/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.flwor;

import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.expr.BinaryExpression;
import net.sf.saxon.expr.Binding;
import net.sf.saxon.expr.CompareToIntegerConstant;
import net.sf.saxon.expr.ComparisonExpression;
import net.sf.saxon.expr.ContextItemExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.FilterExpression;
import net.sf.saxon.expr.FunctionCall;
import net.sf.saxon.expr.GeneralComparison;
import net.sf.saxon.expr.LetExpression;
import net.sf.saxon.expr.RootExpression;
import net.sf.saxon.expr.SimpleExpression;
import net.sf.saxon.expr.SlashExpression;
import net.sf.saxon.expr.ValueComparison;
import net.sf.saxon.expr.VariableReference;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.flwor.Clause;
import net.sf.saxon.expr.flwor.ExpressionProcessor;
import net.sf.saxon.expr.flwor.FLWORExpression;
import net.sf.saxon.expr.flwor.ForClauseOuterPull;
import net.sf.saxon.expr.flwor.ForClauseOuterPush;
import net.sf.saxon.expr.flwor.ForClausePull;
import net.sf.saxon.expr.flwor.ForClausePush;
import net.sf.saxon.expr.flwor.LocalVariableBinding;
import net.sf.saxon.expr.flwor.TuplePull;
import net.sf.saxon.expr.flwor.TuplePush;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.Optimizer;
import net.sf.saxon.expr.parser.PromotionOffer;
import net.sf.saxon.expr.parser.RoleLocator;
import net.sf.saxon.expr.parser.TypeChecker;
import net.sf.saxon.functions.KeyFn;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.SequenceType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ForClause
extends Clause {
    private LocalVariableBinding rangeVariable;
    private LocalVariableBinding positionVariable;
    private Expression sequence;
    private boolean allowsEmpty;

    @Override
    public int getClauseKey() {
        return 0;
    }

    @Override
    public ForClause copy() {
        ForClause f2 = new ForClause();
        f2.setLocationId(this.getLocationId());
        f2.rangeVariable = this.rangeVariable.copy();
        if (this.positionVariable != null) {
            f2.positionVariable = this.positionVariable.copy();
        }
        f2.sequence = this.sequence.copy();
        f2.allowsEmpty = this.allowsEmpty;
        return f2;
    }

    public void setSequence(Expression sequence) {
        this.sequence = sequence;
    }

    public Expression getSequence() {
        return this.sequence;
    }

    public void setRangeVariable(LocalVariableBinding binding) {
        this.rangeVariable = binding;
    }

    public LocalVariableBinding getRangeVariable() {
        return this.rangeVariable;
    }

    public void setPositionVariable(LocalVariableBinding binding) {
        this.positionVariable = binding;
    }

    public LocalVariableBinding getPositionVariable() {
        return this.positionVariable;
    }

    @Override
    public LocalVariableBinding[] getRangeVariables() {
        if (this.positionVariable == null) {
            return new LocalVariableBinding[]{this.rangeVariable};
        }
        return new LocalVariableBinding[]{this.rangeVariable, this.positionVariable};
    }

    public void setAllowingEmpty(boolean option) {
        this.allowsEmpty = option;
    }

    public boolean isAllowingEmpty() {
        return this.allowsEmpty;
    }

    @Override
    public void typeCheck(ExpressionVisitor visitor) throws XPathException {
        SequenceType decl = this.rangeVariable.getRequiredType();
        SequenceType sequenceType = SequenceType.makeSequenceType(decl.getPrimaryType(), 57344);
        RoleLocator role = new RoleLocator(3, this.rangeVariable.getVariableQName(), 0);
        this.sequence = TypeChecker.strictTypeCheck(this.sequence, sequenceType, role, visitor.getStaticContext());
    }

    @Override
    public TuplePull getPullStream(TuplePull base, XPathContext context) {
        if (this.allowsEmpty) {
            return new ForClauseOuterPull(base, this);
        }
        return new ForClausePull(base, this);
    }

    @Override
    public TuplePush getPushStream(TuplePush destination, XPathContext context) {
        if (this.allowsEmpty) {
            return new ForClauseOuterPush(destination, this);
        }
        return new ForClausePush(destination, this);
    }

    public boolean addPredicate(FLWORExpression flwor, ExpressionVisitor visitor, ExpressionVisitor.ContextItemType contextItemType, Expression condition) throws XPathException {
        Binding[] thisVar;
        Expression predicate;
        ItemType selectionContextItemType;
        Optimizer opt = visitor.getConfiguration().obtainOptimizer();
        boolean debug = opt.getConfiguration().isOptimizerTracing();
        TypeHierarchy th = visitor.getConfiguration().getTypeHierarchy();
        Expression head = null;
        Expression selection = this.sequence;
        ItemType itemType = selectionContextItemType = contextItemType == null ? null : contextItemType.itemType;
        if (this.sequence instanceof SlashExpression) {
            if (((SlashExpression)this.sequence).isAbsolute(th)) {
                head = ((SlashExpression)this.sequence).getFirstStep();
                selection = ((SlashExpression)this.sequence).getRemainingSteps();
                selectionContextItemType = head.getItemType(th);
            } else {
                SlashExpression p = ((SlashExpression)this.sequence).tryToMakeAbsolute(th);
                if (p != null) {
                    this.sequence = p;
                    head = ((SlashExpression)this.sequence).getFirstStep();
                    selection = ((SlashExpression)this.sequence).getRemainingSteps();
                    selectionContextItemType = head.getItemType(th);
                }
            }
        }
        boolean changed = false;
        Expression term = condition;
        if (this.positionVariable != null && (term instanceof ValueComparison || term instanceof GeneralComparison || term instanceof CompareToIntegerConstant) && ExpressionTool.dependsOnVariable(term, new Binding[]{this.positionVariable})) {
            ComparisonExpression comp = (ComparisonExpression)((Object)term);
            Expression[] operands = comp.getOperands();
            if (ExpressionTool.dependsOnVariable(flwor, new Binding[]{this.positionVariable})) {
                return false;
            }
            for (int op = 0; op < 2; ++op) {
                Binding[] thisVar2 = new Binding[]{this.getRangeVariable()};
                if (this.positionVariable == null || !(operands[op] instanceof VariableReference) || changed) continue;
                ArrayList<VariableReference> varRefs = new ArrayList<VariableReference>();
                ExpressionTool.gatherVariableReferences(condition, this.positionVariable, varRefs);
                if (varRefs.size() != 1 || varRefs.get(0) != operands[op] || ExpressionTool.dependsOnFocus(operands[1 - op]) || ExpressionTool.dependsOnVariable(operands[1 - op], thisVar2)) continue;
                FunctionCall position = SystemFunction.makeSystemFunction("position", SimpleExpression.NO_ARGUMENTS);
                predicate = term.copy();
                predicate.replaceSubExpression(((BinaryExpression)predicate).getOperands()[op], position);
                if (debug) {
                    opt.trace("Replaced positional variable in predicate by position()");
                }
                selection = new FilterExpression(selection, predicate);
                ExpressionTool.copyLocationInfo(predicate, selection);
                ExpressionVisitor.ContextItemType cit = new ExpressionVisitor.ContextItemType(selectionContextItemType, true);
                selection = visitor.typeCheck(selection, cit);
                if (!ExpressionTool.dependsOnVariable(flwor, new Binding[]{this.positionVariable})) {
                    this.positionVariable = null;
                }
                changed = true;
                break;
            }
        }
        if (this.positionVariable == null && opt.isVariableReplaceableByDot(term, thisVar = new Binding[]{this.getRangeVariable()})) {
            Expression replacement;
            boolean useDotDirectly = opt.isVariableReplaceableByDot(term, thisVar);
            if (useDotDirectly) {
                replacement = new ContextItemExpression();
            } else {
                LetExpression let = new LetExpression();
                let.setVariableQName(new StructuredQName("saxon", "http://saxon.sf.net/", "dot" + this.hashCode()));
                let.setRequiredType(SequenceType.makeSequenceType(contextItemType.itemType, 16384));
                let.setSequence(new ContextItemExpression());
                let.setAction(term);
                term = let;
                replacement = new VariableReference(let);
            }
            PromotionOffer offer = new PromotionOffer(visitor.getConfiguration().obtainOptimizer());
            offer.action = 12;
            offer.bindingList = thisVar;
            offer.containingExpression = replacement;
            Expression newTerm = term.promote(offer, this.sequence);
            if (newTerm != null && offer.accepted) {
                ExpressionVisitor.ContextItemType cit = new ExpressionVisitor.ContextItemType(this.sequence.getItemType(th), true);
                predicate = visitor.typeCheck(newTerm, cit);
                int rel = th.relationship(predicate.getItemType(th), BuiltInAtomicType.INTEGER);
                if (rel != 4) {
                    predicate = SystemFunction.makeSystemFunction("boolean", new Expression[]{predicate});
                    assert (predicate != null);
                }
                selection = new FilterExpression(selection, predicate);
                ExpressionTool.copyLocationInfo(predicate, selection);
                cit = new ExpressionVisitor.ContextItemType(selectionContextItemType, true);
                selection = visitor.typeCheck(selection, cit);
                changed = true;
            }
        }
        if (changed) {
            if (head == null) {
                this.sequence = selection;
            } else if (head instanceof RootExpression && selection instanceof KeyFn) {
                this.sequence = selection;
            } else {
                Expression path = ExpressionTool.makePathExpression(head, selection, false);
                if (!(path instanceof SlashExpression)) {
                    return changed;
                }
                ExpressionTool.copyLocationInfo(condition, path);
                Expression k = visitor.getConfiguration().obtainOptimizer().convertPathExpressionToKey((SlashExpression)path, visitor);
                this.sequence = k == null ? path : k;
                this.sequence = visitor.optimize(visitor.typeCheck(visitor.simplify(this.sequence), contextItemType), contextItemType);
            }
        }
        return changed;
    }

    @Override
    public void processSubExpressions(ExpressionProcessor processor) throws XPathException {
        this.sequence = processor.processExpression(this.sequence);
    }

    public void gatherVariableReferences(List references) {
        if (this.positionVariable != null) {
            ExpressionTool.gatherVariableReferences(this.sequence, this.positionVariable, references);
        }
        ExpressionTool.gatherVariableReferences(this.sequence, this.rangeVariable, references);
    }

    @Override
    public void gatherVariableReferences(ExpressionVisitor visitor, Binding binding, List<VariableReference> references) {
        ExpressionTool.gatherVariableReferences(this.sequence, binding, references);
    }

    @Override
    public void refineVariableType(ExpressionVisitor visitor, List<VariableReference> references, Expression returnExpr) {
        TypeHierarchy th = visitor.getConfiguration().getTypeHierarchy();
        ItemType actualItemType = this.sequence.getItemType(th);
        for (VariableReference ref : references) {
            ref.refineVariableType(actualItemType, this.allowsEmpty ? 24576 : 16384, null, this.sequence.getSpecialProperties(), visitor);
        }
    }

    @Override
    public void explain(ExpressionPresenter out) {
        out.startElement("for");
        out.emitAttribute("var", this.getRangeVariable().getVariableQName().getDisplayName());
        LocalVariableBinding posVar = this.getPositionVariable();
        if (posVar != null) {
            out.emitAttribute("at", posVar.getVariableQName().getDisplayName());
        }
        this.sequence.explain(out);
        out.endElement();
    }

    public String toString() {
        FastStringBuffer fsb = new FastStringBuffer(64);
        fsb.append("for $");
        fsb.append(this.rangeVariable.getVariableQName().getDisplayName());
        fsb.append(' ');
        LocalVariableBinding posVar = this.getPositionVariable();
        if (posVar != null) {
            fsb.append("at $");
            fsb.append(posVar.getVariableQName().getDisplayName());
            fsb.append(' ');
        }
        fsb.append("in ");
        fsb.append(this.sequence.toString());
        return fsb.toString();
    }
}

