use Scalar::String qw(sclstr_downgraded sclstr_upgraded);
use Test::More tests => 401;

BEGIN { use_ok "Authen::DecHpwd", qw(lgi_hpwd UAI_C_PURDY); }

while(<DATA>) {
	my($salt, $username, $password, $hash) = split;
	$username = pack("H*", $username) if $username =~ s/\A\*//;
	$password = pack("H*", $password) if $password =~ s/\A\*//;
	$hash = pack("H*", $hash);
	is lgi_hpwd(sclstr_downgraded($username), sclstr_downgraded($password),
			UAI_C_PURDY, $salt),
		$hash;
	is lgi_hpwd(sclstr_upgraded($username), sclstr_upgraded($password),
			UAI_C_PURDY, $salt),
		$hash;
}

1;

__DATA__
50917 unclasping eviscerate 2173ea3940b990c5
50482 jams daylight 2bb8a232fbc3e299
32451 regurgitation Portsmouth 32afa55e2701240b
37825 Sukarno orthodoxes 43dc30df1e8b1756
23197 cartridge spliced 18ec4c4f4200bf1b
59499 solubles assassinate 4d32bec044939111
58414 upsurge Phoenix ca283c9c87cdd433
59512 Casablanca emasculating 3d48b1a76bac2a72
26962 Yenisei growing 99654fa7406d346d
3755 Avicenna demolishing 8c99f82e714f87ee
10311 instantaneous prized bf9b06436508459f
41216 dreamer punchy 152dbb5aba1c37f1
40670 Barber dowelled 4bbe28dfeb876aed
6353 unlearned eloping 41c3bebf40033458
54771 farm disturbingly e7bfae8ca773a9da
43455 philosophizes paperback 79f6ba0aa558e019
58091 caesareans Banjarmasin 01104cecd35d70d6
41077 plaints conceited 4c05359668752fee
47365 debris drown 749dd3cca2e8fb0c
10135 huffier uniforms 4b17506ff6d3fdc3
23234 replying repatriate e92f02b7840d166b
11450 minimum exampled d5f398a84c235e79
28980 subtitle Edinburgh 258ddb4b5ca5bfd0
10298 sailboats prying b4d68355676365fc
48333 heterosexuals librettists 52be595fe7df0640
54741 esters Annette d0ea41036531b43c
34699 catechism cable ad20518d562c34d7
12678 celebrities patientest b7bd3da75850290e
2480 autistics blockade 4d858b7ef7e4ae09
14234 Azazel uncorrelated 24b4a1f72a8841dc
8583 pretender grows f6219a31895058bd
32132 Cinderellas Everest bf1600d28364e567
43566 traded spectacles ac98ec43215bd993
27717 elate spry 307f785aa90c55c5
33771 declined contumely b792dfdd9f295353
45449 bewildered refed 653b12f15e49973e
48546 orchestra snitch 766b3e2151426ef6
65349 unashamed terror a52e6d43679edacf
10783 squadding perspicacious 952f7ee350fd15ef
23600 croaks righteous 72b7013b685edc7d
24897 sunning budding b48ac99f4f5f6161
11302 fazing pinpricks 1f74f437fd5a296f
59473 confluent enfolded 0c2a6a9c6e5404da
5081 branches speechless e50b6a3d67bac1e2
43679 limpid redwood dcc3be4296bd10db
43103 legislation Acheson 11f965bfd4c50222
57810 candelabra certainest 7fae0fdf20d26895
25919 xenon tonsillitis 883081735692e435
49158 subpoenaed Yellowstone bdd8adf8695d8904
15030 fleeter reconnoiters 2ecef5e8561c4ca0
12828 cerebellums payoffs a94936398c312bf3
30462 independents archers 2a474319d7af3e21
50444 nationalities telltale bcd5b7987b2f0b16
37992 magnetized camper e31a50ed3a355f0f
5249 Piedmont naiads 585ca8aac2fb1301
29915 airways Mexicans 3d786383fbb4ca9b
4014 compelling snorkeled 412c33d896369888
7080 swindlers corporals f0b4ae14e617ba78
61910 build outriders 721f44a234d6ba09
49483 shanties tryouts 4f224ff06f671034
48962 presets firestorms 402674708a7dbd98
24032 clack Theresa 6cc9d24178b08380
49908 Afghans speckles 1c81362f9d344a54
8309 Gila functional 3a4331f579fccdb5
16585 localing innovative d40fcc7b479d78fe
53946 reapportioned spaniel a2028831ef5dabcb
29849 sequined corporations 88e0129d9813f71d
36043 misquote anniversaries 5a332e09f26e1037
58509 studded emulating cfd5e9f0654f50d7
18025 unclasps Minolta d06a815a8ea2af1f
46623 upheld binging 21ba4c1e410f0b2f
62399 decompose sonatas 9f5695a57b629496
61285 packet wan 41e180375f081529
16030 heartaches maturation d3b4e4abc7cf1c50
26741 banquets razed ddc8624e02d74cc7
38398 caulked unassigned 76f73995c28b11aa
53377 demagogs branding d3b5c73fce49fa05
32981 hydraulics fleshier 2e16dafb217c97d6
18206 tourists anyhow 8bbf1a205bc2e3d3
52705 trickiness Poe bd1de4903d9a80e8
63160 rig lactate f15f9bcb8631440d
4129 portability Kayla 88ae53fb9ebfc921
62274 laze dolloped 178f242cce7a00d8
1222 palimony Nanchang 97245ba080badd08
35741 chatters traumatizing 5edcc3c484346d2f
48874 rugging Trujillo db5e24c74129efb2
56315 detoxing contour c2181e40ca8a5739
65215 stridently swamping 8cadcf6b4c376f65
51574 sensor tributes 108c235708572ae5
59724 insurgences swaddled 78515450c5128345
25998 notations skillets 16c12ebe78617044
37111 rain Bridget 318f9bcee17253ea
54267 burdening Salerno ac9672930aeefbb9
16499 Cerf revived 664f851dd8f61b99
24056 stuffy bourgeois 22a9828be0159bbe
4479 stars creak f3d8359b416470b7
3410 mushes westerners bedbf5073d92d030
59737 Chappaquiddick repudiated e5ff41bcf60c1573
29704 ids clomped 0a911a5f08240917
365 mullah drivel 4e710db11447581e
1309 *7c5d15969f7568e89c49c58e00c342da43a7ab883b247051a1a3aa91 *39d833548294a077f4656d93b2206eb4 e4bb6344e73c4310
2644 *a5ce954374c4e698d92d5a493adca9835da2a166ef484050119dda22ff00456ee74b1c8f27d4bb *f418127f4870a887c9106fc6782287a8f863c75b83117d5b7802c9e54aef0606f8492eb7312c 8d4e9007e40389d6
63778 *52ec0f82328a66318e25 *b917c57e46455827e5264061e6 39784b6daa533245
64825 *1f84af8a3310e3fbefef9c *677d4531d1483ff8d697e04b27c46b691dbd1cc5db4e25a920da541d27831b265d5704 2bcc67ba462b888c
4008 *6f56e9f3e10351c24c0b83ce9a9d37696d68fffff1d1dda0630172b7727b9ead324c48 *4866ee9492fe0eacb57f21b6e0e75263679441751874c8c9019af9f010c59f1c056fe6fd923ede 60210dbc58c03ffc
23588 *015cfcf26535 *92 f3a4c04a4d5da5af
19274 *8a39cbd8349fac1e9b712d221c73845d33b983e290bd0a6d8d648409cd45070b16ffb54f *c8f4eb9a92a28443b9dacda925f1b7 2117c115ea8ac651
14053 *9a3376f4bdb7b7e4ed7a2d2d7ac9cc70d9aed15dee6be59cdd *743a23c3beb32a8aefb417a42469300f85e809a5041bcf20ba478712bfdf3e09e1 ee52d1f3fe73e570
2283 *8e7f2ee57118ebbb17583c6474da939f *8744dd2418200045101ab6f91f8bed7216310124388ad1 4d956631d49791a3
7490 *24351ed636f9eaed6ea6a726ce6501f44e1a5cafd092e25a0efe97 *d78488f97628ae748441 2f60ba5d8329f14b
1693 *8e *99c1435884e19ba407c1ae1f2947a91d76 820b2764f4f932bc
61321 *7ad867e760f8d001b7877dce54bc8a99666d73fd11991d09ac5fcb313fcdaedf *5ef0f75f375950e566f6d757e622b19443741db8f72bf7e986e42babc2175b465d134d1493 76b86b713ac1cb38
44456 *fb *a2817784c806e7006677078e0a48dd989cc0 ba70ab71d02777ac
39270 *945b7e9a34810c8bdb401dce909fb608f92f34af2ac9 *dd61d728b60730134e08dedf1ec6959fd207af840b 7cb68d590c0b36fc
25617 *30c4bfd6a992 *887d62e9fd7b8ff6f7afa2c747b71ac521057e3beced0ce29fce7f13f134fa7e0394c3 d3586341614868b8
25362 *87ef1991e36468e84798b9c086adc681813cd46a *39 bbfccad4337d357c
41450 *1f90ac5ca0d77ef58964c543e8 *f7f4ea3fcd802c8df66bb1ea42b4807c 322fc0fb5c975831
62262 *a7fc2db715ff2104dedf89ee * 32975accf82f3671
5735 *f64881709c999604d3ea15fd69d98e8cfa5e72f3d1d1 *c7d86e c65f252ef03bee51
28320 *b7a559b2033a3d097c1025bd92880e6459a2411323 *72c5844ef656 9cd2a2c3842082a9
24597 *edf57a35717fab9421 *36c8cba0a0bda1b7ff1890156e3c3c6a2f7ce0d78f93b1a9e4e7d332 a83d7a7a7a04e40e
50069 *861af199434770e4 *ab2c86ea5e18 cf1e6aaad6daa23b
17152 *02633a819035813235df214b90e84794047a9544c75fad0b2f4e2ffbfea82ff02243930b927bcc *cca6a8b77a36a98867630dcfdd1df2bcbe54110b4a2f96a0dbc93813405f9d6162a10ca5f531b8 ef0d65570fffe313
27302 *8dd87c81e273ade84eb9f596448172b8900a3c12e8df402e421d9d466a7b262337e18f *c201da658943837370519fb8ecdac311df98e2083eb9efb24562e3b03fa5f0590fb20f95dc121a 4c20e60449d1ad14
18241 *7574dc952049108be4a9f68c4c7269797d *33374b2bccb44f01a0c0807ca3c39430e7a9be182d133c0af30d478f80063c672f0a8efbc356d5 897852904358c569
54687 *b743e02b25bb1e69690968b7f0dd211c6a80cd0eebc058ff9e7f3f362aa4a8c39e66 *dd132868486576706e2c6f95429f162abe2eb0d83bd7478c870444522a4c1ffb16 c9ff305055f31dee
27356 *2d509445f251f3408c1af500b7567d8a19d806c1 *a16e513770a3ba9337085e2f33afcc7d94576106a9aeef50ac190e16 3720c6d8793fb8f3
23623 *539c7aa99a3c63c41b423a02e3da617dd3672a98250bc71627fd7d *d26eb59a1370a55a369df40f62c1499f177ef38df2d2ff387d736b3a95f7156664 495e7dd95919f26b
40851 *cb3fd90c0bc545d776af70eac7bd96 *8883c4e7eb 2309bf41b03518f6
566 *c2729de86ca2b2c77d0c48e51f60e79d394b70ec5ea94aaa7796a10985402eb5 *a9e0678237db62bfb6920a6cd8adcc620a9c6a67858aa540a1 41a16a7b4ea5b850
63818 *9a32036bf4afff24fcd600661f817485c2 * 8c8c621458484e8b
49387 *68be012990bb2c0229478eace809f64417c462c0d752cefda5 *af89831b6dfc1679af ea7d3661d2f44f2f
13315 *c9f785ea92f01d424ed69cb03648699cab6c21dac680 *b525c1faf2dbb8719d1b3516f1d6c2cc98ab69541a258649 187c429f9929b2c5
30206 *39 *49cd11d5fc6a2bdc68d3584a0e92cb78315bbe562a3cbab2 fc7a4f70eaaf9f01
45942 *23 *5c51e2d3 1306c0e4e85abc02
22736 *ccc7d845466d61be9a5971e0a55de0b5b16e87ba121c6f44 *906bdcf51b6112dc1c05d5e6bb e77edf5580a2ac81
62601 *33ddeda859 *3c68d76cb96b1738a948d8d60da98769f426b6d50f86ec 9b711c2645b960a0
37938 *7e2d0b94b312ce476bd61331f810f5956bab1baeed13ac0d069ab8b56406e3 *bad377af15de12127d bac8799da9af28bf
16581 *ac312bee0d3fd8814be16489a4931313be *05aa3f9fe0c399e14470f1f64887b51fa38f9f 609c12cb12ad34db
15653 *0ce145500eae256a2c20ecbdbdf52b2a6b80e5737a670bb3d0839650910f9f1d20 *4c3ee52ebf1cd46848f77888f368b36c54b58742003b1047dd39656f07b42b680b1284b09dfa 06841347360ce834
6277 *c6893f277f8f0ca84913a1d4c3b8a63993c472ead14e73c093b2 *aad25c24c5fc679cf33ffaa1fbff3915bda977ecf0b3a76f28195f 267698d5631fb5f0
7054 *407c804963b77c73f95fffc3a8062b56d923be0dd076a8667aebee294794d7 *715bda23f39964359bc0 b74bfce3d701cc95
32870 *01f8df4d727b639bf4907cf0f1 *027d1ca4daf80d35461799f00972563b19b3689e1166a0121a9f0e0743bd0462 70bd0126f9e7b7d5
56693 *842eaa9d85c6 *2d212d440015d1b9d95b7a8a153262dd5d80efcc 9ab087d8236964e0
59726 *5e222dfa41 *91d25df8b529b0eefc2fd0f018dfed8589daba765b6f1f7d49e586c5b6c64719c1 f27743bce0dbde49
38241 *e824d32fc615838ef51c4bc1aab3e325c649 *1c48cc9f476bd4874c229b110918bf939cd12bdf8da839a5d739b9e94b665badc8c8f0fabf1b bfb7f11ff1e82e70
18013 *5e *59522949fd17ef13aff50af1532f946a134deb919c b95b08449eb07570
44143 *891ce9077a607e28ac9adca4993b8c23ff5be604258ee674201bd6a498796ed3 *7cfa0088 f07d66df8b630c27
12822 *5ef8f765865e31a533b41670743fc83aabfa27f1e6159c23 *06d4d7161bff2d6fc498a9efbe5ce08b1e6c89470384d8bddfee 7a73017b21cd63eb
46758 *2dfcc3407bb658781dfcae9cbad6d89aa722c2 *0cdf55318582c20eef938ed223b0ba5c6e41 10e0f16f3cbf258d
10214 *04d03a53ef7cffff48 *f842595d d3142bf3d89080bb
28171 *5028f20bfbb87c *bf9606cea79b8e3df637b35d7f12e9e3 c6b929f9d913ca91
15346 *5f97f438c482cd73c50845e132ced839f46f6c2bc10619fe660fe5f8e612e59112163d07 *4ec58241e1ca3e80af25b65486e3746e8811acb3820f89958cb12c59f14e1dd02881b057c43e adc38a6c38a1d511
53284 *39831a78c784063dd836b76ba5008f41 *e6cb8a2354674c53caef1a7afaca2c 77ef3a47c1131f53
15557 *38dd2066f930eb5d9de73a7e3a1ccfe2266eeabdfb46df74c248e240a7469d26 *7722c0bfde0a4b899062b0 b1aa9e84824d3924
26467 *6640456d6682921d20edafd0959f69 *703856c1e2cf746cdbf324df bae3252a1aae2375
18831 *5c6cc0f0595b0936da9eae *de0c27052f7fceaa2ce94b5be3953370d6b3922c3d69bc98a4dba58b d0a2aafb636997ff
17507 *08a87475a5d017645a8d8e5d6f5c71ef1524ef05c508d953bf9433b97ef2 *1e663a22b77d8d3a1afaf2fe7c7f3c603befe445fa0136be65543a161a69a4dfe0483b26 fa288d80ce8a2409
9052 *0f11784ed432ff6133f146 *76a8125c0f011f78af6a1253d9179fc37942bbb7024f10543dcadbdd77a5ad40f5cd1a8f7b 03a8ccca939e5b3e
14899 *24ec2cb26dee05334b1ae7299487f3abd6f0a06e26fc679845ebf9e9276102624dff7ed6d929a5 *e36834b238c392a1a40f780df3fa0e7ad1888f7a9d651829f5d3f3dcc08b872bd3b3fa1023 ee35844fee17a057
60053 * *a3023b5e194a59fd738651cc7d0d6ec0dfa6226da7 b216b37d601fccab
22976 *3ca18b18899b494cb435adeb59627fe5a3877cce4b61860512d9c9067c73a42d2d3c7ae5 *fa898d4b150018579aa0ad7d e794fd633f86b621
54496 *7de90322ef4eb737b35866c11aa1838c963ec143f607 *294b acf95eb8b2848774
52965 *25ffe151457ef83a7ce8f7118fa8b3ad2ccdb1ac *7e37d5fa79ca678951e54f1d30384cc2b954f50bd37c11 499e70ab0da02882
33116 *0f2492016ce746fb299fb026edbc *36c67ec91ce160605a2f0ecb859479d13adea777a46b3c31 e5a4179f16c28db5
52698 *8eed6a1c5b1677767ba5a05e369e6794af6487c5a1ac67269bc3 *6fe97359fe6a0da4bcea8d ce53456980584652
34485 *4b745f538b *0dd33c806f0059a0c99b12016712855fe74b2535cf9c96e693ee b5bf11a039bb2f22
18911 *b002322c7428088dacf4b2b5429c74f2dcbbb476532c1c4b3ff2 *684363a440ffa019ba4f07574edcf3 774f1188ad741c1a
62230 *18df730441280bfa37d5cb00d6b584822849f7fc76ac16e10d4aca571f *981495f01747dc76b242962cb67de72b5b680613f21c25897642f91e7b08de87ff6084 f2c1efa3187807a4
7776 *69d695a0e1b2df4e022204 *302a916653e763b4e9cd08 4c694080f6ab4a97
10162 *e5228563fc247919 * a7e04a5d5ebd9e4c
27782 *2651fa304fbd8a3d1d7d51d2cbe16a *d46040ed2bdedebfc16b0e66f5c29f7c8ac6e90d1a5ae5fc4210b80e917ef1aa34 d812275979debdc5
58763 *81b580 *f79a6c07760f2e231a30a4a0b61263b461e35d91666f3a544da3ec62f2845d1c08 53c8e2e84c49323a
19530 *add4d92f2beaa0319d437d06c19784904adcb6adccfe97def2c11ca80d1f6ade5989d78b *114768d7144cf59fb6 e353825dcbe0287c
56592 *e8bbb3bd29c387ff2337bbeec8705715b6f3 *f6aa600e77fe99b846dd977eef6a0bf1172deb5b76c6 f2f6405b0abbd072
43466 *81191387b4da8895 *63196f0c3dad77f9ae0bf92a5410ee258df74c1e3203d5829adc01c4db085f1d01db0a 11b20c40b51509d4
1553 *f99f7bb19eab125574b7c525 *a1623c4a5368fb1a922057 84d510a3bbd41f7d
23802 *86e5994768b64d557faee7f9e5271316225367074ebb04a9ab07 *4f2057e6d90cb73453381e80b6c13ac579609e725bc351 63d529e5f950ede3
19605 *8acb008de1d5fbf4250a15337d0914fae5d1b898 *f150b5f67972880c5f1acc365056474da8f2151bd9c928b9092e03e87e2390e856d2eb cc2017090b2a173c
23265 *c3c5dfd37c72545f099c518bc9a3936288a586fecc17449861ec2dcc5b19 *886f9dd491628ca77e56e0e2d31106a4745a284eef63346f13205f16667dbdb86d1887 4cb1b281f2374d17
12048 *3b2dcfdac267dca916aaccab4f67b2929547a4cca9c81dac927485f3059001b6a63dbfbe5e *49d7298fd23847 a5fdd6c416d41d96
55316 *4f3217a4 *949bebdf86945c541f36f8d213d8ecb7aa4c178eeee5d570 c4aa20834c4bbc83
45626 *4c6778fd9519cce964c143d3 *85ae11168d33005c1e646e6db5a69392d76f03bdaa 88002731ab235121
27480 *5faac851a5a98807b5245d148a9a0b3ca9cef083f0 *538e81521f243409a220d6fab162c6451572a1157a289d78 3259ba099e077af9
55366 *973b36254412ee469ec646fbca091cf1fd9daf0ca281923f55e39a *2e875b62b13509526e1d32cacd49b81296dc237fb6 c0f8a0d6d17f2799
43807 *bfab37ce52940dc483069b1ec45a0d1254df4a595c2df133ad0b00229f *c6658d06ccec 5d15affcf73f933b
51967 *ff233a3f6b3cb585999733788c4f31942b *7a4de9865f1af6facfaf7830107a0446e83b8c66af1cc104d2ad0e26c3dc5b f1872faa016b6dd2
57373 *39ba99dffb70bbc93e12522f6a2d5b42 * 8bc54595e5a214d9
31665 *7bba2c155ac59470fe39d02ad88ef611c9c32ced62f64c9e2d90 *830925e2f3e9 ab9968b8591338a4
30781 *43afdf60d4f7a31f03489d29a69f58517bf2914eaa1081d20a4efc4bc4bbb89272419507 *6bd448a0bec921cee8f171a796d1bcee1694296534253020cc3f4d835220 2474bbe23bb94f8d
50480 *bbb941b0a35c9c29f0ed6ee24d2efb28a4e8b58b3f6c6dcccb558a1c07 *cf4a131ac0cc4acb063088f2c891961d3b0882b647e5436e741317de d05ed024c3c22753
32392 *556d187a7a698585de9a300151fd28df2d6c7fee3c421c43ea *da38f662c3798863aa5952a0bde5bdb412054e422eb9170d08240cda3d40013f8bcba414291fd6 da3b2b0449a58731
44001 *f12efacf73213f9615155f *0542418b3e21c0495de8339aa0807490b83d63d8d01d3d2e78e71eaf85192a94633b579188 602e637cbc5af65d
20767 *c09f94082dfa82592499c354051f02a0aa2157783169ce61a7c95cbfc4ce9595eeea92451577 *d4e8b12e7784b3a32ef2498a53f9854d 7d33784638bd7d2f
45816 *8b9b255a04a950a58c23 *e003f14b5aae14161c271d1368c2b7e9c10c0ce65872f5 1aafeb8549ce9f19
40573 *36ec723856946821242e33f0 *4db844e97166 f1a8c96e79a39433
62064 *b7e7ebbe01d95dc144b94aa186ef1f89efcb19f7184e7210cf4f94f6144133b6c73e1138a9f6f8 *7fbd7e67a04131ab0e75f00c56c4c5570f132096402498f300dfd12f85b2 da1d029a0a65e35d
19479 *3945dd7c00f94db5d75ebb1d94e45cd0da *3ce7d5ce8134f1949da3e51a0ca55435550c 63138ddac7d37b58
56282 *99f450ef73aa38fb49ad74e49f0476b8566ac561e6664d2906528a64 *413422ea581df62334f0a2e8558c0c74fc887698a6dacb 34f83f6ee3def29a
6822 *cd9615d919ce8dd5 *9686bce6cc80 4d6d436d4732ea2b
