use strict;
use warnings;
use inc::Module::Install;


# See lib/ExtUtils/MakeMaker.pm for details of how to influence
# the contents of the Makefile that is written.
WriteMakefile(
    NAME		=> 'WWW::Selenium::Utils',
    VERSION_FROM	=> 'lib/WWW/Selenium/Utils.pm', # finds $VERSION
    PREREQ_PM		=> {}, 
    ABSTRACT            => 'Handy utilities for working with Selenium',
    AUTHOR              => 'Luke Closs <cpan@5thplane.com>',
    EXE_FILES           => [ qw(bin/selenium-regen) ],
    clean               => { FILES => 't/foo.conf t/tests t/index.html t/etc '
                                      . 'lib/WWW/Selenium/Utils/Actions.pm'
                           }, 
);

# Module::Install Stuff
{
    license ('perl');
    # Needed to activate PAR functionality.  
    par_base('LUKEC');
}

# auto-generate WWW::Selenium::Utils::Actions
my $actfile = "lib/WWW/Selenium/Utils/Actions.pm";
unlink $actfile if -e $actfile;
open(my $ofh, ">$actfile") or die "Can't open $actfile: $!";
print $ofh <<EOT;
package WWW::Selenium::Utils::Actions;
use strict;
use warnings;
use base 'Exporter';
our \@EXPORT_OK = qw(\%selenium_actions);

# Do not edit this file - it is auto-generated from the Selenium sources

# key is function name (without assert/verify)
# value is number of arguments
our \%selenium_actions = (
EOT

my $selapi = "website/selenium/selenium-api.js";
open(my $ifh, $selapi) or die "Can't open $selapi: $!";
while(<$ifh>) {
    next unless /^Selenium\.prototype\.do(\w+)\s*=\s*function\(([^\)]*)\)/;
    my ($basefunc, $args) = (lc($1), $2);
    my @args = split /,\s*/, $args;
    my $numargs = @args;
    print $ofh "    $basefunc => $numargs,\n";
}
close $ifh or die "Can't close $: $!";

print $ofh ");\n1;\n";
close $ofh or die "Can't write $selapi: $!";
