/*
 * Decompiled with CFR 0.152.
 */
package com.wutka.dtd;

import com.wutka.dtd.DTDDecl;
import com.wutka.dtd.DTDEnumeration;
import com.wutka.dtd.DTDNotationList;
import com.wutka.dtd.DTDOutput;
import java.io.IOException;
import java.io.PrintWriter;

public class DTDAttribute
implements DTDOutput {
    public String name;
    public Object type;
    public DTDDecl decl;
    public String defaultValue;

    public DTDAttribute() {
    }

    public DTDAttribute(String aName) {
        this.name = aName;
    }

    public void write(PrintWriter out) throws IOException {
        out.print(this.name + " ");
        if (this.type instanceof String) {
            out.print(this.type);
        } else if (this.type instanceof DTDEnumeration) {
            DTDEnumeration dtdEnum = (DTDEnumeration)this.type;
            dtdEnum.write(out);
        } else if (this.type instanceof DTDNotationList) {
            DTDNotationList dtdnl = (DTDNotationList)this.type;
            dtdnl.write(out);
        }
        if (this.decl != null) {
            this.decl.write(out);
        }
        if (this.defaultValue != null) {
            out.print(" \"");
            out.print(this.defaultValue);
            out.print("\"");
        }
    }

    public boolean equals(Object ob) {
        if (ob == this) {
            return true;
        }
        if (!(ob instanceof DTDAttribute)) {
            return false;
        }
        DTDAttribute other = (DTDAttribute)ob;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.type == null ? other.type != null : !this.type.equals(other.type)) {
            return false;
        }
        if (this.decl == null ? other.decl != null : !this.decl.equals(other.decl)) {
            return false;
        }
        return !(this.defaultValue == null ? other.defaultValue != null : !this.defaultValue.equals(other.defaultValue));
    }

    public void setName(String aName) {
        this.name = aName;
    }

    public String getName() {
        return this.name;
    }

    public void setType(Object aType) {
        if (!(aType instanceof String || aType instanceof DTDEnumeration || aType instanceof DTDNotationList)) {
            throw new IllegalArgumentException("Must be String, DTDEnumeration or DTDNotationList");
        }
        this.type = aType;
    }

    public Object getType() {
        return this.type;
    }

    public void setDecl(DTDDecl aDecl) {
        this.decl = aDecl;
    }

    public DTDDecl getDecl() {
        return this.decl;
    }

    public void setDefaultValue(String aDefaultValue) {
        this.defaultValue = aDefaultValue;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }
}

