package File::Spec::Unix;
use strict;
use Cwd;
sub canonpath{my($self,$path)=@_;
$path=~s|/+|/|g unless($^O eq 'cygwin');
$path=~s|(/\.)+/|/|g;
$path=~s|^(\./)+||s unless$path eq"./";
$path=~s|^/(\.\./)+|/|s;
$path=~s|/\z|| unless$path eq"/";
return$path;}sub catdir{my$self=shift;
my@args=@_;
foreach(@args){$_.="/" if$_ eq ''||substr($_,-1)ne"/";}return$self->canonpath(join('',@args));}sub catfile{my$self=shift;
my$file=pop@_;
return$file unless@_;
my$dir=$self->catdir(@_);
$dir.="/" unless substr($dir,-1)eq"/";
return$dir.$file;}sub curdir{return".";}sub devnull{return"/dev/null";}sub rootdir{return"/";}my$tmpdir;
sub tmpdir{return$tmpdir if defined$tmpdir;
foreach($ENV{TMPDIR},"/tmp"){next unless defined&&-d&&-w _;
$tmpdir=$_;
last;}$tmpdir='' unless defined$tmpdir;
return$tmpdir;}sub updir{return"..";}sub no_upwards{my$self=shift;
return grep(!/^\.{1,2}\z/s,@_);}sub case_tolerant{return 0;}sub file_name_is_absolute{my($self,$file)=@_;
return scalar($file=~m:^/:s);}sub path{my@path=split(':',$ENV{PATH});
foreach(@path){$_='.' if$_ eq ''}return@path;}sub join{my$self=shift;
return$self->catfile(@_);}sub splitpath{my($self,$path,$nofile)=@_;
my($volume,$directory,$file)=('','','');
if($nofile){$directory=$path;}else{$path=~m|^ ( (?: .* / (?: \.\.?\z )? )? ) ([^/]*) |xs;
$directory=$1;
$file=$2;}return($volume,$directory,$file);}sub splitdir{my($self,$directories)=@_;
if($directories!~m|/\z|){return split(m|/|,$directories);}else{my(@directories)=split(m|/|,"${directories}dummy");
$directories[$#directories]='';
return@directories;}}sub catpath{my($self,$volume,$directory,$file)=@_;
if($directory ne ''&&$file ne ''&&substr($directory,-1)ne '/'&&substr($file,0,1)ne '/'){$directory.="/$file";}else{$directory.=$file;}return$directory;}sub abs2rel{my($self,$path,$base)=@_;
if(!$self->file_name_is_absolute($path)){$path=$self->rel2abs($path);}else{$path=$self->canonpath($path);}if(!defined($base)||$base eq ''){$base=cwd();}elsif(!$self->file_name_is_absolute($base)){$base=$self->rel2abs($base);}else{$base=$self->canonpath($base);}my@pathchunks=$self->splitdir($path);
my@basechunks=$self->splitdir($base);
while(@pathchunks&&@basechunks&&$pathchunks[0]eq$basechunks[0]){shift@pathchunks;
shift@basechunks;}$path=CORE::join('/',@pathchunks);
$base=CORE::join('/',@basechunks);
$base=~s|[^/]+|..|g;
if($path ne ''&&$base ne ''){$path="$base/$path";}else{$path="$base$path";}return$self->canonpath($path);}sub rel2abs($;$;){my($self,$path,$base)=@_;
if(!$self->file_name_is_absolute($path)){if(!defined($base)||$base eq ''){$base=cwd();}elsif(!$self->file_name_is_absolute($base)){$base=$self->rel2abs($base);}else{$base=$self->canonpath($base);}$path=$self->catdir($base,$path);}return$self->canonpath($path);}1;
