# Generated by default/object.tt
package Paws::Appflow::DestinationConnectorProperties;
  use Moose;
  has CustomerProfiles => (is => 'ro', isa => 'Paws::Appflow::CustomerProfilesDestinationProperties');
  has EventBridge => (is => 'ro', isa => 'Paws::Appflow::EventBridgeDestinationProperties');
  has Honeycode => (is => 'ro', isa => 'Paws::Appflow::HoneycodeDestinationProperties');
  has LookoutMetrics => (is => 'ro', isa => 'Paws::Appflow::LookoutMetricsDestinationProperties');
  has Redshift => (is => 'ro', isa => 'Paws::Appflow::RedshiftDestinationProperties');
  has S3 => (is => 'ro', isa => 'Paws::Appflow::S3DestinationProperties');
  has Salesforce => (is => 'ro', isa => 'Paws::Appflow::SalesforceDestinationProperties');
  has Snowflake => (is => 'ro', isa => 'Paws::Appflow::SnowflakeDestinationProperties');
  has Upsolver => (is => 'ro', isa => 'Paws::Appflow::UpsolverDestinationProperties');
  has Zendesk => (is => 'ro', isa => 'Paws::Appflow::ZendeskDestinationProperties');

1;

### main pod documentation begin ###

=head1 NAME

Paws::Appflow::DestinationConnectorProperties

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Appflow::DestinationConnectorProperties object:

  $service_obj->Method(Att1 => { CustomerProfiles => $value, ..., Zendesk => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Appflow::DestinationConnectorProperties object:

  $result = $service_obj->Method(...);
  $result->Att1->CustomerProfiles

=head1 DESCRIPTION

This stores the information that is required to query a particular
connector.

=head1 ATTRIBUTES


=head2 CustomerProfiles => L<Paws::Appflow::CustomerProfilesDestinationProperties>

The properties required to query Amazon Connect Customer Profiles.


=head2 EventBridge => L<Paws::Appflow::EventBridgeDestinationProperties>

The properties required to query Amazon EventBridge.


=head2 Honeycode => L<Paws::Appflow::HoneycodeDestinationProperties>

The properties required to query Amazon Honeycode.


=head2 LookoutMetrics => L<Paws::Appflow::LookoutMetricsDestinationProperties>

The properties required to query Amazon Lookout for Metrics.


=head2 Redshift => L<Paws::Appflow::RedshiftDestinationProperties>

The properties required to query Amazon Redshift.


=head2 S3 => L<Paws::Appflow::S3DestinationProperties>

The properties required to query Amazon S3.


=head2 Salesforce => L<Paws::Appflow::SalesforceDestinationProperties>

The properties required to query Salesforce.


=head2 Snowflake => L<Paws::Appflow::SnowflakeDestinationProperties>

The properties required to query Snowflake.


=head2 Upsolver => L<Paws::Appflow::UpsolverDestinationProperties>

The properties required to query Upsolver.


=head2 Zendesk => L<Paws::Appflow::ZendeskDestinationProperties>

The properties required to query Zendesk.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Appflow>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

