
package Paws::EBS::StartSnapshot;
  use Moose;
  has ClientToken => (is => 'ro', isa => 'Str');
  has Description => (is => 'ro', isa => 'Str');
  has Encrypted => (is => 'ro', isa => 'Bool');
  has KmsKeyArn => (is => 'ro', isa => 'Str');
  has ParentSnapshotId => (is => 'ro', isa => 'Str');
  has Tags => (is => 'ro', isa => 'ArrayRef[Paws::EBS::Tag]');
  has Timeout => (is => 'ro', isa => 'Int');
  has VolumeSize => (is => 'ro', isa => 'Int', required => 1);

  use MooseX::ClassAttribute;

  class_has _api_call => (isa => 'Str', is => 'ro', default => 'StartSnapshot');
  class_has _api_uri  => (isa => 'Str', is => 'ro', default => '/snapshots');
  class_has _api_method  => (isa => 'Str', is => 'ro', default => 'POST');
  class_has _returns => (isa => 'Str', is => 'ro', default => 'Paws::EBS::StartSnapshotResponse');
1;

### main pod documentation begin ###

=head1 NAME

Paws::EBS::StartSnapshot - Arguments for method StartSnapshot on L<Paws::EBS>

=head1 DESCRIPTION

This class represents the parameters used for calling the method StartSnapshot on the
L<Amazon Elastic Block Store|Paws::EBS> service. Use the attributes of this class
as arguments to method StartSnapshot.

You shouldn't make instances of this class. Each attribute should be used as a named argument in the call to StartSnapshot.

=head1 SYNOPSIS

    my $ebs = Paws->service('EBS');
    my $StartSnapshotResponse = $ebs->StartSnapshot(
      VolumeSize       => 1,
      ClientToken      => 'MyIdempotencyToken',    # OPTIONAL
      Description      => 'MyDescription',         # OPTIONAL
      Encrypted        => 1,                       # OPTIONAL
      KmsKeyArn        => 'MyKmsKeyArn',           # OPTIONAL
      ParentSnapshotId => 'MySnapshotId',          # OPTIONAL
      Tags             => [
        {
          Key   => 'MyTagKey',      # max: 127; OPTIONAL
          Value => 'MyTagValue',    # max: 255; OPTIONAL
        },
        ...
      ],    # OPTIONAL
      Timeout => 1,    # OPTIONAL
    );

    # Results:
    my $BlockSize        = $StartSnapshotResponse->BlockSize;
    my $Description      = $StartSnapshotResponse->Description;
    my $KmsKeyArn        = $StartSnapshotResponse->KmsKeyArn;
    my $OwnerId          = $StartSnapshotResponse->OwnerId;
    my $ParentSnapshotId = $StartSnapshotResponse->ParentSnapshotId;
    my $SnapshotId       = $StartSnapshotResponse->SnapshotId;
    my $StartTime        = $StartSnapshotResponse->StartTime;
    my $Status           = $StartSnapshotResponse->Status;
    my $Tags             = $StartSnapshotResponse->Tags;
    my $VolumeSize       = $StartSnapshotResponse->VolumeSize;

    # Returns a L<Paws::EBS::StartSnapshotResponse> object.

Values for attributes that are native types (Int, String, Float, etc) can passed as-is (scalar values). Values for complex Types (objects) can be passed as a HashRef. The keys and values of the hashref will be used to instance the underlying object.
For the AWS API documentation, see L<https://docs.aws.amazon.com/goto/WebAPI/ebs/StartSnapshot>

=head1 ATTRIBUTES


=head2 ClientToken => Str

A unique, case-sensitive identifier that you provide to ensure the
idempotency of the request. Idempotency ensures that an API request
completes only once. With an idempotent request, if the original
request completes successfully. The subsequent retries with the same
client token return the result from the original successful request and
they have no additional effect.

If you do not specify a client token, one is automatically generated by
the AWS SDK.

For more information, see Idempotency for StartSnapshot API
(https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-direct-api-idempotency.html)
in the I<Amazon Elastic Compute Cloud User Guide>.



=head2 Description => Str

A description for the snapshot.



=head2 Encrypted => Bool

Indicates whether to encrypt the snapshot. To create an encrypted
snapshot, specify C<true>. To create an unencrypted snapshot, omit this
parameter.

If you specify a value for B<ParentSnapshotId>, omit this parameter.

If you specify C<true>, the snapshot is encrypted using the CMK
specified using the B<KmsKeyArn> parameter. If no value is specified
for B<KmsKeyArn>, the default CMK for your account is used. If no
default CMK has been specified for your account, the AWS managed CMK is
used. To set a default CMK for your account, use
ModifyEbsDefaultKmsKeyId
(https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyEbsDefaultKmsKeyId.html).

If your account is enabled for encryption by default, you cannot set
this parameter to C<false>. In this case, you can omit this parameter.

For more information, see Using encryption
(https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-accessing-snapshot.html#ebsapis-using-encryption)
in the I<Amazon Elastic Compute Cloud User Guide>.



=head2 KmsKeyArn => Str

The Amazon Resource Name (ARN) of the AWS Key Management Service (AWS
KMS) customer master key (CMK) to be used to encrypt the snapshot. If
you do not specify a CMK, the default AWS managed CMK is used.

If you specify a B<ParentSnapshotId>, omit this parameter; the snapshot
will be encrypted using the same CMK that was used to encrypt the
parent snapshot.

If B<Encrypted> is set to C<true>, you must specify a CMK ARN.



=head2 ParentSnapshotId => Str

The ID of the parent snapshot. If there is no parent snapshot, or if
you are creating the first snapshot for an on-premises volume, omit
this parameter.

If your account is enabled for encryption by default, you cannot use an
unencrypted snapshot as a parent snapshot. You must first create an
encrypted copy of the parent snapshot using CopySnapshot
(https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CopySnapshot.html).



=head2 Tags => ArrayRef[L<Paws::EBS::Tag>]

The tags to apply to the snapshot.



=head2 Timeout => Int

The amount of time (in minutes) after which the snapshot is
automatically cancelled if:

=over

=item *

No blocks are written to the snapshot.

=item *

The snapshot is not completed after writing the last block of data.

=back

If no value is specified, the timeout defaults to C<60> minutes.



=head2 B<REQUIRED> VolumeSize => Int

The size of the volume, in GiB. The maximum size is C<16384> GiB (16
TiB).




=head1 SEE ALSO

This class forms part of L<Paws>, documenting arguments for method StartSnapshot in L<Paws::EBS>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

