# Generated by default/object.tt
package Paws::IoTWireless::WirelessGatewayLogOption;
  use Moose;
  has Events => (is => 'ro', isa => 'ArrayRef[Paws::IoTWireless::WirelessGatewayEventLogOption]');
  has LogLevel => (is => 'ro', isa => 'Str', required => 1);
  has Type => (is => 'ro', isa => 'Str', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::IoTWireless::WirelessGatewayLogOption

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::IoTWireless::WirelessGatewayLogOption object:

  $service_obj->Method(Att1 => { Events => $value, ..., Type => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::IoTWireless::WirelessGatewayLogOption object:

  $result = $service_obj->Method(...);
  $result->Att1->Events

=head1 DESCRIPTION

The log option for wireless gateways. Can be used to set log level for
a specific type of wireless gateway.

=head1 ATTRIBUTES


=head2 Events => ArrayRef[L<Paws::IoTWireless::WirelessGatewayEventLogOption>]




=head2 B<REQUIRED> LogLevel => Str




=head2 B<REQUIRED> Type => Str





=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::IoTWireless>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

