# Generated by default/object.tt
package Paws::SSMIncidents::TimelineEvent;
  use Moose;
  has EventData => (is => 'ro', isa => 'Str', request_name => 'eventData', traits => ['NameInRequest'], required => 1);
  has EventId => (is => 'ro', isa => 'Str', request_name => 'eventId', traits => ['NameInRequest'], required => 1);
  has EventTime => (is => 'ro', isa => 'Str', request_name => 'eventTime', traits => ['NameInRequest'], required => 1);
  has EventType => (is => 'ro', isa => 'Str', request_name => 'eventType', traits => ['NameInRequest'], required => 1);
  has EventUpdatedTime => (is => 'ro', isa => 'Str', request_name => 'eventUpdatedTime', traits => ['NameInRequest'], required => 1);
  has IncidentRecordArn => (is => 'ro', isa => 'Str', request_name => 'incidentRecordArn', traits => ['NameInRequest'], required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::SSMIncidents::TimelineEvent

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SSMIncidents::TimelineEvent object:

  $service_obj->Method(Att1 => { EventData => $value, ..., IncidentRecordArn => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SSMIncidents::TimelineEvent object:

  $result = $service_obj->Method(...);
  $result->Att1->EventData

=head1 DESCRIPTION

A significant event that happened during the incident.

=head1 ATTRIBUTES


=head2 B<REQUIRED> EventData => Str

A short description of the event.


=head2 B<REQUIRED> EventId => Str

The ID of the timeline event.


=head2 B<REQUIRED> EventTime => Str

The time that the event occurred.


=head2 B<REQUIRED> EventType => Str

The type of event that occurred. Currently Incident Manager supports
only the C<Custom Event> type.


=head2 B<REQUIRED> EventUpdatedTime => Str

The time that the timeline event was last updated.


=head2 B<REQUIRED> IncidentRecordArn => Str

The Amazon Resource Name (ARN) of the incident that the event occurred
during.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SSMIncidents>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

