# Generated by default/object.tt
package Paws::SecurityHub::AwsElbLoadBalancerHealthCheck;
  use Moose;
  has HealthyThreshold => (is => 'ro', isa => 'Int');
  has Interval => (is => 'ro', isa => 'Int');
  has Target => (is => 'ro', isa => 'Str');
  has Timeout => (is => 'ro', isa => 'Int');
  has UnhealthyThreshold => (is => 'ro', isa => 'Int');

1;

### main pod documentation begin ###

=head1 NAME

Paws::SecurityHub::AwsElbLoadBalancerHealthCheck

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SecurityHub::AwsElbLoadBalancerHealthCheck object:

  $service_obj->Method(Att1 => { HealthyThreshold => $value, ..., UnhealthyThreshold => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SecurityHub::AwsElbLoadBalancerHealthCheck object:

  $result = $service_obj->Method(...);
  $result->Att1->HealthyThreshold

=head1 DESCRIPTION

Contains information about the health checks that are conducted on the
load balancer.

=head1 ATTRIBUTES


=head2 HealthyThreshold => Int

The number of consecutive health check successes required before the
instance is moved to the Healthy state.


=head2 Interval => Int

The approximate interval, in seconds, between health checks of an
individual instance.


=head2 Target => Str

The instance that is being checked. The target specifies the protocol
and port. The available protocols are TCP, SSL, HTTP, and HTTPS. The
range of valid ports is 1 through 65535.

For the HTTP and HTTPS protocols, the target also specifies the ping
path.

For the TCP protocol, the target is specified as C<TCP:
I<E<lt>portE<gt>> >.

For the SSL protocol, the target is specified as
C<SSL.I<E<lt>portE<gt>> >.

For the HTTP and HTTPS protocols, the target is specified as C<
I<E<lt>protocolE<gt>>:I<E<lt>portE<gt>>/I<E<lt>path to pingE<gt>> >.


=head2 Timeout => Int

The amount of time, in seconds, during which no response means a failed
health check.


=head2 UnhealthyThreshold => Int

The number of consecutive health check failures that must occur before
the instance is moved to the Unhealthy state.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SecurityHub>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

