use strict;
use warnings FATAL => 'all';

use Test::Requires { 'Dist::Zilla::Plugin::ModuleBuildTiny::Fallback' => '0.006' };

use Path::Tiny;
my $code = path('t', '01-basic.t')->slurp_utf8;

if (
    eval { Dist::Zilla::Plugin::ModuleBuildTiny->VERSION('0.008'); 1 }
        and
    eval { Dist::Zilla::Plugin::ModuleBuildTiny::Fallback->VERSION('0.010'); 1 })
{
    $code =~ m/^my \$pattern = <<PATTERN;\n/gm;
    my $start = pos($code);

    $code =~ m/(?=^PATTERN)/mg;
    my $end = pos($code);

    my $mbt_version = Dist::Zilla::Plugin::ModuleBuildTiny->VERSION;
    $code = substr($code, 0, $start)
        . "    # This section for DZT-Sample was generated by Dist::Zilla::Plugin::ModuleBuildTiny $mbt_version.\n"
        . do {
            my $inserted_code_re = substr($code, $start, $end - $start);
            $inserted_code_re =~ s/^(?!$)/    /gm;
            $inserted_code_re;
        }
        . substr($code, $end);
}

$code =~ s/'MakeMaker'/'ModuleBuildTiny::Fallback'/g;
$code =~ s/ExtUtils::MakeMaker/Module::Build::Tiny/g;
$code =~ s/Makefile.PL/Build.PL/g;
$code =~ s/# build prereqs go here/build => \{ requires => \{ 'Module::Build::Tiny' => ignore \} \},/
    if eval { Dist::Zilla::Plugin::ModuleBuildTiny->VERSION('999') }; # adjust later

eval $code;
die $@ if $@;
