/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.grid.internal.cli;

import com.beust.jcommander.IStringConverter;
import org.openqa.selenium.remote.DesiredCapabilities;

class BrowserDesiredCapabilityConverter
implements IStringConverter<DesiredCapabilities> {
    BrowserDesiredCapabilityConverter() {
    }

    @Override
    public DesiredCapabilities convert(String value) {
        DesiredCapabilities capabilities = new DesiredCapabilities();
        for (String cap : value.split(",")) {
            String[] pieces = cap.split("=");
            String capabilityName = pieces[0].trim();
            String capabilityValue = pieces[1].trim();
            if (capabilityName.equals("version")) {
                capabilities.setCapability(capabilityName, capabilityValue);
                continue;
            }
            try {
                Long x = Long.parseLong(capabilityValue);
                capabilities.setCapability(capabilityName, x);
            }
            catch (NumberFormatException e) {
                if (capabilityValue.equals("true") || capabilityValue.equals("false")) {
                    capabilities.setCapability(capabilityName, Boolean.parseBoolean(capabilityValue));
                    continue;
                }
                capabilities.setCapability(capabilityName, capabilityValue);
            }
        }
        return capabilities;
    }
}

