/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.html.DomAttr;
import com.gargoylesoftware.htmlunit.html.HtmlForm;
import com.gargoylesoftware.htmlunit.html.HtmlInput;
import java.io.IOException;
import java.util.Map;

public class HtmlResetInput
extends HtmlInput {
    private static final String DEFAULT_VALUE = "Reset";

    HtmlResetInput(String qualifiedName, SgmlPage page, Map<String, DomAttr> attributes) {
        super(qualifiedName, page, HtmlResetInput.addValueIfNeeded(page, attributes));
        if (this.hasFeature(BrowserVersionFeatures.RESETINPUT_DEFAULT_VALUE_IF_VALUE_NOT_DEFINED) && this.getAttribute("value") == DEFAULT_VALUE) {
            this.setDefaultValue(ATTRIBUTE_NOT_DEFINED, false);
        }
    }

    private static Map<String, DomAttr> addValueIfNeeded(SgmlPage page, Map<String, DomAttr> attributes) {
        BrowserVersion browserVersion = page.getWebClient().getBrowserVersion();
        if (browserVersion.hasFeature(BrowserVersionFeatures.RESETINPUT_DEFAULT_VALUE_IF_VALUE_NOT_DEFINED)) {
            for (String key : attributes.keySet()) {
                if (!"value".equalsIgnoreCase(key)) continue;
                return attributes;
            }
            DomAttr newAttr = new DomAttr(page, null, "value", DEFAULT_VALUE, true);
            attributes.put("value", newAttr);
        }
        return attributes;
    }

    @Override
    protected boolean doClickStateUpdate() throws IOException {
        HtmlForm form = this.getEnclosingForm();
        if (form != null) {
            form.reset();
            return false;
        }
        super.doClickStateUpdate();
        return false;
    }

    @Override
    public void reset() {
    }

    @Override
    public void setAttributeNS(String namespaceURI, String qualifiedName, String attributeValue) {
        if (this.hasFeature(BrowserVersionFeatures.HTMLINPUT_SET_VALUE_UPDATES_DEFAULT_VALUE) && "value".equals(qualifiedName)) {
            this.setDefaultValue(attributeValue, false);
        }
        super.setAttributeNS(namespaceURI, qualifiedName, attributeValue);
    }
}

