# automatically generated file, don't edit



# Copyright 2023 David Cantrell, derived from data from libphonenumber
# http://code.google.com/p/libphonenumber/
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
package Number::Phone::StubCountry::JP;
use base qw(Number::Phone::StubCountry);

use strict;
use warnings;
use utf8;
our $VERSION = 1.20230307181420;

my $formatters = [
                {
                  'format' => '$1-$2',
                  'intl_format' => 'NA',
                  'leading_digits' => '00777[01]',
                  'pattern' => '(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '
            (?:
              12|
              57|
              99
            )0
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{3})(\\d{3})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '
            1(?:
              267|
              3(?:
                7[247]|
                9[278]
              )|
              466|
              5(?:
                47|
                58|
                64
              )|
              6(?:
                3[245]|
                48|
                5[4-68]
              )
            )|
            499[2468]|
            5(?:
              769|
              979[2-69]
            )|
            7468|
            8(?:
              3(?:
                8[7-9]|
                96[2457-9]
              )|
              477|
              51[2-9]|
              636[457-9]
            )|
            9(?:
              802|
              9(?:
                1[23]|
                69
              )
            )|
            1(?:
              45|
              58
            )[67]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d)(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '60',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '
            [36]|
            4(?:
              2(?:
                0|
                9[02-69]
              )|
              7(?:
                0[019]|
                1
              )
            )
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d)(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '
            1(?:
              1|
              5(?:
                4[018]|
                5[017]
              )|
              77|
              88|
              9[69]
            )|
            2(?:
              2[127]|
              3[0-269]|
              4[59]|
              5(?:
                [1-3]|
                5[0-69]|
                7[015-9]|
                9(?:
                  17|
                  99
                )
              )|
              6(?:
                2|
                4[016-9]
              )|
              7(?:
                [1-35]|
                8[0189]
              )|
              8(?:
                [16]|
                3[0134]|
                9[0-5]
              )|
              9(?:
                [028]|
                17|
                3[015-9]
              )
            )|
            4(?:
              2(?:
                [13-79]|
                8[014-6]
              )|
              3[0-57]|
              [45]|
              6[248]|
              7[2-47]|
              9[29]
            )|
            5(?:
              2|
              3[045]|
              4[0-369]|
              5[29]|
              8[02389]|
              9[0-3]
            )|
            7(?:
              2[02-46-9]|
              34|
              [58]|
              6[0249]|
              7[57]|
              9(?:
                [23]|
                4[0-59]|
                5[01569]|
                6[0167]
              )
            )|
            8(?:
              2(?:
                [1258]|
                4[0-39]|
                9(?:
                  [019]|
                  4[1-3]|
                  6(?:
                    [0-47-9]|
                    5[01346-9]
                  )
                )
              )|
              3(?:
                [29]|
                7(?:
                  [017-9]|
                  6[6-8]
                )
              )|
              49|
              51|
              6(?:
                [0-24]|
                36[23]|
                5(?:
                  [0-389]|
                  5[23]
                )|
                6(?:
                  [01]|
                  9[178]
                )|
                72|
                9[0145]
              )|
              7[0-468]|
              8[68]
            )|
            9(?:
              4[15]|
              5[138]|
              6[1-3]|
              7[156]|
              8[189]|
              9(?:
                [1289]|
                3(?:
                  31|
                  4[357]
                )|
                4[0178]
              )
            )|
            (?:
              223|
              8699
            )[014-9]|
            (?:
              25[0468]|
              422|
              838
            )[01]|
            (?:
              48|
              829(?:
                2|
                66
              )|
              9[23]
            )[1-9]|
            (?:
              47[59]|
              59[89]|
              8(?:
                68|
                9
              )
            )[019]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '
            [14]|
            [289][2-9]|
            5[3-9]|
            7[2-4679]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{2})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'intl_format' => 'NA',
                  'leading_digits' => '0077',
                  'pattern' => '(\\d{4})(\\d{2})(\\d{3,4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'intl_format' => 'NA',
                  'leading_digits' => '008',
                  'pattern' => '(\\d{4})(\\d{2})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '800',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '[257-9]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'intl_format' => 'NA',
                  'pattern' => '(\\d{4})(\\d{3})(\\d{3,4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'intl_format' => 'NA',
                  'pattern' => '(\\d{4})(\\d{4})(\\d{4,5})'
                },
                {
                  'format' => '$1-$2-$3',
                  'intl_format' => 'NA',
                  'pattern' => '(\\d{4})(\\d{5})(\\d{5,6})'
                },
                {
                  'format' => '$1-$2-$3',
                  'intl_format' => 'NA',
                  'pattern' => '(\\d{4})(\\d{6})(\\d{6,7})'
                }
              ];

my $validators = {
                'fixed_line' => '
          (?:
            1(?:
              1[235-8]|
              2[3-6]|
              3[3-9]|
              4[2-6]|
              [58][2-8]|
              6[2-7]|
              7[2-9]|
              9[1-9]
            )|
            (?:
              2[2-9]|
              [36][1-9]
            )\\d|
            4(?:
              [2-578]\\d|
              6[02-8]|
              9[2-59]
            )|
            5(?:
              [2-589]\\d|
              6[1-9]|
              7[2-8]
            )|
            7(?:
              [25-9]\\d|
              3[4-9]|
              4[02-9]
            )|
            8(?:
              [2679]\\d|
              3[2-9]|
              4[5-9]|
              5[1-9]|
              8[03-9]
            )|
            9(?:
              [2-58]\\d|
              [679][1-9]
            )
          )\\d{6}
        ',
                'geographic' => '
          (?:
            1(?:
              1[235-8]|
              2[3-6]|
              3[3-9]|
              4[2-6]|
              [58][2-8]|
              6[2-7]|
              7[2-9]|
              9[1-9]
            )|
            (?:
              2[2-9]|
              [36][1-9]
            )\\d|
            4(?:
              [2-578]\\d|
              6[02-8]|
              9[2-59]
            )|
            5(?:
              [2-589]\\d|
              6[1-9]|
              7[2-8]
            )|
            7(?:
              [25-9]\\d|
              3[4-9]|
              4[02-9]
            )|
            8(?:
              [2679]\\d|
              3[2-9]|
              4[5-9]|
              5[1-9]|
              8[03-9]
            )|
            9(?:
              [2-58]\\d|
              [679][1-9]
            )
          )\\d{6}
        ',
                'mobile' => '[7-9]0[1-9]\\d{7}',
                'pager' => '20\\d{8}',
                'personal_number' => '60\\d{7}',
                'specialrate' => '(990\\d{6})|(570\\d{6})',
                'toll_free' => '
          00777(?:
            [01]|
            5\\d
          )\\d\\d|
          (?:
            00(?:
              7778|
              882[1245]
            )|
            (?:
              120|
              800\\d
            )\\d\\d
          )\\d{4}|
          00(?:
            37|
            66|
            78
          )\\d{6,13}
        ',
                'voip' => '50[1-9]\\d{7}'
              };
my %areanames = ();
$areanames{en} = {"81482", "Kawaguchi\,\ Saitama",
"818835", "Mima\,\ Tokushima",
"81765", "Uozu\,\ Toyama",
"81729", "Yao\,\ Osaka",
"819944", "Kanoya\,\ Kagoshima",
"81142", "Date\,\ Hokkaido",
"817703", "Tsuruga\,\ Fukui",
"81983", "Takanabe\,\ Miyazaki",
"818956", "Uwajima\,\ Ehime",
"819979", "Tokunoshima\,\ Kagoshima",
"81938", "Kitakyushu\,\ Fukuoka",
"811396", "Esashi\,\ Hokkaido",
"8161", "Osaka\,\ Osaka",
"814287", "Ome\,\ Tokyo",
"812230", "Sendai\,\ Miyagi",
"812962", "Shimodate\,\ Ibaraki",
"81935", "Kitakyushu\,\ Fukuoka",
"817969", "Hamasaka\,\ Hyogo",
"818843", "Anan\,\ Tokushima",
"811863", "Kazuno\,\ Akita",
"8182943", "Hiroshima\,\ Hiroshima",
"818385", "Hagi\,\ Yamaguchi",
"814702", "Tateyama\,\ Chiba",
"815734", "Ena\,\ Gifu",
"819953", "Okuchi\,\ Kagoshima",
"815755", "Sekigahara\,\ Gifu",
"812659", "Ina\,\ Nagano",
"818475", "Fuchu\,\ Hiroshima",
"812619", "Omachi\,\ Nagano",
"817682", "Wajima\,\ Ishikawa",
"811558", "Hiroo\,\ Hokkaido",
"817494", "Hikone\,\ Shiga",
"81586", "Ichinomiya\,\ Aichi",
"812742", "Fujioka\,\ Gunma",
"815996", "Ago\,\ Mie",
"818206", "Yanai\,\ Yamaguchi",
"817612", "Komatsu\,\ Ishikawa",
"811588", "Okoppe\,\ Hokkaido",
"812673", "Komoro\,\ Nagano",
"81947", "Tagawa\,\ Fukuoka",
"815395", "Hamamatsu\,\ Shizuoka",
"8198292", "Nobeoka\,\ Miyazaki",
"812573", "Kashiwazaki\,\ Niigata",
"812896", "Kanuma\,\ Tochigi",
"81979", "Nakatsu\,\ Oita",
"812589", "Nagaoka\,\ Niigata",
"812994", "Ishioka\,\ Ibaraki",
"811658", "Kamikawa\,\ Hokkaido",
"812559", "Yasuzuka\,\ Niigata",
"811756", "Noheji\,\ Aomori",
"8165", "Osaka\,\ Osaka",
"811874", "Kakunodate\,\ Akita",
"817914", "Aioi\,\ Hyogo",
"811976", "Kitakami\,\ Iwate",
"817954", "Nishiwaki\,\ Hyogo",
"8125483", "Murakami\,\ Niigata",
"81740", "Imazu\,\ Shiga",
"819738", "Kusu\,\ Oita",
"811375", "Yakumo\,\ Hokkaido",
"817943", "Kakogawa\,\ Hyogo",
"81734", "Wakayama\,\ Wakayama",
"812414", "Yanaizu\,\ Fukushima",
"814794", "Choshi\,\ Chiba",
"81476", "Narita\,\ Chiba",
"8166", "Osaka\,\ Osaka",
"818545", "Kisuki\,\ Shimane",
"8199343", "Kagoshima\,\ Kagoshima",
"812484", "Shirakawa\,\ Fukushima",
"812692", "Nakano\,\ Nagano",
"812374", "Murayama\,\ Yamagata",
"81427", "Sagamihara\,\ Kanagawa",
"815768", "Gero\,\ Gifu",
"811455", "Mukawa\,\ Hokkaido",
"811232", "Chitose\,\ Hokkaido",
"81494", "Chichibu\,\ Saitama",
"817367", "Iwade\,\ Wakayama",
"819789", "Kitsuki\,\ Oita",
"819824", "Nobeoka\,\ Miyazaki",
"812564", "Sanjo\,\ Niigata",
"818368", "Ube\,\ Yamaguchi",
"81259", "Sado\,\ Niigata",
"8186995", "Seto\,\ Okayama",
"81225", "Ishinomaki\,\ Miyagi",
"812875", "Otawara\,\ Tochigi",
"819667", "Minamata\,\ Kumamoto",
"81832", "Shimonoseki\,\ Yamaguchi",
"817238", "Neyagawa\,\ Osaka",
"818678", "Niimi\,\ Okayama",
"815566", "Minobu\,\ Yamanashi",
"819542", "Takeo\,\ Saga",
"817677", "Nanao\,\ Ishikawa",
"81572", "Tajimi\,\ Gifu",
"811947", "Kuji\,\ Iwate",
"817968", "Hamasaka\,\ Hyogo",
"815394", "Hamamatsu\,\ Shizuoka",
"81242", "Aizuwakamatsu\,\ Fukushima",
"81174", "Kanita\,\ Aomori",
"819978", "Tokunoshima\,\ Kagoshima",
"812995", "Ishioka\,\ Ibaraki",
"81557", "Ito\,\ Shizuoka",
"811736", "Goshogawara\,\ Aomori",
"81567", "Tsushima\,\ Aichi",
"818474", "Fuchu\,\ Hiroshima",
"817495", "Nagahama\,\ Shiga",
"818942", "Yawatahama\,\ Ehime",
"81792", "Himeji\,\ Hyogo",
"8126175", "Omachi\,\ Nagano",
"818808", "Tosashimizu\,\ Kochi",
"81432", "Chiba\,\ Chiba",
"8186553", "Kurashiki\,\ Okayama",
"814776", "Funabashi\,\ Chiba",
"81933", "Kitakyushu\,\ Fukuoka",
"815735", "Ena\,\ Gifu",
"819933", "Ibusuki\,\ Kagoshima",
"815754", "Sekigahara\,\ Gifu",
"818384", "Hagi\,\ Yamaguchi",
"812588", "Nagaoka\,\ Niigata",
"815362", "Shinshiro\,\ Aichi",
"81827", "Iwakuni\,\ Yamaguchi",
"81763", "Fukuno\,\ Toyama",
"818834", "Kamojima\,\ Tokushima",
"819945", "Kanoya\,\ Kagoshima",
"815743", "Minokamo\,\ Gifu",
"812786", "Numata\,\ Gunma",
"811589", "Okoppe\,\ Hokkaido",
"81988", "Naha\,\ Okinawa",
"81196", "Morioka\,\ Iwate",
"8112396", "Kuriyama\,\ Hokkaido",
"812658", "Ina\,\ Nagano",
"812618", "Omachi\,\ Nagano",
"8125489", "Tsugawa\,\ Niigata",
"81985", "Miyazaki\,\ Miyazaki",
"811363", "Kutchan\,\ Hokkaido",
"811559", "Obihiro\,\ Hokkaido",
"812246", "Ogawara\,\ Miyagi",
"812874", "Otawara\,\ Tochigi",
"814701", "Kamogawa\,\ Chiba",
"818697", "Bizen\,\ Okayama",
"818463", "Takehara\,\ Hiroshima",
"812375", "Murayama\,\ Yamagata",
"811454", "Mukawa\,\ Hokkaido",
"817476", "Shimonoseki\,\ Yamaguchi",
"815974", "Owase\,\ Mie",
"819825", "Hyuga\,\ Miyazaki",
"812565", "Sanjo\,\ Niigata",
"817356", "Kushimoto\,\ Wakayama",
"819437", "Tanushimaru\,\ Fukuoka",
"818683", "Tsuyama\,\ Okayama",
"814700", "Kamogawa\,\ Chiba",
"811374", "Mori\,\ Hokkaido",
"817239", "Neyagawa\,\ Osaka",
"8153965", "Hamamatsu\,\ Shizuoka",
"818679", "Niimi\,\ Okayama",
"819556", "Karatsu\,\ Saga",
"812415", "Yanaizu\,\ Fukushima",
"812232", "Iwanuma\,\ Miyagi",
"814795", "Choshi\,\ Chiba",
"818293", "Hatsukaichi\,\ Hiroshima",
"811564", "Kamishihoro\,\ Hokkaido",
"812485", "Shirakawa\,\ Fukushima",
"818544", "Kisuki\,\ Shimane",
"819686", "Tamana\,\ Kumamoto",
"81544", "Fujinomiya\,\ Shizuoka",
"8153970", "Hamamatsu\,\ Shizuoka",
"811875", "Kakunodate\,\ Akita",
"819788", "Kunisaki\,\ Oita",
"81125", "Takikawa\,\ Hokkaido",
"818553", "Hamada\,\ Shimane",
"818369", "Ube\,\ Yamaguchi",
"817955", "Sanda\,\ Hyogo",
"817915", "Aioi\,\ Hyogo",
"8183766", "Shimonoseki\,\ Yamaguchi",
"818583", "Kurayoshi\,\ Tottori",
"815769", "Shokawa\,\ Gifu",
"819724", "Saiki\,\ Oita",
"819596", "Fukue\,\ Nagasaki",
"817468", "Kamikitayama\,\ Nara",
"8125480", "Murakami\,\ Niigata",
"818467", "Mima\,\ Tokushima",
"81292", "Mito\,\ Ibaraki",
"818949", "Uwajima\,\ Ehime",
"814755", "Togane\,\ Chiba",
"818693", "Oku\,\ Okayama",
"81742", "Nara\,\ Nara",
"81582", "Gifu\,\ Gifu",
"818244", "Miyoshi\,\ Hiroshima",
"8152", "Nagoya\,\ Aichi",
"818593", "Yonago\,\ Tottori",
"812968", "Kasama\,\ Ibaraki",
"818974", "Niihama\,\ Ehime",
"817995", "Sumoto\,\ Hyogo",
"811462", "Urakawa\,\ Hokkaido",
"812646", "Nagano\,\ Nagano",
"819433", "Yame\,\ Fukuoka",
"812748", "Tomioka\,\ Gunma",
"81263", "Matsumoto\,\ Nagano",
"811552", "Obihiro\,\ Hokkaido",
"818687", "Mimasaka\,\ Okayama",
"817688", "Noto\,\ Ishikawa",
"818297", "Hatsukaichi\,\ Hiroshima",
"817716", "Sonobe\,\ Kyoto",
"818657", "Kasaoka\,\ Okayama",
"811582", "Monbetsu\,\ Hokkaido",
"817618", "Kaga\,\ Ishikawa",
"819804", "Nago\,\ Okinawa",
"818557", "Kawamoto\,\ Shimane",
"81486", "Urawa\,\ Saitama",
"818587", "Koge\,\ Tottori",
"8126178", "Omachi\,\ Nagano",
"811652", "Shibetsu\,\ Hokkaido",
"81253", "Niigata\,\ Niigata",
"812546", "Murakami\,\ Niigata",
"815583", "Shimoda\,\ Shizuoka",
"8153979", "Hamamatsu\,\ Shizuoka",
"819575", "Isahaya\,\ Nagasaki",
"81134", "Otaru\,\ Hokkaido",
"812476", "Miharu\,\ Fukushima",
"811336", "Ishikari\,\ Hokkaido",
"811943", "Iwaizumi\,\ Iwate",
"8153968", "Hamamatsu\,\ Shizuoka",
"819732", "Hita\,\ Oita",
"81857", "Tottori\,\ Tottori",
"812580", "Tokamachi\,\ Niigata",
"81723", "Sakai\,\ Osaka",
"811856", "Noshiro\,\ Akita",
"817723", "Miyazu\,\ Kyoto",
"819966", "Izumi\,\ Kagoshima",
"811984", "Hanamaki\,\ Iwate",
"818895", "Susaki\,\ Kochi",
"81989", "Naha\,\ Okinawa",
"812796", "Shibukawa\,\ Gunma",
"812550", "Yasuzuka\,\ Niigata",
"811954", "Ninohe\,\ Iwate",
"812698", "Iiyama\,\ Nagano",
"811935", "Kamaishi\,\ Iwate",
"81480", "Kuki\,\ Saitama",
"812836", "Sano\,\ Tochigi",
"81284", "Ashikaga\,\ Tochigi",
"815762", "Gero\,\ Gifu",
"819746", "Taketa\,\ Oita",
"819937", "Kaseda\,\ Kagoshima",
"811525", "Abashiri\,\ Hokkaido",
"811238", "Kuriyama\,\ Hokkaido",
"818362", "Ube\,\ Yamaguchi",
"8199347", "Kagoshima\,\ Kagoshima",
"812934", "Takahagi\,\ Ibaraki",
"812955", "Hitachi\-Omiya\,\ Ibaraki",
"8188096", "Tosashimizu\,\ Kochi",
"817455", "Yamatotakada\,\ Nara",
"812239", "Sendai\,\ Miyagi",
"81594", "Kuwana\,\ Mie",
"8186697", "Kurashiki\,\ Okayama",
"811367", "Suttsu\,\ Hokkaido",
"817485", "Yokaichi\,\ Shiga",
"8125487", "Tsugawa\,\ Niigata",
"812551", "Joetsu\,\ Niigata",
"812386", "Nagai\,\ Yamagata",
"81467", "Fujisawa\,\ Kanagawa",
"817962", "Toyooka\,\ Hyogo",
"817230", "Neyagawa\,\ Osaka",
"819805", "Nago\,\ Okinawa",
"814709", "Kamogawa\,\ Chiba",
"8198294", "Nobeoka\,\ Miyazaki",
"811632", "Teshio\,\ Hokkaido",
"81192", "Ofunato\,\ Iwate",
"818360", "Ogori\,\ Yamaguchi",
"81436", "Ichihara\,\ Chiba",
"818948", "Uwajima\,\ Ehime",
"811532", "Nemuro\,\ Hokkaido",
"817947", "Miki\,\ Hyogo",
"817736", "Maizuru\,\ Kyoto",
"81268", "Ueda\,\ Nagano",
"81774", "Uji\,\ Kyoto",
"811646", "Haboro\,\ Hokkaido",
"818245", "Miyoshi\,\ Hiroshima",
"818666", "Ibara\,\ Okayama",
"812552", "Joetsu\,\ Niigata",
"818975", "Niihama\,\ Ehime",
"815368", "Shitara\,\ Aichi",
"812582", "Nagaoka\,\ Niigata",
"81924", "Fukuoka\,\ Fukuoka",
"817994", "Sumoto\,\ Hyogo",
"818376", "Mine\,\ Yamaguchi",
"81246", "Iwaki\,\ Fukushima",
"819663", "Hitoyoshi\,\ Kumamoto",
"819725", "Saiki\,\ Oita",
"81532", "Toyohashi\,\ Aichi",
"8153973", "Hamamatsu\,\ Shizuoka",
"8162", "Osaka\,\ Osaka",
"812612", "Omachi\,\ Nagano",
"812652", "Iida\,\ Nagano",
"817673", "Hakui\,\ Ishikawa",
"811546", "Kushiro\,\ Hokkaido",
"814754", "Mobara\,\ Chiba",
"81234", "Sakata\,\ Yamagata",
"817454", "Yamatotakada\,\ Nara",
"815986", "Matsusaka\,\ Mie",
"817484", "Yokaichi\,\ Shiga",
"8126171", "Omachi\,\ Nagano",
"817707", "Obama\,\ Fukui",
"814283", "Ome\,\ Tokyo",
"812856", "Mooka\,\ Tochigi",
"8186998", "Seto\,\ Okayama",
"81975", "Oita\,\ Oita",
"811524", "Abashiri\,\ Hokkaido",
"819957", "Kajiki\,\ Kagoshima",
"812914", "Hokota\,\ Ibaraki",
"811867", "Takanosu\,\ Akita",
"812935", "Mito\,\ Ibaraki",
"81725", "Izumi\,\ Osaka",
"81721", "Tondabayashi\,\ Osaka",
"818894", "Susaki\,\ Kochi",
"81886", "Tokushima\,\ Tokushima",
"81184", "Yurihonjo\,\ Akita",
"812238", "Sendai\,\ Miyagi",
"81728", "Neyagawa\,\ Osaka",
"812677", "Saku\,\ Nagano",
"817902", "Fukusaki\,\ Hyogo",
"811934", "Kamaishi\,\ Iwate",
"811955", "Ninohe\,\ Iwate",
"819574", "Isahaya\,\ Nagasaki",
"819782", "Bungotakada\,\ Oita",
"812577", "Muika\,\ Niigata",
"811356", "Iwanai\,\ Hokkaido",
"814297", "Hanno\,\ Saitama",
"81939", "Kitakyushu\,\ Fukuoka",
"8145", "Yokohama\,\ Kanagawa",
"818584", "Kurayoshi\,\ Tottori",
"812388", "Nagai\,\ Yamagata",
"819546", "Kashima\,\ Saga",
"814771", "Ichikawa\,\ Chiba",
"818514", "Ama\,\ Shimane",
"818554", "Hamada\,\ Shimane",
"811236", "Chitose\,\ Hokkaido",
"81545", "Fuji\,\ Shizuoka",
"8186994", "Seto\,\ Okayama",
"818654", "Kamogata\,\ Okayama",
"81462", "Atsugi\,\ Kanagawa",
"818294", "Hatsukaichi\,\ Hiroshima",
"811563", "Honbetsu\,\ Hokkaido",
"81124", "Ashibetsu\,\ Hokkaido",
"818543", "Yasugi\,\ Shimane",
"817945", "Kakogawa\,\ Hyogo",
"818684", "Tsuyama\,\ Okayama",
"812838", "Sano\,\ Tochigi",
"81548", "Haibara\,\ Shizuoka",
"81963", "Kumamoto\,\ Kumamoto",
"815973", "Owase\,\ Mie",
"812798", "Naganohara\,\ Gunma",
"818977", "Hakata\,\ Ehime",
"81537", "Kakegawa\,\ Shizuoka",
"812696", "Iiyama\,\ Nagano",
"811858", "Noshiro\,\ Akita",
"811453", "Hayakita\,\ Hokkaido",
"819968", "Izumi\,\ Kagoshima",
"818247", "Shobara\,\ Hiroshima",
"814770", "Ichikawa\,\ Chiba",
"815959", "Kameyama\,\ Mie",
"81877", "Marugame\,\ Kagawa",
"811972", "Mizusawa\,\ Iwate",
"812780", "Maebashi\,\ Gunma",
"812859", "Oyama\,\ Tochigi",
"81992", "Kagoshima\,\ Kagoshima",
"81566", "Kariya\,\ Aichi",
"81849", "Fukuyama\,\ Hiroshima",
"818464", "Takehara\,\ Hiroshima",
"818262", "Kake\,\ Hiroshima",
"812478", "Miharu\,\ Fukushima",
"81493", "Higashimatsuyama\,\ Saitama",
"819727", "Usuki\,\ Oita",
"812873", "Otawara\,\ Tochigi",
"818669", "Soja\,\ Okayama",
"81550", "Gotenba\,\ Shizuoka",
"817705", "Obama\,\ Fukui",
"814998", "Ogasawara\,\ Tokyo",
"811752", "Mutsu\,\ Aomori",
"811364", "Kutchan\,\ Hokkaido",
"8168", "Osaka\,\ Osaka",
"8198298", "Hyuga\,\ Miyazaki",
"818833", "Kamojima\,\ Tokushima",
"812892", "Utsunomiya\,\ Tochigi",
"815744", "Minokamo\,\ Gifu",
"815992", "Toba\,\ Mie",
"81898", "Imabari\,\ Ehime",
"818202", "Yanai\,\ Yamaguchi",
"812937", "Mito\,\ Ibaraki",
"811865", "Odate\,\ Akita",
"817718", "Sonobe\,\ Kyoto",
"815753", "Sekigahara\,\ Gifu",
"819955", "Kajiki\,\ Kagoshima",
"819934", "Ibusuki\,\ Kagoshima",
"817616", "Komatsu\,\ Ishikawa",
"818383", "Hagi\,\ Yamaguchi",
"812648", "Nagano\,\ Nagano",
"81273", "Takasaki\,\ Gunma",
"817686", "Noto\,\ Ishikawa",
"81984", "Kobayashi\,\ Miyazaki",
"811549", "Kushiro\,\ Hokkaido",
"812746", "Tomioka\,\ Gunma",
"811957", "Iwate\,\ Iwate",
"81178", "Hachinohe\,\ Aomori",
"812675", "Saku\,\ Nagano",
"811392", "Kikonai\,\ Hokkaido",
"811987", "Tono\,\ Iwate",
"817466", "Totsukawa\,\ Nara",
"818952", "Uwajima\,\ Ehime",
"819598", "Fukue\,\ Nagasaki",
"812575", "Tokamachi\,\ Niigata",
"815393", "Hamamatsu\,\ Shizuoka",
"818397", "Ogori\,\ Yamaguchi",
"814757", "Togane\,\ Chiba",
"812839", "Sano\,\ Tochigi",
"81587", "Ichinomiya\,\ Aichi",
"8153964", "Hamamatsu\,\ Shizuoka",
"819682", "Yamaga\,\ Kumamoto",
"8183767", "Shimonoseki\,\ Yamaguchi",
"81495", "Honjo\,\ Saitama",
"81946", "Amagi\,\ Fukuoka",
"817997", "Tsuna\,\ Hyogo",
"812236", "Sendai\,\ Miyagi",
"812563", "Sanjo\,\ Niigata",
"819823", "Nobeoka\,\ Miyazaki",
"817352", "Shingu\,\ Fukuoka",
"812373", "Murayama\,\ Yamagata",
"81779", "Ono\,\ Gifu",
"812389", "Yonezawa\,\ Yamagata",
"819552", "Imari\,\ Saga",
"814793", "Choshi\,\ Chiba",
"818655", "Kamogata\,\ Okayama",
"81543", "Shizuoka\,\ Shizuoka",
"812483", "Shirakawa\,\ Fukushima",
"818295", "Hatsukaichi\,\ Hiroshima",
"81929", "Fukuoka\,\ Fukuoka",
"812858", "Mooka\,\ Tochigi",
"818685", "Tsuyama\,\ Okayama",
"817944", "Kakogawa\,\ Hyogo",
"812413", "Kitakata\,\ Fukushima",
"81965", "Yatsushiro\,\ Kumamoto",
"81420", "Tokorozawa\,\ Saitama",
"812890", "Utsunomiya\,\ Tochigi",
"817953", "Nishiwaki\,\ Hyogo",
"815958", "Kameyama\,\ Mie",
"818585", "Kurayoshi\,\ Tottori",
"8198291", "Nobeoka\,\ Miyazaki",
"81958", "Nagasaki\,\ Nagasaki",
"812242", "Shiroishi\,\ Miyagi",
"812799", "Naganohara\,\ Gunma",
"818555", "Gotsu\,\ Shimane",
"8112390", "Yubari\,\ Hokkaido",
"81738", "Gobo\,\ Wakayama",
"811873", "Kakunodate\,\ Akita",
"812649", "Nagano\,\ Nagano",
"81862", "Okayama\,\ Okayama",
"812993", "Ishioka\,\ Ibaraki",
"8188099", "Tosashimizu\,\ Kochi",
"818568", "Tsuwano\,\ Shimane",
"811548", "Teshikaga\,\ Hokkaido",
"81426", "Hachioji\,\ Tokyo",
"818378", "Shimonoseki\,\ Yamaguchi",
"812574", "Kashiwazaki\,\ Niigata",
"8112397", "Kuriyama\,\ Hokkaido",
"812782", "Numata\,\ Gunma",
"819577", "Shimabara\,\ Nagasaki",
"814772", "Ichikawa\,\ Chiba",
"811937", "Miyako\,\ Iwate",
"812674", "Komoro\,\ Nagano",
"815366", "Shitara\,\ Aichi",
"818668", "Ibara\,\ Okayama",
"81852", "Matsue\,\ Shimane",
"812549", "Tsugawa\,\ Niigata",
"817493", "Hikone\,\ Shiga",
"819599", "Oseto\,\ Nagasaki",
"812917", "Mito\,\ Ibaraki",
"818844", "Anan\,\ Tokushima",
"81940", "Munakata\,\ Fukuoka",
"817738", "Maizuru\,\ Kyoto",
"812957", "Daigo\,\ Ibaraki",
"81764", "Toyama\,\ Toyama",
"811864", "Odate\,\ Akita",
"8128798", "Otawara\,\ Tochigi",
"818490", "Onomichi\,\ Hiroshima",
"819954", "Kajiki\,\ Kagoshima",
"819935", "Kaseda\,\ Kagoshima",
"815733", "Ena\,\ Gifu",
"811527", "Bihoro\,\ Hokkaido",
"81893", "Ozu\,\ Ehime",
"8163", "Osaka\,\ Osaka",
"818946", "Uwajima\,\ Ehime",
"817704", "Tsuruga\,\ Fukui",
"817487", "Minakuchi\,\ Shiga",
"811365", "Kutchan\,\ Hokkaido",
"8153976", "Hamamatsu\,\ Shizuoka",
"818879", "Muroto\,\ Kochi",
"811732", "Goshogawara\,\ Aomori",
"8126174", "Omachi\,\ Nagano",
"81934", "Kitakyushu\,\ Fukuoka",
"819943", "Kanoya\,\ Kagoshima",
"817457", "Yamatotakada\,\ Nara",
"815745", "Minokamo\,\ Gifu",
"8188097", "Tosashimizu\,\ Kochi",
"818676", "Kuse\,\ Okayama",
"812382", "Yonezawa\,\ Yamagata",
"812997", "Itako\,\ Ibaraki",
"819573", "Isahaya\,\ Nagasaki",
"81797", "Nishinomiya\,\ Hyogo",
"8112399", "Kuriyama\,\ Hokkaido",
"81188", "Akita\,\ Akita",
"8125486", "Tsugawa\,\ Niigata",
"811945", "Kuji\,\ Iwate",
"818366", "Ube\,\ Yamaguchi",
"811933", "Kamaishi\,\ Iwate",
"812832", "Sano\,\ Tochigi",
"817497", "Nagahama\,\ Shiga",
"818893", "Sakawa\,\ Kochi",
"815766", "Gero\,\ Gifu",
"819742", "Mie\,\ Oita",
"817725", "Miyazu\,\ Kyoto",
"811541", "Teshikaga\,\ Hokkaido",
"81552", "Kofu\,\ Yamanashi",
"81235", "Tsuruoka\,\ Yamagata",
"814220", "Kokubunji\,\ Tokyo",
"81822", "Hiroshima\,\ Hiroshima",
"812792", "Shibukawa\,\ Gunma",
"815737", "Nakatsugawa\,\ Gifu",
"811523", "Shari\,\ Hokkaido",
"81466", "Fujisawa\,\ Kanagawa",
"812913", "Hokota\,\ Ibaraki",
"8167", "Osaka\,\ Osaka",
"818660", "Seto\,\ Okayama",
"814284", "Tachikawa\,\ Tokyo",
"81593", "Yokkaichi\,\ Mie",
"811852", "Oga\,\ Akita",
"819962", "Satsumasendai\,\ Kagoshima",
"817483", "Yokaichi\,\ Shiga",
"811978", "Kitakami\,\ Iwate",
"812472", "Ishikawa\,\ Fukushima",
"817453", "Yamatotakada\,\ Nara",
"819947", "Shibushi\,\ Kagoshima",
"811332", "Tobetsu\,\ Hokkaido",
"811656", "Bifuka\,\ Hokkaido",
"8126172", "Omachi\,\ Nagano",
"817674", "Hakui\,\ Ishikawa",
"818695", "Seto\,\ Okayama",
"814753", "Mobara\,\ Chiba",
"81928", "Fukuoka\,\ Fukuoka",
"812542", "Shibata\,\ Niigata",
"819664", "Hitoyoshi\,\ Kumamoto",
"81969", "Amakusa\,\ Kumamoto",
"81460", "Odawara\,\ Kanagawa",
"81925", "Fukuoka\,\ Fukuoka",
"812898", "Kanuma\,\ Tochigi",
"81739", "Tanabe\,\ Wakayama",
"817712", "Kameoka\,\ Kyoto",
"819827", "Takachiho\,\ Miyazaki",
"815998", "Ago\,\ Mie",
"811586", "Nakayubetsu\,\ Hokkaido",
"817993", "Sumoto\,\ Hyogo",
"812789", "Maebashi\,\ Gunma",
"818595", "Yonago\,\ Tottori",
"812377", "Sagae\,\ Yamagata",
"811556", "Obihiro\,\ Hokkaido",
"812487", "Sukagawa\,\ Fukushima",
"814797", "Yokaichiba\,\ Chiba",
"811466", "Erimo\,\ Hokkaido",
"811398", "Kumaishi\,\ Hokkaido",
"818872", "Muroto\,\ Kochi",
"819435", "Yame\,\ Fukuoka",
"815585", "Shimoda\,\ Shizuoka",
"81778", "Takefu\,\ Fukui",
"818958", "Misho\,\ Ehime",
"819592", "Oseto\,\ Nagasaki",
"811877", "Omagari\,\ Akita",
"81775", "Otsu\,\ Shiga",
"81281", "Utsunomiya\,\ Tochigi",
"819688", "Tamana\,\ Kumamoto",
"81179", "Sannohe\,\ Aomori",
"819786", "Kitsuki\,\ Oita",
"811352", "Yoichi\,\ Hokkaido",
"81288", "Imabari\,\ Ehime",
"81487", "Urawa\,\ Saitama",
"818387", "Tamagawa\,\ Yamaguchi",
"81233", "Shinjo\,\ Yamagata",
"812933", "Takahagi\,\ Ibaraki",
"814285", "Sagamihara\,\ Kanagawa",
"81591", "Tsu\,\ Mie",
"819558", "Karatsu\,\ Saga",
"811953", "Ninohe\,\ Iwate",
"812640", "Nagano\,\ Nagano",
"8147950", "Yokaichiba\,\ Chiba",
"8186992", "Bizen\,\ Okayama",
"81138", "Hakodate\,\ Hokkaido",
"812852", "Oyama\,\ Tochigi",
"817724", "Miyazu\,\ Kyoto",
"818477", "Tojo\,\ Hiroshima",
"811983", "Hanamaki\,\ Iwate",
"81183", "Yuzawa\,\ Akita",
"818797", "Tonosho\,\ Kagawa",
"812248", "Ogawara\,\ Miyagi",
"81942", "Kurume\,\ Fukuoka",
"811944", "Iwaizumi\,\ Iwate",
"815982", "Matsusaka\,\ Mie",
"81899", "Matsuyama\,\ Ehime",
"812616", "Omachi\,\ Nagano",
"812656", "Ina\,\ Nagano",
"811542", "Kushiro\,\ Hokkaido",
"818562", "Masuda\,\ Shimane",
"815584", "Shimoda\,\ Shizuoka",
"819803", "Nago\,\ Okinawa",
"818372", "Nagato\,\ Yamaguchi",
"815999", "Tsu\,\ Mie",
"812788", "Maebashi\,\ Gunma",
"819232", "Maebaru\,\ Fukuoka",
"818547", "Kakeya\,\ Shimane",
"8147957", "Yokaichiba\,\ Chiba",
"81845", "Innoshima\,\ Hiroshima",
"812586", "Nagaoka\,\ Niigata",
"812899", "Kanuma\,\ Tochigi",
"81848", "Onomichi\,\ Hiroshima",
"818806", "Sukumo\,\ Kochi",
"818662", "Takahashi\,\ Okayama",
"819434", "Yame\,\ Fukuoka",
"812556", "Itoigawa\,\ Niigata",
"811377", "Yakumo\,\ Hokkaido",
"817732", "Fukuchiyama\,\ Kyoto",
"818973", "Niihama\,\ Ehime",
"815977", "Kumano\,\ Mie",
"812830", "Utsunomiya\,\ Tochigi",
"818243", "Higashi\-ku\,\ Hiroshima",
"818594", "Yonago\,\ Tottori",
"8198295", "Hyuga\,\ Miyazaki",
"81577", "Takayama\,\ Gifu",
"811536", "Akkeshi\,\ Hokkaido",
"817675", "Nanao\,\ Ishikawa",
"819976", "Naze\,\ Kagoshima",
"81549", "Shizuoka\,\ Shizuoka",
"818694", "Okayama\,\ Okayama",
"819723", "Saiki\,\ Oita",
"819665", "Hitoyoshi\,\ Kumamoto",
"812877", "Kuroiso\,\ Tochigi",
"8112393", "Yubari\,\ Hokkaido",
"81923", "Fukuoka\,\ Fukuoka",
"811876", "Omagari\,\ Akita",
"8125484", "Murakami\,\ Niigata",
"819685", "Tamana\,\ Kumamoto",
"818462", "Takehara\,\ Hiroshima",
"811974", "Mizusawa\,\ Iwate",
"817956", "Sanda\,\ Hyogo",
"819555", "Karatsu\,\ Saga",
"812416", "Tajima\,\ Fukushima",
"817355", "Shingu\,\ Fukuoka",
"814288", "Ome\,\ Tokyo",
"81280", "Koga\,\ Ibaraki",
"8188095", "Tosashimizu\,\ Kochi",
"812486", "Sukagawa\,\ Fukushima",
"814796", "Yokaichiba\,\ Chiba",
"814291", "Hanno\,\ Saitama",
"817475", "Shimonoseki\,\ Yamaguchi",
"81484", "Kawaguchi\,\ Saitama",
"81569", "Handa\,\ Aichi",
"818682", "Tsuyama\,\ Okayama",
"812376", "Sagae\,\ Yamagata",
"81144", "Tomakomai\,\ Hokkaido",
"818292", "Hiroshima\,\ Hiroshima",
"81272", "Maebashi\,\ Gunma",
"819826", "Hyuga\,\ Miyazaki",
"812566", "Sanjo\,\ Niigata",
"812571", "Muika\,\ Niigata",
"818652", "Kurashiki\,\ Okayama",
"812233", "Iwanuma\,\ Miyagi",
"811587", "Nakayubetsu\,\ Hokkaido",
"8183768", "Shimonoseki\,\ Yamaguchi",
"818512", "Nishigo\,\ Fukushima",
"818552", "Hamada\,\ Shimane",
"812245", "Ogawara\,\ Miyagi",
"81559", "Numazu\,\ Shizuoka",
"818582", "Kurayoshi\,\ Tottori",
"819946", "Kanoya\,\ Kagoshima",
"812785", "Numata\,\ Gunma",
"81167", "Furano\,\ Hokkaido",
"8153972", "Hamamatsu\,\ Shizuoka",
"818954", "Uwajima\,\ Ehime",
"81492", "Kawagoe\,\ Saitama",
"819737", "Kusu\,\ Oita",
"818943", "Yawatahama\,\ Ehime",
"81834", "Tokuyama\,\ Yamaguchi",
"811394", "Matsumae\,\ Hokkaido",
"81157", "Kitami\,\ Hokkaido",
"815736", "Nakatsugawa\,\ Gifu",
"814775", "Funabashi\,\ Chiba",
"817496", "Nagahama\,\ Shiga",
"81463", "Hiratsuka\,\ Kanagawa",
"815767", "Gero\,\ Gifu",
"819932", "Ibusuki\,\ Kagoshima",
"815363", "Shinshiro\,\ Aichi",
"817940", "Kakogawa\,\ Hyogo",
"815994", "Ago\,\ Mie",
"81962", "Kumamoto\,\ Kumamoto",
"818367", "Ube\,\ Yamaguchi",
"8111", "Sapporo\,\ Hokkaido",
"818204", "Yanai\,\ Yamaguchi",
"81596", "Ise\,\ Mie",
"817368", "Iwade\,\ Wakayama",
"815742", "Minokamo\,\ Gifu",
"812894", "Utsunomiya\,\ Tochigi",
"81952", "Saga\,\ Saga",
"81286", "Utsunomiya\,\ Tochigi",
"8112398", "Kuriyama\,\ Hokkaido",
"819668", "Minamata\,\ Kumamoto",
"811735", "Goshogawara\,\ Aomori",
"811754", "Mutsu\,\ Aomori",
"811362", "Kutchan\,\ Hokkaido",
"817678", "Nanao\,\ Ishikawa",
"818677", "Niimi\,\ Okayama",
"812996", "Itako\,\ Ibaraki",
"812876", "Kuroiso\,\ Tochigi",
"8112391", "Yubari\,\ Hokkaido",
"81977", "Beppu\,\ Oita",
"8198290", "Nobeoka\,\ Miyazaki",
"812244", "Shiroishi\,\ Miyagi",
"81434", "Chiba\,\ Chiba",
"81776", "Fukui\,\ Fukui",
"819977", "Setouchi\,\ Kagoshima",
"814289", "Ome\,\ Tokyo",
"811537", "Nakashibetsu\,\ Hokkaido",
"817942", "Kakogawa\,\ Hyogo",
"81892", "Kumakogen\,\ Ehime",
"812693", "Nakano\,\ Nagano",
"81949", "Nogata\,\ Fukuoka",
"818807", "Sukumo\,\ Kochi",
"819554", "Imari\,\ Saga",
"817354", "Shingu\,\ Fukuoka",
"81244", "Hobara\,\ Fukushima",
"811376", "Yakumo\,\ Hokkaido",
"81172", "Hirosaki\,\ Aomori",
"818546", "Kakeya\,\ Shimane",
"812587", "Nagaoka\,\ Niigata",
"811233", "Chitose\,\ Hokkaido",
"81853", "Izumo\,\ Shimane",
"81863", "Tamano\,\ Okayama",
"81727", "Ikeda\,\ Osaka",
"819684", "Yamaga\,\ Kumamoto",
"81926", "Fukuoka\,\ Fukuoka",
"812657", "Ina\,\ Nagano",
"819543", "Takeo\,\ Saga",
"811975", "Mizusawa\,\ Iwate",
"812895", "Utsunomiya\,\ Tochigi",
"818698", "Bizen\,\ Okayama",
"8147955", "Yokaichiba\,\ Chiba",
"8124197", "Yanaizu\,\ Fukushima",
"811734", "Goshogawara\,\ Aomori",
"818796", "Tonosho\,\ Kagawa",
"817463", "Yoshino\,\ Nara",
"817702", "Tsuruga\,\ Fukui",
"81465", "Odawara\,\ Kanagawa",
"81542", "Shizuoka\,\ Shizuoka",
"812963", "Shimodate\,\ Ibaraki",
"818290", "Hiroshima\,\ Hiroshima",
"81236", "Yamagata\,\ Yamagata",
"818476", "Fuchu\,\ Hiroshima",
"81429", "Tokorozawa\,\ Saitama",
"814703", "Tateyama\,\ Chiba",
"818680", "Okayama\,\ Okayama",
"81468", "Yokosuka\,\ Kanagawa",
"819952", "Okuchi\,\ Kagoshima",
"818842", "Anan\,\ Tokushima",
"818205", "Yanai\,\ Yamaguchi",
"811862", "Kazuno\,\ Akita",
"815995", "Ago\,\ Mie",
"817683", "Wajima\,\ Ishikawa",
"819438", "Tanushimaru\,\ Fukuoka",
"812743", "Fujioka\,\ Gunma",
"811395", "Esashi\,\ Hokkaido",
"817613", "Komatsu\,\ Ishikawa",
"812672", "Komoro\,\ Nagano",
"812784", "Numata\,\ Gunma",
"8198297", "Hyuga\,\ Miyazaki",
"819787", "Kunisaki\,\ Oita",
"818836", "Mima\,\ Tokushima",
"812572", "Kashiwazaki\,\ Niigata",
"818955", "Uwajima\,\ Ehime",
"81998", "Kagoshima\,\ Kagoshima",
"812474", "Ishikawa\,\ Fukushima",
"817949", "Kakogawa\,\ Hyogo",
"819964", "Satsumasendai\,\ Kagoshima",
"811986", "Tono\,\ Iwate",
"814282", "Ome\,\ Tokyo",
"811854", "Oga\,\ Akita",
"812967", "Kasama\,\ Ibaraki",
"811956", "Iwate\,\ Iwate",
"8186996", "Seto\,\ Okayama",
"812794", "Shibukawa\,\ Gunma",
"81276", "Ota\,\ Gunma",
"819744", "Mie\,\ Oita",
"81227", "Sendai\,\ Miyagi",
"817687", "Noto\,\ Ishikawa",
"818688", "Mimasaka\,\ Okayama",
"812855", "Oyama\,\ Tochigi",
"812834", "Utsunomiya\,\ Tochigi",
"812747", "Tomioka\,\ Gunma",
"812936", "Mito\,\ Ibaraki",
"818298", "Hatsukaichi\,\ Hiroshima",
"817617", "Kaga\,\ Ishikawa",
"8175", "Kyoto\,\ Kyoto",
"81294", "Hitachiota\,\ Ibaraki",
"81950", "Hirado\,\ Nagasaki",
"817903", "Fukusaki\,\ Hyogo",
"818558", "Kawamoto\,\ Shimane",
"819783", "Bungotakada\,\ Oita",
"815985", "Matsusaka\,\ Mie",
"81744", "Yamatotakada\,\ Nara",
"81425", "Tachikawa\,\ Tokyo",
"81584", "Ogaki\,\ Gifu",
"8198299", "Hyuga\,\ Miyazaki",
"818690", "Okayama\,\ Okayama",
"812384", "Yonezawa\,\ Yamagata",
"818588", "Koge\,\ Tottori",
"819726", "Usuki\,\ Oita",
"811869", "Odate\,\ Akita",
"81282", "Tochigi\,\ Tochigi",
"81956", "Sasebo\,\ Nagasaki",
"818375", "Mine\,\ Yamaguchi",
"817963", "Toyooka\,\ Hyogo",
"818565", "Masuda\,\ Shimane",
"81937", "Kitakyushu\,\ Fukuoka",
"811545", "Kushiro\,\ Hokkaido",
"81474", "Funabashi\,\ Chiba",
"818874", "Aki\,\ Kochi",
"811533", "Nemuro\,\ Hokkaido",
"81823", "Kure\,\ Hiroshima",
"818665", "Takahashi\,\ Okayama",
"818246", "Miyoshi\,\ Hiroshima",
"811645", "Rumoi\,\ Hokkaido",
"8186552", "Kurashiki\,\ Okayama",
"81592", "Tsu\,\ Mie",
"818976", "Niihama\,\ Ehime",
"812697", "Iiyama\,\ Nagano",
"812553", "Joetsu\,\ Niigata",
"811237", "Kuriyama\,\ Hokkaido",
"812583", "Nagaoka\,\ Niigata",
"819938", "Kaseda\,\ Kagoshima",
"817714", "Kameoka\,\ Kyoto",
"81553", "Yamanashi\,\ Yamanashi",
"817735", "Fukuchiyama\,\ Kyoto",
"812679", "Saku\,\ Nagano",
"81563", "Nishio\,\ Aichi",
"81948", "Iizuka\,\ Fukuoka",
"81270", "Isesaki\,\ Gunma",
"819662", "Hitoyoshi\,\ Kumamoto",
"812544", "Shibata\,\ Niigata",
"812613", "Omachi\,\ Nagano",
"819547", "Kashima\,\ Saga",
"812653", "Iida\,\ Nagano",
"817672", "Hakui\,\ Ishikawa",
"811942", "Iwaizumi\,\ Iwate",
"81423", "Kokubunji\,\ Tokyo",
"815984", "Matsusaka\,\ Mie",
"817456", "Yamatotakada\,\ Nara",
"819733", "Hita\,\ Oita",
"812385", "Yonezawa\,\ Yamagata",
"817486", "Minakuchi\,\ Shiga",
"8153966", "Hamamatsu\,\ Shizuoka",
"81922", "Fukuoka\,\ Fukuoka",
"817722", "Miyazu\,\ Kyoto",
"817948", "Miki\,\ Hyogo",
"812835", "Sano\,\ Tochigi",
"812854", "Oyama\,\ Tochigi",
"818947", "Uwajima\,\ Ehime",
"81534", "Hamamatsu\,\ Shizuoka",
"812956", "Hitachi\-Omiya\,\ Ibaraki",
"81176", "Towada\,\ Aomori",
"811526", "Abashiri\,\ Hokkaido",
"818896", "Susaki\,\ Kochi",
"815763", "Gero\,\ Gifu",
"819965", "Satsumasendai\,\ Kagoshima",
"811855", "Noshiro\,\ Akita",
"818363", "Ube\,\ Yamaguchi",
"818559", "Kawamoto\,\ Shimane",
"819676", "Takamori\,\ Kumamoto",
"811936", "Miyako\,\ Iwate",
"812795", "Shibukawa\,\ Gunma",
"81896", "Iyomishima\,\ Ehime",
"815367", "Shitara\,\ Aichi",
"811354", "Yoichi\,\ Hokkaido",
"818299", "Hiroshima\,\ Hiroshima",
"812475", "Ishikawa\,\ Fukushima",
"819576", "Shimabara\,\ Nagasaki",
"8188098", "Tosashimizu\,\ Kochi",
"8125482", "Murakami\,\ Niigata",
"818689", "Okayama\,\ Okayama",
"8198293", "Nobeoka\,\ Miyazaki",
"81565", "Toyota\,\ Aichi",
"81561", "Seto\,\ Aichi",
"81182", "Yokote\,\ Akita",
"812545", "Murakami\,\ Niigata",
"818692", "Oku\,\ Okayama",
"81568", "Kasugai\,\ Aichi",
"814281", "Sagamihara\,\ Kanagawa",
"8112395", "Kuriyama\,\ Hokkaido",
"818592", "Yonago\,\ Tottori",
"811463", "Urakawa\,\ Hokkaido",
"8199331", "Kagoshima\,\ Kagoshima",
"817734", "Fukuchiyama\,\ Kyoto",
"81555", "Fujiyoshida\,\ Yamanashi",
"811868", "Takanosu\,\ Akita",
"817715", "Kameoka\,\ Kyoto",
"81551", "Nirasaki\,\ Yamanashi",
"819432", "Yame\,\ Fukuoka",
"81825", "Hiroshima\,\ Hiroshima",
"811553", "Obihiro\,\ Hokkaido",
"811644", "Rumoi\,\ Hokkaido",
"81546", "Shizuoka\,\ Shizuoka",
"818664", "Takahashi\,\ Okayama",
"814280", "Tachikawa\,\ Tokyo",
"812678", "Saku\,\ Nagano",
"812237", "Sendai\,\ Miyagi",
"817996", "Tsuna\,\ Hyogo",
"811583", "Monbetsu\,\ Hokkaido",
"81828", "Hiroshima\,\ Hiroshima",
"8182942", "Hiroshima\,\ Hiroshima",
"81987", "Nichinan\,\ Miyazaki",
"8126176", "Omachi\,\ Nagano",
"812578", "Muika\,\ Niigata",
"818374", "Nagato\,\ Yamaguchi",
"811544", "Kushiro\,\ Hokkaido",
"814756", "Togane\,\ Chiba",
"814298", "Hanno\,\ Saitama",
"818564", "Masuda\,\ Shimane",
"815582", "Shimoda\,\ Shizuoka",
"811653", "Shibetsu\,\ Hokkaido",
"811366", "Suttsu\,\ Hokkaido",
"8169", "Osaka\,\ Osaka",
"812387", "Nagai\,\ Yamagata",
"812992", "Ishioka\,\ Ibaraki",
"81833", "Kudamatsu\,\ Yamaguchi",
"812783", "Numata\,\ Gunma",
"815746", "Minokamo\,\ Gifu",
"81260", "Anan\,\ Nagano",
"8112392", "Yubari\,\ Hokkaido",
"819808", "Yaeyama\ District\,\ Okinawa",
"819936", "Kaseda\,\ Kagoshima",
"81885", "Komatsushima\,\ Tokushima",
"817614", "Komatsu\,\ Ishikawa",
"81726", "Ibaraki\,\ Osaka",
"81250", "Niitsu\,\ Niigata",
"817684", "Wajima\,\ Ishikawa",
"818945", "Yawatahama\,\ Ehime",
"817492", "Hikone\,\ Shiga",
"812837", "Sano\,\ Tochigi",
"812744", "Fujioka\,\ Gunma",
"81888", "Kochi\,\ Kochi",
"81927", "Fukuoka\,\ Fukuoka",
"819747", "Taketa\,\ Oita",
"814704", "Tateyama\,\ Chiba",
"812797", "Shibukawa\,\ Gunma",
"815732", "Ena\,\ Gifu",
"818978", "Hakata\,\ Ehime",
"812964", "Shimodate\,\ Ibaraki",
"811857", "Noshiro\,\ Akita",
"818248", "Shobara\,\ Hiroshima",
"819967", "Izumi\,\ Kagoshima",
"8144", "Kawasaki\,\ Kanagawa",
"81464", "Atsugi\,\ Kanagawa",
"811733", "Goshogawara\,\ Aomori",
"817464", "Yoshino\,\ Nara",
"8153969", "Hamamatsu\,\ Shizuoka",
"812477", "Miharu\,\ Fukushima",
"811337", "Ishikari\,\ Hokkaido",
"8153978", "Hamamatsu\,\ Shizuoka",
"819728", "Usuki\,\ Oita",
"818586", "Kurayoshi\,\ Tottori",
"819544", "Takeo\,\ Saga",
"8126179", "Omachi\,\ Nagano",
"812547", "Murakami\,\ Niigata",
"81245", "Fukushima\,\ Fukushima",
"811939", "Miyako\,\ Iwate",
"819679", "Takamori\,\ Kumamoto",
"818556", "Gotsu\,\ Shimane",
"813", "Tokyo",
"819683", "Yamaga\,\ Kumamoto",
"818296", "Hiroshima\,\ Hiroshima",
"81798", "Nishinomiya\,\ Hyogo",
"817717", "Sonobe\,\ Kyoto",
"819822", "Nobeoka\,\ Miyazaki",
"812562", "Sanjo\,\ Niigata",
"812938", "Mito\,\ Ibaraki",
"811234", "Chitose\,\ Hokkaido",
"818656", "Kasaoka\,\ Okayama",
"8186993", "Bizen\,\ Okayama",
"819553", "Imari\,\ Saga",
"812647", "Nagano\,\ Nagano",
"817353", "Shingu\,\ Fukuoka",
"818686", "Tsuyama\,\ Okayama",
"812372", "Murayama\,\ Yamagata",
"812482", "Shirakawa\,\ Fukushima",
"81266", "Suwa\,\ Nagano",
"812694", "Nakano\,\ Nagano",
"811958", "Iwate\,\ Iwate",
"814792", "Choshi\,\ Chiba",
"812235", "Sendai\,\ Miyagi",
"8125485", "Tsugawa\,\ Niigata",
"812412", "Kitakata\,\ Fukushima",
"81438", "Kisarazu\,\ Chiba",
"818466", "Mima\,\ Tokushima",
"817912", "Aioi\,\ Hyogo",
"81143", "Muroran\,\ Hokkaido",
"8199345", "Kagoshima\,\ Kagoshima",
"817952", "Nishiwaki\,\ Hyogo",
"819597", "Fukue\,\ Nagasaki",
"812243", "Shiroishi\,\ Miyagi",
"818398", "Ogori\,\ Yamaguchi",
"811753", "Mutsu\,\ Aomori",
"814758", "Togane\,\ Chiba",
"8198296", "Hyuga\,\ Miyazaki",
"817465", "Yoshino\,\ Nara",
"812893", "Utsunomiya\,\ Tochigi",
"817950", "Sanda\,\ Hyogo",
"818832", "Kamojima\,\ Tokushima",
"812576", "Tokamachi\,\ Niigata",
"811357", "Iwanai\,\ Hokkaido",
"815752", "Sekigahara\,\ Gifu",
"817998", "Tsuna\,\ Hyogo",
"818382", "Hagi\,\ Yamaguchi",
"814705", "Tateyama\,\ Chiba",
"812676", "Saku\,\ Nagano",
"815993", "Toba\,\ Mie",
"818203", "Yanai\,\ Yamaguchi",
"819809", "Yaeyama\ District\,\ Okinawa",
"812965", "Shimodate\,\ Ibaraki",
"817615", "Komatsu\,\ Ishikawa",
"819956", "Kajiki\,\ Kagoshima",
"811866", "Takanosu\,\ Akita",
"81199", "Morioka\,\ Iwate",
"812745", "Fujioka\,\ Gunma",
"812857", "Mooka\,\ Tochigi",
"818944", "Yawatahama\,\ Ehime",
"817685", "Wajima\,\ Ishikawa",
"811393", "Matsumae\,\ Hokkaido",
"812560", "Itoigawa\,\ Niigata",
"8186999", "Seto\,\ Okayama",
"8126173", "Omachi\,\ Nagano",
"818953", "Uwajima\,\ Ehime",
"81835", "Hofu\,\ Yamaguchi",
"818249", "Higashi\-ku\,\ Hiroshima",
"817706", "Obama\,\ Fukui",
"81578", "Kamioka\,\ Akita",
"81222", "Sendai\,\ Miyagi",
"8124196", "Yanaizu\,\ Fukushima",
"815392", "Hamamatsu\,\ Shizuoka",
"81762", "Kanazawa\,\ Ishikawa",
"81485", "Kumagaya\,\ Saitama",
"811547", "Shiranuka\,\ Hokkaido",
"818567", "Tsuwano\,\ Shimane",
"819940", "Shibushi\,\ Kagoshima",
"81488", "Urawa\,\ Saitama",
"818377", "Shimonoseki\,\ Yamaguchi",
"812939", "Mito\,\ Ibaraki",
"819578", "Shimabara\,\ Nagasaki",
"8153971", "Hamamatsu\,\ Shizuoka",
"811938", "Miyako\,\ Iwate",
"811562", "Honbetsu\,\ Hokkaido",
"812695", "Nakano\,\ Nagano",
"818542", "Yasugi\,\ Shimane",
"81433", "Chiba\,\ Chiba",
"812234", "Sendai\,\ Miyagi",
"811647", "Haboro\,\ Hokkaido",
"818667", "Ibara\,\ Okayama",
"81932", "Kitakyushu\,\ Fukuoka",
"818493", "Onomichi\,\ Hiroshima",
"811372", "Shikabe\,\ Hokkaido",
"81166", "Asahikawa\,\ Hokkaido",
"817737", "Maizuru\,\ Kyoto",
"81864", "Kurashiki\,\ Okayama",
"811528", "Bihoro\,\ Hokkaido",
"815972", "Owase\,\ Mie",
"811235", "Yubari\,\ Hokkaido",
"811452", "Hayakita\,\ Hokkaido",
"81793", "Himeji\,\ Hyogo",
"817946", "Miki\,\ Hyogo",
"811973", "Mizusawa\,\ Iwate",
"81243", "Nihonmatsu\,\ Fukushima",
"817488", "Minakuchi\,\ Shiga",
"812872", "Otawara\,\ Tochigi",
"818263", "Kake\,\ Hiroshima",
"811543", "Kushiro\,\ Hokkaido",
"818563", "Masuda\,\ Shimane",
"81126", "Iwamizawa\,\ Hokkaido",
"814240", "Kokubunji\,\ Tokyo",
"812998", "Itako\,\ Ibaraki",
"819975", "Naze\,\ Kagoshima",
"811654", "Nayoro\,\ Hokkaido",
"811635", "Hamatonbetsu\,\ Hokkaido",
"817676", "Nanao\,\ Ishikawa",
"819802", "Minamidaito\,\ Okinawa",
"817965", "Toyooka\,\ Hyogo",
"818373", "Nagato\,\ Yamaguchi",
"819666", "Minamata\,\ Kumamoto",
"811584", "Engaru\,\ Hokkaido",
"817366", "Iwade\,\ Wakayama",
"819233", "Maebaru\,\ Fukuoka",
"817498", "Nagahama\,\ Shiga",
"811535", "Akkeshi\,\ Hokkaido",
"811554", "Obihiro\,\ Hokkaido",
"81473", "Ichikawa\,\ Chiba",
"818663", "Soja\,\ Okayama",
"8178", "Kobe\,\ Hyogo",
"815738", "Nakatsugawa\,\ Gifu",
"81564", "Okazaki\,\ Aichi",
"811464", "Shizunai\,\ Hokkaido",
"812585", "Nagaoka\,\ Niigata",
"81722", "Sakai\,\ Osaka",
"817733", "Fukuchiyama\,\ Kyoto",
"818972", "Niihama\,\ Ehime",
"81489", "Soka\,\ Saitama",
"812555", "Itoigawa\,\ Niigata",
"818242", "Higashi\-ku\,\ Hiroshima",
"811977", "Kitakami\,\ Iwate",
"8186691", "Kurashiki\,\ Okayama",
"8125481", "Murakami\,\ Niigata",
"818479", "Tojo\,\ Hiroshima",
"812655", "Iida\,\ Nagano",
"812615", "Omachi\,\ Nagano",
"819948", "Shibushi\,\ Kagoshima",
"81177", "Aomori\,\ Aomori",
"812911", "Hokota\,\ Ibaraki",
"819722", "Saiki\,\ Oita",
"81554", "Otsuki\,\ Yamanashi",
"81547", "Shimada\,\ Shizuoka",
"818674", "Kuse\,\ Okayama",
"811757", "Noheji\,\ Aomori",
"81986", "Miyakonojo\,\ Miyazaki",
"81252", "Niigata\,\ Niigata",
"811353", "Yoichi\,\ Hokkaido",
"812897", "Kanuma\,\ Tochigi",
"81191", "Ichinoseki\,\ Iwate",
"818364", "Ube\,\ Yamaguchi",
"815997", "Ago\,\ Mie",
"819828", "Takachiho\,\ Miyazaki",
"81839", "Yamaguchi\,\ Yamaguchi",
"812932", "Takahagi\,\ Ibaraki",
"81262", "Nagano\,\ Nagano",
"815764", "Gero\,\ Gifu",
"812378", "Sagae\,\ Yamagata",
"81583", "Gifu\,\ Gifu",
"811952", "Ninohe\,\ Iwate",
"81743", "Nara\,\ Nara",
"812879", "Nasukarasuyama\,\ Tochigi",
"812488", "Sukagawa\,\ Fukushima",
"817905", "Fukusaki\,\ Hyogo",
"8182941", "Hiroshima\,\ Hiroshima",
"8182920", "Hatsukaichi\,\ Hiroshima",
"814798", "Yokaichiba\,\ Chiba",
"8186997", "Seto\,\ Okayama",
"811397", "Okushiri\,\ Hokkaido",
"811982", "Hanamaki\,\ Iwate",
"814286", "Sagamihara\,\ Kanagawa",
"812853", "Oyama\,\ Tochigi",
"819734", "Hita\,\ Oita",
"81531", "Tahara\,\ Aichi",
"81878", "Takamatsu\,\ Kagawa",
"818957", "Misho\,\ Ehime",
"81535", "Hamamatsu\,\ Shizuoka",
"811878", "Omagari\,\ Akita",
"815983", "Matsusaka\,\ Mie",
"819785", "Bungotakada\,\ Oita",
"81538", "Iwata\,\ Shizuoka",
"815979", "Kumano\,\ Mie",
"81875", "Kan\'onji\,\ Kagawa",
"81226", "Kesennuma\,\ Miyagi",
"814752", "Mobara\,\ Chiba",
"81439", "Kisarazu\,\ Chiba",
"812543", "Shibata\,\ Niigata",
"815586", "Shimoda\,\ Shizuoka",
"812614", "Omachi\,\ Nagano",
"81930", "Yukuhashi\,\ Fukuoka",
"812654", "Iida\,\ Nagano",
"819687", "Tamana\,\ Kumamoto",
"8164", "Osaka\,\ Osaka",
"812584", "Nagaoka\,\ Niigata",
"818388", "Tamagawa\,\ Yamaguchi",
"817992", "Sumoto\,\ Hyogo",
"811465", "Shizunai\,\ Hokkaido",
"817713", "Kameoka\,\ Kyoto",
"817357", "Kushimoto\,\ Wakayama",
"812554", "Joetsu\,\ Niigata",
"812999", "Itako\,\ Ibaraki",
"8153975", "Hamamatsu\,\ Shizuoka",
"819557", "Karatsu\,\ Saga",
"81944", "Setaka\,\ Fukuoka",
"811585", "Engaru\,\ Hokkaido",
"81249", "Koriyama\,\ Fukushima",
"818391", "Ogori\,\ Yamaguchi",
"81478", "Sawara\,\ Chiba",
"818873", "Aki\,\ Kochi",
"811555", "Obihiro\,\ Hokkaido",
"811534", "Nakashibetsu\,\ Hokkaido",
"818478", "Tojo\,\ Hiroshima",
"812930", "Mito\,\ Ibaraki",
"818596", "Yonago\,\ Tottori",
"81471", "Kashiwa\,\ Chiba",
"8112394", "Yubari\,\ Hokkaido",
"818696", "Bizen\,\ Okayama",
"818798", "Tonosho\,\ Kagawa",
"811634", "Hamatonbetsu\,\ Hokkaido",
"819974", "Yakushima\,\ Kagoshima",
"811655", "Nayoro\,\ Hokkaido",
"812247", "Ogawara\,\ Miyagi",
"81277", "Kiryu\,\ Gunma",
"815398", "Hamamatsu\,\ Shizuoka",
"817964", "Toyooka\,\ Hyogo",
"819593", "Oseto\,\ Nagasaki",
"8186698", "Kurashiki\,\ Okayama",
"819735", "Hita\,\ Oita",
"812383", "Yonezawa\,\ Yamagata",
"81533", "Toyohashi\,\ Aichi",
"81298", "Tsuchiura\,\ Ibaraki",
"8125488", "Tsugawa\,\ Niigata",
"819784", "Bungotakada\,\ Oita",
"812787", "Numata\,\ Gunma",
"819572", "Isahaya\,\ Nagasaki",
"814777", "Funabashi\,\ Chiba",
"818240", "Higashi\-ku\,\ Hiroshima",
"81585", "Ibigawa\,\ Gifu",
"811932", "Kamaishi\,\ Iwate",
"81162", "Wakkanai\,\ Hokkaido",
"817904", "Fukusaki\,\ Hyogo",
"818892", "Sakawa\,\ Kochi",
"819743", "Mie\,\ Oita",
"811378", "Imakane\,\ Hokkaido",
"812833", "Utsunomiya\,\ Tochigi",
"818365", "Ube\,\ Yamaguchi",
"81737", "Yuasa\,\ Wakayama",
"815978", "Kumano\,\ Mie",
"812793", "Shibukawa\,\ Gunma",
"811522", "Shari\,\ Hokkaido",
"815765", "Gero\,\ Gifu",
"819963", "Satsumasendai\,\ Kagoshima",
"817959", "Sanda\,\ Hyogo",
"81936", "Kitakyushu\,\ Fukuoka",
"811853", "Oga\,\ Akita",
"818675", "Kuse\,\ Okayama",
"812419", "Tajima\,\ Fukushima",
"817482", "Yokaichi\,\ Shiga",
"8126170", "Omachi\,\ Nagano",
"81766", "Takaoka\,\ Toyama",
"811946", "Kuji\,\ Iwate",
"811333", "Tobetsu\,\ Hokkaido",
"812878", "Nasukarasuyama\,\ Tochigi",
"812489", "Sukagawa\,\ Fukushima",
"812473", "Ishikawa\,\ Fukushima",
"8153967", "Hamamatsu\,\ Shizuoka",
"817452", "Yamatotakada\,\ Nara",};
$areanames{ja} = {"815988", "三瀬谷",
"81738", "御坊",
"819969", "中甑",
"818585", "倉吉",
"812890", "宇都宮",
"81420", "所沢",
"81965", "八代",
"817472", "五条",
"818685", "津山",
"817944", "加古川",
"818295", "廿日市",
"819552", "伊万里",
"81779", "大野",
"819823", "延岡",
"812563", "三条",
"8183767", "下関",
"81495", "本庄",
"81946", "甘木",
"819943", "鹿屋",
"815745", "美濃加茂",
"81934", "北九州",
"817487", "水口",
"811732", "五所川原",
"817704", "敦賀",
"819935", "加世田",
"815733", "恵那",
"818490", "尾道",
"811527", "美幌",
"819599", "大瀬戸",
"812957", "大子",
"817738", "舞鶴",
"8128798", "大田原",
"81852", "松江",
"812549", "津川",
"814228", "武蔵野三鷹",
"812674", "小諸",
"814772", "市川",
"812782", "沼田",
"818378", "下関",
"8112397", "栗山",
"812574", "柏崎",
"812649", "長野",
"81862", "岡山",
"812993", "石岡",
"812478", "三春",
"81992", "鹿児島",
"81566", "刈谷",
"81849", "福山",
"812780", "前橋",
"812859", "小山",
"8188093", "窪川",
"811453", "早来",
"814770", "市川",
"815959", "亀山",
"81877", "丸亀",
"812798", "長野原",
"817945", "加古川",
"818684", "津山",
"812838", "佐野",
"811563", "本別",
"818294", "廿日市",
"818543", "安来",
"81545", "富士",
"8186994", "岡山瀬戸",
"81462", "厚木",
"818514", "海士",
"818584", "倉吉",
"812388", "長井",
"815562", "鰍沢青柳",
"818397", "小郡",
"812575", "十日町",
"815393", "浜松",
"818952", "宇和島",
"817466", "十津川",
"818878", "嶺北",
"811392", "木古内",
"812675", "佐久",
"811957", "岩手",
"81178", "八戸",
"81984", "小林",
"811549", "釧路",
"812746", "富岡",
"81273", "高崎",
"819934", "指宿",
"815992", "鳥羽",
"818202", "柳井",
"817718", "園部",
"815744", "美濃加茂",
"812892", "宇都宮",
"818669", "総社",
"817705", "小浜",
"811944", "岩泉",
"815982", "松阪",
"81183", "湯沢",
"818797", "土庄",
"817724", "宮津",
"818477", "東城",
"811983", "花巻",
"8186992", "備前",
"81138", "函館",
"8147950", "八日市場",
"819558", "唐津",
"814285", "相模原",
"81591", "津",
"812933", "高萩",
"815757", "郡上八幡",
"818387", "田万川",
"81487", "浦和",
"817906", "播磨山崎",
"81233", "新庄",
"81179", "三戸",
"819786", "杵築",
"818837", "阿波池田",
"81288", "今市",
"81281", "宇都宮",
"819723", "佐伯",
"812877", "黒磯",
"819665", "人吉",
"8112393", "夕張",
"811738", "鰺ケ沢",
"818694", "岡山",
"817675", "七尾",
"818243", "東広島",
"818594", "米子",
"8198295", "日向",
"815977", "熊野",
"812830", "宇都宮",
"817732", "福知山",
"818973", "新居浜",
"814222", "武蔵野三鷹",
"811377", "八雲",
"812556", "糸魚川",
"81848", "尾道",
"812788", "前橋",
"819803", "名護",
"818372", "長門",
"812656", "伊那",
"811332", "当別",
"812472", "石川",
"817453", "大和高田",
"814284", "立川",
"812979", "竜ケ崎",
"81593", "四日市",
"812913", "鉾田",
"814220", "国分寺",
"812792", "渋川",
"81822", "広島",
"819742", "三重",
"817725", "宮津",
"811541", "弟子屈",
"812832", "佐野",
"817497", "長浜",
"818366", "宇部",
"811933", "釜石",
"819673", "熊本一の宮",
"81188", "秋田",
"8125486", "津川",
"811945", "久慈",
"819573", "諫早",
"812382", "米沢",
"8188097", "土佐清水",
"811877", "大曲",
"81778", "武生",
"818958", "御荘",
"817957", "丹波柏原",
"818872", "室戸",
"812417", "会津山口",
"811398", "熊石",
"814797", "八日市場",
"811466", "えりも",
"812487", "須賀川",
"812377", "寒河江",
"811556", "帯広",
"818595", "米子",
"817993", "洲本",
"81739", "田辺",
"817712", "亀岡",
"818208", "久賀",
"815998", "阿児",
"81925", "福岡",
"81460", "小田原",
"812898", "鹿沼",
"819664", "人吉",
"818695", "岡山瀬戸",
"814753", "茂原",
"811656", "美深",
"817674", "羽咋",
"81985", "宮崎",
"811559", "帯広",
"811363", "倶知安",
"81196", "盛岡",
"8112396", "栗山",
"812618", "大町",
"81827", "岩国",
"81763", "福野",
"818834", "鴨島",
"815754", "関",
"818384", "萩",
"812588", "長岡",
"815362", "新城",
"8186553", "倉敷",
"81432", "千葉",
"818808", "土佐清水",
"811538", "根室標津",
"817495", "長浜",
"818942", "八幡浜",
"817727", "峰山",
"818474", "府中",
"819978", "徳之島",
"811638", "利尻礼文",
"818794", "三本松",
"81242", "会津若松",
"8153977", "天竜",
"811947", "久慈",
"817968", "浜坂",
"817955", "三田",
"8183766", "下関",
"811875", "角館",
"818553", "浜田",
"818369", "宇部",
"81544", "富士宮",
"819686", "玉名",
"812485", "白河",
"812232", "岩沼",
"814795", "銚子",
"812415", "柳津",
"817356", "串本",
"814700", "鴨川",
"811374", "森",
"815974", "尾鷲",
"818597", "根雨",
"812375", "村山",
"818463", "竹原",
"812976", "竜ケ崎",
"818697", "備前",
"812874", "大田原",
"812246", "大河原",
"812559", "安塚",
"811756", "野辺地",
"818795", "三本松",
"817612", "小松",
"811588", "興部",
"817682", "輪島",
"817494", "彦根",
"81586", "一宮",
"812659", "伊那",
"818475", "府中",
"814702", "館山",
"818385", "萩",
"815755", "関",
"819953", "大口",
"81935", "北九州",
"818843", "阿南",
"811863", "鹿角",
"814287", "青梅",
"812230", "仙台",
"812962", "下館",
"8161", "大阪",
"81729", "八尾",
"81142", "伊達",
"81482", "川口",
"818835", "脇町",
"817238", "寝屋川",
"818678", "新見",
"819542", "武雄",
"817677", "七尾",
"81228", "築館",
"819667", "水俣",
"81832", "下関",
"812875", "大田原",
"819789", "杵築",
"81259", "佐渡",
"811232", "千歳",
"81494", "秩父",
"815768", "下呂",
"812374", "村山",
"81427", "相模原",
"812484", "白河",
"812692", "中野",
"814794", "銚子",
"812414", "柳津",
"811375", "八雲",
"8125483", "村上",
"81964", "松橋",
"81740", "今津",
"811976", "北上",
"817954", "西脇",
"811874", "角館",
"818266", "千代田",
"811546", "釧路",
"812612", "大町",
"815368", "設楽",
"812582", "長岡",
"81924", "福岡",
"817363", "和歌山橋本",
"811646", "羽幌",
"818802", "窪川",
"818666", "井原",
"81268", "上田",
"818948", "宇和",
"811532", "根室",
"817947", "三木",
"81229", "古川",
"811632", "天塩",
"819972", "種子島",
"81467", "藤沢",
"817962", "豊岡",
"817230", "寝屋川",
"811551", "十勝池田",
"814297", "飯能",
"811356", "岩内",
"812577", "六日町",
"811955", "二戸",
"812238", "仙台",
"812677", "佐久",
"81728", "寝屋川",
"818894", "須崎",
"81721", "富田林",
"81240", "磐城富岡",
"811524", "網走",
"8186998", "岡山瀬戸",
"812856", "真岡",
"81975", "大分",
"815956", "上野",
"817707", "小浜",
"817484", "八日市",
"815583", "下田",
"812546", "村上",
"818587", "郡家",
"814996", "八丈島",
"81253", "新潟",
"811582", "紋別",
"817618", "加賀",
"818297", "廿日市",
"819433", "八女",
"81263", "松本",
"818687", "美作",
"817688", "能都",
"812646", "長野",
"814708", "大原",
"812968", "笠間",
"81742", "奈良",
"8152", "名古屋",
"819596", "福江",
"8125487", "津川",
"812551", "上越",
"817960", "八鹿",
"818672", "福渡",
"817485", "八日市",
"8188096", "土佐清水",
"815747", "美濃白川",
"812955", "常陸大宮",
"811525", "網走",
"819937", "加世田",
"811238", "栗山",
"815762", "下呂",
"812698", "飯山",
"811954", "二戸",
"81480", "久喜",
"819966", "出水",
"818895", "須崎",
"812580", "十日町",
"81723", "堺",
"811856", "能代",
"81857", "鳥取",
"815392", "浜松",
"81835", "防府",
"815957", "上野",
"817706", "小浜",
"81578", "神岡",
"818953", "宇和島",
"811393", "松前",
"812560", "糸魚川",
"8186999", "岡山瀬戸",
"812745", "藤岡",
"81199", "盛岡",
"812857", "真岡",
"815993", "鳥羽",
"818203", "柳井",
"817998", "津名",
"812676", "佐久",
"812576", "十日町",
"811357", "岩内",
"812893", "宇都宮",
"817465", "吉野",
"814758", "東金",
"8198296", "日向",
"817458", "大和榛原",
"817946", "三木",
"811452", "早来",
"81793", "姫路",
"81166", "旭川",
"81864", "倉敷",
"818493", "尾道",
"811647", "羽幌",
"81932", "北九州",
"818667", "井原",
"819678", "矢部",
"811562", "本別",
"811938", "宮古",
"818542", "安来",
"819578", "島原",
"8153963", "天竜",
"811547", "白糠",
"818567", "津和野",
"819940", "志布志",
"815563", "鰍沢青柳",
"81485", "熊谷",
"819728", "臼杵",
"819942", "大根占",
"817464", "吉野",
"8144", "川崎",
"81464", "厚木",
"811733", "五所川原",
"819967", "出水",
"818248", "庄原",
"811857", "能代",
"818978", "伯方",
"815732", "恵那",
"81927", "福岡",
"812744", "藤岡",
"81726", "茨木",
"819936", "加世田",
"81885", "小松島",
"819808", "八重山",
"812783", "沼田",
"815746", "美濃加茂",
"812992", "石岡",
"819597", "福江",
"817912", "相生",
"817473", "五条",
"8125485", "津川",
"81266", "諏訪",
"818686", "津山",
"812647", "長野",
"819553", "伊万里",
"818296", "広島",
"81798", "西宮",
"812938", "水戸",
"819822", "延岡",
"812562", "三条",
"81245", "福島",
"812547", "村上",
"818586", "倉吉",
"815398", "浜松",
"812247", "大河原",
"811655", "名寄",
"812977", "竜ケ崎",
"818696", "備前",
"812930", "水戸",
"818596", "米子",
"818873", "安芸",
"811555", "帯広",
"818391", "小郡",
"817357", "串本",
"812554", "上越",
"817713", "亀岡",
"811465", "静内",
"817992", "洲本",
"819687", "玉名",
"8164", "大阪",
"81930", "行橋",
"812654", "飯田",
"814752", "茂原",
"81226", "気仙沼",
"8126177", "長野",
"812473", "石川",
"817452", "大和高田",
"811333", "当別",
"811946", "久慈",
"812489", "須賀川",
"81766", "高岡",
"812419", "田島",
"817959", "三田",
"817726", "峰山",
"812793", "渋川",
"818365", "宇部",
"812833", "宇都宮",
"819743", "三重",
"817904", "福崎",
"81581", "高富",
"818548", "石見大田",
"818240", "東広島",
"81424", "武蔵野三鷹",
"811932", "釜石",
"819672", "熊本一の宮",
"819572", "諫早",
"819784", "豊後高田",
"81298", "土浦",
"81533", "豊橋",
"8186698", "倉敷",
"819735", "日田",
"812383", "米沢",
"819722", "佐伯",
"819948", "志布志",
"818267", "千代田",
"818479", "東城",
"812655", "飯田",
"811977", "北上",
"8186691", "倉敷",
"818242", "東広島",
"812555", "糸魚川",
"817733", "福知山",
"818972", "新居浜",
"8178", "神戸",
"815738", "中津川",
"811464", "静内",
"811554", "帯広",
"814223", "武蔵野三鷹",
"819802", "南大東",
"818373", "長門",
"819666", "水俣",
"811654", "名寄",
"812998", "潮来",
"817676", "七尾",
"814240", "国分寺",
"81126", "岩見沢",
"81538", "磐田",
"81875", "観音寺",
"815979", "熊野",
"815983", "松阪",
"819785", "豊後高田",
"81531", "田原",
"819734", "日田",
"814286", "相模原",
"811982", "花巻",
"817905", "福崎",
"8182941", "広島",
"81583", "岐阜",
"812879", "烏山",
"818364", "宇部",
"819828", "高千穂",
"812568", "巻",
"812932", "高萩",
"81191", "一関",
"811757", "野辺地",
"81547", "島田",
"811975", "水沢",
"819543", "武雄",
"812657", "伊那",
"819684", "山鹿",
"818265", "安芸吉田",
"811233", "千歳",
"817354", "新宮",
"81244", "原町",
"812557", "新井",
"811376", "八雲",
"81892", "久万",
"812693", "中野",
"81949", "直方",
"812974", "水海道",
"814289", "青梅",
"81776", "福井",
"812244", "白石",
"81434", "千葉",
"812876", "黒磯",
"81977", "別府",
"815588", "修善寺大仁",
"819787", "国東",
"818836", "脇町",
"8198297", "日向",
"817613", "小松",
"815756", "郡上八幡",
"817907", "播磨山崎",
"817683", "輪島",
"819438", "田主丸",
"818842", "阿南",
"811862", "鹿角",
"814703", "館山",
"819952", "大口",
"81236", "山形",
"818476", "府中",
"81465", "小田原",
"81542", "静岡",
"812963", "下館",
"818796", "土庄",
"812975", "水海道",
"81559", "沼津",
"812245", "大河原",
"818552", "浜田",
"812571", "六日町",
"818652", "倉敷",
"812233", "岩沼",
"81144", "苫小牧",
"812376", "寒河江",
"81569", "半田",
"811557", "十勝池田",
"814291", "飯能",
"81484", "川口",
"814796", "八日市場",
"8188095", "土佐清水",
"812486", "須賀川",
"817355", "新宮",
"812416", "田島",
"811974", "水沢",
"817956", "三田",
"818462", "竹原",
"818264", "安芸吉田",
"819685", "玉名",
"811876", "大曲",
"811754", "むつ",
"811362", "倶知安",
"81952", "佐賀",
"81286", "宇都宮",
"81962", "熊本",
"818367", "宇部",
"81596", "伊勢",
"817368", "岩出",
"815363", "新城",
"817496", "長浜",
"81834", "徳山",
"818943", "八幡浜",
"819737", "玖珠",
"81492", "川越",
"818689", "岡山",
"818673", "福渡",
"811354", "余市",
"818299", "広島",
"811855", "能代",
"818896", "須崎",
"815763", "下呂",
"819965", "川内",
"81176", "十和田",
"811526", "網走",
"812956", "常陸大宮",
"812854", "小山",
"817486", "水口",
"81922", "福岡",
"815954", "上野",
"819208", "対馬佐賀",
"811544", "釧路",
"818564", "益田",
"815582", "下田",
"819595", "有川",
"8182942", "広島",
"81987", "日南",
"811583", "紋別",
"811644", "留萌",
"818664", "高梁",
"81825", "広島",
"819432", "八女",
"811868", "鷹巣",
"818848", "牟岐",
"81551", "韮崎",
"812645", "木曾福島",
"8112395", "栗山",
"814281", "相模原",
"812545", "村上",
"81568", "春日井",
"8198293", "延岡",
"81561", "瀬戸",
"815955", "上野",
"818558", "川本",
"81425", "立川",
"81744", "大和高田",
"8175", "京都",
"81950", "平戸",
"812855", "小山",
"812747", "富岡",
"81276", "太田",
"811956", "岩手",
"811854", "男鹿",
"819964", "川内",
"817949", "加古川",
"814994", "三宅",
"812613", "大町",
"812544", "新発田",
"81948", "飯塚",
"812679", "佐久",
"81563", "西尾",
"812579", "小出",
"817362", "和歌山橋本",
"81553", "山梨",
"812583", "長岡",
"818803", "土佐中村",
"812644", "木曾福島",
"818665", "高梁",
"811645", "留萌",
"811533", "根室",
"81474", "船橋",
"819973", "種子島",
"818565", "益田",
"81937", "北九州",
"811545", "釧路",
"817963", "豊岡",
"819594", "有川",
"818555", "江津",
"8112390", "夕張",
"811873", "角館",
"81958", "長崎",
"8198291", "延岡",
"812799", "長野原",
"812242", "白石",
"815958", "亀山",
"812972", "水海道",
"817953", "西脇",
"812413", "喜多方",
"81929", "福岡",
"812858", "真岡",
"812483", "白河",
"814793", "銚子",
"818655", "鴨方",
"81543", "静岡",
"812389", "米沢",
"817352", "新宮",
"812373", "村山",
"812236", "仙台",
"817997", "津名",
"819682", "山鹿",
"812839", "佐野",
"814757", "東金",
"81587", "一宮",
"817457", "大和高田",
"811365", "倶知安",
"818879", "室戸",
"8163", "大阪",
"818946", "宇和",
"81893", "大洲",
"819954", "加治木",
"818844", "阿南",
"812917", "水戸",
"81764", "富山",
"811864", "大館",
"81940", "宗像",
"817493", "彦根",
"818668", "井原",
"811648", "焼尻",
"815366", "設楽",
"811937", "宮古",
"819677", "矢部",
"819577", "島原",
"8188099", "土佐清水",
"818568", "津和野",
"811548", "弟子屈",
"81426", "八王子",
"819204", "郷ノ浦",
"819727", "臼杵",
"812873", "大田原",
"818262", "加計",
"81493", "東松山",
"818464", "竹原",
"811972", "水沢",
"819968", "出水",
"818247", "庄原",
"811858", "能代",
"818977", "伯方",
"812696", "飯山",
"81537", "掛川",
"815973", "尾鷲",
"81963", "熊本",
"81548", "榛原",
"81124", "芦別",
"811236", "千歳",
"818654", "鴨方",
"819807", "沖縄宮古",
"818554", "浜田",
"814771", "市川",
"819546", "鹿島",
"819598", "福江",
"818793", "三本松",
"819205", "厳原",
"818473", "甲山",
"811987", "遠野",
"814706", "大原",
"817686", "能都",
"812648", "長野",
"817616", "小松",
"819955", "加治木",
"815753", "関",
"818383", "萩",
"81898", "今治",
"811865", "大館",
"812937", "水戸",
"818845", "丹生谷",
"8168", "大阪",
"8198298", "日向",
"818833", "鴨島",
"811752", "むつ",
"811364", "倶知安",
"814229", "武蔵野三鷹",
"81550", "御殿場",
"814998", "小笠原",
"81942", "久留米",
"81899", "松山",
"815397", "浜松",
"812248", "大河原",
"815952", "上野",
"812978", "竜ケ崎",
"812852", "小山",
"811953", "二戸",
"812640", "長野",
"811352", "余市",
"819688", "玉名",
"81923", "福岡",
"817966", "八鹿",
"81549", "静岡",
"819976", "名瀬",
"811636", "北見枝幸",
"81577", "高山",
"811536", "厚岸",
"811457", "門別富川",
"817365", "和歌山橋本",
"819434", "八女",
"811642", "石狩深川",
"818806", "宿毛",
"818662", "高梁",
"812586", "長岡",
"812899", "鹿沼",
"811567", "十勝清水",
"8147957", "八日市場",
"819232", "前原",
"818547", "掛合",
"81845", "因島",
"815999", "津",
"811542", "釧路",
"818562", "益田",
"815584", "下田",
"812616", "大町",
"8153962", "天竜",
"818268", "千代田",
"819947", "志布志",
"817483", "八日市",
"811978", "北上",
"819962", "川内",
"811852", "男鹿",
"81466", "藤沢",
"8167", "大阪",
"818660", "岡山瀬戸",
"81235", "鶴岡",
"815737", "中津川",
"811523", "斜里",
"818893", "佐川",
"815766", "下呂",
"81552", "甲府",
"8112399", "栗山",
"81797", "西宮",
"818676", "久世",
"812997", "潮来",
"81724", "岸和田貝塚",
"81562", "尾張横須賀",
"81775", "大津",
"819592", "大瀬戸",
"817917", "竜野",
"815585", "下田",
"8188090", "窪川",
"819435", "八女",
"812642", "木曾福島",
"811586", "中湧別",
"812789", "前橋",
"817364", "和歌山橋本",
"819827", "高千穂",
"812567", "巻",
"81969", "天草",
"81928", "福岡",
"812542", "新発田",
"814992", "伊豆大島",
"812658", "伊那",
"8125489", "津川",
"819945", "鹿屋",
"815743", "美濃加茂",
"812786", "沼田",
"811589", "興部",
"81988", "那覇",
"815735", "恵那",
"819933", "指宿",
"814776", "船橋",
"81933", "北九州",
"812558", "新井",
"81792", "姫路",
"81567", "津島",
"81557", "伊東",
"811736", "五所川原",
"812995", "石岡",
"81174", "蟹田",
"815394", "浜松",
"818583", "倉吉",
"815769", "荘川",
"815587", "修善寺大仁",
"817915", "相生",
"819788", "国東",
"81125", "滝川",
"818293", "廿日市",
"811564", "上士幌",
"818544", "木次",
"817908", "播磨山崎",
"817239", "寝屋川",
"818679", "新見",
"819556", "唐津",
"819437", "田主丸",
"818683", "津山",
"819825", "日向",
"812565", "三条",
"811454", "鵡川",
"817476", "下市",
"814701", "鴨川",
"811658", "上川",
"812994", "石岡",
"812896", "鹿沼",
"81979", "中津",
"812589", "長岡",
"815395", "浜松",
"8198292", "延岡",
"812573", "柏崎",
"812673", "小諸",
"81947", "田川",
"815996", "阿児",
"818206", "柳井",
"811558", "広尾",
"812742", "藤岡",
"812619", "大町",
"819913", "硫黄島",
"8182943", "広島",
"815734", "恵那",
"817969", "浜坂",
"819979", "徳之島",
"811639", "利尻礼文",
"81938", "北九州",
"811396", "江差",
"811539", "根室標津",
"81983", "高鍋",
"818956", "宇和島",
"817703", "敦賀",
"819944", "鹿屋",
"81765", "魚津",
"815566", "身延",
"81572", "多治見",
"81225", "石巻",
"8186995", "岡山瀬戸",
"817367", "岩出",
"812564", "三条",
"819824", "延岡",
"818368", "宇部",
"811455", "鵡川",
"818545", "木次",
"8199343", "鹿児島",
"81476", "成田",
"8166", "大阪",
"81734", "和歌山",
"817943", "加古川",
"819738", "玖珠",
"817914", "相生",
"8165", "大阪",
"814754", "茂原",
"8162", "大阪",
"812652", "飯田",
"817673", "羽咋",
"81532", "豊橋",
"8153961", "天竜",
"818376", "美祢",
"819663", "人吉",
"81246", "いわき",
"819725", "佐伯",
"817994", "洲本",
"818975", "新居浜",
"814226", "武蔵野三鷹",
"812552", "上越",
"818245", "三次",
"81774", "宇治",
"817736", "舞鶴",
"818360", "小郡",
"81436", "市原",
"81192", "大船渡",
"8198294", "延岡",
"814709", "鴨川",
"819805", "名護",
"81939", "北九州",
"8145", "横浜",
"819782", "豊後高田",
"819574", "諫早",
"811934", "釜石",
"819674", "熊本一の宮",
"817902", "福崎",
"81886", "徳島",
"81184", "本荘",
"81725", "和泉",
"812914", "鉾田",
"818847", "牟岐",
"812935", "水戸",
"811867", "鷹巣",
"819957", "加治木",
"814283", "青梅",
"815986", "松阪",
"81234", "酒田",
"817454", "大和高田",
"811652", "士別",
"81486", "浦和",
"819804", "名護",
"818557", "川本",
"818657", "笠岡",
"817716", "園部",
"812748", "富岡",
"811552", "帯広",
"817995", "洲本",
"811462", "浦河",
"818974", "新居浜",
"818876", "土佐山田",
"818244", "三次",
"81582", "岐阜",
"818593", "米子",
"81292", "水戸",
"818949", "宇和",
"814755", "東金",
"818693", "邑久",
"8125480", "村上",
"817468", "上北山",
"818467", "木江",
"819724", "佐伯",
"812386", "長井",
"81594", "桑名",
"8186697", "倉敷",
"811367", "寿都",
"817455", "大和高田",
"812239", "仙台",
"818362", "宇部",
"8199347", "鹿児島",
"812934", "高萩",
"81284", "足利",
"819746", "竹田",
"812836", "佐野",
"811935", "釜石",
"819675", "熊本一の宮",
"81989", "那覇",
"812796", "渋川",
"812550", "安塚",
"817723", "宮津",
"811984", "花巻",
"819732", "日田",
"811943", "岩泉",
"811336", "石狩",
"819575", "諫早",
"812476", "三春",
"81134", "小樽",
"815987", "三瀬谷",
"8124196", "柳津",
"818792", "三本松",
"81222", "仙台",
"818249", "東広島",
"818472", "甲山",
"818944", "八幡浜",
"817685", "輪島",
"818846", "丹生谷",
"811866", "鷹巣",
"819956", "加治木",
"817615", "小松",
"812965", "下館",
"819809", "八重山",
"815752", "関",
"814705", "館山",
"818382", "萩",
"818832", "鴨島",
"817950", "三田",
"811753", "むつ",
"818263", "加計",
"812872", "大田原",
"811973", "水沢",
"81243", "二本松",
"817488", "水口",
"811528", "美幌",
"815972", "尾鷲",
"811235", "夕張",
"817737", "舞鶴",
"814227", "武蔵野三鷹",
"811372", "鹿部",
"81433", "千葉",
"812234", "仙台",
"812695", "中野",
"818377", "下関",
"81488", "浦和",
"812939", "水戸",
"81762", "金沢",
"811337", "石狩",
"812477", "三春",
"812964", "下館",
"814704", "館山",
"812797", "渋川",
"819747", "竹田",
"817684", "輪島",
"818945", "八幡浜",
"812837", "佐野",
"817492", "彦根",
"81888", "高知",
"81250", "新津",
"817614", "小松",
"8112392", "夕張",
"81260", "阿南町",
"812387", "長井",
"81833", "下松",
"811366", "寿都",
"8169", "大阪",
"812243", "白石",
"818398", "小郡",
"8188094", "窪川",
"81143", "室蘭",
"812973", "水海道",
"8199345", "鹿児島",
"817952", "西脇",
"818466", "木江",
"81438", "木更津",
"818877", "嶺北",
"812412", "喜多方",
"817459", "大和榛原",
"814792", "銚子",
"812235", "仙台",
"812482", "白河",
"811958", "岩手",
"812694", "中野",
"817353", "新宮",
"812372", "村山",
"8186993", "備前",
"811234", "千歳",
"818656", "笠岡",
"817717", "園部",
"813", "東京",
"819683", "山鹿",
"811939", "宮古",
"819679", "高森",
"818556", "江津",
"819544", "武雄",
"817964", "豊岡",
"819593", "大瀬戸",
"81277", "桐生",
"818798", "土庄",
"811634", "浜頓別",
"819974", "屋久島",
"8112394", "夕張",
"818478", "東城",
"81471", "柏",
"811534", "中標津",
"81478", "佐原",
"819949", "大根占",
"811585", "遠軽",
"81249", "郡山",
"812999", "潮来",
"818804", "土佐中村",
"819557", "唐津",
"812643", "木曾福島",
"81944", "瀬高",
"812584", "長岡",
"818388", "田万川",
"815758", "郡上八幡",
"818838", "阿波池田",
"8153960", "天竜",
"812614", "大町",
"81439", "木更津",
"815586", "下田",
"812543", "新発田",
"812878", "烏山",
"817482", "八日市",
"811737", "鰺ケ沢",
"818675", "久世",
"81936", "北九州",
"811853", "男鹿",
"81220", "迫",
"815765", "下呂",
"819963", "川内",
"81737", "湯浅",
"815978", "熊野",
"811522", "斜里",
"811378", "今金",
"818892", "佐川",
"81162", "稚内",
"814777", "船橋",
"81585", "揖斐川",
"812787", "沼田",
"812569", "巻",
"8125488", "津川",
"8188092", "窪川",
"81554", "大月",
"81177", "青森",
"812911", "鉾田",
"8125481", "村上",
"812615", "大町",
"818805", "土佐中村",
"815399", "天竜",
"81489", "草加",
"81564", "岡崎",
"81722", "堺",
"812585", "長岡",
"811643", "石狩深川",
"818663", "総社",
"81473", "市川",
"817498", "長浜",
"811535", "厚岸",
"817366", "岩出",
"819233", "前原",
"811584", "遠軽",
"817965", "豊岡",
"819975", "名瀬",
"811635", "浜頓別",
"811543", "釧路",
"818563", "益田",
"811878", "大曲",
"817958", "丹波柏原",
"81878", "高松",
"818957", "御荘",
"81535", "浜松",
"815953", "上野",
"812853", "小山",
"8186997", "岡山瀬戸",
"811397", "奥尻",
"812418", "会津山口",
"8182920", "廿日市",
"814798", "八日市場",
"811952", "二戸",
"81743", "奈良",
"812488", "須賀川",
"812378", "寒河江",
"815764", "下呂",
"81262", "長野",
"815997", "阿児",
"818207", "久賀",
"81839", "山口",
"812897", "鹿沼",
"818549", "石見大田",
"81252", "新潟",
"81986", "都城",
"811353", "余市",
"818674", "久世",
"81926", "福岡",
"812617", "大町",
"81863", "玉野",
"81727", "池田",
"812587", "長岡",
"81853", "出雲",
"811566", "十勝清水",
"81172", "弘前",
"818546", "掛合",
"818807", "宿毛",
"819554", "伊万里",
"811537", "中標津",
"817942", "加古川",
"811456", "門別富川",
"817474", "五条",
"817728", "峰山",
"815565", "鰍沢青柳",
"819977", "瀬戸内",
"811637", "北見枝幸",
"8198290", "延岡",
"817967", "八鹿",
"8112391", "夕張",
"81998", "鹿児島",
"818955", "宇和島",
"812572", "柏崎",
"812784", "沼田",
"812672", "小諸",
"811395", "江差",
"812743", "藤岡",
"818205", "柳井",
"815995", "阿児",
"819912", "中之島",
"818680", "岡山",
"81468", "横須賀",
"818290", "広島",
"818598", "根雨",
"81429", "所沢",
"817702", "敦賀",
"817463", "吉野",
"818698", "備前",
"8147955", "八日市場",
"8124197", "柳津",
"811734", "五所川原",
"815396", "浜松",
"812895", "宇都宮",
"818582", "倉吉",
"815564", "鰍沢青柳",
"8183768", "下関",
"818512", "西郷",
"811587", "中湧別",
"818292", "広島",
"81272", "前橋",
"812566", "三条",
"819826", "日向",
"818682", "津山",
"817475", "下市",
"81280", "古河",
"814288", "青梅",
"819555", "唐津",
"817916", "竜野",
"812570", "小出",
"8125484", "村上",
"817678", "七尾",
"818677", "新見",
"812996", "潮来",
"811735", "五所川原",
"819668", "水俣",
"815742", "美濃加茂",
"812894", "宇都宮",
"8112398", "栗山",
"815994", "阿児",
"818204", "柳井",
"8111", "札幌",
"819932", "指宿",
"817940", "加古川",
"815767", "下呂",
"815589", "修善寺大仁",
"81463", "平塚",
"814775", "船橋",
"81157", "北見",
"815736", "中津川",
"811394", "松前",
"818954", "宇和島",
"81167", "富良野",
"812785", "沼田",
"819946", "鹿屋",
"8125482", "村上",
"8188098", "土佐清水",
"812475", "石川",
"819576", "島原",
"812795", "渋川",
"81896", "伊予三島",
"815367", "設楽",
"818559", "川本",
"818363", "宇部",
"819676", "高森",
"811936", "宮古",
"817948", "三木",
"812835", "佐野",
"818947", "宇和",
"81534", "浜松",
"817722", "宮津",
"819733", "日田",
"812385", "米沢",
"817456", "大和高田",
"811942", "岩泉",
"81423", "国分寺",
"815984", "松阪",
"811653", "士別",
"8153974", "天竜",
"814756", "東金",
"814298", "飯能",
"812578", "六日町",
"818374", "長門",
"814280", "立川",
"812678", "佐久",
"817996", "津名",
"812237", "仙台",
"81828", "広島",
"81546", "静岡",
"811553", "帯広",
"814224", "武蔵野三鷹",
"818875", "土佐山田",
"81555", "吉田",
"8199331", "鹿児島",
"817734", "福知山",
"817715", "亀岡",
"811463", "浦河",
"818592", "米子",
"818692", "邑久",
"81182", "横手",
"81565", "豊田",
"812384", "米沢",
"818588", "郡家",
"8198299", "日向",
"818690", "岡山",
"815985", "松阪",
"819783", "豊後高田",
"81584", "大垣",
"817617", "加賀",
"817903", "福崎",
"81294", "常陸太田",
"812936", "水戸",
"818298", "廿日市",
"817687", "能都",
"81227", "仙台",
"818688", "美作",
"812834", "宇都宮",
"819744", "三重",
"814707", "大原",
"812794", "渋川",
"8186996", "岡山瀬戸",
"814282", "青梅",
"812967", "笠間",
"811986", "遠野",
"812474", "石川",
"812653", "飯田",
"819547", "鹿島",
"817672", "羽咋",
"819806", "沖縄宮古",
"819662", "人吉",
"81270", "伊勢崎",
"815748", "美濃白川",
"817714", "亀岡",
"817735", "福知山",
"811237", "栗山",
"819938", "加世田",
"812553", "上越",
"818976", "新居浜",
"812697", "飯山",
"8186552", "倉敷",
"81592", "津",
"818246", "三次",
"818874", "安芸",
"814225", "武蔵野三鷹",
"81823", "呉",
"8188091", "窪川",
"819726", "臼杵",
"811869", "大館",
"81282", "栃木",
"81956", "佐世保",
"818375", "美祢",};

    sub new {
      my $class = shift;
      my $number = shift;
      $number =~ s/(^\+81|\D)//g;
      my $self = bless({ country_code => '81', number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self if ($self->is_valid());
      $number =~ s/^(?:0)//;
      $self = bless({ country_code => '81', number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self->is_valid() ? $self : undef;
    }
1;