# automatically generated file, don't edit



# Copyright 2023 David Cantrell, derived from data from libphonenumber
# http://code.google.com/p/libphonenumber/
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
package Number::Phone::StubCountry::MN;
use base qw(Number::Phone::StubCountry);

use strict;
use warnings;
use utf8;
our $VERSION = 1.20230307181421;

my $formatters = [
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '[12]1',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{2})(\\d{4})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '[5-9]',
                  'pattern' => '(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '[12]2[1-3]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{5,6})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            [12](?:
              27|
              3[2-8]|
              4[2-68]|
              5[1-4689]
            )[0-3]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{5,6})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '[12]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{5})(\\d{4,5})'
                }
              ];

my $validators = {
                'fixed_line' => '
          [12]2[1-3]\\d{5,6}|
          7(?:
            0[0-5]\\d|
            128
          )\\d{4}|
          (?:
            [12](?:
              1|
              27
            )|
            5[368]
          )\\d{6}|
          [12](?:
            3[2-8]|
            4[2-68]|
            5[1-4689]
          )\\d{6,7}
        ',
                'geographic' => '
          [12]2[1-3]\\d{5,6}|
          7(?:
            0[0-5]\\d|
            128
          )\\d{4}|
          (?:
            [12](?:
              1|
              27
            )|
            5[368]
          )\\d{6}|
          [12](?:
            3[2-8]|
            4[2-68]|
            5[1-4689]
          )\\d{6,7}
        ',
                'mobile' => '
          (?:
            83[01]|
            920
          )\\d{5}|
          (?:
            5[05]|
            6[069]|
            8[015689]|
            9[013-9]
          )\\d{6}
        ',
                'pager' => '',
                'personal_number' => '',
                'specialrate' => '',
                'toll_free' => '',
                'voip' => '
          712[0-79]\\d{4}|
          7(?:
            1[013-9]|
            [25-9]\\d
          )\\d{5}
        '
              };
my %areanames = ();
$areanames{en} = {"97613857", "Khatgal\,\ Khuvsgul",
"97625647", "Binder\,\ Khentii",
"97625854", "Chuluunkhoroot\,\ Dornod",
"97613644", "Yereu\,\ Selenge",
"97614349", "Munkhkhairkhan\,\ Khovd",
"97613742", "Khongor\,\ Darkhan\-Uul",
"97612741", "Altaanbulag\,\ Tuv",
"97614846", "Delger\,\ Govi\-Altai",
"97613842", "Arbulag\,\ Khuvsgul",
"97625652", "Delgerkhaan\,\ Khentii",
"97615945", "Delgerkhangai\,\ Dundgovi",
"97613743", "Sharingol\,\ Darkhan\-Uul",
"97625251", "Ulaanbadrakh\,\ Dornogovi",
"97625653", "Jargaltkhaan\,\ Khentii",
"97613843", "Bayanzurkh\,\ Khuvsgul",
"97614461", "Erdenetsogt\,\ Bayankhongor",
"97612747", "Bayanjargal\,\ Tuv",
"97624458", "Khureemaral\,\ Bayankhongor",
"97614855", "Tseel\,\ Govi\-Altai",
"97613851", "Tarialan\,\ Khuvsgul",
"97625243", "Dalanjargalan\,\ Dornogovi",
"97625641", "Batnorov\,\ Khentii",
"97612752", "Bayantsogt\,\ Tuv",
"97613254", "Taragt\,\ Uvurkhangai",
"97625242", "Altanshiree\,\ Dornogovi",
"97612753", "Bayanchandmani\,\ Tuv",
"9761442", "Bayankhongor\ city\,\ Bayankhongor",
"97623448", "Orkhon\,\ Bulgan",
"97625655", "Norovlin\,\ Khentii",
"97613845", "Galt\,\ Khuvsgul",
"97612746", "Bayandelger\,\ Tuv",
"97615943", "Govi\-Ugtaal\,\ Dundgovi",
"97614841", "Altai\,\ Govi\-Altai",
"9761512", "Baruun\-Urt\ city\,\ Sukhbaatar",
"97614244", "Bugat\,\ Bayan\-Ulgii",
"97614559", "Tsagaankhairkhan\,\ Uvs",
"97615942", "Bayanjargalan\,\ Dundgovi",
"97614847", "Jargalan\,\ Govi\-Altai",
"97612755", "Buren\,\ Tuv",
"97614654", "Songino\,\ Zavkhan",
"97625646", "Bayankhutagt\,\ Khentii",
"97613359", "Erdenemandal\,\ Arkhangai",
"97613856", "Khankh\,\ Khuvsgul",
"97614852", "Khaluun\,\ Govi\-Altai",
"9761532", "Dalanzadgad\,\ Umnugovi",
"97625245", "Zamiin\-Uud\,\ Dornogovi",
"97614853", "Khukhmorit\,\ Govi\-Altai",
"97615951", "Undurshil\,\ Dundgovi",
"97624556", "Tes\,\ Uvs",
"97613444", "Buregkhangai\,\ Bulgan",
"97622749", "Bayankhangai\,\ Tuv",
"97624341", "Altai\,\ Khovd",
"97624248", "Nogoonnnuur\,\ Bayan\-Ulgii",
"97623345", "Ugii\-Nuur\,\ Arkhangai",
"9761322", "Arvaikheer\ city\,\ Uvurkhangai",
"97625441", "Bayantal\,\ Govisumber",
"97623541", "Jargalant\,\ Orkhon",
"97624353", "Uench\,\ Khovd",
"97614661", "Tsagaanchuluut\,\ Zavkhan",
"9762582", "Choibalsan\ city\,\ Dornod",
"97624545", "Zuungovi\,\ Uvs",
"97624658", "Urgamal\,\ Zavkhan",
"97623356", "Tsenkher\,\ Arkhangai",
"97615649", "Dadal\,\ Khentii",
"97623859", "Tsagaan\-Uul\,\ Khuvsgul",
"97624352", "Myangad\,\ Khovd",
"97624347", "Zereg\,\ Khovd",
"97624551", "Umnugovi\,\ Uvs",
"97623343", "Jargalant\,\ Arkhangai",
"9761462", "Uliastal\ city\,\ Zavkhan",
"97623648", "Orkhon\,\ Selenge",
"97624346", "Duut\,\ Khovd",
"97624849", "Tonkhil\,\ Govi\-Altai",
"97623342", "Bulgan\,\ Arkhangai",
"976222", "Bagakhangai",
"97623357", "Tsetserleg\,\ Arkhangai",
"97615354", "Tsogt\-Ovoo\,\ Umnugovi",
"97624542", "Bukhmurun\,\ Uvs",
"97613864", "Shine\-Ider\,\ Khuvsgul",
"97624557", "Khovd\,\ Uvs",
"97614454", "Jargalant\,\ Bayankhongor",
"97623351", "Khairkhan\,\ Arkhangai",
"97624543", "Davst\,\ Uvs",
"97623258", "Kharkhorin\,\ Uvurkhangai",
"97624355", "Tsetseg\,\ Khovd",
"97624844", "Bugant\,\ Govi\-Altai",
"97624657", "Tes\,\ Zavkhan",
"97624642", "Asgat\,\ Zavkhan",
"97623646", "Zuunburen\,\ Selenge",
"97624348", "Mankhan\,\ Khovd",
"97623245", "Bogd\,\ Uvurkhangai",
"9761332", "Tsetserleg\ city\,\ Arkhangai",
"97624241", "Altai\,\ Bayan\-Ulgii",
"97624643", "Bayantest\,\ Zavkhan",
"97615845", "Gurvanzagal\,\ Dornod",
"97623655", "Hushaat\,\ Selenge",
"9761452", "Ulaangom\ city\,\ Uvs",
"97624651", "Numrug\,\ Zavkhan",
"97624253", "Tsengel\,\ Bayan\-Ulgii",
"97624247", "Deluun\,\ Bayan\-Ulgii",
"97625954", "Tsagaandelger\,\ Dundgovi",
"97623256", "Uyanga\,\ Uvurkhangai",
"97624252", "Ulaankhus\,\ Bayan\-Ulgii",
"97614459", "Shjnejinst\,\ Bayankhongor",
"97622744", "Batsumber\,\ Tuv",
"97624558", "Khyargas\,\ Uvs",
"97624645", "Bulnai\,\ Zavkhan",
"97623243", "Bayangol\,\ Uvurkhangai",
"97623641", "Altanbulag\,\ Selenge",
"97615851", "Khulunbuyir\,\ Dornod",
"976223", "Nalaikh",
"97623257", "Hairkhandulaan\,\ Uvurkhangai",
"97615254", "Erdene\,\ Dornogovi",
"97624246", "Buyant\,\ Bayan\-Ulgii",
"97613449", "Rashaant\,\ Bulgan",
"97623242", "Batulzii\,\ Uvurkhangai",
"97615644", "Bayanmunkh\,\ Khentii",
"97623854", "Tunel\,\ Khuvsgul",
"97623647", "Mandal\,\ Selenge",
"97623652", "Sant\,\ Selenge",
"97615842", "Bayantumen\,\ Dornod",
"976221", "Baganuur",
"97624656", "Telmen\,\ Zavkhan",
"97623358", "Chuluut\,\ Arkhangai",
"97615843", "Bayan\-Uul\,\ Dornod",
"97623653", "Tushig\,\ Selenge",
"97623251", "Naariinteel\,\ Uvurkhangai",
"97624442", "Bayanbulag\,\ Bayankhongor",
"97614249", "Sagsai\,\ Bayan\-Ulgii",
"97623446", "Dashinchilen\,\ Bulgan",
"97614554", "Tarialan\,\ Uvs",
"97612748", "Bayan\-Unjuul\,\ Tuv",
"97624457", "Ulziit\,\ Bayankhongor",
"97625142", "Bayandelger\,\ Sukhbaatar",
"97624443", "Bayangovi\,\ Bayankhongor",
"97625351", "Khanbogd\,\ Umnugovi",
"9762592", "Mandalgovi\ city\,\ Dundgovi",
"97625143", "Dariganga\,\ Sukhbaatar",
"97625343", "Bulgan\,\ Umnugovi",
"97624451", "Buutsagaan\,\ Bayankhongor",
"97625151", "Uulbayan\,\ Sukhbaatar",
"97613858", "Tsagaannuur\,\ Khuvsgul",
"97625648", "Galshir\,\ Khentii",
"97623455", "Khishig\-Undur\,\ Bulgan",
"97622762", "Undurshereet\,\ Tuv",
"97623861", "Tsagaan\-Uur\,\ Khuvsgul",
"97625342", "Bayan\-Ovoo\,\ Umnugovi",
"97614659", "Tsegeenkhairkhan\,\ Zavkhan",
"97613354", "Khotont\,\ Arkhangai",
"97622763", "Sumber\,\ Tuv",
"97623441", "Bayanagt\,\ Bulgan",
"97625145", "Naran\,\ Sukhbaatar",
"97614848", "Taishir\,\ Govi\-Altai",
"97624445", "Bayan\-Ovoo\,\ Bayankhongor",
"9762372", "Darkhan\ city\,\ Darkhan\-Uul",
"9762382", "Murun\ city\,\ Khuvsgul",
"97613649", "Orkhontuul\,\ Selenge",
"97614344", "Darvi\,\ Khovd",
"97623452", "Selenge\,\ Bulgan",
"97613259", "Khujirt\,\ Uvurkhangai",
"97622765", "Ugtaal\,\ Tuv",
"97624664", "Erdenekhaijkhan\,\ Zavkhan",
"97624456", "Zag\,\ Bayankhongor",
"97623447", "Mogod\,\ Bulgan",
"97623453", "Teshig\,\ Bulgan",
"9761522", "Sainshand\ city\,\ Dornogovi",
"97625345", "Mandal\-Ovoo\,\ Umnugovi",
"97625254", "Erdene\,\ Dornogovi",
"976123", "Nalaikh",
"97613257", "Hairkhandulaan\,\ Uvurkhangai",
"97623449", "Rashaant\,\ Bulgan",
"97613242", "Bat\-Ulzii\,\ Uvurkhangai",
"97614246", "Buyant\,\ Bayan\-Ulgii",
"97612744", "Batsumber\,\ Tuv",
"97614558", "Khyargas\,\ Uvs",
"97614645", "Bulnai\,\ Zavkhan",
"97613243", "Bayangol\,\ Uvurkhangai",
"97613641", "Altanbulag\,\ Selenge",
"97625851", "Khulunbuyir\,\ Dornod",
"97613358", "Chuluut\,\ Arkhangai",
"97625843", "Bayan\-Uul\,\ Dornod",
"97613653", "Tushig\,\ Selenge",
"97613251", "Naariinteel\,\ Uvurkhangai",
"97613647", "Mandal\,\ Selenge",
"97625644", "Bayanmunkh\,\ Khentii",
"97613854", "Tunel\,\ Khuvsgul",
"976121", "Baganuur",
"97614656", "Telmen\,\ Zavkhan",
"97613652", "Sant\,\ Selenge",
"97625842", "Bayantumen\,\ Dornod",
"97613245", "Bogd\,\ Uvurkhangai",
"9762332", "Tsetserleg\ city\,\ Arkhangai",
"97614348", "Mankhan\,\ Khovd",
"97614241", "Altai\,\ Bayan\-Ulgii",
"97614643", "Bayantest\,\ Zavkhan",
"97614657", "Tes\,\ Zavkhan",
"97614844", "Bugant\,\ Govi\-Altai",
"97613646", "Zuunburen\,\ Selenge",
"97614642", "Asgat\,\ Zavkhan",
"97615954", "Tsagaandelger\,\ Dundgovi",
"97614247", "Deluun\,\ Bayan\-Ulgii",
"97614252", "Ulaankhus\,\ Bayan\-Ulgii",
"97624459", "Shjnejinst\,\ Bayankhongor",
"97613256", "Uyanga\,\ Uvurkhangai",
"9762452", "Ulaangom\ city\,\ Uvs",
"97625845", "Gurvanzagal\,\ Dornod",
"97613655", "Hushaat\,\ Selenge",
"97614651", "Numrug\,\ Zavkhan",
"97614253", "Tsengel\,\ Bayan\-Ulgii",
"97623649", "Orkhontuul\,\ Selenge",
"97624344", "Darvi\,\ Khovd",
"97613441", "Bayanagt\,\ Bulgan",
"97615145", "Naran\,\ Sukhbaatar",
"9761382", "Murun\ city\,\ Khuvsgul",
"97624848", "Taishir\,\ Govi\-Altai",
"9761372", "Darkhan\ city\,\ Darkhan\-Uul",
"97614445", "Bayan\-Ovoo\,\ Bayankhongor",
"97613453", "Teshig\,\ Bulgan",
"9762522", "Sainshand\ city\,\ Dornogovi",
"97615345", "Mandal\-Ovoo\,\ Umnugovi",
"97614456", "Zag\,\ Bayankhongor",
"97612765", "Ugtaal\,\ Tuv",
"97623259", "Khujirt\,\ Uvurkhangai",
"97613452", "Selenge\,\ Bulgan",
"97614664", "Erdenekhaijkhan\,\ Zavkhan",
"97613447", "Mogod\,\ Bulgan",
"97615351", "Khanbogd\,\ Umnugovi",
"97614443", "Bayangovi\,\ Bayankhongor",
"97615143", "Dariganga\,\ Sukhbaatar",
"9761592", "Mandalgovi\ city\,\ Dundgovi",
"97613446", "Dashinchilen\,\ Bulgan",
"97624249", "Sagsai\,\ Bayan\-Ulgii",
"97614442", "Bayanbulag\,\ Bayankhongor",
"97614457", "Ulziit\,\ Bayankhongor",
"97615142", "Bayandelger\,\ Sukhbaatar",
"97624554", "Tarialan\,\ Uvs",
"97622748", "Bayan\-Unjuul\,\ Tuv",
"97624659", "Tsegeenkhairkhan\,\ Zavkhan",
"97615342", "Bayan\-Ovoo\,\ Umnugovi",
"97612763", "Sumber\,\ Tuv",
"97623354", "Khotont\,\ Arkhangai",
"97614451", "Buutsagaan\,\ Bayankhongor",
"97615343", "Bulgan\,\ Umnugovi",
"97613861", "Tsagaan\-Uur\,\ Khuvsgul",
"97623858", "Tsagaannuur\,\ Khuvsgul",
"97615151", "Uulbayan\,\ Sukhbaatar",
"97613455", "Khishig\-Undur\,\ Bulgan",
"97612762", "Undurshereet\,\ Tuv",
"97615648", "Galshir\,\ Khentii",
"97624244", "Bugat\,\ Bayan\-Ulgii",
"97624559", "Tsagaankhairkhan\,\ Uvs",
"97625942", "Bayanjargalan\,\ Dundgovi",
"97613448", "Orkhon\,\ Bulgan",
"97615655", "Norovlin\,\ Khentii",
"97623845", "Galt\,\ Khuvsgul",
"9762442", "Bayankhongor\ city\,\ Bayankhongor",
"9762512", "Baruun\-Urt\ city\,\ Sukhbaatar",
"97625943", "Govi\-Ugtaal\,\ Dundgovi",
"97622746", "Bayandelger\,\ Tuv",
"97624841", "Altai\,\ Govi\-Altai",
"9762532", "Dalanzadgad\,\ Umnugovi",
"97615245", "Zamiin\-Uud\,\ Dornogovi",
"97624853", "Khukhmorit\,\ Govi\-Altai",
"97625951", "Undurshil\,\ Dundgovi",
"97622755", "Buren\,\ Tuv",
"97624654", "Songino\,\ Zavkhan",
"97624847", "Jargalan\,\ Govi\-Altai",
"97624852", "Khaluun\,\ Govi\-Altai",
"97615646", "Bayankhutagt\,\ Khentii",
"97623359", "Erdenemandal\,\ Arkhangai",
"97623856", "Khankh\,\ Khuvsgul",
"97625945", "Delgerkhangai\,\ Dundgovi",
"97615653", "Jargaltkhaan\,\ Khentii",
"97615251", "Ulaanbadrakh\,\ Dornogovi",
"97623843", "Bayanzurkh\,\ Khuvsgul",
"97623743", "Sharingol\,\ Darkhan\-Uul",
"97615854", "Chuluunkhoroot\,\ Dornod",
"97623644", "Yereu\,\ Selenge",
"97623857", "Khatgal\,\ Khuvsgul",
"97615647", "Binder\,\ Khentii",
"97623842", "Arbulag\,\ Khuvsgul",
"97615652", "Delgerkhaan\,\ Khentii",
"97624349", "Munkhkhairkhan\,\ Khovd",
"97624846", "Delger\,\ Govi\-Altai",
"97623742", "Khongor\,\ Darkhan\-Uul",
"97622741", "Altaanbulag\,\ Tuv",
"97623254", "Taragt\,\ Uvurkhangai",
"97622753", "Bayanchandmani\,\ Tuv",
"97615242", "Altanshiree\,\ Dornogovi",
"97614458", "Khureemaral\,\ Bayankhongor",
"97624855", "Tseel\,\ Govi\-Altai",
"97624461", "Erdenetsogt\,\ Bayankhongor",
"97622747", "Bayanjargal\,\ Tuv",
"97622752", "Bayantsogt\,\ Tuv",
"97623851", "Tarialan\,\ Khuvsgul",
"97615641", "Batnorov\,\ Khentii",
"97615243", "Dalanjargalan\,\ Dornogovi",
"97613342", "Bulgan\,\ Arkhangai",
"97614346", "Duut\,\ Khovd",
"97614849", "Tonkhil\,\ Govi\-Altai",
"97625354", "Tsogt\-Ovoo\,\ Umnugovi",
"976122", "Bagakhangai",
"97613357", "Tsetserleg\,\ Arkhangai",
"97613343", "Jargalant\,\ Arkhangai",
"97614551", "Umnugovi\,\ Uvs",
"97613648", "Orkhon\,\ Selenge",
"9762462", "Uliastal\ city\,\ Zavkhan",
"97614543", "Davst\,\ Uvs",
"97613351", "Khairkhan\,\ Arkhangai",
"97614355", "Tsetseg\,\ Khovd",
"97613258", "Kharkhorin\,\ Uvurkhangai",
"97623864", "Shine\-Ider\,\ Khuvsgul",
"97614542", "Bukhmurun\,\ Uvs",
"97624454", "Jargalant\,\ Bayankhongor",
"97614557", "Khovd\,\ Uvs",
"97612749", "Bayankhangai\,\ Tuv",
"97614341", "Altai\,\ Khovd",
"97613345", "Ugii\-Nuur\,\ Arkhangai",
"9762322", "Arvaikheer\ city\,\ Uvurkhangai",
"97614248", "Nogoonnnuur\,\ Bayan\-Ulgii",
"97614556", "Tes\,\ Uvs",
"97623444", "Buregkhangai\,\ Bulgan",
"97614352", "Myangad\,\ Khovd",
"97625649", "Dadal\,\ Khentii",
"97613356", "Tsenkher\,\ Arkhangai",
"97613859", "Tsagaan\-Uul\,\ Khuvsgul",
"97614347", "Zereg\,\ Khovd",
"97614353", "Uench\,\ Khovd",
"97615441", "Bayantal\,\ Govisumber",
"97613541", "Jargalant\,\ Orkhon",
"97614545", "Zuungovi\,\ Uvs",
"97614658", "Urgamal\,\ Zavkhan",
"97624661", "Tsagaanchuluut\,\ Zavkhan",
"9761582", "Choibalsan\ city\,\ Dornod",
"97614665", "Yaruu\,\ Zavkhan",
"97623353", "Khashaat\,\ Arkhangai",
"97612764", "Sergelen\,\ Tuv",
"97624541", "Baruunturuun\,\ Uvs",
"97615848", "Sereglen\,\ Dornod",
"97623352", "Khahgai\,\ Arkhangai",
"97624356", "Chandmani\,\ Khovd",
"97615344", "Gurvan\ tes\,\ Umnugovi",
"97623347", "Undur\-Ulaan\,\ Arkhangai",
"97624552", "Undurkhangai\,\ Uvs",
"97625949", "Ulziit\,\ Dundgovi",
"97615144", "Munkhkhaan\,\ Sukhbaatar",
"97614444", "Bayanlig\,\ Bayankhongor",
"97624547", "Malchin\,\ Uvs",
"97624553", "Sagili\,\ Uvs",
"97623341", "Battsengel\,\ Arkhangai",
"9761422", "Ulgii\,\ Bayan\-Ulgii",
"97624345", "Durgun\,\ Khovd",
"97623248", "Zuil\,\ Uvurkhangai",
"97625442", "Shivee\-Govi\,\ Govisumber",
"97615249", "Saikhandulaan\,\ Dornogovi",
"97624546", "Zuunkhangai\,\ Uvs",
"97613454", "Khangal\,\ Bulgan",
"97614662", "Tsetsen\-Uul\,\ Zavkhan",
"97624351", "Must\,\ Khovd",
"97622759", "Lun\,\ Tuv",
"97614663", "Shiluustei\,\ Zavkhan",
"97623355", "Tsakhirt\,\ Arkhangai",
"97624343", "Buyant\,\ Khovd",
"97624648", "Ider\,\ Zavkhan",
"97624555", "Turgen\,\ Uvs",
"9761362", "Sukhbaatar\ city\,\ Selenge",
"97624342", "Bulgan\,\ Khovd",
"97623849", "Renchinlkhumbe\,\ Khuvsgul",
"97623346", "Ulziit\,\ Arkhangai",
"97624357", "Erdeneburen\,\ Khovd",
"97613855", "Ulaan\-Uul\,\ Khuvsgul",
"97625645", "Bayan\-Ovoo\,\ Khentii",
"97615953", "Khuld\,\ Dundgovi",
"97612756", "Delgerkhaan\,\ Tuv",
"97614851", "Tugrug\,\ Govi\-Altai",
"97615947", "Deren\,\ Dundgovi",
"97625246", "Ikh\-Khet\,\ Dornogovi",
"97615952", "Saikhan\-Ovoo\,\ Dundgovi",
"97614549", "Ulgii\,\ Uvs",
"97614644", "Bayankhairkhan\,\ Zavkhan",
"97612745", "Bayan\,\ Tuv",
"97614857", "Sharga\,\ Govi\-Altai",
"97614842", "Bayan\-Uul\,\ Govi\-Altai",
"97613846", "Jargalant\,\ Khuvsgul",
"97625656", "Umnudelger\,\ Khentii",
"97613349", "Tuvshruulekh\,\ Arkhangai",
"97615941", "Adaatsag\,\ Dundgovi",
"97614843", "Biger\,\ Govi\-Altai",
"97613654", "Khuder\,\ Selenge",
"97625844", "Bulgan\,\ Dornod",
"97625657", "Tsenkhermandal\,\ Khentii",
"97613847", "Ikh\-Uul\,\ Khuvsgul",
"97622768", "Erdenesant\,\ Tuv",
"97625642", "Batshireet\,\ Khentii",
"97613852", "Tosontsengel\,\ Khuvsgul",
"97614856", "Chandmani\,\ Govi\-Altai",
"97612751", "Bayantsagaan\,\ Tuv",
"97625348", "Nomgon\,\ Umnugovi",
"97615955", "Erdenedalai\,\ Dundgovi",
"97613853", "Tumurbulag\,\ Khuvsgul",
"97625643", "Bayan\-Adarga\,\ Khentii",
"97625241", "Airag\,\ Dornogovi",
"97614845", "Darvi\,\ Govi\-Altai",
"97624448", "Bogd\,\ Bayankhongor",
"97612757", "Jargalant\,\ Tuv",
"9761342", "Bulgan\ city\,\ Bulgan",
"97613741", "Orkhon\,\ Darkhan\-Uul",
"97612742", "Argalant\,\ Tuv",
"97625253", "Huvsgul\,\ Dornogovi",
"97625651", "Darkhan\,\ Khentii",
"97613841", "Alag\-Erdene\,\ Khuvsgul",
"97625148", "Tuvshin\-Shiree\,\ Sukhbaatar",
"97625247", "Mandakh\,\ Dornogovi",
"97613244", "Bayan\-Undur\,\ Uvurkhangai",
"97615946", "Delgertsogt\,\ Dundgovi",
"97612743", "Arhust\,\ Tuv",
"97625252", "Khatanbulag\,\ Dornogovi",
"97621", "Ulaanbaatar",
"97623451", "Saikhan\,\ Bulgan",
"97623865", "Erdenebulgan\,\ Khuvsgul",
"9761562", "Undurkhaan\ city\,\ Khentii",
"97622766", "Tseel\,\ Tuv",
"97624455", "Jinst\,\ Bayankhongor",
"97614858", "Erdene\,\ Govi\-Altai",
"97625346", "Manlai\,\ Umnugovi",
"97625849", "Khalkhgol\,\ Dornod",
"97614354", "Khovd\,\ Khovd",
"97624446", "Bayan\-Undur\,\ Bayankhongor",
"97613249", "Zuunbayan\-Ulaan\,\ Uvurkhangai",
"97623442", "Bayannuur\,\ Bulgan",
"9762272", "Zuunmod\ city\,\ Tuv",
"97625146", "Ongon\,\ Sukhbaatar",
"97623443", "Bugat\,\ Bulgan",
"97615948", "Luus\,\ Dundgovi",
"97625355", "Tsogt\-Tsetsii\,\ Umnugovi",
"97623456", "Khutag\-Undur\,\ Bulgan",
"97624452", "Galuut\,\ Bayankhongor",
"97625147", "Sukhbaatar\,\ Sukhbaatar",
"97622761", "Mungunmorit\,\ Tuv",
"97624447", "Bayantsagaan\,\ Bayankhongor",
"97625152", "Halzan\,\ Sukhbaatar",
"97612758", "Zaamar\,\ Tuv",
"97614544", "Zavkhan\,\ Uvs",
"97623862", "Tsetserleg\,\ Khuvsgul",
"97625341", "Bayandalai\,\ Umnugovi",
"97624453", "Gurvanbulag\,\ Bayankhongor",
"97625153", "Erdenetsagaan\,\ Sukhbaatar",
"97625248", "Urgun\,\ Dornogovi",
"97623863", "Chaandmani\-Undur\,\ Khuvsgul",
"97622767", "Erdene\,\ Tuv",
"97624441", "Baatsagaan\,\ Bayankhongor",
"97625353", "Khurmen\,\ Umnugovi",
"9762482", "Altai\ city\,\ Govi\-Altai",
"97623445", "Gurvanbulag\,\ Bulgan",
"97625141", "Asgat\,\ Sukhbaatar",
"97613848", "Rashaant\,\ Khuvsgul",
"97614649", "Ikh\-Uul\,\ Zavkhan",
"97625352", "Khankhongor\,\ Umnugovi",
"97625347", "Noyon\,\ Umnugovi",
"97613344", "Ikh\-Tamir\,\ Arkhangai",
"9761542", "Choir\,\ Govisumber",
"9761352", "Erdenet\ city\,\ Orkhon",
"97624548", "Naranbulag\,\ Uvs",
"97624655", "Tudevtei\,\ Zavkhan",
"97622754", "Bornuur\,\ Tuv",
"97615841", "Bayandun\,\ Dornod",
"97623651", "Saikhan\,\ Selenge",
"97623253", "Sant\,\ Uvurkhangai",
"97615244", "Delgerekh\,\ Dornogovi",
"97623247", "Guchin\-Us\,\ Uvurkhangai",
"97623252", "Ulziit\,\ Uvurkhangai",
"97615847", "Matad\,\ Dornod",
"97623657", "Shaamar\,\ Selenge",
"97623844", "Burentogtokh\,\ Khuvsgul",
"97615654", "Murun\,\ Khentii",
"97624646", "Durvuljin\,\ Zavkhan",
"97615852", "Tsagaan\-Ovoo\,\ Dornod",
"97623642", "Baruunburen\,\ Selenge",
"9761432", "Khovd\ city\,\ Khovd",
"97624245", "Bulgan\,\ Bayan\-Ulgii",
"97623348", "Tariat\,\ Arkhangai",
"97623241", "Baruun\ Bayan\-Ulaan\,\ Uvurkhangai",
"97623643", "Bayangol\,\ Selenge",
"97615853", "Choibalsan\,\ Dornod",
"97624647", "Zavkhanmandal\,\ Zavkhan",
"97624854", "Tsogt\,\ Govi\-Altai",
"97615349", "Savrai\,\ Umnugovi",
"97623656", "Tsagaannuur\,\ Selenge",
"97615846", "Dashbalbar\,\ Dornod",
"97624652", "Otgon\,\ Zavkhan",
"97623255", "Tugrug\,\ Uvurkhangai",
"97624653", "Santmargad\,\ Zavkhan",
"97624251", "Tolbo\,\ Bayan\-Ulgii",
"97623645", "Javkhlant\,\ Selenge",
"97624243", "Bayannuur\,\ Bayan\-Ulgii",
"97624641", "Aldarkhaan\,\ Zavkhan",
"97625944", "Gurvansaikhan\,\ Dundgovi",
"97615149", "Tumentsogt\,\ Sukhbaatar",
"97624242", "Altantsugts\,\ Bayan\-Ulgii",
"97614449", "Bumbugur\,\ Bayankhongor",
"97623246", "Burd\,\ Uvurkhangai",
"97614453", "Gurvanbulag\,\ Bayankhongor",
"97615341", "Bayandalai\,\ Umnugovi",
"97613863", "Chaandmani\-Undur\,\ Khuvsgul",
"97615153", "Erdenetsagaan\,\ Sukhbaatar",
"97615248", "Urgun\,\ Dornogovi",
"97615147", "Sukhbaatar\,\ Sukhbaatar",
"97614452", "Galuut\,\ Bayankhongor",
"97613456", "Khutag\-Undur\,\ Bulgan",
"97622758", "Zaamar\,\ Tuv",
"97624544", "Zavkhan\,\ Uvs",
"97613862", "Tsetserleg\,\ Khuvsgul",
"97612761", "Mungunmorit\,\ Tuv",
"97615152", "Halzan\,\ Sukhbaatar",
"97614447", "Bayantsagaan\,\ Bayankhongor",
"97615352", "Khankhongor\,\ Umnugovi",
"97624649", "Ikh\-Uul\,\ Zavkhan",
"97623344", "Ikh\-Tamir\,\ Arkhangai",
"97615347", "Noyon\,\ Umnugovi",
"97615353", "Khurmen\,\ Umnugovi",
"97612767", "Erdene\,\ Tuv",
"97614441", "Baatsagaan\,\ Bayankhongor",
"97613445", "Gurvanbulag\,\ Bulgan",
"97615141", "Asgat\,\ Sukhbaatar",
"97623848", "Rashaant\,\ Khuvsgul",
"9761482", "Altai\ city\,\ Govi\-Altai",
"97615346", "Manlai\,\ Umnugovi",
"97615849", "Khalkh\,\ Dornod",
"97624354", "Khovd\,\ Khovd",
"97613865", "Erdenebulgan\,\ Khuvsgul",
"97611", "Ulaanbaatar",
"97613451", "Saikhan\,\ Bulgan",
"97614455", "Jinst\,\ Bayankhongor",
"97624858", "Erdene\,\ Govi\-Altai",
"9762562", "Undurkhaan\ city\,\ Khentii",
"97612766", "Tseel\,\ Tuv",
"97613443", "Bugat\,\ Bulgan",
"97615355", "Tsogttsetsii\,\ Umnugovi",
"97625948", "Luus\,\ Dundgovi",
"97623249", "Zuunbayan\-Ulaan\,\ Uvurkhangai",
"97613442", "Bayannuur\,\ Bulgan",
"97614446", "Bayan\-Undur\,\ Bayankhongor",
"97615146", "Ongon\,\ Sukhbaatar",
"9761272", "Zuunmod\ city\,\ Tuv",
"97613255", "Tugrug\,\ Uvurkhangai",
"97614653", "Santmargad\,\ Zavkhan",
"97614251", "Tolbo\,\ Bayan\-Ulgii",
"97614854", "Tsogt\,\ Govi\-Altai",
"97614647", "Zavkhanmandal\,\ Zavkhan",
"97614652", "Otgon\,\ Zavkhan",
"97625349", "Savrai\,\ Umnugovi",
"97613656", "Tsagaannuur\,\ Selenge",
"97625846", "Dashbalbar\,\ Dornod",
"97625149", "Tumentsogt\,\ Sukhbaatar",
"97615944", "Gurvansaikhan\,\ Dundgovi",
"97613246", "Burd\,\ Uvurkhangai",
"97624449", "Bumbugur\,\ Bayankhongor",
"97614242", "Altantsugts\,\ Bayan\-Ulgii",
"97613645", "Javkhlant\,\ Selenge",
"97614243", "Bayannuur\,\ Bayan\-Ulgii",
"97614641", "Aldarkhaan\,\ Zavkhan",
"97613247", "Guchin\-Us\,\ Uvurkhangai",
"97625244", "Delgerekh\,\ Dornogovi",
"97613252", "Ulziit\,\ Uvurkhangai",
"97614655", "Tudevtei\,\ Zavkhan",
"97614548", "Naranbulag\,\ Uvs",
"97612754", "Bornuur\,\ Tuv",
"9762352", "Erdenet\ city\,\ Orkhon",
"9762542", "Choir\,\ Govisumber",
"97625841", "Bayandun\,\ Dornod",
"97613253", "Sant\,\ Uvurkhangai",
"97613651", "Saikhan\,\ Selenge",
"97613348", "Tariat\,\ Arkhangai",
"9762432", "Khovd\ city\,\ Khovd",
"97614245", "Bulgan\,\ Bayan\-Ulgii",
"97613643", "Bayangol\,\ Selenge",
"97613241", "Baruun\ Bayan\-Ulaan\,\ Uvurkhangai",
"97625853", "Choibalsan\,\ Dornod",
"97613844", "Burentogtokh\,\ Khuvsgul",
"97625654", "Murun\,\ Khentii",
"97625847", "Matad\,\ Dornod",
"97613657", "Shaamar\,\ Selenge",
"97625852", "Tsagaan\-Ovoo\,\ Dornod",
"97613642", "Baruunburen\,\ Selenge",
"97614646", "Durvuljin\,\ Zavkhan",
"97614351", "Must\,\ Khovd",
"97612759", "Lun\,\ Tuv",
"97624663", "Shiluustei\,\ Zavkhan",
"97613355", "Tsakhirt\,\ Arkhangai",
"97614546", "Zuunkhangai\,\ Uvs",
"97625249", "Saikhandulaan\,\ Dornogovi",
"97615442", "Shivee\-Govi\,\ Govisumber",
"97623454", "Khangal\,\ Bulgan",
"97624662", "Tsetsen\-Uul\,\ Zavkhan",
"97613849", "Renchinlkhumbe\,\ Khuvsgul",
"97613346", "Ulziit\,\ Arkhangai",
"97614342", "Bulgan\,\ Khovd",
"97614357", "Erdeneburen\,\ Khovd",
"97614343", "Buyant\,\ Khovd",
"9762362", "Sukhbaatar\ city\,\ Selenge",
"97614555", "Turgen\,\ Uvs",
"97614648", "Ider\,\ Zavkhan",
"97614356", "Chandmani\,\ Khovd",
"97613352", "Khahgai\,\ Arkhangai",
"97613347", "Undur\-Ulaan\,\ Arkhangai",
"97625344", "Gurvan\ tes\,\ Umnugovi",
"97614541", "Baruunturuun\,\ Uvs",
"97624665", "Yaruu\,\ Zavkhan",
"97613353", "Khashaat\,\ Arkhangai",
"97622764", "Sergelen\,\ Tuv",
"97625848", "Sereglen\,\ Dornod",
"97613341", "Battsengel\,\ Arkhangai",
"97614553", "Sagili\,\ Uvs",
"97613248", "Zuil\,\ Uvurkhangai",
"9762422", "Ulgii\,\ Bayan\-Ulgii",
"97614345", "Durgun\,\ Khovd",
"97625144", "Munkhkhaan\,\ Sukhbaatar",
"97614552", "Undurkhangai\,\ Uvs",
"97615949", "Ulziit\,\ Dundgovi",
"97614547", "Malchin\,\ Uvs",
"97624444", "Bayanlig\,\ Bayankhongor",
"97625955", "Erdenedalai\,\ Dundgovi",
"97615348", "Nomgon\,\ Umnugovi",
"97623853", "Tumurbulag\,\ Khuvsgul",
"97615643", "Bayan\-Adraga\,\ Khentii",
"97615241", "Airag\,\ Dornogovi",
"97615657", "Tsenkhermandal\,\ Khentii",
"97623847", "Ikh\-Uul\,\ Khuvsgul",
"97623654", "Khuder\,\ Selenge",
"97615844", "Bulgan\,\ Dornod",
"97622751", "Bayantsagaan\,\ Tuv",
"97624856", "Chandmani\,\ Govi\-Altai",
"97615642", "Batshireet\,\ Khentii",
"97612768", "Erdenesant\,\ Tuv",
"97623852", "Tosontsengel\,\ Khuvsgul",
"97623244", "Bayan\-Undur\,\ Uvurkhangai",
"97615247", "Mandakh\,\ Dornogovi",
"97615252", "Khatanbulag\,\ Dornogovi",
"97625946", "Delgertsogt\,\ Dundgovi",
"97622743", "Arhust\,\ Tuv",
"97622757", "Jargalant\,\ Tuv",
"9762342", "Bulgan\ city\,\ Bulgan",
"97624845", "Darvi\,\ Govi\-Altai",
"97614448", "Bogd\,\ Bayankhongor",
"97615253", "Huvsgul\,\ Dornogovi",
"97615651", "Darkhan\,\ Khentii",
"97615148", "Tuvshin\-Shiree\,\ Sukhbaatar",
"97623841", "Alag\-Erdene\,\ Khuvsgul",
"97622742", "Argalant\,\ Tuv",
"97623741", "Orkhon\,\ Darkhan\-Uul",
"97625947", "Deren\,\ Dundgovi",
"97625952", "Saikhan\-Ovoo\,\ Dundgovi",
"97624549", "Ulgii\,\ Uvs",
"97615246", "Ikh\-Khet\,\ Dornogovi",
"97623855", "Ulaan\-Uul\,\ Khuvsgul",
"97615645", "Bayan\-Ovoo\,\ Khentii",
"97625953", "Khuld\,\ Dundgovi",
"97622756", "Delgerkhaan\,\ Tuv",
"97624851", "Tugrug\,\ Govi\-Altai",
"97624843", "Biger\,\ Govi\-Altai",
"97625941", "Adaatsag\,\ Dundgovi",
"97624857", "Sharga\,\ Govi\-Altai",
"97624644", "Bayankhairkhan\,\ Zavkhan",
"97622745", "Bayan\,\ Tuv",
"97623846", "Jargalant\,\ Khuvsgul",
"97623349", "Tuvshruulekh\,\ Arkhangai",
"97615656", "Umnudelger\,\ Khentii",
"97624842", "Bayan\-Uul\,\ Govi\-Altai",};

    sub new {
      my $class = shift;
      my $number = shift;
      $number =~ s/(^\+976|\D)//g;
      my $self = bless({ country_code => '976', number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self if ($self->is_valid());
      $number =~ s/^(?:0)//;
      $self = bless({ country_code => '976', number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self->is_valid() ? $self : undef;
    }
1;