/*    ICU.xs
 *
 *    $Id: ICU.xs,v 1.6 2001/07/22 02:08:06 mrperl Exp $
 *
 *    Copyright (c) 2000 Brian Stell
 *
 *    This package is free software and is provided ``as is'' without
 *    express or implied warranty. It may be used, redistributed and/or
 *    modified under the terms of the Perl Artistic License
 *    (see http://www.perl.com/perl/misc/Artistic.html)
 *
 */

extern "C" {
#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"
}

#include  "unicode/utypes.h"
#include "picu/picu_debug.h"

extern "C" XS(boot_ICU__BiDi);
extern "C" XS(boot_ICU__BreakIterator);
extern "C" XS(boot_ICU__Calendar);
extern "C" XS(boot_ICU__DateFormat);
extern "C" XS(boot_ICU__DateFormatSymbols);
extern "C" XS(boot_ICU__DecimalFormatSymbols);
extern "C" XS(boot_ICU__Locale);
extern "C" XS(boot_ICU__MessageFormat);
extern "C" XS(boot_ICU__Normalizer);
extern "C" XS(boot_ICU__NumberFormat);
extern "C" XS(boot_ICU__TimeZone);
extern "C" XS(boot_ICU__UConverter);
extern "C" XS(boot_ICU__Unicode);

static int debugLevel = 0;

static void
callXS (void (*subaddr)(CV* cv), CV *cv, SV **mark)
{
    int items;
  dSP;
   PUSHMARK (mark);
   (*subaddr)(cv);

    PUTBACK;  /* Forget the return values */
}

static IV
constant_iv(char *name, int arg)
{
    DEBUG100("name = %s");
    errno = 0;
    switch (*name) {
#if 0
add more cases as needed
    case 'A':
        if (strEQ(name, "AName"))
            return AValue;
        break;
#endif
    case 'U':
        if (strEQ(name, "U_ZERO_ERROR"))
            return U_ZERO_ERROR;
        else if (strEQ(name, "U_ERROR_INFO_START"))
            return U_ERROR_INFO_START;
        else if (strEQ(name, "U_USING_FALLBACK_ERROR"))
            return U_USING_FALLBACK_ERROR;
        else if (strEQ(name, "U_USING_DEFAULT_ERROR"))
            return U_USING_DEFAULT_ERROR;
        else if (strEQ(name, "U_SAFECLONE_ALLOCATED_ERROR"))
            return U_SAFECLONE_ALLOCATED_ERROR;
        else if (strEQ(name, "U_ERROR_INFO_LIMIT"))
            return U_ERROR_INFO_LIMIT;
        else if (strEQ(name, "U_ILLEGAL_ARGUMENT_ERROR"))
            return U_ILLEGAL_ARGUMENT_ERROR;
        else if (strEQ(name, "U_MISSING_RESOURCE_ERROR"))
            return U_MISSING_RESOURCE_ERROR;
        else if (strEQ(name, "U_INVALID_FORMAT_ERROR"))
            return U_INVALID_FORMAT_ERROR;
        else if (strEQ(name, "U_FILE_ACCESS_ERROR"))
            return U_FILE_ACCESS_ERROR;
        else if (strEQ(name, "U_INTERNAL_PROGRAM_ERROR"))
            return U_INTERNAL_PROGRAM_ERROR;
        else if (strEQ(name, "U_MESSAGE_PARSE_ERROR"))
            return U_MESSAGE_PARSE_ERROR;
        else if (strEQ(name, "U_MEMORY_ALLOCATION_ERROR"))
            return U_MEMORY_ALLOCATION_ERROR;
        else if (strEQ(name, "U_INDEX_OUTOFBOUNDS_ERROR"))
            return U_INDEX_OUTOFBOUNDS_ERROR;
        else if (strEQ(name, "U_PARSE_ERROR"))
            return U_PARSE_ERROR;
        else if (strEQ(name, "U_INVALID_CHAR_FOUND"))
            return U_INVALID_CHAR_FOUND;
        else if (strEQ(name, "U_TRUNCATED_CHAR_FOUND"))
            return U_TRUNCATED_CHAR_FOUND;
        else if (strEQ(name, "U_ILLEGAL_CHAR_FOUND"))
            return U_ILLEGAL_CHAR_FOUND;
        else if (strEQ(name, "U_INVALID_TABLE_FORMAT"))
            return U_INVALID_TABLE_FORMAT;
        else if (strEQ(name, "U_INVALID_TABLE_FILE"))
            return U_INVALID_TABLE_FILE;
        else if (strEQ(name, "U_BUFFER_OVERFLOW_ERROR"))
            return U_BUFFER_OVERFLOW_ERROR;
        else if (strEQ(name, "U_UNSUPPORTED_ERROR"))
            return U_UNSUPPORTED_ERROR;
        else if (strEQ(name, "U_RESOURCE_TYPE_MISMATCH"))
            return U_RESOURCE_TYPE_MISMATCH;
        else if (strEQ(name, "U_ILLEGAL_ESCAPE_SEQUENCE"))
            return U_ILLEGAL_ESCAPE_SEQUENCE;
        else if (strEQ(name, "U_UNSUPPORTED_ESCAPE_SEQUENCE"))
            return U_UNSUPPORTED_ESCAPE_SEQUENCE;
        else if (strEQ(name, "U_NO_SPACE_AVAILABLE"))
            return U_NO_SPACE_AVAILABLE;
        else if (strEQ(name, "U_ERROR_LIMIT"))
            return U_ERROR_LIMIT;
        break;
    }
    errno = EINVAL;
    return 0;

/* if a value should be defined but is not */
not_there:
    errno = ENOENT;
    return 0;
}

void
init_ICU_xs_debug()
{
    char *debugLevel_string = getenv("PICU_DEBUG_ICU_XS_LEVEL");
    if (debugLevel_string != 0) {
        debugLevel = atoi(debugLevel_string);
    }
}

MODULE = ICU    PACKAGE = ICU

REQUIRE: 1.925

IV
constant_iv(name,arg)
    char *name
    int   arg

UBool
U_SUCCESS(code)
        UErrorCode code;
  CODE:
        DEBUG100("U_SUCCESS code=%d", code);
        RETVAL = (UBool)(code<=U_ZERO_ERROR);
        DEBUG100("U_SUCCESS RETVAL=%d", RETVAL);
  OUTPUT:
        RETVAL

UBool
U_FAILURE(code)
        UErrorCode code;
  CODE:
        DEBUG100("U_FAILURE code=%d", code);
        RETVAL = (UBool)(code>U_ZERO_ERROR);
        DEBUG100("U_FAILURE RETVAL=%d", RETVAL);
  OUTPUT:
        RETVAL


#
# tell perl about the ICU wrappers
#
BOOT:
        init_ICU_xs_debug();
        callXS(boot_ICU__BiDi, cv, mark);
        callXS(boot_ICU__BreakIterator, cv, mark);
        callXS(boot_ICU__Calendar, cv, mark);
        callXS(boot_ICU__DateFormat, cv, mark);
        callXS(boot_ICU__DateFormatSymbols, cv, mark);
        callXS(boot_ICU__DecimalFormatSymbols, cv, mark);
        callXS(boot_ICU__Locale, cv, mark);
        callXS(boot_ICU__MessageFormat, cv, mark);
        callXS(boot_ICU__Normalizer, cv, mark);
        callXS(boot_ICU__NumberFormat, cv, mark);
        callXS(boot_ICU__TimeZone, cv, mark);
        callXS(boot_ICU__UConverter, cv, mark);
        callXS(boot_ICU__Unicode, cv, mark);

