# Generated by default/object.tt
package Paws::Quicksight::UIColorPalette;
  use Moose;
  has Accent => (is => 'ro', isa => 'Str');
  has AccentForeground => (is => 'ro', isa => 'Str');
  has Danger => (is => 'ro', isa => 'Str');
  has DangerForeground => (is => 'ro', isa => 'Str');
  has Dimension => (is => 'ro', isa => 'Str');
  has DimensionForeground => (is => 'ro', isa => 'Str');
  has Measure => (is => 'ro', isa => 'Str');
  has MeasureForeground => (is => 'ro', isa => 'Str');
  has PrimaryBackground => (is => 'ro', isa => 'Str');
  has PrimaryForeground => (is => 'ro', isa => 'Str');
  has SecondaryBackground => (is => 'ro', isa => 'Str');
  has SecondaryForeground => (is => 'ro', isa => 'Str');
  has Success => (is => 'ro', isa => 'Str');
  has SuccessForeground => (is => 'ro', isa => 'Str');
  has Warning => (is => 'ro', isa => 'Str');
  has WarningForeground => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::Quicksight::UIColorPalette

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Quicksight::UIColorPalette object:

  $service_obj->Method(Att1 => { Accent => $value, ..., WarningForeground => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Quicksight::UIColorPalette object:

  $result = $service_obj->Method(...);
  $result->Att1->Accent

=head1 DESCRIPTION

The theme colors that apply to UI and to charts, excluding data colors.
The colors description is a hexadecimal color code that consists of six
alphanumerical characters, prefixed with C<#>, for example #37BFF5. For
more information, see Using Themes in Amazon QuickSight
(https://docs.aws.amazon.com/quicksight/latest/user/themes-in-quicksight.html)
in the I<Amazon QuickSight User Guide.>

=head1 ATTRIBUTES


=head2 Accent => Str

This color is that applies to selected states and buttons.


=head2 AccentForeground => Str

The foreground color that applies to any text or other elements that
appear over the accent color.


=head2 Danger => Str

The color that applies to error messages.


=head2 DangerForeground => Str

The foreground color that applies to any text or other elements that
appear over the error color.


=head2 Dimension => Str

The color that applies to the names of fields that are identified as
dimensions.


=head2 DimensionForeground => Str

The foreground color that applies to any text or other elements that
appear over the dimension color.


=head2 Measure => Str

The color that applies to the names of fields that are identified as
measures.


=head2 MeasureForeground => Str

The foreground color that applies to any text or other elements that
appear over the measure color.


=head2 PrimaryBackground => Str

The background color that applies to visuals and other high emphasis
UI.


=head2 PrimaryForeground => Str

The color of text and other foreground elements that appear over the
primary background regions, such as grid lines, borders, table banding,
icons, and so on.


=head2 SecondaryBackground => Str

The background color that applies to the sheet background and sheet
controls.


=head2 SecondaryForeground => Str

The foreground color that applies to any sheet title, sheet control
text, or UI that appears over the secondary background.


=head2 Success => Str

The color that applies to success messages, for example the check mark
for a successful download.


=head2 SuccessForeground => Str

The foreground color that applies to any text or other elements that
appear over the success color.


=head2 Warning => Str

This color that applies to warning and informational messages.


=head2 WarningForeground => Str

The foreground color that applies to any text or other elements that
appear over the warning color.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Quicksight>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

