/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.PendingUpdateList;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.PathMap;
import net.sf.saxon.om.FunctionItem;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.Navigator;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.IntegerRange;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Value;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Literal
extends Expression {
    private Value value;

    public Literal(Value value) {
        this.value = value;
    }

    public static Literal makeLiteral(Value value) {
        if (value instanceof StringValue) {
            return new StringLiteral((StringValue)value);
        }
        return new Literal(value);
    }

    public static Literal makeEmptySequence() {
        return new Literal(EmptySequence.getInstance());
    }

    public Value getValue() {
        return this.value;
    }

    @Override
    public Expression simplify(ExpressionVisitor visitor) {
        try {
            this.value = this.value.reduce();
        }
        catch (XPathException err) {
            throw new AssertionError();
        }
        return this;
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ExpressionVisitor.ContextItemType contextItemType) {
        return this;
    }

    @Override
    public final Expression optimize(ExpressionVisitor visitor, ExpressionVisitor.ContextItemType contextItemType) {
        return this;
    }

    @Override
    public ItemType getItemType(TypeHierarchy th) {
        return this.value.getItemType(th);
    }

    @Override
    public int computeCardinality() {
        if (this.value instanceof EmptySequence) {
            return 8192;
        }
        if (this.value instanceof AtomicValue) {
            return 16384;
        }
        try {
            SequenceIterator iter = this.value.iterate();
            Object next = iter.next();
            if (next == null) {
                return 8192;
            }
            if (iter.next() != null) {
                return 49152;
            }
            return 16384;
        }
        catch (XPathException err) {
            return 57344;
        }
    }

    @Override
    public int computeSpecialProperties() {
        if (this.getValue() instanceof EmptySequence) {
            return 0xEFF0000;
        }
        return 0x400000;
    }

    @Override
    public IntegerValue[] getIntegerBounds() {
        if (this.value instanceof IntegerValue) {
            return new IntegerValue[]{(IntegerValue)this.value, (IntegerValue)this.value};
        }
        if (this.value instanceof IntegerRange) {
            return new IntegerValue[]{Int64Value.makeIntegerValue(((IntegerRange)this.value).getStart()), Int64Value.makeIntegerValue(((IntegerRange)this.value).getEnd())};
        }
        return null;
    }

    @Override
    public boolean isVacuousExpression() {
        try {
            return this.value.getLength() == 0;
        }
        catch (XPathException err) {
            return false;
        }
    }

    @Override
    public Expression copy() {
        return new Literal(this.value);
    }

    @Override
    public PathMap.PathMapNodeSet addToPathMap(PathMap pathMap, PathMap.PathMapNodeSet pathMapNodeSet) {
        return pathMapNodeSet;
    }

    @Override
    public final int getDependencies() {
        return 0;
    }

    @Override
    public SequenceIterator<? extends Item> iterate(XPathContext context) throws XPathException {
        return this.value.iterate();
    }

    public SequenceIterator<? extends Item> iterate() throws XPathException {
        return this.value.iterate();
    }

    @Override
    public Item evaluateItem(XPathContext context) throws XPathException {
        if (this.value instanceof AtomicValue) {
            return (AtomicValue)this.value;
        }
        return this.value.iterate().next();
    }

    @Override
    public void process(XPathContext context) throws XPathException {
        Object it;
        SequenceIterator iter = this.value.iterate();
        SequenceReceiver out = context.getReceiver();
        while ((it = iter.next()) != null) {
            out.append((Item)it, 0, 2);
        }
    }

    @Override
    public CharSequence evaluateAsString(XPathContext context) throws XPathException {
        AtomicValue value = (AtomicValue)this.evaluateItem(context);
        if (value == null) {
            return "";
        }
        return value.getStringValueCS();
    }

    @Override
    public boolean effectiveBooleanValue(XPathContext context) throws XPathException {
        return this.value.effectiveBooleanValue();
    }

    @Override
    public void evaluatePendingUpdates(XPathContext context, PendingUpdateList pul) throws XPathException {
        if (!(this.value instanceof EmptySequence)) {
            super.evaluatePendingUpdates(context, pul);
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Literal)) {
            return false;
        }
        Value v0 = this.value;
        Value v1 = ((Literal)obj).value;
        try {
            Object m1;
            Object m0;
            SequenceIterator i0 = v0.iterate();
            SequenceIterator i1 = v1.iterate();
            do {
                m0 = i0.next();
                m1 = i1.next();
                if (m0 == null && m1 == null) {
                    return true;
                }
                if (m0 == null || m1 == null) {
                    return false;
                }
                boolean n0 = m0 instanceof NodeInfo;
                boolean n1 = m1 instanceof NodeInfo;
                if (n0 != n1) {
                    return false;
                }
                if (!n0 || !n1 || ((NodeInfo)m0).isSameNodeInfo((NodeInfo)m1)) continue;
                return false;
            } while (!(m0 instanceof AtomicValue) || !(m1 instanceof AtomicValue) || ((AtomicValue)m0).isIdentical((AtomicValue)m1) && ((AtomicValue)m0).getTypeLabel() == ((AtomicValue)m1).getTypeLabel());
            return false;
        }
        catch (XPathException err) {
            return false;
        }
    }

    public int hashCode() {
        return this.value.getSchemaComparable().hashCode();
    }

    @Override
    public String toString() {
        return this.value.toString();
    }

    @Override
    public void explain(ExpressionPresenter out) {
        out.startElement("literal");
        if (this.value instanceof EmptySequence) {
            out.emitAttribute("value", "()");
        } else if (this.value instanceof AtomicValue) {
            out.emitAttribute("value", ((AtomicValue)this.value).getStringValue());
            out.emitAttribute("type", ((AtomicValue)this.value).getTypeLabel().getDisplayName());
        } else {
            try {
                out.emitAttribute("count", this.value.getLength() + "");
                if (this.value.getLength() < 20) {
                    Item it;
                    SequenceIterator<? extends Item> iter = this.iterate();
                    while ((it = iter.next()) != null) {
                        if (it instanceof NodeInfo) {
                            out.startElement("node");
                            out.emitAttribute("path", Navigator.getPath((NodeInfo)it));
                            out.emitAttribute("uri", ((NodeInfo)it).getSystemId());
                            out.endElement();
                            continue;
                        }
                        if (it instanceof AtomicValue) {
                            out.startElement("atomicValue");
                            out.emitAttribute("value", it.getStringValue());
                            out.emitAttribute("type", ((AtomicValue)it).getTypeLabel().getDisplayName());
                            out.endElement();
                            continue;
                        }
                        if (!(it instanceof FunctionItem)) continue;
                        out.startElement("functionItem");
                        if (((FunctionItem)it).getFunctionName() != null) {
                            out.emitAttribute("name", ((FunctionItem)it).getFunctionName().getDisplayName());
                        }
                        out.emitAttribute("arity", "" + ((FunctionItem)it).getArity());
                        out.endElement();
                    }
                }
            }
            catch (XPathException xPathException) {
                // empty catch block
            }
        }
        out.endElement();
    }

    public static boolean isAtomic(Expression exp) {
        return exp instanceof Literal && ((Literal)exp).getValue() instanceof AtomicValue;
    }

    public static boolean isEmptySequence(Expression exp) {
        return exp instanceof Literal && ((Literal)exp).getValue() instanceof EmptySequence;
    }

    public static boolean isConstantBoolean(Expression exp, boolean value) {
        if (exp instanceof Literal) {
            Value b = ((Literal)exp).getValue();
            return b instanceof BooleanValue && ((BooleanValue)b).getBooleanValue() == value;
        }
        return false;
    }

    public static boolean isConstantOne(Expression exp) {
        if (exp instanceof Literal) {
            Value v = ((Literal)exp).getValue();
            return v instanceof Int64Value && ((Int64Value)v).longValue() == 1L;
        }
        return false;
    }

    @Override
    public boolean isSubtreeExpression() {
        return true;
    }
}

