package Number::MuPhone::Parser::IL;
use strict;
use warnings;
use Moo;

extends 'Number::MuPhone::Parser';

sub config { 
  return {
  'nationalPrefixFormattingRule'=>'$FG',
  'availableFormats'=>{
                          'numberFormat'=>[
                                              {
                                                'nationalPrefixFormattingRule'=>'$NP$FG',
                                                'pattern'=>'([2-489])(\\d{3})(\\d{4})',
                                                'format'=>'$1-$2-$3',
                                                'leadingDigits'=>'[2-489]'
                                              },
                                              {
                                                'pattern'=>'([57]\\d)(\\d{3})(\\d{4})',
                                                'nationalPrefixFormattingRule'=>'$NP$FG',
                                                'leadingDigits'=>'[57]',
                                                'format'=>'$1-$2-$3'
                                              },
                                              {
                                                'leadingDigits'=>'153',
                                                'format'=>'$1 $2 $3 $4',
                                                'pattern'=>'(153)(\\d{1,2})(\\d{3})(\\d{4})'
                                              },
                                              {
                                                'pattern'=>'(1)([7-9]\\d{2})(\\d{3})(\\d{3})',
                                                'leadingDigits'=>'1[7-9]',
                                                'format'=>'$1-$2-$3-$4'
                                              },
                                              {
                                                'pattern'=>'(1255)(\\d{3})',
                                                'format'=>'$1-$2',
                                                'leadingDigits'=>'125'
                                              },
                                              {
                                                'pattern'=>'(1200)(\\d{3})(\\d{3})',
                                                'format'=>'$1-$2-$3',
                                                'leadingDigits'=>'120'
                                              },
                                              {
                                                'pattern'=>'(1212)(\\d{2})(\\d{2})',
                                                'leadingDigits'=>'121',
                                                'format'=>'$1-$2-$3'
                                              },
                                              {
                                                'pattern'=>'(1599)(\\d{6})',
                                                'format'=>'$1-$2',
                                                'leadingDigits'=>'1599'
                                              },
                                              {
                                                'pattern'=>'(151)(\\d{1,2})(\\d{3})(\\d{4})',
                                                'format'=>'$1-$2 $3-$4',
                                                'leadingDigits'=>'151'
                                              },
                                              {
                                                'format'=>'*$1',
                                                'leadingDigits'=>'[2-689]',
                                                'pattern'=>'(\\d{4})'
                                              }
                                            ]
                        },
  'noInternationalDialling'=>{
                               'possibleLengths'=>{
                                                    'national'=>'4,10'
                                                  },
                               'nationalNumberPattern'=>'1700\\d{6}|[2-689]\\d{3}',
                               'exampleNumber'=>'1700123456'
                             },
  'tollFree'=>{
                'possibleLengths'=>{
                                     'national'=>'7,10'
                                   },
                'nationalNumberPattern'=>'1(?:80[019]\\d{3}|255)\\d{3}',
                'exampleNumber'=>'1800123456'
              },
  'generalDesc'=>{
                   'nationalNumberPattern'=>'1\\d{6,11}|[2-589]\\d{3}(?:\\d{3,6})?|6\\d{3}|7\\d{6,9}'
                 },
  'nationalPrefix'=>'0',
  'fixedLine'=>{
                 'possibleLengths'=>{
                                      'localOnly'=>'7',
                                      'national'=>'8,11,12'
                                    },
                 'nationalNumberPattern'=>'(?:153\\d{1,2}|[2-489])\\d{7}',
                 'exampleNumber'=>'21234567'
               },
  'mobile'=>{
              'possibleLengths'=>{
                                   'national'=>'9'
                                 },
              'nationalNumberPattern'=>'5(?:[0-47-9]\\d{2}|5(?:01|2[23]|3[2-4]|4[45]|5[5689]|6[6-8]|7[0178]|8[6-9]|9[2-9])|6[2-9]\\d)\\d{5}',
              'exampleNumber'=>'501234567'
            },
  'references'=>{
                  'sourceUrl'=>[
                                 'http://www.itu.int/oth/T020200006A/en',
                                 'http://en.wikipedia.org/wiki/%2B972',
                                 'http://he.wikipedia.org/wiki/%D7%A7%D7%99%D7%93%D7%95%D7%9E%D7%AA_%D7%98%D7%9C%D7%A4%D7%95%D7%9F_%D7%91%D7%99%D7%A9%D7%A8%D7%90%D7%9C'
                               ]
                },
  'mobileNumberPortableRegion'=>'true',
  'countryCode'=>'972',
  'internationalPrefix'=>'0(?:0|1[2-9])',
  'CountryCode'=>'IL',
  'TerritoryName'=>'Israel',
  'voicemail'=>{
                 'possibleLengths'=>{
                                      'national'=>'11,12'
                                    },
                 'nationalNumberPattern'=>'151\\d{8,9}',
                 'exampleNumber'=>'15112340000'
               },
  'premiumRate'=>{
                   'exampleNumber'=>'1919123456',
                   'possibleLengths'=>{
                                        'national'=>'[8-10]'
                                      },
                   'nationalNumberPattern'=>'1(?:212|(?:9(?:0[01]|19)|200)\\d{2})\\d{4}'
                 },
  'voip'=>{
            'nationalNumberPattern'=>'7(?:18\\d|2[23]\\d|3[237]\\d|47\\d|6[58]\\d|7\\d{2}|8(?:2\\d|33|55|77|81)|9[2579]\\d)\\d{5}',
            'possibleLengths'=>{
                                 'national'=>'9'
                               },
            'exampleNumber'=>'771234567'
          },
  'uan'=>{
           'nationalNumberPattern'=>'[2-689]\\d{3}|1599\\d{6}',
           'possibleLengths'=>{
                                'national'=>'4,10'
                              },
           'exampleNumber'=>'1599123456'
         },
  'sharedCost'=>{
                  'nationalNumberPattern'=>'1700\\d{6}',
                  'possibleLengths'=>{
                                       'national'=>'10'
                                     },
                  'exampleNumber'=>'1700123456'
                }
}
;
}

1;
