# Generated by default/object.tt
package Paws::ManagedBlockchain::NodeEthereumAttributes;
  use Moose;
  has HttpEndpoint => (is => 'ro', isa => 'Str');
  has WebSocketEndpoint => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::ManagedBlockchain::NodeEthereumAttributes

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::ManagedBlockchain::NodeEthereumAttributes object:

  $service_obj->Method(Att1 => { HttpEndpoint => $value, ..., WebSocketEndpoint => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::ManagedBlockchain::NodeEthereumAttributes object:

  $result = $service_obj->Method(...);
  $result->Att1->HttpEndpoint

=head1 DESCRIPTION

Attributes of an Ethereum node.

=head1 ATTRIBUTES


=head2 HttpEndpoint => Str

The endpoint on which the Ethereum node listens to run Ethereum
JSON-RPC methods over HTTP connections from a client. Use this endpoint
in client code for smart contracts when using an HTTP connection.
Connections to this endpoint are authenticated using Signature Version
4
(https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html).


=head2 WebSocketEndpoint => Str

The endpoint on which the Ethereum node listens to run Ethereum
JSON-RPC methods over WebSockets connections from a client. Use this
endpoint in client code for smart contracts when using a WebSockets
connection. Connections to this endpoint are authenticated using
Signature Version 4
(https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html).



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::ManagedBlockchain>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

