# Generated by default/object.tt
package Paws::SecurityHub::AwsIamUserDetails;
  use Moose;
  has AttachedManagedPolicies => (is => 'ro', isa => 'ArrayRef[Paws::SecurityHub::AwsIamAttachedManagedPolicy]');
  has CreateDate => (is => 'ro', isa => 'Str');
  has GroupList => (is => 'ro', isa => 'ArrayRef[Str|Undef]');
  has Path => (is => 'ro', isa => 'Str');
  has PermissionsBoundary => (is => 'ro', isa => 'Paws::SecurityHub::AwsIamPermissionsBoundary');
  has UserId => (is => 'ro', isa => 'Str');
  has UserName => (is => 'ro', isa => 'Str');
  has UserPolicyList => (is => 'ro', isa => 'ArrayRef[Paws::SecurityHub::AwsIamUserPolicy]');

1;

### main pod documentation begin ###

=head1 NAME

Paws::SecurityHub::AwsIamUserDetails

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SecurityHub::AwsIamUserDetails object:

  $service_obj->Method(Att1 => { AttachedManagedPolicies => $value, ..., UserPolicyList => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SecurityHub::AwsIamUserDetails object:

  $result = $service_obj->Method(...);
  $result->Att1->AttachedManagedPolicies

=head1 DESCRIPTION

Information about an IAM user.

=head1 ATTRIBUTES


=head2 AttachedManagedPolicies => ArrayRef[L<Paws::SecurityHub::AwsIamAttachedManagedPolicy>]

A list of the managed policies that are attached to the user.


=head2 CreateDate => Str

Indicates when the user was created.

Uses the C<date-time> format specified in RFC 3339 section 5.6,
Internet Date/Time Format
(https://tools.ietf.org/html/rfc3339#section-5.6). The value cannot
contain spaces. For example, C<2020-03-22T13:22:13.933Z>.


=head2 GroupList => ArrayRef[Str|Undef]

A list of IAM groups that the user belongs to.


=head2 Path => Str

The path to the user.


=head2 PermissionsBoundary => L<Paws::SecurityHub::AwsIamPermissionsBoundary>

The permissions boundary for the user.


=head2 UserId => Str

The unique identifier for the user.


=head2 UserName => Str

The name of the user.


=head2 UserPolicyList => ArrayRef[L<Paws::SecurityHub::AwsIamUserPolicy>]

The list of inline policies that are embedded in the user.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SecurityHub>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

