# automatically generated file, don't edit



# Copyright 2023 David Cantrell, derived from data from libphonenumber
# http://code.google.com/p/libphonenumber/
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
package Number::Phone::StubCountry::BR;
use base qw(Number::Phone::StubCountry);

use strict;
use warnings;
use utf8;
our $VERSION = 1.20230307181417;

my $formatters = [
                {
                  'format' => '$1',
                  'intl_format' => 'NA',
                  'leading_digits' => '
            1(?:
              1[25-8]|
              2[357-9]|
              3[02-68]|
              4[12568]|
              5|
              6[0-8]|
              8[015]|
              9[0-47-9]
            )|
            321|
            610
          ',
                  'pattern' => '(\\d{3,6})'
                },
                {
                  'format' => '$1-$2',
                  'leading_digits' => '
            4(?:
              02|
              37
            )0|
            [34]00
          ',
                  'pattern' => '(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1-$2',
                  'intl_format' => 'NA',
                  'leading_digits' => '
            [2357]|
            4(?:
              [0-24-9]|
              3(?:
                [0-689]|
                7[1-9]
              )
            )
          ',
                  'pattern' => '(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            (?:
              [358]|
              90
            )0
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{2,3})(\\d{4})'
                },
                {
                  'format' => '$1-$2',
                  'intl_format' => 'NA',
                  'leading_digits' => '9',
                  'pattern' => '(\\d{5})(\\d{4})'
                },
                {
                  'format' => '$1 $2-$3',
                  'leading_digits' => '
            (?:
              [14689][1-9]|
              2[12478]|
              3[1-578]|
              5[13-5]|
              7[13-579]
            )[2-57]
          ',
                  'national_rule' => '($1)',
                  'pattern' => '(\\d{2})(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1 $2-$3',
                  'leading_digits' => '
            [16][1-9]|
            [2-57-9]
          ',
                  'national_rule' => '($1)',
                  'pattern' => '(\\d{2})(\\d{5})(\\d{4})'
                }
              ];

my $validators = {
                'fixed_line' => '
          (?:
            [14689][1-9]|
            2[12478]|
            3[1-578]|
            5[13-5]|
            7[13-579]
          )[2-5]\\d{7}
        ',
                'geographic' => '
          (?:
            [14689][1-9]|
            2[12478]|
            3[1-578]|
            5[13-5]|
            7[13-579]
          )[2-5]\\d{7}
        ',
                'mobile' => '
          (?:
            [14689][1-9]|
            2[12478]|
            3[1-578]|
            5[13-5]|
            7[13-579]
          )(?:
            7|
            9\\d
          )\\d{7}
        ',
                'pager' => '',
                'personal_number' => '',
                'specialrate' => '(
          (?:
            30[03]\\d{3}|
            4(?:
              0(?:
                0\\d|
                20
              )|
              370
            )
          )\\d{4}|
          300\\d{5}
        )|(
          300\\d{6}|
          [59]00\\d{6,7}
        )',
                'toll_free' => '800\\d{6,7}',
                'voip' => ''
              };
my %areanames = ();
$areanames{pt} = {"5561", "Distrito\ Federal",};
$areanames{en} = {"55223865", "São\ João\ do\ Paraíso\ \-\ RJ",
"55433548", "Sapopema\ \-\ PR",
"55493258", "Cerro\ Negro\ \-\ SC",
"55743528", "Umburanas\ \-\ BA",
"55963424", "Pracuúba\ \-\ AP",
"55692183", "Ji\-Paraná\ \-\ RO",
"55282101", "Cachoeiro\ de\ Itapemirim\ \-\ ES",
"55323257", "Juiz\ de\ Fora\ \-\ MG",
"55623878", "Goiânia\ \-\ GO",
"55643438", "Domiciano\ Ribeiro\ \-\ GO",
"55913725", "Apeú\ \-\ PA",
"55112087", "Guarulhos\ \-\ SP",
"55613467", "Brasília\ \-\ DF",
"55133506", "Mongaguá\ \-\ SP",
"55443288", "Sarandi\ \-\ PR",
"55624014", "Anápolis\ \-\ GO",
"55333411", "Peçanha\ \-\ MG",
"55623535", "Santo\ Antônio\ de\ Goiás\ \-\ GO",
"55652122", "Cáceres\ \-\ MT",
"55713396", "Simões\ Filho\ \-\ BA",
"55443122", "Maringá\ \-\ PR",
"55463533", "São\ João\ \-\ PR",
"55273759", "Água\ Doce\ do\ Norte\ \-\ ES",
"55423617", "Santa\ Maria\ do\ Oeste\ \-\ PR",
"55133372", "Cubatão\ \-\ SP",
"55283515", "Cachoeiro\ de\ Itapemirim\ \-\ ES",
"55793214", "Aracaju\ \-\ SE",
"55813645", "Feira\ Nova\ \-\ PE",
"55963697", "Chaves\ \-\ PA",
"55115112", "São\ Paulo\ \-\ SP",
"55143342", "Chavantes\ \-\ SP",
"55713656", "São\ Sebastião\ do\ Passé\ \-\ BA",
"55683261", "Humaitá\ \(Pad\ Humaitá\)\ \-\ AC",
"55733531", "Ipiaú\ \-\ BA",
"55673509", "Três\ Lagoas\ \-\ MS",
"55193671", "Casa\ Branca\ \-\ SP",
"55553567", "Campina\ das\ Missões\ \-\ RS",
"55983484", "Afonso\ Cunha\ \-\ MA",
"55213077", "Rio\ de\ Janeiro\ \-\ RJ",
"55813657", "Ferreiros\ \-\ PE",
"55643679", "Sanclerlândia\ \-\ GO",
"55883548", "Altaneira\ \-\ CE",
"55633421", "Araguaína\ \-\ TO",
"55823013", "Maceió\ \-\ AL",
"55433711", "Cambé\ \-\ PR",
"55743259", "Macajuba\ \-\ BA",
"55163221", "Matão\ \-\ SP",
"55493453", "Peritiba\ \-\ SC",
"55933514", "Brasil\ Novo\ \-\ PA",
"55353735", "Caldas\ \-\ MG",
"55133273", "Santos\ \-\ SP",
"55453038", "Cascavel\ \-\ PR",
"55153294", "Ibiúna\ \-\ SP",
"55613625", "Cidade\ Ocidental\ \-\ GO",
"55773682", "Iuiú\ \-\ BA",
"55933589", "Santarém\ \-\ PA",
"55383741", "Pirapora\ \-\ MG",
"55833441", "Catolé\ do\ Rocha\ \-\ PB",
"55823215", "Maceió\ \-\ AL",
"55553737", "Vicente\ Dutra\ \-\ RS",
"554133", "Curitiba\ \-\ PR",
"55513475", "Canoas\ \-\ RS",
"55553522", "Três\ Passos\ \-\ RS",
"55753320", "Itaeté\ \-\ BA",
"55173818", "Bady\ Bassitt\ \-\ SP",
"55843471", "Parelhas\ \-\ RN",
"55453379", "Toledo\ \-\ PR",
"55833629", "São\ Miguel\ de\ Taipu\ \-\ PB",
"55313381", "Belo\ Horizonte\ \-\ MG",
"55843634", "Ceará\-Mirim\ \-\ RN",
"5531356", "Minas\ Gerais",
"55183366", "Quatá\ \-\ SP",
"55623096", "Goiânia\ \-\ GO",
"55663588", "Ipiranga\ do\ Norte\ \-\ MT",
"55343669", "Araxá\ \-\ MG",
"55863346", "São\ José\ do\ Divino\ \-\ PI",
"55943779", "Goianésia\ do\ Pará\ \-\ PA",
"55243351", "Itatiaia\ \-\ RJ",
"55273761", "São\ Mateus\ \-\ ES",
"55113371", "São\ Paulo\ \-\ SP",
"55133856", "Pariquera\-Açu\ \-\ SP",
"55213846", "Duque\ de\ Caxias\ \-\ RJ",
"55483441", "Urussanga\ \-\ SC",
"55513672", "Tapes\ \-\ RS",
"55313615", "Belo\ Horizonte\ \-\ MG",
"55623456", "Divinópolis\ de\ Goiás\ \-\ GO",
"55183571", "Flórida\ Paulista\ \-\ SP",
"55683303", "Rio\ Branco\ \-\ AC",
"55473050", "Camboriú\ \-\ SC",
"55183281", "Presidente\ Epitácio\ \-\ SP",
"55313266", "Minas\ Gerais",
"55843387", "Riacho\ de\ Santana\ \-\ RN",
"55923427", "Juruá\ \-\ AM",
"55313318", "Belo\ Horizonte\ \-\ MG",
"55613503", "Planaltina\ \-\ GO",
"55473059", "São\ Bento\ do\ Sul\ \-\ SC",
"55663511", "Sinop\ \-\ MT",
"55513617", "Rio\ Grande\ do\ Sul",
"55773485", "Carinhanha\ \-\ BA",
"55613044", "Taguatinga\ \-\ DF",
"55893424", "Paquetá\ \-\ PI",
"55813726", "Belo\ Jardim\ \-\ PE",
"55513619", "Rio\ Grande\ do\ Sul",
"55543401", "Farroupilha\ \-\ RS",
"55673521", "Três\ Lagoas\ \-\ MS",
"55383535", "Datas\ \-\ MG",
"55513684", "Tramandaí\ \-\ RS",
"55323202", "Cataguases\ \-\ MG",
"55833494", "Diamante\ \-\ PB",
"55513610", "Rio\ Grande\ do\ Sul",
"55813661", "Palmares\ \-\ PE",
"55313335", "Belo\ Horizonte\ \-\ MG",
"55553551", "Tenente\ Portela\ \-\ RS",
"55353541", "Cássia\ \-\ MG",
"55212479", "São\ Gonçalo\ \-\ RJ",
"55153241", "Ibiúna\ \-\ SP",
"55114538", "Itatiba\ \-\ SP",
"55773431", "Poções\ \-\ BA",
"55473045", "Itajaí\ \-\ SC",
"55163252", "Taquaritinga\ \-\ SP",
"5516396", "Ribeirão\ Preto\ \-\ SP",
"55633364", "Lagoa\ da\ Confusão\ \-\ TO",
"55543368", "Jacutinga\ \-\ RS",
"55473342", "Navegantes\ \-\ SC",
"55513337", "Rio\ Grande\ do\ Sul",
"55753263", "Valente\ \-\ BA",
"55553730", "Vista\ Alegre\ \-\ RS",
"55553224", "Silveira\ Martins\ \-\ RS",
"55453377", "Foz\ do\ Iguaçu\ \-\ PR",
"55373278", "Pequi\ \-\ MG",
"55833627", "Pilõezinhos\ \-\ PB",
"55473624", "Canoinhas\ \-\ SC",
"55913483", "São\ Domingos\ do\ Capim\ \-\ PA",
"55373511", "Divinópolis\ \-\ MG",
"55493562", "Pinheiro\ Preto\ \-\ SC",
"55173122", "São\ José\ do\ Rio\ Preto\ \-\ SP",
"55673254", "Sonora\ \-\ MS",
"55753327", "Lajedinho\ \-\ BA",
"55223841", "Natividade\ \-\ RJ",
"55773674", "Ibipitanga\ \-\ BA",
"55553739", "Taquaruçu\ do\ Sul\ \-\ RS",
"55353292", "Alfenas\ \-\ MG",
"55323261", "São\ João\ Nepomuceno\ \-\ MG",
"55313479", "Minas\ Gerais",
"55243322", "Barra\ Mansa\ \-\ RJ",
"55853326", "Capistrano\ \-\ CE",
"55193716", "Campinas\ \-\ SP",
"55212638", "Maricá\ \-\ RJ",
"55113414", "Itu\ \-\ SP",
"55443646", "Pérola\ Independente\ \-\ PR",
"55673463", "Juti\ \-\ MS",
"55143305", "Piraju\ \-\ SP",
"55993575", "Graça\ Aranha\ \-\ MA",
"55453015", "Cascavel\ \-\ PR",
"55313470", "Minas\ Gerais",
"55733626", "Núcleo\ Colonial\ de\ Una\ \-\ BA",
"55543462", "Garibaldi\ \-\ RS",
"55473448", "Balneário\ Barra\ do\ Sul\ \-\ SC",
"55115693", "São\ Paulo\ \-\ SP",
"55353825", "Itutinga\ \-\ MG",
"55114496", "Itupeva\ \-\ SP",
"55643677", "Amorinópolis\ \-\ GO",
"55133384", "Guarujá\ \-\ SP",
"55493527", "Joaçaba\ \-\ SC",
"55163693", "Jardinópolis\ \-\ SP",
"55153336", "Sorocaba\ \-\ SP",
"5516363", "Ribeirão\ Preto\ \-\ SP",
"55343425", "Frutal\ \-\ MG",
"55753362", "Boa\ Vista\ Cananéia\ \-\ BA",
"55483465", "Urussanga\ \-\ SC",
"55873781", "Canhotinho\ \-\ PE",
"55273745", "Águia\ Branca\ \-\ ES",
"55543354", "Esmeralda\ \-\ RS",
"55633358", "Dueré\ \-\ TO",
"55674001", "Campo\ Grande\ \-\ MS",
"55643018", "Itumbiara\ \-\ GO",
"55183916", "Presidente\ Prudente\ \-\ SP",
"55893576", "Cristalândia\ do\ Piauí\ \-\ PI",
"55983472", "Brejo\ \-\ MA",
"55162132", "Ribeirão\ Preto\ \-\ SP",
"55643612", "Rio\ Verde\ \-\ GO",
"55283538", "Atilio\ Vivacqua\ \-\ ES",
"55273757", "Ponto\ Belo\ \-\ ES",
"55863285", "Elesbão\ Veloso\ \-\ PI",
"5517332", "Barretos\ \-\ SP",
"55843256", "Boa\ Saúde\ \-\ RN",
"55653346", "Nortelândia\ \-\ MT",
"55173483", "Nova\ Luzitânia\ \-\ SP",
"55613304", "Guará\ \-\ DF",
"55163209", "Jaboticabal\ \-\ SP",
"55623518", "Aparecida\ de\ Goiânia\ \-\ GO",
"55633452", "Nova\ Olinda\ \-\ TO",
"55163353", "Ibaté\ \-\ SP",
"55623581", "Goiânia\ \-\ GO",
"55273275", "Aracruz\ \-\ ES",
"55983378", "Pedro\ do\ Rosário\ \-\ MA",
"55674062", "Campo\ Grande\ \-\ MS",
"55412118", "Curitiba\ \-\ PR",
"55673268", "Bodoquena\ \-\ MS",
"55553643", "Boa\ Vista\ do\ Cadeado\ \-\ RS",
"55113907", "São\ Bernardo\ do\ Campo\ \-\ SP",
"55353653", "Conceição\ dos\ Ouros\ \-\ MG",
"55323250", "Juiz\ de\ Fora\ \-\ MG",
"55213432", "Rio\ de\ Janeiro\ \-\ RJ",
"55753301", "Feira\ de\ Santana\ \-\ BA",
"5531382", "Ipatinga\ \-\ MG",
"55714116", "Dias\ d\'Ávila\ \-\ BA",
"55853092", "Fortaleza\ \-\ CE",
"55623351", "Campos\ Verdes\ \-\ GO",
"55843423", "Jardim\ de\ Piranhas\ \-\ RN",
"5531347", "Belo\ Horizonte\ \-\ MG",
"55213175", "Nilópolis\ \-\ RJ",
"55183605", "Santópolis\ do\ Aguapeí\ \-\ SP",
"55483346", "São\ José\ \-\ SC",
"55333521", "Teófilo\ Otoni\ \-\ MG",
"5511348", "São\ Paulo\ \-\ SP",
"55314002", "Belo\ Horizonte\ \-\ MG",
"55273347", "Vitória\ \-\ ES",
"55122136", "São\ José\ dos\ Campos\ \-\ SP",
"55713604", "Madre\ de\ Deus\ \-\ BA",
"55193898", "Lindóia\ \-\ SP",
"55683213", "Rio\ Branco\ \-\ AC",
"55922125", "Manaus\ \-\ AM",
"55953532", "Caracaraí\ \-\ RR",
"55323379", "São\ João\ Del\ Rei\ \-\ MG",
"55273355", "Vitória\ \-\ ES",
"55163273", "Itápolis\ \-\ SP",
"55773616", "Formosa\ do\ Rio\ Preto\ \-\ BA",
"55114667", "Itapecerica\ da\ Serra\ \-\ SP",
"55352103", "Pouso\ Alegre\ \-\ MG",
"55823305", "Maceió\ \-\ AL",
"55853358", "Tururu\ \-\ CE",
"55193855", "Socorro\ \-\ SP",
"55333254", "Perpétuo\ Socorro\ \-\ MG",
"55383223", "Montes\ Claros\ \-\ MG",
"55663407", "Barra\ do\ Garças\ \-\ MT",
"55843376", "Viçosa\ \-\ RN",
"55354102", "Pouso\ Alegre\ \-\ MG",
"55543519", "Erechim\ \-\ RS",
"55753646", "Guaibim\ \-\ BA",
"55183402", "Assis\ \-\ SP",
"55115103", "São\ Paulo\ \-\ SP",
"55513565", "Nova\ Hartz\ \-\ RS",
"55193847", "Jaguariúna\ \-\ SP",
"55873991", "Vermelho\ \-\ PE",
"55883614", "Sobral\ \-\ CE",
"55543584", "Passo\ Fundo\ \-\ RS",
"55833346", "Barra\ de\ Santana\ \-\ PB",
"55143885", "Pirambóia\ \-\ SP",
"55313522", "Minas\ Gerais",
"55883533", "Campos\ Sales\ \-\ CE",
"55313820", "Minas\ Gerais",
"55843228", "Ceará\-Mirim\ \-\ RN",
"55923306", "Manaus\ \-\ AM",
"55553412", "Uruguaiana\ \-\ RS",
"55114622", "Santana\ de\ Parnaíba\ \-\ SP",
"55983264", "São\ Luís\ \-\ MA",
"55453257", "Entre\ Rios\ do\ Oeste\ \-\ PR",
"55313737", "Minas\ Gerais",
"55623404", "Assunção\ de\ Goiás\ \-\ GO",
"55513594", "Novo\ Hamburgo\ \-\ RS",
"55163506", "Matão\ \-\ SP",
"55323556", "São\ Geraldo\ \-\ MG",
"55114028", "Salto\ \-\ SP",
"55483231", "Florianópolis\ \-\ SC",
"55113188", "São\ Paulo\ \-\ SP",
"55793304", "Aracaju\ \-\ SE",
"55463548", "Bom\ Jesus\ do\ Sul\ \-\ PR",
"55453245", "Braganey\ \-\ PR",
"55983453", "Arari\ \-\ MA",
"55112623", "São\ Paulo\ \-\ SP",
"55513735", "Várzea\ do\ Capivarita\ \-\ RS",
"55663563", "Paranaíta\ \-\ MT",
"55893580", "Dom\ Inocêncio\ \-\ PI",
"55163951", "Cravinhos\ \-\ SP",
"55663421", "Rondonópolis\ \-\ MT",
"55553318", "Jóia\ \-\ RS",
"55653054", "Cuiabá\ \-\ MT",
"55633473", "Xambioá\ \-\ TO",
"55643443", "Catalão\ \-\ GO",
"55984009", "São\ Luís\ \-\ MA",
"55193623", "São\ João\ da\ Boa\ Vista\ \-\ SP",
"55553266", "Nova\ Palma\ \-\ RS",
"55173329", "Alberto\ Moreira\ \-\ SP",
"55893589", "Caracol\ \-\ PI",
"55543046", "Passo\ Fundo\ \-\ RS",
"55222556", "São\ Sebastião\ do\ Alto\ \-\ RJ",
"55143433", "Marília\ \-\ SP",
"55923572", "São\ Sebastião\ do\ Uatumã\ \-\ AM",
"55163075", "Ribeirão\ Preto\ \-\ SP",
"55613577", "Brasília\ \-\ DF",
"55553615", "Santa\ Margarida\ do\ Sul\ \-\ RS",
"55333316", "Pocrane\ \-\ MG",
"55333268", "Aimorés\ \-\ MG",
"55853364", "Umirim\ \-\ CE",
"55553381", "São\ Miguel\ das\ Missões\ \-\ RS",
"55433533", "Panema\ \-\ PR",
"55713051", "Lauro\ de\ Freitas\ \-\ BA",
"5513331", "Bertioga\ \-\ SP",
"55192111", "Rio\ Claro\ \-\ SP",
"55353339", "São\ Lourenço\ \-\ MG",
"55823624", "Pão\ de\ Açúcar\ \-\ AL",
"55753211", "Feira\ de\ Santana\ \-\ BA",
"55673488", "Aral\ Moreira\ \-\ MS",
"55473238", "Blumenau\ \-\ SC",
"55833285", "Gurinhém\ \-\ PB",
"55114706", "Barueri\ \-\ SP",
"55923877", "Manaus\ \-\ AM",
"55993627", "Bacabal\ \-\ MA",
"55643686", "Moiporá\ \-\ GO",
"55463225", "Pato\ Branco\ \-\ PR",
"55123116", "Bananal\ \-\ SP",
"55923584", "Manaus\ \-\ AM",
"55183642", "Birigui\ \-\ SP",
"5524336", "Angra\ dos\ Reis\ \-\ RJ",
"55313551", "Ouro\ Preto\ \-\ MG",
"55553335", "Eugênio\ de\ Castro\ \-\ RS",
"55513541", "Taquara\ \-\ RS",
"55643946", "Itumbiara\ \-\ GO",
"55893587", "Dirceu\ Arcoverde\ \-\ PI",
"55793276", "Pirambu\ \-\ SE",
"55613214", "Brasília\ \-\ DF",
"55163384", "Matão\ \-\ SP",
"55212730", "Rio\ de\ Janeiro\ \-\ RJ",
"55553032", "Santa\ Maria\ \-\ RS",
"55173263", "Mirassolândia\ \-\ SP",
"55673411", "Dourados\ \-\ MS",
"55114651", "Arujá\ \-\ SP",
"55913468", "Capitão\ Poço\ \-\ PA",
"55472033", "Balneário\ Camboriú\ \-\ SC",
"55543383", "Espumoso\ \-\ RS",
"55153431", "Itararé\ \-\ SP",
"55713444", "Salvador\ \-\ BA",
"55913796", "Mocajuba\ \-\ PA",
"55513718", "Vera\ Cruz\ \-\ RS",
"55813613", "Limoeiro\ \-\ PE",
"55183324", "Assis\ \-\ SP",
"55413375", "São\ José\ dos\ Pinhais\ \-\ PR",
"55283543", "Ibatiba\ \-\ ES",
"55453259", "São\ José\ das\ Palmeiras\ \-\ PR",
"55223081", "Macaé\ \-\ RJ",
"55133209", "Santos\ \-\ SP",
"55513781", "Rio\ Grande\ do\ Sul",
"55713628", "Arembepe\ \-\ BA",
"55663452", "Novo\ São\ Joaquim\ \-\ MT",
"55313827", "Minas\ Gerais",
"55313739", "Minas\ Gerais",
"55313730", "Minas\ Gerais",
"55373421", "Luz\ \-\ MG",
"55413678", "Adrianópolis\ \-\ PR",
"55823342", "Maceió\ \-\ AL",
"55483285", "Biguaçu\ \-\ SC",
"55423653", "Rio\ Bonito\ do\ Iguaçu\ \-\ PR",
"55623367", "Porangatu\ \-\ GO",
"55273021", "Guarapari\ \-\ ES",
"55212643", "Teresópolis\ \-\ RJ",
"55312591", "Betim\ \-\ MG",
"55193849", "Valinhos\ \-\ SP",
"55613356", "Taguatinga\ \-\ DF",
"55983181", "São\ Luís\ \-\ MA",
"55173301", "São\ José\ do\ Rio\ Preto\ \-\ SP",
"55543282", "Canela\ \-\ RS",
"55643603", "Iporá\ \-\ GO",
"55114783", "Embu\ das\ Artes\ \-\ SP",
"55193542", "Araras\ \-\ SP",
"55612141", "Brasília\ \-\ DF",
"55693532", "Cacaulândia\ \-\ RO",
"55813534", "Escada\ \-\ PE",
"55993601", "Feira\ Nova\ do\ Maranhão\ \-\ MA",
"55943786", "Breu\ Branco\ \-\ PA",
"55343515", "Patrocínio\ \-\ MG",
"55114669", "Itapecerica\ da\ Serra\ \-\ SP",
"55143666", "Bocaina\ \-\ SP",
"55313862", "Alvorada\ de\ Minas\ \-\ MG",
"55743632", "Mairi\ \-\ BA",
"55683901", "Rio\ Branco\ \-\ AC",
"55963212", "Macapá\ \-\ AP",
"55813758", "Barra\ de\ Guabiraba\ \-\ PE",
"55513653", "Taquari\ \-\ RS",
"55433334", "Londrina\ \-\ PR",
"55993662", "Dom\ Pedro\ \-\ MA",
"55733021", "Prado\ \-\ BA",
"55123634", "Taubaté\ \-\ SP",
"55112849", "São\ Paulo\ \-\ SP",
"55493030", "Concórdia\ \-\ SC",
"55323312", "Juiz\ de\ Fora\ \-\ MG",
"55493675", "Riqueza\ \-\ SC",
"55953194", "Boa\ Vista\ \-\ RR",
"55133828", "Registro\ \-\ SP",
"55323015", "Juiz\ de\ Fora\ \-\ MG",
"55173362", "Marcondésia\ \-\ SP",
"55112840", "Salto\ \-\ SP",
"55423132", "Irati\ \-\ PR",
"55473544", "Trombudo\ Central\ \-\ SC",
"55183266", "Alfredo\ Marcondes\ \-\ SP",
"55833547", "Vieirópolis\ \-\ PB",
"55613559", "Samambaia\ Sul\ \-\ DF",
"55513239", "Rio\ Grande\ do\ Sul",
"55413398", "São\ José\ dos\ Pinhais\ \-\ PR",
"55113518", "São\ Paulo\ \-\ SP",
"55513724", "Cachoeira\ do\ Sul\ \-\ RS",
"55653611", "Cuiabá\ \-\ MT",
"5544322", "Maringá\ \-\ PR",
"55812119", "Recife\ \-\ PE",
"55843287", "Lagoa\ D\'Anta\ \-\ RN",
"55652123", "Cuiabá\ \-\ MT",
"55313571", "Brumadinho\ \-\ MG",
"55793256", "Nossa\ Senhora\ do\ Socorro\ \-\ SE",
"55443123", "Maringá\ \-\ PR",
"55733546", "Nova\ Itarana\ \-\ BA",
"55443526", "Formosa\ do\ Oeste\ \-\ PR",
"55113581", "Barueri\ \-\ SP",
"55163321", "Tabatinga\ \-\ SP",
"55634007", "Palmas\ \-\ TO",
"55463532", "Quedas\ do\ Iguaçu\ \-\ PR",
"55353449", "Pouso\ Alegre\ \-\ MG",
"55212792", "Nilópolis\ \-\ RJ",
"55153394", "Ibiúna\ \-\ SP",
"55353621", "Itajubá\ \-\ MG",
"55143343", "Canitar\ \-\ SP",
"55923521", "Itacoatiara\ \-\ AM",
"55673429", "Vila\ Macaúba\ \-\ MS",
"55453270", "Iguiporã\ \-\ PR",
"55493364", "Serra\ Alta\ \-\ SC",
"55192127", "Campinas\ \-\ SP",
"55413658", "Bocaiúva\ do\ Sul\ \-\ PR",
"55663472", "Serra\ Dourada\ \-\ MT",
"55173631", "Santa\ Fé\ do\ Sul\ \-\ SP",
"554132", "Curitiba\ \-\ PR",
"55423026", "Ponta\ Grossa\ \-\ PR",
"55453279", "Quatro\ Pontes\ \-\ PR",
"5563341", "Araguaína\ \-\ TO",
"55133272", "Santos\ \-\ SP",
"55623921", "Goiânia\ \-\ GO",
"55493452", "Seara\ \-\ SC",
"55613561", "Taguatinga\ \-\ DF",
"55793314", "Itabi\ \-\ SE",
"55773683", "Jaborandi\ \-\ BA",
"55443482", "Paranavaí\ \-\ PR",
"55543552", "Cacique\ Doble\ \-\ RS",
"55242291", "Petrópolis\ \-\ RJ",
"55733084", "Ilhéus\ \-\ BA",
"55553402", "Uruguaiana\ \-\ RS",
"55423239", "Ponta\ Grossa\ \-\ PR",
"55343849", "Monte\ Carmelo\ \-\ MG",
"55483436", "Nova\ Veneza\ \-\ SC",
"55553523", "Padre\ Gonzales\ \-\ RS",
"55443685", "Nova\ Olímpia\ \-\ PR",
"55493358", "Cordilheira\ Alta\ \-\ SC",
"55192101", "Campinas\ \-\ SP",
"55244004", "Petrópolis\ \-\ RJ",
"55413664", "Doutor\ Ulysses\ \-\ PR",
"55422102", "Ponta\ Grossa\ \-\ PR",
"55493647", "Palmitos\ \-\ SC",
"55833436", "Vista\ Serrana\ \-\ PB",
"55343131", "Uberlândia\ \-\ MG",
"55633527", "Santa\ Tereza\ do\ Tocantins\ \-\ TO",
"55433051", "Rolândia\ \-\ PR",
"55473205", "Joinville\ \-\ SC",
"55713533", "Salvador\ \-\ BA",
"55115049", "São\ Paulo\ \-\ SP",
"55443311", "Jardim\ Olinda\ \-\ PR",
"55513673", "Mostardas\ \-\ RS",
"55323357", "Coronel\ Xavier\ Chaves\ \-\ MG",
"55663904", "Barra\ do\ Garças\ \-\ MT",
"55743699", "Lapão\ \-\ BA",
"55323424", "Laranjal\ \-\ MG",
"55163307", "São\ Carlos\ \-\ SP",
"55493655", "Campo\ Erê\ \-\ SC",
"55683302", "Rio\ Branco\ \-\ AC",
"55273084", "Vitória\ \-\ ES",
"55713296", "Simões\ Filho\ \-\ BA",
"55123978", "Jambeiro\ \-\ SP",
"55553308", "Ijuí\ \-\ RS",
"55613502", "Luziânia\ \-\ GO",
"55323345", "Alto\ Rio\ Doce\ \-\ MG",
"55813525", "São\ Lourenço\ da\ Mata\ \-\ PE",
"55883444", "Quixeramobim\ \-\ CE",
"55843696", "Caiçara\ do\ Norte\ \-\ RN",
"55623371", "Goiás\ \-\ GO",
"5531345", "Belo\ Horizonte\ \-\ MG",
"55313164", "Santa\ Luzia\ \-\ MG",
"55673665", "Água\ Clara\ \-\ MS",
"55443631", "Cianorte\ \-\ PR",
"55163253", "Taquaritinga\ \-\ SP",
"55983278", "São\ Luís\ \-\ MA",
"55673216", "Sidrolândia\ \-\ MS",
"55623952", "Aparecida\ de\ Goiânia\ \-\ GO",
"55123106", "Silveiras\ \-\ SP",
"55114716", "São\ João\ Novo\ \-\ SP",
"55273072", "Vila\ Velha\ \-\ ES",
"55333744", "Rio\ do\ Prado\ \-\ MG",
"55493649", "Barra\ Bonita\ \-\ SC",
"55473343", "Ilhota\ \-\ SC",
"55883628", "Santa\ Quitéria\ \-\ CE",
"55913311", "Castanhal\ \-\ PA",
"55633520", "Nova\ Rosalândia\ \-\ TO",
"55753201", "Acupe\ \-\ BA",
"55733017", "Ilhéus\ \-\ BA",
"55423237", "Piraí\ do\ Sul\ \-\ PR",
"55913482", "Augusto\ Corrêa\ \-\ PA",
"55743648", "Ibipeba\ \-\ BA",
"55914006", "Belém\ \-\ PA",
"55753262", "Conceição\ do\ Coité\ \-\ BA",
"55343847", "Abadia\ dos\ Dourados\ \-\ MG",
"55634052", "Palmas\ \-\ TO",
"55313916", "Belo\ Horizonte\ \-\ MG",
"55773446", "Aracatu\ \-\ BA",
"55193875", "Indaiatuba\ \-\ SP",
"55343244", "Uberlândia\ \-\ MG",
"55353293", "Areado\ \-\ MG",
"55213198", "Rio\ de\ Janeiro\ \-\ RJ",
"55733678", "Monte\ Pascoal\ \-\ BA",
"55133219", "Santos\ \-\ SP",
"55493563", "Caçador\ \-\ SC",
"5535323", "Três\ Corações\ \-\ MG",
"55643534", "Itumbiara\ \-\ GO",
"55143003", "Bauru\ \-\ SP",
"55193538", "Ajapi\ \-\ SP",
"55373226", "Nova\ Serrana\ \-\ MG",
"55353064", "Poços\ de\ Caldas\ \-\ MG",
"55343855", "Rio\ Paranaíba\ \-\ MG",
"55513708", "Sinimbu\ \-\ RS",
"55112754", "São\ Paulo\ \-\ SP",
"55243323", "Barra\ Mansa\ \-\ RJ",
"55353536", "Itaú\ de\ Minas\ \-\ MG",
"55843356", "Doutor\ Severiano\ \-\ RN",
"55433444", "Arapuã\ \-\ PR",
"55963117", "Macapá\ \-\ AP",
"5517322", "São\ José\ do\ Rio\ Preto\ \-\ SP",
"55863385", "São\ João\ do\ Arraial\ \-\ PI",
"55823338", "Maceió\ \-\ AL",
"55243111", "Petrópolis\ \-\ RJ",
"55943347", "Eldorado\ dos\ Carajás\ \-\ PA",
"55553324", "Cruz\ Alta\ \-\ RS",
"55963261", "Macapá\ \-\ AP",
"55453277", "Toledo\ \-\ PR",
"55323286", "Santo\ Antônio\ do\ Aventureiro\ \-\ MG",
"55192129", "Campinas\ \-\ SP",
"55353455", "São\ João\ da\ Mata\ \-\ MG",
"55544001", "Caxias\ do\ Sul\ \-\ RS",
"55943355", "Marabá\ \-\ PA",
"55323361", "Carandaí\ \-\ MG",
"55162133", "Ribeirão\ Preto\ \-\ SP",
"55643613", "Rio\ Verde\ \-\ GO",
"55193768", "Campinas\ \-\ SP",
"55983473", "Coelho\ Neto\ \-\ MA",
"55663419", "Campo\ Verde\ \-\ MT",
"55173311", "Catanduva\ \-\ SP",
"55663410", "Rondonópolis\ \-\ MT",
"55634009", "Palmas\ \-\ TO",
"55323576", "Dores\ do\ Turvo\ \-\ MG",
"55463234", "Bom\ Sucesso\ do\ Sul\ \-\ PR",
"55193496", "Rafard\ \-\ SP",
"55313888", "Minas\ Gerais",
"55173482", "Auriflama\ \-\ SP",
"55443902", "Paranavaí\ \-\ PR",
"55983326", "Presidente\ Médici\ \-\ MA",
"55633453", "Wanderlândia\ \-\ TO",
"55653331", "Barão\ de\ Melgaço\ \-\ MT",
"55843289", "Serra\ de\ São\ Bento\ \-\ RN",
"55313235", "Belo\ Horizonte\ \-\ MG",
"55183638", "Birigui\ \-\ SP",
"55193056", "São\ João\ da\ Boa\ Vista\ \-\ SP",
"55114014", "Morungaba\ \-\ SP",
"55544062", "Caxias\ do\ Sul\ \-\ RS",
"55113120", "São\ Paulo\ \-\ SP",
"55163352", "Ibitinga\ \-\ SP",
"55473242", "Pomerode\ \-\ SC",
"55113129", "São\ Paulo\ \-\ SP",
"55543268", "Farroupilha\ \-\ RS",
"55513237", "Rio\ Grande\ do\ Sul",
"55213433", "Rio\ de\ Janeiro\ \-\ RJ",
"55813686", "Belém\ de\ Maria\ \-\ PE",
"55753631", "Santo\ Antônio\ de\ Jesus\ \-\ BA",
"55814109", "Paulista\ \-\ PE",
"55883656", "Graça\ \-\ CE",
"55193667", "Mococa\ \-\ SP",
"55843422", "Mossoró\ \-\ RN",
"55683212", "Rio\ Branco\ \-\ AC",
"55553366", "Itacurubi\ \-\ RS",
"55613387", "Sobradinho\ \-\ DF",
"55314003", "Belo\ Horizonte\ \-\ MG",
"55443201", "Campo\ Mourão\ \-\ PR",
"55613634", "Padre\ Bernardo\ \-\ GO",
"55553281", "Caçapava\ do\ Sul\ \-\ RS",
"55653549", "Lucas\ do\ Rio\ Verde\ \-\ MT",
"55553792", "Pinheirinho\ do\ Vale\ \-\ RS",
"55993547", "São\ Raimundo\ das\ Mangabeiras\ \-\ MA",
"55843328", "Governador\ Dix\-Sept\ Rosado\ \-\ RN",
"55823003", "Maceió\ \-\ AL",
"55352102", "Pouso\ Alegre\ \-\ MG",
"55613471", "Ceilândia\ \-\ DF",
"55673274", "Figueirão\ \-\ MS",
"55373258", "Pitangui\ \-\ MG",
"55114774", "Itapevi\ \-\ SP",
"55383222", "Montes\ Claros\ \-\ MG",
"55893435", "Francisco\ Macedo\ \-\ PI",
"55222633", "Armação\ dos\ Búzios\ \-\ RJ",
"55513440", "Rio\ Grande\ do\ Sul",
"55993555", "Pastos\ Bons\ \-\ MA",
"55513621", "Capão\ Novo\ \-\ RS",
"55663527", "Nova\ União\ \-\ MT",
"55115102", "São\ Paulo\ \-\ SP",
"55543908", "Vacaria\ \-\ RS",
"55514112", "Novo\ Hamburgo\ \-\ RS",
"55183522", "Adamantina\ \-\ SP",
"55354103", "Passos\ \-\ MG",
"55453345", "Portão\ Ocoi\ \-\ PR",
"55213002", "Rio\ de\ Janeiro\ \-\ RJ",
"55313459", "Minas\ Gerais",
"55513449", "Rio\ Grande\ do\ Sul",
"55313090", "Belo\ Horizonte\ \-\ MG",
"55813679", "Gameleira\ \-\ PE",
"55553413", "Uruguaiana\ \-\ RS",
"55313402", "Nova\ Lima\ \-\ MG",
"55543031", "Canela\ \-\ RS",
"55323749", "Faria\ Lemos\ \-\ MG",
"55313523", "Sítio\ Novo\ \-\ MG",
"55883532", "Barbalha\ \-\ CE",
"55173808", "Engenheiro\ Schimidt\ \-\ SP",
"55633378", "Ponte\ Alta\ do\ Tocantins\ \-\ TO",
"55913734", "Quatro\ Bocas\ \-\ PA",
"55733247", "Almadina\ \-\ BA",
"55543374", "Ibiaçá\ \-\ RS",
"55613964", "Brasília\ \-\ DF",
"55433141", "Santo\ Antônio\ da\ Platina\ \-\ PR",
"55333354", "Bom\ Jesus\ do\ Galho\ \-\ MG",
"55273138", "Serra\ \-\ ES",
"55643657", "Bom\ Jardim\ de\ Goiás\ \-\ GO",
"55623524", "Goiânia\ \-\ GO",
"55222580", "Nova\ Friburgo\ \-\ RJ",
"55193937", "Jaguariúna\ \-\ SP",
"55843276", "Monte\ Alegre\ \-\ RN",
"55113367", "São\ Paulo\ \-\ SP",
"55333427", "Materlândia\ \-\ MG",
"55793545", "Tomar\ do\ Geru\ \-\ SE",
"55733255", "Camamu\ \-\ BA",
"55112622", "São\ Paulo\ \-\ SP",
"55663562", "Santa\ Carmem\ \-\ MT",
"55973428", "Maraã\ \-\ AM",
"55643645", "Acreúna\ \-\ GO",
"55983395", "Godofredo\ Viana\ \-\ MA",
"55633472", "Araguacema\ \-\ TO",
"55663501", "Alta\ Floresta\ \-\ MT",
"55513607", "Rio\ Grande\ do\ Sul",
"55483246", "São\ José\ \-\ SC",
"55173564", "Catiguá\ \-\ SP",
"55193622", "São\ João\ da\ Boa\ Vista\ \-\ SP",
"55643442", "Catalão\ \-\ GO",
"55533028", "Pelotas\ \-\ RS",
"55983655", "Zé\ Doca\ \-\ MA",
"55773668", "Sebastião\ Laranjeiras\ \-\ BA",
"55733298", "Prado\ \-\ BA",
"55143432", "Marília\ \-\ SP",
"55273255", "Viana\ \-\ ES",
"55133321", "Santos\ \-\ SP",
"55983358", "Penalva\ \-\ MA",
"55433532", "Cambará\ \-\ PR",
"55453286", "Capitão\ Leônidas\ Marques\ \-\ PR",
"55633484", "Campos\ Lindos\ \-\ TO",
"55323277", "Chácara\ \-\ MG",
"55963312", "Macapá\ \-\ AP",
"5575322", "Feira\ de\ Santana\ \-\ BA",
"55213448", "Rio\ de\ Janeiro\ \-\ RJ",
"55123512", "São\ José\ dos\ Campos\ \-\ SP",
"55873834", "Poção\ \-\ PE",
"55112651", "São\ Paulo\ \-\ SP",
"55493278", "Urubici\ \-\ SC",
"55273249", "Paraju\ \-\ ES",
"55753526", "Maragogipe\ \-\ BA",
"55853181", "Fortaleza\ \-\ CE",
"55513600", "Rio\ Grande\ do\ Sul",
"55183643", "Birigui\ \-\ SP",
"55513609", "Rio\ Grande\ do\ Sul",
"55423447", "São\ João\ do\ Triunfo\ \-\ PR",
"5567342", "Dourados\ \-\ MS",
"55222747", "Farol\ de\ São\ Tomé\ \-\ RJ",
"55553033", "Santa\ Maria\ \-\ RS",
"55173262", "Nova\ Granada\ \-\ SP",
"55513536", "Conceição\ \-\ RS",
"55643931", "Itumbiara\ \-\ GO",
"55713676", "Mata\ de\ São\ João\ \-\ BA",
"55273770", "Colatina\ \-\ ES",
"55173201", "São\ José\ do\ Rio\ Preto\ \-\ SP",
"55413073", "Belo\ Horizonte\ \-\ MG",
"55543382", "Alto\ Alegre\ \-\ RS",
"55193706", "Campinas\ \-\ SP",
"55113404", "Bragança\ Paulista\ \-\ SP",
"55513133", "Novo\ Hamburgo\ \-\ RS",
"55183862", "Pacaembu\ \-\ SP",
"55413626", "Mandirituba\ \-\ PR",
"55283542", "Castelo\ \-\ ES",
"55133495", "Praia\ Grande\ \-\ SP",
"55973351", "Beruri\ \-\ AM",
"55323755", "Vieiras\ \-\ MG",
"55343671", "São\ Gotardo\ \-\ MG",
"55513064", "Sapiranga\ \-\ RS",
"55733240", "Gongogi\ \-\ BA",
"55643659", "Itarumã\ \-\ GO",
"55823343", "Maceió\ \-\ AL",
"55423652", "Boa\ Ventura\ de\ São\ Roque\ \-\ PR",
"55323466", "Além\ Paraíba\ \-\ MG",
"55273115", "Linhares\ \-\ ES",
"55323747", "Alto\ Caparaó\ \-\ MG",
"55193651", "Espírito\ Santo\ do\ Pinhal\ \-\ SP",
"55733249", "Barro\ Preto\ \-\ BA",
"55543283", "Caxias\ do\ Sul\ \-\ RS",
"55854007", "Maracanaú\ \-\ CE",
"55614141", "Brasília\ \-\ DF",
"55212642", "Teresópolis\ \-\ RJ",
"55713225", "Feira\ de\ Santana\ \-\ BA",
"55152104", "Sorocaba\ \-\ SP",
"55513447", "Alvorada\ \-\ RS",
"55223066", "Nova\ Friburgo\ \-\ RJ",
"55513766", "Bom\ Retiro\ do\ Sul\ \-\ RS",
"55643602", "Rio\ Verde\ \-\ GO",
"55193543", "Araras\ \-\ SP",
"55663529", "Querência\ \-\ MT",
"55623323", "Ceres\ \-\ GO",
"55693533", "Porto\ Velho\ \-\ RO",
"55313445", "Belo\ Horizonte\ \-\ MG",
"55513455", "Rio\ Grande\ do\ Sul",
"55413585", "Curitiba\ \-\ PR",
"55114131", "Pirapora\ do\ Bom\ Jesus\ \-\ SP",
"55313863", "Ferros\ \-\ MG",
"55743633", "Saúde\ \-\ BA",
"55313324", "Belo\ Horizonte\ \-\ MG",
"55163145", "Patrocínio\ Paulista\ \-\ SP",
"55112783", "São\ Paulo\ \-\ SP",
"55623476", "Colinas\ do\ Tocantins\ \-\ TO",
"55933528", "Novo\ Progresso\ \-\ PA",
"55183551", "Lucélia\ \-\ SP",
"55753311", "Santo\ Antônio\ de\ Jesus\ \-\ BA",
"55833385", "Cubati\ \-\ PB",
"55143846", "Areiópolis\ \-\ SP",
"55353237", "São\ Thomé\ das\ Letras\ \-\ MG",
"55513652", "Butiá\ \-\ RS",
"55993663", "Presidente\ Dutra\ \-\ MA",
"55412108", "Curitiba\ \-\ PR",
"55353834", "Aguanil\ \-\ MG",
"55243371", "Paraty\ \-\ RJ",
"55753685", "Ipecaetá\ \-\ BA",
"55323313", "Juiz\ de\ Fora\ \-\ MG",
"55473635", "São\ Bento\ do\ Sul\ \-\ SC",
"55643661", "Mineiros\ \-\ GO",
"55513498", "Rio\ Grande\ do\ Sul",
"55613389", "Planaltina\ \-\ DF",
"55643405", "Piracanjuba\ \-\ GO",
"55613380", "Núcleo\ Bandeirante\ \-\ DF",
"55213773", "Nova\ Iguaçu\ \-\ RJ",
"55193669", "Divinolândia\ \-\ SP",
"55153537", "Itapetininga\ \-\ SP",
"55814107", "Jaboatão\ dos\ Guararapes\ \-\ PE",
"55313048", "Belo\ Horizonte\ \-\ MG",
"55493326", "Caxambu\ do\ Sul\ \-\ SC",
"55383251", "Bocaiúva\ \-\ MG",
"5511331", "São\ Paulo\ \-\ SP",
"55733051", "Alcobaça\ \-\ BA",
"55643547", "Indiara\ \-\ GO",
"55313268", "Minas\ Gerais",
"55314062", "Belo\ Horizonte\ \-\ MG",
"55743685", "Mundo\ Novo\ \-\ BA",
"55354101", "Varginha\ \-\ MG",
"55343834", "Guimarânia\ \-\ MG",
"55613108", "Brasília\ \-\ DF",
"55483333", "Florianópolis\ \-\ SC",
"55183401", "Valparaíso\ \-\ SP",
"55513623", "Rio\ Grande\ do\ Sul",
"55813728", "Bezerros\ \-\ PE",
"55543235", "Campestre\ da\ Serra\ \-\ RS",
"55143722", "Tupã\ \-\ SP",
"55183368", "Lutécia\ \-\ SP",
"55623098", "Anápolis\ \-\ GO",
"55663586", "Cocalinho\ \-\ MT",
"55433437", "Novo\ Itacolomi\ \-\ PR",
"55813231", "Recife\ \-\ PE",
"55643555", "Avelinópolis\ \-\ GO",
"55112594", "São\ Paulo\ \-\ SP",
"55142104", "Jaú\ \-\ SP",
"55913424", "Redenção\ \-\ PA",
"55114607", "Jundiaí\ \-\ SP",
"55313507", "Belo\ Horizonte\ \-\ MG",
"55173816", "Orindiúva\ \-\ SP",
"55273051", "Serra\ \-\ ES",
"55883437", "Tauá\ \-\ CE",
"55193594", "Descalvado\ \-\ SP",
"55663467", "Nova\ Nazaré\ \-\ MT",
"55333737", "Berilo\ \-\ MG",
"5568322", "Rio\ Branco\ \-\ AC",
"55453036", "Cascavel\ \-\ PR",
"55115034", "São\ Paulo\ \-\ SP",
"55333522", "Teófilo\ Otoni\ \-\ MG",
"55183354", "Platina\ \-\ SP",
"55713052", "Salvador\ \-\ BA",
"55133864", "Jacupiranga\ \-\ SP",
"55192112", "Rio\ Claro\ \-\ SP",
"55133323", "Santos\ \-\ SP",
"55883546", "Nova\ Olinda\ \-\ CE",
"55113554", "São\ Paulo\ \-\ SP",
"55313845", "Jaguaraçu\ \-\ MG",
"55443302", "Maringá\ \-\ PR",
"55923571", "Urucará\ \-\ AM",
"55673479", "Sete\ Quedas\ \-\ MS",
"55823027", "Maceió\ \-\ AL",
"55623464", "Água\ Fria\ de\ Goiás\ \-\ GO",
"55194113", "Sumaré\ \-\ SP",
"55683311", "Cruzeiro\ do\ Sul\ \-\ AC",
"55833232", "Bayeux\ \-\ PB",
"55613797", "Brasília\ \-\ DF",
"55313254", "Belo\ Horizonte\ \-\ MG",
"55753279", "Paripiranga\ \-\ BA",
"55313857", "Dom\ Silvério\ \-\ MG",
"55163952", "Pitangueiras\ \-\ SP",
"55193565", "Pirassununga\ \-\ SP",
"55793364", "Telha\ \-\ SE",
"55663503", "Brianorte\ \-\ MT",
"55113177", "São\ Paulo\ \-\ SP",
"55513774", "Ilópolis\ \-\ RS",
"55173345", "Bebedouro\ \-\ SP",
"55483232", "Florianópolis\ \-\ SC",
"55513898", "Porto\ Alegre\ \-\ RS",
"55443361", "Umuarama\ \-\ PR",
"55733604", "Batinga\ \-\ BA",
"55183694", "Zacarias\ \-\ SP",
"55383321", "Montes\ Claros\ \-\ MG",
"55433546", "Ibaiti\ \-\ PR",
"55493256", "Fraiburgo\ \-\ SC",
"55353434", "Itapeva\ \-\ MG",
"55113112", "São\ Paulo\ \-\ SP",
"55543033", "Nova\ Petrópolis\ \-\ RS",
"5538", "Minas\ Gerais",
"55313521", "Ibirité\ \-\ MG",
"55413614", "Araucária\ \-\ PR",
"55853304", "Fortaleza\ \-\ CE",
"55143767", "Coronel\ Macedo\ \-\ SP",
"55993645", "Esperantinópolis\ \-\ MA",
"55114449", "Franco\ da\ Rocha\ \-\ SP",
"55443576", "Águas\ de\ Jurema\ \-\ PR",
"55663328", "Planalto\ da\ Serra\ \-\ MT",
"55173648", "Paranapuã\ \-\ SP",
"55553411", "Uruguaiana\ \-\ RS",
"55193653", "Aguaí\ \-\ SP",
"55173359", "Colômbia\ \-\ SP",
"55143769", "Holambra\ II\ \-\ SP",
"55823341", "Maceió\ \-\ AL",
"55513782", "Santa\ Clara\ do\ Sul\ \-\ RS",
"55843295", "Jaçanã\ \-\ RN",
"55633696", "Novo\ Jardim\ \-\ TO",
"55663451", "Dom\ Aquino\ \-\ MT",
"55973353", "Codajás\ \-\ AM",
"55163489", "Serrana\ \-\ SP",
"55134004", "Santos\ \-\ SP",
"55483534", "Santa\ Rosa\ do\ Sul\ \-\ SC",
"55472104", "Itajaí\ \-\ SC",
"55913286", "Ananindeua\ \-\ PA",
"55113170", "São\ Paulo\ \-\ SP",
"55173203", "São\ José\ do\ Rio\ Preto\ \-\ SP",
"55222123", "Macaé\ \-\ RJ",
"55653397", "Diamantino\ \-\ MT",
"55623516", "Goianira\ \-\ GO",
"55643933", "Itumbiara\ \-\ GO",
"55115907", "São\ Paulo\ \-\ SP",
"55183918", "Presidente\ Prudente\ \-\ SP",
"55893578", "Gilbués\ \-\ PI",
"55313859", "João\ Monlevade\ \-\ MG",
"55673412", "Douradina\ \-\ MS",
"55114652", "Arujá\ \-\ SP",
"55283536", "Anchieta\ \-\ ES",
"551130", "São\ Paulo\ \-\ SP",
"55833534", "Uiraúna\ \-\ PB",
"55183641", "Birigui\ \-\ SP",
"55473537", "Chapadão\ do\ Lageado\ \-\ SC",
"55613799", "Brasília\ \-\ DF",
"55313552", "Ouro\ Preto\ \-\ MG",
"55513542", "Taquara\ \-\ RS",
"55313850", "Minas\ Gerais",
"55843258", "São\ Tomé\ \-\ RN",
"55482107", "Florianópolis\ \-\ SC",
"55753277", "Antas\ \-\ BA",
"55133269", "Santos\ \-\ SP",
"55112653", "São\ Paulo\ \-\ SP",
"55173699", "Pontalinda\ \-\ SP",
"55183981", "Mirante\ do\ Paranapanema\ \-\ SP",
"55633356", "Peixe\ \-\ TO",
"55623307", "Ceres\ \-\ GO",
"55953626", "Boa\ Vista\ \-\ RR",
"55353716", "Poços\ de\ Caldas\ \-\ MG",
"55383253", "Engenheiro\ Navarro\ \-\ MG",
"55342102", "Uberlândia\ \-\ MG",
"55173361", "Monte\ Azul\ Paulista\ \-\ SP",
"55853328", "Mulungu\ \-\ CE",
"55193825", "Indaiatuba\ \-\ SP",
"55433017", "Londrina\ \-\ PR",
"55173576", "Ariranha\ \-\ SP",
"55443648", "Santa\ Rita\ do\ Oeste\ \-\ PR",
"55333739", "Chapada\ do\ Norte\ \-\ MG",
"55733628", "Santa\ Luzia\ \-\ BA",
"55493634", "Iporã\ do\ Oeste\ \-\ SC",
"55453262", "Matelândia\ \-\ PR",
"55323311", "Juiz\ de\ Fora\ \-\ MG",
"55643663", "Caiapônia\ \-\ GO",
"55473446", "Barra\ Velha\ \-\ SC",
"55443424", "Paranavaí\ \-\ PR",
"55213899", "Rio\ de\ Janeiro\ \-\ RJ",
"55833613", "Campina\ Grande\ \-\ PB",
"55373276", "Conceição\ do\ Pará\ \-\ MG",
"55993661", "Codó\ \-\ MA",
"55243373", "Paraty\ \-\ RJ",
"55883439", "Ibaretama\ \-\ CE",
"55113353", "São\ Paulo\ \-\ SP",
"55114609", "Francisco\ Morato\ \-\ SP",
"55213890", "Rio\ de\ Janeiro\ \-\ RJ",
"55112781", "São\ Paulo\ \-\ SP",
"5511419", "Barueri\ \-\ SP",
"55114133", "Barueri\ \-\ SP",
"5562", "Goiás",
"55313861", "Nova\ Era\ \-\ MG",
"55743631", "Serrolândia\ \-\ BA",
"55543366", "Campinas\ do\ Sul\ \-\ RS",
"55993602", "Nova\ Colinas\ \-\ MA",
"55423542", "Mallet\ \-\ PR",
"55133251", "Santos\ \-\ SP",
"55193541", "Araras\ \-\ SP",
"55273325", "Vitória\ \-\ ES",
"55893483", "São\ João\ do\ Piauí\ \-\ PI",
"55983182", "São\ Luís\ \-\ MA",
"55843264", "Taipu\ \-\ RN",
"55543281", "Nova\ Petrópolis\ \-\ RS",
"55173302", "São\ José\ do\ Rio\ Preto\ \-\ SP",
"551124", "Guarulhos\ \-\ SP",
"55633422", "Bernardo\ Sayão\ \-\ TO",
"55453902", "Cascavel\ \-\ PR",
"55473062", "Balneário\ Camboriú\ \-\ SC",
"55173633", "Santa\ Albertina\ \-\ SP",
"55333318", "Caratinga\ \-\ MG",
"55333266", "Quatituba\ \-\ MG",
"55193672", "Santa\ Cruz\ das\ Palmeiras\ \-\ SP",
"55984141", "São\ Luís\ \-\ MA",
"55473365", "Camboriú\ \-\ SC",
"55554062", "Santa\ Maria\ \-\ RS",
"55353623", "Itajubá\ \-\ MG",
"55115111", "São\ Paulo\ \-\ SP",
"55733532", "Itamari\ \-\ BA",
"55683262", "Vila\ do\ V\ \-\ AC",
"55323229", "Juiz\ de\ Fora\ \-\ MG",
"55242447", "Barra\ do\ Piraí\ \-\ RJ",
"55133034", "Praia\ Grande\ \-\ SP",
"55553268", "Dona\ Francisca\ \-\ RS",
"55163323", "Ribeirão\ Preto\ \-\ SP",
"55193617", "Rio\ Claro\ \-\ SP",
"55443277", "Corumbataí\ do\ Sul\ \-\ PR",
"55112078", "Barueri\ \-\ SP",
"55873847", "Tabira\ \-\ PE",
"55113583", "São\ Paulo\ \-\ SP",
"55114026", "Itu\ \-\ SP",
"55333412", "São\ João\ Evangelista\ \-\ MG",
"55652121", "Cuiabá\ \-\ MT",
"55313573", "Rio\ Manso\ \-\ MG",
"55543324", "Ibirubá\ \-\ RS",
"55554001", "Santa\ Maria\ \-\ RS",
"55463546", "Nova\ Esperança\ do\ Sudoeste\ \-\ PR",
"55543445", "Fagundes\ Varela\ \-\ RS",
"55643999", "Itumbiara\ \-\ GO",
"55343455", "Carneirinho\ \-\ MG",
"55213485", "Rio\ de\ Janeiro\ \-\ RJ",
"55493557", "Zortéa\ \-\ SC",
"55423434", "Guamirim\ \-\ PR",
"55873855", "Buíque\ \-\ PE",
"55273727", "São\ Gabriel\ da\ Palha\ \-\ ES",
"55653613", "Cuiabá\ \-\ MT",
"55222734", "Campos\ dos\ Goytacazes\ \-\ RJ",
"55473001", "Joinville\ \-\ SC",
"55543457", "Monte\ Belo\ do\ Sul\ \-\ RS",
"55163508", "Araraquara\ \-\ SP",
"55153205", "Tatuí\ \-\ SP",
"55433255", "Rolândia\ \-\ PR",
"55493545", "Abdon\ Batista\ \-\ SC",
"55282102", "Cachoeiro\ de\ Itapemirim\ \-\ ES",
"55843378", "São\ Francisco\ do\ Oeste\ \-\ RN",
"55913633", "Curralinho\ \-\ PA",
"55663512", "Alta\ Floresta\ \-\ MT",
"55753648", "Dom\ Macedo\ Costa\ \-\ BA",
"55114230", "Itupeva\ \-\ SP",
"55473654", "Monte\ Castelo\ \-\ SC",
"55424101", "Guarapuava\ \-\ PR",
"55183282", "Teodoro\ Sampaio\ \-\ SP",
"55833348", "Alcantil\ \-\ PB",
"55112896", "Santo\ André\ \-\ SP",
"55553254", "Cacequi\ \-\ RS",
"55353244", "Cordislândia\ \-\ MG",
"55443313", "Santa\ Inês\ \-\ PR",
"55383814", "Mamonas\ \-\ MG",
"55222564", "Trajano\ de\ Morais\ \-\ RJ",
"55753345", "Nova\ Redenção\ \-\ BA",
"55483442", "Criciúma\ \-\ SC",
"55733656", "Ilhéus\ \-\ BA",
"55663577", "Canabrava\ do\ Norte\ \-\ MT",
"55153544", "Ribeirão\ Grande\ \-\ SP",
"55513671", "Camaquã\ \-\ RS",
"55483024", "Florianópolis\ \-\ SC",
"55353855", "Coqueiral\ \-\ MG",
"55153003", "Sorocaba\ \-\ SP",
"55313382", "Minas\ Gerais",
"55853356", "Apuiarés\ \-\ CE",
"55753424", "Muritiba\ \-\ BA",
"55383217", "Montes\ Claros\ \-\ MG",
"55273762", "Conceição\ da\ Barra\ \-\ ES",
"55243352", "Itatiaia\ \-\ RJ",
"55192103", "Campinas\ \-\ SP",
"55213833", "Rio\ de\ Janeiro\ \-\ RJ",
"55483645", "Armazém\ \-\ SC",
"5531350", "Minas\ Gerais",
"55123867", "Maresias\ \-\ SP",
"55313411", "Minas\ Gerais",
"55843472", "Jardim\ do\ Seridó\ \-\ RN",
"55373214", "Divinópolis\ \-\ MG",
"5524223", "Petrópolis\ \-\ RJ",
"55633467", "Presidente\ Kennedy\ \-\ TO",
"55163111", "Franca\ \-\ SP",
"55173279", "Olímpia\ \-\ SP",
"55773618", "Cristópolis\ \-\ BA",
"55513434", "Viamão\ \-\ RS",
"55483657", "São\ Ludgero\ \-\ SC",
"55753697", "Serra\ Preta\ \-\ BA",
"55843417", "Caicó\ \-\ RN",
"55823539", "Arapiraca\ \-\ AL",
"55383742", "Buritizeiro\ \-\ MG",
"55823530", "Arapiraca\ \-\ AL",
"55613563", "Taguatinga\ \-\ DF",
"55473394", "Indaial\ \-\ SC",
"55833397", "Natuba\ \-\ PB",
"55313488", "Minas\ Gerais",
"55193896", "Santo\ Antônio\ de\ Posse\ \-\ SP",
"55623923", "Goiânia\ \-\ GO",
"55163524", "Sertãozinho\ \-\ SP",
"55833399", "Massaranduba\ \-\ PB",
"5524", "Rio\ de\ Janeiro",
"55543461", "Carlos\ Barbosa\ \-\ RS",
"55753690", "Capela\ do\ Alto\ Alegre\ \-\ BA",
"55993534", "Davinópolis\ \-\ MA",
"55483659", "Pedras\ Grandes\ \-\ SC",
"55753699", "Saubara\ \-\ BA",
"55923324", "Presidente\ Figueiredo\ \-\ AM",
"55323262", "Rochedo\ de\ Minas\ \-\ MG",
"55243321", "Resende\ \-\ RJ",
"55833390", "Prata\ \-\ PB",
"55823537", "Campo\ Grande\ \-\ AL",
"55173587", "Palmares\ Paulista\ \-\ SP",
"55633469", "Goiatins\ \-\ TO",
"55613395", "Santa\ Maria\ \-\ DF",
"55493561", "Caçador\ \-\ SC",
"55373287", "Perdigão\ \-\ MG",
"55183744", "Nova\ Independência\ \-\ SP",
"55893454", "Fronteiras\ \-\ PI",
"55173121", "São\ José\ do\ Rio\ Preto\ \-\ SP",
"55173277", "Nipoã\ \-\ SP",
"55223842", "Porciúncula\ \-\ RJ",
"55353291", "Alfenas\ \-\ MG",
"55173874", "Macaubal\ \-\ SP",
"55114148", "Cotia\ \-\ SP",
"55373512", "Divinópolis\ \-\ MG",
"55473341", "Itajaí\ \-\ SC",
"55753203", "Jeremoabo\ \-\ BA",
"55173466", "Cardoso\ \-\ SP",
"55113637", "São\ Paulo\ \-\ SP",
"55153242", "Votorantim\ \-\ SP",
"55773432", "Itambé\ \-\ BA",
"55663579", "Nova\ Ubiratã\ \-\ MT",
"55143668", "Itaju\ \-\ SP",
"55163251", "Guariba\ \-\ SP",
"55183274", "Teçaindá\ \-\ SP",
"55623373", "Jussara\ \-\ GO",
"55323201", "Cataguases\ \-\ MG",
"55813662", "Palmares\ \-\ PE",
"55443633", "São\ João\ \-\ PR",
"55613358", "Samambaia\ Sul\ \-\ DF",
"55553552", "Vista\ Gaúcha\ \-\ RS",
"55543523", "Barão\ de\ Cotegipe\ \-\ RS",
"55313374", "Minas\ Gerais",
"55113384", "São\ Paulo\ \-\ SP",
"55673522", "Três\ Lagoas\ \-\ MS",
"55413590", "Piraquara\ \-\ PR",
"55893468", "Aroazes\ \-\ PI",
"55983387", "Palmeirândia\ \-\ MA",
"55883115", "Juazeiro\ do\ Norte\ \-\ CE",
"55543459", "Bento\ Gonçalves\ \-\ RS",
"55213431", "Rio\ de\ Janeiro\ \-\ RJ",
"55713626", "Camaçari\ \-\ BA",
"55273720", "Itarana\ \-\ ES",
"55413676", "Campina\ Grande\ do\ Sul\ \-\ PR",
"55153343", "Votorantim\ \-\ SP",
"55273729", "São\ Roque\ do\ Canaã\ \-\ ES",
"55623582", "Goiânia\ \-\ GO",
"55862107", "Teresina\ \-\ PI",
"55163973", "Guatapará\ \-\ SP",
"55643997", "Itumbiara\ \-\ GO",
"55873840", "Inajá\ \-\ PE",
"55443270", "Uniflor\ \-\ PR",
"55273194", "Vitória\ \-\ ES",
"55433249", "Cambé\ \-\ PR",
"55633451", "Rio\ Sono\ \-\ TO",
"55112610", "Mogi\ das\ Cruzes\ \-\ SP",
"55433240", "São\ Martinho\ \-\ PR",
"55513716", "Arroio\ do\ Meio\ \-\ RS",
"55913798", "Pacajá\ \-\ PA",
"55223016", "Nova\ Friburgo\ \-\ RJ",
"55112684", "São\ Paulo\ \-\ SP",
"55873849", "Itaíba\ \-\ PE",
"55613364", "Brasília\ \-\ DF",
"55753286", "Coronel\ João\ Sá\ \-\ BA",
"55983471", "Chapadinha\ \-\ MA",
"55193684", "São\ José\ do\ Rio\ Pardo\ \-\ SP",
"55323363", "Lagoa\ Dourada\ \-\ MG",
"5545322", "Cascavel\ \-\ PR",
"55493228", "Bocaina\ do\ Sul\ \-\ SC",
"55913466", "Marudá\ \-\ PA",
"55643611", "Rio\ Verde\ \-\ GO",
"55733234", "Ilhéus\ \-\ BA",
"55333335", "São\ José\ do\ Mantimento\ \-\ MG",
"55873782", "Saloá\ \-\ PE",
"55713105", "Salvador\ \-\ BA",
"55544003", "Caxias\ do\ Sul\ \-\ RS",
"55674002", "Campo\ Grande\ \-\ MS",
"55473236", "Blumenau\ \-\ SC",
"55993613", "Grajaú\ \-\ MA",
"55643688", "Jaupaci\ \-\ GO",
"55114708", "Mairinque\ \-\ SP",
"55123527", "Pindamonhangaba\ \-\ SP",
"55913755", "Igarapé\-Miri\ \-\ PA",
"55213674", "Niterói\ \-\ RJ",
"55143654", "Brotas\ \-\ SP",
"55193607", "Casa\ Branca\ \-\ SP",
"55313694", "Nova\ Lima\ \-\ MG",
"55483035", "São\ José\ \-\ SC",
"55173245", "José\ Bonifácio\ \-\ SP",
"55753435", "Cipó\ \-\ BA",
"55483332", "Florianópolis\ \-\ SC",
"55513622", "Arroio\ Teixeira\ \-\ RS",
"55713298", "Simões\ Filho\ \-\ BA",
"55933558", "Belterra\ \-\ PA",
"55183521", "Adamantina\ \-\ SP",
"55114594", "Itatiba\ \-\ SP",
"5512364", "Pindamonhangaba\ \-\ SP",
"55493356", "Arvoredo\ \-\ SC",
"55383221", "Montes\ Claros\ \-\ MG",
"55373545", "Paineiras\ \-\ MG",
"55833438", "Condado\ \-\ PB",
"55173257", "Baguaçu\ \-\ SP",
"55773499", "Sussuarana\ \-\ BA",
"55352101", "Poços\ de\ Caldas\ \-\ MG",
"55893474", "Pimenteiras\ \-\ PI",
"55114735", "Mogi\ das\ Cruzes\ \-\ SP",
"55553282", "Lavras\ do\ Sul\ \-\ RS",
"55983469", "Urbano\ Santos\ \-\ MA",
"55213668", "São\ João\ de\ Meriti\ \-\ RJ",
"55163518", "Cravinhos\ \-\ SP",
"55663559", "Novo\ Horizonte\ do\ Norte\ \-\ MT",
"55553791", "Palmitinho\ \-\ RS",
"55793453", "Moita\ Bonita\ \-\ SE",
"55923318", "Nova\ Olinda\ do\ Norte\ \-\ AM",
"55983304", "São\ Luís\ \-\ MA",
"55483438", "Criciúma\ \-\ SC",
"55183857", "São\ João\ do\ Pau\ D\'Alho\ \-\ SP",
"557133", "Salvador\ \-\ BA",
"55144104", "Garça\ \-\ SP",
"555138", "Rio\ Grande\ do\ Sul",
"55683211", "Rio\ Branco\ \-\ AC",
"55793264", "Itaporanga\ d\'Ajuda\ \-\ SE",
"55753632", "Santo\ Antônio\ de\ Jesus\ \-\ BA",
"5516336", "São\ Carlos\ \-\ SP",
"55513425", "Canoas\ \-\ RS",
"55333523", "Teófilo\ Otoni\ \-\ MG",
"55833035", "João\ Pessoa\ \-\ PB",
"55423667", "Inácio\ Martins\ \-\ PR",
"55623353", "Goianésia\ \-\ GO",
"55843421", "Caicó\ \-\ RN",
"55823294", "União\ dos\ Palmares\ \-\ AL",
"55493289", "Lages\ \-\ SC",
"55973321", "Barcelos\ \-\ AM",
"55192113", "Limeira\ \-\ SP",
"55313462", "Belo\ Horizonte\ \-\ MG",
"55323725", "Antônio\ Prado\ de\ Minas\ \-\ MG",
"55863297", "Agricolândia\ \-\ PI",
"55484109", "Biguaçu\ \-\ SC",
"55433531", "Santa\ Mariana\ \-\ PR",
"55413656", "Colombo\ \-\ PR",
"55192516", "Indaiatuba\ \-\ SP",
"55823265", "Pilar\ \-\ AL",
"5597", "Amazonas",
"55423028", "Ponta\ Grossa\ \-\ PR",
"55713493", "Camaçari\ \-\ BA",
"55193621", "Americana\ \-\ SP",
"55212665", "Queimados\ \-\ RJ",
"55913854", "Maracanã\ \-\ PA",
"55443259", "Maringá\ \-\ PR",
"55643441", "Catalão\ \-\ GO",
"55953084", "Boa\ Vista\ \-\ RR",
"55113307", "São\ Paulo\ \-\ SP",
"55643620", "Rio\ Verde\ \-\ GO",
"55643629", "Montividiu\ \-\ GO",
"55172137", "São\ José\ do\ Rio\ Preto\ \-\ SP",
"55633471", "Tocantinópolis\ \-\ TO",
"55443250", "Presidente\ Castelo\ Branco\ \-\ PR",
"55163953", "Pontal\ \-\ SP",
"55663423", "Rondonópolis\ \-\ MT",
"55173043", "Barretos\ \-\ SP",
"55112621", "São\ Paulo\ \-\ SP",
"55513667", "Três\ Cachoeiras\ \-\ RS",
"55663561", "Itaúba\ \-\ MT",
"55913119", "Belém\ \-\ PA",
"55983451", "Santa\ Rita\ \-\ MA",
"55313216", "Minas\ Gerais",
"55733548", "Irajuba\ \-\ BA",
"55913110", "Belém\ \-\ PA",
"55443528", "Assis\ Chateaubriand\ \-\ PR",
"55913184", "Belém\ \-\ PA",
"55633387", "Jaú\ do\ Tocantins\ \-\ TO",
"55213938", "Rio\ de\ Janeiro\ \-\ RJ",
"55183268", "Nantes\ \-\ SP",
"55113113", "São\ Paulo\ \-\ SP",
"55313665", "Pedro\ Leopoldo\ \-\ MG",
"55913775", "Santo\ Antônio\ do\ Tauá\ \-\ PA",
"5511461", "Cotia\ \-\ SP",
"55863248", "Buriti\ dos\ Montes\ \-\ PI",
"55163101", "Ribeirão\ Preto\ \-\ SP",
"55872101", "Petrolina\ \-\ PE",
"55273711", "Colatina\ \-\ ES",
"55673033", "Dourados\ \-\ MS",
"5531351", "Minas\ Gerais",
"55543032", "Flores\ da\ Cunha\ \-\ RS",
"55883531", "Brejo\ Santo\ \-\ CE",
"55423651", "Reserva\ do\ Iguaçu\ \-\ PR",
"55643054", "Rio\ Verde\ \-\ GO",
"55112392", "São\ Paulo\ \-\ SP",
"55474104", "São\ Bento\ do\ Sul\ \-\ SC",
"55193652", "Aguaí\ \-\ SP",
"55373423", "Tapiraí\ \-\ MG",
"5516391", "Ribeirão\ Preto\ \-\ SP",
"55633389", "Abreulândia\ \-\ TO",
"55543266", "Santa\ Lúcia\ do\ Piaí\ \-\ RS",
"55513783", "Esteio\ \-\ RS",
"55813688", "São\ José\ da\ Coroa\ Grande\ \-\ PE",
"55183861", "Irapuru\ \-\ SP",
"55193498", "Nova\ Odessa\ \-\ SP",
"55313886", "Diogo\ de\ Vasconcelos\ \-\ MG",
"55883585", "Iguatu\ \-\ CE",
"55453301", "Cascavel\ \-\ PR",
"55973352", "Anori\ \-\ AM",
"5571301", "Salvador\ \-\ BA",
"55273225", "Vitória\ \-\ ES",
"55414116", "Curitiba\ \-\ PR",
"5511433", "São\ Bernardo\ do\ Campo\ \-\ SP",
"55513660", "Rio\ Grande\ do\ Sul",
"55513669", "Nova\ Tramandaí\ \-\ RS",
"55643932", "Itumbiara\ \-\ GO",
"55543381", "Soledade\ \-\ RS",
"55173202", "São\ José\ do\ Rio\ Preto\ \-\ SP",
"55183636", "Araçatuba\ \-\ SP",
"55913528", "Novo\ Progresso\ \-\ PA",
"55843364", "Olho\-D\'Água\ do\ Borges\ \-\ RN",
"55114653", "Arujá\ \-\ SP",
"55543412", "Farroupilha\ \-\ RS",
"55643627", "Riverlândia\ \-\ GO",
"55623554", "Varjão\ \-\ GO",
"55163456", "Ribeirão\ Preto\ \-\ SP",
"55333324", "Vargem\ Alegre\ \-\ MG",
"55193447", "Piracicaba\ \-\ SP",
"55213020", "Rio\ de\ Janeiro\ \-\ RJ",
"55673413", "Panambi\ \-\ MS",
"55173261", "Nova\ Granada\ \-\ SP",
"55313553", "Cachoeira\ do\ Campo\ \-\ MG",
"55513543", "Parobé\ \-\ RS",
"55323578", "Guidoval\ \-\ MG",
"55853182", "Fortaleza\ \-\ CE",
"55443257", "Flórida\ \-\ PR",
"55973458", "Pauini\ \-\ AM",
"55823336", "Maceió\ \-\ AL",
"55173386", "Pirangi\ \-\ SP",
"55212886", "Nova\ Iguaçu\ \-\ RJ",
"55433275", "Arapongas\ \-\ PR",
"55193455", "Santa\ Bárbara\ D\'Oeste\ \-\ SP",
"55112652", "São\ Paulo\ \-\ SP",
"55543477", "Paraí\ \-\ RS",
"55323288", "Olaria\ \-\ MG",
"55733225", "Igrapiúna\ \-\ BA",
"55863299", "Hugo\ Napoleão\ \-\ PI",
"55634141", "Palmas\ \-\ TO",
"55443245", "Mandaguaçu\ \-\ PR",
"55753213", "Banzaê\ \-\ BA",
"55873875", "Cabrobó\ \-\ PE",
"55484107", "Palhoça\ \-\ SC",
"55163878", "Ribeirão\ Preto\ \-\ SP",
"55513706", "Rio\ Grande\ do\ Sul",
"55373228", "Nova\ Serrana\ \-\ MG",
"55383252", "Engenheiro\ Dolabela\ \-\ MG",
"55513930", "Porto\ Alegre\ \-\ RS",
"55473674", "São\ Miguel\ da\ Serra\ \-\ SC",
"5553323", "Rio\ Grande\ \-\ RS",
"55843647", "Parnamirim\ \-\ RN",
"55643662", "Palestina\ de\ Goiás\ \-\ GO",
"55843358", "Rafael\ Fernandes\ \-\ RN",
"55213236", "Nilópolis\ \-\ RJ",
"55773624", "Riachão\ das\ Neves\ \-\ BA",
"55533293", "Rio\ Grande\ \-\ RS",
"55663545", "Sorriso\ \-\ MT",
"55833612", "João\ Pessoa\ \-\ PB",
"55743646", "Cafarnaum\ \-\ BA",
"55243372", "Paraty\ \-\ RJ",
"55443043", "Paiçandu\ \-\ PR",
"55433626", "Jundiaí\ do\ Sul\ \-\ PR",
"55753015", "Feira\ de\ Santana\ \-\ BA",
"55853376", "Guaiúba\ \-\ CE",
"55773448", "Dom\ Basílio\ \-\ BA",
"55693546", "Nova\ Dimensão\ \-\ RO",
"55753312", "Cruz\ das\ Almas\ \-\ BA",
"55183552", "Pracinha\ \-\ SP",
"5596322", "Macapá\ \-\ AP",
"55733676", "Barrolândia\ \-\ BA",
"55313641", "Santa\ Luzia\ \-\ MG",
"55513651", "São\ Jerônimo\ \-\ RS",
"55663557", "Tabaporã\ \-\ MT",
"55114132", "Pirapora\ do\ Bom\ Jesus\ \-\ SP",
"55973464", "Tonantins\ \-\ AM",
"55983276", "São\ Luís\ \-\ MA",
"55123108", "Aparecida\ \-\ SP",
"55843395", "Almino\ Afonso\ \-\ RN",
"55483081", "Criciúma\ \-\ SC",
"5562331", "Anápolis\ \-\ GO",
"55114718", "Mairinque\ \-\ SP",
"55713115", "Salvador\ \-\ BA",
"55883626", "São\ Benedito\ \-\ CE",
"55483018", "Florianópolis\ \-\ SC",
"55643601", "São\ Luís\ de\ Montes\ Belos\ \-\ GO",
"55114781", "Embu\ das\ Artes\ \-\ SP",
"55112536", "São\ Paulo\ \-\ SP",
"55423543", "Paulo\ Frontin\ \-\ PR",
"55114292", "Suzano\ \-\ SP",
"55643465", "Urutaí\ \-\ GO",
"55893482", "Simplício\ Mendes\ \-\ PI",
"55212641", "Teresópolis\ \-\ RJ",
"55553744", "Frederico\ Westphalen\ \-\ RS",
"55753418", "Alagoinhas\ \-\ BA",
"55213760", "Nilópolis\ \-\ RJ",
"55512101", "Porto\ Alegre\ \-\ RS",
"55663471", "Alto\ Garças\ \-\ MT",
"55954400", "Caracaraí\ \-\ RR",
"55173632", "Jales\ \-\ SP",
"55193026", "Santa\ Bárbara\ D\'Oeste\ \-\ SP",
"55913556", "Senador\ José\ Porfírio\ \-\ PA",
"55733296", "Medeiros\ Neto\ \-\ BA",
"55633423", "Darcinópolis\ \-\ TO",
"55193673", "Tambaú\ \-\ SP",
"55353622", "Itajubá\ \-\ MG",
"55733533", "Maracas\ \-\ BA",
"55163025", "Franca\ \-\ SP",
"55483248", "Florianópolis\ \-\ SC",
"55113159", "São\ Paulo\ \-\ SP",
"55484042", "Balneário\ Camboriú\ \-\ SC",
"55833297", "Mataraca\ \-\ PB",
"55813436", "Paulista\ \-\ PE",
"55163322", "Araraquara\ \-\ SP",
"55973373", "Humaitá\ \-\ AM",
"55383506", "Buritis\ \-\ MG",
"55683327", "Assis\ Brasil\ \(Vila\)\ \-\ AC",
"55212791", "Nilópolis\ \-\ RJ",
"55533026", "Pelotas\ \-\ RS",
"55883664", "Marco\ \-\ CE",
"55313572", "Itatiaiuçu\ \-\ MG",
"55753257", "Bessa\ \-\ BA",
"55843278", "São\ Gonçalo\ do\ Amarante\ \-\ RN",
"55313870", "Minas\ Gerais",
"55513515", "Porto\ Alegre\ \-\ RS",
"55333413", "Paulistas\ \-\ MG",
"55673445", "Anaurilândia\ \-\ MS",
"55833248", "Cabedelo\ \-\ PB",
"55553354", "Porto\ Xavier\ \-\ RS",
"55313879", "Belo\ Horizonte\ \-\ MG",
"55273296", "Aracruz\ \-\ ES",
"55893558", "São\ Francisco\ do\ Piauí\ \-\ PI",
"55973426", "Japurá\ \-\ AM",
"55353344", "Aiuruoca\ \-\ MG",
"55743065", "Juazeiro\ \-\ BA",
"55493304", "Chapecó\ \-\ SC",
"55753245", "Santo\ Estêvão\ \-\ BA",
"55313128", "Jaboticatubas\ \-\ MG",
"55163984", "São\ Simão\ \-\ SP",
"55633376", "Barrolândia\ \-\ TO",
"55673457", "Itaporã\ \-\ MS",
"55273136", "Cariacica\ \-\ ES",
"55692181", "Porto\ Velho\ \-\ RO",
"55374141", "Divinópolis\ \-\ MG",
"55273533", "Vila\ Velha\ \-\ ES",
"55623637", "Goiânia\ \-\ GO",
"55663513", "Sorriso\ \-\ MT",
"55173556", "Irapuã\ \-\ SP",
"55543906", "Farroupilha\ \-\ RS",
"55613501", "Planaltina\ \-\ DF",
"55183283", "Euclides\ da\ Cunha\ Paulista\ \-\ SP",
"55343292", "Uberlândia\ \-\ MG",
"55123655", "Caçapava\ \-\ SP",
"55683301", "Rio\ Branco\ \-\ AC",
"55843326", "Tibau\ \-\ RN",
"55443312", "Nossa\ Senhora\ das\ Graças\ \-\ PR",
"55483443", "Criciúma\ \-\ SC",
"55623384", "Taquaral\ de\ Goiás\ \-\ GO",
"55983214", "São\ Luís\ \-\ MA",
"55883695", "Sobral\ \-\ CE",
"55924002", "Manaus\ \-\ AM",
"55243353", "Porto\ Real\ \-\ RJ",
"55273763", "São\ Mateus\ \-\ ES",
"55443015", "Marialva\ \-\ PR",
"55123647", "Lagoinha\ \-\ SP",
"55192102", "Campinas\ \-\ SP",
"55313383", "Belo\ Horizonte\ \-\ MG",
"55614007", "Brasília\ \-\ DF",
"55153305", "Tatuí\ \-\ SP",
"55433355", "Londrina\ \-\ PR",
"55422101", "Ponta\ Grossa\ \-\ PR",
"55413060", "Fazenda\ Rio\ Grande\ \-\ PR",
"55553401", "Uruguaiana\ \-\ RS",
"55843473", "Cruzeta\ \-\ RN",
"5531342", "Minas\ Gerais",
"5513336", "Cubatão\ \-\ SP",
"55413604", "Fazenda\ Rio\ Grande\ \-\ PR",
"55543551", "Machadinho\ \-\ RS",
"55863332", "Caxingó\ \-\ PI",
"55113426", "Diadema\ \-\ SP",
"55242292", "Petrópolis\ \-\ RJ",
"55733680", "Ilhéus\ \-\ BA",
"55833443", "Brejo\ do\ Cruz\ \-\ PB",
"5571324", "Salvador\ \-\ BA",
"55383743", "Pirapora\ \-\ MG",
"55883658", "Poranga\ \-\ CE",
"55433398", "Tamarana\ \-\ PR",
"55623922", "Goiânia\ \-\ GO",
"55133271", "Santos\ \-\ SP",
"5511260", "São\ Paulo\ \-\ SP",
"55493451", "Paial\ \-\ SC",
"55613562", "Taguatinga\ \-\ DF",
"55115691", "São\ Paulo\ \-\ SP",
"55513496", "Gravataí\ \-\ RS",
"55533237", "Povo\ Novo\ \-\ RS",
"55623506", "Trindade\ \-\ GO",
"55613264", "Brasília\ \-\ DF",
"55673461", "Naviraí\ \-\ MS",
"55443435", "Planaltina\ do\ Paraná\ \-\ PR",
"55863081", "Teresina\ \-\ PI",
"55493328", "Chapecó\ \-\ SC",
"55513056", "Santa\ Cruz\ do\ Sul\ \-\ RS",
"55323263", "Maripá\ de\ Minas\ \-\ MG",
"55933526", "Alenquer\ \-\ PA",
"55853387", "Caucaia\ \-\ CE",
"55223843", "Varre\-Sai\ \-\ RJ",
"55193834", "Indaiatuba\ \-\ SP",
"55333235", "Tumiritinga\ \-\ MG",
"55113705", "Santo\ André\ \-\ SP",
"55613453", "Sobradinho\ \-\ DF",
"55143848", "Itatinga\ \-\ SP",
"55473336", "Blumenau\ \-\ SC",
"55493625", "Belmonte\ \-\ SC",
"55412106", "Curitiba\ \-\ PR",
"55643575", "Itumbiara\ \-\ GO",
"55733687", "Caravelas\ \-\ BA",
"55913481", "Primavera\ \-\ PA",
"55373513", "Pompéu\ \-\ MG",
"55753261", "Serrinha\ \-\ BA",
"5561303", "Brasília\ \-\ DF",
"55273071", "Vitória\ \-\ ES",
"55112834", "São\ Bernardo\ do\ Campo\ \-\ SP",
"55614009", "Brasília\ \-\ DF",
"55753202", "Retirolândia\ \-\ BA",
"55913015", "Belém\ \-\ PA",
"55143294", "Iacanga\ \-\ SP",
"55443038", "Umuarama\ \-\ PR",
"55153243", "Votorantim\ \-\ SP",
"55773433", "Boa\ Nova\ \-\ BA",
"55123421", "Taubaté\ \-\ SP",
"55873939", "Flores\ \-\ PE",
"55353543", "Capetinga\ \-\ MG",
"55623372", "Goiás\ \-\ GO",
"55653233", "Salto\ do\ Céu\ \-\ MT",
"55443632", "Xambrê\ \-\ PR",
"55513768", "Rio\ Grande\ do\ Sul",
"55623639", "Goiânia\ \-\ GO",
"55543522", "Erechim\ \-\ RS",
"55473241", "Itajaí\ \-\ SC",
"55353651", "Paraisópolis\ \-\ MG",
"55483525", "Turvo\ \-\ SC",
"55114619", "Jandira\ \-\ SP",
"55153342", "Sorocaba\ \-\ SP",
"55623583", "Goiânia\ \-\ GO",
"55114684", "Juquitiba\ \-\ SP",
"55313519", "Belo\ Horizonte\ \-\ MG",
"55163351", "São\ Carlos\ \-\ SP",
"55513538", "Canoas\ \-\ RS",
"55653332", "Nova\ Olímpia\ \-\ MT",
"55163972", "Bonfim\ Paulista\ \-\ SP",
"55313877", "Jequeri\ \-\ MG",
"55193708", "Campinas\ \-\ SP",
"55413628", "Campo\ do\ Tenente\ \-\ PR",
"55222796", "Macaé\ \-\ RJ",
"55143265", "Piratininga\ \-\ SP",
"55753259", "Euclides\ da\ Cunha\ \-\ BA",
"55173481", "São\ João\ das\ Duas\ Pontes\ \-\ SP",
"55443901", "Maringá\ \-\ PR",
"55173312", "Barretos\ \-\ SP",
"55833299", "Pitimbu\ \-\ PB",
"55223054", "Campos\ dos\ Goytacazes\ \-\ RJ",
"55513754", "Imigrante\ \-\ RS",
"55664141", "Rondonópolis\ \-\ MT",
"55323362", "Barbacena\ \-\ MG",
"55943491", "Redenção\ \-\ PA",
"55453211", "Santa\ Maria\ \-\ PR",
"55833290", "Conde\ \-\ PB",
"5519344", "Limeira\ \-\ SP",
"55674003", "Campo\ Grande\ \-\ MS",
"55453288", "Santa\ Lúcia\ \-\ PR",
"55443556", "Rancho\ Alegre\ D\'Oeste\ \-\ PR",
"55873783", "Caetés\ \-\ PE",
"55153624", "Itapeva\ \-\ SP",
"55833525", "Sousa\ \-\ PB",
"55413906", "Curitiba\ \-\ PR",
"55183275", "Martinópolis\ \-\ SP",
"55273033", "Vila\ Velha\ \-\ ES",
"55953553", "Cantá\ \-\ RR",
"55693216", "Porto\ Velho\ \-\ RO",
"55114578", "Mauá\ \-\ SP",
"55773471", "Paramirim\ \-\ BA",
"55553249", "Santiago\ \-\ RS",
"55493343", "Formosa\ do\ Sul\ \-\ SC",
"55223828", "Boaventura\ \-\ RJ",
"55753651", "Jiquiriçá\ \-\ BA",
"55313375", "Belo\ Horizonte\ \-\ MG",
"55883636", "Amontada\ \-\ CE",
"55873202", "Petrolina\ \-\ PE",
"5585349", "Fortaleza\ \-\ CE",
"55843011", "Natal\ \-\ RN",
"5574361", "Juazeiro\ \-\ BA",
"55893498", "Lagoa\ do\ Barro\ do\ Piauí\ \-\ PI",
"55163603", "Ribeirão\ Preto\ \-\ SP",
"55833351", "Monteiro\ \-\ PB",
"5511567", "São\ Paulo\ \-\ SP",
"55313430", "Minas\ Gerais",
"55993535", "Pequiá\ \-\ MA",
"55222653", "Saquarema\ \-\ RJ",
"55313439", "Minas\ Gerais",
"55513481", "Eldorado\ do\ Sul\ \-\ RS",
"55613027", "Taguatinga\ \-\ DF",
"55893447", "São\ José\ do\ Piauí\ \-\ PI",
"5553322", "Pelotas\ \-\ RS",
"55173875", "São\ João\ de\ Iracema\ \-\ SP",
"55323393", "Senhora\ das\ Dores\ \-\ MG",
"55823278", "Tanque\ D\'Arca\ \-\ AL",
"55373238", "Pará\ de\ Minas\ \-\ MG",
"55193123", "Campinas\ \-\ SP",
"55613394", "Santa\ Maria\ \-\ DF",
"55893455", "Caldeirão\ Grande\ do\ Piauí\ \-\ PI",
"55473563", "Salete\ \-\ SC",
"55813253", "Recife\ \-\ PE",
"55183745", "Itapura\ \-\ SP",
"55163946", "Sertãozinho\ \-\ SP",
"55442101", "Maringá\ \-\ PR",
"55693427", "Nova\ Colina\ \-\ RO",
"55893536", "Flores\ do\ Piauí\ \-\ PI",
"55613365", "Brasília\ \-\ DF",
"55193311", "Jaguariúna\ \-\ SP",
"55853198", "Fortaleza\ \-\ CE",
"55353261", "Campanha\ \-\ MG",
"55323292", "Bom\ Jardim\ de\ Minas\ \-\ MG",
"55883552", "Mauriti\ \-\ CE",
"55213039", "Nilópolis\ \-\ RJ",
"55193388", "Campinas\ \-\ SP",
"55222541", "Nova\ Friburgo\ \-\ RJ",
"55913754", "Barcarena\ \-\ PA",
"55753669", "Ponte\ 2\ de\ Julho\ \-\ BA",
"55114483", "Mairiporã\ \-\ SP",
"55833360", "Borborema\ \-\ PB",
"55973385", "Manicoré\ \-\ AM",
"55533311", "Bagé\ \-\ RS",
"55813495", "Olinda\ \-\ PE",
"55833369", "Arara\ \-\ PB",
"55643637", "Aparecida\ do\ Rio\ Doce\ \-\ GO",
"55413643", "Araucária\ \-\ PR",
"55153376", "Itapetininga\ \-\ SP",
"55753660", "Pé\ de\ Serra\ \-\ BA",
"55333334", "Manhuaçu\ \-\ MG",
"55213030", "Rio\ de\ Janeiro\ \-\ RJ",
"55483369", "Florianópolis\ \-\ SC",
"55143452", "Pompéia\ \-\ SP",
"55813692", "Lagoa\ dos\ Gatos\ \-\ PE",
"55493242", "São\ José\ do\ Cerrito\ \-\ SC",
"55433552", "Nova\ Fátima\ \-\ PR",
"55273235", "Vitória\ \-\ ES",
"55383083", "Montes\ Claros\ \-\ MG",
"55323541", "Ubá\ \-\ MG",
"55222781", "Campos\ dos\ Goytacazes\ \-\ RJ",
"55193482", "Águas\ de\ São\ Pedro\ \-\ SP",
"55112685", "São\ Paulo\ \-\ SP",
"55373433", "São\ Roque\ de\ Minas\ \-\ MG",
"55213484", "Rio\ de\ Janeiro\ \-\ RJ",
"55433463", "Godoy\ Moreira\ \-\ PR",
"55623575", "Goiânia\ \-\ GO",
"55883521", "Crato\ \-\ CE",
"5581", "Pernambuco",
"55633448", "Babaçulândia\ \-\ TO",
"55343454", "Carneirinho\ \-\ MG",
"55543444", "Serafina\ Corrêa\ \-\ RS",
"55643478", "Ouvidor\ \-\ GO",
"55114169", "Carapicuíba\ \-\ SP",
"55543325", "São\ José\ do\ Herval\ \-\ RS",
"55123848", "Ubatuba\ \-\ SP",
"55673676", "Nova\ Andradina\ \-\ MS",
"55513883", "Montenegro\ \-\ RS",
"55493544", "Campos\ Novos\ \-\ SC",
"55433254", "Cambé\ \-\ PR",
"55983681", "Santa\ Inês\ \-\ MA",
"55443538", "Engenheiro\ Beltrão\ \-\ PR",
"55983012", "São\ Luís\ \-\ MA",
"55343263", "Capinópolis\ \-\ MG",
"55474053", "Blumenau\ \-\ SC",
"55343327", "Conceição\ das\ Alagoas\ \-\ MG",
"55222735", "Campos\ dos\ Goytacazes\ \-\ RJ",
"55873854", "Carnaíba\ \-\ PE",
"55423435", "Pinho\ de\ Baixo\ \-\ PR",
"5531377", "Minas\ Gerais",
"55452103", "Toledo\ \-\ PR",
"55473364", "Dona\ Emma\ \-\ SC",
"55643639", "Perolândia\ \-\ GO",
"55963621", "Laranjal\ do\ Jari\ \-\ AP",
"55833367", "Bananeiras\ \-\ PB",
"55193866", "Conchal\ \-\ SP",
"55793530", "Estância\ \-\ SE",
"55663433", "Primavera\ do\ Leste\ \-\ MT",
"55213037", "Nova\ Iguaçu\ \-\ RJ",
"55753667", "Nossa\ Senhora\ da\ Ajuda\ \-\ BA",
"55863271", "Pedro\ II\ \-\ PI",
"55183702", "Andradina\ \-\ SP",
"55733281", "Eunápolis\ \-\ BA",
"55423632", "Jordãozinho\ \-\ PR",
"55693641", "Alta\ Floresta\ do\ Oeste\ \-\ RO",
"55633497", "Tupirama\ \-\ TO",
"55513556", "Rio\ Grande\ do\ Sul",
"55242263", "Paraíba\ do\ Sul\ \-\ RJ",
"55313546", "Minas\ Gerais",
"55743541", "Senhor\ do\ Bonfim\ \-\ BA",
"55493719", "Capinzal\ \-\ SC",
"55973331", "Lábrea\ \-\ AM",
"55123897", "Caraguatatuba\ \-\ SP",
"55143649", "Barra\ Bonita\ \-\ SC",
"5521386", "Rio\ de\ Janeiro\ \-\ RJ",
"55114646", "Itaquaquecetuba\ \-\ SP",
"55433521", "Londrina\ \-\ PR",
"5511354", "São\ Paulo\ \-\ SP",
"55873775", "Águas\ Belas\ \-\ PE",
"55433268", "Ibiporã\ \-\ PR",
"55753622", "Feira\ de\ Santana\ \-\ BA",
"55333533", "Novo\ Cruzeiro\ \-\ MG",
"55513435", "Rio\ Grande\ do\ Sul",
"55193902", "Holambra\ \-\ SP",
"55423901", "Ponta\ Grossa\ \-\ PR",
"55843431", "Currais\ Novos\ \-\ RN",
"55443056", "Umuarama\ \-\ PR",
"55833322", "Campina\ Grande\ \-\ PB",
"55373215", "Divinópolis\ \-\ MG",
"55343301", "Uberlândia\ \-\ MG",
"55483644", "Laguna\ \-\ SC",
"55873868", "Afrânio\ \-\ PE",
"55743653", "Morro\ do\ Chapéu\ \-\ BA",
"55133596", "Praia\ Grande\ \-\ SP",
"55434062", "Londrina\ \-\ PR",
"55433316", "Arapongas\ \-\ PR",
"55313437", "Minas\ Gerais",
"55333296", "Sardoá\ \-\ MG",
"55893449", "Santo\ Antônio\ de\ Lisboa\ \-\ PI",
"55473452", "Araquari\ \-\ SC",
"55473395", "Pomerode\ \-\ SC",
"55893440", "Ipiranga\ do\ Piauí\ \-\ PI",
"55542106", "Erechim\ \-\ RS",
"55553255", "Jaguari\ \-\ RS",
"55613341", "Cruzeiro\ \-\ DF",
"55143407", "Garça\ \-\ SP",
"55473655", "Major\ Vieira\ \-\ SC",
"55114818", "Terra\ Preta\ \-\ SP",
"55513038", "Campo\ Bom\ \-\ RS",
"55383231", "Brasília\ de\ Minas\ \-\ MG",
"55673225", "Coxim\ \-\ MS",
"55143733", "Avaré\ \-\ SP",
"55774141", "Vitória\ da\ Conquista\ \-\ BA",
"55153557", "Itaóca\ \-\ SP",
"55833428", "Mãe\ d\'Água\ \-\ PB",
"55513370", "Rio\ Grande\ do\ Sul",
"55114881", "Francisco\ Morato\ \-\ SP",
"55753425", "Cachoeira\ \-\ BA",
"55483322", "Florianópolis\ \-\ SC",
"55923491", "Carauari\ \-\ AM",
"55513632", "Montenegro\ \-\ RS",
"55383728", "Angueretá\ \-\ MG",
"55473358", "Witmarsum\ \-\ SC",
"55434001", "Londrina\ \-\ PR",
"55473647", "Mafra\ \-\ SC",
"55833644", "Tenório\ \-\ PB",
"55843674", "Natal\ \-\ RN",
"55313084", "Belo\ Horizonte\ \-\ MG",
"55212703", "Niterói\ \-\ RJ",
"55753344", "Palmeiras\ \-\ BA",
"55222565", "Bom\ Jardim\ \-\ RJ",
"55513379", "Rio\ Grande\ do\ Sul",
"55353854", "Ilicínea\ \-\ MG",
"55483025", "Florianópolis\ \-\ SC",
"55863369", "Cajueiro\ da\ Praia\ \-\ PI",
"55353015", "Varginha\ \-\ MG",
"55183349", "Frutal\ do\ Campo\ \-\ SP",
"55923194", "Manaus\ \-\ AM",
"55833535", "São\ João\ do\ Rio\ do\ Peixe\ \-\ PB",
"55553375", "Panambi\ \-\ RS",
"55863360", "Joaquim\ Pires\ \-\ PI",
"55793236", "Aracaju\ \-\ SE",
"55713641", "Catu\ \-\ BA",
"55533262", "Arroio\ Grande\ \-\ RS",
"55663499", "Araguaiana\ \-\ MT",
"55313249", "Belo\ Horizonte\ \-\ MG",
"55114979", "Santo\ André\ \-\ SP",
"55543701", "Bento\ Gonçalves\ \-\ RS",
"55313240", "Perpétuo\ Socorro\ \-\ MG",
"55813705", "Santa\ Cruz\ do\ Capibaribe\ \-\ PE",
"55214007", "Rio\ de\ Janeiro\ \-\ RJ",
"55823421", "Palmeira\ dos\ Índios\ \-\ AL",
"55653025", "Cuiabá\ \-\ MT",
"55443667", "Santa\ Eliza\ \-\ PR",
"55843294", "São\ José\ do\ Campestre\ \-\ RN",
"55124104", "Taubaté\ \-\ SP",
"55483878", "Florianópolis\ \-\ SC",
"55653322", "Cuiabá\ \-\ MT",
"55533201", "Rio\ Grande\ \-\ RS",
"55613606", "Santo\ Antônio\ do\ Descoberto\ \-\ GO",
"55313779", "Sete\ Lagoas\ \-\ MG",
"55173651", "Palmeira\ D\'Oeste\ \-\ SP",
"55463552", "Capanema\ \-\ PR",
"55163415", "São\ Carlos\ \-\ SP",
"55543396", "Santo\ Expedito\ do\ Sul\ \-\ RS",
"55114094", "Diadema\ \-\ SP",
"55183021", "Birigui\ \-\ SP",
"55453541", "Santa\ Terezinha\ de\ Itaipu\ \-\ PR",
"55413032", "Campo\ Largo\ \-\ PR",
"55114454", "Santo\ André\ \-\ SP",
"55913783", "Breves\ \-\ PA",
"55313891", "Viçosa\ \-\ MG",
"5521341", "Rio\ de\ Janeiro\ \-\ RJ",
"55553430", "São\ Borja\ \-\ RS",
"55483535", "Jacinto\ Machado\ \-\ SC",
"55423250", "Abapã\ \-\ PR",
"55853342", "Caucaia\ \-\ CE",
"55373243", "Itaúna\ \-\ MG",
"55543532", "São\ João\ da\ Urtiga\ \-\ RS",
"55133841", "Iguape\ \-\ SP",
"55743672", "Morro\ do\ Chapéu\ \-\ BA",
"55753496", "Adustina\ \-\ BA",
"55213851", "Nova\ Iguaçu\ \-\ RJ",
"55843616", "Natal\ \-\ RN",
"55873929", "Serra\ Talhada\ \-\ PE",
"55623441", "Catalão\ \-\ GO",
"55653223", "Cáceres\ \-\ MT",
"55423259", "Ventania\ \-\ PR",
"55383662", "Buritis\ \-\ MG",
"55443622", "Umuarama\ \-\ PR",
"55493432", "Irani\ \-\ SC",
"55843265", "Poço\ Branco\ \-\ RN",
"55512139", "Porto\ Alegre\ \-\ RS",
"55343818", "Patos\ de\ Minas\ \-\ MG",
"55123431", "São\ José\ dos\ Campos\ \-\ SP",
"55423303", "Guarapuava\ \-\ PR",
"55813887", "Orocó\ \-\ PE",
"55793341", "Aquidabã\ \-\ SE",
"55173543", "Novo\ Horizonte\ \-\ SP",
"55273324", "Vitória\ \-\ ES",
"55473473", "Joinville\ \-\ SC",
"55933064", "Santarém\ \-\ PA",
"55933536", "Juruti\ \-\ PA",
"55123674", "Tremembé\ \-\ SP",
"55114468", "Santo\ André\ \-\ SP",
"55193824", "Águas\ de\ Lindóia\ \-\ SP",
"55193363", "Paulínia\ \-\ SP",
"55133299", "Santos\ \-\ SP",
"55333225", "Governador\ Valadares\ \-\ MG",
"55213118", "Rio\ de\ Janeiro\ \-\ RJ",
"55383756", "Buenópolis\ \-\ MG",
"55383843", "Novorizonte\ \-\ MG",
"55443344", "Maringá\ \-\ PR",
"55833456", "Pedra\ Branca\ \-\ PB",
"55813145", "Vitória\ de\ Santo\ Antão\ \-\ PE",
"55493338", "Cunhataí\ \-\ SC",
"55323337", "Mercês\ \-\ MG",
"55273048", "Linhares\ \-\ ES",
"55115612", "São\ Paulo\ \-\ SP",
"55443425", "Loanda\ \-\ PR",
"55433031", "Londrina\ \-\ PR",
"55913344", "Belém\ \-\ PA",
"55323339", "Barbacena\ \-\ MG",
"55623932", "Goiânia\ \-\ GO",
"55123682", "Taubaté\ \-\ SP",
"55123011", "Taubaté\ \-\ SP",
"55813742", "Cachoeirinha\ \-\ PE",
"55323330", "Correia\ de\ Almeida\ \-\ MG",
"55913425", "Bragança\ \-\ PA",
"55142105", "Marília\ \-\ SP",
"55274003", "Vitória\ \-\ ES",
"55713462", "Salvador\ \-\ BA",
"55513043", "Gravataí\ \-\ RS",
"55173667", "Turmalina\ \-\ SP",
"55863322", "Parnaíba\ \-\ PI",
"55113436", "Guarulhos\ \-\ SP",
"55623494", "Cavalcante\ \-\ GO",
"55883411", "Russas\ \-\ CE",
"55453565", "São\ Miguel\ do\ Iguaçu\ \-\ PR",
"55213520", "Rio\ de\ Janeiro\ \-\ RJ",
"55813217", "Recife\ \-\ PE",
"55343835", "Cruzeiro\ da\ Fortaleza\ \-\ MG",
"55743684", "Canarana\ \-\ BA",
"55423245", "Socavão\ \-\ PR",
"55143278", "Lençóis\ Paulista\ \-\ SP",
"55743619", "Jaguarari\ \-\ BA",
"55843336", "São\ Rafael\ \-\ RN",
"55883085", "Juazeiro\ do\ Norte\ \-\ CE",
"55353556", "Arceburgo\ \-\ MG",
"55553546", "Alecrim\ \-\ RS",
"55112229", "Guarulhos\ \-\ SP",
"55153256", "Campina\ do\ Monte\ Alegre\ \-\ SP",
"55813272", "Recife\ \-\ PE",
"55483953", "Florianópolis\ \-\ SC",
"55713216", "Simões\ Filho\ \-\ BA",
"55543234", "São\ José\ dos\ Ausentes\ \-\ RS",
"55273090", "Cariacica\ \-\ ES",
"55313712", "Matozinhos\ \-\ MG",
"55513775", "Pouso\ Novo\ \-\ RS",
"55943335", "Itinga\ do\ Maranhão\ \-\ PA",
"55173344", "Bebedouro\ \-\ SP",
"55463254", "Coronel\ Domingos\ Soares\ \-\ PR",
"55752101", "Feira\ de\ Santana\ \-\ BA",
"55483271", "Florianópolis\ \-\ SC",
"55673687", "Miranda\ \-\ MS",
"55653691", "Várzea\ Grande\ \-\ MT",
"55242483", "Miguel\ Pereira\ \-\ RJ",
"55823647", "Pariconha\ \-\ AL",
"55993644", "Lago\ da\ Pedra\ \-\ MA",
"55853305", "Fortaleza\ \-\ CE",
"55193808", "Amparo\ \-\ SP",
"55353435", "Extrema\ \-\ MG",
"55193913", "Itapira\ \-\ SP",
"5541356", "Curitiba\ \-\ PR",
"55143326", "Ourinhos\ \-\ SP",
"55183695", "Planalto\ \-\ SP",
"55733605", "Itabatan\ \-\ BA",
"55212712", "São\ Gonçalo\ \-\ RJ",
"55433573", "Guapirama\ \-\ PR",
"55313844", "Cava\ Grande\ \-\ MG",
"55433176", "Rolândia\ \-\ PR",
"55113555", "São\ Paulo\ \-\ SP",
"55663497", "Primavera\ do\ Leste\ \-\ MT",
"55313247", "Belo\ Horizonte\ \-\ MG",
"55143473", "Alvinlândia\ \-\ SP",
"55183355", "Presidente\ Prudente\ \-\ SP",
"55443543", "Ubiratã\ \-\ PR",
"55833271", "Guarabira\ \-\ PB",
"55123833", "Ubatuba\ \-\ SP",
"55873883", "Parnamirim\ \-\ PE",
"55793365", "Malhada\ dos\ Bois\ \-\ SE",
"55183658", "Clementina\ \-\ SP",
"55863367", "Luís\ Correia\ \-\ PI",
"55173622", "Jales\ \-\ SP",
"55114912", "São\ Paulo\ \-\ SP",
"55653351", "Nossa\ Senhora\ do\ Livramento\ \-\ MT",
"55633433", "Palmeiras\ do\ Tocantins\ \-\ TO",
"55843241", "Canguaretama\ \-\ RN",
"55143108", "Bauru\ \-\ SP",
"55793431", "Itabaiana\ \-\ SE",
"55953552", "Bonfim\ \-\ RR",
"55483269", "Florianópolis\ \-\ SC",
"55473501", "Jaraguá\ do\ Sul\ \-\ SC",
"55273032", "Vila\ Velha\ \-\ ES",
"55143295", "Boracéia\ \-\ SP",
"55153467", "Capela\ do\ Alto\ \-\ SP",
"55913014", "Ananindeua\ \-\ PA",
"55115931", "São\ Paulo\ \-\ SP",
"55493342", "Galvão\ \-\ SC",
"5511422", "São\ Caetano\ do\ Sul\ \-\ SP",
"55273335", "Vitória\ \-\ ES",
"55112835", "São\ Caetano\ do\ Sul\ \-\ SP",
"55313626", "Ribeirão\ das\ Neves\ \-\ MG",
"55433429", "Califórnia\ \-\ PR",
"55693521", "Jaru\ \-\ RO",
"55513313", "Nova\ Santa\ Rita\ \-\ RS",
"55623331", "Pirenópolis\ \-\ GO",
"55213748", "Belford\ Roxo\ \-\ RJ",
"5511362", "São\ Paulo\ \-\ SP",
"55983198", "São\ Luís\ \-\ MA",
"55474007", "Joinville\ \-\ SC",
"55143529", "Lins\ \-\ SP",
"55743621", "Jacobina\ \-\ BA",
"5521340", "Rio\ de\ Janeiro\ \-\ RJ",
"55883420", "São\ João\ do\ Jaguaribe\ \-\ CE",
"55484004", "Florianópolis\ \-\ SC",
"55222652", "Saquarema\ \-\ RJ",
"55883641", "Pacujá\ \-\ CE",
"55323447", "Leopoldina\ \-\ MG",
"55163661", "Batatais\ \-\ SP",
"55693463", "Mirante\ da\ Serra\ \-\ RO",
"55193578", "Campinas\ \-\ SP",
"55493448", "Arabutã\ \-\ SC",
"55242220", "Petrópolis\ \-\ RJ",
"55163405", "Franca\ \-\ SP",
"55883429", "Alto\ Santo\ \-\ CE",
"55353361", "Itanhandu\ \-\ MG",
"55613616", "Águas\ Lindas\ de\ Goiás\ \-\ GO",
"55623999", "Goiânia\ \-\ GO",
"55493624", "Romelândia\ \-\ SC",
"55193406", "Americana\ \-\ SP",
"55353286", "Divisa\ Nova\ \-\ MG",
"55423277", "Ortigueira\ \-\ PR",
"55813252", "Recife\ \-\ PE",
"55473562", "Taió\ \-\ SC",
"55153276", "Sarapuí\ \-\ SP",
"55333234", "Engenheiro\ Caldas\ \-\ MG",
"55193835", "Indaiatuba\ \-\ SP",
"55853338", "Beberibe\ \-\ CE",
"55323536", "Senador\ Firmino\ \-\ MG",
"55413048", "Araucária\ \-\ PR",
"55483251", "Florianópolis\ \-\ SC",
"55513755", "Muçum\ \-\ RS",
"55312108", "Belo\ Horizonte\ \-\ MG",
"5532323", "Juiz\ de\ Fora\ \-\ MG",
"55883553", "Milagres\ \-\ CE",
"55444101", "Sarandi\ \-\ PR",
"55323293", "Liberdade\ \-\ MG",
"55843606", "Natal\ \-\ RN",
"55144009", "Bauru\ \-\ SP",
"55114482", "Mairiporã\ \-\ SP",
"55353690", "Varginha\ \-\ MG",
"55513747", "Arroio\ do\ Tigre\ \-\ RS",
"55513466", "Canoas\ \-\ RS",
"55313757", "Itaverava\ \-\ MG",
"55453237", "Lindoeste\ \-\ PR",
"55694001", "Porto\ Velho\ \-\ RO",
"55413642", "Araucária\ \-\ PR",
"55283526", "Cachoeiro\ de\ Itapemirim\ \-\ ES",
"55183375", "Pedrinhas\ Paulista\ \-\ SP",
"55163659", "Brodowski\ \-\ SP",
"55693316", "Vilhena\ \-\ RO",
"55694062", "Porto\ Velho\ \-\ RO",
"55143453", "Marília\ \-\ SP",
"55433156", "Rolândia\ \-\ PR",
"55483524", "Araranguá\ \-\ SC",
"55813693", "Xexéu\ \-\ PE",
"55493243", "Correia\ Pinto\ \-\ SC",
"55433553", "Nova\ América\ da\ Colina\ \-\ PR",
"55193483", "São\ Pedro\ \-\ SP",
"55653371", "Nova\ Mutum\ \-\ MT",
"55163931", "Ribeirão\ Preto\ \-\ SP",
"55143264", "Lençóis\ Paulista\ \-\ SP",
"55893541", "Marcos\ Parente\ \-\ PI",
"55833251", "João\ Pessoa\ \-\ PB",
"55513587", "Novo\ Hamburgo\ \-\ RS",
"55653566", "Juína\ \-\ MT",
"55413457", "Pontal\ do\ Paraná\ \-\ PR",
"55353345", "Carvalhos\ \-\ MG",
"55553355", "Caibaté\ \-\ RS",
"55313531", "Betim\ \-\ MG",
"55673444", "Taquarussu\ \-\ MS",
"55883401", "Limoeiro\ do\ Norte\ \-\ CE",
"55513589", "São\ Leopoldo\ \-\ RS",
"55673022", "Campo\ Grande\ \-\ MS",
"55613241", "Olinda\ \-\ PE",
"55413099", "Curitiba\ \-\ PR",
"55513580", "Novo\ Hamburgo\ \-\ RS",
"55113191", "São\ Paulo\ \-\ SP",
"55743536", "Casa\ Nova\ \-\ BA",
"55353424", "Congonhal\ \-\ MG",
"55973346", "Uarini\ \-\ AM",
"55883665", "Morrinhos\ \-\ CE",
"55943324", "Marabá\ \-\ PA",
"55553347", "Santa\ Maria\ \-\ RS",
"55473258", "Vitor\ Meireles\ \-\ SC",
"55513270", "Rio\ Grande\ do\ Sul",
"55223321", "Rio\ das\ Ostras\ \-\ RJ",
"55983013", "São\ Luís\ \-\ MA",
"55343262", "Ituiutaba\ \-\ MG",
"55213976", "Rio\ de\ Janeiro\ \-\ RJ",
"5522", "Rio\ de\ Janeiro",
"55452102", "Foz\ do\ Iguaçu\ \-\ PR",
"55193646", "São\ Sebastião\ da\ Grama\ \-\ SP",
"55513279", "Rio\ Grande\ do\ Sul",
"55753244", "Conceição\ da\ Feira\ \-\ BA",
"55474052", "Blumenau\ \-\ SC",
"55163348", "Motuca\ \-\ SP",
"55313759", "Minas\ Gerais",
"55873816", "Buíque\ \-\ PE",
"55353697", "Poços\ de\ Caldas\ \-\ MG",
"55513749", "Palanque\ \-\ RS",
"55663432", "Poxoréo\ \-\ MT",
"55473135", "Rio\ da\ Anta\ \-\ SC",
"55473520", "Rio\ do\ Sul\ \-\ SC",
"55453239", "Juvinópolis\ \-\ PR",
"55453230", "Diamante\ do\ Sul\ \-\ PR",
"55343201", "Araxá\ \-\ MG",
"55423633", "Mato\ Rico\ \-\ PR",
"55163397", "Araraquara\ \-\ SP",
"55112646", "São\ Paulo\ \-\ SP",
"55513740", "Santa\ Cruz\ do\ Sul\ \-\ RS",
"55183703", "Bairro\ Formosa\ \-\ SP",
"55313750", "Minas\ Gerais",
"55123668", "Campos\ do\ Jordão\ \-\ SP",
"55114474", "Santo\ André\ \-\ SP",
"55414003", "Curitiba\ \-\ PR",
"55163024", "Ribeirão\ Preto\ \-\ SP",
"55433401", "Cornélio\ Procópio\ \-\ PR",
"55463572", "Cruzeiro\ do\ Iguaçu\ \-\ PR",
"55153451", "Tatuí\ \-\ SP",
"5531334", "Minas\ Gerais",
"55473264", "Balneário\ Camboriú\ \-\ SC",
"55453026", "Foz\ do\ Iguaçu\ \-\ PR",
"55833267", "Juarez\ Távora\ \-\ PB",
"55483476", "Nova\ Veneza\ \-\ SC",
"55753623", "Feira\ de\ Santana\ \-\ BA",
"55123027", "São\ José\ dos\ Campos\ \-\ SP",
"55333532", "Itaipé\ \-\ MG",
"55193903", "Sumaré\ \-\ SP",
"55853012", "Caucaia\ \-\ CE",
"55853315", "São\ Gonçalo\ do\ Amarante\ \-\ CE",
"55193818", "Mogi\-Guaçu\ \-\ SP",
"55413605", "Colombo\ \-\ PR",
"55743652", "Ibititá\ \-\ BA",
"55623997", "Goiânia\ \-\ GO",
"55434063", "Londrina\ \-\ PR",
"55333727", "Santa\ Maria\ do\ Salto\ \-\ MG",
"55423270", "Guaragi\ \-\ PR",
"55163726", "Orlândia\ \-\ SP",
"55193881", "Valinhos\ \-\ SP",
"55613336", "Taguatinga\ \-\ DF",
"55893565", "Santa\ Luz\ \-\ PI",
"55473453", "Joinville\ \-\ SC",
"55883427", "Boa\ Viagem\ \-\ CE",
"55913434", "Garrafão\ do\ Norte\ \-\ PA",
"55114961", "Itupeva\ \-\ SP",
"55733266", "Itarantim\ \-\ BA",
"55323449", "Leopoldina\ \-\ MG",
"55672106", "Campo\ Grande\ \-\ MS",
"55273381", "Vitória\ \-\ ES",
"55183786", "Sud\ Mennucci\ \-\ SP",
"55123654", "Caçapava\ \-\ SP",
"55313761", "Conselheiro\ Lafaiete\ \-\ MG",
"55143732", "Avaré\ \-\ SP",
"55713283", "Salvador\ \-\ BA",
"55433354", "Londrina\ \-\ PR",
"55913087", "Belém\ \-\ PA",
"55713176", "Salvador\ \-\ BA",
"55343824", "Lagoa\ Formosa\ \-\ MG",
"55222621", "São\ Pedro\ da\ Aldeia\ \-\ RJ",
"55273266", "Santa\ Leopoldina\ \-\ ES",
"55623611", "Aparecida\ de\ Goiânia\ \-\ GO",
"55513633", "Pareci\ Novo\ \-\ RS",
"55443014", "Marialva\ \-\ PR",
"55813738", "Cupira\ \-\ PE",
"55115645", "São\ Paulo\ \-\ SP",
"55483267", "Nova\ Trento\ \-\ SC",
"55112818", "Mauá\ \-\ SP",
"55623385", "Nova\ Crixás\ \-\ GO",
"55413523", "Curitiba\ \-\ PR",
"55493198", "Maravilha\ \-\ SC",
"55113601", "Osasco\ \-\ SP",
"55333022", "Governador\ Valadares\ \-\ MG",
"55693411", "Ji\-Paraná\ \-\ RO",
"55333325", "Imbé\ de\ Minas\ \-\ MG",
"55115066", "São\ Paulo\ \-\ SP",
"55473904", "Itapema\ \-\ SC",
"55143484", "Álvaro\ de\ Carvalho\ \-\ SP",
"55112970", "Barueri\ \-\ SP",
"55713500", "Salvador\ \-\ BA",
"55443244", "Paiçandu\ \-\ PR",
"55873874", "Ouricuri\ \-\ PE",
"55533263", "Santa\ Vitória\ do\ Palmar\ \-\ RS",
"55742102", "Juazeiro\ \-\ BA",
"55873798", "Bom\ Conselho\ \-\ PE",
"55493238", "Palmeira\ \-\ SC",
"55183996", "Marabá\ Paulista\ \-\ SP",
"55114201", "Barueri\ \-\ SP",
"55683026", "Rio\ Branco\ \-\ AC",
"55193454", "Santa\ Bárbara\ D\'Oeste\ \-\ SP",
"55333628", "Umburatiba\ \-\ MG",
"55433274", "Arapongas\ \-\ PR",
"55643495", "Goiatuba\ \-\ GO",
"55813637", "Aliança\ \-\ PE",
"55863251", "São\ João\ da\ Serra\ \-\ PI",
"55373343", "Camacho\ \-\ MG",
"55474105", "Itajaí\ \-\ SC",
"55213980", "Rio\ de\ Janeiro\ \-\ RJ",
"55623598", "Aparecida\ de\ Goiânia\ \-\ GO",
"55513408", "Rio\ Grande\ do\ Sul",
"55913131", "Belém\ \-\ PA",
"55843365", "Messias\ Targino\ \-\ RN",
"55883519", "Granjeiro\ \-\ CE",
"55193979", "Monte\ Mor\ \-\ SP",
"55463553", "Espigão\ Alto\ do\ Iguaçu\ \-\ PR",
"55343631", "Ibiá\ \-\ MG",
"55273224", "Vitória\ \-\ ES",
"55773467", "Jacaraci\ \-\ BA",
"55733551", "Aurelino\ Leal\ \-\ BA",
"55813319", "São\ Lourenço\ da\ Mata\ \-\ PE",
"55713636", "Vera\ Cruz\ \-\ BA",
"55413033", "Pinhais\ \-\ PR",
"55843062", "Mossoró\ \-\ RN",
"55543614", "Rio\ dos\ Índios\ \-\ RS",
"55883510", "Iguatu\ \-\ CE",
"55883584", "Orós\ \-\ CE",
"55373242", "Itaúna\ \-\ MG",
"55833489", "São\ José\ de\ Caiana\ \-\ PB",
"55682102", "Rio\ Branco\ \-\ AC",
"55543533", "Caxias\ do\ Sul\ \-\ RS",
"55513699", "Rio\ Grande\ do\ Sul",
"55553757", "Novo\ Barreiro\ \-\ RS",
"55353466", "Munhoz\ \-\ MG",
"55743673", "Uauá\ \-\ BA",
"55162107", "São\ Carlos\ \-\ SP",
"55843394", "Frutuoso\ Gomes\ \-\ RN",
"55853343", "Canindé\ \-\ CE",
"55653222", "Cáceres\ \-\ MT",
"55443623", "Umuarama\ \-\ PR",
"55383663", "Buritis\ \-\ MG",
"55433046", "Arapongas\ \-\ PR",
"55513690", "Rio\ Grande\ do\ Sul",
"55833480", "Igaracy\ \-\ PB",
"55173849", "Macedônia\ \-\ SP",
"55543296", "Nova\ Pádua\ \-\ RS",
"55553745", "Iraí\ \-\ RS",
"55613485", "Sobradinho\ \-\ DF",
"55423302", "Ponta\ Grossa\ \-\ PR",
"55493433", "Xanxerê\ \-\ SC",
"55193301", "Piracicaba\ \-\ SP",
"55473472", "Joinville\ \-\ SC",
"55173542", "Novo\ Horizonte\ \-\ SP",
"55943366", "Vila\ Novo\ Paraíso\ \-\ PA",
"55213733", "Rio\ de\ Janeiro\ \-\ RJ",
"55863269", "Beneditinos\ \-\ PI",
"55153577", "Barra\ do\ Turvo\ \-\ SP",
"55773625", "Santa\ Rita\ de\ Cássia\ \-\ BA",
"55663544", "Sorriso\ \-\ MT",
"55112301", "São\ Paulo\ \-\ SP",
"55413158", "Campina\ Grande\ do\ Sul\ \-\ PR",
"55353212", "Varginha\ \-\ MG",
"55473039", "Blumenau\ \-\ SC",
"55863260", "Demerval\ Lobão\ \-\ PI",
"55193362", "Mogi\-Guaçu\ \-\ SP",
"55923071", "Manaus\ \-\ AM",
"55843654", "Natal\ \-\ RN",
"55383842", "Salinas\ \-\ MG",
"55823527", "Craíbas\ \-\ AL",
"55353798", "Areado\ \-\ MG",
"55153287", "Laranjal\ Paulista\ \-\ SP",
"55173291", "Riolândia\ \-\ SP",
"55193796", "Campinas\ \-\ SP",
"55823520", "Girau\ do\ Ponciano\ \-\ AL",
"55153289", "Ibiúna\ \-\ SP",
"55383547", "Serra\ Azul\ de\ Minas\ \-\ MG",
"55122128", "Jacareí\ \-\ SP",
"55683237", "Plácido\ de\ Castro\ \-\ AC",
"55323026", "Juiz\ de\ Fora\ \-\ MG",
"55773451", "Guanambi\ \-\ BA",
"55623933", "Goiânia\ \-\ GO",
"55274002", "Vitória\ \-\ ES",
"55183255", "Rancharia\ \-\ SP",
"55823529", "Arapiraca\ \-\ AL",
"55813743", "Camocim\ de\ São\ Félix\ \-\ PE",
"55833371", "Picuí\ \-\ PB",
"55823295", "São\ Miguel\ dos\ Milagres\ \-\ AL",
"55513042", "Gravataí\ \-\ RS",
"55933735", "Monte\ Dourado\ \-\ PA",
"55793265", "Nossa\ Senhora\ das\ Dores\ \-\ SE",
"55863323", "Parnaíba\ \-\ PI",
"55513424", "Rio\ Grande\ do\ Sul",
"55863267", "Lagoa\ Alegre\ \-\ PI",
"55213823", "Rio\ de\ Janeiro\ \-\ RJ",
"55513345", "Rio\ Grande\ do\ Sul",
"55653251", "São\ José\ dos\ Quatro\ Marcos\ \-\ MT",
"55283036", "Cachoeiro\ de\ Itapemirim\ \-\ ES",
"552122", "Rio\ de\ Janeiro\ \-\ RJ",
"55114595", "Várzea\ Paulista\ \-\ SP",
"55753434", "Acajutiba\ \-\ BA",
"55623016", "Aparecida\ de\ Goiânia\ \-\ GO",
"55113441", "São\ Paulo\ \-\ SP",
"5543342", "Apucarana\ \-\ PR",
"55222673", "Araruama\ \-\ RJ",
"55713521", "Salvador\ \-\ BA",
"55493700", "Chapecó\ \-\ SC",
"55173847", "Floreal\ \-\ SP",
"55483034", "São\ José\ \-\ SC",
"55733208", "Nova\ Viçosa\ \-\ BA",
"55893475", "Novo\ Oriente\ do\ Piauí\ \-\ PI",
"55483952", "Florianópolis\ \-\ SC",
"55813273", "Recife\ \-\ PE",
"55823258", "Passo\ de\ Camaragibe\ \-\ AL",
"55373544", "Cedro\ do\ Abaeté\ \-\ MG",
"55143226", "Bauru\ \-\ SP",
"55513697", "Brochier\ \-\ RS",
"55162109", "Araraquara\ \-\ SP",
"55673234", "Corumbá\ \-\ MS",
"55313398", "Minas\ Gerais",
"55283558", "Jerônimo\ Monteiro\ \-\ ES",
"55824009", "Maceió\ \-\ AL",
"55133348", "Guarujá\ \-\ SP",
"55313713", "Capim\ Branco\ \-\ MG",
"55143378", "Salto\ Grande\ \-\ SP",
"55843236", "Natal\ \-\ RN",
"55193977", "Artur\ Nogueira\ \-\ SP",
"55883517", "Jucás\ \-\ CE",
"55773460", "Igaporã\ \-\ BA",
"55433306", "Londrina\ \-\ PR",
"55423648", "Marquinho\ \-\ PR",
"55813372", "Paulista\ \-\ PE",
"55813639", "Macaparana\ \-\ PE",
"55714062", "Salvador\ \-\ BA",
"55114036", "Piracaia\ \-\ SP",
"55754101", "Feira\ de\ Santana\ \-\ BA",
"55322102", "Juiz\ de\ Fora\ \-\ MG",
"55213987", "Rio\ de\ Janeiro\ \-\ RJ",
"55913774", "São\ Francisco\ do\ Pará\ \-\ PA",
"55353100", "Extrema\ \-\ MG",
"55543334", "Colorado\ \-\ RS",
"55973441", "Santa\ Isabel\ do\ Rio\ Negro\ \-\ AM",
"55823264", "Atalaia\ \-\ AL",
"55212713", "São\ Gonçalo\ \-\ RJ",
"55623549", "Aparecida\ de\ Goiânia\ \-\ GO",
"55433572", "Londrina\ \-\ PR",
"55443542", "Campina\ da\ Lagoa\ \-\ PR",
"55323724", "Eugenópolis\ \-\ MG",
"55143472", "Ubirajara\ \-\ SP",
"55923533", "Parintins\ \-\ AM",
"55123832", "Ubatuba\ \-\ SP",
"55873882", "Serrita\ \-\ PE",
"55813478", "Jaboatão\ dos\ Guararapes\ \-\ PE",
"55114808", "Jundiaí\ \-\ SP",
"55143417", "Marília\ \-\ SP",
"55214138", "Queimados\ \-\ RJ",
"55633432", "Bandeirantes\ do\ Tocantins\ \-\ TO",
"55654004", "Várzea\ Grande\ \-\ MT",
"5564", "Goiás",
"55212664", "Japeri\ \-\ RJ",
"55413031", "Araucária\ \-\ PR",
"55114699", "Mogi\ das\ Cruzes\ \-\ SP",
"55183325", "Assis\ \-\ SP",
"55313892", "Viçosa\ \-\ MG",
"55313590", "Minas\ Gerais",
"55313599", "Ibirité\ \-\ MG",
"55513363", "Rio\ Grande\ do\ Sul",
"55343633", "Tapira\ \-\ MG",
"55663027", "Rondonópolis\ \-\ MT",
"55213809", "Rio\ de\ Janeiro\ \-\ RJ",
"55123965", "Jacareí\ \-\ SP",
"55183022", "Assis\ \-\ SP",
"55653321", "Cuiabá\ \-\ MT",
"55943382", "Sapucaia\ \-\ PA",
"55242109", "Resende\ \-\ RJ",
"55373341", "Itapecerica\ \-\ MG",
"55863253", "Juazeiro\ do\ Piauí\ \-\ PI",
"55473154", "Rio\ dos\ Cedros\ \-\ SC",
"5565", "Mato\ Grosso",
"55823422", "Cacimbinhas\ \-\ AL",
"55543702", "Bento\ Gonçalves\ \-\ RS",
"55193386", "Campinas\ \-\ SP",
"55463224", "Pato\ Branco\ \-\ PR",
"55443607", "São\ Tomé\ \-\ PR",
"55173392", "Viradouro\ \-\ SP",
"55533261", "Jaguarão\ \-\ RS",
"55273553", "Guaçuí\ \-\ ES",
"55833284", "Caldas\ Brandão\ \-\ PB",
"55823625", "Maravilha\ \-\ AL",
"55153378", "Pilar\ do\ Sul\ \-\ SP",
"55673437", "Ponta\ Porã\ \-\ MS",
"55493905", "Chapecó\ \-\ SC",
"55163385", "Tabatinga\ \-\ SP",
"55693413", "Urupá\ \-\ RO",
"55713642", "Pólo\ Petroquímico\ Camaçari\ \-\ BA",
"55143356", "Manduri\ \-\ SP",
"55753237", "Teodoro\ Sampaio\ \-\ BA",
"55893538", "Colônia\ do\ Gurguéia\ \-\ PI",
"55553334", "Augusto\ Pestana\ \-\ RS",
"55843003", "Natal\ \-\ RN",
"55113603", "Osasco\ \-\ SP",
"55463560", "Pinhal\ de\ São\ Bento\ \-\ PR",
"55173293", "Palestina\ \-\ SP",
"55953235", "São\ João\ da\ Baliza\ \-\ RR",
"55114005", "São\ Paulo\ \-\ SP",
"55353526", "Passos\ \-\ MG",
"55513416", "Capão\ da\ Canoa\ \-\ RS",
"55623645", "Goiânia\ \-\ GO",
"55115611", "São\ Paulo\ \-\ SP",
"5517323", "São\ José\ do\ Rio\ Preto\ \-\ SP",
"55433032", "Londrina\ \-\ PR",
"55823276", "Jequiá\ da\ Praia\ \-\ AL",
"55673546", "Brasilândia\ \-\ MS",
"55114302", "São\ Paulo\ \-\ SP",
"55873945", "Serra\ Talhada\ \-\ PE",
"55243333", "Arrozal\ \-\ RJ",
"5511474", "Suzano\ \-\ SP",
"55623348", "Mozarlândia\ \-\ GO",
"55493674", "Mondaí\ \-\ SC",
"55112303", "Guarulhos\ \-\ SP",
"55213731", "Maricá\ \-\ RJ",
"55613013", "Brasília\ \-\ DF",
"55312559", "Contagem\ \-\ MG",
"55123635", "Taubaté\ \-\ SP",
"55933543", "Rurópolis\ \-\ PA",
"55793342", "Muribeca\ \-\ SE",
"55623397", "Rialma\ \-\ GO",
"55883638", "Hidrolândia\ \-\ CE",
"55633530", "Rio\ dos\ Bois\ \-\ TO",
"55633539", "Lizarda\ \-\ TO",
"55493431", "Xanxerê\ \-\ SC",
"55114408", "Cajamar\ \-\ SP",
"55893496", "São\ Francisco\ de\ Assis\ do\ Piauí\ \-\ PI",
"55143214", "Bauru\ \-\ SP",
"55793045", "Aracaju\ \-\ SE",
"55123432", "Taubaté\ \-\ SP",
"55913447", "Cachoeira\ do\ Piriá\ \-\ PA",
"55413908", "Curitiba\ \-\ PR",
"55213852", "Rio\ de\ Janeiro\ \-\ RJ",
"55443440", "Inajá\ \-\ PR",
"55443621", "Umuarama\ \-\ PR",
"55343514", "Cachoeira\ Dourada\ \-\ MG",
"5511458", "Jundiaí\ \-\ SP",
"55693218", "Porto\ Velho\ \-\ RO",
"55124158", "Vargem\ Grande\ Paulista\ \-\ SP",
"5511367", "São\ Paulo\ \-\ SP",
"55114576", "Mauá\ \-\ SP",
"55813535", "Moreno\ \-\ PE",
"55853341", "Maranguape\ \-\ CE",
"55112528", "São\ Paulo\ \-\ SP",
"55114173", "São\ Bernardo\ do\ Campo\ \-\ SP",
"55543531", "Paim\ Filho\ \-\ RS",
"55133842", "Ilha\ Comprida\ \-\ SP",
"55693235", "Porto\ Velho\ \-\ RO",
"55613433", "Brasília\ \-\ DF",
"55443447", "Alto\ Paraná\ \-\ PR",
"55473356", "Vidal\ Ramos\ \-\ SC",
"55383726", "Santo\ Hipólito\ \-\ MG",
"55913621", "Caiçava\ \-\ PA",
"55413283", "São\ José\ dos\ Pinhais\ \-\ PR",
"55112119", "Atibaia\ \-\ SP",
"55663593", "Apiacás\ \-\ MT",
"55533245", "Candiota\ \-\ RS",
"55913449", "São\ João\ de\ Pirabas\ \-\ PA",
"55813127", "Recife\ \-\ PE",
"55543275", "Nova\ Araçá\ \-\ RS",
"55774009", "Vitória\ da\ Conquista\ \-\ BA",
"55163246", "Taiúva\ \-\ SP",
"55813518", "Cabo\ de\ Santo\ Agostinho\ \-\ PE",
"55433477", "São\ João\ do\ Ivaí\ \-\ PR",
"55343212", "Uberlândia\ \-\ MG",
"55813271", "Recife\ \-\ PE",
"55143884", "Anhembi\ \-\ SP",
"55962101", "Macapá\ \-\ AP",
"55443455", "Santa\ Mônica\ \-\ PR",
"55813581", "Chã\ de\ Alegria\ \-\ PE",
"55533257", "Piratini\ \-\ RS",
"55333247", "Itabirinha\ \-\ MG",
"55513564", "Dois\ Irmãos\ \-\ RS",
"55513036", "Novo\ Hamburgo\ \-\ RS",
"55114816", "Jundiaí\ \-\ SP",
"55113443", "São\ Paulo\ \-\ SP",
"55413573", "Curitiba\ \-\ PR",
"55833426", "Emas\ \-\ PB",
"55143287", "Avaí\ \-\ SP",
"55883412", "Quixadá\ \-\ CE",
"5586", "Piauí",
"55333298", "Açucena\ \-\ MG",
"55443652", "Iporã\ \-\ PR",
"55713605", "Candeias\ \-\ BA",
"55193775", "Campinas\ \-\ SP",
"55312557", "Contagem\ \-\ MG",
"55553533", "São\ Martinho\ \-\ RS",
"55733694", "São\ José\ da\ Vitória\ \-\ BA",
"55713461", "Salvador\ \-\ BA",
"55183604", "Vicentinópolis\ \-\ SP",
"55863321", "Parnaíba\ \-\ PI",
"55112245", "Guarulhos\ \-\ SP",
"55312", "Minas\ Gerais",
"55542108", "Caxias\ do\ Sul\ \-\ RS",
"55833373", "Araruna\ \-\ PB",
"55433266", "Nova\ Santa\ Bárbara\ \-\ PR",
"55123681", "Taubaté\ \-\ SP",
"55813741", "Toritama\ \-\ PE",
"55273354", "Viana\ \-\ ES",
"55773453", "Brumado\ \-\ BA",
"55623931", "Goiânia\ \-\ GO",
"55753230", "Antônio\ Cardoso\ \-\ BA",
"55173621", "Jales\ \-\ SP",
"55114911", "São\ Paulo\ \-\ SP",
"55513558", "Rio\ Grande\ do\ Sul",
"55313548", "Minas\ Gerais",
"55423036", "Guarapuava\ \-\ PR",
"55112504", "São\ Paulo\ \-\ SP",
"55653352", "Nova\ Marilândia\ \-\ MT",
"55843242", "Arês\ \-\ RN",
"55653055", "Cuiabá\ \-\ MT",
"55192137", "Campinas\ \-\ SP",
"55753239", "Anguera\ \-\ BA",
"55893515", "Floriano\ \-\ PI",
"55923531", "Barreirinha\ \-\ AM",
"55993321", "Imperatriz\ \-\ MA",
"55673439", "Bela\ Vista\ \-\ MS",
"55853365", "Canindé\ \-\ CE",
"55114424", "Santo\ André\ \-\ SP",
"55193868", "Estiva\ Gerbi\ \-\ SP",
"55813101", "Caruaru\ \-\ PE",
"55553614", "Vitória\ das\ Missões\ \-\ RS",
"5599", "Maranhão",
"55353866", "Santana\ do\ Jacaré\ \-\ MG",
"55714003", "Salvador\ \-\ BA",
"55833217", "Santa\ Rita\ \-\ PB",
"55733665", "Teixeira\ de\ Freitas\ \-\ BA",
"55713450", "Salvador\ \-\ BA",
"55513595", "Novo\ Hamburgo\ \-\ RS",
"55413382", "São\ José\ dos\ Pinhais\ \-\ PR",
"55443133", "Mandaguari\ \-\ PR",
"55443536", "Brasiliana\ \-\ PR",
"55892101", "Picos\ \-\ PI",
"55623661", "Goiânia\ \-\ GO",
"55242107", "Volta\ Redonda\ \-\ RJ",
"55513734", "Pantano\ Grande\ \-\ RS",
"55752102", "Feira\ de\ Santana\ \-\ BA",
"55483272", "Antônio\ Carlos\ \-\ SC",
"55324101", "Barbacena\ \-\ MG",
"55653692", "Várzea\ Grande\ \-\ MT",
"55633446", "Sítio\ Novo\ do\ Tocantins\ \-\ TO",
"55453244", "Missal\ \-\ PR",
"55313711", "Prudente\ de\ Morais\ \-\ MG",
"55273401", "Baixo\ Guandu\ \-\ ES",
"55513229", "Rio\ Grande\ do\ Sul",
"55173834", "Guarani\ D\'Oeste\ \-\ SP",
"55483047", "São\ José\ \-\ SC",
"55153527", "Itapetininga\ \-\ SP",
"55833458", "Manaíra\ \-\ PB",
"55493336", "Guatambú\ \-\ SC",
"55423526", "Porto\ União\ \-\ SC",
"55673255", "Bonito\ \-\ MS",
"55114755", "Itaquaquecetuba\ \-\ SP",
"55473625", "Irineópolis\ \-\ SC",
"55823287", "Capela\ \-\ AL",
"55753447", "Ouriçangas\ \-\ BA",
"55993574", "Fortuna\ \-\ MA",
"55923021", "Manaus\ \-\ AM",
"55483055", "Içara\ \-\ SC",
"55353824", "Ingaí\ \-\ MG",
"5542322", "Ponta\ Grossa\ \-\ PR",
"55353363", "Itamonte\ \-\ MG",
"55513482", "Barra\ do\ Ribeiro\ \-\ RS",
"55433569", "Pinhalão\ \-\ PR",
"55693461", "Ouro\ Preto\ do\ Oeste\ \-\ RO",
"55413552", "Araucária\ \-\ PR",
"55212687", "Itaguaí\ \-\ RJ",
"55673247", "Costa\ Rica\ \-\ MS",
"55933538", "Terra\ Santa\ \-\ PA",
"55163663", "Jardinópolis\ \-\ SP",
"55213513", "Rio\ de\ Janeiro\ \-\ RJ",
"55433560", "Cornélio\ Procópio\ \-\ PR",
"55213116", "Rio\ de\ Janeiro\ \-\ RJ",
"556733", "Campo\ Grande\ \-\ MS",
"55883643", "Massapê\ \-\ CE",
"55383758", "Augusto\ de\ Lima\ \-\ MG",
"55313071", "Belo\ Horizonte\ \-\ MG",
"55733046", "Jequié\ \-\ BA",
"55313334", "Minas\ Gerais",
"55513685", "Capivari\ do\ Sul\ \-\ RS",
"55773417", "Guajeru\ \-\ BA",
"55833352", "São\ João\ do\ Tigre\ \-\ PB",
"55343816", "Lagoa\ Grande\ \-\ MG",
"55693523", "Theobroma\ \-\ RO",
"55443673", "Ivaté\ \-\ PR",
"55383534", "Diamantina\ \-\ MG",
"55753652", "Cairu\ \-\ BA",
"55414020", "Curitiba\ \-\ PR",
"55683244", "Rio\ Branco\ \-\ AC",
"55873201", "Petrolina\ \-\ PE",
"55883569", "Deputado\ Irapuan\ Pinheiro\ \-\ CE",
"55663539", "Novo\ Mundo\ \-\ MT",
"55773472", "Maetinga\ \-\ BA",
"55115933", "São\ Paulo\ \-\ SP",
"55633365", "Fátima\ \-\ TO",
"55513945", "Gravataí\ \-\ RS",
"55473044", "Brusque\ \-\ SC",
"55473422", "Joinville\ \-\ SC",
"55843618", "Natal\ \-\ RN",
"55893543", "Antônio\ Almeida\ \-\ PI",
"55833253", "Bayeux\ \-\ PB",
"55633394", "Sandolândia\ \-\ TO",
"55112312", "Mogi\ das\ Cruzes\ \-\ SP",
"55543398", "Charrua\ \-\ RS",
"55643489", "Água\ Limpa\ \-\ GO",
"55643480", "Edealina\ \-\ GO",
"55193481", "São\ Pedro\ \-\ SP",
"55753609", "Bravo\ \-\ BA",
"55833464", "Junco\ do\ Seridó\ \-\ PB",
"55813691", "Panelas\ \-\ PE",
"55473467", "Joinville\ \-\ SC",
"55193929", "Valinhos\ \-\ SP",
"55493241", "Curitibanos\ \-\ SC",
"55413636", "Balsa\ Nova\ \-\ PR",
"55433551", "Ribeirão\ do\ Pinhal\ \-\ PR",
"55693459", "Ji\-Paraná\ \-\ RO",
"55973415", "Benjamin\ Constant\ \-\ AM",
"5515341", "Sorocaba\ \-\ SP",
"55383613", "Itacarambi\ \-\ MG",
"55143451", "Marília\ \-\ SP",
"55833309", "São\ José\ dos\ Cordeiros\ \-\ PB",
"55713164", "Salvador\ \-\ BA",
"55613608", "Novo\ Gama\ \-\ GO",
"55513123", "Porto\ Alegre\ \-\ RS",
"55813351", "Recife\ \-\ PE",
"55533015", "Pelotas\ \-\ RS",
"55694003", "Porto\ Velho\ \-\ RO",
"55193377", "Piracicaba\ \-\ SP",
"55273744", "Governador\ Lindenberg\ \-\ ES",
"55213634", "Rio\ Bonito\ \-\ RJ",
"55543355", "Ibiraiaras\ \-\ RS",
"55323291", "Santa\ Rita\ de\ Jacutinga\ \-\ MG",
"55153562", "Itaberá\ \-\ SP",
"55543052", "Bento\ Gonçalves\ \-\ RS",
"55793198", "Aracaju\ \-\ SE",
"55483464", "Lauro\ Muller\ \-\ SC",
"55222542", "Nova\ Friburgo\ \-\ RJ",
"55343424", "Itapagipe\ \-\ MG",
"55612099", "Brasília\ \-\ DF",
"55533312", "Bagé\ \-\ RS",
"55863284", "Barro\ Duro\ \-\ PI",
"55193312", "Indaiatuba\ \-\ SP",
"55493592", "Tangará\ \-\ SC",
"55633654", "Taguatinga\ \-\ TO",
"55423311", "Ponta\ Grossa\ \-\ PR",
"55543347", "Casca\ \-\ RS",
"55733274", "Vera\ Cruz\ \-\ BA",
"55813972", "Recife\ \-\ PE",
"55483253", "Paulo\ Lopes\ \-\ SC",
"55863219", "Teresina\ \-\ PI",
"55442102", "Maringá\ \-\ PR",
"55653102", "Nobres\ \-\ MT",
"55433906", "Rolândia\ \-\ PR",
"55433224", "Santo\ Antônio\ do\ Paraíso\ \-\ PR",
"55543340", "Vanini\ \-\ RS",
"55743542", "Senhor\ do\ Bonfim\ \-\ BA",
"5511435", "São\ Bernardo\ do\ Campo\ \-\ SP",
"55333084", "Governador\ Valadares\ \-\ MG",
"55183656", "Jatobá\ \-\ SP",
"55863582", "São\ Raimundo\ Nonato\ \-\ PI",
"55813644", "Cumaru\ \-\ PE",
"55114109", "São\ Bernardo\ do\ Campo\ \-\ SP",
"55793215", "Aracaju\ \-\ SE",
"55693642", "São\ Miguel\ do\ Guaporé\ \-\ RO",
"55414001", "Curitiba\ \-\ PR",
"55115787", "São\ Paulo\ \-\ SP",
"55353564", "Conceição\ da\ Aparecida\ \-\ MG",
"55923664", "Manaus\ \-\ AM",
"55343359", "Uberaba\ \-\ MG",
"55143106", "Bauru\ \-\ SP",
"55543349", "São\ Domingos\ do\ Sul\ \-\ RS",
"55153264", "Águia\ da\ Castelo\ \-\ SP",
"55183701", "Mirandópolis\ \-\ SP",
"55733282", "Santa\ Cruz\ Cabrália\ \-\ BA",
"55423631", "Guarapuava\ \-\ PR",
"55112806", "Diadema\ \-\ SP",
"55212136", "Rio\ de\ Janeiro\ \-\ RJ",
"55963622", "Vitória\ do\ Jari\ \-\ AP",
"55983485", "Água\ Doce\ do\ Maranhão\ \-\ MA",
"55513902", "Santa\ Cruz\ do\ Sul\ \-\ RS",
"55833307", "Caraúbas\ \-\ PB",
"55193806", "Mogi\ Mirim\ \-\ SP",
"55123003", "São\ José\ dos\ Campos\ \-\ SP",
"55193927", "Piracicaba\ \-\ SP",
"55983011", "São\ Luís\ \-\ MA",
"55223864", "Aperibé\ \-\ RJ",
"55154009", "Sorocaba\ \-\ SP",
"55113596", "São\ Paulo\ \-\ SP",
"55414062", "Curitiba\ \-\ PR",
"55343690", "Araguari\ \-\ MG",
"55454101", "Cascavel\ \-\ PR",
"55623534", "Goiânia\ \-\ GO",
"55624015", "Anápolis\ \-\ GO",
"55443237", "Santa\ Zélia\ \-\ PR",
"55693445", "São\ Felipe\ do\ Oeste\ \-\ RO",
"5531359", "Betim\ \-\ MG",
"55313533", "Ibirité\ \-\ MG",
"55883522", "Jaguaribe\ \-\ CE",
"55913724", "Benevides\ \-\ PA",
"5548", "Santa\ Catarina",
"55183839", "Jamaica\ \-\ SP",
"55143586", "Guarantã\ \-\ SP",
"55153258", "Guareí\ \-\ SP",
"55222623", "Armação\ dos\ Búzios\ \-\ RJ",
"55114882", "Carapicuíba\ \-\ SP",
"55932101", "Santarém\ \-\ PA",
"55483321", "Florianópolis\ \-\ SC",
"55663537", "Nova\ Maringá\ \-\ MT",
"55513631", "Escadinhas\ \-\ RS",
"55843635", "Santa\ Maria\ \-\ RN",
"55773484", "Santana\ \-\ BA",
"55893425", "Sussuapara\ \-\ PI",
"55383232", "Cristália\ \-\ MG",
"55613045", "Brasília\ \-\ DF",
"55683542", "Xapuri\ \-\ AC",
"55193556", "Cordeirópolis\ \-\ SP",
"55883567", "Ipaumirim\ \-\ CE",
"55143276", "Bauru\ \-\ SP",
"55843338", "Carnaubais\ \-\ RN",
"55313763", "Conselheiro\ Lafaiete\ \-\ MG",
"55513959", "Sapiranga\ \-\ RS",
"55112883", "Mogi\ das\ Cruzes\ \-\ SP",
"55353558", "São\ Sebastião\ do\ Paraíso\ \-\ MG",
"55553548", "Cândido\ Godói\ \-\ RS",
"55613624", "Valparaíso\ de\ Goiás\ \-\ GO",
"55673240", "Aquidauana\ \-\ MS",
"55212680", "Mangaratiba\ \-\ RJ",
"55113438", "Santo\ André\ \-\ SP",
"55353229", "Varginha\ \-\ MG",
"55353734", "Santa\ Rita\ de\ Caldas\ \-\ MG",
"55433567", "Sengés\ \-\ PR",
"55193883", "Sumaré\ \-\ SP",
"55212689", "Porto\ Belo\ \-\ RJ",
"55933515", "Altamira\ \-\ PA",
"55993582", "Imperatriz\ \-\ MA",
"55833321", "Campina\ Grande\ \-\ PB",
"55753449", "Conde\ \-\ BA",
"55823289", "Santana\ do\ Mundaú\ \-\ AL",
"55513474", "Sapucaia\ do\ Sul\ \-\ RS",
"55212763", "Nova\ Iguaçu\ \-\ RJ",
"55753621", "Cruz\ das\ Almas\ \-\ BA",
"5583", "Paraiba",
"55823280", "Pindoba\ \-\ AL",
"55483049", "São\ José\ \-\ SC",
"55423902", "Guarapuava\ \-\ PR",
"55843432", "Campo\ Redondo\ \-\ RN",
"55313893", "Porto\ Firme\ \-\ MG",
"55323754", "São\ Francisco\ do\ Glória\ \-\ MG",
"55133494", "Praia\ Grande\ \-\ SP",
"55733552", "Córrego\ de\ Pedras\ \-\ BA",
"55333340", "Governador\ Valadares\ \-\ MG",
"55513065", "Novo\ Hamburgo\ \-\ RS",
"55843061", "Mossoró\ \-\ RN",
"55143389", "Timburi\ \-\ SP",
"55913781", "Cametá\ \-\ PA",
"55123147", "Queluz\ \-\ SP",
"55453543", "Vila\ Ipiranga\ \-\ PR",
"55513362", "Rio\ Grande\ do\ Sul",
"55313067", "Itabira\ \-\ MG",
"55823423", "Igaci\ \-\ AL",
"55433158", "Ibiporã\ \-\ PR",
"55163704", "Franca\ \-\ SP",
"55863252", "Campo\ Maior\ \-\ PI",
"55963014", "Macapá\ \-\ AP",
"55312106", "Sete\ Lagoas\ \-\ MG",
"55843608", "Natal\ \-\ RN",
"55873835", "Pesqueira\ \-\ PE",
"55643691", "Vicentinópolis\ \-\ GO",
"55513468", "Rio\ Grande\ do\ Sul",
"55433235", "Primeiro\ de\ Maio\ \-\ PR",
"55283528", "Vargem\ Alta\ \-\ ES",
"55112350", "Poá\ \-\ SP",
"55114202", "Carapicuíba\ \-\ SP",
"55693412", "Alvorada\ do\ Oeste\ \-\ RO",
"55623248", "Aparecida\ de\ Goiânia\ \-\ GO",
"55323538", "Presidente\ Bernardes\ \-\ MG",
"55113602", "Osasco\ \-\ SP",
"55493537", "Treze\ Tílias\ \-\ SC",
"5516362", "Ribeirão\ Preto\ \-\ SP",
"55333021", "Governador\ Valadares\ \-\ MG",
"5511562", "São\ Paulo\ \-\ SP",
"5511274", "São\ Paulo\ \-\ SP",
"55753684", "Ichu\ \-\ BA",
"55433033", "Apucarana\ \-\ PR",
"55613618", "Águas\ Lindas\ de\ Goiás\ \-\ GO",
"55173292", "Paulo\ de\ Faria\ \-\ SP",
"55113659", "Osasco\ \-\ SP",
"55353835", "Cristais\ \-\ MG",
"55473387", "Pomerode\ \-\ SC",
"55193408", "Americana\ \-\ SP",
"55543546", "Faxinalzinho\ \-\ RS",
"55833384", "Pocinhos\ \-\ PB",
"55833310", "Campina\ Grande\ \-\ PB",
"55243332", "Rio\ Claro\ \-\ RJ",
"55153511", "Itapetininga\ \-\ SP",
"55383841", "Salinas\ \-\ MG",
"55153278", "Pilar\ do\ Sul\ \-\ SP",
"55853336", "Horizonte\ \-\ CE",
"55353211", "Passos\ \-\ MG",
"5553327", "Pelotas\ \-\ RS",
"55643404", "Itumbiara\ \-\ GO",
"55753337", "Utinga\ \-\ BA",
"55193361", "Mogi\-Guaçu\ \-\ SP",
"55613012", "Brasília\ \-\ DF",
"55163838", "Ituverava\ \-\ SP",
"55193576", "Ipeúna\ \-\ SP",
"55553234", "Vila\ Nova\ do\ Sul\ \-\ RS",
"55493446", "Lindóia\ do\ Sul\ \-\ SC",
"55473634", "São\ Bento\ do\ Sul\ \-\ SC",
"55115704", "Itupeva\ \-\ SP",
"55313628", "Ribeirão\ das\ Neves\ \-\ MG",
"55473471", "São\ Francisco\ do\ Sul\ \-\ SC",
"55793343", "Pacatuba\ \-\ SE",
"55933542", "Jacareacanga\ \-\ PA",
"5511258", "São\ Paulo\ \-\ SP",
"55213746", "Mesquita\ \-\ RJ",
"55114528", "Cabreúva\ \-\ SP",
"55423301", "Ponta\ Grossa\ \-\ PR",
"55513263", "Rio\ Grande\ do\ Sul",
"55152105", "Sorocaba\ \-\ SP",
"55193302", "Piracicaba\ \-\ SP",
"55312586", "Contagem\ \-\ MG",
"55222768", "Quissamã\ \-\ RJ",
"55653221", "Cáceres\ \-\ MT",
"55313325", "Minas\ Gerais",
"55113399", "São\ Paulo\ \-\ SP",
"55373241", "Itaúna\ \-\ MG",
"55682101", "Rio\ Branco\ \-\ AC",
"55413584", "Curitiba\ \-\ PR",
"55133843", "Ilha\ Comprida\ \-\ SP",
"55513454", "Esteio\ \-\ RS",
"55313444", "Belo\ Horizonte\ \-\ MG",
"55383525", "Senador\ Modestino\ Gonçalves\ \-\ MG",
"55443565", "Tuneiras\ do\ Oeste\ \-\ PR",
"55413282", "São\ José\ dos\ Pinhais\ \-\ PR",
"55663592", "Brasnorte\ \-\ MT",
"55474141", "Itajaí\ \-\ SC",
"55613432", "Formosa\ \-\ GO",
"55273268", "Domingos\ Martins\ \-\ ES",
"55114775", "Itapecerica\ da\ Serra\ \-\ SP",
"55813736", "São\ Caetano\ \-\ PE",
"55343213", "Uberlândia\ \-\ MG",
"55623946", "Goiânia\ \-\ GO",
"55413517", "São\ José\ dos\ Pinhais\ \-\ PR",
"55483372", "São\ José\ \-\ SC",
"55753475", "Porto\ de\ Sauipe\ \-\ BA",
"55183788", "Murutinga\ do\ Sul\ \-\ SP",
"55793205", "Aracaju\ \-\ SE",
"55823557", "Piaçabuçu\ \-\ AL",
"55213304", "Belford\ Roxo\ \-\ RJ",
"55993554", "Paraibano\ \-\ MA",
"55113442", "São\ Paulo\ \-\ SP",
"55773647", "Ibitiara\ \-\ BA",
"55163728", "São\ Joaquim\ da\ Barra\ \-\ SP",
"55613338", "Brasília\ \-\ DF",
"55313491", "Minas\ Gerais",
"55753330", "Boninal\ \-\ BA",
"55883413", "Fortim\ \-\ CE",
"55923019", "Manaus\ \-\ AM",
"55443653", "Tuneiras\ do\ Oeste\ \-\ PR",
"55833639", "Riachão\ \-\ PB",
"55923084", "Manaus\ \-\ AM",
"55733268", "Porto\ Seguro\ \-\ BA",
"55833372", "Cuité\ \-\ PB",
"55773698", "Ibotirama\ \-\ BA",
"55753339", "Souto\ Soares\ \-\ BA",
"55513041", "Cachoeirinha\ \-\ RS",
"55672108", "Dourados\ \-\ MS",
"55993221", "Imperatriz\ \-\ MA",
"55453028", "Foz\ do\ Iguaçu\ \-\ PR",
"55483478", "Criciúma\ \-\ SC",
"55123013", "Guaratinguetá\ \-\ SP",
"55163231", "Guariba\ \-\ SP",
"55193816", "Indaiatuba\ \-\ SP",
"55833317", "Galante\ \-\ PB",
"55314", "Minas\ Gerais",
"55773452", "Guanambi\ \-\ BA",
"55653353", "Acorizal\ \-\ MT",
"55773409", "Iguatemi\ \-\ BA",
"55493539", "Iomerê\ \-\ SC",
"55983654", "Santa\ Luzia\ \-\ MA",
"55633431", "Angico\ \-\ TO",
"55843243", "Goianinha\ \-\ RN",
"55123666", "Santo\ Antônio\ do\ Pinhal\ \-\ SP",
"55873881", "Ipubi\ \-\ PE",
"55833273", "Alagoa\ Grande\ \-\ PB",
"55443541", "Moreira\ Sales\ \-\ PR",
"55114043", "Diadema\ \-\ SP",
"55273254", "Cariacica\ \-\ ES",
"55143471", "Garça\ \-\ SP",
"55543439", "Faria\ Lemos\ \-\ RS",
"55463523", "Francisco\ Beltrão\ \-\ PR",
"5541342", "Paranaguá\ \-\ PR",
"55433571", "Siqueira\ Campos\ \-\ PR",
"55423912", "São\ Mateus\ do\ Sul\ \-\ PR",
"55413383", "São\ José\ dos\ Pinhais\ \-\ PR",
"55333355", "Iapu\ \-\ MG",
"55322101", "Juiz\ de\ Fora\ \-\ MG",
"55883571", "Juazeiro\ do\ Norte\ \-\ CE",
"55193911", "Mogi\-Guaçu\ \-\ SP",
"55823204", "Chã\ Preta\ \-\ AL",
"55213978", "Rio\ de\ Janeiro\ \-\ RJ",
"55543375", "Erval\ Grande\ \-\ RS",
"55483583", "Balneário\ Gaivota\ \-\ SC",
"55163346", "Boa\ Esperança\ do\ Sul\ \-\ SP",
"55643644", "Aporé\ \-\ GO",
"55933505", "Aveiro\ \-\ PA",
"55983394", "Carutapera\ \-\ MA",
"55543017", "Veranópolis\ \-\ RS",
"55193042", "Piracicaba\ \-\ SP",
"55483273", "Major\ Gercino\ \-\ SC",
"55193345", "Campinas\ \-\ SP",
"55894101", "Picos\ \-\ PI",
"55733254", "Gandu\ \-\ BA",
"55793544", "Itabaianinha\ \-\ SE",
"55743538", "Sobradinho\ \-\ BA",
"55143387", "Sarutaiá\ \-\ SP",
"55343245", "Indianópolis\ \-\ MG",
"55423122", "Ponta\ Grossa\ \-\ PR",
"55623438", "São\ João\ D\'Aliança\ \-\ GO",
"55793635", "Lagarto\ \-\ SE",
"55193874", "Paulínia\ \-\ SP",
"55473376", "Jaraguá\ do\ Sul\ \-\ SC",
"55193798", "Campinas\ \-\ SP",
"55513483", "Alvorada\ \-\ RS",
"55953224", "Boa\ Vista\ \-\ RR",
"55343257", "Uberlândia\ \-\ MG",
"55733031", "Itamaraju\ \-\ BA",
"55222651", "Saquarema\ \-\ RJ",
"55834064", "Campina\ Grande\ \-\ PB",
"55883642", "Moraújo\ \-\ CE",
"55163662", "Batatais\ \-\ SP",
"55213512", "Rio\ de\ Janeiro\ \-\ RJ",
"55313165", "Santa\ Luzia\ \-\ MG",
"55833353", "Sumé\ \-\ PB",
"5521346", "Rio\ de\ Janeiro\ \-\ RJ",
"55843013", "Natal\ \-\ RN",
"55163601", "Ribeirão\ Preto\ \-\ SP",
"55743622", "Jacobina\ \-\ BA",
"55753653", "Cairu\ \-\ BA",
"55353301", "Poços\ de\ Caldas\ \-\ MG",
"55623332", "Silvânia\ \-\ GO",
"55653273", "Curvelândia\ \-\ MT",
"5551332", "Rio\ Grande\ do\ Sul",
"55443672", "Rondon\ \-\ PR",
"55453056", "Toledo\ \-\ PR",
"55813524", "Cabo\ de\ Santo\ Agostinho\ \-\ PE",
"55493341", "Jupiá\ \-\ SC",
"55115932", "São\ Paulo\ \-\ SP",
"55112277", "Bragança\ Paulista\ \-\ SP",
"55242257", "Areal\ \-\ RJ",
"55333745", "Joaíma\ \-\ MG",
"55773473", "Macaúbas\ \-\ BA",
"55273031", "Vila\ Velha\ \-\ ES",
"55793432", "Itabaiana\ \-\ SE",
"55833209", "João\ Pessoa\ \-\ PB",
"55193466", "Nova\ Odessa\ \-\ SP",
"55473423", "Joinville\ \-\ SC",
"55543712", "Erechim\ \-\ RS",
"55313234", "Minas\ Gerais",
"55373431", "Bambuí\ \-\ MG",
"55313720", "Minas\ Gerais",
"55923249", "Manaus\ \-\ AM",
"55613003", "Brasília\ \-\ DF",
"55893542", "Landri\ Sales\ \-\ PI",
"55813269", "Recife\ \-\ PE",
"55833252", "João\ Pessoa\ \-\ PB",
"55383677", "Unaí\ \-\ MG",
"55222783", "Italva\ \-\ RJ",
"55743667", "Piritiba\ \-\ BA",
"55313729", "Minas\ Gerais",
"55313837", "Barão\ de\ Cocais\ \-\ MG",
"553139", "Minas\ Gerais",
"55383081", "Montes\ Claros\ \-\ MG",
"55513288", "Rio\ Grande\ do\ Sul",
"55114312", "Mogi\ das\ Cruzes\ \-\ SP",
"55383612", "Montalvânia\ \-\ MG",
"55183334", "Presidente\ Prudente\ \-\ SP",
"55313194", "Belo\ Horizonte\ \-\ MG",
"55513406", "Rio\ Grande\ do\ Sul",
"55623596", "Aparecida\ de\ Goiânia\ \-\ GO",
"55114015", "Tuiuti\ \-\ SP",
"55353454", "Espírito\ Santo\ do\ Dourado\ \-\ MG",
"55943427", "Água\ Azul\ do\ Norte\ \-\ PA",
"55624109", "Goiânia\ \-\ GO",
"55493236", "Urupema\ \-\ SC",
"55873796", "Capoeiras\ \-\ PE",
"55183998", "João\ Ramalho\ \-\ SP",
"55683028", "Rio\ Branco\ \-\ AC",
"55153563", "Guapiara\ \-\ SP",
"55333626", "Santa\ Helena\ de\ Minas\ \-\ MG",
"55222543", "Nova\ Friburgo\ \-\ RJ",
"55114481", "Bragança\ Paulista\ \-\ SP",
"55353263", "Monsenhor\ Paulo\ \-\ MG",
"55442103", "Maringá\ \-\ PR",
"55823634", "Senador\ Rui\ Palmeira\ \-\ AL",
"55115068", "São\ Paulo\ \-\ SP",
"55473228", "Balneário\ Camboriú\ \-\ SC",
"55353327", "Carrancas\ \-\ MG",
"55483252", "São\ Bonifácio\ \-\ SC",
"55993637", "Joselândia\ \-\ MA",
"55813476", "Jaboatão\ dos\ Guararapes\ \-\ PE",
"55433523", "Cornélio\ Procópio\ \-\ PR",
"55993075", "Imperatriz\ \-\ MA",
"55993639", "São\ Mateus\ do\ Maranhão\ \-\ MA",
"55114806", "Jundiaí\ \-\ SP",
"55493668", "Flor\ do\ Sertão\ \-\ SC",
"55733573", "Prado\ \-\ BA",
"55713412", "Salvador\ \-\ BA",
"55513151", "Porto\ Alegre\ \-\ RS",
"55693643", "Alto\ Alegre\ dos\ Parecis\ \-\ RO",
"55733283", "Camacã\ \-\ BA",
"55732011", "Teixeira\ de\ Freitas\ \-\ BA",
"55613717", "Brasília\ \-\ DF",
"55863273", "Curralinhos\ \-\ PI",
"55173330", "Guaíra\ \-\ SP",
"55663431", "Guiratinga\ \-\ MT",
"55823314", "Maceió\ \-\ AL",
"55993317", "Timon\ \-\ MA",
"55613591", "Sobradinho\ \-\ DF",
"55493365", "Modelo\ \-\ SC",
"5511269", "São\ Paulo\ \-\ SP",
"55423646", "Pitanga\ \-\ PR",
"55452101", "Cascavel\ \-\ PR",
"55653319", "Cuiabá\ \-\ MT",
"55513725", "Cerro\ Branco\ \-\ RS",
"55222667", "Araruama\ \-\ RJ",
"55653384", "Porto\ Estrela\ \-\ MT",
"55983683", "Satubinha\ \-\ MA",
"55173475", "Meridiano\ \-\ SP",
"55343261", "Ituiutaba\ \-\ MG",
"55114038", "Campo\ Limpo\ Paulista\ \-\ SP",
"55473545", "Pouso\ Redondo\ \-\ SC",
"55843198", "Natal\ \-\ RN",
"55113192", "São\ Paulo\ \-\ SP",
"55283556", "São\ José\ do\ Calçado\ \-\ ES",
"55313839", "Itabira\ \-\ MG",
"55313727", "Capela\ Nova\ \-\ MG",
"55743669", "Várzea\ da\ Roça\ \-\ BA",
"55123608", "Taubaté\ \-\ SP",
"55313532", "Betim\ \-\ MG",
"55883523", "Crato\ \-\ CE",
"55143376", "Sodrélia\ \-\ SP",
"55923247", "Manaus\ \-\ AM",
"55313830", "Minas\ Gerais",
"55843238", "Parnamirim\ \-\ RN",
"55473557", "Imbuia\ \-\ SC",
"55383679", "Paracatu\ \-\ MG",
"55833554", "Nazarezinho\ \-\ PB",
"55433461", "Faxinal\ \-\ PR",
"55673021", "Dourados\ \-\ MS",
"55653637", "Cuiabá\ \-\ MT",
"55443619", "Cianorte\ \-\ PR",
"55473204", "São\ Francisco\ do\ Sul\ \-\ SC",
"55193749", "Campinas\ \-\ SP",
"55963244", "Macapá\ \-\ AP",
"55823256", "Flexeiras\ \-\ AL",
"551155", "São\ Paulo\ \-\ SP",
"55413665", "Pinhais\ \-\ PR",
"55913617", "Cotijuba\ \-\ PA",
"55222622", "Arraial\ do\ Cabo\ \-\ RJ",
"55443684", "Guaporema\ \-\ PR",
"55623612", "Goiânia\ \-\ GO",
"55242259", "Petrópolis\ \-\ RJ",
"55112279", "Guarulhos\ \-\ SP",
"55313396", "Minas\ Gerais",
"55143731", "Avaré\ \-\ SP",
"55323344", "Bias\ Fortes\ \-\ MG",
"55383233", "Francisco\ Sá\ \-\ MG",
"55493654", "São\ Bernardino\ \-\ SC",
"55273382", "Vitória\ \-\ ES",
"55733206", "Mucuri\ \-\ BA",
"55212656", "São\ João\ de\ Meriti\ \-\ RJ",
"55313762", "Conselheiro\ Lafaiete\ \-\ MG",
"55323425", "Santana\ de\ Cataguases\ \-\ MG",
"55193589", "Porto\ Ferreira\ \-\ SP",
"55112152", "Jundiaí\ \-\ SP",
"55193882", "Cosmópolis\ \-\ SP",
"55643581", "Itumbiara\ \-\ GO",
"55343259", "Uberlândia\ \-\ MG",
"55153364", "Boituva\ \-\ SP",
"55743651", "Capim\ Grosso\ \-\ BA",
"55122126", "Pindamonhangaba\ \-\ SP",
"55423903", "União\ da\ Vitória\ \-\ PR",
"55413462", "Morretes\ \-\ PR",
"55843433", "Acari\ \-\ RN",
"55483207", "Florianópolis\ \-\ SC",
"55333531", "Caraí\ \-\ MG",
"55313683", "Jaboticatubas\ \-\ MG",
"55453346", "São\ João\ d\'Oeste\ \-\ PR",
"55242252", "Três\ Rios\ \-\ RJ",
"55734141", "Itabuna\ \-\ BA",
"5553330", "Pelotas\ \-\ RS",
"55153461", "Porto\ Feliz\ \-\ SP",
"55312128", "Belo\ Horizonte\ \-\ MG",
"55993556", "Mirador\ \-\ MA",
"55543717", "Nova\ Prata\ \-\ RS",
"55813734", "Vertentes\ \-\ PE",
"55443018", "Cianorte\ \-\ PR",
"55893436", "Alegrete\ do\ Piauí\ \-\ PI",
"55114273", "Caieiras\ \-\ SP",
"55474001", "Joinville\ \-\ SC",
"55493491", "Seara\ \-\ SC",
"55773413", "Cascavel\ \-\ BA",
"55313769", "Conselheiro\ Lafaiete\ \-\ MG",
"55132101", "Santos\ \-\ SP",
"55743627", "Miguel\ Calmon\ \-\ BA",
"55312572", "Betim\ \-\ MG",
"55313760", "Minas\ Gerais",
"55443677", "Tapejara\ \-\ PR",
"55273314", "Vitória\ \-\ ES",
"55112814", "Itaquaquecetuba\ \-\ SP",
"55382103", "Montes\ Claros\ \-\ MG",
"55673243", "Dois\ Irmãos\ do\ Buriti\ \-\ MS",
"55212683", "Paracambi\ \-\ RJ",
"55193889", "Monte\ Mor\ \-\ SP",
"55543242", "Nova\ Prata\ \-\ RS",
"55343252", "Ipiaçu\ \-\ MG",
"55883647", "Groaíras\ \-\ CE",
"55353223", "Varginha\ \-\ MG",
"55323441", "Leopoldina\ \-\ MG",
"55474062", "Joinville\ \-\ SC",
"55193814", "Mogi\ Mirim\ \-\ SP",
"55163667", "Cajuru\ \-\ SP",
"55333215", "Governador\ Valadares\ \-\ MG",
"55193582", "Santa\ Rita\ do\ Passa\ Quatro\ \-\ SP",
"55433452", "Borrazópolis\ \-\ PR",
"55423271", "Telêmaco\ Borba\ \-\ PR",
"55153523", "Caputera\ \-\ SP",
"55553365", "Roque\ Gonzales\ \-\ RS",
"55483043", "Tubarão\ \-\ SC",
"55212769", "Nova\ Iguaçu\ \-\ RJ",
"55212760", "Rio\ das\ Ostras\ \-\ RJ",
"55513101", "Alvorada\ \-\ RS",
"55883655", "Frecheirinha\ \-\ CE",
"55143552", "Getulina\ \-\ SP",
"55823283", "Viçosa\ \-\ AL",
"55753443", "Crisópolis\ \-\ BA",
"55543343", "Sananduva\ \-\ RS",
"55343353", "Conquista\ \-\ MG",
"55273256", "Aracruz\ \-\ ES",
"55114103", "São\ Bernardo\ do\ Campo\ \-\ SP",
"55413978", "Antonina\ \-\ PR",
"55483257", "São\ José\ \-\ SC",
"55993632", "Lago\ dos\ Rodrigues\ \-\ MA",
"55153459", "Iperó\ \-\ SP",
"55353322", "Seritinga\ \-\ MG",
"55553027", "Santa\ Maria\ \-\ RS",
"55193373", "Piracicaba\ \-\ SP",
"55513741", "Venâncio\ Aires\ \-\ RS",
"55123664", "Campos\ do\ Jordão\ \-\ SP",
"55943422", "Piçarras\ \-\ PA",
"55313751", "Entre\ Rios\ de\ Minas\ \-\ MG",
"55517", "Rio\ Grande\ do\ Sul",
"55453231", "Santa\ Tereza\ do\ Oeste\ \-\ PR",
"55694007", "Porto\ Velho\ \-\ RO",
"55983656", "Governador\ Newton\ Bello\ \-\ MA",
"55473521", "Rio\ do\ Sul\ \-\ SC",
"55173332", "Guaíra\ \-\ SP",
"55483245", "Santo\ Amaro\ da\ Imperatriz\ \-\ SC",
"55183942", "Gardênia\ \-\ SP",
"55114317", "São\ Bernardo\ do\ Campo\ \-\ SP",
"55673448", "Deodápolis\ \-\ MS",
"55983396", "Cândido\ Mendes\ \-\ MA",
"55893555", "Arraial\ \-\ PI",
"55513127", "Gravataí\ \-\ RS",
"55843275", "Vera\ Cruz\ \-\ RN",
"55793546", "Umbaúba\ \-\ SE",
"55733256", "Ituberá\ \-\ BA",
"55954009", "Boa\ Vista\ \-\ RR",
"55513271", "Novo\ Hamburgo\ \-\ RS",
"55653312", "Santo\ Afonso\ \-\ MT",
"55212751", "São\ João\ de\ Meriti\ \-\ RJ",
"55313539", "Betim\ \-\ MG",
"55353644", "Piranguinho\ \-\ MG",
"55513581", "Novo\ Hamburgo\ \-\ RS",
"55883409", "Russas\ \-\ CE",
"55893547", "São\ Miguel\ do\ Fidalgo\ \-\ PI",
"55383672", "Paracatu\ \-\ MG",
"55943328", "Núcleo\ Carajás\ \-\ PA",
"55833257", "Mata\ Redonda\ \-\ PB",
"55163344", "Ribeirão\ Bonito\ \-\ SP",
"55753248", "Coração\ de\ Maria\ \-\ BA",
"55883400", "Limoeiro\ do\ Norte\ \-\ CE",
"55114639", "Poá\ \-\ SP",
"5579324", "Aracaju\ \-\ SE",
"5521342", "Rio\ de\ Janeiro\ \-\ RJ",
"55313530", "Betim\ \-\ MG",
"55743662", "Barra\ \-\ BA",
"55313832", "Santa\ Bárbara\ \-\ MG",
"55313722", "Queluzito\ \-\ MG",
"55323465", "Pirapetinga\ \-\ MG",
"55163706", "Franca\ \-\ SP",
"55223094", "Campos\ dos\ Goytacazes\ \-\ RJ",
"55313537", "Serra\ Azul\ \-\ MG",
"55713378", "Lauro\ de\ Freitas\ \-\ BA",
"55833259", "Pitimbu\ \-\ PB",
"55443233", "Mandaguari\ \-\ PR",
"55893549", "Alvorada\ do\ Gurguéia\ \-\ PI",
"55413625", "Contenda\ \-\ PR",
"55143268", "Macatuba\ \-\ SP",
"55222662", "Arraial\ do\ Cabo\ \-\ RJ",
"55333433", "São\ José\ do\ Jacuri\ \-\ MG",
"55843531", "Angicos\ \-\ RN",
"55193705", "Campinas\ \-\ SP",
"55143316", "Marília\ \-\ SP",
"55753603", "Feira\ de\ Santana\ \-\ BA",
"55993015", "Imperatriz\ \-\ MA",
"55212722", "Niterói\ \-\ RJ",
"55713472", "Salvador\ \-\ BA",
"55153324", "Tatuí\ \-\ SP",
"55353691", "Três\ Corações\ \-\ MG",
"55112705", "São\ Paulo\ \-\ SP",
"55914107", "Ananindeua\ \-\ PA",
"55694009", "Porto\ Velho\ \-\ RO",
"55112923", "Jundiaí\ \-\ SP",
"55483303", "Florianópolis\ \-\ SC",
"55673499", "Vila\ Nova\ Casa\ Verde\ \-\ MS",
"55813201", "Recife\ \-\ PE",
"55483259", "São\ José\ \-\ SC",
"55653927", "Várzea\ Grande\ \-\ MT",
"55613298", "Brasília\ \-\ DF",
"55373334", "Piracema\ \-\ MG",
"55453285", "Subsede\ São\ Francisco\ \-\ PR",
"55373071", "Divinópolis\ \-\ MG",
"55713417", "Salvador\ \-\ BA",
"55333721", "Almenara\ \-\ MG",
"55213274", "Rio\ de\ Janeiro\ \-\ RJ",
"55493325", "São\ Carlos\ \-\ SC",
"55833261", "Belém\ \-\ PB",
"55483202", "Florianópolis\ \-\ SC",
"55533284", "Pelotas\ \-\ RS",
"55493444", "Concórdia\ \-\ SC",
"55553236", "Formigueiro\ \-\ RS",
"55443438", "São\ Carlos\ do\ Ivaí\ \-\ PR",
"55212767", "Nova\ Iguaçu\ \-\ RJ",
"55123021", "São\ José\ dos\ Campos\ \-\ SP",
"55184104", "Birigui\ \-\ SP",
"55242221", "Petrópolis\ \-\ RJ",
"55883649", "Meruoca\ \-\ CE",
"55283310", "Castelo\ \-\ ES",
"55733634", "Ilhéus\ \-\ BA",
"55163669", "Cássia\ dos\ Coqueiros\ \-\ SP",
"55853334", "Cascavel\ \-\ CE",
"55333238", "São\ Geraldo\ da\ Piedade\ \-\ MG",
"55213584", "Nova\ Iguaçu\ \-\ RJ",
"55163660", "Batatais\ \-\ SP",
"55433563", "Tomazina\ \-\ PR",
"55193887", "Hortolândia\ \-\ SP",
"55883421", "Aracati\ \-\ CE",
"55883640", "Alcântaras\ \-\ CE",
"55543544", "Entre\ Rios\ do\ Sul\ \-\ RS",
"55833386", "Gurjão\ \-\ PB",
"55143845", "Conchas\ \-\ SP",
"55883563", "Icó\ \-\ CE",
"55163146", "Itirapuã\ \-\ SP",
"55743620", "São\ Gabriel\ \-\ BA",
"55443679", "Tapira\ \-\ PR",
"55653901", "Cuiabá\ \-\ MT",
"55112284", "Osasco\ \-\ SP",
"55443332", "Itaguajé\ \-\ PR",
"55813363", "Jaboatão\ dos\ Guararapes\ \-\ PE",
"55112887", "Itaquaquecetuba\ \-\ SP",
"55743629", "Barro\ Alto\ \-\ BA",
"55313446", "Belo\ Horizonte\ \-\ MG",
"55413586", "São\ José\ dos\ Pinhais\ \-\ PR",
"55313767", "Minas\ Gerais",
"55513456", "Canoas\ \-\ RS",
"55343221", "Uberlândia\ \-\ MG",
"55613053", "Brasília\ \-\ DF",
"55183723", "Andradina\ \-\ SP",
"55663533", "Sinop\ \-\ MT",
"55983194", "São\ Luís\ \-\ MA",
"55513765", "Lagoão\ \-\ RS",
"55222627", "São\ Pedro\ da\ Aldeia\ \-\ RJ",
"55823268", "Santa\ Luzia\ do\ Norte\ \-\ AL",
"55423025", "Ponta\ Grossa\ \-\ PR",
"55113607", "Osasco\ \-\ SP",
"55773402", "Vitória\ da\ Conquista\ \-\ BA",
"55493532", "Tangará\ \-\ SC",
"55323728", "Muriaé\ \-\ MG",
"55193321", "Araras\ \-\ SP",
"55714009", "Salvador\ \-\ BA",
"55533321", "Pelotas\ \-\ RS",
"55623541", "Goiânia\ \-\ GO",
"55813474", "Jaboatão\ dos\ Guararapes\ \-\ PE",
"55212668", "Nova\ Iguaçu\ \-\ RJ",
"55612030", "Brasília\ \-\ DF",
"5511566", "São\ Paulo\ \-\ SP",
"5553", "Rio\ Grande\ do\ Sul",
"55793712", "Aracaju\ \-\ SE",
"55673433", "Ponta\ Porã\ \-\ MS",
"55213694", "Maricá\ \-\ RJ",
"55713453", "Salvador\ \-\ BA",
"55793255", "Aracaju\ \-\ SE",
"55283554", "Muqui\ \-\ ES",
"55443525", "Campo\ Mourão\ \-\ PR",
"55653261", "Araputanga\ \-\ MT",
"55833556", "São\ Gonçalo\ \-\ PB",
"55813631", "Timbaúba\ \-\ PE",
"55143374", "Caporanga\ \-\ SP",
"55713264", "Salvador\ \-\ BA",
"55163993", "Ribeirão\ Preto\ \-\ SP",
"55773461", "Bom\ Jesus\ da\ Serra\ \-\ BA",
"55423644", "Santa\ Maria\ do\ Oeste\ \-\ PR",
"55543338", "Victor\ Graeff\ \-\ RS",
"55183265", "Rancharia\ \-\ SP",
"55343637", "Pratinha\ \-\ MG",
"55863245", "Nossa\ Senhora\ dos\ Remédios\ \-\ PI",
"55663023", "Rondonópolis\ \-\ MT",
"55112321", "São\ Paulo\ \-\ SP",
"55653386", "São\ José\ do\ Rio\ Claro\ \-\ MT",
"55173248", "Mendonça\ \-\ SP",
"55753438", "São\ Félix\ \-\ BA",
"55323346", "Antônio\ Carlos\ \-\ MG",
"55473411", "Rio\ do\ Sul\ \-\ SC",
"55913443", "Irituia\ \-\ PA",
"55663599", "Guariba\ \-\ MT",
"55353741", "Botelhos\ \-\ MG",
"55553751", "Dois\ Irmãos\ das\ MissõEs\ \-\ RS",
"55114177", "São\ Bernardo\ do\ Campo\ \-\ SP",
"55733204", "Itaju\ do\ Colônia\ \-\ BA",
"55162101", "Ribeirão\ Preto\ \-\ SP",
"55112516", "São\ Paulo\ \-\ SP",
"55493656", "Saltinho\ \-\ SC",
"55823254", "São\ Luís\ do\ Quitunde\ \-\ AL",
"55143813", "Botucatu\ \-\ SP",
"55413579", "Curitiba\ \-\ PR",
"55623393", "Bonópolis\ \-\ GO",
"55114738", "Mogi\ das\ Cruzes\ \-\ SP",
"55113449", "Osasco\ \-\ SP",
"55933547", "Óbidos\ \-\ PA",
"55483632", "Tubarão\ \-\ SC",
"55313394", "Belo\ Horizonte\ \-\ MG",
"55673238", "Ribas\ do\ Rio\ Pardo\ \-\ MS",
"55443686", "Palotina\ \-\ PR",
"55833435", "Jericó\ \-\ PB",
"55473488", "Blumenau\ \-\ SC",
"55193307", "Campinas\ \-\ SP",
"55833379", "Cacimba\ de\ Dentro\ \-\ PB",
"55933598", "Jamanchizinho\ \-\ PA",
"55122124", "Lorena\ \-\ SP",
"55483435", "Siderópolis\ \-\ SC",
"55753332", "Palmeiras\ \-\ BA",
"55553539", "Independência\ \-\ RS",
"55163515", "Ribeirão\ Preto\ \-\ SP",
"55153571", "Riversul\ \-\ SP",
"55213665", "Queimados\ \-\ RJ",
"55923681", "Manaus\ \-\ AM",
"55923012", "Manaus\ \-\ AM",
"55833370", "Caiçara\ \-\ PB",
"55653259", "Vila\ Bela\ da\ Santíssima\ Trindade\ \-\ MT",
"55513428", "Rio\ Grande\ do\ Sul",
"55153281", "Araçoiaba\ da\ Serra\ \-\ SP",
"55353271", "Lambari\ \-\ MG",
"55773459", "Tanhaçu\ \-\ BA",
"55773450", "Barra\ da\ Estiva\ \-\ BA",
"55473382", "Timbó\ \-\ SC",
"55212394", "Rio\ de\ Janeiro\ \-\ RJ",
"55823521", "Arapiraca\ \-\ AL",
"55193516", "Campinas\ \-\ SP",
"55833015", "João\ Pessoa\ \-\ PB",
"55463563", "Santo\ Antônio\ do\ Sudoeste\ \-\ PR",
"55353535", "São\ Tomás\ de\ Aquino\ \-\ MG",
"55753612", "Feira\ de\ Santana\ \-\ BA",
"5521387", "Rio\ de\ Janeiro\ \-\ RJ",
"55843355", "Venha\-Ver\ \-\ RN",
"55383541", "Serro\ \-\ MG",
"55982106", "São\ Luís\ \-\ MA",
"55773457", "Riacho\ de\ Santana\ \-\ BA",
"55113652", "Osasco\ \-\ SP",
"55343856", "Arapuá\ \-\ MG",
"55683231", "Bujari\ \-\ AC",
"55733561", "Ubaitaba\ \-\ BA",
"55373225", "Nova\ Serrana\ \-\ MG",
"55553537", "Horizontina\ \-\ RS",
"55993117", "Timon\ \-\ MA",
"55173525", "Catanduva\ \-\ SP",
"55753677", "Valença\ \-\ BA",
"55323083", "Juiz\ de\ Fora\ \-\ MG",
"55653257", "Rio\ Branco\ \-\ MT",
"55833377", "Dona\ Inês\ \-\ PB",
"55473374", "Schroeder\ \-\ SC",
"55473031", "Joinville\ \-\ SC",
"55193876", "Vinhedo\ \-\ SP",
"55773445", "Condeúba\ \-\ BA",
"55313915", "Belo\ Horizonte\ \-\ MG",
"55613010", "Brasília\ \-\ DF",
"55613084", "Luziânia\ \-\ GO",
"55914005", "Belém\ \-\ PA",
"55333243", "Central\ de\ Minas\ \-\ MG",
"55843398", "Serrinha\ dos\ Pintos\ \-\ RN",
"55223835", "Carabuçu\ \-\ RJ",
"55114715", "Alumínio\ \-\ SP",
"55173841", "Arabá\ \-\ SP",
"55713118", "Salvador\ \-\ BA",
"55823552", "Piaçabuçu\ \-\ AL",
"55143283", "Pederneiras\ \-\ SP",
"55123105", "Aparecida\ \-\ SP",
"55113447", "Osasco\ \-\ SP",
"55193464", "Santa\ Bárbara\ D\'Oeste\ \-\ SP",
"55112876", "Carapicuíba\ \-\ SP",
"55773642", "Oliveira\ dos\ Brejinhos\ \-\ BA",
"5581322", "Recife\ \-\ PE",
"55933549", "Porto\ Trombetas\ \-\ PA",
"55663597", "Nova\ Monte\ Verde\ \-\ MT",
"55513691", "Rio\ Grande\ do\ Sul",
"55833481", "Água\ Branca\ \-\ PB",
"55213553", "Rio\ de\ Janeiro\ \-\ RJ",
"55313029", "Belo\ Horizonte\ \-\ MG",
"55223211", "Campos\ dos\ Goytacazes\ \-\ RJ",
"55443443", "Santo\ Antônio\ do\ Caiuá\ \-\ PR",
"55673666", "Chapadão\ do\ Sul\ \-\ MS",
"55843695", "Lagoa\ de\ Velhos\ \-\ RN",
"55453054", "Toledo\ \-\ PR",
"55383825", "Montezuma\ \-\ MG",
"55813526", "Vitória\ de\ Santo\ Antão\ \-\ PE",
"55314114", "Conselheiro\ Lafaiete\ \-\ MG",
"55623565", "Goiânia\ \-\ GO",
"55433473", "Lidianópolis\ \-\ PR",
"55613703", "Brasília\ \-\ DF",
"55113392", "São\ Paulo\ \-\ SP",
"55883511", "Juazeiro\ do\ Norte\ \-\ CE",
"55843664", "Natal\ \-\ RN",
"55213803", "Niterói\ \-\ RJ",
"55813685", "Quipapá\ \-\ PE",
"5561324", "Brasília\ \-\ DF",
"55333342", "Durandé\ \-\ MG",
"55813311", "Ipojuca\ \-\ PE",
"55513404", "Rio\ Grande\ do\ Sul",
"55113133", "São\ Paulo\ \-\ SP",
"55623594", "Aparecida\ de\ Goiânia\ \-\ GO",
"55143382", "Fartura\ \-\ SP",
"55114693", "Guararema\ \-\ SP",
"55863303", "Teresina\ \-\ PI",
"55193055", "Pirassununga\ \-\ SP",
"55863259", "Lagoa\ do\ Piauí\ \-\ PI",
"55652137", "Várzea\ Grande\ \-\ MT",
"55313236", "Belo\ Horizonte\ \-\ MG",
"55273182", "Vitória\ \-\ ES",
"55863250", "Prata\ do\ Piauí\ \-\ PI",
"55543618", "Nonoai\ \-\ RS",
"55242103", "Petrópolis\ \-\ RJ",
"55193352", "Araras\ \-\ SP",
"55193495", "Limeira\ \-\ SP",
"55983325", "Maranhãozinho\ \-\ MA",
"55432105", "Londrina\ \-\ PR",
"55643454", "Caldas\ Novas\ \-\ GO",
"55114209", "Barueri\ \-\ SP",
"55323575", "Guarani\ \-\ MG",
"55833213", "João\ Pessoa\ \-\ PB",
"55714007", "Salvador\ \-\ BA",
"55943356", "Parauapebas\ \-\ PA",
"55143488", "Quintana\ \-\ SP",
"55473908", "Itajaí\ \-\ SC",
"55112352", "São\ Paulo\ \-\ SP",
"55873794", "Ibirajuba\ \-\ PE",
"55713501", "Salvador\ \-\ BA",
"55143411", "Jaú\ \-\ SP",
"55873878", "Bodocó\ \-\ PE",
"55813482", "Jaboatão\ dos\ Guararapes\ \-\ PE",
"55443248", "Iguaraçu\ \-\ PR",
"55353456", "Natércia\ \-\ MG",
"55133391", "Guarujá\ \-\ SP",
"55333624", "Carlos\ Chagas\ \-\ MG",
"55433511", "Jacarezinho\ \-\ PR",
"55323285", "Chiador\ \-\ MG",
"55193458", "Santa\ Bárbara\ D\'Oeste\ \-\ SP",
"55513566", "São\ Leopoldo\ \-\ RS",
"55773477", "Lagoa\ Real\ \-\ BA",
"55114217", "Atibaia\ \-\ SP",
"55833345", "Caturité\ \-\ PB",
"55673591", "Santa\ Rita\ do\ Pardo\ \-\ MS",
"55143886", "Pardinho\ \-\ SP",
"55434009", "Londrina\ \-\ PR",
"55473427", "Joinville\ \-\ SC",
"55833424", "Salgadinho\ \-\ PB",
"55833042", "João\ Pessoa\ \-\ PB",
"55843375", "Taboleiro\ Grande\ \-\ RN",
"55193743", "Campinas\ \-\ SP",
"55653212", "Lucas\ do\ Rio\ Verde\ \-\ MT",
"55513034", "Sapucaia\ do\ Sul\ \-\ RS",
"55193856", "Vinhedo\ \-\ SP",
"55333753", "Medina\ \-\ MG",
"55383724", "Presidente\ Juscelino\ \-\ MG",
"55473354", "Guabiruba\ \-\ SC",
"55833357", "São\ Domingos\ do\ Cariri\ \-\ PB",
"55114272", "Santana\ de\ Parnaíba\ \-\ SP",
"55513952", "São\ Leopoldo\ \-\ RS",
"55163847", "Nuporanga\ \-\ SP",
"55773412", "Iramaia\ \-\ BA",
"55693733", "Porto\ Velho\ \-\ RO",
"55353858", "Santana\ da\ Vargem\ \-\ MG",
"55383239", "Mirabela\ \-\ MG",
"55163244", "Monte\ Alto\ \-\ SP",
"55653277", "Caramujo\ \-\ MT",
"55382102", "Unaí\ \-\ MG",
"55673242", "Miranda\ \-\ MS",
"55212682", "Seropédica\ \-\ RJ",
"55513487", "Glorinha\ \-\ RS",
"55193583", "Descalvado\ \-\ SP",
"55483648", "Termas\ do\ Gravatal\ \-\ SC",
"55353222", "Varginha\ \-\ MG",
"55193186", "Charqueada\ \-\ SP",
"55474063", "Joinville\ \-\ SC",
"55483357", "São\ José\ \-\ SC",
"55153522", "Itapeva\ \-\ SP",
"55843439", "Bodó\ \-\ RN",
"55433453", "Kaloré\ \-\ PR",
"55423909", "Palmeira\ \-\ PR",
"55753024", "Feira\ de\ Santana\ \-\ BA",
"55823282", "Paulo\ Jacinto\ \-\ AL",
"55143553", "Guaimbê\ \-\ SP",
"5511508", "São\ Paulo\ \-\ SP",
"55114159", "Vargem\ Grande\ Paulista\ \-\ SP",
"55483345", "Tijucas\ \-\ SC",
"55183606", "Guararapes\ \-\ SP",
"55212088", "São\ Gonçalo\ \-\ RJ",
"55433520", "Cornélio\ Procópio\ \-\ PR",
"55242458", "Rio\ das\ Flores\ \-\ RJ",
"55543342", "Marau\ \-\ RS",
"55343352", "Uberaba\ \-\ MG",
"55353267", "Paraguaçu\ \-\ MG",
"55222555", "Cantagalo\ \-\ RJ",
"55143641", "Barra\ Bonita\ \-\ SP",
"55993633", "Lagoa\ Grande\ do\ Maranhão\ \-\ MA",
"55243064", "Petrópolis\ \-\ RJ",
"55543045", "Passo\ Fundo\ \-\ RS",
"55353323", "São\ Vicente\ de\ Minas\ \-\ MG",
"55214125", "Belford\ Roxo\ \-\ RJ",
"55743549", "Rômulo\ Campos\ \-\ BA",
"55353864", "Perdões\ \-\ MG",
"55333315", "Inhapim\ \-\ MG",
"55433529", "Jacarezinho\ \-\ PR",
"55693421", "Ji\-Paraná\ \-\ RO",
"55162111", "Ribeirão\ Preto\ \-\ SP",
"55112506", "São\ Paulo\ \-\ SP",
"55733214", "Itabuna\ \-\ BA",
"55643631", "Jataí\ \-\ GO",
"55553265", "Agudo\ \-\ RS",
"55543057", "Bento\ Gonçalves\ \-\ RS",
"55733289", "Itagimirim\ \-\ BA",
"55453246", "Palmitópolis\ \-\ PR",
"55633444", "Axixá\ do\ Tocantins\ \-\ TO",
"55513736", "Estrêla\ \-\ RS",
"55983689", "Zé\ Doca\ \-\ MA",
"55323555", "Coimbra\ \-\ MG",
"55653313", "Cuiabá\ \-\ MT",
"55643474", "Orizona\ \-\ GO",
"55614501", "Brasília\ \-\ DF",
"55112317", "São\ Paulo\ \-\ SP",
"55193478", "Americana\ \-\ SP",
"55443534", "Mariluz\ \-\ PR",
"55114373", "São\ Paulo\ \-\ SP",
"55383673", "Guarda\-Mor\ \-\ MG",
"55433258", "Ibiporã\ \-\ PR",
"55493548", "Vargem\ Bonita\ \-\ SC",
"55883529", "Milhã\ \-\ CE",
"55873858", "Pedra\ \-\ PE",
"55114161", "Barueri\ \-\ SP",
"55434052", "Londrina\ \-\ PR",
"55313833", "São\ Gonçalo\ do\ Rio\ Abaixo\ \-\ MG",
"55115855", "São\ Paulo\ \-\ SP",
"55313723", "Casa\ Grande\ \-\ MG",
"55222789", "São\ Francisco\ de\ Paula\ \-\ RJ",
"55483286", "Palhoça\ \-\ SC",
"55273287", "Fundão\ \-\ ES",
"55112319", "São\ Paulo\ \-\ SP",
"55893465", "Valença\ do\ Piauí\ \-\ PI",
"55443232", "Marialva\ \-\ PR",
"55473156", "Braço\ do\ Baú\ \-\ SC",
"55423414", "Rio\ da\ Areia\ \-\ PR",
"55883527", "Pereiro\ \-\ CE",
"55913795", "Baião\ \-\ PA",
"55833302", "Camalaú\ \-\ PB",
"55813094", "Jaboatão\ dos\ Guararapes\ \-\ PE",
"5534", "Minas\ Gerais",
"55753602", "Feira\ de\ Santana\ \-\ BA",
"55813454", "Recife\ \-\ PE",
"55333432", "São\ Sebastião\ do\ Maranhão\ \-\ MG",
"55143354", "Botucatu\ \-\ SP",
"55863277", "Capitão\ de\ Campos\ \-\ PI",
"55733287", "Belmonte\ \-\ BA",
"55223201", "Araruama\ \-\ RJ",
"55733512", "Eunápolis\ \-\ BA",
"55833361", "Esperança\ \-\ PB",
"55533310", "Pelotas\ \-\ RS",
"55624103", "Aparecida\ de\ Goiânia\ \-\ GO",
"55643945", "Itumbiara\ \-\ GO",
"55713473", "Salvador\ \-\ BA",
"55793275", "Maruim\ \-\ SE",
"55553336", "Catuípe\ \-\ RS",
"55222540", "Nova\ Friburgo\ \-\ RJ",
"55123115", "Arapeí\ \-\ SP",
"55463226", "Mariópolis\ \-\ PR",
"55743547", "Antônio\ Gonçalves\ \-\ BA",
"55123891", "São\ Sebastião\ \-\ SP",
"55433527", "Jacarezinho\ \-\ PR",
"55913758", "Cachoeira\ do\ Arari\ \-\ PA",
"55193384", "Campinas\ \-\ SP",
"55863212", "Timon\ \-\ MA",
"55633491", "Luzinópolis\ \-\ TO",
"55833286", "Caaporã\ \-\ PB",
"55643685", "Ivolândia\ \-\ GO",
"55114705", "Santana\ de\ Parnaíba\ \-\ SP",
"55993587", "São\ Francisco\ do\ Brejão\ \-\ MA",
"55643526", "Itumbiara\ \-\ GO",
"55182104", "Presidente\ Prudente\ \-\ SP",
"55813468", "Jaboatão\ dos\ Guararapes\ \-\ PE",
"55483203", "Florianópolis\ \-\ SC",
"55993212", "Timon\ \-\ MA",
"55423907", "Irati\ \-\ PR",
"55843437", "Lagoa\ Nova\ \-\ RN",
"55513480", "Guaíba\ \-\ RS",
"55353524", "São\ João\ Batista\ do\ Glória\ \-\ MG",
"55114145", "Itapevi\ \-\ SP",
"55313431", "Belo\ Horizonte\ \-\ MG",
"55673003", "Campo\ Grande\ \-\ MS",
"55373234", "São\ Gonçalo\ do\ Pará\ \-\ MG",
"55213813", "Rio\ de\ Janeiro\ \-\ RJ",
"55823274", "Colônia\ Pindorama\ \-\ AL",
"55513489", "Gravataí\ \-\ RS",
"55433562", "Sertaneja\ \-\ PR",
"55883501", "Juazeiro\ do\ Norte\ \-\ CE",
"55383237", "Claro\ dos\ Poções\ \-\ MG",
"55943785", "Novo\ Repartimento\ \-\ PA",
"55833350", "Ouro\ Velho\ \-\ PB",
"55153551", "Ribeirão\ Branco\ \-\ SP",
"55883562", "Mineirolândia\ \-\ CE",
"55843084", "Natal\ \-\ RN",
"55713797", "Salvador\ \-\ BA",
"55753659", "Salinas\ da\ Margarida\ \-\ BA",
"55913764", "São\ Sebastião\ da\ Boa\ Vista\ \-\ PA",
"55753650", "Nordestina\ \-\ BA",
"5571340", "Salvador\ \-\ BA",
"55833359", "Congo\ \-\ PB",
"55813362", "Jaboatão\ dos\ Guararapes\ \-\ PE",
"55383834", "Nova\ Porteirinha\ \-\ MG",
"55183722", "Andradina\ \-\ SP",
"55114284", "Mogi\ das\ Cruzes\ \-\ SP",
"55773470", "Rio\ do\ Antônio\ \-\ BA",
"55663532", "Sinop\ \-\ MT",
"55773479", "Piatã\ \-\ BA",
"55553241", "Santana\ do\ Livramento\ \-\ RS",
"55353251", "Cambuquira\ \-\ MG",
"55114887", "Jarinu\ \-\ SP",
"55473641", "Mafra\ \-\ SC",
"55893494", "Paes\ Landim\ \-\ PI",
"55613355", "Taguatinga\ \-\ DF",
"55434007", "Londrina\ \-\ PR",
"55923215", "Manaus\ \-\ AM",
"55833279", "Cachoeira\ \-\ PB",
"55313848", "Minas\ Gerais",
"55843240", "Montanhas\ \-\ RN",
"55173442", "Fernandópolis\ \-\ SP",
"55713647", "Catu\ \-\ BA",
"55153266", "Iperó\ \-\ SP",
"55613585", "Ceilândia\ \-\ DF",
"55843249", "Espírito\ Santo\ \-\ RN",
"55493533", "Videira\ \-\ SC",
"55423323", "Ponta\ Grossa\ \-\ PR",
"55683611", "Manoel\ Urbano\ \-\ AC",
"55643564", "Anicuns\ \-\ GO",
"55613275", "Brasília\ \-\ DF",
"55214062", "Rio\ de\ Janeiro\ \-\ RJ",
"55713655", "São\ Sebastião\ do\ Passé\ \-\ BA",
"55353371", "Passa\ Quatro\ \-\ MG",
"55143104", "Bauru\ \-\ SP",
"55543433", "Arco\ Verde\ \-\ RS",
"55463520", "Francisco\ Beltrão\ \-\ PR",
"55623609", "Goiânia\ \-\ GO",
"55114049", "Diadema\ \-\ SP",
"55673432", "Ponta\ Porã\ \-\ MS",
"55183654", "Penápolis\ \-\ SP",
"55813646", "Tracunhaém\ \-\ PE",
"55163434", "Ribeirão\ Preto\ \-\ SP",
"55623536", "Goiânia\ \-\ GO",
"55713452", "Salvador\ \-\ BA",
"55113594", "São\ Paulo\ \-\ SP",
"55513111", "Cachoeirinha\ \-\ RS",
"55913726", "Ulianópolis\ \-\ PA",
"55133505", "Mongaguá\ \-\ SP",
"55823427", "Minador\ do\ Negrão\ \-\ AL",
"55383621", "Januária\ \-\ MG",
"55193804", "Mogi\ Mirim\ \-\ SP",
"55993648", "Bernardo\ do\ Mearim\ \-\ MA",
"55313897", "São\ Miguel\ do\ Anta\ \-\ MG",
"55483279", "Palhoça\ \-\ SC",
"55223866", "São\ José\ de\ Ubá\ \-\ RJ",
"55663022", "Rondonópolis\ \-\ MT",
"55123143", "Cruzeiro\ \-\ SP",
"55193554", "Leme\ \-\ SP",
"55273091", "Cariacica\ \-\ ES",
"55213857", "São\ Gonçalo\ \-\ RJ",
"55913442", "Santa\ Maria\ do\ Pará\ \-\ PA",
"55343284", "Araporã\ \-\ MG",
"55653361", "Barra\ do\ Bugres\ \-\ MT",
"55133847", "Miracatu\ \-\ SP",
"55313265", "Minas\ Gerais",
"55143274", "Gália\ \-\ SP",
"55113565", "São\ Caetano\ do\ Sul\ \-\ SP",
"55213845", "Duque\ de\ Caxias\ \-\ RJ",
"55793347", "Cedro\ de\ São\ João\ \-\ SE",
"55143584", "Pirajuí\ \-\ SP",
"55143812", "São\ Manuel\ \-\ SP",
"55853051", "Fortaleza\ \-\ CE",
"55623455", "Povoado\ de\ São\ Jorge\ \-\ GO",
"55623095", "Goiânia\ \-\ GO",
"55543238", "Caxias\ do\ Sul\ \-\ RS",
"55413873", "Campina\ Grande\ do\ Sul\ \-\ PR",
"55633234", "Palmas\ \-\ TO",
"55513267", "Rio\ Grande\ do\ Sul",
"55643558", "Itumbiara\ \-\ GO",
"5511361", "São\ Paulo\ \-\ SP",
"55133855", "Tatuí\ \-\ SP",
"55863345", "São\ João\ da\ Fronteira\ \-\ PI",
"55513476", "Canoas\ \-\ RS",
"5528", "Espirito\ Santo",
"55472125", "Balneário\ Camboriú\ \-\ SC",
"55883410", "Itaiçaba\ \-\ CE",
"55833633", "Baraúna\ \-\ PB",
"55443659", "Altônia\ \-\ PR",
"55883419", "Arneiroz\ \-\ CE",
"55823216", "Maceió\ \-\ AL",
"55323331", "Barbacena\ \-\ MG",
"55613626", "Santo\ Antônio\ do\ Descoberto\ \-\ GO",
"55123019", "São\ José\ dos\ Campos\ \-\ SP",
"55643595", "Itumbiara\ \-\ GO",
"55353736", "Cabo\ Verde\ \-\ MG",
"55193112", "Campinas\ \-\ SP",
"55473383", "Ascurra\ \-\ SC",
"55443645", "Terra\ Roxa\ \-\ PR",
"55853022", "Fortaleza\ \-\ CE",
"55463562", "Manfrinópolis\ \-\ PR",
"55353826", "Lavras\ \-\ MG",
"55733625", "Mascote\ \-\ BA",
"55993576", "Matões\ \-\ MA",
"55113653", "Osasco\ \-\ SP",
"55833313", "Boa\ Vista\ \-\ PB",
"55213114", "Rio\ de\ Janeiro\ \-\ RJ",
"5511415", "Santana\ de\ Parnaíba\ \-\ SP",
"55853325", "Pacoti\ \-\ CE",
"55193828", "Sumaré\ \-\ SP",
"55123678", "Natividade\ da\ Serra\ \-\ SP",
"55433675", "Centenário\ do\ Sul\ \-\ PR",
"55173405", "Votuporanga\ \-\ SP",
"55493334", "Saudades\ \-\ SC",
"55423524", "União\ da\ Vitória\ \-\ PR",
"55173836", "Cosmorama\ \-\ SP",
"55133291", "Santos\ \-\ SP",
"55273422", "Cariacica\ \-\ ES",
"55273044", "Colatina\ \-\ ES",
"55173661", "Rubinéia\ \-\ SP",
"551120", "São\ Paulo\ \-\ SP",
"55512131", "Porto\ Alegre\ \-\ RS",
"5561334", "Brasília\ \-\ DF",
"55533252", "Canguçu\ \-\ RS",
"55464007", "Francisco\ Beltrão\ \-\ PR",
"55333242", "São\ João\ do\ Manteninha\ \-\ MG",
"55433417", "Ribeirão\ Bonito\ \-\ PR",
"55773643", "Matina\ \-\ BA",
"55793349", "Porto\ da\ Folha\ \-\ SE",
"55513260", "Rio\ Grande\ do\ Sul",
"55823553", "Porto\ Real\ do\ Colégio\ \-\ AL",
"55143282", "Duartina\ \-\ SP",
"55473046", "Itajaí\ \-\ SC",
"55443442", "Guairaçá\ \-\ PR",
"55343814", "Patos\ de\ Minas\ \-\ MG",
"55623621", "Goiânia\ \-\ GO",
"55112715", "Itu\ \-\ SP",
"55313336", "Minas\ Gerais",
"55883675", "Independência\ \-\ CE",
"55133849", "Iguape\ \-\ SP",
"55213850", "Rio\ de\ Janeiro\ \-\ RJ",
"55143572", "Pirajuí\ \-\ SP",
"55213552", "Duque\ de\ Caxias\ \-\ RJ",
"55613702", "Brasília\ \-\ DF",
"55113393", "São\ Paulo\ \-\ SP",
"55143879", "Bauru\ \-\ SP",
"55112828", "Santo\ André\ \-\ SP",
"55423251", "Papagaios\ Novos\ \-\ PR",
"55433472", "Ivaiporã\ \-\ PR",
"55623449", "Guarani\ de\ Goiás\ \-\ GO",
"5511333", "São\ Paulo\ \-\ SP",
"55413116", "São\ José\ dos\ Pinhais\ \-\ PR",
"55313890", "Minas\ Gerais",
"55843298", "São\ Bento\ do\ Trairí\ \-\ RN",
"55673681", "Terenos\ \-\ MS",
"55483277", "São\ Pedro\ de\ Alcântara\ \-\ SC",
"55553431", "São\ Borja\ \-\ RS",
"55333343", "Alto\ Jequitibá\ \-\ MG",
"55413634", "São\ José\ dos\ Pinhais\ \-\ PR",
"55833466", "Assunção\ \-\ PB",
"55114692", "Biritiba\-Mirim\ \-\ SP",
"55863302", "Teresina\ \-\ PI",
"55453540", "São\ Miguel\ do\ Iguaçu\ \-\ PR",
"5581332", "Recife\ \-\ PE",
"55513524", "Novo\ Hamburgo\ \-\ RS",
"55313899", "Viçosa\ \-\ MG",
"55273276", "Guaraná\ \-\ ES",
"55114098", "Salto\ \-\ SP",
"55943314", "Serra\ Pelada\ \-\ PA",
"55633396", "São\ Salvador\ do\ Tocantins\ \-\ TO",
"55223311", "Macaé\ \-\ RJ",
"55483212", "Florianópolis\ \-\ SC",
"55823420", "Palmeira\ dos\ Índios\ \-\ AL",
"5511263", "São\ Paulo\ \-\ SP",
"55823641", "Delmiro\ Gouveia\ \-\ AL",
"55913661", "Oeiras\ do\ Pará\ \-\ PA",
"55643416", "Morrinhos\ \-\ GO",
"55242102", "Volta\ Redonda\ \-\ RJ",
"55313771", "Sete\ Lagoas\ \-\ MG",
"55193353", "Araras\ \-\ SP",
"55733276", "Apuarema\ \-\ BA",
"55313241", "Belo\ Horizonte\ \-\ MG",
"55623607", "Goiânia\ \-\ GO",
"55923198", "Manaus\ \-\ AM",
"55963083", "Macapá\ \-\ AP",
"55843255", "Senador\ Elói\ de\ Souza\ \-\ RN",
"55653345", "Poconé\ \-\ MT",
"55114047", "Diadema\ \-\ SP",
"55433904", "Cornélio\ Procópio\ \-\ PR",
"5519363", "São\ João\ da\ Boa\ Vista\ \-\ SP",
"55893575", "Avelino\ Lopes\ \-\ PI",
"55463527", "Francisco\ Beltrão\ \-\ PR",
"55813483", "Olinda\ \-\ PE",
"55273746", "Alto\ Rio\ Novo\ \-\ ES",
"55843247", "Pedro\ Velho\ \-\ RN",
"55183341", "Cândido\ Mota\ \-\ SP",
"55833277", "Pirpirituba\ \-\ PB",
"55114495", "Itatiba\ \-\ SP",
"55473274", "Jaraguá\ do\ Sul\ \-\ SC",
"55713649", "Camaçari\ \-\ BA",
"55483466", "Orleans\ \-\ SC",
"55343426", "Pirajuba\ \-\ MG",
"55163014", "Araraquara\ \-\ SP",
"55212771", "Duque\ de\ Caxias\ \-\ RJ",
"55153335", "Sorocaba\ \-\ SP",
"55123141", "Cruzeiro\ \-\ SP",
"55483902", "Criciúma\ \-\ SC",
"55943326", "Rondon\ do\ Pará\ \-\ PA",
"55753246", "São\ Gonçalo\ dos\ Campos\ \-\ BA",
"55773462", "Caetanos\ \-\ BA",
"55633375", "Pindorama\ do\ Tocantins\ \-\ TO",
"55824002", "Maceió\ \-\ AL",
"55213974", "Rio\ de\ Janeiro\ \-\ RJ",
"55443663", "Douradina\ \-\ PR",
"55673446", "Angélica\ \-\ MS",
"55383623", "Januária\ \-\ MG",
"55983398", "Cedral\ \-\ MA",
"55143032", "Jaú\ \-\ SP",
"55883579", "Quixelô\ \-\ CE",
"55973425", "Jutaí\ \-\ AM",
"55643648", "Itajá\ \-\ GO",
"55143335", "Ourinhos\ \-\ SP",
"55313061", "Conselheiro\ Lafaiete\ \-\ MG",
"55353426", "Senador\ José\ Bento\ \-\ MG",
"55193984", "Paulínia\ \-\ SP",
"55743534", "Pilão\ Arcado\ \-\ BA",
"55212608", "Niterói\ \-\ RJ",
"55793548", "Santa\ Luzia\ do\ Itanhy\ \-\ SE",
"55733258", "Maraú\ \-\ BA",
"55813379", "Jaboatão\ dos\ Guararapes\ \-\ PE",
"55643697", "Davinópolis\ \-\ GO",
"55793711", "Aracaju\ \-\ SE",
"55813435", "Paulista\ \-\ PE",
"55383505", "Unaí\ \-\ MG",
"55533025", "Pelotas\ \-\ RS",
"55983658", "Alto\ Alegre\ do\ Pindaré\ \-\ MA",
"55143479", "Avencas\ \-\ SP",
"55993564", "Governador\ Eugênio\ Barros\ \-\ MA",
"55353373", "Virgínia\ \-\ MG",
"55213099", "Teresópolis\ \-\ RJ",
"55313305", "Belo\ Horizonte\ \-\ MG",
"55153383", "Laranjal\ Paulista\ \-\ SP",
"55443540", "Bragantina\ \-\ PR",
"55873272", "Parnamirim\ \-\ RN",
"55623542", "Goiânia\ \-\ GO",
"55693471", "Presidente\ Médici\ \-\ RO",
"55433579", "Salto\ do\ Itararé\ \-\ PR",
"55163026", "Franca\ \-\ SP",
"55343414", "Contagem\ \-\ MG",
"55983355", "Cajapió\ \-\ MA",
"55493531", "Videira\ \-\ SC",
"55633439", "Itacajá\ \-\ TO",
"55773401", "Vitória\ da\ Conquista\ \-\ BA",
"55713204", "Salvador\ \-\ BA",
"55273258", "João\ Neiva\ \-\ ES",
"55873880", "Granito\ \-\ PE",
"5542", "Paraná",
"55733295", "Itanhém\ \-\ BA",
"55873889", "Cedro\ \-\ PE",
"55633430", "Carmolândia\ \-\ TO",
"55963332", "Macapá\ \-\ AP",
"55423516", "Rio\ Claro\ do\ Sul\ \-\ PR",
"55823522", "Arapiraca\ \-\ AL",
"55613334", "Recanto\ das\ Emas\ \-\ DF",
"55163724", "Franca\ \-\ SP",
"55153282", "Tietê\ \-\ SP",
"55323333", "Barbacena\ \-\ MG",
"55313499", "Minas\ Gerais",
"55113425", "Diadema\ \-\ SP",
"55153572", "Itaberá\ \-\ SP",
"55923682", "Manaus\ \-\ AM",
"551138", "São\ Paulo\ \-\ SP",
"55473318", "Gaspar\ \-\ SC",
"55333062", "Governador\ Valadares\ \-\ MG",
"55513049", "Campo\ Bom\ \-\ RS",
"55313490", "Minas\ Gerais",
"55753331", "Seabra\ \-\ BA",
"55443016", "Campo\ Mourão\ \-\ PR",
"55273264", "Linhares\ \-\ ES",
"55893438", "São\ Julião\ \-\ PI",
"55343826", "Patos\ de\ Minas\ \-\ MG",
"55114895", "Nazaré\ Paulista\ \-\ SP",
"55433356", "Londrina\ \-\ PR",
"55833474", "Maturéia\ \-\ PB",
"55843325", "Upanema\ \-\ RN",
"55322152", "Juiz\ de\ Fora\ \-\ MG",
"55883696", "Monsenhor\ Tabosa\ \-\ CE",
"55483631", "Tubarão\ \-\ SC",
"55173547", "Itajobi\ \-\ SP",
"55353742", "Bandeira\ do\ Sul\ \-\ MG",
"55553752", "Ametista\ do\ Sul\ \-\ RS",
"55373247", "Igaratinga\ \-\ MG",
"55653363", "Cuiabá\ \-\ MT",
"55983664", "Buriticupu\ \-\ MA",
"55162102", "Ribeirão\ Preto\ \-\ SP",
"55993558", "Passagem\ Franca\ \-\ MA",
"55543905", "Gramado\ \-\ RS",
"55313624", "Ribeirão\ das\ Neves\ \-\ MG",
"55513692", "Camaquã\ \-\ RS",
"55833482", "Imaculada\ \-\ PB",
"55373249", "Itaúna\ \-\ MG",
"55114524", "Itatiba\ \-\ SP",
"55823551", "Penedo\ \-\ AL",
"55412626", "Curitiba\ \-\ PR",
"55773641", "Mansidão\ \-\ BA",
"55222764", "Rio\ das\ Ostras\ \-\ RJ",
"55893415", "Picos\ \-\ PI",
"55173842", "Indiaporã\ \-\ SP",
"55313448", "Minas\ Gerais",
"55513458", "Esteio\ \-\ RS",
"55413588", "São\ José\ dos\ Pinhais\ \-\ PR",
"55643576", "Itumbiara\ \-\ GO",
"5513323", "Santos\ \-\ SP",
"55493626", "Bandeirante\ \-\ SC",
"55613614", "Novo\ Gama\ \-\ GO",
"5531370", "Minas\ Gerais",
"55753688", "Lamarão\ \-\ BA",
"55513047", "Gravataí\ \-\ RS",
"55313057", "Belo\ Horizonte\ \-\ MG",
"55173663", "Santa\ Clara\ D\'Oeste\ \-\ SP",
"55613689", "Formosa\ \-\ GO",
"55153274", "Alambari\ \-\ SP",
"55333236", "Alpercata\ \-\ MG",
"55863262", "Altos\ \-\ PI",
"55833388", "Seridó\ \-\ PB",
"55193404", "Limeira\ \-\ SP",
"55353284", "Serrania\ \-\ MG",
"55153584", "Taquarivaí\ \-\ SP",
"55643408", "Joviânia\ \-\ GO",
"55113651", "Osasco\ \-\ SP",
"55313045", "Belo\ Horizonte\ \-\ MG",
"55683232", "Senador\ Guiomard\ \-\ AC",
"55513055", "Guaíba\ \-\ RS",
"55313342", "Belo\ Horizonte\ \-\ MG",
"55274007", "Vitória\ \-\ ES",
"55623505", "Trindade\ \-\ GO",
"55513495", "Sertão\ Santana\ \-\ RS",
"55833685", "Sertãozinho\ \-\ PB",
"55443436", "Itaúna\ do\ Sul\ \-\ PR",
"55153519", "Sorocaba\ \-\ SP",
"55433512", "Arapoti\ \-\ PR",
"55843604", "Parnamirim\ \-\ RN",
"55973391", "Tapauá\ \-\ AM",
"55873887", "Orocó\ \-\ PE",
"55133392", "Guarujá\ \-\ SP",
"55493275", "Otacílio\ Costa\ \-\ SC",
"55413473", "Caiobá\ \-\ PR",
"55222758", "São\ Fidélis\ \-\ RJ",
"55633437", "Cachoeirinha\ \-\ TO",
"55283524", "Vargem\ Grande\ do\ Soturno\ \-\ ES",
"55443555", "Nice\ \-\ PR",
"55863363", "Buriti\ dos\ Lopes\ \-\ PI",
"55813481", "Jaboatão\ dos\ Guararapes\ \-\ PE",
"55213445", "Rio\ de\ Janeiro\ \-\ RJ",
"55513464", "Canoas\ \-\ RS",
"5583322", "João\ Pessoa\ \-\ PB",
"55213097", "Teresópolis\ \-\ RJ",
"55323534", "Brás\ Pires\ \-\ MG",
"55173016", "São\ José\ do\ Rio\ Preto\ \-\ SP",
"55613533", "Brasília\ \-\ DF",
"55983349", "Barreirinhas\ \-\ MA",
"55643699", "Buriti\ de\ Goiás\ \-\ GO",
"55143477", "Arco\-Íris\ \-\ SP",
"55733527", "Jequié\ \-\ BA",
"55313243", "Minas\ Gerais",
"55663493", "Pedra\ Preta\ \-\ MT",
"55963081", "Macapá\ \-\ AP",
"55513253", "Rio\ Grande\ do\ Sul",
"55242566", "Bom\ Jardim\ \-\ RJ",
"55193351", "Araras\ \-\ SP",
"55823643", "Olho\ d\'Água\ do\ Casado\ \-\ AL",
"55813377", "Jaboatão\ dos\ Guararapes\ \-\ PE",
"5548322", "Florianópolis\ \-\ SC",
"55213982", "Rio\ de\ Janeiro\ \-\ RJ",
"55273181", "Vitória\ \-\ ES",
"55143318", "Marília\ \-\ SP",
"55193917", "Ribeirão\ Preto\ \-\ SP",
"55222534", "Duas\ Barras\ \-\ RJ",
"55192146", "Capivari\ \-\ SP",
"55543011", "Farroupilha\ \-\ RS",
"55242487", "Avelar\ \-\ RJ",
"55883512", "Juazeiro\ do\ Norte\ \-\ CE",
"55163708", "Franca\ \-\ SP",
"55483526", "Balneário\ Arroio\ do\ Silva\ \-\ SC",
"55673683", "Rio\ Verde\ de\ Mato\ Grosso\ \-\ MS",
"55213642", "Teresópolis\ \-\ RJ",
"55433154", "Cambé\ \-\ PR",
"55553433", "Itaqui\ \-\ RS",
"55333341", "Manhumirim\ \-\ MG",
"55813015", "Recife\ \-\ PE",
"55273732", "Baixo\ Guandu\ \-\ ES",
"55853084", "Fortaleza\ \-\ CE",
"55513426", "Canoas\ \-\ RS",
"55743659", "Várzea\ Nova\ \-\ BA",
"55222645", "Cabo\ Frio\ \-\ RJ",
"55833564", "Poço\ de\ José\ de\ Moura\ \-\ PB",
"55453333", "Cascavel\ \-\ PR",
"55433451", "São\ Pedro\ do\ Ivaí\ \-\ PR",
"55423272", "Telêmaco\ Borba\ \-\ PR",
"55323442", "Leopoldina\ \-\ MG",
"55933596", "São\ José\ \-\ PA",
"55193581", "Porto\ Ferreira\ \-\ SP",
"55893443", "Santana\ do\ Piauí\ \-\ PI",
"55213792", "Duque\ de\ Caxias\ \-\ RJ",
"55343251", "Santa\ Vitória\ \-\ MG",
"5587", "Pernambuco",
"55312571", "Betim\ \-\ MG",
"55114736", "Mogi\ das\ Cruzes\ \-\ SP",
"55673236", "Nioaque\ \-\ MS",
"5577342", "Vitória\ da\ Conquista\ \-\ BA",
"55443688", "Xambrê\ \-\ PR",
"55493355", "Lajeado\ Grande\ \-\ SC",
"55333751", "Pedra\ Azul\ \-\ MG",
"55163607", "Ribeirão\ Preto\ \-\ SP",
"55373546", "Biquinhas\ \-\ MG",
"55143224", "Bauru\ \-\ SP",
"55883451", "Dom\ Maurício\ \-\ CE",
"55863474", "Pimenteiras\ \-\ PI",
"55753436", "Olindina\ \-\ BA",
"55212709", "Niterói\ \-\ RJ",
"55323348", "Cipotânea\ \-\ MG",
"55123975", "Santa\ Branca\ \-\ SP",
"55553305", "Ijuí\ \-\ RS",
"55493347", "Coronel\ Freitas\ \-\ SC",
"55212700", "Itaguaí\ \-\ RJ",
"55242251", "Três\ Rios\ \-\ RJ",
"55623089", "Goiânia\ \-\ GO",
"55112518", "São\ Paulo\ \-\ SP",
"55493658", "Tigrinhos\ \-\ SC",
"5511366", "São\ Paulo\ \-\ SP",
"55114566", "Mogi\ das\ Cruzes\ \-\ SP",
"55114163", "Barueri\ \-\ SP",
"55743661", "Xique\-Xique\ \-\ BA",
"55433304", "Londrina\ \-\ PR",
"55313831", "Itabira\ \-\ MG",
"55212752", "São\ João\ de\ Meriti\ \-\ RJ",
"55543336", "Ipiranga\ do\ Sul\ \-\ RS",
"55913776", "Santa\ Bárbara\ do\ Pará\ \-\ PA",
"55114034", "Bragança\ Paulista\ \-\ SP",
"55673029", "Campo\ Grande\ \-\ MS",
"55413452", "Matinhos\ \-\ PR",
"55113515", "São\ Paulo\ \-\ SP",
"55513582", "Novo\ Hamburgo\ \-\ RS",
"55383671", "Paracatu\ \-\ MG",
"55653388", "Várzea\ Grande\ \-\ MT",
"55313215", "Minas\ Gerais",
"55123604", "Pindamonhangaba\ \-\ SP",
"55712136", "Salvador\ \-\ BA",
"55653311", "Tangará\ da\ Serra\ \-\ MT",
"55343269", "Ituiutaba\ \-\ MG",
"55183941", "Espigão\ \-\ SP",
"55413698", "Almirante\ Tamandaré\ \-\ PR",
"55833558", "Cachoeira\ dos\ Índios\ \-\ PB",
"55843234", "Natal\ \-\ RN",
"55833229", "Santa\ Rita\ \-\ PB",
"55473522", "Rio\ do\ Sul\ \-\ SC",
"55173331", "Guaíra\ \-\ SP",
"55114487", "Itatiba\ \-\ SP",
"55212666", "Nova\ Iguaçu\ \-\ RJ",
"55413358", "São\ José\ dos\ Pinhais\ \-\ PR",
"55513742", "Sobradinho\ \-\ RS",
"55663439", "Rondonópolis\ \-\ MT",
"55313752", "Catas\ Altas\ da\ Noruega\ \-\ MG",
"55943421", "Conceição\ do\ Araguaia\ \-\ PA",
"55453232", "Guaraniaçu\ \-\ PR",
"55493664", "Maravilha\ \-\ SC",
"55643633", "Lagoa\ do\ Bauzinho\ \-\ GO",
"55693423", "Ji\-Paraná\ \-\ RO",
"55823266", "Satuba\ \-\ AL",
"55993631", "São\ Luís\ Gonzaga\ do\ Maranhão\ \-\ MA",
"5551330", "Rio\ Grande\ do\ Sul",
"55344004", "Uberlândia\ \-\ MG",
"55323726", "Patrocínio\ do\ Muriaé\ \-\ MG",
"5535", "Minas\ Gerais",
"55183994", "Emilianópolis\ \-\ SP",
"55513157", "Três\ Coroas\ \-\ RS",
"55873876", "Belém\ de\ São\ Francisco\ \-\ PE",
"55823032", "Maceió\ \-\ AL",
"55633493", "Palmeirante\ \-\ TO",
"55443246", "Maringá\ \-\ PR",
"55433276", "Arapongas\ \-\ PR",
"5586322", "Teresina\ \-\ PI",
"55274105", "Vila\ Velha\ \-\ ES",
"55113754", "Arujá\ \-\ SP",
"55123893", "São\ Sebastião\ \-\ SP",
"55193456", "Iracemápolis\ \-\ SP",
"55624101", "Goiânia\ \-\ GO",
"55773274", "Macarani\ \-\ BA",
"55663437", "Campinápolis\ \-\ MT",
"55353692", "Itajubá\ \-\ MG",
"55613597", "Taguatinga\ \-\ DF",
"55413649", "Campo\ Largo\ \-\ PR",
"55993311", "Açailândia\ \-\ MA",
"5521345", "Rio\ de\ Janeiro\ \-\ RJ",
"55833363", "Solânea\ \-\ PB",
"55163392", "Américo\ Brasiliense\ \-\ SP",
"55143486", "Herculândia\ \-\ SP",
"55943358", "Canaã\ dos\ Carajás\ \-\ PA",
"55114489", "Francisco\ Morato\ \-\ SP",
"55212721", "Niterói\ \-\ RJ",
"55193765", "Campinas\ \-\ SP",
"55343267", "Centralina\ \-\ MG",
"55843532", "Lajes\ \-\ RN",
"55313238", "Belo\ Horizonte\ \-\ MG",
"55883586", "Crato\ \-\ CE",
"55313885", "Viçosa\ \-\ MG",
"55343323", "Veríssimo\ \-\ MG",
"55713634", "Pólo\ Petroquímico\ Camaçari\ \-\ BA",
"55222661", "Araruama\ \-\ RJ",
"55383014", "Montes\ Claros\ \-\ MG",
"55433467", "Rio\ Branco\ do\ Ivaí\ \-\ PR",
"55673027", "Campo\ Grande\ \-\ MS",
"55653631", "Cuiabá\ \-\ MT",
"55513210", "Rio\ Grande\ do\ Sul",
"55213916", "Rio\ de\ Janeiro\ \-\ RJ",
"55542521", "Bento\ Gonçalves\ \-\ RS",
"55313721", "Conselheiro\ Lafaiete\ \-\ MG",
"55473643", "Mafra\ \-\ SC",
"55913082", "Belém\ \-\ PA",
"55493349", "Irati\ \-\ SC",
"55673668", "Paranaíba\ \-\ MS",
"55553243", "Santana\ do\ Livramento\ \-\ RS",
"55623087", "Goiânia\ \-\ GO",
"55543294", "Nova\ Roma\ do\ Sul\ \-\ RS",
"55943364", "Vila\ Mandii\ \-\ PA",
"55112535", "São\ Paulo\ \-\ SP",
"55833201", "Campina\ Grande\ \-\ PB",
"55483262", "Governador\ Celso\ Ramos\ \-\ SC",
"55212707", "Niterói\ \-\ RJ",
"55843396", "Lucrécia\ \-\ RN",
"55353464", "Inconfidentes\ \-\ MG",
"55883625", "Chaval\ \-\ CE",
"55143522", "Lins\ \-\ SP",
"55153553", "Ribeirão\ Branco\ \-\ SP",
"55143737", "Garça\ \-\ SP",
"55114826", "Rio\ Grande\ da\ Serra\ \-\ SP",
"5531349", "Belo\ Horizonte\ \-\ MG",
"55883422", "Morada\ Nova\ \-\ CE",
"55313433", "Belo\ Horizonte\ \-\ MG",
"55423219", "Ponta\ Grossa\ \-\ PR",
"55243076", "Volta\ Redonda\ \-\ RJ",
"55193794", "Campinas\ \-\ SP",
"55743645", "Campo\ Formoso\ \-\ BA",
"55242222", "Petrópolis\ \-\ RJ",
"55163133", "Cristais\ Paulista\ \-\ SP",
"55115095", "São\ Paulo\ \-\ SP",
"55853375", "Pindoretama\ \-\ CE",
"55193878", "Louveira\ \-\ SP",
"55623434", "Goiânia\ \-\ GO",
"55433625", "Cafeara\ \-\ PR",
"55493021", "Lages\ \-\ SC",
"55833262", "João\ Pessoa\ \-\ PB",
"55193129", "Vinhedo\ \-\ SP",
"55663546", "Cláudia\ \-\ MT",
"55123022", "Taubaté\ \-\ SP",
"55743657", "Lapão\ \-\ BA",
"55333722", "Mata\ Verde\ \-\ MG",
"55513705", "Marques\ de\ Souza\ \-\ RS",
"55483903", "Araranguá\ \-\ SC",
"55373355", "Doresópolis\ \-\ MG",
"55193476", "Nova\ Odessa\ \-\ SP",
"55463557", "Bela\ Vista\ da\ Caroba\ \-\ PR",
"55273364", "Guarapari\ \-\ ES",
"55112864", "São\ Paulo\ \-\ SP",
"55433256", "Rolândia\ \-\ PR",
"55493546", "Monte\ Carlo\ \-\ SC",
"55313710", "Minas\ Gerais",
"55843225", "Genipabu\ \-\ RN",
"55313719", "Minas\ Gerais",
"55873856", "Tupanatinga\ \-\ PE",
"55443068", "Campo\ Mourão\ \-\ PR",
"55643504", "Americano\ do\ Brasil\ \-\ GO",
"55773463", "Licínio\ de\ Almeida\ \-\ BA",
"55453248", "Iguatu\ \-\ PR",
"55543446", "Cotiporã\ \-\ RS",
"55193508", "Araras\ \-\ SP",
"55343456", "União\ de\ Minas\ \-\ MG",
"55463545", "Nova\ Prata\ do\ Iguaçu\ \-\ PR",
"55163475", "Sertãozinho\ \-\ SP",
"55513738", "Venâncio\ Aires\ \-\ RS",
"55813633", "Nazaré\ da\ Mata\ \-\ PE",
"55383622", "Pedras\ de\ Maria\ da\ Cruz\ \-\ MG",
"55443662", "Maria\ Helena\ \-\ PR",
"55114025", "Itu\ \-\ SP",
"55653327", "Progresso\ \-\ MT",
"55673674", "Bela\ Vista\ \-\ MS",
"5564392", "Itumbiara\ \-\ GO",
"55713451", "Salvador\ \-\ BA",
"55213208", "Rio\ de\ Janeiro\ \-\ RJ",
"55313544", "Betim\ \-\ MG",
"55533267", "Herval\ \-\ RS",
"55513554", "São\ Leopoldo\ \-\ RS",
"55613234", "Guará\ \-\ DF",
"55443465", "Cruzeiro\ do\ Sul\ \-\ PR",
"55673431", "Ponta\ Porã\ \-\ MS",
"55114644", "Itaquaquecetuba\ \-\ SP",
"55623004", "Goiânia\ \-\ GO",
"55333265", "Santa\ Rita\ do\ Itueto\ \-\ MG",
"55114428", "Santo\ André\ \-\ SP",
"55683612", "Sena\ Madureira\ \-\ AC",
"55473366", "Balneário\ Camboriú\ \-\ SC",
"55173441", "General\ Salgado\ \-\ SP",
"55823523", "Limoeiro\ de\ Anadia\ \-\ AL",
"55193895", "Socorro\ \-\ SP",
"55333294", "Nacip\ Raydan\ \-\ MG",
"55493019", "Lages\ \-\ SC",
"55353273", "Jesuânia\ \-\ MG",
"55653301", "Chapada\ dos\ Guimarães\ \-\ MT",
"55323332", "Barbacena\ \-\ MG",
"55542104", "Passo\ Fundo\ \-\ RS",
"55153283", "Laranjal\ Paulista\ \-\ SP",
"55183608", "Araçatuba\ \-\ SP",
"55283322", "Cachoeiro\ de\ Itapemirim\ \-\ ES",
"55423221", "Telêmaco\ Borba\ \-\ PR",
"55113505", "São\ Paulo\ \-\ SP",
"55713460", "Salvador\ \-\ BA",
"55153573", "Barão\ de\ Antonina\ \-\ SP",
"55213820", "Rio\ de\ Janeiro\ \-\ RJ",
"55133594", "Praia\ Grande\ \-\ SP",
"55884141", "Juazeiro\ do\ Norte\ \-\ CE",
"55483646", "Laguna\ \-\ SC",
"55193858", "Engenheiro\ Coelho\ \-\ SP",
"55853355", "São\ Luís\ do\ Curu\ \-\ CE",
"5511412", "São\ Bernardo\ do\ Campo\ \-\ SP",
"55434141", "Londrina\ \-\ PR",
"55493437", "Passos\ Maia\ \-\ SC",
"55353856", "Guapé\ \-\ MG",
"55143811", "Botucatu\ \-\ SP",
"55623391", "Mundo\ Novo\ \-\ GO",
"55513568", "São\ Leopoldo\ \-\ RS",
"55853347", "Baturité\ \-\ CE",
"55653362", "Várzea\ Grande\ \-\ MT",
"55353743", "Campestre\ \-\ MG",
"55112895", "São\ Paulo\ \-\ SP",
"55273395", "Vitória\ \-\ ES",
"55553753", "São\ José\ das\ MissõEs\ \-\ RS",
"55143888", "Pereiras\ \-\ SP",
"55743677", "Ponto\ Novo\ \-\ BA",
"55543537", "Caxias\ do\ Sul\ \-\ RS",
"558532", "Fortaleza\ \-\ CE",
"55913441", "Igarapé\-Açu\ \-\ PA",
"55443627", "São\ Lourenço\ \-\ PR",
"55423554", "Cruz\ Machado\ \-\ PR",
"55613701", "Brasília\ \-\ DF",
"55883634", "Ubajara\ \-\ CE",
"55713183", "Salvador\ \-\ BA",
"55143366", "Bauru\ \-\ SP",
"55443629", "Cianorte\ \-\ PR",
"55423252", "Palmeira\ \-\ PR",
"55433471", "Jacutinga\ \-\ PR",
"55443441", "Terra\ Rica\ \-\ PR",
"55623622", "Goiânia\ \-\ GO",
"55143218", "Bauru\ \-\ SP",
"55513693", "Rio\ Grande\ do\ Sul",
"55833483", "Olho\ d\'Água\ \-\ PB",
"55733421", "Porto\ Seguro\ \-\ BA",
"55213551", "Rio\ de\ Janeiro\ \-\ RJ",
"55343271", "Ituiutaba\ \-\ MG",
"55173465", "Fernandópolis\ \-\ SP",
"55813212", "Recife\ \-\ PE",
"55143281", "Bauru\ \-\ SP",
"55633531", "Divinópolis\ do\ Tocantins\ \-\ TO",
"55493439", "Linha\ Planalto\ \-\ SC",
"55533251", "São\ Lourenço\ do\ Sul\ \-\ RS",
"55112524", "São\ Paulo\ \-\ SP",
"55333241", "Mantena\ \-\ MG",
"55713276", "Salvador\ \-\ BA",
"55173843", "Ouroeste\ \-\ SP",
"55793022", "Aracaju\ \-\ SE",
"55213224", "Rio\ de\ Janeiro\ \-\ RJ",
"55913494", "Muaná\ \-\ PA",
"55173662", "Santa\ Salete\ \-\ SP",
"55813755", "Tacaimbó\ \-\ PE",
"55863263", "Cocal\ de\ Telha\ \-\ PI",
"55623937", "Anápolis\ \-\ GO",
"55242271", "Sapucaia\ \-\ RJ",
"55493678", "Itapiranga\ \-\ SC",
"55683233", "Porto\ Acre\ \-\ AC",
"55733166", "Eunápolis\ \-\ BA",
"55383543", "Gouveia\ \-\ MG",
"55623344", "Uruana\ \-\ GO",
"55813747", "Brejo\ da\ Madre\ de\ Deus\ \-\ PE",
"55623425", "São\ Domingos\ \-\ GO",
"55123687", "Quiririm\ \-\ SP",
"55413472", "Guaratuba\ \-\ PR",
"55913756", "Moju\ \-\ PA",
"55212772", "Duque\ de\ Caxias\ \-\ RJ",
"55863362", "Cocal\ \-\ PI",
"55333336", "Simonésia\ \-\ MG",
"55833288", "Mulungu\ \-\ PB",
"555130", "Rio\ Grande\ do\ Sul",
"55143413", "Marília\ \-\ SP",
"55753285", "Rodelas\ \-\ BA",
"55993263", "Imperatriz\ \-\ MA",
"55163944", "Dumont\ \-\ SP",
"55313242", "Minas\ Gerais",
"55513252", "Rio\ Grande\ do\ Sul",
"55613532", "Brasília\ \-\ DF",
"55553338", "Nova\ Ramada\ \-\ RS",
"55513715", "Santa\ Cruz\ do\ Sul\ \-\ RS",
"55653329", "Tangará\ da\ Serra\ \-\ MT",
"55823642", "Mata\ Grande\ \-\ AL",
"55913662", "Terra\ Alta\ \-\ PA",
"55873967", "Ouricuri\ \-\ PE",
"55483211", "Florianópolis\ \-\ SC",
"55313717", "Santana\ de\ Pirapama\ \-\ MG",
"55413675", "Colombo\ \-\ PR",
"55513179", "Taquara\ \-\ RS",
"55183624", "Araçatuba\ \-\ SP",
"55863301", "Teresina\ \-\ PI",
"55463550", "Renascença\ \-\ PR",
"55673682", "Camapuã\ \-\ MS",
"55713625", "Dias\ d\'Ávila\ \-\ BA",
"55213643", "Teresópolis\ \-\ RJ",
"55273733", "Brejetuba\ \-\ ES",
"55463559", "Quedas\ do\ Iguaçu\ \-\ PR",
"55473158", "Itajaí\ \-\ SC",
"55883513", "Crato\ \-\ CE",
"5554302", "Caxias\ do\ Sul\ \-\ RS",
"55513170", "Estância\ Velha\ \-\ RS",
"55453035", "Cascavel\ \-\ PR",
"55643901", "Itumbiara\ \-\ GO",
"55113434", "São\ Paulo\ \-\ SP",
"55823281", "União\ dos\ Palmares\ \-\ AL",
"55613628", "Novo\ Gama\ \-\ GO",
"55753441", "Aporá\ \-\ BA",
"55193909", "Hortolândia\ \-\ SP",
"55153521", "Itapeva\ \-\ SP",
"5598324", "São\ Luís\ \-\ MA",
"55753629", "Conceição\ do\ Almeida\ \-\ BA",
"55453332", "Nova\ Santa\ Rosa\ \-\ PR",
"55423273", "Telêmaco\ Borba\ \-\ PR",
"55513478", "Rio\ Grande\ do\ Sul",
"55173815", "Guaraci\ \-\ SP",
"55242404", "Angra\ dos\ Reis\ \-\ RJ",
"55353221", "Varginha\ \-\ MG",
"5551320", "Rio\ Grande\ do\ Sul",
"55913346", "Ananindeua\ \-\ PA",
"55223854", "Santo\ Antônio\ de\ Pádua\ \-\ RJ",
"55473459", "São\ Francisco\ do\ Sul\ \-\ SC",
"55382101", "Montes\ Claros\ \-\ MG",
"55893442", "Alagoinha\ do\ Piauí\ \-\ PI",
"55212681", "Seropédica\ \-\ RJ",
"55673241", "Aquidauana\ \-\ MS",
"55823218", "Maceió\ \-\ AL",
"55693467", "Rondominas\ \-\ RO",
"55553784", "Chiapetta\ \-\ RS",
"55713289", "Lauro\ de\ Freitas\ \-\ BA",
"55643556", "Paraúna\ \-\ GO",
"55474003", "Blumenau\ \-\ SC",
"55114518", "Mauá\ \-\ SP",
"55663585", "Feliz\ Natal\ \-\ MT",
"55513951", "Novo\ Hamburgo\ \-\ RS",
"55773411", "Ibitira\ \-\ BA",
"55743686", "Ibipeba\ \-\ BA",
"55513372", "Rio\ Grande\ do\ Sul",
"55653211", "Cáceres\ \-\ MT",
"55513630", "Rio\ Grande\ do\ Sul",
"5511436", "São\ Bernardo\ do\ Campo\ \-\ SP",
"55773488", "Correntina\ \-\ BA",
"55553544", "Novo\ Machado\ \-\ RS",
"55513639", "São\ Vendelino\ \-\ RS",
"55353554", "São\ Pedro\ da\ União\ \-\ MG",
"55513075", "Canoas\ \-\ RS",
"55134102", "Guarujá\ \-\ SP",
"55313681", "Lagoa\ Santa\ \-\ MG",
"55843334", "Serra\ do\ Mel\ \-\ RN",
"55114162", "Barueri\ \-\ SP",
"55993646", "Lima\ Campos\ \-\ MA",
"55193487", "Santa\ Maria\ da\ Serra\ \-\ SP",
"55622765", "Goiânia\ \-\ GO",
"55443575", "Roncador\ \-\ PR",
"55222778", "Casimiro\ de\ Abreu\ \-\ RJ",
"55433545", "Curiúva\ \-\ PR",
"55513583", "Rio\ Grande\ do\ Sul",
"55413453", "Matinhos\ \-\ PR",
"55212753", "São\ João\ de\ Meriti\ \-\ RJ",
"55143324", "Ourinhos\ \-\ SP",
"55343691", "Araxá\ \-\ MG",
"55454100", "Cascavel\ \-\ PR",
"55173346", "Bebedouro\ \-\ SP",
"55623538", "Goiânia\ \-\ GO",
"55143457", "Oscar\ Bressane\ \-\ SP",
"55493247", "Lebon\ Régis\ \-\ SC",
"55913728", "Concórdia\ do\ Pará\ \-\ PA",
"55433557", "Arapoti\ \-\ PR",
"55473402", "Joinville\ \-\ SC",
"55612328", "Brasília\ \-\ DF",
"55883557", "Porteiras\ \-\ CE",
"55193566", "Analândia\ \-\ SP",
"55423639", "Foz\ do\ Jordão\ \-\ PR",
"55343972", "Uberaba\ \-\ MG",
"55473523", "Lontras\ \-\ SC",
"55453233", "Campo\ Bonito\ \-\ PR",
"55423630", "Guarapuava\ \-\ PR",
"55643632", "Jataí\ \-\ GO",
"55283518", "Cachoeiro\ de\ Itapemirim\ \-\ ES",
"55193371", "Piracicaba\ \-\ SP",
"55513743", "Candelária\ \-\ RS",
"55813648", "João\ Alfredo\ \-\ PE",
"55313753", "Rio\ Espera\ \-\ MG",
"55143642", "Barra\ Bonita\ \-\ SP",
"55313846", "Coronel\ Fabriciano\ \-\ MG",
"55433174", "Cambé\ \-\ PR",
"55883545", "Santana\ do\ Cariri\ \-\ CE",
"55693422", "Ji\-Paraná\ \-\ RO",
"55873221", "Garanhuns\ \-\ PE",
"55153268", "Boituva\ \-\ SP",
"55414009", "Curitiba\ \-\ PR",
"5516361", "Ribeirão\ Preto\ \-\ SP",
"55543341", "Getúlio\ Vargas\ \-\ RS",
"55343351", "Sacramento\ \-\ MG",
"55923365", "Novo\ Airão\ \-\ AM",
"55823033", "Maceió\ \-\ AL",
"55633355", "Miranorte\ \-\ TO",
"55414007", "Curitiba\ \-\ PR",
"55953625", "Boa\ Vista\ \-\ RR",
"55373073", "Itaúna\ \-\ MG",
"55123892", "São\ Sebastião\ \-\ SP",
"55343428", "Fronteira\ \-\ MG",
"55793194", "Aracaju\ \-\ SE",
"55733278", "Wenceslau\ Guimarães\ \-\ BA",
"55833362", "Areia\ \-\ PB",
"55733511", "Eunápolis\ \-\ BA",
"55483301", "Tubarão\ \-\ SC",
"55873828", "Tuparetama\ \-\ PE",
"55633658", "Aurora\ do\ Tocantins\ \-\ TO",
"55353693", "Pouso\ Alegre\ \-\ MG",
"55863288", "Palmeirais\ \-\ PI",
"5521271", "Niterói\ \-\ RJ",
"55753662", "Laje\ \-\ BA",
"55213032", "Rio\ de\ Janeiro\ \-\ RJ",
"55883559", "Penaforte\ \-\ CE",
"5516333", "Araraquara\ \-\ SP",
"55423637", "Nova\ Laranjeiras\ \-\ PR",
"55283535", "Presidente\ Kennedy\ \-\ ES",
"55833065", "Campina\ Grande\ \-\ PB",
"55163393", "Américo\ Brasiliense\ \-\ SP",
"55863122", "Teresina\ \-\ PI",
"55643377", "Mossâmedes\ \-\ GO",
"55114096", "São\ Paulo\ \-\ SP",
"55843533", "Afonso\ Bezerra\ \-\ RN",
"55693451", "Pimenta\ Bueno\ \-\ RO",
"55433559", "Joaquim\ Távora\ \-\ PR",
"55413562", "Colombo\ \-\ PR",
"55493249", "Campo\ Belo\ do\ Sul\ \-\ SC",
"55813699", "Panelas\ \-\ PE",
"55543394", "Santo\ Antônio\ do\ Palma\ \-\ RS",
"55553343", "Cruz\ Alta\ \-\ RS",
"55483065", "Florianópolis\ \-\ SC",
"55623515", "Goiânia\ \-\ GO",
"55333431", "Santa\ Maria\ do\ Suaçuí\ \-\ MG",
"55983678", "Pindare\ Mirim\ \-\ MA",
"55343322", "Uberaba\ \-\ MG",
"55114456", "Salto\ \-\ SP",
"55633695", "Novo\ Alegre\ \-\ TO",
"55443231", "Itambé\ \-\ PR",
"55732105", "Porto\ Seguro\ \-\ BA",
"55533921", "Pelotas\ \-\ RS",
"55273278", "Acioli\ \-\ ES",
"55553242", "Santana\ do\ Livramento\ \-\ RS",
"55513637", "Feliz\ \-\ RS",
"55663531", "Sinop\ \-\ MT",
"55313338", "Nova\ Lima\ \-\ MG",
"55473642", "Mafra\ \-\ SC",
"55613491", "Brasília\ \-\ DF",
"55183721", "Andradina\ \-\ SP",
"55683248", "Rio\ Branco\ \-\ AC",
"55114878", "Barueri\ \-\ SP",
"55273326", "Vila\ Velha\ \-\ ES",
"55483263", "Tijucas\ \-\ SC",
"55543365", "Rondinha\ \-\ RS",
"55143523", "Lins\ \-\ SP",
"55143402", "Marília\ \-\ SP",
"55912122", "Ananindeua\ \-\ PA",
"55813361", "Jaboatão\ dos\ Guararapes\ \-\ PE",
"55513310", "Rio\ Grande\ do\ Sul",
"55114535", "Jundiaí\ \-\ SP",
"55813576", "Sirinhaém\ \-\ PE",
"55713287", "Lauro\ de\ Freitas\ \-\ BA",
"55883561", "Icó\ \-\ CE",
"55843614", "Natal\ \-\ RN",
"55153552", "Apiaí\ \-\ SP",
"55473048", "Itajaí\ \-\ SC",
"55753494", "Canudos\ \-\ BA",
"55313432", "Belo\ Horizonte\ \-\ MG",
"55883423", "Limoeiro\ do\ Norte\ \-\ CE",
"5512394", "São\ José\ dos\ Campos\ \-\ SP",
"55833454", "Ibiara\ \-\ PB",
"55473457", "Barra\ Velha\ \-\ SC",
"55433561", "Conselheiro\ Mairinck\ \-\ PR",
"55173838", "Pedranópolis\ \-\ SP",
"55823235", "Maceió\ \-\ AL",
"55242223", "Petrópolis\ \-\ RJ",
"55923020", "Manaus\ \-\ AM",
"55373275", "São\ José\ da\ Varginha\ \-\ MG",
"553131", "Minas\ Gerais",
"55143308", "Fartura\ \-\ SP",
"55193907", "Amparo\ \-\ SP",
"55753627", "Sapeaçu\ \-\ BA",
"55123023", "Jacareí\ \-\ SP",
"55473445", "Garuva\ \-\ SC",
"55833263", "Lagoa\ de\ Dentro\ \-\ PB",
"55993578", "São\ Domingos\ do\ Maranhão\ \-\ MA",
"55383754", "Três\ Marias\ \-\ MG",
"55353715", "Poços\ de\ Caldas\ \-\ MG",
"55123676", "Redenção\ da\ Serra\ \-\ SP",
"55193826", "Vinhedo\ \-\ SP",
"55333723", "Jacinto\ \-\ MG",
"55933534", "Prainha\ \-\ PA",
"55414114", "Curitiba\ \-\ PR",
"55713635", "Mata\ de\ São\ João\ \-\ BA",
"55553422", "Alegrete\ \-\ RS",
"55653617", "Cuiabá\ \-\ MT",
"55273723", "Colatina\ \-\ ES",
"55513575", "São\ Leopoldo\ \-\ RS",
"55153349", "Ibiúna\ \-\ SP",
"55313884", "Minas\ Gerais",
"55413020", "Curitiba\ \-\ PR",
"55313512", "Betim\ \-\ MG",
"55313819", "Ponte\ Nova\ \-\ MG",
"55843366", "Janduís\ \-\ RN",
"55673452", "Rio\ Brilhante\ \-\ MS",
"55183634", "Birigui\ \-\ SP",
"55114081", "São\ Paulo\ \-\ SP",
"55753252", "Ruy\ Barbosa\ \-\ BA",
"55313577", "Minas\ Gerais",
"55873843", "Tacaratu\ \-\ PE",
"55443273", "Ivatuba\ \-\ PR",
"55114018", "Pinhalzinho\ \-\ SP",
"55653339", "Tangará\ da\ Serra\ \-\ MT",
"55513285", "Rio\ Grande\ do\ Sul",
"55493553", "Piratuba\ \-\ SC",
"55643496", "Aloândia\ \-\ GO",
"55163979", "Ribeirão\ Preto\ \-\ SP",
"55843281", "Nova\ Cruz\ \-\ RN",
"55683025", "Rio\ Branco\ \-\ AC",
"55613522", "Brasília\ \-\ DF",
"55163263", "Itápolis\ \-\ SP",
"55274104", "Cariacica\ \-\ ES",
"55553328", "Fortaleza\ dos\ Valos\ \-\ RS",
"55823334", "Maceió\ \-\ AL",
"55634001", "Palmas\ \-\ TO",
"55833292", "Mamanguape\ \-\ PB",
"55683322", "Cruzeiro\ do\ Sul\ \-\ AC",
"55183995", "Indiana\ \-\ SP",
"5542362", "Guarapuava\ \-\ PR",
"55242443", "Barra\ do\ Piraí\ \-\ RJ",
"55173637", "Guzolândia\ \-\ SP",
"55333326", "Santa\ Bárbara\ do\ Leste\ \-\ MG",
"55492020", "Chapecó\ \-\ SC",
"55533613", "Pedras\ Altas\ \-\ RS",
"5531346", "Minas\ Gerais",
"55192121", "Campinas\ \-\ SP",
"55544009", "Caxias\ do\ Sul\ \-\ RS",
"55853813", "São\ Paulo\ \-\ SP",
"55663488", "Santo\ Antonuio\ do\ Leste\ \-\ MT",
"55422122", "Castro\ \-\ PR",
"55773275", "Maiquinique\ \-\ BA",
"55544052", "Passo\ Fundo\ \-\ RS",
"55333511", "Itambacuri\ \-\ MG",
"55853031", "Fortaleza\ \-\ CE",
"55743644", "Itaguaçu\ da\ Bahia\ \-\ BA",
"55193795", "Campinas\ \-\ SP",
"55753693", "Pintadas\ \-\ BA",
"55483653", "Rio\ Fortuna\ \-\ SC",
"55115094", "São\ Paulo\ \-\ SP",
"55353662", "Maria\ da\ Fé\ \-\ MG",
"5583333", "Campina\ Grande\ \-\ PB",
"55733674", "Barra\ de\ Caravelas\ \-\ BA",
"55813542", "Abreu\ e\ Lima\ \-\ PE",
"55213194", "Rio\ de\ Janeiro\ \-\ RJ",
"55833393", "Fagundes\ \-\ PB",
"55343248", "Cascalho\ Rico\ \-\ MG",
"55693544", "Nova\ Mamoré\ \-\ RO",
"55613567", "Guará\ \-\ DF",
"55133406", "São\ Vicente\ \-\ SP",
"55513704", "Monte\ Alverne\ \-\ RS",
"55353068", "Varginha\ \-\ MG",
"55323691", "Juiz\ de\ Fora\ \-\ MG",
"55553276", "São\ Pedro\ do\ Sul\ \-\ RS",
"55123863", "Maresias\ \-\ SP",
"55213837", "Rio\ de\ Janeiro\ \-\ RJ",
"55953591", "Uiramutã\ \-\ RR",
"55773626", "Wanderley\ \-\ BA",
"55133211", "Santos\ \-\ SP",
"55633463", "Aragominas\ \-\ TO",
"55883448", "Parambu\ \-\ CE",
"55633521", "Brejinho\ de\ Nazaré\ \-\ TO",
"55663573", "Paranatinga\ \-\ MT",
"55323351", "Barroso\ \-\ MG",
"55943365", "Vila\ Taboca\ \-\ PA",
"55143597", "Presidente\ Alves\ \-\ SP",
"55553746", "Seberi\ \-\ RS",
"55192107", "Indaiatuba\ \-\ SP",
"55613486", "Brasília\ \-\ DF",
"55543295", "Gramado\ \-\ RS",
"55143711", "Avaré\ \-\ SP",
"55493641", "Princesa\ \-\ SC",
"55623370", "Montes\ Claros\ de\ Goiás\ \-\ GO",
"55963251", "Macapá\ \-\ AP",
"55983274", "Paço\ do\ Lumiar\ \-\ MA",
"55353843", "Ijaci\ \-\ MG",
"55673409", "Naviraí\ \-\ MS",
"55753353", "Santo\ Antônio\ de\ Jesus\ \-\ BA",
"55913637", "Melgaço\ \-\ PA",
"55163301", "Araraquara\ \-\ SP",
"55883624", "Granja\ \-\ CE",
"55543520", "Erechim\ \-\ RS",
"55353465", "Monte\ Sião\ \-\ MG",
"55813131", "Recife\ \-\ PE",
"55124242", "Cotia\ \-\ SP",
"55443639", "Umuarama\ \-\ PR",
"55623379", "Minaçu\ \-\ GO",
"55433342", "Londrina\ \-\ PR",
"55413668", "Pinhais\ \-\ PR",
"55443637", "Cianorte\ \-\ PR",
"55623377", "Formoso\ \-\ GO",
"55493354", "Marema\ \-\ SC",
"55114233", "São\ Caetano\ do\ Sul\ \-\ SP",
"55543527", "Áurea\ \-\ RS",
"55853924", "Fortaleza\ \-\ CE",
"55623312", "Itapuranga\ \-\ GO",
"55314136", "Belo\ Horizonte\ \-\ MG",
"55924009", "Manaus\ \-\ AM",
"55994102", "Imperatriz\ \-\ MA",
"55642101", "Rio\ Verde\ \-\ GO",
"55114596", "Várzea\ Paulista\ \-\ SP",
"5511369", "Osasco\ \-\ SP",
"55553304", "Santa\ Maria\ \-\ RS",
"55123974", "Paraibuna\ \-\ SP",
"55113633", "São\ Paulo\ \-\ SP",
"55623015", "Goiânia\ \-\ GO",
"55115041", "São\ Paulo\ \-\ SP",
"55113109", "Jundiaí\ \-\ SP",
"55213830", "Rio\ de\ Janeiro\ \-\ RJ",
"55313356", "Contagem\ \-\ MG",
"55793318", "Monte\ Alegre\ de\ Sergipe\ \-\ SE",
"55853382", "Maracanaú\ \-\ CE",
"55833565", "João\ Pessoa\ \-\ PB",
"55733682", "Teixeira\ de\ Freitas\ \-\ BA",
"55823296", "Maragogi\ \-\ AL",
"55733011", "Teixeira\ de\ Freitas\ \-\ BA",
"55423231", "Carambeí\ \-\ PR",
"55623481", "Posse\ \-\ GO",
"55933736", "Munguba\ \-\ PA",
"55793266", "Santo\ Amaro\ das\ Brotas\ \-\ SE",
"55343841", "Coromandel\ \-\ MG",
"55222644", "Cabo\ Frio\ \-\ RJ",
"55213839", "Rio\ de\ Janeiro\ \-\ RJ",
"55323322", "Nazareno\ \-\ MG",
"55793615", "Simão\ Dias\ \-\ SE",
"55823533", "Jaramataia\ \-\ AL",
"55643515", "Itumbiara\ \-\ GO",
"55623920", "Goiânia\ \-\ GO",
"55323025", "Juiz\ de\ Fora\ \-\ MG",
"55493665", "Iraceminha\ \-\ SC",
"55953086", "Boa\ Vista\ \-\ RR",
"55963323", "Macapá\ \-\ AP",
"55213762", "Nilópolis\ \-\ RJ",
"55544007", "Caxias\ do\ Sul\ \-\ RS",
"55173639", "Populina\ \-\ SP",
"55633509", "Dianópolis\ \-\ TO",
"55943341", "Bom\ Jesus\ do\ Tocantins\ \-\ PA",
"55453271", "Sede\ Alvorada\ \-\ PR",
"55993078", "Caxias\ \-\ MA",
"55693343", "Corumbiara\ \-\ RO",
"55353441", "Ouro\ Fino\ \-\ MG",
"55323367", "Alfredo\ Vasconcelos\ \-\ MG",
"55353629", "Itajubá\ \-\ MG",
"55113152", "São\ Paulo\ \-\ SP",
"55613906", "Luziânia\ \-\ GO",
"55113514", "São\ Paulo\ \-\ SP",
"55513191", "Portão\ \-\ RS",
"55114035", "Bragança\ Paulista\ \-\ SP",
"55653337", "Diamantino\ \-\ MT",
"55163041", "Sertãozinho\ \-\ SP",
"55313570", "Minas\ Gerais",
"55313872", "Abre\ Campo\ \-\ MG",
"55163977", "Ribeirão\ Preto\ \-\ SP",
"55313579", "Aranha\ \-\ MG",
"55433305", "Londrina\ \-\ PR",
"55153355", "Angatuba\ \-\ SP",
"55153492", "Salto\ de\ Pirapora\ \-\ SP",
"55513728", "Rio\ Grande\ do\ Sul",
"55383632", "Santa\ Fé\ de\ Minas\ \-\ MG",
"55713681", "Vera\ Cruz\ \-\ BA",
"55843235", "Natal\ \-\ RN",
"55613551", "Brasília\ \-\ DF",
"55313817", "Ponte\ Nova\ \-\ MG",
"55313289", "Minas\ Gerais",
"55983383", "São\ Bento\ \-\ MA",
"55653619", "Cuiabá\ \-\ MT",
"55473334", "Blumenau\ \-\ SC",
"55193405", "Americana\ \-\ SP",
"55663463", "Primavera\ do\ Leste\ \-\ MT",
"55153275", "Itapetininga\ \-\ SP",
"55333733", "Itinga\ \-\ MG",
"55193836", "Vinhedo\ \-\ SP",
"55613381", "Guará\ \-\ DF",
"55933524", "Santarém\ \-\ PA",
"55193661", "Espírito\ Santo\ do\ Pinhal\ \-\ SP",
"55773021", "Barreiras\ \-\ BA",
"55423662", "Paz\ \-\ PR",
"5511310", "São\ Paulo\ \-\ SP",
"55163835", "Miguelópolis\ \-\ SP",
"55513494", "Itapuã\ \-\ RS",
"55163406", "Franca\ \-\ SP",
"55923030", "Manaus\ \-\ AM",
"55863393", "Luzilândia\ \-\ PI",
"55243370", "Angra\ dos\ Reis\ \-\ RJ",
"55114603", "Bragança\ Paulista\ \-\ SP",
"55833684", "Serra\ da\ Raiz\ \-\ PB",
"55113359", "São\ Paulo\ \-\ SP",
"55883433", "Aracati\ \-\ CE",
"55243379", "Angra\ dos\ Reis\ \-\ RJ",
"55923675", "Manaus\ \-\ AM",
"55513054", "Viamão\ \-\ RS",
"55553884", "Dona\ Otília\ \-\ RS",
"55553512", "Santa\ Rosa\ \-\ RS",
"55152108", "Tietê\ \-\ SP",
"55713717", "Camaçari\ \-\ BA",
"55433433", "Ariranha\ do\ Ivaí\ \-\ PR",
"55114130", "São\ Roque\ \-\ SP",
"55313625", "Ribeirão\ das\ Neves\ \-\ MG",
"55993541", "Balsas\ \-\ MA",
"55143533", "Lins\ \-\ SP",
"55743162", "Juazeiro\ \-\ BA",
"55643543", "Cezarina\ \-\ GO",
"55193602", "São\ João\ da\ Boa\ Vista\ \-\ SP",
"55443568", "Mamborê\ \-\ PR",
"55112836", "São\ Paulo\ \-\ SP",
"55893489", "Conceição\ do\ Canindé\ \-\ PI",
"55513627", "Imbé\ \-\ RS",
"55663521", "Alta\ Floresta\ \-\ MT",
"55112661", "São\ Paulo\ \-\ SP",
"55893480", "Socorro\ do\ Piauí\ \-\ PI",
"55793643", "Riachão\ do\ Dantas\ \-\ SE",
"55463057", "Francisco\ Beltrão\ \-\ PR",
"55143296", "Arealva\ \-\ SP",
"55222765", "Macaé\ \-\ RJ",
"55313328", "Minas\ Gerais",
"55113408", "Itatiba\ \-\ SP",
"55463243", "Mangueirinha\ \-\ PR",
"5531328", "Belo\ Horizonte\ \-\ MG",
"55533931", "Rio\ Grande\ \-\ RS",
"55643651", "Quirinópolis\ \-\ GO",
"55733241", "Coaraci\ \-\ BA",
"55173353", "São\ José\ do\ Rio\ Preto\ \-\ SP",
"55543037", "Carlos\ Barbosa\ \-\ RS",
"55313276", "Minas\ Gerais",
"55343332", "Uberaba\ \-\ MG",
"5511467", "Ferraz\ de\ Vasconcelos\ \-\ SP",
"55813080", "Jaboatão\ dos\ Guararapes\ \-\ PE",
"55113576", "São\ Paulo\ \-\ SP",
"55513662", "Santo\ Antônio\ da\ Patrulha\ \-\ RS",
"55242438", "Conservatória\ \-\ RJ",
"55173209", "São\ José\ do\ Rio\ Preto\ \-\ SP",
"55843523", "Alto\ do\ Rodrigues\ \-\ RN",
"55183376", "Cruzália\ \-\ SP",
"55114686", "São\ Lourenço\ da\ Serra\ \-\ SP",
"55333421", "Guanhães\ \-\ MG",
"55113361", "São\ Paulo\ \-\ SP",
"55273771", "São\ Mateus\ \-\ ES",
"55793224", "Aracaju\ \-\ SE",
"55513465", "Canoas\ \-\ RS",
"55283525", "Jaciguá\ \-\ ES",
"55633488", "Praia\ Norte\ \-\ TO",
"55443554", "Assis\ Chateaubriand\ \-\ PR",
"55663507", "Simione\ \-\ MT",
"55513601", "Osório\ \-\ RS",
"55183502", "Adamantina\ \-\ SP",
"55873838", "Afogados\ da\ Ingazeira\ \-\ PE",
"55313853", "Bela\ Vista\ de\ Minas\ \-\ MG",
"55843605", "Natal\ \-\ RN",
"55863292", "Amarante\ \-\ PI",
"55313746", "Piranga\ \-\ MG",
"55223056", "Campos\ dos\ Goytacazes\ \-\ RJ",
"55513756", "Anta\ Gorda\ \-\ RS",
"55173693", "São\ Francisco\ \-\ SP",
"55193399", "Sumaré\ \-\ SP",
"55323535", "Divinésia\ \-\ MG",
"55343415", "Iturama\ \-\ MG",
"55673473", "Eldorado\ \-\ MS",
"55543472", "São\ Valentim\ do\ Sul\ \-\ RS",
"55993565", "Formosa\ da\ Serra\ Negra\ \-\ MA",
"55112657", "Guarulhos\ \-\ SP",
"55383504", "Paracatu\ \-\ MG",
"55623303", "Montes\ Claros\ de\ Goiás\ \-\ GO",
"55323271", "Bicas\ \-\ MG",
"55693432", "Rolim\ de\ Moura\ \-\ RO",
"55813434", "Paulista\ \-\ PE",
"55493572", "Matos\ Costa\ \-\ SC",
"55643622", "Rio\ Verde\ \-\ GO",
"55733294", "Itamaraju\ \-\ BA",
"55222741", "São\ João\ da\ Barra\ \-\ RJ",
"55193024", "Rio\ Claro\ \-\ SP",
"55773664", "Paratinga\ \-\ BA",
"55115818", "São\ Paulo\ \-\ SP",
"55793522", "Estância\ \-\ SE",
"55663500", "Primavera\ do\ Leste\ \-\ MT",
"55713205", "Salvador\ \-\ BA",
"55473533", "Ituporanga\ \-\ SC",
"55443252", "Nova\ Esperança\ \-\ PR",
"55543378", "Ernestina\ \-\ RS",
"55633374", "Figueirópolis\ \-\ TO",
"55913738", "Km\ 12\ \-\ PA",
"55163986", "Luís\ Antônio\ \-\ SP",
"55623528", "Caturaí\ \-\ GO",
"55343612", "Araxá\ \-\ MG",
"55813671", "Ribeirão\ \-\ PE",
"55114443", "Franco\ da\ Rocha\ \-\ SP",
"55743535", "Remanso\ \-\ BA",
"55323741", "Carangola\ \-\ MG",
"55193657", "Tapiratiba\ \-\ SP",
"55973345", "Alvarães\ \-\ AM",
"5531381", "Minas\ Gerais",
"55353346", "Cruzília\ \-\ MG",
"55553356", "Bossoroca\ \-\ RS",
"55853463", "Fortaleza\ \-\ CE",
"55623386", "Faina\ \-\ GO",
"55673278", "Rio\ Negro\ \-\ MS",
"55513629", "Rio\ Grande\ do\ Sul",
"55773658", "Ibitiara\ \-\ BA",
"55213604", "Niterói\ \-\ RJ",
"55183821", "Dracena\ \-\ SP",
"55114894", "Itatiba\ \-\ SP",
"55413539", "Campo\ Largo\ \-\ PR",
"55513441", "Cachoeirinha\ \-\ RS",
"55273265", "Rio\ Bananal\ \-\ ES",
"55115646", "São\ Paulo\ \-\ SP",
"55483330", "Florianópolis\ \-\ SC",
"55513620", "Rio\ Grande\ do\ Sul",
"55983368", "Primeira\ Cruz\ \-\ MA",
"55893487", "Paulistana\ \-\ PI",
"55773492", "Presidente\ Jânio\ Quadros\ \-\ BA",
"5511597", "São\ Paulo\ \-\ SP",
"55794002", "Aracaju\ \-\ SE",
"55114137", "Taboão\ da\ Serra\ \-\ SP",
"55613479", "Brazlândia\ \-\ DF",
"55123413", "Taubaté\ \-\ SP",
"55773695", "Tanque\ Novo\ \-\ BA",
"55243377", "Angra\ dos\ Reis\ \-\ RJ",
"55113357", "São\ Paulo\ \-\ SP",
"55733265", "Itororó\ \-\ BA",
"55443209", "Nova\ Esperança\ \-\ PR",
"55373521", "Bom\ Despacho\ \-\ MG",
"55672105", "Três\ Lagoas\ \-\ MS",
"55163818", "São\ Joaquim\ da\ Barra\ \-\ SP",
"55893566", "Redenção\ do\ Gurguéia\ \-\ PI",
"55183557", "Salmourão\ \-\ SP",
"55163725", "Franca\ \-\ SP",
"55653541", "Colíder\ \-\ MT",
"55553289", "Vale\ Vêneto\ \-\ RS",
"55613335", "São\ Sebastião\ \-\ DF",
"55983462", "Cantanhede\ \-\ MA",
"55663552", "Guarantã\ do\ Norte\ \-\ MT",
"55413606", "Colombo\ \-\ PR",
"55153531", "Itararé\ \-\ SP",
"55753639", "Santa\ Teresinha\ \-\ BA",
"55854062", "Fortaleza\ \-\ CE",
"55823597", "Maceió\ \-\ AL",
"55113988", "Guarulhos\ \-\ SP",
"55453322", "Cascavel\ \-\ PR",
"55713003", "Salvador\ \-\ BA",
"55733616", "Itabuna\ \-\ BA",
"55453025", "Foz\ do\ Iguaçu\ \-\ PR",
"55643667", "Arenópolis\ \-\ GO",
"55843642", "Natal\ \-\ RN",
"55113424", "São\ Bernardo\ do\ Campo\ \-\ SP",
"55933222", "Santarém\ \-\ PA",
"55222101", "Campos\ dos\ Goytacazes\ \-\ RJ",
"55973481", "Eirunepé\ \-\ AM",
"55913284", "Ananindeua\ \-\ PA",
"55472106", "Jaraguá\ do\ Sul\ \-\ SC",
"55613308", "Planaltina\ \-\ DF",
"55483536", "Timbé\ do\ Sul\ \-\ SC",
"55553423", "Quaraí\ \-\ RS",
"55623589", "Goiânia\ \-\ GO",
"55323251", "Santos\ Dumont\ \-\ MG",
"55273722", "Colatina\ \-\ ES",
"55313116", "Belo\ Horizonte\ \-\ MG",
"55543395", "Viadutos\ \-\ RS",
"55543452", "Bento\ Gonçalves\ \-\ RS",
"55443582", "Guaiporã\ \-\ PR",
"55623514", "Inhumas\ \-\ GO",
"55673453", "Caarapó\ \-\ MS",
"55873842", "Ibimirim\ \-\ PE",
"55983374", "Santa\ Luzia\ do\ Paruá\ \-\ MA",
"55443272", "Fênix\ \-\ PR",
"55613605", "Cidade\ Ocidental\ \-\ GO",
"55493552", "Lacerdópolis\ \-\ SC",
"55613461", "Ceilândia\ \-\ DF",
"55112612", "São\ Paulo\ \-\ SP",
"55433242", "Bela\ Vista\ do\ Paraíso\ \-\ PR",
"55653026", "Várzea\ Grande\ \-\ MT",
"55163262", "Itápolis\ \-\ SP",
"55733537", "Ibirataia\ \-\ BA",
"55683267", "Vila\ Campinas\ \(Pad\ Peixoto\)\ \-\ AC",
"55643089", "Itumbiara\ \-\ GO",
"55953624", "Boa\ Vista\ \-\ RR",
"5583323", "João\ Pessoa\ \-\ PB",
"55643014", "Jataí\ \-\ GO",
"55242442", "Barra\ do\ Piraí\ \-\ RJ",
"55633354", "Cristalândia\ \-\ TO",
"55543358", "Lagoa\ Vermelha\ \-\ RS",
"55853877", "Fortaleza\ \-\ CE",
"55833293", "Lucena\ \-\ PB",
"55283534", "Anchieta\ \-\ ES",
"55633427", "Pequizeiro\ \-\ TO",
"5571349", "Salvador\ \-\ BA",
"5515301", "Sorocaba\ \-\ SP",
"55713433", "Salvador\ \-\ BA",
"55143491", "Tupã\ \-\ SP",
"55123224", "Caçapava\ \-\ SP",
"55553376", "Panambi\ \-\ RS",
"55433717", "Londrina\ \-\ PR",
"55833133", "João\ Pessoa\ \-\ PB",
"55124448", "Cajamar\ \-\ SP",
"55873789", "Brejão\ \-\ PE",
"55813651", "Passira\ \-\ PE",
"55833536", "Santa\ Cruz\ \-\ PB",
"55843412", "Currais\ Novos\ \-\ RN",
"55753692", "Paulo\ Afonso\ \-\ BA",
"55483652", "Grão\ Pará\ \-\ SC",
"55373274", "Papagaios\ \-\ MG",
"55553228", "Boca\ do\ Monte\ \-\ RS",
"55383747", "Paredão\ de\ Minas\ \-\ MG",
"55173284", "Ribeiro\ dos\ Santos\ \-\ SP",
"55823234", "Maceió\ \-\ AL",
"55813543", "Igarassu\ \-\ PE",
"55773678", "Botuporã\ \-\ BA",
"55143604", "Barra\ Bonita\ \-\ SP",
"55833455", "Santana\ de\ Mangueira\ \-\ PB",
"55833392", "Queimadas\ \-\ PB",
"55673258", "Taunay\ \-\ MS",
"55153115", "Boituva\ \-\ SP",
"55163171", "Pedregulho\ \-\ SP",
"55353663", "Pedralva\ \-\ MG",
"55123862", "São\ Sebastião\ \-\ SP",
"55383755", "Morada\ Nova\ de\ Minas\ \-\ MG",
"55843477", "Ouro\ Branco\ \-\ RN",
"55353714", "Poços\ de\ Caldas\ \-\ MG",
"55833447", "Belém\ do\ Brejo\ do\ Cruz\ \-\ PB",
"55473444", "São\ Francisco\ do\ Sul\ \-\ SC",
"551137", "São\ Paulo\ \-\ SP",
"55493636", "São\ João\ do\ Oeste\ \-\ SC",
"55613459", "Samambaia\ Sul\ \-\ DF",
"55113418", "Taboão\ da\ Serra\ \-\ SP",
"55212634", "Maricá\ \-\ RJ",
"55773439", "Encruzilhada\ \-\ BA",
"55663572", "Nova\ Bandeirantes\ \-\ MT",
"55153249", "Ibiúna\ \-\ SP",
"55713198", "Salvador\ \-\ BA",
"55483447", "Cocal\ do\ Sul\ \-\ SC",
"55833058", "Campina\ Grande\ \-\ PB",
"55673295", "São\ Gabriel\ do\ Oeste\ \-\ MS",
"55614003", "Brasília\ \-\ DF",
"55313387", "Minas\ Gerais",
"55843266", "Pureza\ \-\ RN",
"55243357", "Resende\ \-\ RJ",
"55273767", "São\ Mateus\ \-\ ES",
"55113377", "São\ Paulo\ \-\ SP",
"55833498", "Serra\ Grande\ \-\ PB",
"55493802", "Lages\ \-\ SC",
"55513688", "Rio\ Grande\ do\ Sul",
"55773430", "Caatiba\ \-\ BA",
"55353842", "Nazareno\ \-\ MG",
"55853104", "Fortaleza\ \-\ CE",
"55114534", "Itatiba\ \-\ SP",
"55663517", "Sinop\ \-\ MT",
"55513611", "Chuvisca\ \-\ RS",
"55114066", "Diadema\ \-\ SP",
"55433343", "Londrina\ \-\ PR",
"55553559", "Braga\ \-\ RS",
"55843381", "Alexandria\ \-\ RN",
"55313634", "Santa\ Luzia\ \-\ MG",
"55543364", "Ronda\ Alta\ \-\ RS",
"55633368", "Pium\ \-\ TO",
"55183287", "Campinal\ \-\ SP",
"55663510", "Juara\ \-\ MT",
"55663584", "Sorriso\ \-\ MT",
"55613642", "Formosa\ \-\ GO",
"55312136", "Ipatinga\ \-\ MG",
"55553557", "Coronel\ Bicaco\ \-\ RS",
"55543733", "Caxias\ do\ Sul\ \-\ RS",
"55183289", "Tarabai\ \-\ SP",
"55843638", "Rio\ do\ Fogo\ \-\ RN",
"55153255", "Angatuba\ \-\ SP",
"55183872", "Ouro\ Verde\ \-\ SP",
"55313389", "Belo\ Horizonte\ \-\ MG",
"55843335", "Ipanguaçu\ \-\ RN",
"55353555", "Guaranésia\ \-\ MG",
"55413134", "São\ José\ dos\ Pinhais\ \-\ PR",
"55553545", "Porto\ Mauá\ \-\ RS",
"55273769", "Jaguaré\ \-\ ES",
"55113379", "Jundiaí\ \-\ SP",
"55343661", "Araxá\ \-\ MG",
"55153247", "Votorantim\ \-\ SP",
"55893428", "Santa\ Rosa\ do\ Piauí\ \-\ PI",
"55613048", "Taguatinga\ \-\ DF",
"55773437", "Belo\ Campo\ \-\ BA",
"55343836", "São\ João\ da\ Serra\ Negra\ \-\ MG",
"55313380", "Minas\ Gerais",
"55413063", "Curitiba\ \-\ PR",
"55423246", "Caetano\ Mendes\ \-\ PR",
"55833449", "Riacho\ dos\ Cavalos\ \-\ PB",
"5531380", "Minas\ Gerais",
"55933518", "Itaituba\ \-\ PA",
"55173272", "Tanabi\ \-\ SP",
"55753321", "Feira\ de\ Santana\ \-\ BA",
"55853383", "Maracanaú\ \-\ CE",
"55223847", "Raposo\ \-\ RJ",
"55113435", "Guarulhos\ \-\ SP",
"55733683", "Guarani\ \-\ BA",
"55153298", "Pilar\ do\ Sul\ \-\ SP",
"55833440", "Brejo\ dos\ Santos\ \-\ PB",
"55843479", "Carnaúba\ dos\ Dantas\ \-\ RN",
"5575", "Bahia",
"55173889", "Altair\ \-\ SP",
"55553785", "Inhacorá\ \-\ RS",
"55383740", "Pirapora\ \-\ MG",
"55323323", "São\ João\ Del\ Rei\ \-\ MG",
"55142106", "Bauru\ \-\ SP",
"55493316", "Chapecó\ \-\ SC",
"55323267", "São\ João\ Nepomuceno\ \-\ MG",
"55173814", "Adolfo\ \-\ SP",
"55383749", "Pirapora\ \-\ MG",
"55212380", "Rio\ de\ Janeiro\ \-\ RJ",
"55863239", "Santo\ Antônio\ dos\ Milagres\ \-\ PI",
"55213763", "Mesquita\ \-\ RJ",
"55873787", "Paranatama\ \-\ PE",
"55674007", "Campo\ Grande\ \-\ MS",
"55373383", "Carmo\ da\ Mata\ \-\ MG",
"55963322", "Pedra\ Branca\ do\ Amaparí\ \-\ AP",
"55493521", "Joaçaba\ \-\ SC",
"55633429", "Muricilândia\ \-\ TO",
"55643671", "São\ Luís\ de\ Montes\ Belos\ \-\ GO",
"55793366", "Brejo\ Grande\ \-\ SE",
"55123522", "Pindamonhangaba\ \-\ SP",
"55923364", "Caapiranga\ \-\ AM",
"55973379", "Novo\ Aripuanã\ \-\ AM",
"55273751", "Mucurici\ \-\ ES",
"55733530", "Entroncamento\ de\ Jaguaquara\ \-\ BA",
"55323222", "Juiz\ de\ Fora\ \-\ MG",
"55693342", "Cerejeiras\ \-\ RO",
"55183356", "Echaporã\ \-\ SP",
"55813344", "Recife\ \-\ PE",
"55983488", "Santana\ do\ Maranhão\ \-\ MA",
"55113153", "São\ Paulo\ \-\ SP",
"55623466", "Vila\ Boa\ \-\ GO",
"55793281", "Laranjeiras\ \-\ SE",
"55543421", "Gramado\ \-\ RS",
"55733539", "Itagi\ \-\ BA",
"55533035", "Rio\ Grande\ \-\ RS",
"55883544", "Farias\ Brito\ \-\ CE",
"55113556", "São\ Paulo\ \-\ SP",
"55643087", "Itumbiara\ \-\ GO",
"55143325", "Ourinhos\ \-\ SP",
"55353436", "Toledo\ \-\ MG",
"55313873", "Matipó\ \-\ MG",
"55623277", "Aparecida\ de\ Goiânia\ \-\ GO",
"55493254", "Ponte\ Alta\ do\ Norte\ \-\ SC",
"55433544", "Santa\ Amélia\ \-\ PR",
"55183696", "Turiúba\ \-\ SP",
"55673562", "Chapadão\ do\ Sul\ \-\ MS",
"55622764", "Goiânia\ \-\ GO",
"55243302", "Petrópolis\ \-\ RJ",
"55813622", "Carpina\ \-\ PE",
"55383633", "Ubaí\ \-\ MG",
"55853306", "Fortaleza\ \-\ CE",
"5511439", "São\ Bernardo\ do\ Campo\ \-\ SP",
"55143022", "Avaré\ \-\ SP",
"55173426", "Votuporanga\ \-\ SP",
"55222222", "Nova\ Friburgo\ \-\ RJ",
"55693448", "Ministro\ Andreazza\ \-\ RO",
"55983382", "Santa\ Helena\ \-\ MA",
"55643434", "Cachoeira\ Dourada\ \-\ GO",
"55273125", "Guarapari\ \-\ ES",
"55443219", "Maringá\ \-\ PR",
"55513776", "Relvado\ \-\ RS",
"55623587", "Aparecida\ de\ Goiânia\ \-\ GO",
"55273341", "Serra\ \-\ ES",
"55112841", "São\ Paulo\ \-\ SP",
"55333732", "Comercinho\ \-\ MG",
"55893456", "Simões\ \-\ PI",
"55873948", "Bom\ Nome\ \-\ PE",
"55183746", "Pereira\ Barreto\ \-\ SP",
"55453269", "Vila\ Nova\ \-\ PR",
"55513933", "Gravataí\ \-\ RS",
"55453260", "Missal\ \-\ PR",
"55423663", "Palmeirinha\ \-\ PR",
"55623357", "Uruaçu\ \-\ GO",
"55953238", "Rorainópolis\ \-\ RR",
"55333527", "Ouro\ Verde\ de\ Minas\ \-\ MG",
"55342109", "Araguari\ \-\ MG",
"55793445", "Carira\ \-\ SE",
"55133227", "Santos\ \-\ SP",
"55114602", "Salto\ \-\ SP",
"55313809", "Santa\ Bárbara\ \-\ MG",
"55553513", "Santa\ Rosa\ \-\ RS",
"55883432", "Icapuí\ \-\ CE",
"55953198", "Boa\ Vista\ \-\ RR",
"55993536", "Governador\ Edison\ Lobão\ \-\ MA",
"55793457", "Macambira\ \-\ SE",
"55623988", "Goiânia\ \-\ GO",
"55313561", "Itabirito\ \-\ MG",
"5544", "Paraná",
"55183586", "Mariápolis\ \-\ SP",
"55114405", "Piracaia\ \-\ SP",
"55433432", "Jandaia\ do\ Sul\ \-\ PR",
"55114661", "Embu\-Guaçu\ \-\ SP",
"55313376", "Belo\ Horizonte\ \-\ MG",
"55883635", "Irauçuba\ \-\ CE",
"55214503", "Rio\ de\ Janeiro\ \-\ RJ",
"55143532", "Lins\ \-\ SP",
"55173253", "Mirassol\ \-\ SP",
"55193841", "Mogi\-Guaçu\ \-\ SP",
"55343232", "Uberlândia\ \-\ MG",
"55373553", "Estrela\ do\ Indaiá\ \-\ MG",
"55643542", "Itumbiara\ \-\ GO",
"55183276", "Piquerobi\ \-\ SP",
"55633572", "Palmas\ \-\ TO",
"55663401", "Barra\ do\ Garças\ \-\ MT",
"55913692", "Gurupá\ \-\ PA",
"55319", "Minas\ Gerais",
"55793642", "Colônia\ Treze\ \-\ SE",
"55513789", "Boqueirão\ do\ Leão\ \-\ RS",
"5511267", "São\ Paulo\ \-\ SP",
"55133201", "Santos\ \-\ SP",
"55453251", "Ouro\ Verde\ do\ Oeste\ \-\ PR",
"55313731", "Congonhas\ \-\ MG",
"55463242", "Chopinzinho\ \-\ PR",
"55633383", "Cariri\ do\ Tocantins\ \-\ TO",
"55113117", "São\ Paulo\ \-\ SP",
"55812129", "Recife\ \-\ PE",
"55143762", "Taquarituba\ \-\ SP",
"55513714", "Lajeado\ \-\ RS",
"55513780", "Rio\ Grande\ do\ Sul",
"55383690", "Montes\ Claros\ \-\ MG",
"55133416", "Ana\ Dias\ \-\ SP",
"55843737", "Parnamirim\ \-\ RN",
"55343333", "Uberaba\ \-\ MG",
"55713624", "Camaçari\ \-\ BA",
"55513663", "Osório\ \-\ RS",
"55163482", "Cravinhos\ \-\ SP",
"55843522", "Pendências\ \-\ RN",
"55413674", "Tijucas\ do\ Sul\ \-\ PR",
"55183625", "Araçatuba\ \-\ SP",
"55113303", "São\ Bernardo\ do\ Campo\ \-\ SP",
"55863133", "Teresina\ \-\ PI",
"55473234", "Blumenau\ \-\ SC",
"55673484", "Caarapó\ \-\ MS",
"55513549", "Igrejinha\ \-\ RS",
"55823628", "Monteirópolis\ \-\ AL",
"55163311", "Araraquara\ \-\ SP",
"55673410", "Dourados\ \-\ MS",
"55313559", "Ouro\ Preto\ \-\ MG",
"55673419", "Angélica\ \-\ MS",
"55313550", "Minas\ Gerais",
"55513540", "Rio\ Grande\ do\ Sul",
"55143656", "Torrinha\ \-\ SP",
"55163957", "Ibitiúva\ \-\ SP",
"55313852", "João\ Monlevade\ \-\ MG",
"55663427", "Rondonópolis\ \-\ MT",
"55183422", "Assis\ \-\ SP",
"55553387", "Ajuricaba\ \-\ RS",
"55613366", "Brasília\ \-\ DF",
"55893535", "Manoel\ Emídio\ \-\ PI",
"55863293", "Regeneração\ \-\ PI",
"55192117", "Campinas\ \-\ SP",
"55733236", "Una\ \-\ BA",
"55493908", "Fraiburgo\ \-\ SC",
"55173692", "Santana\ da\ Ponte\ Pensa\ \-\ SP",
"55913464", "Atalaia\ \-\ PA",
"55163945", "Sertãozinho\ \-\ SP",
"55753284", "Macururé\ \-\ BA",
"55613218", "Brasília\ \-\ DF",
"55553314", "Santo\ Ângelo\ \-\ RS",
"55114645", "Itaquaquecetuba\ \-\ SP",
"55443464", "São\ Pedro\ do\ Paraná\ \-\ PR",
"55753217", "Santo\ Amaro\ \-\ BA",
"55133036", "Santos\ \-\ SP",
"55993621", "Bacabal\ \-\ MA",
"55623302", "Jussara\ \-\ GO",
"55353331", "São\ Lourenço\ \-\ MG",
"55192119", "Hortolândia\ \-\ SP",
"55513555", "Rio\ Grande\ do\ Sul",
"55313545", "Rio\ Acima\ \-\ MG",
"55943431", "Santana\ do\ Araguaia\ \-\ PA",
"55733668", "Trancoso\ \-\ BA",
"55493573", "Calmon\ \-\ SC",
"55114657", "Santa\ Isabel\ \-\ SP",
"55643623", "Rio\ Verde\ \-\ GO",
"55443253", "Maringá\ \-\ PR",
"55482102", "Criciúma\ \-\ SC",
"55753272", "Tucano\ \-\ BA",
"55313557", "Mariana\ \-\ MG",
"55193865", "Hortolândia\ \-\ SP",
"55513547", "Rolante\ \-\ RS",
"55793461", "Pinhão\ \-\ SE",
"55483239", "Florianópolis\ \-\ SC",
"55843224", "Natal\ \-\ RN",
"55423436", "Imbituva\ \-\ PR",
"55513598", "Campo\ Bom\ \-\ RS",
"55373354", "Japaraíba\ \-\ MG",
"55983268", "São\ Luís\ \-\ MA",
"55543326", "Campos\ Borges\ \-\ RS",
"55113184", "Osasco\ \-\ SP",
"55114024", "Itu\ \-\ SP",
"55623361", "Itapaci\ \-\ GO",
"55483199", "Tubarão\ \-\ SC",
"55673675", "Tacuru\ \-\ MS",
"55114442", "Caieiras\ \-\ SP",
"55223087", "Macaé\ \-\ RJ",
"55513787", "Pinheiral\ \-\ RS",
"55853462", "Fortaleza\ \-\ CE",
"55463544", "Enéas\ Marques\ \-\ PR",
"55543511", "Vacaria\ \-\ RS",
"55543278", "Canela\ \-\ RS",
"55153546", "Buri\ \-\ SP",
"55222566", "Bom\ Jardim\ \-\ RJ",
"55693238", "Buritis\ \-\ RO",
"55753426", "Rio\ Real\ \-\ BA",
"55533248", "Pinheiro\ Machado\ \-\ RS",
"5592364", "Manaus\ \-\ AM",
"55673226", "Ladário\ \-\ MS",
"55983521", "Caxias\ \-\ MA",
"5591", "Pará",
"55773493", "Guanambi\ \-\ BA",
"55633519", "Lajeado\ \-\ TO",
"55794003", "Aracaju\ \-\ SE",
"55553256", "Manoel\ Viana\ \-\ RS",
"55112894", "São\ Paulo\ \-\ SP",
"55812101", "Recife\ \-\ PE",
"55433618", "Ibaiti\ \-\ PR",
"55793459", "Pedra\ Mole\ \-\ SE",
"55542105", "Bento\ Gonçalves\ \-\ RS",
"55333295", "Virgolândia\ \-\ MG",
"55493382", "Xanxerê\ \-\ SC",
"55663553", "Juruena\ \-\ MT",
"55323371", "São\ João\ Del\ Rei\ \-\ MG",
"55193894", "Indaiatuba\ \-\ SP",
"55193778", "Campinas\ \-\ SP",
"55473396", "Brusque\ \-\ SC",
"55983463", "Itapecuru\ Mirim\ \-\ MA",
"55163902", "Ribeirão\ Preto\ \-\ SP",
"55373216", "Divinópolis\ \-\ MG",
"55753161", "Feira\ de\ Santana\ \-\ BA",
"55185871", "Panorama\ \-\ SP",
"55453323", "Cascavel\ \-\ PR",
"55623359", "Jesúpolis\ \-\ GO",
"55443055", "Umuarama\ \-\ PR",
"55433315", "Londrina\ \-\ PR",
"55333529", "Teófilo\ Otoni\ \-\ MG",
"55513436", "Viamão\ \-\ RS",
"55115631", "São\ Paulo\ \-\ SP",
"5517321", "São\ José\ do\ Rio\ Preto\ \-\ SP",
"55963271", "Mazagão\ \-\ AP",
"55443352", "Santo\ Inácio\ \-\ PR",
"55843643", "Parnamirim\ \-\ RN",
"55453267", "Vera\ Cruz\ do\ Oeste\ \-\ PR",
"55663522", "São\ Félix\ do\ Araguaia\ \-\ MT",
"55613411", "Brasília\ \-\ DF",
"55123104", "Aparecida\ \-\ SP",
"55112662", "São\ Paulo\ \-\ SP",
"55114789", "Jandira\ \-\ SP",
"55643609", "Itumbiara\ \-\ GO",
"55413721", "Paranaguá\ \-\ PR",
"5521375", "São\ João\ de\ Meriti\ \-\ RJ",
"55193601", "Americana\ \-\ SP",
"55193843", "Itapira\ \-\ SP",
"55333746", "Rubim\ \-\ MG",
"55212649", "Cachoeiras\ de\ Macacu\ \-\ RJ",
"55673289", "Rochedo\ \-\ MS",
"55373551", "Dores\ do\ Indaiá\ \-\ MG",
"55883446", "Aracati\ \-\ CE",
"55214501", "Rio\ de\ Janeiro\ \-\ RJ",
"5511316", "São\ Paulo\ \-\ SP",
"55352107", "Poços\ de\ Caldas\ \-\ MG",
"55993542", "Balsas\ \-\ MA",
"55173251", "São\ José\ do\ Rio\ Preto\ \-\ SP",
"55443323", "Colorado\ \-\ PR",
"55114663", "Embu\-Guaçu\ \-\ SP",
"55314115", "Lagoa\ Santa\ \-\ MG",
"55673579", "Selvíria\ \-\ MS",
"55383824", "Rio\ Pardo\ de\ Minas\ \-\ MG",
"55453055", "Toledo\ \-\ PR",
"55483014", "São\ João\ Batista\ \-\ SC",
"55753414", "Cachoeira\ \-\ BA",
"55553748", "Erval\ Seco\ \-\ RS",
"55383227", "Brasília\ de\ Minas\ \-\ MG",
"55613488", "Brasília\ \-\ DF",
"55313166", "Belo\ Horizonte\ \-\ MG",
"55483089", "São\ José\ \-\ SC",
"55453352", "Rio\ do\ Salto\ \-\ PR",
"55843694", "Monte\ das\ Gameleiras\ \-\ RN",
"55133302", "Praia\ Grande\ \-\ SP",
"55513399", "Rio\ Grande\ do\ Sul",
"55313563", "Itabirito\ \-\ MG",
"55353066", "Poços\ de\ Caldas\ \-\ MG",
"55513650", "Barão\ do\ Triunfo\ \-\ RS",
"55143546", "Sabino\ \-\ SP",
"55553278", "Pinhal\ Grande\ \-\ RS",
"55183851", "Tupi\ Paulista\ \-\ SP",
"55553511", "Santa\ Rosa\ \-\ RS",
"55773628", "Luis\ Eduardo\ Magalhães\ \-\ BA",
"55653244", "Jauru\ \-\ MT",
"55873764", "Garanhuns\ \-\ PE",
"55843354", "Encanto\ \-\ RN",
"55353534", "Itamogi\ \-\ MG",
"55133576", "São\ Vicente\ \-\ SP",
"55513659", "Rio\ Grande\ do\ Sul",
"55313649", "Santa\ Luzia\ \-\ MG",
"55553797", "Novo\ Tiradentes\ \-\ RS",
"55773444", "Livramento\ de\ Nossa\ Senhora\ \-\ BA",
"55193662", "Caconde\ \-\ SP",
"55473375", "Corupá\ \-\ SC",
"55423661", "Porto\ Barreiro\ \-\ PR",
"55843427", "Timbaúba\ dos\ Batistas\ \-\ RN",
"55823891", "Viçosa\ \-\ MG",
"55513931", "Porto\ Alegre\ \-\ RS",
"55613382", "Guará\ \-\ DF",
"55112843", "São\ Paulo\ \-\ SP",
"55343246", "Araguari\ \-\ MG",
"55173524", "Catanduva\ \-\ SP",
"55613573", "Brasília\ \-\ DF",
"55123519", "São\ José\ dos\ Campos\ \-\ SP",
"55115212", "São\ Paulo\ \-\ SP",
"5511499", "Santo\ André\ \-\ SP",
"55333328", "Alvarenga\ \-\ MG",
"55623558", "Goiânia\ \-\ GO",
"55214118", "Rio\ de\ Janeiro\ \-\ RJ",
"55863291", "Jardim\ do\ Mulato\ \-\ PI",
"55383201", "Montes\ Claros\ \-\ MG",
"55793114", "Nossa\ Senhora\ do\ Socorro\ \-\ SE",
"55323574", "Tocantins\ \-\ MG",
"55433537", "Barra\ do\ Jacaré\ \-\ PR",
"55663486", "Pedra\ Preta\ \-\ MT",
"55643455", "Caldas\ Novas\ \-\ GO",
"55513602", "Caraá\ \-\ RS",
"55633477", "Itaguatins\ \-\ TO",
"55323284", "Belmiro\ Braga\ \-\ MG",
"55173269", "Ipiguá\ \-\ SP",
"55553326", "Cruz\ Alta\ \-\ RS",
"55333625", "Serra\ dos\ Aimorés\ \-\ MG",
"55544141", "Caxias\ do\ Sul\ \-\ RS",
"55693485", "Espigão\ D\'Oeste\ \-\ RO",
"55273242", "Vila\ Velha\ \-\ ES",
"55113301", "São\ Paulo\ \-\ SP",
"55873795", "Jurema\ \-\ PE",
"55493235", "Painel\ \-\ SC",
"55863131", "Teresina\ \-\ PI",
"55643447", "Corumbaíba\ \-\ GO",
"55623595", "Goiânia\ \-\ GO",
"55543380", "Ibirapuitã\ \-\ RS",
"55513405", "Rio\ Grande\ do\ Sul",
"55474108", "Balneário\ Camboriú\ \-\ SC",
"55813619", "Fernando\ de\ Noronha\ \-\ PE",
"55273772", "Nova\ Venécia\ \-\ ES",
"55113362", "São\ Paulo\ \-\ SP",
"55114016", "Jarinu\ \-\ SP",
"55813684", "São\ Benedito\ do\ Sul\ \-\ PE",
"55643498", "Professor\ Jamil\ \-\ GO",
"55513661", "Tramandaí\ \-\ RS",
"55343074", "Uberaba\ \-\ MG",
"55543389", "Fontoura\ Xavier\ \-\ RS",
"55432104", "Londrina\ \-\ PR",
"55423659", "Samambaia\ \-\ PR",
"55273717", "Colatina\ \-\ ES",
"55983324", "Centro\ Novo\ do\ Maranhão\ \-\ MA",
"55943013", "Parauapebas\ \-\ PA",
"55174004", "São\ José\ do\ Rio\ Preto\ \-\ SP",
"55733242", "Ibicaraí\ \-\ BA",
"55883537", "Salitre\ \-\ CE",
"55843368", "Triunfo\ Potiguar\ \-\ RN",
"55313733", "Joaquim\ Murtinho\ \-\ MG",
"55633381", "Conceição\ do\ Tocantins\ \-\ TO",
"5531379", "Minas\ Gerais",
"55133203", "Santos\ \-\ SP",
"55453253", "Nova\ Santa\ Rosa\ \-\ PR",
"55643652", "Cristianópolis\ \-\ GO",
"55143375", "Espírito\ Santo\ do\ Turvo\ \-\ SP",
"55213492", "Niterói\ \-\ RJ",
"55883530", "Araripe\ \-\ CE",
"55813339", "Recife\ \-\ PE",
"55713616", "Salvador\ \-\ BA",
"55283555", "Mimoso\ do\ Sul\ \-\ ES",
"55423657", "Palmital\ \-\ PR",
"55623363", "Porangatu\ \-\ GO",
"55313409", "Belo\ Horizonte\ \-\ MG",
"55443524", "Campo\ Mourão\ \-\ PR",
"55383564", "Ruralminas\ I\ \-\ MG",
"55343611", "Araxá\ \-\ MG",
"55733544", "Planaltino\ \-\ BA",
"55793254", "Nossa\ Senhora\ do\ Socorro\ \-\ SE",
"55883539", "Baixio\ \-\ CE",
"55834101", "Campina\ Grande\ \-\ PB",
"55323742", "Fervedouro\ \-\ MG",
"55863244", "Miguel\ Alves\ \-\ PI",
"55813078", "Recife\ \-\ PE",
"55663569", "Porto\ Alegre\ do\ Norte\ \-\ MT",
"55543387", "Selbach\ \-\ RS",
"55473546", "Laurentino\ \-\ SC",
"55183264", "Iepê\ \-\ SP",
"55423645", "Laranjal\ \-\ PR",
"55283547", "Conceição\ do\ Castelo\ \-\ ES",
"55513726", "Lajeado\ \-\ RS",
"55193629", "Santa\ Bárbara\ D\'Oeste\ \-\ SP",
"55493366", "Pinhalzinho\ \-\ SC",
"55633470", "Santa\ Fé\ do\ Araguaia\ \-\ TO",
"55443251", "Sabáudia\ \-\ PR",
"55643440", "Cumari\ \-\ GO",
"55633479", "Piraquê\ \-\ TO",
"55643621", "Rio\ Verde\ \-\ GO",
"55173267", "Guapiaçu\ \-\ SP",
"55943433", "Tucumã\ \-\ PA",
"55993623", "Bom\ Lugar\ \-\ MA",
"55353333", "Soledade\ de\ Minas\ \-\ MG",
"55323272", "Simão\ Pereira\ \-\ MG",
"55843553", "Jandaíra\ \-\ RN",
"55813475", "Recife\ \-\ PE",
"55114805", "Jundiaí\ \-\ SP",
"55543471", "Dois\ Lajeados\ \-\ RS",
"55853403", "Fortaleza\ \-\ CE",
"55733086", "Ilhéus\ \-\ BA",
"55843641", "Natal\ \-\ RN",
"55513645", "São\ Pedro\ da\ Serra\ \-\ RS",
"55163514", "Ribeirão\ Preto\ \-\ SP",
"5545", "Paraná",
"5543302", "Londrina\ \-\ PR",
"55213664", "Belford\ Roxo\ \-\ RJ",
"55222102", "Nova\ Friburgo\ \-\ RJ",
"55153532", "Itararé\ \-\ SP",
"55814102", "Recife\ \-\ PE",
"55483434", "Morro\ da\ Fumaça\ \-\ SC",
"55413140", "Campo\ Largo\ \-\ PR",
"55114555", "Mauá\ \-\ SP",
"55122125", "Taubaté\ \-\ SP",
"55843429", "Jucurutu\ \-\ RN",
"55453321", "Cascavel\ \-\ PR",
"55513348", "Rio\ Grande\ do\ Sul",
"55313358", "Contagem\ \-\ MG",
"55793316", "Nossa\ Senhora\ de\ Lourdes\ \-\ SE",
"55983461", "Vargem\ Grande\ \-\ MA",
"55663551", "Nova\ Canaã\ do\ Norte\ \-\ MT",
"55513657", "Vendinha\ \-\ RS",
"55323373", "São\ João\ Del\ Rei\ \-\ MG",
"55243388", "Resende\ \-\ RJ",
"55823298", "Porto\ de\ Pedras\ \-\ AL",
"55473084", "Jaraguá\ do\ Sul\ \-\ SC",
"55373522", "Bom\ Despacho\ \-\ MG",
"55793268", "General\ Maynard\ \-\ SE",
"55733205", "Argolo\ \-\ BA",
"55314138", "Vespasiano\ \-\ MG",
"55323426", "Miraí\ \-\ MG",
"55212655", "São\ João\ de\ Meriti\ \-\ RJ",
"55913323", "Belém\ \-\ PA",
"55773491", "São\ Félix\ do\ Coribe\ \-\ BA",
"55114598", "Vargem\ \-\ SP",
"55163749", "Ribeirão\ Corrente\ \-\ SP",
"55983523", "Imperatriz\ \-\ MA",
"55183822", "Dracena\ \-\ SP",
"55833434", "Guarabira\ \-\ PB",
"55653291", "Cáceres\ \-\ MT",
"55413666", "Colombo\ \-\ PR",
"55513442", "Alvorada\ \-\ RS",
"55313395", "Contagem\ \-\ MG",
"55673287", "Porto\ Murtinho\ \-\ MS",
"55212647", "Magé\ \-\ RJ",
"5585347", "Fortaleza\ \-\ CE",
"55643607", "Itumbiara\ \-\ GO",
"55114787", "Taboão\ da\ Serra\ \-\ SP",
"55183529", "Osvaldo\ Cruz\ \-\ SP",
"55823255", "Colônia\ Leopoldina\ \-\ AL",
"55883683", "Ipu\ \-\ CE",
"55153141", "Sorocaba\ \-\ SP",
"55112704", "São\ Paulo\ \-\ SP",
"55192122", "Campinas\ \-\ SP",
"55813653", "Lagoa\ do\ Itaenga\ \-\ PE",
"55513758", "Capitão\ \-\ RS",
"55223058", "Cabo\ Frio\ \-\ RJ",
"55163690", "Jardinópolis\ \-\ SP",
"55553563", "São\ Paulo\ das\ Missões\ \-\ RS",
"55153325", "Sorocaba\ \-\ SP",
"55153022", "Tatuí\ \-\ SP",
"55213626", "Rio\ de\ Janeiro\ \-\ RJ",
"55713431", "Salvador\ \-\ BA",
"55143493", "Varpa\ \-\ SP",
"55512107", "Santa\ Cruz\ do\ Sul\ \-\ RS",
"55923228", "Manaus\ \-\ AM",
"55993014", "Imperatriz\ \-\ MA",
"55833291", "Rio\ Tinto\ \-\ PB",
"55373335", "Passa\ Tempo\ \-\ MG",
"55463537", "Boa\ Esperança\ do\ Iguaçu\ \-\ PR",
"55453284", "Marechal\ Cândido\ Rondon\ \-\ PR",
"55453219", "Cascavel\ \-\ PR",
"55873836", "Sanharó\ \-\ PE",
"5568", "Acre",
"55613521", "Brasília\ \-\ DF",
"55663412", "Juscimeira\ \-\ MT",
"55123156", "Piquete\ \-\ SP",
"55113578", "São\ Paulo\ \-\ SP",
"55163203", "Jaboticabal\ \-\ SP",
"55843282", "Santo\ Antônio\ \-\ RN",
"55753251", "Itaberaba\ \-\ BA",
"55323464", "Estrela\ Dalva\ \-\ MG",
"55114688", "Barueri\ \-\ SP",
"55173489", "Brasitânia\ \-\ SP",
"55113122", "São\ Paulo\ \-\ SP",
"55193704", "Limeira\ \-\ SP",
"55673451", "Itaporã\ \-\ MS",
"55833542", "Santa\ Helena\ \-\ PB",
"55473249", "Itajaí\ \-\ SC",
"55383311", "Paracatu\ \-\ MG",
"55553649", "Sanchuri\ \-\ RS",
"55114082", "São\ Paulo\ \-\ SP",
"55513066", "Novo\ Hamburgo\ \-\ RS",
"55553421", "Alegrete\ \-\ RS",
"55323253", "Tabuleiro\ \-\ MG",
"5531340", "Minas\ Gerais",
"55413624", "Agudos\ do\ Sul\ \-\ PR",
"55313511", "Betim\ \-\ MG",
"55973483", "Envira\ \-\ AM",
"55483131", "Florianópolis\ \-\ SC",
"55123981", "Cedro\ \-\ SP",
"55843383", "José\ da\ Penha\ \-\ RN",
"55443566", "Juranda\ \-\ PR",
"55383526", "Carbonita\ \-\ MG",
"55112838", "São\ Paulo\ \-\ SP",
"5511332", "São\ Paulo\ \-\ SP",
"5574", "Bahia",
"55513613", "Fazenda\ Vilanova\ \-\ RS",
"55623631", "Jataí\ \-\ GO",
"55212108", "Rio\ de\ Janeiro\ \-\ RJ",
"55143298", "Macatuba\ \-\ SP",
"55313326", "Belo\ Horizonte\ \-\ MG",
"55513764", "Cruzeiro\ do\ Sul\ \-\ RS",
"5544326", "Maringá\ \-\ PR",
"55273079", "Serra\ \-\ ES",
"55213745", "Nova\ Iguaçu\ \-\ RJ",
"55614001", "Brasília\ \-\ DF",
"55493642", "Guarujá\ do\ Sul\ \-\ SC",
"55633522", "Lagoa\ do\ Tocantins\ \-\ TO",
"55512121", "Porto\ Alegre\ \-\ RS",
"55623959", "Niquelândia\ \-\ GO",
"55193575", "Itirapina\ \-\ SP",
"55493445", "Abelardo\ Luz\ \-\ SC",
"55943305", "Bannach\ \-\ PA",
"55133212", "Santos\ \-\ SP",
"55163286", "Ribeirão\ Preto\ \-\ SP",
"55614062", "Brasília\ \-\ DF",
"55753269", "Riachão\ do\ Jacuípe\ \-\ BA",
"55953592", "Pacaraima\ \-\ RR",
"55173826", "Uchoa\ \-\ SP",
"55163173", "Igarapava\ \-\ SP",
"55143844", "Pratânia\ \-\ SP",
"55813541", "Abreu\ e\ Lima\ \-\ PE",
"55673469", "Culturama\ \-\ MS",
"55493457", "Presidente\ Castelo\ Branco\ \-\ SC",
"55863089", "Teresina\ \-\ PI",
"55333512", "Frei\ Gaspar\ \-\ MG",
"55433020", "Rolândia\ \-\ PR",
"55413608", "Fazenda\ Rio\ Grande\ \-\ PR",
"55114246", "Mairinque\ \-\ SP",
"5532", "Minas\ Gerais",
"55863087", "Teresina\ \-\ PI",
"55133279", "Santos\ \-\ SP",
"55673467", "Fátima\ do\ Sul\ \-\ MS",
"55493459", "Coronel\ Martins\ \-\ SC",
"55613636", "Cabeceiras\ \-\ GO",
"55833623", "Cuité\ de\ Mamanguape\ \-\ PB",
"55185821", "Dracena\ \-\ SP",
"55733012", "Porto\ Seguro\ \-\ BA",
"55423232", "Castro\ \-\ PR",
"55883654", "Mucambo\ \-\ CE",
"55623482", "Nova\ Roma\ \-\ GO",
"55753267", "Biritinga\ \-\ BA",
"5511454", "Mauá\ \-\ SP",
"55343842", "Monte\ Carmelo\ \-\ MG",
"55893568", "Palmeira\ do\ Piauí\ \-\ PI",
"55853381", "Maracanaú\ \-\ CE",
"55642102", "Jataí\ \-\ GO",
"55413061", "Curitiba\ \-\ PR",
"55743692", "América\ Dourada\ \-\ BA",
"5575348", "Feira\ de\ Santana\ \-\ BA",
"55115042", "São\ Paulo\ \-\ SP",
"55343663", "Perdizes\ \-\ MG",
"55483623", "Capivari\ de\ Baixo\ \-\ SC",
"55213142", "Itaboraí\ \-\ RJ",
"55983218", "São\ Luís\ \-\ MA",
"55273315", "Vitória\ \-\ ES",
"55773656", "Brejolândia\ \-\ BA",
"55623945", "Goiânia\ \-\ GO",
"55683464", "Jordão\ \-\ AC",
"55123354", "Jacareí\ \-\ SP",
"55613500", "Brasília\ \-\ DF",
"5547343", "Joinville\ \-\ SC",
"55813735", "São\ Bento\ do\ Una\ \-\ PE",
"55793411", "Nossa\ Senhora\ da\ Glória\ \-\ SE",
"55843274", "Ceará\-Mirim\ \-\ RN",
"55163357", "Araraquara\ \-\ SP",
"55883668", "Senador\ Sá\ \-\ CE",
"55613552", "Núcleo\ Bandeirante\ \-\ DF",
"55893554", "São\ José\ do\ Peixe\ \-\ PI",
"55553358", "Salvador\ das\ Missões\ \-\ RS",
"55543376", "Aratiba\ \-\ RS",
"55153491", "Salto\ de\ Pirapora\ \-\ SP",
"55163345", "Dourado\ \-\ SP",
"5513335", "Guarujá\ \-\ SP",
"55173487", "Magda\ \-\ SP",
"55713682", "Bom\ Despacho\ \-\ BA",
"55383631", "São\ Francisco\ \-\ MG",
"55513192", "Novo\ Hamburgo\ \-\ RS",
"55623526", "Goiânia\ \-\ GO",
"55163042", "Sertãozinho\ \-\ SP",
"55473255", "Brusque\ \-\ SC",
"55923545", "Boa\ Vista\ do\ Ramos\ \-\ AM",
"55353645", "São\ José\ do\ Alegre\ \-\ MG",
"55333356", "São\ João\ do\ Oriente\ \-\ MG",
"55313871", "Rio\ Casca\ \-\ MG",
"55613966", "Brasília\ \-\ DF",
"55673503", "Paranaíba\ \-\ MS",
"55183928", "Presidente\ Prudente\ \-\ SP",
"55673044", "Campo\ Grande\ \-\ MS",
"55113151", "São\ Paulo\ \-\ SP",
"55433062", "Cambé\ \-\ PR",
"55413059", "Pinhais\ \-\ PR",
"55115816", "São\ Paulo\ \-\ SP",
"5532321", "Juiz\ de\ Fora\ \-\ MG",
"55273753", "Vila\ Pavão\ \-\ ES",
"55463539", "Doutor\ Antônio\ Paranhos\ \-\ PR",
"55353442", "Bueno\ Brandão\ \-\ MG",
"55195657", "São\ Paulo\ \-\ SP",
"55173566", "Embaúba\ \-\ SP",
"55614020", "Brasília\ \-\ DF",
"55483244", "Florianópolis\ \-\ SC",
"55112346", "São\ Paulo\ \-\ SP",
"55663479", "Novo\ São\ Joaquim\ \-\ MT",
"55512109", "Santa\ Cruz\ do\ Sul\ \-\ RS",
"55943342", "Abel\ Figueiredo\ \-\ PA",
"55453272", "Diamante\ D\'Oeste\ \-\ PR",
"55613114", "Brasília\ \-\ DF",
"55493523", "Luzerna\ \-\ SC",
"55212124", "Duque\ de\ Caxias\ \-\ RJ",
"55373381", "Cláudio\ \-\ MG",
"55213761", "Nilópolis\ \-\ RJ",
"55543280", "Pedras\ Brancas\ \-\ RS",
"55663402", "Barra\ do\ Garças\ \-\ MT",
"55633571", "Palmas\ \-\ TO",
"5561342", "Brasília\ \-\ DF",
"55663523", "Nova\ Santa\ Helena\ \-\ MT",
"55193549", "Mogi\ Mirim\ \-\ SP",
"55112663", "São\ Paulo\ \-\ SP",
"55793641", "Riachão\ do\ Dantas\ \-\ SE",
"55853048", "Fortaleza\ \-\ CE",
"55193842", "Serra\ Negra\ \-\ SP",
"55643541", "Itumbiara\ \-\ GO",
"55313956", "Contagem\ \-\ MG",
"55633366", "Miracema\ do\ Tocantins\ \-\ TO",
"55114662", "Embu\-Guaçu\ \-\ SP",
"55693530", "Monte\ Negro\ \-\ RO",
"55983224", "São\ José\ de\ Ribamar\ \-\ MA",
"55743639", "Várzea\ do\ Poço\ \-\ BA",
"55512117", "Porto\ Alegre\ \-\ RS",
"55313869", "Congonhas\ do\ Norte\ \-\ MG",
"55993543", "Tasso\ Fragoso\ \-\ MA",
"55313562", "Itabirito\ \-\ MG",
"55883674", "Acaraú\ \-\ CE",
"55843268", "Caiçara\ do\ Rio\ do\ Vento\ \-\ RN",
"55313860", "Minas\ Gerais",
"55743630", "Mirangaba\ \-\ BA",
"55513686", "Magistério\ \-\ RS",
"55693539", "Rio\ Crespo\ \-\ RO",
"55853324", "Caridade\ \-\ CE",
"55883431", "Itapiúna\ \-\ CE",
"5531341", "Belo\ Horizonte\ \-\ MG",
"55953537", "São\ Luiz\ \-\ RR",
"55753456", "Cardeal\ da\ Silva\ \-\ BA",
"55213891", "Rio\ de\ Janeiro\ \-\ RJ",
"55114601", "Jundiaí\ \-\ SP",
"55733624", "Jussari\ \-\ BA",
"55443644", "São\ Manoel\ do\ Paraná\ \-\ PR",
"55113416", "Taboão\ da\ Serra\ \-\ SP",
"55473626", "São\ Bento\ do\ Sul\ \-\ SC",
"55443428", "Graciosa\ \-\ PR",
"55112549", "São\ Paulo\ \-\ SP",
"55193663", "Divinolândia\ \-\ SP",
"55213779", "Nova\ Iguaçu\ \-\ RJ",
"55663461", "Jaciara\ \-\ MT",
"55333731", "Araçuaí\ \-\ MG",
"55314007", "Belo\ Horizonte\ \-\ MG",
"55613383", "Brasília\ \-\ DF",
"55493335", "Planalto\ Alegre\ \-\ SC",
"55373324", "Pimenta\ \-\ MG",
"55173691", "Três\ Fronteiras\ \-\ SP",
"55133261", "Santos\ \-\ SP",
"55115213", "São\ Paulo\ \-\ SP",
"55193016", "Indaiatuba\ \-\ SP",
"55893574", "Curimatá\ \-\ PI",
"55653344", "Jangada\ \-\ MT",
"55613879", "Brasília\ \-\ DF",
"55843254", "São\ Pedro\ \-\ RN",
"55833538", "São\ José\ da\ Lagoa\ Tapada\ \-\ PB",
"55613517", "Brasília\ \-\ DF",
"55313851", "João\ Monlevade\ \-\ MG",
"55153334", "Sorocaba\ \-\ SP",
"55513603", "Rainha\ do\ Mar\ \-\ RS",
"55813708", "Bezerros\ \-\ PE",
"55133386", "Guarujá\ \-\ SP",
"55473275", "Jaraguá\ do\ Sul\ \-\ SC",
"55114494", "Atibaia\ \-\ SP",
"55923512", "Borba\ \-\ AM",
"55183421", "Assis\ \-\ SP",
"55413432", "Antonina\ \-\ PR",
"55183649", "Birigui\ \-\ SP",
"5561202", "Brasília\ \-\ DF",
"55543356", "Barracão\ \-\ RS",
"5521301", "Rio\ de\ Janeiro\ \-\ RJ",
"55434104", "Apucarana\ \-\ PR",
"55713029", "Lauro\ de\ Freitas\ \-\ BA",
"55273773", "São\ Mateus\ \-\ ES",
"55333423", "Sabinópolis\ \-\ MG",
"55413070", "Fazenda\ Rio\ Grande\ \-\ PR",
"55843521", "Macau\ \-\ RN",
"55193933", "Paulínia\ \-\ SP",
"55413635", "São\ José\ dos\ Pinhais\ \-\ PR",
"55113171", "São\ Paulo\ \-\ SP",
"55653028", "Cuiabá\ \-\ MT",
"55733243", "Floresta\ Azul\ \-\ BA",
"55143761", "Itaí\ \-\ SP",
"55613306", "Brasília\ \-\ DF",
"55313527", "Minas\ Gerais",
"55483538", "Balneário\ Bela\ Torres\ \-\ SC",
"55313118", "Belo\ Horizonte\ \-\ MG",
"55943012", "Marabá\ \-\ PA",
"55453252", "Toledo\ \-\ PR",
"55943315", "PA\ 275\ \-\ PA",
"55133202", "Santos\ \-\ SP",
"55643653", "Gouvelândia\ \-\ GO",
"55313732", "Congonhas\ \-\ MG",
"55693446", "Primavera\ de\ Rondônia\ \-\ RO",
"55853461", "Fortaleza\ \-\ CE",
"55413012", "Curitiba\ \-\ PR",
"55313520", "Minas\ Gerais",
"55993425", "Jenipapo\ dos\ Vieiras\ \-\ MA",
"55713394", "Aratu\ \-\ BA",
"55113595", "São\ Paulo\ \-\ SP",
"55313529", "Betim\ \-\ MG",
"55323743", "Divino\ \-\ MG",
"55114620", "Osasco\ \-\ SP",
"55553419", "Barra\ do\ Quaraí\ \-\ RS",
"55623362", "Porangatu\ \-\ GO",
"55513778", "Rio\ Grande\ do\ Sul",
"55813673", "Catende\ \-\ PE",
"55114441", "Caieiras\ \-\ SP",
"55653391", "Cuiabá\ \-\ MT",
"55513137", "Alvorada\ \-\ RS",
"55353438", "Camanducaia\ \-\ MG",
"55963426", "Lourenço\ \-\ AP",
"55183698", "Lavínia\ \-\ SP",
"55313295", "Belo\ Horizonte\ \-\ MG",
"55413941", "Curitiba\ \-\ PR",
"55193805", "Mogi\ Mirim\ \-\ SP",
"55832101", "Campina\ Grande\ \-\ PB",
"55984002", "São\ Luís\ \-\ MA",
"55183647", "Glicério\ \-\ SP",
"55643565", "Itumbiara\ \-\ GO",
"55473531", "Rio\ do\ Sul\ \-\ SC",
"55893582", "São\ Raimundo\ Nonato\ \-\ PI",
"55482101", "Criciúma\ \-\ SC",
"55753271", "Euclides\ da\ Cunha\ \-\ BA",
"55943432", "Floresta\ do\ Araguaia\ \-\ PA",
"5593", "Pará",
"55112805", "Diadema\ \-\ SP",
"55613877", "Brasília\ \-\ DF",
"55843552", "Galinhos\ \-\ RN",
"55163379", "Fazenda\ Babilônia\ \-\ SP",
"55183655", "Barbosa\ \-\ SP",
"55993622", "Bacabal\ \-\ MA",
"55353332", "São\ Lourenço\ \-\ MG",
"55623301", "Leopoldo\ de\ Bulhões\ \-\ GO",
"55323273", "Matias\ Barbosa\ \-\ MG",
"55613274", "Brasília\ \-\ DF",
"55673471", "Iguatemi\ \-\ MS",
"553136", "Minas\ Gerais",
"55314009", "Belo\ Horizonte\ \-\ MG",
"55115632", "São\ Paulo\ \-\ SP",
"55433011", "Arapongas\ \-\ PR",
"55222103", "Nova\ Friburgo\ \-\ RJ",
"55443351", "Cianorte\ \-\ PR",
"55142108", "Bauru\ \-\ SP",
"55753162", "Santo\ Antônio\ de\ Jesus\ \-\ BA",
"55112547", "São\ Paulo\ \-\ SP",
"55153533", "Bom\ Sucesso\ de\ Itararé\ \-\ SP",
"55213138", "Rio\ de\ Janeiro\ \-\ RJ",
"55623979", "Anápolis\ \-\ GO",
"55323372", "São\ João\ Del\ Rei\ \-\ MG",
"55963217", "Macapá\ \-\ AP",
"55643594", "Itumbiara\ \-\ GO",
"55812102", "Recife\ \-\ PE",
"55373402", "Itaúna\ \-\ MG",
"55873035", "Petrolina\ \-\ PE",
"55993667", "Governador\ Archer\ \-\ MA",
"55373523", "Pompéu\ \-\ MG",
"55953539", "Nova\ Colina\ \-\ RR",
"55313264", "Minas\ Gerais",
"55143275", "Paulistânia\ \-\ SP",
"55913322", "Barcarena\ \-\ PA",
"55893426", "Geminiano\ \-\ PI",
"55112787", "São\ Paulo\ \-\ SP",
"55123411", "Taubaté\ \-\ SP",
"55313867", "São\ Sebastião\ do\ Rio\ Preto\ \-\ MG",
"55193555", "Leme\ \-\ SP",
"55743637", "Gentio\ do\ Ouro\ \-\ BA",
"55793354", "Gararu\ \-\ SE",
"55222630", "Cabo\ Frio\ \-\ RJ",
"55513443", "Alvorada\ \-\ RS",
"55133854", "Cajati\ \-\ SP",
"55312138", "Belo\ Horizonte\ \-\ MG",
"55623094", "Aparecida\ de\ Goiânia\ \-\ GO",
"55183823", "Dracena\ \-\ SP",
"55543287", "Vila\ Cristina\ \-\ RS",
"55854003", "Fortaleza\ \-\ CE",
"55843636", "Ruy\ Barbosa\ \-\ RN",
"55143585", "Pirajuí\ \-\ SP",
"552133", "Rio\ de\ Janeiro\ \-\ RJ",
"55193547", "Araras\ \-\ SP",
"55473702", "Blumenau\ \-\ SC",
"55213844", "Nova\ Iguaçu\ \-\ RJ",
"55793274", "Rosário\ do\ Catete\ \-\ SE",
"55613368", "Brasília\ \-\ DF",
"5516337", "São\ Carlos\ \-\ SP",
"55693654", "São\ Domingos\ \-\ RO",
"55423677", "Pinhão\ \-\ PR",
"55813652", "Camutanga\ \-\ PE",
"55733238", "Itajuípe\ \-\ BA",
"55533611", "Portão\ \-\ RS",
"55143492", "Vera\ Cruz\ \-\ SP",
"55143355", "Manduri\ \-\ SP",
"55163386", "Dobrada\ \-\ SP",
"55114704", "Embu\ das\ Artes\ \-\ SP",
"55643684", "Aurilândia\ \-\ GO",
"55643610", "Mineiros\ \-\ GO",
"55133377", "Cubatão\ \-\ SP",
"55634003", "Palmas\ \-\ TO",
"55823626", "Poço\ das\ Trincheiras\ \-\ AL",
"55532123", "Pelotas\ \-\ RS",
"55193385", "Campinas\ \-\ SP",
"55983479", "Tutóia\ \-\ MA",
"55673926", "Ponta\ Porã\ \-\ MS",
"55193948", "Louveira\ \-\ SP",
"55463905", "Francisco\ Beltrão\ \-\ PR",
"55613401", "Taguatinga\ \-\ DF",
"55133418", "Itariri\ \-\ SP",
"55163202", "Jaboticabal\ \-\ SP",
"55554007", "Santa\ Maria\ \-\ RS",
"55743221", "Senhor\ do\ Bonfim\ \-\ BA",
"55843283", "Brejinho\ \-\ RN",
"55493551", "Joaçaba\ \-\ SC",
"55633459", "Buriti\ do\ Tocantins\ \-\ TO",
"55813447", "Recife\ \-\ PE",
"55893464", "Caridade\ do\ Piauí\ \-\ PI",
"55913120", "Belém\ \-\ PA",
"55873841", "Sertânia\ \-\ PE",
"55443518", "Campo\ Mourão\ \-\ PR",
"55273198", "Vitória\ \-\ ES",
"55543451", "Bento\ Gonçalves\ \-\ RS",
"55114083", "São\ Paulo\ \-\ SP",
"55123966", "São\ José\ dos\ Campos\ \-\ SP",
"55833543", "Aparecida\ \-\ PB",
"55813095", "Caruaru\ \-\ PE",
"55973482", "Ipixuna\ \-\ AM",
"55133481", "Praia\ Grande\ \-\ SP",
"55112688", "Guarulhos\ \-\ SP",
"55323252", "Santos\ Dumont\ \-\ MG",
"55273721", "Colatina\ \-\ ES",
"55813536", "Pombos\ \-\ PE",
"55163303", "Araraquara\ \-\ SP",
"55843382", "Luís\ Gomes\ \-\ RN",
"55183278", "Caiuá\ \-\ SP",
"55353841", "Bom\ Sucesso\ \-\ MG",
"55913765", "Salvaterra\ \-\ PA",
"55143664", "Itapuí\ \-\ SP",
"55313039", "Timóteo\ \-\ MG",
"55513612", "Doutor\ Ricardo\ \-\ RS",
"55143713", "Paranapanema\ \-\ SP",
"55893495", "Queimada\ Nova\ \-\ PI",
"55473349", "Itajaí\ \-\ SC",
"55493643", "São\ José\ do\ Cedro\ \-\ SC",
"55613354", "Brasília\ \-\ DF",
"55513018", "Porto\ Alegre\ \-\ RS",
"5565366", "Cuiabá\ \-\ MT",
"55793046", "Aracaju\ \-\ SE",
"55663571", "Colniza\ \-\ MT",
"55633402", "Araguaína\ \-\ TO",
"55513677", "Dom\ Feliciano\ \-\ RS",
"55323353", "Dores\ de\ Campos\ \-\ MG",
"55913456", "Benfica\ \-\ PA",
"55313378", "Belo\ Horizonte\ \-\ MG",
"55473340", "Blumenau\ \-\ SC",
"55843488", "Cerro\ Corá\ \-\ RN",
"55673557", "Três\ Lagoas\ \-\ MS",
"55473021", "Balneário\ Camboriú\ \-\ SC",
"55133213", "Santos\ \-\ SP",
"55633461", "Brasilândia\ do\ Tocantins\ \-\ TO",
"55353299", "Alfenas\ \-\ MG",
"55323693", "Barbacena\ \-\ MG",
"55123861", "São\ Sebastião\ \-\ SP",
"55614063", "Brasília\ \-\ DF",
"55953593", "Amajari\ \-\ RR",
"55212675", "Duque\ de\ Caxias\ \-\ RJ",
"55923328", "Rio\ Preto\ da\ Eva\ \-\ AM",
"55993538", "Açailândia\ \-\ MA",
"55823275", "Campo\ Alegre\ \-\ AL",
"55833391", "Boqueirão\ \-\ PB",
"55433336", "Londrina\ \-\ PR",
"55873946", "Salgueiro\ \-\ PE",
"55183748", "Ilha\ Solteira\ \-\ SP",
"55163172", "Igarapava\ \-\ SP",
"55373235", "Pará\ de\ Minas\ \-\ MG",
"55243320", "Volta\ Redonda\ \-\ RJ",
"5585345", "Fortaleza\ \-\ CE",
"55313472", "Minas\ Gerais",
"55353525", "Delfinópolis\ \-\ MG",
"55114144", "Itapevi\ \-\ SP",
"55953236", "Caroebe\ \-\ RR",
"55513415", "Canoas\ \-\ RS",
"55333513", "Campanário\ \-\ MG",
"55773687", "Canápolis\ \-\ BA",
"55813607", "Orobó\ \-\ PE",
"55933582", "Santa\ Maria\ do\ Uruará\ \-\ PA",
"55823531", "Batalha\ \-\ AL",
"55773689", "Rosário\ \-\ BA",
"55873865", "Dormentes\ \-\ PE",
"55513438", "Cachoeirinha\ \-\ RS",
"55773614", "Barreiras\ \-\ BA",
"55433265", "São\ Sebastião\ da\ Amoreira\ \-\ PR",
"5589", "Piauí",
"55623483", "Sítio\ D\'Abadia\ \-\ GO",
"55753025", "Feira\ de\ Santana\ \-\ BA",
"55433616", "Sengés\ \-\ PR",
"5519378", "Campinas\ \-\ SP",
"55483344", "Palhoça\ \-\ SC",
"55343843", "Estrela\ do\ Sul\ \-\ MG",
"55833622", "Capim\ \-\ PB",
"55733013", "Teixeira\ de\ Freitas\ \-\ BA",
"55423233", "Castro\ \-\ PR",
"55313419", "Minas\ Gerais",
"55373281", "Santo\ Antônio\ do\ Monte\ \-\ MG",
"55673559", "Paranaíba\ \-\ MS",
"55313410", "Minas\ Gerais",
"55493567", "Caçador\ \-\ SC",
"55122134", "São\ José\ dos\ Campos\ \-\ SP",
"55353297", "Alfenas\ \-\ MG",
"55413003", "Curitiba\ \-\ PR",
"55173271", "Neves\ Paulista\ \-\ SP",
"55753322", "Feira\ de\ Santana\ \-\ BA",
"55513679", "Sentinela\ do\ Sul\ \-\ RS",
"55114815", "Jundiaí\ \-\ SP",
"55753644", "Queimadas\ \-\ BA",
"55513035", "Novo\ Hamburgo\ \-\ RS",
"55833425", "Quixabá\ \-\ PB",
"55642103", "Itumbiara\ \-\ GO",
"55542628", "Farroupilha\ \-\ RS",
"55554052", "Santa\ Maria\ \-\ RS",
"55843374", "Riacho\ da\ Cruz\ \-\ RN",
"55163257", "Cândido\ Rodrigues\ \-\ SP",
"55713125", "Camaçari\ \-\ BA",
"55183871", "Panorama\ \-\ SP",
"55473347", "Piçarras\ \-\ SC",
"55553258", "Nova\ Esperança\ do\ Sul\ \-\ RS",
"55613981", "Formosa\ \-\ GO",
"5562332", "Anápolis\ \-\ GO",
"55513670", "Amaral\ Ferrador\ \-\ RS",
"55483622", "Tubarão\ \-\ SC",
"55343662", "Araxá\ \-\ MG",
"5511592", "São\ Paulo\ \-\ SP",
"55543276", "Protásio\ Alves\ \-\ RS",
"55153548", "Itapirapuã\ Paulista\ \-\ SP",
"55483028", "Florianópolis\ \-\ SC",
"55473052", "Indaial\ \-\ SC",
"55473355", "Brusque\ \-\ SC",
"55473492", "Santa\ Cruz\ \-\ SC",
"55383725", "Morro\ da\ Garça\ \-\ MG",
"55753428", "Pedrão\ \-\ BA",
"55693236", "Porto\ Velho\ \-\ RO",
"55242465", "Mendes\ \-\ RJ",
"55533246", "Aceguá\ \-\ RS",
"55992101", "Imperatriz\ \-\ MA",
"55643475", "Três\ Ranchos\ \-\ GO",
"55323554", "Ervália\ \-\ MG",
"55123845", "Ubatuba\ \-\ SP",
"55112331", "São\ Paulo\ \-\ SP",
"55173101", "Uchoa\ \-\ SP",
"55623578", "Aparecida\ de\ Goiânia\ \-\ GO",
"55983381", "Pinheiro\ \-\ MA",
"55315", "Minas\ Gerais",
"5551329", "Rio\ Grande\ do\ Sul",
"55613553", "Brasília\ \-\ DF",
"55273215", "Vitória\ \-\ ES",
"55623288", "Aparecida\ de\ Goiânia\ \-\ GO",
"55813621", "Carpina\ \-\ PE",
"55543625", "Capão\ Bonito\ do\ Sul\ \-\ RS",
"55423438", "Guamiranga\ \-\ PR",
"55115854", "São\ Paulo\ \-\ SP",
"55814112", "São\ Lourenço\ da\ Mata\ \-\ PE",
"55334141", "Governador\ Valadares\ \-\ MG",
"55623406", "Buritinópolis\ \-\ GO",
"55513596", "Novo\ Hamburgo\ \-\ RS",
"55633457", "Colméia\ \-\ TO",
"55443535", "Jesuítas\ \-\ PR",
"55983477", "São\ Bernardo\ \-\ MA",
"55333314", "Ipanema\ \-\ MG",
"55213084", "Rio\ de\ Janeiro\ \-\ RJ",
"55514109", "Gravataí\ \-\ RS",
"55243065", "Petrópolis\ \-\ RJ",
"55222554", "Macuco\ \-\ RJ",
"55913741", "Soure\ \-\ PA",
"55353865", "Cana\ Verde\ \-\ MG",
"55162137", "Ribeirão\ Preto\ \-\ SP",
"55273752", "Nova\ Venécia\ \-\ ES",
"55353443", "Jacutinga\ \-\ MG",
"55693341", "Colorado\ do\ Oeste\ \-\ RO",
"55853366", "Fortaleza\ \-\ CE",
"55453273", "Toledo\ \-\ PR",
"55493522", "Joaçaba\ \-\ SC",
"55643672", "Mineiros\ \-\ GO",
"55123521", "Pindamonhangaba\ \-\ SP",
"5596", "Amapá",
"55733215", "Itabuna\ \-\ BA",
"55423035", "Guarapuava\ \-\ PR",
"55963321", "Serra\ do\ Navio\ \-\ AP",
"55313388", "Belo\ Horizonte\ \-\ MG",
"55663581", "Castanheira\ \-\ MT",
"55513687", "Arroio\ do\ Sal\ \-\ RS",
"55413291", "Campo\ Largo\ \-\ PR",
"55773415", "Ituaçu\ \-\ BA",
"55243358", "Resende\ \-\ RJ",
"55273768", "Boa\ Esperança\ \-\ ES",
"55113378", "Jundiaí\ \-\ SP",
"55114275", "Mairiporã\ \-\ SP",
"55813236", "Recife\ \-\ PE",
"55473054", "Jaraguá\ do\ Sul\ \-\ SC",
"55893429", "São\ João\ da\ Canabrava\ \-\ PI",
"55683463", "Feijó\ \-\ AC",
"55183211", "Birigui\ \-\ SP",
"55483624", "Jaguaruna\ \-\ SC",
"55343664", "Araxá\ \-\ MG",
"55413131", "Curitiba\ \-\ PR",
"55313685", "Nova\ União\ \-\ MG",
"55163852", "Sales\ Oliveira\ \-\ SP",
"55183288", "Rosana\ \-\ SP",
"55633367", "Tocantínia\ \-\ TO",
"55833342", "Campina\ Grande\ \-\ PB",
"55843372", "Severiano\ Melo\ \-\ RN",
"55753642", "Jaguaripe\ \-\ BA",
"55183406", "Guararapes\ \-\ SP",
"55773677", "Érico\ Cardoso\ \-\ BA",
"55553363", "São\ Nicolau\ \-\ RS",
"55483045", "Criciúma\ \-\ SC",
"55313482", "Minas\ Gerais",
"55133513", "Santos\ \-\ SP",
"55453031", "Foz\ do\ Iguaçu\ \-\ PR",
"55473627", "Canoinhas\ \-\ SC",
"55833624", "João\ Pessoa\ \-\ PB",
"55823285", "São\ José\ da\ Laje\ \-\ AL",
"55483342", "Palhoça\ \-\ SC",
"55753445", "Jandaíra\ \-\ BA",
"55553227", "Itaara\ \-\ RS",
"55883653", "Ibiapina\ \-\ CE",
"5561", "Federal\ District",
"55833448", "Bom\ Sucesso\ \-\ PB",
"55773612", "Barreiras\ \-\ BA",
"55673245", "Anastácio\ \-\ MS",
"55212685", "Mangaratiba\ \-\ RJ",
"5584320", "Natal\ \-\ RN",
"55333213", "Governador\ Valadares\ \-\ MG",
"55173811", "Nova\ Aliança\ \-\ SP",
"55843478", "São\ José\ do\ Seridó\ \-\ RN",
"55353225", "Carmo\ da\ Cachoeira\ \-\ MG",
"55684062", "Rio\ Branco\ \-\ AC",
"55193375", "Piracicaba\ \-\ SP",
"55213688", "Rio\ de\ Janeiro\ \-\ RJ",
"55553262", "Paraíso\ do\ Sul\ \-\ RS",
"55863198", "Teresina\ \-\ PI",
"55543357", "Camargo\ \-\ RS",
"55333377", "São\ João\ do\ Manhuaçu\ \-\ MG",
"55483243", "Biguaçu\ \-\ SC",
"55643674", "Iporá\ \-\ GO",
"55813915", "Aripibu\ \-\ PE",
"55493524", "Água\ Doce\ \-\ SC",
"55423334", "Maceió\ \-\ AL",
"55873892", "Terra\ Nova\ \-\ PE",
"55133387", "Guarujá\ \-\ SP",
"55733538", "Itiruçu\ \-\ BA",
"55193678", "Canoas\ \-\ SP",
"55813341", "Recife\ \-\ PE",
"55433132", "Cornélio\ Procópio\ \-\ PR",
"55273754", "Montanha\ \-\ ES",
"55543345", "Sertão\ \-\ RS",
"55343355", "Pedrinópolis\ \-\ MG",
"55923361", "Manacapuru\ \-\ AM",
"55543042", "Farroupilha\ \-\ RS",
"55883541", "Várzea\ Alegre\ \-\ CE",
"55222552", "Santa\ Rita\ da\ Floresta\ \-\ RJ",
"55633428", "Araguanã\ \-\ TO",
"55193017", "Indaiatuba\ \-\ SP",
"55213611", "São\ Gonçalo\ \-\ RJ",
"55333312", "Mutum\ \-\ MG",
"55673043", "Campo\ Grande\ \-\ MS",
"55443366", "Maringá\ \-\ PR",
"5511352", "São\ Paulo\ \-\ SP",
"55693449", "Rolim\ de\ Moura\ \-\ RO",
"55433541", "Uraí\ \-\ PR",
"55493251", "Lages\ \-\ SC",
"55143629", "Potunduva\ \-\ SP",
"55115852", "São\ Paulo\ \-\ SP",
"55313526", "Minas\ Gerais",
"55613307", "Brasília\ \-\ DF",
"55143441", "Tupã\ \-\ SP",
"55443571", "Luiziana\ \-\ PR",
"55443218", "Maringá\ \-\ PR",
"55313123", "Belo\ Horizonte\ \-\ MG",
"55693621", "São\ Francisco\ do\ Guaporé\ \-\ RO",
"55633025", "Palmas\ \-\ TO",
"55643431", "Itumbiara\ \-\ GO",
"55473465", "Joinville\ \-\ SC",
"55893553", "Júlio\ Borges\ \-\ PI",
"55973417", "Atalaia\ do\ Norte\ \-\ AM",
"55193439", "Saltinho\ \-\ SP",
"55684001", "Rio\ Branco\ \-\ AC",
"55913811", "Ipixuna\ do\ Pará\ \-\ PA",
"55633322", "Palmas\ \-\ TO",
"55553201", "Santo\ Ângelo\ \-\ RS",
"55843273", "São\ José\ de\ Mipibu\ \-\ RN",
"5531322", "Belo\ Horizonte\ \-\ MG",
"55323254", "Piau\ \-\ MG",
"55713026", "Lauro\ de\ Freitas\ \-\ BA",
"55973484", "Itamarati\ \-\ AM",
"55413623", "Quitandinha\ \-\ PR",
"55483061", "Criciúma\ \-\ SC",
"55623511", "Inhumas\ \-\ GO",
"55333435", "Coluna\ \-\ MG",
"55323463", "Volta\ Grande\ \-\ MG",
"55913366", "Belém\ \-\ PA",
"55114761", "Mogi\ das\ Cruzes\ \-\ SP",
"55823346", "Maceió\ \-\ AL",
"55623588", "Aparecida\ de\ Goiânia\ \-\ GO",
"55983371", "Governador\ Nunes\ Freire\ \-\ MA",
"55624017", "Aparecida\ de\ Goiânia\ \-\ GO",
"55673261", "Bandeirantes\ \-\ MS",
"55893462", "Oeiras\ \-\ PI",
"55693447", "Parecis\ \-\ RO",
"55633691", "Rio\ da\ Conceição\ \-\ TO",
"55163204", "Jaboticabal\ \-\ SP",
"55732101", "Ilhéus\ \-\ BA",
"55123112", "Potim\ \-\ SP",
"55673202", "Campo\ Grande\ \-\ MS",
"55193019", "Mogi\-Guaçu\ \-\ SP",
"55873788", "Angelim\ \-\ PE",
"55793217", "Aracaju\ \-\ SE",
"55633351", "Gurupi\ \-\ TO",
"55453283", "Margarida\ \-\ PR",
"55114702", "Cotia\ \-\ SP",
"55953621", "Boa\ Vista\ \-\ RR",
"55643682", "Turvânia\ \-\ GO",
"55272101", "Colatina\ \-\ ES",
"55123221", "Caçapava\ \-\ SP",
"55743552", "Campo\ Formoso\ \-\ BA",
"5511434", "São\ Bernardo\ do\ Campo\ \-\ SP",
"55643088", "Itumbiara\ \-\ GO",
"55283531", "Itapemirim\ \-\ ES",
"55813654", "Salgadinho\ \-\ PE",
"55753402", "Entre\ Rios\ \-\ BA",
"55183646", "Brejo\ Alegre\ \-\ SP",
"55112703", "São\ Paulo\ \-\ SP",
"55983487", "Paulino\ Neves\ \-\ MA",
"55543359", "Vila\ Maria\ \-\ RS",
"55643942", "Itumbiara\ \-\ GO",
"55793272", "Japaratuba\ \-\ SE",
"55163821", "Orlândia\ \-\ SP",
"55823231", "Maceió\ \-\ AL",
"55173281", "Olímpia\ \-\ SP",
"55993666", "Santo\ Antônio\ dos\ Lopes\ \-\ MA",
"55114142", "Itapevi\ \-\ SP",
"55373271", "Pitangui\ \-\ MG",
"55153297", "Araçoiaba\ da\ Serra\ \-\ SP",
"55613458", "Samambaia\ Sul\ \-\ DF",
"55553595", "Tuparendi\ \-\ RS",
"5561219", "Brasília\ \-\ DF",
"55623473", "Iaciara\ \-\ GO",
"55433565", "São\ José\ da\ Boa\ Vista\ \-\ PR",
"55143601", "Jaú\ \-\ SP",
"55933517", "Creporizão\ \-\ PA",
"55493323", "Chapecó\ \-\ SC",
"55673250", "Corguinho\ \-\ MS",
"55423533", "Antônio\ Olinto\ \-\ PR",
"55473629", "Bela\ Vista\ do\ Toldo\ \-\ SC",
"55114759", "Suzano\ \-\ SP",
"55173571", "Santa\ Adélia\ \-\ SP",
"55212631", "Magé\ \-\ RJ",
"55613055", "Brasília\ \-\ DF",
"55383799", "Curvelo\ \-\ MG",
"55453206", "Agro\ Cafeeira\ \-\ PR",
"55193546", "Cordeirópolis\ \-\ SP",
"55663535", "Sinop\ \-\ MT",
"55513763", "Rio\ Grande\ do\ Sul",
"55633369", "Novo\ Acordo\ \-\ TO",
"55613352", "Taguatinga\ \-\ DF",
"55843637", "Bento\ Fernandes\ \-\ RN",
"55543286", "Gramado\ \-\ RS",
"55833490", "Bonito\ de\ Santa\ Fé\ \-\ PB",
"55513614", "Maratá\ \-\ RS",
"55153248", "Ibiúna\ \-\ SP",
"55114531", "Jundiaí\ \-\ SP",
"55513680", "Quintão\ \-\ RS",
"55893427", "Tanque\ do\ Piauí\ \-\ PI",
"55773438", "Cândido\ Sales\ \-\ BA",
"55143662", "Bariri\ \-\ SP",
"55883565", "Acopiara\ \-\ CE",
"55453411", "Cascavel\ \-\ PR",
"55313866", "Dom\ Joaquim\ \-\ MG",
"55243421", "Angra\ dos\ Reis\ \-\ RJ",
"55743636", "Caém\ \-\ BA",
"55543361", "Sarandi\ \-\ RS",
"55843384", "Pilões\ \-\ RN",
"55693536", "Ariquemes\ \-\ RO",
"55623326", "Jaraguá\ \-\ GO",
"55513689", "Xangri\-Lá\ \-\ RS",
"55833499", "Aguiar\ \-\ PB",
"55114349", "São\ Paulo\ \-\ SP",
"55163958", "Taquaral\ \-\ SP",
"55553311", "Santa\ Maria\ \-\ RS",
"55613272", "Brasília\ \-\ DF",
"55143346", "Bernardino\ de\ Campos\ \-\ SP",
"55853404", "Fortaleza\ \-\ CE",
"55713652", "São\ Francisco\ do\ Conde\ \-\ BA",
"55624053", "Goiânia\ \-\ GO",
"55353334", "Carmo\ de\ Minas\ \-\ MG",
"55853369", "Maranguape\ \-\ CE",
"55673435", "Antônio\ João\ \-\ MS",
"55493907", "Lages\ \-\ SC",
"55943434", "Ourilândia\ do\ Norte\ \-\ PA",
"55163387", "Nova\ Europa\ \-\ SP",
"55613217", "Brasília\ \-\ DF",
"55173445", "Américo\ de\ Campos\ \-\ SP",
"55753235", "Candeal\ \-\ BA",
"55333261", "Conselheiro\ Pena\ \-\ MG",
"55373691", "Divinópolis\ \-\ MG",
"55192118", "Hortolândia\ \-\ SP",
"55833198", "João\ Pessoa\ \-\ PB",
"55423676", "Faxinal\ da\ Boa\ Vista\ \-\ PR",
"55843221", "Natal\ \-\ RN",
"55333202", "Governador\ Valadares\ \-\ MG",
"55163995", "Ribeirão\ Preto\ \-\ SP",
"55173642", "Vitória\ Brasil\ \-\ SP",
"55673038", "Dourados\ \-\ MS",
"55863243", "Porto\ \-\ PI",
"55483721", "Florianópolis\ \-\ SC",
"55373351", "Arcos\ \-\ MG",
"55183263", "Santo\ Anastácio\ \-\ SP",
"55383563", "São\ Gonçalo\ do\ Abaeté\ \-\ MG",
"55443523", "Campo\ Mourão\ \-\ PR",
"55623364", "São\ Miguel\ do\ Araguaia\ \-\ GO",
"55464055", "Pato\ Branco\ \-\ PR",
"55114021", "Salto\ \-\ SP",
"55513590", "São\ Leopoldo\ \-\ RS",
"55733543", "Itaquara\ \-\ BA",
"55513599", "Sapiranga\ \-\ RS",
"55693026", "Porto\ Velho\ \-\ RO",
"55813446", "Recife\ \-\ PE",
"55983269", "São\ Luís\ \-\ MA",
"55213842", "Duque\ de\ Caxias\ \-\ RJ",
"55513676", "Arambaré\ \-\ RS",
"55213540", "Nova\ Iguaçu\ \-\ RJ",
"5584331", "Mossoró\ \-\ RN",
"55883684", "Ipaporanga\ \-\ CE",
"55143815", "Botucatu\ \-\ SP",
"55883619", "Forquilha\ \-\ CE",
"55833433", "Coremas\ \-\ PB",
"55183362", "Paraguaçu\ Paulista\ \-\ SP",
"55853351", "Trairi\ \-\ CE",
"55623092", "Goiânia\ \-\ GO",
"55223723", "Macaé\ \-\ RJ",
"55222031", "Saquarema\ \-\ RJ",
"55133852", "Ariri\ \-\ SP",
"55793352", "Neópolis\ \-\ SE",
"55543279", "Linha\ Oitenta\ \-\ RS",
"55533240", "Bagé\ \-\ RS",
"55913445", "Santa\ Luzia\ do\ Pará\ \-\ PA",
"55983524", "Imperatriz\ \-\ MA",
"55673901", "Campo\ Grande\ \-\ MS",
"5571323", "Salvador\ \-\ BA",
"55693230", "Candeias\ do\ Jamari\ \-\ RO",
"55383733", "Francisco\ Dumont\ \-\ MG",
"55693239", "Campo\ Novo\ de\ Rondônia\ \-\ RO",
"55813537", "Chã\ Grande\ \-\ PE",
"55533249", "Hulha\ Negra\ \-\ RS",
"55112891", "Suzano\ \-\ SP",
"55313262", "Belo\ Horizonte\ \-\ MG",
"55623358", "Santa\ Isabel\ \-\ GO",
"55114007", "São\ Paulo\ \-\ SP",
"55313201", "Belo\ Horizonte\ \-\ MG",
"55773686", "Serra\ Dourada\ \-\ BA",
"55213780", "Duque\ de\ Caxias\ \-\ RJ",
"5555322", "Santa\ Maria\ \-\ RS",
"55333528", "Teófilo\ Otoni\ \-\ MG",
"55224104", "Macaé\ \-\ RJ",
"55433337", "Londrina\ \-\ PR",
"55213789", "Mangaratiba\ \-\ RJ",
"55323031", "Juiz\ de\ Fora\ \-\ MG",
"55323374", "Rio\ das\ Mortes\ \-\ MG",
"55193891", "Mogi\-Guaçu\ \-\ SP",
"55183301", "Araçatuba\ \-\ SP",
"55483433", "Criciúma\ \-\ SC",
"55472122", "Balneário\ Camboriú\ \-\ SC",
"55433619", "Ibaiti\ \-\ PR",
"55553526", "Sede\ Nova\ \-\ RS",
"55163116", "São\ Carlos\ \-\ SP",
"55113501", "São\ Paulo\ \-\ SP",
"55444003", "Maringá\ \-\ PR",
"55115634", "São\ Paulo\ \-\ SP",
"55123637", "Moreira\ César\ \-\ SP",
"55163513", "Sertãozinho\ \-\ SP",
"55193779", "Campinas\ \-\ SP",
"55493566", "Videira\ \-\ SC",
"55813751", "Frei\ Miguelinho\ \-\ PE",
"55173523", "Catanduva\ \-\ SP",
"55273344", "Viana\ \-\ ES",
"55353296", "Fama\ \-\ MG",
"55914003", "Belém\ \-\ PA",
"55443048", "Sarandi\ \-\ PR",
"55773443", "Caraíbas\ \-\ BA",
"55313913", "Contagem\ \-\ MG",
"5579", "Sergipe",
"55843353", "São\ Miguel\ \-\ RN",
"55623421", "Alvorada\ do\ Norte\ \-\ GO",
"55433339", "Londrina\ \-\ PR",
"55873763", "Garanhuns\ \-\ PE",
"55443642", "Guaíra\ \-\ PR",
"55213787", "Seropédica\ \-\ RJ",
"55733622", "Mucuri\ \-\ BA",
"55453268", "Santa\ Helena\ \-\ PR",
"55114000", "Arujá\ \-\ SP",
"55463565", "Flor\ da\ Serra\ do\ Sul\ \-\ PR",
"55353533", "Pratápolis\ \-\ MG",
"55963282", "Santana\ \-\ AP",
"55114009", "São\ Paulo\ \-\ SP",
"55133821", "Registro\ \-\ SP",
"55454062", "Cascavel\ \-\ PR",
"55512", "Rio\ Grande\ do\ Sul",
"55342108", "Araguari\ \-\ MG",
"55853322", "Ocara\ \-\ CE",
"55112712", "São\ Paulo\ \-\ SP",
"55843693", "Touros\ \-\ RN",
"55693237", "Porto\ Velho\ \-\ RO",
"55454001", "Cascavel\ \-\ PR",
"55443445", "São\ João\ do\ Caiuá\ \-\ PR",
"55753413", "Esplanada\ \-\ BA",
"55213555", "Rio\ de\ Janeiro\ \-\ RJ",
"55883672", "Nova\ Russas\ \-\ CE",
"55533247", "Bagé\ \-\ RS",
"5512320", "São\ José\ dos\ Campos\ \-\ SP",
"55433475", "Jardim\ Alegre\ \-\ PR",
"55383823", "Riacho\ dos\ Machados\ \-\ MG",
"55114664", "Embu\-Guaçu\ \-\ SP",
"55883617", "Tamboril\ \-\ CE",
"55633535", "Marianópolis\ do\ Tocantins\ \-\ TO",
"55473346", "Itajaí\ \-\ SC",
"55223833", "Bom\ Jesus\ do\ Itabapoana\ \-\ RJ",
"55533255", "Pedro\ Osório\ \-\ RS",
"55193844", "Paulínia\ \-\ SP",
"55333245", "Divino\ das\ Laranjeiras\ \-\ MG",
"55673213", "Campo\ Grande\ \-\ MS",
"55173461", "General\ Salgado\ \-\ SP",
"55123103", "Cachoeira\ Paulista\ \-\ SP",
"55113264", "Salvador\ \-\ BA",
"55163256", "Santa\ Ernestina\ \-\ SP",
"55143285", "Cabrália\ Paulista\ \-\ SP",
"55513597", "Campo\ Bom\ \-\ RS",
"55623407", "São\ Miguel\ do\ Passa\ Quatro\ \-\ GO",
"55313734", "Belo\ Vale\ \-\ MG",
"55313220", "Minas\ Gerais",
"55193053", "Leme\ \-\ SP",
"55142122", "Avaré\ \-\ SP",
"55483215", "Florianópolis\ \-\ SC",
"55453254", "Marechal\ Cândido\ Rondon\ \-\ PR",
"55633456", "Augustinópolis\ \-\ TO",
"55983323", "Centro\ do\ Guilherme\ \-\ MA",
"55432103", "Londrina\ \-\ PR",
"55513711", "Santa\ Cruz\ do\ Sul\ \-\ RS",
"55653624", "Cuiabá\ \-\ MT",
"5519343", "Piracicaba\ \-\ SP",
"55313229", "Minas\ Gerais",
"55193493", "Rio\ das\ Pedras\ \-\ SP",
"55174003", "São\ José\ do\ Rio\ Preto\ \-\ SP",
"55513788", "Progresso\ \-\ RS",
"55713621", "Camaçari\ \-\ BA",
"55813683", "Maraial\ \-\ PE",
"5514362", "Jaú\ \-\ SP",
"55714112", "Salvador\ \-\ BA",
"55183329", "Tarumã\ \-\ SP",
"55114695", "Guararema\ \-\ SP",
"55413671", "Quatro\ Barras\ \-\ PR",
"55113135", "São\ Bernardo\ do\ Campo\ \-\ SP",
"55753218", "Salgadália\ \-\ BA",
"55212734", "Rio\ Bonito\ \-\ RJ",
"55673481", "Amambaí\ \-\ MS",
"55884102", "Crato\ \-\ CE",
"55473231", "Blumenau\ \-\ SC",
"55114052", "São\ Paulo\ \-\ SP",
"55114492", "Jundiaí\ \-\ SP",
"55653057", "Cuiabá\ \-\ MT",
"55323283", "Rio\ Preto\ \-\ MG",
"55973453", "Boca\ do\ Acre\ \-\ AM",
"55163389", "São\ Lourenço\ do\ Turvo\ \-\ SP",
"55323573", "Piraúba\ \-\ MG",
"55123186", "Cachoeira\ Paulista\ \-\ SP",
"55793113", "Nossa\ Senhora\ do\ Socorro\ \-\ SE",
"55313558", "Mariana\ \-\ MG",
"55513548", "Riozinho\ \-\ RS",
"55823629", "Ouro\ Branco\ \-\ AL",
"55913605", "Anajás\ \-\ PA",
"55843252", "Sítio\ Novo\ \-\ RN",
"55653342", "Denise\ \-\ MT",
"55893572", "Parnaguá\ \-\ PI",
"55383647", "Formoso\ \-\ MG",
"55753281", "Paulo\ Afonso\ \-\ BA",
"55983476", "Santa\ Quitéria\ do\ Maranhão\ \-\ MA",
"55823620", "Dois\ Riachos\ \-\ AL",
"55613574", "Brasília\ \-\ DF",
"55673418", "Itaum\ \-\ MS",
"55114658", "Igaratá\ \-\ SP",
"55112493", "Atibaia\ \-\ SP",
"55373322", "Formiga\ \-\ MG",
"55913461", "Colares\ \-\ PA",
"55833215", "João\ Pessoa\ \-\ PB",
"55733667", "Itamaraju\ \-\ BA",
"55673929", "Três\ Lagoas\ \-\ MS",
"55273080", "Serra\ \-\ ES",
"55493351", "Entre\ Rios\ \-\ SC",
"55383226", "Coração\ de\ Jesus\ \-\ MG",
"55192108", "Americana\ \-\ SP",
"55323429", "Cataguases\ \-\ MG",
"55333755", "Águas\ Vermelhas\ \-\ MG",
"55913032", "Ananindeua\ \-\ PA",
"55683462", "Tarauacá\ \-\ AC",
"55883447", "Limoeiro\ do\ Norte\ \-\ CE",
"55352106", "Varginha\ \-\ MG",
"55813771", "Bom\ Conselho\ \-\ PE",
"55413669", "Pinhais\ \-\ PR",
"55833343", "Campina\ Grande\ \-\ PB",
"55983878", "São\ Luís\ \-\ MA",
"55242255", "Três\ Rios\ \-\ RJ",
"55333747", "Santo\ Antônio\ do\ Jacinto\ \-\ MG",
"55115044", "São\ Paulo\ \-\ SP",
"55753643", "Valença\ \-\ BA",
"55123971", "São\ Bento\ do\ Sapucaí\ \-\ SP",
"55553301", "Santa\ Maria\ \-\ RS",
"55843373", "Rodolfo\ Fernandes\ \-\ RN",
"5513346", "São\ Vicente\ \-\ SP",
"55514116", "Porto\ Alegre\ \-\ RS",
"55642104", "Rio\ Verde\ \-\ GO",
"55413543", "Rio\ Negro\ \-\ PR",
"55683216", "Rio\ Branco\ \-\ AC",
"55623928", "Goiânia\ \-\ GO",
"55613568", "Guará\ \-\ DF",
"55413146", "São\ José\ dos\ Pinhais\ \-\ PR",
"55553362", "Dezesseis\ de\ Novembro\ \-\ RS",
"55343844", "Grupiara\ \-\ MG",
"55483343", "São\ José\ \-\ SC",
"55623484", "Mambaí\ \-\ GO",
"55883652", "Guaraciaba\ do\ Norte\ \-\ CE",
"55423234", "Colônia\ Castrolanda\ \-\ PR",
"55843426", "Serra\ Negra\ do\ Norte\ \-\ RN",
"55773613", "Barreiras\ \-\ BA",
"55793319", "Gracho\ Cardoso\ \-\ SE",
"55553796", "Alpestre\ \-\ RS",
"55143547", "Guaiçara\ \-\ SP",
"55353067", "Varginha\ \-\ MG",
"55533275", "Capão\ do\ Leão\ \-\ RS",
"5561331", "Brasília\ \-\ DF",
"55193585", "Porto\ Ferreira\ \-\ SP",
"55333212", "Governador\ Valadares\ \-\ MG",
"55123876", "São\ José\ dos\ Campos\ \-\ SP",
"55193626", "Santa\ Bárbara\ D\'Oeste\ \-\ SP",
"55553263", "Faxinal\ do\ Soturno\ \-\ RS",
"55633476", "Colinas\ do\ Tocantins\ \-\ TO",
"55453274", "Toledo\ \-\ PR",
"55923528", "Silves\ \-\ AM",
"55873893", "Itacuruba\ \-\ PE",
"55553327", "Salto\ do\ Jacuí\ \-\ RS",
"55943344", "Nova\ Ipixuna\ \-\ PA",
"5512388", "Caraguatatuba\ \-\ SP",
"55173335", "Colômbia\ \-\ SP",
"55483242", "Palhoça\ \-\ SC",
"55433133", "Cornélio\ Procópio\ \-\ PR",
"55353444", "Jacutinga\ \-\ MG",
"55353022", "Pouso\ Alegre\ \-\ MG",
"55822123", "Maceió\ \-\ AL",
"55433536", "Ribeirão\ Claro\ \-\ PR",
"55192511", "Campinas\ \-\ SP",
"55413651", "São\ Luiz\ do\ Purunã\ \-\ PR",
"55433064", "Londrina\ \-\ PR",
"55173638", "Mesópolis\ \-\ SP",
"55333313", "Inhapim\ \-\ MG",
"55353325", "Andrelândia\ \-\ MG",
"55222553", "Cantagalo\ \-\ RJ",
"55993635", "Lago\ Verde\ \-\ MA",
"55973473", "São\ Gabriel\ da\ Cachoeira\ \-\ AM",
"55483717", "Florianópolis\ \-\ SC",
"55383675", "Bonfinópolis\ de\ Minas\ \-\ MG",
"55413391", "Campo\ Largo\ \-\ PR",
"55743665", "Jacobina\ \-\ BA",
"55883536", "Lavras\ da\ Mangabeira\ \-\ CE",
"55115853", "São\ Paulo\ \-\ SP",
"55313835", "Itabira\ \-\ MG",
"55183311", "Presidente\ Prudente\ \-\ SP",
"55483591", "Jacinto\ Machado\ \-\ SC",
"55513234", "Rio\ Grande\ do\ Sul",
"55663566", "Juína\ \-\ MT",
"55513720", "Estrêla\ \-\ RS",
"55893552", "Guadalupe\ \-\ PI",
"55613554", "Brasília\ \-\ DF",
"55313578", "Piedade\ dos\ Gerais\ \-\ MG",
"55313211", "Minas\ Gerais",
"55843272", "Parnamirim\ \-\ RN",
"55323553", "Guiricema\ \-\ MG",
"55513729", "Lajeado\ \-\ RS",
"55114017", "Jarinu\ \-\ SP",
"555139", "Rio\ Grande\ do\ Sul",
"55183866", "Flora\ Rica\ \-\ SP",
"55413622", "Lapa\ \-\ PR",
"55283546", "Venda\ Nova\ do\ Imigrante\ \-\ ES",
"55313881", "Ponte\ Nova\ \-\ MG",
"55114019", "Itu\ \-\ SP",
"55513727", "Rio\ Grande\ do\ Sul",
"55453306", "Cascavel\ \-\ PR",
"55222665", "Araruama\ \-\ RJ",
"55813616", "Goiana\ \-\ PE",
"55114084", "São\ Paulo\ \-\ SP",
"55653338", "Gleba\ Ranchão\ \-\ MT",
"55833544", "Marizópolis\ \-\ PB",
"55543386", "Muliterno\ \-\ RS",
"55183631", "Araçatuba\ \-\ SP",
"55473547", "Braço\ do\ Trombudo\ \-\ SC",
"55193702", "Limeira\ \-\ SP",
"55423656", "Goioxim\ \-\ PR",
"55323462", "Além\ Paraíba\ \-\ MG",
"55313725", "Caranaíba\ \-\ MG",
"55843284", "Serrinha\ \-\ RN",
"55923245", "Manaus\ \-\ AM",
"55543261", "Farroupilha\ \-\ RS",
"55813265", "Recife\ \-\ PE",
"55893521", "Floriano\ \-\ PI",
"55373371", "Piumhi\ \-\ MG",
"55453282", "Pato\ Bragado\ \-\ PR",
"55114703", "Cotia\ \-\ SP",
"55663489", "Ribeirão\ Cascalheira\ \-\ MT",
"55323401", "Leopoldina\ \-\ MG",
"55483003", "Florianópolis\ \-\ SC",
"55193761", "Campinas\ \-\ SP",
"55743553", "Campo\ Formoso\ \-\ BA",
"55553329", "Entre\ Ijuís\ \-\ RS",
"55173266", "Cedral\ \-\ SP",
"55483544", "Morro\ Grande\ \-\ SC",
"55923184", "Manaus\ \-\ AM",
"55624105", "Senador\ Canedo\ \-\ GO",
"55753522", "Castro\ Alves\ \-\ BA",
"55313151", "Sete\ Lagoas\ \-\ MG",
"55493367", "Sul\ Brasil\ \-\ SC",
"55114143", "Itapevi\ \-\ SP",
"5562400", "Goiânia\ \-\ GO",
"55133872", "Sete\ Barras\ \-\ SP",
"55743641", "Irecê\ \-\ BA",
"5511364", "São\ Paulo\ \-\ SP",
"55333514", "Malacacheta\ \-\ MG",
"55433440", "Pirapó\ \-\ PR",
"55863315", "Parnaíba\ \-\ PI",
"55853371", "Maracanaú\ \-\ CE",
"55693541", "Guajará\-Mirim\ \-\ RO",
"55714102", "Salvador\ \-\ BA",
"55733671", "Santa\ Cruz\ Cabrália\ \-\ BA",
"55143842", "São\ Manuel\ \-\ SP",
"55513656", "Arroio\ dos\ Ratos\ \-\ RS",
"55133579", "São\ Vicente\ \-\ SP",
"55323694", "Leopoldina\ \-\ MG",
"55123321", "São\ José\ dos\ Campos\ \-\ SP",
"55423532", "São\ Mateus\ do\ Sul\ \-\ PR",
"55493322", "Chapecó\ \-\ SC",
"55513701", "Rio\ Grande\ do\ Sul",
"55963521", "Oiapoque\ \-\ AP",
"55493025", "Chapecó\ \-\ SC",
"55643539", "Itumbiara\ \-\ GO",
"55913412", "Castanhal\ \-\ PA",
"55483205", "Florianópolis\ \-\ SC",
"55543259", "Nova\ Sardenha\ \-\ RS",
"55343249", "Araguari\ \-\ MG",
"55114786", "Taboão\ da\ Serra\ \-\ SP",
"55323354", "Resende\ Costa\ \-\ MG",
"55633524", "Porto\ Alegre\ do\ Tocantins\ \-\ TO",
"55543528", "Itatiba\ do\ Sul\ \-\ RS",
"55613353", "Taguatinga\ \-\ DF",
"55312191", "Contagem\ \-\ MG",
"55493644", "Dionísio\ Cerqueira\ \-\ SC",
"55413667", "Pinhais\ \-\ PR",
"55143714", "Cerqueira\ César\ \-\ SP",
"55623378", "Itauçu\ \-\ GO",
"55212646", "São\ Gonçalo\ \-\ RJ",
"55673286", "Camapuã\ \-\ MS",
"55513762", "Rio\ Grande\ do\ Sul",
"55883449", "Senador\ Pompeu\ \-\ CE",
"55983271", "São\ Luís\ \-\ MA",
"55483086", "Palhoça\ \-\ SC",
"55883621", "Camocim\ \-\ CE",
"55163304", "Araraquara\ \-\ SP",
"55513396", "Rio\ Grande\ do\ Sul",
"55753208", "Campinhos\ \-\ BA",
"55663508", "Santo\ Antônio\ Fontoura\ \-\ MT",
"55413056", "Pinhais\ \-\ PR",
"55873837", "Iguaraci\ \-\ PE",
"55613273", "Brasília\ \-\ DF",
"55813431", "Olinda\ \-\ PE",
"55115819", "São\ Paulo\ \-\ SP",
"55323274", "Rio\ Novo\ \-\ MG",
"55624052", "Goiânia\ \-\ GO",
"55633487", "São\ Bento\ do\ Tocantins\ \-\ TO",
"55463536", "Dois\ Vizinhos\ \-\ PR",
"55212796", "Mesquita\ \-\ RJ",
"55543435", "Boa\ Vista\ do\ Sul\ \-\ RS",
"55773661", "Candiba\ \-\ BA",
"55663476", "Araguainha\ \-\ MT",
"55512106", "Santa\ Cruz\ do\ Sul\ \-\ RS",
"55733291", "Teixeira\ de\ Freitas\ \-\ BA",
"55923213", "Manaus\ \-\ AM",
"55983351", "Viana\ \-\ MA",
"55493535", "Arroio\ Trinta\ \-\ SC",
"55173643", "Santa\ Rita\ D\'Oeste\ \-\ SP",
"55513067", "Novo\ Hamburgo\ \-\ RS",
"55543038", "Garibaldi\ \-\ RS",
"55212301", "Rio\ de\ Janeiro\ \-\ RJ",
"55173801", "Riolândia\ \-\ SP",
"55633371", "Paranã\ \-\ TO",
"5584321", "Natal\ \-\ RN",
"55333203", "Governador\ Valadares\ \-\ MG",
"55183262", "Presidente\ Bernardes\ \-\ SP",
"55123145", "Cruzeiro\ \-\ SP",
"55863242", "Barras\ \-\ PI",
"55913739", "Paragominas\ \-\ PA",
"55793252", "Aracaju\ \-\ SE",
"55543379", "Coxilha\ \-\ RS",
"55733542", "Km\ Cem\ \-\ BA",
"55443522", "Goioerê\ \-\ PR",
"55623520", "Goiânia\ \-\ GO",
"55383562", "Brasilândia\ de\ Minas\ \-\ MG",
"55222519", "Nova\ Friburgo\ \-\ RJ",
"55623529", "Brazabrantes\ \-\ GO",
"55123157", "Lorena\ \-\ SP",
"55242437", "Ipiabas\ \-\ RJ",
"55543632", "Passo\ Fundo\ \-\ RS",
"5519375", "Campinas\ \-\ SP",
"5561320", "Brasília\ \-\ DF",
"55843321", "Mossoró\ \-\ RN",
"55213601", "Niterói\ \-\ RJ",
"55313094", "Ipatinga\ \-\ MG",
"55613478", "Sobradinho\ \-\ DF",
"55863343", "Piracuruca\ \-\ PI",
"5584", "Rio\ Grande\ do\ Norte",
"55513444", "Viamão\ \-\ RS",
"55152107", "Porto\ Feliz\ \-\ SP",
"5524224", "Petrópolis\ \-\ RJ",
"55114891", "Bom\ Jesus\ dos\ Perdões\ \-\ SP",
"55623093", "Goiânia\ \-\ GO",
"55513628", "Maquiné\ \-\ RS",
"55813723", "Caruaru\ \-\ PE",
"55933552", "Placas\ \-\ PA",
"55173551", "Ibirá\ \-\ SP",
"55613506", "Brasília\ \-\ DF",
"55313327", "Belo\ Horizonte\ \-\ MG",
"55313263", "Belo\ Horizonte\ \-\ MG",
"55983369", "Santo\ Amaro\ do\ Maranhão\ \-\ MA",
"55383527", "Turmalina\ \-\ MG",
"55443567", "Quinta\ do\ Sol\ \-\ PR",
"55114779", "Itapecerica\ da\ Serra\ \-\ SP",
"5533327", "Governador\ Valadares\ \-\ MG",
"55853260", "Eusébio\ \-\ CE",
"55753638", "Governador\ Mangabeira\ \-\ BA",
"55373524", "Martinho\ Campos\ \-\ MG",
"5513328", "Santos\ \-\ SP",
"55353729", "Poços\ de\ Caldas\ \-\ MG",
"55473385", "Benedito\ Novo\ \-\ SC",
"55653003", "Cuiabá\ \-\ MT",
"55613639", "Planaltina\ \-\ GO",
"55493456", "Campina\ da\ Alegria\ \-\ SC",
"55643593", "Itumbiara\ \-\ GO",
"55923312", "Balbina\ \-\ AM",
"55173827", "Potirendaba\ \-\ SP",
"55472123", "Blumenau\ \-\ SC",
"55753335", "Andaraí\ \-\ BA",
"55483432", "Içara\ \-\ SC",
"55153534", "Taquarivaí\ \-\ SP",
"55163287", "Vista\ Alegre\ do\ Alto\ \-\ SP",
"55163810", "São\ Joaquim\ da\ Barra\ \-\ SP",
"55942101", "Marabá\ \-\ PA",
"55113421", "Mauá\ \-\ SP",
"55163512", "Ribeirão\ Preto\ \-\ SP",
"55833635", "Damião\ \-\ PB",
"55933521", "Vila\ Residencial\ Belo\ Monte\ \-\ PA",
"55173522", "Catanduva\ \-\ SP",
"55163214", "Araraquara\ \-\ SP",
"55183558", "Sagres\ \-\ SP",
"55833077", "Campina\ Grande\ \-\ PB",
"55114255", "Mogi\ das\ Cruzes\ \-\ SP",
"55514", "Rio\ Grande\ do\ Sul",
"55173829", "Talhado\ \-\ SP",
"55753266", "Araci\ \-\ BA",
"55773442", "Buritirama\ \-\ BA",
"55313912", "Contagem\ \-\ MG",
"55733623", "Firmino\ Alves\ \-\ BA",
"55115696", "São\ Paulo\ \-\ SP",
"55643668", "Serranópolis\ \-\ GO",
"55353532", "São\ Sebastião\ do\ Paraíso\ \-\ MG",
"55513491", "Guaíba\ \-\ RS",
"55193713", "Limeira\ \-\ SP",
"55613637", "Planaltina\ \-\ GO",
"55673466", "Glória\ de\ Dourados\ \-\ MS",
"55443643", "Francisco\ Alves\ \-\ PR",
"55863086", "Teresina\ \-\ PI",
"55753381", "Varzedo\ \-\ BA",
"55853323", "Tejuçuoca\ \-\ CE",
"55114247", "Barueri\ \-\ SP",
"55373222", "Divinópolis\ \-\ MG",
"55833315", "Campina\ Grande\ \-\ PB",
"55513051", "Canoas\ \-\ RS",
"55963283", "Santana\ \-\ AP",
"55454063", "Cascavel\ \-\ PR",
"55313320", "Ipaba\ \-\ MG",
"55883673", "Itapipoca\ \-\ CE",
"55843692", "Lagoa\ de\ Pedras\ \-\ RN",
"55983367", "Humberto\ de\ Campos\ \-\ MA",
"55893488", "Jacobina\ do\ Piauí\ \-\ PI",
"5585348", "Fortaleza\ \-\ CE",
"55443569", "Juranda\ \-\ PR",
"55114777", "Cotia\ \-\ SP",
"55383822", "Janaúba\ \-\ MG",
"55713594", "Simões\ Filho\ \-\ BA",
"55993544", "Loreto\ \-\ MA",
"55773657", "Tabocas\ do\ Brejo\ Velho\ \-\ BA",
"55313329", "Minas\ Gerais",
"55113395", "Jundiaí\ \-\ SP",
"55273076", "Cariacica\ \-\ ES",
"55753477", "Chorrochó\ \-\ BA",
"55223832", "Rosal\ \-\ RJ",
"55193000", "Vinhedo\ \-\ SP",
"55114138", "Taboão\ da\ Serra\ \-\ SP",
"55183229", "Presidente\ Prudente\ \-\ SP",
"55823555", "São\ Brás\ \-\ AL",
"55623956", "Goiânia\ \-\ GO",
"55112664", "Barueri\ \-\ SP",
"55123102", "Silveiras\ \-\ SP",
"55123426", "Taubaté\ \-\ SP",
"55773645", "Boquira\ \-\ BA",
"55643654", "Cachoeira\ Alta\ \-\ GO",
"55123159", "Lorena\ \-\ SP",
"55623527", "Araçu\ \-\ GO",
"55333357", "Dom\ Cavati\ \-\ MG",
"55193492", "Capivari\ \-\ SP",
"55543377", "Santo\ Antônio\ do\ Planalto\ \-\ RS",
"55913829", "Tomé\-Açú\ \-\ PA",
"55242430", "Barra\ do\ Piraí\ \-\ RJ",
"55733244", "Itagibá\ \-\ BA",
"55222791", "Macaé\ \-\ RJ",
"55173486", "Álvares\ Florence\ \-\ SP",
"55443906", "Umuarama\ \-\ PR",
"55432102", "Apucarana\ \-\ PR",
"55353701", "Alfenas\ \-\ MG",
"55983322", "Boa\ Vista\ do\ Gurupi\ \-\ MA",
"551932", "Campinas\ \-\ SP",
"55543015", "Erechim\ \-\ RS",
"55714113", "Lauro\ de\ Freitas\ \-\ BA",
"55113409", "Suzano\ \-\ SP",
"55333345", "Chalé\ \-\ MG",
"55353656", "Consolação\ \-\ MG",
"55813682", "Joaquim\ Nabuco\ \-\ PE",
"55333424", "Senhora\ do\ Porto\ \-\ MG",
"55143385", "Tejupá\ \-\ SP",
"55193934", "Indaiatuba\ \-\ SP",
"55443551", "Iracema\ do\ Oeste\ \-\ PR",
"551122", "São\ Paulo\ \-\ SP",
"55213620", "Niterói\ \-\ RJ",
"55793221", "Aracaju\ \-\ SE",
"55112347", "São\ Paulo\ \-\ SP",
"55213629", "Niterói\ \-\ RJ",
"55173567", "Paraíso\ \-\ SP",
"5511443", "Santo\ André\ \-\ SP",
"55853111", "Fortaleza\ \-\ CE",
"55114493", "Várzea\ Paulista\ \-\ SP",
"55384009", "Montes\ Claros\ \-\ MG",
"55112658", "Poá\ \-\ SP",
"55513604", "Rio\ Grande\ do\ Sul",
"55323282", "Pedro\ Teixeira\ \-\ MG",
"55873830", "Solidão\ \-\ PE",
"55843253", "Bom\ Jesus\ \-\ RN",
"55115817", "São\ Paulo\ \-\ SP",
"55653343", "Arenápolis\ \-\ MT",
"55323572", "Silveirânia\ \-\ MG",
"55193695", "Mococa\ \-\ SP",
"55373323", "Pains\ \-\ MG",
"55183913", "Montalvão\ \-\ SP",
"55893573", "Corrente\ \-\ PI",
"55873839", "Alagoinha\ \-\ PE",
"55973423", "Fonte\ Boa\ \-\ AM",
"55463542", "Santa\ Izabel\ do\ Oeste\ \-\ PR",
"55653027", "Cuiabá\ \-\ MT",
"55443665", "Icaraíma\ \-\ PR",
"55853464", "Fortaleza\ \-\ CE",
"55183699", "Lourdes\ \-\ SP",
"55383625", "Varzelândia\ \-\ MG",
"55163472", "Araraquara\ \-\ SP",
"55114444", "Franco\ da\ Rocha\ \-\ SP",
"55333416", "Virginópolis\ \-\ MG",
"55114022", "Itu\ \-\ SP",
"55513115", "Canoas\ \-\ RS",
"55443401", "Cianorte\ \-\ PR",
"55513770", "Sério\ \-\ RS",
"55373352", "Arcos\ \-\ MG",
"5566", "Mato\ Grosso",
"55313528", "Belo\ Horizonte\ \-\ MG",
"55472107", "Jaraguá\ do\ Sul\ \-\ SC",
"55212303", "Rio\ de\ Janeiro\ \-\ RJ",
"55633373", "Almas\ \-\ TO",
"55843222", "Natal\ \-\ RN",
"55663321", "Rondonópolis\ \-\ MT",
"55513779", "Rio\ Grande\ do\ Sul",
"55173641", "Santa\ Fé\ do\ Sul\ \-\ SP",
"55483537", "Meleiro\ \-\ SC",
"55273064", "Serra\ \-\ ES",
"55333262", "Goiabeira\ \-\ MG",
"55613581", "Ceilândia\ \-\ DF",
"55753274", "Cansanção\ \-\ BA",
"55473534", "Agrolândia\ \-\ SC",
"55683615", "Santa\ Rosa\ do\ Purus\ \-\ AC",
"55983353", "Apicum\-Açu\ \-\ MA",
"55633426", "São\ Sebastião\ do\ Tocantins\ \-\ TO",
"55553377", "Pejuçara\ \-\ RS",
"55773663", "Morpará\ \-\ BA",
"55115904", "São\ Paulo\ \-\ SP",
"55193023", "Rio\ Claro\ \-\ SP",
"55733293", "Alcobaça\ \-\ BA",
"55553015", "Santa\ Maria\ \-\ RS",
"55813433", "Paulista\ \-\ PE",
"55443462", "Querência\ do\ Norte\ \-\ PR",
"55673474", "Mundo\ Novo\ \-\ MS",
"55553312", "Santo\ Ângelo\ \-\ RS",
"55313303", "Belo\ Horizonte\ \-\ MG",
"55613271", "Belo\ Horizonte\ \-\ MG",
"55353375", "Dom\ Viçoso\ \-\ MG",
"55973561", "Coari\ \-\ AM",
"55113559", "São\ Paulo\ \-\ SP",
"55713651", "São\ Francisco\ do\ Conde\ \-\ BA",
"55813707", "Frei\ Miguelinho\ \-\ PE",
"55733536", "Santa\ Inês\ \-\ BA",
"55493637", "Cristo\ Rei\ \-\ SC",
"55113502", "São\ Paulo\ \-\ SP",
"55623978", "Anápolis\ \-\ GO",
"55213139", "Rio\ de\ Janeiro\ \-\ RJ",
"55813155", "Gravatá\ \-\ PE",
"55942103", "Marabá\ \-\ PA",
"55113423", "São\ Bernardo\ do\ Campo\ \-\ SP",
"55213525", "Rio\ de\ Janeiro\ \-\ RJ",
"55183302", "Assis\ \-\ SP",
"55843476", "Santana\ do\ Seridó\ \-\ RN",
"55163904", "Ribeirão\ Preto\ \-\ SP",
"55643591", "Itumbiara\ \-\ GO",
"55913429", "Viseu\ \-\ PA",
"55142109", "Bauru\ \-\ SP",
"55323032", "Juiz\ de\ Fora\ \-\ MG",
"55193892", "Serra\ Negra\ \-\ SP",
"55493319", "Chapecó\ \-\ SC",
"55323335", "Piedade\ do\ Rio\ Grande\ \-\ MG",
"55692101", "Vilhena\ \-\ RO",
"55313202", "Belo\ Horizonte\ \-\ MG",
"55443427", "Porto\ Rico\ \-\ PR",
"55913803", "Bonito\ \-\ PA",
"55383746", "Ibiaí\ \-\ MG",
"55114067", "Diadema\ \-\ SP",
"55653365", "Cuiabá\ \-\ MT",
"55813198", "Recife\ \-\ PE",
"55183286", "Anhumas\ \-\ SP",
"55112892", "São\ Paulo\ \-\ SP",
"55313261", "Belo\ Horizonte\ \-\ MG",
"55173553", "São\ João\ de\ Itaguaçu\ \-\ SP",
"55793351", "Porto\ da\ Folha\ \-\ SE",
"55112599", "São\ Paulo\ \-\ SP",
"55613101", "Brasília\ \-\ DF",
"55673902", "Dourados\ \-\ MS",
"55813721", "Caruaru\ \-\ PE",
"55843267", "Ielmo\ Marinho\ \-\ RN",
"55313386", "Minas\ Gerais",
"55853352", "Pentecoste\ \-\ CE",
"55183361", "Paraguaçu\ Paulista\ \-\ SP",
"55114893", "Campo\ Limpo\ Paulista\ \-\ SP",
"55623091", "Goiânia\ \-\ GO",
"55113376", "São\ Paulo\ \-\ SP",
"55243356", "Pinheiral\ \-\ RJ",
"55133851", "Cananéia\ \-\ SP",
"55343839", "Patrocínio\ \-\ MG",
"55713669", "Palmares\ \-\ BA",
"55623451", "Campos\ Belos\ \-\ GO",
"55843323", "Mossoró\ \-\ RN",
"55713667", "Mata\ de\ São\ João\ \-\ BA",
"55793644", "Lagarto\ \-\ SE",
"55173462", "Fernandópolis\ \-\ SP",
"55913694", "Anapu\ \-\ PA",
"55153246", "Cesário\ Lange\ \-\ SP",
"55773436", "Barra\ do\ Choça\ \-\ BA",
"55423247", "Ivaí\ \-\ PR",
"55843260", "São\ Bento\ do\ Norte\ \-\ RN",
"55313868", "Conceição\ do\ Mato\ Dentro\ \-\ MG",
"55843269", "Riachuelo\ \-\ RN",
"5511472", "Mogi\ das\ Cruzes\ \-\ SP",
"55112597", "São\ Paulo\ \-\ SP",
"55133258", "Santos\ \-\ SP",
"55813831", "Serra\ Talhada\ \-\ PE",
"55623625", "Aparecida\ de\ Goiânia\ \-\ GO",
"55114069", "Diadema\ \-\ SP",
"55553556", "Redentora\ \-\ RS",
"55543288", "Gramado\ \-\ RS",
"55883671", "Tianguá\ \-\ CE",
"55513053", "Santa\ Cruz\ do\ Sul\ \-\ RS",
"55963281", "Santana\ \-\ AP",
"55193597", "Rio\ Claro\ \-\ SP",
"55133822", "Registro\ \-\ SP",
"55883434", "Ererê\ \-\ CE",
"55313504", "Belo\ Horizonte\ \-\ MG",
"55212868", "Rio\ de\ Janeiro\ \-\ RJ",
"55853321", "Guaramiranga\ \-\ CE",
"55443429", "Diamante\ do\ Norte\ \-\ PR",
"55443641", "Terra\ Boa\ \-\ PR",
"55114604", "Mairiporã\ \-\ SP",
"55733621", "Dário\ Meira\ \-\ BA",
"55142107", "Bauru\ \-\ SP",
"5585", "Ceará",
"55623503", "Abadia\ de\ Goiás\ \-\ GO",
"55513493", "Viamão\ \-\ RS",
"55123034", "Caraguatatuba\ \-\ SP",
"55133295", "Santos\ \-\ SP",
"55993668", "Timbiras\ \-\ MA",
"55412103", "Curitiba\ \-\ PR",
"55613456", "Taguatinga\ \-\ DF",
"55473333", "Indaial\ \-\ SC",
"55213137", "Rio\ de\ Janeiro\ \-\ RJ",
"55793322", "Propriá\ \-\ SE",
"55933523", "Santarém\ \-\ PA",
"55333734", "Itaobim\ \-\ MG",
"55183911", "Eneida\ \-\ SP",
"55753282", "Paulo\ Afonso\ \-\ BA",
"55623467", "Teresina\ de\ Goiás\ \-\ GO",
"55643086", "Itumbiara\ \-\ GO",
"55173694", "Dirce\ Reis\ \-\ SP",
"55913462", "Capanema\ \-\ PA",
"55813709", "Belo\ Jardim\ \-\ PE",
"55373321", "Formiga\ \-\ MG",
"55313245", "Belo\ Horizonte\ \-\ MG",
"55663495", "Primavera\ do\ Leste\ \-\ MT",
"55813700", "Caruaru\ \-\ PE",
"55183648", "Juritis\ \-\ SP",
"55513255", "Rio\ Grande\ do\ Sul",
"5537", "Minas\ Gerais",
"55613535", "Brasília\ \-\ DF",
"55843251", "São\ Paulo\ do\ Potengi\ \-\ RN",
"55653341", "Santo\ Antônio\ do\ Leverger\ \-\ MT",
"55853113", "Aquiraz\ \-\ CE",
"555133", "Porto\ Alegre\ \-\ RS",
"55553379", "Condor\ \-\ RS",
"55313854", "Rio\ Piracicaba\ \-\ MG",
"55132138", "Santos\ \-\ SP",
"55873786", "Iati\ \-\ PE",
"55613878", "Brasília\ \-\ DF",
"55793223", "Aracaju\ \-\ SE",
"55833539", "Triunfo\ \-\ PB",
"55443553", "Janiópolis\ \-\ PR",
"55183345", "Presidente\ Prudente\ \-\ SP",
"55413672", "Quatro\ Barras\ \-\ PR",
"55513777", "Putinga\ \-\ RS",
"55943337", "Brejo\ Grande\ do\ Araguaia\ \-\ PA",
"55623586", "Goiânia\ \-\ GO",
"55483539", "São\ João\ do\ Sul\ \-\ SC",
"55434101", "Apucarana\ \-\ PR",
"55553435", "Maçambara\ \-\ RS",
"55313184", "Itaguara\ \-\ MG",
"55712223", "Salvador\ \-\ BA",
"55713622", "Camaçari\ \-\ BA",
"55714111", "Camaçari\ \-\ BA",
"55823645", "Inhapi\ \-\ AL",
"55513712", "Estrêla\ \-\ RS",
"55223012", "Campos\ dos\ Goytacazes\ \-\ RJ",
"55313775", "Sete\ Lagoas\ \-\ MG",
"55913665", "Benevides\ \-\ PA",
"55173354", "São\ José\ do\ Rio\ Preto\ \-\ SP",
"55143764", "Iaras\ \-\ SP",
"55222793", "Macaé\ \-\ RJ",
"55353437", "Senador\ Amaral\ \-\ MG",
"55463244", "Sulina\ \-\ PR",
"55183697", "Rubiácea\ \-\ SP",
"55653029", "Várzea\ Grande\ \-\ MT",
"55473390", "Itajaí\ \-\ SC",
"55823534", "Jacaré\ dos\ Homens\ \-\ AL",
"55173812", "Icém\ \-\ SP",
"55553528", "Campo\ Novo\ \-\ RS",
"55993537", "Senador\ La\ Roque\ \-\ MA",
"55773611", "Barreiras\ \-\ BA",
"55473399", "Timbó\ \-\ SC",
"55893445", "Santa\ Cruz\ do\ Piauí\ \-\ PI",
"55623356", "Nova\ Veneza\ \-\ GO",
"55513430", "Gravataí\ \-\ RS",
"55222643", "Cabo\ Frio\ \-\ RJ",
"55483341", "Palhoça\ \-\ SC",
"55773688", "Novo\ Paraná\ \-\ BA",
"55333526", "Ataléia\ \-\ MG",
"55173274", "Tanabi\ \-\ SP",
"55513439", "Cachoeirinha\ \-\ RS",
"55122131", "Guaratinguetá\ \-\ SP",
"55893457", "Jaicós\ \-\ PI",
"55553303", "Cruz\ Alta\ \-\ RS",
"55313312", "Belo\ Horizonte\ \-\ MG",
"55843371", "Itaú\ \-\ RN",
"5563321", "Palmas\ \-\ TO",
"55843034", "Natal\ \-\ RN",
"55183277", "Sandovalina\ \-\ SP",
"55753641", "Valença\ \-\ BA",
"55513375", "Rio\ Grande\ do\ Sul",
"55483029", "São\ José\ \-\ SC",
"55753420", "Entre\ Rios\ \-\ BA",
"55753429", "Conde\ \-\ BA",
"55413132", "Pinhais\ \-\ PR",
"55163851", "Morro\ Agudo\ \-\ SP",
"55833341", "Campina\ Grande\ \-\ PB",
"55114234", "São\ Caetano\ do\ Sul\ \-\ SP",
"55513678", "Cristal\ \-\ RS",
"55953543", "Iracema\ \-\ RR",
"55853923", "Fortaleza\ \-\ CE",
"55553250", "Nova\ Esperança\ do\ Sul\ \-\ RS",
"55313377", "Belo\ Horizonte\ \-\ MG",
"55553259", "Mata\ \-\ RS",
"55124004", "São\ José\ dos\ Campos\ \-\ SP",
"55663582", "Gaúcha\ do\ Norte\ \-\ MT",
"55493353", "Xaxim\ \-\ SC",
"55413292", "Campo\ Largo\ \-\ PR",
"55114837", "São\ Paulo\ \-\ SP",
"55223717", "Macaé\ \-\ RJ",
"55323551", "Visconde\ do\ Rio\ Branco\ \-\ MG",
"55112334", "São\ Paulo\ \-\ SP",
"55483236", "Florianópolis\ \-\ SC",
"55913812", "Magalhães\ Barata\ \-\ PA",
"55652128", "Cuiabá\ \-\ MT",
"55633321", "Araguaína\ \-\ TO",
"55643432", "Itumbiara\ \-\ GO",
"55242491", "Vassouras\ \-\ RJ",
"55273237", "Vitória\ \-\ ES",
"55983384", "Presidente\ Sarney\ \-\ MA",
"55813448", "Recife\ \-\ PE",
"5563", "Tocantins",
"55623280", "Aparecida\ de\ Goiânia\ \-\ GO",
"55115851", "São\ Paulo\ \-\ SP",
"55543329", "Carazinho\ \-\ RS",
"55114165", "Itapecerica\ da\ Serra\ \-\ SP",
"55813624", "Surubim\ \-\ PE",
"55923301", "Manaus\ \-\ AM",
"55443572", "Piquirivaí\ \-\ PR",
"55112687", "São\ Paulo\ \-\ SP",
"55433542", "Bandeirantes\ \-\ PR",
"55623579", "Goiânia\ \-\ GO",
"55413393", "Campo\ Largo\ \-\ PR",
"55113513", "São\ Paulo\ \-\ SP",
"55493252", "Timbó\ Grande\ \-\ SC",
"55973471", "São\ Gabriel\ da\ Cachoeira\ \-\ AM",
"55163501", "São\ Carlos\ \-\ SP",
"55883542", "Missão\ Velha\ \-\ CE",
"55913744", "Santa\ Isabel\ do\ Pará\ \-\ PA",
"55222551", "Cordeiro\ \-\ RJ",
"55733237", "Buerarema\ \-\ BA",
"55873779", "Jupi\ \-\ PE",
"55193955", "Socorro\ \-\ SP",
"5512390", "São\ José\ dos\ Campos\ \-\ SP",
"55813342", "Recife\ \-\ PE",
"55613367", "Brasília\ \-\ DF",
"55693344", "Pimenteiras\ do\ Oeste\ \-\ RO",
"55192513", "Campinas\ \-\ SP",
"55413653", "Pinhais\ \-\ PR",
"55323224", "Juiz\ de\ Fora\ \-\ MG",
"55822121", "Maceió\ \-\ AL",
"55923362", "Careiro\ \-\ AM",
"55163956", "Pontal\ \-\ SP",
"55473405", "Itajaí\ \-\ SC",
"55113964", "Jundiaí\ \-\ SP",
"55873891", "Moreilândia\ \-\ PE",
"55963324", "Itaubal\ \-\ AP",
"55813497", "Recife\ \-\ PE",
"55643635", "Santa\ Rita\ do\ Araguaia\ \-\ GO",
"55133378", "Cubatão\ \-\ SP",
"55553261", "Restinga\ Seca\ \-\ RS",
"55223205", "Saquarema\ \-\ RJ",
"55833365", "Alagoa\ Nova\ \-\ PB",
"55693651", "Costa\ Marques\ \-\ RO",
"55313153", "Sete\ Lagoas\ \-\ MG",
"55313556", "Mariana\ \-\ MG",
"55513546", "Três\ Coroas\ \-\ RS",
"55643941", "Itumbiara\ \-\ GO",
"55793271", "Divina\ Pastora\ \-\ SE",
"55272102", "Colatina\ \-\ ES",
"55213035", "Rio\ de\ Janeiro\ \-\ RJ",
"55743551", "Filadélfia\ \-\ BA",
"55983478", "Araioses\ \-\ MA",
"55673416", "Dourados\ \-\ MS",
"55114656", "Santa\ Isabel\ \-\ SP",
"55162138", "Ribeirão\ Preto\ \-\ SP",
"55973389", "Apuí\ \-\ AM",
"55283532", "Marataízes\ \-\ ES",
"5531325", "Minas\ Gerais",
"55613369", "Paranoá\ \-\ DF",
"55633352", "Crixás\ do\ Tocantins\ \-\ TO",
"55733230", "Ubaitaba\ \-\ BA",
"55242444", "Barra\ do\ Piraí\ \-\ RJ",
"55643681", "Firminópolis\ \-\ GO",
"55114701", "Taboão\ da\ Serra\ \-\ SP",
"55123111", "Cunha\ \-\ SP",
"55123895", "Ilhabela\ \-\ SP",
"55373373", "Capitólio\ \-\ MG",
"55733239", "Uruçuca\ \-\ BA",
"55893523", "Floriano\ \-\ PI",
"55893461", "Colônia\ do\ Piauí\ \-\ PI",
"55212153", "Rio\ de\ Janeiro\ \-\ RJ",
"55513786", "Rio\ Grande\ do\ Sul",
"55433244", "Prado\ Ferreira\ \-\ PR",
"55633692", "Dianópolis\ \-\ TO",
"55493554", "Herval\ D\'Oeste\ \-\ SC",
"55732102", "Itabuna\ \-\ BA",
"55373426", "Campos\ Altos\ \-\ MG",
"55543327", "Passo\ Fundo\ \-\ RS",
"55812126", "Recife\ \-\ PE",
"55114762", "Mogi\ das\ Cruzes\ \-\ SP",
"55443274", "Sarandi\ \-\ PR",
"55483668", "Pinheiral\ \-\ SC",
"55983372", "Santo\ Antônio\ dos\ Lopes\ \-\ MA",
"55873844", "São\ José\ do\ Egito\ \-\ PE",
"55133419", "Pedro\ de\ Toledo\ \-\ SP",
"55483062", "Florianópolis\ \-\ SC",
"55273239", "Vila\ Velha\ \-\ ES",
"55623512", "Senador\ Canedo\ \-\ GO",
"55443584", "Icaraíma\ \-\ PR",
"55273724", "Marilândia\ \-\ ES",
"55753462", "Itapicuru\ \-\ BA",
"55414113", "Pinhais\ \-\ PR",
"55313883", "Rio\ Doce\ \-\ MG",
"55313370", "Minas\ Gerais",
"55543362", "Nonoai\ \-\ RS",
"55473348", "Itajaí\ \-\ SC",
"55883623", "Barroquinha\ \-\ CE",
"55553257", "São\ Vicente\ do\ Sul\ \-\ RS",
"55143405", "Pompéia\ \-\ SP",
"55983273", "São\ Luís\ \-\ MA",
"55113389", "São\ Paulo\ \-\ SP",
"55114532", "Jundiaí\ \-\ SP",
"55673227", "Anhanduí\ \-\ MS",
"55163258", "Fernando\ Prestes\ \-\ SP",
"55353844", "Ibituruna\ \-\ MG",
"55153555", "Ribeira\ \-\ SP",
"55313379", "Minas\ Gerais",
"55383214", "Montes\ Claros\ \-\ MG",
"55753427", "Esplanada\ \-\ BA",
"55493804", "Lages\ \-\ SC",
"55613351", "Taguatinga\ \-\ DF",
"55112136", "Jundiaí\ \-\ SP",
"55183279", "Regente\ Feijó\ \-\ SP",
"55112533", "São\ Paulo\ \-\ SP",
"55663574", "Nova\ Guarita\ \-\ MT",
"55483027", "Florianópolis\ \-\ SC",
"55153547", "Guapiara\ \-\ SP",
"55212632", "Guapimirim\ \-\ RJ",
"55173572", "Pindorama\ \-\ SP",
"55513437", "Rio\ Grande\ do\ Sul",
"55633464", "Guaraí\ \-\ TO",
"55453266", "Céu\ Azul\ \-\ PR",
"55543468", "Pinto\ Bandeira\ \-\ RS",
"55473442", "São\ Francisco\ do\ Sul\ \-\ SC",
"5521329", "Rio\ de\ Janeiro\ \-\ RJ",
"55893459", "Patos\ do\ Piauí\ \-\ PI",
"55893450", "Francisco\ Santos\ \-\ PI",
"55513703", "Rio\ Grande\ do\ Sul",
"55353712", "Poços\ de\ Caldas\ \-\ MG",
"55243328", "Barra\ Mansa\ \-\ RJ",
"55342106", "Patos\ de\ Minas\ \-\ MG",
"55123864", "São\ Sebastião\ \-\ SP",
"55733673", "Arataca\ \-\ BA",
"55313435", "Belo\ Horizonte\ \-\ MG",
"55143602", "Jaú\ \-\ SP",
"55833394", "Ingá\ \-\ PB",
"55473397", "Gaspar\ \-\ SC",
"55353298", "Machado\ \-\ MG",
"55433623", "Porecatu\ \-\ PR",
"55823232", "Maceió\ \-\ AL",
"55173282", "Icém\ \-\ SP",
"55853373", "Acarape\ \-\ CE",
"55373272", "Maravilhas\ \-\ MG",
"55114141", "Itapevi\ \-\ SP",
"55753694", "Santanópolis\ \-\ BA",
"55993539", "Vila\ Nova\ dos\ Martírios\ \-\ MA",
"55483654", "Santa\ Rosa\ de\ Lima\ \-\ SC",
"55743643", "Mulungu\ do\ Morro\ \-\ BA",
"55163135", "Rifaina\ \-\ SP",
"55643497", "Santo\ Antônio\ do\ Rio\ Verde\ \-\ GO",
"55112628", "São\ Paulo\ \-\ SP",
"55813635", "Itambé\ \-\ PE",
"55663568", "São\ José\ do\ Xingu\ \-\ MT",
"55653265", "Conquista\ D\'Oeste\ \-\ MT",
"5531358", "Minas\ Gerais",
"55463543", "Realeza\ \-\ PR",
"55113183", "Itatiba\ \-\ SP",
"55313576", "Bonfim\ \-\ MG",
"55143332", "Santa\ Cruz\ do\ Rio\ Pardo\ \-\ SP",
"55793251", "Aracaju\ \-\ SE",
"55383561", "João\ Pinheiro\ \-\ MG",
"55343614", "Perdizes\ \-\ MG",
"55443521", "Goioerê\ \-\ PR",
"55114023", "Itu\ \-\ SP",
"55183261", "Ribeirão\ dos\ Índios\ \-\ SP",
"55843367", "Paraú\ \-\ RN",
"55273132", "Vitória\ \-\ ES",
"55212005", "Rio\ de\ Janeiro\ \-\ RJ",
"55813338", "Recife\ \-\ PE",
"55373353", "Iguatama\ \-\ MG",
"55863241", "Boa\ Hora\ \-\ PI",
"55773465", "Ibiassucê\ \-\ BA",
"55313408", "Belo\ Horizonte\ \-\ MG",
"55173802", "Paulo\ de\ Faria\ \-\ SP",
"55883538", "Potengi\ \-\ CE",
"55633372", "Natividade\ \-\ TO",
"55843223", "Natal\ \-\ RN",
"5531327", "Belo\ Horizonte\ \-\ MG",
"55443254", "Atalaia\ \-\ PR",
"5531374", "Minas\ Gerais",
"55983352", "Vitória\ do\ Mearim\ \-\ MA",
"55193325", "Campinas\ \-\ SP",
"55333263", "Resplendor\ \-\ MG",
"55913859", "Salinópolis\ \-\ PA",
"55433538", "Andirá\ \-\ PR",
"55773662", "Palmas\ de\ Monte\ Alto\ \-\ BA",
"55333327", "Ipaba\ \-\ MG",
"55193022", "Mogi\ Mirim\ \-\ SP",
"55173636", "Dolcinópolis\ \-\ SP",
"55823686", "Xingó\ \-\ AL",
"55733292", "Teixeira\ de\ Freitas\ \-\ BA",
"55212173", "Rio\ de\ Janeiro\ \-\ RJ",
"55643624", "Itumbiara\ \-\ GO",
"55493574", "Macieira\ \-\ SC",
"55623557", "Campestre\ de\ Goiás\ \-\ GO",
"55214117", "Nova\ Iguaçu\ \-\ RJ",
"55123878", "São\ José\ dos\ Campos\ \-\ SP",
"55193628", "Santa\ Bárbara\ D\'Oeste\ \-\ SP",
"55443463", "Paranacity\ \-\ PR",
"55163326", "Boa\ Esperança\ do\ Sul\ \-\ SP",
"55693434", "Santa\ Luzia\ D\'Oeste\ \-\ RO",
"55624051", "Anápolis\ \-\ GO",
"55353626", "Wenceslau\ Braz\ \-\ MG",
"55533325", "Pelotas\ \-\ RS",
"55633478", "Filadélfia\ \-\ TO",
"55553313", "Santo\ Ângelo\ \-\ RS",
"55623545", "Goiânia\ \-\ GO",
"55113422", "São\ Caetano\ do\ Sul\ \-\ SP",
"55793260", "Barra\ dos\ Coqueiros\ \-\ SE",
"55163511", "Sertãozinho\ \-\ SP",
"55753031", "Alagoinhas\ \-\ BA",
"55243389", "Barra\ Mansa\ \-\ RJ",
"55843644", "Parnamirim\ \-\ RN",
"55473018", "Gaspar\ \-\ SC",
"55444001", "Maringá\ \-\ PR",
"55553798", "Rodeio\ Bonito\ \-\ RS",
"55453324", "Cascavel\ \-\ PR",
"55163797", "Ribeirão\ Preto\ \-\ SP",
"55823299", "Atalaia\ \-\ AL",
"55923311", "Cacau\ Pirêra\ \-\ AM",
"55993592", "Açailândia\ \-\ MA",
"55793269", "Riachuelo\ \-\ SE",
"55483431", "Quarta\ Linha\ \-\ SC",
"55553277", "São\ Martinho\ da\ Serra\ \-\ RS",
"55193893", "Pedreira\ \-\ SP",
"55663554", "Vila\ Rica\ \-\ MT",
"55983464", "Miranda\ do\ Norte\ \-\ MA",
"55153285", "Tietê\ \-\ SP",
"55913802", "Mãe\ do\ Rio\ \-\ PA",
"55843428", "São\ Fernando\ \-\ RN",
"55473081", "Balneário\ Camboriú\ \-\ SC",
"55112893", "São\ Paulo\ \-\ SP",
"55553755", "Liberato\ Salzano\ \-\ RS",
"55162105", "Sertãozinho\ \-\ SP",
"55183117", "Araçatuba\ \-\ SP",
"55383731", "Várzea\ da\ Palma\ \-\ MG",
"55713291", "Salvador\ \-\ BA",
"55173552", "Urupês\ \-\ SP",
"55543902", "Passo\ Fundo\ \-\ RS",
"55913636", "Limoeiro\ do\ Ajuru\ \-\ PA",
"55183528", "Osvaldo\ Cruz\ \-\ SP",
"55773494", "Tremedal\ \-\ BA",
"55553747", "Boa\ Vista\ das\ Missões\ \-\ RS",
"55613487", "Sobradinho\ \-\ DF",
"55192106", "Piracicaba\ \-\ SP",
"55383228", "Coração\ de\ Jesus\ \-\ MG",
"55833431", "Pombal\ \-\ PB",
"55853353", "Uruburetama\ \-\ CE",
"55114892", "Bragança\ Paulista\ \-\ SP",
"5512391", "São\ José\ dos\ Campos\ \-\ SP",
"55433056", "Arapongas\ \-\ PR",
"55114599", "Jundiaí\ \-\ SP",
"55213602", "Niterói\ \-\ RJ",
"55114597", "Nazaré\ Paulista\ \-\ SP",
"5554322", "Caxias\ do\ Sul\ \-\ RS",
"55173463", "Fernandópolis\ \-\ SP",
"55123101", "Cachoeira\ Paulista\ \-\ SP",
"55223831", "Bom\ Jesus\ do\ Itabapoana\ \-\ RJ",
"55173845", "Meridiano\ \-\ SP",
"55613489", "Planaltina\ \-\ DF",
"55313697", "Bairro\ Eldorado\ \-\ Sete\ Lagoas\ MG",
"55623561", "Caldazinha\ \-\ GO",
"55643608", "Bom\ Jesus\ de\ Goiás\ \-\ GO",
"55383821", "Janaúba\ \-\ MG",
"55893477", "Inhuma\ \-\ PI",
"55173254", "Mirassol\ \-\ SP",
"55543526", "Três\ Arroios\ \-\ RS",
"55833485", "Santana\ dos\ Garrotes\ \-\ PB",
"55513695", "Harmonia\ \-\ RS",
"55843691", "Lajes\ Pintadas\ \-\ RN",
"55623376", "Aruanã\ \-\ GO",
"5511272", "São\ Paulo\ \-\ SP",
"55212648", "Maricá\ \-\ RJ",
"55454003", "Foz\ do\ Iguaçu\ \-\ PR",
"55443636", "Pérola\ \-\ PR",
"55813846", "Santa\ Cruz\ da\ Baixa\ Verde\ \-\ PE",
"55383545", "Presidente\ Kubitschek\ \-\ MG",
"55373221", "Divinópolis\ \-\ MG",
"55683235", "Acrelândia\ \-\ AC",
"55513052", "Canoas\ \-\ RS",
"55313424", "Belo\ Horizonte\ \-\ MG",
"55212697", "Mesquita\ \-\ RJ",
"55833682", "São\ José\ dos\ Ramos\ \-\ PB",
"55513492", "Viamão\ \-\ RS",
"55623502", "Bela\ Vista\ de\ Goiás\ \-\ GO",
"55353531", "São\ Sebastião\ do\ Paraíso\ \-\ MG",
"55843351", "Pau\ dos\ Ferros\ \-\ RN",
"55873761", "Garanhuns\ \-\ PE",
"5519372", "Campinas\ \-\ SP",
"55653241", "Mirassol\ D\'Oeste\ \-\ MT",
"55473035", "Blumenau\ \-\ SC",
"55423664", "Faxinal\ do\ Céu\ \-\ PR",
"55833088", "Campina\ Grande\ \-\ PB",
"55823297", "Japaratinga\ \-\ AL",
"555132", "Porto\ Alegre\ \-\ RS",
"55933737", "Almeirim\ \-\ PA",
"55213726", "Teresópolis\ \-\ RJ",
"55773620", "Serra\ do\ Ramalho\ \-\ BA",
"55773441", "Brumado\ \-\ BA",
"55313911", "Contagem\ \-\ MG",
"55553279", "Quevedos\ \-\ RS",
"55863265", "União\ \-\ PI",
"55553270", "São\ Miguel\ \-\ RS",
"55933522", "Santarém\ \-\ PA",
"55173521", "Catanduva\ \-\ SP",
"55773629", "Recife\ \-\ PE",
"55313357", "Contagem\ \-\ MG",
"55243387", "Visconde\ de\ Mauá\ \-\ RJ",
"55473332", "Gaspar\ \-\ SC",
"55813753", "São\ Joaquim\ do\ Monte\ \-\ PE",
"55513658", "Charqueadas\ \-\ RS",
"55323366", "Oliveira\ Fortes\ \-\ MG",
"55753283", "Paulo\ Afonso\ \-\ BA",
"55173268", "Onda\ Verde\ \-\ SP",
"55323571", "Rio\ Pomba\ \-\ MG",
"55333329", "Caratinga\ \-\ MG",
"55973451", "Boca\ do\ Acre\ \-\ AM",
"55323281", "Lima\ Duarte\ \-\ MG",
"55473233", "São\ Francisco\ do\ Sul\ \-\ SC",
"55443552", "Boa\ Esperança\ \-\ PR",
"55623550", "Aragoiânia\ \-\ GO",
"55143415", "Marília\ \-\ SP",
"55113304", "São\ Paulo\ \-\ SP",
"55793222", "Aracaju\ \-\ SE",
"55673483", "Coronel\ Sapucaia\ \-\ MS",
"55413673", "Piraquara\ \-\ PR",
"55883515", "Pedra\ Branca\ \-\ CE",
"55343071", "Uberaba\ \-\ MG",
"55513664", "Torres\ \-\ RS",
"55273735", "Afonso\ Cláudio\ \-\ ES",
"55813681", "Xexéu\ \-\ PE",
"55193491", "Capivari\ \-\ SP",
"55283548", "Irupi\ \-\ ES",
"55223013", "Campos\ dos\ Goitacazes\ \-\ RJ",
"55432101", "Londrina\ \-\ PR",
"55513713", "Santa\ Cruz\ do\ Sul\ \-\ RS",
"55653336", "Diamantino\ \-\ MT",
"55543388", "Bento\ Gonçalves\ \-\ RS",
"55633384", "Araguaçu\ \-\ TO",
"55163976", "Ribeirão\ Preto\ \-\ SP",
"5598", "Maranhão",
"55913521", "Paragominas\ \-\ PA",
"55323445", "Argirita\ \-\ MG",
"55313107", "Sete\ Lagoas\ \-\ MG",
"55893560", "Francisco\ Ayres\ \-\ PI",
"55173813", "Jaci\ \-\ SP",
"55553286", "Santa\ Maria\ \-\ RS",
"55633554", "Taquarussu\ do\ Porto\ \-\ TO",
"55893569", "Santa\ Filomena\ \-\ PI",
"55853319", "Chorozinho\ \-\ CE",
"55753636", "Nazaré\ \-\ BA",
"55624141", "Goiânia\ \-\ GO",
"55733684", "Itamaraty\ \-\ BA",
"55423275", "Tibagi\ \-\ PR",
"55133278", "Santos\ \-\ SP",
"55853384", "Maracanaú\ \-\ CE",
"55213534", "Rio\ de\ Janeiro\ \-\ RJ",
"55493458", "Itá\ \-\ SC",
"55553361", "Giruá\ \-\ RS",
"55193837", "Jaguariúna\ \-\ SP",
"55143297", "Bairro\ de\ Santa\ Izabel\ \-\ SP",
"55513626", "Torres\ \-\ RS",
"55623389", "Goianésia\ \-\ GO",
"55553302", "Santa\ Maria\ \-\ RS",
"55123972", "Santa\ Branca\ \-\ SP",
"551129", "São\ Paulo\ \-\ SP",
"55623380", "Araguapaz\ \-\ GO",
"55273337", "Vitória\ \-\ ES",
"55112837", "São\ Paulo\ \-\ SP",
"55953542", "Mucajaí\ \-\ RR",
"55663583", "Vera\ \-\ MT",
"55132105", "Santos\ \-\ SP",
"55123351", "Jacareí\ \-\ SP",
"55913031", "Ananindeua\ \-\ PA",
"55183377", "Florínia\ \-\ SP",
"55843271", "Macaíba\ \-\ RN",
"5563331", "Gurupi\ \-\ TO",
"55684003", "Rio\ Branco\ \-\ AC",
"55114687", "São\ Lourenço\ da\ Serra\ \-\ SP",
"55443283", "Barbosa\ Ferraz\ \-\ PR",
"55212747", "Tanguá\ \-\ RJ",
"55643433", "Itumbiara\ \-\ GO",
"55383634", "Chapada\ Gaúcha\ \-\ MG",
"55443573", "Iretama\ \-\ PR",
"55313121", "Igarapé\ \-\ MG",
"55693623", "Seringueiras\ \-\ RO",
"55883669", "Vila\ de\ Jericoacoara\ \-\ CE",
"55153494", "Ibiúna\ \-\ SP",
"55313277", "Minas\ Gerais",
"55543036", "Gramado\ \-\ RS",
"55553359", "Cerro\ Largo\ \-\ RS",
"55313874", "Minas\ Gerais",
"55212755", "São\ João\ de\ Meriti\ \-\ RJ",
"55883660", "Cruz\ \-\ CE",
"55163421", "Ribeirão\ Preto\ \-\ SP",
"55433543", "Itambaracá\ \-\ PR",
"55113512", "São\ Paulo\ \-\ SP",
"55493253", "São\ Cristovão\ do\ Sul\ \-\ SC",
"55513585", "Campo\ Bom\ \-\ RS",
"55413392", "Campo\ Largo\ \-\ PR",
"55413455", "Pontal\ do\ Paraná\ \-\ PR",
"55433660", "Lupionópolis\ \-\ PR",
"55663478", "Canarana\ \-\ MT",
"5511346", "São\ Paulo\ \-\ SP",
"55673041", "Campo\ Grande\ \-\ MS",
"55883543", "Aurora\ \-\ CE",
"55513757", "Nova\ Bréscia\ \-\ RS",
"55313466", "Belo\ Horizonte\ \-\ MG",
"55353021", "Passos\ \-\ MG",
"55923363", "Manaquiri\ \-\ AM",
"55813343", "Recife\ \-\ PE",
"55413652", "Rio\ Branco\ do\ Sul\ \-\ PR",
"55473525", "Rio\ do\ Sul\ \-\ SC",
"55663506", "Analândia\ do\ Norte\ \-\ MT",
"55473130", "Joinville\ \-\ SC",
"55413058", "São\ José\ dos\ Pinhais\ \-\ PR",
"55483241", "São\ José\ \-\ SC",
"55513745", "Segredo\ \-\ RS",
"55313755", "Senhora\ de\ Oliveira\ \-\ MG",
"55463538", "Salto\ do\ Lontra\ \-\ PR",
"55373384", "Itaguara\ \-\ MG",
"55453235", "Três\ Barras\ do\ Paraná\ \-\ PR",
"55353695", "São\ Lourenço\ \-\ MG",
"55313152", "Sete\ Lagoas\ \-\ MG",
"55453218", "Cascavel\ \-\ PR",
"55163395", "Rincão\ \-\ SP",
"55384141", "Montes\ Claros\ \-\ MG",
"55833063", "Campina\ Grande\ \-\ PB",
"55283533", "Rio\ Novo\ do\ Sul\ \-\ ES",
"55272103", "Linhares\ \-\ ES",
"55453281", "Marechal\ Cândido\ Rondon\ \-\ PR",
"55513759", "Travesseiro\ \-\ RS",
"55313749", "Ouro\ Branco\ \-\ MG",
"55953623", "Boa\ Vista\ \-\ RR",
"55833294", "Itapororoca\ \-\ PB",
"55823035", "Maceió\ \-\ AL",
"55633353", "Alvorada\ \-\ TO",
"55893522", "Floriano\ \-\ PI",
"55823332", "Maceió\ \-\ AL",
"55212882", "Nova\ Iguaçu\ \-\ RJ",
"55274102", "Serra\ \-\ ES",
"55193396", "Sumaré\ \-\ SP",
"5512312", "Guaratinguetá\ \-\ SP",
"55513750", "Vale\ do\ Sol\ \-\ RS",
"55732103", "Itabuna\ \-\ BA",
"55212152", "Teresópolis\ \-\ RJ",
"55983373", "Maracaçumé\ \-\ MA",
"55323461", "Angustura\ \-\ MG",
"55943392", "Canaã\ dos\ Carajás\ \-\ PA",
"55112396", "Itu\ \-\ SP",
"55462101", "Pato\ Branco\ \-\ PR",
"55883667", "Itarema\ \-\ CE",
"55193656", "Mococa\ \-\ SP",
"55163358", "Araraquara\ \-\ SP",
"55753254", "Ipirá\ \-\ BA",
"55623513", "Nerópolis\ \-\ GO",
"55114680", "Santa\ Isabel\ \-\ SP",
"55713671", "Camaçari\ \-\ BA",
"55673454", "Maracaju\ \-\ MS",
"55843535", "Jardim\ de\ Angicos\ \-\ RN",
"55313589", "Nova\ Lima\ \-\ MG",
"55193701", "Limeira\ \-\ SP",
"55734102", "Ilhéus\ \-\ BA",
"55183379", "São\ José\ Laranjeiras\ \-\ SP",
"55413621", "Colombo\ \-\ PR",
"55163987", "Serrana\ \-\ SP",
"55313882", "Minas\ Gerais",
"55973356", "Anamã\ \-\ AM",
"55813086", "Recife\ \-\ PE",
"55433344", "Londrina\ \-\ PR",
"55543363", "Constantina\ \-\ RS",
"55114136", "Araçariguama\ \-\ SP",
"55983272", "São\ Luís\ \-\ MA",
"55114533", "Jundiaí\ \-\ SP",
"55112839", "São\ Paulo\ \-\ SP",
"55513761", "Paverama\ \-\ RS",
"55483265", "São\ João\ Batista\ \-\ SC",
"55813719", "Caruaru\ \-\ PE",
"55983217", "São\ Luís\ \-\ MA",
"55623387", "Anápolis\ \-\ GO",
"55112532", "São\ Paulo\ \-\ SP",
"55643666", "Portelândia\ \-\ GO",
"55473443", "Itapoá\ \-\ SC",
"55733617", "Itabuna\ \-\ BA",
"55833265", "Duas\ Estradas\ \-\ PB",
"55913411", "Capanema\ \-\ PA",
"5549", "Santa\ Catarina",
"55173573", "Roberto\ \-\ SP",
"55212633", "Magé\ \-\ RJ",
"55123025", "Taubaté\ \-\ SP",
"55673468", "Vicentina\ \-\ MS",
"55193839", "Amparo\ \-\ SP",
"55654104", "Várzea\ Grande\ \-\ MT",
"55623995", "Goiânia\ \-\ GO",
"55413607", "Araucária\ \-\ PR",
"55123322", "São\ José\ dos\ Campos\ \-\ SP",
"55333725", "Salto\ da\ Divisa\ \-\ MG",
"55493321", "Chapecó\ \-\ SC",
"55513702", "Rio\ Grande\ do\ Sul",
"55353713", "Poços\ de\ Caldas\ \-\ MG",
"5531335", "Minas\ Gerais",
"55714101", "Salvador\ \-\ BA",
"55553816", "Condor\ \-\ RS",
"55813544", "Ilha\ de\ Itamaracá\ \-\ PE",
"55183556", "Inúbia\ Paulista\ \-\ SP",
"55893567", "Ribeiro\ Gonçalves\ \-\ PI",
"55134010", "Santos\ \-\ SP",
"55733672", "Santa\ Cruz\ Cabrália\ \-\ BA",
"55143841", "São\ Manuel\ \-\ SP",
"55353664", "Conceição\ das\ Pedras\ \-\ MG",
"55883425", "Ibicuitinga\ \-\ CE",
"55163409", "Franca\ \-\ SP",
"55115092", "São\ Paulo\ \-\ SP",
"55373273", "Onça\ de\ Pitangui\ \-\ MG",
"55933793", "Porto\ de\ Moz\ \-\ PA",
"55133871", "Eldorado\ \-\ SP",
"55743642", "Irecê\ \-\ BA",
"55242225", "Petrópolis\ \-\ RJ",
"55753268", "Teofilândia\ \-\ BA",
"55433622", "Jaboti\ \-\ PR",
"55173283", "Jaci\ \-\ SP",
"55853372", "São\ Gonçalo\ do\ Amarante\ \-\ CE",
"55443275", "Barbosa\ Ferraz\ \-\ PR",
"55873845", "Calumbi\ \-\ PE",
"55653326", "Tangará\ da\ Serra\ \-\ MT",
"5511256", "São\ Paulo\ \-\ SP",
"55543447", "Vila\ Flores\ \-\ RS",
"55343457", "Carneirinho\ \-\ MG",
"55513283", "Novo\ Hamburgo\ \-\ RS",
"55493555", "Capinzal\ \-\ SC",
"55644141", "Itumbiara\ \-\ GO",
"55413036", "Almirante\ Tamandaré\ \-\ PR",
"55873857", "Flores\ \-\ PE",
"55553505", "Alegrete\ \-\ RS",
"5561210", "Brasília\ \-\ DF",
"55273725", "Itaguaçu\ \-\ ES",
"55343324", "Água\ Comprida\ \-\ MG",
"55713633", "Vera\ Cruz\ \-\ BA",
"55463556", "Pérola\ D\'Oeste\ \-\ PR",
"55193477", "Americana\ \-\ SP",
"55112318", "São\ Paulo\ \-\ SP",
"55543392", "Lagoa\ dos\ Três\ Cantos\ \-\ RS",
"55153207", "Gramadinho\ \-\ SP",
"55433257", "Pitangueiras\ \-\ PR",
"55493547", "Celso\ Ramos\ \-\ SC",
"55115063", "São\ Paulo\ \-\ SP",
"55143351", "Piraju\ \-\ SP",
"55753664", "Taperoá\ \-\ BA",
"55333339", "Manhuaçu\ \-\ MG",
"55242457", "Santa\ Isabel\ do\ Rio\ Preto\ \-\ RJ",
"55833364", "Remígio\ \-\ PB",
"55484053", "Criciúma\ \-\ SC",
"55473367", "Balneário\ Camboriú\ \-\ SC",
"55323711", "Vermelho\ \-\ MG",
"55163265", "Tapinas\ \-\ SP",
"55123894", "Ilhabela\ \-\ SP",
"55242445", "Barra\ do\ Piraí\ \-\ RJ",
"55183993", "Cuiabá\ Paulista\ \-\ SP",
"55633494", "Barra\ do\ Ouro\ \-\ TO",
"55273151", "Linhares\ \-\ ES",
"55483647", "Laguna\ \-\ SC",
"55212671", "Duque\ de\ Caxias\ \-\ RJ",
"55933532", "Uruará\ \-\ PA",
"55173531", "Catanduva\ \-\ SP",
"55773639", "Luis\ Eduardo\ Magalhães\ \-\ BA",
"55182101", "Presidente\ Prudente\ \-\ SP",
"55423573", "Porto\ Vitória\ \-\ PR",
"55633465", "Itapiratins\ \-\ TO",
"55513488", "Gravataí\ \-\ RS",
"55213736", "Rio\ de\ Janeiro\ \-\ RJ",
"55753695", "São\ Domingos\ \-\ BA",
"55483655", "Sangão\ \-\ SC",
"55163134", "Jeriquara\ \-\ SP",
"5551350", "Rio\ Grande\ do\ Sul",
"55353521", "Passos\ \-\ MG",
"55693302", "Porto\ Velho\ \-\ RO",
"55513411", "Alvorada\ \-\ RS",
"55115616", "São\ Paulo\ \-\ SP",
"5519373", "Campinas\ \-\ SP",
"55673541", "Bataguassu\ \-\ MS",
"55823271", "São\ Miguel\ dos\ Campos\ \-\ AL",
"55833452", "Piancó\ \-\ PB",
"55813469", "Jaboatão\ dos\ Guararapes\ \-\ PE",
"55833395", "Umbuzeiro\ \-\ PB",
"55373231", "Pará\ de\ Minas\ \-\ MG",
"55313434", "Belo\ Horizonte\ \-\ MG",
"55473428", "Dona\ Francisca\ SC\ 301\ \-\ SC",
"55153554", "Barra\ do\ Chapéu\ \-\ SP",
"5511273", "São\ Paulo\ \-\ SP",
"55443626", "Umuarama\ \-\ PR",
"55513382", "Rio\ Grande\ do\ Sul",
"55383831", "Porteirinha\ \-\ MG",
"55114571", "São\ Paulo\ \-\ SP",
"55773478", "Ribeirão\ do\ Largo\ \-\ BA",
"55143404", "Tupã\ \-\ SP",
"55853346", "Itapagé\ \-\ CE",
"55543536", "Caxias\ do\ Sul\ \-\ RS",
"55743676", "Quixabeira\ \-\ BA",
"55353463", "Bueno\ Brandão\ \-\ MG",
"55663575", "Peixoto\ de\ Azevedo\ \-\ MT",
"55353857", "Campo\ do\ Meio\ \-\ MG",
"55713270", "Salvador\ \-\ BA",
"55753658", "Fátima\ \-\ BA",
"55493436", "Faxinal\ dos\ Guedes\ \-\ SC",
"55673292", "Rio\ Verde\ de\ Mato\ Grosso\ \-\ MS",
"55473644", "Rio\ Negrinho\ \-\ SC",
"55543293", "Antônio\ Prado\ \-\ RS",
"55553244", "Santana\ do\ Livramento\ \-\ RS",
"55833358", "Barra\ de\ São\ Miguel\ \-\ PB",
"55313080", "Belo\ Horizonte\ \-\ MG",
"55843332", "Areia\ Branca\ \-\ RN",
"55183875", "Santa\ Mercedes\ \-\ SP",
"55134104", "São\ Vicente\ \-\ SP",
"55713121", "Camaçari\ \-\ BA",
"55313014", "Belo\ Horizonte\ \-\ MG",
"55353552", "Guaxupé\ \-\ MG",
"55753340", "Marcionílio\ Souza\ \-\ BA",
"55553542", "Tucunduva\ \-\ RS",
"55114811", "Franco\ da\ Rocha\ \-\ SP",
"55513031", "Canoas\ \-\ RS",
"55383238", "Grão\ Mogol\ \-\ MG",
"55683548", "Assis\ Brasil\ \-\ AC",
"55833421", "Patos\ \-\ PB",
"55114888", "Joanópolis\ \-\ SP",
"55383721", "Curvelo\ \-\ MG",
"55473351", "Brusque\ \-\ SC",
"55143223", "Bauru\ \-\ SP",
"55153252", "Torre\ de\ Pedra\ \-\ SP",
"55433202", "Apucarana\ \-\ PR",
"55163241", "Monte\ Alto\ \-\ SP",
"55123686", "Taubaté\ \-\ SP",
"55893444", "Dom\ Expedito\ Lopes\ \-\ PI",
"55613024", "Brasília\ \-\ DF",
"55813746", "Jataúba\ \-\ PE",
"55223852", "Miracema\ \-\ RJ",
"55843438", "Tenente\ Laurentino\ Cruz\ \-\ RN",
"55643513", "Caldas\ Novas\ \-\ GO",
"55114158", "Vargem\ Grande\ Paulista\ \-\ SP",
"55823535", "Olho\ d\'Água\ Grande\ \-\ AL",
"55613397", "Taguatinga\ \-\ DF",
"55272144", "Vila\ Velha\ \-\ ES",
"55173275", "Monte\ Aprazível\ \-\ SP",
"55213826", "Rio\ de\ Janeiro\ \-\ RJ",
"55863326", "Timon\ \-\ MA",
"55113432", "Carapicuíba\ \-\ SP",
"5543337", "Londrina\ \-\ PR",
"55753021", "Feira\ de\ Santana\ \-\ BA",
"55124408", "Polvilho\ \-\ SP",
"55993326", "Timon\ \-\ MA",
"55923133", "Manaus\ \-\ AM",
"55883303", "Aracati\ \-\ CE",
"55693345", "Cabixi\ \-\ RO",
"55813106", "Jaboatão\ dos\ Guararapes\ \-\ PE",
"55693424", "Ji\-Paraná\ \-\ RO",
"55433172", "Arapongas\ \-\ PR",
"55353861", "Nepomuceno\ \-\ MG",
"55733288", "Porto\ Seguro\ \-\ BA",
"55844109", "Mossoró\ \-\ RN",
"55143644", "Igaraçu\ do\ Tietê\ \-\ SP",
"5565364", "Cuiabá\ \-\ MT",
"55193032", "Campinas\ \-\ SP",
"55114916", "São\ Paulo\ \-\ SP",
"55643634", "Chapadão\ do\ Céu\ \-\ GO",
"55733211", "Itabuna\ \-\ BA",
"5592323", "Manaus\ \-\ AM",
"55963325", "Cutias\ \-\ AP",
"55743548", "Pindobaçu\ \-\ BA",
"55463213", "Pato\ Branco\ \-\ PR",
"55473360", "Balneário\ Camboriú\ \-\ SC",
"55433528", "Wenceslau\ Braz\ \-\ PR",
"55473404", "Itajaí\ \-\ SC",
"55983385", "Bequimão\ \-\ MA",
"55273288", "Marechal\ Floriano\ \-\ ES",
"55873850", "Brejinho\ \-\ PE",
"55493549", "Vargem\ \-\ SC",
"55433259", "Jataizinho\ \-\ PR",
"55643471", "Pontalina\ \-\ GO",
"55873859", "Santa\ Terezinha\ \-\ PE",
"55313716", "Inhaúma\ \-\ MG",
"55112335", "São\ Paulo\ \-\ SP",
"55873966", "Exu\ \-\ PE",
"55143322", "Ourinhos\ \-\ SP",
"55343459", "Frutal\ \-\ MG",
"55913275", "Ananindeua\ \-\ PA",
"55543449", "Bento\ Gonçalves\ \-\ RS",
"55443531", "Peabiru\ \-\ PR",
"55673565", "Aparecida\ do\ Taboado\ \-\ MS",
"55114033", "Bragança\ Paulista\ \-\ SP",
"55813625", "Goiana\ \-\ PE",
"55143025", "Lins\ \-\ SP",
"55433303", "Arapongas\ \-\ PR",
"55153353", "Votorantim\ \-\ SP",
"55114164", "Carapicuíba\ \-\ SP",
"55114605", "Caieiras\ \-\ SP",
"55514001", "Porto\ Alegre\ \-\ RS",
"559132", "Belém\ \-\ PA",
"55693466", "Nova\ União\ \-\ RO",
"55823223", "Maceió\ \-\ AL",
"55913658", "Santa\ Cruz\ do\ Arari\ \-\ PA",
"55623342", "Ipiranga\ de\ Goiás\ \-\ GO",
"55443340", "Alto\ Alegre\ \-\ PR",
"55114461", "Santo\ André\ \-\ SP",
"55923673", "Manaus\ \-\ AM",
"55213895", "Rio\ de\ Janeiro\ \-\ RJ",
"55883435", "Potiretama\ \-\ CE",
"55353573", "Monte\ Belo\ \-\ MG",
"55153273", "Itapetininga\ \-\ SP",
"55333735", "Coronel\ Murta\ \-\ MG",
"55353283", "Poço\ Fundo\ \-\ MG",
"55423521", "União\ da\ Vitória\ \-\ PR",
"55114308", "Diadema\ \-\ SP",
"55663601", "Nova\ Fronteira\ \-\ MT",
"55173664", "Aspásia\ \-\ SP",
"55213222", "Rio\ de\ Janeiro\ \-\ RJ",
"55793442", "Malhador\ \-\ SE",
"55193829", "Valinhos\ \-\ SP",
"55613613", "Águas\ Lindas\ de\ Goiás\ \-\ GO",
"55343235", "Uberlândia\ \-\ MG",
"55133848", "Iguape\ \-\ SP",
"55643545", "Itumbiara\ \-\ GO",
"55423463", "Rio\ Azul\ \-\ PR",
"55413902", "Paranaguá\ \-\ PR",
"55623448", "Flores\ de\ Goiás\ \-\ GO",
"55793645", "Boquim\ \-\ SE",
"55112829", "Santo\ André\ \-\ SP",
"55312111", "Belo\ Horizonte\ \-\ MG",
"55543237", "Bom\ Jesus\ \-\ RS",
"55114402", "Atibaia\ \-\ SP",
"55733041", "Itabuna\ \-\ BA",
"55433435", "Manoel\ Ribas\ \-\ PR",
"55623624", "Goiânia\ \-\ GO",
"55343811", "Presidente\ Olegário\ \-\ MG",
"55514062", "Porto\ Alegre\ \-\ RS",
"55793348", "Japoatã\ \-\ SE",
"55423254", "Colônia\ Witmarsum\ \-\ PR",
"55143535", "Pompéia\ \-\ SP",
"55313623", "São\ José\ da\ Lapa\ \-\ MG",
"55883632", "Viçosa\ do\ Ceará\ \-\ CE",
"55493246", "Fraiburgo\ \-\ SC",
"55114099", "Diadema\ \-\ SP",
"55433556", "Abatiá\ \-\ PR",
"55113175", "São\ Paulo\ \-\ SP",
"55173347", "Jaborandi\ \-\ SP",
"55222533", "Nova\ Friburgo\ \-\ RJ",
"55143456", "Oriente\ \-\ SP",
"55183622", "Araçatuba\ \-\ SP",
"55353411", "São\ Sebastião\ do\ Paraíso\ \-\ MG",
"55843525", "Guamaré\ \-\ RN",
"55153478", "Pilar\ do\ Sul\ \-\ SP",
"55943311", "Parauapebas\ \-\ PA",
"55843299", "Coronel\ Ezequiel\ \-\ RN",
"55463245", "Honório\ Serpa\ \-\ PR",
"55312323", "Betim\ \-\ MG",
"55213508", "Itaboraí\ \-\ RJ",
"55194002", "Campinas\ \-\ SP",
"55143765", "Águas\ de\ Santa\ Bárbara\ \-\ SP",
"55993647", "Igarapé\ Grande\ \-\ MA",
"55173355", "São\ José\ do\ Rio\ Preto\ \-\ SP",
"55124109", "São\ José\ dos\ Campos\ \-\ SP",
"55313898", "Cajuri\ \-\ MG",
"55823644", "Água\ Branca\ \-\ AL",
"55193486", "Charqueada\ \-\ SP",
"55424001", "Ponta\ Grossa\ \-\ PR",
"55893532", "Pajeú\ do\ Piauí\ \-\ PI",
"55313244", "Minas\ Gerais",
"55424062", "Ponta\ Grossa\ \-\ PR",
"55663494", "São\ José\ do\ Povo\ \-\ MT",
"55224141", "Campos\ dos\ Goytacazes\ \-\ RJ",
"55323533", "Colônia\ Padre\ Damião\ \-\ MG",
"55313847", "Minas\ Gerais",
"55163942", "Sertãozinho\ \-\ SP",
"55173695", "Marinópolis\ \-\ SP",
"55823025", "Maceió\ \-\ AL",
"55433901", "Apucarana\ \-\ PR",
"55653421", "Rondonópolis\ \-\ MT",
"55713648", "Dias\ d\'Ávila\ \-\ BA",
"55183344", "Presidente\ Prudente\ \-\ SP",
"55283523", "Gironda\ \-\ ES",
"55153372", "Itapetininga\ \-\ SP",
"55773221", "Itapetinga\ \-\ BA",
"55513463", "Rio\ Grande\ do\ Sul",
"55213267", "Rio\ de\ Janeiro\ \-\ RJ",
"55115833", "São\ Paulo\ \-\ SP",
"55313855", "Alvinópolis\ \-\ MG",
"55883556", "Catarina\ \-\ CE",
"55323296", "Arantina\ \-\ MG",
"55193567", "Santa\ Cruz\ da\ Conceição\ \-\ SP",
"55212774", "São\ João\ de\ Meriti\ \-\ RJ",
"5511589", "São\ Paulo\ \-\ SP",
"55112643", "São\ Paulo\ \-\ SP",
"55183706", "Suzanápolis\ \-\ SP",
"55423636", "Cantagalo\ \-\ PR",
"55623608", "Goiânia\ \-\ GO",
"55713203", "Salvador\ \-\ BA",
"55473535", "Atalanta\ \-\ SC",
"55193862", "Mogi\ Mirim\ \-\ SP",
"55753275", "Monte\ Santo\ \-\ BA",
"55114048", "Diadema\ \-\ SP",
"55313849", "Timóteo\ \-\ MG",
"55833278", "Alagoinha\ \-\ PB",
"55993563", "Aldeias\ Altas\ \-\ MA",
"55833511", "Patos\ \-\ PB",
"55343413", "São\ Francisco\ de\ Sales\ \-\ MG",
"55673475", "Japorã\ \-\ MS",
"55153384", "Cerquilho\ \-\ SP",
"55183651", "Avanhandava\ \-\ SP",
"55513552", "Lindolfo\ Collor\ \-\ RS",
"55623305", "São\ Francisco\ de\ Goiás\ \-\ GO",
"55413482", "Guaraqueçaba\ \-\ PR",
"55313542", "Nova\ Lima\ \-\ MG",
"55313840", "Minas\ Gerais",
"55843248", "Senador\ Georgino\ Avelino\ \-\ RN",
"55513114", "Guaíba\ \-\ RS",
"55743533", "Campo\ Alegre\ de\ Lourdes\ \-\ BA",
"55973343", "Tefé\ \-\ AM",
"55993649", "Peritoró\ \-\ MA",
"55713699", "Saubara\ \-\ BA",
"55673672", "Rio\ Brilhante\ \-\ MS",
"55114445", "Caieiras\ \-\ SP",
"55383624", "São\ Romão\ \-\ MG",
"55733301", "Itabuna\ \-\ BA",
"55443664", "Alto\ Paraíso\ \-\ PR",
"55843297", "Japi\ \-\ RN",
"55483278", "São\ José\ \-\ SC",
"55413685", "Paiol\ de\ Baixo\ \-\ PR",
"55993421", "Caxias\ \-\ MA",
"55193643", "Vargem\ Grande\ do\ Sul\ \-\ SP",
"55273065", "Serra\ \-\ ES",
"55173349", "Turvínia\ \-\ SP",
"55193801", "Indaiatuba\ \-\ SP",
"55273362", "Guarapari\ \-\ ES",
"55112862", "São\ Paulo\ \-\ SP",
"55313291", "Belo\ Horizonte\ \-\ MG",
"55423552", "General\ Carneiro\ \-\ PR",
"55813577", "Sirinhaém\ \-\ PE",
"55713286", "Salvador\ \-\ BA",
"55312524", "Contagem\ \-\ MG",
"55193551", "Araras\ \-\ SP",
"55653364", "Várzea\ Grande\ \-\ MT",
"55343281", "Tupaciguara\ \-\ MG",
"55643559", "Itumbiara\ \-\ GO",
"55833473", "Desterro\ \-\ PB",
"55143581", "Pongaí\ \-\ SP",
"55813512", "Cabo\ de\ Santo\ Agostinho\ \-\ PE",
"55273327", "Vitória\ \-\ ES",
"55112827", "São\ Paulo\ \-\ SP",
"55513636", "Rio\ Grande\ do\ Sul",
"55273263", "Santa\ Maria\ de\ Jetibá\ \-\ ES",
"55513509", "São\ Leopoldo\ \-\ RS",
"55963234", "Porto\ Grande\ \-\ AP",
"55133592", "Praia\ Grande\ \-\ SP",
"55433312", "Arapongas\ \-\ PR",
"55193827", "Artur\ Nogueira\ \-\ SP",
"55123677", "Natividade\ da\ Serra\ \-\ SP",
"55433015", "Rolândia\ \-\ PR",
"55753626", "Feira\ de\ Santana\ \-\ BA",
"5581346", "Recife\ \-\ PE",
"55333825", "Belo\ Oriente\ \-\ MG",
"55933067", "Santarém\ \-\ PA",
"55123018", "São\ José\ dos\ Campos\ \-\ SP",
"55443355", "Maringá\ \-\ PR",
"55953212", "Boa\ Vista\ \-\ RR",
"55873031", "Petrolina\ \-\ PE",
"55733263", "Teixeira\ de\ Freitas\ \-\ BA",
"55542102", "Bento\ Gonçalves\ \-\ RS",
"55323334", "Santana\ do\ Garambéu\ \-\ MG",
"55533224", "Morro\ Redondo\ \-\ RS",
"55773693", "Rio\ do\ Pires\ \-\ BA",
"55883418", "Jaguaruana\ \-\ CE",
"55333292", "Marilac\ \-\ MG",
"55163723", "Franca\ \-\ SP",
"55613333", "Recanto\ das\ Emas\ \-\ DF",
"55473456", "Barra\ Velha\ \-\ SC",
"55613603", "Luziânia\ \-\ GO",
"55143269", "Lençóis\ Paulista\ \-\ SP",
"55513128", "Gravataí\ \-\ RS",
"5522272", "Campos\ dos\ Goytacazes\ \-\ RJ",
"55673447", "Novo\ Horizonte\ do\ Sul\ \-\ MS",
"55713038", "Salvador\ \-\ BA",
"55663385", "Nova\ Brasilândia\ \-\ MT",
"55713632", "Pólo\ Petroquímico\ Camaçari\ \-\ BA",
"55753247", "Irará\ \-\ BA",
"55313515", "Belo\ Horizonte\ \-\ MG",
"55673455", "Rio\ Brilhante\ \-\ MS",
"55843534", "Pedro\ Avelino\ \-\ RN",
"55833258", "João\ Pessoa\ \-\ PB",
"55943327", "Núcleo\ Carajás\ \-\ PA",
"55713379", "Lauro\ de\ Freitas\ \-\ BA",
"55543393", "Mormaço\ \-\ RS",
"55483529", "Praia\ Grande\ \-\ SC",
"55115062", "São\ Paulo\ \-\ SP",
"55144004", "Bauru\ \-\ SP",
"55473222", "Blumenau\ \-\ SC",
"55413041", "Curitiba\ \-\ PR",
"55163394", "Matão\ \-\ SP",
"55483258", "São\ José\ \-\ SC",
"55213162", "Nilópolis\ \-\ RJ",
"55613299", "Brasília\ \-\ DF",
"55353694", "Lavras\ \-\ MG",
"55153321", "Sorocaba\ \-\ SP",
"55312101", "Belo\ Horizonte\ \-\ MG",
"55813204", "Recife\ \-\ PE",
"55613525", "Brasília\ \-\ DF",
"55643696", "Campo\ Alegre\ de\ Goiás\ \-\ GO",
"55114477", "Santo\ André\ \-\ SP",
"55833295", "Jacaraú\ \-\ PB",
"55983346", "Bacabeira\ \-\ MA",
"55553028", "Santa\ Maria\ \-\ RS",
"55673498", "Caarapó\ \-\ MS",
"55683325", "Marechal\ Thaumaturgo\ \-\ AC",
"55373331", "Oliveira\ \-\ MG",
"55183992", "Narandiba\ \-\ SP",
"55883648", "Uruoca\ \-\ CE",
"55383753", "Felixlândia\ \-\ MG",
"5571325", "Salvador\ \-\ BA",
"55633540", "Monte\ do\ Carmo\ \-\ TO",
"55643579", "Itumbiara\ \-\ GO",
"55933533", "Monte\ Alegre\ \-\ PA",
"55163668", "Santo\ Antônio\ da\ Alegria\ \-\ SP",
"55333724", "Divisópolis\ \-\ MG",
"55193366", "São\ João\ da\ Boa\ Vista\ \-\ SP",
"5515321", "Sorocaba\ \-\ SP",
"55193571", "Leme\ \-\ SP",
"55643570", "Claudinápolis\ \-\ GO",
"55493441", "Concórdia\ \-\ SC",
"55943301", "Maracajá\ \-\ PA",
"55533281", "Pelotas\ \-\ RS",
"55124110", "Pindamonhangaba\ \-\ SP",
"55623432", "Goiânia\ \-\ GO",
"55484009", "Florianópolis\ \-\ SC",
"5592361", "Manaus\ \-\ AM",
"55242224", "São\ José\ do\ Vale\ do\ Rio\ Preto\ \-\ RJ",
"55193792", "Limeira\ \-\ SP",
"55184101", "Presidente\ Prudente\ \-\ SP",
"55543541", "Trindade\ do\ Sul\ \-\ RS",
"55883424", "Tabuleiro\ do\ Norte\ \-\ CE",
"55813545", "Igarassu\ \-\ PE",
"55853331", "Barreira\ \-\ CE",
"55833453", "Conceição\ \-\ PB",
"55653904", "Campo\ Novo\ do\ Parecis\ \-\ MT",
"55843613", "Natal\ \-\ RN",
"55373246", "Igaratinga\ \-\ MG",
"55682106", "Rio\ Branco\ \-\ AC",
"55483093", "Palhoça\ \-\ SC",
"55353462", "Estiva\ \-\ MG",
"55433345", "Londrina\ \-\ PR",
"55813821", "Recife\ \-\ PE",
"55834009", "João\ Pessoa\ \-\ PB",
"55433911", "Jacarezinho\ \-\ PR",
"55512125", "Porto\ Alegre\ \-\ RS",
"55623338", "Corumbá\ de\ Goiás\ \-\ GO",
"55483264", "Canelinha\ \-\ SC",
"55173546", "Itajobi\ \-\ SP",
"55332102", "Governador\ Valadares\ \-\ MG",
"55323051", "Barbacena\ \-\ MG",
"55543292", "Flores\ da\ Cunha\ \-\ RS",
"55443017", "Campo\ Mourão\ \-\ PR",
"55153307", "Itapetininga\ \-\ SP",
"55743628", "Piritiba\ \-\ BA",
"55273388", "Vila\ Velha\ \-\ ES",
"55353553", "Juruaia\ \-\ MG",
"55553543", "Tuparendi\ \-\ RS",
"55443019", "Cianorte\ \-\ PR",
"55843333", "Apodi\ \-\ RN",
"55313768", "Contagem\ \-\ MG",
"55913017", "Ananindeua\ \-\ PA",
"5511482", "Ribeirão\ Pires\ \-\ SP",
"55343820", "Patos\ de\ Minas\ \-\ MG",
"55143222", "Bauru\ \-\ SP",
"55873803", "Pesqueira\ \-\ PE",
"55312535", "Belo\ Horizonte\ \-\ MG",
"55813731", "Santa\ Cruz\ do\ Capibaribe\ \-\ PE",
"55112811", "Salto\ \-\ SP",
"55273311", "Vila\ Velha\ \-\ ES",
"55623941", "Goiânia\ \-\ GO",
"55153253", "Quadra\ \-\ SP",
"55223853", "Santo\ Antônio\ de\ Pádua\ \-\ RJ",
"55413468", "Alexandra\ \-\ PR",
"55423519", "União\ da\ Vitória\ \-\ PR",
"55212768", "Nova\ Iguaçu\ \-\ RJ",
"55443437", "Amaporã\ \-\ PR",
"55163236", "Ribeirão\ Preto\ \-\ SP",
"55193811", "Mogi\-Guaçu\ \-\ SP",
"55643512", "Rio\ Quente\ \-\ GO",
"55484007", "Florianópolis\ \-\ SC",
"55323444", "Recreio\ \-\ MG",
"55242522", "Nova\ Friburgo\ \-\ RJ",
"55115029", "São\ Paulo\ \-\ SP",
"55193888", "Paulínia\ \-\ SP",
"55333237", "Fernandes\ Tourinho\ \-\ MG",
"55423274", "Ventania\ \-\ PR",
"55633547", "Porto\ Nacional\ \-\ TO",
"55833562", "Poço\ Dantas\ \-\ PB",
"55813559", "Ipojuca\ \-\ PE",
"55733311", "Teixeira\ de\ Freitas\ \-\ BA",
"5599352", "Imperatriz\ \-\ MA",
"5511349", "São\ Paulo\ \-\ SP",
"55493627", "Paraíso\ \-\ SC",
"55463313", "Pato\ Branco\ \-\ PR",
"55113433", "Embu\ das\ Artes\ \-\ SP",
"55443546", "Quarto\ Centenário\ \-\ PR",
"55143476", "Campos\ Novos\ Paulista\ \-\ SP",
"55733526", "Jequié\ \-\ BA",
"55133446", "Mongaguá\ \-\ SP",
"55693043", "Porto\ Velho\ \-\ RO",
"55613297", "Brasília\ \-\ DF",
"55453234", "Catanduvas\ \-\ PR",
"55313754", "Lamim\ \-\ MG",
"55513744", "Ibarama\ \-\ RS",
"55213765", "Mesquita\ \-\ RJ",
"55123836", "Ubatuba\ \-\ SP",
"55873886", "Verdejante\ \-\ PE",
"55653928", "Cuiabá\ \-\ MT",
"55473524", "Aurora\ \-\ SC",
"55313538", "Esmeraldas\ \-\ MG",
"55843232", "Natal\ \-\ RN",
"55483527", "Araranguá\ \-\ SC",
"55513274", "Rio\ Grande\ do\ Sul",
"55114638", "Poá\ \-\ SP",
"55753249", "Tanquinho\ \-\ BA",
"55113198", "São\ Paulo\ \-\ SP",
"55123602", "Taubaté\ \-\ SP",
"55673449", "Nova\ Andradina\ \-\ MS",
"55813561", "Ipojuca\ \-\ PE",
"55473251", "Brusque\ \-\ SC",
"55513584", "Novo\ Hamburgo\ \-\ RS",
"55114032", "Bragança\ Paulista\ \-\ SP",
"55353641", "Brasópolis\ \-\ MG",
"55313875", "Santa\ Margarida\ \-\ MG",
"55883576", "Jaguaretama\ \-\ CE",
"55433302", "Londrina\ \-\ PR",
"55143267", "Borebi\ \-\ SP",
"55813376", "Jaboatão\ dos\ Guararapes\ \-\ PE",
"55383635", "Arinos\ \-\ MG",
"55163341", "Ibitinga\ \-\ SP",
"55673440", "Amandina\ \-\ MS",
"55163832", "Ipuã\ \-\ SP",
"55513354", "Rio\ Grande\ do\ Sul",
"55933597", "Tabocal\ \-\ PA",
"55923672", "Manaus\ \-\ AM",
"55683234", "Capixaba\ \-\ AC",
"55623343", "Abadiânia\ \-\ GO",
"55613677", "Planaltina\ \-\ GO",
"55183855", "Monte\ Castelo\ \-\ SP",
"55193402", "Piracicaba\ \-\ SP",
"55353282", "Carvalhópolis\ \-\ MG",
"55813256", "Jaboatão\ dos\ Guararapes\ \-\ PE",
"55863264", "José\ de\ Freitas\ \-\ PI",
"55153272", "Itapetininga\ \-\ SP",
"55663540", "União\ do\ Sul\ \-\ MT",
"55793443", "Campo\ do\ Brito\ \-\ SE",
"55613081", "Brasília\ \-\ DF",
"55513427", "Canoas\ \-\ RS",
"55613612", "Cristalina\ \-\ GO",
"55473371", "Jaraguá\ do\ Sul\ \-\ SC",
"5577", "Bahia",
"55114178", "São\ Bernardo\ do\ Campo\ \-\ SP",
"55493346", "Quilombo\ \-\ SC",
"55643469", "Anhanguera\ \-\ GO",
"55173844", "Pontes\ Gestal\ \-\ SP",
"55483037", "Florianópolis\ \-\ SC",
"55112523", "São\ Paulo\ \-\ SP",
"55753437", "Nova\ Soure\ \-\ BA",
"55222762", "Macaé\ \-\ RJ",
"55552101", "Santa\ Maria\ \-\ RS",
"55613415", "Brasília\ \-\ DF",
"55163751", "Buritizal\ \-\ SP",
"55114820", "Rio\ Grande\ da\ Serra\ \-\ SP",
"55813873", "Araripina\ \-\ PE",
"55193308", "Campinas\ \-\ SP",
"55833484", "Juru\ \-\ PB",
"55864009", "Teresina\ \-\ PI",
"55114403", "Itu\ \-\ SP",
"55513694", "Minas\ do\ Leão\ \-\ RS",
"55833419", "Santa\ Teresinha\ \-\ PB",
"55313622", "Vespasiano\ \-\ MG",
"55883633", "Ararendá\ \-\ CE",
"55314111", "Belo\ Horizonte\ \-\ MG",
"55513665", "Capão\ da\ Canoa\ \-\ RS",
"55433152", "Arapongas\ \-\ PR",
"55222727", "São\ Francisco\ de\ Itabapoana\ \-\ RJ",
"55213644", "Teresópolis\ \-\ RJ",
"55913712", "Castanhal\ \-\ PA",
"55843661", "Natal\ \-\ RN",
"55883514", "Cariús\ \-\ CE",
"55863258", "Monsenhor\ Gil\ \-\ PI",
"55183623", "Araçatuba\ \-\ SP",
"55623591", "Goiânia\ \-\ GO",
"55513401", "Guaíba\ \-\ RS",
"5535342", "Pouso\ Alegre\ \-\ MG",
"5551351", "Rio\ Grande\ do\ Sul",
"55273229", "Vila\ Velha\ \-\ ES",
"55843405", "Currais\ Novos\ \-\ RN",
"55813314", "Recife\ \-\ PE",
"55633385", "Talismã\ \-\ TO",
"55313667", "Coronel\ Fabriciano\ \-\ MG",
"55543337", "Estação\ \-\ RS",
"55913777", "Ponta\ de\ Pedras\ \-\ PA",
"55513368", "Rio\ Grande\ do\ Sul",
"55663016", "Primavera\ do\ Leste\ \-\ MT",
"55194003", "Campinas\ \-\ SP",
"55424063", "Ponta\ Grossa\ \-\ PR",
"55323727", "Barão\ de\ Monte\ Alto\ \-\ MG",
"55113608", "Osasco\ \-\ SP",
"55863295", "São\ Félix\ do\ Piauí\ \-\ PI",
"55893533", "Rio\ Grande\ do\ Piauí\ \-\ PI",
"55443249", "Lobato\ \-\ PR",
"55433270", "Santa\ Cecília\ do\ Pavão\ \-\ PR",
"55873879", "Exu\ \-\ PE",
"55873870", "Trindade\ \-\ PE",
"55693418", "Nova\ Brasilândia\ D\'Oeste\ \-\ RO",
"55823267", "Coqueiro\ Seco\ \-\ AL",
"55323532", "Ubá\ \-\ MG",
"55163943", "Barrinha\ \-\ SP",
"55793297", "Siriri\ \-\ SE",
"55963689", "Afuá\ \-\ PA",
"55153373", "Itapetininga\ \-\ SP",
"55693481", "Espigão\ do\ Oeste\ \-\ RO",
"55513462", "Canoas\ \-\ RS",
"55713043", "Salvador\ \-\ BA",
"55212667", "Nova\ Iguaçu\ \-\ RJ",
"55143414", "Marília\ \-\ SP",
"55713504", "Lauro\ de\ Freitas\ \-\ BA",
"55873791", "Palmeirina\ \-\ PE",
"55113305", "São\ Paulo\ \-\ SP",
"55654007", "Cuiabá\ \-\ MT",
"55283522", "Cachoeiro\ de\ Itapemirim\ \-\ ES",
"55143489", "Iacri\ \-\ SP",
"55333621", "Nanuque\ \-\ MG",
"55114486", "Terra\ Preta\ \-\ SP",
"55143487", "Júlio\ Mesquita\ \-\ SP",
"55112642", "São\ Paulo\ \-\ SP",
"55193863", "Itapira\ \-\ SP",
"55193324", "Campinas\ \-\ SP",
"55663436", "Poxoréo\ \-\ MT",
"55212669", "Nova\ Iguaçu\ \-\ RJ",
"55443255", "Maringá\ \-\ PR",
"55373016", "Divinópolis\ \-\ MG",
"55654009", "Cuiabá\ \-\ MT",
"55343412", "Campina\ Verde\ \-\ MG",
"55823269", "Pólo\ Cloroquímico\ de\ Alagoas\ \-\ AL",
"55813471", "Recife\ \-\ PE",
"5511314", "São\ Paulo\ \-\ SP",
"55193457", "Santa\ Bárbara\ D\'Oeste\ \-\ SP",
"55993562", "Gonçalves\ Dias\ \-\ MA",
"55242266", "Werneck\ \-\ RJ",
"55323729", "Muriaé\ \-\ MG",
"55513553", "Novo\ Hamburgo\ \-\ RS",
"55313543", "Raposos\ \-\ MG",
"55213691", "Japeri\ \-\ RJ",
"55443247", "Santa\ Fé\ \-\ PR",
"55873877", "Floresta\ \-\ PE",
"55693435", "Novo\ Horizonte\ do\ Oeste\ \-\ RO",
"55613233", "Guará\ \-\ DF",
"55823260", "Marechal\ Deodoro\ \-\ AL",
"55673673", "Jateí\ \-\ MS",
"55283551", "Divino\ de\ São\ Lourenço\ \-\ ES",
"55543330", "Carazinho\ \-\ RS",
"55743532", "Pilar\ \-\ BA",
"55834105", "Cabedelo\ \-\ PB",
"55133341", "Guarujá\ \-\ SP",
"55213917", "Maricá\ \-\ RJ",
"55313660", "Pedro\ Leopoldo\ \-\ MG",
"55543339", "Erebango\ \-\ RS",
"55813634", "Surubim\ \-\ PE",
"55824004", "Maceió\ \-\ AL",
"55543617", "Tapejara\ \-\ RS",
"55273171", "Linhares\ \-\ ES",
"55883587", "Juazeiro\ do\ Norte\ \-\ CE",
"55193642", "Águas\ da\ Prata\ \-\ SP",
"55343318", "Uberaba\ \-\ MG",
"55773464", "Mortugaba\ \-\ BA",
"55273227", "Vitória\ \-\ ES",
"55713261", "Salvador\ \-\ BA",
"55343266", "Canápolis\ \-\ MG",
"55773495", "Caetité\ \-\ BA",
"55653529", "Santa\ Rita\ do\ Trivelato\ \-\ MT",
"55423553", "Bituruna\ \-\ PR",
"55673230", "Pedro\ Gomes\ \-\ MS",
"55114739", "Mogi\ das\ Cruzes\ \-\ SP",
"55113448", "Osasco\ \-\ SP",
"55843397", "Umarizal\ \-\ RN",
"55483378", "Santa\ Tereza\ \-\ SC",
"55673239", "Água\ Clara\ \-\ MS",
"55223512", "Nova\ Friburgo\ \-\ RJ",
"55212651", "São\ João\ de\ Meriti\ \-\ RJ",
"55553754", "Pinhal\ \-\ RS",
"55753439", "Ribeira\ do\ Amparo\ \-\ BA",
"55483030", "Florianópolis\ \-\ SC",
"55173249", "Potirendaba\ \-\ SP",
"55413122", "Curitiba\ \-\ PR",
"55833472", "Teixeira\ \-\ PB",
"55823251", "Matriz\ de\ Camaragibe\ \-\ AL",
"55623086", "Goiânia\ \-\ GO",
"55273262", "Guarapari\ \-\ ES",
"55483039", "Florianópolis\ \-\ SC",
"55313391", "Contagem\ \-\ MG",
"55753430", "Itapicuru\ \-\ BA",
"55743656", "Canarana\ \-\ BA",
"55513429", "Canoas\ \-\ RS",
"55283569", "Ibitirama\ \-\ ES",
"55773458", "Brumado\ \-\ BA",
"55283560", "Alegre\ \-\ ES",
"55513420", "Rio\ Grande\ do\ Sul",
"55333536", "Teófilo\ Otoni\ \-\ MG",
"55663547", "Tapurah\ \-\ MT",
"55313651", "Caeté\ \-\ MG",
"55542103", "Passo\ Fundo\ \-\ RS",
"55733262", "Eunápolis\ \-\ BA",
"55833378", "Campo\ de\ Santana\ \-\ PB",
"55654052", "Cuiabá\ \-\ MT",
"55353274", "Olímpio\ Noronha\ \-\ MG",
"55613679", "São\ Gabriel\ de\ Goiás\ \-\ GO",
"55153284", "Cerquilho\ \-\ SP",
"55313939", "Conselheiro\ Lafaiete\ \-\ MG",
"55993118", "Timon\ \-\ MA",
"55163722", "Franca\ \-\ SP",
"55983465", "Nina\ Rodrigues\ \-\ MA",
"55613332", "Recanto\ das\ Emas\ \-\ DF",
"55823524", "Feira\ Grande\ \-\ AL",
"55553538", "Boa\ Vista\ do\ Buricá\ \-\ RS",
"55643586", "Itumbiara\ \-\ GO",
"55212391", "Rio\ de\ Janeiro\ \-\ RJ",
"55333293", "São\ José\ da\ Safira\ \-\ MG",
"55663555", "Cotriguaçu\ \-\ MT",
"55433474", "Grandes\ Rios\ \-\ PR",
"55114665", "Embu\-Guaçu\ \-\ SP",
"55314113", "Sete\ Lagoas\ \-\ MG",
"55753656", "Glória\ \-\ BA",
"55613704", "Brasília\ \-\ DF",
"55883631", "Itapipoca\ \-\ CE",
"55413883", "Curitiba\ \-\ PR",
"55493438", "Ipumirim\ \-\ SC",
"55213554", "Rio\ de\ Janeiro\ \-\ RJ",
"55193857", "Engenheiro\ Coelho\ \-\ SP",
"55443444", "São\ Pedro\ do\ Paraná\ \-\ PR",
"55833356", "Cabaceiras\ \-\ PB",
"55343812", "Lagamar\ \-\ MG",
"55663405", "Barra\ do\ Garças\ \-\ MT",
"55473426", "Joinville\ \-\ SC",
"55143284", "Pederneiras\ \-\ SP",
"55644052", "Itumbiara\ \-\ GO",
"55443628", "Jussara\ \-\ PR",
"55312112", "Belo\ Horizonte\ \-\ MG",
"55193463", "Santa\ Bárbara\ D\'Oeste\ \-\ SP",
"55552103", "Santa\ Maria\ \-\ RS",
"55513567", "Santa\ Maria\ do\ Herval\ \-\ RS",
"55333244", "Galiléia\ \-\ MG",
"55193845", "Hortolândia\ \-\ SP",
"55853348", "Pacajus\ \-\ CE",
"55533254", "Cerrito\ \-\ RS",
"55773476", "Abaíra\ \-\ BA",
"55112521", "São\ Paulo\ \-\ SP",
"55633534", "Mateiros\ \-\ TO",
"55473373", "Guaramirim\ \-\ SC",
"5521261", "Niterói\ \-\ RJ",
"55183607", "Araçatuba\ \-\ SP",
"55733697", "Travessão\ \-\ BA",
"55213221", "Rio\ de\ Janeiro\ \-\ RJ",
"55273345", "Vitória\ \-\ ES",
"55193521", "Campinas\ \-\ SP",
"55643520", "Itumbiara\ \-\ GO",
"55493332", "Águas\ Frias\ \-\ SC",
"55423522", "União\ da\ Vitória\ \-\ PR",
"55323084", "Juiz\ de\ Fora\ \-\ MG",
"55623341", "Goianápolis\ \-\ GO",
"55114462", "Santo\ André\ \-\ SP",
"55922127", "Manaus\ \-\ AM",
"55483356", "Imbituba\ \-\ SC",
"55193187", "Santa\ Maria\ da\ Serra\ \-\ SP",
"55273357", "Vitória\ \-\ ES",
"55463564", "Salgado\ Filho\ \-\ PR",
"55513486", "Morungava\ \-\ RS",
"55413556", "São\ José\ dos\ Pinhais\ \-\ PR",
"55153566", "Bairro\ Palmitalzinho\ \-\ SP",
"55543056", "Farroupilha\ \-\ RS",
"55333623", "Fronteira\ dos\ Vales\ \-\ MG",
"55534062", "Pelotas\ \-\ RS",
"55873793", "Calçado\ \-\ PE",
"55493233", "São\ Joaquim\ \-\ SC",
"55112507", "São\ Paulo\ \-\ SP",
"55163315", "Ribeirão\ Preto\ \-\ SP",
"55713041", "Camaçari\ \-\ BA",
"5582", "Alagoas",
"55833280", "Salgado\ de\ São\ Félix\ \-\ PB",
"55163941", "Ribeirão\ Preto\ \-\ SP",
"55553617", "Tiradentes\ do\ Sul\ \-\ RS",
"55893531", "Canto\ do\ Buriti\ \-\ PI",
"55643453", "Caldas\ Novas\ \-\ GO",
"55114427", "Santo\ André\ \-\ SP",
"55213568", "Niterói\ \-\ RJ",
"55353266", "Três\ Pontas\ \-\ MG",
"55463220", "Pato\ Branco\ \-\ PR",
"55833289", "Juripiranga\ \-\ PB",
"55242104", "Petrópolis\ \-\ RJ",
"55922101", "Manaus\ \-\ AM",
"55653625", "Cuiabá\ \-\ MT",
"55463558", "Pérola\ D\'Oeste\ \-\ PR",
"55483214", "São\ José\ \-\ SC",
"55453255", "São\ Pedro\ do\ Iguaçu\ \-\ PR",
"55943312", "Marabá\ \-\ PA",
"55313735", "Jeceaba\ \-\ MG",
"55663399", "Campo\ Verde\ \-\ MT",
"55513522", "Morro\ da\ Pedra\ \-\ RS",
"55863304", "Teresina\ \-\ PI",
"55114694", "Biritiba\-Mirim\ \-\ SP",
"55213207", "Rio\ de\ Janeiro\ \-\ RJ",
"55183621", "Araçatuba\ \-\ SP",
"55623593", "Goiânia\ \-\ GO",
"55513403", "Guaíba\ \-\ RS",
"55453247", "Penha\ \-\ PR",
"55843663", "Natal\ \-\ RN",
"55413632", "Piên\ \-\ PR",
"55193507", "Araras\ \-\ SP",
"55534001", "Pelotas\ \-\ RS",
"55513737", "Rio\ Grande\ do\ Sul",
"55453249", "Anahy\ \-\ PR",
"55943379", "São\ João\ do\ Araguaia\ \-\ PA",
"55112861", "São\ Paulo\ \-\ SP",
"55273361", "Guarapari\ \-\ ES",
"55513739", "Rio\ Grande\ do\ Sul",
"55663442", "Vale\ dos\ Sonhos\ \-\ MT",
"55313292", "Belo\ Horizonte\ \-\ MG",
"55513730", "Passo\ do\ Sobrado\ \-\ RS",
"55793465", "São\ Miguel\ do\ Aleixo\ \-\ SE",
"55453240", "Medianeira\ \-\ PR",
"55423643", "Nova\ Tebas\ \-\ PR",
"55193802", "Holambra\ \-\ SP",
"55313132", "Esmeraldas\ \-\ MG",
"55883526", "Saboeiro\ \-\ CE",
"55143373", "Santa\ Cruz\ do\ Rio\ Pardo\ \-\ SP",
"55993422", "Caxias\ \-\ MA",
"55133343", "Guarujá\ \-\ SP",
"55313718", "Baldim\ \-\ MG",
"55483287", "Florianópolis\ \-\ SC",
"55673671", "Dourados\ \-\ MS",
"55163432", "Franca\ \-\ SP",
"55283553", "Guaçuí\ \-\ ES",
"55464054", "Francisco\ Beltrão\ \-\ PR",
"55623365", "Crixás\ \-\ GO",
"55673434", "Sanga\ Puitã\ \-\ MS",
"55183652", "Penápolis\ \-\ SP",
"55843555", "Pedra\ Grande\ \-\ RN",
"55353335", "Conceição\ do\ Rio\ Verde\ \-\ MG",
"55513551", "Estância\ Velha\ \-\ RS",
"55214133", "Magé\ \-\ RJ",
"55313541", "Nova\ Lima\ \-\ MG",
"55833287", "Mari\ \-\ PB",
"55213693", "Paracambi\ \-\ RJ",
"55143102", "Bauru\ \-\ SP",
"55643956", "Itumbiara\ \-\ GO",
"55463227", "Vitorino\ \-\ PR",
"55743546", "Itiúba\ \-\ BA",
"55813473", "Jaboatão\ dos\ Guararapes\ \-\ PE",
"55114641", "Itaquaquecetuba\ \-\ SP",
"55433526", "Santana\ do\ Itararé\ \-\ PR",
"55212132", "Rio\ de\ Janeiro\ \-\ RJ",
"55423560", "Fluviópolis\ \-\ PR",
"55193861", "Mogi\-Guaçu\ \-\ SP",
"55893585", "Coronel\ José\ Dias\ \-\ PI",
"55943435", "São\ Félix\ do\ Xingu\ \-\ PA",
"55753234", "Nova\ Fátima\ \-\ BA",
"55163338", "Gavião\ Peixoto\ \-\ SP",
"55863276", "Piripiri\ \-\ PI",
"55733286", "Itapebi\ \-\ BA",
"552124", "Rio\ de\ Janeiro\ \-\ RJ",
"55273302", "Aracruz\ \-\ ES",
"55173893", "Palestina\ \-\ SP",
"55333291", "Coroaci\ \-\ MG",
"55513983", "Venâncio\ Aires\ \-\ RS",
"55463262", "Palmas\ \-\ PR",
"55323375", "Conceição\ da\ Barra\ de\ Minas\ \-\ MG",
"55213828", "Rio\ de\ Janeiro\ \-\ RJ",
"55224105", "Nova\ Friburgo\ \-\ RJ",
"55373405", "Arcos\ \-\ MG",
"55922129", "Manaus\ \-\ AM",
"55873032", "Petrolina\ \-\ PE",
"55273350", "Vila\ Velha\ \-\ ES",
"55542101", "Caxias\ do\ Sul\ \-\ RS",
"55854117", "Maracanaú\ \-\ CE",
"55813748", "Sairé\ \-\ PE",
"55115635", "São\ Paulo\ \-\ SP",
"55423906", "Castro\ \-\ PR",
"55493018", "Lages\ \-\ SC",
"55843436", "São\ Vicente\ \-\ RN",
"55493677", "Itapiranga\ \-\ SC",
"55122123", "Taubaté\ \-\ SP",
"55993586", "Ribamar\ Fiquene\ \-\ MA",
"55323017", "Juiz\ de\ Fora\ \-\ MG",
"55183609", "Araçatuba\ \-\ SP",
"55433311", "Rolândia\ \-\ PR",
"55133591", "Praia\ Grande\ \-\ SP",
"55114886", "Itu\ \-\ SP",
"55513569", "Morro\ Reuter\ \-\ RS",
"55313393", "Minas\ Gerais",
"55633232", "Palmas\ \-\ TO",
"55623394", "Santa\ Rita\ do\ Novo\ Destino\ \-\ GO",
"55883685", "Ipueiras\ \-\ CE",
"55193966", "Conchal\ \-\ SP",
"55853650", "Carnaubal\ \-\ CE",
"55143880", "Botucatu\ \-\ SP",
"55143814", "Botucatu\ \-\ SP",
"55823253", "Novo\ Lino\ \-\ AL",
"55143582", "Uru\ \-\ SP",
"55513560", "Araricá\ \-\ RS",
"55212653", "Duque\ de\ Caxias\ \-\ RJ",
"55213252", "Rio\ de\ Janeiro\ \-\ RJ",
"55193859", "Valinhos\ \-\ SP",
"55733203", "Ibicaraí\ \-\ BA",
"55423551", "Santana\ \-\ PR",
"55983525", "Imperatriz\ \-\ MA",
"55383236", "Juramento\ \-\ MG",
"55812626", "Recife\ \-\ PE",
"55913444", "Mãe\ do\ Rio\ \-\ PA",
"55683546", "Brasiléia\ \-\ AC",
"55193552", "Mogi\ Mirim\ \-\ SP",
"55283517", "Cachoeiro\ de\ Itapemirim\ \-\ ES",
"55373333", "Carmópolis\ de\ Minas\ \-\ MG",
"55923667", "Manaus\ \-\ AM",
"55733279", "Teolândia\ \-\ BA",
"55863289", "São\ Gonçalo\ do\ Piauí\ \-\ PI",
"55813647", "Buenos\ Aires\ \-\ PE",
"55633659", "Ponte\ Alta\ do\ Bom\ Jesus\ \-\ TO",
"55873829", "Ingazeira\ \-\ PE",
"55883558", "Abaiara\ \-\ CE",
"55863214", "Teresina\ \-\ PI",
"55333087", "Teófilo\ Otoni\ \-\ MG",
"55863280", "São\ Pedro\ do\ Piauí\ \-\ PI",
"55733270", "Itabela\ \-\ BA",
"55312103", "Belo\ Horizonte\ \-\ MG",
"55463902", "Pato\ Branco\ \-\ PR",
"55224009", "Campos\ dos\ Goitacazes\ \-\ RJ",
"55553565", "Porto\ Lucena\ \-\ RS",
"55213639", "Itaboraí\ \-\ RJ",
"55813655", "São\ Vicente\ Ferrer\ \-\ PE",
"55213630", "Magé\ \-\ RJ",
"55153267", "Capela\ do\ Alto\ \-\ SP",
"55483469", "Treviso\ \-\ SC",
"55713646", "Lauro\ de\ Freitas\ \-\ BA",
"55143495", "Tupã\ \-\ SP",
"55343429", "Frutal\ \-\ MG",
"55143352", "Piraju\ \-\ SP",
"55333434", "São\ Pedro\ do\ Suaçuí\ \-\ MG",
"55222777", "Rio\ das\ Ostras\ \-\ RJ",
"55543391", "Gaurama\ \-\ RS",
"55273270", "Barra\ do\ Riacho\ \-\ ES",
"55813452", "Jaboatão\ dos\ Guararapes\ \-\ PE",
"55753604", "Feira\ de\ Santana\ \-\ BA",
"55833469", "Várzea\ \-\ PB",
"55193924", "Águas\ de\ Lindóia\ \-\ SP",
"55973485", "Guajará\ \-\ AM",
"55313896", "Pedra\ do\ Anta\ \-\ MG",
"55323255", "Ewbank\ da\ Câmara\ \-\ MG",
"55213103", "Nova\ Iguaçu\ \-\ RJ",
"55473307", "Jaraguá\ do\ Sul\ \-\ SC",
"55193488", "Mombuca\ \-\ SP",
"55833304", "São\ Sebastião\ do\ Umbuzeiro\ \-\ PB",
"55423412", "Mato\ Branco\ de\ Baixo\ \-\ PR",
"55513793", "Venâncio\ Aires\ \-\ RS",
"55493248", "Ponte\ Alta\ \-\ SC",
"55913727", "Tomé\-Açu\ \-\ PA",
"55433558", "Santo\ Antônio\ da\ Platina\ \-\ PR",
"55823426", "Estrela\ de\ Alagoas\ \-\ AL",
"55112085", "Guarulhos\ \-\ SP",
"55443234", "Astorga\ \-\ PR",
"55613465", "Brasília\ \-\ DF",
"55633399", "Sucupira\ \-\ TO",
"55143458", "Queiroz\ \-\ SP",
"55623537", "Aparecida\ de\ Goiânia\ \-\ GO",
"55943386", "Lindoeste\ \-\ PA",
"55613601", "Luziânia\ \-\ GO",
"55643419", "Cromínia\ \-\ GO",
"55313078", "Belo\ Horizonte\ \-\ MG",
"55893492", "Campo\ Alegre\ do\ Fidalgo\ \-\ PI",
"55673291", "Coxim\ \-\ MS",
"55213743", "Nilópolis\ \-\ RJ",
"55663534", "Terra\ Nova\ do\ Norte\ \-\ MT",
"55513266", "Rio\ Grande\ do\ Sul",
"55114282", "São\ Paulo\ \-\ SP",
"55793346", "Canindé\ de\ São\ Francisco\ \-\ SE",
"55613054", "Brasília\ \-\ DF",
"55513381", "Rio\ Grande\ do\ Sul",
"55383832", "São\ João\ do\ Paraíso\ \-\ MG",
"55483091", "Florianópolis\ \-\ SC",
"55133846", "Pedro\ Barros\ \-\ SP",
"55843385", "Marcelino\ Vieira\ \-\ RN",
"55313339", "Belo\ Horizonte\ \-\ MG",
"55313330", "Belo\ Horizonte\ \-\ MG",
"55753491", "Feira\ de\ Santana\ \-\ BA",
"55213856", "São\ Gonçalo\ \-\ RJ",
"55883564", "Cedro\ \-\ CE",
"55843611", "Natal\ \-\ RN",
"55623446", "Alto\ Paraíso\ de\ Goiás\ \-\ GO",
"55513615", "Caraá\ \-\ RS",
"55433564", "Quatiguá\ \-\ PR",
"55823272", "Barra\ de\ São\ Miguel\ \-\ AL",
"5511507", "São\ Paulo\ \-\ SP",
"55833451", "Itaporanga\ \-\ PB",
"55373232", "Pará\ de\ Minas\ \-\ MG",
"55353737", "São\ Pedro\ de\ Caldas\ \-\ MG",
"55353829", "Lavras\ \-\ MG",
"55733633", "Ilhéus\ \-\ BA",
"55353522", "Passos\ \-\ MG",
"55613627", "Valparaíso\ de\ Goiás\ \-\ GO",
"55493443", "São\ Domingos\ \-\ SC",
"55533283", "Pelotas\ \-\ RS",
"5511285", "São\ Paulo\ \-\ SP",
"55923028", "Manaus\ \-\ AM",
"55173839", "Parisi\ \-\ SP",
"5547", "Santa\ Catarina",
"55193573", "Leme\ \-\ SP",
"55913656", "Santa\ Bárbara\ do\ Pará\ \-\ PA",
"55933531", "Medicilândia\ \-\ PA",
"55633602", "Paraíso\ do\ Tocantins\ \-\ TO",
"55513477", "Canoas\ \-\ RS",
"55182102", "Araçatuba\ \-\ SP",
"55383751", "Corinto\ \-\ MG",
"55473098", "Itapema\ \-\ SC",
"55823284", "Cajueiro\ \-\ AL",
"55113431", "Barueri\ \-\ SP",
"55753022", "Feira\ de\ Santana\ \-\ BA",
"55513479", "Nova\ Santa\ Rita\ \-\ RS",
"55463311", "Pato\ Branco\ \-\ PR",
"55453375", "Esquina\ Ipiranga\ \-\ PR",
"55833625", "Marcação\ \-\ PB",
"55883416", "Tauá\ \-\ CE",
"55733313", "Ipiaú\ \-\ BA",
"55443656", "Alto\ Piquiri\ \-\ PR",
"55513470", "Rio\ Grande\ do\ Sul",
"55753325", "Iaçu\ \-\ BA",
"55173837", "Sebastianópolis\ do\ Sul\ \-\ SP",
"55153524", "Itapeva\ \-\ SP",
"55473458", "São\ João\ do\ Itaperiú\ \-\ SC",
"55613629", "Valparaíso\ de\ Goiás\ \-\ GO",
"55193813", "Itapira\ \-\ SP",
"55242401", "Barra\ do\ Piraí\ \-\ RJ",
"55433262", "Assaí\ \-\ PR",
"55553781", "Santo\ Augusto\ \-\ RS",
"55753628", "São\ Felipe\ \-\ BA",
"55143307", "Ibirarema\ \-\ SP",
"55382104", "Montes\ Claros\ \-\ MG",
"55613620", "Luziânia\ \-\ GO",
"55223851", "Santo\ Antônio\ de\ Pádua\ \-\ RJ",
"55993577", "Parnarama\ \-\ MA",
"55453017", "Foz\ do\ Iguaçu\ \-\ PR",
"55353739", "Andradas\ \-\ MG",
"55153251", "Tatuí\ \-\ SP",
"55163242", "Monte\ Alto\ \-\ SP",
"55773489", "Cocos\ \-\ BA",
"55273313", "São\ Mateus\ \-\ ES",
"55112813", "São\ Paulo\ \-\ SP",
"55473055", "Jaraguá\ do\ Sul\ \-\ SC",
"55773414", "Jussiape\ \-\ BA",
"55513638", "Salvador\ do\ Sul\ \-\ RS",
"55473352", "Presidente\ Getúlio\ \-\ SC",
"55383722", "Curvelo\ \-\ MG",
"55813733", "Taquaritinga\ do\ Norte\ \-\ PE",
"55773480", "Coribe\ \-\ BA",
"55313337", "Belo\ Horizonte\ \-\ MG",
"55513032", "Canoas\ \-\ RS",
"55114812", "Campo\ Limpo\ Paulista\ \-\ SP",
"55623683", "Santa\ Bárbara\ de\ Goiás\ \-\ GO",
"55744400", "Pilão\ Arcado\ \-\ BA",
"55713288", "Lauro\ de\ Freitas\ \-\ BA",
"55473047", "Balneário\ Camboriú\ \-\ SC",
"55833422", "Patos\ \-\ PB",
"55873983", "Petrolina\ \-\ PE",
"55843331", "Açu\ \-\ RN",
"55313684", "Taquaraçu\ de\ Minas\ \-\ MG",
"55483625", "Treze\ de\ Maio\ \-\ SC",
"55114519", "Mauá\ \-\ SP",
"55353551", "Guaxupé\ \-\ MG",
"55553541", "Santo\ Cristo\ \-\ RS",
"55163343", "Ibaté\ \-\ SP",
"55623539", "Goiânia\ \-\ GO",
"55973431", "São\ Paulo\ de\ Olivença\ \-\ AM",
"55543622", "Passo\ Fundo\ \-\ RS",
"55643417", "Morrinhos\ \-\ GO",
"55353643", "Piranguçu\ \-\ MG",
"55143321", "Bauru\ \-\ SP",
"55913729", "Paragominas\ \-\ PA",
"55813563", "Gravatá\ \-\ PE",
"55443532", "Moreira\ Sales\ \-\ PR",
"55633397", "Pugmil\ \-\ TO",
"55713167", "Salvador\ \-\ BA",
"55643472", "Santa\ Cruz\ de\ Goiás\ \-\ GO",
"55123842", "Ubatuba\ \-\ SP",
"55273277", "Timbuí\ \-\ ES",
"55473309", "Blumenau\ \-\ SC",
"55473300", "Rio\ do\ Sul\ \-\ SC",
"55483276", "Alfredo\ Wagner\ \-\ SC",
"5564400", "Itumbiara\ \-\ GO",
"55222779", "Conceição\ de\ Macabu\ \-\ RJ",
"55473464", "Joinville\ \-\ SC",
"55833467", "São\ José\ do\ Sabugi\ \-\ PB",
"55633442", "Ananás\ \-\ TO",
"55833276", "Pilões\ \-\ PB",
"55643675", "Palminópolis\ \-\ GO",
"55693912", "Espigão\ do\ Oeste\ \-\ RO",
"55493525", "Catanduvas\ \-\ SC",
"55343427", "Planura\ \-\ MG",
"55483467", "Içara\ \-\ SC",
"55123663", "Campos\ do\ Jordão\ \-\ SP",
"55193374", "Piracicaba\ \-\ SP",
"55193031", "Campinas\ \-\ SP",
"55733212", "Itabuna\ \-\ BA",
"55653356", "Rosário\ Oeste\ \-\ MT",
"55843246", "Pipa\ \-\ RN",
"55333089", "Governador\ Valadares\ \-\ MG",
"55183708", "Primeira\ Aliança\ \-\ SP",
"55463526", "Itapejara\ D\'Oeste\ \-\ PR",
"55953263", "Alto\ Alegre\ \-\ RR",
"55423638", "Candói\ \-\ PR",
"55533031", "Pelotas\ \-\ RS",
"55273755", "Ecoporanga\ \-\ ES",
"55733277", "Guaratinga\ \-\ BA",
"55343354", "Santa\ Juliana\ \-\ MG",
"55543344", "Tapejara\ \-\ RS",
"55813649", "Machados\ \-\ PE",
"55333014", "Governador\ Valadares\ \-\ MG",
"55114104", "São\ Bernardo\ do\ Campo\ \-\ SP",
"55313440", "Minas\ Gerais",
"55513099", "São\ Leopoldo\ \-\ RS",
"55993545", "São\ Domingos\ do\ Azeitão\ \-\ MA",
"55513450", "Rio\ Grande\ do\ Sul",
"55313621", "Vespasiano\ \-\ MG",
"55623336", "Alexânia\ \-\ GO",
"55693526", "Jaru\ \-\ RO",
"55173548", "Marapoama\ \-\ SP",
"55443676", "Cruzeiro\ do\ Oeste\ \-\ PR",
"55133305", "Guarujá\ \-\ SP",
"55343813", "Vazante\ \-\ MG",
"55413589", "Piraquara\ \-\ PR",
"55513459", "Esteio\ \-\ RS",
"55733043", "Itabuna\ \-\ BA",
"55743626", "Mundo\ Novo\ \-\ BA",
"55313449", "Belo\ Horizonte\ \-\ MG",
"55653228", "Lambari\ D\'Oeste\ \-\ MT",
"55993557", "Nova\ Iorque\ \-\ MA",
"55793436", "Itabaiana\ \-\ SE",
"55773644", "Brotas\ de\ Macaúbas\ \-\ BA",
"55663525", "Carlinda\ \-\ MT",
"55552102", "Uruguaiana\ \-\ RS",
"55163752", "Aramina\ \-\ SP",
"55823554", "Igreja\ Nova\ \-\ AL",
"55193665", "Mococa\ \-\ SP",
"55663603", "Aripuanã\ \-\ MT",
"55473372", "Jaraguá\ do\ Sul\ \-\ SC",
"55353281", "Cristina\ \-\ MG",
"55423523", "União\ da\ Vitória\ \-\ PR",
"55493333", "Nova\ Erechim\ \-\ SC",
"55193401", "Piracicaba\ \-\ SP",
"55153271", "Itapetininga\ \-\ SP",
"55923671", "Manaus\ \-\ AM",
"55473317", "Indaial\ \-\ SC",
"55213113", "Rio\ de\ Janeiro\ \-\ RJ",
"55833314", "São\ José\ da\ Mata\ \-\ PB",
"55113654", "Osasco\ \-\ SP",
"55833380", "Puxinanã\ \-\ PB",
"55883646", "Cariré\ \-\ CE",
"55353571", "Muzambinho\ \-\ MG",
"55484141", "Florianópolis\ \-\ SC",
"55163666", "Santa\ Cruz\ da\ Esperança\ \-\ SP",
"55114463", "Santo\ André\ \-\ SP",
"55163831", "Guará\ \-\ SP",
"55753680", "Rafael\ Jambeiro\ \-\ BA",
"55753614", "Feira\ de\ Santana\ \-\ BA",
"55823221", "Maceió\ \-\ AL",
"55823177", "Maceió\ \-\ AL",
"55833389", "Olivedos\ \-\ PB",
"55514003", "Porto\ Alegre\ \-\ RS",
"55353366", "Alagoa\ \-\ MG",
"55513605", "Torres\ \-\ RS",
"55333622", "Nanuque\ \-\ MG",
"55813419", "Recife\ \-\ PE",
"55643698", "Nova\ Aurora\ \-\ GO",
"55112427", "Atibaia\ \-\ SP",
"55513461", "Esteio\ \-\ RS",
"55273245", "Serra\ \-\ ES",
"55553026", "Santa\ Maria\ \-\ RS",
"55673496", "Ponta\ Porã\ \-\ MS",
"55493232", "Bom\ Jardim\ da\ Serra\ \-\ SC",
"55873792", "Terezinha\ \-\ PE",
"55283521", "Cachoeiro\ de\ Itapemirim\ \-\ ES",
"5521", "Rio\ de\ Janeiro",
"55423459", "Fernandes\ Pinheiro\ \-\ PR",
"55323531", "Ubá\ \-\ MG",
"55112354", "São\ Paulo\ \-\ SP",
"55753296", "Sítio\ do\ Quinto\ \-\ BA",
"55483256", "Anitápolis\ \-\ SC",
"55222759", "Macaé\ \-\ RJ",
"55963084", "Macapá\ \-\ AP",
"55273257", "Ibiraçu\ \-\ ES",
"55643452", "Rio\ Quente\ \-\ GO",
"55653376", "Nobres\ \-\ MT",
"55633612", "Gurupi\ \-\ TO",
"55733245", "Ubatã\ \-\ BA",
"55893546", "Bertolínia\ \-\ PI",
"55643655", "Paranaiguara\ \-\ GO",
"55833256", "Alhandra\ \-\ PB",
"55353413", "Passos\ \-\ MG",
"55513402", "Guaíba\ \-\ RS",
"55623592", "Goiânia\ \-\ GO",
"55193935", "Indaiatuba\ \-\ SP",
"55693311", "Cacoal\ \-\ RO",
"55333425", "Braúnas\ \-\ MG",
"55113365", "São\ Paulo\ \-\ SP",
"55513523", "Parobé\ \-\ RS",
"55133499", "Praia\ Grande\ \-\ SP",
"55854042", "Fortaleza\ \-\ CE",
"55793547", "Arauá\ \-\ SE",
"55222531", "Sumidouro\ \-\ RJ",
"55733257", "Nilo\ Peçanha\ \-\ BA",
"55333344", "Lajinha\ \-\ MG",
"55433151", "Sabáudia\ \-\ PR",
"55383616", "Matias\ Cardoso\ \-\ MG",
"55643647", "Maurilândia\ \-\ GO",
"55913711", "Castanhal\ \-\ PA",
"55443599", "Campo\ Mourão\ \-\ PR",
"55843662", "Natal\ \-\ RN",
"55983397", "Turiaçu\ \-\ MA",
"5561354", "Brasília\ \-\ DF",
"55643649", "Castelândia\ \-\ GO",
"55883578", "Umari\ \-\ CE",
"55983399", "Mirinzal\ \-\ MA",
"55123144", "Cruzeiro\ \-\ SP",
"55212609", "Niterói\ \-\ RJ",
"55193803", "Sumaré\ \-\ SP",
"55242411", "Barra\ do\ Piraí\ \-\ RJ",
"55643640", "Lagoa\ Santa\ \-\ GO",
"55423642", "Turvo\ \-\ PR",
"55193641", "Vargem\ Grande\ do\ Sul\ \-\ SP",
"55813378", "Jaboatão\ dos\ Guararapes\ \-\ PE",
"55733259", "Ibirapitanga\ \-\ BA",
"55793549", "Poço\ Verde\ \-\ SE",
"55163707", "Franca\ \-\ SP",
"55313536", "Florestal\ \-\ MG",
"55143372", "Santa\ Cruz\ do\ Rio\ Pardo\ \-\ SP",
"55813030", "Paulista\ \-\ PE",
"55813675", "Barreiros\ \-\ PE",
"55283552", "Alegre\ \-\ ES",
"5511353", "São\ Paulo\ \-\ SP",
"55743531", "Curaçá\ \-\ BA",
"55323745", "Caiana\ \-\ MG",
"55133342", "Guarujá\ \-\ SP",
"55313064", "Belo\ Horizonte\ \-\ MG",
"55273259", "Santa\ Teresa\ \-\ ES",
"55323275", "Santana\ do\ Deserto\ \-\ MG",
"55633438", "Recursolândia\ \-\ TO",
"55143103", "Bauru\ \-\ SP",
"55543434", "Silva\ Jardim\ \-\ RS",
"55114509", "Santo\ André\ \-\ SP",
"55183653", "Penápolis\ \-\ SP",
"55343411", "Iturama\ \-\ MG",
"55813472", "Recife\ \-\ PE",
"55693474", "Castanheiras\ \-\ RO",
"55423457", "Rebouças\ \-\ PR",
"55433122", "Apucarana\ \-\ PR",
"55273250", "Coqueiral\ \-\ ES",
"55222757", "Macaé\ \-\ RJ",
"55993561", "Governador\ Luiz\ Rocha\ \-\ MA",
"55833513", "João\ Pessoa\ \-\ PB",
"55873811", "Jirau\ \-\ PE",
"55112429", "Itu\ \-\ SP",
"55212133", "Rio\ de\ Janeiro\ \-\ RJ",
"55643563", "Jandaia\ \-\ GO",
"55143478", "Bastos\ \-\ SP",
"55493534", "Ibiam\ \-\ SC",
"55733528", "Jequié\ \-\ BA",
"55133448", "Mongaguá\ \-\ SP",
"55112803", "Carapicuíba\ \-\ SP",
"55112641", "São\ Paulo\ \-\ SP",
"55115721", "Mauá\ \-\ SP",
"55163721", "Franca\ \-\ SP",
"55613331", "Recanto\ das\ Emas\ \-\ DF",
"55193886", "Vinhedo\ \-\ SP",
"55833387", "São\ Sebastião\ de\ Lagoa\ de\ Roça\ \-\ PB",
"55473384", "Rodeio\ \-\ SC",
"55463263", "Palmas\ \-\ PR",
"55513982", "Lajeado\ \-\ RS",
"55733261", "Eunápolis\ \-\ BA",
"55373525", "Moema\ \-\ MG",
"55473319", "Navegantes\ \-\ SC",
"55773691", "Malhada\ \-\ BA",
"55513048", "Osório\ \-\ RS",
"5512362", "Taubaté\ \-\ SP",
"55833634", "Casserengue\ \-\ PB",
"55222105", "Macaé\ \-\ RJ",
"55553237", "São\ Gabriel\ \-\ RS",
"55753334", "Lençóis\ \-\ BA",
"5521388", "Rio\ de\ Janeiro\ \-\ RJ",
"5543332", "Londrina\ \-\ PR",
"55153535", "Nova\ Campina\ \-\ SP",
"55114850", "Itu\ \-\ SP",
"55633233", "Palmas\ \-\ TO",
"5521315", "Rio\ de\ Janeiro\ \-\ RJ",
"55513445", "Presidente\ Lucena\ \-\ RS",
"55273261", "Guarapari\ \-\ ES",
"55313392", "Contagem\ \-\ MG",
"55993559", "Sucupira\ do\ Norte\ \-\ MA",
"55833471", "Malta\ \-\ PB",
"5511505", "São\ Paulo\ \-\ SP",
"55143583", "Balbinos\ \-\ SP",
"55823252", "Joaquim\ Gomes\ \-\ AL",
"55983661", "Codó\ \-\ MA",
"55112886", "São\ Paulo\ \-\ SP",
"55893439", "Marcolândia\ \-\ PI",
"55733202", "Barra\ do\ Rocha\ \-\ BA",
"55343283", "Monte\ Alegre\ de\ Minas\ \-\ MG",
"55143273", "Fernão\ \-\ SP",
"55313447", "Belo\ Horizonte\ \-\ MG",
"55313766", "Minas\ Gerais",
"55513457", "Rio\ Grande\ do\ Sul",
"55413587", "São\ José\ dos\ Pinhais\ \-\ PR",
"55513097", "Novo\ Hamburgo\ \-\ RS",
"55413648", "Bateias\ \-\ PR",
"55373332", "São\ Francisco\ de\ Paula\ \-\ MG",
"55114206", "Jandira\ \-\ SP",
"55183991", "Mirante\ do\ Paranapanema\ \-\ SP",
"55312102", "Belo\ Horizonte\ \-\ MG",
"55964400", "Macapá\ \-\ AP",
"55532125", "Rio\ Grande\ \-\ RS",
"55663415", "Ribeirãozinho\ \-\ MT",
"55114488", "Francisco\ Morato\ \-\ SP",
"55814009", "Recife\ \-\ PE",
"5511450", "São\ Paulo\ \-\ SP",
"55624104", "Goiânia\ \-\ GO",
"55553621", "Santana\ do\ Livramento\ \-\ RS",
"55693416", "Ji\-Paraná\ \-\ RO",
"55115061", "São\ Paulo\ \-\ SP",
"55473221", "Blumenau\ \-\ SC",
"55222009", "Campos\ dos\ Goytacazes\ \-\ RJ",
"55813453", "Recife\ \-\ PE",
"55833545", "São\ Francisco\ \-\ PB",
"55812138", "Recife\ \-\ PE",
"55653387", "Campos\ de\ Júlio\ \-\ MT",
"55513571", "São\ José\ do\ Hortêncio\ \-\ RS",
"55733556", "Lajedo\ do\ Tabocal\ \-\ BA",
"55483821", "Florianópolis\ \-\ SC",
"55222664", "Araruama\ \-\ RJ",
"55513218", "Rio\ Grande\ do\ Sul",
"55713631", "Itaparica\ \-\ BA",
"55813093", "Jaboatão\ dos\ Guararapes\ \-\ PE",
"5519342", "Piracicaba\ \-\ SP",
"55513792", "Costão\ \-\ RS",
"55843285", "Várzea\ \-\ RN",
"55313239", "Belo\ Horizonte\ \-\ MG",
"55863256", "Alto\ Longá\ \-\ PI",
"55313724", "Cristiano\ Otoni\ \-\ MG",
"55313230", "Minas\ Gerais",
"5521260", "São\ Gonçalo\ \-\ RJ",
"55613540", "Brazlândia\ \-\ DF",
"55323052", "Barbacena\ \-\ MG",
"55443687", "Maripá\ \-\ PR",
"55543291", "São\ Marcos\ \-\ RS",
"55213742", "Nova\ Iguaçu\ \-\ RJ",
"55193306", "Sumaré\ \-\ SP",
"55493645", "Guaraciaba\ \-\ SC",
"55893493", "Acauã\ \-\ PI",
"55653513", "Lucas\ do\ Rio\ Verde\ \-\ MT",
"55323355", "Tiradentes\ \-\ MG",
"55332101", "Governador\ Valadares\ \-\ MG",
"55313026", "Sete\ Lagoas\ \-\ MG",
"55493348", "União\ do\ Oeste\ \-\ SC",
"55114176", "São\ Bernardo\ do\ Campo\ \-\ SP",
"55163305", "Araraquara\ \-\ SP",
"55353461", "Bom\ Repouso\ \-\ MG",
"55493657", "Santa\ Terezinha\ do\ Progresso\ \-\ SC",
"55114573", "Cotia\ \-\ SP",
"55383833", "Jaíba\ \-\ MG",
"55673669", "Paranaíba\ \-\ MS",
"5511418", "Carapicuíba\ \-\ SP",
"55323347", "Ibertioga\ \-\ MG",
"55373233", "Pará\ de\ Minas\ \-\ MG",
"55823273", "Coruripe\ \-\ AL",
"55213814", "Rio\ de\ Janeiro\ \-\ RJ",
"55853332", "Redenção\ \-\ CE",
"55982109", "São\ Luís\ \-\ MA",
"55333515", "Água\ Boa\ \-\ MG",
"55733632", "Ilhéus\ \-\ BA",
"55343859", "Patos\ de\ Minas\ \-\ MG",
"55353523", "Alpinópolis\ \-\ MG",
"55193572", "Leme\ \-\ SP",
"55493442", "Concórdia\ \-\ SC",
"55533282", "Pelotas\ \-\ RS",
"55533517", "Pelotas\ \-\ RS",
"55182103", "Araçatuba\ \-\ SP",
"55212673", "Duque\ de\ Caxias\ \-\ RJ",
"55143252", "Pederneiras\ \-\ SP",
"55193879", "Monte\ Mor\ \-\ SP",
"55423235", "Ponta\ Grossa\ \-\ PR",
"55833376", "Barra\ de\ Santa\ Rosa\ \-\ PB",
"55343845", "Iraí\ de\ Minas\ \-\ MG",
"55143554", "Cafelândia\ \-\ SP",
"55753023", "Feira\ de\ Santana\ \-\ BA",
"55193877", "Artur\ Nogueira\ \-\ SP",
"55753676", "São\ Miguel\ das\ Matas\ \-\ BA",
"55553536", "Alegria\ \-\ RS",
"55643588", "Itumbiara\ \-\ GO",
"55433454", "Cruzmaltina\ \-\ PR",
"55833561", "Bernardino\ Batista\ \-\ PB",
"55733312", "Itamaraju\ \-\ BA",
"55193584", "Santa\ Rita\ do\ Passa\ Quatro\ \-\ SP",
"55193812", "Cosmópolis\ \-\ SP",
"55213219", "Rio\ de\ Janeiro\ \-\ RJ",
"55743658", "Canarana\ \-\ BA",
"55323021", "Ubá\ \-\ MG",
"55773456", "Urandi\ \-\ BA",
"55543244", "São\ Francisco\ de\ Paula\ \-\ RS",
"55193519", "Campinas\ \-\ SP",
"55793611", "Simão\ Dias\ \-\ SE",
"55163243", "Monte\ Alto\ \-\ SP",
"55112812", "Guarulhos\ \-\ SP",
"55273312", "São\ Mateus\ \-\ ES",
"55623942", "Goiânia\ \-\ GO",
"55143221", "Marília\ \-\ SP",
"55242463", "Engenheiro\ Paulo\ de\ Frontin\ \-\ RJ",
"55333754", "Cachoeira\ de\ Pajeú\ \-\ MG",
"55663596", "Paranorte\ \-\ MT",
"55623088", "Goiânia\ \-\ GO",
"55613436", "Brasília\ \-\ DF",
"55273015", "Vitória\ \-\ ES",
"55383723", "Inimutaba\ \-\ MG",
"55473353", "Apiúna\ \-\ SC",
"55813732", "Fazenda\ Nova\ \-\ PE",
"55413576", "Curitiba\ \-\ PR",
"55833423", "Patos\ \-\ PB",
"55114813", "Itu\ \-\ SP",
"55513033", "Esteio\ \-\ RS",
"55193744", "Campinas\ \-\ SP",
"55143112", "Botucatu\ \-\ SP",
"55242254", "Comendador\ Levy\ Gasparian\ \-\ RJ",
"55313834", "Itabira\ \-\ MG",
"55433301", "Londrina\ \-\ PR",
"55743664", "Xique\-xique\ \-\ BA",
"55813869", "Santa\ Maria\ da\ Boa\ Vista\ \-\ PE",
"55163342", "Ibitinga\ \-\ SP",
"55273213", "Cariacica\ \-\ ES",
"55383674", "Cabeceira\ Grande\ \-\ MG",
"55114374", "Carapicuíba\ \-\ SP",
"55813562", "Primavera\ \-\ PE",
"55833559", "Bom\ Jesus\ \-\ PB",
"55423916", "Tibagi\ \-\ PR",
"55413699", "Almirante\ Tamandaré\ \-\ PR",
"55343268", "Ituiutaba\ \-\ MG",
"55114031", "Bragança\ Paulista\ \-\ SP",
"55313237", "Belo\ Horizonte\ \-\ MG",
"55923542", "Maués\ \-\ AM",
"55653314", "Cuiabá\ \-\ MT",
"55123843", "Ubatuba\ \-\ SP",
"55213923", "Rio\ de\ Janeiro\ \-\ RJ",
"55123601", "Taubaté\ \-\ SP",
"55843231", "Natal\ \-\ RN",
"55433468", "Rio\ Bom\ \-\ PR",
"55673028", "Campo\ Grande\ \-\ MS",
"55943345", "Jacundá\ \-\ PA",
"55173334", "São\ José\ do\ Rio\ Preto\ \-\ SP",
"55463211", "Francisco\ Beltrão\ \-\ PR",
"55453275", "São\ Clemente\ \-\ PR",
"55693913", "Guajará\-Mirim\ \-\ RO",
"55814007", "Recife\ \-\ PE",
"55654141", "Cuiabá\ \-\ MT",
"55943424", "Redenção\ \-\ PA",
"55123662", "Campos\ do\ Jordão\ \-\ SP",
"55353457", "Heliodora\ \-\ MG",
"55353863", "Santo\ Antônio\ do\ Amparo\ \-\ MG",
"55833228", "Cabedelo\ \-\ PB",
"55993634", "Lago\ do\ Junco\ \-\ MA",
"55953262", "Normandia\ \-\ RR",
"55813501", "Ipojuca\ \-\ PE",
"55933017", "Santarém\ \-\ PA",
"55663438", "Nova\ Xavantina\ \-\ MT",
"55923131", "Manaus\ \-\ AM",
"55353445", "Borda\ da\ Mata\ \-\ MG",
"55484020", "Florianópolis\ \-\ SC",
"55883404", "Russas\ \-\ CE",
"55833552", "São\ José\ de\ Piranhas\ \-\ PB",
"55673441", "Nova\ Andradina\ \-\ MS",
"55743061", "Juazeiro\ \-\ BA",
"55913723", "Marapanim\ \-\ PA",
"55313534", "Igarapé\ \-\ MG",
"55623533", "Goiânia\ \-\ GO",
"55163349", "Trabiju\ \-\ SP",
"55632112", "Araguaína\ \-\ TO",
"55114634", "Poá\ \-\ SP",
"55123146", "Lavrinhas\ \-\ SP",
"55553931", "Santo\ Ângelo\ \-\ RS",
"55123004", "São\ José\ dos\ Campos\ \-\ SP",
"55222773", "Macaé\ \-\ RJ",
"551139", "São\ Paulo\ \-\ SP",
"55223863", "Jaguarembé\ \-\ RJ",
"55513588", "São\ Leopoldo\ \-\ RS",
"55653382", "Campo\ Novo\ do\ Parecis\ \-\ MT",
"55943321", "Marabá\ \-\ PA",
"55823481", "Arapiraca\ \-\ AL",
"55753241", "Santo\ Amaro\ \-\ BA",
"5594", "Pará",
"55914104", "Ananindeua\ \-\ PA",
"55493536", "Salto\ Veloso\ \-\ SC",
"55893591", "Jurema\ \-\ PI",
"55823312", "Maceió\ \-\ AL",
"55153327", "Sorocaba\ \-\ SP",
"55123669", "Campos\ do\ Jordão\ \-\ SP",
"55413971", "Matinhos\ \-\ PR",
"5564309", "Itumbiara\ \-\ GO",
"55153263", "Boituva\ \-\ SP",
"55413047", "Almirante\ Tamandaré\ \-\ PR",
"55713414", "Salvador\ \-\ BA",
"55513748", "Lajeado\ \-\ RS",
"55813643", "Itaquitinga\ \-\ PE",
"55313758", "Minas\ Gerais",
"55453238", "Ibema\ \-\ PR",
"55923663", "Manaus\ \-\ AM",
"55353563", "Bom\ Jesus\ da\ Penha\ \-\ MG",
"55463535", "Verê\ \-\ PR",
"55312107", "Sete\ Lagoas\ \-\ MG",
"55612323", "Brasília\ \-\ DF",
"55193577", "Corumbataí\ \-\ SP",
"55115021", "São\ Paulo\ \-\ SP",
"551", "São\ Paulo",
"55833636", "Frei\ Martinho\ \-\ PB",
"55813551", "Ipojuca\ \-\ PE",
"55473261", "Balneário\ Camboriú\ \-\ SC",
"55923016", "Manaus\ \-\ AM",
"55493447", "Ouro\ Verde\ \-\ SC",
"55513473", "Esteio\ \-\ RS",
"55662103", "Rondonópolis\ \-\ MT",
"55753336", "Wagner\ \-\ BA",
"55353733", "Ibitiúra\ de\ Minas\ \-\ MG",
"55423511", "Santo\ Antônio\ do\ Iratim\ \-\ PR",
"55473386", "Rio\ dos\ Cedros\ \-\ SC",
"55423278", "Imbaú\ \-\ PR",
"55853337", "Aracoiaba\ \-\ CE",
"55193884", "Paulínia\ \-\ SP",
"55493455", "Alto\ Bela\ Vista\ \-\ SC",
"55193512", "Campinas\ \-\ SP",
"55213212", "Rio\ de\ Janeiro\ \-\ RJ",
"55193819", "Hortolândia\ \-\ SP",
"55793014", "Nossa\ Senhora\ do\ Socorro\ \-\ SE",
"55613623", "Luziânia\ \-\ GO",
"55313764", "Conselheiro\ Lafaiete\ \-\ MG",
"55813739", "Altinho\ \-\ PE",
"55112884", "Mogi\ das\ Cruzes\ \-\ SP",
"55493652", "Palma\ Sola\ \-\ SC",
"5519346", "Americana\ \-\ SP",
"55112819", "Mogi\ das\ Cruzes\ \-\ SP",
"55693222", "Porto\ Velho\ \-\ RO",
"55773483", "Santa\ Maria\ da\ Vitória\ \-\ BA",
"55613505", "Luziânia\ \-\ GO",
"55323342", "Santa\ Rita\ de\ Ibitipoca\ \-\ MG",
"55443011", "Maringá\ \-\ PR",
"55653283", "Comodoro\ \-\ MT",
"55114513", "Mauá\ \-\ SP",
"55213747", "Rio\ de\ Janeiro\ \-\ RJ",
"55222624", "Iguaba\ Grande\ \-\ RJ",
"55343821", "Patos\ de\ Minas\ \-\ MG",
"55433351", "Londrina\ \-\ PR",
"55963242", "Macapá\ \-\ AP",
"55883691", "Crateús\ \-\ CE",
"55823556", "Feliz\ Deserto\ \-\ AL",
"55913011", "Paragominas\ \-\ PA",
"55273372", "Linhares\ \-\ ES",
"55773646", "Ipupiara\ \-\ BA",
"55433428", "Marilândia\ do\ Sul\ \-\ PR",
"55115934", "São\ Paulo\ \-\ SP",
"55383533", "Couto\ de\ Magalhães\ de\ Minas\ \-\ MG",
"55114873", "São\ Paulo\ \-\ SP",
"55813522", "Cabo\ de\ Santo\ Agostinho\ \-\ PE",
"55443674", "Indianópolis\ \-\ PR",
"55853475", "Caucaia\ \-\ CE",
"55343228", "Uberlândia\ \-\ MG",
"55483268", "Leoberto\ Leal\ \-\ SC",
"55623334", "Petrolina\ de\ Goiás\ \-\ GO",
"55273317", "Vitória\ \-\ ES",
"55413113", "Campo\ Largo\ \-\ PR",
"55693524", "Governador\ Jorge\ Teixeira\ \-\ RO",
"55313333", "Minas\ Gerais",
"55743624", "Jacobina\ \-\ BA",
"55913088", "Belém\ \-\ PA",
"55813737", "Bonito\ \-\ PE",
"55484062", "Florianópolis\ \-\ SC",
"55623998", "Goiânia\ \-\ GO",
"55333728", "Bandeira\ \-\ MG",
"55163664", "Brodowski\ \-\ SP",
"55193817", "Amparo\ \-\ SP",
"55353409", "Lavras\ \-\ MG",
"55883644", "Santana\ do\ Acaraú\ \-\ CE",
"55484001", "Florianópolis\ \-\ SC",
"55833316", "Riachão\ do\ Bacamarte\ \-\ PB",
"55733639", "Ilhéus\ \-\ BA",
"55223308", "São\ Pedro\ da\ Aldeia\ \-\ RJ",
"55353364", "Pouso\ Alto\ \-\ MG",
"55115695", "São\ Paulo\ \-\ SP",
"55353823", "Itumirim\ \-\ MG",
"55833268", "João\ Pessoa\ \-\ PB",
"55673465", "Jateí\ \-\ MS",
"55143303", "Marília\ \-\ SP",
"55853339", "Palmácia\ \-\ CE",
"55443431", "Paraíso\ do\ Norte\ \-\ PR",
"55213589", "Mesquita\ \-\ RJ",
"55753616", "Feira\ de\ Santana\ \-\ BA",
"5551364", "Rio\ Grande\ do\ Sul",
"55643571", "Palmeiras\ de\ Goiás\ \-\ GO",
"55114256", "Suzano\ \-\ SP",
"55913485", "Tracuateua\ \-\ PA",
"55242228", "Secretário\ \-\ RJ",
"55493621", "São\ Miguel\ do\ Oeste\ \-\ SC",
"55193872", "Cosmópolis\ \-\ SP",
"55753265", "Santaluz\ \-\ BA",
"55213279", "Rio\ de\ Janeiro\ \-\ RJ",
"55193579", "Campinas\ \-\ SP",
"55333231", "Itanhomi\ \-\ MG",
"55173833", "Estrela\ D\'Oeste\ \-\ SP",
"55644012", "Itumbiara\ \-\ GO",
"55883428", "Iracema\ \-\ CE",
"55943309", "Cumaru\ do\ Norte\ \-\ PA",
"55693251", "Vista\ Alegre\ do\ Abunã\ \-\ RO",
"55493449", "Ipuaçu\ \-\ SC",
"55483254", "Garopaba\ \-\ SC",
"55753294", "Água\ Fria\ \-\ BA",
"55163398", "Fazenda\ Babilônia\ \-\ SP",
"55312109", "Ipatinga\ \-\ MG",
"55943352", "Parauapebas\ \-\ PA",
"55173011", "São\ José\ do\ Rio\ Preto\ \-\ SP",
"55433223", "Cambé\ \-\ PR",
"55823632", "Olivença\ \-\ AL",
"55433367", "Londrina\ \-\ PR",
"55633653", "Arraias\ \-\ TO",
"55143202", "Bauru\ \-\ SP",
"55353698", "Alfenas\ \-\ MG",
"55733273", "Pau\ Brasil\ \-\ BA",
"55323061", "Juiz\ de\ Fora\ \-\ MG",
"55343423", "Frutal\ \-\ MG",
"55483463", "Forquilhinha\ \-\ SC",
"55192532", "Piracicaba\ \-\ SP",
"55833521", "Sousa\ \-\ PB",
"55463581", "Dois\ Vizinhos\ \-\ PR",
"55213633", "Guapimirim\ \-\ RJ",
"55813486", "Recife\ \-\ PE",
"55273743", "Colatina\ \-\ ES",
"55353452", "Careaçu\ \-\ MG",
"55854102", "Fortaleza\ \-\ CE",
"55273273", "Sooretama\ \-\ ES",
"55143386", "Taguaí\ \-\ SP",
"55492049", "Chapecó\ \-\ SC",
"55833463", "Taperoá\ \-\ PB",
"5541", "Paraná",
"55483521", "Araranguá\ \-\ SC",
"55383614", "Montalvânia\ \-\ MG",
"55353655", "Sapucaí\-Mirim\ \-\ MG",
"55683342", "Rodrigues\ Alves\ \-\ AC",
"55143261", "Agudos\ \-\ SP",
"55643413", "Morrinhos\ \-\ GO",
"55163934", "Ribeirão\ Preto\ \-\ SP",
"55983673", "Brejo\ de\ Areia\ \-\ MA",
"55442031", "Umuarama\ \-\ PR",
"55163347", "Cambaratiba\ \-\ SP",
"55653374", "Cangas\ \-\ MT",
"55173485", "Valentim\ Gentil\ \-\ SP",
"55633393", "Chapada\ da\ Natividade\ \-\ TO",
"55833254", "Cruz\ do\ Espírito\ Santo\ \-\ PB",
"55893544", "Uruçuí\ \-\ PI",
"55843538", "Fernando\ Pedroza\ \-\ RN",
"55313232", "Minas\ Gerais",
"55773454", "Caetité\ \-\ BA",
"55473312", "Timbó\ \-\ SC",
"55922123", "Manaus\ \-\ AM",
"55193586", "Itirapina\ \-\ SP",
"55163275", "Taiaçu\ \-\ SP",
"55413157", "Quatro\ Barras\ \-\ PR",
"55343256", "Uberlândia\ \-\ MG",
"55513421", "Gravataí\ \-\ RS",
"55153288", "Cerquilho\ \-\ SP",
"55143556", "Cafelândia\ \-\ SP",
"55183603", "Luiziânia\ \-\ SP",
"55473377", "Luiz\ Alves\ \-\ SC",
"55183841", "Junqueirópolis\ \-\ SP",
"55833374", "Nova\ Floresta\ \-\ PB",
"55843425", "São\ João\ do\ Sabugi\ \-\ RN",
"55114852", "Santo\ André\ \-\ SP",
"55433456", "Apucarana\ \-\ PR",
"55653254", "Indiavaí\ \-\ MT",
"55553534", "Doutor\ Maurício\ Cardoso\ \-\ RS",
"55823528", "Lagoa\ da\ Canoa\ \-\ AL",
"55513649", "Montenegro\ \-\ RS",
"55753674", "Cruz\ das\ Almas\ \-\ BA",
"55193746", "Campinas\ \-\ SP",
"55115105", "São\ Paulo\ \-\ SP",
"55113444", "São\ Paulo\ \-\ SP",
"55313390", "Minas\ Gerais",
"55993552", "Colinas\ \-\ MA",
"55753431", "Inhambupe\ \-\ BA",
"55473418", "Joinville\ \-\ SC",
"55143883", "Bofete\ \-\ SP",
"55313399", "Minas\ Gerais",
"55513563", "Ivoti\ \-\ RS",
"55483031", "Florianópolis\ \-\ SC",
"5598323", "São\ Luís\ \-\ MA",
"55162108", "Araraquara\ \-\ SP",
"55352105", "Varginha\ \-\ MG",
"55223811", "Itaperuna\ \-\ RJ",
"55114731", "Suzano\ \-\ SP",
"55733209", "Posto\ da\ Mata\ \-\ BA",
"55893432", "Cajazeiras\ do\ Piauí\ \-\ PI",
"55673231", "Corumbá\ \-\ MS",
"55613434", "Recanto\ das\ Emas\ \-\ DF",
"5511257", "São\ Paulo\ \-\ SP",
"55663594", "Santa\ Cruz\ do\ Xingu\ \-\ MT",
"55193853", "Pedreira\ \-\ SP",
"55212659", "Magé\ \-\ RJ",
"55373541", "Abaeté\ \-\ MG",
"55623597", "Goiânia\ \-\ GO",
"55423649", "Guará\ \-\ PR",
"55513407", "Porto\ Alegre\ \-\ RS",
"55793542", "Cristinápolis\ \-\ SE",
"55614101", "Brasília\ \-\ DF",
"55654062", "Cuiabá\ \-\ MT",
"55653268", "Vale\ de\ São\ Domingos\ \-\ MT",
"55112625", "São\ Paulo\ \-\ SP",
"55513733", "Encruzilhada\ do\ Sul\ \-\ RS",
"55813638", "Bom\ Jardim\ \-\ PE",
"55663565", "Aripuanã\ \-\ MT",
"55453243", "Nova\ Aurora\ \-\ PR",
"5551379", "Rio\ Grande\ do\ Sul",
"55983392", "Bacuri\ \-\ MA",
"55983455", "Matões\ do\ Norte\ \-\ MA",
"55193503", "Hortolândia\ \-\ SP",
"55423421", "Irati\ \-\ PR",
"55643642", "Turvelândia\ \-\ GO",
"55533503", "Bagé\ \-\ RS",
"55813032", "Recife\ \-\ PE",
"55283559", "Dores\ do\ Rio\ Preto\ \-\ ES",
"55773468", "Mirante\ \-\ BA",
"5521310", "Rio\ de\ Janeiro\ \-\ RJ",
"55143632", "Dois\ Córregos\ \-\ SP",
"55353473", "Santa\ Rita\ do\ Sapucaí\ \-\ MG",
"55313836", "Itambé\ do\ Mato\ Dentro\ \-\ MG",
"55883535", "Assaré\ \-\ CE",
"55543331", "Carazinho\ \-\ RS",
"55823202", "Maceió\ \-\ AL",
"55913771", "Mosqueiro\ \-\ PA",
"55212008", "Teresópolis\ \-\ RJ",
"55143379", "Ribeirão\ do\ Sul\ \-\ SP",
"55313661", "Pedro\ Leopoldo\ \-\ MG",
"55383676", "Unaí\ \-\ MG",
"55864020", "Teresina\ \-\ PI",
"55553613", "Mato\ Queimado\ \-\ RS",
"55823261", "Rio\ Largo\ \-\ AL",
"55993636", "Poção\ de\ Pedras\ \-\ MA",
"55353326", "Minduri\ \-\ MG",
"55213699", "Queimados\ \-\ RJ",
"55214139", "Maricá\ \-\ RJ",
"55323721", "Muriaé\ \-\ MG",
"55433535", "Jaguariaíva\ \-\ PR",
"55193328", "Indaiatuba\ \-\ SP",
"55633475", "Esperantina\ \-\ TO",
"55623548", "Aparecida\ de\ Goiânia\ \-\ GO",
"55333627", "Machacalis\ \-\ MG",
"55433878", "Londrina\ \-\ PR",
"5582337", "Maceió\ \-\ AL",
"55193625", "São\ João\ da\ Boa\ Vista\ \-\ SP",
"55943426", "Xinguara\ \-\ PA",
"55654001", "Cuiabá\ \-\ MT",
"55493237", "Capão\ Alto\ \-\ SC",
"55112503", "São\ Paulo\ \-\ SP",
"55983652", "Bom\ Jesus\ das\ Selvas\ \-\ MA",
"55624106", "Trindade\ \-\ GO",
"55553333", "Ijuí\ \-\ RS",
"55143481", "Marília\ \-\ SP",
"55473901", "Blumenau\ \-\ SC",
"5571348", "Salvador\ \-\ BA",
"55173265", "José\ Bonifácio\ \-\ SP",
"55813412", "Recife\ \-\ PE",
"55114204", "Araçariguama\ \-\ SP",
"55733221", "Ilhéus\ \-\ BA",
"55833283", "Sapé\ \-\ PB",
"55713508", "Lauro\ de\ Freitas\ \-\ BA",
"55493199", "Chapecó\ \-\ SC",
"55214137", "Nilópolis\ \-\ RJ",
"55873871", "Salgueiro\ \-\ PE",
"55643450", "Marzagão\ \-\ GO",
"55163761", "Batatais\ \-\ SP",
"55133398", "Guarujá\ \-\ SP",
"55813477", "Recife\ \-\ PE",
"55463223", "Pato\ Branco\ \-\ PR",
"55193451", "Limeira\ \-\ SP",
"55143377", "São\ Pedro\ do\ Turvo\ \-\ SP",
"55883518", "Solonópole\ \-\ CE",
"55863254", "Assunção\ do\ Piauí\ \-\ PI",
"55473556", "Santa\ Terezinha\ \-\ SC",
"55983621", "Bacabal\ \-\ MA",
"55283557", "Apiacá\ \-\ ES",
"55423655", "Altamira\ do\ Paraná\ \-\ PR",
"55483283", "Palhoça\ \-\ SC",
"55313726", "Santana\ dos\ Montes\ \-\ MG",
"55133347", "Guarujá\ \-\ SP",
"55242471", "Vassouras\ \-\ RJ",
"55543385", "Tapera\ \-\ RS",
"55513400", "Rio\ Grande\ do\ Sul",
"55273177", "Colatina\ \-\ ES",
"55513409", "Miraguaia\ \-\ RS",
"55883581", "Iguatu\ \-\ CE",
"55492102", "Lages\ \-\ SC",
"55283545", "Iúna\ \-\ ES",
"55543611", "André\ da\ Rocha\ \-\ RS",
"55713267", "Salvador\ \-\ BA",
"55733554", "Aurelino\ Leal\ \-\ BA",
"55222666", "São\ Vicente\ de\ Paula\ \-\ RJ",
"55453305", "Cascavel\ \-\ PR",
"55153646", "Buri\ \-\ SP",
"55973491", "Carauari\ \-\ AM",
"55733207", "Nova\ Canaã\ \-\ BA",
"55843391", "Martins\ \-\ RN",
"55483085", "Florianópolis\ \-\ SC",
"55173848", "Gastão\ Vidigal\ \-\ SP",
"55313442", "Minas\ Gerais",
"55413582", "Curitiba\ \-\ PR",
"55513452", "Sapucaia\ do\ Sul\ \-\ RS",
"5512393", "São\ José\ dos\ Campos\ \-\ SP",
"55114174", "São\ Bernardo\ do\ Campo\ \-\ SP",
"55163142", "São\ José\ da\ Bela\ Vista\ \-\ SP",
"55913265", "Ananindeua\ \-\ PA",
"55114821", "Rio\ Grande\ da\ Serra\ \-\ SP",
"55343513", "Araguari\ \-\ MG",
"55533304", "Santa\ Maria\ \-\ RS",
"55643461", "Pires\ do\ Rio\ \-\ GO",
"55513698", "Capela\ de\ Santana\ \-\ RS",
"55833488", "Santa\ Inês\ \-\ PB",
"55193304", "Campinas\ \-\ SP",
"55313397", "Contagem\ \-\ MG",
"55212645", "Itaboraí\ \-\ RJ",
"55673285", "Jaraguari\ \-\ MS",
"55933544", "Oriximiná\ \-\ PA",
"55114785", "Embu\ das\ Artes\ \-\ SP",
"55823257", "Campestre\ \-\ AL",
"55163759", "Franca\ \-\ SP",
"55473632", "Campo\ Alegre\ \-\ SC",
"55112304", "Guarulhos\ \-\ SP",
"55553232", "São\ Gabriel\ \-\ RS",
"55663541", "Colíder\ \-\ MT",
"55513647", "Vendinha\ \-\ RS",
"55353799", "Caldas\ \-\ MG",
"55473379", "Massaranduba\ \-\ SC",
"55122127", "Jacareí\ \-\ SP",
"55213816", "Rio\ de\ Janeiro\ \-\ RJ",
"55483411", "Criciúma\ \-\ SC",
"55313645", "Vespasiano\ \-\ MG",
"55243334", "Rio\ Claro\ \-\ RJ",
"55513655", "General\ Câmara\ \-\ RS",
"55433162", "Apucarana\ \-\ PR",
"55993521", "Caxias\ \-\ MA",
"55463025", "Pato\ Branco\ \-\ PR",
"55833382", "Juazeirinho\ \-\ PB",
"55212397", "Duque\ de\ Caxias\ \-\ RJ",
"55413150", "Fazenda\ Rio\ Grande\ \-\ PR",
"55753682", "Gavião\ \-\ BA",
"55753011", "Feira\ de\ Santana\ \-\ BA",
"55543441", "Veranópolis\ \-\ RS",
"55913722", "Curuçá\ \-\ PA",
"55883524", "Aiuaba\ \-\ CE",
"55153416", "Votorantim\ \-\ SP",
"55983337", "Alcântara\ \-\ MA",
"55833553", "Carrapateira\ \-\ PB",
"55213481", "Rio\ de\ Janeiro\ \-\ RJ",
"55813445", "Recife\ \-\ PE",
"55693025", "Porto\ Velho\ \-\ RO",
"5551352", "Rio\ Grande\ do\ Sul",
"55693322", "Vilhena\ \-\ RO",
"55623532", "Senador\ Canedo\ \-\ GO",
"55813863", "Petrolina\ \-\ PE",
"55443125", "Marialva\ \-\ PR",
"55414064", "Paranaguá\ \-\ PR",
"55222772", "Macaé\ \-\ RJ",
"55223862", "Portela\ \-\ RJ",
"55663026", "Rondonópolis\ \-\ MT",
"55653383", "Sapezal\ \-\ MT",
"55433251", "Cambé\ \-\ PR",
"55493541", "Campos\ Novos\ \-\ SC",
"55633449", "Tupiratins\ \-\ TO",
"55813457", "Paulista\ \-\ PE",
"55114168", "Barueri\ \-\ SP",
"55873851", "Petrolândia\ \-\ PE",
"55643479", "Panamá\ \-\ GO",
"55633440", "Fortaleza\ do\ Tabocão\ \-\ TO",
"55163996", "Ribeirão\ Preto\ \-\ SP",
"55123849", "Ubatuba\ \-\ SP",
"55273145", "Vitória\ \-\ ES",
"55123131", "São\ José\ dos\ Campos\ \-\ SP",
"55423675", "Copel\ \-\ PR",
"55473361", "Balneário\ Camboriú\ \-\ SC",
"55733284", "Canavieiras\ \-\ BA",
"55863274", "Brasileira\ \-\ PI",
"55753236", "Santa\ Bárbara\ \-\ BA",
"55143357", "Óleo\ \-\ SP",
"55693428", "Nova\ Londrina\ \-\ RO",
"55153262", "Porto\ Feliz\ \-\ SP",
"55643954", "Itumbiara\ \-\ GO",
"55353562", "Nova\ Resende\ \-\ MG",
"55133375", "Cubatão\ \-\ SP",
"55813642", "Condado\ \-\ PE",
"55193387", "Campinas\ \-\ SP",
"55333611", "Águas\ Formosas\ \-\ MG",
"55433524", "Cornélio\ Procópio\ \-\ PR",
"55333082", "Governador\ Valadares\ \-\ MG",
"55753593", "Heliópolis\ \-\ BA",
"55973334", "Canutama\ \-\ AM",
"55843434", "Santana\ do\ Matos\ \-\ RN",
"55423904", "Telêmaco\ Borba\ \-\ PR",
"55893448", "Bocaina\ \-\ PI",
"5511501", "São\ Paulo\ \-\ SP",
"55513472", "Canoas\ \-\ RS",
"55553525", "Humaitá\ \-\ RS",
"55153363", "Boituva\ \-\ SP",
"55483641", "Tijucas\ \-\ SC",
"55343304", "Uberlândia\ \-\ MG",
"55993584", "Lajeado\ Novo\ \-\ MA",
"55673547", "Debrasa\ \-\ MS",
"55823277", "Anadia\ \-\ AL",
"55193513", "Limeira\ \-\ SP",
"55773311", "Brumado\ \-\ BA",
"55353732", "Ipuiúna\ \-\ MG",
"55353527", "Bom\ Jesus\ dos\ Campos\ \-\ MG",
"55553290", "Santa\ Maria\ \-\ RS",
"55433260", "Guaraci\ \-\ PR",
"55213213", "Rio\ de\ Janeiro\ \-\ RJ",
"55873869", "Santa\ Maria\ da\ Boa\ Vista\ \-\ PE",
"55613622", "Luziânia\ \-\ GO",
"55473359", "Botuverá\ \-\ SC",
"55383729", "Curvelo\ \-\ MG",
"55114577", "Mauá\ \-\ SP",
"55493653", "Anchieta\ \-\ SC",
"55323343", "Senhora\ dos\ Remédios\ \-\ MG",
"55913767", "São\ Caetano\ de\ Odivelas\ \-\ PA",
"55913446", "São\ Miguel\ do\ Guamá\ \-\ PA",
"55843087", "Natal\ \-\ RN",
"55383234", "São\ João\ da\ Ponte\ \-\ MG",
"55473350", "Brusque\ \-\ SC",
"55833641", "Riacho\ de\ Santo\ Antônio\ \-\ PB",
"55893497", "Betânia\ do\ Piauí\ \-\ PI",
"55434004", "Londrina\ \-\ PR",
"55443683", "Doutor\ Oliveira\ Castro\ \-\ PR",
"55513675", "Cerro\ Grande\ do\ Sul\ \-\ RS",
"55353851", "Boa\ Esperança\ \-\ MG",
"55513039", "Sapiranga\ \-\ RS",
"55114819", "Franco\ da\ Rocha\ \-\ SP",
"55753341", "João\ Amaro\ \-\ BA",
"55833429", "São\ Bentinho\ \-\ PB",
"55963243", "Macapá\ \-\ AP",
"55623396", "Itaguari\ \-\ GO",
"55273373", "Linhares\ \-\ ES",
"55114817", "Jundiaí\ \-\ SP",
"55513037", "São\ Leopoldo\ \-\ RS",
"55223829", "Laje\ do\ Muriaé\ \-\ RJ",
"55153558", "Apiaí\ \-\ SP",
"55143286", "Lucianópolis\ \-\ SP",
"55833427", "Catingueira\ \-\ PB",
"55473424", "Pirabeiraba\ \-\ SC",
"55893499", "Bela\ Vista\ do\ Piauí\ \-\ PI",
"55273161", "Guarapari\ \-\ ES",
"55533256", "Bojuru\ \-\ RS",
"55773474", "Feira\ da\ Mata\ \-\ BA",
"55143408", "Marília\ \-\ SP",
"55114280", "Cotia\ \-\ SP",
"55333246", "Mendes\ Pimentel\ \-\ MG",
"55713271", "Salvador\ \-\ BA",
"55683242", "Rio\ Branco\ \-\ AC",
"55372102", "Divinópolis\ \-\ MG",
"55143361", "Botucatu\ \-\ SP",
"55753654", "Brejões\ \-\ BA",
"55383532", "Diamantina\ \-\ MG",
"55813523", "Vitória\ de\ Santo\ Antão\ \-\ PE",
"55433476", "Cândido\ de\ Abreu\ \-\ PR",
"55413112", "Curitiba\ \-\ PR",
"55443446", "Paranavaí\ \-\ PR",
"55833354", "Serra\ Branca\ \-\ PB",
"55473357", "Ibirama\ \-\ SC",
"55383727", "Monjolos\ \-\ MG",
"55313332", "Minas\ Gerais",
"55353529", "Passos\ \-\ MG",
"55243325", "Barra\ Mansa\ \-\ RJ",
"55343853", "Tiros\ \-\ MG",
"55483354", "Garopaba\ \-\ SC",
"55543601", "Passo\ Fundo\ \-\ RS",
"55823270", "Maribondo\ \-\ AL",
"55143302", "Ourinhos\ \-\ SP",
"55823279", "Boca\ da\ Mata\ \-\ AL",
"55863383", "Esperantina\ \-\ PI",
"55433267", "São\ Jerônimo\ da\ Serra\ \-\ PR",
"55513484", "Gravataí\ \-\ RS",
"55413554", "Quatro\ Barras\ \-\ PR",
"55353822", "Lavras\ \-\ MG",
"55993572", "Buriti\ Bravo\ \-\ MA",
"55193873", "Sumaré\ \-\ SP",
"5511255", "São\ Paulo\ \-\ SP",
"55313438", "Minas\ Gerais",
"55613391", "Brazlândia\ \-\ DF",
"55353295", "Machado\ \-\ MG",
"55212670", "Japeri\ \-\ RJ",
"55173832", "General\ Salgado\ \-\ SP",
"55983475", "Mata\ Roma\ \-\ MA",
"55653046", "Cuiabá\ \-\ MT",
"55643615", "Quirinópolis\ \-\ GO",
"55813974", "Recife\ \-\ PE",
"55353867", "Ribeirão\ Vermelho\ \-\ MG",
"55943353", "Vila\ Cruzeiro\ do\ Sul\ \-\ PA",
"55733272", "Ibicuí\ \-\ BA",
"55123185", "Lorena\ \-\ SP",
"55353264", "Elói\ Mendes\ \-\ MG",
"55833368", "Areial\ \-\ PB",
"55873822", "Arcoverde\ \-\ PE",
"55613669", "Valparaíso\ de\ Goiás\ \-\ GO",
"55143203", "Bauru\ \-\ SP",
"55913606", "Bagre\ \-\ PA",
"55863282", "Água\ Branca\ \-\ PI",
"55913751", "Abaetetuba\ \-\ PA",
"55483462", "Criciúma\ \-\ SC",
"55543054", "Caxias\ do\ Sul\ \-\ RS",
"55192533", "Piracicaba\ \-\ SP",
"55213632", "Magé\ \-\ RJ",
"55753062", "Feira\ de\ Santana\ \-\ BA",
"55333331", "Manhuaçu\ \-\ MG",
"55353453", "São\ Sebastião\ da\ Bela\ Vista\ \-\ MG",
"55273742", "São\ Domingos\ do\ Norte\ \-\ ES",
"55493735", "Fazenda\ Zandavalli\ \-\ SC",
"55814003", "Recife\ \-\ PE",
"55813099", "Olinda\ \-\ PE",
"55114696", "Salesópolis\ \-\ SP",
"55273272", "Guarapari\ \-\ ES",
"55534141", "Pelotas\ \-\ RS",
"55673016", "Dourados\ \-\ MS",
"55883111", "Sobral\ \-\ CE",
"55633447", "São\ Miguel\ do\ Tocantins\ \-\ TO",
"55213806", "Rio\ de\ Janeiro\ \-\ RJ",
"55833462", "São\ Mamede\ \-\ PB",
"55813459", "Aldeia\ \-\ PE",
"55343328", "Campo\ Florido\ \-\ MG",
"55983672", "Bom\ Jardim\ \-\ MA",
"55323003", "Juiz\ de\ Fora\ \-\ MG",
"55683343", "Mâncio\ Lima\ \-\ AC",
"5582335", "Maceió\ \-\ AL",
"55643412", "Itumbiara\ \-\ GO",
"55242106", "Barra\ Mansa\ \-\ RJ",
"55613004", "Brasília\ \-\ DF",
"55313233", "Minas\ Gerais",
"55515", "Rio\ Grande\ do\ Sul",
"5531329", "Minas\ Gerais",
"55633455", "Nazaré\ \-\ TO",
"55443537", "Engenheiro\ Beltrão\ \-\ PR",
"55483216", "Florianópolis\ \-\ SC",
"55213528", "Rio\ de\ Janeiro\ \-\ RJ",
"55353226", "Luminárias\ \-\ MG",
"55514007", "Porto\ Alegre\ \-\ RS",
"55123014", "Jacareí\ \-\ SP",
"55673246", "Terenos\ \-\ MS",
"5515322", "Sorocaba\ \-\ SP",
"5592362", "Manaus\ \-\ AM",
"55242280", "Petrópolis\ \-\ RJ",
"55323338", "Madre\ de\ Deus\ de\ Minas\ \-\ MG",
"55963198", "Macapá\ \-\ AP",
"55773262", "Itapetinga\ \-\ BA",
"5551341", "Rio\ Grande\ do\ Sul",
"55823286", "Murici\ \-\ AL",
"55733692", "Camacan\ \-\ BA",
"55753446", "Sátiro\ Dias\ \-\ BA",
"55273047", "Linhares\ \-\ ES",
"55183602", "Gabriel\ Monteiro\ \-\ SP",
"55153526", "Itapeva\ \-\ SP",
"55443654", "Brasilândia\ do\ Sul\ \-\ PR",
"55114853", "Suzano\ \-\ SP",
"55493337", "Jardinópolis\ \-\ SC",
"55883414", "Quixadá\ \-\ CE",
"55143589", "Reginópolis\ \-\ SP",
"55213303", "Duque\ de\ Caxias\ \-\ RJ",
"55743681", "Ourolândia\ \-\ BA",
"5531367", "Sabará\ \-\ MG",
"5511368", "Osasco\ \-\ SP",
"55993553", "Sucupira\ do\ Riachão\ \-\ MA",
"55713369", "Lauro\ de\ Freitas\ \-\ BA",
"55513562", "Portão\ \-\ RS",
"55693581", "Machadinho\ D\'Oeste\ \-\ RO",
"55143882", "Botucatu\ \-\ SP",
"55313686", "Confins\ \-\ MG",
"55773201", "Vitória\ da\ Conquista\ \-\ BA",
"5522382", "Itaperuna\ \-\ RJ",
"55793651", "Salgado\ \-\ SE",
"55193852", "Pedreira\ \-\ SP",
"55733047", "Jequié\ \-\ BA",
"55543231", "Vacaria\ \-\ RS",
"55823302", "Maceió\ \-\ AL",
"55143279", "Tibiriçá\ \-\ SP",
"55112228", "Santo\ André\ \-\ SP",
"55343817", "Coromandel\ \-\ MG",
"55893433", "Monsenhor\ Hipólito\ \-\ PI",
"55773416", "Contendas\ do\ Sincorá\ \-\ BA",
"55483877", "Florianópolis\ \-\ SC",
"55173341", "Colina\ \-\ SP",
"55793543", "Indiaroba\ \-\ SE",
"55193809", "Hortolândia\ \-\ SP",
"55213202", "Rio\ de\ Janeiro\ \-\ RJ",
"55413637", "Bugre\ \-\ PR",
"55453242", "Corbélia\ \-\ PR",
"55653694", "Várzea\ Grande\ \-\ MT",
"55983393", "Luís\ Domingues\ \-\ MA",
"55193502", "Rio\ Claro\ \-\ SP",
"55633026", "Palmas\ \-\ TO",
"55643643", "Porteirão\ \-\ GO",
"55483274", "Angelina\ \-\ SC",
"55513732", "Rio\ Grande\ do\ Sul",
"55443668", "Serra\ dos\ Dourados\ \-\ PR",
"55993641", "Coroatá\ \-\ MA",
"55353472", "Cachoeira\ de\ Minas\ \-\ MG",
"55313525", "Minas\ Gerais",
"55113599", "Osasco\ \-\ SP",
"55424007", "Ponta\ Grossa\ \-\ PR",
"55813033", "Recife\ \-\ PE",
"55443062", "Paranavaí\ \-\ PR",
"55313130", "Matozinhos\ \-\ MG",
"55643983", "Itumbiara\ \-\ GO",
"55823203", "Ibateguara\ \-\ AL",
"55413384", "São\ José\ dos\ Pinhais\ \-\ PR",
"55473212", "Brusque\ \-\ SC",
"55923575", "Itapiranga\ \-\ AM",
"55463524", "Francisco\ Beltrão\ \-\ PR",
"55313841", "Coronel\ Fabriciano\ \-\ MG",
"55553612", "Dilermando\ de\ Aguiar\ \-\ RS",
"55153311", "Sorocaba\ \-\ SP",
"55114044", "Diadema\ \-\ SP",
"55183659", "Bilac\ \-\ SP",
"55853133", "Fortaleza\ \-\ CE",
"55543346", "Ciríaco\ \-\ RS",
"55343356", "Nova\ Ponte\ \-\ MG",
"55273253", "Serra\ \-\ ES",
"55153388", "Sorocaba\ \-\ SP",
"55193561", "Pirassununga\ \-\ SP",
"55112809", "Guarulhos\ \-\ SP",
"55643560", "São\ João\ da\ Paraúna\ \-\ GO",
"55423562", "Paula\ Freitas\ \-\ PR",
"55833274", "Araçagi\ \-\ PB",
"55843244", "Baía\ Formosa\ \-\ RN",
"55983653", "Santa\ Inês\ \-\ MA",
"55114978", "Santo\ André\ \-\ SP",
"55473270", "Jaraguá\ do\ Sul\ \-\ SC",
"55663498", "Primavera\ do\ Leste\ \-\ MT",
"55313248", "Belo\ Horizonte\ \-\ MG",
"55183645", "Coroados\ \-\ SP",
"55643567", "Itumbiara\ \-\ GO",
"55483306", "Florianópolis\ \-\ SC",
"55553332", "Ijuí\ \-\ RS",
"55773229", "Brumado\ \-\ BA",
"55163010", "Araraquara\ \-\ SP",
"55713644", "Camaçari\ \-\ BA",
"55813413", "Recife\ \-\ PE",
"55112807", "Embu\ das\ Artes\ \-\ SP",
"55183657", "Alto\ Alegre\ \-\ SP",
"55833282", "Pilar\ \-\ PB",
"55863216", "Teresina\ \-\ PI",
"55843291", "Santa\ Cruz\ \-\ RN",
"55943319", "Santa\ Maria\ das\ Barreiras\ \-\ PA",
"55443236", "Floresta\ \-\ PR",
"55823424", "Major\ Isidoro\ \-\ AL",
"55473152", "Gaspar\ Alto\ \-\ SC",
"55993427", "Barra\ do\ Corda\ \-\ MA",
"55663455", "Santa\ Elvira\ \-\ MT",
"55533204", "Rio\ Grande\ \-\ RS",
"55424009", "Ponta\ Grossa\ \-\ PR",
"55483282", "Florianópolis\ \-\ SC",
"55114091", "Diadema\ \-\ SP",
"55413639", "Lapa\ \-\ PR",
"55443593", "Jota\ Esse\ \-\ PR",
"55143313", "Bauru\ \-\ SP",
"55513822", "Gravataí\ \-\ RS",
"55333436", "Rio\ Vermelho\ \-\ MG",
"55833306", "Coxixola\ \-\ PB",
"55483879", "Florianópolis\ \-\ SC",
"55133493", "Praia\ Grande\ \-\ SP",
"55513529", "Sapiranga\ \-\ RS",
"55323753", "Miradouro\ \-\ MG",
"55713025", "Salvador\ \-\ BA",
"55313894", "Araponga\ \-\ MG",
"55193807", "Amparo\ \-\ SP",
"55213504", "Rio\ de\ Janeiro\ \-\ RJ",
"55313443", "Minas\ Gerais",
"55133844", "Juquiá\ \-\ SP",
"55513453", "Rio\ Grande\ do\ Sul",
"55143277", "Bauru\ \-\ SP",
"55343819", "Monte\ Carmelo\ \-\ MG",
"55623325", "Rubiataba\ \-\ GO",
"55693535", "Ariquemes\ \-\ RO",
"55343512", "Araguari\ \-\ MG",
"55112785", "São\ Paulo\ \-\ SP",
"55313865", "Coronel\ Fabriciano\ \-\ MG",
"55193557", "Rio\ Claro\ \-\ SP",
"55883566", "Juazeiro\ do\ Norte\ \-\ CE",
"55743635", "Tapiramutá\ \-\ BA",
"55163143", "Restinga\ \-\ SP",
"55663536", "Marcelândia\ \-\ MT",
"55513264", "Rio\ Grande\ do\ Sul",
"55424052", "Guarapuava\ \-\ PR",
"55623628", "Novo\ Gama\ \-\ GO",
"55813281", "Recife\ \-\ PE",
"55543285", "Picada\ Café\ \-\ RS",
"55143212", "Bauru\ \-\ SP",
"5527", "Espirito\ Santo",
"55143587", "Presidente\ Alves\ \-\ SP",
"55193545", "Santa\ Gertrudes\ \-\ SP",
"55273321", "Vitória\ \-\ ES",
"55793344", "Neópolis\ \-\ SE",
"55553233", "São\ Sepé\ \-\ RS",
"55473633", "São\ Bento\ do\ Sul\ \-\ SC",
"55493339", "Águas\ de\ Chapecó\ \-\ SC",
"55423520", "São\ Mateus\ do\ Sul\ \-\ PR",
"55493330", "Chapecó\ \-\ SC",
"55643522", "Itumbiara\ \-\ GO",
"5587386", "Petrolina\ \-\ PE",
"55193821", "Elias\ Fausto\ \-\ SP",
"55123671", "São\ Luís\ do\ Paraitinga\ \-\ SP",
"55273049", "Colatina\ \-\ ES",
"55514009", "Porto\ Alegre\ \-\ RS",
"55833383", "Soledade\ \-\ PB",
"55433566", "Carlópolis\ \-\ PR",
"55133298", "Santos\ \-\ SP",
"55753683", "Humildes\ \-\ BA",
"55114469", "Santo\ André\ \-\ SP",
"5573", "Bahia",
"55993665", "Capinzal\ do\ Norte\ \-\ MA",
"55213119", "São\ Gonçalo\ \-\ RJ",
"55673232", "Corumbá\ \-\ MS",
"55893431", "Padre\ Marcos\ \-\ PI",
"55543233", "Ipê\ \-\ RS",
"55313627", "Ribeirão\ das\ Neves\ \-\ MG",
"55613475", "Brasília\ \-\ DF",
"55413535", "Curitiba\ \-\ PR",
"55693583", "Quinto\ Bec\ \-\ RO",
"55273269", "Alfredo\ Chaves\ \-\ ES",
"55513625", "Capão\ da\ Canoa\ \-\ RS",
"55273260", "Vila\ Velha\ \-\ ES",
"55173242", "Mirassol\ \-\ SP",
"55993551", "São\ João\ dos\ Patos\ \-\ MA",
"55222767", "Cambuci\ \-\ RJ",
"55753432", "Aramari\ \-\ BA",
"55463055", "Francisco\ Beltrão\ \-\ PR",
"55833479", "Cacimba\ de\ Areia\ \-\ PB",
"5511279", "São\ Paulo\ \-\ SP",
"55453029", "Foz\ do\ Iguaçu\ \-\ PR",
"55473388", "Doutor\ Pedrinho\ \-\ SC",
"55193407", "Americana\ \-\ SP",
"55423276", "Reserva\ \-\ PR",
"55153277", "Tapiraí\ \-\ SP",
"55513422", "Barro\ Vermelho\ \-\ RS",
"55613617", "Águas\ Lindas\ de\ Goiás\ \-\ GO",
"55513044", "Alvorada\ \-\ RS",
"55753635", "Mutuípe\ \-\ BA",
"55183842", "Junqueirópolis\ \-\ SP",
"55833032", "Santa\ Rita\ \-\ PB",
"55283562", "Bom\ Jesus\ do\ Norte\ \-\ ES",
"55613339", "Brasília\ \-\ DF",
"55163729", "Ituverava\ \-\ SP",
"55833638", "Nova\ Palmeira\ \-\ PB",
"55923018", "Manaus\ \-\ AM",
"55983004", "São\ Luís\ \-\ MA",
"55323446", "Palma\ \-\ MG",
"55634101", "Palmas\ \-\ TO",
"55733269", "Ilhéus\ \-\ BA",
"55163234", "Ribeirão\ Preto\ \-\ SP",
"55753338", "Mucugê\ \-\ BA",
"55213263", "Rio\ de\ Janeiro\ \-\ RJ",
"55513746", "Rio\ Grande\ do\ Sul",
"55513467", "Canoas\ \-\ RS",
"55313756", "Minas\ Gerais",
"55453236", "Serranópolis\ do\ Iguaçu\ \-\ PR",
"55633434", "Juarina\ \-\ TO",
"55983651", "Araguanã\ \-\ MA",
"55423625", "Entre\ Rios\ \-\ PR",
"55193563", "Pirassununga\ \-\ SP",
"55873884", "São\ José\ do\ Belmonte\ \-\ PE",
"55123834", "Ubatuba\ \-\ SP",
"55493538", "Ibicaré\ \-\ SC",
"55143474", "Lupércio\ \-\ SP",
"55273251", "Serra\ \-\ ES",
"55323722", "Muriaé\ \-\ MG",
"55153313", "Sorocaba\ \-\ SP",
"55443544", "Tupãssi\ \-\ PR",
"5511441", "Atibaia\ \-\ SP",
"55823262", "Messias\ \-\ AL",
"55993569", "Senador\ Alexandre\ Costa\ \-\ MA",
"55323537", "Paula\ Cândido\ \-\ MG",
"55313843", "Antônio\ Dias\ \-\ MG",
"55823201", "Maceió\ \-\ AL",
"55543332", "Não\-Me\-Toque\ \-\ RS",
"55212756", "São\ João\ de\ Meriti\ \-\ RJ",
"55913772", "Mosqueiro\ \-\ PA",
"55433145", "Bandeirantes\ \-\ PR",
"55883574", "Barbalha\ \-\ CE",
"55322104", "Juiz\ de\ Fora\ \-\ MG",
"55313662", "Pedro\ Leopoldo\ \-\ MG",
"55413456", "Matinhos\ \-\ PR",
"55513586", "Rio\ Grande\ do\ Sul",
"5551357", "Rio\ Grande\ do\ Sul",
"55813031", "Recife\ \-\ PE",
"55413096", "São\ José\ dos\ Pinhais\ \-\ PR",
"55993643", "Barra\ do\ Corda\ \-\ MA",
"55543035", "Farroupilha\ \-\ RS",
"55213970", "Rio\ de\ Janeiro\ \-\ RJ",
"55242484", "Miguel\ Pereira\ \-\ RJ",
"55423422", "Irati\ \-\ PR",
"55983391", "Cururupu\ \-\ MA",
"55643641", "Santa\ Helena\ de\ Goiás\ \-\ GO",
"55112166", "Barueri\ \-\ SP",
"55173343", "Bebedouro\ \-\ SP",
"55793541", "Tobias\ Barreto\ \-\ SE",
"55733251", "Itacaré\ \-\ BA",
"55222537", "Carmo\ \-\ RJ",
"55614102", "Brasília\ \-\ DF",
"55193649", "Águas\ da\ Prata\ \-\ SP",
"55492101", "Lages\ \-\ SC",
"55883582", "Iguatu\ \-\ CE",
"55213977", "Rio\ de\ Janeiro\ \-\ RJ",
"55913784", "Portel\ \-\ PA",
"55543612", "Muitos\ Capões\ \-\ RS",
"55133491", "Praia\ Grande\ \-\ SP",
"55323751", "Tombos\ \-\ MG",
"55193647", "Itobi\ \-\ SP",
"55273222", "Vitória\ \-\ ES",
"55843133", "Natal\ \-\ RN",
"55843536", "Pedra\ Preta\ \-\ RN",
"55114093", "Diadema\ \-\ SP",
"55143311", "Marília\ \-\ SP",
"55983622", "Bacabal\ \-\ MA",
"55114264", "Francisco\ Morato\ \-\ SP",
"55273111", "Aracruz\ \-\ ES",
"55743537", "Sento\ Sé\ \-\ BA",
"55633014", "Palmas\ \-\ TO",
"55843293", "Serra\ Caiada\ \-\ RN",
"55433272", "Jaguapitã\ \-\ PR",
"55993567", "São\ João\ do\ Soter\ \-\ MA",
"55222751", "São\ Fidélis\ \-\ RJ",
"55913544", "Oriximiná\ \-\ PA",
"55323539", "Ubá\ \-\ MG",
"55112655", "São\ Paulo\ \-\ SP",
"55193452", "Limeira\ \-\ SP",
"55733222", "Ilhéus\ \-\ BA",
"55823036", "Maceió\ \-\ AL",
"55873872", "Araripina\ \-\ PE",
"55443242", "Floraí\ \-\ PR",
"55643694", "Palmelo\ \-\ GO",
"55163396", "Santa\ Lúcia\ \-\ SP",
"55283520", "Piúma\ \-\ ES",
"55473902", "Jaraguá\ do\ Sul\ \-\ SC",
"55813411", "Belo\ Jardim\ \-\ PE",
"55513460", "Esteio\ \-\ RS",
"55112647", "São\ Paulo\ \-\ SP",
"55115839", "São\ Paulo\ \-\ SP",
"55873817", "Alagoinha\ \-\ PE",
"55513469", "Cachoeirinha\ \-\ RS",
"55353696", "Guaxupé\ \-\ MG",
"55283529", "Itapemirim\ \-\ ES",
"55733267", "Itororó\ \-\ BA",
"55163830", "Ituverava\ \-\ SP",
"55753681", "Cabaceiras\ do\ Paraguaçu\ \-\ BA",
"55443343", "Maringá\ \-\ PR",
"5546", "Paraná",
"55163839", "Ituverava\ \-\ SP",
"55883426", "Banabuiú\ \-\ CE",
"55833381", "Montadas\ \-\ PB",
"55993522", "Tuntum\ \-\ MA",
"55613619", "Águas\ Lindas\ de\ Goiás\ \-\ GO",
"55333726", "Jordânia\ \-\ MG",
"55383255", "Botumirim\ \-\ MG",
"55353214", "Varginha\ \-\ MG",
"55473631", "São\ Bento\ do\ Sul\ \-\ SC",
"55643665", "Piranhas\ \-\ GO",
"55453027", "Foz\ do\ Iguaçu\ \-\ PR",
"55833266", "Mogeiro\ \-\ PB",
"551132", "São\ Paulo\ \-\ SP",
"55663542", "Rondolândia\ \-\ MT",
"55553231", "Rosário\ do\ Sul\ \-\ RS",
"55933063", "Santarém\ \-\ PA",
"55153279", "Sao\ Miguel\ Arcanjo\ \-\ SP",
"55123026", "Taubaté\ \-\ SP",
"55483266", "Florianópolis\ \-\ SC",
"55114295", "Suzano\ \-\ SP",
"55833477", "Livramento\ \-\ PB",
"552125", "Rio\ de\ Janeiro\ \-\ RJ",
"55643462", "Goiandira\ \-\ GO",
"55713177", "Salvador\ \-\ BA",
"55423460", "Teixeira\ Soares\ \-\ PR",
"55423304", "Guarapuava\ \-\ PR",
"55273267", "Fundão\ \-\ ES",
"55222760", "Rio\ das\ Ostras\ \-\ RJ",
"55713221", "Salvador\ \-\ BA",
"55893485", "Isaías\ Coelho\ \-\ PI",
"55823558", "Penedo\ \-\ AL",
"55114135", "Taboão\ da\ Serra\ \-\ SP",
"55483381", "São\ José\ \-\ SC",
"55773648", "Novo\ Horizonte\ \-\ BA",
"55653224", "Cáceres\ \-\ MT",
"55855672", "São\ Paulo\ \-\ SP",
"55114529", "Jacaré\ \-\ SP",
"55843392", "Antônio\ Martins\ \-\ RN",
"55313441", "Minas\ Gerais",
"55513451", "Rio\ Grande\ do\ Sul",
"55413581", "Curitiba\ \-\ PR",
"55373244", "Carmo\ do\ Cajuru\ \-\ MG",
"55353625", "Marmelópolis\ \-\ MG",
"55623546", "Goiânia\ \-\ GO",
"55943428", "Rio\ Maria\ \-\ PA",
"55344009", "Uberlândia\ \-\ MG",
"55183997", "Taciba\ \-\ SP",
"55173635", "Aparecida\ D\'Oeste\ \-\ SP",
"55413972", "Pontal\ do\ Paraná\ \-\ PR",
"55993638", "Alto\ Alegre\ do\ Maranhão\ \-\ MA",
"55123133", "Guaratinguetá\ \-\ SP",
"55473363", "Balneário\ Camboriú\ \-\ SC",
"55213167", "Duque\ de\ Caxias\ \-\ RJ",
"55823311", "Maceió\ \-\ AL",
"55112473", "Bragança\ Paulista\ \-\ SP",
"55242453", "Valença\ \-\ RJ",
"55193326", "Campinas\ \-\ SP",
"55333764", "Minas\ Novas\ \-\ MG",
"55823482", "Arapiraca\ \-\ AL",
"55753242", "Amélia\ Rodrigues\ \-\ BA",
"55713637", "Vera\ Cruz\ \-\ BA",
"55773466", "Jacaraci\ \-\ BA",
"55452104", "Cascavel\ \-\ PR",
"55123609", "Taubaté\ \-\ SP",
"55873853", "Itapetim\ \-\ PE",
"55743668", "João\ Dourado\ \-\ BA",
"55313838", "Santa\ Maria\ de\ Itabira\ \-\ MG",
"55843230", "Nísia\ Floresta\ \-\ RN",
"55843239", "Nísia\ Floresta\ \-\ RN",
"55433253", "Cambé\ \-\ PR",
"55493543", "Anita\ Garibaldi\ \-\ SC",
"55123600", "São\ José\ dos\ Campos\ \-\ SP",
"55483906", "Tubarão\ \-\ SC",
"55343264", "Gurinhatã\ \-\ MG",
"55193473", "Santa\ Bárbara\ D\'Oeste\ \-\ SP",
"55943322", "Marabá\ \-\ PA",
"55383678", "Riachinho\ \-\ MG",
"55313575", "Moeda\ \-\ MG",
"55632111", "Palmas\ \-\ TO",
"55113585", "São\ Paulo\ \-\ SP",
"55813861", "Petrolina\ \-\ PE",
"55653318", "Cuiabá\ \-\ MT",
"55114039", "Campo\ Limpo\ Paulista\ \-\ SP",
"55653266", "Pontes\ e\ Lacerda\ \-\ MT",
"55433464", "Mauá\ da\ Serra\ \-\ PR",
"55673442", "Ivinhema\ \-\ MS",
"55213483", "Rio\ de\ Janeiro\ \-\ RJ",
"55813636", "Paudalho\ \-\ PE",
"55543443", "Guaporé\ \-\ RS",
"55343453", "Limeira\ do\ Oeste\ \-\ MG",
"55212704", "Niterói\ \-\ RJ",
"55433055", "Arapongas\ \-\ PR",
"55813114", "Vitória\ de\ Santo\ Antão\ \-\ PE",
"55843673", "Natal\ \-\ RN",
"55353853", "Campos\ Gerais\ \-\ MG",
"55883692", "Crateús\ \-\ CE",
"55413404", "Curitiba\ \-\ PR",
"55753343", "Bonito\ \-\ BA",
"55623010", "Senador\ Canedo\ \-\ GO",
"55192105", "Piracicaba\ \-\ SP",
"55543297", "Flores\ da\ Cunha\ \-\ RS",
"55983538", "Açailândia\ \-\ MA",
"5511452", "Jundiaí\ \-\ SP",
"55185841", "Junqueirópolis\ \-\ SP",
"55153302", "Sorocaba\ \-\ SP",
"55433047", "Apucarana\ \-\ PR",
"55312122", "Belo\ Horizonte\ \-\ MG",
"55323341", "Ressaquinha\ \-\ MG",
"55473416", "Joinville\ \-\ SC",
"55123652", "Caçapava\ \-\ SP",
"55553756", "Cerro\ Grande\ \-\ RS",
"55242258", "Bemposta\ \-\ RJ",
"55162106", "São\ Carlos\ \-\ SP",
"5521262", "Niterói\ \-\ RJ",
"55153286", "Jumirim\ \-\ SP",
"55193797", "Campinas\ \-\ SP",
"55643519", "Itumbiara\ \-\ GO",
"55823526", "Coité\ do\ Nóia\ \-\ AL",
"55743654", "Barra\ do\ Mendes\ \-\ BA",
"55124715", "Alumínio\ \-\ SP",
"55213835", "Rio\ de\ Janeiro\ \-\ RJ",
"55483643", "Imaruí\ \-\ SC",
"55793337", "Poço\ Redondo\ \-\ SE",
"55193588", "Porto\ Ferreira\ \-\ SP",
"55853014", "Maracanaú\ \-\ CE",
"55333534", "Padre\ Paraíso\ \-\ MG",
"55213288", "Rio\ de\ Janeiro\ \-\ RJ",
"55813552", "Ipojuca\ \-\ PE",
"55213818", "Rio\ de\ Janeiro\ \-\ RJ",
"55333232", "Sobrália\ \-\ MG",
"55283037", "Cachoeiro\ de\ Itapemirim\ \-\ ES",
"55833567", "Cabedelo\ \-\ PB",
"55473564", "Rio\ do\ Campo\ \-\ SC",
"55693252", "Vila\ Extrema\ \-\ RO",
"55613393", "Santa\ Maria\ \-\ DF",
"55193124", "Piracicaba\ \-\ SP",
"55633542", "Silvanópolis\ \-\ TO",
"55493622", "São\ Miguel\ do\ Oeste\ \-\ SC",
"55193871", "Valinhos\ \-\ SP",
"55793339", "Santana\ do\ São\ Francisco\ \-\ SE",
"55313346", "Belo\ Horizonte\ \-\ MG",
"55483208", "Florianópolis\ \-\ SC",
"5543", "Paraná",
"55443432", "Nova\ Londrina\ \-\ PR",
"55383546", "São\ Gonçalo\ do\ Rio\ Preto\ \-\ MG",
"5511334", "São\ Paulo\ \-\ SP",
"55643517", "Itumbiara\ \-\ GO",
"55343851", "Carmo\ do\ Paranaíba\ \-\ MG",
"55222654", "Sampaio\ Correia\ \-\ RJ",
"55163604", "Ribeirão\ Preto\ \-\ SP",
"55513696", "Barão\ \-\ RS",
"55143227", "Bauru\ \-\ SP",
"55443635", "Japurá\ \-\ PR",
"55623375", "Itaberaí\ \-\ GO",
"55813521", "Cabo\ de\ Santo\ Agostinho\ \-\ PE",
"5588", "Ceará",
"55833208", "João\ Pessoa\ \-\ PB",
"55713186", "Salvador\ \-\ BA",
"55543525", "Severiano\ de\ Almeida\ \-\ RS",
"55673405", "Vista\ Alegre\ \-\ MS",
"55713273", "Salvador\ \-\ BA",
"55173846", "Mira\ Estrela\ \-\ SP",
"55493344", "São\ Lourenço\ do\ Oeste\ \-\ SC",
"55493425", "Concórdia\ \-\ SC",
"55374101", "Itaúna\ \-\ MG",
"55543290", "Caxias\ do\ Sul\ \-\ RS",
"55943369", "Parauapebas\ \-\ PA",
"55273371", "Linhares\ \-\ ES",
"55863477", "Inhuma\ \-\ PI",
"55513289", "Rio\ Grande\ do\ Sul",
"55114037", "Pedra\ Bela\ \-\ SP",
"55653335", "Agrovila\ das\ Palmeiras\ \-\ MT",
"55373434", "Medeiros\ \-\ MG",
"55313231", "Minas\ Gerais",
"55163975", "Ribeirão\ Preto\ \-\ SP",
"55143262", "Agudos\ \-\ SP",
"55222668", "Silva\ Jardim\ \-\ RJ",
"55883516", "Piquet\ Carneiro\ \-\ CE",
"55843237", "Parnamirim\ \-\ RN",
"55413025", "Curitiba\ \-\ PR",
"55483522", "Araranguá\ \-\ SC",
"55383084", "Montes\ Claros\ \-\ MG",
"55273736", "Laranja\ da\ Terra\ \-\ ES",
"55813316", "Recife\ \-\ PE",
"55753544", "Ubaíra\ \-\ BA",
"55814062", "Recife\ \-\ PE",
"55513579", "São\ Leopoldo\ \-\ RS",
"55123607", "Tremembé\ \-\ SP",
"55163491", "Sertãozinho\ \-\ SP",
"55313728", "Buarque\ de\ Macedo\ \-\ MG",
"55493667", "São\ Miguel\ da\ Boa\ Vista\ \-\ SC",
"55143416", "Jaú\ \-\ SP",
"55114419", "Mairiporã\ \-\ SP",
"55333333", "Realeza\ \-\ MG",
"55353451", "Silvianópolis\ \-\ MG",
"55913753", "Barcarena\ \-\ PA",
"55114484", "Mairiporã\ \-\ SP",
"55553629", "Jacuizinho\ \-\ RS",
"55833522", "Sousa\ \-\ PB",
"55143201", "Bauru\ \-\ SP",
"55183999", "Estrela\ do\ Norte\ \-\ SP",
"55943351", "Palestina\ do\ Pará\ \-\ PA",
"55323365", "Santa\ Bárbara\ do\ Tugúrio\ \-\ MG",
"55463272", "Pato\ Branco\ \-\ PR",
"55173012", "São\ José\ do\ Rio\ Preto\ \-\ SP",
"55212728", "São\ Gonçalo\ \-\ RJ",
"55173681", "Nova\ Canaã\ Paulista\ \-\ SP",
"55613718", "Formosa\ \-\ GO",
"55193851", "Mogi\-Guaçu\ \-\ SP",
"55343799", "Araguari\ \-\ MG",
"55543232", "Vacaria\ \-\ RS",
"55373543", "Quartel\ Geral\ \-\ MG",
"55813877", "Carnaubeira\ da\ Penha\ \-\ PE",
"55813274", "Recife\ \-\ PE",
"55883637", "Reriutaba\ \-\ CE",
"55519", "Rio\ Grande\ do\ Sul",
"5511479", "Mogi\ das\ Cruzes\ \-\ SP",
"55623398", "Itaguaru\ \-\ GO",
"55693582", "Cujubim\ \-\ RO",
"55513561", "Estância\ Velha\ \-\ RS",
"55813510", "Cabo\ de\ Santo\ Agostinho\ \-\ PE",
"55483033", "Palhoça\ \-\ SC",
"55222674", "Araruama\ \-\ RJ",
"55143881", "Botucatu\ \-\ SP",
"55673596", "Cassilândia\ \-\ MS",
"55112118", "Itu\ \-\ SP",
"5524334", "Volta\ Redonda\ \-\ RJ",
"55773202", "Vitória\ da\ Conquista\ \-\ BA",
"55913448", "Maracanã\ \-\ PA",
"55413907", "Curitiba\ \-\ PR",
"55173243", "Mirassol\ \-\ SP",
"55813519", "São\ Lourenço\ da\ Mata\ \-\ PE",
"55753433", "Subaúma\ \-\ BA",
"55213824", "Rio\ de\ Janeiro\ \-\ RJ",
"55453336", "Luz\ Marina\ \-\ PR",
"55213171", "Rio\ de\ Janeiro\ \-\ RJ",
"55653308", "Nova\ Mutum\ \-\ MT",
"55833033", "Santa\ Rita\ \-\ PB",
"55623355", "Itapuranga\ \-\ GO",
"55513502", "Capão\ da\ Canoa\ \-\ RS",
"55333525", "Poté\ \-\ MG",
"55513423", "Gravataí\ \-\ RS",
"55773261", "Itapetinga\ \-\ BA",
"55793447", "Frei\ Paulo\ \-\ SE",
"55183601", "Bento\ de\ Abreu\ \-\ SP",
"55213227", "Rio\ de\ Janeiro\ \-\ RJ",
"55333299", "Açucena\ \-\ MG",
"556232", "Goiânia\ \-\ GO",
"55813744", "Agrestina\ \-\ PE",
"55893446", "Itainópolis\ \-\ PI",
"55613026", "Brasília\ \-\ DF",
"55212016", "Rio\ de\ Janeiro\ \-\ RJ",
"55922121", "Manaus\ \-\ AM",
"55623347", "Campinorte\ \-\ GO",
"55193181", "Floresta\ Escura\ \-\ SP",
"55933593", "Altamira\ \-\ PA",
"55542109", "Farroupilha\ \-\ RS",
"55793455", "São\ Domingos\ \-\ SE",
"5547332", "Blumenau\ \-\ SC",
"55654003", "Cuiabá\ \-\ MT",
"55112501", "São\ Paulo\ \-\ SP",
"55643636", "Jataí\ \-\ GO",
"55114914", "São\ Paulo\ \-\ SP",
"55113240", "Salvador\ \-\ BA",
"55173624", "Jales\ \-\ SP",
"55193869", "Valinhos\ \-\ SP",
"55673438", "Laguna\ Carapã\ \-\ MS",
"55473406", "Balneário\ Camboriú\ \-\ SC",
"55613190", "Brasília\ \-\ DF",
"55193562", "Pirassununga\ \-\ SP",
"55212789", "Mangaratiba\ \-\ RJ",
"55893537", "Eliseu\ Martins\ \-\ PI",
"55114421", "Santo\ André\ \-\ SP",
"55923534", "Nhamundá\ \-\ AM",
"55313549", "Minas\ Gerais",
"55513559", "Sapiranga\ \-\ RS",
"55323723", "Rosário\ da\ Limeira\ \-\ MG",
"55143646", "Mineiros\ do\ Tietê\ \-\ SP",
"55473211", "Brusque\ \-\ SC",
"55513550", "Rio\ Grande\ do\ Sul",
"55443305", "Maringá\ \-\ PR",
"55313540", "Minas\ Gerais",
"55163947", "Sertãozinho\ \-\ SP",
"55313842", "Coronel\ Fabriciano\ \-\ MG",
"55413414", "Tagaçaba\ \-\ PR",
"55553611", "Unistalda\ \-\ RS",
"55813046", "Caruaru\ \-\ PE",
"55212780", "Mangaratiba\ \-\ RJ",
"55753238", "Terra\ Nova\ \-\ BA",
"55114649", "Itaquaquecetuba\ \-\ SP",
"55823263", "Marechal\ Deodoro\ \-\ AL",
"55543333", "Chapada\ \-\ RS",
"55853004", "Fortaleza\ \-\ CE",
"55873964", "Serrolândia\ \-\ PE",
"55113115", "São\ Paulo\ \-\ SP",
"55313663", "Pedro\ Leopoldo\ \-\ MG",
"55993642", "Pedreiras\ \-\ MA",
"55114166", "Barueri\ \-\ SP",
"55353471", "Santa\ Rita\ do\ Sapucaí\ \-\ MG",
"55194007", "Campinas\ \-\ SP",
"55453241", "Cafelândia\ \-\ PR",
"55193501", "Hortolândia\ \-\ SP",
"55423423", "Irati\ \-\ PR",
"55173045", "Catanduva\ \-\ SP",
"55534007", "Pelotas\ \-\ RS",
"55513731", "Rio\ Pardo\ \-\ RS",
"55273369", "Vila\ Velha\ \-\ ES",
"55463252", "Clevelândia\ \-\ PR",
"5519341", "Piracicaba\ \-\ SP",
"55173342", "Bebedouro\ \-\ SP",
"55614103", "Brasília\ \-\ DF",
"55313714", "Paraopeba\ \-\ MG",
"55213201", "Rio\ de\ Janeiro\ \-\ RJ",
"55273223", "Vitória\ \-\ ES",
"5571", "Bahia",
"55883583", "Mombaça\ \-\ CE",
"55413034", "Piraquara\ \-\ PR",
"55114092", "Diadema\ \-\ SP",
"55183441", "Araçatuba\ \-\ SP",
"55354141", "Poços\ de\ Caldas\ \-\ MG",
"55112867", "São\ Paulo\ \-\ SP",
"55494101", "Chapecó\ \-\ SC",
"55373425", "Luz\ \-\ MG",
"55213913", "Itaboraí\ \-\ RJ",
"55113138", "São\ Paulo\ \-\ SP",
"55194009", "Campinas\ \-\ SP",
"5598308", "São\ Luís\ \-\ MA",
"55843292", "Tangará\ \-\ RN",
"55513785", "Rio\ Grande\ do\ Sul",
"55313598", "Minas\ Gerais",
"55373344", "Pedra\ do\ Indaiá\ \-\ MG",
"55312564", "Contagem\ \-\ MG",
"55192138", "Campinas\ \-\ SP",
"55163949", "Cruz\ das\ Posses\ \-\ SP",
"55123896", "Ilhabela\ \-\ SP",
"55193453", "Limeira\ \-\ SP",
"55163763", "Jardinópolis\ \-\ SP",
"55433273", "Miraselva\ \-\ PR",
"55873873", "Araripina\ \-\ PE",
"55443243", "São\ Jorge\ do\ Ivaí\ \-\ PR",
"55853667", "Itarema\ \-\ CE",
"55212787", "Duque\ de\ Caxias\ \-\ RJ",
"55893539", "Porto\ Alegre\ do\ Piauí\ \-\ PI",
"55833281", "Itabaiana\ \-\ PB",
"55513557", "Rio\ Grande\ do\ Sul",
"55533264", "Praia\ do\ Hermenegildo\ \-\ RS",
"55313547", "Minas\ Gerais",
"5581342", "Recife\ \-\ PE",
"55713040", "Camaçari\ \-\ BA",
"55114655", "Arujá\ \-\ SP",
"55473903", "Joinville\ \-\ SC",
"55833366", "Lagoa\ Seca\ \-\ PB",
"55313555", "Minas\ Gerais",
"55193867", "Jaguariúna\ \-\ SP",
"55553331", "Ijuí\ \-\ RS",
"55513545", "Igrejinha\ \-\ RS",
"55153379", "São\ Miguel\ Arcanjo\ \-\ SP",
"55115614", "São\ Paulo\ \-\ SP",
"55443045", "Paranavaí\ \-\ PR",
"55623349", "Hidrolina\ \-\ GO",
"55542107", "Erechim\ \-\ RS",
"55333297", "Santa\ Efigênia\ de\ Minas\ \-\ MG",
"55313436", "Minas\ Gerais",
"55443342", "Paranapoema\ \-\ PR",
"55623340", "São\ Patrício\ \-\ GO",
"55483413", "Criciúma\ \-\ SC",
"55843653", "Natal\ \-\ RN",
"55643521", "Itumbiara\ \-\ GO",
"55193822", "Sumaré\ \-\ SP",
"55123672", "Tremembé\ \-\ SP",
"55213229", "Rio\ de\ Janeiro\ \-\ RJ",
"55793449", "Ribeirópolis\ \-\ SE",
"5561344", "Brasília\ \-\ DF",
"55933062", "Santarém\ \-\ PA",
"55273322", "Vitória\ \-\ ES",
"55112822", "Osasco\ \-\ SP",
"55813517", "São\ Lourenço\ da\ Mata\ \-\ PE",
"55433478", "Lunardelli\ \-\ PR",
"55443448", "Marilena\ \-\ PR",
"5571321", "Salvador\ \-\ BA",
"55124159", "Vargem\ Grande\ Paulista\ \-\ SP",
"55493434", "Vargeão\ \-\ SC",
"55343511", "Patrocínio\ \-\ MG",
"55443624", "Umuarama\ \-\ PR",
"55534052", "Pelotas\ \-\ RS",
"55153556", "Iporanga\ \-\ SP",
"55143288", "Bauru\ \-\ SP",
"55883639", "Varjota\ \-\ CE",
"55743674", "Lajes\ do\ Batata\ \-\ BA",
"55883630", "Miraíma\ \-\ CE",
"55114409", "Jacaré\ \-\ SP",
"55543534", "Caxias\ do\ Sul\ \-\ RS",
"55713113", "Salvador\ \-\ BA",
"55633538", "Aparecida\ do\ Rio\ Negro\ \-\ TO",
"5592365", "Manaus\ \-\ AM",
"55143406", "Garça\ \-\ SP",
"55533258", "Santana\ da\ Boa\ Vista\ \-\ RS",
"55853344", "Paracuru\ \-\ CE",
"55813879", "Jaboatão\ dos\ Guararapes\ \-\ PE",
"55843393", "João\ Dias\ \-\ RN",
"55213311", "Macaé\ \-\ RJ",
"55733535", "Jitaúna\ \-\ BA",
"55844102", "Natal\ \-\ RN",
"55623142", "Goiânia\ \-\ GO",
"55353561", "Carmo\ do\ Rio\ Claro\ \-\ MG",
"55283511", "Cachoeiro\ de\ Itapemirim\ \-\ ES",
"55114473", "Santo\ André\ \-\ SP",
"55813641", "Vicência\ \-\ PE",
"55633425", "Pau\ D\'Arco\ \-\ TO",
"55423634", "Campina\ do\ Simão\ \-\ PR",
"55473065", "Balneário\ Camboriú\ \-\ SC",
"55452031", "Marechal\ Cândido\ Rondon\ \-\ PR",
"55183704", "Pereira\ Barreto\ \-\ SP",
"55193030", "Vinhedo\ \-\ SP",
"55413973", "Rio\ Branco\ do\ Sul\ \-\ PR",
"55153261", "Porto\ Feliz\ \-\ SP",
"5582332", "Maceió\ \-\ AL",
"55193675", "Tambaú\ \-\ SP",
"55242452", "Valença\ \-\ RJ",
"55543348", "Água\ Santa\ \-\ RS",
"55123132", "Guaratinguetá\ \-\ SP",
"55633344", "Carrasco\ Bonito\ \-\ TO",
"55473362", "Presidente\ Nereu\ \-\ SC",
"55273129", "Guarapari\ \-\ ES",
"55873852", "Betânia\ \-\ PE",
"55473301", "Indaial\ \-\ SC",
"55753243", "Conceição\ do\ Jacuípe\ \-\ BA",
"55223861", "Itaocara\ \-\ RJ",
"55222771", "Rio\ das\ Ostras\ \-\ RJ",
"55543397", "Maximiliano\ de\ Almeida\ \-\ RS",
"55983014", "São\ Luís\ \-\ MA",
"55943323", "Marabá\ \-\ PA",
"55433252", "Arapongas\ \-\ PR",
"55153202", "Sorocaba\ \-\ SP",
"55493542", "Erval\ Velho\ \-\ SC",
"55273120", "Colatina\ \-\ ES",
"55333415", "Gonzaga\ \-\ MG",
"55693321", "Vilhena\ \-\ RO",
"55323241", "Juiz\ de\ Fora\ \-\ MG",
"55613607", "Distrito\ de\ Campos\ Lindos\ \-\ GO",
"55913721", "Castanhal\ \-\ PA",
"5569", "Rondônia",
"55633028", "Palmas\ \-\ TO",
"55112378", "Mogi\ das\ Cruzes\ \-\ SP",
"55383626", "Ibiracatu\ \-\ MG",
"55673443", "Batayporã\ \-\ MS",
"55443666", "Herculândia\ \-\ PR",
"55693516", "Ariquemes\ \-\ RO",
"55314122", "Contagem\ \-\ MG",
"55843330", "Itajá\ \-\ RN",
"55313611", "Viçosa\ \-\ MG",
"55843672", "Natal\ \-\ RN",
"55833642", "Santa\ Cecília\ \-\ PB",
"55673297", "Chapadão\ do\ Baús\ \-\ MS",
"55313385", "Minas\ Gerais",
"55243355", "Resende\ \-\ RJ",
"55113375", "São\ Paulo\ \-\ SP",
"55273765", "Pinheiros\ \-\ ES",
"55114278", "Santa\ Isabel\ \-\ SP",
"55943222", "Marabá\ \-\ PA",
"55513634", "Bom\ Princípio\ \-\ RS",
"55353559", "Guaxupé\ \-\ MG",
"55114511", "Mauá\ \-\ SP",
"55483324", "Florianópolis\ \-\ SC",
"55513958", "Charqueadas\ \-\ RS",
"55343823", "Patos\ de\ Minas\ \-\ MG",
"55153259", "Tatuí\ \-\ SP",
"55833048", "João\ Pessoa\ \-\ PB",
"55663515", "Sinop\ \-\ MT",
"55773481", "Bom\ Jesus\ da\ Lapa\ \-\ BA",
"55653366", "Nova\ Mutum\ \-\ MT",
"55513387", "Rio\ Grande\ do\ Sul",
"55123653", "Caçapava\ \-\ SP",
"55873809", "Iguaraci\ \-\ PE",
"55183285", "Caiabu\ \-\ SP",
"55223850", "Miracema\ \-\ RJ",
"55323336", "Desterro\ do\ Melo\ \-\ MG",
"55383745", "Lagoa\ dos\ Patos\ \-\ MG",
"55823288", "Quebrangulo\ \-\ AL",
"55613621", "Luziânia\ \-\ GO",
"55753448", "Itamira\ \-\ BA",
"55833457", "Princesa\ Isabel\ \-\ PB",
"5519352", "Rio\ Claro\ \-\ SP",
"55353731", "Andradas\ \-\ MG",
"55513471", "Cachoeirinha\ \-\ RS",
"55662101", "Rondonópolis\ \-\ MT",
"55113439", "Santo\ André\ \-\ SP",
"55933537", "Mujuí\ dos\ Campos\ \-\ PA",
"55483642", "Gravatal\ \-\ SC",
"55383757", "Joaquim\ Felício\ \-\ MG",
"55843475", "Equador\ \-\ RN",
"55833445", "Paulista\ \-\ PB",
"55813553", "Amaraji\ \-\ PE",
"55473263", "Balneário\ Camboriú\ \-\ SC",
"55193904", "Mogi\ Mirim\ \-\ SP",
"5511568", "São\ Paulo\ \-\ SP",
"55212688", "Itaguaí\ \-\ RJ",
"55673248", "Costa\ Rica\ \-\ MS",
"55753624", "Feira\ de\ Santana\ \-\ BA",
"55613392", "Santa\ Maria\ \-\ DF",
"55693253", "Vila\ Nova\ Califórnia\ \-\ RO",
"55163711", "Franca\ \-\ SP",
"55333233", "Tarumirim\ \-\ MG",
"55173831", "Nova\ Castilho\ \-\ SP",
"55113437", "Guarulhos\ \-\ SP",
"55133296", "Santos\ \-\ SP",
"55643573", "Itumbiara\ \-\ GO",
"55383759", "Lassance\ \-\ MG",
"55493623", "Descanso\ \-\ SC",
"55833459", "Nova\ Olinda\ \-\ PB",
"55443433", "Nova\ Aliança\ do\ Ivaí\ \-\ PR",
"55693464", "Vale\ do\ Paraíso\ \-\ RO",
"55353821", "Lavras\ \-\ MG",
"55993571", "Porto\ Franco\ \-\ MA",
"55323265", "Descoberto\ \-\ MG",
"55484003", "Florianópolis\ \-\ SC",
"55733162", "Porto\ Seguro\ \-\ BA",
"55833099", "Campina\ Grande\ \-\ PB",
"55833450", "Tavares\ \-\ PB",
"55663538", "Bom\ Jesus\ do\ Araguaia\ \-\ MT",
"55623626", "Goiânia\ \-\ GO",
"55513389", "Rio\ Grande\ do\ Sul",
"55653235", "Figueirópolis\ D\'Oeste\ \-\ MT",
"55313331", "Minas\ Gerais",
"55353545", "Ibiraci\ \-\ MG",
"55313074", "Belo\ Horizonte\ \-\ MG",
"55153257", "Porangaba\ \-\ SP",
"55483090", "São\ José\ \-\ SC",
"55372101", "Divinópolis\ \-\ MG",
"55383531", "Diamantina\ \-\ MG",
"55114871", "São\ Paulo\ \-\ SP",
"55513380", "Rio\ Grande\ do\ Sul",
"55423256", "Porto\ Amazonas\ \-\ PR",
"55413111", "Curitiba\ \-\ PR",
"55843337", "Caraúbas\ \-\ RN",
"55713272", "Salvador\ \-\ BA",
"55153245", "Votorantim\ \-\ SP",
"55773435", "Anagé\ \-\ BA",
"55883568", "Jaguaribara\ \-\ CE",
"55473041", "Blumenau\ \-\ SC",
"55883221", "Juazeiro\ do\ Norte\ \-\ CE",
"5531378", "Minas\ Gerais",
"55753608", "Barrocas\ \-\ BA",
"55833308", "Santo\ André\ \-\ PB",
"55442033", "Palotina\ \-\ PR",
"55193484", "Nova\ Odessa\ \-\ SP",
"55823646", "Canapi\ \-\ AL",
"55424141", "Ponta\ Grossa\ \-\ PR",
"55143263", "Lençóis\ Paulista\ \-\ SP",
"55643411", "Catalão\ \-\ GO",
"55483523", "Maracajá\ \-\ SC",
"55673686", "Bonito\ \-\ MS",
"55443238", "Doutor\ Camargo\ \-\ PR",
"55883112", "Sobral\ \-\ CE",
"55433554", "Congonhinhas\ \-\ PR",
"55493244", "Santa\ Cecília\ \-\ SC",
"55833461", "Santa\ Luzia\ \-\ PB",
"55222134", "Iguaba\ Grande\ \-\ RJ",
"55143454", "Marília\ \-\ SP",
"55863366", "Luís\ Correia\ \-\ PI",
"55873785", "Lagoa\ do\ Ouro\ \-\ PE",
"55333332", "Manhuaçu\ \-\ MG",
"55343421", "Frutal\ \-\ MG",
"55483461", "Criciúma\ \-\ SC",
"55913752", "Tailândia\ \-\ PA",
"55323294", "Bocaina\ de\ Minas\ \-\ MG",
"55883554", "Barro\ \-\ CE",
"55114976", "Santo\ André\ \-\ SP",
"55733271", "Iguaí\ \-\ BA",
"55663496", "Alto\ Taquari\ \-\ MT",
"55313246", "Minas\ Gerais",
"55513256", "Rio\ Grande\ do\ Sul",
"55873821", "Arcoverde\ \-\ PE",
"55613536", "Brasília\ \-\ DF",
"55112419", "Bragança\ Paulista\ \-\ SP",
"55863281", "Milton\ Brandão\ \-\ PI",
"5595", "Roraima",
"55883441", "Quixeramobim\ \-\ CE",
"55313373", "Belo\ Horizonte\ \-\ MG",
"55543524", "Mariano\ Moro\ \-\ RS",
"55173256", "Santa\ Luzia\ \-\ SP",
"55113383", "São\ Paulo\ \-\ SP",
"55163461", "Araraquara\ \-\ SP",
"55443634", "São\ Jorge\ do\ Patrocínio\ \-\ PR",
"55313161", "Ribeirão\ das\ Neves\ \-\ MG",
"55623374", "Itapirapuã\ \-\ GO",
"55163605", "Ribeirão\ Preto\ \-\ SP",
"55883629", "Novo\ Oriente\ \-\ CE",
"55493648", "Caibi\ \-\ SC",
"55183583", "Rinópolis\ \-\ SP",
"55143292", "Pederneiras\ \-\ SP",
"55813712", "Caruaru\ \-\ PE",
"55183273", "Álvares\ Machado\ \-\ SP",
"55553307", "Santa\ Maria\ \-\ RS",
"55493424", "Bom\ Jesus\ \-\ SC",
"55753204", "Feira\ de\ Santana\ \-\ BA",
"55163308", "Gavião\ Peixoto\ \-\ SP",
"55813138", "Caruaru\ \-\ PE",
"55493345", "Santiago\ do\ Sul\ \-\ SC",
"55824102", "Centro\ \-\ AL",
"55333741", "Jequitinhonha\ \-\ MG",
"55273332", "Vitória\ \-\ ES",
"55323452", "Itamarati\ de\ Minas\ \-\ MG",
"55193539", "Ajapi\ \-\ SP",
"5555321", "Santa\ Maria\ \-\ RS",
"55213724", "Rio\ de\ Janeiro\ \-\ RJ",
"55222647", "Cabo\ Frio\ \-\ RJ",
"55793631", "Lagarto\ \-\ SE",
"55513709", "Lajeado\ \-\ RS",
"55473565", "Mirim\ Doce\ \-\ SC",
"55893453", "Pio\ Ix\ \-\ PI",
"55813255", "Jaboatão\ dos\ Guararapes\ \-\ PE",
"55513700", "Rio\ Grande\ do\ Sul",
"55643531", "Itumbiara\ \-\ GO",
"55183743", "Ilha\ Solteira\ \-\ SP",
"55343241", "Araguari\ \-\ MG",
"55543251", "Cambará\ do\ Sul\ \-\ RS",
"55313426", "Belo\ Horizonte\ \-\ MG",
"55743649", "Uibaí\ \-\ BA",
"55112751", "São\ Paulo\ \-\ SP",
"55923323", "Pitinga\ \-\ AM",
"55993533", "Buritirana\ \-\ MA",
"55143541", "Promissão\ \-\ SP",
"55222655", "Saquarema\ \-\ RJ",
"55183856", "Nova\ Guataporanga\ \-\ SP",
"55613262", "Brasília\ \-\ DF",
"55333581", "Nova\ Módica\ \-\ MG",
"55433441", "Marumbi\ \-\ PR",
"55115090", "São\ Paulo\ \-\ SP",
"55743640", "Presidente\ Dutra\ \-\ BA",
"55733679", "Porto\ Seguro\ \-\ BA",
"55172136", "São\ José\ do\ Rio\ Preto\ \-\ SP",
"55513140", "Novo\ Hamburgo\ \-\ RS",
"55532128", "Pelotas\ \-\ RS",
"55143653", "Brotas\ \-\ SP",
"55663418", "São\ Pedro\ da\ Cipa\ \-\ MT",
"55114485", "Mairiporã\ \-\ SP",
"55553321", "Cruz\ Alta\ \-\ RS",
"55193769", "Campinas\ \-\ SP",
"5531330", "Minas\ Gerais",
"55313159", "Betim\ \-\ MG",
"55993614", "Itaipava\ do\ Grajaú\ \-\ MA",
"5555", "Rio\ Grande\ do\ Sul",
"55483548", "Passo\ de\ Torres\ \-\ SC",
"55193683", "Santa\ Cruz\ das\ Palmeiras\ \-\ SP",
"55323364", "Paiva\ \-\ MG",
"55313742", "Ouro\ Branco\ \-\ MG",
"55513752", "Jacarezinho\ \-\ RS",
"55613363", "Guará\ \-\ DF",
"55663481", "Alto\ Araguaia\ \-\ MT",
"55413657", "Almirante\ Tamandaré\ \-\ PR",
"55513215", "Rio\ Grande\ do\ Sul",
"55112683", "São\ Paulo\ \-\ SP",
"55964009", "Macapá\ \-\ AP",
"55543260", "Caravaggio\ \-\ RS",
"55373435", "Vargem\ Bonita\ \-\ MG",
"55163974", "Ribeirão\ Preto\ \-\ SP",
"55633386", "Palmeirópolis\ \-\ TO",
"55663015", "Sinop\ \-\ MT",
"55313889", "Belo\ Horizonte\ \-\ MG",
"55164003", "Ribeirão\ Preto\ \-\ SP",
"55753545", "Milagres\ \-\ BA",
"55114682", "Juquitiba\ \-\ SP",
"55114011", "Piracaia\ \-\ SP",
"55153344", "Piedade\ \-\ SP",
"55343336", "Uberaba\ \-\ MG",
"55212742", "Teresópolis\ \-\ RJ",
"55772101", "Vitória\ da\ Conquista\ \-\ BA",
"55273233", "Vitória\ \-\ ES",
"55113572", "São\ Paulo\ \-\ SP",
"55513666", "Terra\ de\ Areia\ \-\ RS",
"55413442", "Guaratuba\ \-\ PR",
"55183639", "Santo\ Antônio\ do\ Aracanguá\ \-\ SP",
"55313880", "Minas\ Gerais",
"55843288", "Passa\ e\ Fica\ \-\ RN",
"55913116", "Belém\ \-\ PA",
"55343265", "Cachoeira\ Dourada\ \-\ MG",
"55313210", "Minas\ Gerais",
"55183637", "Araçatuba\ \-\ SP",
"55123301", "Lorena\ \-\ SP",
"55452105", "Foz\ do\ Iguaçu\ \-\ PR",
"55163982", "Serra\ Azul\ \-\ SP",
"55313887", "Acaiaca\ \-\ MG",
"55222733", "Campos\ dos\ Goytacazes\ \-\ RJ",
"55513721", "Triunfo\ \-\ RS",
"55223021", "Araruama\ \-\ RJ",
"55983313", "São\ Luís\ \-\ MA",
"55623283", "Aparecida\ de\ Goiânia\ \-\ GO",
"55543267", "Vila\ Seca\ \-\ RS",
"55553352", "São\ Luiz\ Gonzaga\ \-\ RS",
"55413399", "Campo\ Largo\ \-\ PR",
"55433465", "Rosário\ do\ Ivaí\ \-\ PR",
"55673025", "Campo\ Grande\ \-\ MS",
"55623573", "Goiânia\ \-\ GO",
"55513238", "Rio\ Grande\ do\ Sul",
"55113584", "São\ Paulo\ \-\ SP",
"55543323", "Nova\ Alvorada\ \-\ RS",
"55313574", "Crucilândia\ \-\ MG",
"55433662", "Florestópolis\ \-\ PR",
"55413659", "Tunas\ \-\ PR",
"55484106", "Florianópolis\ \-\ SC",
"55163324", "Araraquara\ \-\ SP",
"55873773", "Lajedo\ \-\ PE",
"5513345", "Peruíbe\ \-\ SP",
"55823337", "Maceió\ \-\ AL",
"55943348", "Curionópolis\ \-\ PA",
"55114431", "Jundiaí\ \-\ SP",
"55753182", "Alagoinhas\ \-\ BA",
"55923524", "Urucurituba\ \-\ AM",
"55543476", "União\ da\ Serra\ \-\ RS",
"55453278", "Toledo\ \-\ PR",
"55353624", "Delfim\ Moreira\ \-\ MG",
"55793526", "Estância\ \-\ SE",
"55663435", "Tesouro\ \-\ MT",
"55373015", "Divinópolis\ \-\ MG",
"55613595", "Sobradinho\ \-\ DF",
"55493361", "Chapecó\ \-\ SC",
"55443256", "Ângulo\ \-\ PR",
"55643626", "Santo\ Antônio\ da\ Barra\ \-\ GO",
"55673919", "Três\ Lagoas\ \-\ MS",
"55853213", "Caucaia\ \-\ CE",
"55173634", "Urânia\ \-\ SP",
"55893562", "Bom\ Jesus\ \-\ PI",
"55473393", "Bombinhas\ \-\ SC",
"55173513", "São\ José\ do\ Rio\ Preto\ \-\ SP",
"55983466", "Pirapemas\ \-\ MA",
"55663556", "Juara\ \-\ MT",
"55733677", "Coroa\ Vermelha\ \-\ BA",
"55743647", "Jussara\ \-\ BA",
"55115097", "São\ Paulo\ \-\ SP",
"55423238", "Ponta\ Grossa\ \-\ PR",
"55623488", "Simolândia\ \-\ GO",
"55853377", "Itaitinga\ \-\ CE",
"55343848", "Romaria\ \-\ MG",
"55433627", "Leópolis\ \-\ PR",
"55733612", "Itabuna\ \-\ BA",
"55843646", "Natal\ \-\ RN",
"55963118", "Macapá\ \-\ AP",
"55513433", "Rio\ Grande\ do\ Sul",
"55222640", "Cabo\ Frio\ \-\ RJ",
"55333535", "Pavão\ \-\ MG",
"55743655", "Central\ \-\ BA",
"55193537", "Ipeúna\ \-\ SP",
"55373213", "Divinópolis\ \-\ MG",
"55453326", "Cascavel\ \-\ PR",
"55513707", "Lajeado\ \-\ RS",
"55192104", "Campinas\ \-\ SP",
"55115642", "São\ Paulo\ \-\ SP",
"55924004", "Manaus\ \-\ AM",
"55623085", "Aparecida\ de\ Goiânia\ \-\ GO",
"55753423", "Alagoinhas\ \-\ BA",
"55983212", "São\ Luís\ \-\ MA",
"55623382", "Fazenda\ Nova\ \-\ GO",
"55413405", "São\ José\ dos\ Pinhais\ \-\ PR",
"55153543", "Capão\ Bonito\ \-\ SP",
"55483023", "Palhoça\ \-\ SC",
"55383813", "Mato\ Verde\ \-\ MG",
"55212705", "Niterói\ \-\ RJ",
"55123979", "Monteiro\ Lobato\ \-\ SP",
"55473653", "Papanduva\ \-\ SC",
"55883627", "Martinópole\ \-\ CE",
"55323421", "Cataguases\ \-\ MG",
"55773496", "Santa\ Maria\ da\ Vitória\ \-\ BA",
"55273081", "Vitória\ \-\ ES",
"55983345", "Rosário\ \-\ MA",
"55643695", "Adelândia\ \-\ GO",
"55273248", "Aracê\ \-\ ES",
"55833296", "Baía\ da\ Traição\ \-\ PB",
"55533027", "Pelotas\ \-\ RS",
"55412152", "Paranaguá\ \-\ PR",
"55513608", "Rio\ Grande\ do\ Sul",
"55193394", "Indaiatuba\ \-\ SP",
"55112654", "São\ Paulo\ \-\ SP",
"55613526", "Brasília\ \-\ DF",
"55873831", "Serra\ Talhada\ \-\ PE",
"55983357", "Matinha\ \-\ MA",
"55353013", "Lavras\ \-\ MG",
"55833533", "João\ Pessoa\ \-\ PB",
"55343431", "Prata\ \-\ MG",
"55333025", "Governador\ Valadares\ \-\ MG",
"55213621", "Rio\ de\ Janeiro\ \-\ RJ",
"55733297", "Caravelas\ \-\ BA",
"55553373", "Saldanha\ Marinho\ \-\ RS",
"55773667", "Pindaí\ \-\ BA",
"5561322", "Brasília\ \-\ DF",
"55333322", "Caratinga\ \-\ MG",
"55843301", "Natal\ \-\ RN",
"55623552", "Guapó\ \-\ GO",
"55493279", "Rio\ Rufino\ \-\ SC",
"55273137", "Vitória\ \-\ ES",
"55843362", "Campo\ Grande\ \-\ RN",
"55673456", "Nova\ Alvorada\ do\ Sul\ \-\ MS",
"55163413", "São\ Carlos\ \-\ SP",
"55643658", "São\ Simão\ \-\ GO",
"55483533", "Sombrio\ \-\ SC",
"55813010", "Paulista\ \-\ PE",
"55343674", "Matutina\ \-\ MG",
"55454053", "Foz\ do\ Iguaçu\ \-\ PR",
"556432", "Itumbiara\ \-\ GO",
"55134003", "Praia\ Grande\ \-\ SP",
"55553426", "Alegrete\ \-\ RS",
"55633377", "Aliança\ do\ Tocantins\ \-\ TO",
"55733248", "Itapé\ \-\ BA",
"55843065", "Mossoró\ \-\ RN",
"55472103", "Itajaí\ \-\ SC",
"55173807", "Ubarana\ \-\ SP",
"5565368", "Várzea\ Grande\ \-\ MT",
"55663386", "São\ José\ do\ Rio\ Claro\ \-\ MT",
"55123151", "Canas\ \-\ SP",
"55643492", "Edéia\ \-\ GO",
"55653023", "Cuiabá\ \-\ MT",
"55633015", "Palmas\ \-\ TO",
"55973427", "Juruá\ \-\ AM",
"55242431", "Piraí\ \-\ RJ",
"55913821", "Peixe\-Boi\ \-\ PA",
"55753256", "Tucano\ \-\ BA",
"55483296", "Biguaçu\ \-\ SC",
"55193938", "Indaiatuba\ \-\ SP",
"55193654", "Santo\ Antônio\ do\ Jardim\ \-\ SP",
"5531321", "Belo\ Horizonte\ \-\ MG",
"55114265", "Itapecerica\ da\ Serra\ \-\ SP",
"55113368", "São\ Paulo\ \-\ SP",
"55333428", "Santo\ Antônio\ do\ Itambé\ \-\ MG",
"55553742", "Palmeira\ das\ Missões\ \-\ RS",
"55152101", "Sorocaba\ \-\ SP",
"55123646", "Roseira\ \-\ SP",
"55893484", "Campinas\ do\ Piauí\ \-\ PI",
"55114897", "Itu\ \-\ SP",
"55843263", "Touros\ \-\ RN",
"55183221", "Presidente\ Prudente\ \-\ SP",
"55512126", "Porto\ Alegre\ \-\ RS",
"55843327", "Grossos\ \-\ RN",
"55383521", "Itamarandiba\ \-\ MG",
"55663528", "Luciára\ \-\ MT",
"55112668", "Mogi\ das\ Cruzes\ \-\ SP",
"55623636", "Goiânia\ \-\ GO",
"55653225", "Porto\ Esperidião\ \-\ MT",
"55313321", "Minas\ Gerais",
"55754141", "Feira\ de\ Santana\ \-\ BA",
"55173557", "Sales\ \-\ SP",
"55114134", "Barueri\ \-\ SP",
"55513499", "Eldorado\ do\ Sul\ \-\ RS",
"55383845", "Taiobeiras\ \-\ MG",
"55613388", "Planaltina\ \-\ DF",
"55443423", "Paranavaí\ \-\ PR",
"55113354", "São\ Paulo\ \-\ SP",
"55242723", "Campos\ dos\ Goitacazes\ \-\ RJ",
"55353831", "Campo\ Belo\ \-\ MG",
"55513059", "Canoas\ \-\ RS",
"55313049", "Contagem\ \-\ MG",
"55713555", "Salvador\ \-\ BA",
"55513490", "Gravataí\ \-\ RS",
"55113427", "Mogi\ das\ Cruzes\ \-\ SP",
"55773622", "Angical\ \-\ BA",
"55643664", "Doverlândia\ \-\ GO",
"55473339", "Blumenau\ \-\ SC",
"55493633", "Santa\ Helena\ \-\ SC",
"55383254", "Itacambira\ \-\ MG",
"55473330", "Blumenau\ \-\ SC",
"55553272", "Tupanciretã\ \-\ RS",
"55823292", "Porto\ Calvo\ \-\ AL",
"55412107", "Curitiba\ \-\ PR",
"55163811", "São\ Joaquim\ da\ Barra\ \-\ SP",
"55793262", "Barra\ dos\ Coqueiros\ \-\ SE",
"55753634", "Amargosa\ \-\ BA",
"55513045", "Viamão\ \-\ RS",
"55313055", "Belo\ Horizonte\ \-\ MG",
"55113429", "São\ Paulo\ \-\ SP",
"55653548", "Lucas\ do\ Rio\ Verde\ \-\ MT",
"55933527", "Santarém\ \-\ PA",
"55213133", "Rio\ de\ Janeiro\ \-\ RJ",
"55473337", "Blumenau\ \-\ SC",
"55542992", "Caxias\ do\ Sul\ \-\ RS",
"55114241", "Embu\ das\ Artes\ \-\ SP",
"55913809", "Inhangapi\ \-\ PA",
"55753387", "Quijingue\ \-\ BA",
"5519353", "Rio\ Claro\ \-\ SP",
"55983302", "São\ Luís\ \-\ MA",
"55193593", "Descalvado\ \-\ SP",
"55493313", "Chapecó\ \-\ SC",
"55353721", "Poços\ de\ Caldas\ \-\ MG",
"55513057", "Montenegro\ \-\ RS",
"55513497", "Gravataí\ \-\ RS",
"55212692", "Nilópolis\ \-\ RJ",
"55913423", "Salinópolis\ \-\ PA",
"5521323", "Rio\ de\ Janeiro\ \-\ RJ",
"55613631", "Formosa\ \-\ GO",
"55893472", "Francinópolis\ \-\ PI",
"55823541", "Junqueiro\ \-\ AL",
"55513448", "Rio\ Grande\ do\ Sul",
"55983361", "Axixá\ \-\ MA",
"55114592", "Itupeva\ \-\ SP",
"55843329", "Felipe\ Guerra\ \-\ RN",
"55453421", "Toledo\ \-\ PR",
"55423243", "Ponta\ Grossa\ \-\ PR",
"55513624", "Santa\ Terezinha\ \-\ RS",
"55483334", "Florianópolis\ \-\ SC",
"55343833", "Serra\ do\ Salitre\ \-\ MG",
"55373259", "Pitangui\ \-\ MG",
"55753471", "Feira\ de\ Santana\ \-\ BA",
"55114899", "Caieiras\ \-\ SP",
"55843320", "Baraúna\ \-\ RN",
"55413534", "São\ José\ dos\ Pinhais\ \-\ PR",
"55543371", "Marau\ \-\ RS",
"55913731", "Vigia\ \-\ PA",
"55543034", "São\ Marcos\ \-\ RS",
"55183693", "Piacatu\ \-\ SP",
"55353433", "Camanducaia\ \-\ MG",
"55333351", "Raul\ Soares\ \-\ MG",
"55883575", "Jati\ \-\ CE",
"55273299", "Vila\ Velha\ \-\ ES",
"55313876", "Urucânia\ \-\ MG",
"55613961", "Brasília\ \-\ DF",
"55913182", "Belém\ \-\ PA",
"55343088", "Uberlândia\ \-\ MG",
"55513773", "Poço\ das\ Antas\ \-\ RS",
"55193341", "Campinas\ \-\ SP",
"55943333", "Itupiranga\ \-\ PA",
"55813678", "Rio\ Formoso\ \-\ PE",
"55633379", "Caseara\ \-\ TO",
"55173809", "Mendonça\ \-\ SP",
"55323748", "Pedra\ Dourada\ \-\ MG",
"55133048", "São\ Vicente\ \-\ SP",
"55242485", "Paty\ do\ Alferes\ \-\ RJ",
"55273139", "Vila\ Velha\ \-\ ES",
"55173423", "Votuporanga\ \-\ SP",
"55733299", "Lajedão\ \-\ BA",
"55173561", "Novais\ \-\ SP",
"55124611", "Cotia\ \-\ SP",
"55793363", "Canhoba\ \-\ SE",
"55193029", "Campinas\ \-\ SP",
"55873885", "Mirandiba\ \-\ PE",
"55123835", "Ubatuba\ \-\ SP",
"55112341", "São\ Paulo\ \-\ SP",
"55493277", "Bom\ Retiro\ \-\ SC",
"55663504", "União\ do\ Norte\ \(Antiga\ Lenislândia\)\ \-\ MT",
"55633435", "Arapoema\ \-\ TO",
"55983359", "São\ João\ Batista\ \-\ MA",
"55323511", "Muriaé\ \-\ MG",
"55443557", "Terra\ Nova\ do\ Piquirí\ \-\ PR",
"55323278", "Pequeri\ \-\ MG",
"55213766", "Nova\ Iguaçu\ \-\ RJ",
"55793227", "Aracaju\ \-\ SE",
"55513243", "Rio\ Grande\ do\ Sul",
"55733290", "Ibirapuã\ \-\ BA",
"55313253", "Belo\ Horizonte\ \-\ MG",
"55133445", "Mongaguá\ \-\ SP",
"55433575", "Londrina\ \-\ PR",
"55222748", "Travessão\ \-\ RJ",
"55123211", "Cruzeiro\ \-\ SP",
"55623463", "Mimoso\ de\ Goiás\ \-\ GO",
"55313309", "Belo\ Horizonte\ \-\ MG",
"55443545", "Yolanda\ \-\ PR",
"55143475", "Ocauçu\ \-\ SP",
"55533029", "Pelotas\ \-\ RS",
"55733525", "Jequié\ \-\ BA",
"55373261", "Lagoa\ da\ Prata\ \-\ MG",
"55313464", "Belo\ Horizonte\ \-\ MG",
"55133324", "Santos\ \-\ SP",
"55673524", "Três\ Lagoas\ \-\ MS",
"55114539", "Joanópolis\ \-\ SP",
"55663212", "Sorriso\ \-\ MT",
"55833051", "Campina\ Grande\ \-\ PB",
"55313372", "Minas\ Gerais",
"55543360", "Nova\ Boa\ Vista\ \-\ RS",
"55183217", "Presidente\ Prudente\ \-\ SP",
"55353544", "Ibiraci\ \-\ MG",
"55553554", "Miraguaí\ \-\ RS",
"55183582", "Parapuã\ \-\ SP",
"55543369", "Barra\ Funda\ \-\ RS",
"55513681", "Cidreira\ \-\ RS",
"55115486", "São\ Paulo\ \-\ SP",
"55433436", "Cambira\ \-\ PR",
"55183272", "Presidente\ Venceslau\ \-\ SP",
"5514323", "Bauru\ \-\ SP",
"55773434", "Planalto\ \-\ BA",
"55324009", "Juiz\ de\ Fora\ \-\ MG",
"55153244", "Piedade\ \-\ SP",
"55212103", "Rio\ de\ Janeiro\ \-\ RJ",
"55513618", "Barão\ \-\ RS",
"55143293", "Guaianás\ \-\ SP",
"55273333", "Vitória\ \-\ ES",
"55343236", "Uberlândia\ \-\ MG",
"55513077", "Canoas\ \-\ RS",
"55643546", "Itumbiara\ \-\ GO",
"55843388", "Major\ Sales\ \-\ RN",
"55513941", "Canoas\ \-\ RS",
"55633361", "Paraíso\ do\ Tocantins\ \-\ TO",
"55114751", "Suzano\ \-\ SP",
"55453037", "Cascavel\ \-\ PR",
"55373514", "Abaeté\ \-\ MG",
"55473621", "Canoinhas\ \-\ SC",
"55323453", "Dona\ Eusébia\ \-\ MG",
"5531320", "Minas\ Gerais",
"55212630", "Magé\ \-\ RJ",
"55663466", "Ponte\ Branca\ \-\ MT",
"55773671", "Sítio\ do\ Mato\ \-\ BA",
"55193833", "Paulínia\ \-\ SP",
"55333736", "Virgem\ da\ Lapa\ \-\ MG",
"55223844", "Porciúncula\ \-\ RJ",
"55173579", "Botelho\ \-\ SP",
"55673251", "Jardim\ \-\ MS",
"55893452", "Wall\ Ferraz\ \-\ PI",
"55473449", "São\ Francisco\ do\ Sul\ \-\ SC",
"55183742", "Ilha\ Solteira\ \-\ SP",
"55613454", "Sobradinho\ \-\ DF",
"55173817", "Severínia\ \-\ SP",
"55163829", "Ituverava\ \-\ SP",
"55883436", "Itatira\ \-\ CE",
"55323264", "Guarará\ \-\ MG",
"55483491", "Orleans\ \-\ SC",
"55753451", "Araças\ \-\ BA",
"55813000", "Recife\ \-\ PE",
"55213896", "Duque\ de\ Caxias\ \-\ RJ",
"5598325", "São\ Luís\ \-\ MA",
"55163403", "Franca\ \-\ SP",
"55114606", "Várzea\ Paulista\ \-\ SP",
"55553738", "Caiçara\ \-\ RS",
"55163820", "Orlândia\ \-\ SP",
"55113411", "São\ Paulo\ \-\ SP",
"55173280", "Olímpia\ \-\ SP",
"55613263", "Brasília\ \-\ DF",
"55693465", "Teixeirópolis\ \-\ RO",
"55143652", "Dois\ Córregos\ \-\ SP",
"55883555", "Jardim\ \-\ CE",
"55323295", "Passa\-Vinte\ \-\ MG",
"55313856", "São\ Domingos\ do\ Prata\ \-\ MG",
"55283539", "Itaoca\ \-\ ES",
"5513356", "São\ Vicente\ \-\ SP",
"55813492", "Olinda\ \-\ PE",
"55423618", "Virmond\ \-\ PR",
"55533011", "Pelotas\ \-\ RS",
"55674004", "Campo\ Grande\ \-\ MS",
"55543351", "David\ Canabarro\ \-\ RS",
"55873784", "São\ João\ \-\ PE",
"55923223", "Manaus\ \-\ AM",
"55883547", "Caririaçu\ \-\ CE",
"55193682", "São\ José\ do\ Rio\ Pardo\ \-\ SP",
"55163567", "Cajuru\ \-\ SP",
"55633359", "São\ Valério\ da\ Natividade\ \-\ TO",
"55613362", "Guará\ \-\ DF",
"55213078", "Rio\ de\ Janeiro\ \-\ RJ",
"55212186", "Nilópolis\ \-\ RJ",
"55923367", "Iranduba\ \-\ AM",
"55813658", "Glória\ do\ Goitá\ \-\ PE",
"55513753", "Roca\ Sales\ \-\ RS",
"55223053", "Cabo\ Frio\ \-\ RJ",
"55143766", "Arandu\ \-\ SP",
"55613301", "Brasília\ \-\ DF",
"55673260", "Alcinópolis\ \-\ MS",
"55112682", "São\ Paulo\ \-\ SP",
"55623877", "Goiânia\ \-\ GO",
"55323258", "Coronel\ Pacheco\ \-\ MG",
"55433547", "Figueira\ \-\ PR",
"55493257", "Frei\ Rogério\ \-\ SC",
"55673269", "Guia\ Lopes\ da\ Laguna\ \-\ MS",
"55743527", "Casa\ Nova\ \-\ BA",
"55463246", "Saudade\ do\ Iguaçu\ \-\ PR",
"55684007", "Rio\ Branco\ \-\ AC",
"55753469", "Cícero\ Dantas\ \-\ BA",
"55114683", "Juquitiba\ \-\ SP",
"55623584", "Aparecida\ de\ Goiânia\ \-\ GO",
"55443810", "Campo\ Mourão\ \-\ PR",
"55843526", "Porto\ do\ Mangue\ \-\ RN",
"55913817", "Nova\ Esperança\ do\ Piriá\ \-\ PA",
"55183373", "Tarumã\ \-\ SP",
"55413443", "Guaratuba\ \-\ PR",
"55493245", "Curitibanos\ \-\ SC",
"55433555", "Japira\ \-\ PR",
"55613468", "Brasília\ \-\ DF",
"55212743", "Teresópolis\ \-\ RJ",
"55112088", "Guarulhos\ \-\ SP",
"55623519", "Goiânia\ \-\ GO",
"55273232", "Vitória\ \-\ ES",
"55653396", "Alto\ Paraguai\ \-\ MT",
"55963421", "Amapá\ \-\ AP",
"55983015", "São\ Luís\ \-\ MA",
"55623517", "Goiânia\ \-\ GO",
"55222732", "Campos\ dos\ Goytacazes\ \-\ RJ",
"55983312", "São\ Luís\ \-\ MA",
"55623282", "Aparecida\ de\ Goiânia\ \-\ GO",
"55193431", "Tanquinho\ \-\ SP",
"55163983", "Luís\ Antônio\ \-\ SP",
"55643430", "Itumbiara\ \-\ GO",
"55832106", "João\ Pessoa\ \-\ PB",
"55913287", "Ananindeua\ \-\ PA",
"55693441", "Cacoal\ \-\ RO",
"55623572", "Goiânia\ \-\ GO",
"55433549", "Bandeirantes\ \-\ PR",
"55813021", "Paulista\ \-\ PE",
"55713083", "Salvador\ \-\ BA",
"55353343", "Baependi\ \-\ MG",
"55553353", "Guarani\ das\ Missões\ \-\ RS",
"55743529", "Andorinha\ \-\ BA",
"55543322", "Quinze\ de\ Novembro\ \-\ RS",
"55883663", "Bela\ Cruz\ \-\ CE",
"55983377", "Nova\ Olinda\ do\ Maranhão\ \-\ MA",
"55333414", "Divinolândia\ de\ Minas\ \-\ MG",
"55624011", "Goiânia\ \-\ GO",
"55433540", "Rancho\ Alegre\ \-\ PR",
"55114446", "Cajamar\ \-\ SP",
"55633357", "Formoso\ do\ Araguaia\ \-\ TO",
"55213610", "Niterói\ \-\ RJ",
"55863194", "Teresina\ \-\ PI",
"55793211", "Aracaju\ \-\ SE",
"55343654", "Santa\ Rosa\ da\ Serra\ \-\ MG",
"55923369", "Careiro\ da\ Várzea\ \-\ AM",
"55733534", "Jaguaquara\ \-\ BA",
"5545352", "Foz\ do\ Iguaçu\ \-\ PR",
"55883549", "Tarrafas\ \-\ CE",
"55643678", "Israelândia\ \-\ GO",
"55873772", "Correntes\ \-\ PE",
"55243401", "Barra\ Mansa\ \-\ RJ",
"55743258", "Baixa\ Grande\ \-\ BA",
"55673476", "Itaquiraí\ \-\ MS",
"55273758", "Mantenópolis\ \-\ ES",
"55473536", "Petrolândia\ \-\ SC",
"55482106", "Florianópolis\ \-\ SC",
"55753276", "Ribeira\ do\ Pombal\ \-\ BA",
"55983481", "Anapurus\ \-\ MA",
"55193674", "Casa\ Branca\ \-\ SP",
"55183705", "Guaraçaí\ \-\ SP",
"55115906", "São\ Paulo\ \-\ SP",
"55793288", "Areia\ Branca\ \-\ SE",
"55423635", "Laranjeiras\ do\ Sul\ \-\ PR",
"55283537", "Iconha\ \-\ ES",
"55633424", "Goianorte\ \-\ TO",
"55173512", "São\ José\ do\ Rio\ Preto\ \-\ SP",
"55893563", "Cristino\ Castro\ \-\ PI",
"55473455", "Joinville\ \-\ SC",
"55753328", "Ibiquera\ \-\ BA",
"55173819", "Poloni\ \-\ SP",
"55383744", "Jequitaí\ \-\ MG",
"55153291", "Araçoiaba\ da\ Serra\ \-\ SP",
"55373277", "Leandro\ Ferreira\ \-\ MG",
"55453378", "Toledo\ \-\ PR",
"55513432", "Gravataí\ \-\ RS",
"5512395", "Jacareí\ \-\ SP",
"55353591", "Monte\ Santo\ de\ Minas\ \-\ MG",
"55433016", "Rolândia\ \-\ PR",
"55212637", "Maricá\ \-\ RJ",
"55473447", "Araquari\ \-\ SC",
"55733613", "Itabuna\ \-\ BA",
"55833444", "São\ Bento\ \-\ PB",
"55453030", "Foz\ do\ Iguaçu\ \-\ PR",
"55373212", "Divinópolis\ \-\ MG",
"55453039", "Cascavel\ \-\ PR",
"55413603", "Itaperuçu\ \-\ PR",
"555131", "Rio\ Grande\ do\ Sul",
"55513635", "São\ Sebastião\ do\ Caí\ \-\ RS",
"55113374", "Mogi\ das\ Cruzes\ \-\ SP",
"55273764", "Pedro\ Canário\ \-\ ES",
"55243354", "Resende\ \-\ RJ",
"55115643", "São\ Paulo\ \-\ SP",
"55373755", "Morada\ Nova\ de\ Minas\ \-\ MG",
"55753422", "Alagoinhas\ \-\ BA",
"55313384", "Belo\ Horizonte\ \-\ MG",
"55843631", "Macaíba\ \-\ RN",
"55493202", "Joaçaba\ \-\ SC",
"55983213", "São\ Luís\ \-\ MA",
"55623383", "Britânia\ \-\ GO",
"55153542", "Capão\ Bonito\ \-\ SP",
"55383812", "Espinosa\ \-\ MG",
"55313637", "Santa\ Luzia\ \-\ MG",
"55353242", "Turvolândia\ \-\ MG",
"55553252", "São\ Francisco\ de\ Assis\ \-\ RS",
"55183284", "Rosana\ \-\ SP",
"55543367", "Três\ Palmeiras\ \-\ RS",
"55473652", "Itaiópolis\ \-\ SC",
"55943778", "Vila\ Residencial\ de\ Tucuruí\ \-\ PA",
"55114537", "Jundiaí\ \-\ SP",
"55893421", "Picos\ \-\ PI",
"55793483", "Nossa\ Senhora\ Aparecida\ \-\ SE",
"55613041", "Brasília\ \-\ DF",
"55713285", "Salvador\ \-\ BA",
"55533265", "Chuí\ \-\ RS",
"55823621", "Santana\ do\ Ipanema\ \-\ AL",
"55553317", "Santa\ Maria\ \-\ RS",
"55163266", "Borborema\ \-\ SP",
"55753289", "Pedro\ Alexandre\ \-\ BA",
"55913469", "Nova\ Timboteua\ \-\ PA",
"55673489", "Indápolis\ \-\ MS",
"55513544", "Taquara\ \-\ RS",
"55333267", "Aimorés\ \-\ MG",
"55313554", "Lavras\ Novas\ \-\ MG",
"55353012", "Itajubá\ \-\ MG",
"55833532", "Cajazeiras\ \-\ PB",
"55923581", "Manaus\ \-\ AM",
"55623553", "Hidrolândia\ \-\ GO",
"55114654", "Arujá\ \-\ SP",
"55673414", "Vila\ Vargas\ \-\ MS",
"55613578", "Brasília\ \-\ DF",
"55553372", "Santa\ Bárbara\ do\ Sul\ \-\ RS",
"55673480", "Paranhos\ \-\ MS",
"55333323", "Ubaporanga\ \-\ MG",
"55133208", "Santos\ \-\ SP",
"55543456", "Santa\ Tereza\ \-\ RS",
"55453258", "Ramilândia\ \-\ PR",
"55163412", "São\ Carlos\ \-\ SP",
"55463555", "Planalto\ \-\ PR",
"55843363", "Rafael\ Godeiro\ \-\ RN",
"5513347", "Praia\ Grande\ \-\ SP",
"55123961", "Jacareí\ \-\ SP",
"55313738", "São\ Brás\ do\ Suaçuí\ \-\ MG",
"55843227", "São\ Gonçalo\ do\ Amarante\ \-\ RN",
"55413679", "Campina\ Grande\ do\ Sul\ \-\ PR",
"55553506", "São\ Francisco\ de\ Assis\ \-\ RS",
"55413035", "São\ José\ dos\ Pinhais\ \-\ PR",
"55472102", "Blumenau\ \-\ SC",
"55183321", "Assis\ \-\ SP",
"55483532", "Praia\ Grande\ \-\ SC",
"55134002", "Santos\ \-\ SP",
"55454052", "Foz\ do\ Iguaçu\ \-\ PR",
"55273726", "Pancas\ \-\ ES",
"55463547", "Ampére\ \-\ PR",
"55493556", "Brunópolis\ \-\ SC",
"55513784", "Mato\ Leitão\ \-\ RS",
"55223084", "Macaé\ \-\ RJ",
"55813761", "Garanhuns\ \-\ PE",
"55513710", "Lajeado\ \-\ RS",
"55873846", "Triunfo\ \-\ PE",
"55114027", "Salto\ \-\ SP",
"55653325", "Tangará\ da\ Serra\ \-\ MT",
"55513719", "Santa\ Cruz\ do\ Sul\ \-\ RS",
"55443276", "Maringá\ \-\ PR",
"55333508", "Governador\ Valadares\ \-\ MG",
"55373424", "Córrego\ Danta\ \-\ MG",
"55853357", "General\ Sampaio\ \-\ CE",
"55843262", "João\ Câmara\ \-\ RN",
"55493435", "Ponte\ Serrada\ \-\ SC",
"55553743", "Jaboticaba\ \-\ RS",
"55613483", "Sobradinho\ \-\ DF",
"55383216", "Montes\ Claros\ \-\ MG",
"55114668", "Itapecerica\ da\ Serra\ \-\ SP",
"55115477", "Mogi\ das\ Cruzes\ \-\ SP",
"55993604", "São\ Pedro\ dos\ Crentes\ \-\ MA",
"55193848", "Louveira\ \-\ SP",
"55853345", "Pacatuba\ \-\ CE",
"55454009", "Cascavel\ \-\ PR",
"55114062", "São\ Paulo\ \-\ SP",
"55112897", "São\ Bernardo\ do\ Campo\ \-\ SP",
"55743675", "São\ José\ do\ Jacuípe\ \-\ BA",
"55543535", "Caxias\ do\ Sul\ \-\ RS",
"55973463", "Amaturá\ \-\ AM",
"5531331", "Minas\ Gerais",
"55733645", "Medeiros\ Neto\ \-\ BA",
"55663408", "São\ José\ do\ Couto\ \-\ MT",
"55443625", "Perobal\ \-\ PR",
"55673907", "Corumbá\ \-\ MS",
"55112848", "São\ Paulo\ \-\ SP",
"55833396", "Aroeiras\ \-\ PB",
"55623429", "Posse\ \-\ GO",
"55193897", "Hortolândia\ \-\ SP",
"55133829", "Registro\ \-\ SP",
"55753696", "Saubara\ \-\ BA",
"55483656", "Sangão\ \-\ SC",
"55443422", "Paranavaí\ \-\ PR",
"55313207", "Belo\ Horizonte\ \-\ MG",
"55115615", "São\ Paulo\ \-\ SP",
"55813759", "Santa\ Cruz\ do\ Capibaribe\ \-\ PE",
"55493632", "Tunápolis\ \-\ SC",
"55453264", "Medianeira\ \-\ PR",
"55633466", "Pedro\ Afonso\ \-\ TO",
"55113507", "São\ Paulo\ \-\ SP",
"55773623", "São\ Desidério\ \-\ BA",
"55123631", "Taubaté\ \-\ SP",
"5577308", "Vitória\ da\ Conquista\ \-\ BA",
"5561332", "Brasília\ \-\ DF",
"55623981", "Aparecida\ de\ Goiânia\ \-\ GO",
"55663302", "Rondonópolis\ \-\ MT",
"55333524", "Ladainha\ \-\ MG",
"55793263", "Capela\ \-\ SE",
"55115032", "São\ Paulo\ \-\ SP",
"55823293", "Paripueira\ \-\ AL",
"55623354", "Niquelândia\ \-\ GO",
"55813757", "Santa\ Maria\ do\ Cambucá\ \-\ PE",
"55373286", "São\ Sebastião\ do\ Oeste\ \-\ MG",
"55713601", "Candeias\ \-\ BA",
"55144103", "Jaú\ \-\ SP",
"55173276", "Engenheiro\ Balduíno\ \-\ SP",
"55493312", "Chapecó\ \-\ SC",
"55193592", "Santa\ Rita\ do\ Passa\ Quatro\ \-\ SP",
"55414107", "Curitiba\ \-\ PR",
"55823536", "Traipu\ \-\ AL",
"55123311", "Aparecida\ \-\ SP",
"55213781", "Itaguaí\ \-\ RJ",
"55813745", "Riacho\ das\ Almas\ \-\ PE",
"55123957", "São\ Silvestre\ \-\ SP",
"55133224", "Santos\ \-\ SP",
"55193899", "Monte\ Alegre\ do\ Sul\ \-\ SP",
"55493015", "Lages\ \-\ SC",
"55212693", "Nilópolis\ \-\ RJ",
"55373361", "Oliveira\ \-\ MG",
"55112592", "São\ Paulo\ \-\ SP",
"55543271", "São\ Jorge\ \-\ RS",
"55893473", "Massapê\ do\ Piauí\ \-\ PI",
"55693231", "Itapuã\ do\ Oeste\ \-\ RO",
"55454007", "Cascavel\ \-\ PR",
"55333251", "Santana\ do\ Paraíso\ \-\ MG",
"55533241", "Bagé\ \-\ RS",
"55113636", "São\ Paulo\ \-\ SP",
"55222030", "Campos\ dos\ Goytacazes\ \-\ RJ",
"55343832", "Patrocínio\ \-\ MG",
"55173467", "Nhandeara\ \-\ SP",
"55114593", "Itupeva\ \-\ SP",
"55423242", "Ipiranga\ \-\ PR",
"55183876", "Paulicéia\ \-\ SP",
"55543581", "Passo\ Fundo\ \-\ RS",
"55883611", "Sobral\ \-\ CE",
"55112771", "São\ Paulo\ \-\ SP",
"55314133", "Belo\ Horizonte\ \-\ MG",
"55114029", "Salto\ \-\ SP",
"55513717", "Santa\ Cruz\ do\ Sul\ \-\ RS",
"55414121", "Fazenda\ Rio\ Grande\ \-\ PR",
"55813626", "Goiana\ \-\ PE",
"55413081", "São\ José\ dos\ Pinhais\ \-\ PR",
"55463540", "Pranchita\ \-\ PR",
"55853302", "Apuiarés\ \-\ CE",
"55143026", "Ourinhos\ \-\ SP",
"55643996", "Itumbiara\ \-\ GO",
"55113180", "São\ Paulo\ \-\ SP",
"55513591", "São\ Leopoldo\ \-\ RS",
"55463549", "Realeza\ \-\ PR",
"55353432", "Córrego\ do\ Bom\ Jesus\ \-\ MG",
"55473148", "Navegantes\ \-\ SC",
"55183692", "Braúna\ \-\ SP",
"5522252", "Nova\ Friburgo\ \-\ RJ",
"55313715", "Cordisburgo\ \-\ MG",
"55413677", "Campo\ Magro\ \-\ PR",
"55843229", "São\ Gonçalo\ do\ Amarante\ \-\ RN",
"55862106", "Teresina\ \-\ PI",
"55112336", "São\ Paulo\ \-\ SP",
"55513772", "Arvorezinha\ \-\ RS",
"55943332", "São\ Domingos\ do\ Araguaia\ \-\ PA",
"55373359", "Arcos\ \-\ MG",
"55173422", "Votuporanga\ \-\ SP",
"55713627", "Camaçari\ \-\ BA",
"55983386", "Guimarães\ \-\ MA",
"55173044", "Bebedouro\ \-\ SP",
"55313828", "Minas\ Gerais",
"55843220", "Natal\ \-\ RN",
"55793362", "Cumbe\ \-\ SE",
"55933563", "Curuá\ \-\ PA",
"55663424", "Rondonópolis\ \-\ MT",
"55193336", "Rio\ Claro\ \-\ SP",
"55373690", "Divinópolis\ \-\ MG",
"55163954", "Santa\ Rosa\ de\ Viterbo\ \-\ SP",
"55673487", "Vila\ Marques\ \-\ MS",
"55653491", "Itiquira\ \-\ MT",
"55963326", "Ferreira\ Gomes\ \-\ AP",
"55443460", "Tamboara\ \-\ PR",
"55753287", "Abaré\ \-\ BA",
"55913467", "Ourém\ \-\ PA",
"55733661", "Vereda\ \-\ BA",
"55913746", "Bujaru\ \-\ PA",
"55443304", "Maringá\ \-\ PR",
"55113552", "São\ Paulo\ \-\ SP",
"55192114", "Limeira\ \-\ SP",
"55713054", "Camaçari\ \-\ BA",
"55133862", "Colonização\ \-\ SP",
"55893588", "Anísio\ de\ Abreu\ \-\ PI",
"553130", "Minas\ Gerais",
"55693346", "Chupinguaia\ \-\ RO",
"55853361", "Aquiraz\ \-\ CE",
"55174009", "São\ José\ do\ Rio\ Preto\ \-\ SP",
"55913822", "Quatipuru\ \-\ PA",
"55793257", "São\ Cristóvão\ \-\ SE",
"55733547", "Aiquara\ \-\ BA",
"55193499", "Santa\ Bárbara\ D\'Oeste\ \-\ SP",
"55643051", "Rio\ Verde\ \-\ GO",
"55423654", "Catuporanga\ \-\ PR",
"55964141", "Macapá\ \-\ AP",
"55383567", "Varjão\ de\ Minas\ \-\ MG",
"55443527", "Nova\ Cantu\ \-\ PR",
"55343338", "Uberaba\ \-\ MG",
"55123152", "Lorena\ \-\ SP",
"55643491", "Ipameri\ \-\ GO",
"55513668", "Palmares\ do\ Sul\ \-\ RS",
"5583324", "João\ Pessoa\ \-\ PB",
"55633685", "Combinado\ \-\ TO",
"55843286", "Passagem\ \-\ RN",
"5511407", "Diadema\ \-\ SP",
"55453304", "Cascavel\ \-\ PR",
"55283544", "Muniz\ Freire\ \-\ ES",
"55143014", "Bauru\ \-\ SP",
"55183323", "Assis\ \-\ SP",
"55543319", "Montauri\ \-\ RS",
"55843361", "Patu\ \-\ RN",
"55113402", "Atibaia\ \-\ SP",
"55633388", "Santa\ Rosa\ do\ Tocantins\ \-\ TO",
"55183267", "Santo\ Expedito\ \-\ SP",
"55543384", "Barros\ Cassal\ \-\ RS",
"55813689", "Jaqueira\ \-\ PE",
"55863247", "Castelo\ do\ Piauí\ \-\ PI",
"55173264", "Bálsamo\ \-\ SP",
"55483546", "Ermo\ \-\ SC",
"55153026", "Sorocaba\ \-\ SP",
"55163383", "Matão\ \-\ SP",
"55613213", "Brasília\ \-\ DF",
"55333321", "Caratinga\ \-\ MG",
"55623551", "Bela\ Vista\ de\ Goiás\ \-\ GO",
"55423027", "Ponta\ Grossa\ \-\ PR",
"55863298", "Angical\ do\ Piauí\ \-\ PI",
"5533", "Minas\ Gerais",
"55173453", "Cardoso\ \-\ SP",
"55532126", "Rio\ Grande\ \-\ RS",
"55663416", "General\ Carneiro\ \-\ MT",
"55433232", "Sertanópolis\ \-\ PR",
"55823623", "Olho\ d\'Água\ das\ Flores\ \-\ AL",
"55113308", "Jundiaí\ \-\ SP",
"55963314", "Santana\ \-\ AP",
"55114205", "Itapevi\ \-\ SP",
"55112490", "Bragança\ Paulista\ \-\ SP",
"55273555", "Mimoso\ do\ Sul\ \-\ ES",
"55923317", "Autazes\ \-\ AM",
"55313428", "Belo\ Horizonte\ \-\ MG",
"55623983", "Aparecida\ de\ Goiânia\ \-\ GO",
"55553271", "Júlio\ de\ Castilhos\ \-\ RS",
"55773449", "Malhada\ de\ Pedras\ \-\ BA",
"55323696", "Muriaé\ \-\ MG",
"55483437", "Criciúma\ \-\ SC",
"55123633", "Taubaté\ \-\ SP",
"55212025", "Rio\ de\ Janeiro\ \-\ RJ",
"55773621", "Cotegipe\ \-\ BA",
"55213667", "Duque\ de\ Caxias\ \-\ RJ",
"55173529", "Elisiário\ \-\ SP",
"55773440", "Piripá\ \-\ BA",
"55444007", "Maringá\ \-\ PR",
"55133216", "Santos\ \-\ SP",
"55333516", "Capelinha\ \-\ MG",
"55623643", "Goiânia\ \-\ GO",
"55473087", "Brusque\ \-\ SC",
"55353832", "Campo\ Belo\ \-\ MG",
"55173295", "Monte\ Aprazível\ \-\ SP",
"55373229", "Divinópolis\ \-\ MG",
"55353539", "São\ Sebastião\ do\ Paraíso\ \-\ MG",
"55513654", "Triunfo\ \-\ RS",
"55243335", "Rio\ Claro\ \-\ RJ",
"55843359", "Água\ Nova\ \-\ RN",
"55673574", "Inocência\ \-\ MS",
"55973461", "Santo\ Antônio\ do\ Içá\ \-\ AM",
"55313322", "Minas\ Gerais",
"5563322", "Palmas\ \-\ TO",
"55933557", "Faro\ \-\ PA",
"55713297", "Salvador\ \-\ BA",
"55513394", "Rio\ Grande\ do\ Sul",
"55163306", "São\ Carlos\ \-\ SP",
"55813136", "Caruaru\ \-\ PE",
"55193608", "São\ José\ do\ Rio\ Pardo\ \-\ SP",
"55443562", "Araruna\ \-\ PR",
"55813533", "Gravatá\ \-\ PE",
"55483084", "Florianópolis\ \-\ SC",
"55183222", "Presidente\ Prudente\ \-\ SP",
"55173258", "Bady\ Bassitt\ \-\ SP",
"55323356", "Ritápolis\ \-\ MG",
"55114784", "São\ Roque\ \-\ SP",
"55643604", "Mairipotaba\ \-\ GO",
"55152102", "Sorocaba\ \-\ SP",
"55833437", "Cajazeirinhas\ \-\ PB",
"55493646", "Cunha\ Porã\ \-\ SC",
"55193305", "Campinas\ \-\ SP",
"55112773", "São\ Paulo\ \-\ SP",
"55213543", "Rio\ de\ Janeiro\ \-\ RJ",
"55443453", "Santa\ Isabel\ do\ Ivaí\ \-\ PR",
"55833439", "Lagoa\ \-\ PB",
"55883613", "Sobral\ \-\ CE",
"55773498", "Formoso\ A\ \-\ BA",
"55114591", "Itupeva\ \-\ SP",
"55413575", "Curitiba\ \-\ PR",
"55123107", "Areias\ \-\ SP",
"55113445", "Itaquaquecetuba\ \-\ SP",
"55223234", "Campos\ dos\ Goitacazes\ \-\ RJ",
"55333253", "Belo\ Oriente\ \-\ MG",
"55663595", "Matupá\ \-\ MT",
"55533243", "Dom\ Pedrito\ \-\ RS",
"55443264", "Sarandi\ \-\ PR",
"55114772", "Jandira\ \-\ SP",
"55843697", "Parazinho\ \-\ RN",
"55693233", "Triunfo\ \-\ RO",
"55983362", "Icatu\ \-\ MA",
"55613435", "Brasília\ \-\ DF",
"55823542", "São\ Sebastião\ \-\ AL",
"55893471", "Várzea\ Grande\ \-\ PI",
"55673272", "Sidrolândia\ \-\ MS",
"55623567", "Goiânia\ \-\ GO",
"55773652", "Muquém\ de\ São\ Francisco\ \-\ BA",
"55543273", "Nova\ Bassano\ \-\ RS",
"55933559", "Trairão\ \-\ PA",
"5518390", "Presidente\ Prudente\ \-\ SP",
"55553794", "Planalto\ \-\ RS",
"55353537", "Fortaleza\ de\ Minas\ \-\ MG",
"55473080", "Blumenau\ \-\ SC",
"55212691", "Nilópolis\ \-\ RJ",
"55963116", "Santana\ \-\ AP",
"55183251", "Presidente\ Epitácio\ \-\ SP",
"55843357", "Coronel\ João\ Pessoa\ \-\ RN",
"55613632", "Formosa\ \-\ GO",
"55312146", "Sete\ Lagoas\ \-\ MG",
"55653247", "Reserva\ do\ Cabaçal\ \-\ MT",
"55163877", "Ribeirão\ Preto\ \-\ SP",
"55353722", "Poços\ de\ Caldas\ \-\ MG",
"55773455", "Caculé\ \-\ BA",
"55373227", "Nova\ Serrana\ \-\ MG",
"55823131", "Maceió\ \-\ AL",
"55193773", "Campinas\ \-\ SP",
"55163519", "Ribeirão\ Preto\ \-\ SP",
"55483430", "Criciúma\ \-\ SC",
"55553535", "Três\ de\ Maio\ \-\ RS",
"55313351", "Contagem\ \-\ MG",
"55983468", "São\ Benedito\ do\ Rio\ Preto\ \-\ MA",
"55542991", "Caxias\ do\ Sul\ \-\ RS",
"55444009", "Maringá\ \-\ PR",
"55683214", "Rio\ Branco\ \-\ AC",
"55663558", "Santa\ Terezinha\ \-\ MT",
"55243381", "Resende\ \-\ RJ",
"55833375", "Pedra\ Lavrada\ \-\ PB",
"55823291", "Barra\ de\ Santo\ Antônio\ \-\ AL",
"55843424", "Ipueira\ \-\ RN",
"55423236", "Ponta\ Grossa\ \-\ PR",
"55623486", "Colinas\ do\ Sul\ \-\ GO",
"55213660", "Magé\ \-\ RJ",
"55773447", "Cordeiros\ \-\ BA",
"55793261", "São\ Cristóvão\ \-\ SE",
"55483439", "Criciúma\ \-\ SC",
"55343846", "Douradoquara\ \-\ MG",
"55753030", "Feira\ de\ Santana\ \-\ BA",
"55115812", "São\ Paulo\ \-\ SP",
"55433534", "Santo\ Antônio\ da\ Platina\ \-\ PR",
"55853363", "Paraipaba\ \-\ CE",
"55373262", "Lagoa\ da\ Prata\ \-\ MG",
"55323577", "Rodeiro\ \-\ MG",
"55353446", "Albertina\ \-\ MG",
"55443258", "Munhoz\ de\ Melo\ \-\ PR",
"5545357", "Foz\ do\ Iguaçu\ \-\ PR",
"55643628", "Ouroana\ \-\ GO",
"55433066", "Londrina\ \-\ PR",
"55193448", "Ibitiruna\ \-\ SP",
"55323512", "Juiz\ de\ Fora\ \-\ MG",
"55643444", "Buriti\ Alegre\ \-\ GO",
"55193624", "São\ João\ da\ Boa\ Vista\ \-\ SP",
"55173562", "Tabapuã\ \-\ SP",
"5554320", "Caxias\ do\ Sul\ \-\ RS",
"55112342", "São\ Paulo\ \-\ SP",
"55943346", "Parauapebas\ \-\ PA",
"55453276", "Santa\ Helena\ \-\ PR",
"55543478", "Vista\ Alegre\ do\ Prata\ \-\ RS",
"55323287", "Senador\ Cortes\ \-\ MG",
"55633474", "Araguatins\ \-\ TO",
"55653053", "Várzea\ Grande\ \-\ MT",
"55983454", "Anajatuba\ \-\ MA",
"55183269", "Pirapozinho\ \-\ SP",
"55933502", "Castelo\ dos\ Sonhos\ \-\ PA",
"55863249", "São\ Miguel\ do\ Tapuio\ \-\ PI",
"55813687", "Bonito\ \-\ PE",
"55513236", "Rio\ Grande\ do\ Sul",
"55663564", "Confresa\ \-\ MT",
"55913181", "Belém\ \-\ PA",
"55863240", "Cabeceiras\ do\ Piauí\ \-\ PI",
"5551353", "Rio\ Grande\ do\ Sul",
"55913118", "Belém\ \-\ PA",
"55423915", "Carambeí\ \-\ PR",
"55623522", "Goiânia\ \-\ GO",
"55333352", "São\ Pedro\ dos\ Ferros\ \-\ MG",
"55513593", "Novo\ Hamburgo\ \-\ RS",
"5561325", "Brasília\ \-\ DF",
"55533342", "Pelotas\ \-\ RS",
"55613962", "Brasília\ \-\ DF",
"55733540", "Presidente\ Tancredo\ Neves\ \-\ BA",
"55543372", "Marcelino\ Ramos\ \-\ RS",
"55413083", "Curitiba\ \-\ PR",
"55733549", "Manoel\ Vitorino\ \-\ BA",
"55913732", "Acará\ \-\ PA",
"55793259", "Aracaju\ \-\ SE",
"55533045", "Rio\ Grande\ \-\ RS",
"55193497", "Limeira\ \-\ SP",
"55443529", "Campo\ Mourão\ \-\ PR",
"55373201", "Itaúna\ \-\ MG",
"55333582", "São\ José\ do\ Divino\ \-\ MG",
"55113413", "Itu\ \-\ SP",
"55613261", "Brasília\ \-\ DF",
"55714109", "Salvador\ \-\ BA",
"55433442", "Bom\ Sucesso\ \-\ PR",
"55483053", "Tubarão\ \-\ SC",
"55353365", "São\ Sebastião\ do\ Rio\ Verde\ \-\ MG",
"55143849", "Bairro\ de\ Santana\ \-\ SP",
"55883645", "Coreaú\ \-\ CE",
"55133879", "Barra\ do\ Braço\ \-\ SP",
"55112752", "São\ Paulo\ \-\ SP",
"55753453", "Itanagra\ \-\ BA",
"55143542", "Promissão\ \-\ SP",
"55472111", "Blumenau\ \-\ SC",
"55163665", "Altinópolis\ \-\ SP",
"55643532", "Itumbiara\ \-\ GO",
"55813548", "Itapissuma\ \-\ PE",
"55553367", "Santo\ Antônio\ das\ Missões\ \-\ RS",
"55193831", "Mogi\-Guaçu\ \-\ SP",
"55613386", "Núcleo\ Bandeirante\ \-\ DF",
"55773673", "Oliveira\ dos\ Brejinhos\ \-\ BA",
"55343242", "Araguari\ \-\ MG",
"5561337", "Ceilândia\ \-\ DF",
"55323451", "Astolfo\ Dutra\ \-\ MG",
"55883657", "Quiterianópolis\ \-\ CE",
"55753264", "Riachão\ do\ Jacuípe\ \-\ BA",
"55913484", "Santarém\ Novo\ \-\ PA",
"55473623", "Três\ Barras\ \-\ SC",
"55493329", "Chapecó\ \-\ SC",
"55633363", "Porto\ Nacional\ \-\ TO",
"55513769", "Rio\ Grande\ do\ Sul",
"55112831", "São\ Bernardo\ do\ Campo\ \-\ SP",
"55273331", "Vitória\ \-\ ES",
"55123424", "Taubaté\ \-\ SP",
"55663526", "Porto\ dos\ Gaúchos\ \-\ MT",
"55623954", "Goiânia\ \-\ GO",
"55813711", "Caruaru\ \-\ PE",
"55513760", "Colinas\ \-\ RS",
"55143291", "Domélia\ \-\ SP",
"55123042", "São\ José\ dos\ Campos\ \-\ SP",
"55833493", "Boa\ Ventura\ \-\ PB",
"55313162", "Betim\ \-\ MG",
"55513683", "Rio\ Grande\ do\ Sul",
"55883442", "Madalena\ \-\ CE",
"55754009", "Feira\ de\ Santana\ \-\ BA",
"55443675", "Cidade\ Gaúcha\ \-\ PR",
"55693525", "Vale\ do\ Anari\ \-\ RO",
"55623335", "Vianópolis\ \-\ GO",
"55443039", "Cianorte\ \-\ PR",
"55383615", "Manga\ \-\ MG",
"55212741", "Teresópolis\ \-\ RJ",
"55353654", "Gonçalves\ \-\ MG",
"55772102", "Vitória\ da\ Conquista\ \-\ BA",
"55513539", "Novo\ Hamburgo\ \-\ RS",
"55113571", "São\ Paulo\ \-\ SP",
"5513342", "Itanhaém\ \-\ SP",
"5531336", "Minas\ Gerais",
"55193709", "Campinas\ \-\ SP",
"55313581", "Nova\ Lima\ \-\ MG",
"55893557", "Nazaré\ do\ Piauí\ \-\ PI",
"55483298", "Florianópolis\ \-\ SC",
"55753258", "Araci\ \-\ BA",
"55163354", "Guarapiranga\ \-\ SP",
"55413629", "Tijucas\ do\ Sul\ \-\ PR",
"55843277", "Nísia\ Floresta\ \-\ RN",
"55193936", "Indaiatuba\ \-\ SP",
"55183371", "Maracaí\ \-\ SP",
"55114681", "Juquitiba\ \-\ SP",
"55114012", "Bom\ Jesus\ dos\ Perdões\ \-\ SP",
"55273776", "Barra\ de\ São\ Francisco\ \-\ ES",
"55333426", "Dores\ de\ Guanhães\ \-\ MG",
"55114618", "Jandira\ \-\ SP",
"55643656", "Caçu\ \-\ GO",
"55833255", "João\ Pessoa\ \-\ PB",
"55173484", "Monções\ \-\ SP",
"55733246", "Itapitanga\ \-\ BA",
"55613303", "Brasília\ \-\ DF",
"55313741", "Ouro\ Branco\ \-\ MG",
"55463232", "Coronel\ Vivida\ \-\ PR",
"55513751", "Encantado\ \-\ RS",
"55223051", "Macaé\ \-\ RJ",
"55317", "Minas\ Gerais",
"55673047", "Campo\ Grande\ \-\ MS",
"55923221", "Manaus\ \-\ AM",
"55453280", "São\ Luiz\ D\'Oeste\ \-\ PR",
"55483255", "Imbituba\ \-\ SC",
"55553025", "Santa\ Maria\ \-\ RS",
"55543353", "Caseiros\ \-\ RS",
"55833298", "Conde\ \-\ PB",
"55673495", "Caracol\ \-\ MS",
"55513606", "Rondinha\ Velha\ \-\ RS",
"55133383", "Guarujá\ \-\ SP",
"55483247", "São\ José\ \-\ SC",
"55553322", "Cruz\ Alta\ \-\ RS",
"55333373", "Santana\ do\ Manhuaçu\ \-\ MG",
"55993017", "Imperatriz\ \-\ MA",
"55423446", "Prudentópolis\ \-\ PR",
"55113158", "São\ Paulo\ \-\ SP",
"55512104", "Porto\ Alegre\ \-\ RS",
"55983483", "Magalhães\ de\ Almeida\ \-\ MA",
"55112707", "São\ Paulo\ \-\ SP",
"55493362", "Novo\ Horizonte\ \-\ SC",
"55543207", "São\ Brás\ \-\ RS",
"55413054", "Campo\ Largo\ \-\ PR",
"55853123", "Caucaia\ \-\ CE",
"55753181", "Alagoinhas\ \-\ BA",
"55653925", "Cuiabá\ \-\ MT",
"55993072", "Imperatriz\ \-\ MA",
"55153392", "Itapetininga\ \-\ SP",
"55453287", "Boa\ Vista\ da\ Aparecida\ \-\ PR",
"55463534", "São\ Jorge\ D\'Oeste\ \-\ PR",
"55323276", "Mar\ de\ Espanha\ \-\ MG",
"55433661", "Alvorada\ do\ Sul\ \-\ PR",
"5511587", "São\ Paulo\ \-\ SP",
"55793213", "Aracaju\ \-\ SE",
"55813676", "Tamandaré\ \-\ PE",
"5554331", "Passo\ Fundo\ \-\ RS",
"55883661", "Acaraú\ \-\ CE",
"55323746", "Espera\ Feliz\ \-\ MG",
"55353341", "Caxambu\ \-\ MG",
"55553351", "Pirapó\ \-\ RS",
"55313535", "Mateus\ Leme\ \-\ MG",
"5567", "Mato\ Grosso\ do\ Sul",
"55693443", "Cacoal\ \-\ RO",
"55713612", "Salvador\ \-\ BA",
"55843279", "Extremoz\ \-\ RN",
"55413627", "Fazenda\ Rio\ Grande\ \-\ PR",
"55163981", "Pradópolis\ \-\ SP",
"55893550", "Jerumenha\ \-\ PI",
"55123302", "São\ José\ dos\ Campos\ \-\ SP",
"55223022", "Itaperuna\ \-\ RJ",
"55493301", "Concórdia\ \-\ SC",
"55513722", "Cachoeira\ do\ Sul\ \-\ RS",
"55173472", "Nhandeara\ \-\ SP",
"55713677", "Mata\ de\ São\ João\ \-\ BA",
"55513537", "Porto\ Alegre\ \-\ RS",
"55543568", "Ponte\ Preta\ \-\ RS",
"55193707", "Campinas\ \-\ SP",
"55893559", "Itaueira\ \-\ PI",
"55313878", "Contagem\ \-\ MG",
"55473542", "Agronômica\ \-\ SC",
"55963423", "Calçoene\ \-\ AP",
"55613504", "Cristalina\ \-\ GO",
"55273082", "Vitória\ \-\ ES",
"55613043", "Brasília\ \-\ DF",
"5511471", "São\ Roque\ \-\ SP",
"55273385", "Serra\ \-\ ES",
"55112885", "Guarulhos\ \-\ SP",
"55323422", "Cataguases\ \-\ MG",
"55313765", "Minas\ Gerais",
"55663902", "Rondonópolis\ \-\ MT",
"55623381", "Estrela\ do\ Norte\ \-\ GO",
"55313096", "Ipatinga\ \-\ MG",
"5511345", "São\ Paulo\ \-\ SP",
"55753501", "Paulo\ Afonso\ \-\ BA",
"55413662", "Cerro\ Azul\ \-\ PR",
"55513446", "Viamão\ \-\ RS",
"55513767", "Tunas\ \-\ RS",
"55313456", "Minas\ Gerais",
"55115641", "São\ Paulo\ \-\ SP",
"55883659", "Croatá\ \-\ CE",
"55413601", "Pinhais\ \-\ PR",
"55493327", "Nova\ Itaberaba\ \-\ SC",
"5592363", "Manaus\ \-\ AM",
"55533238", "São\ José\ do\ Norte\ \-\ RS",
"55343003", "Uberlândia\ \-\ MG",
"55133519", "Santos\ \-\ SP",
"55413465", "Morretes\ \-\ PR",
"55433399", "Tamarana\ \-\ PR",
"55623412", "Goiânia\ \-\ GO",
"55353593", "Jacuí\ \-\ MG",
"55553369", "São\ Pedro\ do\ Butiá\ \-\ RS",
"55212765", "Nova\ Iguaçu\ \-\ RJ",
"55222106", "Macaé\ \-\ RJ",
"55883650", "Carnaubal\ \-\ CE",
"55793377", "Ilha\ das\ Flores\ \-\ SE",
"55133877", "Santos\ \-\ SP",
"55733688", "Piraí\ do\ Norte\ \-\ BA",
"55153293", "Sorocaba\ \-\ SP",
"5515323", "Sorocaba\ \-\ SP",
"55493454", "Xavantina\ \-\ SC",
"55333284", "Frei\ Inocêncio\ \-\ MG",
"55193885", "Indaiatuba\ \-\ SP",
"55353236", "São\ Bento\ Abade\ \-\ MG",
"55143847", "Itatinga\ \-\ SP",
"55943385", "Vila\ Santa\ Fé\ \-\ PA",
"55163488", "São\ Simão\ \-\ SP",
"55823344", "Maceió\ \-\ AL",
"55913823", "Americano\ \-\ PA",
"55113178", "São\ Paulo\ \-\ SP",
"55242433", "Barra\ do\ Piraí\ \-\ RJ",
"55133507", "Mongaguá\ \-\ SP",
"55123153", "Lorena\ \-\ SP",
"55813762", "Garanhuns\ \-\ PE",
"55112086", "Guarulhos\ \-\ SP",
"55823425", "Taquarana\ \-\ AL",
"55143768", "Jurumirim\ \-\ SP",
"55183322", "Assis\ \-\ SP",
"55483531", "Morro\ Grande\ \-\ SC",
"55993492", "Lagoa\ do\ Mato\ \-\ MA",
"55323256", "Aracitaba\ \-\ MG",
"55313895", "Teixeiras\ \-\ MG",
"55313111", "São\ Joaquim\ de\ Bicas\ \-\ MG",
"55113820", "Guarulhos\ \-\ SP",
"55163411", "São\ Carlos\ \-\ SP",
"55513134", "São\ Leopoldo\ \-\ RS",
"55113403", "Bragança\ Paulista\ \-\ SP",
"55714119", "Candeias\ \-\ BA",
"55123962", "Jacareí\ \-\ SP",
"55453545", "Foz\ do\ Iguaçu\ \-\ PR",
"55133268", "Bertioga\ \-\ SP",
"55823028", "Maceió\ \-\ AL",
"55143496", "Tupã\ \-\ SP",
"55713645", "Pojuca\ \-\ BA",
"55163382", "Matão\ \-\ SP",
"55613212", "Brasília\ \-\ DF",
"55153339", "Sorocaba\ \-\ SP",
"55153330", "Sorocaba\ \-\ SP",
"5511518", "São\ Paulo\ \-\ SP",
"55813656", "Orobó\ \-\ PE",
"55353011", "Alfenas\ \-\ MG",
"55183644", "Birigui\ \-\ SP",
"55833531", "Cajazeiras\ \-\ PB",
"55923582", "Manaus\ \-\ AM",
"55873833", "Venturosa\ \-\ PE",
"55313858", "Dionísio\ \-\ MG",
"55373329", "Formiga\ \-\ MG",
"55173395", "Terra\ Roxa\ \-\ SP",
"55194126", "Itapira\ \-\ SP",
"55633483", "Bom\ Jesus\ do\ Tocantins\ \-\ TO",
"55653349", "Campo\ Novo\ do\ Parecis\ \-\ MT",
"55893570", "Baixa\ Grande\ do\ Ribeiro\ \-\ PI",
"55843259", "Barcelona\ \-\ RN",
"55823622", "São\ José\ da\ Tapera\ \-\ AL",
"55333221", "Governador\ Valadares\ \-\ MG",
"55213774", "Duque\ de\ Caxias\ \-\ RJ",
"55313508", "Belo\ Horizonte\ \-\ MG",
"55883438", "Choró\ \-\ CE",
"55663301", "Rondonópolis\ \-\ MT",
"55493631", "São\ Miguel\ do\ Oeste\ \-\ SC",
"55323314", "Juiz\ de\ Fora\ \-\ MG",
"55114608", "Francisco\ Morato\ \-\ SP",
"55123632", "Taubaté\ \-\ SP",
"55353833", "Candeias\ \-\ MG",
"55443421", "Paranavaí\ \-\ PR",
"55853329", "Aratuba\ \-\ CE",
"55433035", "Cambé\ \-\ PR",
"55623642", "Goiânia\ \-\ GO",
"55443640", "Esperança\ Nova\ \-\ PR",
"55663468", "Água\ Boa\ \-\ MT",
"55333738", "Francisco\ Badaró\ \-\ MG",
"55443649", "Palotina\ \-\ PR",
"55643597", "Itumbiara\ \-\ GO",
"55853320", "Paramoti\ \-\ CE",
"5511347", "São\ Paulo\ \-\ SP",
"5531348", "Belo\ Horizonte\ \-\ MG",
"55163176", "Furnas\ Vila\ Residencial\ \-\ SP",
"55963214", "Macapá\ \-\ AP",
"55733629", "São\ João\ do\ Paraíso\ \-\ BA",
"55313323", "Belo\ Horizonte\ \-\ MG",
"55743634", "Caldeirão\ Grande\ \-\ BA",
"55313864", "Carmésia\ \-\ MG",
"55213855", "Rio\ de\ Janeiro\ \-\ RJ",
"55513616", "Rio\ Grande\ do\ Sul",
"55623445", "Damianópolis\ \-\ GO",
"55613107", "Brasília\ \-\ DF",
"55793648", "Pedrinhas\ \-\ SE",
"55112784", "São\ Paulo\ \-\ SP",
"55983229", "Raposa\ \-\ MA",
"55383523", "Felício\ dos\ Santos\ \-\ MG",
"55443563", "Farol\ \-\ PR",
"55114061", "Diadema\ \-\ SP",
"55693534", "Alto\ Paraíso\ \-\ RO",
"55112719", "São\ Paulo\ \-\ SP",
"55643548", "Itumbiara\ \-\ GO",
"55843386", "Tenente\ Ananias\ \-\ RN",
"55313267", "Belo\ Horizonte\ \-\ MG",
"55193544", "Araras\ \-\ SP",
"55213847", "Rio\ de\ Janeiro\ \-\ RJ",
"55223533", "Vila\ Velha\ \-\ ES",
"55324141", "Juiz\ de\ Fora\ \-\ MG",
"55183223", "Presidente\ Prudente\ \-\ SP",
"55623457", "Monte\ Alegre\ de\ Goiás\ \-\ GO",
"55183367", "Borá\ \-\ SP",
"55623097", "Aparecida\ de\ Goiânia\ \-\ GO",
"55543284", "Caxias\ do\ Sul\ \-\ RS",
"55543210", "Passo\ Fundo\ \-\ RS",
"55843261", "Maxaranguape\ \-\ RN",
"55863347", "Batalha\ \-\ PI",
"55623099", "Anápolis\ \-\ GO",
"55443452", "Santa\ Cruz\ de\ Monte\ Castelo\ \-\ PR",
"55112772", "São\ Paulo\ \-\ SP",
"55813194", "Recife\ \-\ PE",
"55982016", "São\ Luís\ \-\ MA",
"55483626", "Tubarão\ \-\ SC",
"55863340", "Matias\ Olímpio\ \-\ PI",
"55343831", "Patrocínio\ \-\ MG",
"55213849", "Rio\ de\ Janeiro\ \-\ RJ",
"55354104", "Lavras\ \-\ MG",
"55623459", "Alto\ Paraíso\ de\ Goiás\ \-\ GO",
"55114773", "Itapevi\ \-\ SP",
"55112717", "São\ Paulo\ \-\ SP",
"55983363", "Morros\ \-\ MA",
"55333252", "Joanésia\ \-\ MG",
"55313269", "Belo\ Horizonte\ \-\ MG",
"55493482", "Concórdia\ \-\ SC",
"55883677", "Sobral\ \-\ CE",
"55533242", "Bagé\ \-\ RS",
"55112591", "São\ Paulo\ \-\ SP",
"55543272", "Guabiju\ \-\ RS",
"55313260", "Minas\ Gerais",
"55373301", "Divinópolis\ \-\ MG",
"55343215", "Uberlândia\ \-\ MG",
"55823543", "Teotônio\ Vilela\ \-\ AL",
"55473056", "Balneário\ Camboriú\ \-\ SC",
"55443647", "Maripá\ \-\ PR",
"5571210", "Salvador\ \-\ BA",
"55193717", "Limeira\ \-\ SP",
"55613633", "Padre\ Bernardo\ \-\ GO",
"55733627", "Santa\ Cruz\ da\ Vitória\ \-\ BA",
"55493311", "Chapecó\ \-\ SC",
"55114243", "Cotia\ \-\ SP",
"55213131", "Rio\ de\ Janeiro\ \-\ RJ",
"55712203", "Salvador\ \-\ BA",
"55713602", "Candeias\ \-\ BA",
"55443655", "Cafezal\ do\ Sul\ \-\ PR",
"55883415", "Palhano\ \-\ CE",
"55314004", "Belo\ Horizonte\ \-\ MG",
"55193772", "Campinas\ \-\ SP",
"55753326", "Boa\ Vista\ do\ Tupim\ \-\ BA",
"55843504", "Caicó\ \-\ RN",
"55115031", "São\ Paulo\ \-\ SP",
"55453376", "Nova\ Concórdia\ \-\ PR",
"55533717", "Rio\ Grande\ \-\ RS",
"55273756", "Barra\ de\ São\ Francisco\ \-\ ES",
"55623605", "Goiânia\ \-\ GO",
"55843257", "Lagoa\ Salgada\ \-\ RN",
"55482108", "Florianópolis\ \-\ SC",
"55753278", "Cícero\ Dantas\ \-\ BA",
"55653347", "Assari\ \-\ MT",
"55853362", "Aquiraz\ \-\ CE",
"55952121", "Boa\ Vista\ \-\ RR",
"55183351", "Palmital\ \-\ SP",
"55623461", "Pires\ do\ Rio\ \-\ GO",
"55115908", "São\ Paulo\ \-\ SP",
"55893577", "Monte\ Alegre\ do\ Piauí\ \-\ PI",
"55183917", "Presidente\ Prudente\ \-\ SP",
"55733662", "Jucuruçu\ \-\ BA",
"5549322", "Lages\ \-\ SC",
"55463525", "Marmeleiro\ \-\ PR",
"55313251", "Santana\ do\ Paraíso\ \-\ MG",
"55653492", "Ouro\ Branco\ \(Antiga\ Raposolândia\)\ \-\ MT",
"55843245", "Vila\ Flor\ \-\ RN",
"55493526", "Jaborá\ \-\ SC",
"55114497", "Jundiaí\ \-\ SP",
"55833275", "Serraria\ \-\ PB",
"55653052", "Cuiabá\ \-\ MT",
"55643676", "Cachoeira\ de\ Goiás\ \-\ GO",
"55173563", "Cajobi\ \-\ SP",
"55793361", "Amparo\ de\ São\ Francisco\ \-\ SE",
"55673478", "Tacuru\ \-\ MS",
"55173421", "Votuporanga\ \-\ SP",
"55483275", "Rancho\ Queimado\ \-\ SC",
"55853468", "Fortaleza\ \-\ CE",
"55653695", "Várzea\ Grande\ \-\ MT",
"55714117", "Simões\ Filho\ \-\ BA",
"55793302", "Aracaju\ \-\ SE",
"55553921", "Santa\ Maria\ \-\ RS",
"55513771", "Rio\ Grande\ do\ Sul",
"55943331", "São\ Geraldo\ do\ Araguaia\ \-\ PA",
"55114448", "Cajamar\ \-\ SP",
"55212251", "São\ Gonçalo\ \-\ RJ",
"55413385", "São\ José\ dos\ Pinhais\ \-\ PR",
"55353431", "Cambuí\ \-\ MG",
"55333353", "Pingo\-D\'Água\ \-\ MG",
"55513592", "São\ Leopoldo\ \-\ RS",
"55613963", "Brasília\ \-\ DF",
"55623523", "Goiânia\ \-\ GO",
"55983262", "São\ Luís\ \-\ MA",
"55453559", "Itaipulândia\ \-\ PR",
"55183691", "Buritama\ \-\ SP",
"55114624", "Osasco\ \-\ SP",
"55553414", "Uruguaiana\ \-\ RS",
"55453550", "São\ Jorge\ \-\ PR",
"55133500", "Santos\ \-\ SP",
"55414122", "Curitiba",
"55543373", "São\ Valentim\ \-\ RS",
"55853301", "Beberibe\ \-\ CE",
"55913733", "Murucupi\ \-\ PA",
"55313524", "Belo\ Horizonte\ \-\ MG",
"55483052", "Tubarão\ \-\ SC",
"55543464", "Garibaldi\ \-\ RS",
"55633468", "Couto\ de\ Magalhães\ \-\ TO",
"55413555", "Campo\ Largo\ \-\ PR",
"5592", "Amazonas",
"55113412", "São\ Bernardo\ do\ Campo\ \-\ SP",
"55333583", "Pescador\ \-\ MG",
"55513485", "Viamão\ \-\ RS",
"55773617", "Baianópolis\ \-\ BA",
"55163521", "Sertãozinho\ \-\ SP",
"55143004", "Bauru\ \-\ SP",
"55243324", "Barra\ Mansa\ \-\ RJ",
"55112753", "São\ Paulo\ \-\ SP",
"55753452", "Itatim\ \-\ BA",
"55993531", "Estreito\ \-\ MA",
"55483355", "Imbituba\ \-\ SC",
"55813604", "Surubim\ \-\ PE",
"55143543", "Promissão\ \-\ SP",
"55353294", "Alterosa\ \-\ MG",
"55833398", "Itatuba\ \-\ PB",
"55343243", "Amanhece\ \-\ MG",
"55543253", "Jaquirana\ \-\ RS",
"55893451", "Santo\ Inácio\ do\ Piauí\ \-\ PI",
"55643533", "Itumbiara\ \-\ GO",
"55183741", "Castilho\ \-\ SP",
"55493564", "Rio\ das\ Antas\ \-\ SC",
"55413547", "Lapa\ \-\ PR",
"55473622", "Canoinhas\ \-\ SC",
"55753698", "Santa\ Brígida\ \-\ BA",
"55483658", "Braço\ do\ Norte\ \-\ SC",
"55633301", "Gurupi\ \-\ TO",
"55773475", "Rio\ de\ Contas\ \-\ BA",
"55333743", "Felisburgo\ \-\ MG",
"55193846", "Vinhedo\ \-\ SP",
"55833347", "Gado\ Bravo\ \-\ PB",
"55473344", "Itajaí\ \-\ SC",
"55613359", "Samambaia\ Sul\ \-\ DF",
"55633362", "Dois\ Irmãos\ do\ Tocantins\ \-\ TO",
"55183271", "Presidente\ Venceslau\ \-\ SP",
"55753358", "Coronel\ Octaviano\ Alves\ \-\ BA",
"55163254", "Guariroba\ \-\ SP",
"55843377", "Portalegre\ \-\ RN",
"55663406", "Torixoréu\ \-\ MT",
"55513088", "Lajeado\ \-\ RS",
"55753647", "Aratuípe\ \-\ BA",
"55183581", "Flórida\ Paulista\ \-\ SP",
"55513011", "Lajeado\ \-\ RS",
"55833355", "São\ João\ do\ Cariri\ \-\ PB",
"55833492", "Monte\ Horebe\ \-\ PB",
"55513682", "Balneário\ Pinhal\ \-\ RS",
"55383218", "Montes\ Claros\ \-\ MG",
"55663578", "Itanhangá\ \-\ MT",
"55114666", "Itapecerica\ da\ Serra\ \-\ SP",
"55663211", "Sinop\ \-\ MT",
"55163463", "Araraquara\ \-\ SP",
"55653275", "Glória\ D\'Oeste\ \-\ MT",
"5511356", "São\ Paulo\ \-\ SP",
"55883443", "Quixeré\ \-\ CE",
"55313371", "Minas\ Gerais",
"5512392", "São\ José\ dos\ Campos\ \-\ SP",
"55313034", "Contagem\ \-\ MG",
"55973412", "Tabatinga\ \-\ AM",
"55493558", "Ipira\ \-\ SC",
"55112618", "São\ Paulo\ \-\ SP",
"55213434", "Rio\ de\ Janeiro\ \-\ RJ",
"55873848", "Custódia\ \-\ PE",
"55483664", "Florianópolis\ \-\ SC",
"55115845", "São\ Paulo\ \-\ SP",
"55443278", "Ourizona\ \-\ PR",
"55114013", "Itu\ \-\ SP",
"55633454", "Aguiarnópolis\ \-\ TO",
"55443588", "Vidigal\ \-\ PR",
"55453256", "Mercedes\ \-\ PR",
"55543458", "Tuiutí\ \-\ RS",
"55313736", "Desterro\ de\ Entre\ Rios\ \-\ MG",
"55613302", "Sobradinho\ \-\ DF",
"55653626", "Cuiabá\ \-\ MT",
"55222785", "Cardoso\ Moreira\ \-\ RJ",
"55273728", "Vila\ Valério\ \-\ ES",
"55613361", "Guará\ \-\ DF",
"55643689", "Diorama\ \-\ GO",
"55463233", "Coronel\ Vivida\ \-\ PR",
"55123184", "Cruzeiro\ \-\ SP",
"55353265", "Três\ Pontas\ \-\ MG",
"55733231", "Ilhéus\ \-\ BA",
"55643614", "Santa\ Helena\ de\ Goiás\ \-\ GO",
"55643680", "Nazário\ \-\ GO",
"55123119", "Campos\ de\ Cunha\ \-\ SP",
"55193681", "São\ José\ do\ Rio\ Pardo\ \-\ SP",
"55333317", "Conceição\ de\ Ipanema\ \-\ MG",
"55983474", "Duque\ Bacelar\ \-\ MA",
"55813491", "Olinda\ \-\ PE",
"55833664", "Santa\ Rita\ \-\ PB",
"55793279", "Nossa\ Senhora\ do\ Socorro\ \-\ SE",
"55543352", "São\ José\ do\ Ouro\ \-\ RS",
"55553267", "Ivorá\ \-\ RS",
"55753364", "Iraquara\ \-\ BA",
"55153565", "Itaporanga\ \-\ SP",
"55743559", "Pindobaçu\ \-\ BA",
"55543055", "Bento\ Gonçalves\ \-\ RS",
"55133382", "Guarujá\ \-\ SP",
"55613408", "Brasília\ \-\ DF",
"55733285", "Potiraguá\ \-\ BA",
"55493363", "Bom\ Jesus\ do\ Oeste\ \-\ SC",
"55643071", "Rio\ Verde\ \-\ GO",
"55323228", "Juiz\ de\ Fora\ \-\ MG",
"551121", "São\ Paulo\ \-\ SP",
"55793277", "Carmópolis\ \-\ SE",
"55983482", "Buriti\ \-\ MA",
"55553269", "São\ João\ do\ Polêsine\ \-\ RS",
"55143344", "Ipaussu\ \-\ SP",
"55222559", "São\ Sebastião\ do\ Alto\ \-\ RJ",
"55123117", "São\ José\ do\ Barreiro\ \-\ SP",
"55993073", "Imperatriz\ \-\ MA",
"55433525", "Jacarezinho\ \-\ PR",
"55213089", "Rio\ de\ Janeiro\ \-\ RJ",
"55873771", "Bom\ Conselho\ \-\ PE",
"55514104", "Canoas\ \-\ RS",
"55883603", "Cruz\ \-\ CE",
"55143425", "Marília\ \-\ SP",
"55643687", "Córrego\ do\ Ouro\ \-\ GO",
"55993626", "Pedreiras\ \-\ MA",
"55733575", "Arraial\ d\'Ajuda\ \-\ BA",
"55114707", "Jandira\ \-\ SP",
"5511405", "Diadema\ \-\ SP",
"55543321", "Erechim\ \-\ RS",
"55283155", "Cachoeiro\ de\ Itapemirim\ \-\ ES",
"55153653", "Capão\ Bonito\ \-\ SP",
"55623366", "Mara\ Rosa\ \-\ GO",
"55624012", "Goiânia\ \-\ GO",
"5554", "Rio\ Grande\ do\ Sul",
"55693442", "Rolim\ de\ Moura\ \-\ RO",
"55893467", "Lagoa\ do\ Sítio\ \-\ PI",
"55983388", "Peri\ Mirim\ \-\ MA",
"55163509", "São\ Carlos\ \-\ SP",
"55883525", "Antonina\ do\ Norte\ \-\ CE",
"55313826", "Minas\ Gerais",
"55513723", "Cachoeira\ do\ Sul\ \-\ RS",
"55983311", "São\ Luís\ \-\ MA",
"55323559", "Visconde\ do\ Rio\ Branco\ \-\ MG",
"55813628", "Limoeiro\ \-\ PE",
"55643998", "Itumbiara\ \-\ GO",
"55963422", "Tartarugalzinho\ \-\ AP",
"55473543", "Rio\ do\ Oeste\ \-\ SC",
"55113638", "São\ Paulo\ \-\ SP",
"55673221", "Três\ Lagoas\ \-\ MS",
"55383235", "Capitão\ Enéas\ \-\ MG",
"55893422", "Picos\ \-\ PI",
"55943787", "Tucuruí\ \-\ PA",
"55542621", "Bento\ Gonçalves\ \-\ RS",
"5554321", "Caxias\ do\ Sul\ \-\ RS",
"55143667", "Itaju\ \-\ SP",
"55353241", "São\ Gonçalo\ do\ Sapucaí\ \-\ MG",
"55553251", "Santiago\ \-\ RS",
"55323423", "Cataguases\ \-\ MG",
"55653531", "Sinop\ \-\ MT",
"55193965", "Hortolândia\ \-\ SP",
"55883686", "Catunda\ \-\ CE",
"55843379", "Francisco\ Dantas\ \-\ RN",
"55663903", "Alta\ Floresta\ \-\ MT",
"5598322", "São\ Luís\ \-\ MA",
"55343061", "Patos\ de\ Minas\ \-\ MG",
"55513674", "Tavares\ \-\ RS",
"55753649", "Elísio\ Medrado\ \-\ BA",
"55383811", "Monte\ Azul\ \-\ MG",
"55222561", "Santa\ Maria\ Madalena\ \-\ RJ",
"55753421", "Alagoinhas\ \-\ BA",
"55613357", "Samambaia\ Sul\ \-\ DF",
"55163859", "Orlândia\ \-\ SP",
"55413663", "Colombo\ \-\ PR",
"55313480", "Minas\ Gerais",
"55313414", "Minas\ Gerais",
"55553524", "Crissiumal\ \-\ RS",
"55513431", "Gravataí\ \-\ RS",
"55163114", "Araraquara\ \-\ SP",
"55613697", "Taboquinha\ \-\ GO",
"55122139", "São\ José\ dos\ Campos\ \-\ SP",
"55843435", "Florânia\ \-\ RN",
"55313489", "Minas\ Gerais",
"55213716", "São\ Gonçalo\ \-\ RJ",
"55773684", "Roda\ Velha\ \-\ BA",
"55153292", "Salto\ de\ Pirapora\ \-\ SP",
"55114147", "Itapecerica\ da\ Serra\ \-\ SP",
"55373288", "Araújos\ \-\ MG",
"55323376", "São\ Tiago\ \-\ MG",
"55793313", "Feira\ Nova\ \-\ SE",
"55933512", "Santarém\ \-\ PA",
"55773619", "Catolândia\ \-\ BA",
"55173278", "União\ Paulista\ \-\ SP",};

    sub new {
      my $class = shift;
      my $number = shift;
      $number =~ s/(^\+55|\D)//g;
      my $self = bless({ country_code => '55', number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self if ($self->is_valid());
      my $prefix = qr/^(?:(?:0|90)(?:(1[245]|2[1-35]|31|4[13]|[56]5|99)(\d{10,11}))?)/;
      my @matches = $number =~ /$prefix/;
      if (defined $matches[-1]) {
        no warnings 'uninitialized';
        $number =~ s/$prefix/$2/;
      }
      else {
        $number =~ s/$prefix//;
      }
      $self = bless({ country_code => '55', number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self->is_valid() ? $self : undef;
    }
1;