# automatically generated file, don't edit



# Copyright 2011 David Cantrell, derived from data from libphonenumber
# http://code.google.com/p/libphonenumber/
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
package Number::Phone::StubCountry::JP;
use base qw(Number::Phone::StubCountry);

use strict;
use warnings;
use utf8;
our $VERSION = 1.20220903144941;

my $formatters = [
                {
                  'format' => '$1-$2',
                  'intl_format' => 'NA',
                  'leading_digits' => '00777[01]',
                  'pattern' => '(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '
            (?:
              12|
              57|
              99
            )0
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{3})(\\d{3})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '
            1(?:
              267|
              3(?:
                7[247]|
                9[278]
              )|
              466|
              5(?:
                47|
                58|
                64
              )|
              6(?:
                3[245]|
                48|
                5[4-68]
              )
            )|
            499[2468]|
            5(?:
              769|
              979[2-69]
            )|
            7468|
            8(?:
              3(?:
                8[7-9]|
                96[2457-9]
              )|
              477|
              51[2-9]|
              636[457-9]
            )|
            9(?:
              802|
              9(?:
                1[23]|
                69
              )
            )|
            1(?:
              45|
              58
            )[67]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d)(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '60',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '
            [36]|
            4(?:
              2(?:
                0|
                9[02-69]
              )|
              7(?:
                0[019]|
                1
              )
            )
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d)(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '
            1(?:
              1|
              5(?:
                4[018]|
                5[017]
              )|
              77|
              88|
              9[69]
            )|
            2(?:
              2[127]|
              3[0-269]|
              4[59]|
              5(?:
                [1-3]|
                5[0-69]|
                7[015-9]|
                9(?:
                  17|
                  99
                )
              )|
              6(?:
                2|
                4[016-9]
              )|
              7(?:
                [1-35]|
                8[0189]
              )|
              8(?:
                [16]|
                3[0134]|
                9[0-5]
              )|
              9(?:
                [028]|
                17|
                3[015-9]
              )
            )|
            4(?:
              2(?:
                [13-79]|
                8[014-6]
              )|
              3[0-57]|
              [45]|
              6[248]|
              7[2-47]|
              9[29]
            )|
            5(?:
              2|
              3[045]|
              4[0-369]|
              5[29]|
              8[02389]|
              9[0-3]
            )|
            7(?:
              2[02-46-9]|
              34|
              [58]|
              6[0249]|
              7[57]|
              9(?:
                [23]|
                4[0-59]|
                5[01569]|
                6[0167]
              )
            )|
            8(?:
              2(?:
                [1258]|
                4[0-39]|
                9(?:
                  [019]|
                  4[1-3]|
                  6(?:
                    [0-47-9]|
                    5[01346-9]
                  )
                )
              )|
              3(?:
                [29]|
                7(?:
                  [017-9]|
                  6[6-8]
                )
              )|
              49|
              51|
              6(?:
                [0-24]|
                36[23]|
                5(?:
                  [0-389]|
                  5[23]
                )|
                6(?:
                  [01]|
                  9[178]
                )|
                72|
                9[0145]
              )|
              7[0-468]|
              8[68]
            )|
            9(?:
              4[15]|
              5[138]|
              6[1-3]|
              7[156]|
              8[189]|
              9(?:
                [1289]|
                3(?:
                  31|
                  4[357]
                )|
                4[0178]
              )
            )|
            (?:
              223|
              8699
            )[014-9]|
            (?:
              25[0468]|
              422|
              838
            )[01]|
            (?:
              48|
              829(?:
                2|
                66
              )|
              9[23]
            )[1-9]|
            (?:
              47[59]|
              59[89]|
              8(?:
                68|
                9
              )
            )[019]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '
            [14]|
            [289][2-9]|
            5[3-9]|
            7[2-4679]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{2})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'intl_format' => 'NA',
                  'leading_digits' => '0077',
                  'pattern' => '(\\d{4})(\\d{2})(\\d{3,4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'intl_format' => 'NA',
                  'leading_digits' => '008',
                  'pattern' => '(\\d{4})(\\d{2})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '800',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '[257-9]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'intl_format' => 'NA',
                  'pattern' => '(\\d{4})(\\d{3})(\\d{3,4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'intl_format' => 'NA',
                  'pattern' => '(\\d{4})(\\d{4})(\\d{4,5})'
                },
                {
                  'format' => '$1-$2-$3',
                  'intl_format' => 'NA',
                  'pattern' => '(\\d{4})(\\d{5})(\\d{5,6})'
                },
                {
                  'format' => '$1-$2-$3',
                  'intl_format' => 'NA',
                  'pattern' => '(\\d{4})(\\d{6})(\\d{6,7})'
                }
              ];

my $validators = {
                'fixed_line' => '
          (?:
            1(?:
              1[235-8]|
              2[3-6]|
              3[3-9]|
              4[2-6]|
              [58][2-8]|
              6[2-7]|
              7[2-9]|
              9[1-9]
            )|
            (?:
              2[2-9]|
              [36][1-9]
            )\\d|
            4(?:
              [2-578]\\d|
              6[02-8]|
              9[2-59]
            )|
            5(?:
              [2-589]\\d|
              6[1-9]|
              7[2-8]
            )|
            7(?:
              [25-9]\\d|
              3[4-9]|
              4[02-9]
            )|
            8(?:
              [2679]\\d|
              3[2-9]|
              4[5-9]|
              5[1-9]|
              8[03-9]
            )|
            9(?:
              [2-58]\\d|
              [679][1-9]
            )
          )\\d{6}
        ',
                'geographic' => '
          (?:
            1(?:
              1[235-8]|
              2[3-6]|
              3[3-9]|
              4[2-6]|
              [58][2-8]|
              6[2-7]|
              7[2-9]|
              9[1-9]
            )|
            (?:
              2[2-9]|
              [36][1-9]
            )\\d|
            4(?:
              [2-578]\\d|
              6[02-8]|
              9[2-59]
            )|
            5(?:
              [2-589]\\d|
              6[1-9]|
              7[2-8]
            )|
            7(?:
              [25-9]\\d|
              3[4-9]|
              4[02-9]
            )|
            8(?:
              [2679]\\d|
              3[2-9]|
              4[5-9]|
              5[1-9]|
              8[03-9]
            )|
            9(?:
              [2-58]\\d|
              [679][1-9]
            )
          )\\d{6}
        ',
                'mobile' => '[7-9]0[1-9]\\d{7}',
                'pager' => '20\\d{8}',
                'personal_number' => '60\\d{7}',
                'specialrate' => '(990\\d{6})|(570\\d{6})',
                'toll_free' => '
          00777(?:
            [01]|
            5\\d
          )\\d\\d|
          (?:
            00(?:
              7778|
              882[1245]
            )|
            (?:
              120|
              800\\d
            )\\d\\d
          )\\d{4}|
          00(?:
            37|
            66|
            78
          )\\d{6,13}
        ',
                'voip' => '50[1-9]\\d{7}'
              };
my %areanames = ();
$areanames{en} = {"818593", "Yonago\,\ Tottori",
"81984", "Kobayashi\,\ Miyazaki",
"812992", "Ishioka\,\ Ibaraki",
"815998", "Ago\,\ Mie",
"81550", "Gotenba\,\ Shizuoka",
"81249", "Koriyama\,\ Fukushima",
"817964", "Toyooka\,\ Hyogo",
"817463", "Yoshino\,\ Nara",
"818377", "Shimonoseki\,\ Yamaguchi",
"8112396", "Kuriyama\,\ Hokkaido",
"811646", "Haboro\,\ Hokkaido",
"819952", "Okuchi\,\ Kagoshima",
"81489", "Soka\,\ Saitama",
"8186691", "Kurashiki\,\ Okayama",
"812484", "Shirakawa\,\ Fukushima",
"811954", "Ninohe\,\ Iwate",
"812917", "Mito\,\ Ibaraki",
"8186998", "Seto\,\ Okayama",
"815736", "Nakatsugawa\,\ Gifu",
"811453", "Hayakita\,\ Hokkaido",
"818582", "Kurayoshi\,\ Tottori",
"815762", "Gero\,\ Gifu",
"811734", "Goshogawara\,\ Aomori",
"812612", "Omachi\,\ Nagano",
"812387", "Nagai\,\ Yamagata",
"818679", "Niimi\,\ Okayama",
"811857", "Noshiro\,\ Akita",
"814287", "Ome\,\ Tokyo",
"8186994", "Seto\,\ Okayama",
"812572", "Kashiwazaki\,\ Niigata",
"818973", "Niihama\,\ Ehime",
"818565", "Masuda\,\ Shimane",
"818368", "Ube\,\ Yamaguchi",
"812697", "Iiyama\,\ Nagano",
"81534", "Hamamatsu\,\ Shizuoka",
"817495", "Nagahama\,\ Shiga",
"818474", "Fuchu\,\ Hiroshima",
"814701", "Kamogawa\,\ Chiba",
"819732", "Hita\,\ Oita",
"818464", "Takehara\,\ Hiroshima",
"815997", "Ago\,\ Mie",
"817714", "Kameoka\,\ Kyoto",
"819822", "Nobeoka\,\ Miyazaki",
"812853", "Oyama\,\ Tochigi",
"814795", "Choshi\,\ Chiba",
"818378", "Shimonoseki\,\ Yamaguchi",
"812562", "Sanjo\,\ Niigata",
"81932", "Kitakyushu\,\ Fukuoka",
"81969", "Amakusa\,\ Kumamoto",
"818546", "Kakeya\,\ Shimane",
"81938", "Kitakyushu\,\ Fukuoka",
"81977", "Beppu\,\ Oita",
"812656", "Ina\,\ Nagano",
"81270", "Isesaki\,\ Gunma",
"819684", "Yamaga\,\ Kumamoto",
"811392", "Kikonai\,\ Hokkaido",
"818669", "Soja\,\ Okayama",
"81253", "Niigata\,\ Niigata",
"81464", "Atsugi\,\ Kanagawa",
"818263", "Kake\,\ Hiroshima",
"812244", "Shiroishi\,\ Miyagi",
"812585", "Nagaoka\,\ Niigata",
"812388", "Nagai\,\ Yamagata",
"811858", "Noshiro\,\ Akita",
"817705", "Obama\,\ Fukui",
"818295", "Hatsukaichi\,\ Hiroshima",
"814288", "Ome\,\ Tokyo",
"818367", "Ube\,\ Yamaguchi",
"81582", "Gifu\,\ Gifu",
"812698", "Iiyama\,\ Nagano",
"811987", "Tono\,\ Iwate",
"815393", "Hamamatsu\,\ Shizuoka",
"812895", "Utsunomiya\,\ Tochigi",
"8147957", "Yokaichiba\,\ Chiba",
"812237", "Sendai\,\ Miyagi",
"814753", "Mobara\,\ Chiba",
"818947", "Uwajima\,\ Ehime",
"81559", "Numazu\,\ Shizuoka",
"8186992", "Bizen\,\ Okayama",
"819668", "Minamata\,\ Kumamoto",
"81947", "Tagawa\,\ Fukuoka",
"811535", "Akkeshi\,\ Hokkaido",
"812830", "Utsunomiya\,\ Tochigi",
"812937", "Mito\,\ Ibaraki",
"8186697", "Kurashiki\,\ Okayama",
"811655", "Nayoro\,\ Hokkaido",
"811868", "Takanosu\,\ Akita",
"811974", "Mizusawa\,\ Iwate",
"818247", "Shobara\,\ Hiroshima",
"815584", "Shimoda\,\ Shizuoka",
"819789", "Kitsuki\,\ Oita",
"81480", "Kuki\,\ Saitama",
"812743", "Fujioka\,\ Gunma",
"812549", "Tsugawa\,\ Niigata",
"811586", "Nakayubetsu\,\ Hokkaido",
"8163", "Osaka\,\ Osaka",
"817682", "Wajima\,\ Ishikawa",
"812834", "Utsunomiya\,\ Tochigi",
"8198290", "Nobeoka\,\ Miyazaki",
"811877", "Omagari\,\ Akita",
"818844", "Anan\,\ Tokushima",
"818953", "Uwajima\,\ Ehime",
"812552", "Joetsu\,\ Niigata",
"811526", "Abashiri\,\ Hokkaido",
"819592", "Oseto\,\ Nagasaki",
"812478", "Miharu\,\ Fukushima",
"81266", "Suwa\,\ Nagano",
"8153970", "Hamamatsu\,\ Shizuoka",
"812238", "Sendai\,\ Miyagi",
"811753", "Mutsu\,\ Aomori",
"814705", "Tateyama\,\ Chiba",
"81596", "Ise\,\ Mie",
"811337", "Ishikari\,\ Hokkaido",
"819803", "Nago\,\ Okinawa",
"818555", "Gotsu\,\ Shimane",
"818948", "Uwajima\,\ Ehime",
"819667", "Minamata\,\ Kumamoto",
"812784", "Numata\,\ Gunma",
"812374", "Murayama\,\ Yamagata",
"812796", "Shibukawa\,\ Gunma",
"812873", "Otawara\,\ Tochigi",
"817734", "Fukuchiyama\,\ Kyoto",
"811867", "Takanosu\,\ Akita",
"81543", "Shizuoka\,\ Shizuoka",
"812938", "Mito\,\ Ibaraki",
"812676", "Saku\,\ Nagano",
"81975", "Oita\,\ Oita",
"818248", "Shobara\,\ Hiroshima",
"817950", "Sanda\,\ Hyogo",
"818690", "Okayama\,\ Okayama",
"8199343", "Kagoshima\,\ Kagoshima",
"8183768", "Shimonoseki\,\ Yamaguchi",
"811233", "Chitose\,\ Hokkaido",
"818205", "Yanai\,\ Yamaguchi",
"818384", "Hagi\,\ Yamaguchi",
"819432", "Yame\,\ Fukuoka",
"815752", "Sekigahara\,\ Gifu",
"8126176", "Omachi\,\ Nagano",
"811463", "Urakawa\,\ Hokkaido",
"811542", "Kushiro\,\ Hokkaido",
"812780", "Maebashi\,\ Gunma",
"811878", "Omagari\,\ Akita",
"81764", "Toyama\,\ Toyama",
"819936", "Kaseda\,\ Kagoshima",
"81946", "Amagi\,\ Fukuoka",
"817453", "Yamatotakada\,\ Nara",
"811933", "Kamaishi\,\ Iwate",
"81923", "Fukuoka\,\ Fukuoka",
"819544", "Takeo\,\ Saga",
"81839", "Yamaguchi\,\ Yamaguchi",
"81862", "Okayama\,\ Okayama",
"819962", "Satsumasendai\,\ Kagoshima",
"8125483", "Murakami\,\ Niigata",
"812477", "Miharu\,\ Fukushima",
"811559", "Obihiro\,\ Hokkaido",
"817675", "Nanao\,\ Ishikawa",
"817954", "Nishiwaki\,\ Hyogo",
"818694", "Okayama\,\ Okayama",
"818892", "Sakawa\,\ Kochi",
"818686", "Tsuyama\,\ Okayama",
"819738", "Kusu\,\ Oita",
"81234", "Sakata\,\ Yamagata",
"81886", "Tokushima\,\ Tokushima",
"811982", "Hanamaki\,\ Iwate",
"814704", "Tateyama\,\ Chiba",
"818807", "Sukumo\,\ Kochi",
"812578", "Muika\,\ Niigata",
"818554", "Hamada\,\ Shimane",
"818362", "Ube\,\ Yamaguchi",
"818663", "Soja\,\ Okayama",
"817735", "Fukuchiyama\,\ Kyoto",
"812375", "Murayama\,\ Yamagata",
"8153969", "Hamamatsu\,\ Shizuoka",
"812785", "Numata\,\ Gunma",
"8126171", "Omachi\,\ Nagano",
"81225", "Ishinomaki\,\ Miyagi",
"8186552", "Kurashiki\,\ Okayama",
"818832", "Kamojima\,\ Tokushima",
"812956", "Hitachi\-Omiya\,\ Ibaraki",
"812618", "Omachi\,\ Nagano",
"81142", "Date\,\ Hokkaido",
"81833", "Kudamatsu\,\ Yamaguchi",
"81929", "Fukuoka\,\ Fukuoka",
"81494", "Chichibu\,\ Saitama",
"812859", "Oyama\,\ Tochigi",
"815983", "Matsusaka\,\ Mie",
"8198293", "Nobeoka\,\ Miyazaki",
"814700", "Kamogawa\,\ Chiba",
"818204", "Yanai\,\ Yamaguchi",
"818385", "Hagi\,\ Yamaguchi",
"811397", "Okushiri\,\ Hokkaido",
"815768", "Gero\,\ Gifu",
"818588", "Koge\,\ Tottori",
"812640", "Nagano\,\ Nagano",
"819576", "Shimabara\,\ Nagasaki",
"81273", "Takasaki\,\ Gunma",
"81778", "Takefu\,\ Fukui",
"81737", "Yuasa\,\ Wakayama",
"8153973", "Hamamatsu\,\ Shizuoka",
"81549", "Shizuoka\,\ Shizuoka",
"812998", "Itako\,\ Ibaraki",
"81250", "Niitsu\,\ Niigata",
"817674", "Hakui\,\ Ishikawa",
"815992", "Toba\,\ Mie",
"819827", "Takachiho\,\ Miyazaki",
"817955", "Sanda\,\ Hyogo",
"818695", "Seto\,\ Okayama",
"812692", "Nakano\,\ Nagano",
"812894", "Utsunomiya\,\ Tochigi",
"81956", "Sasebo\,\ Nagasaki",
"819737", "Kusu\,\ Oita",
"812577", "Muika\,\ Niigata",
"819943", "Kanoya\,\ Kagoshima",
"81282", "Tochigi\,\ Tochigi",
"811946", "Kuji\,\ Iwate",
"818808", "Tosashimizu\,\ Kochi",
"811534", "Nakashibetsu\,\ Hokkaido",
"81124", "Ashibetsu\,\ Hokkaido",
"811356", "Iwanai\,\ Hokkaido",
"811654", "Nayoro\,\ Hokkaido",
"811852", "Oga\,\ Akita",
"81288", "Imabari\,\ Ehime",
"814282", "Ome\,\ Tokyo",
"811975", "Mizusawa\,\ Iwate",
"811563", "Honbetsu\,\ Hokkaido",
"817239", "Neyagawa\,\ Osaka",
"817366", "Iwade\,\ Wakayama",
"815585", "Shimoda\,\ Shizuoka",
"812382", "Yonezawa\,\ Yamagata",
"811398", "Kumaishi\,\ Hokkaido",
"81553", "Yamanashi\,\ Yamanashi",
"818587", "Koge\,\ Tottori",
"812890", "Utsunomiya\,\ Tochigi",
"815767", "Gero\,\ Gifu",
"812835", "Sano\,\ Tochigi",
"818372", "Nagato\,\ Yamaguchi",
"8125480", "Murakami\,\ Niigata",
"812416", "Tajima\,\ Fukushima",
"819957", "Kajiki\,\ Kagoshima",
"817903", "Fukusaki\,\ Hyogo",
"812997", "Itako\,\ Ibaraki",
"819828", "Takachiho\,\ Miyazaki",
"81565", "Toyota\,\ Aichi",
"8112397", "Kuriyama\,\ Hokkaido",
"812472", "Ishikawa\,\ Fukushima",
"819598", "Fukue\,\ Nagasaki",
"817715", "Kameoka\,\ Kyoto",
"81566", "Kariya\,\ Aichi",
"812580", "Tokamachi\,\ Niigata",
"814794", "Choshi\,\ Chiba",
"818290", "Hiroshima\,\ Hiroshima",
"819967", "Izumi\,\ Kagoshima",
"811547", "Shiranuka\,\ Hokkaido",
"817688", "Noto\,\ Ishikawa",
"81227", "Sendai\,\ Miyagi",
"812879", "Nasukarasuyama\,\ Tochigi",
"819437", "Tanushimaru\,\ Fukuoka",
"819685", "Tamana\,\ Kumamoto",
"819744", "Mie\,\ Oita",
"812245", "Ogawara\,\ Miyagi",
"81478", "Sawara\,\ Chiba",
"819809", "Yaeyama\ District\,\ Okinawa",
"817356", "Kushimoto\,\ Wakayama",
"812584", "Nagaoka\,\ Niigata",
"815743", "Minokamo\,\ Gifu",
"81963", "Kumamoto\,\ Kumamoto",
"811939", "Miyako\,\ Iwate",
"817946", "Miki\,\ Hyogo",
"81822", "Hiroshima\,\ Hiroshima",
"811862", "Kazuno\,\ Akita",
"81898", "Imabari\,\ Ehime",
"817704", "Tsuruga\,\ Fukui",
"819556", "Karatsu\,\ Saga",
"811553", "Obihiro\,\ Hokkaido",
"818294", "Hatsukaichi\,\ Hiroshima",
"8178", "Kobe\,\ Hyogo",
"819978", "Tokunoshima\,\ Kagoshima",
"818493", "Onomichi\,\ Hiroshima",
"811332", "Tobetsu\,\ Hokkaido",
"81892", "Kumakogen\,\ Ehime",
"811366", "Suttsu\,\ Hokkaido",
"819662", "Hitoyoshi\,\ Kumamoto",
"81259", "Sado\,\ Niigata",
"81183", "Yuzawa\,\ Akita",
"81828", "Hiroshima\,\ Hiroshima",
"819597", "Fukue\,\ Nagasaki",
"81172", "Hirosaki\,\ Aomori",
"817965", "Toyooka\,\ Hyogo",
"811376", "Yakumo\,\ Hokkaido",
"819783", "Bungotakada\,\ Oita",
"819968", "Izumi\,\ Kagoshima",
"813", "Tokyo",
"811955", "Ninohe\,\ Iwate",
"817687", "Noto\,\ Ishikawa",
"811548", "Teshikaga\,\ Hokkaido",
"812485", "Shirakawa\,\ Fukushima",
"819723", "Saiki\,\ Oita",
"817613", "Komatsu\,\ Ishikawa",
"819438", "Tanushimaru\,\ Fukuoka",
"81178", "Hachinohe\,\ Aomori",
"8153965", "Hamamatsu\,\ Shizuoka",
"811735", "Goshogawara\,\ Aomori",
"818242", "Higashi\-ku\,\ Hiroshima",
"81436", "Ichihara\,\ Chiba",
"8182941", "Hiroshima\,\ Hiroshima",
"812932", "Takahagi\,\ Ibaraki",
"81551", "Nirasaki\,\ Yamanashi",
"81226", "Kesennuma\,\ Miyagi",
"81243", "Nihonmatsu\,\ Fukushima",
"818564", "Masuda\,\ Shimane",
"818942", "Yawatahama\,\ Ehime",
"819977", "Setouchi\,\ Kagoshima",
"81742", "Nara\,\ Nara",
"812543", "Shibata\,\ Niigata",
"817993", "Sumoto\,\ Hyogo",
"817494", "Hikone\,\ Shiga",
"81567", "Tsushima\,\ Aichi",
"817486", "Minakuchi\,\ Shiga",
"812232", "Iwanuma\,\ Miyagi",
"8112391", "Yubari\,\ Hokkaido",
"818475", "Fuchu\,\ Hiroshima",
"81885", "Komatsushima\,\ Tokushima",
"815398", "Hamamatsu\,\ Shizuoka",
"81985", "Miyazaki\,\ Miyazaki",
"812693", "Nakano\,\ Nagano",
"81944", "Setaka\,\ Fukuoka",
"8153971", "Hamamatsu\,\ Shizuoka",
"811656", "Bifuka\,\ Hokkaido",
"81766", "Takaoka\,\ Toyama",
"815769", "Shokawa\,\ Gifu",
"818977", "Hakata\,\ Ehime",
"812999", "Itako\,\ Ibaraki",
"814283", "Ome\,\ Tokyo",
"811944", "Iwaizumi\,\ Iwate",
"811562", "Honbetsu\,\ Hokkaido",
"811354", "Yoichi\,\ Hokkaido",
"811853", "Oga\,\ Akita",
"8175", "Kyoto\,\ Kyoto",
"811536", "Akkeshi\,\ Hokkaido",
"812896", "Kanuma\,\ Tochigi",
"812383", "Yonezawa\,\ Yamagata",
"8198291", "Nobeoka\,\ Miyazaki",
"811525", "Abashiri\,\ Hokkaido",
"812913", "Hokota\,\ Ibaraki",
"818512", "Nishigo\,\ Fukushima",
"812414", "Yanaizu\,\ Fukushima",
"8126173", "Omachi\,\ Nagano",
"812619", "Omachi\,\ Nagano",
"8125486", "Tsugawa\,\ Niigata",
"818373", "Nagato\,\ Yamaguchi",
"812858", "Mooka\,\ Tochigi",
"818874", "Aki\,\ Kochi",
"81740", "Imazu\,\ Shiga",
"814777", "Funabashi\,\ Chiba",
"81535", "Hamamatsu\,\ Shizuoka",
"811585", "Engaru\,\ Hokkaido",
"817902", "Fukusaki\,\ Hyogo",
"81594", "Kuwana\,\ Mie",
"811983", "Hanamaki\,\ Iwate",
"81928", "Fukuoka\,\ Fukuoka",
"81992", "Kagoshima\,\ Kagoshima",
"818662", "Takahashi\,\ Okayama",
"818363", "Ube\,\ Yamaguchi",
"812675", "Saku\,\ Nagano",
"818978", "Hakata\,\ Ehime",
"818556", "Gotsu\,\ Shimane",
"818833", "Kamojima\,\ Tokushima",
"81998", "Kagoshima\,\ Kagoshima",
"812646", "Nagano\,\ Nagano",
"812795", "Shibukawa\,\ Gunma",
"81863", "Tamano\,\ Okayama",
"81922", "Fukuoka\,\ Fukuoka",
"81465", "Odawara\,\ Kanagawa",
"81548", "Haibara\,\ Shizuoka",
"817724", "Miyazu\,\ Kyoto",
"817676", "Nanao\,\ Ishikawa",
"814240", "Kokubunji\,\ Tokyo",
"815982", "Matsusaka\,\ Mie",
"818685", "Tsuyama\,\ Okayama",
"81779", "Ono\,\ Gifu",
"819935", "Kaseda\,\ Kagoshima",
"819574", "Isahaya\,\ Nagasaki",
"817238", "Neyagawa\,\ Osaka",
"812857", "Mooka\,\ Tochigi",
"817468", "Kamikitayama\,\ Nara",
"815993", "Toba\,\ Mie",
"818206", "Yanai\,\ Yamaguchi",
"81542", "Shizuoka\,\ Shizuoka",
"818391", "Ogori\,\ Yamaguchi",
"815735", "Ena\,\ Gifu",
"81280", "Koga\,\ Ibaraki",
"81987", "Nichinan\,\ Miyazaki",
"81179", "Sannohe\,\ Aomori",
"818957", "Misho\,\ Ehime",
"819782", "Bungotakada\,\ Oita",
"811938", "Miyako\,\ Iwate",
"811873", "Kakunodate\,\ Akita",
"819722", "Saiki\,\ Oita",
"811645", "Rumoi\,\ Hokkaido",
"817612", "Komatsu\,\ Ishikawa",
"811374", "Mori\,\ Hokkaido",
"8153968", "Hamamatsu\,\ Shizuoka",
"819979", "Tokunoshima\,\ Kagoshima",
"81167", "Furano\,\ Hokkaido",
"8198297", "Hyuga\,\ Miyazaki",
"811238", "Kuriyama\,\ Hokkaido",
"817484", "Yokaichi\,\ Shiga",
"81572", "Tajimi\,\ Gifu",
"8153964", "Hamamatsu\,\ Shizuoka",
"812747", "Tomioka\,\ Gunma",
"817496", "Nagahama\,\ Shiga",
"812559", "Yasuzuka\,\ Niigata",
"81466", "Fujisawa\,\ Kanagawa",
"818243", "Higashi\-ku\,\ Hiroshima",
"8188097", "Tosashimizu\,\ Kochi",
"819599", "Oseto\,\ Nagasaki",
"812933", "Takahagi\,\ Ibaraki",
"8169", "Osaka\,\ Osaka",
"812878", "Nasukarasuyama\,\ Tochigi",
"818652", "Kurashiki\,\ Okayama",
"817992", "Sumoto\,\ Hyogo",
"818943", "Yawatahama\,\ Ehime",
"819808", "Yaeyama\ District\,\ Okinawa",
"812964", "Shimodate\,\ Ibaraki",
"8147950", "Yokaichiba\,\ Chiba",
"812542", "Shibata\,\ Niigata",
"8145", "Yokohama\,\ Kanagawa",
"8162", "Osaka\,\ Osaka",
"81578", "Kamioka\,\ Akita",
"81537", "Kakegawa\,\ Shizuoka",
"814757", "Togane\,\ Chiba",
"812233", "Iwanuma\,\ Miyagi",
"819746", "Taketa\,\ Oita",
"8112393", "Yubari\,\ Hokkaido",
"81857", "Tottori\,\ Tottori",
"812473", "Ishikawa\,\ Fukushima",
"818545", "Kisuki\,\ Shimane",
"818958", "Misho\,\ Ehime",
"812655", "Iida\,\ Nagano",
"811937", "Miyako\,\ Iwate",
"817457", "Yamatotakada\,\ Nara",
"814796", "Yokaichiba\,\ Chiba",
"815366", "Shitara\,\ Aichi",
"8182943", "Hiroshima\,\ Hiroshima",
"81583", "Gifu\,\ Gifu",
"817940", "Kakogawa\,\ Hyogo",
"81467", "Fujisawa\,\ Kanagawa",
"811237", "Kuriyama\,\ Hokkaido",
"812748", "Tomioka\,\ Gunma",
"81933", "Kitakyushu\,\ Fukuoka",
"815742", "Minokamo\,\ Gifu",
"81166", "Asahikawa\,\ Hokkaido",
"811552", "Obihiro\,\ Hokkaido",
"811863", "Kazuno\,\ Akita",
"811364", "Kutchan\,\ Hokkaido",
"817706", "Obama\,\ Fukui",
"819663", "Hitoyoshi\,\ Kumamoto",
"81899", "Matsuyama\,\ Ehime",
"81765", "Uozu\,\ Toyama",
"81252", "Niigata\,\ Niigata",
"812877", "Kuroiso\,\ Tochigi",
"811632", "Teshio\,\ Hokkaido",
"811333", "Tobetsu\,\ Hokkaido",
"818296", "Hiroshima\,\ Hiroshima",
"819554", "Imari\,\ Saga",
"81986", "Miyakonojo\,\ Miyazaki",
"817354", "Shingu\,\ Fukuoka",
"811549", "Kushiro\,\ Hokkaido",
"812586", "Nagaoka\,\ Niigata",
"814758", "Togane\,\ Chiba",
"811757", "Noheji\,\ Aomori",
"817944", "Kakogawa\,\ Hyogo",
"819823", "Nobeoka\,\ Miyazaki",
"81294", "Hitachiota\,\ Ibaraki",
"819686", "Tamana\,\ Kumamoto",
"812246", "Ogawara\,\ Miyagi",
"81235", "Tsuruoka\,\ Yamagata",
"812563", "Sanjo\,\ Niigata",
"81823", "Kure\,\ Hiroshima",
"81962", "Kumamoto\,\ Kumamoto",
"8144", "Kawasaki\,\ Kanagawa",
"81939", "Kitakyushu\,\ Fukuoka",
"818544", "Kisuki\,\ Shimane",
"81188", "Akita\,\ Akita",
"81425", "Tachikawa\,\ Tokyo",
"812852", "Oyama\,\ Tochigi",
"818678", "Niimi\,\ Okayama",
"812654", "Iida\,\ Nagano",
"818798", "Tonosho\,\ Kagawa",
"81182", "Yokote\,\ Akita",
"81434", "Chiba\,\ Chiba",
"818262", "Kake\,\ Hiroshima",
"81893", "Ozu\,\ Ehime",
"818466", "Mima\,\ Tokushima",
"817716", "Sonobe\,\ Kyoto",
"81495", "Honjo\,\ Saitama",
"818369", "Ube\,\ Yamaguchi",
"811393", "Matsumae\,\ Hokkaido",
"814998", "Ogasawara\,\ Tokyo",
"81727", "Ikeda\,\ Osaka",
"81875", "Kan\'onji\,\ Kagawa",
"811365", "Kutchan\,\ Hokkaido",
"81473", "Ichikawa\,\ Chiba",
"815999", "Tsu\,\ Mie",
"818667", "Ibara\,\ Okayama",
"81797", "Nishinomiya\,\ Hyogo",
"819555", "Karatsu\,\ Saga",
"819948", "Shibushi\,\ Kagoshima",
"814298", "Hanno\,\ Saitama",
"817355", "Shingu\,\ Fukuoka",
"815392", "Hamamatsu\,\ Shizuoka",
"817945", "Kakogawa\,\ Hyogo",
"815734", "Ena\,\ Gifu",
"814772", "Ichikawa\,\ Chiba",
"81242", "Aizuwakamatsu\,\ Fukushima",
"818592", "Yonago\,\ Tottori",
"8125487", "Tsugawa\,\ Niigata",
"812993", "Ishioka\,\ Ibaraki",
"814289", "Ome\,\ Tokyo",
"81488", "Urawa\,\ Saitama",
"811956", "Iwate\,\ Iwate",
"819953", "Okuchi\,\ Kagoshima",
"812486", "Sukagawa\,\ Fukushima",
"8112390", "Yubari\,\ Hokkaido",
"818677", "Niimi\,\ Okayama",
"812389", "Yonezawa\,\ Yamagata",
"81125", "Takikawa\,\ Hokkaido",
"811644", "Rumoi\,\ Hokkaido",
"818797", "Tonosho\,\ Kagawa",
"811375", "Yakumo\,\ Hokkaido",
"8186995", "Seto\,\ Okayama",
"81482", "Kawaguchi\,\ Saitama",
"818583", "Kurayoshi\,\ Tottori",
"811452", "Hayakita\,\ Hokkaido",
"81134", "Otaru\,\ Hokkaido",
"81726", "Ibaraki\,\ Osaka",
"815763", "Gero\,\ Gifu",
"81743", "Nara\,\ Nara",
"8199347", "Kagoshima\,\ Kagoshima",
"817485", "Yokaichi\,\ Shiga",
"818476", "Fuchu\,\ Hiroshima",
"812613", "Omachi\,\ Nagano",
"81281", "Utsunomiya\,\ Tochigi",
"818668", "Ibara\,\ Okayama",
"819947", "Shibushi\,\ Kagoshima",
"812573", "Kashiwazaki\,\ Niigata",
"812965", "Shimodate\,\ Ibaraki",
"814297", "Hanno\,\ Saitama",
"818972", "Niihama\,\ Ehime",
"819733", "Hita\,\ Oita",
"8111", "Sapporo\,\ Hokkaido",
"811736", "Goshogawara\,\ Aomori",
"81564", "Okazaki\,\ Aichi",
"8186999", "Seto\,\ Okayama",
"818680", "Okayama\,\ Okayama",
"811752", "Mutsu\,\ Aomori",
"81930", "Yukuhashi\,\ Fukuoka",
"812674", "Komoro\,\ Nagano",
"817998", "Tsuna\,\ Hyogo",
"81427", "Sagamihara\,\ Kanagawa",
"812872", "Otawara\,\ Tochigi",
"819802", "Minamidaito\,\ Okinawa",
"812955", "Hitachi\-Omiya\,\ Ibaraki",
"817736", "Maizuru\,\ Kyoto",
"812794", "Shibukawa\,\ Gunma",
"812786", "Numata\,\ Gunma",
"812376", "Sagae\,\ Yamagata",
"81272", "Maebashi\,\ Gunma",
"81725", "Izumi\,\ Osaka",
"815753", "Sekigahara\,\ Gifu",
"811462", "Urakawa\,\ Hokkaido",
"817725", "Miyazu\,\ Kyoto",
"818684", "Tsuyama\,\ Okayama",
"81471", "Kashiwa\,\ Chiba",
"811232", "Chitose\,\ Hokkaido",
"819433", "Yame\,\ Fukuoka",
"818696", "Bizen\,\ Okayama",
"817956", "Sanda\,\ Hyogo",
"81196", "Morioka\,\ Iwate",
"8126170", "Omachi\,\ Nagano",
"817618", "Kaga\,\ Ishikawa",
"819934", "Ibusuki\,\ Kagoshima",
"819728", "Usuki\,\ Oita",
"811543", "Kushiro\,\ Hokkaido",
"819546", "Kashima\,\ Saga",
"81877", "Marugame\,\ Kagawa",
"819575", "Isahaya\,\ Nagasaki",
"819963", "Satsumasendai\,\ Kagoshima",
"81143", "Muroran\,\ Hokkaido",
"81832", "Shimonoseki\,\ Yamaguchi",
"81126", "Iwamizawa\,\ Hokkaido",
"81734", "Wakayama\,\ Wakayama",
"817452", "Yamatotakada\,\ Nara",
"811932", "Kamaishi\,\ Iwate",
"819788", "Kunisaki\,\ Oita",
"811869", "Odate\,\ Akita",
"818893", "Sakawa\,\ Kochi",
"815586", "Shimoda\,\ Shizuoka",
"814752", "Mobara\,\ Chiba",
"8125481", "Murakami\,\ Niigata",
"818657", "Kasaoka\,\ Okayama",
"817997", "Tsuna\,\ Hyogo",
"81552", "Kofu\,\ Yamanashi",
"812547", "Murakami\,\ Niigata",
"811976", "Kitakami\,\ Iwate",
"811945", "Kuji\,\ Iwate",
"817912", "Aioi\,\ Hyogo",
"811558", "Hiroo\,\ Hokkaido",
"812742", "Fujioka\,\ Gunma",
"819679", "Takamori\,\ Kumamoto",
"8188096", "Tosashimizu\,\ Kochi",
"811524", "Abashiri\,\ Hokkaido",
"818949", "Uwajima\,\ Ehime",
"819727", "Usuki\,\ Oita",
"812415", "Yanaizu\,\ Fukushima",
"812239", "Sendai\,\ Miyagi",
"817617", "Kaga\,\ Ishikawa",
"8198296", "Hyuga\,\ Miyazaki",
"817683", "Wajima\,\ Ishikawa",
"8166", "Osaka\,\ Osaka",
"818952", "Uwajima\,\ Ehime",
"818249", "Higashi\-ku\,\ Hiroshima",
"812836", "Sano\,\ Tochigi",
"812553", "Joetsu\,\ Niigata",
"815974", "Owase\,\ Mie",
"819787", "Kunisaki\,\ Oita",
"81845", "Innoshima\,\ Hiroshima",
"81426", "Hachioji\,\ Tokyo",
"812939", "Mito\,\ Ibaraki",
"819593", "Oseto\,\ Nagasaki",
"8153976", "Hamamatsu\,\ Shizuoka",
"811584", "Engaru\,\ Hokkaido",
"81236", "Yamagata\,\ Yamagata",
"818490", "Onomichi\,\ Hiroshima",
"819937", "Kaseda\,\ Kagoshima",
"81563", "Nishio\,\ Aichi",
"812476", "Miharu\,\ Fukushima",
"81487", "Urawa\,\ Saitama",
"811528", "Bihoro\,\ Hokkaido",
"812789", "Maebashi\,\ Gunma",
"819743", "Mie\,\ Oita",
"818687", "Mimasaka\,\ Okayama",
"818397", "Ogori\,\ Yamaguchi",
"81555", "Fujiyoshida\,\ Yamanashi",
"811588", "Okoppe\,\ Hokkaido",
"81174", "Kanita\,\ Aomori",
"815363", "Shinshiro\,\ Aichi",
"81940", "Munakata\,\ Fukuoka",
"815978", "Kumano\,\ Mie",
"812855", "Oyama\,\ Tochigi",
"814793", "Choshi\,\ Chiba",
"811866", "Takanosu\,\ Akita",
"817475", "Shimonoseki\,\ Yamaguchi",
"812677", "Saku\,\ Nagano",
"819552", "Imari\,\ Saga",
"811634", "Hamatonbetsu\,\ Hokkaido",
"817352", "Shingu\,\ Fukuoka",
"81744", "Yamatotakada\,\ Nara",
"815395", "Hamamatsu\,\ Shizuoka",
"817942", "Kakogawa\,\ Hyogo",
"81848", "Onomichi\,\ Hiroshima",
"8125489", "Tsugawa\,\ Niigata",
"8183767", "Shimonoseki\,\ Yamaguchi",
"812583", "Nagaoka\,\ Niigata",
"815744", "Minokamo\,\ Gifu",
"811336", "Ishikari\,\ Hokkaido",
"811554", "Obihiro\,\ Hokkaido",
"818293", "Hatsukaichi\,\ Hiroshima",
"811362", "Kutchan\,\ Hokkaido",
"817959", "Sanda\,\ Hyogo",
"819666", "Minamata\,\ Kumamoto",
"817703", "Tsuruga\,\ Fukui",
"812797", "Shibukawa\,\ Gunma",
"817614", "Komatsu\,\ Ishikawa",
"811372", "Shikabe\,\ Hokkaido",
"819676", "Takamori\,\ Kumamoto",
"819938", "Kaseda\,\ Kagoshima",
"819724", "Saiki\,\ Oita",
"81979", "Nakatsu\,\ Oita",
"811455", "Mukawa\,\ Hokkaido",
"811527", "Bihoro\,\ Hokkaido",
"818688", "Mimasaka\,\ Okayama",
"814775", "Funabashi\,\ Chiba",
"818398", "Ogori\,\ Yamaguchi",
"81260", "Anan\,\ Nagano",
"818595", "Yonago\,\ Tottori",
"811587", "Nakayubetsu\,\ Hokkaido",
"81474", "Funabashi\,\ Chiba",
"811876", "Omagari\,\ Akita",
"817465", "Yoshino\,\ Nara",
"815977", "Kumano\,\ Mie",
"819784", "Bungotakada\,\ Oita",
"812936", "Mito\,\ Ibaraki",
"812678", "Saku\,\ Nagano",
"81246", "Iwaki\,\ Fukushima",
"818654", "Kamogata\,\ Okayama",
"817994", "Sumoto\,\ Hyogo",
"812544", "Shibata\,\ Niigata",
"812962", "Shimodate\,\ Ibaraki",
"81728", "Neyagawa\,\ Osaka",
"818975", "Niihama\,\ Ehime",
"818563", "Masuda\,\ Shimane",
"812839", "Sano\,\ Tochigi",
"818246", "Miyoshi\,\ Hiroshima",
"81835", "Hofu\,\ Yamaguchi",
"81792", "Himeji\,\ Hyogo",
"817493", "Hikone\,\ Shiga",
"81433", "Chiba\,\ Chiba",
"812236", "Sendai\,\ Miyagi",
"817482", "Yokaichi\,\ Shiga",
"81798", "Nishinomiya\,\ Hyogo",
"81486", "Urawa\,\ Saitama",
"81722", "Sakai\,\ Osaka",
"818946", "Uwajima\,\ Ehime",
"812798", "Naganohara\,\ Gunma",
"8186698", "Kurashiki\,\ Okayama",
"81561", "Seto\,\ Aichi",
"81192", "Ofunato\,\ Iwate",
"818366", "Ube\,\ Yamaguchi",
"811986", "Tono\,\ Iwate",
"81485", "Kumagaya\,\ Saitama",
"814703", "Tateyama\,\ Chiba",
"81284", "Ashikaga\,\ Tochigi",
"81557", "Ito\,\ Shizuoka",
"81949", "Nogata\,\ Fukuoka",
"818664", "Takahashi\,\ Okayama",
"81245", "Fukushima\,\ Fukushima",
"815958", "Kameyama\,\ Mie",
"812875", "Otawara\,\ Tochigi",
"819805", "Nago\,\ Okinawa",
"818836", "Mima\,\ Tokushima",
"818553", "Hamada\,\ Shimane",
"818547", "Kakeya\,\ Shimane",
"819572", "Isahaya\,\ Nagasaki",
"812657", "Ina\,\ Nagano",
"811935", "Kamaishi\,\ Iwate",
"817455", "Yamatotakada\,\ Nara",
"815738", "Nakatsugawa\,\ Gifu",
"814771", "Ichikawa\,\ Chiba",
"817673", "Hakui\,\ Ishikawa",
"817722", "Miyazu\,\ Kyoto",
"811465", "Shizunai\,\ Hokkaido",
"818203", "Yanai\,\ Yamaguchi",
"811235", "Yubari\,\ Hokkaido",
"815996", "Ago\,\ Mie",
"815984", "Matsusaka\,\ Mie",
"81276", "Ota\,\ Gunma",
"818660", "Seto\,\ Okayama",
"817915", "Aioi\,\ Hyogo",
"811564", "Kamishihoro\,\ Hokkaido",
"81277", "Kiryu\,\ Gunma",
"811942", "Iwaizumi\,\ Iwate",
"81144", "Tomakomai\,\ Hokkaido",
"8199345", "Kagoshima\,\ Kagoshima",
"817969", "Hamasaka\,\ Hyogo",
"81492", "Kawagoe\,\ Saitama",
"811653", "Shibetsu\,\ Hokkaido",
"811352", "Yoichi\,\ Hokkaido",
"812696", "Iiyama\,\ Nagano",
"812745", "Fujioka\,\ Gunma",
"812489", "Sukagawa\,\ Fukushima",
"81965", "Yatsushiro\,\ Kumamoto",
"812386", "Nagai\,\ Yamagata",
"812893", "Utsunomiya\,\ Tochigi",
"814755", "Togane\,\ Chiba",
"811533", "Nemuro\,\ Hokkaido",
"811856", "Noshiro\,\ Akita",
"814286", "Sagamihara\,\ Kanagawa",
"819944", "Kanoya\,\ Kagoshima",
"818955", "Uwajima\,\ Ehime",
"8125485", "Tsugawa\,\ Niigata",
"818872", "Muroto\,\ Kochi",
"818674", "Kuse\,\ Okayama",
"812658", "Ina\,\ Nagano",
"815737", "Nakatsugawa\,\ Gifu",
"81878", "Takamatsu\,\ Kagawa",
"817904", "Fukusaki\,\ Hyogo",
"8186997", "Seto\,\ Okayama",
"818514", "Ama\,\ Shimane",
"81774", "Uji\,\ Kyoto",
"818376", "Mine\,\ Yamaguchi",
"812412", "Kitakata\,\ Fukushima",
"819940", "Shibushi\,\ Kagoshima",
"811647", "Haboro\,\ Hokkaido",
"815566", "Minobu\,\ Yamanashi",
"818479", "Tojo\,\ Hiroshima",
"8112392", "Yubari\,\ Hokkaido",
"817914", "Aioi\,\ Hyogo",
"811973", "Mizusawa\,\ Iwate",
"819976", "Naze\,\ Kagoshima",
"81927", "Fukuoka\,\ Fukuoka",
"815583", "Shimoda\,\ Shizuoka",
"812744", "Fujioka\,\ Gunma",
"817487", "Minakuchi\,\ Shiga",
"8188095", "Tosashimizu\,\ Kochi",
"814754", "Mobara\,\ Chiba",
"817948", "Miki\,\ Hyogo",
"8182942", "Hiroshima\,\ Hiroshima",
"812967", "Kasama\,\ Ibaraki",
"819945", "Kanoya\,\ Kagoshima",
"819558", "Karatsu\,\ Saga",
"817686", "Noto\,\ Ishikawa",
"81547", "Shimada\,\ Shizuoka",
"818954", "Uwajima\,\ Ehime",
"818675", "Kuse\,\ Okayama",
"815972", "Owase\,\ Mie",
"818843", "Anan\,\ Tokushima",
"81762", "Kanazawa\,\ Ishikawa",
"81739", "Tanabe\,\ Wakayama",
"817905", "Fukusaki\,\ Hyogo",
"8153975", "Hamamatsu\,\ Shizuoka",
"811582", "Monbetsu\,\ Hokkaido",
"81864", "Kurashiki\,\ Okayama",
"811522", "Shari\,\ Hokkaido",
"819596", "Fukue\,\ Nagasaki",
"81263", "Matsumoto\,\ Nagano",
"811377", "Yakumo\,\ Hokkaido",
"8198295", "Hyuga\,\ Miyazaki",
"8168", "Osaka\,\ Osaka",
"812556", "Itoigawa\,\ Niigata",
"812833", "Utsunomiya\,\ Tochigi",
"811367", "Suttsu\,\ Hokkaido",
"812792", "Shibukawa\,\ Gunma",
"8183766", "Shimonoseki\,\ Yamaguchi",
"8126174", "Omachi\,\ Nagano",
"817488", "Minakuchi\,\ Shiga",
"81593", "Yokkaichi\,\ Mie",
"817357", "Kushimoto\,\ Wakayama",
"811754", "Mutsu\,\ Aomori",
"817947", "Miki\,\ Hyogo",
"818665", "Takahashi\,\ Okayama",
"817733", "Fukuchiyama\,\ Kyoto",
"812874", "Otawara\,\ Tochigi",
"812672", "Komoro\,\ Nagano",
"812373", "Murayama\,\ Yamagata",
"812783", "Numata\,\ Gunma",
"819557", "Karatsu\,\ Saga",
"819804", "Nago\,\ Okinawa",
"81546", "Shizuoka\,\ Shizuoka",
"812968", "Kasama\,\ Ibaraki",
"819543", "Takeo\,\ Saga",
"812589", "Nagaoka\,\ Niigata",
"811546", "Kushiro\,\ Hokkaido",
"811934", "Kamaishi\,\ Iwate",
"817454", "Yamatotakada\,\ Nara",
"819232", "Maebaru\,\ Fukuoka",
"818693", "Oku\,\ Okayama",
"817953", "Nishiwaki\,\ Hyogo",
"818299", "Hiroshima\,\ Hiroshima",
"811464", "Shizunai\,\ Hokkaido",
"815985", "Matsusaka\,\ Mie",
"811234", "Chitose\,\ Hokkaido",
"818896", "Susaki\,\ Kochi",
"818383", "Hagi\,\ Yamaguchi",
"818682", "Tsuyama\,\ Okayama",
"81926", "Fukuoka\,\ Fukuoka",
"819932", "Ibusuki\,\ Kagoshima",
"811378", "Imakane\,\ Hokkaido",
"8126178", "Omachi\,\ Nagano",
"819966", "Izumi\,\ Kagoshima",
"819725", "Saiki\,\ Oita",
"817615", "Komatsu\,\ Ishikawa",
"8182920", "Hatsukaichi\,\ Hiroshima",
"812899", "Kanuma\,\ Tochigi",
"81925", "Fukuoka\,\ Fukuoka",
"8186996", "Seto\,\ Okayama",
"819956", "Kajiki\,\ Kagoshima",
"81462", "Atsugi\,\ Kanagawa",
"81439", "Kisarazu\,\ Chiba",
"811953", "Ninohe\,\ Iwate",
"812483", "Shirakawa\,\ Fukushima",
"811454", "Mukawa\,\ Hokkaido",
"812996", "Itako\,\ Ibaraki",
"817963", "Toyooka\,\ Hyogo",
"8112398", "Kuriyama\,\ Hokkaido",
"815732", "Ena\,\ Gifu",
"818586", "Kurayoshi\,\ Tottori",
"81934", "Kitakyushu\,\ Fukuoka",
"815766", "Gero\,\ Gifu",
"818594", "Yonago\,\ Tottori",
"819578", "Shimabara\,\ Nagasaki",
"81468", "Yokosuka\,\ Kanagawa",
"81852", "Matsue\,\ Shimane",
"819785", "Bungotakada\,\ Oita",
"817464", "Yoshino\,\ Nara",
"8152", "Nagoya\,\ Aichi",
"817995", "Sumoto\,\ Hyogo",
"818655", "Kamogata\,\ Okayama",
"818974", "Niihama\,\ Ehime",
"8112394", "Yubari\,\ Hokkaido",
"81545", "Fuji\,\ Shizuoka",
"812545", "Murakami\,\ Niigata",
"81950", "Hirado\,\ Nagasaki",
"812616", "Omachi\,\ Nagano",
"817367", "Iwade\,\ Wakayama",
"81584", "Ogaki\,\ Gifu",
"814770", "Ichikawa\,\ Chiba",
"811733", "Goshogawara\,\ Aomori",
"811947", "Kuji\,\ Iwate",
"812576", "Tokamachi\,\ Niigata",
"8128798", "Otawara\,\ Tochigi",
"817230", "Neyagawa\,\ Osaka",
"811357", "Iwanai\,\ Hokkaido",
"81591", "Tsu\,\ Mie",
"812566", "Sanjo\,\ Niigata",
"81162", "Wakkanai\,\ Hokkaido",
"81988", "Naha\,\ Okinawa",
"814709", "Kamogawa\,\ Chiba",
"812243", "Shiroishi\,\ Miyagi",
"818559", "Kawamoto\,\ Shimane",
"819683", "Yamaga\,\ Kumamoto",
"819826", "Hyuga\,\ Miyazaki",
"812649", "Nagano\,\ Nagano",
"817713", "Kameoka\,\ Kyoto",
"811396", "Esashi\,\ Hokkaido",
"818463", "Takehara\,\ Hiroshima",
"818542", "Yasugi\,\ Shimane",
"819577", "Shimabara\,\ Nagasaki",
"812652", "Iida\,\ Nagano",
"8188099", "Tosashimizu\,\ Kochi",
"812854", "Oyama\,\ Tochigi",
"81532", "Toyohashi\,\ Aichi",
"81569", "Handa\,\ Aichi",
"811635", "Hamatonbetsu\,\ Hokkaido",
"814291", "Hanno\,\ Saitama",
"812957", "Daigo\,\ Ibaraki",
"8198299", "Hyuga\,\ Miyazaki",
"817368", "Iwade\,\ Wakayama",
"815394", "Hamamatsu\,\ Shizuoka",
"8126172", "Omachi\,\ Nagano",
"815745", "Minokamo\,\ Gifu",
"811555", "Obihiro\,\ Hokkaido",
"818806", "Sukumo\,\ Kochi",
"8153979", "Hamamatsu\,\ Shizuoka",
"81538", "Iwata\,\ Shizuoka",
"81577", "Takayama\,\ Gifu",
"817707", "Obama\,\ Fukui",
"812876", "Kuroiso\,\ Tochigi",
"812793", "Shibukawa\,\ Gunma",
"818835", "Mima\,\ Tokushima",
"818297", "Hatsukaichi\,\ Hiroshima",
"8112399", "Kuriyama\,\ Hokkaido",
"812587", "Nagaoka\,\ Niigata",
"81776", "Fukui\,\ Fukui",
"811756", "Noheji\,\ Aomori",
"817498", "Nagahama\,\ Shiga",
"81554", "Otsuki\,\ Yamanashi",
"818568", "Tsuwano\,\ Shimane",
"817732", "Fukuchiyama\,\ Kyoto",
"818365", "Ube\,\ Yamaguchi",
"812372", "Murayama\,\ Yamagata",
"812673", "Komoro\,\ Nagano",
"812782", "Numata\,\ Gunma",
"8124197", "Yanaizu\,\ Fukushima",
"814797", "Yokaichiba\,\ Chiba",
"819964", "Satsumasendai\,\ Kagoshima",
"819542", "Takeo\,\ Saga",
"815367", "Shitara\,\ Aichi",
"811466", "Erimo\,\ Hokkaido",
"819233", "Maebaru\,\ Fukuoka",
"815995", "Ago\,\ Mie",
"818894", "Susaki\,\ Kochi",
"811236", "Chitose\,\ Hokkaido",
"818692", "Oku\,\ Okayama",
"817952", "Nishiwaki\,\ Hyogo",
"819434", "Yame\,\ Fukuoka",
"819747", "Taketa\,\ Oita",
"818683", "Tsuyama\,\ Okayama",
"818382", "Hagi\,\ Yamaguchi",
"8126175", "Omachi\,\ Nagano",
"815754", "Sekigahara\,\ Gifu",
"811544", "Kushiro\,\ Hokkaido",
"81888", "Kochi\,\ Kochi",
"817949", "Kakogawa\,\ Hyogo",
"817456", "Yamatotakada\,\ Nara",
"811936", "Miyako\,\ Iwate",
"819933", "Ibusuki\,\ Kagoshima",
"811855", "Noshiro\,\ Akita",
"812550", "Yasuzuka\,\ Niigata",
"8188098", "Tosashimizu\,\ Kochi",
"818298", "Hatsukaichi\,\ Hiroshima",
"814285", "Sagamihara\,\ Kanagawa",
"8198294", "Nobeoka\,\ Miyazaki",
"811972", "Mizusawa\,\ Iwate",
"812588", "Nagaoka\,\ Niigata",
"812385", "Yonezawa\,\ Yamagata",
"815582", "Shimoda\,\ Shizuoka",
"81460", "Odawara\,\ Kanagawa",
"814756", "Togane\,\ Chiba",
"812695", "Nakano\,\ Nagano",
"817497", "Nagahama\,\ Shiga",
"812746", "Tomioka\,\ Gunma",
"819974", "Yakushima\,\ Kagoshima",
"818567", "Tsuwano\,\ Shimane",
"81721", "Tondabayashi\,\ Osaka",
"81952", "Saga\,\ Saga",
"814798", "Yokaichiba\,\ Chiba",
"818375", "Mine\,\ Yamaguchi",
"815973", "Owase\,\ Mie",
"818842", "Anan\,\ Tokushima",
"8153978", "Hamamatsu\,\ Shizuoka",
"812554", "Joetsu\,\ Niigata",
"815368", "Shitara\,\ Aichi",
"811583", "Monbetsu\,\ Hokkaido",
"81493", "Higashimatsuyama\,\ Saitama",
"81834", "Tokuyama\,\ Yamaguchi",
"81286", "Utsunomiya\,\ Tochigi",
"81738", "Gobo\,\ Wakayama",
"8198298", "Hyuga\,\ Miyazaki",
"81233", "Shinjo\,\ Yamagata",
"8199331", "Kagoshima\,\ Kagoshima",
"811523", "Shari\,\ Hokkaido",
"818956", "Uwajima\,\ Ehime",
"817684", "Wajima\,\ Ishikawa",
"8153967", "Hamamatsu\,\ Shizuoka",
"812832", "Sano\,\ Tochigi",
"81423", "Kokubunji\,\ Tokyo",
"81958", "Nagasaki\,\ Nagasaki",
"81825", "Hiroshima\,\ Hiroshima",
"812856", "Mooka\,\ Tochigi",
"8165", "Osaka\,\ Osaka",
"811394", "Matsumae\,\ Hokkaido",
"812911", "Hokota\,\ Ibaraki",
"819682", "Yamaga\,\ Kumamoto",
"812242", "Shiroishi\,\ Miyagi",
"81484", "Kawaguchi\,\ Saitama",
"812475", "Ishikawa\,\ Fukushima",
"818462", "Takehara\,\ Hiroshima",
"817677", "Nanao\,\ Ishikawa",
"817712", "Kameoka\,\ Kyoto",
"819824", "Nobeoka\,\ Miyazaki",
"81896", "Iyomishima\,\ Ehime",
"812653", "Iida\,\ Nagano",
"81244", "Hobara\,\ Fukushima",
"818543", "Yasugi\,\ Shimane",
"81989", "Naha\,\ Okinawa",
"81177", "Aomori\,\ Aomori",
"81138", "Hakodate\,\ Hokkaido",
"812564", "Sanjo\,\ Niigata",
"81476", "Narita\,\ Chiba",
"818557", "Kawamoto\,\ Shimane",
"81191", "Ichinoseki\,\ Iwate",
"812647", "Nagano\,\ Nagano",
"819665", "Hitoyoshi\,\ Kumamoto",
"812898", "Kanuma\,\ Tochigi",
"811865", "Odate\,\ Akita",
"817476", "Shimonoseki\,\ Yamaguchi",
"811658", "Kamikawa\,\ Hokkaido",
"812560", "Itoigawa\,\ Niigata",
"81568", "Kasugai\,\ Aichi",
"814281", "Sagamihara\,\ Kanagawa",
"811952", "Ninohe\,\ Iwate",
"81432", "Chiba\,\ Chiba",
"812482", "Shirakawa\,\ Fukushima",
"811875", "Kakunodate\,\ Akita",
"81793", "Himeji\,\ Hyogo",
"817466", "Totsukawa\,\ Nara",
"81298", "Tsuchiura\,\ Ibaraki",
"814776", "Funabashi\,\ Chiba",
"81222", "Sendai\,\ Miyagi",
"818596", "Yonago\,\ Tottori",
"815764", "Gero\,\ Gifu",
"81184", "Yurihonjo\,\ Akita",
"818584", "Kurayoshi\,\ Tottori",
"812994", "Ishioka\,\ Ibaraki",
"817678", "Nanao\,\ Ishikawa",
"817962", "Toyooka\,\ Hyogo",
"8186553", "Kurashiki\,\ Okayama",
"81723", "Sakai\,\ Osaka",
"815733", "Ena\,\ Gifu",
"8112395", "Kuriyama\,\ Hokkaido",
"81292", "Mito\,\ Ibaraki",
"81438", "Kisarazu\,\ Chiba",
"819954", "Kajiki\,\ Kagoshima",
"818945", "Yawatahama\,\ Ehime",
"8198292", "Nobeoka\,\ Miyazaki",
"81176", "Towada\,\ Aomori",
"812574", "Kashiwazaki\,\ Niigata",
"818558", "Kawamoto\,\ Shimane",
"8126179", "Omachi\,\ Nagano",
"812648", "Nagano\,\ Nagano",
"811537", "Nakashibetsu\,\ Hokkaido",
"812897", "Kanuma\,\ Tochigi",
"812235", "Sendai\,\ Miyagi",
"812419", "Tajima\,\ Fukushima",
"819734", "Hita\,\ Oita",
"812614", "Omachi\,\ Nagano",
"818245", "Miyoshi\,\ Hiroshima",
"811732", "Goshogawara\,\ Aomori",
"8153972", "Hamamatsu\,\ Shizuoka",
"81775", "Otsu\,\ Shiga",
"818879", "Muroto\,\ Kochi",
"81827", "Iwakuni\,\ Yamaguchi",
"812935", "Mito\,\ Ibaraki",
"818976", "Niihama\,\ Ehime",
"812837", "Sano\,\ Tochigi",
"811541", "Teshikaga\,\ Hokkaido",
"819786", "Kitsuki\,\ Oita",
"8161", "Osaka\,\ Osaka",
"811874", "Kakunodate\,\ Akita",
"818388", "Tamagawa\,\ Yamaguchi",
"8153966", "Hamamatsu\,\ Shizuoka",
"818585", "Kurayoshi\,\ Tottori",
"815765", "Gero\,\ Gifu",
"812230", "Sendai\,\ Miyagi",
"81937", "Kitakyushu\,\ Fukuoka",
"812995", "Ishioka\,\ Ibaraki",
"818698", "Bizen\,\ Okayama",
"818240", "Higashi\-ku\,\ Hiroshima",
"819726", "Usuki\,\ Oita",
"817616", "Komatsu\,\ Ishikawa",
"812930", "Mito\,\ Ibaraki",
"819955", "Kajiki\,\ Kagoshima",
"81420", "Tokorozawa\,\ Saitama",
"812575", "Tokamachi\,\ Niigata",
"812963", "Shimodate\,\ Ibaraki",
"818944", "Yawatahama\,\ Ehime",
"818562", "Masuda\,\ Shimane",
"8147955", "Yokaichiba\,\ Chiba",
"812378", "Sagae\,\ Yamagata",
"812788", "Maebashi\,\ Gunma",
"817738", "Maizuru\,\ Kyoto",
"812234", "Sendai\,\ Miyagi",
"81587", "Ichinomiya\,\ Aichi",
"81463", "Hiratsuka\,\ Kanagawa",
"817492", "Hikone\,\ Shiga",
"819735", "Hita\,\ Oita",
"818244", "Miyoshi\,\ Hiroshima",
"81853", "Izumo\,\ Shimane",
"812615", "Omachi\,\ Nagano",
"815979", "Kumano\,\ Mie",
"8164", "Osaka\,\ Osaka",
"817483", "Yokaichi\,\ Shiga",
"817996", "Tsuna\,\ Hyogo",
"818656", "Kasaoka\,\ Okayama",
"812934", "Takahagi\,\ Ibaraki",
"8125482", "Murakami\,\ Niigata",
"81729", "Yao\,\ Osaka",
"811977", "Kitakami\,\ Iwate",
"811589", "Okoppe\,\ Hokkaido",
"812546", "Murakami\,\ Niigata",
"812838", "Sano\,\ Tochigi",
"8186993", "Bizen\,\ Okayama",
"819742", "Mie\,\ Oita",
"812679", "Saku\,\ Nagano",
"818387", "Tamagawa\,\ Yamaguchi",
"811395", "Esashi\,\ Hokkaido",
"81533", "Toyohashi\,\ Aichi",
"812474", "Ishikawa\,\ Fukushima",
"812799", "Naganohara\,\ Gunma",
"81586", "Ichinomiya\,\ Aichi",
"8124196", "Yanaizu\,\ Fukushima",
"818697", "Bizen\,\ Okayama",
"819825", "Hyuga\,\ Miyazaki",
"814792", "Choshi\,\ Chiba",
"819547", "Kashima\,\ Saga",
"812551", "Joetsu\,\ Niigata",
"815362", "Shinshiro\,\ Aichi",
"812565", "Sanjo\,\ Niigata",
"811556", "Obihiro\,\ Hokkaido",
"819553", "Imari\,\ Saga",
"817737", "Maizuru\,\ Kyoto",
"818689", "Okayama\,\ Okayama",
"819664", "Hitoyoshi\,\ Kumamoto",
"812377", "Sagae\,\ Yamagata",
"812787", "Numata\,\ Gunma",
"81849", "Fukuyama\,\ Hiroshima",
"817943", "Kakogawa\,\ Hyogo",
"815746", "Minokamo\,\ Gifu",
"81936", "Kitakyushu\,\ Fukuoka",
"817353", "Shingu\,\ Fukuoka",
"812582", "Nagaoka\,\ Niigata",
"81983", "Takanabe\,\ Miyazaki",
"817702", "Tsuruga\,\ Fukui",
"811363", "Kutchan\,\ Hokkaido",
"811864", "Odate\,\ Akita",
"811978", "Kitakami\,\ Iwate",
"818292", "Hiroshima\,\ Hiroshima",
"811854", "Oga\,\ Akita",
"81924", "Fukuoka\,\ Fukuoka",
"811353", "Yoichi\,\ Hokkaido",
"811652", "Shibetsu\,\ Hokkaido",
"811943", "Iwaizumi\,\ Iwate",
"81268", "Ueda\,\ Nagano",
"819946", "Kanoya\,\ Kagoshima",
"81763", "Fukuno\,\ Toyama",
"814284", "Tachikawa\,\ Tokyo",
"812384", "Yonezawa\,\ Yamagata",
"812892", "Utsunomiya\,\ Tochigi",
"81429", "Tokorozawa\,\ Saitama",
"812694", "Nakano\,\ Nagano",
"81935", "Kitakyushu\,\ Fukuoka",
"818477", "Tojo\,\ Hiroshima",
"81262", "Nagano\,\ Nagano",
"819975", "Naze\,\ Kagoshima",
"811532", "Nemuro\,\ Hokkaido",
"8125484", "Murakami\,\ Niigata",
"818796", "Tonosho\,\ Kagawa",
"814280", "Tachikawa\,\ Tokyo",
"818873", "Aki\,\ Kochi",
"818374", "Nagato\,\ Yamaguchi",
"81544", "Fujinomiya\,\ Shizuoka",
"812555", "Itoigawa\,\ Niigata",
"8125488", "Tsugawa\,\ Niigata",
"81585", "Ibigawa\,\ Gifu",
"817718", "Sonobe\,\ Kyoto",
"819688", "Tamana\,\ Kumamoto",
"815959", "Kameyama\,\ Mie",
"812914", "Hokota\,\ Ibaraki",
"812248", "Ogawara\,\ Miyagi",
"811957", "Iwate\,\ Iwate",
"817685", "Wajima\,\ Ishikawa",
"812487", "Sukagawa\,\ Fukushima",
"812413", "Kitakata\,\ Fukushima",
"818676", "Kuse\,\ Okayama",
"814220", "Kokubunji\,\ Tokyo",
"818666", "Ibara\,\ Okayama",
"81199", "Morioka\,\ Iwate",
"81531", "Tahara\,\ Aichi",
"818834", "Kamojima\,\ Tokushima",
"81948", "Iizuka\,\ Fukuoka",
"812659", "Ina\,\ Nagano",
"81942", "Kurume\,\ Fukuoka",
"814702", "Tateyama\,\ Chiba",
"818478", "Tojo\,\ Hiroshima",
"811984", "Hanamaki\,\ Iwate",
"818552", "Hamada\,\ Shimane",
"812571", "Muika\,\ Niigata",
"818364", "Ube\,\ Yamaguchi",
"81592", "Tsu\,\ Mie",
"819573", "Isahaya\,\ Nagasaki",
"819965", "Satsumasendai\,\ Kagoshima",
"8167", "Osaka\,\ Osaka",
"817672", "Hakui\,\ Ishikawa",
"818467", "Mima\,\ Tokushima",
"817717", "Sonobe\,\ Kyoto",
"815986", "Matsusaka\,\ Mie",
"815994", "Ago\,\ Mie",
"818895", "Susaki\,\ Kochi",
"817968", "Hamasaka\,\ Hyogo",
"818202", "Yanai\,\ Yamaguchi",
"819687", "Tamana\,\ Kumamoto",
"819435", "Yame\,\ Fukuoka",
"81157", "Kitami\,\ Hokkaido",
"815755", "Sekigahara\,\ Gifu",
"812247", "Ogawara\,\ Miyagi",
"817723", "Miyazu\,\ Kyoto",
"811545", "Kushiro\,\ Hokkaido",
"818360", "Ogori\,\ Yamaguchi",
"812488", "Sukagawa\,\ Fukushima",
"811958", "Iwate\,\ Iwate",};
$areanames{ja} = {"817683", "輪島",
"817617", "加賀",
"812415", "柳津",
"812239", "仙台",
"811524", "網走",
"818949", "宇和",
"811584", "遠軽",
"819593", "大瀬戸",
"81426", "八王子",
"815974", "尾鷲",
"818875", "土佐山田",
"81845", "因島",
"812836", "佐野",
"819973", "種子島",
"811976", "北上",
"811638", "利尻礼文",
"81552", "甲府",
"815586", "下田",
"817365", "和歌山橋本",
"815748", "美濃白川",
"8188096", "土佐清水",
"817912", "相生",
"811543", "釧路",
"819546", "鹿島",
"819728", "臼杵",
"819934", "指宿",
"819433", "八女",
"81196", "盛岡",
"81471", "柏",
"811232", "千歳",
"81725", "和泉",
"817452", "大和高田",
"819788", "国東",
"819963", "川内",
"81832", "下関",
"81143", "室蘭",
"812955", "常陸大宮",
"81427", "相模原",
"812674", "小諸",
"817998", "津名",
"811752", "むつ",
"818680", "岡山",
"81272", "前橋",
"812786", "沼田",
"817736", "舞鶴",
"812794", "渋川",
"811557", "十勝池田",
"81281", "宇都宮",
"811567", "十勝清水",
"818476", "府中",
"812613", "大町",
"817485", "八日市",
"8199347", "鹿児島",
"8111", "札幌",
"812965", "下館",
"819947", "志布志",
"814297", "飯能",
"818668", "井原",
"815954", "上野",
"81488", "浦和",
"811956", "岩手",
"819953", "大口",
"814289", "青梅",
"817907", "播磨山崎",
"8125487", "津川",
"81134", "小樽",
"814229", "武蔵野三鷹",
"81726", "茨木",
"818583", "倉吉",
"81482", "川口",
"8186995", "岡山瀬戸",
"815999", "津",
"81473", "市川",
"81727", "池田",
"814998", "小笠原",
"817945", "加古川",
"817355", "新宮",
"818803", "土佐中村",
"817472", "五条",
"818678", "新見",
"812654", "飯田",
"81425", "立川",
"81939", "北九州",
"818544", "木次",
"8144", "川崎",
"812975", "水海道",
"812246", "大河原",
"818369", "宇部",
"811393", "松前",
"817716", "園部",
"815987", "三瀬谷",
"818466", "木江",
"81893", "大洲",
"818262", "加計",
"818798", "土庄",
"811863", "鹿角",
"811552", "帯広",
"81166", "旭川",
"812748", "富岡",
"814758", "東金",
"811757", "野辺地",
"817944", "加古川",
"817354", "新宮",
"812586", "長岡",
"81986", "都城",
"818296", "広島",
"81252", "新潟",
"819663", "人吉",
"817706", "小浜",
"817457", "大和高田",
"812655", "飯田",
"812974", "水海道",
"818958", "御荘",
"818545", "木次",
"812473", "石川",
"819746", "竹田",
"811237", "栗山",
"81583", "岐阜",
"812933", "高萩",
"817917", "竜野",
"818243", "東広島",
"812559", "安塚",
"817496", "長浜",
"817484", "八日市",
"81572", "多治見",
"8162", "大阪",
"81578", "神岡",
"812964", "下館",
"819808", "八重山",
"8147950", "八日市場",
"815955", "上野",
"812878", "烏山",
"819673", "熊本一の宮",
"811938", "宮古",
"81179", "三戸",
"81987", "日南",
"81280", "古河",
"8198297", "日向",
"81167", "富良野",
"817612", "小松",
"811873", "角館",
"819935", "加世田",
"814240", "国分寺",
"815982", "松阪",
"818267", "千代田",
"818598", "根雨",
"817238", "寝屋川",
"818978", "伯方",
"812675", "佐久",
"81928", "福岡",
"812569", "巻",
"814706", "大原",
"81922", "福岡",
"81863", "玉野",
"812795", "渋川",
"818833", "鴨島",
"81581", "高富",
"812414", "柳津",
"8188091", "窪川",
"818512", "西郷",
"812913", "鉾田",
"812579", "小出",
"811525", "網走",
"811585", "遠軽",
"817902", "福崎",
"812858", "真岡",
"818874", "安芸",
"815769", "荘川",
"819942", "大根占",
"811656", "美深",
"8153962", "天竜",
"81985", "宮崎",
"817364", "和歌山橋本",
"815398", "浜松",
"812383", "米沢",
"811853", "男鹿",
"811562", "本別",
"812999", "潮来",
"81551", "韮崎",
"81226", "気仙沼",
"812932", "高萩",
"8182941", "広島",
"811735", "五所川原",
"818242", "東広島",
"8112391", "夕張",
"819977", "瀬戸内",
"818564", "益田",
"811376", "八雲",
"819672", "熊本一の宮",
"817965", "豊岡",
"819597", "福江",
"815758", "郡上八幡",
"817613", "小松",
"812485", "白河",
"817687", "能都",
"819556", "唐津",
"811553", "帯広",
"811862", "鹿角",
"81898", "今治",
"811939", "宮古",
"81724", "岸和田貝塚",
"81892", "久万",
"811366", "寿都",
"819662", "人吉",
"818493", "尾道",
"819967", "出水",
"812558", "新井",
"818290", "広島",
"814794", "銚子",
"812580", "十日町",
"812472", "石川",
"81478", "佐原",
"819809", "八重山",
"819685", "玉名",
"819437", "田主丸",
"812879", "烏山",
"81227", "仙台",
"8126177", "長野",
"811547", "白糠",
"818587", "郡家",
"81553", "山梨",
"819828", "高千穂",
"817903", "福崎",
"812568", "巻",
"819957", "加治木",
"818845", "丹生谷",
"8125480", "村上",
"811356", "岩内",
"811534", "中標津",
"819943", "鹿屋",
"811946", "久慈",
"81282", "栃木",
"81956", "佐世保",
"812894", "宇都宮",
"812382", "米沢",
"812617", "大町",
"817239", "寝屋川",
"811563", "本別",
"81288", "今市",
"811852", "男鹿",
"819576", "島原",
"815399", "天竜",
"815768", "下呂",
"818204", "柳井",
"811397", "奥尻",
"8198293", "延岡",
"815983", "松阪",
"814700", "鴨川",
"818695", "岡山瀬戸",
"817955", "三田",
"817726", "峰山",
"81549", "静岡",
"812998", "潮来",
"81250", "新津",
"817674", "羽咋",
"81778", "武生",
"81273", "高崎",
"812644", "木曾福島",
"812375", "村山",
"81424", "武蔵野三鷹",
"812578", "六日町",
"818554", "浜田",
"818807", "宿毛",
"819738", "玖珠",
"812859", "小山",
"81833", "下松",
"81142", "伊達",
"818832", "鴨島",
"81225", "石巻",
"812780", "前橋",
"811542", "釧路",
"811639", "利尻礼文",
"819432", "八女",
"818205", "柳井",
"811233", "千歳",
"818686", "津山",
"817954", "西脇",
"818694", "岡山",
"817675", "七尾",
"8125483", "村上",
"812477", "三春",
"81862", "岡山",
"819962", "川内",
"81923", "福岡",
"817453", "大和高田",
"819667", "水俣",
"812645", "木曾福島",
"812374", "村山",
"818948", "宇和",
"818555", "江津",
"812238", "仙台",
"811753", "むつ",
"8183768", "下関",
"8199343", "鹿児島",
"81975", "大分",
"811867", "鷹巣",
"811877", "大曲",
"817682", "輪島",
"8198290", "延岡",
"812549", "津川",
"819592", "大瀬戸",
"819677", "矢部",
"818844", "阿南",
"811535", "厚岸",
"812830", "宇都宮",
"819972", "種子島",
"8147957", "八日市場",
"812895", "宇都宮",
"819789", "杵築",
"81480", "久喜",
"818247", "庄原",
"8186697", "倉敷",
"812937", "水戸",
"814288", "青梅",
"818837", "阿波池田",
"812698", "飯山",
"81582", "岐阜",
"817473", "五条",
"814228", "武蔵野三鷹",
"818802", "窪川",
"81969", "天草",
"818378", "下関",
"814795", "銚子",
"81253", "新潟",
"818263", "加計",
"811392", "木古内",
"818669", "総社",
"819684", "山鹿",
"81270", "伊勢崎",
"81977", "別府",
"811857", "能代",
"818679", "新見",
"812387", "長井",
"812612", "大町",
"811734", "五所川原",
"814701", "鴨川",
"818368", "宇部",
"818565", "益田",
"819952", "大口",
"811646", "羽幌",
"817463", "吉野",
"8112396", "栗山",
"815998", "阿児",
"81249", "郡山",
"81550", "御殿場",
"817964", "豊岡",
"81984", "小林",
"818582", "倉吉",
"815736", "中津川",
"812917", "水戸",
"812484", "白河",
"817672", "羽咋",
"8167", "大阪",
"819965", "川内",
"811958", "岩手",
"818360", "小郡",
"811545", "釧路",
"819687", "玉名",
"819435", "八女",
"818202", "柳井",
"818834", "鴨島",
"818666", "井原",
"812642", "木曾福島",
"812571", "六日町",
"818552", "浜田",
"818478", "東城",
"817718", "園部",
"81585", "揖斐川",
"817967", "八鹿",
"8125488", "津川",
"819595", "有川",
"818796", "土庄",
"814280", "立川",
"818873", "安芸",
"812413", "喜多方",
"818676", "久世",
"814220", "国分寺",
"812487", "須賀川",
"817685", "輪島",
"812248", "大河原",
"812914", "鉾田",
"812384", "米沢",
"811737", "鰺ケ沢",
"81924", "福岡",
"811854", "男鹿",
"811532", "根室",
"8125484", "村上",
"819975", "名瀬",
"817363", "和歌山橋本",
"814996", "八丈島",
"812892", "宇都宮",
"815746", "美濃加茂",
"817353", "新宮",
"817943", "加古川",
"819664", "人吉",
"812377", "寒河江",
"818689", "岡山",
"818805", "土佐中村",
"811978", "北上",
"811636", "北見枝幸",
"811864", "大館",
"815588", "修善寺大仁",
"81983", "高鍋",
"811395", "江差",
"812838", "佐野",
"812551", "上越",
"815362", "新城",
"812973", "水海道",
"814792", "銚子",
"818697", "備前",
"817957", "丹波柏原",
"81586", "一宮",
"8124196", "柳津",
"812474", "石川",
"81587", "一宮",
"817738", "舞鶴",
"812788", "前橋",
"818562", "益田",
"812963", "下館",
"812546", "村上",
"818656", "笠岡",
"817996", "津名",
"812934", "高萩",
"8125482", "村上",
"817483", "八日市",
"812615", "大町",
"818244", "三次",
"812230", "仙台",
"818585", "倉吉",
"818388", "田万川",
"811874", "角館",
"819786", "杵築",
"8161", "大阪",
"81420", "所沢",
"819955", "加治木",
"819674", "熊本一の宮",
"818847", "牟岐",
"819726", "臼杵",
"814708", "大原",
"812897", "鹿沼",
"811537", "中標津",
"815953", "上野",
"8198292", "延岡",
"818976", "新居浜",
"812935", "水戸",
"81775", "大津",
"811732", "五所川原",
"818245", "三次",
"812614", "大町",
"818584", "倉吉",
"818596", "米子",
"814776", "船橋",
"81222", "仙台",
"812570", "小出",
"811875", "角館",
"812482", "白河",
"819954", "加治木",
"8112395", "栗山",
"819675", "熊本一の宮",
"81723", "堺",
"81228", "築館",
"817962", "豊岡",
"811456", "門別富川",
"812647", "長野",
"819665", "人吉",
"818804", "土佐中村",
"81191", "一関",
"81476", "成田",
"818557", "川本",
"814281", "相模原",
"812560", "糸魚川",
"811865", "大館",
"811658", "上川",
"819913", "硫黄島",
"815396", "浜松",
"81484", "川口",
"819682", "山鹿",
"818207", "久賀",
"811394", "松前",
"8165", "大阪",
"812856", "真岡",
"81138", "函館",
"818543", "安来",
"812653", "飯田",
"81896", "伊予三島",
"817677", "七尾",
"812475", "石川",
"819594", "有川",
"81286", "宇都宮",
"81834", "徳山",
"811583", "紋別",
"818842", "阿南",
"815973", "尾鷲",
"81952", "佐賀",
"81958", "長崎",
"817684", "輪島",
"81423", "国分寺",
"818956", "宇和島",
"811523", "斜里",
"8198298", "日向",
"814756", "東金",
"812385", "米沢",
"812588", "長岡",
"8198294", "延岡",
"818298", "廿日市",
"812550", "安塚",
"811855", "能代",
"81721", "富田林",
"818567", "津和野",
"819974", "屋久島",
"812746", "富岡",
"817952", "西脇",
"818692", "邑久",
"811466", "えりも",
"819964", "川内",
"815367", "設楽",
"814797", "八日市場",
"811936", "宮古",
"819933", "指宿",
"811544", "釧路",
"819434", "八女",
"81776", "福井",
"818835", "脇町",
"819806", "沖縄宮古",
"812876", "黒磯",
"812793", "渋川",
"812372", "村山",
"812673", "小諸",
"81554", "大月",
"817498", "長浜",
"8198299", "日向",
"812957", "大子",
"817474", "五条",
"81569", "半田",
"81577", "高山",
"811555", "帯広",
"819912", "中之島",
"819683", "山鹿",
"819826", "日向",
"818264", "安芸吉田",
"81162", "稚内",
"81988", "那覇",
"8153963", "天竜",
"814709", "鴨川",
"812566", "三条",
"812652", "飯田",
"818542", "安来",
"81584", "大垣",
"81950", "平戸",
"817367", "岩出",
"815952", "上野",
"817230", "寝屋川",
"8128798", "大田原",
"812576", "十日町",
"811733", "五所川原",
"814770", "市川",
"812996", "潮来",
"817728", "峰山",
"812483", "白河",
"81439", "木更津",
"817615", "小松",
"81925", "福岡",
"8186996", "岡山瀬戸",
"812417", "会津山口",
"817464", "吉野",
"818877", "嶺北",
"819578", "島原",
"815766", "下呂",
"817963", "豊岡",
"818299", "広島",
"815756", "郡上八幡",
"817953", "西脇",
"818693", "邑久",
"817454", "大和高田",
"812977", "竜ケ崎",
"812589", "長岡",
"819932", "指宿",
"811378", "今金",
"81926", "福岡",
"811234", "千歳",
"818896", "須崎",
"815985", "松阪",
"812792", "渋川",
"812373", "村山",
"812672", "小諸",
"811754", "むつ",
"817947", "三木",
"817357", "串本",
"81864", "倉敷",
"817905", "福崎",
"811582", "紋別",
"81739", "田辺",
"815972", "尾鷲",
"818843", "阿南",
"812556", "糸魚川",
"8168", "大阪",
"819208", "対馬佐賀",
"811522", "斜里",
"8188095", "土佐清水",
"817487", "水口",
"81927", "福岡",
"817914", "相生",
"81220", "迫",
"819558", "唐津",
"812967", "笠間",
"819945", "鹿屋",
"817904", "福崎",
"818872", "室戸",
"818479", "東城",
"815566", "身延",
"818376", "美祢",
"812412", "喜多方",
"81774", "宇治",
"818514", "海士",
"812696", "飯山",
"81144", "苫小牧",
"81277", "桐生",
"817915", "相生",
"811564", "上士幌",
"814226", "武蔵野三鷹",
"819944", "鹿屋",
"814286", "相模原",
"811533", "根室",
"815957", "上野",
"812893", "宇都宮",
"817362", "和歌山橋本",
"817673", "羽咋",
"814771", "市川",
"815738", "中津川",
"817455", "大和高田",
"812657", "伊那",
"818547", "掛合",
"81276", "太田",
"818660", "岡山瀬戸",
"811648", "焼尻",
"815984", "松阪",
"818203", "柳井",
"811235", "夕張",
"815996", "阿児",
"811986", "遠野",
"81485", "熊谷",
"818366", "宇部",
"81192", "大船渡",
"818553", "浜田",
"812643", "木曾福島",
"81949", "直方",
"81557", "伊東",
"81284", "足利",
"81835", "防府",
"812839", "佐野",
"818563", "益田",
"812962", "下館",
"81728", "寝屋川",
"8186698", "倉敷",
"81722", "堺",
"818946", "宇和",
"81486", "浦和",
"817482", "八日市",
"812236", "仙台",
"8153960", "天竜",
"818688", "美作",
"811527", "美幌",
"817614", "小松",
"815977", "熊野",
"815589", "修善寺大仁",
"817465", "吉野",
"81474", "船橋",
"811587", "中湧別",
"817942", "加古川",
"817352", "新宮",
"812677", "佐久",
"817475", "下市",
"812797", "渋川",
"811554", "帯広",
"811336", "石狩",
"81848", "尾道",
"8125489", "津川",
"8183767", "下関",
"812789", "前橋",
"81487", "浦和",
"818265", "安芸吉田",
"819937", "加世田",
"814793", "銚子",
"815363", "新城",
"812972", "水海道",
"81555", "吉田",
"818397", "小郡",
"8166", "大阪",
"818846", "丹生谷",
"8198296", "日向",
"819727", "臼杵",
"81236", "山形",
"812939", "水戸",
"819787", "国東",
"812553", "上越",
"818952", "宇和島",
"818249", "東広島",
"812547", "村上",
"817997", "津名",
"818657", "笠岡",
"814752", "茂原",
"8125481", "村上",
"812742", "藤岡",
"819679", "高森",
"811558", "広尾",
"811945", "久慈",
"81877", "丸亀",
"817618", "加賀",
"818696", "備前",
"817956", "三田",
"818684", "津山",
"811462", "浦河",
"817725", "宮津",
"815753", "関",
"811869", "大館",
"818893", "佐川",
"811932", "釜石",
"81126", "岩見沢",
"81734", "和歌山",
"819575", "諫早",
"819802", "南大東",
"811637", "北見枝幸",
"812872", "大田原",
"81930", "行橋",
"8186999", "岡山瀬戸",
"815747", "美濃白川",
"812376", "寒河江",
"81564", "岡崎",
"819733", "日田",
"811736", "五所川原",
"818972", "新居浜",
"812573", "柏崎",
"812389", "米沢",
"81125", "滝川",
"818677", "新見",
"812486", "須賀川",
"8112390", "夕張",
"812993", "石岡",
"818592", "米子",
"81242", "会津若松",
"814772", "市川",
"815734", "恵那",
"815988", "三瀬谷",
"81743", "奈良",
"817966", "八鹿",
"815763", "下呂",
"811452", "早来",
"811644", "留萌",
"811375", "八雲",
"818797", "土庄",
"811365", "倶知安",
"81875", "観音寺",
"815392", "浜松",
"819948", "志布志",
"814298", "飯能",
"81797", "西宮",
"819555", "唐津",
"818667", "井原",
"812852", "小山",
"81962", "熊本",
"81188", "秋田",
"812563", "三条",
"81823", "呉",
"817908", "播磨山崎",
"81235", "鶴岡",
"819823", "延岡",
"819686", "玉名",
"81294", "常陸太田",
"81495", "本庄",
"819205", "厳原",
"81434", "千葉",
"81182", "横手",
"811364", "倶知安",
"815742", "美濃加茂",
"819969", "中甑",
"81933", "北九州",
"811549", "釧路",
"819554", "伊万里",
"819807", "沖縄宮古",
"811632", "天塩",
"811333", "当別",
"812877", "黒磯",
"81899", "松山",
"81765", "魚津",
"811937", "宮古",
"8112393", "夕張",
"81857", "鳥取",
"819204", "郷ノ浦",
"817940", "加古川",
"81467", "藤沢",
"8182943", "広島",
"815366", "設楽",
"814796", "八日市場",
"8169", "大阪",
"8188097", "土佐清水",
"819599", "大瀬戸",
"81466", "藤沢",
"812747", "富岡",
"814757", "東金",
"812233", "岩沼",
"81537", "掛川",
"8145", "横浜",
"812542", "新発田",
"818943", "八幡浜",
"817992", "洲本",
"818652", "倉敷",
"819782", "豊後高田",
"817458", "大和榛原",
"8153977", "天竜",
"818957", "御荘",
"815735", "恵那",
"818391", "小郡",
"811238", "栗山",
"819979", "徳之島",
"811645", "留萌",
"811374", "森",
"819722", "佐伯",
"81779", "大野",
"818685", "津山",
"817676", "七尾",
"81548", "榛原",
"817724", "宮津",
"81542", "静岡",
"815993", "鳥羽",
"818206", "柳井",
"817468", "上北山",
"812857", "真岡",
"819574", "諫早",
"81992", "鹿児島",
"818363", "宇部",
"818662", "高梁",
"815397", "浜松",
"811983", "花巻",
"81465", "小田原",
"812646", "長野",
"81998", "鹿児島",
"818556", "江津",
"818792", "三本松",
"818268", "千代田",
"811457", "門別富川",
"818597", "根雨",
"81594", "桑名",
"81535", "浜松",
"81740", "今津",
"814777", "船橋",
"815563", "鰍沢青柳",
"818672", "福渡",
"818373", "長門",
"8125486", "津川",
"812619", "大町",
"818977", "伯方",
"814223", "武蔵野三鷹",
"81766", "高岡",
"81944", "瀬高",
"812693", "中野",
"8198291", "延岡",
"814992", "伊豆大島",
"812896", "鹿沼",
"811536", "厚岸",
"8175", "京都",
"811354", "余市",
"811944", "岩泉",
"814283", "青梅",
"81243", "二本松",
"81436", "市原",
"818475", "府中",
"81885", "小松島",
"817486", "水口",
"812232", "岩沼",
"817494", "彦根",
"81567", "津島",
"817993", "洲本",
"81742", "奈良",
"812543", "新発田",
"818942", "八幡浜",
"813", "東京",
"812557", "新井",
"819968", "出水",
"819783", "豊後高田",
"81172", "弘前",
"81178", "八戸",
"819438", "田主丸",
"819723", "佐伯",
"811548", "弟子屈",
"811955", "二戸",
"8178", "神戸",
"818294", "廿日市",
"817704", "敦賀",
"817946", "三木",
"81822", "広島",
"81963", "熊本",
"817459", "大和榛原",
"817356", "串本",
"812584", "長岡",
"815743", "美濃加茂",
"81828", "広島",
"81183", "湯沢",
"81259", "佐渡",
"819978", "徳之島",
"811332", "当別",
"81566", "刈谷",
"817715", "亀岡",
"819598", "福江",
"815757", "郡上八幡",
"812245", "大河原",
"819744", "三重",
"817688", "能都",
"812976", "竜ケ崎",
"818876", "土佐山田",
"818793", "三本松",
"812835", "佐野",
"815767", "下呂",
"812890", "宇都宮",
"811398", "熊石",
"8112397", "栗山",
"81565", "豊田",
"812997", "潮来",
"815562", "鰍沢青柳",
"818372", "長門",
"818673", "福渡",
"812416", "田島",
"81124", "芦別",
"818808", "土佐清水",
"812577", "六日町",
"814222", "武蔵野三鷹",
"819737", "玖珠",
"812692", "中野",
"815585", "下田",
"817366", "岩出",
"811975", "水沢",
"814282", "青梅",
"811654", "名寄",
"812640", "長野",
"818588", "郡家",
"818385", "萩",
"819827", "高千穂",
"815992", "鳥羽",
"812567", "巻",
"81737", "湯浅",
"812785", "沼田",
"818362", "宇部",
"818663", "総社",
"817735", "福知山",
"814704", "館山",
"81234", "酒田",
"81886", "徳島",
"811982", "花巻",
"81929", "福岡",
"81494", "秩父",
"812618", "大町",
"812956", "常陸大宮",
"8188093", "窪川",
"8186552", "倉敷",
"811878", "大曲",
"811463", "浦河",
"815752", "関",
"818384", "萩",
"818892", "佐川",
"811559", "帯広",
"819544", "武雄",
"81839", "山口",
"819678", "矢部",
"81946", "甘木",
"819936", "加世田",
"811933", "釜石",
"81764", "富山",
"812796", "渋川",
"812873", "大田原",
"817734", "福知山",
"812784", "沼田",
"819803", "名護",
"811337", "石狩",
"81596", "伊勢",
"814705", "館山",
"817950", "三田",
"818690", "岡山",
"818248", "庄原",
"81543", "静岡",
"812676", "佐久",
"812938", "水戸",
"8163", "大阪",
"812834", "宇都宮",
"811586", "中湧別",
"812478", "三春",
"81266", "諏訪",
"811526", "網走",
"812552", "上越",
"818953", "宇和島",
"819668", "水俣",
"81947", "田川",
"8186992", "備前",
"818947", "宇和",
"81559", "沼津",
"81240", "磐城富岡",
"812237", "仙台",
"814753", "茂原",
"815584", "下田",
"8188090", "窪川",
"812743", "藤岡",
"811974", "水沢",
"811868", "鷹巣",
"811655", "名寄",
"818295", "廿日市",
"811858", "能代",
"817705", "小浜",
"812388", "長井",
"812585", "長岡",
"815393", "浜松",
"811987", "遠野",
"818367", "宇部",
"81932", "北九州",
"812562", "三条",
"812853", "小山",
"817714", "亀岡",
"819822", "延岡",
"815997", "阿児",
"818464", "竹原",
"812244", "白石",
"81464", "厚木",
"812656", "伊那",
"81938", "北九州",
"818546", "掛合",
"8186994", "岡山瀬戸",
"818838", "阿波池田",
"814287", "青梅",
"815956", "上野",
"817960", "八鹿",
"819732", "日田",
"818474", "府中",
"817495", "長浜",
"81534", "浜松",
"812697", "飯山",
"818973", "新居浜",
"814227", "武蔵野三鷹",
"812572", "柏崎",
"818377", "下関",
"812992", "石岡",
"818593", "米子",
"815762", "下呂",
"819949", "大根占",
"811453", "早来",
"8186998", "岡山瀬戸",
"811954", "二戸",
"8186691", "倉敷",
"81489", "草加",
"815994", "阿児",
"818895", "須崎",
"817968", "浜坂",
"815986", "松阪",
"817717", "園部",
"818467", "木江",
"819573", "諫早",
"81592", "津",
"812488", "須賀川",
"817723", "宮津",
"815755", "関",
"812247", "大河原",
"81157", "北見",
"812659", "伊那",
"81948", "飯塚",
"818549", "石見大田",
"811738", "鰺ケ沢",
"81531", "田原",
"81199", "盛岡",
"818364", "宇部",
"811984", "花巻",
"814702", "館山",
"81942", "久留米",
"812555", "糸魚川",
"81544", "富士宮",
"818374", "長門",
"815564", "鰍沢青柳",
"811957", "岩手",
"817906", "播磨山崎",
"815959", "亀山",
"819688", "玉名",
"814284", "立川",
"81763", "福野",
"811943", "岩泉",
"819946", "鹿屋",
"81268", "上田",
"811353", "余市",
"811652", "士別",
"814224", "武蔵野三鷹",
"811566", "十勝清水",
"81262", "長野",
"81935", "北九州",
"818477", "東城",
"812694", "中野",
"81429", "所沢",
"81936", "北九州",
"81849", "福山",
"812787", "沼田",
"817737", "舞鶴",
"811556", "帯広",
"819553", "伊万里",
"818292", "広島",
"817702", "敦賀",
"811363", "倶知安",
"812582", "長岡",
"81533", "豊橋",
"818387", "田万川",
"8186993", "備前",
"819742", "三重",
"812679", "佐久",
"819547", "鹿島",
"812565", "三条",
"818848", "牟岐",
"819825", "日向",
"812799", "長野原",
"819735", "日田",
"81463", "平塚",
"817492", "彦根",
"812234", "仙台",
"8147955", "八日市場",
"812378", "寒河江",
"818944", "八幡浜",
"812575", "十日町",
"811977", "北上",
"811589", "興部",
"81729", "八尾",
"8164", "大阪",
"815587", "修善寺大仁",
"815979", "熊野",
"81853", "出雲",
"815765", "下呂",
"812837", "佐野",
"811541", "弟子屈",
"812930", "水戸",
"817616", "小松",
"818240", "東広島",
"818698", "備前",
"817958", "丹波柏原",
"812995", "石岡",
"81937", "北九州",
"818472", "甲山",
"819734", "日田",
"812235", "仙台",
"812419", "田島",
"812648", "長野",
"812574", "柏崎",
"81176", "十和田",
"818558", "川本",
"818945", "八幡浜",
"81827", "岩国",
"8153961", "天竜",
"818879", "室戸",
"81184", "本荘",
"815764", "下呂",
"818208", "久賀",
"811643", "石狩深川",
"81298", "土浦",
"817466", "十津川",
"81793", "姫路",
"811952", "二戸",
"81432", "千葉",
"81438", "木更津",
"81292", "水戸",
"8186553", "倉敷",
"815733", "恵那",
"8188092", "窪川",
"81964", "松橋",
"812994", "石岡",
"817678", "七尾",
"814707", "大原",
"812898", "鹿沼",
"81562", "尾張横須賀",
"811538", "根室標津",
"81568", "春日井",
"817476", "下市",
"812242", "白石",
"812911", "鉾田",
"81177", "青森",
"812564", "三条",
"81989", "那覇",
"81244", "原町",
"819824", "延岡",
"817712", "亀岡",
"818462", "竹原",
"818266", "千代田",
"81493", "東松山",
"815368", "設楽",
"812554", "上越",
"815565", "鰍沢青柳",
"814798", "八日市場",
"818375", "美祢",
"81825", "広島",
"812832", "佐野",
"8199331", "鹿児島",
"81233", "新庄",
"8188094", "窪川",
"81738", "御坊",
"81460", "小田原",
"815582", "下田",
"811972", "水沢",
"8188098", "土佐清水",
"814285", "相模原",
"814225", "武蔵野三鷹",
"817916", "竜野",
"817497", "長浜",
"812695", "中野",
"8153974", "天竜",
"819233", "前原",
"815995", "阿児",
"811236", "千歳",
"818894", "須崎",
"819542", "武雄",
"8124197", "柳津",
"817456", "大和高田",
"817949", "加古川",
"81888", "高知",
"815754", "関",
"818683", "津山",
"818382", "萩",
"819747", "竹田",
"811756", "野辺地",
"812587", "長岡",
"8112399", "栗山",
"812979", "竜ケ崎",
"818297", "廿日市",
"817707", "小浜",
"812782", "沼田",
"817732", "福知山",
"818365", "宇部",
"818568", "津和野",
"817368", "岩出",
"815394", "浜松",
"814291", "飯能",
"811635", "浜頓別",
"81532", "豊橋",
"81538", "磐田",
"818806", "宿毛",
"815745", "美濃加茂",
"812649", "長野",
"818559", "川本",
"817727", "峰山",
"812243", "白石",
"812418", "会津山口",
"81591", "津",
"812854", "小山",
"8188099", "土佐清水",
"818878", "嶺北",
"819577", "島原",
"818463", "竹原",
"811396", "江差",
"817713", "亀岡",
"812616", "大町",
"818473", "甲山",
"812545", "村上",
"8112394", "夕張",
"818974", "新居浜",
"81545", "富士",
"8152", "名古屋",
"817995", "洲本",
"818655", "鴨方",
"811357", "岩内",
"811947", "久慈",
"81229", "古川",
"811539", "根室標津",
"811454", "鵡川",
"819956", "加治木",
"81462", "厚木",
"811953", "二戸",
"8182920", "廿日市",
"812899", "鹿沼",
"811642", "石狩深川",
"819725", "佐伯",
"81852", "松江",
"819785", "豊後高田",
"81468", "横須賀",
"81934", "北九州",
"818594", "米子",
"818586", "倉吉",
"815732", "恵那",
"8112398", "栗山",
"819232", "前原",
"811934", "釜石",
"819543", "武雄",
"811546", "釧路",
"819966", "出水",
"818383", "萩",
"818682", "津山",
"811464", "静内",
"81593", "四日市",
"817488", "水口",
"8183766", "下関",
"811367", "寿都",
"812968", "笠間",
"81546", "静岡",
"819804", "名護",
"819557", "唐津",
"812783", "沼田",
"818665", "高梁",
"817733", "福知山",
"812874", "大田原",
"81762", "金沢",
"818675", "久世",
"81547", "島田",
"812978", "竜ケ崎",
"818954", "宇和島",
"817686", "能都",
"812833", "宇都宮",
"8198295", "日向",
"818795", "三本松",
"811377", "八雲",
"81263", "松本",
"819596", "福江",
"815583", "下田",
"812744", "藤岡",
"811973", "水沢",
"811551", "十勝池田",
"819976", "名瀬",
"8112392", "夕張",
"8182942", "広島",
"814754", "茂原",
"817948", "三木",
"81878", "高松",
"815737", "中津川",
"818674", "久世",
"812658", "伊那",
"818548", "石見大田",
"8125485", "津川",
"818955", "宇和島",
"811647", "羽幌",
"818794", "三本松",
"819940", "志布志",
"8186997", "岡山瀬戸",
"814994", "三宅",
"812745", "藤岡",
"81492", "川越",
"8199345", "鹿児島",
"817969", "浜坂",
"811653", "士別",
"811352", "余市",
"811942", "岩泉",
"811856", "能代",
"814755", "東金",
"812386", "長井",
"81965", "八代",
"812489", "須賀川",
"811935", "釜石",
"819572", "諫早",
"817722", "宮津",
"811465", "静内",
"81561", "瀬戸",
"819805", "名護",
"818836", "脇町",
"818664", "高梁",
"81245", "福島",
"812875", "大田原",
"815958", "亀山",
"814703", "館山",
"817493", "彦根",
"81433", "千葉",
"818246", "三次",
"81792", "姫路",
"818975", "新居浜",
"812544", "新発田",
"812678", "佐久",
"812936", "水戸",
"81246", "いわき",
"818654", "鴨方",
"817994", "洲本",
"812798", "長野原",
"81798", "西宮",
"811455", "鵡川",
"81979", "中津",
"819724", "佐伯",
"811372", "鹿部",
"819676", "高森",
"819938", "加世田",
"819784", "豊後高田",
"811876", "大曲",
"818595", "米子",
"81260", "阿南町",
"818398", "小郡",
"814775", "船橋",
"81744", "大和高田",
"815395", "浜松",
"811634", "浜頓別",
"819552", "伊万里",
"811866", "鷹巣",
"811362", "倶知安",
"819666", "水俣",
"817959", "三田",
"817703", "敦賀",
"818293", "廿日市",
"812583", "長岡",
"815744", "美濃加茂",
"818687", "美作",
"819743", "三重",
"811528", "美幌",
"81563", "西尾",
"812476", "三春",
"818490", "尾道",
"815978", "熊野",
"812855", "小山",
"81940", "宗像",
"81174", "蟹田",
"811588", "興部",};

    sub new {
      my $class = shift;
      my $number = shift;
      $number =~ s/(^\+81|\D)//g;
      my $self = bless({ number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self if ($self->is_valid());
      $number =~ s/^(?:0)//;
      $self = bless({ number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self->is_valid() ? $self : undef;
    }
1;