# automatically generated file, don't edit



# Copyright 2011 David Cantrell, derived from data from libphonenumber
# http://code.google.com/p/libphonenumber/
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
package Number::Phone::StubCountry::DE;
use base qw(Number::Phone::StubCountry);

use strict;
use warnings;
use utf8;
our $VERSION = 1.20230112200226;

my $formatters = [
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            3[02]|
            40|
            [68]9
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3,13})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            2(?:
              0[1-389]|
              12[0-8]
            )|
            3(?:
              [35-9][15]|
              4[015]
            )|
            906|
            2(?:
              [13][14]|
              2[18]
            )|
            (?:
              2[4-9]|
              4[2-9]|
              [579][1-9]|
              [68][1-8]
            )1
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{3,12})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            [24-6]|
            3(?:
              3(?:
                0[1-467]|
                2[127-9]|
                3[124578]|
                7[1257-9]|
                8[1256]|
                9[145]
              )|
              4(?:
                2[135]|
                4[13578]|
                9[1346]
              )|
              5(?:
                0[14]|
                2[1-3589]|
                6[1-4]|
                7[13468]|
                8[13568]
              )|
              6(?:
                2[1-489]|
                3[124-6]|
                6[13]|
                7[12579]|
                8[1-356]|
                9[135]
              )|
              7(?:
                2[1-7]|
                4[145]|
                6[1-5]|
                7[1-4]
              )|
              8(?:
                21|
                3[1468]|
                6|
                7[1467]|
                8[136]
              )|
              9(?:
                0[12479]|
                2[1358]|
                4[134679]|
                6[1-9]|
                7[136]|
                8[147]|
                9[1468]
              )
            )|
            70[2-8]|
            8(?:
              0[2-9]|
              [1-8]
            )|
            90[7-9]|
            [79][1-9]|
            3[68]4[1347]|
            3(?:
              47|
              60
            )[1356]|
            3(?:
              3[46]|
              46|
              5[49]
            )[1246]|
            3[4579]3[1357]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{2,11})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '138',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '3',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{5})(\\d{2,10})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '181',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{5,11})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            1(?:
              3|
              80
            )|
            9
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d)(\\d{4,10})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '1[67]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{7,8})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '8',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{7,12})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '18500',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{5})(\\d{6})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '7',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '18[68]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{7})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '15[0568]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{5})(\\d{6})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '15[1279]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{7})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '18',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{8})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            1(?:
              6[023]|
              7
            )
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{2})(\\d{7,8})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '15[279]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{2})(\\d{7})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '15',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{2})(\\d{8})'
                }
              ];

my $validators = {
                'fixed_line' => '
          32\\d{9,11}|
          49[1-6]\\d{10}|
          322\\d{6}|
          49[0-7]\\d{3,9}|
          (?:
            [34]0|
            [68]9
          )\\d{3,13}|
          (?:
            2(?:
              0[1-689]|
              [1-3569]\\d|
              4[0-8]|
              7[1-7]|
              8[0-7]
            )|
            3(?:
              [3569]\\d|
              4[0-79]|
              7[1-7]|
              8[1-8]
            )|
            4(?:
              1[02-9]|
              [2-48]\\d|
              5[0-6]|
              6[0-8]|
              7[0-79]
            )|
            5(?:
              0[2-8]|
              [124-6]\\d|
              [38][0-8]|
              [79][0-7]
            )|
            6(?:
              0[02-9]|
              [1-358]\\d|
              [47][0-8]|
              6[1-9]
            )|
            7(?:
              0[2-8]|
              1[1-9]|
              [27][0-7]|
              3\\d|
              [4-6][0-8]|
              8[0-5]|
              9[013-7]
            )|
            8(?:
              0[2-9]|
              1[0-79]|
              2\\d|
              3[0-46-9]|
              4[0-6]|
              5[013-9]|
              6[1-8]|
              7[0-8]|
              8[0-24-6]
            )|
            9(?:
              0[6-9]|
              [1-4]\\d|
              [589][0-7]|
              6[0-8]|
              7[0-467]
            )
          )\\d{3,12}
        ',
                'geographic' => '
          32\\d{9,11}|
          49[1-6]\\d{10}|
          322\\d{6}|
          49[0-7]\\d{3,9}|
          (?:
            [34]0|
            [68]9
          )\\d{3,13}|
          (?:
            2(?:
              0[1-689]|
              [1-3569]\\d|
              4[0-8]|
              7[1-7]|
              8[0-7]
            )|
            3(?:
              [3569]\\d|
              4[0-79]|
              7[1-7]|
              8[1-8]
            )|
            4(?:
              1[02-9]|
              [2-48]\\d|
              5[0-6]|
              6[0-8]|
              7[0-79]
            )|
            5(?:
              0[2-8]|
              [124-6]\\d|
              [38][0-8]|
              [79][0-7]
            )|
            6(?:
              0[02-9]|
              [1-358]\\d|
              [47][0-8]|
              6[1-9]
            )|
            7(?:
              0[2-8]|
              1[1-9]|
              [27][0-7]|
              3\\d|
              [4-6][0-8]|
              8[0-5]|
              9[013-7]
            )|
            8(?:
              0[2-9]|
              1[0-79]|
              2\\d|
              3[0-46-9]|
              4[0-6]|
              5[013-9]|
              6[1-8]|
              7[0-8]|
              8[0-24-6]
            )|
            9(?:
              0[6-9]|
              [1-4]\\d|
              [589][0-7]|
              6[0-8]|
              7[0-467]
            )
          )\\d{3,12}
        ',
                'mobile' => '
          15[0-25-9]\\d{8}|
          1(?:
            6[023]|
            7\\d
          )\\d{7,8}
        ',
                'pager' => '
          16(?:
            4\\d{1,10}|
            [89]\\d{1,11}
          )
        ',
                'personal_number' => '700\\d{8}',
                'specialrate' => '(
          180\\d{5,11}|
          13(?:
            7[1-6]\\d\\d|
            8
          )\\d{4}
        )|(
          (?:
            137[7-9]|
            900(?:
              [135]|
              9\\d
            )
          )\\d{6}
        )|(
          18(?:
            1\\d{5,11}|
            [2-9]\\d{8}
          )
        )',
                'toll_free' => '800\\d{7,12}',
                'voip' => ''
              };
my %areanames = ();
$areanames{en} = {"4934345", "Bad\ Lausick",
"498074", "Schnaitsee",
"495664", "Morschen",
"492858", "Hünxe",
"4938333", "Horst\ bei\ Grimmen",
"4936043", "Kirchheilingen",
"4939482", "Gatersleben",
"4935054", "Lauenstein\ Sachsen",
"496135", "Bodenheim\ Rhein",
"498622", "Tacherting\-Peterskirchen",
"496725", "Gau\-Algesheim",
"496175", "Friedrichsdorf\ Taunus",
"498034", "Brannenburg",
"4934745", "Winningen\ Sachsen\-Anhalt",
"4938733", "Karbow\-Vietlübbe",
"492104", "Mettmann",
"497240", "Pfinztal",
"499746", "Zeitlofs",
"4937325", "Niederbobritzsch",
"497545", "Immenstaad\ am\ Bodensee",
"492421", "Düren",
"499357", "Gräfendorf\ Bayern",
"495207", "Schloss\ Holte\-Stukenbrock",
"499408", "Altenthann",
"49465", "Sylt",
"494553", "Geschendorf",
"494953", "Bunde",
"498196", "Pürgen",
"496826", "Bexbach",
"498547", "Osterhofen\-Gergweis",
"497436", "Messstetten\-Oberdigisheim",
"498324", "Hindelang",
"4937348", "Oberwiesenthal\ Kurort",
"497945", "Wüstenrot",
"497476", "Bisingen",
"493592", "Kirschau",
"4933968", "Meyenburg\ Kreis\ Prignitz",
"495362", "Wolfsburg\-Fallersleben",
"4939861", "Gramzow\ bei\ Prenzlau",
"4934328", "Hartha\ bei\ Döbeln",
"4936965", "Stadtlengsfeld",
"492269", "Kierspe\-Rönsahl",
"497392", "Laupheim",
"4939489", "Strassberg\ Harz",
"4939054", "Flechtingen",
"496559", "Leidenborn",
"4937384", "Wechselburg",
"4938466", "Jürgenshagen",
"495223", "Bünde",
"499845", "Oberdachstetten",
"497123", "Metzingen\ Württemberg",
"497773", "Bodman\-Ludwigshafen",
"4936703", "Gräfenthal",
"496621", "Bad\ Hersfeld",
"4934441", "Hohenmölsen",
"498266", "Kirchheim\ in\ Schwaben",
"494563", "Scharbeutz\-Haffkrug",
"499367", "Unterpleichfeld",
"497733", "Engen\ Hegau",
"4937421", "Oelsnitz\ Vogtland",
"4936422", "Reinstädt\ Thüringen",
"495654", "Herleshausen",
"498105", "Gilching",
"4935032", "Langenhennersdorf",
"4939039", "Bonese",
"496004", "Lich\-Eberstadt",
"492697", "Blankenheim\-Ahrhütte",
"4936207", "Plaue\ Thüringen",
"492325", "Wanne\-Eickel",
"496184", "Langenselbold",
"494132", "Amelinghausen",
"4939032", "Mahlsdorf\ bei\ Salzwedel",
"499231", "Marktredwitz",
"496569", "Bickendorf",
"498085", "Sankt\ Wolfgang",
"499271", "Thurnau\-Alladorf",
"494722", "Cuxhaven\-Altenbruch",
"494172", "Salzhausen",
"493441", "Zeitz",
"4939391", "Lückstedt",
"494963", "Dörpen",
"493867", "Lübstorf",
"499202", "Waischenfeld",
"495352", "Schöningen",
"495045", "Springe\-Bennigsen",
"494101", "Pinneberg",
"499443", "Abensberg",
"499828", "Rügland",
"497266", "Kirchardt",
"498733", "Mengkofen",
"4933238", "Senzke",
"496893", "Saarbrücken\-Ensheim",
"498123", "Moosinning",
"498773", "Neufahrn\ in\ Niederbayern",
"492801", "Xanten",
"493865", "Holthusen",
"492832", "Kevelaer",
"499451", "Schierling",
"495934", "Haren\-Rütenbrock",
"492327", "Bochum\-Wattenscheid",
"492872", "Rhede\ Westfalen",
"492695", "Insul",
"4933397", "Wandlitz",
"497085", "Enzklösterle",
"494168", "Neu\ Wulmstorf\-Elstorf",
"495842", "Schnega",
"495574", "Oberweser",
"492944", "Rietberg\-Mastholte",
"495534", "Eschershausen\ an\ der\ Lenne",
"497528", "Neukirch\ bei\ Tettnang",
"495156", "Coppenbrügge",
"494492", "Saterland",
"494830", "Süderhastedt",
"494336", "Owschlag",
"4934773", "Schwittersdorf",
"499365", "Rimpar",
"493328", "Teltow",
"494794", "Worpswede\-Ostersode",
"496391", "Dahn",
"4936075", "Dingelstädt\ Eichsfeld",
"496406", "Lollar",
"492303", "Unna",
"496639", "Ottrau",
"497622", "Schopfheim",
"499461", "Roding",
"497034", "Ehningen",
"49681", "Saarbrücken",
"499847", "Ergersheim",
"495028", "Pennigsehl",
"496244", "Westhofen\ Rheinhessenen",
"494941", "Aurich",
"494298", "Lilienthal",
"495585", "Herzberg\-Sieber",
"492486", "Nettersheim",
"496383", "Glan\-Münchweiler",
"497947", "Forchtenberg",
"497256", "Philippsburg",
"496703", "Wöllstein\ Rheinhessen",
"4938205", "Tessin\ bei\ Rostock",
"4939603", "Burg\ Stargard",
"498545", "Hofkirchen\ Bayern",
"495378", "Sassenburg\-Platendorf",
"495205", "Bielefeld\-Sennestadt",
"494633", "Satrup",
"499229", "Mainleus",
"499355", "Frammersbach",
"4936691", "Eisenberg\ Thüringen",
"494804", "Nordhastedt",
"4935603", "Burg\ Spreewald",
"492606", "Winningen\ Mosel",
"497324", "Herbrechtingen",
"494673", "Joldelund",
"498392", "Markt\ Rettenbach",
"496727", "Gensingen",
"494541", "Ratzeburg",
"494158", "Roseburg",
"4939030", "Brunau",
"496881", "Lebach",
"495166", "Walsrode\-Kirchboitzen",
"4937609", "Wolkenburg\ Mulde",
"492404", "Alsdorf\ Rheinland",
"498634", "Garching\ an\ der\ Alz",
"498803", "Peissenberg",
"498249", "Ettringen\ Wertach",
"4939266", "Förderstedt",
"499925", "Bayerisch\ Eisenstein",
"495909", "Wettrup",
"498022", "Tegernsee",
"492771", "Dillenburg",
"497954", "Kirchberg\ an\ der\ Jagst",
"493968", "Schönbeck",
"4933652", "Neuzelle",
"492382", "Ahlen\ Westfalen",
"4938295", "Satow\ bei\ Bad\ Doberan",
"495064", "Gross\ Düngen",
"497825", "Kippenheim",
"496435", "Wallmerod",
"492567", "Ahaus\-Alstätte",
"494238", "Neddenaverbergen",
"49871", "Landshut",
"496670", "Ludwigsau\ Hessen",
"494305", "Westensee",
"496475", "Weilmünster\-Wolfenhausen",
"496630", "Schwalmtal\-Storndorf",
"4938450", "Tarnow\ bei\ Bützow",
"496257", "Seeheim\-Jugenheim",
"499854", "Wittelshofen",
"492684", "Puderbach\ Westerwald",
"498372", "Obergünzburg",
"4936027", "Lengenfeld\ Unterm\ Stein",
"498781", "Rottenburg\ an\ der\ Laaber",
"498332", "Ottobeuren",
"499088", "Mönchsdeggingen",
"4934651", "Rossla",
"497136", "Bad\ Friedrichshall",
"497554", "Heiligenberg\ Baden",
"495509", "Rosdorf\ Kreis\ Göttingen",
"499220", "Kasendorf\-Azendorf",
"497726", "Bad\ Dürrheim",
"499525", "Königsberg\ in\ Bayern",
"497176", "Spraitbach",
"4935266", "Heyda\ bei\ Riesa",
"495741", "Lübbecke",
"4937602", "Kirchberg\ Sachsen",
"4935693", "Lauschütz",
"4936601", "Hermsdorf\ Thüringen",
"492557", "Wettringen\ Kreis\ Steinfurt",
"492635", "Rheinbrohl",
"498405", "Stammham\ bei\ Ingolstadt",
"495276", "Marienmünster",
"492675", "Ediger\-Eller",
"496267", "Fahrenbach\ Baden",
"495236", "Blomberg\-Grossenmarpe",
"4939820", "Triepkendorf",
"496021", "Aschaffenburg",
"494681", "Wyk\ auf\ Föhr",
"497423", "Oberndorf\ am\ Neckar",
"4933634", "Berkenbrück\ Kreis\ Oder\-Spree",
"496833", "Rehlingen\-Siersburg",
"495054", "Bergen\-Sülze",
"496873", "Nonnweiler",
"497964", "Stödtlen",
"496331", "Pirmasens",
"497564", "Bad\ Wurzach",
"496782", "Birkenfeld\ Nahe",
"494734", "Stadland\-Seefeld",
"498685", "Kirchanschöring",
"4934973", "Osternienburg",
"494124", "Glückstadt",
"494774", "Hechthausen",
"4933203", "Kleinmachnow",
"494401", "Brake\ Unterweser",
"496371", "Landstuhl",
"499143", "Pappenheim\ Mittelfranken",
"493364", "Eisenhüttenstadt",
"49461", "Flensburg",
"497358", "Eberhardzell\-Füramoos",
"496484", "Beselich",
"494432", "Dötlingen\-Brettorf",
"4939087", "Jerchel\ Altmark",
"495645", "Borgentreich\-Borgholz",
"4935820", "Zodel",
"494839", "Wöhrden\ Dithmarschen",
"495594", "Bovenden\-Reyershausen",
"492246", "Lohmar\ Rheinland",
"492957", "Wünnenberg\-Haaren",
"496302", "Winnweiler",
"494472", "Lastrup",
"4937757", "Rittersgrün",
"4938452", "Lalendorf",
"494252", "Bruchhausen\-Vilsen",
"492955", "Büren\-Wewelsburg",
"495763", "Uchte",
"499151", "Hersbruck",
"499548", "Mühlhausen\ Mittelfranken",
"495647", "Lichtenau\-Kleinenberg",
"4935936", "Sohland\ Spree",
"496086", "Grävenwiesbach",
"4939364", "Dolle",
"4969", "Frankfurt\ am\ Main",
"494626", "Treia",
"498423", "Titting",
"4933833", "Wollin\ bei\ Brandenburg",
"495922", "Bad\ Bentheim",
"498687", "Taching\-Tengling",
"4934953", "Gräfenhainichen",
"492824", "Kalkar",
"4936338", "Bleicherode",
"4937600", "Neumark\ Sachsen",
"495522", "Osterode\ am\ Harz",
"4936461", "Bad\ Sulza",
"4937462", "Rothenkirchen\ Vogtland",
"498564", "Johanniskirchen",
"4936738", "Königsee",
"4939991", "Daberkow",
"4935364", "Lebusa",
"496106", "Rodgau",
"497685", "Gutach\-Bleibach",
"495149", "Wienhausen",
"496265", "Billigheim\ Baden",
"494468", "Friedeburg\-Reepsholt",
"492677", "Lutzerath",
"4934386", "Dürrweitzschen\ bei\ Grimma",
"499948", "Eschlkam",
"492555", "Schöppingen",
"495456", "Westerkappeln\-Velpe",
"4933335", "Pinnow\ Kreis\ Uckermark",
"494192", "Bad\ Bramstedt",
"498407", "Grossmehring",
"492637", "Weissenthurm",
"4938459", "Laage",
"499527", "Knetzgau",
"499344", "Gerchsheim",
"494323", "Bornhöved",
"497674", "Todtmoos",
"4934671", "Bad\ Frankenhausen\ Kyffhäuser",
"499283", "Rehau",
"497634", "Sulzburg",
"497803", "Gengenbach",
"4933679", "Wendisch\ Rietz",
"497249", "Stutensee",
"496039", "Karben",
"497022", "Nürtingen",
"495753", "Auetal\-Bernsen",
"498094", "Steinhöring",
"499161", "Neustadt\ an\ der\ Aisch",
"4939822", "Kratzeburg",
"493901", "Salzwedel",
"4935829", "Gersdorf\ bei\ Görlitz",
"494262", "Visselhövede",
"498825", "Krün",
"496195", "Kelkheim\ Taunus",
"499903", "Schöllnach",
"49771", "Donaueschingen",
"496477", "Greifenstein\-Nenderoth",
"494307", "Raisdorf",
"499503", "Oberhaid\ Oberfranken",
"494458", "Wiefelstede\-Spohle",
"497332", "Lauterstein",
"496329", "Weidenthal\ Pfalz",
"496255", "Lindenfels",
"496550", "Irrhausen",
"4939829", "Blankenförde",
"493501", "Pirna",
"4935822", "Hagenwerder",
"4938308", "Göhren\ Rügen",
"492565", "Gronau\-Epe",
"4934928", "Seegrehna",
"499642", "Kemnath\ Stadt",
"495466", "Merzen",
"4939405", "Hötensleben",
"498368", "Halblech",
"4933672", "Pfaffendorfb\ Beeskow",
"4935894", "Hähnichen",
"498726", "Schönau\ Niederbayern",
"494821", "Itzehoe",
"498176", "Egling\ bei\ Wolfratshausen",
"4933368", "Hohensaaten",
"493844", "Schwaan",
"499927", "Kirchberg\ Wald",
"498136", "Markt\ Indersdorf",
"4933768", "Prieros",
"498554", "Schönberg\ Niederbayern",
"499545", "Buttenheim",
"497746", "Wutöschingen",
"492958", "Büren\-Harth",
"492662", "Hachenburg",
"495721", "Stadthagen",
"495171", "Peine",
"496452", "Battenberg\ Eder",
"4938482", "Warin",
"495131", "Garbsen",
"497357", "Attenweiler",
"495102", "Laatzen",
"496754", "Martinstein",
"494351", "Eckernförde",
"493675", "Sonneberg\ Thüringen",
"498847", "Obersöchering",
"493635", "Kölleda",
"498461", "Beilngries",
"496526", "Bollendorf",
"4933051", "Nassenheide",
"494853", "Sankt\ Michaelisdonn",
"495082", "Langlingen",
"499392", "Faulbach\ Unterfranken",
"492364", "Haltern\ Westfalen",
"4934425", "Droyssig",
"499436", "Nittenau",
"494465", "Friedeburg\ Ostfriesland",
"496268", "Hüffenhardt",
"4939398", "Gross\ Garz",
"492558", "Horstmar",
"498042", "Lenggries",
"499945", "Arnbruck",
"497582", "Bad\ Buchau",
"494361", "Oldenburg\ in\ Holstein",
"492226", "Rheinbach",
"496764", "Rheinböllen",
"499087", "Marktoffingen",
"495625", "Naumburg\ Hessen",
"496462", "Gladenbach",
"494144", "Himmelpforten",
"493382", "Lehnin",
"493731", "Freiberg\ Sachsen",
"499773", "Unsleben",
"499123", "Lauf\ an\ der\ Pegnitz",
"4933394", "Blumberg\ Kreis\ Barnim",
"496869", "Merzig\-Silwingen",
"492652", "Mendig",
"493771", "Aue\ Sachsen",
"499733", "Münnerstadt",
"497367", "Aalen\-Ebnat",
"496198", "Eppstein",
"4936870", "Masserberg",
"496258", "Gernsheim",
"494455", "Jade\-Schweiburg",
"4937341", "Ehrenfriedersdorf",
"494277", "Schwaförden",
"497443", "Dornstetten",
"498365", "Wertach",
"492568", "Heek",
"494237", "Bendingbostel",
"4936742", "Uhlstädt",
"497202", "Karlsbad",
"497231", "Pforzheim",
"499107", "Trautskirchen",
"4938391", "Altenkirchen\ Rügen",
"496041", "Glauburg",
"4934321", "Leisnig",
"494863", "Sankt\ Peter\-Ording",
"493967", "Oertzenhof\ bei\ Strasburg",
"4934721", "Nienburg\ Saale",
"492354", "Meinerzhagen",
"497271", "Wörth\ am\ Rhein",
"4938736", "Goldberg",
"4938791", "Bad\ Wilsnack",
"497451", "Horb\ am\ Neckar",
"499928", "Kirchdorf\ im\ Wald",
"492163", "Schwalmtal\ Niederrhein",
"498582", "Röhrnbach",
"499105", "Grosshabersdorf",
"495129", "Söhlde",
"493965", "Burow\ bei\ Altentreptow",
"495603", "Gudensberg",
"496438", "Hünfelden",
"494235", "Langwedel\-Etelsen",
"498367", "Rosshaupten\ Forggensee",
"4935606", "Briesen\ bei\ Cottbus",
"492932", "Neheim\-Hüsten",
"495834", "Wittingen\-Knesebeck",
"499266", "Mitwitz",
"492972", "Schmallenberg",
"495542", "Witzenhausen",
"496053", "Wächtersbach",
"495874", "Soltendieck",
"496478", "Greifenstein\-Ulm",
"494275", "Ehrenburg",
"494308", "Schwedeneck",
"498443", "Hohenwart\ Paar",
"497365", "Essingen\ Württemberg",
"49221", "Cologne",
"499180", "Pyrbaum",
"495942", "Uelsen",
"498202", "Althegnenberg",
"492572", "Emsdetten",
"492844", "Rheinberg\-Orsoy",
"492532", "Ostbevern",
"4936204", "Stotternheim",
"4939606", "Glienke",
"494646", "Mohrkirch",
"495483", "Lienen",
"498271", "Meitingen",
"492501", "Münster\-Hiltrup",
"499085", "Alerheim",
"496593", "Hillesheim\ Eifel",
"498231", "Königsbrunn\ bei\ Augsburg",
"499528", "Donnersdorf",
"495491", "Damme\ Dümmer",
"492638", "Waldbreitbach",
"499256", "Stammbach",
"4933231", "Pausin",
"495306", "Cremlingen",
"499947", "Neukirchen\ bei\ Hl\ Blut",
"496581", "Saarburg",
"4934776", "Rothenschirmbach",
"494841", "Husum\ Nordsee",
"4935057", "Hermsdorf\ Erzgebirge",
"494467", "Wittmund\-Funnix",
"496063", "Bad\ König",
"492678", "Büchel\ bei\ Cochem",
"497461", "Tuttlingen",
"492153", "Nettetal\-Lobberich",
"4939205", "Langenweddingen",
"499622", "Hirschau\ Oberpfalz",
"494504", "Ratekau",
"496349", "Billigheim\-Ingenheim",
"499074", "Höchstädt\ an\ der\ Donau",
"498845", "Bad\ Kohlgrub",
"4938234", "Born\ Darss",
"4935205", "Ottendorf\-Okrilla",
"492293", "Nümbrecht",
"496201", "Weinheim\ Bergstr",
"493677", "Ilmenau\ Thüringen",
"495648", "Brakel\-Gehrden",
"4939057", "Rätzlingen\ Sachsen\-Anhalt",
"494284", "Selsingen",
"497355", "Hochdorf\ Riss",
"497229", "Iffezheim",
"496232", "Speyer",
"497042", "Vaihingen\ an\ der\ Enz",
"496272", "Hirschhorn\ Neckar",
"499324", "Dettelbach",
"499547", "Zapfendorf",
"49651", "Trier",
"499196", "Wiesenttal",
"494343", "Laboe",
"495402", "Bissendorf\ Kreis\ Osnabrück",
"496340", "Wörth\-Schaidt",
"499825", "Herrieden",
"497854", "Kehl\-Goldscheuer",
"493868", "Rastow",
"499094", "Tagmersheim",
"4939295", "Zuchau",
"498161", "Freising",
"4933920", "Walsleben\ bei\ Neuruppin",
"495384", "Seesen\-Gross\ Rhüden",
"495471", "Bohmte",
"496152", "Gross\-Gerau",
"498283", "Neuburg\ an\ der\ Kammel",
"4934976", "Gröbzig",
"495704", "Petershagen\-Friedewalde",
"4933206", "Fichtenwalde",
"498344", "Westendorf\ bei\ Kaufbeuren",
"499954", "Simbach\ Niederbayern",
"495431", "Quakenbrück",
"499554", "Untersteinbach\ Unterfranken",
"4936940", "Oepfershausen",
"495682", "Borken\ Hessen",
"494165", "Hollenstedt\ Nordheide",
"492867", "Heiden\ Kreis\ Borken",
"496292", "Seckach",
"497525", "Aulendorf",
"499726", "Euerbach",
"499176", "Allersberg",
"492441", "Kall",
"4940", "Hamburg",
"497220", "Forbach\-Hundsbach",
"498642", "Übersee",
"496745", "Gondershausen",
"492233", "Hürth\ Rheinland",
"494206", "Stuhr\-Heiligenrode",
"492273", "Kerpen\-Horrem",
"498503", "Neuhaus\ am\ Inn",
"496162", "Reinheim\ Odenwald",
"494444", "Goldenstedt",
"495025", "Estorf\ Weser",
"499423", "Geiselhöring",
"4935472", "Schlepzig",
"493421", "Torgau",
"4935263", "Gröditz\ bei\ Riesa",
"492992", "Marsberg",
"499964", "Stallwang",
"494539", "Westerau",
"494295", "Emtinghausen",
"4935696", "Briesnig",
"494742", "Dorum",
"498548", "Vilshofen\-Sandbach",
"492052", "Velbert\-Langenberg",
"498151", "Starnberg",
"499407", "Wenzenbach",
"499358", "Gössenheim",
"495208", "Leopoldshöhe",
"496573", "Gillenfeld",
"4933605", "Boossen",
"495375", "Müden\ Aller",
"498291", "Zusmarshausen",
"496533", "Morbach\ Hunsrück",
"495335", "Schladen",
"494155", "Büchen",
"499564", "Bad\ Rodach",
"494939", "Baltrum",
"492592", "Selm",
"4939263", "Unseburg",
"4934658", "Hayn\ Harz",
"497143", "Besigheim",
"4936608", "Seelingstädt\ bei\ Gera",
"492857", "Rees\-Mehr",
"496641", "Lauterbach\ Hessen",
"4934241", "Jesewitz",
"499189", "Berg\ bei\ Neumarkt\ in\ der\ Oberpfalz",
"4933704", "Baruth\ Mark",
"496138", "Mommenheim",
"4936949", "Obermassfeld\-Grimmenthal",
"4939452", "Ilsenburg",
"492855", "Voerde\ Niederrhein",
"496728", "Ober\-Hilbersheim",
"4934362", "Mügeln\ bei\ Oschatz",
"495337", "Kissenbrück",
"497151", "Waiblingen",
"4933922", "Karwesee",
"492463", "Titz",
"496653", "Burghaun",
"499405", "Bad\ Abbach",
"495429", "Melle\-Wellingholzhausen",
"495377", "Ehra\-Lessien",
"495822", "Ebstorf",
"4933637", "Beerfelde",
"492924", "Möhnesee",
"492524", "Ennigerloh",
"495183", "Lamspringe",
"4935025", "Liebstadt",
"4938301", "Putbus",
"4934921", "Kemberg",
"4933929", "Gühlen\-Glienicke",
"497948", "Öhringen\-Ohrnberg",
"498143", "Inning\ am\ Ammersee",
"493606", "Heiligenstadt\ Heilbad",
"499480", "Sünching",
"494297", "Ottersberg\-Posthausen",
"4937754", "Zwönitz",
"4933361", "Joachimsthal",
"495027", "Linsburg",
"499848", "Simmershofen",
"495261", "Lemgo",
"4935452", "Golssen",
"4939084", "Lindstedt",
"4939459", "Hasselfelde",
"4933438", "Altlandsberg",
"4936085", "Reinholterode",
"496663", "Steinau\ an\ der\ Strasse",
"497161", "Göppingen",
"493695", "Bad\ Salzungen",
"4934383", "Trebsen\ Mulde",
"492453", "Heinsberg\-Randerath",
"493327", "Werder\ Havel",
"496356", "Carlsberg\ Pfalz",
"493544", "Luckau\ Brandenburg",
"496747", "Emmelshausen",
"49971", "Bad\ Kissingen",
"4934783", "Gerbstedt",
"497903", "Mainhardt",
"494521", "Eutin",
"499674", "Schönsee",
"495191", "Soltau",
"492865", "Raesfeld",
"497344", "Blaubeuren",
"4938822", "Diedrichshagen\ bei\ Grevesmühlen",
"497527", "Wolfegg",
"499803", "Colmberg",
"499634", "Wiesau",
"4939933", "Vollrathsruhe",
"4933088", "Falkenthal",
"494167", "Apensen",
"4935434", "Altdöbern",
"493303", "Birkenwerder",
"4935933", "Neschwitz",
"4936331", "Ilfeld",
"4933836", "Butzow\ bei\ Brandenburg",
"4936731", "Unterloquitz",
"4939998", "Loitz\ bei\ Demmin",
"4936024", "Diedorf\ bei\ Mühlhausen",
"4934956", "Zörbig",
"495251", "Paderborn",
"494921", "Emden\ Stadt",
"499332", "Marktbreit",
"497503", "Wilhelmsdorf\ Württemberg",
"49760", "Oberried\ Breisgau",
"493944", "Blankenburg\ Harz",
"497642", "Endingen\ Kaiserstuhl",
"499827", "Lichtenau\ Mittelfranken",
"499372", "Klingenberg\ am\ Main",
"496224", "Sandhausen\ Baden",
"4938323", "Prohn",
"4934903", "Coswig\ Anhalt",
"4935751", "Welzow",
"494426", "Wangerland\-Horumersiel",
"498623", "Kirchweidach",
"4938723", "Kladrum",
"4936454", "Magdala",
"4938848", "Vellahn",
"492195", "Radevormwald",
"495861", "Dannenberg\ Elbe",
"495447", "Lembruch",
"494552", "Leezen",
"496186", "Grosskrotzenburg",
"494668", "Klanxbüll",
"494952", "Rhauderfehn",
"492255", "Euskirchen\-Flamersheim",
"4938825", "Klütz",
"495656", "Waldkappel",
"4934297", "Liebertwolkwitz",
"496565", "Dudeldorf",
"4938227", "Lüdershagen\ bei\ Barth",
"495363", "Wolfsburg\-Vorsfelde",
"4936082", "Ershausen",
"4934461", "Nebra\ Unstrut",
"497393", "Munderkingen",
"4939751", "Penkun",
"497485", "Empfingen",
"495222", "Bad\ Salzuflen",
"4935726", "Gross\ Särchen",
"497122", "St\ Johann\ Württemberg",
"496139", "Budenheim",
"496190", "Hattersheim\ am\ Main",
"497381", "Münsingen",
"494562", "Grömitz",
"4933984", "Blumenthal\ bei\ Pritzwalk",
"494707", "Langen\-Neuenwalde",
"4936945", "Henneberg",
"4935326", "Schönborn\ Kreis\ Elbe\-Elster",
"4935455", "Walddrehna",
"497732", "Radolfzell\ am\ Bodensee",
"495851", "Dahlenburg",
"4937431", "Mehltheuer\ Vogtland",
"496095", "Bessenbach",
"497474", "Haigerloch",
"495428", "Melle\-Neuenkirchen",
"498326", "Fischen\ im\ Allgäu",
"497434", "Winterlingen",
"4935022", "Bad\ Schandau",
"4937368", "Deutschneudorf",
"493581", "Görlitz",
"49391", "Magdeburg",
"499227", "Neuenmarkt",
"498194", "Vilgertshofen",
"496824", "Ottweiler",
"4933925", "Wustrau\-Altfriesack",
"494133", "Wittorf\ Kreis\ Lüneburg",
"498254", "Altomünster",
"493981", "Neustrelitz",
"49351", "Dresden",
"499744", "Zeitlofs\-Detter",
"497949", "Pfedelbach\-Untersteinbach",
"494173", "Wulfsen",
"494723", "Cuxhaven\-Altenwalde",
"4935841", "Grossschönau\ Sachsen",
"498036", "Stephanskirchen\ Simssee",
"4939455", "Schierke",
"496677", "Neuenstein\ Hessen",
"492265", "Reichshof\-Eckenhagen",
"494962", "Papenburg\-Aschendorf",
"49731", "Ulm\ Donau",
"496555", "Bleialf",
"495353", "Königslutter\ am\ Elm",
"499203", "Neudrossenfeld",
"499442", "Riedenburg",
"4936928", "Neuenhof\ Thüringen",
"498076", "Pfaffing",
"4939726", "Ducherow",
"496637", "Feldatal",
"4938758", "Dömitz",
"498381", "Lindenberg\ im\ Allgäu",
"495164", "Hodenhagen",
"496557", "Hallschlag",
"496635", "Kirtorf",
"498732", "Frontenhausen",
"4938378", "Heringsdorf\ Seebad",
"496675", "Breitenbach\ am\ Herzberg",
"492267", "Wipperfürth",
"496430", "Hahnstätten",
"498122", "Erding",
"498772", "Mallersdorf\-Pfaffenberg",
"492604", "Nassau\ Lahn",
"498434", "Rennertshofen",
"497326", "Neresheim",
"495341", "Salzgitter",
"4933602", "Alt\ Zeschdorf",
"492833", "Kerken",
"497194", "Spiegelberg",
"499920", "Bischofsmais",
"494806", "Sarzbüttel",
"492873", "Isselburg\-Werth",
"498549", "Vilshofen\-Pleinting",
"4936651", "Lobenstein",
"492331", "Hagen\ Westfalen",
"495209", "Gütersloh\-Friedrichsdorf",
"499359", "Karlstadt\-Wiesenfeld",
"495843", "Wustrow\ Wendland",
"499225", "Stadtsteinach",
"497254", "Waghäusel",
"4933609", "Brieskow\-Finkenheerd",
"494385", "Hohenfelde\ bei\ Kiel",
"4934601", "Teutschenthal",
"492371", "Iserlohn",
"494493", "Friesoythe\-Gehlenberg",
"494705", "Wremen",
"492484", "Mechernich\-Eiserfey",
"4935475", "Straupitz",
"49234", "Bochum",
"494938", "Hagermarsch",
"496246", "Eich\ Rheinhessen",
"492302", "Witten",
"499188", "Postbauer\-Heng",
"4933847", "Görzke",
"49831", "Kempten\ Allgäu",
"4939771", "Ueckermünde",
"4937203", "Gersdorf\ bei\ Chemnitz",
"496404", "Lich\ Hessen",
"497623", "Rheinfelden\ Baden",
"4935020", "Struppen",
"495808", "Gerdau",
"4939887", "Gerswalde",
"496771", "St\ Goarshausen",
"494796", "Teufelsmoor",
"493869", "Dümmer",
"496731", "Alzey",
"494334", "Bredenbek\ bei\ Rendsburg",
"496382", "Lauterecken",
"493462", "Bad\ Dürrenberg",
"495536", "Holzminden\-Neuhaus",
"495154", "Aerzen",
"496567", "Oberkail",
"492435", "Erkelenz\-Lövenich",
"493764", "Meerane",
"492630", "Mülheim\-Kärlich",
"492257", "Reckerscheid",
"494481", "Hatten\-Sandkrug",
"494632", "Steinbergkirche",
"496684", "Hofbieber\-Schwarzbach",
"49441", "Oldenburg",
"4939224", "Büden",
"492546", "Coesfeld\-Lette",
"4936626", "Auma",
"495445", "Drebber",
"495976", "Salzbergen",
"495294", "Hövelhof\-Espeln",
"495936", "Twist",
"494672", "Langenhorn",
"498393", "Holzgünz",
"499369", "Uettingen",
"497264", "Bad\ Rappenau",
"4939292", "Biederitz",
"4935771", "Bad\ Muskau",
"492639", "Anhausen\ Kreis\ Neuwied",
"49281", "Wesel",
"498023", "Bayrischzell",
"499651", "Vohenstrauss",
"492244", "Königswinter\-Oberpleis",
"498802", "Huglfing",
"49355", "Cottbus",
"4936875", "Straufhain\-Streufdorf",
"493366", "Beeskow",
"495147", "Uetze\-Hänigsen",
"492383", "Bönen",
"496486", "Katzenelnbogen",
"4933878", "Nennhausen",
"493860", "Raben\ Steinfeld",
"4939971", "Gnoien",
"494394", "Bokhorst",
"494126", "Horst\ Holstein",
"494776", "Osten\-Altendorf",
"4939427", "Ströbeck",
"494736", "Butjadingen\-Tossens",
"4939209", "Wanzleben",
"4935202", "Klingenberg\ Sachsen",
"4937293", "Eppendorf\ Sachsen",
"496348", "Offenbach\ an\ der\ Queich",
"497566", "Argenbühl",
"499765", "Trappstadt",
"497966", "Unterschneidheim",
"498373", "Altusried",
"4939202", "Gross\ Ammensleben",
"4935209", "Mohorn",
"495056", "Winsen\-Meissendorf",
"499360", "Thüngen",
"4936373", "Buttstädt",
"4935971", "Sebnitz",
"498333", "Babenhausen\ Schwaben",
"494835", "Albersdorf\ Holstein",
"49395", "Neubrandenburg",
"495234", "Horn\-Bad\ Meinberg",
"497228", "Forbach",
"495274", "Nieheim",
"492137", "Neuss\-Norf",
"494875", "Stafstedt",
"498245", "Türkheim\ Wertach",
"499929", "Ruhmannsfelden",
"495905", "Beesten",
"497724", "St\ Georgen\ im\ Schwarzwald",
"497174", "Mögglingen",
"4935246", "Ziegenhain\ Sachsen",
"4933476", "Neuhardenberg",
"495128", "Hohenhameln",
"497134", "Weinsberg",
"497556", "Uhldingen\-Mühlhofen",
"4935874", "Bernstadt\ an\ der\ Eigen",
"499661", "Sulzbach\-Rosenberg",
"496439", "Holzappel",
"497422", "Schramberg",
"495285", "Bad\ Pyrmont\-Kleinenberg",
"494884", "Schwabstedt",
"496832", "Beckingen\-Reimsbach",
"496872", "Losheim\ am\ See",
"496544", "Rhaunen",
"496327", "Neustadt\-Lachen",
"496695", "Jesberg",
"492686", "Weyerbusch",
"496479", "Waldbrunn\ Westerwald",
"493663", "Schleiz",
"499856", "Dürrwangen",
"496783", "Baumholder",
"494241", "Bassum",
"499142", "Treuchtlingen",
"494433", "Dötlingen",
"497247", "Linkenheim\-Hochstetten",
"495066", "Sarstedt",
"4934636", "Schafstädt",
"4934691", "Könnern",
"4939246", "Lindau\ Anh",
"4936644", "Hirschberg\ Saale",
"499350", "Eussenheim\-Hundsbach",
"492391", "Plettenberg",
"495505", "Hardegsen",
"494473", "Emstek",
"499529", "Oberaurach",
"496303", "Enkenbach\-Alsenborn",
"498636", "Ampfing",
"492406", "Herzogenrath",
"494253", "Asendorf\ Kreis\ Diepholz",
"498134", "Odelzhausen",
"4933748", "Treuenbrietzen",
"498556", "Haidmühle",
"4935200", "Arnsdorf\ bei\ Dresden",
"492621", "Lahnstein",
"495507", "Ebergötzen",
"497245", "Durmersheim",
"4939854", "Kleptow",
"496035", "Reichelsheim\ Wetterau",
"498724", "Massing",
"499608", "Kohlberg\ Oberpfalz",
"495464", "Alfhausen",
"496868", "Mettlach\-Tünsdorf",
"496130", "Schwabenheim\ an\ der\ Selz",
"498422", "Dollnstein",
"495923", "Schüttorf",
"4939061", "Weferlingen",
"496697", "Willingshausen",
"495523", "Bad\ Sachsa",
"496325", "Lambrecht\ Pfalz",
"4939004", "Köckte\ bei\ Gardelegen",
"493745", "Falkenstein\ Vogtland",
"4939926", "Grabowhöfe",
"4936843", "Benshausen",
"497940", "Künzelsau",
"497636", "Münstertal\ Schwarzwald",
"495907", "Geeste",
"498247", "Bad\ Wörishofen",
"4939200", "Gommern",
"497676", "Feldberg\ Schwarzwald",
"4933456", "Wriezen",
"4938781", "Mellen",
"494193", "Henstedt\-Ulzburg",
"499346", "Grünsfeld",
"4934422", "Osterfeld",
"496858", "Ottweiler\-Fürth",
"493973", "Pasewalk",
"499931", "Plattling",
"494877", "Hennstedt\ bei\ Itzehoe",
"495454", "Hörstel\-Riesenbeck",
"494322", "Bordesholm",
"499282", "Naila",
"493933", "Genthin",
"499971", "Cham",
"4935388", "Klöden",
"494837", "Neuenkirchen\ Dithmarschen",
"492725", "Lennestadt\-Oedingen",
"492175", "Leichlingen\ Rheinland",
"497023", "Weilheim\ an\ der\ Teck",
"494181", "Buchholz\ in\ der\ Nordheide",
"497802", "Oberkirch\ Baden",
"497831", "Hausach",
"495752", "Auetal\-Hattendorf",
"496104", "Heusenstamm",
"494263", "Scheessel",
"496421", "Marburg",
"4939832", "Wesenberg",
"4935951", "Neukirch\ Lausitz",
"4934494", "Ehrenhain",
"4938424", "Bobitz",
"493641", "Jena",
"492826", "Kranenburg\ Niederrhein",
"4939744", "Rothenklempenow",
"497333", "Laichingen",
"499502", "Frensdorf",
"4939951", "Faulenrost",
"497373", "Zwiefalten",
"494624", "Kropp",
"499643", "Auerbach\ in\ der\ Oberpfalz",
"496084", "Schmitten\ Taunus",
"4939344", "Güsen",
"4934207", "Zwochau",
"4939388", "Goldbeck\ Altm",
"499571", "Lichtenfels\ Bayern",
"493533", "Elsterwerda",
"496269", "Gundelsheim\ Württemberg",
"495145", "Beedenbostel",
"4938485", "Dabel",
"499531", "Ebern",
"493573", "Senftenberg",
"4936257", "Luisenthal\ Thüringen",
"4933977", "Gumtow",
"496078", "Gross\-Umstadt",
"492663", "Westerburg\ Westerwald",
"4939323", "Schönhausen\ Elbe",
"493686", "Eisfeld",
"4933675", "Tauche",
"496453", "Gemünden\ Wohra",
"499605", "Weiherhammer",
"492747", "Molzhain",
"4939884", "Hassleben\ bei\ Prenzlau",
"4939723", "Krien",
"497248", "Marxzell",
"4936762", "Steinach\ Thüringen",
"496865", "Mettlach\-Orscholz",
"495103", "Wennigsen\ Deister",
"4937438", "Bad\ Brambach",
"492850", "Rees\-Haldern",
"4935825", "Kodersdorf",
"495961", "Haselünne",
"4939402", "Völpke",
"497051", "Calw",
"4937361", "Neuhausen\ Erzgebirge",
"4939409", "Eilsleben",
"493391", "Neuruppin",
"494852", "Brunsbüttel",
"496328", "Elmstein",
"495561", "Einbeck",
"4939825", "Wokuhl",
"498369", "Rückholz",
"499393", "Rothenfels\ Unterfranken",
"494146", "Stade\-Bützfleth",
"495083", "Hohne\ bei\ Celle",
"4935723", "Bernsdorf\ OL",
"495777", "Diepenau\-Essern",
"495127", "Harsum",
"4938351", "Mesekenhagen",
"4936921", "Wutha\-Farnroda",
"4938751", "Picher",
"496766", "Kisselbach",
"498043", "Jachenau",
"4935323", "Sonnewalde",
"492224", "Bad\ Honnef",
"499474", "Schmidmühlen",
"4933732", "Hennickendorf\ bei\ Luckenwalde",
"497583", "Bad\ Schussenried",
"499549", "Lisberg",
"496855", "Freisen",
"499701", "Sandberg\ Unterfranken",
"497227", "Lichtenau\ Baden",
"499434", "Bodenwöhr",
"495951", "Werlte",
"4933332", "Gartz\ Oder",
"494221", "Delmenhorst",
"492366", "Herten\ Westfalen",
"493679", "Neuhaus\ am\ Rennweg",
"4938841", "Neuhaus\ Elbe",
"492653", "Kaisersesch",
"499122", "Schwabach",
"499772", "Bischofsheim\ an\ der\ Rhön",
"499732", "Hammelburg",
"4937465", "Tannenbergsthal\ Vogtland",
"49381", "Rostock",
"4936783", "Gehren\ Thüringen",
"499381", "Volkach",
"49931", "Würzburg",
"496347", "Hochstadt\ Pfalz",
"496524", "Rodershausen",
"493881", "Grevesmühlen",
"497442", "Baiersbronn",
"497203", "Walzbachtal",
"493727", "Mittweida",
"496756", "Winterbach\ Soonwald",
"4938455", "Plaaz",
"495551", "Northeim",
"494469", "Wangerooge",
"4934906", "Raguhn",
"495148", "Steinhorst\ Niedersachsen",
"4938326", "Grimmen",
"494862", "Garding",
"4933844", "Brück\ Brandenburg",
"498225", "Jettingen\-Scheppach",
"49209", "Gelsenkirchen",
"497744", "Stühlingen",
"4938726", "Spornitz",
"498061", "Bad\ Aibling",
"499194", "Ebermannstadt",
"495671", "Hofgeismar",
"492162", "Viersen",
"4939400", "Wefensleben",
"4939778", "Ferdinandshof\ bei\ Torgelow",
"499326", "Markt\ Einersheim",
"494286", "Gyhum",
"498583", "Neureichenau",
"495631", "Korbach",
"495602", "Hessisch\ Lichtenau",
"493725", "Zschopau",
"4936623", "Berga\ Elster",
"492933", "Sundern\ Sauerland",
"499820", "Lehrberg",
"495543", "Staufenberg\ Niedersachsen",
"496052", "Bad\ Orb",
"496345", "Albersweiler",
"492973", "Eslohe\ Sauerland",
"499076", "Wittislingen",
"498442", "Wolnzach",
"492573", "Nordwalde",
"498203", "Grossaitingen",
"495943", "Emlichheim",
"494506", "Stockelsdorf\-Krumbeck",
"492533", "Münster\-Nienberge",
"497225", "Gaggenau",
"495482", "Tecklenburg",
"497520", "Bodnegg",
"4937206", "Frankenberg\ Sachsen",
"498744", "Gerzen",
"496592", "Daun",
"494838", "Tellingstedt",
"492641", "Bad\ Neuenahr\-Ahrweiler",
"496857", "Namborn",
"499254", "Gefrees",
"495304", "Meine",
"495908", "Wietmarschen\-Lohne",
"498248", "Lamerdingen",
"493969", "Siedenbollentin",
"496062", "Erbach\ Odenwald",
"4938371", "Karlshagen",
"4937605", "Hartenstein\ Sachsen",
"495775", "Diepenau",
"494644", "Karby",
"494239", "Dörverden\-Westen",
"498051", "Prien\ am\ Chiemsee",
"492152", "Kempen",
"493621", "Gotha\ Thüringen",
"496698", "Schrecksbach",
"4934294", "Rackwitz",
"4938224", "Gresenhorst",
"496867", "Perl",
"495836", "Wittingen\-Radenbeck",
"499264", "Küps",
"492292", "Windeck\ Sieg",
"496441", "Wetzlar",
"499089", "Bissingen\-Unterringingen",
"492745", "Brachbach\ Sieg",
"499607", "Luhe\-Wildenau",
"497043", "Maulbronn",
"496233", "Frankenthal\ Pfalz",
"498591", "Obernzell",
"4933655", "Grunow\ Kreis\ Oder\-Spree",
"4934222", "Arzberg\ bei\ Torgau",
"495508", "Gleichen\-Rittmarshausen",
"494342", "Preetz\ Kreis\ Plön",
"4938292", "Kröpelin",
"496638", "Schwalmtal\-Renzendorf",
"495403", "Bad\ Iburg",
"4934261", "Kühren\ bei\ Wurzen",
"495242", "Rheda\-Wiedenbrück",
"49291", "Meschede",
"492581", "Warendorf",
"4934633", "Braunsbedra",
"499566", "Meeder",
"497765", "Rickenbach\ Hotzenwald",
"4939243", "Nedlitz\ bei\ Zerbst",
"494230", "Verden\-Walle",
"494535", "Nahe",
"496678", "Wildeck\-Hönebach",
"497651", "Titisee\-Neustadt",
"4934497", "Langenleuba\-Niederhain",
"4938427", "Blowatz",
"498282", "Krumbach\ Schwaben",
"4938209", "Sanitz\ bei\ Rostock",
"495683", "Wabern\ Hessen",
"499228", "Thurnau",
"495379", "Sassenburg\-Grussendorf",
"4938202", "Volkenshagen",
"495427", "Melle\-Buer",
"498531", "Pocking",
"4939347", "Kade",
"496293", "Schefflenz",
"499080", "Harburg\ Schwaben",
"498571", "Simbach\ am\ Inn",
"4939747", "Züsedom",
"495339", "Gielde",
"494935", "Juist",
"4933473", "Zechin",
"4936254", "Friedrichswerth",
"49385", "Schwerin",
"492232", "Brühl\ Rheinland",
"4935243", "Weinböhla",
"494159", "Basthorst",
"4933974", "Dessow",
"494708", "Ringstedt",
"499966", "Wiesenfelden",
"498502", "Fürstenzell",
"492272", "Bedburg\ Erft",
"4934204", "Schkeuditz",
"492981", "Winterberg\ Westfalen",
"49251", "Münster",
"499185", "Mühlhausen\ Oberpfalz",
"494975", "Westerholt\ Ostfriesland",
"494446", "Bakum\ Kreis\ Vechta",
"495805", "Oetzen",
"4939857", "Drense",
"496163", "Höchst\ im\ Odenwald",
"499829", "Flachslanden",
"494204", "Thedinghausen",
"499422", "Bogen\ Niederbayern",
"497661", "Kirchzarten",
"492993", "Marsberg\-Canstein",
"4936072", "Weissenborn\-Lüderode",
"499724", "Stadtlauringen",
"499174", "Hilpoltstein",
"495691", "Bad\ Arolsen",
"494743", "Langen\ bei\ Bremerhaven",
"4939978", "Gross\ Roge",
"4936376", "Straussfurt",
"496281", "Buchen\ Odenwald",
"492053", "Velbert\-Neviges",
"497755", "Weilheim\ Kreis\ Waldshut",
"499556", "Geiselwind",
"494667", "Dagebüll",
"499134", "Neunkirchen\ am\ Brand",
"498346", "Pforzen",
"494169", "Sauensiek",
"495448", "Barver",
"499956", "Eichendorf\-Aufhausen",
"49621", "Mannheim",
"496844", "Blieskastel\-Altheim",
"496572", "Manderscheid\ Eifel",
"4937296", "Stollberg\ Erzgebirge",
"497529", "Waldburg\ Württemberg",
"496532", "Zeltingen\-Rachtig",
"495706", "Porta\ Westfalica",
"4939007", "Tangeln",
"4938874", "Lützow",
"493437", "Grimma",
"496501", "Konz",
"492593", "Ascheberg\ Westfalen",
"493329", "Stahnsdorf",
"4937320", "Mulda\ Sachsen",
"497142", "Bietigheim\-Bissingen",
"495031", "Wunstorf",
"496226", "Meckesheim",
"493946", "Quedlinburg",
"493475", "Lutherstadt\ Eisleben",
"4935877", "Cunewalde",
"492764", "Welschen\ Ennest",
"493435", "Oschatz",
"4936484", "Knau\ bei\ Pössneck",
"4938854", "Redefin",
"498661", "Grabenstätt\ Chiemsee",
"495071", "Schwarmstedt",
"4933932", "Fehrbellin",
"492462", "Linnich",
"4939035", "Kuhfelde",
"496652", "Hünfeld",
"499245", "Obertrubach",
"495823", "Bienenbüttel",
"4936425", "Isserstedt",
"499636", "Plössberg",
"495182", "Gronau\ Leine",
"494665", "Emmelsbüll\-Horsbüll",
"49203", "Duisburg",
"497346", "Illerkirchberg",
"495321", "Goslar",
"496568", "Wolsfeld",
"499676", "Winklarn",
"4936647", "Saalburg\ Thüringen",
"492041", "Bottrop",
"498142", "Olching",
"495807", "Altenmedingen",
"493546", "Lübben\ Spreewald",
"494751", "Otterndorf",
"498856", "Penzberg",
"499187", "Altdorf\ bei\ Nürnberg",
"498765", "Bruckberg\ Niederbayern",
"492859", "Wesel\-Bislich",
"4936962", "Vacha",
"492452", "Heinsberg\ Rheinland",
"4936846", "Suhl\-Dietzhausen",
"494977", "Blomberg\ Ostfriesland",
"499831", "Gunzenhausen",
"4933741", "Niedergörsdorf",
"499871", "Windsbach",
"497931", "Bad\ Mergentheim",
"492754", "Bad\ Laasphe\-Feudingen",
"4937329", "Grosshartmannsdorf",
"499802", "Ansbach\-Katterbach",
"498651", "Bad\ Reichenhall",
"492526", "Sendenhorst",
"4939424", "Schwanebeck\ Sachsen\-Anhalt",
"497971", "Gaildorf",
"4939923", "Priborn",
"499409", "Pielenhofen",
"495425", "Borgholzhausen",
"497571", "Sigmaringen",
"493302", "Hennigsdorf",
"4937322", "Brand\-Erbisdorf",
"494761", "Bremervörde",
"497531", "Konstanz",
"496364", "Nussbach\ Pfalz",
"493371", "Luckenwalde",
"497502", "Wolpertswende",
"4934342", "Neukieritzsch",
"499333", "Sommerhausen",
"492268", "Kürten",
"494537", "Sülfeld\ Holstein",
"4939485", "Gernrode\ Harz",
"4938788", "Gross\ Warnow",
"497643", "Herbolzheim\ Breisgau",
"493331", "Angermünde",
"4936969", "Merkers",
"499373", "Amorbach",
"4934742", "Sylda",
"496558", "Büdesheim\ Eifel",
"498507", "Neuburg\ am\ Inn",
"496665", "Sinntal\-Altengronau",
"498762", "Wartenberg\ Oberbayern",
"493693", "Meiningen",
"495556", "Lindau\ Harz",
"497128", "Sonnenbühl",
"492455", "Waldfeucht",
"4935386", "Prettin",
"497738", "Steisslingen",
"495724", "Obernkirchen",
"495174", "Lahstedt",
"497905", "Langenburg",
"492237", "Kerpen\ Rheinland\-Türnich",
"4933924", "Rägelin",
"493886", "Gadebusch",
"4934364", "Wermsdorf",
"492863", "Velen",
"498464", "Dietfurt\ an\ der\ Altmühl",
"495829", "Wriedel",
"496751", "Bad\ Sobernheim",
"499805", "Burgoberbach",
"495422", "Melle",
"4939089", "Bismark\ Altmark",
"4939953", "Schwinkendorf",
"494354", "Fleckeby",
"4933702", "Wünsdorf",
"4939454", "Elbingerode\ Harz",
"4935454", "Uckro",
"4939082", "Mieste",
"4935953", "Burkau",
"4936944", "Rentwertshausen",
"492361", "Recklinghausen",
"4937752", "Eibenstock",
"499386", "Prosselsheim",
"494968", "Neulehe",
"497505", "Fronreute",
"4939386", "Seehausen\ Altmark",
"499448", "Hausen\ Niederbayern",
"495956", "Rastdorf",
"495247", "Harsewinkel",
"497066", "Bad\ Rappenau\-Bonfeld",
"4936841", "Schleusingen",
"498454", "Karlshuld",
"4935439", "Zinnitz",
"4933746", "Werbig\ bei\ Jüterbog",
"497147", "Sachsenheim\ Württemberg",
"492853", "Schermbeck",
"4938783", "Dallmin",
"49361", "Erfurt",
"494364", "Dahme\ Kreis\ Ostholstein",
"4938824", "Mallentin",
"4936029", "Menteroda",
"496761", "Simmern\ Hunsrück",
"493774", "Schwarzenberg",
"492465", "Inden",
"496655", "Neuhof\ Kreis\ Fulda",
"498752", "Au\ in\ der\ Hallertau",
"494141", "Stade",
"494558", "Todesfelde",
"499403", "Donaustauf",
"499242", "Gössweinstein",
"4933657", "Steinsdorf\ Brandenburg",
"495185", "Duingen",
"494662", "Leck",
"494958", "Jemgum",
"4937607", "Ebersbrunn\ Sachsen",
"497056", "Gechingen",
"4939928", "Möllenhagen",
"495966", "Meppen\-Apeldorn",
"498145", "Mammendorf",
"492351", "Lüdenscheid",
"497274", "Germersheim",
"493681", "Suhl",
"499339", "Ippesheim",
"4936022", "Grossengottern",
"497234", "Tiefenbronn",
"495228", "Vlotho\-Exter",
"499683", "Friedenfels",
"496044", "Schotten\ Hessen",
"499427", "Leiblfing",
"4933458", "Falkenberg\ Mark",
"495802", "Wrestedt",
"4939827", "Schwarz\ bei\ Neustrelitz",
"495023", "Liebenau\ Kreis\ Nieburg\ Weser",
"492904", "Bestwig",
"4933478", "Gross\ Neuendorf",
"4935248", "Schönfeld\ bei\ Grossenhain",
"495409", "Hilter\ am\ Teutoburger\ Wald",
"497454", "Sulz\ am\ Neckar",
"4939225", "Altengrabow",
"494293", "Ottersberg\-Fischerhude",
"496708", "Bad\ Münster\ am\ Stein\-Ebernburg",
"496159", "Messel",
"495187", "Delligsen",
"496446", "Hohenahr",
"495831", "Wittingen",
"498056", "Eggstätt",
"496575", "Landscheid",
"494638", "Tarp",
"4933677", "Glienicke\ bei\ Beeskow",
"495373", "Hillerse\ Kreis\ Gifhorn",
"496535", "Osann\-Monzel",
"495333", "Dettum",
"496657", "Hofbieber",
"492841", "Moers",
"498234", "Bobingen",
"494153", "Lauenburg\ Elbe",
"498649", "Schleching",
"4934638", "Zöschen",
"497145", "Markgröningen",
"4939248", "Dobritz",
"492504", "Telgte",
"498274", "Buttenwiesen",
"4935827", "Nieder\-Seifersdorf",
"4939080", "Kalbe\ Milde",
"494844", "Pellworm",
"49421", "Bremen",
"499823", "Leutershausen",
"495245", "Herzebrock\-Clarholz",
"492646", "Königsfeld\ Eifel",
"495494", "Holdorf\ Niedersachsen",
"493821", "Ribnitz\-Damgarten",
"497762", "Wehr\ Baden",
"496584", "Wellen\ Mosel",
"494532", "Bargteheide",
"496898", "Völklingen",
"494749", "Schiffdorf\-Geestenseth",
"4933876", "Buschow",
"494501", "Kastorf\ Holstein",
"498285", "Burtenbach",
"4938457", "Krakow\ am\ See",
"499071", "Dillingen\ an\ der\ Donau",
"4935973", "Stolpen",
"493307", "Zehdenick",
"4935474", "Schönwalde\ bei\ Lübben",
"497464", "Talheim\ Kreis\ Tuttlingen",
"4936371", "Schlossvippach",
"496204", "Viernheim",
"494163", "Horneburg\ Niederelbe",
"4939973", "Altkalen",
"4936020", "Ebeleben",
"4937291", "Augustusburg",
"499321", "Kitzingen",
"496743", "Bacharach",
"492599", "Ascheberg\-Herbern",
"494932", "Norderney",
"495676", "Liebenau\ Hessen",
"498066", "Bad\ Feilnbach",
"492235", "Erftstadt",
"497907", "Schwäbisch\ Hall\-Sulzdorf",
"499182", "Velburg",
"492308", "Unna\-Hemmerde",
"495636", "Lichtenfels\-Goddelsheim",
"492275", "Kerpen\-Buir",
"498505", "Hutthurm",
"496667", "Steinau\-Ulmbach",
"494281", "Zeven",
"4937467", "Klingenthal\ Sachsen",
"494972", "Langeoog",
"495732", "Löhne",
"496506", "Welschbillig",
"497851", "Kehl",
"499091", "Monheim\ Schwaben",
"495381", "Seesen",
"4936427", "Dornburg\ Saale",
"494740", "Loxstedt\-Dedesdorf",
"4935773", "Schleife",
"4936209", "Klettbach",
"495772", "Espelkamp",
"496838", "Saarwellingen",
"498341", "Kaufbeuren",
"497428", "Rosenfeld",
"499951", "Landau\ an\ der\ Isar",
"4936645", "Mühltroff",
"495434", "Essen\ Oldenburg",
"494857", "Barlt",
"495474", "Stemwede\-Dielingen",
"4935875", "Obercunnersdorf\ bei\ Löbau",
"4936628", "Zeulenroda",
"495696", "Bad\ Arolsen\-Landau",
"492444", "Schleiden\-Gemünd",
"49365", "Gera",
"499551", "Burgwindheim",
"499148", "Ettenstatt",
"492590", "Dülmen\-Buldern",
"492295", "Ruppichteroth",
"496286", "Walldürn\-Rippberg",
"492742", "Wissen",
"497666", "Denzlingen",
"4939037", "Pretzier",
"495883", "Lemgow",
"497353", "Schwendi",
"4939773", "Altwarp",
"4936202", "Neudietendorf",
"49531", "Braunschweig",
"492165", "Jüchen",
"499961", "Mitterfels",
"498808", "Pähl",
"496150", "Weiterstadt",
"494441", "Vechta",
"499103", "Cadolzburg",
"4938376", "Zirchow",
"493963", "Woldegk",
"495605", "Kaufungen\ Hessen",
"4939487", "Friedrichsbrunn",
"494233", "Blender",
"498536", "Kösslarn",
"497447", "Baiersbronn\-Schwarzenberg",
"4936653", "Lehesten\ Thüringer\ Wald",
"493722", "Limbach\-Oberfrohna",
"496342", "Schweigen\-Rechtenbach",
"4934603", "Nauendorf\ Sachsen\-Anhalt",
"496055", "Freigericht",
"494273", "Kirchdorf\ bei\ Sulingen",
"492206", "Overath",
"498445", "Gerolsbach",
"497363", "Lauchheim",
"499737", "Wartmannsroth",
"4936874", "Schönbrunn\ bei\ Hildburghaus",
"497656", "Schluchsee",
"498640", "Reit\ Im\ Winkl",
"499777", "Ostheim\ von\ der\ Rhön",
"499127", "Rosstal\ Mittelfranken",
"498294", "Horgau",
"492586", "Beelen",
"495485", "Ladbergen",
"493563", "Spremberg",
"497222", "Rastatt",
"496239", "Bobenheim\-Roxheim",
"496644", "Grebenhain",
"499083", "Möttingen",
"496595", "Dockweiler",
"4938232", "Zingst\ Ostseebad",
"499561", "Coburg",
"4939345", "Parchen",
"4935728", "Uhyst\ Spree",
"494328", "Rickling",
"496852", "Nohfelden",
"496146", "Hochheim\ am\ Main",
"497808", "Hohberg\ bei\ Offenburg",
"4939745", "Hetzdorf\ bei\ Strasburg",
"499288", "Bad\ Steben",
"496597", "Jünkerath",
"495623", "Edertal",
"499775", "Schönau\ an\ der\ Brend",
"497576", "Krauchenwies",
"495109", "Ronnenberg",
"492921", "Soest",
"4935843", "Hirschfelde\ bei\ Zittau",
"497154", "Kornwestheim",
"4937366", "Rübenau",
"4938484", "Ventschow",
"499735", "Massbach",
"498861", "Schongau",
"499908", "Schöfweg",
"494766", "Basdahl",
"496057", "Flörsbachtal",
"494453", "Zetel",
"497936", "Schrozberg\-Bartenstein",
"4937433", "Gutenfürst",
"498363", "Pfronten",
"492521", "Beckum",
"497445", "Pfalzgrafenweiler",
"497976", "Sulzbach\-Laufen",
"4936200", "Elxleben\ bei\ Arnstadt",
"495607", "Fuldatal",
"498656", "Anger",
"4938356", "Behrenhoff",
"4939328", "Rochau",
"4938425", "Kirchdorf\ Poel",
"499836", "Gunzenhausen\-Cronheim",
"495264", "Kalletal",
"494865", "Osterhever",
"4934495", "Dobitschen",
"498222", "Burgau\ Schwaben",
"4938756", "Grabow",
"4939728", "Medow\ bei\ Anklam",
"4936926", "Creuzburg",
"499876", "Rohr\ Mittelfranken",
"499543", "Hirschaid",
"495768", "Petershagen\-Heimsen",
"495820", "Suhlendorf",
"494347", "Flintbek",
"494524", "Scharbeutz\-Pönitz",
"498851", "Kochel\ am\ See",
"494756", "Odisheim",
"4939005", "Kusey",
"499602", "Neustadt\ an\ der\ Waldnaab",
"497164", "Boll\ Kreis\ Göppingen",
"4939753", "Strasburg",
"4934463", "Bad\ Kösen",
"493541", "Calau",
"492297", "Wildbergerhütte",
"499631", "Tirschenreuth",
"499671", "Oberviechtach",
"495194", "Bispingen",
"495326", "Langelsheim",
"494855", "Eddelak",
"4939855", "Parmen\-Weggun",
"495254", "Paderborn\-Schloss\ Neuhaus",
"499482", "Wörth\ an\ der\ Donau",
"497843", "Renchen",
"492157", "Nettetal\-Kaldenkirchen",
"4936744", "Remda",
"493941", "Halberstadt",
"4935753", "Grossräschen",
"494463", "Wangerland",
"4938321", "Martensdorf\ bei\ Stralsund",
"495036", "Neustadt\-Schneeren",
"4934901", "Rosslau\ Elbe",
"496221", "Heidelberg",
"494924", "Moormerland\-Oldersum",
"4938721", "Ziegendorf",
"498666", "Teisendorf",
"499943", "Lam\ Oberpfalz",
"498031", "Rosenheim\ Oberbayern",
"492132", "Meerbusch\-Büderich",
"4936848", "Wernshausen",
"498071", "Wasserburg\ am\ Inn",
"492722", "Attendorn",
"495661", "Melsungen",
"499285", "Kirchenlamitz",
"497805", "Appenweier",
"4939362", "Grieben\ bei\ Tangerhütte",
"499128", "Feucht",
"499778", "Fladungen",
"495755", "Kalletal\-Varenholz",
"492963", "Brilon\-Messinghausen",
"4935477", "Rietzneuendorf\-Friedrichshof",
"4930", "Berlin",
"49201", "Essen",
"498823", "Mittenwald",
"4933845", "Borkheide",
"499905", "Bernried\ Niederbayern",
"499738", "Rottershausen",
"4938454", "Kritzkow",
"492424", "Vettweiss",
"495529", "Rhumspringe",
"497706", "Oberbaldingen",
"499505", "Litzendorf",
"496253", "Fürth\ Odenwald",
"4939921", "Ankershagen",
"492563", "Stadtlohn",
"498321", "Sonthofen",
"493586", "Neugersdorf\ Sachsen",
"497448", "Seewald",
"4935362", "Schönewalde\ bei\ Herzberg",
"4933743", "Blönsdorf",
"495142", "Eschede",
"4937464", "Schöneck\ Vogtland",
"4933451", "Heckelberg",
"497386", "Hayingen",
"498807", "Diessen\ am\ Ammersee",
"4939383", "Sandau\ Elbe",
"495765", "Raddestorf",
"492953", "Wünnenberg",
"4939824", "Hohenzieritz",
"496032", "Bad\ Nauheim",
"497242", "Rheinstetten",
"496624", "Heringen\ Werra",
"497403", "Dunningen",
"494269", "Ahausen\-Kirchwalsede",
"499147", "Nennslingen",
"49611", "Wiesbaden",
"495651", "Eschwege",
"496322", "Bad\ Dürkheim",
"4939885", "Jakobshagen",
"499274", "Hollfeld",
"494858", "Sankt\ Margarethen\ Holstein",
"497427", "Schömberg\ bei\ Balingen",
"496181", "Hanau",
"496837", "Wallerfangen",
"4933674", "Trebatsch",
"4935892", "Horka\ OL",
"4939956", "Neukalen",
"497683", "Simonswald",
"499234", "Neusorg",
"494421", "Wilhelmshaven",
"496263", "Neckargerach",
"494104", "Aumühle\ bei\ Hamburg",
"492553", "Ochtrup",
"4935383", "Elster\ Elbe",
"495902", "Freren",
"498029", "Kreuth\ bei\ Tegernsee",
"4938827", "Kalkhorst",
"492804", "Xanten\-Marienbaum",
"498403", "Pförring",
"492633", "Brohl\-Lützing",
"492673", "Ellenz\-Poltersdorf",
"496068", "Beerfelden",
"494606", "Wanderup",
"492389", "Werne",
"4938225", "Trinwillershagen",
"4934295", "Krensitz",
"495282", "Schieder\-Schwalenberg",
"497425", "Trossingen",
"492158", "Grefrath\ bei\ Krefeld",
"492541", "Coesfeld",
"495971", "Rheine",
"4939976", "Gross\ Bützin",
"4933654", "Fünfeichen",
"496835", "Beckingen",
"496692", "Neustadt\ Hessen",
"496875", "Nonnweiler\-Primstal",
"4936378", "Ostramondra",
"497620", "Schopfheim\-Gersbach",
"495931", "Meppen",
"499454", "Aufhausen\ Oberpfalz",
"4937604", "Mosel",
"495531", "Holzminden",
"4933873", "Grosswudicke",
"498427", "Wellheim",
"498379", "Waltenhofen\-Oberdorf",
"498683", "Tittmoning",
"494486", "Edewecht\-Friedrichsfehn",
"4937298", "Oelsnitz\ Erzgebirge",
"495571", "Uslar",
"492941", "Lippstadt",
"499145", "Solnhofen",
"496776", "Dachsenhausen",
"496126", "Idstein",
"494791", "Osterholz\-Scharmbeck",
"495643", "Borgentreich",
"496394", "Bundenthal",
"494348", "Schönkirchen",
"495767", "Warmsen",
"496736", "Bechenheim",
"495502", "Dransfeld",
"4935241", "Lommatzsch",
"497071", "Tübingen",
"494944", "Wiesmoor",
"498805", "Hohenpeissenberg",
"499923", "Teisnach",
"4933927", "Linum",
"493921", "Burg\ bei\ Magdeburg",
"499464", "Walderbach",
"4933632", "Hangelsberg",
"497031", "Böblingen",
"496241", "Worms",
"497823", "Seelbach\ Schutter",
"496433", "Hadamar",
"495608", "Söhrewald",
"4939457", "Benneckenstein\ Harz",
"492336", "Schwelm",
"494303", "Schlesen",
"496473", "Leun",
"499762", "Saal\ an\ der\ Saale",
"496058", "Gründau",
"499907", "Zenting",
"496789", "Heimbach\ Nahe",
"497321", "Heidenheim\ an\ der\ Brenz",
"495346", "Liebenburg",
"4936947", "Jüchsen",
"498706", "Vilsheim",
"497182", "Welzheim",
"499287", "Selb",
"494832", "Meldorf",
"498386", "Oberstaufen",
"4934263", "Hohburg",
"493521", "Meissen",
"497807", "Neuried\ Ortenaukreis",
"494479", "Molbergen\-Peheim",
"495840", "Schnackenburg",
"499523", "Hofheim\ in\ Unterfranken",
"494872", "Hanerau\-Hademarschen",
"494544", "Berkenthin",
"494327", "Grossenaspe",
"4939241", "Leitzkau",
"497951", "Crailsheim",
"499428", "Kirchroth",
"492734", "Freudenberg\ Westfalen",
"498671", "Altötting",
"492401", "Baesweiler",
"498631", "Mühldorf\ am\ Inn",
"495583", "Braunlage\-Hohegeiss",
"492774", "Dietzhölztal",
"496385", "Reichenbach\-Steegen",
"492839", "Straelen\-Herongen",
"492432", "Wassenberg",
"499851", "Dinkelsbühl",
"49261", "Koblenz\ am\ Rhein",
"492472", "Monschau",
"494957", "Detern",
"494246", "Twistringen\-Heiligenloh",
"4938875", "Schlagsdorf\ bei\ Gadebusch",
"498543", "Aidenbach",
"498784", "Hohenthann",
"495203", "Werther\ Westfalen",
"496578", "Salmtal",
"494635", "Sörup",
"499353", "Karlstadt",
"495849", "Waddeweitz",
"499666", "Illschwang",
"495442", "Barnstorf\ Kreis\ Diepholz",
"494557", "Blunk",
"492681", "Altenkirchen\ Westerwald",
"4934606", "Teicha\ Sachsen\-Anhalt",
"494499", "Barssel",
"494892", "Schenefeld\ Mittelholstein",
"495744", "Hüllhorst",
"4938373", "Katzow",
"4939050", "Bartensleben",
"498304", "Wildpoldsried",
"497551", "Überlingen\ Bodensee",
"497148", "Grossbottwar",
"496806", "Heusweiler",
"495248", "Langenberg\ Kreis\ Gütersloh",
"499861", "Rothenburg\ ob\ der\ Tauber",
"496024", "Schöllkrippen",
"49641", "Giessen",
"499447", "Essing",
"498735", "Gangkofen\-Kollbach",
"4939776", "Hintersee",
"494684", "Langeness\ Hallig",
"497629", "Tegernau\ Baden",
"496672", "Eiterfeld",
"493863", "Crivitz",
"494967", "Rhauderfehn\-Burlage",
"495051", "Bergen\ Kreis\ Celle",
"497961", "Ellwangen\ Jagst",
"4934205", "Markranstädt",
"4933975", "Dannenwalde\ Kreis\ Prignitz",
"4936255", "Goldbach\ bei\ Gotha",
"492693", "Antweiler",
"498020", "Weyarn",
"494121", "Elmshorn",
"494771", "Hemmoor",
"497083", "Bad\ Herrenalb",
"4936621", "Elsterberg\ bei\ Plauen",
"499222", "Presseck",
"494404", "Elsfleth",
"496374", "Weilerbach",
"494382", "Wangels",
"496334", "Thaleischweiler\-Fröschen",
"497561", "Leutkirch\ im\ Allgäu",
"494731", "Nordenham",
"499656", "Moosbach\ bei\ Vohenstrauss",
"4937208", "Auerswalde",
"492238", "Pulheim",
"498330", "Legau",
"494702", "Sandstedt",
"499363", "Arnstein\ Unterfranken",
"493361", "Fürstenwalde\ Spree",
"497127", "Neckartenzlingen",
"497777", "Sauldorf",
"498370", "Wiggensbach",
"492305", "Castrop\-Rauxel",
"499576", "Lichtenfels\-Isling",
"497775", "Mühlingen",
"497125", "Bad\ Urach",
"4935756", "Hosena",
"492307", "Kamen",
"496668", "Birstein\-Lichenroth",
"494260", "Visselhövede\-Wittorf",
"497735", "Öhningen",
"499536", "Kirchlauter",
"498629", "Palling",
"499154", "Pommelsbrunn",
"492821", "Kleve\ Niederrhein",
"496092", "Heimbuchenthal",
"4939484", "Harzgerode",
"4935052", "Kipsdorf\ Kurort",
"4939059", "Wegenstedt",
"4937382", "Geringswalde",
"496426", "Fronhausen",
"492323", "Herne",
"498561", "Pfarrkirchen\ Niederbayern",
"497836", "Schiltach",
"4939052", "Erxleben\ bei\ Haldensleben",
"4938843", "Bennin",
"498083", "Isen",
"4933093", "Fürstenberg\ Havel",
"4936781", "Grossbreitenbach",
"499294", "Regnitzlosau",
"4938328", "Miltzow",
"492262", "Wiehl",
"4939425", "Dingelstedt\ am\ Huy",
"499936", "Wallerfing",
"496897", "Sulzbach\ Saar",
"494965", "Surwold",
"494186", "Buchholz\-Trelde",
"495043", "Lauenau",
"496552", "Olzheim",
"4938728", "Domsühl",
"4934466", "Janisroda",
"499976", "Rötz",
"499445", "Neustadt\ an\ der\ Donau",
"4938353", "Gützkow\ bei\ Greifswald",
"497631", "Müllheim\ Baden",
"496133", "Oppenheim",
"496173", "Kronberg\ im\ Taunus",
"496723", "Oestrich\-Winkel",
"499341", "Tauberbischofsheim",
"4936923", "Treffurt",
"4936424", "Kahla\ Thüringen",
"497671", "Todtnau",
"4938753", "Wöbbelin",
"496658", "Poppenhausen\ Wasserkuppe",
"4937436", "Weischlitz",
"497543", "Kressbronn\ am\ Bodensee",
"494637", "Sterup",
"492192", "Hückeswagen",
"499164", "Langenfeld\ Mittelfranken",
"498091", "Kirchseeon",
"493904", "Haldensleben",
"494555", "Seedorf\ bei\ Bad\ Segeberg",
"494955", "Westoverledingen",
"493504", "Dippoldiswalde",
"492252", "Zülpich",
"4938855", "Lübtheen",
"494139", "Hohnstorf\ Elbe",
"494179", "Winsen\-Tönnhausen",
"497943", "Schöntal\ Jagst",
"4937363", "Zöblitz",
"496707", "Windesheim",
"496562", "Speicher",
"497304", "Blaustein\ Württemberg",
"493841", "Wismar",
"492626", "Selters\ Westferwald",
"496387", "Sankt\ Julian",
"4939321", "Arneburg",
"498551", "Freyung",
"4939721", "Liepen\ bei\ Anklam",
"494824", "Krempe",
"4939034", "Fleetmark",
"499843", "Burgbernheim",
"495225", "Spenge",
"495520", "Braunlage",
"499209", "Emtmannsberg",
"497482", "Horb\-Dettingen",
"497236", "Keltern",
"496046", "Ortenberg\ Hessen",
"497276", "Herxheim\ bei\ Landau\ Pfalz",
"499120", "Leinburg",
"4933433", "Buckow\ Märkische\ Schweiz",
"492862", "Südlohn",
"496659", "Eichenzell",
"495964", "Lähden",
"496297", "Ravenstein\ Baden",
"497054", "Wildberg\ Württemberg",
"4938852", "Wittenburg",
"4936482", "Triptis",
"495423", "Versmold",
"494138", "Betzendorf\ Kreis\ Lüneburg",
"493394", "Wittstock\ Dosse",
"4938859", "Alt\ Zachun",
"494178", "Radbruch",
"496157", "Pfungstadt",
"495564", "Dassel",
"4934926", "Pretzsch\ Elbe",
"4938306", "Samtens",
"4933366", "Chorin",
"499335", "Aub\ Kreis\ Würzburg",
"4933970", "Neustadt\ Dosse",
"494366", "Grömitz\-Cismar",
"497440", "Bad\ Rippoldsau",
"495407", "Wallenhorst",
"497645", "Freiamt",
"498456", "Lenting",
"499208", "Bindlach",
"4934673", "Heldrungen",
"495358", "Bahrdorf\-Mackendorf",
"4933766", "Teupitz",
"499375", "Freudenberg\ Baden",
"4939422", "Badersleben",
"492852", "Hamminkeln",
"493473", "Aschersleben\ Sachsen\-Anhalt",
"496669", "Neuhof\-Hauswurz",
"499431", "Schwandorf",
"495954", "Lorup",
"493433", "Borna\ Stadt",
"499471", "Burglengenfeld",
"498628", "Kienberg\ Oberbayern",
"492597", "Senden\ Westfalen",
"499704", "Euerdorf",
"4935207", "Moritzburg",
"493998", "Demmin",
"4935938", "Grosspostwitz\ OL",
"498753", "Elsendorf\ Niederbayern",
"4939055", "Hörsingen",
"499384", "Schwanfeld",
"494224", "Gross\ Ippener",
"499402", "Regenstauf",
"4939993", "Hohenmocker",
"4936463", "Gebstedt",
"495825", "Wieren",
"499243", "Pottenstein",
"4936964", "Dermbach\ Rhön",
"494356", "Gross\ Wittensee",
"4936336", "Klettenberg",
"494663", "Süderlügum",
"498466", "Denkendorf\ Oberbayern",
"495368", "Parsau",
"4935055", "Höckendorf\ bei\ Dippoldiswalde",
"4933083", "Schulzendorf\ Kreis\ Oberhavel",
"4934344", "Kohren\-Sahlis",
"4933831", "Weseram",
"494747", "Beverstedt",
"4936736", "Arnsgereuth",
"4939207", "Colbitz",
"497741", "Tiengen\ Hochrhein",
"495726", "Wiedensahl",
"495176", "Edemissen",
"496167", "Modautal",
"4937324", "Reinsberg\ Sachsen",
"495554", "Moringen",
"499682", "Erbendorf",
"495136", "Burgdorf\ Kreis\ Hannover",
"495022", "Wietzen",
"495803", "Rosche",
"496165", "Breuberg",
"497628", "Efringen\-Kirchen",
"495634", "Waldeck\-Sachsenhausen",
"4938850", "Gammelin",
"498064", "Au\ bei\ Bad\ Aibling",
"499191", "Forchheim\ Oberfranken",
"495674", "Grebenstein",
"492150", "Meerbusch\-Lank",
"494292", "Ritterhude",
"49571", "Minden\ Westfalen",
"4936259", "Tabarz\ Thüringer\ Wald",
"494745", "Bad\ Bederkesa",
"4933979", "Wusterhausen\ Dosse",
"497753", "Albbruck",
"4933201", "Gross\ Glienicke",
"496206", "Lampertheim",
"497466", "Beuron",
"494340", "Achterwehr",
"495372", "Meinersen",
"4934202", "Delitzsch",
"495827", "Unterlüss",
"495332", "Schöppenstedt",
"4936252", "Tambach\-Dietharz",
"4933972", "Breddin",
"496586", "Beuren\ Hochwald",
"494152", "Geesthacht",
"492644", "Linz\ am\ Rhein",
"49345", "Halle\ Saale",
"499251", "Münchberg",
"495301", "Lehre\-Essenrode",
"492595", "Olfen",
"4938204", "Broderstorf",
"494846", "Hattstedt",
"498741", "Vilsbiburg",
"498509", "Ruderting",
"498276", "Baar\ Schwaben",
"492506", "Münster\-Wolbeck",
"499429", "Rain\ Niederbayern",
"495405", "Hasbergen\ Kreis\ Osnabrück",
"499822", "Bechhofen\ an\ der\ Heide",
"496050", "Biebergemünd",
"499377", "Freudenberg\-Boxtal",
"4939268", "Egeln",
"4934653", "Rottleberode",
"497763", "Murg",
"4935691", "Bärenklau\ NL",
"499337", "Gaukönigshofen",
"4936603", "Weida",
"498236", "Fischach",
"492065", "Duisburg\-Rheinhausen",
"494533", "Reinfeld\ Holstein",
"492838", "Sonsbeck",
"4936074", "Worbis",
"493624", "Ohrdruf",
"496155", "Griesheim\ Hessen",
"494641", "Süderbrarup",
"498054", "Breitbrunn\ am\ Chiemsee",
"495848", "Trebel",
"495685", "Knüllwald",
"499261", "Kronach",
"494162", "Jork",
"496444", "Bischoffen",
"496295", "Rosenberg\ Baden",
"494498", "Saterland\-Ramsloh",
"4938872", "Rehna",
"497522", "Wangen\ im\ Allgäu",
"494933", "Dornum\ Ostfriesland",
"496742", "Boppard",
"497456", "Haiterbach",
"4935268", "Stauchitz",
"499183", "Burgthann",
"494973", "Wittmund\-Burhafe",
"493322", "Falkensee",
"493877", "Wittenberge",
"495733", "Vlotho",
"496646", "Grebenau",
"492584", "Warendorf\-Milte",
"495773", "Stemwede\-Wehdem",
"495123", "Schellerten",
"4935027", "Weesenstein",
"4936693", "Crossen\ an\ der\ Elster",
"4935601", "Peitz",
"498296", "Villenbach",
"499625", "Kastl\ bei\ Amberg",
"495609", "Ahnatal",
"499397", "Wertheim\-Dertingen",
"499420", "Feldkirchen\ Niederbayern",
"497654", "Löffingen",
"496059", "Jossgrund",
"496788", "Sien",
"492204", "Bensberg",
"498574", "Wittibreut",
"4939601", "Friedland",
"498534", "Tettenweis",
"495882", "Gorleben",
"492743", "Daaden",
"496599", "Weidenbach\ bei\ Gerolstein",
"492984", "Hallenberg",
"497045", "Oberderdingen",
"496235", "Schifferstadt",
"497352", "Ochsenhausen",
"496308", "Olsbrücken",
"4933635", "Arensdorf\ Kreis\ Oder\-Spree",
"496275", "Rothenberg\ Odenwald",
"492667", "Stein\-Neukirch",
"494478", "Cappeln\ Oldenburg",
"496457", "Burgwald\ Eder",
"4934771", "Querfurt",
"498028", "Fischbachau",
"4934299", "Gaschwitz",
"4938229", "Bad\ Sülze",
"499102", "Wilhermsdorf",
"492388", "Hamm\-Uentrop",
"498585", "Grainet",
"497664", "Freiburg\-Tiengen",
"493962", "Penzlin\ bei\ Waren",
"496284", "Mudau",
"492159", "Meerbusch\-Osterath",
"494232", "Langwedel\ Kreis\ Verden",
"493723", "Hohenstein\-Ernstthal",
"499131", "Erlangen",
"492935", "Sundern\-Hachen",
"495545", "Hedemünden",
"499171", "Roth\ Mittelfranken",
"499721", "Schweinfurt",
"492446", "Heimbach\ Eifel",
"495694", "Diemelstadt",
"496343", "Bad\ Bergzabern",
"492975", "Schmallenberg\-Oberkirchen",
"49451", "Lübeck",
"494272", "Siedenburg",
"49491", "Leer\ Ostfriesland",
"4938294", "Neubukow",
"497362", "Bopfingen",
"498205", "Dasing",
"492575", "Greven\-Reckenfeld",
"4934224", "Belgern\ Sachsen",
"4936087", "Wüstheuterode",
"498378", "Buchenberg\ bei\ Kempten",
"495945", "Wilsum",
"495476", "Ostercappeln\-Venne",
"492535", "Sendenhorst\-Albersloh",
"496467", "Hatzfeld\ Eder",
"498338", "Böhen",
"495436", "Nortrup",
"496841", "Homburg\ Saar",
"492657", "Uersfeld",
"497223", "Bühl\ Baden",
"493562", "Forst\ Lausitz",
"499082", "Oettingen\ in\ Bayern",
"4938222", "Semlow",
"498166", "Allershausen\ Oberbayern",
"497587", "Hosskirch",
"494349", "Dänischenhagen",
"496504", "Thalfang",
"4934292", "Brandis\ bei\ Wurzen",
"4939404", "Ausleben",
"497585", "Ostrach",
"494926", "Krummhörn\-Greetsiel",
"496853", "Marpingen",
"498664", "Chieming",
"4939393", "Werben\ Elbe",
"495074", "Rodewald",
"495034", "Neustadt\-Hagen",
"4936764", "Neuhaus\-Schierschnitz",
"495622", "Fritzlar",
"492761", "Olpe\ Biggesee",
"4939882", "Gollin",
"493385", "Rathenow",
"494268", "Bötersen",
"496465", "Breidenbach\ bei\ Biedenkopf",
"492655", "Weibern",
"493493", "Bitterfeld",
"499491", "Hemau",
"4933056", "Mühlenbeck\ Kreis\ Oberhavel",
"499306", "Kist",
"495947", "Laar\ Vechte",
"4935895", "Klitten",
"496660", "Steinau\-Marjoss",
"498207", "Affing",
"492977", "Schmallenberg\-Bödefeld",
"494452", "Zetel\-Neuenburg",
"495324", "Vienenburg",
"4937423", "Adorf\ Vogtland",
"494859", "Windbergen",
"495196", "Wietzendorf",
"499648", "Neustadt\ am\ Kulm",
"4939297", "Eickendorf\ Kreis\ Schönebeck",
"498362", "Füssen",
"492937", "Arnsberg\-Oeventrop",
"4939889", "Boitzenburg",
"497166", "Adelberg",
"496351", "Eisenberg\ Pfalz",
"4934443", "Teuchern",
"494754", "Bülkau",
"4935793", "Elstra",
"4936701", "Lichte",
"498223", "Ichenhausen",
"494526", "Ascheberg\ Holstein",
"493578", "Kamenz",
"4933607", "Briesen\ Mark",
"4935365", "Falkenberg\ Elster",
"499874", "Neuendettelsau",
"499542", "Schesslitz",
"496455", "Frankenau\ Hessen",
"493601", "Mühlhausen\ Thüringen",
"494258", "Schwarme",
"499603", "Floss",
"496650", "Hosenfeld",
"496237", "Maxdorf",
"499834", "Theilenhofen",
"495266", "Lemgo\-Kirchheide",
"499129", "Wendelstein",
"499779", "Nordheim\ von\ der\ Rhön",
"498654", "Freilassing",
"4933334", "Greiffenberg",
"495105", "Barsinghausen",
"493672", "Rudolstadt",
"497974", "Bühlerzell",
"4933849", "Wiesenburg\ Mark",
"493632", "Sondershausen",
"497934", "Weikersheim",
"492751", "Bad\ Berleburg",
"4939863", "Seehausen\ bei\ Prenzlau",
"49341", "Leipzig",
"4933734", "Felgentreu",
"494764", "Gnarrenburg\-Klenkendorf",
"497156", "Ditzingen",
"4937346", "Geyer",
"497534", "Reichenau\ Baden",
"4938220", "Wustrow\ Ostseebad",
"495528", "Gieboldehausen",
"496361", "Rockenhausen",
"497574", "Gammertingen",
"497842", "Kappelrodeck",
"497449", "Baiersbronn\-Obertal",
"499395", "Triefenstein",
"4933966", "Dranse",
"499627", "Freudenberg\ Oberpfalz",
"495085", "Burgdorf\-Ehlershausen",
"4936041", "Bad\ Tennstedt",
"493334", "Eberswalde",
"4938331", "Rakow\ Vorpom",
"494462", "Wittmund",
"496144", "Bischofsheim\ bei\ Rüsselsheim",
"4938796", "Viesecke",
"4938731", "Lübz",
"4939365", "Bellingen\ bei\ Stendal",
"499942", "Viechtach",
"498045", "Lenggries\-Fall",
"495769", "Steyerberg\-Voigtei",
"4939009", "Badel",
"492133", "Dormagen",
"494106", "Quickborn\ Kreis\ Pinneberg",
"493935", "Tangerhütte",
"492173", "Langenfeld\ Rheinland",
"492723", "Kirchhundem",
"497025", "Neuffen",
"4936333", "Heringen\ Helme",
"492962", "Olsberg",
"495864", "Jameln",
"499236", "Nagel",
"496468", "Dautphetal\-Mornshausen",
"494265", "Fintel",
"498337", "Altenstadt\ Iller",
"4939852", "Schönermark\ bei\ Prenzlau",
"4935931", "Königswartha",
"498377", "Unterthingau",
"496192", "Hofheim\ am\ Taunus",
"4936077", "Grossbodungen",
"498822", "Oberammergau",
"4936733", "Kaulsdorf",
"4933086", "Grieben\ Kreis\ Oberhavel",
"499276", "Bischofsgrün",
"496252", "Heppenheim\ Bergstrasse",
"497335", "Wiesensteig",
"4939931", "Röbel\ Müritz",
"497375", "Obermarchtal",
"4939996", "Törpin",
"4939859", "Fürstenwerder",
"4933838", "Päwesin",
"499645", "Eschenbach\ in\ der\ Oberpfalz",
"492562", "Gronau\ Westfalen",
"496626", "Wildeck\-Obersuhl",
"4934381", "Colditz",
"492387", "Drensteinfurt\-Walstedde",
"493535", "Herzberg\ Elster",
"495143", "Winsen\ Aller",
"4933395", "Zerpenschleuse",
"4939002", "Oebisfelde",
"4934781", "Greifenhagen",
"498261", "Mindelheim",
"498027", "Dietramszell",
"497384", "Schelklingen\-Hütten",
"494329", "Langwedel\ Holstein",
"496458", "Rosenthal\ Hessen",
"494255", "Martfeld",
"494550", "Bühnsdorf",
"4938422", "Neukloster",
"4933363", "Altenhof\ Kreis\ Barnim",
"4939749", "Grambow\ bei\ Pasewalk",
"496307", "Schopp",
"492952", "Rüthen",
"496073", "Babenhausen\ Hessen",
"494477", "Lastrup\-Hemmelte",
"495854", "Bleckede\-Barskamp",
"4934492", "Lucka",
"497243", "Ettlingen",
"496033", "Butzbach",
"4935342", "Mühlberg\ Elbe",
"4933763", "Bestensee",
"499289", "Schwarzenbach\ am\ Wald",
"497402", "Fluorn\-Winzeln",
"4939349", "Parey\ Elbe",
"497431", "Albstadt\-Ebingen",
"495108", "Gehrden\ Han",
"498191", "Landsberg\ am\ Lech",
"496821", "Neunkirchen\ Saar",
"497704", "Geisingen\ Baden",
"4934424", "Reuden\ bei\ Zeitz",
"496787", "Niederbrombach",
"4938303", "Sellin\ Ostseebad",
"497471", "Hechingen",
"4934923", "Cobbelsdorf",
"495925", "Wietmarschen",
"495525", "Walkenried",
"496323", "Edenkoben",
"499741", "Bad\ Brückenau",
"492426", "Nörvenich",
"498251", "Aichach",
"499398", "Birkenfeld\ bei\ Würzburg",
"493984", "Prenzlau",
"497682", "Elzach",
"496262", "Aglasterhausen",
"4938207", "Stäbelow",
"4939342", "Gladau",
"492552", "Steinfurt\-Borghorst",
"4936640", "Remptendorf",
"4933436", "Prötzel",
"4938429", "Glasin",
"494950", "Holtland",
"4939742", "Brüssow\ bei\ Pasewalk",
"494195", "Hartenholm",
"498809", "Wessobrunn",
"498243", "Fuchstal",
"494546", "Mustin\ Lauenburg",
"495903", "Emsbüren",
"49241", "Aachen",
"492632", "Andernach",
"498402", "Münchsmünster",
"4935204", "Wilsdruff",
"498384", "Röthenbach\ Allgäu",
"492672", "Treis\-Karden",
"4934243", "Bad\ Düben",
"495161", "Walsrode",
"4935698", "Hornow",
"498704", "Altdorf\-Pfettrach",
"499628", "Ursensollen",
"495283", "Lügde\-Rischenau",
"4936967", "Geisa",
"492601", "Nauort",
"498431", "Neuburg\ an\ der\ Donau",
"495344", "Lengede",
"495527", "Duderstadt",
"496693", "Neuental",
"497191", "Backnang",
"497251", "Bruchsal",
"498682", "Laufen\ Salzach",
"496785", "Herrstein",
"492374", "Iserlohn\-Letmathe",
"4934347", "Oelzschau\ bei\ Borna",
"4939000", "Beetzendorf",
"492334", "Hagen\-Hohenlimburg",
"4937327", "Rechenberg\-Bienenmühle",
"496238", "Dirmstein",
"494435", "Grossenkneten",
"4934656", "Wallhausen\ Sachsen\-Anhalt",
"499466", "Stamsried",
"495642", "Warburg\-Scherfede",
"4939204", "Niederndodeleben",
"4936606", "Kraftsdorf",
"494257", "Schweringen",
"495503", "Nörten\-Hardenberg",
"494475", "Molbergen",
"494946", "Grossefehn\-Bagband",
"494630", "Barderup",
"496305", "Hochspeyer",
"496734", "Flonheim",
"494331", "Rendsburg",
"498025", "Miesbach",
"4936205", "Gräfenroda",
"499922", "Zwiesel",
"494371", "Burg\ auf\ Fehmarn",
"496396", "Hinterweidenthal",
"496401", "Grünberg\ Hessen",
"493537", "Jessen\ Elster",
"496124", "Bad\ Schwalbach",
"496774", "Kaub",
"492385", "Hamm\-Rhynern",
"492938", "Ense",
"493761", "Werdau\ Sachsen",
"497822", "Ettenheim",
"4935872", "Neusalza\-Spremberg",
"497429", "Egesheim",
"494484", "Hude\-Wüsting",
"496432", "Diez",
"4934978", "Radegast\ Kreis\ Köthen",
"499647", "Kirchenthumbach",
"49661", "Fulda",
"4936649", "Gefell\ bei\ Schleiz",
"4933208", "Fahrland",
"496472", "Weilmünster",
"494302", "Kirchbarkau",
"495151", "Hameln",
"497337", "Nellingen\ Alb",
"499763", "Sulzdorf\ an\ der\ Lederhecke",
"4939740", "Nechlin",
"498375", "Weitnau",
"495948", "Itterbeck",
"498208", "Eurasburg\ bei\ Augsburg",
"4936642", "Harra",
"496681", "Hilders",
"499149", "Weissenburg\-Suffersheim",
"497183", "Rudersberg\ Württemberg",
"498335", "Fellheim",
"492538", "Drensteinfurt\-Rinkerode",
"494267", "Lauenbrück",
"494833", "Wesselburen",
"493937", "Osterburg\ Altmark",
"497261", "Sinsheim",
"494604", "Grossenwiehe",
"499522", "Eltmann",
"494873", "Aukrug",
"497625", "Zell\ im\ Wiesental",
"4933604", "Lebus",
"499654", "Pleystein",
"497420", "Deisslingen",
"495582", "Sankt\ Andreasberg",
"4936450", "Kranichfeld",
"492241", "Siegburg",
"494748", "Stubben\ bei\ Bremerhaven",
"495367", "Rühen",
"496336", "Dellfeld",
"492433", "Hückelhoven",
"494406", "Berne",
"4933337", "Altkünkendorf",
"492473", "Simmerath",
"492058", "Wülfrath",
"498542", "Ortenburg",
"499352", "Lohr\ am\ Main",
"495202", "Oerlinghausen",
"495443", "Lemförde",
"494893", "Hohenaspe",
"492598", "Senden\-Ottmarsbocholt",
"495271", "Höxter",
"498395", "Tannheim\ Württemberg",
"4933233", "Ketzin",
"492309", "Waltrop",
"495231", "Detmold",
"496026", "Grossostheim",
"499207", "Königsfeld\ Oberfranken",
"497131", "Heilbronn\ Neckar",
"495357", "Grasleben",
"496804", "Mandelbachtal",
"496633", "Homberg\ Ohm",
"498306", "Ronsberg",
"496673", "Haunetal",
"4939407", "Seehausen\ Börde",
"497721", "Villingen\ im\ Schwarzwald",
"497171", "Schwäbisch\ Gmünd",
"495746", "Rödinghausen",
"496541", "Traben\-Trarbach",
"496158", "Riedstadt",
"496709", "Fürfeld\ Kreis\ Bad\ Kreuznach",
"492835", "Issum",
"4935608", "Gross\ Ossnig",
"494177", "Drage\ Elbe",
"499664", "Hahnbach",
"492692", "Kelberg",
"494137", "Barendorf",
"494881", "Friedrichstadt",
"494244", "Harpstedt",
"497082", "Neuenbürg\ Württemberg",
"4939294", "Gross\ Rosenburg",
"49481", "Heide\ Holstein",
"494639", "Schafflund",
"495845", "Bergen\ Dumme",
"499223", "Rugendorf",
"4939608", "Staven",
"494383", "Grebin",
"496298", "Möckmühl",
"494495", "Friesoythe\-Thüle",
"494703", "Loxstedt\-Donnern",
"492776", "Bad\ Endbach\-Hartenrod",
"492394", "Neuenrade\-Affeln",
"4939222", "Möser",
"492736", "Burbach\ Siegerl",
"498721", "Eggenfelden",
"494826", "Hohenlockstedt",
"498171", "Wolfratshausen",
"4936025", "Körner",
"4938393", "Binz\ Ostseebad",
"498131", "Dachau",
"4938793", "Dergenthin",
"492624", "Höhr\-Grenzhausen",
"497306", "Vöhringen\ Iller",
"4935435", "Gollmitz\ bei\ Calau",
"493838", "Bergen\ auf\ Rügen",
"4936452", "Berlstedt",
"494497", "Barssel\-Harkebrügge",
"496093", "Laufach",
"49211", "Düsseldorf",
"499280", "Selbitz\ Oberfranken",
"4937343", "Jöhstadt",
"498102", "Höhenkirchen\-Siegertsbrunn",
"495461", "Bramsche\ Hase",
"494559", "Wensin",
"494320", "Heidmühlen",
"4933963", "Wulfersdorf\ bei\ Wittstock",
"494135", "Kirchgellersen",
"494959", "Dollart",
"499166", "Münchsteinach",
"4938297", "Moitin",
"498082", "Schwindegg",
"492181", "Grevenbroich",
"494175", "Egestorf\ Nordheide",
"4936459", "Blankenhain\ Thüringen",
"494725", "Helgoland",
"492837", "Weeze",
"4936084", "Heuthen",
"492263", "Engelskirchen",
"499338", "Röttingen\ Unterfranken",
"495042", "Bad\ Münder\ am\ Deister",
"496553", "Schönecken",
"499378", "Eichenbühl\-Riedern",
"495355", "Frellstedt",
"499205", "Vorbach",
"4938461", "Bützow",
"4938738", "Karow\ bei\ Lübz",
"4934446", "Grosskorbetha",
"499974", "Traitsching",
"497129", "Lichtenstein\ Württemberg",
"496132", "Ingelheim\ am\ Rhein",
"494184", "Hanstedt\ Nordheide",
"4935024", "Stadt\ Wehlen",
"4935796", "Panschwitz\-Kuckau",
"493342", "Neuenhagen\ bei\ Berlin",
"496172", "Bad\ Homburg\ von\ der\ Höhe",
"497739", "Hilzingen",
"496722", "Rüdesheim\ am\ Rhein",
"495451", "Ibbenbüren",
"4939085", "Zichtau",
"497542", "Tettnang",
"4933982", "Hoppenrade\ Kreis\ Prignitz",
"492193", "Dabringhausen",
"497834", "Wolfach",
"4937755", "Schönheide\ Erzgebirge",
"495828", "Himbergen",
"496101", "Bad\ Vilbel",
"496424", "Ebsdorfergrund",
"494621", "Schleswig",
"496081", "Usingen",
"492253", "Bad\ Münstereifel",
"4933053", "Zehlendorf\ Kreis\ Oberhavel",
"493644", "Apolda",
"4933989", "Sadenbeck",
"497942", "Neuenstein\ Württemberg",
"496563", "Kyllburg",
"495365", "Wolfsburg\-Neindorf",
"499534", "Burgpreppach",
"499156", "Neuhaus\ an\ der\ Pegnitz",
"4939396", "Neukirchen\ Altmark",
"497627", "Steinen\ Kreis\ Lörrach",
"497395", "Ehingen\-Dächingen",
"497483", "Horb\-Mühringen",
"499574", "Marktzeuln",
"499842", "Uffenheim",
"496803", "Mandelbachtal\-Ommersheim",
"496249", "Guntersblum",
"495165", "Rethem\ Aller",
"496022", "Obernburg\ am\ Main",
"494682", "Amrum",
"496634", "Gemünden\ Felda",
"496674", "Friedewald\ Hessen",
"492605", "Löf",
"498435", "Ehekirchen",
"498670", "Reischach\ Kreis\ Altötting",
"499747", "Geroda\ Bayern",
"495060", "Bodenburg",
"49671", "Bad\ Kreuznach",
"497950", "Schnelldorf",
"493661", "Greiz",
"497195", "Winnenden",
"498257", "Inchenhofen",
"499663", "Neukirchen\ bei\ Sulzbach\-Rosenberg",
"499356", "Burgsinn",
"4935387", "Seyda",
"495206", "Bielefeld\-Jöllenbeck",
"498630", "Oberneukirchen",
"498546", "Windorf\-Otterskirchen",
"4939387", "Havelberg",
"494243", "Twistringen",
"494402", "Rastede",
"496372", "Bruchmühlbach\-Miesau",
"4934208", "Löbnitz\ bei\ Delitzsch",
"496827", "Eppelborn",
"4933978", "Segeletz",
"494384", "Selent",
"497329", "Steinheim\ am\ Albuch",
"497255", "Graben\-Neudorf",
"496332", "Zweibrücken",
"4936258", "Friemar",
"496781", "Idar\-Oberstein",
"497477", "Jungingen\ bei\ Hechingen",
"492485", "Schleiden\-Dreiborn",
"495586", "Wieda",
"494704", "Drangstedt",
"496301", "Otterbach\ Pfalz",
"494471", "Cloppenburg",
"492393", "Sundern\-Allendorf",
"493529", "Heidenau\ Sachsen",
"494431", "Wildeshausen",
"492680", "Mündersbach",
"494208", "Grasberg",
"496405", "Laubach\ Hessen",
"492732", "Kreuztal",
"492381", "Hamm\ Westfalen",
"4939262", "Güsten\ Anh",
"499366", "Geroldshausen\ Unterfranken",
"4933656", "Bahro",
"498267", "Dirlewang",
"499653", "Eslarn",
"492772", "Herborn\ Hessen",
"498021", "Waakirchen",
"494335", "Hohn\ bei\ Rendsburg",
"4935930", "Seitschen",
"495939", "Sustrum",
"4933747", "Marzahna",
"492434", "Wegberg",
"495155", "Emmerthal",
"499178", "Abenberg\ Mittelfranken",
"499728", "Wülfershausen\ Unterfranken",
"492474", "Nideggen\-Schmidt",
"493765", "Reichenbach\ Vogtland",
"498782", "Pfeffenhausen",
"496848", "Homburg\-Einöd",
"492696", "Nohn\ Eifel",
"495444", "Wagenfeld",
"498331", "Memmingen",
"495295", "Lichtenau\ Westfalen",
"495742", "Preussisch\ Oldendorf",
"493866", "Cambs",
"494120", "Ellerhoop",
"494770", "Wischhafen",
"4935473", "Neu\ Lübbenau",
"4935974", "Hinterhermsdorf",
"498302", "Görisried",
"49231", "Dortmund",
"4937606", "Lengenfeld\ Vogtland",
"497265", "Angelbachtal",
"499973", "Furth\ im\ Wald",
"4934491", "Schmölln\ Thüringen",
"493931", "Stendal",
"497267", "Gemmingen",
"494183", "Jesteburg",
"497021", "Kirchheim\ unter\ Teck",
"4935341", "Bad\ Liebenwerda",
"4936943", "Bettenhausen\ Thüringen",
"499933", "Wallersdorf",
"4935954", "Grossharthau",
"493971", "Anklam",
"4935453", "Drahnsdorf",
"4989", "Munich",
"495659", "Ringgau",
"4939826", "Blankensee\ bei\ Neustrelitz",
"4938858", "Lassahn",
"499498", "Laaber",
"498086", "Buchbach\ Oberbayern",
"497833", "Hornberg\ Schwarzwaldbahn",
"499162", "Scheinfeld",
"496423", "Wetter\ Hessen",
"493902", "Diesdorf\ Altm",
"494261", "Rotenburg\ Wümme",
"4933923", "Flecken\ Zechlin",
"497371", "Riedlingen\ Württemberg",
"492254", "Weilerswist",
"499641", "Grafenwöhr",
"493643", "Weimar\ Thüringen",
"498106", "Vaterstetten",
"4935826", "Königshain\ bei\ Görlitz",
"497331", "Geislingen\ an\ der\ Steige",
"495157", "Emmerthal\-Börry",
"496564", "Neuerburg\ Eifel",
"4939453", "Derenburg",
"4933676", "Friedland\ bei\ Beeskow",
"497302", "Pfaffenhofen\ an\ der\ Roth",
"493571", "Hoyerswerda",
"4939954", "Stavenhagen\ Reuterstadt",
"499533", "Untermerzbach",
"4939341", "Redekin",
"494337", "Jevenstedt",
"498265", "Pfaffenhausen\ Schwaben",
"4939741", "Jatznick",
"494822", "Kellinghusen",
"496407", "Rabenau\ Hessen",
"493531", "Finsterwalde",
"4934363", "Cavertitz",
"499573", "Staffelstein\ Oberfranken",
"497484", "Simmersfeld",
"496358", "Kriegsfeld",
"499846", "Ipsheim",
"4938325", "Rolofshagen",
"4938456", "Langhagen\ bei\ Güstrow",
"4934905", "Wörlitz",
"4939428", "Pabstorf",
"4933877", "Nitzahn",
"498039", "Rott\ am\ Inn",
"494251", "Hoya",
"4938725", "Gross\ Godems",
"492623", "Ransbach\-Baumbach",
"499152", "Hartenstein\ Mittelfranken",
"4939851", "Göritz\ bei\ Prenzlau",
"497257", "Bruchsal\-Untergrombach",
"4935932", "Guttau",
"495921", "Nordhorn",
"497475", "Burladingen",
"492758", "Bad\ Berleburg\-Girkhausen",
"497946", "Bretzfeld",
"496094", "Weibersbrunn",
"497435", "Albstadt\-Laufen",
"496825", "Illingen\ Saar",
"498195", "Weil\ Kreis\ Landsberg\ am\ Lech",
"499340", "Königheim\-Brehmen",
"498550", "Philippsreut",
"4938823", "Selmsdorf",
"4938784", "Kleinow\ Kreis\ Prignitz",
"499745", "Wildflecken",
"497546", "Oberteuringen",
"492607", "Kobern\-Gondorf",
"495521", "Herzberg\ am\ Harz",
"4935939", "Hochkirch",
"4939932", "Malchow\ bei\ Waren",
"492264", "Marienheide",
"499292", "Konradsreuth",
"494191", "Kaltenkirchen\ Holstein",
"496726", "Lorch\ Rheingau",
"4934382", "Nerchau",
"496136", "Nieder\-Olm",
"495167", "Walsrode\-Westenholz",
"4934782", "Mansfeld\ Südharz",
"493346", "Seelow",
"496554", "Waxweiler",
"4939001", "Apenburg",
"498135", "Sulzemoos",
"497383", "Münsingen\-Buttenhausen",
"495853", "Neu\ Darchau",
"499349", "Werbach\-Wenkheim",
"496074", "Rödermark",
"4937434", "Bobenneukirchen",
"496034", "Wöllstadt",
"49781", "Offenburg",
"497244", "Weingarten\ Baden",
"496622", "Bebra",
"498725", "Wurmannsquick",
"4933981", "Putlitz",
"493583", "Zittau",
"495465", "Neuenkirchen\ bei\ Bramsche",
"492566", "Legden",
"4936426", "Ottendorf\ bei\ Stadtroda",
"4939888", "Lychen",
"496256", "Lampertheim\-Hüttenfeld",
"497703", "Bonndorf\ im\ Schwarzwald",
"49991", "Deggendorf",
"49951", "Bamberg",
"496324", "Hassloch",
"499272", "Fichtelberg",
"4939036", "Binde",
"496196", "Bad\ Soden\ am\ Taunus",
"494171", "Winsen\ Luhe",
"494721", "Cuxhaven",
"494131", "Lüneburg",
"493744", "Auerbach\ Vogtland",
"499232", "Wunsiedel",
"499201", "Gesees",
"495351", "Helmstedt",
"49340", "Dessau\ Anh",
"494102", "Ahrensburg",
"4938483", "Brüel",
"4935844", "Oybin\ Kurort",
"498320", "Missen\-Wilhams",
"492228", "Remagen\-Rolandseck",
"497727", "Vöhrenbach",
"498621", "Trostberg",
"495277", "Höxter\-Fürstenau",
"495455", "Tecklenburg\-Brochterbeck",
"492556", "Metelen",
"495650", "Cornberg",
"492174", "Burscheid\ Rheinland",
"492724", "Finnentrop\-Serkenrode",
"499438", "Fensterbach",
"496266", "Hassmersheim",
"495237", "Augustdorf",
"495863", "Zernien",
"496105", "Mörfelden\-Walldorf",
"4936451", "Buttelstedt",
"493991", "Waren\ Müritz",
"4938377", "Zinnowitz",
"4935754", "Klettwitz",
"4936743", "Teichel",
"492422", "Kreuzau",
"4934464", "Freyburg\ Unstrut",
"4939754", "Löcknitz\ Vorpom",
"493591", "Bautzen",
"495361", "Wolfsburg",
"4933848", "Raben",
"494625", "Jübek",
"496085", "Waldsolms",
"497391", "Ehingen\ Donau",
"4936845", "Gehlberg",
"495144", "Wathlingen",
"497748", "Grafenhausen\ Hochschwarzwald",
"4938462", "Baumgarten",
"492247", "Neunkirchen\-Seelscheid",
"494942", "Südbrookmerland",
"496733", "Gau\-Odernheim",
"492245", "Much",
"499198", "Heiligenstadt\ in\ Oberfranken",
"497621", "Lörrach",
"495646", "Willebadessen",
"499462", "Falkenstein\ Oberpfalz",
"4937367", "Lengefeld\ Erzgebirge",
"499869", "Wettringen\ Mittelfranken",
"496773", "Kamp\-Bornhofen",
"496123", "Eltville\ am\ Rhein",
"494627", "Dörpstedt",
"494483", "Ovelgönne\-Grossenmeer",
"496087", "Waldems",
"498686", "Petting",
"4939774", "Mönkebude",
"499764", "Höchheim",
"497569", "Isny\-Eisenbach",
"4935774", "Boxberg\ Sachsen",
"4938757", "Neustadt\-Glewe",
"4936927", "Unterellen",
"496107", "Kelsterbach",
"494129", "Haseldorf",
"497184", "Kaisersbach",
"494779", "Freiburg\ Elbe",
"494834", "Büsum",
"495235", "Blomberg\ Lippe",
"494603", "Havetoft",
"492676", "Ulmen",
"495275", "Höxter\-Ottbergen",
"498406", "Böhmfeld",
"492636", "Burgbrohl",
"495308", "Lehre",
"495457", "Hopsten\-Schale",
"494874", "Todenbüttel",
"494542", "Mölln\ Lauenburg",
"4939221", "Möckern\ bei\ Magdeburg",
"495904", "Lengerich\ Emsl",
"4938847", "Boizenburg\ Elbe",
"49881", "Weilheim\ in\ Oberbayern",
"492802", "Alpen",
"498639", "Neumarkt\-Sankt\ Veit",
"492409", "Stolberg\-Gressenich",
"499526", "Riedbach",
"497725", "Königsfeld\ im\ Schwarzwald",
"497175", "Leinzell",
"495069", "Nordstemmen",
"498679", "Burgkirchen\ an\ der\ Alz",
"497135", "Brackenheim",
"498383", "Grünenbach\ Allgäu",
"4936873", "Themar",
"497959", "Frankenhardt",
"495284", "Schwalenberg",
"492871", "Bocholt",
"498703", "Essenbach",
"494885", "Bergenhusen",
"496694", "Neukirchen\ Knüll",
"496545", "Blankenrath",
"4937295", "Lugau\ Erzgebirge",
"492831", "Geldern",
"499452", "Langquaid",
"492373", "Menden\ Sauerland",
"494491", "Friesoythe",
"496476", "Mengerskirchen",
"492689", "Dierdorf",
"492333", "Ennepetal",
"496436", "Dornburg\ Hessen",
"495467", "Voltlage",
"4936375", "Kindelbrück",
"495841", "Lüchow\ Wendland",
"499268", "Teuschnitz",
"497826", "Schuttertal",
"498727", "Falkenberg\ Niederbayern",
"496392", "Hauenstein\ Pfalz",
"498177", "Münsing\ Starnberger\ See",
"4934604", "Niemberg",
"499926", "Frauenau",
"498137", "Petershausen",
"4938228", "Dettmannsdorf\-Kölzow",
"4934298", "Taucha\ bei\ Leipzig",
"495504", "Friedland\ Kreis\ Göttingen",
"498340", "Baisweil",
"499195", "Adelsdorf\ Mittelfranken",
"492991", "Marsberg\-Bredelar",
"492248", "Hennef\-Uckerath",
"497747", "Berau",
"4935476", "Wittmannsdorf\-Bückchen",
"496161", "Brensbach",
"497356", "Schemmerhofen",
"497663", "Eichstetten",
"4935692", "Kerkwitz",
"4937603", "Wildenfels",
"4933874", "Stechow\ Brandenburg",
"499090", "Rain\ Lech",
"498152", "Herrsching\ am\ Ammersee",
"492051", "Velbert",
"496283", "Hardheim\ Odenwald",
"493724", "Burgstädt",
"496344", "Schwegenheim",
"495693", "Volkmarsen",
"496527", "Oberweis",
"494509", "Gross\ Grönau",
"494741", "Nordholz\ bei\ Bremerhaven",
"498846", "Uffing\ am\ Staffelsee",
"4938871", "Mühlen\ Eichsen",
"4938787", "Glöwen",
"498292", "Dinkelscherben",
"495238", "Nieheim\-Himmighausen",
"494289", "Kirchtimke",
"497224", "Gernsbach",
"496642", "Schlitz",
"4933830", "Ziesar",
"498745", "Bodenkirchen",
"4933653", "Ziltendorf",
"495305", "Sickte",
"492591", "Lüdinghausen",
"499255", "Marktleugast",
"496503", "Hermeskeil",
"495278", "Höxter\-Ovenhausen",
"495734", "Bergkirchen\ Westfalen",
"497728", "Niedereschach",
"492227", "Bornheim\-Merten",
"495401", "Georgsmarienhütte",
"499086", "Fremdingen",
"49335", "Frankfurt\ \(Oder\)",
"495774", "Wagenfeld\-Ströhen",
"497138", "Schwaigern",
"492583", "Sassenberg",
"495839", "Wittingen\-Ohrdorf",
"49561", "Kassel",
"495432", "Löningen",
"4936625", "Langenwetzendorf",
"497653", "Lenzkirch",
"4933202", "Töplitz",
"495472", "Bad\ Essen",
"496151", "Darmstadt",
"497366", "Abtsgmünd",
"498573", "Ering",
"492203", "Cologne\-Porz",
"494276", "Borstel\ bei\ Sulingen",
"496291", "Adelsheim",
"4936648", "Dittersdorf\ bei\ Schleiz",
"4933209", "Caputh",
"499560", "Grub\ am\ Forst",
"4934979", "Wulfen\ Sachsen\-Anhalt",
"499265", "Pressig",
"495681", "Homberg\ Efze",
"4933971", "Kyritz\ Brandenburg",
"498533", "Rotthalmünster",
"494236", "Kirchlinteln",
"492744", "Herdorf",
"492983", "Winterberg\-Siedlinghausen",
"493966", "Cölpin",
"499106", "Markt\ Erlbach",
"498641", "Grassau\ Kreis\ Traunstein",
"4939957", "Gielow",
"499873", "Abenberg\-Wassermungenau",
"4939977", "Jördenstorf",
"493831", "Stralsund",
"498138", "Schwabhausen\ bei\ Dachau",
"4939421", "Osterwieck",
"494522", "Plön",
"498728", "Geratskirchen",
"498860", "Bernbeuren",
"498178", "Icking",
"499604", "Wernberg\-Köblitz",
"499833", "Heidenheim\ Mittelfranken",
"497162", "Süssen",
"493871", "Parchim",
"496864", "Mettlach",
"499267", "Nordhalben",
"4939858", "Bietikow",
"4938826", "Dassow",
"4933839", "Wusterwitz",
"497973", "Obersontheim",
"494149", "Fredenbeck",
"495468", "Bramsche\-Engter",
"498366", "Oy\-Mittelberg",
"495192", "Munster",
"4937463", "Bergen\ Vogtland",
"497933", "Creglingen",
"4936785", "Gräfinau\-Angstedt",
"4933744", "Hohenseefeld",
"494456", "Varel\-Altjührden",
"494763", "Gnarrenburg",
"497533", "Allensbach",
"499302", "Rottendorf\ Unterfranken",
"495252", "Bad\ Lippspringe",
"4933832", "Rogäsen",
"499484", "Brennberg",
"497573", "Stetten\ am\ kalten\ Markt",
"497641", "Emmendingen",
"4938453", "Mistorf",
"495626", "Bad\ Zwesten",
"499371", "Miltenberg",
"494922", "Borkum",
"499331", "Ochsenfurt",
"4939008", "Kunrau",
"492520", "Wadersloh\-Diestedde",
"492225", "Meckenheim\ Rheinland",
"492359", "Kierspe",
"499946", "Hohenwarth\ bei\ Kötzing",
"4939325", "Vinzelberg",
"4938428", "Hohenkirchen\ bei\ Wismar",
"495458", "Hopsten",
"4939456", "Altenbrak",
"4933673", "Weichensdorf",
"4933200", "Bergholz\-Rehbrücke",
"4934498", "Rositz",
"498663", "Ruhpolding",
"496854", "Oberthal\ Saar",
"495073", "Neustadt\-Esperke",
"499257", "Zell\ Oberfranken",
"495307", "Braunschweig\-Wenden",
"497340", "Neenstetten",
"495033", "Wunstorf\-Grossenheidorn",
"494466", "Wittmund\-Ardorf",
"499435", "Schwarzenfeld",
"4938851", "Zarrentin",
"4936481", "Neustadt\ an\ der\ Orla",
"4933926", "Herzberg\ Mark",
"495821", "Bad\ Bevensen",
"4935384", "Steinsdorf\ bei\ Jessen",
"493494", "Wolfen",
"496108", "Mühlheim\ am\ Main",
"4935823", "Ostritz",
"497152", "Leonberg\ Württemberg",
"495323", "Clausthal\-Zellerfeld",
"496525", "Irrel",
"496220", "Wilhelmsfeld",
"493636", "Greussen",
"4939823", "Rechlin",
"492369", "Dorsten\-Wulfen",
"4939384", "Arendsee\ Altmark",
"4939348", "Klitsche",
"495262", "Extertal",
"4935725", "Wittichenau",
"494753", "Balje",
"492043", "Gladbeck",
"499197", "Egloffstein",
"498224", "Offingen\ Donau",
"4935456", "Terpt",
"4939748", "Viereck",
"4936946", "Erbenhausen\ Thüringen",
"499546", "Burgebrach",
"497745", "Jestetten",
"4935325", "Rückersdorf\ bei\ Finsterwalde",
"498452", "Geisenfeld",
"4933094", "Löwenberg",
"497063", "Bad\ Wimpfen",
"495953", "Börger",
"497581", "Saulgau",
"49791", "Schwäbisch\ Hall",
"494362", "Heiligenhafen",
"4938844", "Gülze",
"493772", "Schneeberg\ Erzgebirge",
"4936458", "Bad\ Berka",
"499495", "Breitenbrunn\ Oberpfalz",
"499383", "Wiesentheid",
"498754", "Volkenschwand",
"496461", "Biedenkopf",
"494223", "Ganderkesee\-Bookholzberg",
"493381", "Brandenburg\ an\ der\ Havel",
"499639", "Mähring",
"499244", "Betzenstein",
"49981", "Ansbach",
"4939925", "Wredenhagen",
"492651", "Mayen",
"49331", "Potsdam",
"494664", "Neukirchen\ bei\ Niebüll",
"499177", "Heideck",
"499727", "Schonungen\-Marktsteinach",
"492866", "Dorsten\-Rhade",
"4933841", "Belzig",
"493883", "Hagenow",
"4938332", "Gross\ Bisdorf",
"498268", "Tussenhausen",
"492360", "Haltern\-Lippramsdorf",
"497272", "Rülzheim",
"4939483", "Ballenstedt",
"49751", "Ravensburg",
"4936042", "Tonna",
"496355", "Albisheim\ Pfrimm",
"497232", "Königsbach\-Stein",
"496229", "Neckarsteinach",
"496042", "Büdingen\ Hessen",
"495553", "Kalefeld",
"4938732", "Gallin\ bei\ Lübz",
"494207", "Oyten",
"4934607", "Wettin",
"493949", "Oschersleben\ Bode",
"49208", "Oberhausen\ Rheinland",
"498764", "Mauern\ Kreis\ Freising",
"4938486", "Gustävel",
"4937364", "Reitzenhain\ Erzgebirge",
"495132", "Lehrte",
"4935600", "Döbern\ NL",
"495172", "Ilsede",
"495722", "Bückeburg",
"492661", "Bad\ Marienberg\ Westerwald",
"496451", "Frankenberg\ Eder",
"493605", "Leinefelde",
"494140", "Estorf\ Kreis\ Stade",
"492755", "Bad\ Berleburg\-Schwarzenau",
"497478", "Hirrlingen",
"495963", "Bawinkel",
"498869", "Kinsau",
"4939777", "Borkenfriede",
"498462", "Berching",
"4939033", "Wallstawe",
"497053", "Bad\ Teinach\-Zavelstein",
"4939881", "Ringenwalde\ bei\ Templin",
"495101", "Pattensen",
"495424", "Bad\ Rothenfelde",
"494352", "Damp",
"4938754", "Leussow\ bei\ Ludwigslust",
"4936423", "Orlamünde",
"4936924", "Mihla",
"498258", "Sielenbach",
"499406", "Mintraching",
"499391", "Marktheidenfeld",
"492529", "Oelde\-Stromberg",
"4935033", "Rosenthal\ Sächsische\ Schweiz",
"4938354", "Wusterhusen",
"495563", "Kreiensen",
"499748", "Motten",
"4936702", "Lauscha",
"4939600", "Zwiedorf",
"498041", "Bad\ Tölz",
"492856", "Hamminkeln\-Brünen",
"494842", "Nordstrand",
"4934772", "Helbra",
"495168", "Walsrode\-Stellichte",
"495492", "Steinfeld\ Oldenburg",
"497764", "Herrischried",
"496582", "Freudenburg",
"494534", "Steinburg\ Kreis\ Storman",
"494156", "Talkau",
"493623", "Friedrichroda",
"495336", "Semmenstedt",
"492608", "Welschneudorf",
"4938374", "Lassan\ bei\ Wolgast",
"495376", "Wesendorf\ Kreis\ Gifhorn",
"497462", "Immendingen",
"498053", "Bad\ Endorf",
"499621", "Amberg\ Oberpfalz",
"496202", "Schwetzingen",
"496443", "Ehringshausen\ Dill",
"4934467", "Eckartsberga",
"497258", "Oberderdingen\-Flehingen",
"496271", "Eberbach\ Baden",
"494296", "Schwanewede\-Aschwarden",
"498593", "Untergriesbach",
"499569", "Sesslach",
"494934", "Marienhafe",
"4934291", "Borsdorf",
"499184", "Deining\ Oberpfalz",
"4934779", "Abberode",
"496231", "Hochdorf\-Assenheim",
"495026", "Steimbke",
"4938221", "Marlow",
"497041", "Mühlacker",
"494974", "Neuharlingersiel",
"498581", "Waldkirchen\ Niederbayern",
"495804", "Rätzlingen\ Kreis\ Uelzen",
"4937437", "Bad\ Elster",
"492902", "Warstein",
"499070", "Tapfheim",
"496357", "Standenbühl",
"494205", "Ottersberg",
"496408", "Buseck",
"495633", "Diemelsee",
"4934635", "Bad\ Lauchstädt",
"497452", "Nagold",
"494338", "Alt\ Duvenstedt",
"495673", "Immenhausen\ Hessen",
"498063", "Feldkirchen\-Westerham",
"499099", "Kaisheim",
"4939245", "Loburg",
"496746", "Pfalzfeld",
"492971", "Schmallenberg\-Dorlar",
"499725", "Poppenhausen\ Unterfranken",
"499175", "Spalt",
"495158", "Hemeringen",
"495541", "Hann\.\ Münden",
"4935602", "Drebkau",
"494166", "Ahlerstedt",
"498349", "Stötten\ am\ Auerberg",
"492931", "Arnsberg",
"499135", "Hessdorf\ Mittelfranken",
"497754", "Görwihl",
"499497", "Seubersdorf\ in\ der\ Oberpfalz",
"4935609", "Drachhausen",
"4939602", "Kleeth",
"495941", "Neuenhaus\ Dinkel",
"492571", "Greven\ Westfalen",
"498232", "Schwabmünchen",
"4935245", "Burkhardswalde\-Munzig",
"4933475", "Letschin",
"492643", "Altenahr",
"499826", "Weidenbach\ Mittelfranken",
"497268", "Bad\ Rappenau\-Obergimpern",
"498272", "Wertingen",
"492502", "Nottuln",
"49851", "Passau",
"496023", "Alzenau\ in\ Unterfranken",
"496802", "Völklingen\-Lauterbach",
"494683", "Oldsum",
"496409", "Biebertal",
"4935242", "Nossen",
"4933472", "Golzow\ bei\ Seelow",
"4934639", "Wallendorf\ Luppe",
"494339", "Christiansholm",
"4933631", "Bad\ Saarow\-Pieskow",
"496871", "Wadern",
"495159", "Coppenbrügge\-Bisperode",
"495935", "Twist\-Schöninghsdorf",
"4938203", "Bad\ Doberan",
"498348", "Bidingen",
"495975", "Rheine\-Mesum",
"495446", "Rehden",
"499662", "Vilseck",
"492694", "Wershofen",
"4939605", "Gross\ Nemerow",
"492545", "Rosendahl\-Darfeld",
"496187", "Schöneck",
"496831", "Saarlouis",
"494242", "Syke",
"497084", "Schömberg\ bei\ Neuenbürg",
"4933367", "Friedrichswalde\ Brandenburg",
"499141", "Weissenburg\ in\ Bayern",
"496373", "Schönenberg\-Kübelberg",
"492945", "Lippstadt\-Benninghausen",
"4935605", "Komptendorf",
"496007", "Rosbach\-Rodheim",
"494403", "Bad\ Zwischenahn",
"4933767", "Friedersdorf\ bei\ Berlin",
"492436", "Wegberg\-Rödgen",
"496333", "Waldfischbach\-Burgalben",
"495535", "Polle",
"495657", "Meissner",
"499364", "Zellingen",
"4934632", "Mücheln\ Geiseltal",
"492392", "Werdohl",
"4934927", "Globig\-Bleddin",
"494795", "Garlstedt",
"4939242", "Prödel",
"4933479", "Küstrin\-Kietz",
"497269", "Sulzfeld\ Baden",
"4938307", "Poseritz",
"4935249", "Basslitz",
"492733", "Hilchenbach",
"493925", "Stassfurt",
"496245", "Biblis",
"492773", "Haiger",
"499652", "Waidhaus",
"495584", "Hattorf\ am\ Harz",
"494706", "Schiffdorf",
"498801", "Seeshaupt",
"497130", "Löwenstein\ Württemberg",
"497720", "Schwenningen\ am\ Neckar",
"4935206", "Kreischa\ bei\ Dresden",
"498544", "Eging\ am\ See",
"498327", "Rettenberg",
"499354", "Rieneck",
"495204", "Steinhagen\ Westfalen",
"498783", "Rohr\ in\ Niederbayern",
"4936604", "Münchenbernsdorf",
"4939206", "Eichenbarleben",
"494805", "Schafstedt",
"4934654", "Stolberg\ Harz",
"497325", "Sontheim\ an\ der\ Brenz",
"497259", "Östringen\-Odenheim",
"499568", "Neustadt\ bei\ Coburg",
"495743", "Espelkamp\-Gestringen",
"4934775", "Wippra",
"4936337", "Schiedungen",
"496676", "Hohenroda\ Hessen",
"498303", "Waltenhofen",
"4936737", "Drognitz",
"496636", "Romrod",
"493525", "Riesa",
"4934426", "Kayna",
"499281", "Hof\ Saale",
"4936705", "Oberweissbach\ Thüringer\ Wald",
"499972", "Waldmünchen",
"495665", "Guxhagen",
"498075", "Amerang",
"496134", "Mainz\-Kastel",
"494182", "Tostedt",
"496556", "Pronsfeld",
"493344", "Bad\ Freienwalde",
"496724", "Stromberg\ Hunsrück",
"496174", "Königstein\ im\ Taunus",
"492266", "Lindlar",
"499932", "Osterhofen",
"494321", "Neumünster",
"498035", "Raubling",
"499901", "Hengersberg\ Bayern",
"498170", "Strasslach\-Dingharting",
"498868", "Schwabsoien",
"497544", "Markdorf",
"497327", "Dischingen",
"499163", "Dachsbach",
"4935240", "Tauscha\ bei\ Grossenhain",
"497832", "Haslach\ im\ Kinzigtal",
"495751", "Rinteln",
"4933470", "Lietzen",
"492928", "Soest\-Ostönnen",
"496422", "Kirchhain",
"4933708", "Rangsdorf",
"4933434", "Herzfelde\ bei\ Strausberg",
"4939088", "Letzlingen",
"4933933", "Lindow\ Mark",
"492528", "Ennigerloh\-Enniger",
"498325", "Oberstaufen\-Thalkirchdorf",
"498259", "Schiltberg",
"4935891", "Rothenburg\ OL",
"497944", "Kupferzell",
"496096", "Wiesen\ Unterfranken",
"499749", "Oberbach\ Unterfranken",
"499532", "Maroldsweisach",
"497303", "Illertissen",
"494823", "Wilster",
"499844", "Obernzenn",
"499572", "Burgkunstadt",
"49921", "Bayreuth",
"496247", "Worms\-Pfeddersheim",
"4934343", "Regis\-Breitingen",
"4933084", "Gutengermendorf",
"497486", "Horb\-Altheim",
"498858", "Kochel\-Walchensee",
"4939361", "Lüderitz",
"499153", "Schnaittach",
"492622", "Bendorf\ am\ Rhein",
"495761", "Stolzenau",
"4934743", "Ermsleben",
"4938735", "Plau\ am\ See",
"497348", "Beimerstetten",
"4939929", "Jabel\ bei\ Waren",
"498421", "Eichstätt\ Bayern",
"496566", "Körperich",
"498104", "Sauerlach",
"4937323", "Lichtenberg\ Erzgebirge",
"495655", "Wanfried",
"499638", "Neualbenreuth",
"492256", "Mechernich\-Satzvey",
"492947", "Anröchte",
"496185", "Hammersbach\ Hessen",
"492324", "Hattingen\ Ruhr",
"492547", "Rosendahl\-Osterwick",
"495977", "Spelle",
"492196", "Wermelskirchen",
"498084", "Taufkirchen\ Vils",
"4939922", "Dambeck\ bei\ Röbel",
"495937", "Geeste\-Gross\ Hesepe",
"4936963", "Dorndorf\ Rhön",
"498269", "Unteregg\ bei\ Mindelheim",
"4936464", "Wormstedt",
"499293", "Berg\ Oberfranken",
"4936028", "Kammerforst\ Thüringen",
"4939994", "Metschow",
"4935361", "Schlieben",
"495044", "Springe\-Eldagsen",
"496228", "Schönau\ Odenwald",
"494425", "Wangerland\-Hooksiel",
"4933452", "Neulewin",
"497382", "Römerstein",
"494561", "Neustadt\ in\ Holstein",
"495459", "Hörstel",
"4935722", "Lauta\ bei\ Hoyerswerda",
"492954", "Rüthen\-Oestereiden",
"497731", "Singen\ Hohentwiel",
"495852", "Bleckede",
"495146", "Wietze",
"497121", "Reutlingen",
"497771", "Stockach",
"4935322", "Doberlug\-Kirchhain",
"497404", "Epfendorf",
"496623", "Rotenburg\ an\ der\ Fulda",
"4939329", "Möringen",
"494777", "Cadenberge",
"494127", "Westerhorn",
"496109", "Frankfurt\-Bergen\-Enkheim",
"496758", "Waldböckelheim",
"497702", "Blumberg\ Baden",
"4935026", "Dürrröhrsdorf\-Dittersbach",
"497567", "Leutkirch\-Friesenhofen",
"494737", "Stadland\-Schwei",
"4934444", "Lützen",
"492825", "Uedem",
"499273", "Bad\ Berneck\ im\ Fichtelgebirge",
"497967", "Jagstzell",
"498565", "Dietersburg\-Baumgarten",
"4939394", "Hohenberg\-Krusemark",
"492368", "Oer\-Erkenschwick",
"499233", "Arzberg\ Oberfranken",
"497684", "Glottertal",
"4939403", "Gröningen\ Sachsen\-Anhalt",
"4935329", "Dollenchen",
"496264", "Neudenau",
"4939322", "Tangermünde",
"499867", "Geslau",
"499441", "Kelheim",
"494103", "Wedel",
"492554", "Laer\ Kreis\ Steinfurt",
"493443", "Weissenfels\ Sachsen\-Anhalt",
"4939722", "Sarnow\ bei\ Anklam",
"494961", "Papenburg",
"499345", "Külsheim\ Baden",
"497675", "Bernau\ Baden",
"498139", "Röhrmoos",
"497635", "Schliengen",
"4933398", "Werneuchen",
"498179", "Eurasburg\ an\ der\ Loisach",
"497557", "Herdwangen\-Schönach",
"498095", "Aying",
"4933237", "Paulinenaue",
"492964", "Brilon\-Alme",
"495862", "Hitzacker\ Elbe",
"494551", "Bad\ Segeberg",
"494148", "Drochtersen\-Assel",
"492687", "Horhausen\ Westerwald",
"4933835", "Golzow\ bei\ Brandenburg",
"498824", "Oberau\ Loisach",
"4934955", "Gossa",
"492423", "Langerwehe",
"496326", "Deidesheim",
"4939051", "Calvörde",
"496254", "Lautertal\ Odenwald",
"499857", "Schopfloch\ Mittelfranken",
"4937381", "Penig",
"4936782", "Schmiedefeld\ am\ Rennsteig",
"494951", "Weener",
"492564", "Vreden",
"497957", "Kressberg",
"4933733", "Stülpe",
"496036", "Wölfersheim",
"495221", "Herford",
"497246", "Malsch\ Kreis\ Karlsruhe",
"498677", "Burghausen\ Salzach",
"495067", "Bockenem",
"492407", "Herzogenrath\-Kohlscheid",
"498637", "Lohkirchen",
"498555", "Perlesreut",
"4933333", "Tantow",
"498250", "Hilgertshausen\-Tandern",
"492358", "Meinerzhagen\-Valbert",
"498635", "Pleiskirchen",
"492405", "Würselen",
"493847", "Sternberg",
"497729", "Tennenbronn",
"496732", "Wörrstadt",
"494943", "Grossefehn",
"495506", "Adelebsen",
"496381", "Kusel",
"499924", "Bodenmais",
"498557", "Mauth",
"493461", "Merseburg\ Saale",
"499463", "Wald\ Oberpfalz",
"497955", "Wallhausen\ Württemberg",
"495065", "Sibbesse",
"496122", "Hofheim\-Wallau",
"497139", "Neuenstadt\ am\ Kocher",
"496772", "Nastätten",
"495838", "Gross\ Oesingen",
"497824", "Schwanau",
"496434", "Bad\ Camberg",
"494482", "Hatten",
"496474", "Villmar\-Aumenau",
"496701", "Sprendlingen\ Rheinhessen",
"499855", "Dentlein\ am\ Forst",
"492685", "Flammersfeld",
"496696", "Gilserberg",
"4936622", "Triebes",
"494671", "Bredstedt",
"4934975", "Görzig\ Kreis\ Köthen",
"4933205", "Michendorf",
"494631", "Glücksburg\ Ostsee",
"4939320", "Schinne",
"495286", "Ottenstein\ Niedersachsen",
"497555", "Deggenhausertal",
"4936208", "Ermstedt",
"497250", "Kraichtal",
"494602", "Freienwill",
"499524", "Zeil\ am\ Main",
"49631", "Kaiserslautern",
"499347", "Wittighausen",
"495906", "Lünne",
"494543", "Nusse",
"4939296", "Welsleben",
"498246", "Waal",
"4936694", "Schkölen\ Thüringen",
"492803", "Wesel\-Büderich",
"498121", "Markt\ Schwaben",
"498771", "Ergoldsbach",
"494876", "Reher\ Holstein",
"492634", "Rengsdorf",
"498404", "Oberdolling",
"498382", "Lindau\ Bodensee",
"499865", "Adelshofen\ Mittelfranken",
"4934223", "Dommitzsch",
"492674", "Bad\ Bertrich",
"4938293", "Kühlungsborn\ Ostseebad",
"498731", "Dingolfing",
"494836", "Hennstedt\ Dithmarschen",
"494330", "Emkendorf",
"498702", "Wörth\ an\ der\ Isar",
"49271", "Siegen",
"4933606", "Müllrose",
"495055", "Fassberg",
"499078", "Mertingen",
"499453", "Thalmassing",
"496400", "Mücke",
"497965", "Ellwangen\-Röhlingen",
"494508", "Krummesse",
"499766", "Grosswenkheim",
"497565", "Aichstetten\ Kreis\ Ravensburg",
"497260", "Sinsheim\-Hilsbach",
"498684", "Fridolfing",
"492827", "Goch\-Hassum",
"492372", "Hemer",
"494735", "Butjadingen\-Stollhamm",
"4934327", "Waldheim\ Sachsen",
"494775", "Grossenwörden",
"494125", "Seestermühe",
"492332", "Gevelsberg",
"4938797", "Karstädt\ Kreis\ Prignitz",
"494288", "Horstedt\ Kreis\ Rotenburg",
"496485", "Nentershausen\ Westerwald",
"4937347", "Bärenstein\ Kreis\ Annaberg",
"492301", "Holzwickede",
"496393", "Fischbach\ bei\ Dahn",
"495644", "Willebadessen\-Peckelsheim",
"4933967", "Freyenstein",
"4935695", "Simmersdorf",
"493423", "Eilenburg",
"492357", "Herscheid\ Westfalen",
"498638", "Waldkraiburg",
"492408", "Aachen\-Kornelimünster",
"499104", "Emskirchen",
"498678", "Marktl",
"4933087", "Bredereiche",
"495068", "Elze\ Leine",
"497958", "Rot\ Am\ See\-Brettheim",
"499421", "Straubing",
"497662", "Vogtsburg\ im\ Kaiserstuhl",
"4936076", "Niederorschel",
"493964", "Bredenfelde\ bei\ Strasburg",
"494234", "Dörverden",
"496282", "Walldürn",
"498153", "Wessling",
"495835", "Wahrenholz",
"4939203", "Barleben",
"4936840", "Trusetal",
"4936372", "Kleinneuhausen",
"495875", "Emmendorf",
"495692", "Wolfhagen",
"494274", "Varrel\ bei\ Sulingen",
"496531", "Bernkastel\-Kues",
"497364", "Oberkochen",
"492688", "Kroppach",
"492845", "Neukirchen\-Vluyn",
"4934244", "Mockrehna",
"4936379", "Holzengel",
"4937292", "Oederan",
"4935203", "Tharandt",
"498293", "Welden\ bei\ Augsburg",
"499269", "Tettau\ Kreis\ Kronach",
"496571", "Wittlich",
"495776", "Preussisch\ Ströhen",
"493564", "Schwarze\ Pumpe",
"495126", "Algermissen",
"497141", "Ludwigsburg\ Württemberg",
"497558", "Illmensee",
"499084", "Bissingen\ Schwaben",
"496643", "Herbstein",
"496502", "Schweich",
"4939997", "Jarmen",
"499199", "Kunreuth",
"4933638", "Rüdersdorf\ bei\ Berlin",
"495241", "Gütersloh",
"492582", "Everswinkel",
"499170", "Schwanstetten",
"499868", "Schillingsfürst",
"499720", "Üchtelhausen",
"497226", "Bühl\-Sand",
"495433", "Badbergen",
"492367", "Henrichenburg",
"494505", "Stockelsdorf\-Curau",
"495473", "Ostercappeln",
"497652", "Hinterzarten",
"499075", "Glött",
"498281", "Thannhausen\ Schwaben",
"49821", "Augsburg",
"492202", "Bergisch\ Gladbach",
"498572", "Tann\ Niederbayern",
"4938206", "Graal\-Müritz\ Seeheilbad",
"496346", "Annweiler\ am\ Trifels",
"492443", "Mechernich",
"497568", "Bad\ Wurzach\-Hauerz",
"4933437", "Reichenberg\ bei\ Strausberg",
"493726", "Flöha",
"496757", "Becherbach\ bei\ Kirn",
"494778", "Wingst",
"494128", "Kollmar",
"498532", "Griesbach\ im\ Rottal",
"498501", "Thyrnau",
"492271", "Bergheim\ Erft",
"492982", "Medebach",
"497354", "Erolzheim",
"494285", "Rhade\ bei\ Zeven",
"495309", "Lehre\-Wendhausen",
"499325", "Kleinlangheim",
"499872", "Heilsbronn",
"499544", "Baunach",
"4936966", "Kaltennordheim",
"494523", "Malente",
"4936842", "Oberhof\ Thüringen",
"4936370", "Grossenehrich",
"498226", "Bibertal",
"499439", "Neunburg\-Kemnath",
"496661", "Schlüchtern",
"49371", "Chemnitz\ Sachsen",
"494287", "Heeslingen\-Boitzen",
"492451", "Geilenkirchen",
"497163", "Ebersbach\ an\ der\ Fils",
"499832", "Wassertrüdingen",
"496755", "Odernheim\ am\ Glan",
"498652", "Berchtesgaden",
"497972", "Gschwend\ bei\ Gaildorf",
"493634", "Sömmerda",
"497932", "Niederstetten\ Württemberg",
"492828", "Emmerich\-Elten",
"495193", "Schneverdingen",
"494762", "Kutenholz",
"495253", "Bad\ Driburg",
"4937326", "Frauenstein\ Sachsen",
"499303", "Eibelstadt",
"497532", "Meersburg",
"499077", "Bachhagel",
"49721", "Karlsruhe",
"493496", "Köthen\ Anhalt",
"497844", "Rheinau",
"493301", "Oranienburg",
"497572", "Mengen\ Württemberg",
"4936607", "Niederpöllnitz",
"492365", "Marl",
"4936021", "Schlotheim",
"4934346", "Narsdorf",
"4936734", "Leutenberg",
"493332", "Schwedt\/Oder",
"494464", "Wittmund\-Carolinensiel",
"496142", "Rüsselsheim",
"496856", "St\ Wendel\-Niederkirchen",
"493372", "Jüterbog",
"4936849", "Kleinschmalkalden",
"494923", "Krummhörn\-Pewsum",
"499944", "Miltach",
"4934746", "Giersleben",
"4936334", "Wolkramshausen",
"496765", "Gemünden\ Hunsrück",
"495072", "Neustadt\-Mandelsloh",
"498662", "Siegsdorf\ Kreis\ Traunstein",
"499348", "Werbach\-Gamburg",
"495032", "Neustadt\ am\ Rübenberge",
"492750", "Diedenshausen",
"495624", "Bad\ Emstal",
"49511", "Hannover",
"492461", "Jülich",
"497153", "Plochingen",
"4933701", "Grossbeeren",
"496651", "Rasdorf",
"4933764", "Mittenwalde\ Mark",
"494454", "Jade",
"495322", "Bad\ Harzburg",
"4939833", "Mirow\ Kreis\ Neustrelitz",
"4939081", "Kakerbeck\ Sachsen\-Anhalt",
"495181", "Alfeld\ Leine",
"498364", "Seeg",
"4933364", "Gross\ Ziethen\ Kreis\ Barnim",
"496866", "Perl\-Nennig",
"495837", "Sprakensehl",
"495263", "Barntrup",
"4934924", "Zahna",
"4934423", "Heuckewalde",
"4938304", "Garz\ Rügen",
"494752", "Neuhaus\ Oste",
"499606", "Pfreimd",
"492355", "Schalksmühle",
"498558", "Hohenau\ Niederbayern",
"498141", "Fürstenfeldbruck",
"493685", "Hildburghausen",
"4936083", "Uder",
"497062", "Beilstein\ Württemberg",
"4938729", "Marnitz",
"498453", "Reichertshofen\ Oberbayern",
"4934385", "Mutzschen",
"495952", "Sögel",
"4934785", "Sandersleben",
"498038", "Vogtareuth",
"494363", "Lensahn",
"499567", "Sesslach\-Gemünda",
"4934909", "Aken\ Elbe",
"4933336", "Passow\ Kreis\ Uckermark",
"493773", "Johanngeorgenstadt",
"492759", "Bad\ Berleburg\-Aue",
"499382", "Gerolzhofen",
"499404", "Nittendorf",
"494222", "Ganderkesee",
"4935058", "Pretzschendorf",
"492925", "Warstein\-Allagen",
"499771", "Bad\ Neustadt\ an\ der\ Saale",
"493733", "Annaberg\-Buchholz",
"495426", "Glandorf",
"498328", "Balderschwang",
"497441", "Freudenstadt",
"4935935", "Kleinwelka",
"492525", "Beckum\-Neubeckum",
"4938794", "Cumlosen",
"4939058", "Uthmöden",
"4934324", "Ostrau\ Sachsen",
"4933964", "Fretzdorf",
"4938322", "Richtenberg",
"497273", "Hagenbach\ Pfalz",
"495552", "Katlenburg",
"496043", "Nidda",
"494447", "Vechta\-Langförden",
"4937344", "Crottendorf\ Sachsen",
"497233", "Niefern\-Öschelbronn",
"4938722", "Raduhn",
"498766", "Gammelsdorf",
"494861", "Tönning",
"4933054", "Liebenwalde",
"495723", "Bad\ Nenndorf",
"495173", "Uetze",
"4936766", "Schalkau",
"495658", "Wehretal",
"492864", "Reken",
"495962", "Herzlake",
"499675", "Altendorf\ am\ Nabburg",
"497052", "Bad\ Liebenzell",
"499499", "Painten",
"497345", "Langenau\ Württemberg",
"498463", "Greding",
"494666", "Ladelund",
"496008", "Echzell",
"4939406", "Harbke",
"494353", "Ascheffel",
"499635", "Bärnau",
"499246", "Pegnitz\-Trockau",
"498347", "Friesenried",
"496188", "Kahl\ am\ Main",
"4935023", "Bad\ Gottleuba",
"494851", "Marne",
"498756", "Nandlstadt",
"4937200", "Wittgensdorf\ bei\ Chemnitz",
"495562", "Dassel\-Markoldendorf",
"495707", "Petershagen\ Weser",
"499097", "Marxheim",
"493476", "Hettstedt\ Sachsen\-Anhalt",
"496359", "Grünstadt",
"493947", "Thale",
"494209", "Schwanewede",
"494843", "Viöl",
"499824", "Dietenhofen",
"496061", "Michelstadt",
"496227", "Walldorf\ Baden",
"4935265", "Glaubitz",
"495493", "Neuenkirchen\ Kreis\ Vechta",
"496583", "Palzem",
"493622", "Waltershausen\ Thüringen",
"495705", "Petershagen\-Windheim",
"499179", "Freystadt",
"499729", "Grettstadt",
"4933234", "Wustermark",
"499955", "Mamming",
"492151", "Krefeld",
"499190", "Heroldsbach",
"498052", "Aschau\ im\ Chiemgau",
"492548", "Dülmen\-Rorup",
"495978", "Hörstel\-Dreierwalde",
"498345", "Stöttwang",
"497463", "Mühlheim\ an\ der\ Donau",
"496203", "Ladenburg",
"4938720", "Grebbin",
"496849", "Kirkel",
"492948", "Lippstadt\-Rebbeke",
"492291", "Waldbröl",
"499555", "Schlüsselfeld\-Aschbach",
"495300", "Salzgitter\-Üfingen",
"499637", "Falkenberg\ Oberpfalz",
"494164", "Harsefeld",
"4933603", "Falkenhagen\ bei\ Seelow",
"496442", "Braunfels",
"499677", "Oberviechtach\-Pullenried",
"497347", "Dietenheim",
"4938320", "Tribsees",
"497524", "Bad\ Waldsee",
"496744", "Oberwesel",
"498592", "Wegscheid\ Niederbayern",
"4939265", "Löderburg",
"498857", "Benediktbeuern",
"4938231", "Barth",
"495806", "Barum\ bei\ Bad\ Bevensen",
"4938296", "Rerik\ Ostseebad",
"492903", "Meschede\-Freienohl",
"495024", "Rohrsen\ Kreis\ Nienburg\ Weser",
"494445", "Visbek\ Kreis\ Vechta",
"494976", "Spiekeroog",
"499186", "Lauterhofen\ Oberpfalz",
"493928", "Schönebeck\ Elbe",
"495632", "Willingen\ Upland",
"49541", "Osnabrück",
"499965", "Sankt\ Englmar",
"498062", "Bruckmühl\ Mangfall",
"495672", "Bad\ Karlshafen",
"492161", "Mönchengladbach",
"497453", "Altensteig\ Württemberg",
"494294", "Riede\ Kreis\ Verden",
"4939293", "Dreileben",
"494936", "Grossheide",
"4937209", "Einsiedel\ bei\ Chemnitz",
"496051", "Gelnhausen",
"4935797", "Schwepnitz",
"492527", "Lippetal\-Lippborg",
"495601", "Schauenburg",
"4939397", "Geestgottberg",
"49375", "Zwickau",
"495374", "Isenbüttel",
"492927", "Neuengeseke",
"495334", "Hornburg\ Kreis\ Wolfenbüttel",
"497328", "Königsbronn",
"498441", "Pfaffenhofen\ an\ der\ Ilm",
"498867", "Rottenbuch\ Oberbayern",
"494536", "Steinhorst\ Lauenburg",
"4936201", "Walschleben",
"494154", "Trittau",
"4937202", "Claussnitz\ bei\ Chemnitz",
"498233", "Kissing",
"492642", "Remagen",
"499260", "Wilhelmsthal\ Oberfranken",
"499565", "Untersiemau",
"495481", "Lengerich\ Westfalen",
"493528", "Radeberg",
"496591", "Gerolstein",
"498273", "Nordendorf",
"496164", "Reichelsheim\ Odenwald",
"494442", "Lohne\ Oldenburg",
"498506", "Bad\ Höhenstadt",
"495635", "Vöhl",
"494203", "Weyhe\ bei\ Bremen",
"494849", "Hooge",
"492236", "Wesseling\ Rheinland",
"499658", "Georgenberg",
"495675", "Trendelburg",
"498065", "Tuntenhausen\-Schönau",
"499962", "Schwarzach\ Niederbayern",
"496589", "Kell\ am\ See",
"4936605", "Bad\ Köstritz",
"4938372", "Usedom",
"492994", "Marsberg\-Westheim",
"496341", "Landau\ in\ der\ Pfalz",
"499173", "Thalmässing",
"499723", "Röthlein",
"494744", "Loxstedt",
"4933608", "Jacobsdorf\ Mark",
"492054", "Essen\-Kettwig",
"4934774", "Röblingen\ am\ See",
"499133", "Baiersdorf\ Mittelfranken",
"493721", "Meinersdorf",
"496209", "Mörlenbach",
"496843", "Gersheim",
"499562", "Sonnefeld",
"492594", "Dülmen",
"4938379", "Benz\ Usedom",
"492645", "Vettelschoss",
"495246", "Verl",
"492440", "Nettersheim\-Tondorf",
"497221", "Baden\-Baden",
"495957", "Lindern\ Oldenburg",
"4934221", "Schildau\ Gneisenaustadt",
"495404", "Westerkappeln",
"495771", "Rahden\ Westfalen",
"495121", "Hildesheim",
"4937360", "Olbernhau",
"497146", "Remseck\ am\ Neckar",
"4935604", "Krieschow",
"495731", "Bad\ Oeynhausen",
"497852", "Willstätt",
"492064", "Dinslaken",
"499092", "Wemding",
"495382", "Bad\ Gandersheim",
"497459", "Nagold\-Hochdorf",
"496154", "Ober\-Ramstadt",
"496536", "Kleinich",
"495702", "Petershagen\-Lahde",
"498342", "Marktoberdorf",
"498055", "Halfing",
"499952", "Eichendorf",
"499552", "Burghaslach",
"4936920", "Grossenlupnitz",
"49212", "Solingen",
"4938750", "Malliss",
"495684", "Frielendorf",
"496445", "Schöffengrund",
"494248", "Bassum\-Neubruchhausen",
"496294", "Krautheim\ Jagst",
"4939604", "Wildberg\ bei\ Altentreptow",
"498239", "Langenneufnach",
"4936206", "Grossfahner",
"492741", "Betzdorf",
"499426", "Oberschneiding",
"492509", "Nottuln\-Appelhülsen",
"4939298", "Barby\ Elbe",
"4933731", "Trebbin",
"497150", "Korntal\-Münchingen",
"493874", "Ludwigslust",
"498459", "Manching",
"493542", "Lübbenau\ Spreewald",
"4933331", "Casekow",
"492628", "Rhens",
"4933396", "Klosterfelde",
"493834", "Greifswald",
"493603", "Bad\ Langensalza",
"498146", "Moorenweis",
"499672", "Neunburg\ vorm\ Wald",
"495965", "Klein\ Berssen",
"492753", "Erndtebrück",
"4937383", "Lunzenau",
"4938370", "Kröslin",
"4939053", "Süplingen",
"4938842", "Lüttenmark",
"497055", "Neuweiler\ Kreis\ Calw",
"4939995", "Nossendorf",
"496861", "Merzig",
"4936465", "Oberndorf\ bei\ Apolda",
"499632", "Waldsassen",
"495186", "Salzhemmendorf\-Wallensen",
"49941", "Regensburg",
"496447", "Langgöns\-Niederkleen",
"499481", "Pfatter",
"498057", "Aschau\-Sachrang",
"493395", "Pritzwalk",
"496656", "Ebersburg",
"4935053", "Glashütte\ Sachsen",
"496363", "Niederkirchen",
"4938334", "Grammendorf",
"4933085", "Seilershof",
"495565", "Einbeck\-Wenzen",
"499334", "Giebelstadt",
"497644", "Kenzingen",
"499374", "Eschau",
"496049", "Kefenrod",
"496222", "Wiesloch",
"495139", "Burgwedel",
"4938759", "Tewswoos",
"494188", "Welle\ Nordheide",
"4936929", "Ruhla",
"495190", "Soltau\-Emmingen",
"495955", "Esterwegen",
"492763", "Drolshagen\-Bleche",
"499978", "Schönthal\ Oberpfalz",
"499938", "Moos\ Niederbayern",
"492647", "Kesseling",
"496851", "St\ Wendel",
"497506", "Wangen\-Leupolz",
"4933435", "Rehfelde",
"499493", "Beratzhausen",
"498469", "Freystadt\-Burggriesbach",
"499385", "Kolitzheim",
"498862", "Steingaden\ Oberbayern",
"4936761", "Heubisch",
"4937362", "Seiffen\ Erzgebirge",
"4935028", "Krippen",
"496428", "Stadtallendorf",
"4939401", "Neuwegersleben",
"497838", "Nordrach",
"495824", "Bad\ Bodenteich",
"493491", "Lutherstadt\ Wittenberg",
"493306", "Gransee",
"492922", "Werl",
"492522", "Oelde",
"494920", "Wirdum",
"4937369", "Wolkenstein",
"4936704", "Steinheid",
"4938352", "Kemnitz\ bei\ Greifswald",
"495677", "Calden\-Westuffeln",
"498067", "Tuntenhausen",
"497906", "Braunsbach",
"498221", "Günzburg",
"496353", "Freinsheim",
"492456", "Selfkant",
"495555", "Moringen\-Fredelsloh",
"495250", "Delbrück\ Westfalen",
"4938752", "Zierzow\ bei\ Ludwigslust",
"496666", "Freiensteinau",
"4936922", "Gerstungen",
"494529", "Süsel\-Bujendorf",
"497584", "Altshausen",
"499473", "Kallmünz",
"4933742", "Oehna\ Brandenburg",
"493431", "Döbeln",
"4935363", "Fermerswalde",
"498665", "Inzell",
"496507", "Neumagen\-Dhron",
"4936961", "Bad\ Liebenstein",
"496762", "Kastellaun",
"498460", "Berching\-Holnstein",
"495035", "Gross\ Munzel",
"499433", "Nabburg",
"4933870", "Zollchow\ bei\ Rathenow",
"493471", "Bernburg\ Saale",
"4939267", "Schneidlingen",
"496464", "Angelburg",
"494142", "Steinkirchen\ Kreis\ Stade",
"499241", "Pegnitz",
"492654", "Polch",
"495130", "Wedemark",
"495199", "Schneverdingen\-Heber",
"498751", "Mainburg",
"494856", "Kronprinzenkoog",
"495325", "Goslar\-Hahnenklee",
"495259", "Bad\ Driburg\-Neuenheerse",
"496523", "Holsthum",
"4937321", "Frankenstein\ Sachsen",
"496287", "Limbach\ Baden",
"494661", "Niebüll",
"497204", "Malsch\-Völkersbach",
"4935267", "Diesbar\-Seusslitz",
"4934954", "Roitzsch\ bei\ Bitterfeld",
"4934341", "Geithain",
"4933834", "Pritzerbe",
"497667", "Breisach\ am\ Rhein",
"494755", "Ihlienworth",
"4936026", "Struth\ bei\ Mühlhausen",
"492045", "Bottrop\-Kirchhellen",
"4934741", "Frose",
"492352", "Altena\ Westfalen",
"4935436", "Laasow\ bei\ Calau",
"4939363", "Angern",
"493682", "Zella\-Mehlis",
"494929", "Ihlow\ Kreis\ Aurich",
"497743", "Ühlingen\-Birkendorf",
"499875", "Wolframs\-Eschenbach",
"492664", "Rennerod",
"495858", "Hitzacker\-Wietzetze",
"497388", "Pfronstetten",
"496454", "Lichtenfels\-Sachsenberg",
"4939395", "Wanzer",
"498761", "Moosburg\ an\ der\ Isar",
"4939389", "Schollene",
"499835", "Ehingen\ Mittelfranken",
"496752", "Kirn\ Nahe",
"495421", "Dissen\ am\ Teutoburger\ Wald",
"498537", "Bad\ Füssing\-Aigen",
"497975", "Untergröningen",
"493588", "Niesky",
"497446", "Lossburg",
"4933931", "Rheinsberg\ Mark",
"492207", "Kürten\-Dürscheid",
"497935", "Schrozberg",
"498450", "Ingolstadt\-Zuchering",
"497708", "Geisingen\-Leipferdingen",
"4935893", "Mücka",
"497159", "Renningen",
"4939086", "Jävenitz",
"497657", "Eisenbach\ Hochschwarzwald",
"494765", "Ebersdorf\ bei\ Bremervörde",
"499736", "Oberthulba",
"497575", "Messkirch",
"499776", "Mellrichstadt",
"499126", "Eckental",
"4937756", "Breitenbrunn\ Erzgebirge",
"495084", "Hambühren",
"499394", "Esselbach",
"492362", "Dorsten",
"4934445", "Stössen",
"4935389", "Holzdorf\ Elster",
"496145", "Flörsheim\ am\ Main",
"4935795", "Königsbrück",
"492587", "Ennigerloh\-Westkirchen",
"4939382", "Kamern",
"493335", "Finowfurt",
"493375", "Königs\ Wusterhausen",
"492223", "Königswinter",
"493377", "Zossen\ Brandenburg",
"497761", "Bad\ Säckingen",
"4935937", "Prischwitz",
"494531", "Bad\ Oldesloe",
"4936071", "Teistungen",
"496596", "Üdersdorf",
"498388", "Hergensweiler",
"493337", "Biesenthal\ Brandenburg",
"492585", "Warendorf\-Hoetmar",
"496147", "Trebur",
"49911", "Nuremberg",
"494643", "Gelting\ Angeln",
"497577", "Veringenstadt",
"4935694", "Gosda\ bei\ Klinge",
"4933872", "Hohennauen",
"498708", "Weihmichl\-Unterneuhausen",
"499624", "Ensdorf\ Oberpfalz",
"494767", "Bremervörde\-Bevern",
"497655", "Feldberg\-Altglashütten",
"4935208", "Radeburg",
"494502", "Lübeck\-Travemünde",
"499072", "Lauingen\ Donau",
"498446", "Pörnbach",
"497937", "Dörzbach",
"492205", "Rösrath",
"492378", "Fröndenberg\-Langschede",
"494902", "Jemgum\-Ditzum",
"496056", "Bad\ Soden\-Salmünster",
"4939208", "Loitsche",
"499263", "Ludwigsstadt",
"498657", "Ramsau\ bei\ Berchtesgaden",
"498230", "Gablingen",
"497977", "Oberrot\ bei\ Gaildorf",
"498535", "Haarbach",
"495606", "Zierenberg",
"492338", "Breckerfeld",
"499181", "Neumarkt\ in\ der\ Oberpfalz",
"492985", "Winterberg\-Niedersfeld",
"496234", "Mutterstadt",
"494282", "Sittensen",
"497044", "Mönsheim",
"499837", "Haundorf",
"494971", "Esens",
"496274", "Waldbrunn\ Odenwald",
"494931", "Norden",
"492166", "Mönchengladbach\-Rheydt",
"494346", "Gettorf",
"499193", "Höchstadt\ an\ der\ Aisch",
"4934262", "Falkenhain\ bei\ Wurzen",
"4933204", "Beelitz\ Mark",
"498584", "Breitenberg\ Niederbayern",
"496128", "Taunusstein",
"497665", "March\ Breisgau",
"494757", "Wanna",
"496580", "Zemmer",
"4936695", "Söllmnitz",
"495439", "Bersenbrück",
"496285", "Walldürn\-Altheim",
"494488", "Westerstede",
"492934", "Sundern\-Altenhellefeld",
"492296", "Reichshof\-Brüchermühle",
"495832", "Hankensbüttel",
"497751", "Waldshut",
"492974", "Schmallenberg\-Fredeburg",
"495695", "Twistetal",
"495544", "Reinhardshagen",
"495872", "Stoetze",
"495327", "Bad\ Grund\ Harz",
"492449", "Blankenheim\ Ahr",
"4938201", "Gelbensande",
"495944", "Hoogstede",
"492574", "Saerbeck",
"498204", "Mickhausen",
"492842", "Kamp\-Lintfort",
"492156", "Willich\-Anrath",
"492534", "Münster\-Roxel",
"496066", "Michelstadt\-Vielbrunn",
"494608", "Handewitt",
"495037", "Bad\ Rehburg",
"498743", "Geisenhausen",
"4933633", "Spreenhagen",
"495303", "Wendeburg",
"499253", "Weissenstadt",
"496505", "Kordel",
"498667", "Seeon\-Seebruck",
"4936203", "Vieselbach",
"497723", "Furtwangen\ im\ Schwarzwald",
"497173", "Heubach",
"4939772", "Rothemühl",
"492588", "Harsewinkel\-Greffen",
"4937430", "Eichigt",
"497133", "Lauffen\ am\ Neckar",
"498385", "Hergatz",
"499469", "Roding\-Neubäu",
"496631", "Alsfeld",
"498705", "Altfraunhofen",
"492770", "Eschenburg",
"493987", "Templin",
"494883", "Süderstapel",
"495345", "Baddeckenstedt",
"496543", "Büchenbeuren",
"495052", "Hermannsburg",
"497962", "Fichtenau",
"49431", "Kiel",
"497707", "Bräunlingen",
"494381", "Lütjenburg",
"497562", "Isny\ im\ Allgäu",
"494732", "Stadland\-Rodenkirchen",
"496784", "Weierbach",
"492375", "Balve",
"492208", "Niederkassel",
"494772", "Oberndorf\ Oste",
"492335", "Wetter\ Ruhr",
"494122", "Uetersen",
"498538", "Pocking\-Hartkirchen",
"499221", "Kulmbach",
"493362", "Erkner",
"496482", "Runkel",
"494434", "Colnrade",
"495592", "Gleichen\-Bremke",
"497387", "Hohenstein\ Württemberg",
"4939291", "Calbe\ Saale",
"4935772", "Rietschen",
"4939779", "Eggesin",
"498806", "Utting\ am\ Ammersee",
"496304", "Wolfstein\ Pfalz",
"495857", "Bleckede\-Brackede",
"494474", "Garrel",
"49841", "Ingolstadt\ Donau",
"496735", "Eppelsheim",
"492402", "Stolberg\ Rheinland",
"492243", "Eitorf",
"498024", "Holzkirchen",
"4938233", "Prerow\ Ostseebad",
"497952", "Gerabronn",
"497668", "Ihringen",
"496775", "Strüth\ Taunus",
"492384", "Welver",
"495062", "Holle\ bei\ Hildesheim",
"494393", "Boostedt",
"499146", "Markt\ Berolzheim",
"492471", "Roetgen\ Eifel",
"4933601", "Podelzig",
"494485", "Elsfleth\-Huntorf",
"4934609", "Salzmünde",
"492431", "Erkelenz",
"499852", "Feuchtwangen",
"496020", "Heigenbrücken",
"492682", "Hamm\ Sieg",
"498374", "Dietmannsried",
"496876", "Weiskirchen\ Saar",
"4936652", "Wurzbach",
"496836", "Überherrn",
"4938737", "Ganzlin",
"4934602", "Landsberg\ Sachsen\-Anhalt",
"495441", "Diepholz",
"497426", "Gosheim",
"498334", "Bad\ Grönenbach",
"495233", "Steinheim\ Westfalen",
"494605", "Medelby",
"497552", "Pfullendorf",
"495273", "Beverungen",
"496508", "Hetzerath\ Mosel",
"4935607", "Jänschwalde",
"4933365", "Lüdersdorf\ Kreis\ Barnim",
"499342", "Wertheim",
"495453", "Recke",
"497672", "St\ Blasien",
"49741", "Rottweil",
"496629", "Schenklengsfeld",
"497632", "Badenweiler",
"494607", "Janneby",
"497024", "Wendlingen\ am\ Neckar",
"4933765", "Märkisch\ Buchholz",
"495865", "Gusborn",
"496103", "Langen\ Hessen",
"498092", "Grafing\ bei\ München",
"492191", "Remscheid",
"4937432", "Pausa\ Vogtland",
"494264", "Sottrum\ Kreis\ Rotenburg",
"4935021", "Königstein\ Sächsische\ Schweiz",
"4938305", "Gingst",
"4934925", "Bad\ Schmiedeberg",
"4939408", "Hadmersleben",
"499279", "Mistelgau",
"497334", "Deggingen",
"498426", "Walting\ Kreis\ Eichstätt",
"495328", "Altenau\ Harz",
"496561", "Bitburg",
"4937439", "Jocketa",
"494623", "Böklund",
"497374", "Uttenweiler",
"4935842", "Oderwitz",
"492251", "Euskirchen",
"494487", "Grossenkneten\-Huntlosen",
"496083", "Weilrod",
"499644", "Pressath",
"494758", "Nordleda",
"494109", "Tangstedt\ Bz\ Hamburg",
"496127", "Niedernhausen\ Taunus",
"493574", "Lauchhammer",
"495766", "Rehburg\-Loccum",
"496737", "Köngernheim",
"4939607", "Kotelow",
"498552", "Grafenau\ Niederbayern",
"498133", "Haimhausen\ Oberbayern",
"4935752", "Ruhland",
"494254", "Eystrup",
"497385", "Gomadingen",
"495855", "Nahrendorf",
"4933338", "Stolpe\/Oder",
"498723", "Arnstorf",
"493585", "Löbau",
"4936335", "Grosswechsungen",
"492337", "Hagen\-Dahl",
"492429", "Hürtgenwald",
"4935056", "Altenberg\ Sachsen",
"497705", "Wolterdingen\ Schwarzw",
"495924", "Bad\ Bentheim\-Gildehaus",
"497938", "Mulfingen\ Jagst",
"4936735", "Probstzella",
"492822", "Emmerich",
"492377", "Wickede\ Ruhr",
"492183", "Rommerskirchen",
"4938464", "Bernitt",
"495347", "Burgdorf\ bei\ Salzgitter",
"495524", "Bad\ Lauterberg\ im\ Harz",
"494768", "Hipstedt",
"499906", "Mariaposching",
"4939056", "Klüden",
"498707", "Adlkofen",
"498562", "Triftern",
"497300", "Roggenburg",
"497578", "Wald\ Hohenz",
"498387", "Weiler\-Simmerberg",
"493338", "Bernau\ Brandenburg",
"497806", "Bad\ Peterstal\-Griesbach",
"496551", "Prüm",
"4934600", "Ostrau\ Saalkreis",
"499286", "Oberkotzau",
"4936081", "Arenshausen",
"492261", "Gummersbach",
"4933393", "Gross\ Schönebeck\ Kreis\ Barnim",
"494326", "Wankendorf",
"494194", "Sievershütten",
"4934462", "Laucha\ Unstrut",
"4939752", "Blumenhagen\ bei\ Strasburg",
"493378", "Ludwigsfelde",
"496031", "Friedberg\ Hessen",
"4934977", "Quellendorf",
"495226", "Bruchmühlen\ Westfalen",
"496071", "Dieburg",
"492625", "Ochtendung",
"4933207", "Gross\ Kreutz",
"4935952", "Grossröhrsdorf\ OL",
"4939831", "Feldberg",
"4939083", "Messdorf",
"4939959", "Dargun",
"495652", "Bad\ Sooden\-Allendorf",
"497473", "Mössingen",
"494247", "Affinghausen",
"493909", "Klötze\ Altmark",
"497433", "Balingen",
"498193", "Geltendorf",
"494956", "Uplengen",
"496002", "Ober\-Mörlen",
"494556", "Ahrensbök\-Gnissau",
"498253", "Pöttmes",
"494134", "Embsen\ Kreis\ Lüneburg",
"496182", "Seligenstadt",
"493741", "Plauen",
"496321", "Neustadt\ an\ der\ Weinstrasse",
"4933055", "Kremmen",
"4933703", "Sperenberg",
"4939952", "Grammentin",
"494174", "Stelle\ Kreis\ Harburg",
"494724", "Cuxhaven\-Lüdingworth",
"497309", "Weissenhorn",
"499204", "Plankenfels",
"494422", "Sande\ Kreis\ Friesl",
"495354", "Jerxheim",
"494829", "Wewelsfleth",
"499446", "Altmannstein",
"498072", "Haag\ in\ Oberbayern",
"495662", "Felsberg\ Hessen",
"492721", "Lennestadt",
"492171", "Leverkusen\-Opladen",
"4936968", "Rossdorf\ Rhön",
"4934325", "Mochau\-Lüttewitz",
"499975", "Waldmünchen\-Geigant",
"4936023", "Horsmar",
"494185", "Marxen\ Auetal",
"4938789", "Wolfshagen\ bei\ Perleberg",
"498624", "Obing",
"499708", "Bad\ Bocklet",
"494966", "Neubörger",
"492131", "Neuss",
"498032", "Rohrdorf\ Kreis\ Rosenheim",
"499935", "Stephansposching",
"4935934", "Grossdubrau",
"4939366", "Kehnert",
"4935433", "Vetschau",
"49811", "Hallbergmoos",
"496620", "Philippsthal\ Werra",
"492102", "Ratingen",
"493994", "Malchin",
"49214", "Leverkusen",
"4939062", "Bebertal",
"4935697", "Bagenz",
"497835", "Zell\ am\ Harmersbach",
"4933965", "Herzsprung\ bei\ Wittstock",
"496425", "Rauschenberg\ Hessen",
"498322", "Oberstdorf",
"4937328", "Grossschirma",
"493594", "Bischofswerda",
"4934384", "Grossbothen",
"495364", "Velpke",
"4934348", "Frohburg",
"4939934", "Gross\ Plasten",
"499535", "Pfarrweisach",
"497736", "Tengen",
"499657", "Waldthurn",
"498263", "Breitenbrunn\ Schwaben",
"497394", "Schelklingen",
"4938782", "Reetz\ bei\ Perleberg",
"495141", "Celle",
"499575", "Weismain",
"497126", "Burladingen\-Melchingen",
"499270", "Creussen",
"497624", "Grenzach\-Wyhlen",
"492306", "Lünen",
"496403", "Linden\ Hessen",
"496029", "Mömbris",
"497032", "Herrenberg",
"496242", "Osthofen",
"497072", "Gomaringen",
"4933636", "Steinhöfel\ Kreis\ Oder\-Spree",
"499655", "Tännesberg",
"494333", "Erfde",
"493647", "Pössneck",
"499761", "Bad\ Königshofen\ im\ Grabfeld",
"495153", "Salzhemmendorf",
"49711", "Stuttgart",
"493763", "Glauchau",
"497837", "Oberharmersbach",
"496683", "Ehrenberg\ Rhön",
"494409", "Westerstede\-Ocholt",
"494802", "Wrohm",
"496427", "Cölbe\-Schönstadt",
"4938208", "Kavelstorf",
"497181", "Schorndorf\ Württemberg",
"495293", "Paderborn\-Dahl",
"496339", "Grosssteinhausen",
"497322", "Giengen\ an\ der\ Brenz",
"4934692", "Alsleben\ Saale",
"498394", "Lautrach",
"494871", "Hohenwestedt",
"499937", "Oberpöring",
"499977", "Arnschwang",
"494187", "Holm\-Seppensen",
"493522", "Grossenhain\ Sachsen",
"497263", "Waibstadt",
"496805", "Kleinblittersdorf",
"495163", "Fallingbostel\-Dorfmark",
"492739", "Wilnsdorf",
"492779", "Greifenstein\-Beilstein",
"495901", "Fürstenau\ bei\ Bramsche",
"492129", "Haan\ Rheinland",
"498241", "Buchloe",
"496691", "Schwalmstadt",
"492603", "Bad\ Ems",
"498433", "Königsmoos",
"492834", "Straelen",
"497193", "Sulzbach\ an\ der\ Murr",
"4939972", "Walkendorf",
"493628", "Arnstadt",
"495932", "Haren\ Ems",
"495281", "Bad\ Pyrmont",
"4939264", "Kroppenstedt",
"492542", "Gescher",
"492874", "Isselburg",
"499665", "Königstein\ Oberpfalz",
"4935201", "Langebrück",
"494636", "Langballig",
"4939201", "Wolmirstedt",
"494245", "Neuenkirchen\ bei\ Bassum",
"495572", "Bodenfelde",
"495844", "Clenze",
"4938780", "Lanz\ Brandenburg",
"492942", "Geseke",
"4935264", "Strehla",
"49521", "Bielefeld",
"495532", "Stadtoldendorf",
"496706", "Wallhausen\ Nahe",
"497253", "Bad\ Schönborn",
"494494", "Bösel\ Oldenburg",
"496386", "Altenkirchen\ Pfalz",
"493466", "Artern\ Unstrut",
"492627", "Braubach",
"4933235", "Friesack",
"492395", "Finnentrop\-Rönkhausen",
"494792", "Worpswede",
"49228", "Bonn",
"4933837", "Brielow",
"492905", "Bestwig\-Ramsbeck",
"497237", "Neulingen\ Enzkreis",
"499101", "Langenzenn",
"496047", "Altenstadt\ Hessen",
"494443", "Dinklage",
"499424", "Strasskirchen",
"494202", "Achim\ bei\ Bremen",
"4933232", "Brieselang",
"492738", "Netphen",
"493961", "Altentreptow",
"499963", "Konzell",
"497455", "Dornhan",
"492778", "Siegbach",
"497277", "Wörth\-Büchelberg",
"499172", "Georgensgmünd",
"499722", "Werneck",
"493629", "Stadtilm",
"494271", "Sulingen",
"496296", "Ahorn\ Baden",
"4935975", "Hohnstein",
"494231", "Verden\ Aller",
"499132", "Herzogenaurach",
"495686", "Schwarzenborn\ Knüll",
"496449", "Ehringshausen\-Katzenfurt",
"493737", "Rochlitz",
"496842", "Blieskastel",
"496574", "Hasborn",
"4939975", "Thürkow",
"496534", "Mülheim\ Mosel",
"497361", "Aalen",
"492066", "Duisburg\-Homberg",
"494367", "Grossenbrode",
"499563", "Rödental",
"493561", "Guben",
"498457", "Vohburg\ an\ der\ Donau",
"4938226", "Dierhagen\ Ostseebad",
"4933239", "Gross\ Behnitz",
"4936871", "Bad\ Colberg\-Heldburg",
"497144", "Marbach\ am\ Neckar",
"495406", "Belm",
"499081", "Nördlingen",
"4934296", "Groitzsch\ bei\ Pegau",
"492505", "Altenberge\ Westfalen",
"494845", "Ostenfeld\ Husum",
"495244", "Rietberg",
"496028", "Sulzbach\ am\ Main",
"49581", "Uelzen",
"492596", "Nordkirchen",
"497853", "Kehl\-Bodersweier",
"4939223", "Theessen",
"495495", "Vörden\ Kreis\ Vechta",
"495383", "Lutter\ am\ Barenberge",
"499093", "Polsingen",
"496585", "Ralingen",
"497660", "St\ Peter\ Schwarzwald",
"4935727", "Burghammer",
"495703", "Hille",
"498284", "Ziemetshausen",
"4935327", "Priessen",
"499953", "Pilsting",
"498343", "Aitrang",
"497465", "Emmingen\-Liptingen",
"494408", "Hude\ Oldenburg",
"496205", "Hockenheim",
"496500", "Waldrach",
"499553", "Ebrach\ Oberfranken",
"492056", "Heiligenhaus",
"494357", "Sehestedt\ Eider",
"4939327", "Klietz",
"494746", "Hagen\ bei\ Bremerhaven",
"498841", "Murnau\ am\ Staffelsee",
"4939727", "Spantekow",
"498467", "Kinding",
"4937204", "Lichtenstein\ Sachsen",
"496338", "Hornbach\ Pfalz",
"495177", "Edemissen\-Abbensen",
"492234", "Frechen",
"492274", "Elsdorf\ Rheinland",
"498504", "Tittling",
"496166", "Fischbachtal",
"495137", "Seelze",
"497351", "Biberach\ an\ der\ Riss",
"496664", "Sinntal\-Sterbfritz",
"495135", "Burgwedel\-Fuhrberg",
"492454", "Gangelt",
"4939488", "Güntersberge",
"495175", "Lehrte\-Arpke",
"495725", "Lindhorst\ bei\ Stadthagen",
"4938785", "Berge\ bei\ Perleberg",
"499158", "Offenhausen\ Mittelfranken",
"497904", "Ilshofen",
"493631", "Nordhausen\ Thüringen",
"492752", "Bad\ Laasphe",
"499673", "Tiefenbach\ Oberpfalz",
"4933969", "Stepenitz",
"498465", "Kipfenberg",
"497343", "Buch\ bei\ Illertissen",
"4937349", "Scheibenberg",
"499804", "Aurach",
"496207", "Wald\-Michelbach",
"4933230", "Börnicke\ Kreis\ Havelland",
"493671", "Saalfeld\ Saale",
"494355", "Rieseby",
"499633", "Mitterteich",
"495826", "Suderburg",
"493304", "Velten",
"497841", "Achern",
"4936453", "Mellingen",
"4938724", "Siggelkow",
"497467", "Neuhausen\ ob\ Eck",
"4937342", "Cranzahl",
"4936741", "Bad\ Blankenburg",
"4933846", "Dippmannsdorf",
"4934904", "Oranienbaum",
"4933962", "Heiligengrabe",
"496362", "Alsenz",
"4938324", "Velgast",
"497504", "Horgenzell",
"4934322", "Rosswein",
"4938392", "Sassnitz",
"499941", "Kötzting",
"496587", "Zerf",
"4938792", "Lenzen\ \(Elbe\)",
"494847", "Oster\-Ohrstedt",
"493943", "Wernigerode",
"496223", "Neckargemünd",
"4934722", "Preusslitz",
"494461", "Jever",
"495320", "Torfhaus",
"499376", "Collenberg",
"4938481", "Witzin",
"492507", "Havixbeck",
"497930", "Boxberg\ Baden",
"497646", "Weisweil\ Breisgau",
"492762", "Wenden\ Südsauerland",
"495621", "Bad\ Wildungen",
"498237", "Aindling",
"494365", "Heringsdorf\ Holstein",
"499336", "Bütthard",
"498650", "Marktschellenberg",
"4939886", "Milmersdorf",
"499492", "Parsberg",
"492464", "Aldenhoven\ bei\ Jülich",
"4936428", "Stadtroda",
"496654", "Gersfeld\ Rhön",
"4933052", "Leegebruch",
"492923", "Lippetal\-Herzfeld",
"4939955", "Jürgenstorf",
"493735", "Marienberg\ Sachsen",
"495184", "Freden\ Leine",
"492523", "Wadersloh",
"498361", "Nesselwang",
"4935955", "Pulsnitz",
"4933983", "Gross\ Pankow\ Kreis\ Prignitz",
"4939038", "Henningen",
"494451", "Varel\ Jadebusen",
"497457", "Rottenburg\-Ergenzingen",
"498144", "Grafrath",
"497308", "Nersingen",
"497570", "Sigmaringen\-Gutenstein",
"493836", "Wolgast",
"497275", "Kandel",
"496045", "Gedern",
"497235", "Unterreichenbach\ Kreis\ Calw",
"493876", "Perleberg",
"496352", "Kirchheimbolanden",
"494828", "Lägerdorf",
"4939426", "Hessen",
"4938458", "Zehna",
"499472", "Hohenfels\ Oberpfalz",
"498046", "Bad\ Heilbrunn",
"496763", "Kirchberg\ Hunsrück",
"4939003", "Jübar",
"492851", "Rees",
"496647", "Herbstein\-Stockhausen",
"49961", "Weiden\ in\ der\ Oberpfalz",
"4934465", "Bad\ Bibra",
"495086", "Celle\-Scheuen",
"499401", "Neutraubling",
"499396", "Urspringen\ bei\ Lohr",
"494143", "Drochtersen",
"4936739", "Rottenbach",
"4938821", "Lüdersdorf",
"499774", "Oberelsbach",
"499734", "Burkardroth",
"4936844", "Rohr\ Thüringen",
"492428", "Niederzier",
"497939", "Schrozberg\-Spielbach",
"496522", "Mettendorf",
"4936332", "Ellrich",
"4939853", "Holzendorf\ bei\ Prenzlau",
"494769", "Bremervörde\-Iselersheim",
"4937468", "Treuen\ Vogtland",
"498157", "Feldafing",
"497444", "Alpirsbach",
"497579", "Schwenningen\ Baden",
"4936732", "Könitz",
"495265", "Dörentrup",
"4935755", "Ortrand",
"499681", "Windischeschenbach",
"494864", "Oldenswort",
"49906", "Donauwörth",
"496456", "Haina\ Kloster",
"492353", "Halver",
"497742", "Klettgau",
"493683", "Schmalkalden",
"493379", "Mahlow",
"492666", "Freilingen\ Westerwald",
"4933769", "Töpchin",
"4939343", "Jerichow",
"498669", "Traunreut",
"494525", "Ahrensbök",
"4939451", "Wasserleben",
"496628", "Oberaula",
"4934361", "Dahlen\ Sachsen",
"4933369", "Oderberg",
"4939743", "Zerrenthin",
"493691", "Eisenach\ Thüringen",
"497165", "Göppingen\-Hohenstaufen",
"496753", "Meisenheim",
"4934929", "Straach",
"4933477", "Trebnitz\ bei\ Müncheberg",
"4938309", "Trent",
"4935247", "Zehren\ Sachsen",
"4933921", "Zechlinerhütte",
"4938856", "Pritzier\ bei\ Hagenow",
"4939828", "Wustrow\ Kreis\ Mecklenburg\-Strelitz",
"492861", "Borken\ Westfalen",
"495195", "Neuenkirchen\ bei\ Soltau",
"492447", "Dahlem\ bei\ Kall",
"4934637", "Frankleben",
"494854", "Friedrichskoog",
"495329", "Schulenberg\ im\ Oberharz",
"495255", "Altenbeken",
"499305", "Estenfeld",
"4937435", "Reuth\ bei\ Plauen",
"499278", "Weidenberg",
"4935828", "Reichenbach\ OL",
"492656", "Virneburg",
"499238", "Röslau",
"496466", "Dautphetal\-Friedensdorf",
"4939247", "Güterglück",
"492363", "Datteln",
"4934922", "Mühlanger",
"493386", "Premnitz",
"495437", "Menslage",
"4938302", "Sagard",
"494108", "Rosengarten\ Kreis\ Harburg",
"4933362", "Liepe\ Kreis\ Barnim",
"4938423", "Bad\ Kleinen",
"4933678", "Storkow\ Mark",
"4934493", "Gössnitz\ Thüringen",
"4936941", "Wasungen",
"4935451", "Dahme\ Brandenburg",
"494925", "Hinte",
"493448", "Meuselwitz\ Thüringen",
"498167", "Zolling",
"497586", "Herbertingen",
"4933762", "Zeuthen",
"492222", "Bornheim\ Rheinland",
"4935343", "Hirschfeld\ bei\ Elsterwerda",
"494927", "Krummhörn\-Loquard",
"4935471", "Birkenhainchen",
"4936374", "Weissensee",
"498165", "Neufahrn\ bei\ Freising",
"497669", "St\ Märgen",
"494642", "Kappeln\ Schlei",
"495435", "Berge\ bei\ Quakenbrück",
"492154", "Willich",
"492536", "Münster\-Albachten",
"494503", "Timmendorfer\ Strand",
"495475", "Bohmte\-Hunteburg",
"495946", "Georgsdorf",
"4934605", "Gröbers",
"498206", "Egling\ an\ der\ Paar",
"499073", "Gundelfingen\ an\ der\ Donau",
"499307", "Altertheim",
"495257", "Hövelhof",
"495197", "Soltau\-Frielingen",
"492445", "Schleiden\ Eifel",
"495546", "Scheden",
"494903", "Wymeer",
"4933457", "Altreetz",
"499262", "Wallenfels",
"492294", "Morsbach\ Sieg",
"4938876", "Roggendorf",
"494161", "Buxtehude",
"496398", "Vorderweidenthal",
"4936730", "Sitzendorf",
"498586", "Hauzenberg",
"4937294", "Grünhainichen",
"493321", "Nauen\ Brandenburg",
"494283", "Tarmstedt",
"496741", "St\ Goar",
"4939927", "Nossentiner\ Hütte",
"499323", "Iphofen",
"4934242", "Hohenpriessnitz",
"496509", "Büdlich",
"4936330", "Grossberndten",
"494344", "Schönberg\ Holstein",
"4937608", "Waldenburg\ Sachsen",
"494527", "Bosau",
"492164", "Jüchen\-Otzenrath",
"499192", "Gräfenberg",
"493425", "Wurzen",
"496276", "Hesseneck",
"494948", "Wiesmoor\-Marcardsmoor",
"496236", "Neuhofen\ Pfalz",
"495021", "Nienburg\ Weser",
"497046", "Zaberfeld",
"4935775", "Pechern",
"499468", "Zell\ Oberpfalz",
"495604", "Grossalmerode",
"495833", "Brome",
"4936643", "Thimmendorf",
"495873", "Eimke",
"496054", "Birstein",
"495331", "Wolfenbüttel",
"497157", "Waldenbuch",
"4935873", "Herrnhut",
"4933760", "Münchehofe\ Kreis\ Dahme\-Spreewald",
"498444", "Schweitenkirchen",
"492843", "Rheinberg",
"4934206", "Rötha",
"4936256", "Wechmar",
"4933976", "Wutike",
"499626", "Hohenburg",
"49202", "Wuppertal",
"498295", "Altenmünster\ Schwaben",
"495371", "Gifhorn",
"495484", "Lienen\-Kattenvenne",
"4938300", "Insel\ Hiddensee",
"4934920", "Kropstädt",
"4939775", "Ahlbeck\ bei\ Torgelow",
"498742", "Velden\ Vils",
"496594", "Birresborn",
"496645", "Ulrichstein",
"496888", "Lebach\-Steinbach",
"494151", "Schwarzenbek",
"496440", "Kölschhausen",
"499252", "Helmbrechts",
"495302", "Vechelde",
"498168", "Attenkirchen",
"493447", "Altenburg\ Thüringen",
"497722", "Triberg\ im\ Schwarzwald",
"497172", "Lorch\ Württemberg",
"493861", "Plate",
"496129", "Schlangenbad",
"497132", "Neckarsulm",
"494107", "Siek\ Kreis\ Stormarn",
"492691", "Adenau",
"498336", "Erkheim",
"494489", "Apen",
"497424", "Spaichingen",
"495438", "Bakum\-Lüsche",
"494882", "Lunden",
"496834", "Bous",
"496874", "Wadern\-Nunkirchen",
"496542", "Bullay",
"495053", "Fassberg\-Müden",
"499277", "Warmensteinach",
"498376", "Sulzberg\ Allgäu",
"497963", "Adelmannsfelden",
"497563", "Kisslegg",
"492448", "Hellenthal\-Rescheid",
"4936692", "Bürgel",
"494733", "Butjadingen\-Burhave",
"497081", "Bad\ Wildbad",
"4939390", "Iden",
"494773", "Lamstedt",
"494123", "Barmstedt",
"499144", "Pleinfeld",
"496483", "Selters\ Taunus",
"494609", "Eggebek",
"496627", "Nentershausen\ Hessen",
"495593", "Bovenden\-Lenglern",
"496395", "Münchweiler\ an\ der\ Rodalb",
"4939226", "Hohenziatz",
"4936624", "Teichwolframsdorf",
"498026", "Hausham",
"492403", "Eschweiler\ Rheinland",
"498633", "Tüssling",
"496306", "Trippstadt",
"494945", "Grossefehn\-Timmel",
"49591", "Lingen\ \(Ems\)",
"492242", "Hennef\ Sieg",
"499465", "Neukirchen\-Balbini",
"4938223", "Saal\ Vorpom",
"497953", "Blaufelden",
"495063", "Bad\ Salzdetfurth",
"4934293", "Naunhof\ bei\ Grimma",
"498389", "Weissensberg",
"494392", "Nortorf\ bei\ Neumünster",
"498541", "Vilshofen\ Niederbayern",
"498158", "Tutzing",
"498709", "Eching\ Niederbayern",
"496786", "Kempfeld",
"499853", "Wilburgstetten",
"492379", "Menden\-Asbeck",
"4933875", "Rhinow",
"492683", "Asbach\ Westerwald",
"4934907", "Jeber\-Bergfrieden",
"4938327", "Elmenhorst\ Vorpom",
"492427", "Nideggen",
"499351", "Gemünden\ am\ Main",
"495201", "Halle\ Westfalen",
"4938727", "Mestlin",
"492339", "Sprockhövel\-Hasslinghausen",
"496648", "Bad\ Salzschlirf",
"497553", "Salem\ Baden",
"495232", "Lage\ Lippe",
"49551", "Göttingen",
"495272", "Brakel\ Westfalen",
"494240", "Syke\-Heiligenfelde",
"4936878", "Oberland",
"494545", "Seedorf\ Lauenburg",
"495859", "Thomasburg",
"499343", "Lauda\-Königshofen",
"496171", "Oberursel\ Taunus",
"496721", "Bingen\ am\ Rhein",
"497673", "Schönau\ im\ Schwarzwald",
"495452", "Mettingen\ Westfalen",
"494547", "Gudow\ Lauenburg",
"4938488", "Demen",
"4935792", "Ossling",
"497389", "Heroldstatt",
"494324", "Brokstedt",
"497633", "Staufen\ im\ Breisgau",
"4939399", "Kleinau",
"499284", "Schwarzenbach\ an\ der\ Saale",
"496887", "Schmelz\ Saar",
"496131", "Mainz",
"497804", "Oppenau",
"493341", "Strausberg",
"498093", "Glonn\ Kreis\ Ebersberg",
"495754", "Extertal\-Bremke",
"492620", "Neuhäusel\ Westerwald",
"4935324", "Crinitz",
"496102", "Neu\-Isenburg",
"4936421", "Camburg",
"4933986", "Falkenhagen\ Kreis\ Prignitz",
"4937422", "Markneukirchen",
"499904", "Lalling",
"497541", "Friedrichshafen",
"497158", "Neuhausen\ auf\ den\ Fildern",
"492425", "Nideggen\-Embken",
"4935724", "Lohsa",
"497709", "Wutach",
"495926", "Engden",
"4939031", "Dähre",
"4939724", "Klein\ Bünzow",
"4939883", "Gross\ Dölln",
"497941", "Öhringen",
"499504", "Stadelhofen",
"4937207", "Hainichen\ Sachsen",
"494622", "Taarstedt",
"4939324", "Kläden\ bei\ Stendal",
"496082", "Niederreifenberg",
"499467", "Michelsneukirchen",
"4939392", "Rönnebeck\ Sachsen\-Anhalt",
"499841", "Bad\ Windsheim",
"494947", "Aurich\-Ogenbargen",
"493843", "Güstrow",
"4935385", "Annaburg",
"498553", "Spiegelau",
"494256", "Hilgermissen",
"4939481", "Hedersleben\ bei\ Aschersleben",
"496420", "Lahntal",
"494528", "Schönwalde\ am\ Bungsberg",
"495764", "Steyerberg",
"493576", "Weisswasser",
"498722", "Gangkofen",
"496397", "Leimen\ Pfalz",
"496625", "Niederaula",
"499646", "Freihung",
"495462", "Ankum",
"497376", "Langenenslingen",
"4933843", "Niemegk",
"494180", "Königsmoor",
"497336", "Lonsee",
"498424", "Nassenfels",
"495198", "Schneverdingen\-Wintermoor",
"492823", "Goch",
"499275", "Speichersdorf",
"492182", "Grevenbroich\-Kapellen",
"498081", "Dorfen\ Stadt",
"495258", "Salzkotten",
"4939862", "Schmölln\ bei\ Prenzlau",
"498563", "Bad\ Birnbach\ Rottal",
"494266", "Brockel",
"499235", "Thierstein",
"495041", "Springe\ Deister",
"4933745", "Petkus",
"497026", "Lenningen",
"4936784", "Stützerbach",
"494105", "Seevetal",
"493976", "Torgelow\ bei\ Ueckermünde",
"493445", "Naumburg\ Saale",
"494928", "Ihlow\-Riepe",
"4939458", "Heudeber",
"4933439", "Fredersdorf\-Vogelsdorf",
"4938426", "Neuburg\-Steinhausen",
"4938355", "Züssow",
"497774", "Eigeltingen",
"497124", "Trochtelfingen\ Hohenz",
"494189", "Undeloh",
"495138", "Sehnde",
"4934496", "Nöbdenitz",
"494564", "Schashagen",
"499155", "Simmelsdorf",
"492951", "Büren",
"4936925", "Marksuhl",
"497734", "Gailingen",
"4938755", "Eldena",
"4934672", "Rossleben",
"498468", "Altmannstein\-Pondorf",
"4933928", "Wildberg\ Brandenburg",
"495366", "Jembke",
"496337", "Grossbundenbach",
"4939821", "Carpin",
"497472", "Rottenburg\ am\ Neckar",
"493596", "Neustadt\ in\ Sachsen",
"495653", "Sontra",
"496429", "Schweinsberg\ Hessen",
"497432", "Albstadt\-Tailfingen",
"494358", "Loose\ bei\ Eckernförde",
"49761", "Freiburg\ im\ Breisgau",
"496003", "Rosbach\ von\ der\ Höhe",
"494407", "Wardenburg",
"498192", "Schondorf\ am\ Ammersee",
"497839", "Schapbach",
"496183", "Erlensee",
"498252", "Schrobenhausen",
"497681", "Waldkirch\ Breisgau",
"4938853", "Drönnewitz\ bei\ Hagenow",
"4936483", "Ziegenrück",
"493996", "Teterow",
"499742", "Kalbach\ Rhön",
"4937365", "Sayda",
"492551", "Steinfurt\-Burgsteinfurt",
"4939346", "Tucheim",
"499295", "Töpen",
"4933671", "Lieberose",
"494964", "Rhede\ Ems",
"496261", "Mosbach\ Baden",
"494423", "Fedderwarden",
"496027", "Stockstadt\ am\ Main",
"499444", "Siegenburg",
"4936948", "Römhild",
"4933432", "Müncheberg",
"4939746", "Krackow",
"498073", "Gars\ am\ Inn",
"495663", "Spangenberg",
"498458", "Gaimersheim",
"499206", "Mistelgau\-Obernsees",
"4938451", "Hoppenrade\ bei\ Güstrow",
"495356", "Helmstedt\-Barmke",
"4936377", "Rastenberg",
"498033", "Oberaudorf",
"492103", "Hilden",
"494176", "Marschacht",
"498821", "Garmisch\-Partenkirchen",
"4938828", "Schönberg",
"4939856", "Beenz\ bei\ Prenzlau",
"4939999", "Tutow",
"499165", "Sugenheim",
"492961", "Brilon",
"495850", "Neetze",
"494554", "Wahlstedt",
"4933082", "Menz\ Kreis\ Oberhavel",
"494136", "Scharnebeck",
"4933454", "Wölsickendorf\/Wollenberg",
"494954", "Moormerland",
"4933089", "Himmelpfort",
"498323", "Immenstadt\ im\ Allgäu",
"492561", "Ahaus",
"4938845", "Kaarssen",
"4939992", "Görmin",
"496251", "Bensheim",
"4936462", "Ossmannstedt",
"4939924", "Stuer",
"497305", "Erbach\ Donau",
"4939423", "Wegeleben",
"498262", "Mittelneufnach",
"492777", "Breitscheid\ Hessen",
"4939006", "Miesterhorst",
"494825", "Burg\ Dithmarschen",
"492737", "Netphen\-Deuz",
"4937297", "Thum\ Sachsen",
"495224", "Enger\ Westfalen",
"496048", "Büdingen\-Eckartshausen",
"492735", "Neunkirchen\ Siegerl",
"494372", "Westfehmarn",
"494827", "Wacken",
"496402", "Hungen",
"493923", "Zerbst",
"496809", "Grossrosseln",
"496243", "Monsheim",
"497033", "Weil\ Der\ Stadt",
"497307", "Senden\ Iller",
"497073", "Ammerbuch",
"492775", "Driedorf",
"497458", "Ebhausen",
"496384", "Konken",
"494332", "Hamdorf\ bei\ Rendsburg",
"499921", "Regen",
"493464", "Sangerhausen",
"494496", "Friesoythe\-Markhausen",
"496471", "Weilburg",
"4935876", "Weissenberg\ Sachsen",
"498380", "Achberg",
"496704", "Langenlonsheim",
"4934203", "Zwenkau",
"495152", "Hessisch\ Oldendorf",
"495846", "Gartow\ Niedersachsen",
"493762", "Crimmitschau",
"4933973", "Zernitz\ bei\ Neustadt\ Dosse",
"4935244", "Krögis",
"4933474", "Neutrebbin",
"497821", "Lahr\ Schwarzwald",
"4936253", "Georgenthal\ Thüringer\ Wald",
"496431", "Limburg\ an\ der\ Lahn",
"494634", "Husby",
"496682", "Tann\ Rhön",
"498785", "Rottenburg\-Oberroning",
"499167", "Oberscheinfeld",
"4939244", "Steutz",
"4936646", "Tanna\ bei\ Schleiz",
"493907", "Gardelegen",
"494803", "Pahlen",
"494249", "Bassum\-Nordwohlde",
"495292", "Lichtenau\-Atteln",
"492836", "Wachtendonk",
"494674", "Ockholm",
"497323", "Gerstetten",
"495745", "Stemwede\-Levern",
"499521", "Hassfurt",
"498238", "Gessertshausen",
"49471", "Bremerhaven",
"492330", "Herdecke",
"492508", "Drensteinfurt",
"497262", "Eppingen",
"493523", "Coswig\ bei\ Dresden",
"4933080", "Marienthal\ Kreis\ Oberhavel",
"495162", "Fallingbostel",
"492671", "Cochem",
"494848", "Rantrum",
"4935478", "Goyatz",
"498734", "Reisbach\ Niederbayern",
"496588", "Pluwig",
"494480", "Ovelgönne\-Strückhausen",
"4934659", "Blankenheim\ bei\ Sangerhausen",
"499659", "Leuchtenberg",
"498774", "Bayerbach\ bei\ Ergoldsbach",
"498124", "Forstern\ Oberbayern",
"496894", "St\ Ingbert",
"492631", "Neuwied",
"498432", "Burgheim",
"492602", "Montabaur",
"496120", "Aarbergen",
"49861", "Traunstein",
"4936847", "Steinbach\-Hallenberg",
"495933", "Lathen",
"497192", "Murrhardt",
"495973", "Neuenkirchen\ Kreis\ Steinfurt",
"492543", "Billerbeck\ Westfalen",
"4938873", "Carlow",
"496375", "Wallhalben",
"492943", "Erwitte",
"495573", "Uslar\-Volpriehausen",
"494405", "Edewecht",
"496335", "Trulben",
"497252", "Bretten",
"495533", "Bodenwerder",
"498681", "Waging\ am\ See",
"492482", "Hellenthal",
"4934652", "Allstedt",
"499157", "Alfeld\ Mittelfranken",
"494793", "Hambergen",
"4936602", "Ronneburg\ Thüringen",
"4938375", "Koserow",
"4937601", "Mülsen\ Skt\ Jacob",
"497626", "Kandern",
"492304", "Schwerte",
"495641", "Warburg",};
$areanames{de} = {"4935726", "Groß\ Särchen",
"4935841", "Großschönau\ Sachsen",
"4936072", "Weißenborn\-Lüderode",
"4936484", "Knau\ bei\ Pößneck",
"499636", "Plößberg",
"496364", "Nußbach\ Pfalz",
"495064", "Groß\ Düngen",
"495384", "Seesen\-Groß\ Rhüden",
"4936949", "Obermaßfeld\-Grimmenthal",
"496663", "Steinau\ an\ der\ Straße",
"498367", "Roßhaupten\ Forggensee",
"49221", "Köln",
"4938234", "Born\ Darß",
"497355", "Hochdorf\ Riß",
"4935938", "Großpostwitz\ OL",
"495827", "Unterlüß",
"494497", "Barßel\-Harkebrügge",
"496252", "Heppenheim\ Bergstraße",
"498536", "Kößlarn",
"4935753", "Großräschen",
"4934901", "Roßlau\ Elbe",
"499242", "Gößweinstein",
"4935248", "Schönfeld\ bei\ Großenhain",
"494684", "Langeneß\ Hallig",
"499656", "Moosbach\ bei\ Vohenstrauß",
"498807", "Dießen\ am\ Ammersee",
"4939976", "Groß\ Bützin",
"499141", "Weißenburg\ in\ Bayern",
"4936705", "Oberweißbach\ Thüringer\ Wald",
"4935240", "Tauscha\ bei\ Großenhain",
"498170", "Straßlach\-Dingharting",
"499567", "Seßlach\-Gemünda",
"494483", "Ovelgönne\-Großenmeer",
"4989", "München",
"494509", "Groß\ Grönau",
"492203", "Köln\-Porz",
"497162", "Süßen",
"4934493", "Gößnitz\ Thüringen",
"497351", "Biberach\ an\ der\ Riß",
"495053", "Faßberg\-Müden",
"498633", "Tüßling",
"492339", "Sprockhövel\-Haßlinghausen",
"4939883", "Groß\ Dölln",
"4934445", "Stößen",
"49911", "Nürnberg",
"4935952", "Großröhrsdorf\ OL",
"496321", "Neustadt\ an\ der\ Weinstraße",
"4939934", "Groß\ Plasten",
"493647", "Pößneck",};

    sub new {
      my $class = shift;
      my $number = shift;
      $number =~ s/(^\+49|\D)//g;
      my $self = bless({ country_code => '49', number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self if ($self->is_valid());
      $number =~ s/^(?:0)//;
      $self = bless({ country_code => '49', number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self->is_valid() ? $self : undef;
    }
1;