/* ToggleLogging.c
 * This file is part of the LaBrea package
 *
 * Copyright (C) 2001, 2002 Tom Liston <tliston@premmag.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include "labrea.h"

/* Install USR1 signal to toggle logging off / on   -fw 9/21/01  */
#ifndef WIN32
void ToggleLogging(int sig) {
  extern int datalog, savedatalog, oflag;
  extern char mybuffer2[], format5[], str19[], str20[], str21[];

  if((datalog == 0) && (savedatalog == 0)) {
    datalog = 1;
    sprintf(mybuffer2, str19, sig);
    goto logit;
  } else {
    if(savedatalog != 0) {
      datalog = savedatalog;
      savedatalog = 0;
      sprintf(mybuffer2, str20, sig, datalog);
      goto logit;
    } else {
      savedatalog = datalog;
      datalog = 0;
      sprintf(mybuffer2, str21, sig, datalog);
      goto logit;
    }
  }
  return;
  logit:
  if(oflag)
    printf(format5, mybuffer2);
  else
    syslog(INFOTYPE, mybuffer2);
}
#endif


