# automatically generated file, don't edit



# Copyright 2023 David Cantrell, derived from data from libphonenumber
# http://code.google.com/p/libphonenumber/
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
package Number::Phone::StubCountry::DE;
use base qw(Number::Phone::StubCountry);

use strict;
use warnings;
use utf8;
our $VERSION = 1.20230307181419;

my $formatters = [
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            3[02]|
            40|
            [68]9
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3,13})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            2(?:
              0[1-389]|
              12[0-8]
            )|
            3(?:
              [35-9][15]|
              4[015]
            )|
            906|
            2(?:
              [13][14]|
              2[18]
            )|
            (?:
              2[4-9]|
              4[2-9]|
              [579][1-9]|
              [68][1-8]
            )1
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{3,12})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            [24-6]|
            3(?:
              3(?:
                0[1-467]|
                2[127-9]|
                3[124578]|
                7[1257-9]|
                8[1256]|
                9[145]
              )|
              4(?:
                2[135]|
                4[13578]|
                9[1346]
              )|
              5(?:
                0[14]|
                2[1-3589]|
                6[1-4]|
                7[13468]|
                8[13568]
              )|
              6(?:
                2[1-489]|
                3[124-6]|
                6[13]|
                7[12579]|
                8[1-356]|
                9[135]
              )|
              7(?:
                2[1-7]|
                4[145]|
                6[1-5]|
                7[1-4]
              )|
              8(?:
                21|
                3[1468]|
                6|
                7[1467]|
                8[136]
              )|
              9(?:
                0[12479]|
                2[1358]|
                4[134679]|
                6[1-9]|
                7[136]|
                8[147]|
                9[1468]
              )
            )|
            70[2-8]|
            8(?:
              0[2-9]|
              [1-8]
            )|
            90[7-9]|
            [79][1-9]|
            3[68]4[1347]|
            3(?:
              47|
              60
            )[1356]|
            3(?:
              3[46]|
              46|
              5[49]
            )[1246]|
            3[4579]3[1357]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{2,11})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '138',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '3',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{5})(\\d{2,10})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '181',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{5,11})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            1(?:
              3|
              80
            )|
            9
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d)(\\d{4,10})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '1[67]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{7,8})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '8',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{7,12})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '18500',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{5})(\\d{6})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '7',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '18[68]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{7})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '15[0568]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{5})(\\d{6})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '15[1279]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{7})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '18',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{8})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            1(?:
              6[023]|
              7
            )
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{2})(\\d{7,8})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '15[279]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{2})(\\d{7})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '15',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{2})(\\d{8})'
                }
              ];

my $validators = {
                'fixed_line' => '
          32\\d{9,11}|
          49[1-6]\\d{10}|
          322\\d{6}|
          49[0-7]\\d{3,9}|
          (?:
            [34]0|
            [68]9
          )\\d{3,13}|
          (?:
            2(?:
              0[1-689]|
              [1-3569]\\d|
              4[0-8]|
              7[1-7]|
              8[0-7]
            )|
            3(?:
              [3569]\\d|
              4[0-79]|
              7[1-7]|
              8[1-8]
            )|
            4(?:
              1[02-9]|
              [2-48]\\d|
              5[0-6]|
              6[0-8]|
              7[0-79]
            )|
            5(?:
              0[2-8]|
              [124-6]\\d|
              [38][0-8]|
              [79][0-7]
            )|
            6(?:
              0[02-9]|
              [1-358]\\d|
              [47][0-8]|
              6[1-9]
            )|
            7(?:
              0[2-8]|
              1[1-9]|
              [27][0-7]|
              3\\d|
              [4-6][0-8]|
              8[0-5]|
              9[013-7]
            )|
            8(?:
              0[2-9]|
              1[0-79]|
              2\\d|
              3[0-46-9]|
              4[0-6]|
              5[013-9]|
              6[1-8]|
              7[0-8]|
              8[0-24-6]
            )|
            9(?:
              0[6-9]|
              [1-4]\\d|
              [589][0-7]|
              6[0-8]|
              7[0-467]
            )
          )\\d{3,12}
        ',
                'geographic' => '
          32\\d{9,11}|
          49[1-6]\\d{10}|
          322\\d{6}|
          49[0-7]\\d{3,9}|
          (?:
            [34]0|
            [68]9
          )\\d{3,13}|
          (?:
            2(?:
              0[1-689]|
              [1-3569]\\d|
              4[0-8]|
              7[1-7]|
              8[0-7]
            )|
            3(?:
              [3569]\\d|
              4[0-79]|
              7[1-7]|
              8[1-8]
            )|
            4(?:
              1[02-9]|
              [2-48]\\d|
              5[0-6]|
              6[0-8]|
              7[0-79]
            )|
            5(?:
              0[2-8]|
              [124-6]\\d|
              [38][0-8]|
              [79][0-7]
            )|
            6(?:
              0[02-9]|
              [1-358]\\d|
              [47][0-8]|
              6[1-9]
            )|
            7(?:
              0[2-8]|
              1[1-9]|
              [27][0-7]|
              3\\d|
              [4-6][0-8]|
              8[0-5]|
              9[013-7]
            )|
            8(?:
              0[2-9]|
              1[0-79]|
              2\\d|
              3[0-46-9]|
              4[0-6]|
              5[013-9]|
              6[1-8]|
              7[0-8]|
              8[0-24-6]
            )|
            9(?:
              0[6-9]|
              [1-4]\\d|
              [589][0-7]|
              6[0-8]|
              7[0-467]
            )
          )\\d{3,12}
        ',
                'mobile' => '
          15[0-25-9]\\d{8}|
          1(?:
            6[023]|
            7\\d
          )\\d{7,8}
        ',
                'pager' => '
          16(?:
            4\\d{1,10}|
            [89]\\d{1,11}
          )
        ',
                'personal_number' => '700\\d{8}',
                'specialrate' => '(
          180\\d{5,11}|
          13(?:
            7[1-6]\\d\\d|
            8
          )\\d{4}
        )|(
          (?:
            137[7-9]|
            900(?:
              [135]|
              9\\d
            )
          )\\d{6}
        )|(
          18(?:
            1\\d{5,11}|
            [2-9]\\d{8}
          )
        )',
                'toll_free' => '800\\d{7,12}',
                'voip' => ''
              };
my %areanames = ();
$areanames{de} = {"499636", "Plößberg",
"49221", "Köln",
"499242", "Gößweinstein",
"497351", "Biberach\ an\ der\ Riß",
"4936484", "Knau\ bei\ Pößneck",
"4939883", "Groß\ Dölln",
"49911", "Nürnberg",
"498367", "Roßhaupten\ Forggensee",
"495053", "Faßberg\-Müden",
"497355", "Hochdorf\ Riß",
"4935753", "Großräschen",
"496364", "Nußbach\ Pfalz",
"494483", "Ovelgönne\-Großenmeer",
"498633", "Tüßling",
"499656", "Moosbach\ bei\ Vohenstrauß",
"4934445", "Stößen",
"498170", "Straßlach\-Dingharting",
"496321", "Neustadt\ an\ der\ Weinstraße",
"492339", "Sprockhövel\-Haßlinghausen",
"4936072", "Weißenborn\-Lüderode",
"494509", "Groß\ Grönau",
"4939934", "Groß\ Plasten",
"492203", "Köln\-Porz",
"498807", "Dießen\ am\ Ammersee",
"496663", "Steinau\ an\ der\ Straße",
"4989", "München",
"497162", "Süßen",
"499567", "Seßlach\-Gemünda",
"499141", "Weißenburg\ in\ Bayern",
"495064", "Groß\ Düngen",
"4938234", "Born\ Darß",
"494684", "Langeneß\ Hallig",
"4936949", "Obermaßfeld\-Grimmenthal",
"495827", "Unterlüß",
"4934901", "Roßlau\ Elbe",
"4935841", "Großschönau\ Sachsen",
"496252", "Heppenheim\ Bergstraße",
"498536", "Kößlarn",
"4935952", "Großröhrsdorf\ OL",
"493647", "Pößneck",
"495384", "Seesen\-Groß\ Rhüden",
"4934493", "Gößnitz\ Thüringen",
"4935248", "Schönfeld\ bei\ Großenhain",
"4935726", "Groß\ Särchen",
"4939976", "Groß\ Bützin",
"4935240", "Tauscha\ bei\ Großenhain",
"4936705", "Oberweißbach\ Thüringer\ Wald",
"4935938", "Großpostwitz\ OL",
"494497", "Barßel\-Harkebrügge",};
$areanames{en} = {"492267", "Wipperfürth",
"49961", "Weiden\ in\ der\ Oberpfalz",
"493693", "Meiningen",
"495872", "Stoetze",
"493949", "Oschersleben\ Bode",
"499841", "Bad\ Windsheim",
"498122", "Erding",
"495446", "Rehden",
"496647", "Herbstein\-Stockhausen",
"494793", "Hambergen",
"4936744", "Remda",
"495056", "Winsen\-Meissendorf",
"498555", "Perlesreut",
"496221", "Heidelberg",
"494489", "Apen",
"4938450", "Tarnow\ bei\ Bützow",
"499087", "Marktoffingen",
"494473", "Emstek",
"4937382", "Geringswalde",
"4933830", "Ziesar",
"492242", "Hennef\ Sieg",
"496036", "Wölfersheim",
"4939934", "Gross\ Plasten",
"499199", "Kunreuth",
"496806", "Heusweiler",
"4935771", "Bad\ Muskau",
"492972", "Schmallenberg",
"495432", "Löningen",
"499682", "Erbendorf",
"494135", "Kirchgellersen",
"495285", "Bad\ Pyrmont\-Kleinenberg",
"499292", "Konradsreuth",
"495695", "Twistetal",
"496726", "Lorch\ Rheingau",
"4934927", "Globig\-Bleddin",
"4939406", "Harbke",
"4939955", "Jürgenstorf",
"492389", "Werne",
"4938873", "Carlow",
"4933703", "Sperenberg",
"4933924", "Rägelin",
"492174", "Burscheid\ Rheinland",
"494833", "Wesselburen",
"492373", "Menden\ Sauerland",
"493860", "Raben\ Steinfeld",
"496452", "Battenberg\ Eder",
"4935207", "Moritzburg",
"496042", "Büdingen\ Hessen",
"492236", "Wesseling\ Rheinland",
"4939820", "Triepkendorf",
"4933086", "Grieben\ Kreis\ Oberhavel",
"498333", "Babenhausen\ Schwaben",
"4936072", "Weissenborn\-Lüderode",
"498134", "Odelzhausen",
"495337", "Kissenbrück",
"494925", "Hinte",
"4938356", "Behrenhoff",
"493721", "Meinersdorf",
"494262", "Visselhövede",
"494621", "Schleswig",
"498276", "Baar\ Schwaben",
"494509", "Gross\ Grönau",
"496744", "Oberwesel",
"4933977", "Gumtow",
"499954", "Simbach\ Niederbayern",
"492603", "Bad\ Ems",
"495101", "Pattensen",
"494247", "Affinghausen",
"4938462", "Baumgarten",
"4938787", "Glöwen",
"494977", "Blomberg\ Ostfriesland",
"4934722", "Preusslitz",
"496783", "Baumholder",
"4939393", "Werben\ Elbe",
"496357", "Standenbühl",
"497331", "Geislingen\ an\ der\ Steige",
"4935953", "Burkau",
"499763", "Sulzdorf\ an\ der\ Lederhecke",
"499152", "Hartenstein\ Mittelfranken",
"497773", "Bodman\-Ludwigshafen",
"497567", "Leutkirch\-Friesenhofen",
"499204", "Plankenfels",
"495424", "Bad\ Rothenfelde",
"494554", "Wahlstedt",
"495561", "Einbeck",
"498771", "Ergoldsbach",
"494169", "Sauensiek",
"4938322", "Richtenberg",
"495366", "Jembke",
"499238", "Röslau",
"497542", "Tettnang",
"499525", "Königsberg\ in\ Bayern",
"494458", "Wiefelstede\-Spohle",
"4938302", "Sagard",
"497765", "Rickenbach\ Hotzenwald",
"495594", "Bovenden\-Reyershausen",
"4939320", "Schinne",
"496255", "Lindenfels",
"492339", "Sprockhövel\-Hasslinghausen",
"4938373", "Katzow",
"492696", "Nohn\ Eifel",
"4934636", "Schafstädt",
"494883", "Süderstapel",
"499775", "Schönau\ an\ der\ Brend",
"498326", "Fischen\ im\ Allgäu",
"4935895", "Klitten",
"497852", "Willstätt",
"499727", "Schonungen\-Marktsteinach",
"4939059", "Wegenstedt",
"499495", "Breitenbrunn\ Oberpfalz",
"495482", "Tecklenburg",
"498464", "Dietfurt\ an\ der\ Altmühl",
"499632", "Waldsassen",
"495528", "Gieboldehausen",
"494185", "Marxen\ Auetal",
"495235", "Blomberg\ Lippe",
"494844", "Pellworm",
"492358", "Meinerzhagen\-Valbert",
"4935754", "Klettwitz",
"494668", "Klanxbüll",
"492445", "Schleiden\ Eifel",
"4934773", "Schwittersdorf",
"496086", "Grävenwiesbach",
"4937365", "Sayda",
"4936023", "Horsmar",
"499646", "Freihung",
"493571", "Hoyerswerda",
"494260", "Visselhövede\-Wittorf",
"498654", "Freilassing",
"49541", "Osnabrück",
"4938822", "Diedrichshagen\ bei\ Grevesmühlen",
"495502", "Dransfeld",
"499288", "Bad\ Steben",
"493606", "Heiligenstadt\ Heilbad",
"496195", "Kelkheim\ Taunus",
"494706", "Schiffdorf",
"4936461", "Bad\ Sulza",
"4936645", "Mühltroff",
"492864", "Reken",
"493329", "Stahnsdorf",
"495964", "Lähden",
"4934907", "Jeber\-Bergfrieden",
"499624", "Ensdorf\ Oberpfalz",
"494951", "Weener",
"4939426", "Hessen",
"493847", "Sternberg",
"496371", "Landstuhl",
"497739", "Hilzingen",
"496893", "Saarbrücken\-Ensheim",
"496023", "Alzenau\ in\ Unterfranken",
"492365", "Marl",
"499356", "Burgsinn",
"496733", "Gau\-Odernheim",
"496660", "Steinau\-Marjoss",
"4933206", "Fichtenwalde",
"497381", "Münsingen",
"495147", "Uetze\-Hänigsen",
"499551", "Burgwindheim",
"498344", "Westendorf\ bei\ Kaufbeuren",
"4933846", "Dippmannsdorf",
"497586", "Herbertingen",
"498143", "Inning\ am\ Ammersee",
"4939452", "Ilsenburg",
"4936943", "Bettenhausen\ Thüringen",
"497141", "Ludwigsburg\ Württemberg",
"4938485", "Dabel",
"492223", "Königswinter",
"495753", "Auetal\-Bernsen",
"494826", "Hohenlockstedt",
"4939366", "Kehnert",
"4933436", "Prötzel",
"494465", "Friedeburg\ Ostfriesland",
"498383", "Grünenbach\ Allgäu",
"4938856", "Pritzier\ bei\ Hagenow",
"495162", "Fallingbostel",
"498845", "Bad\ Kohlgrub",
"498379", "Waltenhofen\-Oberdorf",
"496268", "Hüffenhardt",
"497127", "Neckartenzlingen",
"495459", "Hörstel",
"497391", "Ehingen\ Donau",
"4939993", "Hohenmocker",
"495121", "Hildesheim",
"492623", "Ransbach\-Baumbach",
"498194", "Vilgertshofen",
"496439", "Holzappel",
"494529", "Süsel\-Bujendorf",
"498393", "Holzgünz",
"497175", "Leinzell",
"492248", "Hennef\-Uckerath",
"4937322", "Brand\-Erbisdorf",
"4936203", "Vieselbach",
"495074", "Rodewald",
"499165", "Sugenheim",
"496668", "Birstein\-Lichenroth",
"4936843", "Benshausen",
"495438", "Bakum\-Lüsche",
"499505", "Litzendorf",
"497433", "Balingen",
"496844", "Blieskastel\-Altheim",
"496185", "Hammersbach\ Hessen",
"492156", "Willich\-Anrath",
"493821", "Ribnitz\-Damgarten",
"499929", "Ruhmannsfelden",
"4933984", "Blumenthal\ bei\ Pritzwalk",
"495404", "Westerkappeln",
"496345", "Albersweiler",
"496458", "Rosenthal\ Hessen",
"498431", "Neuburg\ an\ der\ Donau",
"499280", "Selbitz\ Oberfranken",
"494255", "Martfeld",
"4937462", "Rothenkirchen\ Vogtland",
"496048", "Büdingen\-Eckartshausen",
"496465", "Breidenbach\ bei\ Biedenkopf",
"496096", "Wiesen\ Unterfranken",
"496826", "Bexbach",
"4936928", "Neuenhof\ Thüringen",
"494268", "Bötersen",
"492471", "Roetgen\ Eifel",
"496201", "Weinheim\ Bergstr",
"4939291", "Calbe\ Saale",
"4934467", "Eckartsberga",
"499246", "Pegnitz\-Trockau",
"497966", "Unterschneidheim",
"498102", "Höhenkirchen\-Siegertsbrunn",
"494733", "Butjadingen\-Burhave",
"4935693", "Lauschütz",
"4938727", "Mestlin",
"4934782", "Mansfeld\ Südharz",
"498254", "Altomünster",
"499976", "Rötz",
"494893", "Hohenaspe",
"495520", "Braunlage",
"496655", "Neuhof\ Kreis\ Fulda",
"499158", "Offenhausen\ Mittelfranken",
"492686", "Weyerbusch",
"499741", "Bad\ Brückenau",
"492296", "Reichshof\-Brüchermühle",
"497937", "Dörzbach",
"498562", "Triftern",
"4939036", "Binde",
"495584", "Hattorf\ am\ Harz",
"492831", "Geldern",
"495772", "Espelkamp",
"494371", "Burg\ auf\ Fehmarn",
"4938758", "Dömitz",
"495931", "Meppen",
"496706", "Wallhausen\ Nahe",
"494195", "Hartenholm",
"495492", "Steinfeld\ Oldenburg",
"4934659", "Blankenheim\ bei\ Sangerhausen",
"495543", "Staufenberg\ Niedersachsen",
"4935600", "Döbern\ NL",
"4933748", "Treuenbrietzen",
"4934327", "Waldheim\ Sachsen",
"4935876", "Weissenberg\ Sachsen",
"4933052", "Leegebruch",
"495635", "Vöhl",
"498547", "Osterhofen\-Gergweis",
"499232", "Wunsiedel",
"494452", "Zetel\-Neuenburg",
"4939264", "Kroppenstedt",
"496003", "Rosbach\ von\ der\ Höhe",
"495155", "Emmerthal",
"497054", "Wildberg\ Württemberg",
"4933741", "Niedergörsdorf",
"492953", "Wünnenberg",
"4934295", "Krensitz",
"496833", "Rehlingen\-Siersburg",
"499604", "Wernberg\-Köblitz",
"497444", "Alpirsbach",
"498745", "Bodenkirchen",
"498857", "Benediktbeuern",
"499469", "Roding\-Neubäu",
"495853", "Neu\ Darchau",
"4935027", "Weesenstein",
"497483", "Horb\-Mühringen",
"4938751", "Picher",
"496135", "Bodenheim\ Rhein",
"495522", "Osterode\ am\ Harz",
"499638", "Neualbenreuth",
"4939298", "Barby\ Elbe",
"492352", "Altena\ Westfalen",
"492764", "Welschen\ Ennest",
"4933877", "Nitzahn",
"494662", "Leck",
"494806", "Sarzbüttel",
"493762", "Crimmitschau",
"494221", "Delmenhorst",
"492203", "Cologne\-Porz",
"496473", "Leun",
"4935058", "Pretzschendorf",
"4936921", "Wutha\-Farnroda",
"499659", "Leuchtenberg",
"4936083", "Uder",
"497839", "Schapbach",
"499435", "Schwarzenfeld",
"495508", "Gleichen\-Rittmarshausen",
"493868", "Rastow",
"495685", "Knüllwald",
"497503", "Wilhelmsdorf\ Württemberg",
"499282", "Naila",
"495295", "Lichtenau\ Westfalen",
"496554", "Waxweiler",
"498306", "Ronsberg",
"495534", "Eschershausen\ an\ der\ Lenne",
"4939779", "Eggesin",
"498501", "Thyrnau",
"498629", "Palling",
"492636", "Burgbrohl",
"4939855", "Parmen\-Weggun",
"49921", "Bayreuth",
"492667", "Stein\-Neukirch",
"499875", "Wolframs\-Eschenbach",
"499349", "Werbach\-Wenkheim",
"498161", "Freising",
"494779", "Freiburg\ Elbe",
"494357", "Sehestedt\ Eider",
"496247", "Worms\-Pfeddersheim",
"497426", "Gosheim",
"493679", "Neuhaus\ am\ Rennweg",
"493683", "Schmalkalden",
"4934691", "Könnern",
"496509", "Büdlich",
"4938425", "Kirchdorf\ Poel",
"494744", "Loxstedt",
"4936041", "Bad\ Tennstedt",
"499173", "Thalmässing",
"496621", "Bad\ Hersfeld",
"499374", "Eschau",
"499189", "Berg\ bei\ Neumarkt\ in\ der\ Oberpfalz",
"492642", "Remagen",
"497163", "Ebersbach\ an\ der\ Fils",
"493644", "Apolda",
"496262", "Aglasterhausen",
"499097", "Marxheim",
"497364", "Oberkochen",
"495168", "Walsrode\-Stellichte",
"499827", "Lichtenau\ Mittelfranken",
"494499", "Barssel",
"499933", "Wallersdorf",
"499346", "Grünsfeld",
"4933981", "Putlitz",
"494776", "Osten\-Altendorf",
"495157", "Emmerthal\-Börry",
"498762", "Wartenberg\ Oberbayern",
"497429", "Egesheim",
"495572", "Bodenfelde",
"4934445", "Stössen",
"498153", "Wessling",
"497151", "Waiblingen",
"496506", "Welschbillig",
"499186", "Lauterhofen\ Oberpfalz",
"495743", "Espelkamp\-Gestringen",
"4935696", "Briesnig",
"4937600", "Neumark\ Sachsen",
"496301", "Otterbach\ Pfalz",
"4936330", "Grossberndten",
"494496", "Friesoythe\-Markhausen",
"497748", "Grafenhausen\ Hochschwarzwald",
"496050", "Biebergemünd",
"496440", "Kölschhausen",
"4939033", "Wallstawe",
"499332", "Marktbreit",
"496166", "Fischbachtal",
"494941", "Aurich",
"493745", "Falkenstein\ Vogtland",
"492591", "Lüdinghausen",
"4938207", "Stäbelow",
"494271", "Sulingen",
"494533", "Reinfeld\ Holstein",
"4935242", "Nossen",
"4938847", "Boizenburg\ Elbe",
"496423", "Wetter\ Hessen",
"492639", "Anhausen\ Kreis\ Neuwied",
"4935873", "Herrnhut",
"498293", "Welden\ bei\ Augsburg",
"4939268", "Egeln",
"496486", "Katzenelnbogen",
"492455", "Waldfeucht",
"498679", "Burgkirchen\ an\ der\ Alz",
"4939996", "Törpin",
"498683", "Tittmoning",
"492045", "Bottrop\-Kirchhellen",
"497681", "Waldkirch\ Breisgau",
"4936206", "Grossfahner",
"499656", "Moosbach\ bei\ Vohenstrauss",
"497836", "Schiltach",
"4936846", "Suhl\-Dietzhausen",
"4939294", "Gross\ Rosenburg",
"499123", "Lauf\ an\ der\ Pegnitz",
"492961", "Brilon",
"4933609", "Brieskow\-Finkenheerd",
"499324", "Dettelbach",
"496245", "Biblis",
"498868", "Schwabsoien",
"494355", "Rieseby",
"4935054", "Lauenstein\ Sachsen",
"497842", "Kappelrodeck",
"499825", "Herrieden",
"499466", "Stamsried",
"493306", "Gransee",
"4935322", "Doberlug\-Kirchhain",
"493629", "Stadtilm",
"493501", "Pirna",
"497476", "Bisingen",
"498064", "Au\ bei\ Bad\ Aibling",
"495082", "Langlingen",
"495861", "Dannenberg\ Elbe",
"499398", "Birkenfeld\ bei\ Würzburg",
"494854", "Friedrichskoog",
"492673", "Ellenz\-Poltersdorf",
"495171", "Peine",
"4936924", "Mihla",
"498206", "Egling\ an\ der\ Paar",
"4936703", "Gräfenthal",
"4938735", "Plau\ am\ See",
"492689", "Dierdorf",
"499142", "Treuchtlingen",
"497125", "Bad\ Urach",
"495024", "Rohrsen\ Kreis\ Nienburg\ Weser",
"4933479", "Küstrin\-Kietz",
"498821", "Garmisch\-Partenkirchen",
"498091", "Kirchseeon",
"492928", "Soest\-Ostönnen",
"496709", "Fürfeld\ Kreis\ Bad\ Kreuznach",
"494544", "Berkenthin",
"4939483", "Ballenstedt",
"499382", "Gerolzhofen",
"495828", "Himbergen",
"499167", "Oberscheinfeld",
"4936252", "Tambach\-Dietharz",
"497823", "Seelbach\ Schutter",
"492994", "Marsberg\-Westheim",
"498178", "Icking",
"493431", "Döbeln",
"497552", "Pfullendorf",
"499274", "Hollfeld",
"497703", "Bonndorf\ im\ Schwarzwald",
"496187", "Schöneck",
"497264", "Bad\ Rappenau",
"496362", "Alsenz",
"496754", "Martinstein",
"499944", "Miltach",
"4938754", "Leussow\ bei\ Ludwigslust",
"495734", "Bergkirchen\ Westfalen",
"4934497", "Langenleuba\-Niederhain",
"494257", "Schweringen",
"49931", "Würzburg",
"493871", "Parchim",
"4933744", "Hohenseefeld",
"492192", "Hückeswagen",
"496347", "Hochstadt\ Pfalz",
"492564", "Vreden",
"492159", "Meerbusch\-Osterath",
"495032", "Neustadt\ am\ Rübenberge",
"4939831", "Feldberg",
"493562", "Forst\ Lausitz",
"4938227", "Lüdershagen\ bei\ Barth",
"499926", "Frauenau",
"495802", "Wrestedt",
"496467", "Hatzfeld\ Eder",
"4935822", "Hagenwerder",
"496876", "Weiskirchen\ Saar",
"492902", "Warstein",
"496593", "Hillesheim\ Eifel",
"493904", "Haldensleben",
"494403", "Bad\ Zwischenahn",
"496442", "Braunfels",
"496052", "Bad\ Orb",
"492421", "Düren",
"4935939", "Hochkirch",
"499851", "Dinkelsbühl",
"497935", "Schrozberg",
"495456", "Westerkappeln\-Velpe",
"497631", "Müllheim\ Baden",
"496657", "Hofbieber",
"498545", "Hofkirchen\ Bayern",
"496436", "Dornburg\ Hessen",
"498633", "Tüssling",
"492252", "Zülpich",
"494526", "Ascheberg\ Holstein",
"492303", "Unna",
"495722", "Bückeburg",
"494321", "Neumünster",
"492104", "Mettmann",
"4933083", "Schulzendorf\ Kreis\ Oberhavel",
"4939863", "Seehausen\ bei\ Prenzlau",
"499777", "Ostheim\ von\ der\ Rhön",
"499359", "Karlstadt\-Wiesenfeld",
"499563", "Rödental",
"4933921", "Zechlinerhütte",
"4938353", "Gützkow\ bei\ Greifswald",
"494347", "Flintbek",
"496257", "Seeheim\-Jugenheim",
"497231", "Pforzheim",
"497573", "Stetten\ am\ kalten\ Markt",
"497026", "Lenningen",
"495237", "Augustdorf",
"494754", "Bülkau",
"494187", "Holm\-Seppensen",
"494362", "Heiligenhafen",
"495761", "Stolzenau",
"498571", "Simbach\ am\ Inn",
"492652", "Mendig",
"498233", "Kissing",
"494829", "Wewelsfleth",
"499497", "Seubersdorf\ in\ der\ Oberpfalz",
"4939396", "Neukirchen\ Altmark",
"498376", "Sulzberg\ Allgäu",
"497742", "Klettgau",
"499725", "Poppenhausen\ Unterfranken",
"493521", "Meissen",
"492447", "Dahlem\ bei\ Kall",
"4939931", "Röbel\ Müritz",
"499338", "Röttingen\ Unterfranken",
"496544", "Rhaunen",
"4935774", "Boxberg\ Sachsen",
"499805", "Burgoberbach",
"495266", "Lemgo\-Kirchheide",
"492462", "Linnich",
"497736", "Tengen",
"4934202", "Delitzsch",
"493464", "Sangerhausen",
"496583", "Palzem",
"494963", "Dörpen",
"4936741", "Bad\ Blankenburg",
"499103", "Cadolzburg",
"4937437", "Bad\ Elster",
"499674", "Schönsee",
"496321", "Neustadt\ an\ der\ Weinstrasse",
"496073", "Babenhausen\ Hessen",
"497664", "Freiburg\-Tiengen",
"493344", "Bad\ Freienwalde",
"496526", "Bollendorf",
"492182", "Grevenbroich\-Kapellen",
"492367", "Henrichenburg",
"4935727", "Burghammer",
"49391", "Magdeburg",
"4939740", "Nechlin",
"4937207", "Hainichen\ Sachsen",
"493379", "Mahlow",
"4933632", "Hangelsberg",
"494442", "Lohne\ Oldenburg",
"492273", "Kerpen\-Horrem",
"496403", "Linden\ Hessen",
"498862", "Steingaden\ Oberbayern",
"498081", "Dorfen\ Stadt",
"498170", "Strasslach\-Dingharting",
"495145", "Beedenbostel",
"497044", "Mönsheim",
"492943", "Erwitte",
"492336", "Schwelm",
"494876", "Reher\ Holstein",
"49234", "Bochum",
"495820", "Suhlendorf",
"4939403", "Gröningen\ Sachsen\-Anhalt",
"497454", "Sulz\ am\ Neckar",
"498847", "Obersöchering",
"49211", "Düsseldorf",
"4938876", "Roggendorf",
"494467", "Wittmund\-Funnix",
"495843", "Wustrow\ Wendland",
"492984", "Hallenberg",
"4936783", "Gehren\ Thüringen",
"497083", "Bad\ Herrenalb",
"499392", "Faulbach\ Unterfranken",
"492401", "Baesweiler",
"496533", "Morbach\ Hunsrück",
"496271", "Eberbach\ Baden",
"496645", "Ulrichstein",
"499148", "Ettenstatt",
"494423", "Fedderwarden",
"4934342", "Neukieritzsch",
"4939602", "Kleeth",
"492922", "Werl",
"492265", "Reichshof\-Eckenhagen",
"495822", "Ebstorf",
"4939423", "Wegeleben",
"499906", "Mariaposching",
"4935751", "Welzow",
"4934978", "Radegast\ Kreis\ Köthen",
"494166", "Ahlerstedt",
"495553", "Kalefeld",
"498860", "Bernbeuren",
"499085", "Alerheim",
"497558", "Illmensee",
"493998", "Demmin",
"498557", "Mauth",
"495702", "Petershagen\-Lahde",
"4933203", "Kleinmachnow",
"492323", "Herne",
"494506", "Stockelsdorf\-Krumbeck",
"4933843", "Niemegk",
"494137", "Barendorf",
"4936377", "Rastenberg",
"498283", "Neuburg\ an\ der\ Kammel",
"4936459", "Blankenhain\ Thüringen",
"4936946", "Erbenhausen\ Thüringen",
"499256", "Stammbach",
"4939363", "Angern",
"4933433", "Buckow\ Märkische\ Schweiz",
"496776", "Dachsenhausen",
"4938853", "Drönnewitz\ bei\ Hagenow",
"4939975", "Thürkow",
"492934", "Sundern\-Altenhellefeld",
"497033", "Weil\ Der\ Stadt",
"4937754", "Zwönitz",
"496854", "Oberthal\ Saar",
"4934633", "Braunsbedra",
"497803", "Gengenbach",
"494927", "Krummhörn\-Loquard",
"495335", "Schladen",
"4938376", "Zirchow",
"4934222", "Arzberg\ bei\ Torgau",
"495808", "Gerdau",
"493491", "Lutherstadt\ Wittenberg",
"4935973", "Stolpen",
"496355", "Albisheim\ Pfrimm",
"4935365", "Falkenberg\ Elster",
"493771", "Aue\ Sachsen",
"498801", "Seeshaupt",
"494975", "Westerholt\ Ostfriesland",
"492581", "Warendorf",
"494671", "Bredstedt",
"4934954", "Roitzsch\ bei\ Bitterfeld",
"498226", "Bibertal",
"498031", "Rosenheim\ Oberbayern",
"494245", "Neuenkirchen\ bei\ Bassum",
"495834", "Wittingen\-Knesebeck",
"496058", "Gründau",
"493946", "Quedlinburg",
"497565", "Aichstetten\ Kreis\ Ravensburg",
"498721", "Eggenfelden",
"4934776", "Rothenschirmbach",
"4937347", "Bärenstein\ Kreis\ Annaberg",
"492132", "Meerbusch\-Büderich",
"499575", "Weismain",
"4939061", "Weferlingen",
"499527", "Knetzgau",
"4933760", "Münchehofe\ Kreis\ Dahme\-Spreewald",
"4933928", "Wildberg\ Brandenburg",
"494486", "Edewecht\-Friedrichsfehn",
"496039", "Karben",
"4936026", "Struth\ bei\ Mühlhausen",
"497723", "Furtwangen\ im\ Schwarzwald",
"4936464", "Wormstedt",
"499196", "Wiesenttal",
"495474", "Stemwede\-Dielingen",
"496809", "Grossrosseln",
"4938792", "Lenzen\ \(Elbe\)",
"498136", "Markt\ Indersdorf",
"4933452", "Neulewin",
"493863", "Crivitz",
"498507", "Neuburg\ am\ Inn",
"495503", "Nörten\-Hardenberg",
"492129", "Haan\ Rheinland",
"497685", "Gutach\-Bleibach",
"4936875", "Straufhain\-Streufdorf",
"4933733", "Stülpe",
"494830", "Süderhastedt",
"4939206", "Eichenbarleben",
"498274", "Buttenwiesen",
"496746", "Pfalzfeld",
"499956", "Eichendorf\-Aufhausen",
"497534", "Reichenau\ Baden",
"4937329", "Grosshartmannsdorf",
"499701", "Sandberg\ Unterfranken",
"4933366", "Chorin",
"498249", "Ettringen\ Wertach",
"492041", "Bottrop",
"49831", "Kempten\ Allgäu",
"492451", "Geilenkirchen",
"496022", "Obernburg\ am\ Main",
"4939723", "Krien",
"4935451", "Dahme\ Brandenburg",
"496732", "Wörrstadt",
"4937601", "Mülsen\ Skt\ Jacob",
"4936331", "Ilfeld",
"499091", "Monheim\ Schwaben",
"495865", "Gusborn",
"499206", "Mistelgau\-Obernsees",
"4933676", "Friedland\ bei\ Beeskow",
"496627", "Nentershausen\ Hessen",
"498142", "Olching",
"495426", "Glandorf",
"4939884", "Hassleben\ bei\ Prenzlau",
"496241", "Worms",
"496675", "Breitenbach\ am\ Herzberg",
"494556", "Ahrensbök\-Gnissau",
"499178", "Abenberg\ Mittelfranken",
"492222", "Bornheim\ Rheinland",
"492661", "Bad\ Marienberg\ Westerwald",
"495163", "Fallingbostel\-Dorfmark",
"495752", "Auetal\-Hattendorf",
"494351", "Eckernförde",
"498167", "Zolling",
"498382", "Lindau\ Bodensee",
"495364", "Velpke",
"496008", "Echzell",
"496838", "Saarwellingen",
"494882", "Lunden",
"4936764", "Neuhaus\-Schierschnitz",
"495054", "Bergen\-Sülze",
"498851", "Kochel\ am\ See",
"495444", "Wagenfeld",
"492958", "Büren\-Harth",
"496305", "Hochspeyer",
"4935725", "Wittichenau",
"493976", "Torgelow\ bei\ Ueckermünde",
"495858", "Hitzacker\-Wietzetze",
"496034", "Wöllstadt",
"497853", "Kehl\-Bodersweier",
"496804", "Mandelbachtal",
"499633", "Mitterteich",
"4937435", "Reuth\ bei\ Plauen",
"497522", "Wangen\ im\ Allgäu",
"499545", "Buttenheim",
"495483", "Lienen",
"492595", "Olfen",
"493741", "Plauen",
"494945", "Grossefehn\-Timmel",
"496724", "Stromberg\ Hunsrück",
"496478", "Greifenstein\-Ulm",
"492208", "Niederkassel",
"494641", "Süderbrarup",
"494275", "Ehrenburg",
"49481", "Heide\ Holstein",
"4934652", "Allstedt",
"4935604", "Krieschow",
"498330", "Legau",
"495839", "Wittingen\-Ohrdorf",
"492234", "Frechen",
"494263", "Scheessel",
"498332", "Ottobeuren",
"492866", "Dorsten\-Rhade",
"4939384", "Arendsee\ Altmark",
"492602", "Montabaur",
"492425", "Nideggen\-Embken",
"494704", "Drangstedt",
"496207", "Wald\-Michelbach",
"495966", "Meppen\-Apeldorn",
"499626", "Hohenburg",
"496574", "Hasborn",
"4935474", "Schönwalde\ bei\ Lübben",
"496782", "Birkenfeld\ Nahe",
"497520", "Bodnegg",
"499153", "Schnaittach",
"499354", "Rieneck",
"498541", "Vilshofen\ Niederbayern",
"4939977", "Jördenstorf",
"499762", "Saal\ an\ der\ Saale",
"497584", "Altshausen",
"495937", "Geeste\-Gross\ Hesepe",
"4939086", "Jävenitz",
"498346", "Pforzen",
"4936375", "Kindelbrück",
"499747", "Geroda\ Bayern",
"497931", "Bad\ Mergentheim",
"499855", "Dentlein\ am\ Forst",
"4934606", "Teicha\ Sachsen\-Anhalt",
"4936963", "Dorndorf\ Rhön",
"492837", "Weeze",
"4933393", "Gross\ Schönebeck\ Kreis\ Barnim",
"49671", "Bad\ Kreuznach",
"497543", "Kressbronn\ am\ Bodensee",
"4938332", "Gross\ Bisdorf",
"4939346", "Tucheim",
"494824", "Krempe",
"497635", "Schliengen",
"498380", "Achberg",
"495873", "Eimke",
"494792", "Worpswede",
"497459", "Nagold\-Hochdorf",
"495127", "Harsum",
"499868", "Schillingsfürst",
"4936483", "Ziegenrück",
"498324", "Hindelang",
"494607", "Janneby",
"493435", "Oschatz",
"498123", "Moosinning",
"492694", "Wershofen",
"4939772", "Rothemühl",
"494472", "Lastrup",
"492243", "Eitorf",
"497121", "Reutlingen",
"4937608", "Waldenburg\ Sachsen",
"4936338", "Bleicherode",
"492628", "Rhens",
"495175", "Lehrte\-Arpke",
"496663", "Steinau\ an\ der\ Strasse",
"492973", "Eslohe\ Sauerland",
"494846", "Hattstedt",
"498825", "Krün",
"4939924", "Stuer",
"498095", "Aying",
"498466", "Denkendorf\ Oberbayern",
"499683", "Friedenfels",
"496020", "Heigenbrücken",
"4933653", "Ziltendorf",
"495433", "Badbergen",
"496084", "Schmitten\ Taunus",
"498705", "Altfraunhofen",
"497669", "St\ Märgen",
"499293", "Berg\ Oberfranken",
"494832", "Meldorf",
"496888", "Lebach\-Steinbach",
"4939226", "Hohenziatz",
"492372", "Hemer",
"499644", "Pressath",
"497404", "Epfendorf",
"496043", "Nidda",
"498656", "Anger",
"496453", "Gemünden\ Wohra",
"497502", "Wolpertswende",
"49471", "Bremerhaven",
"499283", "Rehau",
"496094", "Weibersbrunn",
"496824", "Ottweiler",
"499279", "Mistelgau",
"494957", "Detern",
"493841", "Wismar",
"49361", "Erfurt",
"497269", "Sulzfeld\ Baden",
"499244", "Betzenstein",
"496325", "Lambrecht\ Pfalz",
"497964", "Stödtlen",
"4933834", "Pritzerbe",
"499974", "Traitsching",
"4938454", "Kritzkow",
"496028", "Sulzbach\ am\ Main",
"496898", "Völklingen",
"492684", "Puderbach\ Westerwald",
"498751", "Mainburg",
"4938845", "Kaarssen",
"495381", "Seesen",
"492620", "Neuhäusel\ Westerwald",
"497147", "Sachsenheim\ Württemberg",
"493682", "Zella\-Mehlis",
"492294", "Morsbach\ Sieg",
"4936622", "Triebes",
"494207", "Oyten",
"495586", "Wieda",
"4938205", "Tessin\ bei\ Rostock",
"498085", "Sankt\ Wolfgang",
"495141", "Celle",
"4939824", "Hohenzieritz",
"492643", "Altenahr",
"492228", "Remagen\-Rolandseck",
"496704", "Langenlonsheim",
"499172", "Georgensgmünd",
"492535", "Sendenhorst\-Albersloh",
"496263", "Neckargerach",
"497753", "Albbruck",
"498388", "Hergensweiler",
"4933768", "Prieros",
"497162", "Süssen",
"497387", "Hohenstein\ Württemberg",
"4933920", "Walsleben\ bei\ Neuruppin",
"496002", "Ober\-Mörlen",
"4933966", "Dranse",
"494453", "Zetel",
"495765", "Raddestorf",
"499721", "Schweinfurt",
"496832", "Beckingen\-Reimsbach",
"492952", "Rüthen",
"4939006", "Miesterhorst",
"495852", "Bleckede",
"498196", "Pürgen",
"497482", "Horb\-Dettingen",
"495523", "Bad\ Sachsa",
"497235", "Unterreichenbach\ Kreis\ Calw",
"497528", "Neukirch\ bei\ Tettnang",
"494663", "Süderlügum",
"492154", "Willich",
"4939741", "Jatznick",
"492353", "Halver",
"492202", "Bergisch\ Gladbach",
"496472", "Weilmünster",
"493763", "Glauchau",
"493525", "Riesa",
"495406", "Belm",
"49741", "Rottweil",
"493909", "Klötze\ Altmark",
"498805", "Hohenpeissenberg",
"494971", "Esens",
"4938309", "Trent",
"498338", "Böhen",
"496351", "Eisenberg\ Pfalz",
"497337", "Nellingen\ Alb",
"498035", "Raubling",
"492608", "Welschneudorf",
"494241", "Bassum",
"4939324", "Kläden\ bei\ Stendal",
"496556", "Pronsfeld",
"492585", "Warendorf\-Hoetmar",
"494627", "Dörpstedt",
"4939052", "Erxleben\ bei\ Haldensleben",
"493632", "Sondershausen",
"4939748", "Viereck",
"498304", "Wildpoldsried",
"495536", "Holzminden\-Neuhaus",
"492634", "Rengsdorf",
"496788", "Sien",
"494732", "Stadland\-Rodenkirchen",
"495331", "Wolfenbüttel",
"4938737", "Ganzlin",
"493727", "Mittweida",
"4933334", "Greiffenberg",
"494892", "Schenefeld\ Mittelholstein",
"495773", "Stemwede\-Wehdem",
"4934495", "Dobitschen",
"497424", "Spaichingen",
"498563", "Bad\ Birnbach\ Rottal",
"495850", "Neetze",
"499376", "Collenberg",
"495493", "Neuenkirchen\ Kreis\ Vechta",
"497561", "Leutkirch\ im\ Allgäu",
"498725", "Wurmannsquick",
"494746", "Hagen\ bei\ Bremerhaven",
"499571", "Lichtenfels\ Bayern",
"497366", "Abtsgmünd",
"499233", "Arzberg\ Oberfranken",
"495542", "Witzenhausen",
"4934745", "Winningen\ Sachsen\-Anhalt",
"4989", "Munich",
"4939244", "Steutz",
"499081", "Nördlingen",
"4936423", "Orlamünde",
"496227", "Walldorf\ Baden",
"499170", "Schwanstetten",
"497446", "Lossburg",
"499606", "Pfreimd",
"497056", "Gechingen",
"498392", "Markt\ Rettenbach",
"496641", "Lauterbach\ Hessen",
"4936602", "Ronneburg\ Thüringen",
"494724", "Cuxhaven\-Lüdingworth",
"4938225", "Trinwillershagen",
"494478", "Cappeln\ Oldenburg",
"492622", "Bendorf\ am\ Rhein",
"492405", "Würselen",
"49681", "Saarbrücken",
"496275", "Rothenberg\ Odenwald",
"494859", "Windbergen",
"492737", "Netphen\-Deuz",
"492261", "Gummersbach",
"499847", "Ergersheim",
"493624", "Ohrdruf",
"497432", "Albstadt\-Tailfingen",
"494804", "Nordhastedt",
"4939459", "Hasselfelde",
"492378", "Fröndenberg\-Langschede",
"494838", "Tellingstedt",
"496061", "Michelstadt",
"494305", "Westensee",
"498649", "Schleching",
"4936736", "Arnsgereuth",
"492587", "Ennigerloh\-Westkirchen",
"495033", "Wunstorf\-Grossenheidorn",
"4939821", "Carpin",
"4933963", "Wulfersdorf\ bei\ Wittstock",
"496420", "Lahntal",
"4939248", "Dobritz",
"497335", "Wiesensteig",
"495803", "Rosche",
"493563", "Spremberg",
"496484", "Beselich",
"498807", "Diessen\ am\ Ammersee",
"4935792", "Ossling",
"497808", "Hohberg\ bei\ Offenburg",
"494921", "Emden\ Stadt",
"493725", "Zschopau",
"4939003", "Jübar",
"499654", "Pleystein",
"496592", "Daun",
"492903", "Meschede\-Freienohl",
"496053", "Wächtersbach",
"495105", "Barsinghausen",
"494402", "Rastede",
"494625", "Jübek",
"497834", "Wolfach",
"496443", "Ehringshausen\ Dill",
"499326", "Markt\ Einersheim",
"495565", "Einbeck\-Wenzen",
"493338", "Bernau\ Brandenburg",
"497449", "Baiersbronn\-Obertal",
"4933831", "Weseram",
"499521", "Hassfurt",
"4938451", "Hoppenrade\ bei\ Güstrow",
"492253", "Bad\ Münstereifel",
"499464", "Walderbach",
"493304", "Velten",
"498066", "Bad\ Feilnbach",
"495723", "Bad\ Nenndorf",
"494856", "Kronprinzenkoog",
"498727", "Falkenberg\ Niederbayern",
"492302", "Witten",
"497728", "Niedereschach",
"497474", "Haigerloch",
"494774", "Hechthausen",
"4938725", "Gross\ Godems",
"499143", "Pappenheim\ Mittelfranken",
"499344", "Gerchsheim",
"498551", "Freyung",
"492672", "Treis\-Karden",
"4939328", "Rochau",
"4934465", "Bad\ Bibra",
"499184", "Deining\ Oberpfalz",
"497822", "Ettenheim",
"499845", "Oberdachstetten",
"4936653", "Lehesten\ Thüringer\ Wald",
"4939744", "Rothenklempenow",
"494749", "Schiffdorf\-Geestenseth",
"496504", "Thalfang",
"492735", "Neunkirchen\ Siegerl",
"499383", "Wiesentheid",
"499120", "Leinburg",
"494494", "Bösel\ Oldenburg",
"49991", "Deggendorf",
"492407", "Herzogenrath\-Kohlscheid",
"497553", "Salem\ Baden",
"4934325", "Mochau\-Lüttewitz",
"4933338", "Stolpe\/Oder",
"497702", "Blumberg\ Baden",
"49451", "Lübeck",
"496164", "Reichelsheim\ Odenwald",
"496559", "Leidenborn",
"496363", "Niederkirchen",
"494131", "Lüneburg",
"4935389", "Holzdorf\ Elster",
"495281", "Bad\ Pyrmont",
"492394", "Neuenrade\-Affeln",
"494307", "Raisdorf",
"498624", "Obing",
"492193", "Dabringhausen",
"495691", "Bad\ Arolsen",
"4935025", "Liebstadt",
"496849", "Kirkel",
"496375", "Wallhalben",
"498292", "Dinkelscherben",
"492566", "Legden",
"494955", "Westoverledingen",
"495664", "Morschen",
"499924", "Bodenmais",
"498682", "Laufen\ Salzach",
"4936426", "Ottendorf\ bei\ Stadtroda",
"492361", "Recklinghausen",
"496078", "Gross\-Umstadt",
"4933331", "Casekow",
"4934297", "Liebertwolkwitz",
"496874", "Wadern\-Nunkirchen",
"499229", "Mainleus",
"495409", "Hilter\ am\ Teutoburger\ Wald",
"496327", "Neustadt\-Lachen",
"494205", "Ottersberg",
"499122", "Schwabach",
"496408", "Buseck",
"497145", "Markgröningen",
"495044", "Springe\-Eldagsen",
"498841", "Murnau\ am\ Staffelsee",
"49861", "Traunstein",
"495454", "Hörstel\-Riesenbeck",
"492948", "Lippstadt\-Rebbeke",
"494461", "Jever",
"497385", "Gomadingen",
"495848", "Trebel",
"494524", "Scharbeutz\-Pönitz",
"497843", "Renchen",
"496434", "Bad\ Camberg",
"4936452", "Berlstedt",
"495083", "Hohne\ bei\ Celle",
"4939321", "Arneburg",
"4936733", "Kaulsdorf",
"499555", "Schlüsselfeld\-Aschbach",
"4933875", "Rhinow",
"499491", "Hemau",
"498204", "Mickhausen",
"499932", "Osterhofen",
"499568", "Neustadt\ bei\ Coburg",
"4939857", "Drense",
"495573", "Uslar\-Volpriehausen",
"494181", "Buchholz\ in\ der\ Nordheide",
"495767", "Warmsen",
"495231", "Detmold",
"498152", "Herrsching\ am\ Ammersee",
"495026", "Steimbke",
"497578", "Wald\ Hohenz",
"498630", "Oberneukirchen",
"498238", "Gessertshausen",
"497761", "Bad\ Säckingen",
"496251", "Bensheim",
"497237", "Neulingen\ Enzkreis",
"494546", "Mustin\ Lauenburg",
"499771", "Bad\ Neustadt\ an\ der\ Saale",
"4933838", "Päwesin",
"495742", "Preussisch\ Oldendorf",
"4938458", "Zehna",
"499276", "Bischofsgrün",
"499134", "Neunkirchen\ am\ Brand",
"4938427", "Blowatz",
"497266", "Kirchardt",
"496756", "Winterbach\ Soonwald",
"499946", "Hohenwarth\ bei\ Kötzing",
"499333", "Sommerhausen",
"4939828", "Wustrow\ Kreis\ Mecklenburg\-Strelitz",
"4939241", "Leitzkau",
"496422", "Kirchhain",
"498259", "Schiltberg",
"492051", "Velbert",
"4937292", "Oederan",
"492441", "Kall",
"496588", "Pluwig",
"4933764", "Mittenwalde\ Mark",
"494968", "Neulehe",
"494532", "Bargteheide",
"4939881", "Ringenwalde\ bei\ Templin",
"496580", "Zemmer",
"492427", "Nideggen",
"499676", "Winklarn",
"493541", "Calau",
"497032", "Herrenberg",
"496524", "Rodershausen",
"497802", "Oberkirch\ Baden",
"497666", "Denzlingen",
"494434", "Colnrade",
"493346", "Seelow",
"493933", "Genthin",
"4935454", "Uckro",
"496461", "Biedenkopf",
"4937604", "Mosel",
"4936334", "Wolkramshausen",
"496205", "Hockenheim",
"4939928", "Möllenhagen",
"494408", "Hude\ Oldenburg",
"4935205", "Ottendorf\-Okrilla",
"493332", "Schwedt\/Oder",
"495935", "Twist\-Schöninghsdorf",
"494327", "Grossenaspe",
"494191", "Kaltenkirchen\ Holstein",
"495631", "Korbach",
"492133", "Dormagen",
"4939957", "Gielow",
"497456", "Haiterbach",
"497046", "Zaberfeld",
"492334", "Hagen\-Hohenlimburg",
"499481", "Pfatter",
"498230", "Gablingen",
"494874", "Todenbüttel",
"496651", "Rasdorf",
"498638", "Waldkraiburg",
"497570", "Sigmaringen\-Gutenstein",
"4934925", "Bad\ Schmiedeberg",
"494849", "Hooge",
"492835", "Issum",
"4935435", "Gollmitz\ bei\ Calau",
"499560", "Grub\ am\ Forst",
"4935249", "Basslitz",
"499857", "Schopfloch\ Mittelfranken",
"498469", "Freystadt\-Burggriesbach",
"497722", "Triberg\ im\ Schwarzwald",
"499745", "Wildflecken",
"492308", "Unna\-Hemmerde",
"497171", "Schwäbisch\ Gmünd",
"4938785", "Berge\ bei\ Perleberg",
"494422", "Sande\ Kreis\ Friesl",
"494605", "Medelby",
"493437", "Grimma",
"492678", "Büchel\ bei\ Cochem",
"496532", "Zeltingen\-Rachtig",
"4935601", "Peitz",
"492923", "Lippetal\-Herzfeld",
"4939388", "Goldbeck\ Altm",
"499161", "Neustadt\ an\ der\ Aisch",
"497024", "Wendlingen\ am\ Neckar",
"498349", "Stötten\ am\ Auerberg",
"495840", "Schnackenburg",
"4939203", "Barleben",
"49821", "Augsburg",
"4933975", "Dannenwalde\ Kreis\ Prignitz",
"495823", "Bienenbüttel",
"4933363", "Altenhof\ Kreis\ Barnim",
"494756", "Odisheim",
"495177", "Edemissen\-Abbensen",
"498374", "Dietmannsried",
"496400", "Mücke",
"495552", "Katlenburg",
"4935478", "Goyatz",
"497395", "Ehingen\-Dächingen",
"4939752", "Blumenhagen\ bei\ Strasburg",
"497708", "Geisingen\-Leipferdingen",
"4939726", "Ducherow",
"4934385", "Mutzschen",
"498707", "Adlkofen",
"493877", "Wittenberge",
"495703", "Hille",
"496341", "Landau\ in\ der\ Pfalz",
"4933602", "Alt\ Zeschdorf",
"494251", "Hoya",
"498282", "Krumbach\ Schwaben",
"4933673", "Weichensdorf",
"495264", "Kalletal",
"4936695", "Söllmnitz",
"498435", "Ehekirchen",
"497734", "Gailingen",
"4935329", "Dollenchen",
"496181", "Hanau",
"4936761", "Heubisch",
"499306", "Kist",
"493466", "Artern\ Unstrut",
"496856", "St\ Wendel\-Niederkirchen",
"4936920", "Grossenlupnitz",
"498505", "Hutthurm",
"4933472", "Golzow\ bei\ Seelow",
"495681", "Homberg\ Efze",
"492183", "Rommerskirchen",
"4938292", "Kröpelin",
"4936259", "Tabarz\ Thüringer\ Wald",
"499431", "Schwandorf",
"492384", "Welver",
"4933233", "Ketzin",
"495836", "Wittingen\-Radenbeck",
"493382", "Lehnin",
"498224", "Offingen\ Donau",
"4938750", "Malliss",
"494443", "Dinklage",
"493944", "Blankenburg\ Harz",
"492272", "Bedburg\ Erft",
"496625", "Niederaula",
"4933656", "Bahro",
"499128", "Feucht",
"496402", "Hungen",
"4935471", "Birkenhainchen",
"492942", "Geseke",
"4937367", "Lengefeld\ Erzgebirge",
"498165", "Neufahrn\ bei\ Freising",
"495842", "Schnega",
"4939223", "Theessen",
"4935608", "Gross\ Ossnig",
"499871", "Windsbach",
"494484", "Hude\-Wüsting",
"49331", "Potsdam",
"499393", "Rothenfels\ Unterfranken",
"495476", "Ostercappeln\-Venne",
"496677", "Neuenstein\ Hessen",
"499194", "Ebermannstadt",
"497082", "Neuenbürg\ Württemberg",
"497720", "Schwenningen\ am\ Neckar",
"496307", "Schopp",
"4934362", "Mügeln\ bei\ Oschatz",
"498741", "Vilsbiburg",
"499938", "Moos\ Niederbayern",
"4933931", "Rheinsberg\ Mark",
"499562", "Sonnefeld",
"498158", "Tutzing",
"495429", "Melle\-Wellingholzhausen",
"4935829", "Gersdorf\ bei\ Görlitz",
"497157", "Waldenbuch",
"499209", "Emtmannsberg",
"4934905", "Wörlitz",
"496131", "Mainz",
"497572", "Mengen\ Württemberg",
"494164", "Harsefeld",
"4933094", "Löwenberg",
"4936647", "Saalburg\ Thüringen",
"499547", "Zapfendorf",
"495151", "Hameln",
"498232", "Schwabmünchen",
"492653", "Kaisersesch",
"494559", "Wensin",
"494363", "Lensahn",
"499904", "Lalling",
"49651", "Trier",
"497743", "Ühlingen\-Birkendorf",
"494277", "Schwaförden",
"498139", "Röhrmoos",
"4935932", "Guttau",
"494947", "Aurich\-Ogenbargen",
"4934422", "Osterfeld",
"4939921", "Ankershagen",
"494504", "Ratekau",
"492597", "Senden\ Westfalen",
"4939083", "Messdorf",
"4934603", "Nauendorf\ Sachsen\-Anhalt",
"499254", "Gefrees",
"4939888", "Lychen",
"4933396", "Klosterfelde",
"4936966", "Kaltennordheim",
"492463", "Titz",
"498246", "Waal",
"496428", "Stadtallendorf",
"499102", "Wilhermsdorf",
"496774", "Kaub",
"4934672", "Rossleben",
"496582", "Freudenburg",
"494962", "Papenburg\-Aschendorf",
"4939343", "Jerichow",
"494121", "Elmshorn",
"492304", "Schwerte",
"497472", "Rottenburg\ am\ Neckar",
"495086", "Celle\-Scheuen",
"495529", "Rhumspringe",
"495601", "Schauenburg",
"492103", "Hilden",
"495905", "Beesten",
"499462", "Falkenstein\ Oberpfalz",
"493302", "Hennigsdorf",
"498634", "Garching\ an\ der\ Alz",
"4935362", "Schönewalde\ bei\ Herzberg",
"4933238", "Senzke",
"4939777", "Borkenfriede",
"492338", "Breckerfeld",
"4933671", "Lieberose",
"49641", "Giessen",
"4935456", "Terpt",
"498585", "Grainet",
"4936336", "Klettenberg",
"4937606", "Lengenfeld\ Vogtland",
"499447", "Essing",
"494404", "Elsfleth",
"497832", "Haslach\ im\ Kinzigtal",
"492725", "Lennestadt\-Oedingen",
"495255", "Altenbeken",
"4933361", "Joachimsthal",
"496594", "Birresborn",
"499652", "Waidhaus",
"496482", "Runkel",
"496235", "Schifferstadt",
"4939201", "Wolmirstedt",
"492563", "Stadtlohn",
"492359", "Kierspe",
"492777", "Breitscheid\ Hessen",
"4935603", "Burg\ Spreewald",
"498622", "Tacherting\-Peterskirchen",
"498405", "Stammham\ bei\ Ingolstadt",
"496147", "Trebur",
"4933734", "Felgentreu",
"492392", "Werdohl",
"49911", "Nuremberg",
"499920", "Bischofsmais",
"495733", "Vlotho",
"493394", "Wittstock\ Dosse",
"498261", "Mindelheim",
"497738", "Steisslingen",
"497263", "Waibstadt",
"496753", "Meisenheim",
"4936200", "Elxleben\ bei\ Arnstadt",
"499943", "Lam\ Oberpfalz",
"499336", "Bütthard",
"4939605", "Gross\ Nemerow",
"493328", "Teltow",
"496387", "Sankt\ Julian",
"496162", "Reinheim\ Odenwald",
"499273", "Bad\ Berneck\ im\ Fichtelgebirge",
"4936840", "Trusetal",
"499531", "Ebern",
"499289", "Schwarzenbach\ am\ Wald",
"4934345", "Bad\ Lausick",
"497704", "Geisingen\ Baden",
"494931", "Norden",
"493735", "Marienberg\ Sachsen",
"495195", "Neuenkirchen\ bei\ Soltau",
"494492", "Saterland",
"4939972", "Walkendorf",
"4939088", "Letzlingen",
"498378", "Buchenberg\ bei\ Kempten",
"496269", "Gundelsheim\ Württemberg",
"494543", "Nusse",
"4939724", "Klein\ Bünzow",
"498075", "Amerang",
"496502", "Schweich",
"494635", "Sörup",
"499367", "Unterpleichfeld",
"499182", "Velburg",
"497824", "Schwanau",
"492993", "Marsberg\-Canstein",
"493672", "Rudolstadt",
"495023", "Liebenau\ Kreis\ Nieburg\ Weser",
"498766", "Gammelsdorf",
"496430", "Hahnstätten",
"4939348", "Klitsche",
"498027", "Dietramszell",
"499342", "Wertheim",
"4939883", "Gross\ Dölln",
"497325", "Sontheim\ an\ der\ Brenz",
"492674", "Bad\ Bertrich",
"495371", "Gifhorn",
"494772", "Oberndorf\ Oste",
"499198", "Heiligenstadt\ in\ Oberfranken",
"494770", "Wischhafen",
"496695", "Jesberg",
"4936484", "Knau\ bei\ Pössneck",
"495067", "Bockenem",
"499340", "Königheim\-Brehmen",
"498063", "Feldkirchen\-Westerham",
"4933635", "Arensdorf\ Kreis\ Oder\-Spree",
"495726", "Wiedensahl",
"4939341", "Redekin",
"494853", "Sankt\ Michaelisdonn",
"496432", "Diez",
"494488", "Westerstede",
"4934601", "Teutschenthal",
"496285", "Walldürn\-Altheim",
"492256", "Mechernich\-Satzvey",
"493537", "Jessen\ Elster",
"494522", "Plön",
"495452", "Mettingen\ Westfalen",
"499180", "Pyrbaum",
"499071", "Dillingen\ an\ der\ Donau",
"4939923", "Priborn",
"495042", "Bad\ Münder\ am\ Deister",
"496500", "Waldrach",
"494155", "Büchen",
"4939081", "Kakerbeck\ Sachsen\-Anhalt",
"4938729", "Marnitz",
"499323", "Iphofen",
"495647", "Lichtenau\-Kleinenberg",
"497227", "Lichtenau\ Baden",
"498535", "Haarbach",
"496446", "Hohenahr",
"496056", "Bad\ Soden\-Salmünster",
"496872", "Losheim\ am\ See",
"492388", "Hamm\-Uentrop",
"4933654", "Fünfeichen",
"4935385", "Annaburg",
"492751", "Bad\ Berleburg",
"497945", "Wüstenrot",
"495662", "Felsberg\ Hessen",
"499922", "Zwiesel",
"498684", "Fridolfing",
"499265", "Pressig",
"495806", "Barum\ bei\ Bad\ Bevensen",
"498294", "Horgau",
"493361", "Fürstenwalde\ Spree",
"499401", "Neutraubling",
"497641", "Emmendingen",
"495221", "Herford",
"495036", "Neustadt\-Schneeren",
"49781", "Offenburg",
"4933933", "Lindow\ Mark",
"497275", "Kandel",
"4933457", "Altreetz",
"4938797", "Karstädt\ Kreis\ Prignitz",
"4939383", "Sandau\ Elbe",
"492196", "Wermelskirchen",
"494534", "Steinburg\ Kreis\ Storman",
"496424", "Ebsdorfergrund",
"4939208", "Loitsche",
"492527", "Lippetal\-Lippborg",
"493441", "Zeitz",
"4939221", "Möckern\ bei\ Magdeburg",
"494508", "Krummesse",
"492575", "Greven\-Reckenfeld",
"4935473", "Neu\ Lübbenau",
"499132", "Herzogenaurach",
"494295", "Emtinghausen",
"496561", "Bitburg",
"4933368", "Hohensaaten",
"495744", "Hüllhorst",
"4933231", "Pausin",
"4933678", "Storkow\ Mark",
"496101", "Bad\ Vilbel",
"493996", "Teterow",
"497556", "Uhldingen\-Mühlhofen",
"499908", "Schöfweg",
"499386", "Prosselsheim",
"4934205", "Markranstädt",
"497351", "Biberach\ an\ der\ Riss",
"496337", "Grossbundenbach",
"494168", "Neu\ Wulmstorf\-Elstorf",
"495357", "Grasleben",
"4936964", "Dermbach\ Rhön",
"498202", "Althegnenberg",
"4933394", "Blumberg\ Kreis\ Barnim",
"499146", "Markt\ Berolzheim",
"497724", "St\ Georgen\ im\ Schwarzwald",
"497478", "Hirrlingen",
"499396", "Urspringen\ bei\ Lohr",
"495473", "Ostercappeln",
"499639", "Mähring",
"499468", "Zell\ Oberpfalz",
"4936607", "Niederpöllnitz",
"492332", "Gevelsberg",
"494872", "Hanerau\-Hademarschen",
"4935825", "Kodersdorf",
"4934909", "Aken\ Elbe",
"493334", "Eberswalde",
"494446", "Bakum\ Kreis\ Vechta",
"4939390", "Iden",
"497838", "Nordrach",
"495833", "Brome",
"497305", "Erbach\ Donau",
"4936651", "Lobenstein",
"499658", "Georgenberg",
"496155", "Griesheim\ Hessen",
"493475", "Lutherstadt\ Eisleben",
"497804", "Oppenau",
"492541", "Coesfeld",
"494432", "Dötlingen\-Brettorf",
"495135", "Burgwedel\-Fuhrberg",
"496522", "Mettendorf",
"4936738", "Königsee",
"494285", "Rhade\ bei\ Zeven",
"492933", "Sundern\ Sauerland",
"497034", "Ehningen",
"496853", "Marpingen",
"497627", "Steinen\ Kreis\ Lörrach",
"495247", "Harsewinkel",
"498628", "Kienberg\ Oberbayern",
"498243", "Fuchstal",
"492825", "Uedem",
"495977", "Spelle",
"497732", "Radolfzell\ am\ Bodensee",
"4936255", "Goldbach\ bei\ Gotha",
"4933833", "Wollin\ bei\ Brandenburg",
"497971", "Gaildorf",
"4939057", "Rätzlingen\ Sachsen\-Anhalt",
"494337", "Jevenstedt",
"495925", "Wietmarschen",
"499665", "Königstein\ Oberpfalz",
"4938453", "Mistorf",
"493322", "Falkensee",
"498284", "Ziemetshausen",
"495262", "Extertal",
"499961", "Mitterfels",
"495621", "Bad\ Wildungen",
"495509", "Rosdorf\ Kreis\ Göttingen",
"497675", "Bernau\ Baden",
"493869", "Dümmer",
"4939746", "Krackow",
"494101", "Pinneberg",
"492324", "Hattingen\ Ruhr",
"4938732", "Gallin\ bei\ Lübz",
"495554", "Moringen",
"496295", "Rosenberg\ Baden",
"494561", "Neustadt\ in\ Holstein",
"498372", "Obergünzburg",
"497746", "Wutöschingen",
"494498", "Saterland\-Ramsloh",
"4939001", "Apenburg",
"496508", "Hetzerath\ Mosel",
"494366", "Grömitz\-Cismar",
"492656", "Virneburg",
"499188", "Postbauer\-Heng",
"497022", "Nürtingen",
"494480", "Ovelgönne\-Strückhausen",
"496534", "Mülheim\ Mosel",
"4939823", "Rechlin",
"499348", "Werbach\-Gamburg",
"493923", "Zerbst",
"494778", "Wingst",
"499190", "Heroldsbach",
"492983", "Winterberg\-Siedlinghausen",
"4936424", "Kahla\ Thüringen",
"499192", "Gräfenberg",
"497084", "Schömberg\ bei\ Neuenbürg",
"496669", "Neuhof\-Hauswurz",
"494482", "Hatten",
"496438", "Hünfelden",
"4933968", "Meyenburg\ Kreis\ Prignitz",
"495185", "Duingen",
"494528", "Schönwalde\ am\ Bungsberg",
"493967", "Oertzenhof\ bei\ Strasburg",
"4933979", "Wusterhausen\ Dosse",
"495844", "Clenze",
"4939243", "Nedlitz\ bei\ Zerbst",
"498041", "Bad\ Tölz",
"494235", "Langwedel\-Etelsen",
"49231", "Dortmund",
"497043", "Maulbronn",
"492944", "Rietberg\-Mastholte",
"495458", "Hopsten",
"49214", "Leverkusen",
"497453", "Altensteig\ Württemberg",
"492507", "Havixbeck",
"4939008", "Kunrau",
"498370", "Wiggensbach",
"495345", "Baddeckenstedt",
"492274", "Elsdorf\ Rheinland",
"496404", "Lich\ Hessen",
"495883", "Lemgow",
"4935032", "Langenhennersdorf",
"4938789", "Wolfshagen\ bei\ Perleberg",
"498222", "Burgau\ Schwaben",
"496049", "Kefenrod",
"492382", "Ahlen\ Westfalen",
"4935325", "Rückersdorf\ bei\ Finsterwalde",
"498661", "Grabenstätt\ Chiemsee",
"49441", "Oldenburg",
"496074", "Rödermark",
"4934262", "Falkenhain\ bei\ Wurzen",
"497663", "Eichstetten",
"4936940", "Oepfershausen",
"499928", "Kirchdorf\ im\ Wald",
"495439", "Bersenbrück",
"496397", "Leimen\ Pfalz",
"499673", "Tiefenbach\ Oberpfalz",
"499303", "Eibelstadt",
"494964", "Rhede\ Ems",
"496584", "Wellen\ Mosel",
"4939323", "Schönhausen\ Elbe",
"495951", "Werlte",
"4936731", "Unterloquitz",
"499104", "Emskirchen",
"496772", "Nastätten",
"499252", "Helmbrechts",
"4938370", "Kröslin",
"495655", "Wanfried",
"49771", "Donaueschingen",
"494502", "Lübeck\-Travemünde",
"496543", "Büchenbeuren",
"496635", "Kirtorf",
"495706", "Porta\ Westfalica",
"497957", "Kressberg",
"494269", "Ahausen\-Kirchwalsede",
"492851", "Rees",
"4935245", "Burkhardswalde\-Munzig",
"4938392", "Sassnitz",
"498176", "Egling\ bei\ Wolfratshausen",
"495201", "Halle\ Westfalen",
"4935439", "Zinnitz",
"499421", "Straubing",
"495826", "Suderburg",
"4933333", "Tantow",
"494753", "Balje",
"4934929", "Straach",
"495465", "Neuenkirchen\ bei\ Bramsche",
"494162", "Jork",
"498234", "Bobingen",
"492330", "Herdecke",
"4936020", "Ebeleben",
"497574", "Gammertingen",
"4933766", "Teupitz",
"499564", "Bad\ Rodach",
"4935209", "Mohorn",
"498208", "Eurasburg\ bei\ Augsburg",
"494237", "Bendingbostel",
"498179", "Eurasburg\ an\ der\ Loisach",
"495754", "Extertal\-Bremke",
"494761", "Bremervörde",
"498384", "Röthenbach\ Allgäu",
"493965", "Burow\ bei\ Altentreptow",
"495362", "Wolfsburg\-Fallersleben",
"495187", "Delligsen",
"4939852", "Schönermark\ bei\ Prenzlau",
"497546", "Oberteuringen",
"496708", "Bad\ Münster\ am\ Stein\-Ebernburg",
"495829", "Wriedel",
"498320", "Missen\-Wilhams",
"492224", "Bad\ Honnef",
"493661", "Greiz",
"498343", "Aitrang",
"4933836", "Butzow\ bei\ Brandenburg",
"495347", "Burgdorf\ bei\ Salzgitter",
"4938456", "Langhagen\ bei\ Güstrow",
"498144", "Grafrath",
"492505", "Altenberge\ Westfalen",
"496734", "Flonheim",
"497181", "Schorndorf\ Württemberg",
"4939743", "Zerrenthin",
"499156", "Neuhaus\ an\ der\ Pegnitz",
"492688", "Kroppach",
"496894", "St\ Ingbert",
"496024", "Schöllkrippen",
"499978", "Schönthal\ Oberpfalz",
"492165", "Jüchen",
"496171", "Oberursel\ Taunus",
"495963", "Bawinkel",
"4939400", "Wefensleben",
"4938422", "Neukloster",
"497532", "Meersburg",
"4937349", "Scheibenberg",
"498272", "Wertingen",
"492863", "Velen",
"496395", "Münchweiler\ an\ der\ Rodalb",
"4939826", "Blankensee\ bei\ Neustrelitz",
"4937297", "Thum\ Sachsen",
"494266", "Brockel",
"4936428", "Stadtroda",
"495657", "Meissner",
"492485", "Schleiden\-Dreiborn",
"496456", "Haina\ Kloster",
"496046", "Ortenberg\ Hessen",
"4933080", "Marienthal\ Kreis\ Oberhavel",
"492232", "Brühl\ Rheinland",
"4933964", "Fretzdorf",
"492741", "Betzdorf",
"4934292", "Brandis\ bei\ Wurzen",
"496722", "Rüdesheim\ am\ Rhein",
"497955", "Wallhausen\ Württemberg",
"499831", "Gunzenhausen",
"496637", "Feldatal",
"497651", "Titisee\-Neustadt",
"4939004", "Köckte\ bei\ Gardelegen",
"495436", "Nortrup",
"492158", "Grefrath\ bei\ Krefeld",
"497524", "Bad\ Waldsee",
"498463", "Greding",
"494385", "Hohenfelde\ bei\ Kiel",
"496802", "Völklingen\-Lauterbach",
"499350", "Eussenheim\-Hundsbach",
"495467", "Voltlage",
"496666", "Freiensteinau",
"494843", "Viöl",
"4936379", "Holzengel",
"492246", "Lohmar\ Rheinland",
"496032", "Bad\ Nauheim",
"495442", "Barnstorf\ Kreis\ Diepholz",
"494884", "Schwabstedt",
"499471", "Burglengenfeld",
"495052", "Hermannsburg",
"497461", "Tuttlingen",
"495593", "Bovenden\-Lenglern",
"4934785", "Sandersleben",
"494822", "Kellinghusen",
"495166", "Walsrode\-Kirchboitzen",
"4937439", "Jocketa",
"494553", "Geschendorf",
"498427", "Wellheim",
"497774", "Eigeltingen",
"497428", "Rosenfeld",
"499203", "Neudrossenfeld",
"497582", "Bad\ Buchau",
"495423", "Versmold",
"499352", "Lohr\ am\ Main",
"499764", "Höchheim",
"4937209", "Einsiedel\ bei\ Chemnitz",
"496784", "Weierbach",
"496157", "Pfungstadt",
"497131", "Heilbronn\ Neckar",
"496572", "Manderscheid\ Eifel",
"4933055", "Kremmen",
"492638", "Waldbreitbach",
"497307", "Senden\ Iller",
"4933336", "Passow\ Kreis\ Uckermark",
"495301", "Lehre\-Essenrode",
"49751", "Ravensburg",
"494702", "Sandstedt",
"4936421", "Camburg",
"496743", "Bacharach",
"499953", "Pilsting",
"492604", "Nassau\ Lahn",
"4933763", "Bestensee",
"494287", "Heeslingen\-Boitzen",
"495506", "Adelebsen",
"498334", "Bad\ Grönenbach",
"495137", "Seelze",
"498133", "Haimhausen\ Oberbayern",
"493425", "Wurzen",
"493866", "Cambs",
"4935267", "Diesbar\-Seusslitz",
"49906", "Donauwörth",
"495975", "Rheine\-Mesum",
"493372", "Jüterbog",
"492827", "Goch\-Hassum",
"495671", "Hofgeismar",
"492173", "Langenfeld\ Rheinland",
"4939246", "Lindau\ Anh",
"494834", "Büsum",
"4937325", "Niederbobritzsch",
"495245", "Herzebrock\-Clarholz",
"4938232", "Zingst\ Ostseebad",
"492374", "Iserlohn\-Letmathe",
"4935797", "Schwepnitz",
"497625", "Zell\ im\ Wiesental",
"499642", "Kemnath\ Stadt",
"497402", "Fluorn\-Winzeln",
"498678", "Marktl",
"49228", "Bonn",
"496082", "Niederreifenberg",
"496861", "Merzig",
"494335", "Hohn\ bei\ Rendsburg",
"49221", "Cologne",
"493628", "Arnstadt",
"499636", "Plössberg",
"4933200", "Bergholz\-Rehbrücke",
"497072", "Gomaringen",
"4937465", "Tannenbergsthal\ Vogtland",
"493973", "Pasewalk",
"494474", "Garrel",
"496297", "Ravenstein\ Baden",
"492692", "Kelberg",
"494794", "Worpswede\-Ostersode",
"4936734", "Leutenberg",
"498322", "Oberstdorf",
"492435", "Erkelenz\-Lövenich",
"4938850", "Gammelin",
"498869", "Kinsau",
"495368", "Parsau",
"493535", "Herzberg\ Elster",
"497164", "Boll\ Kreis\ Göppingen",
"496287", "Limbach\ Baden",
"493643", "Weimar\ Thüringen",
"497363", "Lauchheim",
"499236", "Nagel",
"4939204", "Niederndodeleben",
"494743", "Langen\ bei\ Bremerhaven",
"499174", "Hilpoltstein",
"499373", "Amorbach",
"495065", "Sibbesse",
"4938229", "Bad\ Sülze",
"496697", "Willingshausen",
"492292", "Windeck\ Sieg",
"4936642", "Harra",
"495776", "Preussisch\ Ströhen",
"4938825", "Klütz",
"498361", "Nesselwang",
"499149", "Weissenburg\-Suffersheim",
"492682", "Hamm\ Sieg",
"4933364", "Gross\ Ziethen\ Kreis\ Barnim",
"4933674", "Trebatsch",
"495941", "Neuenhaus\ Dinkel",
"4935937", "Prischwitz",
"499972", "Waldmünchen",
"4938482", "Warin",
"495271", "Höxter",
"495533", "Bodenwerder",
"499242", "Gössweinstein",
"498537", "Bad\ Füssing\-Aigen",
"497225", "Gaggenau",
"495645", "Borgentreich\-Borgholz",
"498670", "Reischach\ Kreis\ Altötting",
"497962", "Fichtenau",
"498106", "Vaterstetten",
"497277", "Wörth\-Büchelberg",
"496553", "Schönecken",
"4939455", "Schierke",
"49261", "Koblenz\ am\ Rhein",
"496092", "Heimbuchenthal",
"499267", "Nordhalben",
"4939886", "Milmersdorf",
"497947", "Forchtenberg",
"4936968", "Rossdorf\ Rhön",
"497504", "Horgenzell",
"4933398", "Werneuchen",
"492841", "Moers",
"496449", "Ehringshausen\-Katzenfurt",
"4936766", "Schalkau",
"492238", "Pulheim",
"4937422", "Markneukirchen",
"492525", "Beckum\-Neubeckum",
"496059", "Jossgrund",
"4933477", "Trebnitz\ bei\ Müncheberg",
"4938297", "Moitin",
"4935892", "Horka\ OL",
"49395", "Neubrandenburg",
"492204", "Bensberg",
"494297", "Ottersberg\-Posthausen",
"496728", "Ober\-Hilbersheim",
"496474", "Villmar\-Aumenau",
"492630", "Mülheim\-Kärlich",
"4939721", "Liepen\ bei\ Anklam",
"492763", "Drolshagen\-Bleche",
"4935453", "Drahnsdorf",
"4937603", "Wildenfels",
"4938305", "Gingst",
"4936333", "Heringen\ Helme",
"492152", "Kempen",
"496335", "Trulben",
"497484", "Simmersfeld",
"498441", "Pfaffenhofen\ an\ der\ Ilm",
"494861", "Tönning",
"497420", "Deisslingen",
"4939030", "Brunau",
"4937362", "Seiffen\ Erzgebirge",
"495854", "Bleckede\-Barskamp",
"498051", "Prien\ am\ Chiemsee",
"497053", "Bad\ Teinach\-Zavelstein",
"4933731", "Trebbin",
"495448", "Barver",
"492954", "Rüthen\-Oestereiden",
"496834", "Bous",
"499603", "Floss",
"497443", "Dornstetten",
"495355", "Frellstedt",
"498785", "Rottenburg\-Oberroning",
"496004", "Lich\-Eberstadt",
"4935606", "Briesen\ bei\ Cottbus",
"495544", "Reinhardshagen",
"494828", "Lägerdorf",
"4939386", "Seehausen\ Altmark",
"496266", "Hassmersheim",
"495907", "Geeste",
"492646", "Königsfeld\ Eifel",
"499445", "Neustadt\ an\ der\ Donau",
"497422", "Schramberg",
"494171", "Winsen\ Luhe",
"495583", "Braunlage\-Hohegeiss",
"4935476", "Wittmannsdorf\-Bückchen",
"4933093", "Fürstenberg\ Havel",
"499358", "Gössenheim",
"4936075", "Dingelstädt\ Eichsfeld",
"495257", "Hövelhof",
"494734", "Stadland\-Seefeld",
"4938325", "Rolofshagen",
"492150", "Meerbusch\-Lank",
"498253", "Pöttmes",
"496578", "Salmtal",
"492632", "Andernach",
"4939084", "Lindstedt",
"4933607", "Briesen\ Mark",
"498302", "Görisried",
"4939728", "Medow\ bei\ Anklam",
"492066", "Duisburg\-Homberg",
"493634", "Sömmerda",
"499339", "Ippesheim",
"4936481", "Neustadt\ an\ der\ Orla",
"494708", "Ringstedt",
"492775", "Driedorf",
"4939344", "Güsen",
"4934604", "Niemberg",
"493585", "Löbau",
"496761", "Simmern\ Hunsrück",
"497251", "Bruchsal",
"496237", "Maxdorf",
"499286", "Oberkotzau",
"498735", "Gangkofen\-Kollbach",
"493378", "Ludwigsfelde",
"495403", "Bad\ Iburg",
"499223", "Rugendorf",
"499648", "Neustadt\ am\ Kulm",
"4936961", "Bad\ Liebenstein",
"496145", "Flörsheim\ am\ Main",
"498407", "Grossmehring",
"4933234", "Wustermark",
"492551", "Steinfurt\-Burgsteinfurt",
"4939926", "Grabowhöfe",
"496385", "Reichenbach\-Steegen",
"497434", "Winterlingen",
"496843", "Gersheim",
"494666", "Ladelund",
"494802", "Wrohm",
"492680", "Mündersbach",
"493622", "Waltershausen\ Thüringen",
"499365", "Rimpar",
"495073", "Neustadt\-Esperke",
"494637", "Sterup",
"492624", "Höhr\-Grenzhausen",
"4939952", "Grammentin",
"498193", "Geltendorf",
"497375", "Obermarchtal",
"498394", "Lautrach",
"495197", "Soltau\-Frielingen",
"493737", "Rochlitz",
"495321", "Goslar",
"494722", "Cuxhaven\-Altenbruch",
"4938209", "Sanitz\ bei\ Rostock",
"498328", "Balderschwang",
"497191", "Backnang",
"497327", "Dischingen",
"498025", "Miesbach",
"494456", "Varel\-Altjührden",
"4939224", "Büden",
"499835", "Ehingen\ Mittelfranken",
"4938827", "Kalkhorst",
"497951", "Crailsheim",
"4936781", "Grossbreitenbach",
"493591", "Bautzen",
"492745", "Brachbach\ Sieg",
"492857", "Rees\-Mehr",
"497655", "Feldberg\-Altglashütten",
"4939394", "Hohenberg\-Krusemark",
"499133", "Baiersdorf\ Mittelfranken",
"49571", "Minden\ Westfalen",
"4939401", "Neuwegersleben",
"4935954", "Grossharthau",
"499334", "Giebelstadt",
"495957", "Lindern\ Oldenburg",
"4939428", "Pabstorf",
"497706", "Oberbaldingen",
"4934973", "Osternienburg",
"4933848", "Raben",
"494141", "Stade",
"4933208", "Fahrland",
"497465", "Emmingen\-Liptingen",
"497826", "Schuttertal",
"494758", "Nordleda",
"4939457", "Benneckenstein\ Harz",
"495574", "Oberweser",
"4934425", "Droyssig",
"4933438", "Altlandsberg",
"494381", "Lütjenburg",
"498764", "Mauern\ Kreis\ Freising",
"4938858", "Lassahn",
"498203", "Grossaitingen",
"499427", "Leiblfing",
"4935935", "Kleinwelka",
"495207", "Schloss\ Holte\-Stukenbrock",
"492676", "Ulmen",
"4934638", "Zöschen",
"498062", "Bruckmühl\ Mangfall",
"495084", "Hambühren",
"494852", "Brunsbüttel",
"4938307", "Poseritz",
"492306", "Lünen",
"4936743", "Teichel",
"4938295", "Satow\ bei\ Bad\ Doberan",
"498636", "Ampfing",
"4935342", "Mühlberg\ Elbe",
"494523", "Malente",
"496433", "Hadamar",
"497844", "Rheinau",
"492501", "Münster\-Hiltrup",
"497458", "Ebhausen",
"4939933", "Vollrathsruhe",
"499869", "Wettringen\ Mittelfranken",
"495043", "Lauenau",
"498457", "Vohburg\ an\ der\ Donau",
"495453", "Recke",
"4933475", "Letschin",
"493961", "Altentreptow",
"494765", "Ebersdorf\ bei\ Bremervörde",
"497345", "Langenau\ Württemberg",
"499270", "Creussen",
"496127", "Niedernhausen\ Taunus",
"498642", "Übersee",
"496391", "Dahn",
"494406", "Berne",
"497260", "Sinsheim\-Hilsbach",
"496596", "Üdersdorf",
"496873", "Nonnweiler",
"492161", "Mönchengladbach",
"495663", "Spangenberg",
"499923", "Teisnach",
"497668", "Ihringen",
"498667", "Seeon\-Seebruck",
"4938874", "Lützow",
"4939861", "Gramzow\ bei\ Prenzlau",
"4933704", "Baruth\ Mark",
"4933923", "Flecken\ Zechlin",
"496175", "Friedrichsdorf\ Taunus",
"4938351", "Mesekenhagen",
"492393", "Sundern\-Allendorf",
"497247", "Linkenheim\-Hochstetten",
"496426", "Fronhausen",
"498248", "Lamerdingen",
"496865", "Mettlach\-Orscholz",
"498623", "Kirchweidach",
"4936077", "Grossbodungen",
"494107", "Siek\ Kreis\ Stormarn",
"494536", "Steinhorst\ Lauenburg",
"4933088", "Falkenthal",
"4933972", "Breddin",
"497977", "Oberrot\ bei\ Gaildorf",
"494331", "Rendsburg",
"492871", "Bocholt",
"495732", "Löhne",
"496163", "Höchst\ im\ Odenwald",
"495971", "Rheine",
"496364", "Nussbach\ Pfalz",
"497262", "Eppingen",
"496752", "Kirn\ Nahe",
"499942", "Viechtach",
"4938782", "Reetz\ bei\ Perleberg",
"495241", "Gütersloh",
"497621", "Lörrach",
"499272", "Fichtelberg",
"495675", "Trendelburg",
"498640", "Reit\ Im\ Winkl",
"493994", "Malchin",
"494493", "Friesoythe\-Gehlenberg",
"497554", "Heiligenberg\ Baden",
"495746", "Rödinghausen",
"4935971", "Sebnitz",
"499183", "Burgthann",
"492992", "Marsberg",
"494542", "Mölln\ Lauenburg",
"499179", "Freystadt",
"496503", "Hermeskeil",
"499384", "Schwanfeld",
"492431", "Erkelenz",
"495022", "Wietzen",
"4936692", "Bürgel",
"4938327", "Elmenhorst\ Vorpom",
"4936944", "Rentwertshausen",
"4934382", "Nerchau",
"494773", "Lamstedt",
"493928", "Schönebeck\ Elbe",
"499144", "Pleinfeld",
"499343", "Lauda\-Königshofen",
"499936", "Wallerfing",
"4933605", "Boossen",
"4938374", "Lassan\ bei\ Wolgast",
"495724", "Obernkirchen",
"4939361", "Lüderitz",
"492102", "Ratingen",
"4938851", "Zarrentin",
"497473", "Mössingen",
"4937756", "Breitenbrunn\ Erzgebirge",
"492254", "Weilerswist",
"495859", "Thomasburg",
"499463", "Wald\ Oberpfalz",
"493303", "Birkenwerder",
"4934956", "Zörbig",
"4933841", "Belzig",
"4933201", "Gross\ Glienicke",
"499126", "Eckental",
"496054", "Birstein",
"4934774", "Röblingen\ am\ See",
"495838", "Gross\ Oesingen",
"493902", "Diesdorf\ Altm",
"4939408", "Hadmersleben",
"495305", "Sickte",
"497833", "Hornberg\ Schwarzwaldbahn",
"496444", "Bischoffen",
"493421", "Torgau",
"4939421", "Osterwieck",
"4935753", "Grossräschen",
"499653", "Eslarn",
"492547", "Rosendahl\-Osterwick",
"4934922", "Mühlanger",
"492904", "Bestwig",
"496479", "Waldbrunn\ Westerwald",
"498686", "Petting",
"4935842", "Oderwitz",
"495804", "Rätzlingen\ Kreis\ Uelzen",
"496483", "Selters\ Taunus",
"493564", "Schwarze\ Pumpe",
"497135", "Brackenheim",
"495034", "Neustadt\-Hagen",
"4935202", "Klingenberg\ Sachsen",
"496858", "Ottweiler\-Fürth",
"498296", "Villenbach",
"4936024", "Diedorf\ bei\ Mühlhausen",
"492562", "Gronau\ Westfalen",
"492938", "Ense",
"496773", "Kamp\-Bornhofen",
"496567", "Oberkail",
"499302", "Rottendorf\ Unterfranken",
"493462", "Bad\ Dürrenberg",
"496789", "Heimbach\ Nahe",
"499253", "Weissenstadt",
"49365", "Gera",
"492464", "Aldenhoven\ bei\ Jülich",
"493447", "Altenburg\ Thüringen",
"4935694", "Gosda\ bei\ Klinge",
"492521", "Beckum",
"494503", "Timmendorfer\ Strand",
"496542", "Bullay",
"4939488", "Güntersberge",
"497744", "Stühlingen",
"495556", "Lindau\ Harz",
"4937295", "Lugau\ Erzgebirge",
"494163", "Horneburg\ Niederelbe",
"492654", "Polch",
"495351", "Helmstedt",
"494752", "Neuhaus\ Oste",
"498781", "Rottenburg\ an\ der\ Laaber",
"494364", "Dahme\ Kreis\ Ostholstein",
"499903", "Schöllnach",
"497357", "Attenweiler",
"496331", "Pirmasens",
"494865", "Osterhever",
"494426", "Wangerland\-Horumersiel",
"498055", "Halfing",
"496536", "Kleinich",
"498445", "Gerolsbach",
"496107", "Kelsterbach",
"494858", "Sankt\ Margarethen\ Holstein",
"499394", "Esselbach",
"497726", "Bad\ Dürrheim",
"492982", "Medebach",
"4939994", "Metschow",
"499193", "Höchstadt\ an\ der\ Aisch",
"499077", "Bachhagel",
"494479", "Molbergen\-Peheim",
"494483", "Ovelgönne\-Grossenmeer",
"498365", "Wertach",
"493984", "Prenzlau",
"4939031", "Dähre",
"497452", "Nagold",
"497042", "Vaihingen\ an\ der\ Enz",
"493531", "Finsterwalde",
"4936844", "Rohr\ Thüringen",
"495882", "Gorleben",
"4935022", "Bad\ Schandau",
"493943", "Wernigerode",
"494444", "Goldenstedt",
"4936204", "Stotternheim",
"49291", "Meschede",
"499407", "Wenzenbach",
"4935056", "Altenberg\ Sachsen",
"4933872", "Hohennauen",
"498223", "Ichenhausen",
"492845", "Neukirchen\-Vluyn",
"492379", "Menden\-Asbeck",
"4939296", "Welsleben",
"494839", "Wöhrden\ Dithmarschen",
"499735", "Massbach",
"492383", "Bönen",
"497806", "Bad\ Peterstal\-Griesbach",
"497662", "Vogtsburg\ im\ Kaiserstuhl",
"495945", "Wilsum",
"493342", "Neuenhagen\ bei\ Berlin",
"497221", "Baden\-Baden",
"4933983", "Gross\ Pankow\ Kreis\ Prignitz",
"495641", "Warburg",
"49581", "Uelzen",
"495275", "Höxter\-Ottbergen",
"499672", "Neunburg\ vorm\ Wald",
"499106", "Markt\ Erlbach",
"492555", "Schöppingen",
"496586", "Beuren\ Hochwald",
"494966", "Neubörger",
"496029", "Mömbris",
"497733", "Engen\ Hegau",
"497660", "St\ Peter\ Schwarzwald",
"496381", "Kusel",
"4936926", "Creuzburg",
"4934462", "Laucha\ Unstrut",
"495263", "Barntrup",
"499948", "Eschlkam",
"498267", "Dirlewang",
"496758", "Waldböckelheim",
"498731", "Dingolfing",
"497268", "Bad\ Rappenau\-Obergimpern",
"4938722", "Raduhn",
"495704", "Petershagen\-Friedewalde",
"499278", "Weidenberg",
"497195", "Winnenden",
"498373", "Altusried",
"4939038", "Henningen",
"498389", "Weissensberg",
"4935265", "Glaubitz",
"495377", "Ehra\-Lessien",
"4938756", "Grabow",
"498236", "Fischach",
"495824", "Bad\ Bodenteich",
"498021", "Waakirchen",
"492924", "Möhnesee",
"49212", "Solingen",
"4933746", "Werbig\ bei\ Jüterbog",
"497023", "Weilheim\ an\ der\ Teck",
"497576", "Krauchenwies",
"495028", "Pennigsehl",
"4934322", "Rosswein",
"495325", "Goslar\-Hahnenklee",
"4939833", "Mirow\ Kreis\ Neustrelitz",
"497371", "Riedlingen\ Württemberg",
"499566", "Meeder",
"495472", "Bad\ Essen",
"499441", "Kelheim",
"494175", "Egestorf\ Nordheide",
"497529", "Waldburg\ Württemberg",
"497905", "Langenburg",
"495846", "Gartow\ Niedersachsen",
"4939263", "Unseburg",
"4935795", "Königsbrück",
"4937327", "Rechenberg\-Bienenmühle",
"492333", "Ennepetal",
"494873", "Aukrug",
"494127", "Westerhorn",
"495607", "Fuldatal",
"496406", "Lollar",
"492771", "Dillenburg",
"495832", "Hankensbüttel",
"493386", "Premnitz",
"4939481", "Hedersleben\ bei\ Aschersleben",
"493581", "Görlitz",
"496765", "Gemünden\ Hunsrück",
"497255", "Graben\-Neudorf",
"496523", "Holsthum",
"4934242", "Hohenpriessnitz",
"494433", "Dötlingen",
"496852", "Nohfelden",
"4937467", "Klingenthal\ Sachsen",
"4936701", "Lichte",
"492932", "Neheim\-Hüsten",
"492568", "Heek",
"4936084", "Heuthen",
"496044", "Schotten\ Hessen",
"496454", "Lichtenfels\-Sachsenberg",
"4938222", "Semlow",
"4936605", "Bad\ Köstritz",
"499643", "Auerbach\ in\ der\ Oberpfalz",
"497403", "Dunningen",
"4939200", "Gommern",
"492557", "Wettringen\ Kreis\ Steinfurt",
"499228", "Thurnau",
"499535", "Pfarrweisach",
"4935827", "Nieder\-Seifersdorf",
"496083", "Weilrod",
"499294", "Regnitzlosau",
"4936649", "Gefell\ bei\ Schleiz",
"498265", "Pfaffenhausen\ Schwaben",
"496848", "Homburg\-Einöd",
"495434", "Essen\ Oldenburg",
"497073", "Ammerbuch",
"492974", "Schmallenberg\-Fredeburg",
"496664", "Sinntal\-Sterbfritz",
"4935691", "Bärenklau\ NL",
"4935053", "Glashütte\ Sachsen",
"4939293", "Dreileben",
"492244", "Königswinter\-Oberpleis",
"498340", "Baisweil",
"495849", "Waddeweitz",
"495375", "Müden\ Aller",
"497321", "Heidenheim\ an\ der\ Brenz",
"498323", "Immenstadt\ im\ Allgäu",
"494935", "Juist",
"495327", "Bad\ Grund\ Harz",
"493731", "Freiberg\ Sachsen",
"498124", "Forstern\ Oberbayern",
"492693", "Antweiler",
"495191", "Soltau",
"494631", "Glücksburg\ Ostsee",
"4933986", "Falkenhagen\ Kreis\ Prignitz",
"496409", "Biebertal",
"495874", "Soltendieck",
"498071", "Wasserburg\ am\ Inn",
"497544", "Markdorf",
"492801", "Xanten",
"494823", "Wilster",
"498386", "Oberstaufen",
"497907", "Schwäbisch\ Hall\-Sulzdorf",
"498239", "Langenneufnach",
"494177", "Drage\ Elbe",
"4939055", "Hörsingen",
"494552", "Leezen",
"498581", "Waldkirchen\ Niederbayern",
"492226", "Rheinbach",
"499202", "Waischenfeld",
"497583", "Bad\ Schussenried",
"495605", "Kaufungen\ Hessen",
"498146", "Moorenweis",
"495422", "Melle",
"494125", "Seestermühe",
"497579", "Schwenningen\ Baden",
"4936257", "Luisenthal\ Thüringen",
"499154", "Pommelsbrunn",
"498460", "Berching\-Holnstein",
"499569", "Sesslach",
"499353", "Karlstadt",
"496736", "Bechenheim",
"495901", "Fürstenau\ bei\ Bramsche",
"497257", "Bruchsal\-Untergrombach",
"496231", "Hochdorf\-Assenheim",
"4939034", "Fleetmark",
"498258", "Sielenbach",
"496573", "Gillenfeld",
"4934742", "Sylda",
"496026", "Grossostheim",
"496589", "Kell\ am\ See",
"4936841", "Schleusingen",
"4937369", "Wolkenstein",
"4936201", "Walschleben",
"492721", "Lennestadt",
"4934492", "Lucka",
"494703", "Loxstedt\-Donnern",
"496742", "Boppard",
"499952", "Eichendorf",
"4935874", "Bernstadt\ an\ der\ Eigen",
"4939991", "Daberkow",
"495251", "Paderborn",
"493603", "Bad\ Langensalza",
"494264", "Sottrum\ Kreis\ Rotenburg",
"4940", "Hamburg",
"498650", "Marktschellenberg",
"492571", "Greven\ Westfalen",
"494681", "Wyk\ auf\ Föhr",
"498652", "Berchtesgaden",
"492233", "Hürth\ Rheinland",
"4939998", "Loitz\ bei\ Demmin",
"494836", "Hennstedt\ Dithmarschen",
"4939266", "Förderstedt",
"4936043", "Kirchheilingen",
"496565", "Dudeldorf",
"496723", "Oestrich\-Winkel",
"4936848", "Wernshausen",
"4936208", "Ermstedt",
"493445", "Naumburg\ Saale",
"496803", "Mandelbachtal\-Ommersheim",
"499634", "Wiesau",
"494842", "Nordstrand",
"495484", "Lienen\-Kattenvenne",
"497729", "Tennenbronn",
"498462", "Berching",
"4939080", "Kalbe\ Milde",
"496033", "Butzbach",
"497854", "Kehl\-Goldscheuer",
"494796", "Teufelsmoor",
"499608", "Kohlberg\ Oberpfalz",
"497448", "Seewald",
"494550", "Bühnsdorf",
"496105", "Mörfelden\-Walldorf",
"495053", "Fassberg\-Müden",
"4934600", "Ostrau\ Saalkreis",
"498057", "Aschau\-Sachrang",
"495443", "Lemförde",
"4935327", "Priessen",
"495592", "Gleichen\-Bremke",
"497355", "Hochdorf\ Riss",
"498367", "Rosshaupten\ Forggensee",
"495164", "Hodenhagen",
"494151", "Schwarzenbek",
"495363", "Wolfsburg\-Vorsfelde",
"499075", "Glött",
"499378", "Eichenbühl\-Riedern",
"4936923", "Treffurt",
"4936704", "Steinheid",
"4936081", "Arenshausen",
"494748", "Stubben\ bei\ Bremerhaven",
"4935698", "Hornow",
"496691", "Schwalmstadt",
"498342", "Marktoberdorf",
"496281", "Buchen\ Odenwald",
"4939484", "Harzgerode",
"4933230", "Börnicke\ Kreis\ Havelland",
"499766", "Grosswenkheim",
"497941", "Öhringen",
"499737", "Wartmannsroth",
"499261", "Kronach",
"492755", "Bad\ Berleburg\-Schwarzenau",
"49811", "Hallbergmoos",
"4938753", "Wöbbelin",
"496786", "Kempfeld",
"497533", "Allensbach",
"497271", "Wörth\ am\ Rhein",
"497645", "Freiamt",
"499405", "Bad\ Abbach",
"495962", "Herzlake",
"499622", "Hirschau\ Oberpfalz",
"4939959", "Dargun",
"495225", "Spenge",
"492862", "Südlohn",
"495277", "Höxter\-Fürstenau",
"4933743", "Blönsdorf",
"492606", "Winningen\ Mosel",
"498273", "Nordendorf",
"496558", "Büdesheim\ Eifel",
"4938202", "Volkenshagen",
"498531", "Pocking",
"4936625", "Langenwetzendorf",
"495947", "Laar\ Vechte",
"4935247", "Zehren\ Sachsen",
"495504", "Friedland\ Kreis\ Göttingen",
"4938842", "Lüttenmark",
"498336", "Erkheim",
"499661", "Sulzbach\-Rosenberg",
"4938378", "Heringsdorf\ Seebad",
"495921", "Nordhorn",
"4939859", "Fürstenwerder",
"497975", "Untergröningen",
"497671", "Todtnau",
"4939775", "Ahlbeck\ bei\ Torgelow",
"496550", "Irrhausen",
"494105", "Seevetal",
"495625", "Naumburg\ Hessen",
"495402", "Bissendorf\ Kreis\ Osnabrück",
"499965", "Sankt\ Englmar",
"496867", "Perl",
"499222", "Presseck",
"497245", "Durmersheim",
"492206", "Overath",
"495677", "Calden\-Westuffeln",
"496476", "Mengerskirchen",
"496842", "Blieskastel",
"494803", "Pahlen",
"492821", "Kleve\ Niederrhein",
"497486", "Horb\-Altheim",
"4939391", "Lückstedt",
"4939404", "Ausleben",
"499451", "Schierling",
"493623", "Friedrichroda",
"495072", "Neustadt\-Mandelsloh",
"4935951", "Neukirch\ Lausitz",
"4937342", "Cranzahl",
"494723", "Cuxhaven\-Altenwalde",
"4938429", "Glasin",
"498192", "Schondorf\ am\ Ammersee",
"494740", "Loxstedt\-Dedesdorf",
"4936784", "Stützerbach",
"496836", "Überherrn",
"496291", "Adelsheim",
"4933926", "Herzberg\ Mark",
"496681", "Hilders",
"4936028", "Kammerforst\ Thüringen",
"499129", "Wendelstein",
"499234", "Neusorg",
"497166", "Adelberg",
"4934347", "Oelzschau\ bei\ Borna",
"495494", "Holdorf\ Niedersachsen",
"4939607", "Kotelow",
"4933084", "Gutengermendorf",
"4938871", "Mühlen\ Eichsen",
"4933701", "Grossbeeren",
"498421", "Eichstätt\ Bayern",
"499176", "Allersberg",
"494558", "Todesfelde",
"4938354", "Wusterhusen",
"497440", "Bad\ Rippoldsau",
"495428", "Melle\-Neuenkirchen",
"495774", "Wagenfeld\-Ströhen",
"493686", "Eisfeld",
"499208", "Bindlach",
"497423", "Oberndorf\ am\ Neckar",
"4939000", "Beetzendorf",
"498564", "Johanniskirchen",
"4934299", "Gaschwitz",
"495582", "Sankt\ Andreasberg",
"493831", "Stralsund",
"4934976", "Gröbzig",
"492633", "Brohl\-Lützing",
"498252", "Schrobenhausen",
"495131", "Garbsen",
"494281", "Zeven",
"496429", "Schweinsberg\ Hessen",
"492545", "Rosendahl\-Darfeld",
"4935773", "Schleife",
"494539", "Westerau",
"495307", "Braunschweig\-Wenden",
"4936372", "Kleinneuhausen",
"498104", "Sauerlach",
"498303", "Waltenhofen",
"49551", "Göttingen",
"4936948", "Römhild",
"496151", "Darmstadt",
"497506", "Wangen\-Leupolz",
"493471", "Bernburg\ Saale",
"498138", "Schwabhausen\ bei\ Dachau",
"4937432", "Pausa\ Vogtland",
"496631", "Alsfeld",
"497657", "Eisenbach\ Hochschwarzwald",
"494409", "Westerstede\-Ocholt",
"496599", "Weidenbach\ bei\ Gerolstein",
"4936941", "Wasungen",
"492855", "Voerde\ Niederrhein",
"492747", "Molzhain",
"499837", "Haundorf",
"4934953", "Gräfenhainichen",
"493764", "Meerane",
"4935722", "Lauta\ bei\ Hoyerswerda",
"495955", "Esterwegen",
"497436", "Messstetten\-Oberdigisheim",
"4935974", "Hinterhermsdorf",
"494664", "Neukirchen\ bei\ Niebüll",
"492153", "Nettetal\-Lobberich",
"495651", "Eschwege",
"4937202", "Claussnitz\ bei\ Chemnitz",
"498250", "Hilgertshausen\-Tandern",
"492354", "Meinerzhagen",
"4933637", "Beerfelde",
"492762", "Wenden\ Südsauerland",
"498591", "Obernzell",
"494848", "Rantrum",
"495524", "Bad\ Lauterberg\ im\ Harz",
"498468", "Altmannstein\-Pondorf",
"497467", "Neuhausen\ ob\ Eck",
"492309", "Waltrop",
"4935756", "Hosena",
"498639", "Neumarkt\-Sankt\ Veit",
"492626", "Selters\ Westferwald",
"4936463", "Gebstedt",
"495205", "Bielefeld\-Sennestadt",
"497442", "Baiersbronn",
"499602", "Neustadt\ an\ der\ Waldnaab",
"497052", "Bad\ Liebenzell",
"4935387", "Seyda",
"4933708", "Rangsdorf",
"49335", "Frankfurt\ \(Oder\)",
"494454", "Jade",
"495461", "Bramsche\ Hase",
"496264", "Neudenau",
"497362", "Bopfingen",
"497754", "Görwihl",
"495546", "Scheden",
"499372", "Klingenberg\ am\ Main",
"492644", "Linz\ am\ Rhein",
"495341", "Salzgitter",
"494742", "Dorum",
"4936021", "Schlotheim",
"496703", "Wöllstein\ Rheinhessen",
"4939398", "Gross\ Garz",
"4934771", "Querfurt",
"492293", "Nümbrecht",
"497347", "Dietenheim",
"498348", "Bidingen",
"494767", "Bremervörde\-Bevern",
"4939424", "Schwanebeck\ Sachsen\-Anhalt",
"495181", "Alfeld\ Leine",
"492683", "Asbach\ Westerwald",
"494231", "Verden\ Aller",
"498045", "Lenggries\-Fall",
"4933844", "Brück\ Brandenburg",
"493881", "Grevesmühlen",
"499973", "Furth\ im\ Wald",
"494736", "Butjadingen\-Tossens",
"499243", "Pottenstein",
"4933204", "Beelitz\ Mark",
"492064", "Dinslaken",
"497963", "Adelmannsfelden",
"493636", "Greussen",
"499628", "Ursensollen",
"495532", "Stadtoldendorf",
"4938371", "Karlshagen",
"4939364", "Dolle",
"499220", "Kasendorf\-Azendorf",
"4933434", "Herzfelde\ bei\ Strausberg",
"496552", "Olzheim",
"4938854", "Redefin",
"4934207", "Zwochau",
"498665", "Inzell",
"497709", "Wutach",
"4936730", "Sitzendorf",
"499284", "Schwarzenbach\ an\ der\ Saale",
"496093", "Laufach",
"496562", "Speicher",
"499307", "Altertheim",
"492858", "Hünxe",
"4934243", "Bad\ Düben",
"499131", "Erlangen",
"496209", "Mörlenbach",
"492444", "Schleiden\-Gemünd",
"498706", "Vilsheim",
"493876", "Perleberg",
"49951", "Bamberg",
"492054", "Essen\-Kettwig",
"497953", "Blaufelden",
"495176", "Edemissen",
"4936207", "Plaue\ Thüringen",
"49491", "Leer\ Ostfriesland",
"494120", "Ellerhoop",
"498465", "Kipfenberg",
"494383", "Grebin",
"4933965", "Herzsprung\ bei\ Wittstock",
"499749", "Oberbach\ Unterfranken",
"494845", "Ostenfeld\ Husum",
"495234", "Horn\-Bad\ Meinberg",
"492839", "Straelen\-Herongen",
"494757", "Wanna",
"494184", "Hanstedt\ Nordheide",
"4936847", "Steinbach\-Hallenberg",
"495939", "Sustrum",
"496254", "Lautertal\ Odenwald",
"497352", "Ochsenhausen",
"497764", "Herrischried",
"4939389", "Schollene",
"497203", "Walzbachtal",
"4939005", "Kusey",
"4939262", "Güsten\ Anh",
"494344", "Schönberg\ Holstein",
"494143", "Drochtersen",
"495208", "Leopoldshöhe",
"499774", "Oberelsbach",
"499428", "Kirchroth",
"4939997", "Jarmen",
"496102", "Neu\-Isenburg",
"497062", "Beilstein\ Württemberg",
"4935248", "Schönfeld\ bei\ Grossenhain",
"499856", "Dürrwangen",
"4938206", "Graal\-Müritz\ Seeheilbad",
"497636", "Münstertal\ Schwarzwald",
"499072", "Lauingen\ Donau",
"493963", "Woldegk",
"494464", "Wittmund\-Carolinensiel",
"495451", "Ibbenbüren",
"495041", "Springe\ Deister",
"4939832", "Wesenberg",
"498458", "Gaimersheim",
"495129", "Söhlde",
"496431", "Limburg\ an\ der\ Lahn",
"497457", "Rottenburg\-Ergenzingen",
"494521", "Eutin",
"494609", "Eggebek",
"498345", "Stöttwang",
"494326", "Wankendorf",
"495222", "Bad\ Salzuflen",
"4934463", "Bad\ Kösen",
"499625", "Kastl\ bei\ Amberg",
"493362", "Erkner",
"4939929", "Jabel\ bei\ Waren",
"497642", "Endingen\ Kaiserstuhl",
"499402", "Regenstauf",
"496128", "Taunusstein",
"495965", "Klein\ Berssen",
"492364", "Haltern\ Westfalen",
"4938723", "Kladrum",
"492752", "Bad\ Laasphe",
"4935697", "Bagenz",
"492163", "Schwalmtal\ Niederrhein",
"495661", "Melsungen",
"499921", "Regen",
"496871", "Wadern",
"497667", "Breisach\ am\ Rhein",
"492426", "Nörvenich",
"496393", "Fischbach\ bei\ Dahn",
"492865", "Raesfeld",
"499677", "Oberviechtach\-Pullenried",
"492175", "Leichlingen\ Rheinland",
"499532", "Maroldsweisach",
"498247", "Bad\ Wörishofen",
"497248", "Marxzell",
"4937464", "Schöneck\ Vogtland",
"497623", "Rheinfelden\ Baden",
"494108", "Rosengarten\ Kreis\ Harburg",
"4936087", "Wüstheuterode",
"4933982", "Hoppenrade\ Kreis\ Prignitz",
"496161", "Brensbach",
"495973", "Neuenkirchen\ Kreis\ Steinfurt",
"4939889", "Boitzenburg",
"494946", "Grossefehn\-Bagband",
"494333", "Erfde",
"492873", "Isselburg\-Werth",
"498262", "Mittelneufnach",
"4933873", "Grosswudicke",
"495284", "Schwalenberg",
"4936735", "Probstzella",
"492596", "Nordkirchen",
"494134", "Embsen\ Kreis\ Lüneburg",
"492750", "Diedenshausen",
"495694", "Diemelstadt",
"498509", "Ruderting",
"498621", "Trostberg",
"494276", "Borstel\ bei\ Sulingen",
"492391", "Plettenberg",
"499341", "Tauberbischofsheim",
"498554", "Schönberg\ Niederbayern",
"495372", "Meinersen",
"494771", "Hemmoor",
"4935023", "Bad\ Gottleuba",
"499546", "Burgebrach",
"493671", "Saalfeld\ Saale",
"4937324", "Reinsberg\ Sachsen",
"496501", "Konz",
"492433", "Hückelhoven",
"497156", "Ditzingen",
"496629", "Schenklengsfeld",
"4935241", "Lommatzsch",
"499070", "Tapfheim",
"4935828", "Reichenbach\ OL",
"499181", "Neumarkt\ in\ der\ Oberpfalz",
"496306", "Trippstadt",
"494932", "Norderney",
"4938226", "Dierhagen\ Ostseebad",
"494491", "Friesoythe",
"4934496", "Nöbdenitz",
"494555", "Seedorf\ bei\ Bad\ Segeberg",
"496676", "Hohenroda\ Hessen",
"4933054", "Liebenwalde",
"4935609", "Drachhausen",
"499524", "Zeil\ am\ Main",
"499461", "Roding",
"493301", "Oranienburg",
"4934746", "Giersleben",
"497471", "Hechingen",
"494122", "Uetersen",
"495425", "Borgholzhausen",
"495602", "Hessisch\ Lichtenau",
"499205", "Vorbach",
"495837", "Sprakensehl",
"492548", "Dülmen\-Rorup",
"4936258", "Friemar",
"499651", "Vohenstrauss",
"493423", "Eilenburg",
"494924", "Moormerland\-Oldersum",
"498135", "Sulzemoos",
"499955", "Mamming",
"496857", "Namborn",
"496745", "Gondershausen",
"497831", "Hausach",
"492937", "Arnsberg\-Oeventrop",
"4939601", "Friedland",
"496568", "Wolsfeld",
"4935843", "Hirschfelde\ bei\ Zittau",
"492852", "Hamminkeln",
"4935203", "Tharandt",
"494501", "Kastorf\ Holstein",
"4935388", "Klöden",
"492523", "Wadersloh",
"4934341", "Geithain",
"495109", "Ronnenberg",
"4935433", "Vetschau",
"493448", "Meuselwitz\ Thüringen",
"499251", "Münchberg",
"495952", "Sögel",
"4935752", "Ruhland",
"4934923", "Cobbelsdorf",
"496771", "St\ Goarshausen",
"496276", "Hesseneck",
"492406", "Herzogenrath",
"498744", "Gerzen",
"4939050", "Bartensleben",
"4933638", "Rüdersdorf\ bei\ Berlin",
"4935726", "Gross\ Särchen",
"4937206", "Frankenberg\ Sachsen",
"496333", "Waldfischbach\-Burgalben",
"496134", "Mainz\-Kastel",
"498783", "Rohr\ in\ Niederbayern",
"499901", "Hengersberg\ Bayern",
"495353", "Königslutter\ am\ Elm",
"4937436", "Weischlitz",
"495154", "Aerzen",
"4939329", "Möringen",
"494161", "Buxtehude",
"497358", "Eberhardzell\-Füramoos",
"497055", "Neuweiler\ Kreis\ Calw",
"499605", "Weiherhammer",
"497445", "Pfalzgrafenweiler",
"499422", "Bogen\ Niederbayern",
"4938304", "Garz\ Rügen",
"496108", "Mühlheim\ am\ Main",
"495202", "Oerlinghausen",
"4933675", "Tauche",
"498067", "Tuntenhausen",
"493941", "Halberstadt",
"494745", "Bad\ Bederkesa",
"4934221", "Schildau\ Gneisenaustadt",
"492739", "Wilnsdorf",
"494857", "Barlt",
"498726", "Schönau\ Niederbayern",
"495063", "Bad\ Salzdetfurth",
"499375", "Freudenberg\ Baden",
"4936693", "Crossen\ an\ der\ Elster",
"4934383", "Trebsen\ Mulde",
"493533", "Elsterwerda",
"499078", "Mertingen",
"497365", "Essingen\ Württemberg",
"4934208", "Löbnitz\ bei\ Delitzsch",
"499874", "Neuendettelsau",
"494481", "Hatten\-Sandkrug",
"496229", "Neckarsteinach",
"498452", "Geisenfeld",
"498042", "Lenggries",
"4939454", "Elbingerode\ Harz",
"499191", "Forchheim\ Oberfranken",
"499408", "Altenthann",
"496122", "Hofheim\-Wallau",
"495535", "Polle",
"495228", "Vlotho\-Exter",
"4939062", "Bebertal",
"4939205", "Langenweddingen",
"495643", "Borgentreich",
"497223", "Bühl\ Baden",
"4939397", "Geestgottberg",
"492758", "Bad\ Berleburg\-Girkhausen",
"4938783", "Dallmin",
"493496", "Köthen\ Anhalt",
"499434", "Bodenwöhr",
"492381", "Hamm\ Westfalen",
"498806", "Utting\ am\ Ammersee",
"495684", "Frielendorf",
"498662", "Siegsdorf\ Kreis\ Traunstein",
"492586", "Beelen",
"498221", "Günzburg",
"4938824", "Mallentin",
"496555", "Bleialf",
"495294", "Hövelhof\-Espeln",
"4933973", "Zernitz\ bei\ Neustadt\ Dosse",
"497240", "Pfinztal",
"4933365", "Lüdersdorf\ Kreis\ Barnim",
"498036", "Stephanskirchen\ Simssee",
"496344", "Schwegenheim",
"497242", "Rheinstetten",
"499225", "Stadtsteinach",
"495405", "Hasbergen\ Kreis\ Osnabrück",
"499962", "Schwarzach\ Niederbayern",
"495622", "Fritzlar",
"4936027", "Lengenfeld\ Unterm\ Stein",
"494102", "Ahrensburg",
"498733", "Mengkofen",
"4933922", "Karwesee",
"497972", "Gschwend\ bei\ Gaildorf",
"4939829", "Blankenförde",
"495261", "Lemgo",
"493321", "Nauen\ Brandenburg",
"494254", "Eystrup",
"499504", "Stadelhofen",
"496383", "Glan\-Münchweiler",
"494959", "Dollart",
"497267", "Gemmingen",
"496184", "Langenselbold",
"496757", "Becherbach\ bei\ Kirn",
"498268", "Tussenhausen",
"499947", "Neukirchen\ bei\ Hl\ Blut",
"497731", "Singen\ Hohentwiel",
"4937346", "Geyer",
"4939225", "Altengrabow",
"496120", "Aarbergen",
"499277", "Warmensteinach",
"497373", "Zwiefalten",
"4939932", "Malchow\ bei\ Waren",
"498195", "Weil\ Kreis\ Landsberg\ am\ Lech",
"4938459", "Laage",
"497389", "Heroldstatt",
"495378", "Sassenburg\-Platendorf",
"497174", "Mögglingen",
"4933839", "Wusterwitz",
"499363", "Arnstein\ Unterfranken",
"497236", "Keltern",
"4937384", "Wechselburg",
"497021", "Kirchheim\ unter\ Teck",
"494547", "Gudow\ Lauenburg",
"498450", "Ingolstadt\-Zuchering",
"499164", "Langenfeld\ Mittelfranken",
"495766", "Rehburg\-Loccum",
"4933235", "Friesack",
"498023", "Bayrischzell",
"495027", "Linsburg",
"4936742", "Uhlstädt",
"494209", "Schwanewede",
"4938377", "Zinnowitz",
"494938", "Hagermarsch",
"494562", "Grömitz",
"4935343", "Hirschfeld\ bei\ Elsterwerda",
"492536", "Münster\-Albachten",
"494194", "Sievershütten",
"4938324", "Velgast",
"499420", "Feldkirchen\ Niederbayern",
"4936947", "Jüchsen",
"4939085", "Zichtau",
"494393", "Boostedt",
"498086", "Buchbach\ Oberbayern",
"492331", "Hagen\ Westfalen",
"499484", "Brennberg",
"494871", "Hohenwestedt",
"495634", "Waldeck\-Sachsenhausen",
"4939345", "Parchen",
"4933631", "Bad\ Saarow\-Pieskow",
"496654", "Gersfeld\ Rhön",
"495585", "Herzberg\-Sieber",
"494128", "Kollmar",
"4936376", "Straussfurt",
"499443", "Abensberg",
"4934605", "Gröbers",
"495608", "Söhrewald",
"4934903", "Coswig\ Anhalt",
"493544", "Luckau\ Brandenburg",
"493907", "Gardelegen",
"496326", "Deidesheim",
"494431", "Wildeshausen",
"4938464", "Bernitt",
"492542", "Gescher",
"4939608", "Staven",
"496464", "Angelburg",
"493583", "Zittau",
"492850", "Rees\-Haldern",
"4936074", "Worbis",
"4934348", "Frohburg",
"492567", "Ahaus\-Alstätte",
"492773", "Haiger",
"4938328", "Miltzow",
"4936450", "Kranichfeld",
"496329", "Weidenthal\ Pfalz",
"492558", "Horstmar",
"498403", "Pförring",
"4934386", "Dürrweitzschen\ bei\ Grimma",
"4938301", "Putbus",
"496081", "Usingen",
"495407", "Wallenhorst",
"499227", "Neuenmarkt",
"495672", "Bad\ Karlshafen",
"49981", "Ansbach",
"499275", "Speichersdorf",
"493576", "Weisswasser",
"499641", "Grafenwöhr",
"499945", "Arnbruck",
"496755", "Odernheim\ am\ Glan",
"497265", "Angelbachtal",
"493371", "Luckenwalde",
"498073", "Gars\ am\ Inn",
"4936873", "Themar",
"494545", "Seedorf\ Lauenburg",
"494633", "Satrup",
"497340", "Neenstetten",
"495193", "Schneverdingen",
"492691", "Adenau",
"493733", "Annaberg\-Buchholz",
"498321", "Sonthofen",
"4939604", "Wildberg\ bei\ Altentreptow",
"4933087", "Bredereiche",
"497323", "Gerstetten",
"497124", "Trochtelfingen\ Hohenz",
"495328", "Altenau\ Harz",
"4933976", "Wutike",
"495025", "Estorf\ Weser",
"497071", "Tübingen",
"4934344", "Kohren\-Sahlis",
"4933769", "Töpchin",
"4936462", "Ossmannstedt",
"495903", "Emsbüren",
"499351", "Gemünden\ am\ Main",
"498544", "Eging\ am\ See",
"497386", "Hayingen",
"4935206", "Kreischa\ bei\ Dresden",
"4938821", "Lüdersdorf",
"494178", "Radbruch",
"499556", "Geiselwind",
"497581", "Saulgau",
"498583", "Neureichenau",
"497146", "Remseck\ am\ Neckar",
"495769", "Steyerberg\-Voigtei",
"4935436", "Laasow\ bei\ Calau",
"497934", "Weikersheim",
"494206", "Stuhr\-Heiligenrode",
"494821", "Itzehoe",
"4939407", "Seehausen\ Börde",
"492803", "Wesel\-Büderich",
"4934926", "Pretzsch\ Elbe",
"498257", "Inchenhofen",
"497258", "Oberderdingen\-Flehingen",
"4935723", "Bernsdorf\ OL",
"493529", "Heidenau\ Sachsen",
"4939451", "Wasserleben",
"495253", "Bad\ Driburg",
"493601", "Mühlhausen\ Thüringen",
"4937203", "Gersdorf\ bei\ Chemnitz",
"495302", "Vechelde",
"492723", "Kirchhundem",
"494956", "Uplengen",
"4937433", "Gutenfürst",
"492565", "Gronau\-Epe",
"4934224", "Belgern\ Sachsen",
"497132", "Neckarsulm",
"4937752", "Eibenstock",
"496571", "Wittlich",
"496233", "Frankenthal\ Pfalz",
"493744", "Auerbach\ Vogtland",
"497652", "Hinterzarten",
"497130", "Löwenstein\ Württemberg",
"4933437", "Reichenberg\ bei\ Strausberg",
"492742", "Wissen",
"494644", "Karby",
"496721", "Bingen\ am\ Rhein",
"4934204", "Schkeuditz",
"499832", "Wassertrüdingen",
"4933207", "Gross\ Kreutz",
"494293", "Ottersberg\-Fischerhude",
"4935772", "Rietschen",
"4939458", "Heudeber",
"498809", "Wessobrunn",
"495300", "Salzgitter\-Üfingen",
"4933847", "Görzke",
"4936373", "Buttstädt",
"4937381", "Penig",
"498039", "Rott\ am\ Inn",
"4933395", "Zerpenschleuse",
"492573", "Nordwalde",
"494683", "Oldsum",
"4936965", "Stadtlengsfeld",
"4939427", "Ströbeck",
"492736", "Burbach\ Siegerl",
"4934906", "Raguhn",
"499846", "Ipsheim",
"497462", "Immendingen",
"495441", "Diepholz",
"495051", "Bergen\ Kreis\ Celle",
"499472", "Hohenfels\ Oberpfalz",
"496226", "Meckesheim",
"497447", "Baiersbronn\-Schwarzenberg",
"499607", "Luhe\-Wildenau",
"496031", "Friedberg\ Hessen",
"4938828", "Schönberg",
"493647", "Pössneck",
"499094", "Tagmersheim",
"497367", "Aalen\-Ebnat",
"492409", "Stolberg\-Gressenich",
"497182", "Welzheim",
"499824", "Dietenhofen",
"498368", "Halblech",
"496283", "Hardheim\ Odenwald",
"499377", "Freudenberg\-Boxtal",
"496693", "Neuental",
"494855", "Eddelak",
"4935384", "Steinsdorf\ bei\ Jessen",
"494747", "Beverstedt",
"4936071", "Teistungen",
"4933655", "Grunow\ Kreis\ Oder\-Spree",
"498065", "Tuntenhausen\-Schönau",
"4934721", "Nienburg\ Saale",
"496244", "Westhofen\ Rheinhessenen",
"499325", "Kleinlangheim",
"494762", "Kutenholz",
"495361", "Wolfsburg",
"4938461", "Bützow",
"494354", "Fleckeby",
"4937343", "Jöhstadt",
"49345", "Halle\ Saale",
"494153", "Lauenburg\ Elbe",
"492664", "Rennerod",
"499738", "Rottershausen",
"49711", "Stuttgart",
"4933634", "Berkenbrück\ Kreis\ Oder\-Spree",
"493726", "Flöha",
"498533", "Rotthalmünster",
"494626", "Treia",
"498271", "Meitingen",
"4939749", "Grambow\ bei\ Pasewalk",
"495278", "Höxter\-Ovenhausen",
"4938321", "Martensdorf\ bei\ Stralsund",
"499704", "Euerdorf",
"496172", "Bad\ Homburg\ von\ der\ Höhe",
"497273", "Hagenbach\ Pfalz",
"496557", "Hallschlag",
"497531", "Konstanz",
"4934637", "Frankleben",
"492454", "Gangelt",
"495948", "Itterbeck",
"4938308", "Göhren\ Rügen",
"499263", "Ludwigsstadt",
"497336", "Lonsee",
"497943", "Schöntal\ Jagst",
"492823", "Goch",
"4933742", "Oehna\ Brandenburg",
"4938203", "Bad\ Doberan",
"498671", "Altötting",
"492552", "Steinfurt\-Borghorst",
"4938843", "Bennin",
"496868", "Mettlach\-Tünsdorf",
"498245", "Türkheim\ Wertach",
"4935877", "Cunewalde",
"4938752", "Zierzow\ bei\ Ludwigslust",
"497673", "Schönau\ im\ Schwarzwald",
"4939037", "Pretzier",
"499663", "Neukirchen\ bei\ Sulzbach\-Rosenberg",
"495923", "Schüttorf",
"4934466", "Janisroda",
"496683", "Ehrenberg\ Rhön",
"4938726", "Spornitz",
"496293", "Schefflenz",
"4936254", "Friedrichswerth",
"499084", "Bissingen\ Schwaben",
"497192", "Murrhardt",
"495322", "Bad\ Harzburg",
"493925", "Stassfurt",
"494721", "Cuxhaven",
"496644", "Grebenhain",
"493621", "Gotha\ Thüringen",
"4933470", "Lietzen",
"499453", "Thalmassing",
"492264", "Marienheide",
"4936922", "Gerstungen",
"4937468", "Treuen\ Vogtland",
"498166", "Allershausen\ Oberbayern",
"494172", "Salzhausen",
"499549", "Lisberg",
"494557", "Blunk",
"495475", "Bohmte\-Hunteburg",
"499207", "Königsfeld\ Oberfranken",
"496626", "Wildeck\-Obersuhl",
"497159", "Renningen",
"4935930", "Seitschen",
"495427", "Melle\-Buer",
"498423", "Titting",
"497564", "Bad\ Wurzach",
"499574", "Marktzeuln",
"497252", "Bretten",
"496762", "Kastellaun",
"493473", "Aschersleben\ Sachsen\-Anhalt",
"494974", "Neuharlingersiel",
"4934692", "Alsleben\ Saale",
"495308", "Lehre",
"497303", "Illertissen",
"495835", "Wahrenholz",
"494244", "Harpstedt",
"4937328", "Grossschirma",
"492935", "Sundern\-Hachen",
"492599", "Ascheberg\-Herbern",
"496747", "Emmelshausen",
"496855", "Freisen",
"498137", "Petershausen",
"4936042", "Tonna",
"495334", "Hornburg\ Kreis\ Wolfenbüttel",
"497138", "Schwaigern",
"498506", "Bad\ Höhenstadt",
"49971", "Bad\ Kissingen",
"494283", "Tarmstedt",
"492631", "Neuwied",
"498657", "Ramsau\ bei\ Berchtesgaden",
"4934493", "Gössnitz\ Thüringen",
"4935244", "Krögis",
"495653", "Sontra",
"492151", "Krefeld",
"499305", "Estenfeld",
"4934743", "Ermsleben",
"496545", "Blankenrath",
"496633", "Homberg\ Ohm",
"499804", "Aurach",
"497250", "Kraichtal",
"4937321", "Frankenstein\ Sachsen",
"492429", "Hürtgenwald",
"494755", "Ihlienworth",
"4939487", "Friedrichsbrunn",
"494847", "Oster\-Ohrstedt",
"498467", "Kinding",
"4937609", "Wolkenburg\ Mulde",
"499724", "Stadtlauringen",
"498442", "Wolnzach",
"495126", "Algermissen",
"494606", "Wanderup",
"498052", "Aschau\ im\ Chiemgau",
"494862", "Garding",
"494329", "Langwedel\ Holstein",
"498593", "Untergriesbach",
"498362", "Füssen",
"495384", "Seesen\-Gross\ Rhüden",
"498754", "Volkenschwand",
"494233", "Blender",
"492681", "Altenkirchen\ Westerwald",
"495183", "Lamspringe",
"495320", "Torfhaus",
"492985", "Winterberg\-Niedersfeld",
"499746", "Zeitlofs",
"492291", "Waldbröl",
"492836", "Wachtendonk",
"4935324", "Crinitz",
"496701", "Sprendlingen\ Rheinhessen",
"4934781", "Greifenhagen",
"495936", "Twist",
"495144", "Wathlingen",
"498347", "Friesenried",
"4935052", "Kipsdorf\ Kurort",
"4933876", "Buschow",
"497348", "Beimerstetten",
"4939292", "Biederitz",
"497045", "Oberderdingen",
"494768", "Hipstedt",
"497455", "Dornhan",
"496821", "Neunkirchen\ Saar",
"499732", "Hammelburg",
"4936425", "Isserstedt",
"492842", "Kamp\-Lintfort",
"4935026", "Dürrröhrsdorf\-Dittersbach",
"496206", "Lampertheim",
"499627", "Freudenberg\ Oberpfalz",
"493844", "Schwaan",
"492867", "Heiden\ Kreis\ Borken",
"499675", "Altendorf\ am\ Nabburg",
"495272", "Brakel\ Westfalen",
"497961", "Ellwangen\ Jagst",
"4933051", "Nassenheide",
"499241", "Pegnitz",
"498709", "Eching\ Niederbayern",
"4938223", "Saal\ Vorpom",
"495942", "Uelsen",
"497665", "March\ Breisgau",
"493883", "Hagenow",
"499971", "Cham",
"499854", "Wittelshofen",
"4939035", "Kuhfelde",
"494140", "Estorf\ Kreis\ Stade",
"4935268", "Stauchitz",
"498846", "Uffing\ am\ Staffelsee",
"499729", "Grettstadt",
"497634", "Sulzburg",
"494466", "Wittmund\-Ardorf",
"494825", "Burg\ Dithmarschen",
"492337", "Hagen\-Dahl",
"4938393", "Binz\ Ostseebad",
"494877", "Hennstedt\ bei\ Itzehoe",
"4935875", "Obercunnersdorf\ bei\ Löbau",
"499355", "Frammersbach",
"4933332", "Gartz\ Oder",
"495603", "Gudensberg",
"494324", "Brokstedt",
"497585", "Ostrach",
"499448", "Hausen\ Niederbayern",
"494123", "Barmstedt",
"492561", "Ahaus",
"4934443", "Teuchern",
"497950", "Schnelldorf",
"496575", "Landscheid",
"4939054", "Flechtingen",
"492366", "Herten\ Westfalen",
"4938300", "Insel\ Hiddensee",
"4939322", "Tangermünde",
"493605", "Leinefelde",
"496527", "Oberweis",
"493588", "Niesky",
"492778", "Siegbach",
"492424", "Vettweiss",
"4936451", "Buttelstedt",
"494705", "Wremen",
"493901", "Salzwedel",
"496196", "Bad\ Soden\ am\ Taunus",
"499645", "Eschenbach\ in\ der\ Oberpfalz",
"497622", "Schopfheim",
"495242", "Rheda\-Wiedenbrück",
"4934263", "Hohburg",
"499533", "Untermerzbach",
"499271", "Thurnau\-Alladorf",
"493375", "Königs\ Wusterhausen",
"496751", "Bad\ Sobernheim",
"499941", "Kötzting",
"497261", "Sinsheim",
"498263", "Breitenbrunn\ Schwaben",
"494332", "Hamdorf\ bei\ Rendsburg",
"492872", "Rhede\ Westfalen",
"495731", "Bad\ Oeynhausen",
"493327", "Werder\ Havel",
"496085", "Waldsolms",
"492056", "Heiligenhaus",
"492446", "Heimbach\ Eifel",
"493874", "Ludwigslust",
"498704", "Altdorf\-Pfettrach",
"495373", "Hillerse\ Kreis\ Gifhorn",
"495174", "Lahstedt",
"498377", "Unterthingau",
"4936604", "Münchenbernsdorf",
"495236", "Blomberg\-Grossenmarpe",
"494186", "Buchholz\-Trelde",
"4935033", "Rosenthal\ Sächsische\ Schweiz",
"498094", "Steinhöring",
"495021", "Nienburg\ Weser",
"498824", "Oberau\ Loisach",
"496256", "Lampertheim\-Hüttenfeld",
"492991", "Marsberg\-Bredelar",
"495149", "Wienhausen",
"498028", "Fischbachau",
"4937291", "Augustusburg",
"492432", "Wassenberg",
"494541", "Ratzeburg",
"498325", "Oberstaufen\-Thalkirchdorf",
"499776", "Mellrichstadt",
"492695", "Insul",
"4939242", "Prödel",
"494933", "Dornum\ Ostfriesland",
"494346", "Gettorf",
"499321", "Kitzingen",
"495068", "Elze\ Leine",
"499197", "Egloffstein",
"4937298", "Oelsnitz\ Erzgebirge",
"497063", "Bad\ Wimpfen",
"496674", "Friedewald\ Hessen",
"492964", "Brilon\-Alme",
"499089", "Bissingen\-Unterringingen",
"499526", "Riedbach",
"494487", "Grossenkneten\-Huntlosen",
"4939822", "Kratzeburg",
"495365", "Wolfsburg\-Neindorf",
"499073", "Gundelfingen\ an\ der\ Donau",
"4933929", "Gühlen\-Glienicke",
"493962", "Penzlin\ bei\ Waren",
"4936624", "Teichwolframsdorf",
"492502", "Nottuln",
"493947", "Thale",
"4938426", "Neuburg\-Steinhausen",
"494851", "Marne",
"498061", "Bad\ Aibling",
"492269", "Kierspe\-Rönsahl",
"495864", "Jameln",
"493504", "Dippoldiswalde",
"4933832", "Rogäsen",
"497228", "Forbach",
"495648", "Brakel\-Gehrden",
"4938452", "Lalendorf",
"495223", "Bünde",
"497643", "Herbolzheim\ Breisgau",
"499403", "Donaustauf",
"494330", "Emkendorf",
"492162", "Viersen",
"492387", "Drensteinfurt\-Walstedde",
"4936705", "Oberweissbach\ Thüringer\ Wald",
"4938733", "Karbow\-Vietlübbe",
"492753", "Erndtebrück",
"4969", "Frankfurt\ am\ Main",
"494926", "Krummhörn\-Greetsiel",
"497684", "Glottertal",
"4939856", "Beenz\ bei\ Prenzlau",
"498641", "Grassau\ Kreis\ Traunstein",
"496392", "Hauenstein\ Pfalz",
"4939485", "Gernrode\ Harz",
"497620", "Schopfheim\-Gersbach",
"49881", "Weilheim\ in\ Oberbayern",
"496359", "Grünstadt",
"496563", "Kyllburg",
"494249", "Bassum\-Nordwohlde",
"49431", "Kiel",
"492235", "Erftstadt",
"492528", "Ennigerloh\-Enniger",
"499257", "Zell\ Oberfranken",
"4938320", "Tribsees",
"492482", "Hellenthal",
"4936458", "Bad\ Berka",
"495286", "Ottenstein\ Niedersachsen",
"494136", "Scharnebeck",
"492594", "Dülmen",
"493443", "Weissenfels\ Sachsen\-Anhalt",
"494944", "Wiesmoor",
"493592", "Kirschau",
"496725", "Gau\-Algesheim",
"497952", "Gerabronn",
"495696", "Bad\ Arolsen\-Landau",
"495339", "Gielde",
"494274", "Varrel\ bei\ Sulingen",
"496035", "Reichelsheim\ Wetterau",
"4934296", "Groitzsch\ bei\ Pegau",
"498556", "Haidmühle",
"49241", "Aachen",
"4934979", "Wulfen\ Sachsen\-Anhalt",
"499907", "Zenting",
"496805", "Kleinblittersdorf",
"496338", "Hornbach\ Pfalz",
"494167", "Apensen",
"494382", "Wangels",
"499544", "Baunach",
"497569", "Isny\-Eisenbach",
"497353", "Schwendi",
"495358", "Bahrdorf\-Mackendorf",
"497154", "Kornwestheim",
"4936427", "Dornburg\ Saale",
"495055", "Fassberg",
"494142", "Steinkirchen\ Kreis\ Stade",
"496103", "Langen\ Hessen",
"497202", "Karlsbad",
"496304", "Wolfstein\ Pfalz",
"495445", "Drebber",
"498724", "Massing",
"494392", "Nortorf\ bei\ Neumünster",
"497477", "Jungingen\ bei\ Hechingen",
"4938334", "Grammendorf",
"499467", "Michelsneukirchen",
"493307", "Zehdenick",
"4939727", "Spantekow",
"49351", "Dresden",
"499876", "Rohr\ Mittelfranken",
"495471", "Bohmte",
"497425", "Trossingen",
"499442", "Riedenburg",
"4933608", "Jacobsdorf\ Mark",
"496851", "St\ Wendel",
"497837", "Oberharmersbach",
"4935472", "Schlepzig",
"492931", "Arnsberg",
"493494", "Wolfen",
"4933085", "Seilershof",
"492635", "Rheinbrohl",
"4938355", "Züssow",
"492543", "Billerbeck\ Westfalen",
"499657", "Waldthurn",
"4939382", "Kamern",
"493774", "Schwarzenberg",
"49760", "Oberried\ Breisgau",
"495686", "Schwarzenborn\ Knüll",
"499436", "Nittenau",
"492520", "Wadersloh\-Diestedde",
"498034", "Brannenburg",
"492772", "Herborn\ Hessen",
"495831", "Wittingen",
"492584", "Warendorf\-Milte",
"494674", "Ockholm",
"49340", "Dessau\ Anh",
"494103", "Wedel",
"495248", "Langenberg\ Kreis\ Gütersloh",
"497628", "Efringen\-Kirchen",
"496142", "Rüsselsheim",
"497243", "Ettlingen",
"4939405", "Hötensleben",
"499963", "Konzell",
"495623", "Edertal",
"495978", "Hörstel\-Dreierwalde",
"4934361", "Dahlen\ Sachsen",
"498732", "Frontenhausen",
"4933932", "Fehrbellin",
"497973", "Obersontheim",
"494805", "Schafstedt",
"4936785", "Gräfinau\-Angstedt",
"496382", "Lauterecken",
"494338", "Alt\ Duvenstedt",
"496167", "Modautal",
"4939956", "Neukalen",
"498241", "Buchloe",
"497220", "Forbach\-Hundsbach",
"494725", "Helgoland",
"493921", "Burg\ bei\ Magdeburg",
"496274", "Waldbrunn\ Odenwald",
"494497", "Barssel\-Harkebrügge",
"499829", "Flachslanden",
"4939922", "Dambeck\ bei\ Röbel",
"499099", "Kaisheim",
"492404", "Alsdorf\ Rheinland",
"496136", "Nieder\-Olm",
"4939774", "Mönkebude",
"496507", "Neumagen\-Dhron",
"4935931", "Königswartha",
"499187", "Altdorf\ bei\ Nürnberg",
"495156", "Coppenbrügge",
"493677", "Ilmenau\ Thüringen",
"49631", "Kaiserslautern",
"496249", "Guntersblum",
"4934671", "Bad\ Frankenhausen\ Kyffhäuser",
"498022", "Tegernsee",
"499347", "Wittighausen",
"494563", "Scharbeutz\-Haffkrug",
"494777", "Cadenberge",
"495060", "Bodenburg",
"4933845", "Borkheide",
"498084", "Taufkirchen\ Vils",
"495062", "Holle\ bei\ Hildesheim",
"492534", "Münster\-Roxel",
"4936967", "Geisa",
"4933397", "Wandlitz",
"4939882", "Gollin",
"497451", "Horb\ am\ Neckar",
"495636", "Lichtenfels\-Goddelsheim",
"4933205", "Michendorf",
"498020", "Weyarn",
"493968", "Schönbeck",
"497041", "Mühlacker",
"4933989", "Sadenbeck",
"494527", "Bosau",
"4933435", "Rehfelde",
"499360", "Thüngen",
"498043", "Jachenau",
"495457", "Hopsten\-Schale",
"4939365", "Bellingen\ bei\ Stendal",
"492685", "Flammersfeld",
"497129", "Lichtenstein\ Württemberg",
"496656", "Ebersburg",
"492508", "Drensteinfurt",
"4939973", "Altkalen",
"4938855", "Lübtheen",
"498453", "Reichertshofen\ Oberbayern",
"4938486", "Gustävel",
"4935938", "Grosspostwitz\ OL",
"492295", "Ruppichteroth",
"492981", "Winterberg\ Westfalen",
"495642", "Warburg\-Scherfede",
"497965", "Ellwangen\-Röhlingen",
"496324", "Hassloch",
"497222", "Rastatt",
"499245", "Obertrubach",
"4937320", "Mulda\ Sachsen",
"4936646", "Tanna\ bei\ Schleiz",
"496123", "Eltville\ am\ Rhein",
"493546", "Lübben\ Spreewald",
"499671", "Oberviechtach",
"499975", "Waldmünchen\-Geigant",
"497661", "Kirchzarten",
"493341", "Strausberg",
"498663", "Ruhpolding",
"496825", "Illingen\ Saar",
"499927", "Kirchberg\ Wald",
"496095", "Bessenbach",
"496466", "Dautphetal\-Friedensdorf",
"4938794", "Cumlosen",
"4933454", "Wölsickendorf\/Wollenberg",
"496398", "Vorderweidenthal",
"4939425", "Dingelstedt\ am\ Huy",
"492853", "Schermbeck",
"496346", "Annweiler\ am\ Trifels",
"492770", "Eschenburg",
"492522", "Oelde",
"4934654", "Stolberg\ Harz",
"494256", "Hilgermissen",
"4935602", "Drebkau",
"496541", "Traben\-Trarbach",
"49871", "Landshut",
"496186", "Grosskrotzenburg",
"4933657", "Steinsdorf\ Brandenburg",
"4939751", "Penkun",
"497958", "Rot\ Am\ See\-Brettheim",
"4937366", "Rübenau",
"495953", "Börger",
"493461", "Merseburg\ Saale",
"497176", "Spraitbach",
"4934635", "Bad\ Lauchstädt",
"498549", "Vilshofen\-Pleinting",
"499166", "Münchsteinach",
"4933601", "Podelzig",
"497234", "Tiefenbronn",
"496332", "Zweibrücken",
"4936762", "Steinach\ Thüringen",
"498574", "Wittibreut",
"497939", "Schrozberg\-Spielbach",
"498782", "Pfeffenhausen",
"495764", "Steyerberg",
"495352", "Schöningen",
"4933478", "Gross\ Neuendorf",
"494751", "Otterndorf",
"499423", "Geiselhöring",
"4935975", "Hohnstein",
"495203", "Werther\ Westfalen",
"494148", "Drochtersen\-Assel",
"498207", "Affing",
"4935363", "Fermerswalde",
"494525", "Ahrensbök",
"496282", "Walldürn",
"497384", "Schelklingen\-Hütten",
"494238", "Neddenaverbergen",
"497183", "Rudersberg\ Württemberg",
"498546", "Windorf\-Otterskirchen",
"49208", "Oberhausen\ Rheinland",
"496435", "Wallmerod",
"496707", "Windesheim",
"4934658", "Hayn\ Harz",
"499554", "Untersteinbach\ Unterfranken",
"496692", "Neustadt\ Hessen",
"498341", "Kaufbeuren",
"49201", "Essen",
"492297", "Wildbergerhütte",
"497936", "Schrozberg\-Bartenstein",
"497343", "Buch\ bei\ Illertissen",
"493663", "Schleiz",
"495190", "Soltau\-Emmingen",
"4938759", "Tewswoos",
"494204", "Thedinghausen",
"497144", "Marbach\ am\ Neckar",
"495045", "Springe\-Bennigsen",
"494152", "Geesthacht",
"4938875", "Schlagsdorf\ bei\ Gadebusch",
"4939953", "Schwinkendorf",
"494763", "Gnarrenburg",
"492687", "Horhausen\ Westerwald",
"495455", "Tecklenburg\-Brochterbeck",
"494630", "Barderup",
"49621", "Mannheim",
"499977", "Arnschwang",
"496875", "Nonnweiler\-Primstal",
"496349", "Billigheim\-Ingenheim",
"492861", "Borken\ Westfalen",
"4938294", "Neubukow",
"498532", "Griesbach\ im\ Rottal",
"497967", "Jagstzell",
"496374", "Weilerbach",
"497272", "Rülzheim",
"494954", "Moormerland",
"4938331", "Rakow\ Vorpom",
"496173", "Kronberg\ im\ Taunus",
"495961", "Haselünne",
"4933474", "Neutrebbin",
"499621", "Amberg\ Oberpfalz",
"499262", "Wallenfels",
"496827", "Eppelborn",
"499925", "Bayerisch\ Eisenstein",
"4936929", "Ruhla",
"497942", "Neuenstein\ Württemberg",
"495665", "Guxhagen",
"495658", "Wehretal",
"497653", "Lenzkirch",
"499833", "Heidenheim\ Mittelfranken",
"492743", "Daaden",
"493574", "Lauchhammer",
"4934424", "Reuden\ bei\ Zeitz",
"494292", "Ritterhude",
"498651", "Bad\ Reichenhall",
"4939771", "Ueckermünde",
"499135", "Hessdorf\ Mittelfranken",
"4933677", "Glienicke\ bei\ Beeskow",
"494682", "Amrum",
"496638", "Schwalmtal\-Renzendorf",
"492572", "Emsdetten",
"4935934", "Grossdubrau",
"495250", "Delbrück\ Westfalen",
"492157", "Nettetal\-Kaldenkirchen",
"497463", "Mühlheim\ an\ der\ Donau",
"4933367", "Friedrichswalde\ Brandenburg",
"495468", "Bramsche\-Engter",
"499473", "Kallmünz",
"496659", "Eichenzell",
"497126", "Burladingen\-Melchingen",
"498205", "Dasing",
"4939395", "Wanzer",
"49371", "Chemnitz\ Sachsen",
"4935955", "Pulsnitz",
"494841", "Husum\ Nordsee",
"4933458", "Falkenberg\ Mark",
"4934364", "Wermsdorf",
"4935820", "Zodel",
"498461", "Beilngries",
"49461", "Flensburg",
"4939207", "Colbitz",
"4934775", "Wippra",
"493838", "Bergen\ auf\ Rügen",
"495902", "Freren",
"499465", "Neukirchen\-Balbini",
"499826", "Weidenbach\ Mittelfranken",
"495421", "Dissen\ am\ Teutoburger\ Wald",
"4933451", "Heckelberg",
"4938791", "Bad\ Wilsnack",
"496139", "Budenheim",
"499201", "Gesees",
"497475", "Burladingen",
"4935240", "Tauscha\ bei\ Grossenhain",
"496246", "Eich\ Rheinhessen",
"497427", "Schömberg\ bei\ Balingen",
"495159", "Coppenbrügge\-Bisperode",
"498774", "Bayerbach\ bei\ Ergoldsbach",
"498582", "Röhrnbach",
"495564", "Dassel",
"494551", "Bad\ Segeberg",
"492802", "Alpen",
"492666", "Freilingen\ Westerwald",
"4936025", "Körner",
"4937363", "Zöblitz",
"494356", "Gross\ Wittensee",
"499655", "Tännesberg",
"496158", "Riedstadt",
"4938375", "Koserow",
"498131", "Dachau",
"495252", "Bad\ Lippspringe",
"493724", "Burgstädt",
"4935893", "Mücka",
"492637", "Weissenthurm",
"492722", "Attendorn",
"4933237", "Paulinenaue",
"4939778", "Ferdinandshof\ bei\ Torgelow",
"4935452", "Golssen",
"497308", "Nersingen",
"496741", "St\ Goar",
"497835", "Zell\ am\ Harmersbach",
"4937602", "Kirchberg\ Sachsen",
"499951", "Landau\ an\ der\ Isar",
"495303", "Wendeburg",
"494624", "Kropp",
"4936332", "Ellrich",
"49851", "Passau",
"4937423", "Adorf\ Vogtland",
"495138", "Sehnde",
"497334", "Deggingen",
"494288", "Horstedt\ Kreis\ Rotenburg",
"496232", "Speyer",
"497133", "Lauffen\ am\ Neckar",
"492456", "Selfkant",
"49203", "Duisburg",
"496485", "Nentershausen\ Westerwald",
"4934607", "Wettin",
"492828", "Emmerich\-Elten",
"499260", "Wilhelmsthal\ Oberfranken",
"497940", "Künzelsau",
"494646", "Mohrkirch",
"492395", "Finnentrop\-Rönkhausen",
"498402", "Münchsmünster",
"4939347", "Kade",
"498677", "Burghausen\ Salzach",
"495673", "Immenhausen\ Hessen",
"492171", "Leverkusen\-Opladen",
"499439", "Neunburg\-Kemnath",
"4939976", "Gross\ Bützin",
"496165", "Breuberg",
"4938483", "Brüel",
"4936945", "Henneberg",
"4939087", "Jerchel\ Altmark",
"4933604", "Lebus",
"499844", "Obernzenn",
"4936643", "Thimmendorf",
"499185", "Mühlhausen\ Oberpfalz",
"494632", "Steinbergkirche",
"492734", "Freudenberg\ Westfalen",
"498072", "Haag\ in\ Oberbayern",
"496505", "Kordel",
"4939754", "Löcknitz\ Vorpom",
"498856", "Penzberg",
"494495", "Friesoythe\-Thüle",
"495192", "Munster",
"496298", "Möckmühl",
"494775", "Grossenwörden",
"493971", "Anklam",
"497322", "Giengen\ an\ der\ Brenz",
"496224", "Sandhausen\ Baden",
"499345", "Külsheim\ Baden",
"4934651", "Rossla",
"493675", "Sonneberg\ Thüringen",
"494232", "Langwedel\ Kreis\ Verden",
"495182", "Gronau\ Leine",
"495367", "Rühen",
"498363", "Pfronten",
"494485", "Elsfleth\-Huntorf",
"499195", "Adelsdorf\ Mittelfranken",
"496698", "Schrecksbach",
"4936454", "Magdala",
"499371", "Miltenberg",
"497566", "Argenbühl",
"496624", "Heringen\ Werra",
"494741", "Nordholz\ bei\ Bremerhaven",
"499576", "Lichtenfels\-Isling",
"494158", "Roseburg",
"4939051", "Calvörde",
"493641", "Jena",
"497361", "Aalen",
"49381", "Rostock",
"494976", "Spiekeroog",
"4939007", "Tangeln",
"492843", "Rheinberg",
"4939995", "Nossendorf",
"496356", "Carlsberg\ Pfalz",
"499733", "Münnerstadt",
"492385", "Hamm\-Rhynern",
"49511", "Hannover",
"494246", "Twistringen\-Heiligenloh",
"496551", "Prüm",
"498225", "Jettingen\-Scheppach",
"498538", "Pocking\-Hartkirchen",
"494139", "Hohnstorf\ Elbe",
"4933967", "Freyenstein",
"4936845", "Gehlberg",
"495531", "Holzminden",
"495273", "Beverungen",
"497948", "Öhringen\-Ohrnberg",
"499268", "Teuschnitz",
"4936205", "Gräfenroda",
"4938233", "Prerow\ Ostseebad",
"4939600", "Zwiedorf",
"495336", "Semmenstedt",
"495943", "Emlichheim",
"498504", "Tittling",
"495652", "Bad\ Sooden\-Allendorf",
"499255", "Marktleugast",
"492761", "Olpe\ Biggesee",
"4937294", "Grünhainichen",
"492237", "Kerpen\ Rheinland\-Türnich",
"4933762", "Zeuthen",
"495130", "Wedemark",
"496775", "Strüth\ Taunus",
"494224", "Gross\ Ippener",
"494929", "Ihlow\ Kreis\ Aurich",
"496066", "Michelstadt\-Vielbrunn",
"496727", "Gensingen",
"497300", "Roggenburg",
"4936628", "Zeulenroda",
"494298", "Lilienthal",
"4936601", "Hermsdorf\ Thüringen",
"496150", "Weiterstadt",
"494505", "Stockelsdorf\-Curau",
"494165", "Hollenstedt\ Nordheide",
"499905", "Bernried\ Niederbayern",
"495462", "Ankum",
"4934446", "Grosskorbetha",
"497441", "Freudenstadt",
"499086", "Fremdingen",
"499529", "Oberaurach",
"497051", "Calw",
"495447", "Lembruch",
"498053", "Bad\ Endorf",
"4935695", "Simmersdorf",
"494863", "Sankt\ Peter\-Ording",
"496646", "Grebenau",
"498443", "Hohenwart\ Paar",
"492266", "Lindlar",
"498592", "Wegscheid\ Niederbayern",
"494827", "Wacken",
"499499", "Painten",
"497903", "Mainhardt",
"495908", "Wietmarschen\-Lohne",
"498756", "Nandlstadt",
"494189", "Undeloh",
"492834", "Straelen",
"4936737", "Drognitz",
"494173", "Wulfsen",
"499744", "Zeitlofs\-Detter",
"495146", "Wietze",
"498422", "Dollnstein",
"497587", "Hosskirch",
"495934", "Haren\-Rütenbrock",
"499357", "Gräfendorf\ Bayern",
"499779", "Nordheim\ von\ der\ Rhön",
"494349", "Dänischenhagen",
"494875", "Stafstedt",
"4936085", "Reinholterode",
"492335", "Wetter\ Ruhr",
"49421", "Bremen",
"4934293", "Naunhof\ bei\ Grimma",
"495258", "Salzkotten",
"496152", "Gross\-Gerau",
"497253", "Bad\ Schönborn",
"4936621", "Elsterberg\ bei\ Plauen",
"496630", "Schwalmtal\-Storndorf",
"496763", "Kirchberg\ Hunsrück",
"497302", "Pfaffenhofen\ an\ der\ Roth",
"4936608", "Seelingstädt\ bei\ Gera",
"496204", "Viernheim",
"492474", "Nideggen\-Schmidt",
"494707", "Langen\-Neuenwalde",
"496238", "Dirmstein",
"494282", "Sittensen",
"498251", "Aichach",
"495132", "Lehrte",
"496525", "Irrel",
"494435", "Grossenkneten",
"495650", "Cornberg",
"492449", "Blankenheim\ Ahr",
"497735", "Öhningen",
"496841", "Homburg\ Saar",
"49661", "Fulda",
"4935264", "Strehla",
"493377", "Zossen\ Brandenburg",
"492822", "Emmerich",
"499647", "Kirchenthumbach",
"492553", "Ochtrup",
"492369", "Dorsten\-Wulfen",
"497672", "St\ Blasien",
"499221", "Kulmbach",
"495401", "Georgsmarienhütte",
"496087", "Waldems",
"495265", "Dörentrup",
"4938423", "Bad\ Kleinen",
"499662", "Vilseck",
"495922", "Bad\ Bentheim",
"498434", "Rennertshofen",
"494638", "Tarp",
"496682", "Tann\ Rhön",
"499726", "Euerbach",
"49209", "Gelsenkirchen",
"498375", "Weitnau",
"4939058", "Uthmöden",
"497193", "Sulzbach\ an\ der\ Murr",
"4939742", "Brüssow\ bei\ Pasewalk",
"4938736", "Goldberg",
"497394", "Schelklingen",
"496292", "Seckach",
"495198", "Schneverdingen\-Wintermoor",
"494469", "Wangerooge",
"494604", "Grossenwiehe",
"495323", "Clausthal\-Zellerfeld",
"492697", "Blankenheim\-Ahrhütte",
"498191", "Landsberg\ am\ Lech",
"497328", "Königsbronn",
"4939853", "Holzendorf\ bei\ Prenzlau",
"498327", "Rettenberg",
"497025", "Neuffen",
"495071", "Schwarmstedt",
"494230", "Verden\-Walle",
"499452", "Langquaid",
"497136", "Bad\ Friedrichshall",
"492453", "Heinsberg\-Randerath",
"4939295", "Zuchau",
"499264", "Küps",
"492043", "Gladbeck",
"498685", "Kirchanschöring",
"4936949", "Obermassfeld\-Grimmenthal",
"497944", "Kupferzell",
"494952", "Rhauderfehn",
"498295", "Altenmünster\ Schwaben",
"497274", "Germersheim",
"4935055", "Höckendorf\ bei\ Dippoldiswalde",
"496372", "Bruchmühlbach\-Miesau",
"498534", "Tettenweis",
"495306", "Cremlingen",
"49731", "Ulm\ Donau",
"497249", "Stutensee",
"493861", "Plate",
"494109", "Tangstedt\ Bz\ Hamburg",
"4936603", "Weida",
"494353", "Ascheffel",
"494154", "Trittau",
"495161", "Walsrode",
"492663", "Westerburg\ Westerwald",
"4934298", "Taucha\ bei\ Leipzig",
"496628", "Oberaula",
"497142", "Bietigheim\-Bissingen",
"496243", "Monsheim",
"4938780", "Lanz\ Brandenburg",
"494202", "Achim\ bei\ Bremen",
"499552", "Burghaslach",
"496694", "Neukirchen\ Knüll",
"496220", "Wilhelmsfeld",
"499177", "Heideck",
"4936422", "Reinstädt\ Thüringen",
"499093", "Polsingen",
"499823", "Leutershausen",
"498168", "Attenkirchen",
"496284", "Mudau",
"497382", "Römerstein",
"4933970", "Neustadt\ Dosse",
"495481", "Lengerich\ Westfalen",
"496007", "Rosbach\-Rodheim",
"4936029", "Menteroda",
"4938231", "Barth",
"49271", "Siegen",
"499631", "Tirschenreuth",
"497851", "Kehl",
"499935", "Stephansposching",
"4939827", "Schwarz\ bei\ Neustrelitz",
"496837", "Wallerfangen",
"492957", "Wünnenberg\-Haaren",
"4937296", "Stollberg\ Erzgebirge",
"4935200", "Arnsdorf\ bei\ Dresden",
"495857", "Bleckede\-Brackede",
"4938428", "Hohenkirchen\ bei\ Wismar",
"495745", "Stemwede\-Levern",
"4934920", "Kropstädt",
"4934779", "Abberode",
"4933837", "Brielow",
"4939053", "Süplingen",
"4938457", "Krakow\ am\ See",
"494684", "Langeness\ Hallig",
"492574", "Saerbeck",
"492207", "Kürten\-Dürscheid",
"495676", "Liebenau\ Hessen",
"494294", "Riede\ Kreis\ Verden",
"496477", "Greifenstein\-Nenderoth",
"4934444", "Lützen",
"494535", "Nahe",
"494643", "Gelting\ Angeln",
"496866", "Perl\-Nennig",
"496425", "Rauschenberg\ Hessen",
"4939858", "Bietikow",
"4938379", "Benz\ Usedom",
"497332", "Lauterstein",
"496234", "Mutterstadt",
"4939851", "Göritz\ bei\ Prenzlau",
"494622", "Taarstedt",
"494405", "Edewecht",
"495102", "Laatzen",
"492724", "Finnentrop\-Serkenrode",
"494261", "Rotenburg\ Wümme",
"496595", "Dockweiler",
"492859", "Wesel\-Bislich",
"494737", "Stadland\-Schwei",
"495254", "Paderborn\-Schloss\ Neuhaus",
"493722", "Limbach\-Oberfrohna",
"494766", "Basdahl",
"497541", "Friedrichshafen",
"492804", "Xanten\-Marienbaum",
"495209", "Gütersloh\-Friedrichsdorf",
"499429", "Rain\ Niederbayern",
"498584", "Breitenberg\ Niederbayern",
"495562", "Dassel\-Markoldendorf",
"497346", "Illerkirchberg",
"497933", "Creglingen",
"4939399", "Kleinau",
"498772", "Mallersdorf\-Pfaffenberg",
"499748", "Motten",
"492305", "Castrop\-Rauxel",
"492838", "Sonsbeck",
"495904", "Lengerich\ Emsl",
"498543", "Aidenbach",
"4935796", "Panschwitz\-Kuckau",
"499151", "Hersbruck",
"4939247", "Güterglück",
"498635", "Pleiskirchen",
"496661", "Schlüchtern",
"492971", "Schmallenberg\-Dorlar",
"499867", "Geslau",
"498459", "Manching",
"495128", "Hohenhameln",
"492675", "Ediger\-Eller",
"496222", "Wiesloch",
"497324", "Herbrechtingen",
"497123", "Metzingen\ Württemberg",
"4935266", "Heyda\ bei\ Riesa",
"4938755", "Eldena",
"49202", "Wuppertal",
"492241", "Siegburg",
"494608", "Handewitt",
"495194", "Bispingen",
"498121", "Markt\ Schwaben",
"492627", "Braubach",
"4933337", "Altkünkendorf",
"4934291", "Borsdorf",
"492732", "Kreuztal",
"498074", "Schnaitsee",
"4933745", "Petkus",
"499842", "Uffenheim",
"4936623", "Berga\ Elster",
"497825", "Kippenheim",
"497466", "Beuron",
"494634", "Husby",
"496451", "Frankenberg\ Eder",
"496041", "Glauburg",
"4936925", "Marksuhl",
"498669", "Traunreut",
"497705", "Wolterdingen\ Schwarzw",
"498404", "Oberdolling",
"4939327", "Klietz",
"496887", "Schmelz\ Saar",
"494950", "Holtland",
"499836", "Gunzenhausen\-Cronheim",
"495431", "Quakenbrück",
"496129", "Schlangenbad",
"497656", "Schluchsee",
"493395", "Pritzwalk",
"499681", "Windischeschenbach",
"498502", "Fürstenzell",
"494958", "Jemgum",
"4935607", "Jänschwalde",
"498269", "Unteregg\ bei\ Mindelheim",
"493385", "Rathenow",
"4933652", "Neuzelle",
"493843", "Güstrow",
"4937368", "Deutschneudorf",
"497256", "Philippsburg",
"496766", "Kisselbach",
"499281", "Hof\ Saale",
"496897", "Sulzbach\ Saar",
"496027", "Stockstadt\ am\ Main",
"4938296", "Rerik\ Ostseebad",
"494939", "Baltrum",
"492945", "Lippstadt\-Benninghausen",
"4939773", "Altwarp",
"497751", "Waldshut",
"496737", "Köngernheim",
"496261", "Mosbach\ Baden",
"496405", "Laubach\ Hessen",
"497148", "Grossbottwar",
"496622", "Bebra",
"495344", "Lengede",
"492275", "Kerpen\-Buir",
"49281", "Wesel",
"494208", "Grasberg",
"492641", "Bad\ Neuenahr\-Ahrweiler",
"495143", "Winsen\ Aller",
"4938720", "Grebbin",
"497085", "Enzklösterle",
"494176", "Marschacht",
"492227", "Bornheim\-Merten",
"49591", "Lingen\ \(Ems\)",
"495383", "Lutter\ am\ Barenberge",
"4936482", "Triptis",
"498753", "Elsendorf\ Niederbayern",
"494234", "Dörverden",
"497388", "Pfronstetten",
"495845", "Bergen\ Dumme",
"495379", "Sassenburg\-Grussendorf",
"4933476", "Neuhardenberg",
"498387", "Weiler\-Simmerberg",
"497906", "Braunsbach",
"495184", "Freden\ Leine",
"494129", "Haseldorf",
"497575", "Messkirch",
"495521", "Herzberg\ am\ Harz",
"4936962", "Vacha",
"495609", "Ahnatal",
"4939887", "Gerswalde",
"499565", "Untersiemau",
"495326", "Langelsheim",
"4938333", "Horst\ bei\ Grimmen",
"4935775", "Pechern",
"4938488", "Demen",
"499723", "Röthlein",
"4935936", "Sohland\ Spree",
"495464", "Alfhausen",
"494451", "Varel\ Jadebusen",
"4934426", "Kayna",
"497527", "Wolfegg",
"4939951", "Faulenrost",
"499803", "Colmberg",
"496634", "Gemünden\ Felda",
"4936648", "Dittersdorf\ bei\ Schleiz",
"493578", "Kamenz",
"494222", "Ganderkesee",
"493761", "Werdau\ Sachsen",
"496585", "Ralingen",
"494965", "Surwold",
"492556", "Metelen",
"499105", "Grosshabersdorf",
"492351", "Lüdenscheid",
"49841", "Ingolstadt\ Donau",
"495654", "Herleshausen",
"494661", "Niebüll",
"495946", "Georgsdorf",
"495333", "Dettum",
"4934653", "Rottleberode",
"497805", "Appenweier",
"494284", "Selsingen",
"498337", "Altenstadt\ Iller",
"492607", "Kobern\-Gondorf",
"495276", "Marienmünster",
"497304", "Blaustein\ Württemberg",
"496202", "Schwetzingen",
"492472", "Monschau",
"495108", "Gehrden\ Han",
"494243", "Twistringen",
"496569", "Bickendorf",
"496353", "Freinsheim",
"499736", "Oberthulba",
"4936465", "Oberndorf\ bei\ Apolda",
"494973", "Wittmund\-Burhafe",
"496787", "Niederbrombach",
"496154", "Ober\-Ramstadt",
"4937755", "Schönheide\ Erzgebirge",
"4938481", "Witzin",
"499231", "Marktredwitz",
"4939927", "Nossentiner\ Hütte",
"496109", "Frankfurt\-Bergen\-Enkheim",
"499573", "Staffelstein\ Oberfranken",
"495932", "Haren\ Ems",
"493335", "Finowfurt",
"498424", "Nassenfels",
"497777", "Sauldorf",
"495491", "Damme\ Dümmer",
"497563", "Kisslegg",
"498561", "Pfarrkirchen\ Niederbayern",
"499742", "Kalbach\ Rhön",
"497725", "Königsfeld\ im\ Schwarzwald",
"495771", "Rahden\ Westfalen",
"492832", "Kevelaer",
"4935364", "Lebusa",
"494372", "Westfehmarn",
"498366", "Oy\-Mittelberg",
"4934955", "Gossa",
"493834", "Greifswald",
"499454", "Aufhausen\ Oberpfalz",
"492263", "Engelskirchen",
"496228", "Schönau\ Odenwald",
"498446", "Pörnbach",
"496535", "Osann\-Monzel",
"494602", "Freienwill",
"4937421", "Oelsnitz\ Vogtland",
"494425", "Wangerland\-Hooksiel",
"498056", "Eggstätt",
"496643", "Herbstein",
"494477", "Lastrup\-Hemmelte",
"4939722", "Sarnow\ bei\ Anklam",
"496294", "Krautheim\ Jagst",
"497392", "Laupheim",
"4933870", "Zollchow\ bei\ Rathenow",
"495555", "Moringen\-Fredelsloh",
"4933606", "Müllrose",
"496620", "Philippsthal\ Werra",
"499083", "Möttingen",
"492738", "Netphen",
"496684", "Hofbieber\-Schwarzbach",
"4935891", "Rothenburg\ OL",
"499848", "Simmershofen",
"4936209", "Klettbach",
"498432", "Burgheim",
"498285", "Burtenbach",
"4935477", "Rietzneuendorf\-Friedrichshof",
"499664", "Hahnbach",
"4937361", "Neuhausen\ Erzgebirge",
"495924", "Bad\ Bentheim\-Gildehaus",
"4936849", "Kleinschmalkalden",
"492325", "Wanne\-Eickel",
"4935020", "Struppen",
"496063", "Bad\ König",
"497674", "Todtmoos",
"492759", "Bad\ Berleburg\-Aue",
"4939387", "Havelberg",
"494837", "Neuenkirchen\ Dithmarschen",
"4938793", "Dergenthin",
"492377", "Wickede\ Ruhr",
"499409", "Pielenhofen",
"4939999", "Tutow",
"4933732", "Hennickendorf\ bei\ Luckenwalde",
"492824", "Kalkar",
"4934602", "Landsberg\ Sachsen\-Anhalt",
"496441", "Wetzlar",
"492588", "Harsewinkel\-Greffen",
"492422", "Kreuzau",
"492605", "Löf",
"498038", "Vogtareuth",
"496051", "Gelnhausen",
"498335", "Fellheim",
"4934673", "Heldrungen",
"497807", "Neuried\ Ortenaukreis",
"494923", "Krummhörn\-Pewsum",
"498808", "Pähl",
"4939342", "Gladau",
"496785", "Herrstein",
"492590", "Dülmen\-Buldern",
"493561", "Guben",
"4935933", "Neschwitz",
"495226", "Bruchmühlen\ Westfalen",
"4934423", "Heuckewalde",
"493366", "Beeskow",
"497646", "Weisweil\ Breisgau",
"499406", "Mintraching",
"4939978", "Gross\ Roge",
"4939082", "Mieste",
"495031", "Wunstorf",
"497775", "Mühlingen",
"495721", "Stadthagen",
"493337", "Biesenthal\ Brandenburg",
"494322", "Bordesholm",
"499765", "Trappstadt",
"492251", "Euskirchen",
"499076", "Wittislingen",
"497632", "Badenweiler",
"4934363", "Cavertitz",
"499523", "Hofheim\ in\ Unterfranken",
"497150", "Korntal\-Münchingen",
"4934975", "Görzig\ Kreis\ Köthen",
"497066", "Bad\ Rappenau\-Bonfeld",
"497727", "Vöhrenbach",
"499852", "Feuchtwangen",
"498728", "Geratskirchen",
"4939222", "Möser",
"497551", "Überlingen\ Bodensee",
"496106", "Rodgau",
"493991", "Waren\ Müritz",
"496670", "Ludwigsau\ Hessen",
"494795", "Garlstedt",
"499381", "Volkach",
"492434", "Wegberg",
"493695", "Bad\ Salzungen",
"497356", "Schemmerhofen",
"4933925", "Wustrau\-Altfriesack",
"498092", "Grafing\ bei\ München",
"498822", "Oberammergau",
"4939954", "Stavenhagen\ Reuterstadt",
"495172", "Ilsede",
"492408", "Aachen\-Kornelimünster",
"498553", "Spiegelau",
"498369", "Rückholz",
"499141", "Weissenburg\ in\ Bayern",
"494475", "Molbergen",
"495693", "Volkmarsen",
"492191", "Remscheid",
"4939776", "Hintersee",
"498702", "Wörth\ an\ der\ Isar",
"4938293", "Kühlungsborn\ Ostseebad",
"492327", "Bochum\-Wattenscheid",
"4939489", "Strassberg\ Harz",
"494334", "Bredenbek\ bei\ Rendsburg",
"4933232", "Brieselang",
"492874", "Isselburg",
"4937607", "Ebersbrunn\ Sachsen",
"495283", "Lügde\-Rischenau",
"494133", "Wittorf\ Kreis\ Lüneburg",
"4936337", "Schiedungen",
"496361", "Rockenhausen",
"494308", "Schwedeneck",
"496566", "Körperich",
"497624", "Grenzach\-Wyhlen",
"492375", "Balve",
"4933473", "Zechin",
"495244", "Rietberg",
"494835", "Albersdorf\ Holstein",
"496394", "Bundenthal",
"4935361", "Schlieben",
"497682", "Elzach",
"492363", "Datteln",
"4938484", "Ventschow",
"492164", "Jüchen\-Otzenrath",
"4933603", "Falkenhagen\ bei\ Seelow",
"4933672", "Pfaffendorfb\ Beeskow",
"496328", "Elmstein",
"494126", "Horst\ Holstein",
"4933362", "Liepe\ Kreis\ Barnim",
"498145", "Mammendorf",
"495606", "Zierenberg",
"495862", "Hitzacker\ Elbe",
"496407", "Rabenau\ Hessen",
"4936644", "Hirschberg\ Saale",
"497841", "Achern",
"496735", "Eppelsheim",
"492504", "Telgte",
"49761", "Freiburg\ im\ Breisgau",
"492947", "Anröchte",
"4939753", "Strasburg",
"495329", "Schulenberg\ im\ Oberharz",
"498385", "Hergatz",
"494463", "Wangerland",
"493964", "Bredenfelde\ bei\ Strasburg",
"4933456", "Wriezen",
"4938796", "Viesecke",
"495755", "Kalletal\-Varenholz",
"492225", "Meckenheim\ Rheinland",
"492962", "Olsberg",
"496672", "Eiterfeld",
"492538", "Drensteinfurt\-Rinkerode",
"4938220", "Wustrow\ Ostseebad",
"4939202", "Gross\ Ammensleben",
"496302", "Winnweiler",
"497204", "Malsch\-Völkersbach",
"4934656", "Wallhausen\ Sachsen\-Anhalt",
"4935755", "Ortrand",
"494343", "Laboe",
"494936", "Grossheide",
"494144", "Himmelpforten",
"499773", "Unsleben",
"494885", "Bergenhusen",
"499567", "Sesslach\-Gemünda",
"497152", "Leonberg\ Württemberg",
"495768", "Petershagen\-Heimsen",
"496253", "Fürth\ Odenwald",
"497577", "Veringenstadt",
"497763", "Murg",
"498761", "Moosburg\ an\ der\ Isar",
"494384", "Selent",
"499542", "Schesslitz",
"494179", "Winsen\-Tönnhausen",
"498237", "Aindling",
"497525", "Aulendorf",
"495233", "Steinheim\ Westfalen",
"494183", "Jesteburg",
"495571", "Uslar",
"4937364", "Reitzenhain\ Erzgebirge",
"494320", "Heidmühlen",
"499493", "Beratzhausen",
"49341", "Leipzig",
"495376", "Wesendorf\ Kreis\ Gifhorn",
"4939039", "Bonese",
"492443", "Mechernich",
"494272", "Siedenburg",
"493594", "Bischofswerda",
"492053", "Velbert\-Neviges",
"497954", "Kirchberg\ an\ der\ Jagst",
"494942", "Südbrookmerland",
"4935894", "Hähnichen",
"498266", "Kirchheim\ in\ Schwaben",
"4939971", "Gnoien",
"492592", "Selm",
"492484", "Mechernich\-Eiserfey",
"499331", "Ochsenfurt",
"499536", "Kirchlauter",
"499107", "Trautskirchen",
"497259", "Östringen\-Odenheim",
"493528", "Radeberg",
"496587", "Zerf",
"494967", "Rhauderfehn\-Burlage",
"494672", "Langenhorn",
"492582", "Everswinkel",
"498032", "Rohrdorf\ Kreis\ Rosenheim",
"492428", "Niederzier",
"492774", "Dietzhölztal",
"493772", "Schneeberg\ Erzgebirge",
"498802", "Huglfing",
"4937293", "Eppendorf\ Sachsen",
"498666", "Teisendorf",
"493931", "Stendal",
"494735", "Butjadingen\-Stollhamm",
"496597", "Jünkerath",
"496126", "Idstein",
"493635", "Kölleda",
"494407", "Wardenburg",
"4939056", "Klüden",
"499444", "Siegenburg",
"49251", "Münster",
"4938738", "Karow\ bei\ Lübz",
"494328", "Rickling",
"498456", "Lenting",
"4939747", "Züsedom",
"498046", "Bad\ Heilbrunn",
"4937200", "Wittgensdorf\ bei\ Chemnitz",
"496653", "Burghaun",
"498637", "Lohkirchen",
"495545", "Hedemünden",
"4937430", "Eichigt",
"492131", "Neuss",
"495633", "Diemelsee",
"494193", "Henstedt\-Ulzburg",
"4934261", "Kühren\ bei\ Wurzen",
"492307", "Kamen",
"498722", "Gangkofen",
"4934639", "Wallendorf\ Luppe",
"494394", "Bokhorst",
"498171", "Wolfratshausen",
"494769", "Bremervörde\-Iselersheim",
"499426", "Oberschneiding",
"499865", "Adelshofen\ Mittelfranken",
"492677", "Lutzerath",
"4936453", "Mellingen",
"495206", "Bielefeld\-Jöllenbeck",
"4938859", "Alt\ Zachun",
"495821", "Bad\ Bevensen",
"498024", "Holzkirchen",
"4936732", "Könitz",
"4933439", "Fredersdorf\-Vogelsdorf",
"49721", "Karlsruhe",
"494903", "Wymeer",
"499364", "Zellingen",
"4933209", "Caputh",
"492921", "Soest",
"499163", "Dachsbach",
"497374", "Uttenweiler",
"496272", "Hirschhorn\ Neckar",
"492402", "Stolberg\ Rheinland",
"492625", "Ochtendung",
"4934441", "Hohenmölsen",
"497173", "Heubach",
"498395", "Tannheim\ Württemberg",
"4933849", "Wiesenburg\ Mark",
"498708", "Weihmichl\-Unterneuhausen",
"495956", "Rastdorf",
"497707", "Bräunlingen",
"4936606", "Kraftsdorf",
"4936870", "Masserberg",
"4938391", "Altenkirchen\ Rügen",
"499503", "Oberhaid\ Oberfranken",
"496384", "Konken",
"496183", "Erlensee",
"497435", "Albstadt\-Laufen",
"498734", "Reisbach\ Niederbayern",
"4938234", "Born\ Darss",
"494253", "Asendorf\ Kreis\ Diepholz",
"496343", "Bad\ Bergzabern",
"494302", "Kirchbarkau",
"492856", "Hamminkeln\-Brünen",
"496144", "Bischofsheim\ bei\ Rüsselsheim",
"495293", "Paderborn\-Dahl",
"4933767", "Friedersdorf\ bei\ Berlin",
"499433", "Nabburg",
"498687", "Taching\-Tengling",
"497505", "Fronreute",
"495683", "Wabern\ Hessen",
"492181", "Grevenbroich",
"4935263", "Gröditz\ bei\ Riesa",
"4938424", "Bobitz",
"492546", "Coesfeld\-Lette",
"496869", "Merzig\-Silwingen",
"4939409", "Eilsleben",
"495644", "Willebadessen\-Peckelsheim",
"496322", "Bad\ Dürkheim",
"497224", "Gernsbach",
"4936626", "Auma",
"4936652", "Wurzbach",
"493685", "Hildburghausen",
"499127", "Rosstal\ Mittelfranken",
"499391", "Marktheidenfeld",
"499873", "Abenberg\-Wassermungenau",
"493981", "Neustrelitz",
"497165", "Göppingen\-Hohenstaufen",
"492532", "Ostbevern",
"496678", "Wildeck\-Hönebach",
"499175", "Spalt",
"494441", "Vechta",
"4939854", "Kleptow",
"498861", "Schongau",
"498082", "Schwindegg",
"495064", "Gross\ Düngen",
"492955", "Büren\-Wewelsburg",
"496308", "Olsbrücken",
"499937", "Oberpöring",
"496835", "Beckingen",
"497741", "Tiengen\ Hochrhein",
"498784", "Hohenthann",
"494361", "Oldenburg\ in\ Holstein",
"497158", "Neuhausen\ auf\ den\ Fildern",
"495354", "Jerxheim",
"498157", "Feldafing",
"495153", "Salzhemmendorf",
"492651", "Mayen",
"498572", "Tann\ Niederbayern",
"499548", "Mühlhausen\ Mittelfranken",
"497232", "Königsbach\-Stein",
"496334", "Thaleischweiler\-Fröschen",
"496133", "Oppenheim",
"4938731", "Lübz",
"497485", "Empfingen",
"498743", "Geisenhausen",
"495855", "Nahrendorf",
"4936370", "Grossenehrich",
"4939265", "Löderburg",
"4939002", "Oebisfelde",
"497139", "Neuenstadt\ am\ Kocher",
"496475", "Weilmünster\-Wolfenhausen",
"492205", "Rösrath",
"4934294", "Rackwitz",
"492461", "Jülich",
"494948", "Wiesmoor\-Marcardsmoor",
"492598", "Senden\-Ottmarsbocholt",
"495309", "Lehre\-Wendhausen",
"4933962", "Heiligengrabe",
"497976", "Sulzbach\-Laufen",
"492524", "Ennigerloh",
"4933089", "Himmelpfort",
"497246", "Malsch\ Kreis\ Karlsruhe",
"496427", "Cölbe\-Schönstadt",
"499966", "Wiesenfelden",
"495626", "Bad\ Zwesten",
"494106", "Quickborn\ Kreis\ Pinneberg",
"494537", "Sülfeld\ Holstein",
"4935793", "Elstra",
"493522", "Grossenhain\ Sachsen",
"499090", "Rain\ Lech",
"499820", "Lehrberg",
"4934324", "Ostrau\ Sachsen",
"492268", "Kürten",
"497122", "St\ Johann\ Württemberg",
"496648", "Bad\ Salzschlirf",
"499145", "Solnhofen",
"4934498", "Rositz",
"494471", "Cloppenburg",
"496223", "Neckargemünd",
"499088", "Mönchsdeggingen",
"497555", "Deggenhausertal",
"494791", "Osterholz\-Scharmbeck",
"499843", "Burgbernheim",
"495069", "Nordstemmen",
"499385", "Kolitzheim",
"492733", "Hilchenbach",
"493691", "Eisenach\ Thüringen",
"4938724", "Siggelkow",
"4936256", "Wechmar",
"4934464", "Freyburg\ Unstrut",
"496068", "Beerfelden",
"492371", "Iserlohn",
"495674", "Grebenstein",
"494296", "Schwanewede\-Aschwarden",
"496864", "Mettlach",
"492195", "Radevormwald",
"4939745", "Hetzdorf\ bei\ Strasburg",
"497229", "Iffezheim",
"499266", "Mitwitz",
"495805", "Oetzen",
"4936969", "Merkers",
"497946", "Bretzfeld",
"497333", "Laichingen",
"497134", "Weinsberg",
"4936082", "Ershausen",
"496781", "Idar\-Oberstein",
"497276", "Herxheim\ bei\ Landau\ Pfalz",
"495035", "Gross\ Munzel",
"4934244", "Mockrehna",
"494248", "Bassum\-Neubruchhausen",
"492601", "Nauort",
"495103", "Wennigsen\ Deister",
"492529", "Oelde\-Stromberg",
"496055", "Freigericht",
"496445", "Schöffengrund",
"498536", "Kösslarn",
"494623", "Böklund",
"495304", "Meine",
"493723", "Hohenstein\-Ernstthal",
"498331", "Memmingen",
"492905", "Bestwig\-Ramsbeck",
"496358", "Kriegsfeld",
"494156", "Talkau",
"497568", "Bad\ Wurzach\-Hauerz",
"497932", "Niederstetten\ Württemberg",
"498773", "Neufahrn\ in\ Niederbayern",
"495777", "Diepenau\-Essern",
"495563", "Kreiensen",
"4938228", "Dettmannsdorf\-Kölzow",
"495725", "Lindhorst\ bei\ Stadthagen",
"497771", "Stockach",
"496339", "Grosssteinhausen",
"4938841", "Neuhaus\ Elbe",
"496696", "Gilserberg",
"492255", "Euskirchen\-Flamersheim",
"496286", "Walldürn\-Rippberg",
"4935826", "Königshain\ bei\ Görlitz",
"4938201", "Gelbensande",
"499761", "Bad\ Königshofen\ im\ Grabfeld",
"498542", "Ortenburg",
"4938221", "Marlow",
"498765", "Bruckberg\ Niederbayern",
"4938848", "Vellahn",
"4935246", "Ziegenhain\ Sachsen",
"4938208", "Kavelstorf",
"4933053", "Zehlendorf\ Kreis\ Oberhavel",
"497326", "Neresheim",
"494881", "Friedrichstadt",
"499474", "Schmidmühlen",
"499728", "Wülfershausen\ Unterfranken",
"497930", "Boxberg\ Baden",
"495196", "Wietzendorf",
"497464", "Talheim\ Kreis\ Tuttlingen",
"494636", "Langballig",
"4933765", "Märkisch\ Buchholz",
"498076", "Pfaffing",
"495527", "Duderstadt",
"492779", "Greifenstein\-Beilstein",
"492357", "Herscheid\ Westfalen",
"499335", "Aub\ Kreis\ Würzburg",
"494667", "Dagebüll",
"493573", "Senftenberg",
"4934783", "Gerbstedt",
"4935692", "Kerkwitz",
"494642", "Kappeln\ Schlei",
"499834", "Theilenhofen",
"498406", "Böhmfeld",
"492744", "Herdorf",
"497654", "Löffingen",
"496236", "Neuhofen\ Pfalz",
"4935326", "Schönborn\ Kreis\ Elbe\-Elster",
"496021", "Aschaffenburg",
"492452", "Heinsberg\ Rheinland",
"499287", "Selb",
"496373", "Schönenberg\-Kübelberg",
"494953", "Bunde",
"4937463", "Bergen\ Vogtland",
"496174", "Königstein\ im\ Taunus",
"4933874", "Stechow\ Brandenburg",
"4935024", "Stadt\ Wehlen",
"492662", "Hachenburg",
"494764", "Gnarrenburg\-Klenkendorf",
"498381", "Lindenberg\ im\ Allgäu",
"4936202", "Neudietendorf",
"495751", "Rinteln",
"4937323", "Lichtenberg\ Erzgebirge",
"494352", "Damp",
"496242", "Osthofen",
"497344", "Blaubeuren",
"495148", "Steinhorst\ Niedersachsen",
"494203", "Weyhe\ bei\ Bremen",
"498029", "Kreuth\ bei\ Tegernsee",
"498586", "Hauzenberg",
"4934741", "Frose",
"497143", "Besigheim",
"4936842", "Oberhof\ Thüringen",
"498141", "Fürstenfeldbruck",
"495085", "Burgdorf\-Ehlershausen",
"49791", "Schwäbisch\ Hall",
"499553", "Ebrach\ Oberfranken",
"492647", "Kesseling",
"499369", "Uettingen",
"4934491", "Schmölln\ Thüringen",
"4939267", "Schneidlingen",
"497383", "Münsingen\-Buttenhausen",
"497184", "Kaisersbach",
"499092", "Wemding",
"496267", "Fahrenbach\ Baden",
"495906", "Lünne",
"499822", "Bechhofen\ an\ der\ Heide",
"4939992", "Görmin",
"496731", "Alzey",
"492262", "Wiehl",
"4934384", "Grossbothen",
"492925", "Warstein\-Allagen",
"4937431", "Mehltheuer\ Vogtland",
"495324", "Vienenburg",
"494603", "Havetoft",
"496642", "Schlitz",
"497128", "Sonnenbühl",
"4930", "Berlin",
"492509", "Nottuln\-Appelhülsen",
"492621", "Lahnstein",
"495123", "Schellerten",
"4936694", "Schkölen\ Thüringen",
"49355", "Cottbus",
"4936378", "Ostramondra",
"497194", "Spiegelberg",
"499861", "Rothenburg\ ob\ der\ Tauber",
"499082", "Oettingen\ in\ Bayern",
"492247", "Neunkirchen\-Seelscheid",
"497393", "Munderkingen",
"493969", "Siedenbollentin",
"495466", "Merzen",
"496667", "Steinau\-Ulmbach",
"492977", "Schmallenberg\-Bödefeld",
"4939453", "Derenburg",
"495825", "Wieren",
"496636", "Romrod",
"4938784", "Kleinow\ Kreis\ Prignitz",
"495437", "Menslage",
"498433", "Königsmoos",
"496062", "Erbach\ Odenwald",
"496881", "Lebach",
"4934977", "Quellendorf",
"495705", "Petershagen\-Windheim",
"4938823", "Selmsdorf",
"4933974", "Dessow",
"4934346", "Narsdorf",
"492554", "Laer\ Kreis\ Steinfurt",
"495656", "Waldkappel",
"497431", "Albstadt\-Ebingen",
"4939606", "Glienke",
"496457", "Burgwald\ Eder",
"496047", "Altenstadt\ Hessen",
"493886", "Gadebusch",
"497959", "Frankenhardt",
"4935204", "Wilsdruff",
"493935", "Tangerhütte",
"4936022", "Grossengottern",
"494731", "Nordenham",
"495332", "Schöppenstedt",
"494267", "Lauenbrück",
"493631", "Nordhausen\ Thüringen",
"4933927", "Linum",
"4935844", "Oybin\ Kurort",
"496203", "Ladenburg",
"492473", "Simmerath",
"4937348", "Oberwiesenthal\ Kurort",
"494242", "Syke",
"4934924", "Zahna",
"4935434", "Altdöbern",
"494972", "Langeoog",
"4934772", "Helbra",
"4936871", "Bad\ Colberg\-Heldburg",
"497254", "Waghäusel",
"496352", "Kirchheimbolanden",
"496764", "Rheinböllen",
"494149", "Fredenbeck",
"499572", "Burgkunstadt",
"499157", "Alfeld\ Mittelfranken",
"495541", "Hann\.\ Münden",
"497938", "Mulfingen\ Jagst",
"497562", "Isny\ im\ Allgäu",
"499720", "Üchtelhausen",
"495933", "Lathen",
"495346", "Liebenburg",
"4935455", "Walddrehna",
"492833", "Kerken",
"4938303", "Sellin\ Ostseebad",
"4936335", "Grosswechsungen",
"494174", "Stelle\ Kreis\ Harburg",
"4937605", "Hartenstein\ Sachsen",
"494236", "Kirchlinteln",
"4938372", "Usedom",
"495186", "Salzhemmendorf\-Wallensen",
"497904", "Ilshofen",
"498548", "Vilshofen\-Sandbach",
"4934206", "Rötha",
"495851", "Dahlenburg",
"4938323", "Prohn",
"498054", "Breitbrunn\ am\ Chiemsee",
"494864", "Oldenswort",
"498444", "Schweitenkirchen",
"499722", "Werneck",
"497745", "Jestetten",
"496831", "Saarlouis",
"498858", "Kochel\-Walchensee",
"492951", "Büren",
"496296", "Ahorn\ Baden",
"492655", "Weibern",
"499637", "Falkenberg\ Oberpfalz",
"494365", "Heringsdorf\ Holstein",
"499802", "Ansbach\-Katterbach",
"499666", "Illschwang",
"4937341", "Ehrenfriedersdorf",
"495926", "Engden",
"4939392", "Rönnebeck\ Sachsen\-Anhalt",
"4934904", "Oranienbaum",
"4936878", "Oberland",
"497676", "Feldberg\ Schwarzwald",
"494240", "Syke\-Heiligenfelde",
"4935952", "Grossröhrsdorf\ OL",
"496471", "Weilburg",
"494223", "Ganderkesee\-Bookholzberg",
"492465", "Inden",
"492826", "Kranenburg\ Niederrhein",
"4938872", "Rehna",
"495507", "Ebergötzen",
"494286", "Gyhum",
"495136", "Burgdorf\ Kreis\ Hannover",
"4933702", "Wünsdorf",
"495944", "Hoogstede",
"493867", "Lübstorf",
"4935386", "Prettin",
"498503", "Neuhaus\ am\ Inn",
"499708", "Bad\ Bocklet",
"495274", "Nieheim",
"494339", "Christiansholm",
"497306", "Vöhringen\ Iller",
"493476", "Hettstedt\ Sachsen\-Anhalt",
"49531", "Braunschweig",
"492844", "Rheinberg\-Orsoy",
"497629", "Tegernau\ Baden",
"499734", "Burkardroth",
"4937208", "Auerswalde",
"4936371", "Schlossvippach",
"494358", "Loose\ bei\ Eckernförde",
"4937383", "Lunzenau",
"497161", "Göppingen",
"498426", "Walting\ Kreis\ Eichstätt",
"495142", "Eschede",
"4933636", "Steinhöfel\ Kreis\ Oder\-Spree",
"499171", "Roth\ Mittelfranken",
"4935728", "Uhyst\ Spree",
"496623", "Rotenburg\ an\ der\ Fulda",
"494445", "Visbek\ Kreis\ Vechta",
"499080", "Harburg\ Schwaben",
"493681", "Suhl",
"499395", "Triefenstein",
"4937438", "Bad\ Brambach",
"493836", "Wolgast",
"498364", "Seeg",
"495167", "Walsrode\-Westenholz",
"499828", "Rügland",
"495382", "Bad\ Gandersheim",
"498752", "Au\ in\ der\ Hallertau",
"496104", "Heusenstamm",
"499772", "Bischofsheim\ an\ der\ Rhön",
"4933971", "Kyritz\ Brandenburg",
"496303", "Enkenbach\-Alsenborn",
"495741", "Lübbecke",
"494342", "Preetz\ Kreis\ Plön",
"497354", "Erolzheim",
"496252", "Heppenheim\ Bergstrasse",
"495158", "Hemeringen",
"497762", "Wehr\ Baden",
"492436", "Wegberg\-Rödgen",
"497153", "Plochingen",
"498151", "Starnberg",
"4938781", "Mellen",
"495232", "Lage\ Lippe",
"496138", "Mommenheim",
"494367", "Grossenbrode",
"494182", "Tostedt",
"499635", "Bärnau",
"495485", "Ladbergen",
"499543", "Hirschaid",
"492657", "Uersfeld",
"4935605", "Komptendorf",
"499492", "Parsberg",
"499931", "Plattling",
"497747", "Berau",
"495139", "Burgwedel",
"492052", "Velbert\-Langenberg",
"4937204", "Lichtenstein\ Sachsen",
"496421", "Marburg",
"494289", "Kirchtimke",
"494531", "Bad\ Oldesloe",
"494273", "Kirchdorf\ bei\ Sulingen",
"492593", "Ascheberg\ Westfalen",
"494336", "Owschlag",
"494943", "Grossefehn",
"4935724", "Lohsa",
"4934381", "Colditz",
"495976", "Salzbergen",
"497309", "Weissenhorn",
"494920", "Wirdum",
"4938306", "Samtens",
"4937434", "Bobenneukirchen",
"497626", "Kandern",
"4934632", "Mücheln\ Geiseltal",
"496159", "Messel",
"495246", "Verl",
"4934223", "Dommitzsch",
"4936691", "Eisenberg\ Thüringen",
"496564", "Neuerburg\ Eifel",
"496192", "Hofheim\ am\ Taunus",
"493865", "Holthusen",
"4936739", "Rottenbach",
"4933432", "Müncheberg",
"4939362", "Grieben\ bei\ Tangerhütte",
"497683", "Simonswald",
"4938852", "Wittenburg",
"499438", "Fensterbach",
"495505", "Hardegsen",
"4933202", "Töplitz",
"4939885", "Jakobshagen",
"498681", "Waging\ am\ See",
"492362", "Dorsten",
"492754", "Bad\ Laasphe\-Feudingen",
"495224", "Enger\ Westfalen",
"4939456", "Altenbrak",
"493364", "Eisenhüttenstadt",
"498291", "Zusmarshausen",
"499404", "Nittendorf",
"497644", "Kenzingen",
"4939422", "Badersleben",
"494447", "Vechta\-Langförden",
"498550", "Philippsreut",
"495863", "Zernien",
"4934921", "Kemberg",
"498867", "Rottenbuch\ Oberbayern",
"4936874", "Schönbrunn\ bei\ Hildburghaus",
"49375", "Zwickau",
"495165", "Rethem\ Aller",
"4935201", "Langebrück",
"4938826", "Dassow",
"493987", "Templin",
"499074", "Höchstädt\ an\ der\ Donau",
"494462", "Wittmund",
"4934343", "Regis\-Breitingen",
"4939603", "Burg\ Stargard",
"4935841", "Grossschönau\ Sachsen",
"499397", "Wertheim\-Dertingen",
"49465", "Sylt",
"496673", "Haunetal",
"492963", "Brilon\-Messinghausen",
"494146", "Stade\-Bützfleth",
"4935208", "Radeburg",
"4935383", "Elster\ Elbe",
"493433", "Borna\ Stadt",
"494934", "Marienhafe",
"497821", "Lahr\ Schwarzwald",
"4936782", "Schmiedefeld\ am\ Rennsteig",
"492927", "Neuengeseke",
"49521", "Bielefeld",
"495875", "Emmendorf",
"495827", "Unterlüss",
"492975", "Schmallenberg\-Oberkirchen",
"496665", "Sinntal\-Altengronau",
"4937344", "Crottendorf\ Sachsen",
"498093", "Glonn\ Kreis\ Ebersberg",
"4934928", "Seegrehna",
"498823", "Mittenwald",
"4934901", "Rosslau\ Elbe",
"495374", "Isenbüttel",
"492245", "Much",
"498177", "Münsing\ Starnberger\ See",
"494239", "Dörverden\-Westen",
"495173", "Uetze",
"492671", "Cochem",
"4939402", "Völpke",
"498552", "Grafenau\ Niederbayern",
"495707", "Petershagen\ Weser",
"493596", "Neustadt\ in\ Sachsen",
"495692", "Wolfhagen",
"499295", "Töpen",
"498703", "Essenbach",
"493391", "Neuruppin",
"492360", "Haltern\-Lippramsdorf",
"495282", "Schieder\-Schwalenberg",
"496188", "Kahl\ am\ Main",
"494132", "Amelinghausen",
"495435", "Berge\ bei\ Quakenbrück",
"4933633", "Spreenhagen",
"494258", "Schwarme",
"496045", "Gedern",
"496455", "Frankenau\ Hessen",
"492486", "Nettersheim",
"4937757", "Rittersgrün",
"496190", "Hattersheim\ am\ Main",
"499534", "Burgpreppach",
"4939925", "Wredenhagen",
"496348", "Offenbach\ an\ der\ Queich",
"492423", "Langerwehe",
"496396", "Hinterweidenthal",
"496639", "Ottrau",
"4935341", "Bad\ Liebenwerda",
"494401", "Brake\ Unterweser",
"4934203", "Zwenkau",
"496591", "Gerolstein",
"494265", "Fintel",
"494922", "Borkum",
"4938326", "Grimmen",
"493937", "Osterburg\ Altmark",
"496468", "Dautphetal\-Mornshausen",
"492166", "Mönchengladbach\-Rheydt",
"4936374", "Weissensee",
"495659", "Ringgau",
"492440", "Nettersheim\-Tondorf",
"4938788", "Gross\ Warnow",
"495604", "Grossalmerode",
"4938466", "Jürgenshagen",
"494323", "Bornhöved",
"492301", "Holzwickede",
"494124", "Glückstadt",
"4939009", "Badel",
"496658", "Poppenhausen\ Wasserkuppe",
"499155", "Simmelsdorf",
"498631", "Mühldorf\ am\ Inn",
"492137", "Neuss\-Norf",
"494180", "Königsmoor",
"492506", "Münster\-Wolbeck",
"4933082", "Menz\ Kreis\ Oberhavel",
"499522", "Eltmann",
"497545", "Immenstaad\ am\ Bodensee",
"4933978", "Segeletz",
"4939862", "Schmölln\ bei\ Prenzlau",
"497633", "Staufen\ im\ Breisgau",
"4933969", "Stepenitz",
"493966", "Cölpin",
"4936076", "Niederorschel",
"4938352", "Kemnitz\ bei\ Greifswald",
"499853", "Wilburgstetten",
"494340", "Achterwehr",
"4935475", "Straupitz",
"499778", "Fladungen",
"499424", "Strasskirchen",
"495204", "Steinhagen\ Westfalen",
"494348", "Schönkirchen",
"4934609", "Salzmünde",
"498231", "Königsbrunn\ bei\ Augsburg",
"499480", "Sünching",
"4939349", "Parey\ Elbe",
"495152", "Hessisch\ Oldendorf",
"498573", "Ering",
"496258", "Gernsheim",
"495763", "Uchte",
"494455", "Jade\-Schweiburg",
"498026", "Hausham",
"496132", "Ingelheim\ am\ Rhein",
"494188", "Welle\ Nordheide",
"495525", "Walkenried",
"495238", "Nieheim\-Himmighausen",
"4938721", "Ziegendorf",
"497571", "Sigmaringen",
"499366", "Geroldshausen\ Unterfranken",
"4935057", "Hermsdorf\ Erzgebirge",
"496650", "Hosenfeld",
"497233", "Niefern\-Öschelbronn",
"4939089", "Bismark\ Altmark",
"499498", "Laaber",
"4934461", "Nebra\ Unstrut",
"4939297", "Eickendorf\ Kreis\ Schönebeck",
"497376", "Langenenslingen",
"4933878", "Nennhausen",
"499561", "Coburg",
"495909", "Wettrup",
"49385", "Schwerin",
"498742", "Velden\ Vils",
"4935028", "Krippen",
"499101", "Langenzenn",
"496239", "Bobenheim\-Roxheim",
"492058", "Wülfrath",
"495954", "Lorup",
"492448", "Hellenthal\-Rescheid",
"496581", "Saarburg",
"494961", "Papenburg",
"493765", "Reichenbach\ Vogtland",
"494665", "Emmelsbüll\-Horsbüll",
"499337", "Gaukönigshofen",
"492355", "Schalksmühle",
"496386", "Altenkirchen\ Pfalz",
"4934321", "Leisnig",
"495259", "Bad\ Driburg\-Neuenheerse",
"496146", "Hochheim\ am\ Main",
"493523", "Coswig\ bei\ Dresden",
"4935823", "Ostritz",
"496340", "Wörth\-Schaidt",
"492776", "Bad\ Endbach\-Hartenrod",
"496198", "Eppstein",
"4938844", "Gülze",
"493381", "Brandenburg\ an\ der\ Havel",
"495292", "Lichtenau\-Atteln",
"499285", "Kirchenlamitz",
"495682", "Borken\ Hessen",
"498664", "Chieming",
"4938204", "Broderstorf",
"493586", "Neugersdorf\ Sachsen",
"4939825", "Wokuhl",
"496071", "Dieburg",
"492368", "Oer\-Erkenschwick",
"496323", "Edenkoben",
"492065", "Duisburg\-Rheinhausen",
"496124", "Bad\ Schwalbach",
"4939482", "Gatersleben",
"4936253", "Georgenthal\ Thüringer\ Wald",
"497081", "Bad\ Wildbad",
"499446", "Altmannstein",
"495841", "Lüchow\ Wendland",
"499872", "Heilsbronn",
"497329", "Steinheim\ am\ Albuch",
"498454", "Karlshuld",
"4933239", "Gross\ Behnitz",
"49561", "Kassel",
"497755", "Weilheim\ Kreis\ Waldshut",
"496265", "Billigheim\ Baden",
"492941", "Lippstadt",
"4936702", "Lauscha",
"495199", "Schneverdingen\-Heber",
"494468", "Friedeburg\-Reepsholt",
"494639", "Schafflund",
"492645", "Vettelschoss",
"4933835", "Golzow\ bei\ Brandenburg",
"498083", "Isen",
"492533", "Münster\-Nienberge",
"496401", "Grünberg\ Hessen",
"4938455", "Plaaz",
"4934241", "Jesewitz",
"492271", "Bergheim\ Erft",
"494159", "Basthorst",
"494564", "Schashagen",
"499147", "Nennslingen",
"495551", "Northeim",
"4935323", "Sonnewalde",
"49611", "Wiesbaden",
"495356", "Helmstedt\-Barmke",
"499162", "Scheinfeld",
"494902", "Jemgum\-Ditzum",
"496336", "Dellfeld",
"494421", "Wilhelmshaven",
"497172", "Lorch\ Württemberg",
"498558", "Hohenau\ Niederbayern",
"4933679", "Wendisch\ Rietz",
"497557", "Herdwangen\-Schönach",
"492403", "Eschweiler\ Rheinland",
"496531", "Bernkastel\-Kues",
"497949", "Pfedelbach\-Untersteinbach",
"499269", "Tettau\ Kreis\ Kronach",
"4933369", "Oderberg",
"4939245", "Loburg",
"4936640", "Remptendorf",
"4937326", "Frauenstein\ Sachsen",
"494138", "Betzendorf\ Kreis\ Lüneburg",
"496182", "Seligenstadt",
"499502", "Frensdorf",
"4938224", "Gresenhorst",
"498281", "Thannhausen\ Schwaben",
"492526", "Sendenhorst",
"494252", "Bruchhausen\-Vilsen",
"497974", "Bühlerzell",
"494104", "Aumühle\ bei\ Hamburg",
"4939209", "Wanzleben",
"496342", "Schweigen\-Rechtenbach",
"497244", "Weingarten\ Baden",
"499964", "Stallwang",
"494303", "Schlesen",
"495624", "Bad\ Emstal",
"4933335", "Pinnow\ Kreis\ Uckermark",
"498033", "Oberaudorf",
"4934328", "Hartha\ bei\ Döbeln",
"4933747", "Marzahna",
"492583", "Sassenberg",
"494673", "Joldelund",
"495037", "Bad\ Rehburg",
"493773", "Johanngeorgenstadt",
"498803", "Peissenberg",
"494928", "Ihlow\-Riepe",
"4934494", "Ehrenhain",
"4935243", "Weinböhla",
"4933056", "Mühlenbeck\ Kreis\ Oberhavel",
"496462", "Gladenbach",
"495807", "Altenmedingen",
"4935872", "Neusalza\-Spremberg",
"4935021", "Königstein\ Sächsische\ Schweiz",
"49941", "Regensburg",
"493493", "Bitterfeld",
"4938757", "Neustadt\-Glewe",
"498105", "Gilching",
"4939032", "Mahlsdorf\ bei\ Salzwedel",
"495646", "Willebadessen",
"497226", "Bühl\-Sand",
"496447", "Langgöns\-Niederkleen",
"4937360", "Olbernhau",
"496057", "Flörsbachtal",
"497031", "Böblingen",
"493542", "Lübbenau\ Spreewald",
"4938728", "Domsühl",
"495775", "Diepenau",
"498565", "Dietersburg\-Baumgarten",
"497721", "Villingen\ im\ Schwarzwald",
"4939325", "Vinzelberg",
"496652", "Hünfeld",
"496130", "Schwabenheim\ an\ der\ Selz",
"499235", "Thierstein",
"495632", "Willingen\ Upland",
"499528", "Donnersdorf",
"499482", "Wörth\ an\ der\ Donau",
"492257", "Reckerscheid",
"498723", "Arnstorf",
"495495", "Vörden\ Kreis\ Vechta",
"495066", "Sarstedt",
"494192", "Bad\ Bramstedt",
"4936927", "Unterellen",
"493331", "Angermünde",};

    sub new {
      my $class = shift;
      my $number = shift;
      $number =~ s/(^\+49|\D)//g;
      my $self = bless({ country_code => '49', number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self if ($self->is_valid());
      $number =~ s/^(?:0)//;
      $self = bless({ country_code => '49', number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self->is_valid() ? $self : undef;
    }
1;