use Test::More;

use strict;
use warnings;

use DBI;
use Test::PostgreSQL;
use Try::Tiny;

my $pg = try { Test::PostgreSQL->new() }
         catch { plan skip_all => $_ };

plan tests => 3;

ok defined($pg), "new instance created";

eval {
    $pg->run_psql(
        '-c', q|'CREATE TABLE foo (bar int)'|,
        '-c', q|'INSERT INTO foo (bar) VALUES (42)'|,
    )
};

is $@, '', "run_psql no exception" . ($@ ? ": $@" : "");


my $dbh = DBI->connect($pg->dsn);
my @row = $dbh->selectrow_array('SELECT * FROM foo');

is_deeply \@row, [42], "seed values match";
