package GENAddressBook;

use strict;

use Gantry qw{ -TemplateEngine=TT };

our @ISA = qw( Gantry );

use AddressBook::Address;
use AddressBook::Bday;

##-----------------------------------------------------------------
## $self->init( $r )
##-----------------------------------------------------------------
#sub init {
#    my ( $self, $r ) = @_;
#
#    # process SUPER's init code
#    $self->SUPER::init( $r );
#
#} # END init


#-----------------------------------------------------------------
# $self->do_main( )
#-----------------------------------------------------------------
sub do_main {
    my ( $self ) = shift;

    $self->stash->view->template( 'main.tt' );
    $self->stash->view->title( 'AddressBook' );

    $self->stash->view->data( {
        pages => [
            { link => 'address', label => 'Address' },
            { link => 'bday', label => 'Bday' },
        ],
    } );
}

#-----------------------------------------------------------------
# $self->site_links( )
#-----------------------------------------------------------------
sub site_links {
    my $self = shift;

    return [
        { link => $self->app_rootp() . 'address', label => 'Address' },
        { link => $self->app_rootp() . 'bday', label => 'Bday' },
    ];
}

1;

=head1 NAME

GENAddressBook - generated support module for AddressBook

=head1 SYNOPSIS

In AddressBook:

    use base 'GENAddressBook';

=head1 DESCRIPTION

This module was generated by Bigtop (and IS subject to regeneration) to
provide methods in support of the whole AddressBook
application.

AddressBook should inherit from this module.

=head1 METHODS

=over 4

=item init

=item do_main

=item site_links


=back

=head1 AUTHOR

Phil Crow, E<lt>pcrow@localdomainE<gt>

=head1 COPYRIGHT AND LICENSE

Copyright (C) 2006 Phil Crow

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself, either Perl version 5.8.6 or,
at your option, any later version of Perl 5 you may have available.

=cut
