#!/usr/bin/perl

use strict;
use warnings;
no  warnings 'syntax';

use Regexp::Common;
use Test::More;
use t::zip::Zip;

my $r = eval "require Test::Regexp; 1";

unless ($r) {
    print "1..0 # SKIP Test::Regexp not found\n";
    exit;
}


test_zips country         =>  "Switzerland",
          name            =>  "Swiss zip codes",
          prefix          => {
              iso         =>  "CH",
              cept        =>  "CH",
              invalid     =>  "LI",
          },
          prefix_test_set => [4444, 6664],
;


done_testing;


sub valid_zip_codes {
    1000 .. 1012,   1014 .. 1015,   1017 .. 1020,   1022 .. 1047,
    1052 .. 1055,   1058 .. 1059,   1061 .. 1063,   1066,   1068,
    1070 .. 1073,   1076 .. 1078,   1080 .. 1085,   1088,
    1090 .. 1098,   1110,           1112 .. 1117,   1121 .. 1128,
    1131 .. 1132,   1134 .. 1136,   1141 .. 1149,   1162 .. 1170,
    1172 .. 1176,   1180,           1182 .. 1189,   1195 .. 1197,
    1200 .. 1209,   1211 .. 1220,   1222 .. 1228,   1231 .. 1234,
    1236 .. 1237,   1239 .. 1248,   1251 .. 1258,   1260 .. 1279,
    1281,           1283 .. 1300,   1302 .. 1308,   1310 .. 1313,
    1315 .. 1318,   1320 .. 1326,   1329 .. 1330,   1337 .. 1338,
    1341 .. 1348,   1350,           1352 .. 1358,   1372 .. 1377,
    1400 .. 1401,   1404 .. 1410,   1412 .. 1413,   1415 .. 1418,
    1420 .. 1443,   1445 .. 1446,   1450,           1452 .. 1454,
    1462 .. 1464,   1468,   1470,   1473 .. 1475,   1482 .. 1486,
    1489,           1509 .. 1510,   1512 .. 1515,   1521 .. 1530,
    1532 .. 1538,   1541 .. 1545,   1551 .. 1555,   1562 .. 1568,
    1580,           1582 .. 1589,   1595,           1607 .. 1619,
    1623 .. 1628,   1630 .. 1638,   1642 .. 1649,   1651 .. 1654,
    1656 .. 1661,   1663,           1665 .. 1667,   1669 .. 1670,
    1673 .. 1692,   1694 .. 1697,   1699 .. 1702,   1704 .. 1705,
    1707 .. 1709,   1712 .. 1728,   1730 .. 1738,   1740 .. 1742,
    1744 .. 1749,   1752 .. 1754,   1756 .. 1757,   1762 .. 1763,
    1772 .. 1776,   1782 .. 1789,   1791 .. 1797,   1800 .. 1809,
    1811,           1814 .. 1818,   1820,           1822 .. 1824,
    1832 .. 1833,   1844 .. 1847,   1852 .. 1854,   1856,   1860,
    1862 .. 1875,   1880,   1882,   1884 .. 1885,   1890 .. 1893,
    1895 .. 1899,   1902 .. 1908,   1911 .. 1914,   1918 .. 1923,
    1925 .. 1929,   1932 .. 1934,   1936 .. 1938,   1941 .. 1948,
    1950 .. 1951,   1953,   1955,   1957 .. 1958,   1961 .. 1969,
    1971 .. 1978,   1981 .. 1988,   1991 .. 1994,   1996 .. 1997,

    2000 .. 2004,   2006 .. 2010,   2012 .. 2017,   2019,
    2022 .. 2025,   2027 .. 2028,   2034 .. 2037,   2042 .. 2043,
    2046,           2052 .. 2054,   2056 .. 2058,   2063,   2065,
    2067 .. 2068,   2072 .. 2075,   2087 .. 2088,   2103,   2105,
    2108,           2112 .. 2117,   2123 .. 2124,   2126 .. 2127,
    2149,           2206 .. 2208,   2300 .. 2304,   2306,   2314,
    2316,   2318,   2322,   2325,   2333,   2336,   2338,   2340,
    2345,   2350,   2353 .. 2354,   2360,           2362 .. 2364,
    2400,           2405 .. 2406,   2414,   2416,   2500 .. 2505,
    2510,           2512 .. 2518,   2520,   2523,   2525,
    2532 .. 2538,   2540,           2542 .. 2545,   2552 .. 2558,
    2560,           2562 .. 2565,   2572,           2575 .. 2577,
    2603 .. 2608,   2610,           2612 .. 2613,   2615 .. 2616,
    2710,           2712 .. 2718,   2720,           2722 .. 2723,
    2732 .. 2733,   2735 .. 2736,   2738,   2740,   2742 .. 2748,
    2762,   2800,   2802 .. 2803,   2805 .. 2807,   2812 .. 2814,
    2822 .. 2830,   2832,           2842 .. 2843,   2852 .. 2857,
    2863 .. 2864,   2873,           2882 .. 2889,   2900,
    2902 .. 2908,   2912,           2914 .. 2916,   2922 .. 2926,
    2932 .. 2933,   2935,           2942 .. 2944,   2946 .. 2947,
    2950,           2952 .. 2954,

    3000 .. 3008,   3010 .. 3015,   3017 .. 3020,   3024,   3027,
    3029 .. 3030,   3032 .. 3050,   3052 .. 3054,   3063,
    3065 .. 3068,   3070 .. 3078,   3082 .. 3089,   3095 .. 3099,
    3110 .. 3116,   3122 .. 3128,   3132,           3144 .. 3145,
    3147 .. 3148,   3150,           3152 .. 3159,   3172 .. 3179,
    3182 .. 3186,   3202 .. 3208,   3210,           3212 .. 3216,
    3225 .. 3226,   3232 .. 3238,   3250 .. 3257,   3262 .. 3264,
    3266 .. 3268,   3270 .. 3274,   3280,           3282 .. 3286,
    3292 .. 3298,   3302 .. 3303,   3305 .. 3309,   3312 .. 3315,
    3317,           3321 .. 3326,   3360,           3362 .. 3363,
    3365 .. 3368,   3372 .. 3377,   3380,           3400 .. 3402,
    3412 .. 3419,   3421 .. 3429,   3432 .. 3439,   3452 .. 3457,
    3462 .. 3465,   3472 .. 3476,   3503 .. 3504,   3506 .. 3508,
    3510,           3512 .. 3513,   3531 .. 3538,   3543,
    3550 .. 3553,   3555 .. 3557,   3600 .. 3605,   3607 .. 3609,
    3612 .. 3619,   3622 .. 3629,   3631 .. 3636,   3638,
    3645 .. 3647,   3652 .. 3658,   3661 .. 3665,   3671 .. 3674,
    3700,           3702 .. 3707,   3711,           3713 .. 3718,
    3722 .. 3725,   3752 .. 3758,   3762 .. 3766,   3770 .. 3773,
    3775 .. 3778,   3780 .. 3785,   3792,           3800 .. 3801,
    3803 .. 3807,   3812 .. 3816,   3818,           3822 .. 3826,
    3852 .. 3858,   3860,           3862 .. 3864,   3900 .. 3908,
    3910 .. 3914,   3916 .. 3920,   3922 .. 3935,   3937 .. 3940,
    3942 .. 3949,   3951 .. 3957,   3960 .. 3961,   3963,
    3965 .. 3968,   3970 .. 3979,   3982 .. 3989,   3991 .. 4005,

    4007 .. 4013,   4015 .. 4020,   4023 .. 4025,   4030 .. 4035,
    4039 .. 4042,   4051 .. 4059,   4065,   4070,   4075,   4078,
    4080 .. 4089,   4091 .. 4096,   4101 .. 4108,   4112,
    4114 .. 4118,   4123 .. 4127,   4132 .. 4133,   4142 .. 4148,
    4153,           4202 .. 4204,   4206 .. 4208,   4222 .. 4229,
    4232 .. 4234,   4242 .. 4247,   4252 .. 4254,   4302 .. 4305,
    4310,           4312 .. 4317,   4322 .. 4325,   4332 .. 4334,
    4402,           4410 .. 4419,   4421 .. 4426,   4431 .. 4438,
    4441 .. 4448,   4450 .. 4453,   4455 .. 4458,   4460 .. 4469,
    4492 .. 4497,   4500 .. 4503,   4509,           4512 .. 4515,
    4522 .. 4525,   4528,           4532 .. 4539,   4542 .. 4543,
    4551 .. 4554,   4556 .. 4558,   4562 .. 4566,   4571,
    4573 .. 4574,   4576 .. 4579,   4581 .. 4588,   4600 .. 4601,
    4603,   4609,   4611 .. 4618,   4620 .. 4626,   4628 .. 4630,
    4632 .. 4634,   4640,           4652 .. 4658,   4663,   4665,
    4702 .. 4704,   4710,           4712 .. 4719,   4800 .. 4803,
    4805 .. 4809,   4812 .. 4814,   4852 .. 4853,   4856,
    4900 .. 4902,   4911 .. 4917,   4919,           4922 .. 4924,
    4932 .. 4938,   4942 .. 4944,   4950,           4952 .. 4955,

    5000 .. 5001,   5004,   5010,   5012 .. 5015,   5017 .. 5018,
    5022 .. 5028,   5032 .. 5037,   5040,           5042 .. 5044,
    5046,           5053 .. 5054,   5056 .. 5058,   5062 .. 5064,
    5070,           5072 .. 5080,   5082 .. 5085,   5102 .. 5103,
    5105 .. 5108,   5112 .. 5113,   5116,           5200 .. 5201,
    5210,           5212 .. 5213,   5222 .. 5225,   5232 .. 5237,
    5242 .. 5246,   5272 .. 5277,   5300 .. 5301,   5303 .. 5306,
    5312 .. 5318,   5322 .. 5326,   5330,           5332 .. 5334,
    5400 .. 5402,   5404 .. 5406,   5408,           5412 .. 5413,
    5415 .. 5417,   5420,   5423,   5425 .. 5426,   5430 .. 5432,
    5436,           5442 .. 5445,   5452 .. 5454,   5462 .. 5467,
    5502 .. 5507,   5512,   5522,   5524 .. 5525,   5600 .. 5601,
    5603 .. 5608,   5610 .. 5628,   5630,   5632,   5634,
    5636 .. 5637,   5642 .. 5647,   5702 .. 5708,   5712,
    5722 .. 5728,   5732 .. 5737,   5742,           5745 .. 5746,

    6000,           6002 .. 6028,   6030 .. 6039,   6042 .. 6045,
    6047 .. 6048,   6052 .. 6053,   6055 .. 6056,   6060 .. 6064,
    6066 .. 6068,   6072 .. 6074,   6078,           6083 .. 6086,
    6102 .. 6103,   6105 .. 6106,   6110,           6112 .. 6114,
    6122 .. 6123,   6125 .. 6126,   6130,           6132 .. 6133,
    6142 .. 6147,   6152 .. 6154,   6156,           6160 .. 6163,
    6166 .. 6167,   6170,           6173 .. 6174,   6182,   6192,
    6196 .. 6197,   6203 .. 6208,   6210 .. 6218,   6221 .. 6222,
    6231 .. 6236,   6242 .. 6248,   6252 .. 6253,   6260,
    6262 .. 6265,   6274 .. 6277,   6280 .. 6281,   6283 .. 6289,
    6294 .. 6295,   6300 .. 6304,   6310,           6312 .. 6315,
    6317 .. 6319,   6330 .. 6333,   6340 .. 6346,   6349,
    6353 .. 6354,   6356,           6362 .. 6363,   6365,
    6370 .. 6377,   6382 .. 6383,   6386 .. 6388,   6390 .. 6391,
    6402 .. 6405,   6410,           6414 .. 6418,   6422 .. 6424,
    6430 .. 6434,   6436,   6438,   6440 .. 6443,   6452,   6454,
    6460 .. 6469,   6472 .. 6476,   6482,           6484 .. 6485,
    6487,           6490 .. 6491,   6493,           6500 .. 6501,
    6503,   6506,   6511 .. 6518,   6523 .. 6528,   6532 .. 6535,
    6537 .. 6538,   6540 .. 6549,   6556 .. 6558,   6562 .. 6563,
    6565,           6571 .. 6579,   6582 .. 6584,   6590,
    6592 .. 6602,   6604 .. 6605,   6611 .. 6614,   6616,   6618,
    6622,           6631 .. 6637,   6644 .. 6648,   6652 .. 6659,
    6661 .. 6664,   6670,           6672 .. 6678,   6682 .. 6685,
    6690,           6692 .. 6696,   6702 .. 6703,   6705,   6707,
    6710,           6713 .. 6724,   6742 .. 6749,   6760,
    6763 .. 6764,   6772 .. 6777,   6780 .. 6781,   6802 .. 6810,
    6814 .. 6818,   6821 .. 6823,   6825 .. 6828,   6830,
    6832 .. 6839,   6850,           6852 .. 6855,   6862 .. 6867,
    6872 .. 6875,   6877,   6883,   6900 .. 6908,   6911 .. 6919,
    6921 .. 6922,   6924 .. 6930,   6932 .. 6939,   6942 .. 6959,
    6962 .. 6968,   6974,           6976 .. 6984,   6986 .. 7004,

    7006 .. 7007,   7012 .. 7019,   7023,           7026 .. 7029,
    7031 .. 7032,   7050,           7056 .. 7058,   7062 .. 7064,
    7074 .. 7078,   7082 .. 7084,   7104,           7106 .. 7107,
    7109 .. 7116,   7122,           7126 .. 7128,   7130,
    7132 .. 7138,   7141 .. 7149,   7151 .. 7159,   7162 .. 7168,
    7172 .. 7176,   7180,           7182 .. 7189,   7201 .. 7206,
    7208,           7212 .. 7215,   7220,           7222 .. 7224,
    7226,   7228,   7231 .. 7233,   7235,           7240 .. 7247,
    7249 .. 7250,   7252,   7260,   7265,   7270,   7272,
    7276 .. 7278,   7302 .. 7304,   7306 .. 7307,   7310,
    7312 .. 7315,   7317,   7320,   7323 .. 7326,   7402 .. 7405,
    7407 .. 7408,   7411 .. 7419,   7421 .. 7428,   7430 .. 7438,
    7440,           7442 .. 7448,   7450 .. 7460,   7462 .. 7464,
    7472 .. 7473,   7477,   7482,   7484,           7492 .. 7494,
    7500,           7502 .. 7505,   7512 .. 7517,   7522 .. 7527,
    7530,           7532 .. 7537,   7542 .. 7543,   7545 .. 7546,
    7550 .. 7554,   7556 .. 7560,   7562 .. 7563,   7602 .. 7606,
    7608,   7610,   7710,           7741 .. 7748,

    8000 .. 8006,   8008,           8010 .. 8012,   8015 .. 8016,
    8020 .. 8024,   8026 .. 8027,   8030 .. 8034,   8036 .. 8042,
    8044 .. 8053,   8055,           8057 .. 8061,   8063 .. 8066,
    8068,           8070 .. 8071,   8074 .. 8075,   8080 .. 8081,
    8085 .. 8088,   8090 .. 8093,   8096,           8098 .. 8099,
    8102 .. 8109,   8112 .. 8115,   8117 .. 8118,   8121 .. 8127,
    8130,           8132 .. 8136,   8142 .. 8143,   8152 .. 8158,
    8162,           8164 .. 8166,   8172 .. 8175,   8180 .. 8185,
    8187,           8192 .. 8197,   8200 .. 8205,   8207 .. 8208,
    8210,           8212 .. 8219,   8222 .. 8226,   8228,
    8231 .. 8236,   8238 .. 8243,   8245 .. 8248,   8252 .. 8255,
    8259 .. 8269,   8272 .. 8274,   8280,   8285,   8301 .. 8312,
    8314 .. 8315,   8317,   8320,   8322,   8325,   8330 .. 8332,
    8335,   8340,   8342 .. 8345,   8352 .. 8357,   8360,
    8362 .. 8363,   8370 .. 8372,   8374,   8376,   8400 .. 8402,
    8404 .. 8406,   8408 .. 8416,   8418,           8421 .. 8428,
    8442,   8444,   8447,           8450 .. 8455,   8457 .. 8468,
    8471 .. 8472,   8474 .. 8479,   8482 .. 8484,   8486 .. 8489,
    8492 .. 8503,   8505 .. 8508,   8510,   8512,   8514,   8520,
    8522 .. 8526,   8530,   8532,   8535 .. 8537,   8540,
    8542 .. 8548,   8552 .. 8556,   8558,           8560 .. 8561,
    8564 .. 8566,   8570,           8572 .. 8577,   8580 .. 8590,
    8592 .. 8600,   8602 .. 8608,   8610,           8612 .. 8618,
    8620 .. 8627,   8630,           8632 .. 8640,   8645 .. 8646,
    8700,           8702 .. 8704,   8706 .. 8708,   8712 .. 8718,
    8722 .. 8723,   8725 .. 8727,   8730,           8732 .. 8735,
    8737 .. 8740,   8750 .. 8759,   8762,           8765 .. 8767,
    8772 .. 8775,   8777,           8782 .. 8784,   8800 .. 8808,
    8810,           8812 .. 8813,   8815 .. 8816,   8820,
    8824 .. 8825,   8832 .. 8836,   8840 .. 8847,   8849,
    8852 .. 8858,   8862 .. 8868,   8872 .. 8874,   8877 .. 8890,
    8892 .. 8898,   8901 .. 8919,   8925 .. 8926,   8932 .. 8934,
    8942,           8951 .. 8957,   8962,           8964 .. 8967,
    8970,

    9000 .. 9001,   9004,           9006 .. 9016,   9020,
    9022 .. 9030,   9032 .. 9038,   9042 .. 9044,   9050,
    9052 .. 9058,   9062 .. 9064,   9100 .. 9105,   9107 .. 9108,
    9112 .. 9116,   9122 .. 9123,   9125 .. 9127,   9200 .. 9201,
    9203 .. 9205,   9212 .. 9217,   9220,   9223,   9225,
    9230 .. 9231,   9240,           9242 .. 9249,   9300 .. 9301,
    9304 .. 9306,   9308,           9312 .. 9315,   9320,
    9322 .. 9323,   9325 .. 9327,   9400 .. 9405,   9410 .. 9411,
    9413 .. 9414,   9422 .. 9428,   9430,           9434 .. 9437,
    9442 .. 9445,   9450 .. 9453,   9462 .. 9473,   9475 .. 9479,
    9500 .. 9504,   9506 .. 9508,   9510,   9512,   9514 .. 9515,
    9517,           9523 .. 9527,   9532 .. 9536,   9542 .. 9543,
    9545 .. 9548,   9552 .. 9556,   9562,   9565,   9573,
    9601 .. 9602,   9604,           9606 .. 9608,   9612 .. 9615,
    9620 .. 9622,   9630 .. 9631,   9633,           9642 .. 9643,
    9650 .. 9652,   9655 .. 9658,

}


__END__
