package Travel::Status::DE::IRIS::Stations;

# vim:readonly
# This module has been automatically generated from share/stations.json
# by lib/Travel/Status/DE/IRIS/Stations.pm.PL.
# Do not edit, changes will be lost.

use strict;
use warnings;
use 5.014;
use utf8;

use Geo::Distance;
use List::Util qw(min);
use List::UtilsBy qw(uniq_by);
use List::MoreUtils qw(firstval pairwise);
use Text::LevenshteinXS qw(distance);

# TODO switch to Text::Levenshtein::XS once AUR/Debian packages become available

our $VERSION = '1.73';

# Automatically generated, see share/stations.json
my @stations = (
['KA','Aachen Hbf',8000001,6.091499,50.7678],
['KASZ','Aachen Schanz',8070704,6.07384,50.769862],
['KAW','Aachen West',8000404,6.070715,50.78036],
['KARE','Aachen-Rothe Erde',8000406,6.116475,50.770202],
['TA','Aalen Hbf',8000002,10.096271,48.841013],
['ONAAL','Aalten',8400045,6.5786272287369,51.921326524551],
['XBAAL','Aalter',8800300,3.449044,51.09198],
['XSA','Aarau',8502113,8.0512535427367,47.3913553368765],
['XSABO','Aarburg-Oftringen',8502000,7.90820373353681,47.3202667173669],
['XDAR','Aarhus',8600087,10.2039136,56.1497091],
['ONAB','Abcoude',8400047,4.977,52.2785],
['OMADA','Abda',5500151,17.541119,47.690426],
['KAB','Abenden',8007826,6.476459,50.671085],
['MABG','Abensberg',8000410,11.84662,48.819456],
['OAAB','Abfaltersbach',8100204,12.511744,46.754254],
['OAADH','Absdorf-Hippersdorf',8100202,15.985877,48.402093],
['RAH','Achern',8000412,8.065324,48.63399],
['RAHS','Achern Stadt',8007001,8.067706,48.625736],
['XFAH','Achiet',8700583,2.780676,50.131579],
['HACH','Achim',8000413,9.030447,53.01599],
['RAK','Achkarren',8007291,7.60787,48.060088],
['HAMR','Achmer',8000414,7.94216,52.390479],
['AACW','Achterwehr',8000416,9.964024,54.314913],
['HADB','Adelebsen',8000418,9.760044,51.57769],
['MAD','Adelschlag',8000419,11.211443,48.840759],
['NADM','Adelsdorf(Mittelfr)',8000420,10.687041,49.474944],
['RADN','Adelsheim Nord',8000423,9.392754,49.42149],
['TAD','Adelsheim Ost',8000424,9.395127,49.403123],
['DADO','Adorf(Erzgeb)',8011002,12.873666,50.76385],
['DAD','Adorf(Vogtl)',8010001,12.260789,50.323926],
['TAF','Affaltrach',8000431,9.379012,49.137832],
['XSAA','Affoltern am Albis',8502224,8.44658239142979,47.2760640739514],
['MAGD','Agatharied',8000433,11.824472,47.765606],
['AABG','Agathenburg',8000434,9.531244,53.564111],
['XFAG','Agde',8700145,3.465802,43.317494],
['RAG','Aglasterhausen',8007445,8.990838,49.350097],
['RA','Aha',8000436,8.134349,47.833224],
['EAHS','Ahaus',8000437,7.016453,52.081681],
['WABG','Ahlbeck Grenze',8079084,14.215549,53.921966],
['WABO','Ahlbeck Ostseetherme',8087025,14.177287,53.944426],
['EAHL','Ahlen(Westf)',8000441,7.895488,51.761062],
['HAHO','Ahlhorn',8000442,8.209429,52.899321],
['HALT','Ahlten',8000443,9.904613,52.376062],
['FATC','Ahnatal Casselbreite',8000457,9.434061,51.36286],
['FHEH','Ahnatal-Heckershausen',8002675,9.422727,51.362991],
['FWEI','Ahnatal-Weimar',8006286,9.391588,51.363629],
['KBRU','Ahrbrück',8001209,6.972391,50.489679],
['AAHR','Ahrensburg',8000446,10.236206,53.669171],
['AAHG','Ahrensburg-Gartenholz',8000480,10.251786,53.688482],
['BAHR','Ahrensfelde',8011003,13.565154,52.571375],
['BAF','Ahrensfelde (S)',8089188,13.565551,52.5712445],
['BAFR','Ahrensfelde Friedhof',8011004,13.573316,52.580882],
['BAFN','Ahrensfelde Nord',8011005,13.581985,52.590685],
['AARF','Ahrensfelde(Bz. Bremen)',8071338,8.818139,53.233409],
['KAH','Ahrweiler',8000448,7.107071,50.546544],
['KAHM','Ahrweiler Markt',8000449,7.094229,50.544228],
['MAIC','Aich(Niederbay)',8000451,12.398163,48.417315],
['MAI','Aichach',8000452,11.122721,48.461117],
['TAI','Aichstetten',8000454,10.07494,47.887884],
['XSAL','Aigle',8501400,6.96368009360016,46.3168441199003],
['XFAM','Aime-la-Plagne',8700431,6.648395,45.554204],
['MAID','Aindorf',8072132,12.357742,47.987042],
['MAIN','Ainring',8000459,12.964501,47.815033],
['XSAI','Airolo',8505201,8.60860513449754,46.5275264817373],
['XFAX','Aix-en-Provence TGV',8704980,5.317224,43.455171],
['XFAI','Aix-les-Bains-le-Revard',8700048,5.908984,45.688197],
['ONAK','Akkrum',8400049,5.843611240387,53.046390533447],
['XUAI','Alba Iulia',5300096,23.576231,46.0563473],
['RAL','Albbruck',8000463,8.131774,47.592235],
['AAL','Albersdorf',8000464,9.292151,54.14632],
['RAR','Albersweiler(Pfalz)',8000466,8.024464,49.21847],
['XFAL','Albertville',8700128,6.383619,45.673624],
['RETF','Albgaubad, Ettlingen',723571,8.415256,48.936839],
['FAG','Albig',8000468,8.116579,49.771375],
['LALB','Albrechtshaus',8017000,10.929267,51.642173],
['BAS','Albrechtshof',8080040,13.128917,52.549396],
['FALS','Albshausen',8000471,8.434869,50.545716],
['RAM','Albsheim(Eis)',8070096,8.178998,49.580683],
['TAE','Albstadt-Ebingen',8000473,9.026962,48.21029],
['TAEW','Albstadt-Ebingen West',8079089,8.99698,48.21139],
['TALO','Albstadt-Laufen Ort',8000474,8.917316,48.222859],
['TALT','Albstadt-Lautlingen',8000475,8.95462,48.213638],
['KALK','Aldekerk',8000477,6.412542,51.435759],
['TALD','Aldingen(b Spaichingen)',8000481,8.713033,48.095845],
['XFALN','Alençon',8700141,0.098959,48.433908],
['XFALE','Ales',8700126,4.084979,44.127963],
['MALH','Aletshausen',8000482,10.383631,48.201313],
['LAX','Alexisbad',8017001,11.115311,51.648132],
['HALF','Alfeld(Leine)',8000483,9.817779,51.981417],
['KALI','Alfter-Impekoven',8000495,7.019831,50.711016],
['KWIS','Alfter-Witterschlick',8006516,7.026083,50.689698],
['HALG','Algermissen',8000488,9.966472,52.25188],
['HALI','Aligse',8000489,9.979349,52.403462],
['XBAE','Alken(B)',8800225,5.292533,50.886819],
['XNAL','Alkmaar',8400050,4.7397222518921,52.63777923584],
['ONALN','Alkmaar Noord',8400052,4.7641668319702,52.643890380859],
['FADD','Allendorf(Dillkr)',8000492,8.185486,50.743811],
['FALD','Allendorf(Eder) Bf',8000493,8.677197,51.025899],
['RAB','Allensbach',8000496,9.068852,47.714464],
['OAALL','Allentsteig',8100210,15.329826,48.715934],
['XAAH','Allerheiligenhöfe',8100548,11.3533400318506,47.269094693632],
['NALB','Allersberg(Rothsee)',8000498,11.212573,49.262131],
['TALL','Allmendingen',8000499,9.722382,48.327734],
['XNAO','Almelo',8400051,6.6538887023926,52.358055114746],
['ONAOR','Almelo de Riet',8400520,6.6666665077209,52.341945648193],
['ONABU','Almere Buiten',8400081,5.2780556678772,52.394165039062],
['ONA','Almere Centrum',8400080,5.21764,52.37503],
['ONAMU','Almere Muziekwijk',8400082,5.1902775764465,52.367500305176],
['XNAOO','Almere Oostvaarders',8400024,5.3005557060242,52.403331756592],
['ONAPA','Almere Parkwijk',8479008,5.244722366333,52.376667022705],
['PNAP','Almere Poort',8400450,5.151944,52.342778],
['KALP','Alpen',8000500,6.518041,51.583392],
['XNAR','Alphen aan den Rijn',8400053,4.6577777862549,52.124443054199],
['RALP','Alpirsbach',8000501,8.398251,48.343809],
['KADP','Alsdorf Poststraße',8000510,6.197075,50.855749],
['EGNP','Alsdorf(Westerw)',8007078,7.890486,50.78089],
['KADA','Alsdorf-Annapark',8000502,6.156661,50.870517],
['KADB','Alsdorf-Busch',8000507,6.140586,50.876588],
['KKEL','Alsdorf-Kellersberg',8000521,6.167354,50.867527],
['KMAD','Alsdorf-Mariadorf',8000527,6.188454,50.861978],
['SAZ','Alsenz',8000505,7.817189,49.727495],
['FAFD','Alsfeld(Oberhess)',8000350,9.264297,50.750962],
['FAHM','Alsheim',8000506,8.342462,49.765528],
['OMASR','Alsorönök',5500187,16.378238,46.964125],
['WAHU','Alt Hüttendorf',8011011,13.783574,52.957591],
['BARO','Alt Rosenthal',8011014,14.278627,52.550403],
['WAS','Alt Schwerin',8011015,12.355756,53.512175],
['OAATA','Altach',8100630,9.661128,47.352072],
['TACH','Altbach',8000508,9.382384,48.720393],
['NADW','Altdorf West',8000504,11.341467,49.391146],
['XSADF','Altdorf(CH)',8505113,8.63156572015953,46.8757407268376],
['NAD','Altdorf(b Nürnberg)',8000509,11.35353,49.390006],
['BAD','Altdöbern',8011016,14.009236,51.65278],
['NAVE','Alte Veste',8000511,10.972363,49.454322],
['WAF','Altefähr',8011017,13.14101,54.322927],
['EALN','Altena(Westf)',8000513,7.668808,51.301981],
['KALT','Altenahr',8000514,6.989707,50.515652],
['MALT','Altenau(Bay)',8000515,11.017375,47.648365],
['LALT','Altenbach',8011018,12.682324,51.355868],
['SAB','Altenbamberg',8000517,7.830745,49.786857],
['HA','Altenbeken',8000004,8.943319,51.766433],
['EABG','Altenberge',8000518,7.481303,52.052258],
['LA','Altenburg',8010003,12.444019,50.996648],
['XSAD','Altendorf(CH)',8503211,8.82288898291028,47.1939663839749],
['MANE','Altenerding',8000524,11.901744,48.293572],
['FATF','Altenfeld(Rhön)',8000525,9.849726,50.450898],
['SALG','Altenglan',8000491,7.461841,49.548643],
['AAT','Altengörs',8000526,10.355554,53.898696],
['FAHN','Altenhasungen',8000530,9.225737,51.34354],
['KAK','Altenkirchen(Westerwald)',8000351,7.638257,50.684418],
['XAAL','Altenmarkt im Pongau',8100139,13.428421,47.382471],
['MATM','Altenmarkt(Alz)',8000533,12.536027,47.999817],
['EASE','Altenseelbach',8000537,7.992398,50.783837],
['FAST','Altenstadt(Hess)',8000538,8.943977,50.283398],
['MASI','Altenstadt(Iller)',8000539,10.109983,48.161191],
['NALW','Altenstadt(Waldnaab)',8000540,12.16487,49.715679],
['FHTN','Altenstadt-Höchst',8002886,8.923418,50.269767],
['FLIN','Altenstadt-Lindheim',8003698,8.978775,50.291334],
['WATR','Altentreptow',8011025,13.242713,53.692233],
['WALW','Altenwillershagen',8011027,12.572818,54.259406],
['UACH','Altersbach',8011028,10.544522,50.70064],
['BJA','Altes Lager',8011968,12.989048,52.017356],
['RAT','Altglashütten-Falkau',8000544,8.114113,47.859392],
['MAHB','Althegnenberg',8000545,11.063003,48.236374],
['FAT','Altheim(Hess)',8000546,8.890906,49.923332],
['WAH','Althof',8011031,11.922341,54.090442],
['TAG','Altingen(Württ)',8070591,8.908852,48.561927],
['FKALR','Altmarkt/Regierungspräsidium, Kassel',712165,9.504935,51.316172],
['DAMD','Altmittweida',8011033,12.95969,50.968348],
['FAMO','Altmorschen',8000553,9.610756,51.067275],
['XSAT','Altnau',8506125,9.26589677407834,47.6213657537063],
['MAMT','Altomünster',8000556,11.255133,48.384918],
['DAOR','Altoschatz-Rosenthal',8070689,13.098595,51.287838],
['BART','Altranft',8011034,14.082107,52.763368],
['TAT','Altshausen',8000559,9.551478,47.930838],
['MATS','Altstädten(Allgäu)',8000561,10.280907,47.48855],
['XSAS','Altstätten SG',8506319,9.55651096480567,47.3742291734075],
['TATN','Alttann',8000562,9.793037,47.841214],
['MAT','Altötting',8000555,12.67479,48.221242],
['AAV','Alveslohe',8070185,9.916375,53.791456],
['XVAL','Alvesta station',7400005,14.55746,56.89899],
['FAZB','Alzenau Burg',8077275,9.07434,50.087928],
['FAZUN','Alzenau Nord',8077274,9.051385,50.089443],
['FAZU','Alzenau(Unterfr)',8007275,9.065603,50.088716],
['FALZ','Alzey',8000007,8.109749,49.7502],
['FAZS','Alzey Süd',8000558,8.118732,49.738134],
['FAZW','Alzey West',8007474,8.107255,49.740978],
['FKBHA','Am Kupferhammer, Kassel',719498,9.556139,51.294447],
['FKASA','Am Stern, Kassel',715108,9.500261,51.318046],
['FKNZW','Am Weinberg, Kassel',712236,9.488197,51.307554],
['NAM','Amberg',8000566,11.862902,49.447616],
['XFAE','Amberieu',8700045,5.341486,45.953815],
['MAMG','Amerang',8070802,12.306297,47.985835],
['XNAM','Amersfoort Centraal',8400055,5.3705554008484,52.153888702393],
['ONAMS','Amersfoort Schothorst',8400054,5.4038887023926,52.174822137451],
['XNAMV','Amersfoort Vathorst',8400031,5.4338889122009,52.192779541016],
['UAMM','Ammern',8011029,10.458086,51.233346],
['NAMB','Amorbach',8000575,9.223147,49.645609],
['MAPF','Ampfing',8000576,12.410919,48.253949],
['OSAM','Amriswil',8506109,9.301927,47.550604],
['LAMS','Amsdorf',8011038,11.71979,51.463561],
['XNAA','Amsterdam Amstel',8400057,4.917594,52.346443],
['XNAB','Amsterdam Bijlmer ArenA',8400074,4.947141,52.312221],
['XNAC','Amsterdam Centraal',8400058,4.899427,52.379191],
['PNABH','Amsterdam Holendrecht',8400076,4.960032,52.298108],
['ONAL','Amsterdam Lelylaan',8400079,4.833913,52.357887],
['ONAM','Amsterdam Muiderpoort',8400060,4.931365,52.360736],
['ONAMR','Amsterdam RAI',8400056,4.890725,52.33669],
['PNABJ','Amsterdam Science Park',8400083,4.949254,52.353167],
['XNAS','Amsterdam Sloterdijk',8400059,4.838111,52.389025],
['XNAZ','Amsterdam Zuid',8400061,4.871947,52.338865],
['XAAS','Amstetten NÖ',8100012,14.878112,48.121606],
['TAM M','Amstetten(W) Lokalbahn',8079075,9.873959,48.577852],
['TAM','Amstetten(Württ)',8000577,9.872965,48.578328],
['DAMH','Amtshainersdorf',8011039,14.232364,50.966322],
['XSANF','Andelfingen',8506047,8.67797953563967,47.5937589885536],
['XSAN','Andermatt',8505165,8.59327487979362,46.6368923077695],
['KAND','Andernach',8000331,7.404839,50.434542],
['XAAD','Andorf',8100211,13.5656515933884,48.3694039673152],
['KANM','Angermund',8000579,6.781857,51.330748],
['WA','Angermünde',8010004,13.996361,53.015221],
['LANG','Angern-Rogätz',8011042,11.759535,52.338464],
['OAANN','Angern/March',8100619,16.826647,48.38487],
['FANG','Angersbach',8000580,9.44726,50.63077],
['LAG','Angersdorf',8011043,11.903139,51.460407],
['XBAL','Angleur',8800033,5.599524,50.612882],
['XFANG','Angouleme',8700063,0.164691,45.654018],
['WAK','Anklam',8011044,13.701827,53.856102],
['ONAP','Anna Paulowna',8400065,4.8111109733581,52.867221832275],
['DABM','Annaberg-Buchholz Mitte',8011045,12.999078,50.566791],
['DAB','Annaberg-Buchholz Süd',8010005,12.997404,50.555886],
['DABU','Annaberg-Buchholz unterer Bf',8011047,12.998313,50.57861],
['LAB','Annaburg',8011048,13.032757,51.72868],
['RAN','Annweiler am Trifels',8000582,7.966149,49.205386],
['RANS','Annweiler-Sarnstall',8005257,7.937192,49.208725],
['KANR','Anrath',8000584,6.45023,51.285536],
['XBANS','Ans(B)',8800013,5.509686,50.661028],
['NAN','Ansbach',8000009,10.578239,49.298032],
['XFAN','Antibes',8700146,7.119465,43.585678],
['DATL','Antonsthal',8011049,12.755449,50.500096],
['XBAC','Antwerpen Centraal',8800007,4.42100465297699,51.2155267220265],
['XBBC','Antwerpen-Berchem',8800008,4.432464,51.199527],
['XBLUB','Antwerpen-Luchtbal',8800187,4.424832,51.244734],
['OBAND','Antwerpen-Noorderdokken',8800188,4.427835,51.261616],
['XBAZ','Antwerpen-Zuid',8800310,4.390969,51.19754],
['NAWN','Anwanden',8000588,10.930396,49.411692],
['FAZ','Anzefahr',8000589,8.85959,50.845731],
['MAK','Anzenkirchen',8000590,13.021996,48.434739],
['XFAP','Apach(Moselle)',8700187,6.371969,49.458787],
['XNAE','Apeldoorn',8400066,5.9702777862549,52.209167480469],
['PNAAQ','Apeldoorn De Maten',8400032,6.6875551,52.205276489258],
['PNAAR','Apeldoorn Osseveld',8400033,6.6758332252502,52.215278625488],
['AAPS','Apensen',8007831,9.612345,53.441667],
['UAP','Apolda',8011051,11.526136,51.03094],
['RAP','Appenweier',8000596,7.97319,48.541461],
['XNAP','Appingedam',8400067,6.8619577,53.3258135],
['XUA','Arad',5300002,21.325546,46.189565],
['XSAB','Arbon',8506308,9.43333858590703,47.510585447895],
['XSABS','Arbon (See)',8506110,9.44032100861396,47.5126421316245],
['PSCTD','Arbon Seemoosriet',8516270,9.424722,47.521348],
['HART','Arbste',8070304,8.993578,52.785719],
['OIACS','Arcisate',8301116,8.86242,45.85838],
['EARE','Ardey',8000597,7.727176,51.481163],
['LAF','Arensdorf(Köthen)',8011053,12.007416,51.709511],
['UAR','Arenshausen',8011054,9.968639,51.375166],
['FAF','Arfurt(Lahn)',8000599,8.211079,50.406403],
['XFAR','Argeles-sur-Mer',8700487,3.022097,42.543777],
['ONAKL','Arkel',8400068,4.9927778244019,51.87194442749],
['XFARL','Arles',8700139,4.63243,43.685007],
['XBAR','Arlon',8800022,5.809431,49.680125],
['FARM','Armsheim',8000602,8.074113,49.808372],
['MANB','Arnbach',8000603,11.344044,48.34132],
['ONARM','Arnemuiden',8400069,3.6691665649414,51.501667022705],
['XNAH','Arnhem Centraal',8400071,5.8991665840149,51.985000610352],
['ONAHP','Arnhem Presikhaaf',8400075,5.9438886642456,51.988056182861],
['ONAHV','Arnhem Velperpoort',8400072,5.9194445610046,51.985279083252],
['PNAAN','Arnhem Zuid',8400029,6.60041,51.955001831055],
['XAAR','Arnoldstein',8100056,13.708026901493,46.5515619582999],
['EARB','Arnsberg(Westf)',8000605,8.067965,51.405662],
['NARG','Arnschwang',8000606,12.8116,49.274608],
['DAF','Arnsdorf(Dresden)',8010006,13.982212,51.092807],
['UA','Arnstadt Hbf',8010007,10.948262,50.841939],
['UASD','Arnstadt Süd',8011055,10.954958,50.831084],
['XSAO','Arosa',8509157,9.67933313854315,46.7832957175431],
['NARR','Arrach',8007343,13.002804,49.195364],
['XFAS','Arras(F)',8700071,2.78183,50.286889],
['KARS','Arsbeck',8000611,6.206563,51.152006],
['XFAY','Artenay(Loiret)',8700629,1.883202,48.080862],
['UAT','Artern',8012440,11.310757,51.36324],
['XSAG','Arth-Goldau',8505004,8.54949116321607,47.0491562199955],
['XFARV','Arvant',8700089,3.310677,45.365383],
['NAZ','Arzberg(Oberfr)',8000613,12.197692,50.054633],
['XTAS','As(CZ)',5400122,12.199936,50.209434],
['NAH','Aschaffenburg Hbf',8000010,9.143697,49.980557],
['NAHF','Aschaffenburg Hochschule',8000618,9.160416,49.974445],
['NASU','Aschaffenburg Süd',8000619,9.152586,49.968465],
['MASC','Aschau(Chiemgau)',8000621,12.325564,47.779106],
['AAG','Ascheberg(Holst)',8000011,10.339481,54.148462],
['EASB','Ascheberg(Westf)',8000623,7.600749,51.782991],
['HASD','Aschendorf',8000624,7.337153,53.052179],
['LAL','Aschersleben',8010009,11.465689,51.757122],
['OFASQ','Ascq',8700509,3.159861,50.621908],
['AASN','Ashausen',8000627,10.145564,53.368693],
['TAX','Asperg',8000630,9.147797,48.907359],
['XBASS','Asse',8800338,4.208335,50.906497],
['RASH','Asselheim',8000625,8.161602,49.57622],
['ONAS','Assen',8400073,6.5708332061768,52.991664886475],
['FAS','Assenheim(Oberhess)',8000632,8.812462,50.304939],
['FAH','Assmannshausen',8000635,7.867355,49.985324],
['EAT','Attendorn',8000638,7.908493,51.124644],
['EHOH','Attendorn-Hohen Hagen',8087039,7.855281,51.090165],
['XAAT','Attnang-Puchheim',8100017,13.7192394888439,48.0112229645186],
['XSAU','Au SG',8506316,9.64124454757032,47.4361134138699],
['XSAZ','Au ZH',8503205,8.64370806189535,47.2468165267712],
['RWSA','Au im Murgtal',8000643,8.362349,48.718867],
['KAU','Au(Sieg)',8000012,7.656537,50.773765],
['DAU','Aue(Sachs)',8010010,12.698518,50.591682],
['DAUS','Aue(Sachs) Erzgebirgsstadion',8010027,12.70935,50.596641],
['EAWN','Aue-Wingeshausen',8000647,8.290085,51.051785],
['UAE','Auehütte',8011057,10.416666,50.719672],
['DAUO','Auerbach(V) ob Bf',8010011,12.382054,50.519136],
['DAUU','Auerbach(V) unt Bf',8010012,12.391421,50.511722],
['DAUH','Auerbach(Vogtl) Hp',8011059,12.379204,50.506955],
['RACH','Auerbach(b Mosbach, Baden)',8000649,9.223276,49.399563],
['SAM','Auersmacher',8000651,7.04472464,49.14339809],
['FKNZA','Auestadion, Kassel',714006,9.481279,51.299057],
['TAUF','Aufhausen(Württ)',8000655,10.317193,48.85613],
['MAFE','Aufhausen(b Erding)',8000653,11.894375,48.274365],
['RKAG','Augartenstraße, Karlsruhe',721323,8.40384,48.99874],
['RAUG','Auggen',8000657,7.586788,47.789949],
['MAHA','Augsburg Haunstetterstraße',8000658,10.900985,48.355285],
['MA','Augsburg Hbf',8000013,10.88557,48.365441],
['MAGM','Augsburg Messe',8000659,10.886086,48.338684],
['MAMS','Augsburg Morellstr.',8000660,10.892948,48.355089],
['MAHZ','Augsburg-Hochzoll',8000661,10.943376,48.352977],
['MAOB','Augsburg-Oberhausen',8000662,10.872533,48.380772],
['PQKAB','August-Bebel-Straße, Karlsruhe',723603,8.375802,49.024161],
['HAUG','Augustfehn',8000664,7.759659,53.22089],
['DAUG','Augustusburg Bergstation',8080060,13.099016,50.816613],
['AAU','Aukrug',8003078,9.78581,54.082398],
['TAU','Aulendorf',8000014,9.644046,47.953052],
['XFAU','Aulnoye Aymeries',8700017,3.843542,50.197194],
['FAUM','Aumenau',8000668,8.249249,50.400422],
['AAH','Aumühle',8000669,10.314672,53.529853],
['XFAUN','Auneau(Dourdan)',8700560,1.779908,48.445967],
['FAM','Auringen-Medenbach',8000671,8.332093,50.113608],
['XBAU','Auvelais',8800106,4.631098,50.449063],
['SAUW','Auw an der Kyll',8000674,6.614525,49.903596],
['NAUR','Außenried',8000672,13.181763,49.015763],
['XFAVN','Avesnes-sur-Helpe',8700239,3.933137,50.126874],
['XFAV','Avignon Centre',8700172,4.805337,43.941636],
['XFAVV','Avignon TGV',8704918,4.786044,43.921937],
['MAY','Aying',8000675,11.769578,47.968762],
['XBAY','Aywaille',8800176,5.672993,50.472849],
['FAL','Aßlar',8000633,8.462756,50.588657],
['MAG','Aßling(Oberbay)',8000634,11.993518,47.989491],
['WBA','Baabe',8011063,13.704806,54.362315],
['LBB','Baalberge',8010013,11.784682,51.763048],
['OSBAA','Baar(CH)',8502206,8.52287,47.19518],
['MBAE','Baar-Ebenhausen',8000678,11.460929,48.674463],
['ONBR','Baarn',8400086,5.2808332443237,52.208332061768],
['FLAS','Babenhausen Langstadt',8003559,8.945733,49.922274],
['FBA','Babenhausen(Hess)',8000015,8.957182,49.957963],
['RBST','Babstadt',8000681,9.060708,49.240196],
['XTBY','Babylon',5400400,12.869049,49.398878],
['FBCH','Bacharach',8000683,7.769523,50.056101],
['MBCN','Bachern',8000685,11.378716,48.280159],
['UB','Bachfeld',8011065,10.982451,50.405772],
['RBH','Bachheim',8000686,8.399399,47.862072],
['TB','Backnang',8000016,9.425989,48.942676],
['NBAB','Bad Abbach',8000689,11.994322,48.922732],
['MBAI','Bad Aibling',8000690,12.004157,47.862028],
['MBAK','Bad Aibling Kurpark',8000696,12.013823,47.857617],
['FAR','Bad Arolsen',8000609,8.997792,51.3816],
['XABA','Bad Aussee',8100164,13.7765235895763,47.5990565231694],
['RBEL','Bad Bellingen',8000864,7.557601,47.730804],
['BBIG','Bad Belzig',8010031,12.594981,52.135969],
['HBTH','Bad Bentheim',8000879,7.158539,52.30985],
['RBZB','Bad Bergzabern',8000691,8.002787,49.103209],
['UBB','Bad Berka',8011066,11.28155,50.896138],
['UBBZ','Bad Berka Zeughausplatz',8011067,11.280095,50.900441],
['EBLB','Bad Berleburg',8000907,8.394109,51.051197],
['ABVS','Bad Bevensen',8000935,10.574141,53.078247],
['MBIB','Bad Birnbach',8000988,13.074034,48.432853],
['UBL','Bad Blankenburg(Thüringerw)',8010014,11.275498,50.682648],
['XABB','Bad Blumau',8100663,16.0565695247989,47.1234144896724],
['KBOD','Bad Bodendorf',8001049,7.217217,50.556266],
['HBOD','Bad Bodenteich',8001052,10.673371,52.834275],
['DBM','Bad Brambach',8011068,12.311414,50.217587],
['ABSD','Bad Bramstedt',8007058,9.890162,53.920593],
['ABSK','Bad Bramstedt Kurhaus',8007057,9.890463,53.904013],
['KBRE','Bad Breisig',8000694,7.304564,50.504218],
['FCA','Bad Camberg',8001322,8.255036,50.296433],
['WDO','Bad Doberan',8010016,11.905335,54.100004],
['WDOG','Bad Doberan Goethestraße',8011069,11.899894,54.108463],
['WDOS','Bad Doberan Stadtmitte',8081085,11.9021,54.10465],
['HBDG','Bad Driburg(Westf)',8000697,9.03081,51.730323],
['RBDH','Bad Dürkheim',8000698,8.170701,49.460633],
['RBDT','Bad Dürkheim-Trift',8000708,8.193072,49.466416],
['LDBG','Bad Dürrenberg',8011071,12.069655,51.304941],
['DBEL','Bad Elster',8011072,12.256286,50.296672],
['FEMS','Bad Ems',8000701,7.728637,50.327652],
['FEMW','Bad Ems West',8000702,7.706039,50.330694],
['MBEF','Bad Endorf',8001787,12.301558,47.905066],
['HFAL','Bad Fallingbostel',8001958,9.700233,52.862925],
['WFW','Bad Freienwalde',8010017,14.035751,52.789933],
['TBF','Bad Friedrichshall Hbf',8000017,9.199771,49.231571],
['TBK','Bad Friedrichshall-Kochendorf',8000704,9.211549,49.217753],
['HBGM','Bad Gandersheim',8000352,10.020236,51.86737],
['XABG','Bad Gastein',8100095,13.1319838655024,47.1118078213117],
['RBGR','Bad Griesbach(Schwarzwald)',8000707,8.230569,48.448618],
['MGNB','Bad Grönenbach',8002378,10.253715,47.882468],
['HBHA','Bad Harzburg',8000019,10.555444,51.888116],
['RHLB','Bad Herrenalb',8007011,8.438957,48.802428],
['FBHF','Bad Hersfeld',8000020,9.716182,50.869632],
['XABH','Bad Hofgastein',8100097,13.1005564309789,47.1953376763758],
['HHZH','Bad Holzhausen',8002978,8.545854,52.289097],
['FHO','Bad Homburg',8000712,8.620624,50.219904],
['KHF','Bad Honnef Stadtbahn',8070073,7.217231,50.64375],
['KHBD','Bad Honnef(Rhein)',8000713,7.219533,50.639772],
['MBHT','Bad Höhenstadt',8000710,13.323195,48.494606],
['KHGB','Bad Hönningen',8000711,7.310871,50.513676],
['TIMN','Bad Imnau',8070309,8.770092,48.404155],
['XAIS','Bad Ischl',8100157,13.6275770677526,47.7122337680111],
['HKRF','Bad Karlshafen',8003182,9.44571,51.64627],
['NBKI','Bad Kissingen',8000714,10.079885,50.191547],
['WK','Bad Kleinen',8010018,11.466925,53.766974],
['MBKG','Bad Kohlgrub',8000716,11.058204,47.668006],
['MBKK','Bad Kohlgrub Kurhaus',8000717,11.039181,47.670213],
['SBKN','Bad Kreuznach',8000021,7.866435,49.842399],
['RBKR','Bad Krozingen',8000718,7.697632,47.919721],
['RBKO','Bad Krozingen Ost',8007330,7.70979,47.91714],
['FKI','Bad König',8000715,9.001539,49.738577],
['FZK','Bad König Zell',8006643,8.994116,49.720326],
['UKO','Bad Kösen',8010019,11.718274,51.130742],
['UBKZ','Bad Köstritz',8011074,12.028452,50.93159],
['NKZ','Bad Kötzting',8003393,12.851892,49.17292],
['ELSP','Bad Laasphe',8003486,8.42072,50.929312],
['ENL','Bad Laasphe-Niederlaasphe',8003493,8.442001,50.924324],
['ULS','Bad Langensalza',8010020,10.640671,51.101701],
['LBLS','Bad Lausick',8011077,12.648695,51.143803],
['HBLB','Bad Lauterberg im Harz Barbis',8005324,10.414607,51.619024],
['BBLW','Bad Liebenwerda',8011078,13.40293,51.518401],
['TBLI','Bad Liebenzell',8000721,8.734039,48.772578],
['ULB','Bad Lobenstein',8013452,11.642171,50.452122],
['AMAG','Bad Malente-Gremsmühlen',8003829,10.55151,54.167014],
['TBMR','Bad Mergentheim',8000724,9.771662,49.493647],
['HMDD','Bad Münder(Deister)',8000725,9.468062,52.178192],
['SBMS','Bad Münster a Stein',8000726,7.846989,49.813426],
['KMUE','Bad Münstereifel',8000727,6.764369,50.558914],
['KARL','Bad Münstereifel-Arloff',8000601,6.786608,50.597676],
['KIV','Bad Münstereifel-Iversheim',8003104,6.769162,50.583034],
['FBNA','Bad Nauheim',8000728,8.749334,50.367904],
['HNDF','Bad Nenndorf',8000022,9.378603,52.343735],
['KNEB','Bad Neuenahr',8000729,7.144304,50.547765],
['NBNE','Bad Neustadt(Saale)',8000730,10.226134,50.328127],
['TBN','Bad Niedernau',8000731,8.896533,48.460766],
['XNNS','Bad Nieuweschans',8400457,7.19937,53.1844],
['HOY','Bad Oeynhausen',8000732,8.796523,52.205398],
['HBOE','Bad Oeynhausen Süd',8000733,8.801723,52.197127],
['AO','Bad Oldesloe',8000023,10.382832,53.805283],
['RBPL','Bad Peterstal',8000734,8.201948,48.428895],
['HPRT','Bad Pyrmont',8000735,9.272719,51.974233],
['XSRA','Bad Ragaz',8509004,9.50521579767137,47.0103066076757],
['RBRA','Bad Rappenau',8000736,9.101529,49.237765],
['RBPK','Bad Rappenau Kurpark',8000777,9.113526,49.240371],
['MBRL','Bad Reichenhall',8000737,12.881825,47.731168],
['MBRK','Bad Reichenhall-Kirchberg',8000738,12.874001,47.718538],
['NRC','Bad Rodach',8005112,10.778387,50.336986],
['RRO','Bad Rotenfels Bf',8005183,8.3031,48.815822],
['RROG','Bad Rotenfels Schloss',8005186,8.297131,48.819949],
['RROW','Bad Rotenfels Weinbrennerstraße',8005187,8.312054,48.811515],
['BBSP','Bad Saarow',8011079,14.064929,52.293253],
['BBSK','Bad Saarow Klinikum',8010028,14.065964,52.284632],
['BBSS','Bad Saarow-Pieskow',8011080,14.0711421,52.2707389],
['HSCH','Bad Sachsa',8000739,10.573211,51.581944],
['HBSA','Bad Salzdetfurth',8000740,10.005595,52.062635],
['HBSK','Bad Salzdetfurth Solebad',8000759,10.018916,52.06994],
['FBSH','Bad Salzhausen',8000741,8.980381,50.418878],
['FSF','Bad Salzschlirf',8000743,9.494484,50.626935],
['EBSU','Bad Salzuflen',8000744,8.740428,52.081628],
['ESYL','Bad Salzuflen-Sylbach',8005810,8.765529,52.026884],
['USZ','Bad Salzungen',8010021,10.23106,50.815185],
['EBSA','Bad Sassendorf',8000745,8.162439,51.587168],
['TSL','Bad Saulgau',8005301,9.501083,48.013593],
['XASBW','Bad Schallerbach-Wallern',8100021,13.9222143926918,48.2286625314622],
['DSA','Bad Schandau',8010022,14.139322,50.918835],
['DSUB','Bad Schlema',8012873,12.680229,50.618902],
['LBSB','Bad Schmiedeberg',8011081,12.743874,51.688761],
['LBSK','Bad Schmiedeberg Kurzentrum',8070831,12.734999,51.67901],
['TBSC','Bad Schussenried',8000746,9.668497,47.994033],
['ASCH','Bad Schwartau',8000749,10.702722,53.916276],
['RBS','Bad Schönborn Süd',8003533,8.641924,49.200001],
['RBSK','Bad Schönborn-Kronau',8004032,8.646821,49.219345],
['TBSB','Bad Sebastiansweiler-Belsen',8000750,9.030023,48.395566],
['ASB','Bad Segeberg',8000751,10.308163,53.933805],
['SSOB','Bad Sobernheim',8005583,7.649816,49.78285],
['FBSO','Bad Soden(Taunus)',8000752,8.504128,50.143406],
['FBSS','Bad Soden-Salmünster',8005261,9.372053,50.280742],
['FBSD','Bad Sooden-Allendorf',8000753,9.968696,51.267974],
['APSD','Bad St Peter Süd',8000754,8.648041,54.30501],
['APO','Bad St Peter-Ording',8000755,8.614736,54.317293],
['NSFN','Bad Staffelstein',8005670,10.994239,50.108258],
['NBST','Bad Steben',8000756,11.64677,50.365095],
['LSUR','Bad Suderode',8011084,11.125782,51.733673],
['UBS','Bad Sulza',8011085,11.634595,51.094767],
['RSAE','Bad Säckingen',8005255,7.94863,47.555857],
['TBT','Bad Teinach-Neubulach',8000757,8.727148,48.67847],
['MBT','Bad Tölz',8000758,11.57394,47.760578],
['KTST','Bad Tönisstein',8070314,7.298859,50.459318],
['TUC','Bad Urach',8006029,9.396483,48.491244],
['TUCK','Bad Urach Ermstalklinik',8006027,9.386901,48.494155],
['TUCW','Bad Urach Wasserfall',8070680,9.376401,48.499263],
['XAVN','Bad Vigaun',8101718,13.1241752840184,47.6642034764411],
['FVL','Bad Vilbel',8000760,8.73946,50.188677],
['FVLS','Bad Vilbel Süd',8000761,8.733477,50.178696],
['FGRN','Bad Vilbel-Gronau',8002382,8.783203,50.191529],
['OABV','Bad Vöslau',8100708,16.224028,47.969569],
['TBWA','Bad Waldsee',8000763,9.752274,47.925244],
['TWB','Bad Wildbad Bf',8006431,8.551089,48.755718],
['TWBK','Bad Wildbad Kurpark',8070283,8.550459,48.748755],
['TWBN','Bad Wildbad Nord',8070281,8.555095,48.763936],
['TWBU','Bad Wildbad Uhlandplatz',8070282,8.549366,48.750837],
['FBWD','Bad Wildungen',8000764,9.136091,51.119619],
['WWIL','Bad Wilsnack',8011088,11.949344,52.960229],
['RBWF','Bad Wimpfen',8000765,9.167297,49.229744],
['TBWT','Bad Wimpfen Im Tal',8000706,9.187046,49.229848],
['RBWH','Bad Wimpfen-Hohenstadt',8000766,9.138753,49.242537],
['NBWI','Bad Windsheim',8000767,10.412942,49.5066],
['TBW','Bad Wurzach',8000769,9.889739,47.910258],
['MBWH','Bad Wörishofen',8000768,10.597875,48.005711],
['XSZZ','Bad Zurzach',8503409,8.29556465397506,47.5883101087174],
['HZWI','Bad Zwischenahn',8000770,8.003123,53.182547],
['HBAD','Baddeckenstedt',8000772,10.228767,52.08916],
['OABA','Baden b.Wien',8100025,16.242798,48.004042],
['XSBA','Baden(CH)',8503504,8.30769276309784,47.4764202249643],
['HBDV','Baden(Verden)',8000773,9.081261,53.007872],
['RBB','Baden-Baden',8000774,8.190831,48.790327],
['RHEB','Baden-Baden Haueneberstein',8000771,8.209021,48.811907],
['RBBL','Baden-Baden Rebland',8000775,8.146572,48.733844],
['ONBF','Baflo',8400089,6.5916666984558,53.3608969],
['BBG','Bagenz',8011097,14.426908,51.654888],
['RBAR','Bahlingen Riedlen',8007310,7.747776,48.118019],
['RBAL','Bahlingen am Kaiserstuhl',8007293,7.741516,48.124494],
['RBBR','Bahnbrücken',8007144,8.764854,49.119447],
['FKNZ','Bahnhof Niederzwehren, Kassel',716781,9.475953,51.293161],
['RGHM','Bahnhof, Gönnheim',506735,8.23226,49.458077],
['BBO','Bahnsdorf',8011098,14.112288,51.581745],
['MBAB','Baierbrunn',8000781,11.480027,48.018741],
['RBSN','Baiersbronn Bf',8000782,8.371868,48.504104],
['RBSS','Baiersbronn Schule',8000789,8.375858,48.51061],
['NBD','Baiersdorf',8000783,11.036976,49.656147],
['OFBLS','Baillargues(L Mazes)',8700735,4.007166,43.653326],
['XFBX','Baisieux',8700510,3.234785,50.618564],
['BBAI','Baitz',8011100,12.685111,52.164149],
['XTBNJ','Bakov nad Jizerou',5400033,14.922876,50.472273],
['NBAF','Balbersdorf',8000784,12.683064,49.29044],
['MBDH','Baldham',8000785,11.78678,48.099256],
['FBAD','Balduinstein',8000786,7.968,50.34682],
['XSBAL','Balerna',8505306,9.00503477094019,45.8467569390444],
['TBLH','Balgheim',8000787,8.759892,48.065886],
['UBGS','Balgstädt',8011103,11.738454,51.208295],
['TBGS','Balingen Süd',8000788,8.846484,48.269014],
['TBG','Balingen(Württ)',8000353,8.850307,48.278469],
['FBAL','Ballersbach',8000790,8.365908,50.688602],
['UBAS','Ballstädt(Gotha)',8011106,10.707666,51.04075],
['SBAL','Baltersweiler',8000792,7.166538,49.493785],
['EBAV','Balve',8000793,7.863071,51.332594],
['NBA','Bamberg',8000025,10.899489,49.900759],
['RBAM','Bammental',8000794,8.783685,49.359588],
['WBAM','Bannemin-Mölschow',8011108,13.836574,54.071397],
['XRBJ','Banova Jaruga',7800010,16.8763035,45.445891],
['WBN','Bansin Seebad',8011109,14.129385,53.964389],
['HBAN','Banteln',8000796,9.75033,52.066264],
['WBTN','Bantin',8011110,10.968497,53.53598],
['HBTF','Bantorf',8000797,9.417771,52.332253],
['XFBH','Bantzenheim',8700329,7.503901,47.810985],
['XFBAY','Banyuls-sur-Mer',8700485,3.124842,42.482945],
['XFBD','Bar-le-Duc',8700262,5.167259,48.77361],
['TBA','Barabein',8079098,9.826902,48.144734],
['OMBRN','Barand',5500268,21.234759,47.299908],
['RBRT','Barbelroth',8000802,8.070307,49.104118],
['LBY','Barby',8010024,11.86877062,51.96970764],
['XEBS','Barcelona Sants',7100064,2.140369,41.378914],
['ABCL','Barchel',8071336,9.027667,53.471851],
['PIFAN','Bardonecchia Confine',8346045,6.710151,45.083788],
['ABAD','Bardowick',8000801,10.371994,53.290469],
['XNBA','Barendrecht',8400090,6.5854178,51.854721069336],
['ABAT','Bargstedt',8007840,9.446276,53.457544],
['ABAE','Bargteheide',8000804,10.269104,53.7282],
['LBAR','Barleben',8011111,11.620875,52.208945],
['LBAS','Barleber See',8011112,11.640852,52.214328],
['ABMS','Barmstedt',8007070,9.772007,53.792978],
['ABMB','Barmstedt Brunnenstr',8007069,9.761888,53.792619],
['ONBAC','Barneveld Centrum',8400091,6.5844445228577,52.139999389648],
['ONBAN','Barneveld Noord',8400092,6.5786272287369,52.161388397217],
['PNACA','Barneveld Zuid',8400111,6.5759947,52.128853],
['HBNF','Barnstorf(Han)',8000807,8.510462,52.707587],
['HBNT','Barnten',8000808,9.815279,52.195498],
['HBAR','Barrien',8000810,8.818506,52.946837],
['HBGH','Barsinghausen',8000812,9.467112,52.30489],
['OFBTH','Bartenheim(Bale)',8700789,7.4875323,47.6349493],
['WBH','Barth',8011114,12.72646,54.362342],
['DBAM','Barthmühle',8011115,12.163681,50.557957],
['BBA','Baruth(Mark)',8011116,13.511963,52.057916],
['XLBA','Bascharage-Sanem',8270060,5.925264,49.558601],
['ABAA','Basdahl Kluste',8070023,9.012175,53.4542],
['BBAS','Basdorf',8010025,13.433993,52.715561],
['RB','Basel Bad Bf',8000026,7.607805,47.567288],
['XSBP','Basel Dreispitz',8500132,7.609387,47.53753],
['XSB','Basel SBB',8500010,7.58955146720631,47.5474041526969],
['XSBJ','Basel St Johann',8500016,7.57251267011701,47.5702960042253],
['XSBD','Bassersdorf',8503307,8.62619947665697,47.4385636372036],
['HBAS','Bassum',8000354,8.739924,52.847388],
['OPBAT','Batowice Lubanskie',5100370,15.155849,51.090947],
['RBZE','Batzenhäusle',8000821,7.94108,48.089064],
['NBH','Batzhausen',8000822,11.593033,49.191364],
['RBBC','Bauerbach',8000823,8.748153,49.073964],
['SBH','Baumholder',8007888,7.331236,49.61216],
['NBAU','Baunach',8000826,10.854115,49.98909],
['FGTH','Baunatal-Guntershausen',8000140,9.466997,51.229917],
['FREH','Baunatal-Rengershausen',8005039,9.468667,51.254922],
['XDBH','Baunhoej',8602944,8.283025,55.63612],
['DBZ','Bautzen',8010026,14.428735,51.173097],
['ABF','Bavendorf',8000827,10.629537,53.187474],
['MBYB','Bayerbach',8000828,13.134451,48.414412],
['NBEI','Bayerisch Eisenstein',8000830,13.209815,49.121862],
['MBGM','Bayerisch Gmain',8000831,12.89507,47.720375],
['XFBY','Bayonne',8700257,-1.470385,43.497083],
['NBY','Bayreuth Hbf',8000028,11.579985,49.949616],
['NBYG','Bayreuth-St Georgen',8000833,11.596683,49.95734],
['MBZ','Bayrischzell',8000834,12.011773,47.675406],
['OFBER','Beaucaire(Gard)',8700696,4.645086,43.800039],
['OFBEM','Beaulieu-sur-Mer',8700446,7.331719,43.706623],
['LBBZ','Bebitz',8011119,11.763967,51.724136],
['FB','Bebra',8000029,9.797788,50.969568],
['UBET','Bechstedt-Trippstein',8011121,11.168153,50.659733],
['SBE','Beckingen(Saar)',8000840,6.688021,49.386881],
['ENBM','Beckum-Neubeckum',8004251,8.02136,51.801951],
['KBE','Bedburg(Erft)',8000030,6.572615,50.987478],
['KBH','Bedburg-Hau',8000842,6.173479,51.758052],
['ONBD','Bedum',8400094,6.5752778053284,53.3068857],
['ONBE','Beek-Elsloo',8400096,6.5708332061768,50.947498321533],
['EBEE','Beelen',8000846,8.116159,51.92932],
['BBZS','Beelitz Stadt',8013468,12.96686,52.239395],
['BBEL','Beelitz-Heilstätten',8013467,12.926057,52.262345],
['FHZ','Beerfelden Hetzbach',8002815,8.992856,49.594899],
['XBBE','Beernem',8800302,3.329119,51.128225],
['ONBED','Beesd',8400097,6.5696679,51.899444580078],
['BBES','Beeskow',8010029,14.250974,52.177684],
['WBES','Beetz-Sommerfeld',8011125,13.022086,52.804259],
['NBEH','Behringersdorf',8000850,11.198498,49.481574],
['FBEI','Beienheim',8000851,8.821022,50.359131],
['ONBEL','Beilen',8400100,6.5671364,52.854721069336],
['LBEI','Beilrode',8011131,13.064935,51.571005],
['TBS','Beimerstetten',8000858,9.976835,48.480974],
['XMBS','Bekescsaba',5500109,21.081542,46.670041],
['XTBPB','Bela pod Bezdezem',5400253,14.835816,50.488267],
['XTBPM','Bela pod Bezdezem mesto',5400439,14.787354,50.493245],
['XTBPZ','Bela pod Bezdezem zastavka',5400440,14.866621,50.500059],
['ABE','Beldorf',8000860,9.356217,54.125266],
['XFBF','Belfort Ville',8700024,6.853623,47.633367],
['LBGH','Belgershain',8011132,12.542785,51.233947],
['LBLL','Belleben',8011133,11.633376,51.673603],
['XFBA','Bellegarde(Ain)',8700068,5.825962,46.110918],
['MBNB','Bellenberg',8000862,10.09039,48.254645],
['XFBV','Belleville Meurthe et Moselle',8700330,6.101116,48.819677],
['RBLN','Bellheim Am Mühlbuckel',8000861,8.297626,49.192639],
['RBLH','Bellheim Bf',8000863,8.29456,49.188303],
['XSBZ','Bellinzona',8505213,9.02950898687494,46.1954368160242],
['XSBEP','Belp',8507076,7.49863601858042,46.8888830920118],
['XLBUL','Belval Lycée',8270135,5.934222,49.50137],
['XLBR','Belval-Rédange',8270130,5.924189,49.502846],
['XLBUN','Belval-Université',8270140,5.948587,49.499794],
['XLBS','Belvaux-Soleuvre',8270150,5.926471,49.514962],
['TBEM','Bempflingen',8000865,9.273425,48.572364],
['MBEN','Benediktbeuern',8000869,11.403051,47.709121],
['XTBP','Benesov n. Ploucnici',5400035,14.305071,50.738202],
['XFBTR','Benestroff',8700557,6.753114,48.906704],
['XFBEF','Benfeld(Selestat)',8700551,7.583799,48.373672],
['SBG','Bengel',8000870,7.05803,50.010379],
['XFBE','Bening',8700270,6.828917,49.138191],
['LBEK','Benneckenstein',8017002,10.714811,51.673547],
['HBML','Bennemühlen',8000871,9.726836,52.580993],
['LWZW','Bennewitz',8013362,12.70843,51.355926],
['HBEN','Bennigsen',8000872,9.666376,52.240733],
['TBEN','Benningen(Neckar)',8000873,9.244504,48.943614],
['UBEN','Bennungen',8011138,11.122989,51.464006],
['UBH','Benshausen',8011139,10.602208,50.657009],
['FBH','Bensheim',8000031,8.616717,49.681329],
['FBAU','Bensheim-Auerbach',8000877,8.613366,49.701557],
['WBE','Bentwisch',8011140,12.210506,54.117193],
['NBE','Beratzhausen',8000882,11.807853,49.092846],
['DBER','Berbisdorf',8011142,13.725065,51.186194],
['DBEA','Berbisdorf Anbau',8011143,13.72739,51.197771],
['XLBC','Berchem(LUX)',8270160,6.133596,49.542695],
['MBG','Berchtesgaden Hbf',8000885,12.999058,47.626688],
['XMBTU','Berettyoujfalu',5500116,21.532086,47.21203],
['XSBRG','Berg(CH)',8506194,9.17451078977963,47.5822523245078],
['RBRG','Berg(Pfalz)',8000890,8.212761,48.980676],
['UBGE','Berga(Elster)',8011144,12.158865,50.747189],
['UBK','Berga-Kelbra',8010032,11.014599,51.45217],
['WBG','Bergen auf Rügen',8010033,13.417821,54.4205],
['XNBZ','Bergen op Zoom',8400108,4.296089,51.494446],
['MBE','Bergen(Oberbay)',8000888,12.592846,47.82527],
['TBER','Bergenweiler',8000889,10.272879,48.576297],
['BBFE','Bergfelde(b Berlin)',8080100,13.320244,52.670303],
['RBGBS','Berghausen Am Stadion',8007864,8.53601,49.002456],
['RHUM','Berghausen Hummelberg',8070020,8.526807,49.00981],
['RBGBP','Berghausen Pfinzbrücke',8007863,8.52092,49.006467],
['RBGB','Berghausen(Baden)',8000893,8.530169,49.00575],
['RBGP','Berghausen(Pfalz)',8000894,8.406173,49.295449],
['EBGA','Berghausen(b Wittgenstein)',8000892,8.35001,51.033036],
['KBEE','Bergheim(Erft)',8000355,6.646302,50.951706],
['FBHG','Bergheim-Giflitz',8000897,9.134147,51.159249],
['KBGG','Bergisch Gladbach',8000899,7.124553,50.991461],
['WBER','Bergsdorf',8011149,13.260794,52.936565],
['NBHM','Bergtheim',8000902,10.076473,49.8993],
['XFBER','Bergues(Coudek)',8700707,2.425548,50.969187],
['LBWZ','Bergwitz',8011150,12.576213,51.803696],
['XSBN','Bergün/Bravuogn',8509197,9.74675138257774,46.6310688834213],
['RBE','Beringen Bad Bf',8000903,8.574616,47.694897],
['RBEF','Beringerfeld',8000901,8.592771,47.695308],
['EBRH','Beringhausen',8000904,8.751414,51.407771],
['ABGS','Beringstedt',8000905,9.537501,54.113667],
['UBWI','Berka(Wipper)',8011152,10.929902,51.352994],
['BBKR','Berkenbrück',8011154,14.165217,52.35719],
['BALE','Berlin Alexanderplatz',8011155,13.410961,52.521481],
['BALX','Berlin Alexanderplatz (S)',8089001,13.411007,52.521642],
['BARF','Berlin Alt-Reinickendorf',8089103,13.349617,52.578091],
['BAHU','Berlin Anhalter Bf',8089002,13.381362,52.503486],
['BATS','Berlin Attilastr.',8089003,13.360951,52.447681],
['BBW','Berlin Baumschulenweg',8089004,13.490097,52.467244],
['BBEV','Berlin Bellevue',8089005,13.348263,52.519955],
['BRB','Berlin Betriebsbf Rummelsburg',8089006,13.497786,52.493827],
['BBEU','Berlin Beusselstraße',8089118,13.329042,52.534354],
['BBOS','Berlin Bornholmer Str.',8089008,13.397943,52.554491],
['BBGT','Berlin Botanischer Garten',8089009,13.306766,52.447784],
['BTOR','Berlin Brandenburger Tor',8089044,13.381815,52.516506],
['BBCH','Berlin Buckower Chaussee',8089010,13.382912,52.410351],
['BBUP','Berlin Bundesplatz',8089107,13.32959,52.477617],
['BCHS','Berlin Charlottenburg (S)',8089165,13.3039445,52.504931],
['BEBD','Berlin Eichborndamm',8089101,13.316835,52.577722],
['BFB','Berlin Feuerbachstr.',8089012,13.332575,52.463546],
['BFAL','Berlin Frankfurter Allee',8089013,13.47441,52.515168],
['BFRI','Berlin Friedrichstraße',8011306,13.387314,52.520394],
['BFST','Berlin Friedrichstraße (S)',8089066,13.3869052,52.5201772],
['BGSE','Berlin Gehrenseestraße',8089014,13.524834,52.556011],
['BGS','Berlin Gesundbrunnen',8011102,13.388513,52.548963],
['BGB','Berlin Gesundbrunnen(S)',8089015,13.388513,52.548963],
['BGFB','Berlin Greifswalder Str',8089011,13.439561,52.54002],
['BGBA','Berlin Grünbergallee',8089016,13.542485,52.399411],
['BHKM','Berlin Hackescher Markt',8089017,13.402364,52.522622],
['BLS','Berlin Hbf',8011160,13.369545,52.525592],
['BHBF','Berlin Hbf (S-Bahn)',8089021,13.369545,52.525592],
['BL','Berlin Hbf (tief)',8098160,13.369545,52.525592],
['BHST','Berlin Heerstraße',8089329,13.259379,52.508121],
['BHEI','Berlin Heidelberger Platz',8089112,13.312018,52.479972],
['BHER','Berlin Hermannstraße',8089105,13.431313,52.46751],
['BHO','Berlin Hohenzollerndamm',8089108,13.300257,52.488556],
['BHUM','Berlin Humboldthain',8089018,13.379277,52.544795],
['BIP','Berlin Innsbrucker Platz',8089106,13.342197,52.478084],
['BJB','Berlin Jannowitzbrücke',8089019,13.419347,52.51427],
['BJLB','Berlin Julius-Leber-Brücke',8089537,13.361266,52.486519],
['BJUF','Berlin Jungfernheide',8011167,13.299437,52.530276],
['BJUN','Berlin Jungfernheide (S)',8089100,13.299446,52.530375],
['BKBO','Berlin Karl-Bonhoeffer-Nervenklinik',8089102,13.329176,52.578048],
['BKHD','Berlin Köllnische Heide',8089104,13.467807,52.469653],
['BLST','Berlin Landsberger Allee',8089020,13.454567,52.529593],
['BMEA','Berlin Mehrower Allee',8089022,13.553699,52.557759],
['BMN','Berlin Messe Nord/ICC (Witzleben)',8089110,13.283445,52.507525],
['BMS','Berlin Messe Süd (Eichkamp)',8089328,13.270118,52.49875],
['BMEX','Berlin Mexikoplatz',8089023,13.232712,52.436937],
['BNB','Berlin Nordbahnhof',8089024,13.388464,52.532066],
['BNPL','Berlin Nöldnerplatz',8089026,13.484452,52.503497],
['BOLS','Berlin Olympiastadion',8089330,13.242389,52.511166],
['BORS','Berlin Oranienburger Straße',8089027,13.393052,52.52521],
['BOSS','Berlin Osdorfer Straße',8089473,13.314288,52.418841],
['BHF','Berlin Ostbahnhof',8010255,13.434564,52.510977],
['BOSB','Berlin Ostbahnhof (S)',8089185,13.4351206,52.5107167],
['BOKN','Berlin Ostkreuz',8011162,13.469105,52.503037],
['BOK','Berlin Ostkreuz (S)',8089028,13.469309,52.503003],
['BPWA','Berlin Plänterwald',8089030,13.473126,52.478542],
['BPOE','Berlin Poelchaustr.',8089031,13.535381,52.535593],
['BPOF','Berlin Potsdamer Platz',8011118,13.375988,52.509379],
['BPOP','Berlin Potsdamer Platz (S)',8089032,13.376649,52.509508],
['BPLA','Berlin Prenzlauer Allee',8089033,13.426412,52.544615],
['BPRS','Berlin Priesterweg',8089034,13.356281,52.459914],
['BRW','Berlin Raoul-Wallenberg-Str.',8089035,13.54746,52.550681],
['BRST','Berlin Rathaus Steglitz',8089036,13.322948,52.455833],
['BSAP','Berlin Savignyplatz',8089037,13.319271,52.505093],
['BSC','Berlin Schichauweg',8089038,13.389303,52.398837],
['BSAL','Berlin Schönhauser Allee',8089039,13.41546,52.5492],
['BSO','Berlin Sonnenallee',8089327,13.455851,52.473101],
['BSPH','Berlin Springpfuhl',8089040,13.53674,52.526348],
['BSTO','Berlin Storkower Str',8089041,13.464398,52.52391],
['BSDG','Berlin Sundgauer Str',8089042,13.274377,52.436544],
['BSDE','Berlin Südende',8089115,13.353894,52.448457],
['BPAF','Berlin Südkreuz',8011113,13.365319,52.475047],
['BSKR','Berlin Südkreuz (S)',8089073,13.365144,52.476134],
['BTP','Berlin Treptower Park',8089043,13.461441,52.493559],
['BWS','Berlin Wannsee',8010405,13.179336,52.421058],
['BWSS','Berlin Wannsee (S)',8089190,13.179336,52.421058],
['BWRS','Berlin Warschauer Straße',8089045,13.451646,52.505976],
['BWES','Berlin Westend',8089111,13.284638,52.51807],
['BWH','Berlin Westhafen',8089116,13.344253,52.53625],
['BWKS','Berlin Westkreuz',8089047,13.283966,52.500737],
['BWOK','Berlin Wollankstraße',8089048,13.391791,52.565482],
['BWT','Berlin Wuhletal',8089049,13.575365,52.512417],
['BGGS','Berlin Yorckstr.(S1)',8089051,13.367797,52.492289],
['BYOR','Berlin Yorckstr.(S2)',8089050,13.372128,52.49117],
['BZOO','Berlin Zoologischer Garten',8010406,13.331992,52.507277],
['BZOS','Berlin Zoologischer Garten (S)',8089046,13.331992,52.507277],
['BADL','Berlin-Adlershof',8089052,13.541129,52.435031],
['BAGL','Berlin-Altglienicke',8089054,13.558753,52.407299],
['BBDF','Berlin-Biesdorf',8089055,13.555878,52.513097],
['BBLB','Berlin-Blankenburg',8089056,13.44333,52.591164],
['BBU','Berlin-Buch',8089057,13.492286,52.636162],
['BCHB','Berlin-Charlottenburg',8010403,13.303524,52.504726],
['BFRU','Berlin-Friedenau',8089058,13.341388,52.470586],
['BFFO','Berlin-Friedrichsfelde Ost',8089059,13.520254,52.514169],
['BFRH','Berlin-Friedrichshagen',8089060,13.6246,52.457247],
['BFOH','Berlin-Frohnau',8089061,13.289934,52.632758],
['BGWD','Berlin-Grunewald',8089062,13.26172,52.488693],
['BGAS','Berlin-Grünau',8089063,13.573497,52.413028],
['BHAL','Berlin-Halensee',8089109,13.290326,52.496254],
['BHLS','Berlin-Heiligensee',8089025,13.229278,52.624586],
['BHED','Berlin-Hermsdorf',8089064,13.30769,52.617782],
['BHI','Berlin-Hirschgarten',8089065,13.602134,52.457968],
['BHSH','Berlin-Hohenschönhausen',8011901,13.512565,52.566111],
['BHH','Berlin-Hohenschönhausen (S)',8089117,13.5127169,52.5661352],
['BSCF','Berlin-Johannisthal',8089007,13.52368,52.446905],
['BKH','Berlin-Karlshorst',8010035,13.526813,52.480681],
['BKLH','Berlin-Karlshorst (S)',8089193,13.5264444,52.4808347],
['BKRW','Berlin-Karow',8011046,13.469204,52.614884],
['BKAD','Berlin-Kaulsdorf',8089068,13.58894,52.512093],
['BKPK','Berlin-Köpenick',8089069,13.580942,52.45861],
['BLAK','Berlin-Lankwitz',8089114,13.341954,52.438749],
['BLO','Berlin-Lichtenberg',8010036,13.496923,52.509896],
['BLI','Berlin-Lichtenberg (S)',8089182,13.4972513,52.50992],
['BLRD','Berlin-Lichtenrade',8089070,13.396175,52.387297],
['BLIH','Berlin-Lichterfelde Ost',8011041,13.328556,52.429451],
['BLIO','Berlin-Lichterfelde Ost (S)',8089113,13.327872,52.429691],
['BLIS','Berlin-Lichterfelde Süd',8089472,13.30904,52.410899],
['BLIW','Berlin-Lichterfelde West',8089071,13.293732,52.44335],
['BMHL','Berlin-Mahlsdorf',8011343,13.611071,52.512163],
['BMDF','Berlin-Mahlsdorf (S)',8089072,13.611071,52.512163],
['BMF','Berlin-Marienfelde',8089074,13.375127,52.423634],
['BMAZ','Berlin-Marzahn',8089075,13.541341,52.543608],
['BNK','Berlin-Neukölln',8089077,13.44306,52.46942],
['BNIS','Berlin-Nikolassee',8089078,13.193643,52.431807],
['BOSP','Berlin-Oberspree',8089079,13.538209,52.452466],
['BPKW','Berlin-Pankow',8089080,13.41077,52.566477],
['BPHD','Berlin-Pankow-Heinersdorf',8089081,13.429363,52.577963],
['BPIC','Berlin-Pichelsberg',8089331,13.227134,52.510393],
['BRD','Berlin-Rahnsdorf',8089082,13.690405,52.451536],
['BRH','Berlin-Rummelsburg',8089084,13.478362,52.501309],
['BSLS','Berlin-Schlachtensee',8089085,13.215025,52.439976],
['BSZF','Berlin-Schulzendorf',8089000,13.245929,52.613096],
['BSGR','Berlin-Schöneberg',8089474,13.352068,52.479377],
['BSWP','Berlin-Schöneweide',8010041,13.509395,52.455127],
['BSW','Berlin-Schöneweide (S)',8089168,13.509115,52.454976],
['BSNH','Berlin-Schönholz',8089087,13.381111,52.571422],
['BSPD','Berlin-Spandau',8010404,13.197534,52.534475],
['BSPA','Berlin-Spandau (S)',8089083,13.1974528,52.5347721],
['BSPF','Berlin-Spindlersfeld',8089088,13.561448,52.447162],
['BSTAB','Berlin-Staaken',8013021,13.141367,52.537693],
['BSRW','Berlin-Stresow',8089053,13.209125,52.531976],
['BTG','Berlin-Tegel (S)',8089089,13.289781,52.587998],
['BTHF','Berlin-Tempelhof',8089090,13.384547,52.470967],
['BTGN','Berlin-Tiergarten',8089091,13.336392,52.514061],
['BWAI','Berlin-Waidmannslust',8089092,13.320996,52.60648],
['BWAB','Berlin-Wartenberg',8089093,13.503633,52.572989],
['BWED','Berlin-Wedding',8089131,13.36817,52.543251],
['BWIG','Berlin-Wilhelmshagen',8089094,13.722143,52.438711],
['BWM','Berlin-Wilhelmsruh',8089095,13.362976,52.581447],
['BWIN','Berlin-Wittenau (Wilhelmsruher Damm)',8089096,13.334446,52.597044],
['BWHH','Berlin-Wuhlheide',8089097,13.553202,52.46903],
['BZD','Berlin-Zehlendorf',8089098,13.258659,52.431067],
['XSBLS','Berlingen URh',8506159,9.0176698078502,47.6753379822752],
['XSBLG','Berlingen(CH)',8506135,9.0220012985392,47.6732101292116],
['RBAH','Bermatingen-Ahausen',8000909,9.345157,47.730488],
['XSBE','Bern',8507000,7.43911900575591,46.9488244969903],
['BBER','Bernau (S)',8089205,13.5922229,52.6757966],
['MBN','Bernau a Chiemsee',8000911,12.380957,47.816482],
['BBRN','Bernau(b Berlin)',8013470,13.592293,52.675833],
['BBRF','Bernau-Friedenstal',8089099,13.564578,52.668385],
['XFBEY','Bernay',8700221,0.595772,49.087047],
['LBG','Bernburg Hbf',8010043,11.751455,51.79612],
['LBGF','Bernburg-Friedenshall',8011168,11.768687,51.773623],
['LBGR','Bernburg-Roschwitz',8011605,11.7593,51.7811],
['LBGS','Bernburg-Strenzfeld',8011169,11.717645,51.819892],
['LBGW','Bernburg-Waldau',8011170,11.723312,51.805781],
['HBER','Berne',8000913,8.475368,53.183779],
['OABT','Bernhardsthal',8100457,16.879009,48.688004],
['MBER','Bernried',8000918,11.283658,47.861387],
['UBE','Bernterode',8011172,10.479945,51.405465],
['XTBU','Beroun',5400036,14.076457,49.957257],
['HBBR','Bersenbrück',8000919,7.942405,52.551242],
['XFBTM','Berthelming',8700765,7.00899,48.80978],
['DBF','Berthelsdorf(Erzgeb)',8010044,13.363608,50.875591],
['DBFO','Berthelsdorf(Erzgebirge) Ort',8017219,13.380147,50.86789],
['XLBG','Bertrange-Strassen',8270180,6.060201,49.612884],
['XBBX','Bertrix',8800035,5.267723,49.852709],
['DBTS','Bertsdorf',8010045,14.746641,50.868446],
['FBEZ','Berzhahn',8000921,8.006031,50.539891],
['XFB','Besançon-Mouillère',8702820,6.034034,47.24049],
['XFBI','Besançon-Viotte',8700044,6.021998,47.247327],
['SBS','Besch',8000923,6.372303,49.504391],
['TBE','Besigheim',8000925,9.136645,48.997723],
['SBES','Besseringen',8000926,6.602559,49.475974],
['ONBT','Best',8400112,6.5563172,51.509998321533],
['BBST','Bestensee',8011173,13.63492,52.242129],
['EBWG','Bestwig',8000927,8.397839,51.361913],
['XLB','Bettembourg',8200603,6.101414,49.516585],
['NBMS','Bettmannsäge',8000928,13.186274,48.997687],
['XSBW','Bettwiesen',8506182,9.02076959637222,47.4986165990202],
['XLBZ','Betzdorf(LUX)',8270210,6.348989,49.688887],
['EBZ','Betzdorf(Sieg)',8000034,7.87005,50.789294],
['LBEU','Beucha',8010046,12.573133,51.32362],
['WBEU','Beuchow',8013539,13.502454,54.362122],
['RBEU','Beuggen',8000932,7.810915,47.581906],
['LBEN','Beuna(Geiseltal)',8011177,11.962781,51.322765],
['UBEU','Beuren',8011178,10.279034,51.377127],
['TBEU','Beuron',8000933,8.97189,48.048791],
['TBTB','Beutelsbach',8000934,9.386029,48.810293],
['BBE','Beutersitz',8011179,13.360724,51.590359],
['HWEH','Beverungen-Wehrden',8087065,9.382552,51.709614],
['XNBK','Beverwijk',8400113,6.5404,52.478332519531],
['XSBX','Bex',8501402,7.00067755703565,46.2514595963954],
['SBX','Bexbach',8000941,7.254456,49.345698],
['LBYD','Beyendorf',8011181,11.63105,52.061145],
['OTBK','Bezdekov u Klatov',5400462,13.236643,49.380659],
['XTBEZ','Bezdez',5400464,14.729392,50.51606],
['XFBZ','Beziers',8700064,3.218798,43.336181],
['XFBR','Biarritz',8700114,-1.546077,43.459187],
['XSBC','Biasca',8505209,8.97416705214223,46.351982918019],
['MBID','Bibelöd',8000946,12.646681,47.771517],
['RBI','Biberach(Baden)',8000942,8.032762,48.338388],
['TBI','Biberach(Riß)',8000943,9.793127,48.101845],
['TBIB','Biberach(Riß) Süd',8000944,9.803236,48.087018],
['XSBB','Biberist Ost',8508089,7.56634577241446,47.1806269394652],
['XSBBS','Biberist RBS',8508068,7.55537455038958,47.18292317535],
['FBL','Biblis',8000503,8.450413,49.688881],
['UBA','Bibra',8011183,10.444326,50.468757],
['MBIC','Bichl',8000945,11.408769,47.723815],
['XABIA','Bichlbach Almkopfbahn',8101972,10.776707,47.427632],
['XABI','Bichlbach-Berwang',8100114,10.7932517900954,47.4213581488142],
['RBIC','Bichtlingen',8077777,9.101812,47.967528],
['FBI','Bickenbach(Bergstr)',8000948,8.603415,49.759632],
['FBBM','Biebesheim',8000951,8.473978,49.781977],
['FBIK','Biedenkopf',8000952,8.529989,50.909113],
['FBIZ','Biedenkopf Campus',8000954,8.517706,50.915125],
['LBZ','Biederitz',8010047,11.716466,52.15271],
['XSBL','Biel/Bienne',8504300,7.24290845287706,47.1328920532104],
['EBILP','Bielefeld Hbf',8000036,8.532722,52.029261],
['EBIO','Bielefeld Ost',8000953,8.559416,52.024013],
['EBWE','Bielefeld-Brackwede',8000048,8.498426,51.997378],
['EBIS','Bielefeld-Senne',8000956,8.520335,51.965118],
['ESES','Bielefeld-Sennestadt',8005535,8.567477,51.940582],
['EWIL','Bielefeld-Windelsbleiche',8006466,8.531378,51.957007],
['LBF','Biendorf',8011184,11.856411,51.756861],
['ABIL','Bienenbüttel',8000955,10.484714,53.142127],
['DBIE','Bienenmühle',8011185,13.528533,50.740399],
['SBI','Bierbach',8000357,7.282011,49.26189],
['HROE','Bieren-Rödinghausen',8000957,8.516964,52.239275],
['TBIE','Bieringen',8000959,8.860915,48.449029],
['EBID','Biersdorf(Westerw)',8007076,7.943623,50.749987],
['EBDO','Biersdorf-Ort(Ww)',8007113,7.949036,50.748273],
['XBBA','Bierset-Awans',8800262,5.457387,50.658179],
['LBSR','Biesenrode',8011187,11.384942,51.604085],
['WBT','Biesenthal',8011188,13.674665,52.755415],
['MBIH','Biessenhofen',8000962,10.640467,47.829956],
['RBIE','Bietigheim(Baden)',8000963,8.258045,48.910587],
['TBM','Bietigheim-Bissingen',8000038,9.137557,48.947933],
['RBGN','Bietingen',8000965,8.738915,47.744017],
['EBIG','Bigge',8000966,8.475253,51.358279],
['XMBH','Biharkeresztes',5500074,21.721966,47.135675],
['SBDS','Bildstock',8000967,7.094341,49.337325],
['TBIL','Bilfingen',8000968,8.620498,48.948674],
['XTBI','Bilina',5400208,13.772224,50.554422],
['OTBLK','Bilina Kyselka',5400474,13.759501,50.540645],
['MBIN','Billenhausen',8000969,10.358162,48.275562],
['EBB','Billerbeck',8000970,7.297482,51.981341],
['XDBL','Billum st',8600192,8.331605,55.61693],
['XSBT','Bilten',8503224,9.02990001736007,47.1521909900851],
['ONBH','Bilthoven',8400114,6.5211110115051,52.130001068115],
['XTBKN','Bily Kostel nad Nisou',5400478,14.917889,50.821192],
['RBIN','Binau',8000973,9.083631,49.372589],
['LBIF','Bindfelde',8011190,11.898035,52.584561],
['NBI','Bindlach',8000974,11.603442,49.98022],
['FBGK','Bingen(Rhein) Hbf',8000039,7.884263,49.968729],
['FBGN','Bingen(Rhein) Stadt',8000976,7.902985,49.969746],
['FBGG','Bingen-Gaulsheim',8000975,7.950983,49.967073],
['EBIN','Binolen',8000978,7.859433,51.371981],
['WBIO','Binz LB',8011193,13.609943,54.392784],
['RBZN','Binzen',8070323,7.621048,47.631409],
['OFBIO','Biot(Alpes-Maritimes)',8700723,7.126351,43.610897],
['RBCH','Birach',8007102,8.080366,48.349519],
['EBKB','Birkelbach',8000983,8.252865,51.020694],
['RBRK','Birkenau',8000984,8.708359,49.561039],
['FBBH','Birkenbringhausen',8000985,8.747257,51.025045],
['TBIR','Birkenfeld(Enz)',8000986,8.645278,48.873911],
['BBSH','Birkengrund',8080170,13.27196,52.315563],
['LBIM','Birkenmoor',8017003,10.876323,51.639655],
['BBIS','Birkenstein',8070002,13.647187,52.515601],
['BBIW','Birkenwerder(b Berlin)',8080190,13.288772,52.688249],
['UBKN','Birkungen',8010048,10.330736,51.366312],
['XSBM','Birmensdorf ZH',8502221,8.43754374340253,47.3574317945093],
['SBRB','Birresborn',8000989,6.628884,50.176411],
['DBH','Bischheim-Gersdorf',8011199,14.045844,51.228746],
['XABO','Bischofshofen',8100042,13.219888,47.417859],
['DBW','Bischofswerda',8010049,14.186144,51.125585],
['MBI','Bischofswiesen',8000997,12.960141,47.65189],
['RBIS','Bischweier',8000998,8.277543,48.832154],
['TBIS','Bisingen',8000999,8.921035,48.31277],
['HBSS','Bissendorf',8001000,9.748191,52.522705],
['SED','Bitburg-Erdorf',8001828,6.570958,49.998685],
['TBIT','Bittelbronn',8001002,8.589439,48.444404],
['LBT','Bitterfeld',8010050,12.31685,51.622861],
['TBIF','Bitzfeld',8001005,9.453222,49.187233],
['NBLA','Blaibach(Oberpf)',8001003,12.807925,49.164028],
['MBLH','Blaichach(Allgäu)',8001004,10.258796,47.543741],
['XFBLV','Blainville-Damelevieres',8700804,6.385848,48.565034],
['XUBL','Blaj',5300017,23.909297,46.1761457],
['FBLK','Blankenbach',8007282,9.230064,50.065206],
['WBL','Blankenberg(Meckl)',8010051,11.71529,53.772305],
['KBLB','Blankenberg(Sieg)',8001006,7.348499,50.768476],
['LBK','Blankenburg(Harz)',8013439,10.961184,51.795824],
['BBF','Blankenfelde(Teltow-Fläming)',8010053,13.415982,52.337213],
['UBM','Blankenheim(Sangerhausen)',8010054,11.426004,51.502781],
['KBLH','Blankenheim(Wald)',8001008,6.593504,50.441871],
['RBAN','Blankenloch',8001009,8.464729,49.066528],
['PQSBI','Blankenloch Kirche, Stutensee',721245,8.471398,49.064732],
['PQSBL','Blankenloch Mühlenweg, Stutensee',721219,8.474738,49.068742],
['PQSBN','Blankenloch Nord, Stutensee',721274,8.467376,49.073306],
['PQSBS','Blankenloch Süd, Stutensee',720338,8.466729,49.057026],
['PQSBT','Blankenloch Tolna-Platz, Stutensee',721228,8.469406,49.060342],
['WBLS','Blankensee(Meckl)',8011205,13.262907,53.408174],
['UBN','Blankenstein(Saale)',8011206,11.698549,50.401533],
['TBL','Blaubeuren',8001013,9.791979,48.403815],
['TBLF','Blaufelden',8001014,9.96768,49.296236],
['XSBS','Blausee-Mitholz',8507476,7.67548812869854,46.5289699767961],
['TBLS','Blaustein',8001015,9.919326,48.414596],
['UBHA','Blechhammer(Thür)',8011208,11.203156,50.396834],
['RBLB','Bleibach',8001017,8.004777,48.124091],
['FBLH','Bleichenbach(Oberh)',8001018,9.051582,50.320334],
['UBD','Bleicherode Ost',8010055,10.608882,51.453175],
['KBLE','Blens',8007827,6.486442,50.660249],
['XNBL','Blerick',8400117,6.155355,51.372435],
['SBKL','Blieskastel-Lautzkirchen',8001027,7.258191,49.249192],
['XABD','Blindenmarkt',8100669,14.981591499857,48.1251166210787],
['MBLM','Blindheim',8001028,10.617933,48.645095],
['ONBLO','Bloemendaal',8400118,6.5202779769897,52.404167175293],
['XABL','Bludenz',8100067,9.81444231263391,47.1549626318445],
['OABUF','Bludenz Brunnenfeld',8100699,9.8389,47.136311],
['OABLM','Bludenz-Moos',8100667,9.831148,47.142067],
['BBLU','Blumberg(b Berlin)',8011211,13.611772,52.605234],
['BAHH','Blumberg-Rehhahn',8011064,13.591948,52.596621],
['RRD','Blumberg-Riedöschingen',8001029,8.607543,47.855541],
['RZS','Blumberg-Zollhaus',8006669,8.55584,47.838059],
['DBLU','Blumenau',8011212,13.291014,50.671241],
['WBLK','Blumenhagen',8011213,13.87204,53.528329],
['WBMT','Blumenthal(Mark)',8011214,12.334096,53.076516],
['LBD','Blönsdorf',8011210,12.895568,51.95541],
['RBOB','Bobenheim',8001032,8.35032,49.588139],
['MBOB','Bobingen',8001033,10.837891,48.266373],
['WBO','Bobitz',8011215,11.3628,53.804534],
['FBST','Bobstadt',8001034,8.451786,49.663251],
['WBZN','Bobzin',8011216,11.142869,53.477175],
['XPBO','Bochnia',5100227,20.430773,49.9773],
['EBCH','Bocholt',8000040,6.620426,51.83412],
['EBO','Bochum Hbf',8000041,7.223275,51.478609],
['EBOW','Bochum West',8006711,7.211223,51.481459],
['EBDA','Bochum-Dahlhausen',8001038,7.140842,51.426358],
['EBOE','Bochum-Ehrenfeld',8001039,7.20915,51.472117],
['EBOH','Bochum-Hamme',8006710,7.200935,51.491486],
['EBP','Bochum-Langendreer',8000358,7.323645,51.477992],
['EBW','Bochum-Langendreer West',8004474,7.304327,51.478032],
['EBGZ','Bochum-Riemke',8001035,7.205275,51.5178],
['RBOK','Bockenheim-Kindenheim',8001043,8.188254,49.606872],
['XNBD','Bodegraven',8400121,6.5185581,52.081390380859],
['MBOD','Bodelsberg',8001046,10.411092,47.678113],
['TBOD','Bodelshausen',8001047,8.990601,48.383369],
['HBBU','Bodenburg',8001048,10.00133,52.031121],
['HBOF','Bodenfelde',8001050,9.561667,51.637209],
['FBOD','Bodenheim',8000359,8.312491,49.929585],
['NBMA','Bodenmais',8001051,13.101078,49.070419],
['UBOD','Bodenrode',8011219,10.20855,51.393528],
['NBOE','Bodenwöhr Nord',8001054,12.325948,49.278381],
['XSBOD','Bodio TI',8505207,8.90655905474302,46.3802576814382],
['XFBN','Boen(F)',8702850,4.005007,45.741313],
['NBO','Bogen',8001069,12.686141,48.910594],
['OPBGZ','Boguszow Gorce',5100429,16.201933,50.750166],
['OPBGW','Boguszow Gorce Wsch.',5100428,16.221592,50.747487],
['OPBOD','Boguszow Gorce Zach.',5100511,16.168628,50.761717],
['HBOM','Bohmte',8001071,8.307525,52.361632],
['OTBOH','Bohosudov',5400511,13.878662,50.672373],
['XTBO','Bohumin',5400038,18.359444,49.900731],
['KBOI','Boisheim',8001072,6.274591,51.274323],
['WBZ','Boizenburg(Elbe)',8011230,10.754481,53.378069],
['ABHT','Bokholt',8007067,9.716843,53.786107],
['XFBOW','Bollwiller(Lutterb)',8700293,7.267578,47.85702],
['XIBC','Bologna Centrale',8300217,11.343411,44.50614],
['XIBZ','Bolzano/Bozen',8300084,11.358791,46.496377],
['TBD','Bondorf(b Herrenberg)',8001080,8.827662,48.523552],
['KBBS','Bonn Brühler Str.',8070741,7.068908,50.740317],
['KB','Bonn Hbf',8000044,7.097136,50.732008],
['KB  T','Bonn Hbf (tief)',8098044,7.098023,50.732157],
['KBHH','Bonn Helmholtzstraße',8001081,7.052615,50.721844],
['KB  B','Bonn Heussallee/Museumsmeile',8070026,7.120601,50.716732],
['KB  A','Bonn Konrad-Adenauer-Platz',8070075,7.117656,50.739305],
['KB  H','Bonn Stadthaus',8070107,7.095263,50.736593],
['KBUN','Bonn UN Campus',8001091,7.118018,50.714559],
['KBBG','Bonn-Bad Godesberg',8001082,7.159555,50.683927],
['KBBGS','Bonn-Bad Godesberg Stadthalle',8070231,7.158556,50.68051],
['KBB','Bonn-Beuel',8001083,7.127657,50.738476],
['KBD','Bonn-Duisdorf',8001084,7.042548,50.716475],
['KBEC','Bonn-Endenich Nord',8001088,7.062211,50.73559],
['KBM','Bonn-Mehlem',8001085,7.181342,50.669153],
['KBO','Bonn-Oberkassel',8001086,7.1593,50.715073],
['KBO M','Bonn-Oberkassel Mitte',8070754,7.17106,50.712604],
['PQBR','Bonn-Ramersdorf',8070027,7.155262,50.722279],
['HBHB','Bookholzberg',8001089,8.532556,53.099112],
['OBO','Boom',8800315,4.360326,51.090731],
['XBBDL','Boondael/Boondaal',8800581,4.393567,50.801835],
['ABOS','Boostedt',8007061,10.0162,54.017738],
['TBP','Bopfingen',8001090,10.351707,48.855153],
['KBOP','Boppard Hbf',8000045,7.586102,50.231413],
['KBPS','Boppard Süd',8000324,7.595521,50.230197],
['KSAL','Boppard-Bad Salzig',8000742,7.635481,50.205251],
['KBZ','Boppard-Buchholz',8001235,7.554876,50.210802],
['KFLH','Boppard-Fleckertshöhe',8002004,7.577889,50.197925],
['KHIR','Boppard-Hirzenach',8002861,7.648436,50.175075],
['XFBJ','Bordeaux-St-Jean',8700047,-0.55592,44.826486],
['ABRD','Bordesholm',8001092,10.043711,54.174373],
['ASBRN','Boren-Lindaunis Schleibrücke Nord',8075385,9.819097,54.584452],
['EBOR','Borgeln',8001093,8.032033,51.598265],
['EBHS','Borgholzhausen',8001095,8.266579,52.085229],
['XIBOD','Borgo S. Dalmazzo',8300364,7.486201,44.326211],
['BBOR','Borgsdorf',8080200,13.27675,52.715252],
['EBOK','Bork(Westf)',8001097,7.456308,51.66933],
['FBOK','Borken(Hess)',8001098,9.277,51.050684],
['EBK','Borken(Westf)',8000346,6.865279,51.848962],
['BBK','Borkheide',8011238,12.854413,52.230775],
['LBL','Borna(Leipzig)',8011242,12.486291,51.117926],
['XNBO','Borne(NL)',8400124,6.4736108779907,52.298889160156],
['EBHT','Bornholte(b Verl)',8070447,8.534366,51.87494],
['FBO','Borsdorf(Hess)',8001104,8.975223,50.42941],
['LBOR','Borsdorf(Sachs)',8010059,12.541165,51.345705],
['ONBOK','Boskoop',8400125,6.462,52.077777862549],
['PNBKS','Boskoop Snijdelwijk',8400126,6.458839,52.067658],
['XSBOH','Bottighofen',8506127,9.21308178053177,47.6407078713793],
['EBTH','Bottrop Hbf',8000047,6.936684,51.50945],
['EBTB','Bottrop-Boy',8001107,6.967729,51.537163],
['EBTV','Bottrop-Vonderort',8001108,6.912294,51.501728],
['XDBV','Boulevarden st',8600285,8.459927,55.623852],
['XFBM','Bourg-St.Maurice',8700130,6.771668,45.618829],
['XFBB','Bourg-en-Bresse',8700037,5.214771,46.199927],
['XFBGS','Bourges',8700042,2.394386,47.094311],
['SBO','Bous(Saar)',8001110,6.792639,49.275979],
['PNABP','Boven-Hardinxveld',8400098,6.4492656,51.832222],
['XNBF','Bovenkarspel Flora',8400230,6.4263887405395,52.696109771729],
['XNBG','Bovenkarspel-Grootebroek',8400127,6.42027759552,52.694999694824],
['TBOX','Boxberg-Wölchingen',8001111,9.640048,49.485596],
['ONBM','Boxmeer',8400128,6.4158334732056,51.644521767653],
['ONBX','Boxtel',8400129,6.4062361,51.58433],
['EBRB','Brachbach',8001112,7.941492,50.821987],
['KBRC','Brachelen',8001113,6.231463,51.007824],
['WBRH','Brahlstorf',8011248,10.951992,53.364421],
['HBKE','Brake(Unterweser)',8001120,8.48135,53.328817],
['EBRA','Brake(b Bielefeld)',8001118,8.604914,52.069653],
['HBKH','Brakel(Höxter)',8001121,9.1832,51.712165],
['XDBM','Bramming st',8600297,8.706777,55.464511],
['HBRM','Bramsche',8001122,7.975007,52.410879],
['HBRA','Bramstedt(b Syke)',8001123,8.786024,52.871611],
['BBRA','Brand Tropical Islands',8011250,13.72149,52.029953],
['LBA','Brandenburg Altstadt',8011252,12.530347,52.4117],
['LB','Brandenburg Hbf',8010060,12.566138,52.400554],
['FBRD','Brandoberndorf',8001126,8.493816,50.431621],
['MBRS','Brandstätt',8001128,12.1275572,48.0730131],
['MBB','Brannenburg',8001129,12.106464,47.741354],
['XUBS','Brasov',5300005,25.613708,45.66152],
['XYBN','Bratislava Nove Mesto',5600209,17.146609,48.171898],
['XYB','Bratislava hl.st.',5600207,17.106466,48.15891],
['XYBZ','Bratislava-Petrzalka',5600582,17.100448,48.120679],
['KBRB','Braubach',8001130,7.643187,50.27414],
['XABR','Braunau/Inn',8100365,13.047988,48.259124],
['LBS','Braunsbedra',8011255,11.884594,51.288781],
['LBSO','Braunsbedra Ost',8011256,11.902549,51.289916],
['HBS','Braunschweig Hbf',8000049,10.540295,52.252218],
['HGLI','Braunschweig-Gliesmarode',8001134,10.551499,52.275721],
['DBDL','Braunsdorf-Lichtenwalde',8011257,13.011854,50.879776],
['SBA','Brebach',8001135,7.02886859,49.21620262],
['XTBE','Breclav',5400202,16.893236,48.7539],
['XNBR','Breda',8400131,6.3642466,51.595554351807],
['ONBRP','Breda-Prinsenbeek',8400132,6.3486,51.606388092041],
['WBDN','Breddin',8011258,12.224216,52.886047],
['XDBR','Bredebro st',8600313,8.823061,55.056895],
['EBDL','Bredelar',8001137,8.776566,51.41917],
['ABRB','Bredenbek',8001136,9.867004,54.315112],
['ABST','Bredstedt',8001139,8.970336,54.621166],
['SBRE','Brefeld',8001140,7.04914158,49.31355113],
['XAB','Bregenz',8100090,9.739627,47.503003],
['XABHF','Bregenz Hafen',8101950,9.748294,47.506117],
['XARD','Bregenz Riedenburg',8100473,9.721313,47.492908],
['LBN','Brehna',8011260,12.222163,51.554457],
['XFBRY','Breil-sur-Roya',8702908,7.516326,43.944042],
['KBRN','Breinig',8079063,6.21404,50.731121],
['RBRS','Breisach',8001143,7.58935,48.026918],
['DBRE','Breitenbrunn(Erzg)',8011263,12.746053,50.477081],
['MBRN','Breitenbrunn(Schwab)',8001147,10.408505,48.138586],
['NBRE','Breitendiel',8001148,9.225052,49.691382],
['DBTD','Breitendorf',8011264,14.622726,51.138652],
['NBG','Breitengüßbach',8001149,10.887135,49.96683],
['OABTZ','Breitenschützing',8100695,13.800887,48.078787],
['KBRS','Breitscheidt(Altenkirchen, Ww)',8001153,7.661486,50.748435],
['UBRT','Breitungen(Werra)',8011265,10.32223,50.752475],
['HB','Bremen Hbf',8000050,8.813834,53.083481],
['HBKO','Bremen Kreinsloger',8007896,8.557846,53.188782],
['HBMU','Bremen Mühlenstraße',8007895,8.57134,53.18521],
['HBN','Bremen Neustadt',8001155,8.785808,53.075782],
['HBTU','Bremen Turnerstraße',8007897,8.545403,53.193237],
['HBRN','Bremen-Aumund',8007892,8.617338,53.185226],
['HBRB','Bremen-Blumenthal',8007894,8.58118,53.183635],
['HBB','Bremen-Burg',8001156,8.704773,53.160288],
['HBRF','Bremen-Farge',8007898,8.516602,53.2052],
['HBHM','Bremen-Hemelingen',8001157,8.886759,53.054572],
['HBL','Bremen-Lesum',8001159,8.686152,53.170716],
['HBM','Bremen-Mahndorf',8001160,8.944627,53.039762],
['HBON','Bremen-Oberneuland',8001161,8.938511,53.087038],
['HBOS','Bremen-Oslebshausen',8001162,8.740801,53.135298],
['HBSC','Bremen-Schönebeck',8001163,8.649481,53.1728],
['HBSB','Bremen-Sebaldsbrück',8001164,8.887383,53.061355],
['HBMG','Bremen-St Magnus',8001165,8.669732,53.17158],
['HBV','Bremen-Vegesack',8001166,8.629968,53.169716],
['HBWA','Bremen-Walle',8001167,8.786241,53.103792],
['HBH','Bremerhaven Hbf',8000051,8.599555,53.534912],
['HBHL','Bremerhaven-Lehe',8001168,8.600657,53.566324],
['HBWU','Bremerhaven-Wulsdorf',8001170,8.611934,53.508596],
['ABV','Bremervörde',8007800,9.140251,53.482954],
['KBK','Brenk',8071651,7.168888,50.432442],
['XIBN','Brennero/Brenner',8300092,11.505426,47.002342],
['XIBCA','Brescia',8300048,10.212869,45.532159],
['XIBX','Bressanone/Brixen',8300076,11.649764,46.709896],
['XBBS','Bressoux',8800107,5.612648,50.644506],
['XFBRT','Brest(F)',8700434,-4.479815,48.387805],
['AAE','Brest-Aspe',8007841,9.382342,53.460587],
['UBZ','Breternitz',8011267,11.405863,50.616311],
['UBR','Bretleben',8010061,11.240839,51.340743],
['RBT','Bretten',8000053,8.693448,49.0369],
['RBTK','Bretten Kupferhälde',8070093,8.723679,49.036987],
['RBTN','Bretten Rechberg',8001138,8.701614,49.032596],
['RBTS','Bretten Schulzentrum',8001144,8.718196,49.031838],
['RBTM','Bretten Stadtmitte',8001152,8.702809,49.033993],
['RBTW','Bretten Wannenweg',8079060,8.709122,49.030466],
['RBTI','Bretten-Ruit',8001131,8.722058,49.009462],
['HBRT','Brettorf',8001176,8.44697,52.967127],
['SBRH','Bretzenheim(Nahe)',8001177,7.898692,49.874587],
['TBZ','Bretzfeld',8001178,9.440302,49.172741],
['ONBRU','Breukelen',8400133,6.3170457,52.17149],
['KBRY','Breyell',8001180,6.241174,51.294615],
['XTBD','Breziny u Decina',5400623,14.243928,50.760998],
['OTBN','Breznice',5400266,13.963942,49.558403],
['BBRI','Brieselang',8013472,13.001394,52.582549],
['BBSN','Briesen(Mark)',8011269,14.280635,52.34653],
['XSBG','Brig',8501609,7.98809158467419,46.319421007054],
['RMBK','Brigachtal Kirchdorf',8003339,8.467807,48.014343],
['RKLN','Brigachtal Klengen',8003336,8.465779,48.007366],
['ABRI','Brillit',8071333,9.013664,53.414533],
['EBRS','Brilon Stadt',8001182,8.575287,51.39906],
['EBRW','Brilon Wald',8000054,8.576073,51.349159],
['WBR','Britz',8010064,13.821106,52.873268],
['XABT','Brixen im Thale',8100366,12.2605904764796,47.4491996935856],
['XABX','Brixlegg',8100101,11.8799872390238,47.4347340161349],
['XTBRI','Brniste',5403721,14.728753,50.716591],
['XTBR','Brno hl.n.',5400001,16.6130691,49.1906045],
['XTBK','Brno-Kralovo Pole',5400210,16.596694,49.23098],
['LBRO','Brocken',8017004,10.618559,51.799558],
['HBRO','Brockhöfe',8001185,10.258499,53.002117],
['WBTF','Broderstorf',8011270,12.262763,54.078916],
['XDBN','Broens st',8600345,8.740748,55.194691],
['KBRO','Brohl',8001186,7.332639,50.481429],
['ABRS','Brokstedt',8001190,9.823806,53.990086],
['XSBRH','Bronschhofen',8506181,9.03466211602638,47.4754416432645],
['OIBRO','Bronzolo/Branzoll',8301245,11.315972,46.405122],
['XTBRT','Brtniky',5400612,14.438788,50.951596],
['FBB','Bruchenbrücken',8001196,8.788402,50.301965],
['RBRH','Bruchhausen(b Ettlingen)',8001198,8.373975,48.923992],
['FBK','Bruchköbel',8001199,8.919293,50.186189],
['SBUM','Bruchmühlbach-Miesau',8001200,7.443979,49.385343],
['HBUE','Bruchmühlen',8001201,8.448636,52.204598],
['RBR','Bruchsal',8000055,8.589649,49.124622],
['RBMT','Bruchsal Am Mantel',8001214,8.56327,49.141181],
['RBRZ','Bruchsal Bildungszentrum',8001197,8.574507,49.110346],
['RBRF','Bruchsal Schlachthof',8070009,8.609716,49.118928],
['RBRD','Bruchsal Schloßgarten',8085001,8.59406,49.131438],
['RBRP','Bruchsal Sportzentrum',8001212,8.589941,49.135443],
['RBRC','Bruchsal Stegwiesen',8085002,8.598199,49.136435],
['RBRE','Bruchsal Tunnelstraße',8070008,8.594378,49.119549],
['SBRW','Bruchweiler',8079080,7.801957,49.114704],
['XABF','Bruck-Fusch',8100047,12.8283917680309,47.2845709154397],
['XABK','Bruck/Leitha',8100198,16.780084,48.019068],
['XABM','Bruck/Mur',8100032,15.279433,47.41383],
['MBR','Bruckberg',8001203,11.997782,48.515979],
['TBRU','Brucken',8001205,9.453061,48.573918],
['MBRM','Bruckmühl',8001207,11.915269,47.880874],
['XSBRU','Brugg AG',8500309,8.20882744790919,47.4808528315537],
['XBBR','Brugge',8800029,3.21706295013428,51.1972299862631],
['XFBAH','Brumath',8700294,7.700361,48.732721],
['ONBRM','Brummen',8400136,6.3097786903381,52.091110229492],
['LBRP','Brunau-Packebusch',8011277,11.484586,52.751274],
['PIBN','Brunico Nord/Bruneck Nord',8303941,11.936731,46.800629],
['XIBB','Brunico/Bruneck',8300077,11.930009,46.794588],
['XSBNN','Brunnen(CH)',8505007,8.61004816647745,46.9991749288005],
['MBRU','Brunnen(Oberbay)',8001265,11.29911,48.629771],
['XBBNL','Brussels Airport - Zaventem',8800043,4.48302268981934,50.8985400058829],
['XBB','Bruxelles Midi',8800004,4.335695,50.835374],
['XBBL','Bruxelles-Central',8800003,4.357062,50.845496],
['XBBLX','Bruxelles-Luxembourg',8800005,4.373998,50.838808],
['XBBME','Bruxelles-Midi Eurostar',8898004,4.335317,50.835895],
['XBBN','Bruxelles-Nord',8800002,4.361458,50.860238],
['RBRN','Bräunlingen Bahnhof',8001119,8.457104,47.931875],
['RBRI','Bräunlingen Industriegebiet',8070999,8.470812,47.928337],
['TPB','Brötzingen Mitte',8004799,8.667027,48.889464],
['TPBS','Brötzingen Sandweg',8070274,8.662347,48.88588],
['TPBW','Brötzingen Wohnlichstraße',8070275,8.653987,48.882077],
['BBRK','Brück(Mark)',8011271,12.758467,52.186795],
['WBGE','Brügge(Prign)',8011273,12.229208,53.256287],
['KBR','Brühl',8001215,6.912718,50.829249],
['KKIE','Brühl-Kierberg',8003252,6.888375,50.838197],
['SBB','Bubach',8001221,6.94821,49.411024],
['KBUB','Bubenheim',8071229,6.5526,50.778015],
['NBTH','Bubenreuth',8001223,11.011994,49.629542],
['NBM','Buchbrunn-Mainstockheim',8001225,10.145179,49.763284],
['RBUO','Buchen Ost',8001226,9.332137,49.519152],
['RBUN','Buchen(Odenw)',8001227,9.327179,49.523529],
['FBNU','Buchenau(Lahn)',8001228,8.600525,50.870544],
['MBAU','Buchenau(Oberbay)',8001229,11.224497,48.160277],
['MBHA','Buchenhain',8001231,11.497442,48.031255],
['WBUH','Buchenhorst',8011281,12.712682,54.268211],
['RBU','Buchholz(Baden)',8001234,7.915166,48.083581],
['ABLZ','Buchholz(Nordheide)',8000056,9.876266,53.324683],
['BBUZ','Buchholz(Zauche)',8011282,12.922416,52.167574],
['MBU','Buchloe',8000057,10.716217,48.033723],
['XSBU','Buchs SG',8509404,9.47862968188534,47.1684089961917],
['BBUW','Buckow(Beeskow)',8011284,14.169507,52.188179],
['XUBN','Bucuresti Nord Gara A',5300007,26.074412,44.44677],
['XMBF','Budapest-Ferencváros',5500133,19.090791,47.468985],
['XMBL','Budapest-Kelenföld',5500008,19.020456,47.464355],
['XMBK','Budapest-Keleti',5500003,19.085071,47.500383],
['XMBN','Budapest-Nyugati',5500728,19.057466,47.510706],
['WBHN','Buddenhagen',8011286,13.68228,54.001561],
['FBUD','Budenheim',8001237,8.174062,50.026835],
['UBF','Bufleben',8010067,10.709057,50.997681],
['RBGG','Buggingen',8001262,7.628161,47.855254],
['KBUH','Buir',8001264,6.574514,50.862401],
['XNBP','Buitenpost',8400139,6.2962148,53.2564547],
['OTBUJ','Bujanov',5400646,14.43237,48.70201],
['EBUD','Buldern',8001266,7.370479,51.863054],
['SBY','Bullay(DB)',8001267,7.134584,50.05446],
['XFBG','Bully-Grenay',8700334,2.733171,50.448312],
['ONBU','Bunde',8400140,6.2775001525879,50.896945953369],
['SBTR','Bundenthal-Rumbach',8079087,7.806152,49.102353],
['ONBUK','Bunnik',8400141,6.2598521,52.063056945801],
['SSHI','Burbach Mitte',8001302,6.944932,49.243611],
['EBUR','Burbach(Kr Siegen)',8001268,8.077808,50.748965],
['WBSG','Burg Stargard(Meckl)',8011293,13.303225,53.49959],
['FBUN','Burg(Dillkr) Nord',8001271,8.307686,50.699884],
['ABR','Burg(Dithm)',8001273,9.250087,54.007967],
['LBU','Burg(Magdeburg)',8011294,11.840356,52.274406],
['FBNG','Burg-u. Nieder Gemünden',8000061,9.047604,50.691113],
['MBGU','Burgau(Schwab)',8001276,10.427012,48.424797],
['NBUM','Burgbernheim',8001277,10.320221,49.454322],
['NBUW','Burgbernheim-Wildbad',8001278,10.312317,49.443294],
['HBGD','Burgdorf',8001279,10.002837,52.448708],
['FBUH','Burghaun(Hünfeld)',8001283,9.727953,50.70055],
['MBUH','Burghausen',8001284,12.828182,48.1742],
['MBGH','Burgheim',8001285,11.026984,48.70105],
['FBGH','Burgholzhausen v d H',8001287,8.677106,50.257793],
['LBGK','Burgkemnitz',8011296,12.407167,51.688818],
['MBGK','Burgkirchen',8001288,12.727783,48.166908],
['NBK','Burgkunstadt',8001289,11.242723,50.137657],
['NBUR','Burglauer',8001290,10.184441,50.27434],
['NBN','Burgsinn',8001293,9.656067,50.150317],
['TBU','Burgstall(Murr)',8001296,9.369932,48.928647],
['DBU','Burgstädt',8011297,12.812707,50.915817],
['NBUT','Burgthann',8001297,11.309307,49.342474],
['TBUW','Burgweiler',8001281,9.343805,47.922765],
['HBUR','Burhafe(Ostfriesl)',8001301,7.711074,53.606557],
['DBWD','Burkhardswalde-Maxen',8011298,13.83884,50.925402],
['DBUF','Burkhardtsdorf',8011299,12.932137,50.733196],
['DBUM','Burkhardtsdorf Mitte',8011303,12.916276,50.732937],
['RBBN','Burkheim-Bischoffingen',8007289,7.611766,48.104006],
['TBLD','Burladingen',8007226,9.113057,48.290055],
['TBLW','Burladingen West',8070022,9.099292,48.292271],
['DBUS','Buschmühle',8011301,13.690003,50.826511],
['LBOW','Buschow',8011302,12.628996,52.592203],
['RBUS','Busenbach',8007000,8.450563,48.929311],
['SBNS','Busenberg-Schindhard',8079118,7.799703,49.138868],
['XFBS','Busigny',8700016,3.445515,50.038882],
['XSBUS','Bussnang',8506190,9.08414102197904,47.5560796135436],
['ONBUZ','Bussum Zuid',8400145,6.25861120224,52.26583480835],
['XIBU','Busto Arsizio',8300043,8.864848,45.616124],
['PIBAN','Busto Arsizio Nord',8303051,8.851399,45.606161],
['NBT','Buttenheim',8001310,11.013494,49.799667],
['UBU','Buttstädt',8011304,11.418412,51.126995],
['FBZ','Butzbach',8001312,8.669517,50.431156],
['ABX','Buxtehude',8001315,9.688314,53.470491],
['XPBY','Bydgoszcz Glowna',5100005,17.991637,53.135113],
['XSBAE','Bäch',8503208,8.72716324607716,47.2009791623194],
['DBJ','Bärenhecke-Johnsbach',8011091,13.772021,50.827163],
['BBKL','Bärenklau',8011093,13.143526,52.704043],
['DBS','Bärenstein(Annaberg)',8011094,13.029941,50.507603],
['DBAG','Bärenstein(b Glashütte, Sachs)',8011095,13.794728,50.809728],
['DBAE','Bärnsdorf',8011096,13.72074,51.166767],
['MBHM','Bäumenheim',8000778,10.809972,48.680333],
['TBB','Böbingen(Rems)',8005979,9.912807,48.822439],
['TBO','Böblingen',8001055,9.004128,48.687758],
['TBO T','Böblingen Danziger Str',8085005,8.997785,48.678783],
['TBO H','Böblingen Heusteigstr',8085007,9.025771,48.675633],
['TBOS','Böblingen Südbf',8085006,9.010509,48.677236],
['TBO Z','Böblingen Zimmerschlag',8085008,9.035015,48.670783],
['NBOB','Böbrach',8070667,13.014504,49.052994],
['TBCS','Böckingen Sonnenbrunnen',8070159,9.191198,49.140655],
['TBCW','Böckingen West',8070158,9.166093,49.139319],
['XABS','Böckstein',8100094,13.131944721097,47.0796938202219],
['RBGH','Bödigheim',8001056,9.317207,49.475929],
['XABC','Böheimkirchen',8100661,15.7538593714566,48.1999922539804],
['RBOE','Böhl-Iggelheim',8001057,8.303602,49.379831],
['LBWE','Böhlen Werke',8011222,12.384024,51.184702],
['LBO','Böhlen(Leipzig)',8013471,12.381991,51.203037],
['NBHF','Böhmhof',8001058,13.11088,49.052101],
['RBER','Böhringen-Rickelshausen',8001059,8.926651,47.748732],
['WBOE','Bölzke',8011225,12.269615,53.107382],
['EBEO','Bönen',8001061,7.757296,51.598015],
['ENOB','Bönen-Nordbögge',8004448,7.7422,51.615709],
['ABNS','Bönningstedt',8007047,9.910243,53.663395],
['LBOK','Börnecke(Harz)',8011226,10.995759,51.81968],
['HBSM','Börßum',8001063,10.568935,52.060463],
['LBOE','Bösdorf(Sachs-Anh)',8011228,11.064149,52.422099],
['EBSP','Bösperde',8001066,7.774233,51.45894],
['RBTZ','Bötzingen',8007296,7.721616,48.070174],
['RBTU','Bötzingen Mühle',8007297,7.727931,48.075552],
['SBN','Bübingen',8001238,7.03493355,49.17974283],
['ABCH','Büchen',8000058,10.623298,53.474972],
['NBUE','Büchenbach',8001242,11.074034,49.267744],
['FBDH','Büches-Düdelsheim',8001244,9.066751,50.29737],
['PQSBC','Büchig, Stutensee',721230,8.461102,49.047961],
['HBKB','Bückeburg',8001245,9.047796,52.267637],
['FBDG','Büdingen(Oberhess)',8001250,9.102598,50.28887],
['FBDW','Büdingen(Westerw)',8001249,7.895901,50.624747],
['RBUE','Bühl(Baden)',8001252,8.129299,48.696676],
['XSBH','Bülach',8503400,8.53618858987507,47.523941300811],
['LBZG','Bülzig',8011290,12.752715,51.894894],
['HBDE','Bünde(Westf)',8000059,8.573876,52.202075],
['FBRG','Bürgeln',8001256,8.817194,50.85375],
['FHLI','Bürgerhaus, Hessisch Lichtenau',711731,9.716054,51.195694],
['XSBGL','Bürglen',8506106,9.14985544324719,47.5491005106668],
['FBUE','Bürstadt',8000360,8.459072,49.645125],
['ABUS','Büsenbachtal',8001258,9.858592,53.269595],
['ABSM','Büsum',8001259,8.867113,54.133822],
['KBUT','Büttgen',8001261,6.605785,51.197208],
['WB','Bützow',8010066,11.998194,53.837114],
['XSCZ','Cadenazzo',8505404,8.94168850731561,46.1526250435801],
['ACD','Cadenberge',8001316,9.058163,53.768071],
['NCA','Cadolzburg',8001317,10.863611,49.460649],
['OFCGM','Cagnes-sur-Mer',8700480,7.148384,43.657758],
['DCDF','Cainsdorf',8011305,12.496565,50.686559],
['XFCK','Calais Ville',8700386,1.850179,50.953402],
['XFFE','Calais-Fréthun',8701132,1.811446,50.901549],
['BC','Calau(Nl)',8010069,13.97982,51.738118],
['LCBO','Calbe(Saale) Ost',8010070,11.810527,51.920693],
['LCBS','Calbe(Saale) Stadt',8011323,11.776342,51.913879],
['LCBW','Calbe(Saale) West',8010071,11.758783,51.905693],
['HCAL','Calberlah',8001318,10.624914,52.427559],
['FCLD','Caldern',8001319,8.670244,50.85297],
['TCA','Calmbach Bahnhof',8001320,8.571132,48.776481],
['TCAS','Calmbach Süd',8070280,8.566424,48.773396],
['TCW','Calw',8000063,8.741854,48.714682],
['UCB','Camburg(Saale)',8013474,11.70468,51.050857],
['WCA','Cammin(Meckl)',8011307,13.299645,53.439035],
['OICLE','Camnago-Lentate',8301367,9.133292,45.6662],
['XICTF','Campo di Trens/Freienfeld',8300534,11.488458,46.869077],
['XFCA','Cannes',8700144,7.020325,43.554197],
['XFCB','Cannes-la-Bocca',8700911,6.986729,43.548674],
['PICAG','Cantello Gaggiolo',8301206,8.90742,45.837831],
['OICCE','Cantu-Cermenate',8301310,9.098369,45.71342],
['OFCMR','Cap-Martin-Roquebrun',8700484,7.457226,43.760567],
['OFCAP','Cap-dAil',8700829,7.39432,43.720529],
['ONCS','Capelle Schollevaar',8400147,6.2211112976074,51.954166412354],
['ECP','Capelle(Westf)',8001323,7.61108,51.735268],
['XLCP','Capellen',8270270,5.982577,49.638474],
['XSCR','Capolago-Riva S. Vitale',8505304,8.97889335734244,45.9028465134857],
['BSIS','Caputh Schwielowsee',8012957,12.980368,52.340976],
['BCAP','Caputh-Geltow',8011308,12.984406,52.350295],
['XFCAB','Carbonne(Boussens)',8700840,1.212526,43.298402],
['XFCN','Carcassonne',8700100,2.351797,43.218189],
['XICAR','Carimate',8301155,9.107547,45.69446],
['OFCAR','Carnoles',8700830,7.481551,43.761961],
['XFCNO','Carnoules(Toulon)',8700915,6.186247,43.297446],
['WCW','Casekow',8011311,14.208187,53.213614],
['XICB','Casteldarne/Ehrenburg',8300401,11.844067,46.79761],
['XFCAN','Castelnaudary',8700549,1.950079,43.31205],
['XSCA','Castione-Arbedo',8505212,9.04139950613477,46.2252573555483],
['ONCC','Castricum',8400151,6.2144446372986,52.545833587646],
['ECA','Castrop-Rauxel Hbf',8001327,7.30398,51.573526],
['ECAS','Castrop-Rauxel Süd',8001328,7.310186,51.5503],
['ECME','Castrop-Rauxel-Merklinde',8001329,7.324314,51.527932],
['XFCAV','Cavaillon(Avignon)',8700888,5.043872,43.834753],
['OJCJ','Celje',7900005,15.26798,46.228556],
['HC','Celle',8000064,10.062706,52.621175],
['XLCS','Cents-Hamm',8270280,6.164679,49.614622],
['XFCE','Cerbère',8700147,3.163183,42.44166],
['XTCKA','Ceska Kamenice',5400271,14.414167,50.795882],
['XTC','Ceska Kubice',5400123,12.865142,49.374558],
['XTCLH','Ceska Lipa - Holy vrch',5400064,14.522784,50.682369],
['XTCL','Ceska Lipa hl.n.',5400045,14.533836,50.675179],
['XTCLS','Ceska Lipa strelnice',5400746,14.533174,50.691735],
['XTCB','Ceske Budejovice',5400017,14.488751,48.974613],
['OTCBZ','Ceske Budejovice jiz.z.',5400750,14.475366,48.959245],
['XTCV','Ceske Velenice',5400018,14.957627,48.769327],
['XFCS','Chalon sur Saône',8700091,4.843393,46.781739],
['XFCM','Chalons en Champagne',8700002,4.348892,48.95541],
['XPCP','Chalupki',5100708,18.311557,49.925477],
['NCH','Cham(Oberpf)',8001330,12.656832,49.221869],
['XFCY','Chambery-Challes-E',8700055,5.919756,45.571498],
['NCHA','Chamerau',8001331,12.745258,49.196718],
['XFCG','Champigneulles',8700335,6.169383,48.734927],
['XBCH','Charleroi Sud',8800024,4.438774,50.404422],
['XFCT','Chateau-Thierry',8700261,3.412808,49.037508],
['XFCH','Chauny(Tergnier)',8700336,3.224129,49.611137],
['XTCH','Cheb',5400004,12.380697,50.073492],
['XTCS','Cheb-Skalka',5475036,12.348341,50.073979],
['XFCSG','Chelles Gournay',8703085,2.582711,48.874156],
['DCACC','Chemnitz Alt Chemnitz Center',8017400,12.917936,50.796374],
['DCAN','Chemnitz Annenstraße',8071804,12.922933,50.828749],
['DCANB','Chemnitz Bernsbachplatz',8017475,12.9269,50.825004],
['DC  E','Chemnitz Brückenstraße/Freie Presse',8017476,12.924702,50.834752],
['DCACE','Chemnitz Erdmannsdorfer Straße',8017402,12.911969,50.811211],
['DCE','Chemnitz Erfenschlag',8011975,12.950184,50.787603],
['DC  F','Chemnitz Friedrichstraße',8071174,12.919367,50.772853],
['DCS G','Chemnitz Gustav-Freytag-Straße',8017403,12.920266,50.825596],
['DC','Chemnitz Hbf',8010184,12.930877,50.839696],
['DC  O','Chemnitz Hbf (Bahnhofstraße)',8071738,12.929189,50.838222],
['DCKI','Chemnitz Kinderwaldstätte',8011970,12.953568,50.884211],
['DKW','Chemnitz Küchwald',8017050,12.9129849,50.8547514],
['DCM','Chemnitz Mitte',8011971,12.912587,50.826628],
['DC  M','Chemnitz Moritzhof',8017407,12.919931,50.82976],
['DCOM','Chemnitz Omnibusbahnhof',8089295,12.926391,50.840829],
['DCHAR','Chemnitz Riemenschneiderstraße',8017401,12.925472,50.785384],
['DCANR','Chemnitz Rosenbergstraße',8017480,12.929305,50.817897],
['DC  R','Chemnitz Roter Turm',8017410,12.923074,50.834509],
['DCACR','Chemnitz Rösslerstraße',8017409,12.91412,50.816885],
['DCACS','Chemnitz Scheffelstraße',8017411,12.911337,50.802279],
['DCZWS','Chemnitz Schneeberger Straße',8017413,12.922445,50.794034],
['DCACA','Chemnitz Schule Altchemnitz',8017414,12.913104,50.798923],
['DCANS','Chemnitz Stadlerplatz',8017478,12.927087,50.821175],
['DCD','Chemnitz Süd',8010185,12.926823,50.823746],
['DCANH','Chemnitz TU Campus',8017479,12.930901,50.8137],
['DCANT','Chemnitz Technopark',8017481,12.924603,50.811498],
['DC  T','Chemnitz Theaterplatz',8017416,12.925727,50.837311],
['DCACT','Chemnitz Treffurthstraße',8017417,12.915588,50.819826],
['DCACU','Chemnitz Uhlestraße',8017418,12.911852,50.806071],
['DC  Z','Chemnitz Zentralhaltestelle',8017419,12.922264,50.831627],
['DCAC','Chemnitz-Altchemnitz',8017420,12.926068,50.790804],
['DCBH','Chemnitz-Borna Hp',8011974,12.894459,50.859867],
['DCEO','Chemnitz-Erfenschlag Ost',8071827,12.963955,50.784046],
['DCHA','Chemnitz-Harthau',8011977,12.924049,50.776866],
['DCHP','Chemnitz-Hilbersdorf',8013450,12.953879,50.861934],
['DCRE','Chemnitz-Reichenhain',8011978,12.935877,50.795077],
['DCC','Chemnitz-Schönau',8011979,12.8765,50.818095],
['DCSI','Chemnitz-Siegmar',8011980,12.84251,50.815561],
['XFCGG','Chenay Gagny',8703089,2.553153,48.877135],
['XBCE','Chenee',8800264,5.616433,50.60792],
['XFCHB','Cherbourg',8700227,-1.621044,49.633304],
['XSCH','Chiasso',8505307,9.03144057628565,45.8321788009196],
['XICK','Chiusa/Klausen',8300078,11.572647,46.642572],
['OTCCD','Chlumcany u Dobran',5400263,13.292448,49.623332],
['XTCO','Chomutov',5400005,13.399315,50.45691],
['XTCM','Chomutov mesto',5401259,13.413844,50.469946],
['OTCTE','Choratice',5401260,14.186246,50.723648],
['WCOK','Chorin',8011314,13.869714,52.90354],
['OTCHJ','Chotejovice',5401265,13.784518,50.57546],
['XTCY','Chotyne',5401276,14.87153,50.837601],
['XTCR','Chrastava',5401284,14.952283,50.81317],
['XTCA','Chrastava-Andelska Hora',5401285,14.957803,50.796781],
['XTCHR','Chribska',5401299,14.523655,50.867793],
['XSC','Chur',8509000,9.52892561960782,46.8530797552397],
['XFCD','Château du Loir',8700210,0.415007,47.683073],
['XFCAR','Château-Arnoux-St-Auban',8700156,5.997338,44.061495],
['XFCX','Châteauroux',8700181,1.699911,46.809409],
['XBCL','Châtelet',8800045,4.52054,50.409555],
['OTCC','Cicenice',5400048,14.220917,49.153565],
['OPCIE','Ciechanowice',5100732,15.98318,50.864679],
['OTCL','Cimelice',5400289,14.076676,49.470282],
['XFCIG','Cintegabelle',8703107,1.520423,43.305419],
['OTCZA','Cizova',5400769,14.097864,49.353602],
['ECOH','Clarholz',8001335,8.200835,51.898454],
['DCL','Clausnitz',8011315,13.4986,50.755842],
['XFCLE','Clermont-Ferrand',8700038,3.101019,45.778674],
['XFCL','Clerval',8700087,6.492054,47.396654],
['XLCV','Clervaux',8200134,6.02484,50.061242],
['HCLP','Cloppenburg',8001337,8.055763,52.843996],
['NC','Coburg',8001338,10.95737,50.263097],
['NCN','Coburg Nord',8001334,10.964825,50.2716],
['NCBD','Coburg-Beiersdorf',8001333,10.9297,50.2867],
['NCNS','Coburg-Neuses',8001339,10.951361,50.278082],
['SCOC','Cochem(Mosel)',8001340,7.166738,50.153092],
['ECFS','Coesfeld Schulzentrum',8001343,7.165836,51.951269],
['ECMF','Coesfeld(Westf)',8000066,7.16388,51.939431],
['XNCV','Coevorden',8400153,6.1975002288818,52.663612365723],
['XICIG','Colle Isarco/Gossensass',8300091,11.441378,46.938011],
['NRF','Collenberg',8005028,9.329719,49.771121],
['XFCLL','Collioure',8700486,3.078081,42.526909],
['XFC','Colmar',8700178,7.346546,48.072474],
['OIGNA','Colmegna',8301581,8.752086,46.024743],
['XFCQ','Combs la Ville Quincy',8703137,2.547481,48.66829],
['XIC','Como S. Giovanni',8300056,9.072714,45.808971],
['XFCP','Compiegne',8700246,2.823454,49.422147],
['XICGL','Conegliano',8300086,12.299103,45.884664],
['XFCF','Conflans-Jarny',8700277,5.868115,49.166483],
['SCN','Contwig',8001341,7.427916,49.24528],
['XBC','Coo',8800175,5.880806,50.390732],
['HCOP','Coppenbrügge',8001342,9.537588,52.119521],
['XFCOM','Corbehem(Douai)',8700837,3.040721,50.34323],
['XFCOE','Corbeil Essonnes',8703150,2.473671,48.6142],
['XSCO','Cornaux',8504223,7.02336373279708,47.0385599223159],
['BCO','Coschen',8011319,14.718167,52.019844],
['XFCOS','Cosne',8703161,2.931687,47.415151],
['DCB','Cossebaude',8011320,13.631582,51.085143],
['XSCS','Cossonay-Penthalaz',8501115,6.52368303530211,46.6060023578676],
['LCW','Coswig(Anh)',8011322,12.457625,51.888002],
['DCW','Coswig(b Dresden)',8010072,13.579414,51.12281],
['BCS','Cottbus Hbf',8010073,14.324162,51.750957],
['BMZD','Cottbus-Merzdorf',8012341,14.366669,51.76891],
['BCSO','Cottbus-Sandow',8011318,14.353704,51.755177],
['BWDF','Cottbus-Willmersdorf Nord',8081688,14.376902,51.806736],
['XFCOL','Coulommiers',8703169,3.082044,48.807702],
['XFCSN','Courcelles-sur-Nied',8700962,6.310629,49.063401],
['XFCOU','Coutras',8700184,-0.131329,45.036568],
['TC','Crailsheim',8000067,10.064326,49.137872],
['DCR','Cranzahl',8010074,12.993028,50.511248],
['NCR','Creidlitz',8001347,10.982246,50.227174],
['XFCR','Creil',8700072,2.468704,49.263881],
['NCRE','Creußen(Oberfr)',8001348,11.628443,49.84947],
['DCU','Crimmitschau',8011325,12.392986,50.815068],
['WCZ','Crivitz',8011326,11.645071,53.572518],
['OFCXW','Croix-Wasquehal',8700512,3.137766,50.678522],
['OFCDC','Cros-de-Cagnes',8700847,7.167082,43.660517],
['UKSO','Crossen Ort',8011312,11.9819,50.974715],
['UKS','Crossen a d Elster',8010196,11.984064,50.96573],
['OMCSK','Csakanydoroszlo',5500368,16.500159,46.978481],
['OMCS','Csorna',5500030,17.248592,47.601712],
['OICUC','Cucciago',8301456,9.083456,45.738311],
['ONCK','Cuijk',8400155,6.1941666603088,51.726682587905],
['ONCU','Culemborg',8400154,6.1727776527405,51.946666717529],
['XFCU','Culmont-Chalindrey',8700008,5.443168,47.809959],
['XFCZ','Culoz',8700039,5.778927,45.842945],
['XICUN','Cuneo',8300016,7.535955,44.387897],
['DCN','Cunnertswalde',8011331,13.705502,51.162366],
['UCF','Cursdorf',8011332,11.132022,50.571871],
['XUCU','Curtici',5300001,21.2977,46.341013],
['ACV','Cuxhaven',8001352,8.703431,53.8609],
['XPCW','Czerwiensk',5100096,15.412466,52.015088],
['FCOE','Cölbe',8000065,8.787365,50.848159],
['EDAD','Daaden',8007077,7.963642,50.740469],
['ONDA','Daarlerveen',8400164,6.1605553627014,52.4407702],
['BDAB','Dabendorf',8011334,13.43729,52.237332],
['MDA','Dachau Bahnhof',8001354,11.44426,48.254652],
['MDAS','Dachau Stadt',8001355,11.439761,48.266661],
['UDA','Dachrieden',8011335,10.443166,51.269187],
['XSDA','Dachsen',8506049,8.6137970588401,47.6670843790544],
['UDW','Dachwig',8011336,10.849686,51.072436],
['ADBK','Dagebüll Kirche',8077770,8.729485,54.730283],
['ADM','Dagebüll Mole',8007769,8.690989,54.729909],
['XSDS','Dagmersellen',8502004,7.97901545048938,47.2175519871912],
['EDHL','Dahl',8001357,7.527898,51.303377],
['EDAB','Dahlbruch',8001358,8.053456,50.970432],
['KDAM','Dahlem(Eifel)',8001359,6.550382,50.385752],
['LDA','Dahlen(Sachs)',8011339,12.984253,51.350972],
['ADL','Dahlenburg',8001360,10.708804,53.169266],
['EDAK','Dahlerbrück',8001362,7.517001,51.25186],
['BDT','Dahlewitz',8011340,13.419579,52.326618],
['SDA','Dahn',8079085,7.771283,49.154556],
['SDAS','Dahn Süd',8079081,7.777208,49.148557],
['ONDAL','Dalen(NL)',8400161,6.1550002098083,52.69416809082],
['OND','Dalfsen',8400167,6.1469445228577,52.498332977295],
['KDAL','Dalheim',8001365,6.178209,51.149008],
['RDL','Dallau',8001366,9.18755,49.388078],
['BDL','Dallgow-Döberitz',8080260,13.059037,52.543554],
['LDBK','Dambeck(Altm)',8011342,11.165822,52.80128],
['RKDS','Dammerstock, Karlsruhe',723864,8.403732,48.984199],
['ADB','Dannenberg Ost',8001372,11.117734,53.104997],
['WDWE','Dannenwalde(Gransee)',8011344,13.180801,53.079756],
['MDAR','Darching',8001373,11.777757,47.870651],
['LDAR','Darlingerode',8011346,10.733037,51.84908],
['FD','Darmstadt Hbf',8000068,8.629636,49.872503],
['FDN','Darmstadt Nord',8001375,8.654311,49.892136],
['FDO','Darmstadt Ost',8001376,8.673867,49.874743],
['FDS','Darmstadt Süd',8001377,8.636586,49.855426],
['FDAL','Darmstadt TU-Lichtwiese',8001386,8.687527,49.861045],
['FDA','Darmstadt-Arheilgen',8001378,8.645343,49.913014],
['FDE','Darmstadt-Eberstadt',8001379,8.62582,49.813922],
['FDK','Darmstadt-Kranichstein',8001380,8.679359,49.906826],
['FWX','Darmstadt-Wixhausen',8006528,8.647751,49.930248],
['MDAG','Dasing',8001382,11.052165,48.386243],
['KDAT','Dattenfeld(Sieg)',8001384,7.546252,50.80916],
['ADH','Dauenhof',8001387,9.680659,53.852459],
['SDF','Daufenbach',8001388,6.639911,49.875969],
['FDSU','Dausenau',8001389,7.758212,50.326866],
['EDVB','Davensberg',8001390,7.598146,51.817943],
['XSDD','Davos Dorf',8509072,9.84211236596082,46.8097194337804],
['XSDP','Davos Platz',8509073,9.8207256615341,46.7914664266423],
['XFDX','Dax',8700043,-1.049915,43.720894],
['PQKDC','Daxlanden Dornröschenweg, Karlsruhe',371406,8.335364,48.99283],
['PQKDK','Daxlanden Karl-Delisle-Straße, Karlsruhe',720569,8.338135,48.996105],
['PQKDN','Daxlanden Nussbaumweg, Karlsruhe',720572,8.332747,48.988853],
['PQKDX','Daxlanden Thomas-Mann-Straße, Karlsruhe',370204,8.341087,48.998837],
['ONDVI','De Vink',8400188,6.1446496,52.147220611572],
['XPDB','Debica',5100228,21.405563,50.054419],
['XMD','Debrecen',5500058,21.628789,47.519629],
['XTD','Decin hl.n.',5400003,14.201247,50.773415],
['XTDV','Decin vychod',5400783,14.222817,50.775435],
['XTDC','Decin-Certova voda',5400786,14.221622,50.816661],
['XTDPR','Decin-Priper',5400789,14.209291,50.785013],
['XTDP','Decin-Prostredni Zleb',5400788,14.23002,50.792958],
['HDEH','Dedenhausen',8001392,10.23873,52.432215],
['HDED','Dedensen-Gümmer',8001393,9.521252,52.407049],
['EDED','Dedinghausen',8001394,8.398281,51.672359],
['ADZB','Deezbüll',8079022,8.818274,54.77697],
['NDG','Deggendorf Hbf',8001397,12.949727,48.83944],
['RDM','Deidesheim',8001399,8.192634,49.408349],
['NDE','Deining(Oberpf)',8001400,11.515572,49.203996],
['ADS','Deinste',8070349,9.442568,53.5319],
['ONDM','Deinum',8400168,6.14253,53.1888115],
['MDS','Deisenhofen',8001404,11.583597,48.019539],
['TDLM','Deißlingen Mitte',8001405,8.611586,48.108374],
['XNDD','Delden',8400169,6.1405553817749,52.259998321533],
['XNDT','Delft',8400170,4.356901,52.005752],
['ONDTZ','Delft Campus',8400166,4.364721,51.99083],
['XNDZ','Delfzijl',8400171,6.1130557060242,53.3336625],
['ONDZW','Delfzijl West',8400175,6.1030554771423,53.3320834],
['LDLO','Delitzsch ob Bf',8080280,12.34639,51.519703],
['LDL','Delitzsch unt Bf',8010076,12.345218,51.525227],
['SDE','Dellfeld',8001406,7.469169,49.227782],
['SDEO','Dellfeld Ort',8001407,7.478162,49.238869],
['HD','Delmenhorst',8000070,8.629758,53.052792],
['HHPD','Delmenhorst Hasporter Damm',8070426,8.645525,53.038599],
['XSDE','Delémont',8500109,7.35005384247943,47.3620006555152],
['DDT','Demitz-Thumitz',8011354,14.240902,51.141837],
['LDK','Demker',8011355,11.854733,52.518178],
['WDM','Demmin',8011356,13.053954,53.90114],
['ONDD','Den Dolder',8400179,6.0986108779907,52.140277862549],
['XNDH','Den Haag Centraal',8400282,4.325241,52.080318],
['XNDHH','Den Haag HS',8400280,4.32267,52.069584],
['ONDHL','Den Haag Laan van Nieuw Oost Indie',8400380,4.343444,52.079059],
['ONDHM','Den Haag Mariahoeve',8400278,4.368973,52.090529],
['ONHAM','Den Haag Moerwijk',8400279,4.308548,52.053862],
['PNAAO','Den Haag Ypenburg',8400030,4.391338,52.055606],
['XNDL','Den Helder',8400311,6.0574998855591,52.955276489258],
['ONDLZ','Den Helder Zuid',8400303,6.05146,52.932498931885],
['XBDL','Denderleeuw',8800050,4.071376,50.891494],
['SDBO','Densborn',8001414,6.600406,50.123918],
['RDZ','Denzlingen',8001415,7.881434,48.068625],
['KDEA','Dernau',8001417,7.041527,50.529648],
['KDEB','Dernbach(Westerw)',8001418,7.783693,50.457225],
['HDBG','Derneburg(Han)',8000071,10.143719,52.096851],
['XTDS','Desenice',5400800,13.174638,49.277667],
['XIDS','Desenzano del Garda/Sirmione',8300106,10.536275,45.462667],
['XIDE','Desio',8300608,9.217917,45.617834],
['LDAD','Dessau Adria',8011362,12.314419,51.821189],
['LD','Dessau Hbf',8010077,12.234945,51.839865],
['LDS','Dessau Süd',8011361,12.236455,51.802196],
['LDAL','Dessau-Alten',8011363,12.19334,51.825541],
['LDMO','Dessau-Mosigkau',8011364,12.148546,51.814077],
['LDWA','Dessau-Waldersee',8070259,12.270566,51.836564],
['EDTM','Detmold',8001420,8.872859,51.940745],
['NDEB','Dettelbach Bahnhof',8001421,10.090359,49.788146],
['TDH','Dettenhausen',8085015,9.093437,48.606705],
['TDTUF','Dettingen Freibad',8001424,9.351257,48.523174],
['TDTUG','Dettingen Gsaidt',8001426,9.35804,48.514061],
['TDTUL','Dettingen Lehen',8001422,9.336896,48.529216],
['FDET','Dettingen(Main)',8001427,9.036807,50.042556],
['TDT','Dettingen(Teck)',8001428,9.454878,48.616409],
['TDTU','Dettingen-Mitte',8070679,9.34463,48.527817],
['HDEM','Dettum',8001429,10.660757,52.156721],
['XFDEE','Dettwiller',8701044,7.464995,48.75195],
['LDB','Deuben(Zeitz)',8010078,12.068913,51.11053],
['NDN','Deuerling',8001430,11.914918,49.04164],
['ONDEU','Deurne',8400172,5.78792,51.456098],
['EDEU','Deuten',8001432,6.97079,51.713087],
['OADEW','Deutsch Wagram',8100721,16.563605,48.302942],
['LDTZ','Deutzen',8011371,12.419542,51.11443],
['XUD','Deva',5300073,22.9102492,45.8842727],
['XNDV','Deventer',8400173,6.0422220230103,52.257499694824],
['ONDVC','Deventer Colmschate',8400185,6.03463,52.2502784729],
['XYDN','Devinska Nova Ves',5600193,16.975801,48.218961],
['ONDI','Didam',8400174,6.03228,51.933502],
['NDIE','Diebach',8001435,9.83766,50.128683],
['FDI','Dieburg',8000362,8.839795,49.90369],
['RBTD','Diedelsheim',8070012,8.674472,49.039347],
['MDID','Diedorf(Schwab)',8001439,10.776823,48.35609],
['ONDIM','Diemen',8400165,6.0314,52.34515],
['ONDIZ','Diemen Zuid',8400163,6.02578,52.330276489258],
['XFDM','Diemeringen',8700304,7.184837,48.940615],
['FDHM','Dienheim',8001448,8.35714,49.841354],
['XBDBK','Diepenbeek',8800240,5.420378,50.910506],
['HDIP','Diepholz',8001443,8.380334,52.604771],
['ONDIR','Dieren',8400176,6.019166469574,52.044998168945],
['LDI','Dieskau',8011376,12.052167,51.450325],
['XSDH','Diessenhofen',8503428,8.7522798034753,47.6854695763978],
['XSDHS','Diessenhofen URh',8506152,8.74885906156379,47.6904192083997],
['NDT','Dietersheim',8001450,10.543103,49.556882],
['XSD','Dietlikon',8503306,8.61925589066777,47.4201947418021],
['MDRD','Dietmannsried',8001454,10.290481,47.812866],
['RDB','Dietzelbach',8007335,7.763382,47.859373],
['FDZ','Dietzenbach Bahnhof',8001456,8.785541,50.008064],
['FDZM','Dietzenbach Mitte',8001455,8.78899,50.017246],
['FDZS','Dietzenbach-Steinberg',8001459,8.792627,50.02524],
['UDN','Dietzhausen',8011378,10.5969,50.599437],
['XFDI','Dieulouard',8700340,6.071842,48.843559],
['FDIZ','Diez',8001457,8.01962,50.370127],
['FDIO','Diez Ost',8001458,8.038587,50.376044],
['MDIN','Dießen',8001447,11.10754,47.950818],
['OLDI','Differdange',8200920,5.891955,49.528329],
['XFDN','Dijon Porte Neuve',8700429,5.055185,47.322782],
['XFD','Dijon Ville',8700021,5.026128,47.322913],
['FDBT','Dillbrecht',8001460,8.20377,50.801821],
['FDIL','Dillenburg',8000074,8.294088,50.734883],
['MDIL','Dillingen(Donau)',8001463,10.489167,48.581255],
['SDL','Dillingen(Saar)',8000075,6.72215,49.35271],
['MDIF','Dingolfing',8001466,12.48687,48.641606],
['MDKB','Dinkelsbühl Bf',8070352,10.328856,49.068851],
['MDKS','Dinkelscherben',8001468,10.586675,48.342638],
['EDIN','Dinslaken',8001469,6.73803,51.567458],
['XLDR','Dippach-Reckange',8270340,5.995891,49.572487],
['DDP','Dippoldiswalde',8011382,13.664603,50.891093],
['SDIR','Dirmingen',8001470,7.012377,49.415386],
['HDBR','Dissen-Bad Rothenfelde',8001471,8.185298,52.11192],
['TDIH','Distelhausen',8001472,9.683508,49.598233],
['LDT','Ditfurt',8011383,11.186728,51.833482],
['DDIF','Dittersbach',8011385,13.068842,50.926837],
['DDF','Dittersdorf',8011386,12.978615,50.75139],
['TDM','Dittigheim',8001474,9.674912,49.607964],
['TDI','Ditzingen',8001476,9.06705,48.823611],
['XIDT','Dobbiaco/Toblach',8300104,12.22551,46.724851],
['BDKO','Doberlug-Kirchhain',8010079,13.564241,51.620576],
['LDOB','Doberschütz',8011387,12.745785,51.492237],
['OTDOB','Dobkovice',5400820,14.191405,50.71598],
['XZD','Dobova',7900017,15.6551776,45.8983913],
['OTDY','Dobrany',5400211,13.303451,49.656547],
['LDF','Dodendorf',8011388,11.613086,52.048952],
['AKTKD','Dodenhof',8007148,9.939692,53.844409],
['XDDS','Doestrup(Soenderjylland) st',8600416,8.807864,55.117485],
['ONDO','Doetinchem',8400177,6.0147223472595,51.9585962],
['ONDOH','Doetinchem De Huet',8400184,6.0141777992248,51.9591413],
['RDRN','Dogern',8001491,8.167356,47.608887],
['DDO','Dohna(Sachs)',8011398,13.855565,50.961188],
['XTDK','Doksy',5400252,14.647238,50.573445],
['XFDO','Dole Ville',8700116,5.488103,47.096335],
['XBDG','Dolhain-Gileppe',8800269,5.936494,50.616244],
['HDOG','Dollbergen',8001492,10.181657,52.417153],
['ADR','Dollern',8001493,9.55808,53.545425],
['MDO','Dollnstein',8001495,11.079009,48.871425],
['XTDH','Dolni Habartice',5400870,14.335824,50.75019],
['XTDKR','Dolni Krecany',5400872,14.518703,50.956423],
['XTDD','Dolni Podluzi',5400881,14.620784,50.886784],
['XTDA','Dolni Poustevna',5400884,14.28315,50.983428],
['XTDL','Dolni Zleb',5400890,14.215599,50.845532],
['XTDZ','Dolni Zleb zast.',5400891,14.222765,50.837764],
['XTDO','Domazlice',5400196,12.944582,49.434691],
['NDB','Dombühl',8000365,10.298523,49.25211],
['XLDM','Dommeldange',8270350,6.136628,49.633896],
['LDN','Domnitz(Saalkr)',8011402,11.839973,51.635225],
['XID','Domodossola',8300057,8.296239,46.115293],
['WDS','Domsühl',8011403,11.765869,53.485372],
['RDO','Donaueschingen',8000077,8.498919,47.947786],
['RDOA','Donaueschingen Allmendshofen',8001479,8.50172,47.940563],
['RDOF','Donaueschingen Aufen',8001482,8.47562,47.963356],
['RDOG','Donaueschingen Grüningen',8001483,8.471824,47.983052],
['RDOM','Donaueschingen Mitte/Siedlung',8001485,8.488955,47.952541],
['MDT','Donauwörth',8000078,10.771443,48.714026],
['XNDO','Dordrecht',8400180,4.667766,51.807324],
['ONDOS','Dordrecht Stadspolders',8400186,4.716856,51.801859],
['ONDOZ','Dordrecht Zuid',8400181,4.671388,51.79002],
['WMK','Dorf Mecklenburg',8012321,11.471343,53.842932],
['DDCH','Dorfchemnitz',8011405,12.839939,50.665997],
['MDFN','Dorfen Bahnhof',8001499,12.159686,48.267048],
['XADG','Dorfgastein',8100098,13.1030948051708,47.2387121773031],
['HDMK','Dorfmark',8001502,9.771305,52.899139],
['NDP','Dorfprozelten',8001503,9.38216,49.779377],
['FDH','Dorheim(Wetterau)',8001504,8.79051,50.352702],
['KDO','Dormagen',8001506,6.814837,51.099495],
['KDBW','Dormagen Chempark',8001507,6.838171,51.077045],
['XADO','Dornbirn',8100122,9.738808,47.417691],
['XADS','Dornbirn Schoren',8100728,9.726722,47.413216],
['UDG','Dornburg(Saale)',8011406,11.675499,51.008613],
['TDS','Dornstetten',8001512,8.494955,48.472106],
['TDSA','Dornstetten-Aach',8001510,8.48291,48.4733],
['EDRN','Dorsten',8006709,6.9705,51.658274],
['FDW','Dortelweil',8001514,8.751145,50.207503],
['EDO','Dortmund Hbf',8000080,7.45929,51.517896],
['EDKK','Dortmund Knappschaftskrankenhaus',8001517,7.537458,51.518768],
['EDMB','Dortmund Möllerbrücke',8001518,7.451706,51.507157],
['EDWH','Dortmund Signal Iduna Park',8001522,7.457573,51.490728],
['EDST','Dortmund Stadthaus',8001520,7.468764,51.507828],
['EDTP','Dortmund Tierpark',8001521,7.461995,51.478193],
['EDUV','Dortmund Universität',8004419,7.417708,51.49274],
['EDW','Dortmund West',8003946,7.438938,51.509652],
['EDAP','Dortmund-Aplerbeck',8001523,7.553189,51.490151],
['EDAU','Dortmund-Aplerbeck Süd',8001524,7.549982,51.484437],
['EDAM','Dortmund-Asseln Mitte',8001526,7.583839,51.526219],
['EDBA','Dortmund-Barop',8001527,7.431298,51.476954],
['EDBK','Dortmund-Brackel',8001529,7.550083,51.520757],
['EDBH','Dortmund-Bövinghausen',8001528,7.327477,51.519036],
['EDD','Dortmund-Derne',8001530,7.528822,51.567716],
['EDDP','Dortmund-Dorstfeld',8000081,7.424864,51.509376],
['EDDS','Dortmund-Dorstfeld Süd',8004230,7.420017,51.500632],
['EDGM','Dortmund-Germania',8001540,7.363728,51.498124],
['EDOH','Dortmund-Huckarde',8001505,7.402353,51.532623],
['EDHU','Dortmund-Huckarde Nord',8001532,7.415095,51.533667],
['EDH','Dortmund-Hörde',8000961,7.500029,51.487782],
['EDKD','Dortmund-Kirchderne',8001533,7.510105,51.547075],
['EDKH','Dortmund-Kirchhörde',8001534,7.457764,51.464241],
['EDK','Dortmund-Kley',8004269,7.365374,51.489467],
['EDKR','Dortmund-Kruckel',8001536,7.415529,51.458332],
['EDKU','Dortmund-Kurl',8001537,7.585291,51.556979],
['EDKO','Dortmund-Körne',8001535,7.51537,51.51343],
['EDWK','Dortmund-Körne West',8003916,7.502409,51.509939],
['EDLH','Dortmund-Löttringhausen',8001538,7.447228,51.451655],
['EDLS','Dortmund-Lütgendortmund',8001516,7.334177,51.500735],
['EDLN','Dortmund-Lütgendortmund Nord',8001539,7.342401,51.508523],
['EDMR','Dortmund-Marten',8001541,7.374408,51.514462],
['EDMS','Dortmund-Marten Süd',8001542,7.387479,51.507984],
['EDMG','Dortmund-Mengede',8001543,7.374374,51.570345],
['EDOO','Dortmund-Nette/Oestrich',8001519,7.377731,51.561495],
['EDOP','Dortmund-Oespel',8004288,7.383811,51.488397],
['EDRA','Dortmund-Rahm',8001544,7.395252,51.525728],
['EDSH','Dortmund-Scharnhorst',8001515,7.536564,51.538373],
['EDSM','Dortmund-Somborn',8001549,7.350084,51.49601],
['EDSO','Dortmund-Sölde',8001545,7.589205,51.49546],
['EDOF','Dortmund-Westerfilde',8001525,7.380213,51.548334],
['EDWI','Dortmund-Wickede',8001546,7.62466,51.53393],
['EDWW','Dortmund-Wickede West',8003936,7.607215,51.529455],
['EDOL','Dortmund-Wischlingen',8001531,7.412863,51.51929],
['ADO','Dorum(Weserm)',8001547,8.575801,53.688743],
['WDOW','Dossow(Prign)',8011408,12.520886,53.121209],
['NDM','Dottenheim',8001548,10.522573,49.547496],
['TDOD','Dotternhausen-Dormettingen',8029358,8.781119,48.228455],
['XSDO','Dottikon-Dintikon',8502212,8.23468774088471,47.3736425259442],
['XFDR','Dourges',8701046,2.986945,50.432217],
['BDF','Drahnsdorf',8011409,13.58125,51.915391],
['LDRG','Drahtzug',8017005,11.124636,51.663447],
['XLDF','Drauffelt',8270360,6.006621,50.014874],
['BDR','Drebkau',8011414,14.22313,51.655084],
['LDAH','Drei Annen Hohne',8017006,10.726766,51.770116],
['FBUS','Dreieich-Buchschlag',8001236,8.661204,50.022113],
['FDCH','Dreieich-Dreieichenhain',8001554,8.708693,49.998468],
['FGOZ','Dreieich-Götzenhain',8002315,8.731266,49.994502],
['FOFF','Dreieich-Offenthal',8004653,8.74964,49.981851],
['FSPO','Dreieich-Sprendlingen',8005636,8.68874,50.015201],
['FWED','Dreieich-Weibelfeld',8079151,8.700922,50.007084],
['FOHS','Dreikirchen',8004538,7.958384,50.449865],
['LDD','Dreileben-Drackenstedt',8011415,11.341559,52.143852],
['EDRS','Drensteinfurt',8001558,7.733609,51.799158],
['DBPL','Dresden Bischofsplatz',8011416,13.746248,51.072335],
['DKTF','Dresden Flughafen',8011399,13.765993,51.124665],
['DHFR','Dresden Freiberger Straße',8011431,13.71959,51.047977],
['DGRS','Dresden Grenzstraße',8011417,13.777737,51.128298],
['DH','Dresden Hbf',8010085,13.732035,51.040563],
['DIG','Dresden Industriegelände',8011418,13.762772,51.087456],
['DM','Dresden Mitte',8013444,13.724109,51.056168],
['DCT','Dresden-Cotta',8011419,13.683298,51.062157],
['DD','Dresden-Dobritz',8011420,13.808477,51.011614],
['DF','Dresden-Friedrichstadt',8013475,13.708151,51.056034],
['DKE','Dresden-Kemnitz',8011421,13.668919,51.073084],
['DKT','Dresden-Klotzsche',8010088,13.78911,51.114667],
['DN','Dresden-Neustadt',8010089,13.740701,51.065899],
['DNSH','Dresden-Niedersedlitz',8011422,13.828399,50.999654],
['DPS','Dresden-Pieschen',8011423,13.725527,51.081859],
['DPL','Dresden-Plauen',8013476,13.70317,51.02963],
['DRK','Dresden-Reick',8011424,13.790514,51.021317],
['DSTT','Dresden-Stetzsch',8011425,13.650869,51.080848],
['DSTH','Dresden-Strehlen',8011426,13.761861,51.030677],
['DTR','Dresden-Trachau',8011427,13.702792,51.090081],
['DZSW','Dresden-Zschachwitz',8011428,13.84493,50.989652],
['HDRY','Dreye',8001561,8.871103,53.018425],
['ONDZ','Driebergen-Zeist',8400182,6.0005555152893,52.065277099609],
['ONDR','Driehuis',8400183,5.99714,52.442501068115],
['LDM','Drohndorf-Mehringen',8011433,11.515648,51.721692],
['ONDP','Dronryp',8400192,5.9941668510437,53.1778086],
['XNDR','Dronten',8400198,5.9886615,52.5344],
['OADI','Drösing',8100221,16.895693,48.539907],
['XTDU','Duchcov',5400051,13.754847,50.617473],
['WDU','Ducherow',8011438,13.796021,53.766135],
['KDUK','Duckterath',8001566,7.103496,50.984815],
['SDUW','Dudweiler',8001570,7.027351,49.277299],
['XRDS','Dugo Selo',7800024,16.2339586,45.8013365],
['EDEF','Duisburg Entenfang',8005272,6.813422,51.377123],
['EDG','Duisburg Hbf',8000086,6.775903,51.429785],
['EDBU','Duisburg-Buchholz',8001600,6.775406,51.382919],
['EDGR','Duisburg-Großenbaum',8001602,6.77747,51.364774],
['EDHD','Duisburg-Hochfeld Süd',8001605,6.753408,51.409],
['EDMO','Duisburg-Meiderich Ost',8001607,6.800789,51.468855],
['EDME','Duisburg-Meiderich Süd',8000367,6.780191,51.468831],
['EDOM','Duisburg-Obermeiderich',8001608,6.821232,51.468792],
['EDRM','Duisburg-Rahm',8001609,6.779924,51.346835],
['EDRU','Duisburg-Ruhrort',8001611,6.736015,51.45728],
['EDSL','Duisburg-Schlenk',8001596,6.773206,51.401781],
['EDWD','Duisburg-Wedau',8001612,6.803575,51.399253],
['ONDV','Duiven',8400193,5.9802780151367,51.943332672119],
['XNDU','Duivendrecht',8400194,5.9797382354736,52.323333740234],
['XFDK','Dunkerque',8700004,2.368701,51.030338],
['MDUH','Durach',8001614,10.343797,47.696452],
['RKDUH','Durlach Hubstraße, Karlsruhe',724002,8.472393,49.007212],
['RKDUU','Durlach Untermühlstraße, Karlsruhe',721456,8.454308,49.002171],
['PQKTR','Durlacher Tor/KIT-Campus Süd (U), Karlsruhe',501001,8.41826,49.00877],
['RKDTD','Durlacher Tor/KIT-Campus Süd, Karlsruhe',377903,8.418562,49.009485],
['RDRM','Durmersheim',8001616,8.272631,48.928904],
['RDUN','Durmersheim Nord',8070170,8.280581,48.937796],
['FDTH','Dutenhofen(Wetzlar)',8001618,8.598905,50.56445],
['TDU','Dußlingen',8001617,9.058444,48.452408],
['XDDY','Dyreby st',8600436,8.298163,55.700006],
['OPDW','Dzialdowo',5100100,20.168,53.237993],
['XSDN','Däniken',8502111,7.97875336333831,47.3563863909847],
['DDE','Döbeln Hbf',8010080,13.094988,51.126568],
['LDO','Döberitz',8011390,12.368462,52.524333],
['RDGN','Döggingen',8001480,8.441107,47.893654],
['NDAU','Döhlau',8001481,11.655966,49.961392],
['UDST','Döllstädt',8010081,10.813398,51.084886],
['NDOE','Dörfles-Esbach',8001484,10.997756,50.282751],
['HDPH','Dörpen',8001486,7.354507,52.970568],
['UDOE','Dörrberg',8011397,10.798671,50.735351],
['HDVD','Dörverden',8001489,9.246334,52.846407],
['OSDOK','Döttingen',8503501,8.25643,47.5755],
['KDUL','Dülken',8001571,6.33793,51.257149],
['EDUL','Dülmen',8000083,7.295765,51.827676],
['KDN','Düren',8000084,6.482451,50.809517],
['KDNS','Düren Annakirmesplatz',8007818,6.474259,50.796237],
['KDNG','Düren Im Großen Tal',8007836,6.47431,50.83302],
['KDNR','Düren Renkerstraße',8007832,6.489493,50.770276],
['KKBR','Düren-Kuhbrücke',8007833,6.486752,50.783312],
['KLED','Düren-Lendersdorf',8007819,6.49047,50.774833],
['OADKT','Dürnkrut',8100724,16.86077,48.470627],
['RDBG','Dürrenbüchig',8001576,8.648181,49.023952],
['MDHR','Dürrnhaar',8001578,11.736607,47.993954],
['DRR','Dürrröhrsdorf',8010091,14.00738,51.028138],
['KDFF','Düsseldorf Flughafen',8000082,6.786836,51.292009],
['KDF','Düsseldorf Flughafen Terminal',8001580,6.766979,51.278517],
['KDFS','Düsseldorf Friedrichstadt',8001579,6.78899,51.212115],
['KD','Düsseldorf Hbf',8000085,6.794319,51.219962],
['KDV','Düsseldorf Volksgarten',8001581,6.791978,51.210138],
['KDVS','Düsseldorf Völklinger Str.',8001603,6.760431,51.210208],
['KDW','Düsseldorf Wehrhahn',8001582,6.798173,51.228447],
['KDBE','Düsseldorf-Benrath',8001584,6.878931,51.162293],
['KDBH','Düsseldorf-Bilk',8001585,6.775578,51.207994],
['KDD','Düsseldorf-Derendorf',8001586,6.794512,51.247624],
['KDE','Düsseldorf-Eller',8001587,6.851927,51.20267],
['KDEM','Düsseldorf-Eller Mitte',8001308,6.838607,51.202058],
['KDES','Düsseldorf-Eller Süd',8001588,6.836128,51.198072],
['KDFL','Düsseldorf-Flingern',8001598,6.810179,51.226367],
['KDGA','Düsseldorf-Garath',8001589,6.897675,51.143626],
['KDGE','Düsseldorf-Gerresheim',8001590,6.863933,51.220361],
['KDHA','Düsseldorf-Hamm',8001597,6.740335,51.21077],
['KDHL','Düsseldorf-Hellerhof',8004920,6.908277,51.133036],
['KDOB','Düsseldorf-Oberbilk',8001591,6.808678,51.208047],
['KDR','Düsseldorf-Rath',8001592,6.821063,51.264124],
['KDRM','Düsseldorf-Rath Mitte',8001593,6.808398,51.261136],
['KDRH','Düsseldorf-Reisholz',8001594,6.860953,51.180782],
['KDU','Düsseldorf-Unterrath',8001595,6.788783,51.276732],
['KDZ','Düsseldorf-Zoo',8001583,6.796924,51.236962],
['WDT','Dütschow',8011442,11.678565,53.40194],
['NEE','Ebelsbach-Eltmann',8001619,10.669614,49.982672],
['XAEB','Eben im Pongau',8100140,13.39670241952,47.4064960015542],
['XAEF','Ebenfurth',8100225,16.361942,47.877644],
['NEBH','Ebenhausen(Unterfr)',8001620,10.13804,50.131305],
['MEBS','Ebenhausen-Schäftlarn',8001621,11.453608,47.978686],
['MEBH','Ebenhofen',8001622,10.618479,47.814818],
['NED','Ebensfeld',8001623,10.954725,50.068731],
['REA','Eberbach',8000369,8.984152,49.465768],
['NEBM','Ebermannstadt',8001627,11.186873,49.776801],
['MEBM','Ebermergen',8001628,10.71096,48.75621],
['NEB','Ebern',8001629,10.796719,50.094163],
['TEC','Ebersbach(Fils)',8001632,9.526582,48.71612],
['DEB','Ebersbach(Sachs)',8010092,14.578802,51.004378],
['MEG','Ebersberg(Oberbay)',8001634,11.970243,48.07497],
['DEBR','Ebersbrunn',8011446,12.443215,50.651373],
['NEC','Ebersdorf(b Coburg)',8001636,11.064643,50.224271],
['XFEH','Ebersheim',8701054,7.494354,48.310158],
['WE','Eberswalde Hbf',8010093,13.797062,52.834021],
['RET','Ebertsheim',8001638,8.108237,49.564004],
['PQKEB','Ebertstraße, Karlsruhe',721347,8.394675,48.994617],
['NEG','Ebing',8001640,10.913846,50.001535],
['REBR','Ebringen',8001643,7.76818,47.96036],
['HEBS','Ebstorf(Uelzen)',8001645,10.41695,53.017192],
['AECH','Echem',8001646,10.537198,53.337006],
['MEC','Eching',8001647,11.616754,48.302992],
['ONET','Echt',8400195,5.9749999046326,51.100555419922],
['TETD','Echterdingen',8001650,9.169164,48.692152],
['FEZL','Echzell',8001648,8.891312,50.390719],
['UEK','Eckardtsleben',8011449,10.682123,51.066093],
['UEC','Eckartsberga(Thür)',8011450,11.55455,51.107837],
['TEI','Eckartshausen-Ilshofen',8001651,9.936645,49.152317],
['PQKEK','Eckenerstraße, Karlsruhe',723610,8.349975,49.005325],
['AEC','Eckernförde',8001654,9.835115,54.4676],
['NEMN','Eckersmühlen',8001655,11.137947,49.215472],
['FED','Eddersheim',8001659,8.456741,50.039492],
['XNE','Ede Centrum',8400201,5.9702777862549,52.043609619141],
['XBED','Ede(B)',8800367,3.987542,50.911144],
['XNEW','Ede-Wageningen',8400200,5.9695,52.027778625488],
['TED','Edelfingen',8001660,9.743113,49.513025],
['REK','Edenkoben',8001663,8.14062,49.282053],
['FGRF','Edermünde-Grifte',8002374,9.448855,51.209958],
['REH','Edesheim(Pfalz)',8001665,8.139075,49.263736],
['SEE','Ediger-Eller',8001666,7.139598,50.104697],
['FEDI','Edingen(Wetzlar)',8001668,8.322823,50.632166],
['DKR','Edle Krone',8011451,13.583632,50.950015],
['MEDL','Edling',8001669,12.163234,48.058479],
['PNEHV','Eemshaven',8400202,5.952222,53.458419],
['UEFT','Effelder(Thür)',8011453,11.075849,50.379875],
['FEF','Effolderbach',8001670,9.007483,50.338192],
['XSEK','Effretikon',8503305,8.68666226267409,47.4258103323967],
['REF','Efringen-Kirchen',8001671,7.563918,47.655619],
['FEGB','Egelsbach',8001672,8.653462,49.96917],
['NEGE','Egersdorf',8001674,10.887385,49.464638],
['HEGT','Egestorf(Deister)',8001675,9.514485,52.278585],
['OAEB','Eggenburg',8100201,15.814938,48.637773],
['MEGF','Eggenfelden',8001677,12.748669,48.403956],
['MEFM','Eggenfelden Mitte',8001676,12.767068,48.406215],
['REG','Eggenstein Bf',8007173,8.397941,49.075671],
['PQESS','Eggenstein Schweriner Straße, Eggenstein-Leopoldsh',720701,8.402144,49.085722],
['PQESW','Eggenstein Spöcker Weg, Eggenstein-Leopoldshafen',720702,8.399657,49.079745],
['REGS','Eggenstein Süd, Eggenstein-Leopoldshafen',720703,8.396257,49.071428],
['LEGD','Eggersdorf',8011455,11.695948,51.975131],
['WEGS','Eggesin',8011456,14.073046,53.681825],
['RUEG','Eggingen',8070866,8.396653,47.693731],
['MEGK','Egglkofen',8001678,12.445956,48.395762],
['MEGM','Eggmühl',8001679,12.182192,48.836497],
['NEO','Eggolsheim',8001680,11.036662,49.77496],
['MEGL','Eglharting',8001682,11.864291,48.082348],
['MELG','Egling',8001683,10.975722,48.190541],
['XSEG','Eglisau',8503402,8.51653513850671,47.5723728053759],
['OIENT','Egna-Termeno/Neumarkt-Tramin',8301491,11.257398,46.3195],
['XSEN','Egnach',8506309,9.38300007742757,47.5439914495156],
['OMEGH','Egyhazasradoc',5500471,16.619625,47.09125],
['TEH','Ehingen(Donau)',8001684,9.72434,48.285677],
['EELB','Ehlenbruch',8001686,8.741243,51.98127],
['HELH','Ehlershausen',8001687,10.029596,52.523609],
['TEHN','Ehningen(b Böblingen)',8001689,8.94426,48.662682],
['KEHR','Ehr',8001690,7.571324,50.17572],
['SEG','Ehrang',8000370,6.685808,49.802029],
['SEGO','Ehrang Ort',8001688,6.688261,49.809413],
['FEGN','Ehringen',8001691,9.154619,51.379528],
['EERI','Ehringhausen(Kr Lippstadt)',8001692,8.44926,51.662813],
['FEHR','Ehringshausen(Kr Wetzlar)',8001694,8.383841,50.595066],
['FEHH','Ehringshausen(Oberhess)',8001693,9.101862,50.70878],
['XAEZ','Ehrwald Zugspitzbahn',8100089,10.913742,47.410123],
['DEIB','Eibau',8010094,14.64616,50.986501],
['DEI','Eich(Sachs)',8011458,12.340142,50.545751],
['EEHS','Eichen(Kr Siegen)',8001700,7.977934,50.973864],
['MEIC','Eichenau(Oberbay)',8001702,11.328277,48.179324],
['HEBG','Eichenberg',8000090,9.921482,51.374823],
['FEIZ','Eichenzell',8001704,9.694717,50.494012],
['EEHG','Eichhagen',8001706,7.836871,51.059167],
['REM','Eicholzheim',8001707,9.290317,49.432439],
['LEST','Eichstedt(Altm)',8011460,11.854895,52.67485],
['RE','Eichstetten am Kaiserstuhl',8007295,7.748021,48.092901],
['MEB','Eichstätt Bahnhof',8001708,11.16365,48.869879],
['MEST','Eichstätt Stadt',8001709,11.179602,48.893296],
['BEIW','Eichwalde',8080340,13.615398,52.371352],
['LEF','Eickendorf',8011462,11.676878,51.946752],
['ONEJ','Eijsden',8400219,5.9438886642456,50.771945953369],
['LEG','Eilenburg',8010095,12.637004,51.451966],
['LEGO','Eilenburg Ost',8010161,12.667772,51.463424],
['KEIL','Eilendorf',8001712,6.154367,50.785561],
['LEI','Eilsleben(b Magdeburg)',8010096,11.215214,52.150237],
['HEIV','Eilvese',8001713,9.428147,52.545215],
['REI','Eimeldingen',8001715,7.5956,47.627948],
['HEBM','Einbeck Mitte',8001717,9.87529278,51.8185308],
['HEBA','Einbeck Otto-Hahn-Straße',8001723,9.89290953,51.8144784],
['HEB','Einbeck-Salzderhelden',8005264,9.922775,51.798169],
['XNEI','Eindhoven Centraal',8400206,5.479573,51.443018],
['ONEIB','Eindhoven Strijp-S',8400196,5.456659,51.450677],
['AEF','Einfeld',8001718,9.997923,54.129373],
['DED','Einsiedel',8011466,12.973014,50.772786],
['DEDP','Einsiedel August-Bebel-Platz',8071828,12.974149,50.767713],
['DEDB','Einsiedel Brauerei',8071781,12.974713,50.76517],
['DEDH','Einsiedel Hp Gymnasium',8011464,12.970611,50.782992],
['XSES','Einsiedeln',8503283,8.74446828515549,47.1285821379056],
['SEF','Einsiedlerhof',8001720,7.662227,49.431002],
['SEI','Einöd(Saar)',8000371,7.321916,49.266663],
['FERT','Eisemroth',8001724,8.416049,50.737743],
['UEI','Eisenach',8010097,10.331986,50.976922],
['UEIP','Eisenach Opelwerke Hp',8010105,10.283491,50.979334],
['UEIW','Eisenach West',8011468,10.30474,50.978902],
['REIS','Eisenberg(Pfalz)',8001728,8.070582,49.554483],
['NEHM','Eisenheim',8070856,10.153426,49.869412],
['BEHS','Eisenhüttenstadt',8011471,14.658435,52.14798],
['MEZT','Eisenärzt',8001725,12.638301,47.796273],
['EEFD','Eiserfeld(Sieg)',8001729,7.987071,50.847299],
['UED','Eisfeld',8011472,10.904637,50.417795],
['LETM','Eisfelder Talmühle',8017007,10.812956,51.620408],
['TEF','Eislingen(Fils)',8001731,9.705147,48.696494],
['REIW','Eiswoog',8001732,7.983562,49.516578],
['MEI','Eitensheim',8001734,11.319259,48.815979],
['KEIT','Eitorf',8001736,7.447326,50.773619],
['XBEK','Ekeren',8800189,4.434262,51.281518],
['LELD','Elend',8017008,10.690129,51.74597],
['NELF','Elfershausen-Trimberg',8001742,9.969109,50.14048],
['UELG','Elgersburg',8011476,10.849905,50.706054],
['DLD','Ellefeld',8011477,12.384382,50.488003],
['TBME','Ellental',8001746,9.123744,48.955288],
['AELA','Ellerau',8007050,9.923374,53.750144],
['TELL','Ellhofen',8001747,9.316035,49.149952],
['NEL','Ellingen(Bay)',8001749,10.959693,49.066228],
['UER','Ellrich',8011480,10.669444,51.579804],
['TEL','Ellwangen',8001751,10.129681,48.964121],
['MELZ','Ellzee',8001752,10.338371,48.34214],
['WELM','Elmenhorst',8011481,13.074014,54.210202],
['AEL','Elmshorn',8000092,9.659408,53.754025],
['XFEL','Elne',8701064,2.963436,42.597142],
['TELP','Elpersheim',8001754,9.873427,49.473094],
['XAEL','Elsbethen',8100772,13.0803940431704,47.7609257890464],
['HELS','Elsfleth',8001760,8.464026,53.234103],
['BEZ','Elsholz',8011482,12.954911,52.20405],
['LEK','Elsnigk(Anh)',8011484,12.058518,51.790671],
['XNEL','Elst',8400207,5.934543,51.916942596435],
['BETN','Elstal',8080370,13.000114,52.54749],
['LELT','Elster(Elbe)',8011486,12.827705,51.832331],
['UELB','Elsterberg',8011487,12.167487,50.613547],
['UELK','Elsterberg-Kunstseidenwerk',8011488,12.159798,50.605024],
['BEW','Elsterwerda',8010099,13.516428,51.459677],
['BEB','Elsterwerda-Biehla',8010100,13.519271,51.472227],
['NEF','Eltersdorf',8001762,10.996381,49.553782],
['FELT','Eltville',8001763,8.12153,50.027562],
['UEX','Elxleben',8011489,10.946788,51.043183],
['FELZ','Elz(Limburg/Lahn)',8001764,8.038458,50.414294],
['FELS','Elz(Limburg/Lahn) Süd',8001765,8.032223,50.408709],
['RELZ','Elzach',8001766,8.070891,48.171194],
['HELZ','Elze(Han)',8000093,9.746894,52.120147],
['HEA','Emden Außenhafen',8001767,7.186179,53.344469],
['HE','Emden Hbf',8001768,7.195176,53.369036],
['KEMM','Emmelshausen',8001770,7.560494,50.157673],
['PNEZ','Emmen Zuid',8400093,5.9302778244019,52.748866374691],
['ONEM','Emmen(NL)',8400208,5.9305553436279,52.790000915527],
['XSEB','Emmenbrücke',8502021,8.28255105832802,47.0705979582071],
['REMM','Emmendingen',8001771,7.847511,48.119454],
['EEM','Emmerich',8001773,6.25648,51.834175],
['EEME','Emmerich-Elten',8001776,6.15417,51.8743],
['HEMK','Emmerke',8001775,9.866201,52.162365],
['HEMT','Emmerthal',8001777,9.382856,52.046413],
['EEMP','Empel-Rees',8001780,6.416712,51.798474],
['HEMP','Empelde',8001781,9.668982,52.340157],
['EEDT','Emsdetten',8001782,7.531528,52.17675],
['NEK','Emskirchen',8001783,10.710412,49.55503],
['TEN','Endersbach',8001785,9.370228,48.813153],
['REN','Endingen am Kaiserstuhl',8007285,7.701918,48.14425],
['TEND','Endingen(Württ)',8029356,8.83688,48.257384],
['KENG','Engeln',8070368,7.156853,50.424945],
['KENL','Engelskirchen',8001789,7.407681,50.986719],
['RENG','Engen',8001790,8.772786,47.856347],
['KENR','Engers',8000094,7.546827,50.42598],
['MEGH','Engertsham',8001792,13.358696,48.473918],
['XBEN','Engis',8800464,5.402714,50.582831],
['TKL','Engstingen',8070456,9.292419,48.392271],
['TENS','Engstingen Schulzentrum',8003335,9.2843,48.384],
['TENG','Engstlatt',8001794,8.875219,48.297119],
['SENK','Enkenbach',8000372,7.899501,49.489933],
['XNEK','Enkhuizen',8400210,5.92479,52.699165344238],
['EENP','Ennepetal',8001795,7.343533,51.304778],
['XAEN','Enns',8100011,14.4668014469929,48.2211895097233],
['XNES','Enschede',8400212,5.9216666221619,52.222499847412],
['XNDE','Enschede De Eschmarke',8400012,5.9194445610046,52.221389770508],
['ONESD','Enschede Kennispark',8400213,5.9141664505005,52.23749923706],
['SEN','Ensdorf(Saar)',8001799,6.776015,49.302874],
['FENS','Enspel',8001801,7.882353,50.616413],
['PQKEF','Entenfang, Karlsruhe',370051,8.357809,49.011029],
['TENT','Entringen',8001802,8.963007,48.552291],
['TEZ','Enzberg',8001803,8.799804,48.933883],
['MENW','Enzisweiler',8001806,9.665429,47.564142],
['EEPE','Epe(Westf)',8001808,7.030087,52.183462],
['XFE','Epernay',8700053,3.960091,49.046572],
['XFEI','Epierre-St Leger',8702401,6.292379,45.457053],
['XFEN','Epinal',8700255,6.441381,48.178008],
['SEP','Eppelborn',8001812,6.967189,49.408657],
['FEPP','Eppelsheim(Rheinhess)',8001813,8.162882,49.700063],
['FER','Eppertshausen',8001814,8.84236,49.945368],
['REP','Eppingen',8000373,8.914663,49.136001],
['REPW','Eppingen West',8079077,8.904759,49.132674],
['FEP','Eppstein',8001815,8.387643,50.139833],
['FEPB','Eppstein-Bremthal',8001816,8.364079,50.141396],
['FERO','Erbach(Odenw)',8001817,8.989827,49.656712],
['FERN','Erbach(Odenw) Nord',8001811,8.989963,49.669584],
['FERB','Erbach(Rheingau)',8001818,8.094646,50.023269],
['TER','Erbach(Württ)',8001820,9.894833,48.325902],
['RETE','Erbprinz/Schloss, Ettlingen',723573,8.404485,48.940739],
['LER','Erdeborn',8011496,11.636965,51.468799],
['MER','Erding',8001825,11.912063,48.30346],
['TERD','Erdmannhausen',8001827,9.299405,48.948229],
['DEA','Erdmannsdorf-Augustusburg',8011497,13.08394,50.82115],
['MEWG','Erdweg',8001829,11.303305,48.333744],
['KEST','Erftstadt',8003671,6.832955,50.807093],
['UE  P','Erfurt Hbf',8010101,11.038499,50.972551],
['UEN','Erfurt Nord',8010102,11.029277,51.003357],
['UEO','Erfurt Ost',8011500,11.04377,51.014542],
['UEBI','Erfurt-Bischleben',8011502,10.988439,50.933768],
['UEGI','Erfurt-Gispersleben',8011503,11.000277,51.022129],
['TEG','Ergenzingen',8001833,8.809857,48.489534],
['MERB','Ergoldsbach',8001835,12.201874,48.693868],
['EERG','Ergste',8001836,7.577534,51.424705],
['TEK','Eriskirch',8001838,9.526672,47.628402],
['KERZ','Erkelenz',8001839,6.32172,51.076564],
['NERK','Erkersreuth',8001840,12.141494,50.186624],
['BERK','Erkner',8013477,13.751457,52.428359],
['BE','Erkner (S)',8089181,13.7517714,52.4284765],
['KER','Erkrath',8001841,6.902412,51.220458],
['KERN','Erkrath-Nord',8001842,6.91064,51.229278],
['DERA','Erla',8011505,12.78694,50.519815],
['DERB','Erlabrunn(Erzgeb)',8011506,12.720499,50.470906],
['NER','Erlangen',8001844,11.001908,49.595895],
['NERS','Erlangen Paul-Gossen-Straße',8001846,10.99939,49.579293],
['NERH','Erlangen-Bruck',8001845,10.997261,49.570665],
['DER','Erlau(Sachs)',8011507,12.943035,51.00863],
['XSE','Erlen',8506107,9.22619100907512,47.5514562600656],
['NERL','Erlenbach(Main)',8001848,9.154436,49.803633],
['XSEM','Ermatingen',8506133,9.08565476022238,47.6699950278449],
['XSEMS','Ermatingen URh',8506162,9.08544469808097,47.6752332637346],
['ONER','Ermelo',8400216,5.91309,52.301666259766],
['EEK','Erndtebrück',8001851,8.255317,50.991234],
['MERG','Ernsgaden',8001853,11.573292,48.733309],
['FERH','Ernsthausen',8001854,8.731617,50.979301],
['UERN','Ernstthal am Rennsteig',8011512,11.164312,50.496511],
['KERP','Erpel(Rhein)',8001858,7.241594,50.582064],
['RERO','Erpolzheim',8001860,8.210697,49.488326],
['XBEQ','Erquelinnes',8800023,4.112295,50.30368],
['TERS','Ersingen',8001861,8.63856,48.930657],
['TERW','Ersingen West',8079090,8.633941,48.931433],
['XFES','Erstein',8700281,7.638517,48.42317],
['XSEF','Erstfeld',8505114,8.65044288779607,46.8203404742261],
['FEZS','Erzhausen',8001864,8.650807,49.950731],
['RERZ','Erzingen(Baden)',8001865,8.430123,47.659541],
['TERZ','Erzingen(Württ)',8029357,8.815709,48.255409],
['XDE','Esbjerg st',8600508,8.458649,55.467793],
['XLEA','Esch-sur-Alzette',8200640,5.9856,49.493868],
['FES','Eschborn',8001870,8.560971,50.143618],
['FESS','Eschborn Süd',8001871,8.578487,50.133563],
['HESD','Eschede',8001872,10.230135,52.740784],
['RESN','Eschelbronn',8007443,8.867796,49.323982],
['NESU','Eschenau(Mittelfr)',8001875,11.198618,49.575385],
['TESU','Eschenau(b Heilbronn)',8001874,9.402735,49.143785],
['XAEU','Eschenau/Salzach',8100770,13.008097,47.306613],
['NESB','Eschenbach(b Markt Erlbach)',8001877,10.671636,49.482234],
['MECH','Eschenlohe',8001880,11.187945,47.601745],
['NESD','Escherndorf-Vogelsburg',8070857,10.165791,49.86674],
['FEN','Eschhofen',8001883,8.10492,50.393586],
['FEG','Eschwege',8001884,10.042586,51.191754],
['FONH','Eschwege-Niederhone',8001895,10.008073,51.196291],
['KE','Eschweiler Hbf',8001886,6.251937,50.813532],
['KET','Eschweiler Talbahnhof',8001888,6.263203,50.814759],
['KEN','Eschweiler-Nothberg',8001889,6.293846,50.812827],
['KESJ','Eschweiler-St.Jöris',8001917,6.201387,50.834502],
['KWEI','Eschweiler-Weisweiler',8001893,6.320318,50.824174],
['KEW','Eschweiler-West',8001887,6.251721,50.817712],
['HESO','Esens(Ostfriesl)',8001890,7.616211,53.636214],
['XVEV','Eslöv station',7400053,13.3052278,55.8378366],
['XBEX','Esneux',8800273,5.572782,50.530577],
['HEKP','Espelkamp',8001894,8.613358,52.378688],
['FMHF','Espenau-Mönchehof',8004060,9.455955,51.390674],
['AESL','Essel',8071334,9.272382,53.487691],
['EE','Essen Hbf',8000098,7.014793,51.451355],
['EESA','Essen Stadtwald',8001896,7.023296,51.422853],
['EESD','Essen Süd',8001897,7.023098,51.439295],
['EENW','Essen West',8001898,6.979798,51.454497],
['XBES','Essen(B)',8800009,4.450999,51.462641],
['HESN','Essen(Oldb)',8001899,7.945437,52.723882],
['EEAL','Essen-Altenessen',8001900,7.007252,51.48437],
['EEBE','Essen-Bergeborbeck',8001901,6.977111,51.480396],
['EEBB','Essen-Borbeck',8001902,6.948461,51.473103],
['EEBS','Essen-Borbeck Süd',8005031,6.953922,51.461673],
['EEDL','Essen-Dellwig',8001903,6.922269,51.487923],
['EEDO','Essen-Dellwig Ost',8001904,6.927211,51.487604],
['EEIB','Essen-Eiberg',8001905,7.109691,51.441814],
['EEFO','Essen-Frohnhausen',8001906,6.965285,51.455113],
['EEGE','Essen-Gerschede',8001907,6.943309,51.483036],
['EEHH','Essen-Holthausen',8006514,7.072649,51.417711],
['EEHT','Essen-Horst',8006194,7.102741,51.431214],
['EEHU','Essen-Hügel',8001908,7.008243,51.404501],
['EEKN','Essen-Kray Nord',8001910,7.080476,51.46943],
['EEKS','Essen-Kray Süd',8001911,7.074655,51.458055],
['EEKU','Essen-Kupferdreh',8001912,7.080247,51.390945],
['EEST','Essen-Steele',8000099,7.075552,51.450684],
['EESO','Essen-Steele Ost',8001913,7.088561,51.444201],
['EEWD','Essen-Werden',8001915,6.997845,51.386828],
['EEKB','Essen-Zollverein Nord',8001909,7.046744,51.493609],
['EEUE','Essen-Überruhr',8001914,7.068716,51.428541],
['PQKES','Essenweinstraße, Karlsruhe',370626,8.431947,49.010104],
['TE','Esslingen(Neckar)',8001920,9.30008,48.73881],
['TEME','Esslingen-Mettingen',8001921,9.27583,48.747083],
['TEZL','Esslingen-Zell',8006642,9.359389,48.724328],
['MESG','Esting',8001996,11.317322,48.212196],
['XFETP','Etampes',8700548,2.15935,48.437044],
['HETL','Etelsen',8001924,9.123745,52.999203],
['XLET','Ettelbruck',8200120,6.10683,49.847445],
['ONEL','Etten-Leur',8400218,5.8991665840149,51.57500076294],
['UEH','Ettenhausen',8011519,10.232251,50.874563],
['NET','Etterzhausen',8001925,11.978031,49.030609],
['RETT','Ettlingen Stadt',8007007,8.409106,48.938617],
['RETL','Ettlingen West',8001926,8.387878,48.947182],
['RKME','Ettlinger Tor/Staatstheater (U), Karlsruhe',901012,8.40345,49.00544],
['EEZB','Etzbach',8001928,7.690264,50.781282],
['NEW','Etzelwang',8001929,11.586408,49.525525],
['REZB','Etzenbach',8007334,7.748889,47.86677],
['NEZ','Etzenricht',8001932,12.098291,49.628817],
['RETZ','Etzenrot',8007008,8.457623,48.914209],
['UET','Etzleben',8011520,11.181128,51.258077],
['XSEW','Etzwilen',8506025,8.81859374587505,47.6611436806357],
['TEU','Eubigheim',8001933,9.538015,49.501732],
['NEU','Euerdorf',8001935,10.027633,50.149535],
['XAED','Eugendorf',8100774,13.116709,47.873321],
['XBEP','Eupen',8800110,6.037155,50.635364],
['PQKEU','Europaplatz/Postgalerie (U), Karlsruhe',501004,8.39432,49.00997],
['RKSEP','Europaplatz/Postgalerie, Karlsruhe',721358,8.393553,49.010104],
['KEU','Euskirchen',8000100,6.792193,50.65776],
['KZU','Euskirchen Zuckerfabrik',8006673,6.813256,50.65687],
['KGBU','Euskirchen-Großbüllesheim',8002402,6.816188,50.686747],
['KKRW','Euskirchen-Kreuzweingarten',8003440,6.796055,50.613054],
['KKUH','Euskirchen-Kuchenheim',8003462,6.834478,50.655602],
['KSTZ','Euskirchen-Stotzheim',8005748,6.810773,50.633859],
['AEU','Eutin',8001941,10.610123,54.135343],
['TETN','Eutingen Nord',8001944,8.7531,48.4847],
['TET','Eutingen im Gäu',8000101,8.782236,48.479952],
['TEB','Eutingen(Baden)',8001942,8.743772,48.909846],
['XFEV','Evreux Normandie',8700219,1.149686,49.018469],
['TEY','Eyach',8001946,8.783101,48.446288],
['ONEV','Eygelshoven',8400338,5.898056,50.890556335449],
['XNEM','Eygelshoven Markt',8400043,5.893611,50.896049819644],
['HETR','Eystrup',8001949,9.23139,52.783369],
['OFEZN','Eze',8701100,7.356799,43.722183],
['NEN','Eßleben',8001919,10.085225,49.943101],
['XAFS','Faak am See',8100084,13.9130756724754,46.5643159125976],
['FFAN','Fachingen(Lahn)',8001950,7.992566,50.361781],
['AFK','Fahrenkrug',8001953,10.253159,53.943962],
['RFN','Fahrnau',8001954,7.839425,47.66156],
['XSFD','Faido',8505204,8.79070214576953,46.483076709994],
['DFU','Falkenau(Sachs)Hp',8011528,13.118402,50.854685],
['DFUS','Falkenau(Sachs)Süd',8011529,13.110263,50.84935],
['LF','Falkenberg(Elster)',8010103,13.247685,51.58362],
['WFBG','Falkenberg(Mark)',8011531,13.959985,52.808176],
['WFAP','Falkenhagen Gewerbepark Prignitz',8017346,12.214754,53.205752],
['BFKS','Falkensee',8013479,13.089636,52.559772],
['DFA','Falkenstein(Vogtl)',8010106,12.361698,50.479235],
['HF','Fallersleben',8001957,10.717325,52.423496],
['BFS','Fangschleuse',8011533,13.824926,52.406725],
['MFCH','Farchant',8001961,11.11486,47.53097],
['MFP','Fasanenpark',8001963,11.609378,48.079713],
['NFCH','Faulbach(Main)',8001964,9.437614,49.786932],
['XFF','Faulquemont',8700268,6.604009,49.045715],
['TFAU','Faurndau',8001965,9.616047,48.710807],
['TFV','Favoritepark',8001967,9.180233,48.909209],
['ONVWD','Feanwalden',8400638,5.9886615,53.2351834],
['XFFHL','Fegersheim Lipsheim',8701130,7.672348,48.490973],
['ABUF','Fehmarn-Burg',8001274,11.18898,54.443591],
['XSFE','Fehraltorf',8503302,8.7502650967563,47.3851215524821],
['OAFE','Fehring',8100176,16.01186,46.94952],
['NFZ','Feilitzsch',8001969,11.934034,50.364324],
['MFA','Feldafing',8001970,11.290224,47.946938],
['OAF','Feldbach/Raab',8100175,15.88898,46.95853],
['RFB','Feldberg-Bärental',8001971,8.098294,47.871444],
['AFEB','Felde',8001977,9.947018,54.309847],
['EFEL','Feldhausen',8001972,6.973216,51.614953],
['XAFK','Feldkirch',8100197,9.60445608583997,47.241297170794],
['OAFKA','Feldkirch Amberg',8100791,9.621217,47.255203],
['XAFT','Feldkirchen in Kärnten',8100039,14.0988010202545,46.7213971425771],
['MFK','Feldkirchen(b München)',8001973,11.732103,48.151846],
['MFOL','Feldolling',8001966,11.852244,47.895336],
['XAFX','Felixdorf',8100780,16.2481390546336,47.8889357898922],
['TFE','Fellbach',8001974,9.269978,48.820049],
['FABL','Felsberg-Altenbrunslar',8000520,9.445462,51.165227],
['FGEF','Felsberg-Gensungen',8002236,9.43563,51.131122],
['FWON','Felsberg-Wolfershausen',8006546,9.45006,51.186552],
['BFLZ','Ferch-Lienewitz',8013480,12.964073,52.303553],
['WFDF','Ferdinandshof',8011536,13.881913,53.660087],
['LFMW','Fermerswalde',8011537,13.173589,51.642998],
['EFER','Ferndorf(Siegen)',8001976,8.009227,50.959453],
['PIFLP','Ferno-Lonate Pozzolo',8319371,8.755646,45.608399],
['XIFE','Ferrara',8300209,11.603837,44.843119],
['NFT','Feucht',8001978,11.204207,49.381947],
['NFTO','Feucht Ost',8001988,11.220502,49.376032],
['NFTM','Feucht-Moosbach',8002520,11.260901,49.387913],
['EFEU','Feudingen',8001980,8.329337,50.940797],
['TFI','Fichtenberg',8001982,9.700763,48.987346],
['XAFB','Fieberbrunn',8100053,12.5288935393919,47.4911553688995],
['TFIL','Filderstadt',8001984,9.217709,48.676493],
['XSFI','Filisur',8509195,9.68229070053365,46.6753288359878],
['FFI','Filsen',8001983,7.583509,50.238894],
['BFIH','Finkenheerd',8011540,14.569595,52.249419],
['BFIN','Finkenkrug',8011541,13.051255,52.569663],
['EFP','Finnentrop',8000102,7.964563,51.173048],
['MFNS','Finningerstraße',8001985,10.026228,48.389993],
['MGMF','Finsterwald',8007889,11.728178,47.752887],
['BFW','Finsterwalde(Niederlausitz)',8011542,13.710388,51.637001],
['XIFRS','Firenze S.M.N.',8300151,11.247806,43.776813],
['NFIH','Fischbach(Nürnberg)',8001989,11.17407,49.41334],
['SFC','Fischbach-Camphausen',8001990,7.031132,49.304744],
['SFWB','Fischbach-Weierbach',8001991,7.404671,49.738901],
['MFBU','Fischbachau',8001992,11.934051,47.705605],
['MFN','Fischen',8001995,10.271717,47.456591],
['NFHA','Fischhaus',8070806,13.440826,48.655403],
['MFIN','Fischhausen-Neuhaus',8001998,11.874134,47.706194],
['RFIW','Fischweier, Karlsbad',720822,8.451341,48.888232],
['XSFM','Flamatt',8504103,7.31956255071774,46.888484544433],
['XAFG','Flaurling',8100795,11.143077,47.289009],
['LFG','Flechtingen',8011544,11.261352,52.347968],
['LFL','Fleetmark',8011545,11.378693,52.790802],
['RFL','Flehingen',8002005,8.782727,49.084595],
['AF','Flensburg',8000103,9.436526,54.774039],
['AFW','Flensburg-Weiche',8070006,9.398257,54.757919],
['XFFL','Flers',8700217,-0.573182,48.744394],
['FFD','Flieden',8002010,9.576616,50.421382],
['AFT','Flintbek',8002011,10.062913,54.243349],
['MFLI','Flintsbach',8002012,12.128024,47.724252],
['RFLO','Flomersheim',8002014,8.333801,49.513958],
['DFM','Floßmühle',8011548,13.181082,50.758757],
['BFBI','Flughafen BER - Terminal 1-2',8011201,13.5119498,52.3648038],
['BFBB','Flughafen BER - Terminal 1-2 (S-Bahn)',8089201,13.5119176,52.3648431],
['BFHS','Flughafen BER - Terminal 5 (Schönefeld)',8010109,13.51271,52.391062],
['XAWIF','Flughafen Wien',8100353,16.5624642326075,48.1211401029154],
['XSFL','Flums',8509413,9.34791662856585,47.0966128467643],
['DFL','Flöha',8010108,13.075152,50.854355],
['DFLP','Flöha-Plaue',8010128,13.085007,50.844489],
['FFH','Flörsheim(Main)',8002013,8.431013,50.017211],
['XSFU','Flüelen',8505112,8.62429304307502,46.9017256461889],
['LFDE','Fohrde',8011550,12.46282,52.484148],
['XFFT','Fontaine',8701165,2.926041,50.566439],
['XFFA','Fontainebleau-Avon',8700535,2.726549,48.41629],
['XFFS','Fontan Saorge',8703330,7.551509,43.99666],
['XFFB','Forbach(F)',8700271,6.900258,49.189217],
['RFCH','Forbach(Schwarzw)',8002022,8.361491,48.680399],
['PQRFB','Forchheim Hallenbad, Rheinstetten',720562,8.316833,48.978396],
['PQRFS','Forchheim Hauptstraße, Rheinstetten',723912,8.31248,48.974997],
['PQRFL','Forchheim Leichtsandstr./Messe Karlsruhe, Rheinste',720841,8.323399,48.982159],
['PQRFI','Forchheim Leichtsandstraße/Messe Karlsruhe, Rheins',371210,8.323491,48.982133],
['PQRFO','Forchheim Oberfeldstraße, Rheinstetten',720560,8.307766,48.970273],
['NFO','Forchheim(Oberfr)',8002024,11.069859,49.71707],
['RFM','Forchheim(b Karlsruhe)',8002023,8.338934,48.964785],
['XBFM','Forest Midi/Vorst Zuid',8800397,4.309788,50.809081],
['TFB','Fornsbach',8002026,9.642498,48.975445],
['BFO','Forst(Lausitz)',8010111,14.637628,51.738882],
['FKBHF','Forstfeldstraße, Kassel',716134,9.537956,51.29874],
['KFOS','Forsthaus',8002027,6.503498,51.303412],
['MFOS','Forsting',8002028,12.091448,48.081864],
['XIFF','Fortezza/Franzensfeste',8300089,11.610083,46.788721],
['NFH','Forth',8002029,11.221457,49.591698],
['XFFLT','Fourchambault',8703343,3.087368,47.018969],
['NFHB','Frahelsbruck',8007344,13.027454,49.191145],
['XBFR','Fraipont',8800266,5.724186,50.565059],
['XBFCM','Franchimont',8800591,5.822385,50.525435],
['ONFR','Franeker',8400232,5.879133,53.1824488],
['FFRK','Frankenberg(Eder)',8000104,8.789181,51.054565],
['DFK','Frankenberg(Sachs)',8011553,13.043191,50.911233],
['DFKS','Frankenberg(Sachs) Süd',8011554,13.036378,50.902784],
['FFRG','Frankenberg-Goßberg',8002033,8.799326,51.064998],
['FVI','Frankenberg-Viermünden',8006082,8.83307,51.100937],
['XAFA','Frankenmarkt',8100018,13.4325354306175,47.9830614111769],
['RFST','Frankenstein(Pfalz)',8002036,7.969802,49.438867],
['DFRS','Frankenstein(Sachs)',8011556,13.228254,50.90252],
['RFT','Frankenthal Hbf',8000332,8.349702,49.535567],
['RFTS','Frankenthal Süd',8002025,8.349558,49.522649],
['FFT','Frankfurt Hbf (tief)',8098105,8.664137,50.107407],
['FSP','Frankfurt am Main - Stadion',8002040,8.633247,50.068228],
['FFLF','Frankfurt(M) Flughafen Fernbf',8070003,8.570185,50.053167],
['FFLU','Frankfurt(M) Flughafen Regionalbf',8070004,8.571251,50.051219],
['FFGA','Frankfurt(M)Galluswarte',8006690,8.64472,50.10403],
['FHAU','Frankfurt(M)Hauptwache',8006692,8.678947,50.113926],
['FKON','Frankfurt(M)Konstablerwache',8004429,8.687098,50.114623],
['FLBF','Frankfurt(M)Lokalbahnhof',8002038,8.693025,50.102171],
['FMUL','Frankfurt(M)Mühlberg',8002034,8.701504,50.101609],
['FOST','Frankfurt(M)Ostendstraße',8002058,8.696987,50.112562],
['FSTL','Frankfurt(M)Stresemannallee',8002059,8.671248,50.094438],
['FFTA','Frankfurt(M)Taunusanlage',8006691,8.668864,50.113565],
['FSTLM','Frankfurt(Main) Stresemannallee/Mörfelder Landstr',8071169,8.671591,50.089204],
['FFGG','Frankfurt(Main)-Gateway Gardens',8002060,8.59449506,50.0565739],
['FF','Frankfurt(Main)Hbf',8000105,8.663789,50.107145],
['FFME','Frankfurt(Main)Messe',8079632,8.643374,50.112004],
['FFO','Frankfurt(Main)Ost',8002039,8.70864,50.112574],
['FFS','Frankfurt(Main)Süd',8002041,8.686457,50.099365],
['FFW','Frankfurt(Main)West',8002042,8.639335,50.118864],
['BFP','Frankfurt(Oder)',8010113,14.546496,52.336416],
['BFPN','Frankfurt(Oder)-Neuberesinchen',8011557,14.54605,52.322329],
['BFRS','Frankfurt(Oder)-Rosengarten',8011559,14.472631,52.337769],
['FFBK','Frankfurt-Berkersheim',8002043,8.697827,50.176486],
['FFES','Frankfurt-Eschersheim',8002045,8.655431,50.158583],
['FFBS','Frankfurt-Frankfurter Berg',8002044,8.676551,50.170266],
['FGM','Frankfurt-Griesheim',8002046,8.606394,50.094334],
['FHOE','Frankfurt-Höchst',8000106,8.54237,50.102634],
['FFAW','Frankfurt-Höchst Farbwerke',8002051,8.528732,50.098558],
['FLS','Frankfurt-Louisa',8002047,8.670369,50.083956],
['FFMK','Frankfurt-Mainkur',8002048,8.767437,50.134603],
['FFND','Frankfurt-Nied',8002049,8.570734,50.102519],
['FNI','Frankfurt-Niederrad',8002050,8.637075,50.081283],
['FRH','Frankfurt-Rödelheim',8002052,8.607026,50.124615],
['FSIN','Frankfurt-Sindlingen',8002053,8.512259,50.087497],
['FSO','Frankfurt-Sossenheim',8002054,8.553526,50.115074],
['FULB','Frankfurt-Unterliederbach',8007158,8.528024,50.107911],
['FFZH','Frankfurt-Zeilsheim',8002055,8.506011,50.090124],
['LFA','Frankleben',8011560,11.937582,51.309561],
['XTFNP','Frantiskov nad Ploucnici',5400961,14.331889,50.723917],
['XTF','Frantiskovy Lazne',5400197,12.355325,50.124453],
['XTFA','Frantiskovy Lazne Aquaforum',5474010,12.3589969,50.1167291],
['XAFR','Frastanz',8100069,9.63938006321662,47.2199679865559],
['RFS','Frauenalb-Schielberg',8007010,8.440492,48.837294],
['NFU','Frauenau',8002057,13.300048,48.987653],
['XSFA','Frauenfeld',8506100,8.89653893490838,47.55815997489],
['BFR','Frauenhain',8011563,13.503636,51.384223],
['KFKO','Frechen-Königsdorf',8002389,6.777846,50.936501],
['LFK','Freckleben',8011564,11.54413,51.702365],
['HFRE','Freden(Leine)',8002063,9.899006,51.927787],
['AFE','Fredenbeck',8071335,9.398353,53.517306],
['XDF','Fredericia st',8600623,9.738813,55.568088],
['BFD','Fredersdorf(b Berlin)',8080440,13.760628,52.526212],
['TFG','Freiberg(Neckar)',8002065,9.197796,48.930107],
['DFR','Freiberg(Sachs)',8010115,13.344141,50.908725],
['RFK','Freiburg Klinikum',8002077,7.842755,48.005562],
['RFMU','Freiburg Messe/Universität',8000453,7.832668,48.012918],
['RF','Freiburg(Breisgau) Hbf',8000107,7.84117,47.997697],
['RFHE','Freiburg-Herdern',8002067,7.850973,48.008237],
['RFLW','Freiburg-Landwasser',8002066,7.812882,48.027326],
['RFLT','Freiburg-Littenweiler',8002068,7.895133,47.981672],
['RFSG','Freiburg-St Georgen',8002069,7.803006,47.975496],
['RFWI','Freiburg-Wiehre',8002070,7.854127,47.982413],
['RFZ','Freiburg-Zähringen',8002071,7.863734,48.024363],
['XSFB','Freienbach SBB',8503210,8.75619939808426,47.2073074881608],
['EFRE','Freienohl',8002073,8.169484,51.366422],
['UFO','Freienorla',8011567,11.540139,50.771382],
['MFHD','Freihalden',8002074,10.5022,48.384704],
['NFRE','Freihung',8002076,11.902879,49.627221],
['NFR','Freihöls',8002075,12.020316,49.40137],
['MFL','Freilassing',8000108,12.977193,47.836916],
['MFLH','Freilassing-Hofham',8002085,12.968067,47.831449],
['FFRH','Freimersheim(Rheinh)',8000340,8.086508,49.710777],
['RFHM','Freinsheim',8000374,8.205192,49.501493],
['MFR','Freising',8002078,11.744539,48.395195],
['OAFRS','Freistadt',8100239,14.481613,48.495249],
['DFCO','Freital-Coßmannsdorf',8011568,13.624952,50.976876],
['DFD','Freital-Deuben',8011569,13.646432,50.999358],
['DFH','Freital-Hainsberg',8010116,13.637938,50.988898],
['DHGW','Freital-Hainsberg West',8011570,13.622714,50.981083],
['DPA','Freital-Potschappel',8013445,13.662552,51.013894],
['HFST','Frellstedt',8002080,10.909994,52.213749],
['AFF','Frelsdorf',8007804,8.901283,53.501305],
['MFRD','Fremdingen Bf',8070392,10.460287,48.971278],
['SFF','Fremersdorf',8002083,6.647867,49.410083],
['XSFF','Frenkendorf-Füllinsdorf',8500022,7.71909156777492,47.5014570470392],
['LFZ','Frenz',8011571,11.898933,51.749194],
['AFN','Fresenburg',8002086,10.390584,53.842599],
['WFD','Fretzdorf',8011572,12.539885,53.069302],
['NFM','Freudenberg-Kirschfurt',8002089,9.317981,49.743755],
['TFS','Freudenstadt Hbf',8000110,8.428803,48.460322],
['TFSI','Freudenstadt Industriegebiet',8002087,8.434941,48.464967],
['TFSZ','Freudenstadt Schulzentrum',8002090,8.421419,48.467406],
['TFSS','Freudenstadt Stadt',8002091,8.410694,48.467566],
['EFBU','Freusburg Siedlung',8002092,7.897253,50.815983],
['UFB B','Freyburg(Unstrut)',8011573,11.767313,51.209079],
['NFY','Freyung Bf',8002094,13.548351,48.802843],
['XSF','Fribourg/Freiburg',8504100,7.1510232451879,46.8032670641571],
['TFKH','Frickenhausen',8007446,9.35801,48.595369],
['TFKHK','Frickenhausen Kelterstraße',8090022,9.364479,48.592057],
['FFRN','Frickhofen',8002095,8.030676,50.504908],
['TFD','Fridingen(b Tuttlingen)',8002096,8.93606,48.031822],
['MFDF','Fridolfing',8002097,12.799689,47.984203],
['FGS','Friedberg Süd',8002105,8.747646,50.320279],
['MFDB','Friedberg(Augsburg)',8002099,10.982487,48.352043],
['FFG','Friedberg(Hess)',8000111,8.762056,50.332606],
['XAFI','Friedburg',8100241,13.234567,47.996725],
['FFN','Friedelhausen',8002100,8.710961,50.671607],
['FFRD','Friedensdorf(Lahn)',8002101,8.560747,50.857459],
['BFDF','Friedersdorf(Königs Wusterhausen)',8011574,13.786518,52.289563],
['DFW','Friedewald(Kr Dresden) Bad',8011575,13.662422,51.137948],
['DFWH','Friedewald(Kr Dresden)Hp',8011576,13.651873,51.131301],
['HFRI','Friedland(Han)',8002102,9.914746,51.421562],
['KFWH','Friedrich Wilhelmshütte',8002104,7.159382,50.802044],
['UFR','Friedrichroda',8011578,10.576685,50.862151],
['FFRI','Friedrichsdorf(Taunus)',8002108,8.644776,50.25249],
['EFFD','Friedrichsfeld(Niederrhein)',8002109,6.645499,51.628486],
['AFRG','Friedrichsgabe',8079024,9.98886,53.728876],
['TFFL','Friedrichshafen Flughafen',8002120,9.523714,47.672213],
['TFH','Friedrichshafen Hafen',8002110,9.482819,47.651208],
['TFLA','Friedrichshafen Landratsamt',8002122,9.451988,47.657146],
['TFOS','Friedrichshafen Ost',8002030,9.502018,47.651706],
['TF','Friedrichshafen Stadt',8000112,9.4739,47.653224],
['TFF','Friedrichshafen-Fischbach',8002111,9.417383,47.672481],
['TKLU','Friedrichshafen-Kluftern',8003345,9.409515,47.688149],
['TMAN','Friedrichshafen-Manzell',8003850,9.429156,47.66432],
['LFH','Friedrichshöhe',8017009,10.937618,51.639626],
['FKFPL','Friedrichsplatz, Kassel',712894,9.495328,51.314184],
['WFRR','Friedrichsruhe(Meck)',8011582,11.739088,53.524802],
['KFGN','Friedrichssegen',8002114,7.65084,50.312619],
['AFD','Friedrichstadt',8002115,9.079258,54.377487],
['PQSFM','Friedrichstal Mitte, Stutensee',721299,8.475259,49.104299],
['PQSFN','Friedrichstal Nord, Stutensee',721297,8.47671,49.109261],
['PQSFP','Friedrichstal Saint-Riquier-Platz, Stutensee',721301,8.474331,49.100986],
['RFRT','Friedrichstal b Freudenstadt',8002126,8.376926,48.481805],
['RFTL','Friedrichstal(Baden)',8002116,8.474278,49.101299],
['SFI','Friedrichsthal(Saar)',8002117,7.08913,49.320061],
['SFIM','Friedrichsthal(Saar) Mitte',8002132,7.093916,49.32716],
['NFSB','Friedrichsthal(b Bayreuth)',8002118,11.627833,49.962598],
['WFL','Friedrichswalde(bei Eberswalde)',8011583,13.703148,53.030373],
['XAF','Friesach in Kärnten',8100076,14.409604,46.954145],
['WFRK','Friesack(Mark)',8011585,12.587542,52.760712],
['LFI','Friesdorf',8011586,11.301957,51.589392],
['LFIO','Friesdorf Ost',8011587,11.323154,51.59775],
['RFH','Friesenheim(Baden)',8002123,7.862948,48.381589],
['KFRI','Frimmersdorf',8002127,6.566475,51.045701],
['XDFV','Frisvadvej st',8600639,8.487159,55.627596],
['XAFW','Fritzens-Wattens',8100104,11.5888481867361,47.3021302656662],
['FFZ','Fritzlar',8002129,9.282089,51.125223],
['LFB','Frohburg',8011588,12.559288,51.069159],
['TFR','Frommern',8002133,8.872122,48.244034],
['FFRL','Fronhausen(Lahn)',8002134,8.698651,50.706333],
['XFFX','Frontenex',8702402,6.313547,45.630373],
['OFFTG','Frontignan',8701164,3.759136,43.44581],
['LFE','Frose',8010119,11.374843,51.793636],
['XFFD','Frouard',8701112,6.144596,48.755437],
['XBFY','Froyennes',8800395,3.357327,50.628704],
['XSFR','Frutigen',8507478,7.65159707977157,46.5887749340942],
['EFRM','Frömern',8002130,7.735929,51.499263],
['EFOE','Fröndenberg',8000113,7.762198,51.471254],
['UFT','Fröttstädt',8010118,10.573019,50.930357],
['FFU','Fulda',8000115,9.683977,50.554723],
['FIH','Fuldatal-Ihringshausen',8003053,9.52607,51.348591],
['RFU','Furschenbach',8007005,8.135178,48.579767],
['XAFH','Furth b.Mattighofen',8100814,13.139928,48.13186],
['NFW','Furth im Wald',8002159,12.838811,49.309812],
['MFU','Furth(b Deisenhofen)',8002161,11.593281,48.035521],
['XFFU','Futuroscope',8703726,0.378155,46.669726],
['DFBE','Fährbrücke',8011524,12.619722,50.650124],
['XAFC','Föderlach',8100797,13.9591668182638,46.602068203287],
['SFOE','Föhren',8002018,6.767531,49.857099],
['NFOE','Förbau',8002019,11.910685,50.207519],
['LFD','Förderstedt',8011549,11.633757,51.903517],
['UF','Förtha(Eisenach)',8010110,10.262007,50.938853],
['NFDF','Förtschendorf',8002020,11.350128,50.392901],
['FFUR','Fürfurt',8002137,8.253138,50.430492],
['XAFU','Fürnitz',8100368,13.813345,46.563241],
['WF','Fürstenberg(Havel)',8010399,13.139273,53.186784],
['NFUE','Fürsteneck',8070809,13.469922,48.718431],
['MFB','Fürstenfeldbruck',8002141,11.262148,48.171656],
['FFNW','Fürstenwald',8002145,9.359567,51.380359],
['BFUS','Fürstenwalde Süd',8011591,14.086609,52.341895],
['BFUW','Fürstenwalde(Spree)',8010120,14.05964,52.366858],
['MFZL','Fürstenzell',8002146,13.333817,48.51318],
['NFWS','Fürth Westvorstadt',8002149,10.971395,49.468799],
['NF','Fürth(Bay)Hbf',8000114,10.989988,49.469707],
['RFUE','Fürth(Odenw)',8002150,8.781003,49.648534],
['NFBB','Fürth-Burgfarrnbach',8002152,10.923627,49.491033],
['NFDB','Fürth-Dambach',8002153,10.970196,49.46074],
['NFKL','Fürth-Klinikum',8002154,10.967191,49.483188],
['NFUF','Fürth-Unterfürberg',8002155,10.957532,49.474914],
['MFSN','Füssen',8002156,10.697813,47.570497],
['PNAAS','Gaanderen',8400034,5.8788890838623,51.93074],
['MGAL','Gablingen',8002162,10.850752,48.463417],
['WGA','Gadebusch',8011592,11.121485,53.704066],
['RGG','Gaggenau Bf',8002167,8.319977,48.805772],
['RDAI','Gaggenau Mercedes-Benz Werk',8006733,8.327476,48.798038],
['XFGN','Gagny',8703361,2.525453,48.883716],
['TGAW','Gaildorf West',8002168,9.753892,49.003822],
['XFGAA','Gaillon Aubevoye',8703364,1.352742,49.174641],
['MGH','Gaimersheim',8002171,11.36979,48.798789],
['MGAI','Gaißach',8002173,11.575401,47.737467],
['XIGA','Gallarate',8300058,8.798832,45.660455],
['WGAL','Gallin',8011593,12.129379,53.516641],
['TGAM','Gamburg(Tauber)',8002177,9.59558,49.698297],
['TGMT','Gammertingen',8007229,9.217149,48.250699],
['TGME','Gammertingen Europastraße',8070382,9.210452,48.242944],
['XSGM','Gampel-Steg',8501603,7.74757569359257,46.3065139346823],
['HGKE','Ganderkesee',8002179,8.542777,53.035251],
['XFGD','Gandrange-Amneville',8700344,6.135784,49.260882],
['UGSM','Gangloffsömmern',8011594,10.954856,51.191473],
['XFGAN','Gannat',8700026,3.204888,46.09706],
['WGLN','Ganzlin',8011595,12.247136,53.382455],
['EGAR','Garbeck',8002180,7.839903,51.321459],
['FGA','Garbenteich',8002182,8.745273,50.540288],
['MGA','Garching(Alz)',8002184,12.57299,48.130371],
['XFGA','Gardanne',8700345,5.463566,43.456084],
['LGA','Gardelegen',8011596,11.404536,52.518376],
['AGD','Garding',8002185,8.783783,54.327014],
['WGFZ','Garftitz',8011597,13.637847,54.37771],
['MGP','Garmisch-Partenkirchen',8002187,11.097013,47.491452],
['MGPH','Garmisch-Partenkirchen Hausberg',8002188,11.092343,47.483487],
['MGS','Gars(Inn)',8002189,12.29855,48.14754],
['LGAL','Gatersleben',8011599,11.291362,51.828111],
['OAGTX','Gattendorf',8100332,16.980974,48.010595],
['FGAL','Gau Algesheim',8000375,8.016065,49.961432],
['FGBM','Gau Bickelheim',8002191,8.020291,49.840292],
['TGRN','Gaubüttelbrunn',8002195,9.854584,49.634319],
['RGBA','Gausbach',8002197,8.362372,48.686753],
['TGSF','Gauselfingen',8007227,9.164219,48.275821],
['MGT','Gauting',8002198,11.376146,48.070658],
['XPG','Gdansk Glowny',5100009,18.643803,54.35552],
['XPGOL','Gdansk Oliwa',5101104,18.571742,54.409892],
['XPGWR','Gdansk Wrzeszcz',5101307,18.605435,54.38186],
['XPGD','Gdynia Glowna',5100010,18.529556,54.52084],
['UGEB','Gebersdorf',8011601,11.269547,50.527357],
['UGBH','Gebra(Hainleite)',8011602,10.595388,51.427155],
['HGEE','Geeste',8002203,7.312044,52.598094],
['AGTH','Geestenseth',8007805,8.858373,53.506732],
['LGG','Geestgottberg',8010121,11.736957,52.955743],
['UGB','Gehlberg',8011603,10.769351,50.683768],
['NGET','Geigant',8002205,12.681424,49.323354],
['KGEK','Geilenkirchen',8002206,6.124518,50.961039],
['KGEH','Geilhausen',8002207,7.638667,50.77157],
['XAGEI','Geinberg',8100830,13.2914355675837,48.2663379343501],
['MGLG','Geiselhöring',8002209,12.392077,48.822392],
['MGIB','Geisenbrunn',8002210,11.324847,48.109157],
['MGHS','Geisenhausen',8002211,12.248327,48.47396],
['FGSM','Geisenheim',8002212,7.968804,49.985973],
['DGEI','Geising',8011609,13.786064,50.760699],
['RGSN','Geisingen',8002214,8.653951,47.921342],
['RGA','Geisingen-Aulfingen',8002200,8.661611,47.886408],
['RGHA','Geisingen-Hausen',8002204,8.678602,47.912445],
['RGK','Geisingen-Kirchen',8002213,8.674345,47.905062],
['RGL','Geisingen-Leipferdingen',8002215,8.654687,47.869173],
['TG','Geislingen(Steige)',8002218,9.841941,48.619358],
['TGW','Geislingen(Steige)West',8002217,9.821909,48.630766],
['MGEU','Geitau',8002220,11.966403,47.693887],
['LGH','Geithain',8010122,12.697455,51.058217],
['WGE','Gelbensande',8011611,12.304809,54.198696],
['XNGM','Geldermalsen',8400244,5.27127,51.88301],
['KGE','Geldern',8002222,6.319336,51.513289],
['ONGL','Geldrop',8400245,5.8742952346802,51.419723510742],
['ONLUO','Geleen Oost',8400246,5.8722224235535,50.966945648193],
['XNLU','Geleen-Lutterade',8400248,5.8674998283386,50.975555419922],
['FGEL','Gelnhausen',8000117,9.189278,50.196343],
['EG','Gelsenkirchen Hbf',8000118,7.102455,51.504903],
['EGZO','Gelsenkirchen Zoo',8002223,7.111104,51.537686],
['EGBU','Gelsenkirchen-Buer Nord',8002224,7.050593,51.587245],
['EGBS','Gelsenkirchen-Buer Süd',8002225,7.040156,51.549085],
['EGHS','Gelsenkirchen-Hassel',8002226,7.066571,51.610858],
['EGRO','Gelsenkirchen-Rotthausen',8002227,7.089009,51.492642],
['MGE','Geltendorf',8000119,11.037736,48.105776],
['XSGK','Gelterkinden',8500027,7.84765271264558,47.4658812395598],
['TGEM','Gemmingen',8002228,8.984648,49.151295],
['TGEW','Gemmingen West',8071001,8.977585,49.154442],
['XIGF','Gemona del Friuli',8300090,13.12758,46.272094],
['NGM','Gemünden(Main)',8000120,9.699894,50.050018],
['MGKG','Genderkingen',8002233,10.885159,48.69584],
['MGND','Gendorf',8002234,12.721098,48.179484],
['RGB','Gengenbach',8002235,8.010192,48.404659],
['XBGK','Genk',8800111,5.496256,50.967012],
['SGN','Gennweiler',8002238,7.049984,49.369979],
['XIGP','Genova Piazza Principe',8300153,8.922075,44.417504],
['FGHO','Gensingen-Horrweiler',8000121,7.938188,49.89826],
['XBGP','Gent St Pieters',8800031,3.710612,51.035627],
['XBGD','Gent-Dampoort',8800058,3.740609,51.055852],
['XBGB','Gentbrugge',8800328,3.756088,51.038809],
['LGN','Genthin',8010123,12.157103,52.40322],
['XSGE','Genève',8501008,6.14245302874705,46.2102022668662],
['XSGEA','Genève-Aéroport',8501026,6.11198571992426,46.2325293452194],
['NGE','Georgensgmünd',8002237,11.016614,49.183836],
['UG','Gera Hbf',8010125,12.077092,50.883421],
['UGS','Gera Süd',8010126,12.076443,50.871159],
['UGLB','Gera-Langenberg',8011619,12.0472,50.916971],
['UGZ','Gera-Zwötzen',8011623,12.082181,50.85005],
['UGBG','Geraberg',8011624,10.857196,50.715593],
['TGES','Geradstetten',8002240,9.439753,48.805203],
['TGEH','Gerhausen',8002242,9.806227,48.39972],
['LGE','Gerichshain',8011626,12.587444,51.35388],
['TGLH','Gerlachsheim',8002243,9.710612,49.580886],
['XSGF','Gerlafingen',8508088,7.56518564421974,47.1697445506728],
['MGLH','Gerlenhofen',8002244,10.037282,48.351332],
['XAGE','Gerling im Pinzgau',8100879,12.827396782071,47.3902970910069],
['MUG','Germering-Unterpfaffenhofen',8006006,11.364023,48.12887],
['RGE','Germersheim',8000376,8.36487,49.225638],
['RGEM','Germersheim Mitte/Rhein',8002239,8.379305,49.219876],
['RGES','Germersheim Süd/Nolte',8002241,8.373755,49.208341],
['MGLD','Gernlinden',8002247,11.300378,48.212765],
['LGDE','Gernrode(Harz)',8010127,11.149083,51.729765],
['UNDO','Gernrode-Niederorschel',8012492,10.416533,51.383224],
['RGS','Gernsbach Bf',8002248,8.336714,48.768307],
['RGSD','Gernsbach Mitte',8002250,8.339042,48.763086],
['FGHM','Gernsheim',8002249,8.4902,49.753598],
['TGN','Geroldshausen',8002251,9.903994,49.686941],
['SGR','Gerolstein',8000123,6.660372,50.224006],
['OSG','Gerra (Gambarogno)',8505410,8.784969,46.122043],
['DGD','Gersdorf(Görlitz)',8011628,14.85425,51.125212],
['FGFD','Gersfeld(Rhön)',8002254,9.914847,50.449413],
['TGSN','Gerstetten',8007075,10.022662,48.624836],
['MGHF','Gersthofen',8002256,10.861193,48.42302],
['UGT','Gerstungen',8011629,10.065041,50.964665],
['FGTB','Gertenbach',8002259,9.804709,51.379732],
['LGWS','Gerwisch',8011630,11.742095,52.177587],
['EGK','Geseke',8002262,8.510292,51.64523],
['MGHN','Gessertshausen',8002263,10.732382,48.333715],
['FGGB','Gettenau-Bingenheim',8002265,8.885796,50.379191],
['AGF','Gettorf',8002266,9.978678,54.409893],
['EGVH','Gevelsberg Hbf',8002267,7.33976,51.324399],
['KGVW','Gevelsberg West',8002268,7.313845,51.317276],
['KGVK','Gevelsberg-Kipp',8002509,7.327172,51.31993],
['EGVA','Gevelsberg-Knapp',8001943,7.377884,51.336964],
['XFGE','Gevrey-Chambertin',8700346,4.999421,47.228078],
['TGB','Giengen(Brenz)',8002272,10.236994,48.620023],
['LGI','Giersleben',8011632,11.568659,51.764836],
['FG','Gießen',8000124,8.661462,50.579059],
['FEKW','Gießen Erdkauter Weg',8001826,8.683241,50.571304],
['FLST','Gießen Licher Str',8003674,8.697242,50.581667],
['FGOG','Gießen Oswaldsgarten',8002269,8.669138,50.588355],
['XAGB','Gießenbach in Tirol',8100549,11.236703,47.374382],
['HGI','Gifhorn',8000185,10.545284,52.456155],
['HGIS','Gifhorn Stadt',8002274,10.54294,52.479774],
['MGCH','Gilching-Argelsried',8002275,11.299598,48.105674],
['WGIH','Gildenhall',8011633,12.839423,52.933488],
['ONGR','Gilze-Rijen',8400251,5.8630557060242,51.583610534668],
['TGI','Gingen(Fils)',8002278,9.787826,48.661039],
['FGIR','Girod',8002280,7.902936,50.454329],
['XEG','Girona',7100077,2.816485,41.979518],
['XSGNR','Gisikon-Root',8502201,8.39477668628634,47.1213263146294],
['XFGI','Gisors Embranchement',8703408,1.785277,49.285202],
['HGT','Gittelde/Bad Grund(Harz)',8002281,10.203025,51.787337],
['XSGI','Giubiasco',8505214,9.00358391238064,46.1738183581836],
['XDGJ','Gjesing st',8602940,8.457369,55.509644],
['EGBO','Gladbeck Ost',8002283,6.994813,51.575531],
['EGBW','Gladbeck West',8000125,6.976389,51.574922],
['EZK','Gladbeck-Zweckel',8002284,6.984424,51.59027],
['SGM','Glan-Münchweiler',8002286,7.444848,49.470176],
['XNGB','Glanerbrug',8400011,5.859686,52.218612670898],
['NGLW','Glanzstoffwerke',8002287,9.152194,49.828571],
['DGHU','Glashütte(Sachs)',8011636,13.782378,50.851102],
['XSG','Glattbrugg',8503310,8.55883224275894,47.430825476898],
['XSGA','Glattfelden',8503401,8.52403632787533,47.548557192818],
['DGLA','Glaubitz(Riesa)',8011637,13.365435,51.317562],
['FGBG','Glauburg-Glauberg',8002288,8.996016,50.313752],
['FSTM','Glauburg-Stockheim',8000347,9.010123,50.327056],
['DGL','Glauchau(Sachs)',8010129,12.548646,50.828524],
['DGLS','Glauchau-Schönbörnchen',8010130,12.500671,50.821057],
['OAGL','Gleisdorf',8100195,15.70951,47.09931],
['KGL','Glesch',8002290,6.589633,50.971261],
['XAGL','Gloggnitz',8100026,15.9471829957778,47.6776610821423],
['XPGLO','Glogow',5100012,16.079715,51.668953],
['DGLO','Glossen(b Oschatz)',8070199,12.99548,51.242839],
['WGF','Glöwen',8011641,12.083928,52.903512],
['UGL','Glückauf',8011643,10.828367,51.389701],
['AGST','Glückstadt',8002293,9.42832,53.788606],
['MGMD','Gmund(Tegernsee)',8007631,11.735296,47.749642],
['XAGN','Gmünd NÖ',8100129,14.985175,48.764237],
['LGND','Gnadau',8010084,11.78115,51.979599],
['AGNB','Gnarrenburg',8007114,9.008099,53.381236],
['AGNBN','Gnarrenburg Nord',8070036,9.015403,53.393287],
['WGNV','Gnevkow',8011646,13.17467,53.792896],
['OAGNI','Gniebing',8100857,15.852711,46.961986],
['XPGN','Gniezno',5100013,17.602184,52.529651],
['KGO','Goch',8002296,6.160862,51.681824],
['RGOM','Gochsheim(Baden)',8007143,8.744695,49.109411],
['RGOR','Godramstein',8002300,8.076028,49.20685],
['XLGB','Goebelsmühle',8270480,6.054827,49.92064],
['ONG','Goes',8400253,3.890271,51.498302],
['AGK','Gokels',8002319,9.470081,54.118755],
['LGM','Goldbeck(Osterburg)',8011665,11.858149,52.71606],
['TGOL','Goldberg(Württ)',8005201,9.02043,48.69691],
['HGOL','Goldenstedt(Oldb)',8002320,8.394579,52.800611],
['FGDH','Goldhausen',8002321,7.873064,50.46142],
['TGL','Goldshöfe',8000380,10.128254,48.894221],
['OFGOF','Golfe-Juan-Vallauris',8700536,7.073288,43.566239],
['XAGA','Golling-Abtenau',8100041,13.1641458364658,47.6007900299525],
['BGM','Gollmitz(Niederlausitz)',8011667,13.883834,51.703335],
['BGOL','Golm',8013481,12.971864,52.409774],
['WGOL','Golzow(Eberswalde)',8011671,13.826975,52.914013],
['BGZ','Golzow(Oderbruch)',8011672,14.51181,52.562531],
['BGO','Golßen(Niederlausitz)',8011668,13.574773,51.974272],
['TGOM','Gomadingen',8070400,9.392136,48.399121],
['LGO','Gommern',8011673,11.83878,52.074002],
['RGOS','Gondelsheim Schlossstadion',8070011,8.662867,49.065737],
['RGO','Gondelsheim(Baden)',8002326,8.660281,49.059704],
['ONGO','Goor',8400254,5.8550000190735,52.230278015137],
['XSGO','Goppenstein',8507474,7.75501848804404,46.3677451313466],
['OSGOL','Gordola',8505402,8.865575,46.17907],
['BGOR','Gorgast',8011674,14.550644,52.56313],
['ONGN','Gorinchem',8400256,5.8522224426269,51.833889007568],
['NGG','Gosberg',8002329,11.10948,49.7047],
['HGS','Goslar',8000130,10.421436,51.911573],
['XSGG','Gossau SG',8506210,9.25303263655039,47.4118296551444],
['UGO','Gotha',8010136,10.712568,50.93907],
['UGOS','Gotha Ost',8011678,10.720869,50.961881],
['RGH','Gottenheim',8002334,7.727832,48.051653],
['RKDG','Gottesauer Platz/BGV, Karlsruhe',723616,8.424661,49.007582],
['NGZ','Gotteszell',8002335,12.983435,48.958131],
['XSGL','Gottlieben (Schifflände)',8506163,9.13467870405456,47.6646656888434],
['RG','Gottmadingen',8002337,8.77543,47.737401],
['XNG','Gouda',8400258,5.8519444465637,52.017501831055],
['ONGG','Gouda Goverwelle',8400257,5.850529,52.014999389648],
['XBGY','Gouvy',8800060,5.953735,50.189724],
['DKH','Goßdorf-Kohlmühle',8011676,14.164655,50.94117],
['FGOF','Goßfelden',8002332,8.738249,50.868414],
['NGOD','Goßmannsdorf',8002333,10.025594,49.684959],
['WGM','Graal-Müritz',8012583,12.245387,54.248777],
['WGMW','Graal-Müritz Koppelweg',8012584,12.237167,54.24589],
['MGRL','Graben(Lechfeld)Gewerbepark',8002346,10.852411,48.199148],
['RGN','Graben-Neudorf',8000131,8.49063,49.161797],
['RGNN','Graben-Neudorf Nord',8002345,8.494096,49.177958],
['WGRB','Grabow(Meckl)',8011681,11.564201,53.282902],
['MGRA','Grafenaschau',8002343,11.1374,47.667029],
['NGFU','Grafenau',8002344,13.393327,48.856168],
['NGFW','Grafenwiesen',8007339,12.877825,49.202635],
['XFGR','Graffenstaden',8701209,7.689849,48.532432],
['MGB','Grafing Bahnhof',8002347,11.940423,48.043226],
['MGRS','Grafing Stadt',8002348,11.962758,48.047217],
['NGFA','Grafling-Arzting',8002349,12.973322,48.889645],
['MGF','Grafrath',8002351,11.153259,48.132096],
['XAGR','Gramatneusiedl',8100369,16.493428105458,48.0345849861369],
['WGR','Grambow',8011689,14.347457,53.417381],
['ONGRA','Gramsbergen',8400259,5.843611240387,52.60916519165],
['WGRA','Gransee',8011691,13.16712,53.001076],
['PFAGT','Grasse',8705486,6.926413,43.653856],
['XAGG','Gratwein-Gratkorn',8100370,15.3227744230686,47.1294040781779],
['DGFL','Grauschwitz Flocke',8070660,13.067876,51.237291],
['PALVO','Graz Don Bosco (Bahnsteige 1-2)',8103490,15.419107,47.058449],
['XAG','Graz Hbf',8100173,15.416437,47.072297],
['XAGO','Graz Ostbahnhof-Messe',8100371,15.448298,47.053395],
['OAGLM','Graz-Liebenau Murpark',8103487,15.462831,47.039949],
['FGSN','Grebenstein',8002358,9.420533,51.447238],
['XDGB','Gredstedbro st',8600771,8.741062,55.397424],
['WGW','Greifswald',8010139,13.370262,54.092923],
['WGWS','Greifswald Süd',8011694,13.396656,54.076443],
['UGR','Greiz',8010140,12.194522,50.653287],
['UGRD','Greiz-Dölau',8011697,12.184776,50.630029],
['XSGRN','Grenchen Nord',8500159,7.3894630218879,47.1918033633749],
['XFG','Grenoble',8700034,5.714167,45.191187],
['RGRZ','Grenzach',8002365,7.659506,47.5509],
['LGPN','Greppin',8011699,12.297969,51.645358],
['XFGS','Gresy-sur-Isere',8702403,6.258875,45.594431],
['XFGZ','Gretz-Armainvilliers',8701175,2.728546,48.745446],
['UGN','Greußen',8011700,10.941303,51.22934],
['EGRV','Greven',8002369,7.599341,52.089829],
['KGRB','Grevenbroich',8000133,6.580447,51.093701],
['WGV','Grevesmühlen',8010141,11.184712,53.857468],
['WGBN','Grieben(Meckl)',8011702,11.068569,53.851233],
['LGB','Griebo',8011703,12.522977,51.880576],
['UGRI','Griefstedt',8084070,11.136471,51.230229],
['XAGRB','Gries am Brenner',8100258,11.485266,47.041275],
['XAGI','Gries im Pinzgau',8100892,12.8905971669744,47.2880108582432],
['MGRI','Griesen(Oberbay)',8017041,10.94612,47.478217],
['XAGP','Grieskirchen-Gallspach',8100022,13.8389947493261,48.2310410779956],
['OAGWT','Grieswirt',8100907,12.467751,47.509456],
['RGSS','Grießen(Baden)',8002373,8.396003,47.628432],
['ONGI','Grijpskerk',8400267,5.8430557250977,53.255740325573],
['LGRI','Grimma ob Bf',8011705,12.714131,51.230076],
['WGI','Grimmen',8011707,13.034025,54.109739],
['UGM','Grimmenthal',8010142,10.450512,50.532953],
['DGO','Grobau',8011709,11.943905,50.432302],
['XBGR','Groenendaal',8800527,4.449228,50.766157],
['RGM','Grombach',8002380,8.996902,49.226145],
['EGRN','Gronau(Westf)',8000382,7.022436,52.215107],
['XNGR','Groningen',8400263,6.5647220611572,53.210556030273],
['PNABA','Groningen Europapark',8400042,5.8400001525879,53.20480027],
['ONGRN','Groningen Noord',8400264,6.5563172,53.2301469],
['MGDF','Gronsdorf',8002383,11.698619,48.118401],
['ONGRI','Grou-Jirnsum',8400266,5.8247222900391,53.088890075684],
['LGRL','Groß Ammensleben',8011714,11.525417,52.235646],
['LGBZ','Groß Behnitz',8011715,12.75628402,52.58608985],
['WGB','Groß Brütz',8011718,11.251439,53.653088],
['HGDN','Groß Düngen',8002405,10.020077,52.09773],
['FGER','Groß Gerau',8000136,8.486215,49.924934],
['FDG','Groß Gerau-Dornberg',8002386,8.494709,49.912279],
['FDOH','Groß Gerau-Dornheim',8001511,8.493656,49.877507],
['FGKA','Groß Karben',8002388,8.753528,50.23184],
['WGKW','Groß Kiesow',8011723,13.480617,54.013721],
['LGZ','Groß Kreutz',8011725,12.776335,52.410761],
['BTPI','Groß Köris',8013109,13.650807,52.159607],
['WGLS','Groß Laasch',8011726,11.534139,53.346481],
['WGLI','Groß Lüsewitz',8011729,12.339221,54.073407],
['WGP','Groß Pankow',8011730,12.047421,53.123014],
['WGQ','Groß Quassow',8011731,13.003845,53.314823],
['FGRO','Groß Rohrheim',8002391,8.476857,49.714066],
['WGS','Groß Schwaß',8011735,12.04612,54.077026],
['BGSK','Groß Schönebeck',8011734,13.537516,52.904287],
['FKLU','Groß-Umstadt Klein-Umstadt',8003315,8.938635,49.894367],
['FGRU','Groß-Umstadt Mitte',8002393,8.924171,49.865213],
['FWH','Groß-Umstadt Wiebelsbach',8000384,8.940854,49.833425],
['NGRS','Großarmschlag',8002399,13.375921,48.885723],
['FGAU','Großauheim(Kr Hanau)',8002400,8.943902,50.107054],
['BGSBS','Großbeeren',8011740,13.28477,52.350673],
['UGBD','Großbodungen',8011741,10.48139,51.478035],
['DGR','Großbothen',8010144,12.759033,51.184455],
['HGBW','Großburgwedel',8002403,9.858535,52.50682],
['LGD','Großdeuben',8011745,12.383193,51.232352],
['FGRB','Großen Buseck',8002409,8.782999,50.60574],
['FGL','Großen Linden',8002410,8.661998,50.527851],
['AGSA','Großenaspe',8007060,9.969829,53.980974],
['AGRO','Großenbrode',8002411,11.080779,54.36631],
['UGG','Großengottern',8011746,10.556041,51.144503],
['DGC','Großenhain Cottb Bf',8011749,13.523916,51.291636],
['HGRK','Großenkneten',8002412,8.241136,52.945057],
['FGLR','Großenlüder',8002413,9.550001,50.592936],
['UGFA','Großfurra',8011750,10.802815,51.398882],
['NGRG','Großgeschaidt',8002416,11.172204,49.565031],
['DGRT','Großharthau',8011751,14.087646,51.102124],
['MGHD','Großhelfendorf',8002420,11.78126,47.94606],
['UGH','Großheringen',8010145,11.657745,51.105981],
['MGOI','Großhesselohe Isartalbf',8002422,11.530945,48.071068],
['MGK','Großkarolinenfeld',8002424,12.084824,47.888827],
['LGC','Großkorbetha',8010146,12.022171,51.267318],
['FGK','Großkrotzenburg',8002425,8.982792,50.087726],
['LGKL','Großkugel',8011752,12.164411,51.41872],
['LGL','Großlehna',8011753,12.168818,51.304806],
['UGNH','Großneuhausen',8011754,11.286163,51.164516],
['LGP','Großpösna',8011755,12.488839,51.266709],
['UGRU','Großrudestedt',8011759,11.091093,51.09565],
['BGR','Großräschen',8011756,14.014898,51.591488],
['DGRF','Großröhrsdorf',8011758,14.017557,51.148743],
['UGC','Großschwabhausen',8011762,11.481934,50.936958],
['DGAU','Großschönau(Sachs)',8011761,14.66545,50.892556],
['LGS','Großsteinberg',8011763,12.637415,51.250586],
['NGRW','Großwalbur',8002432,10.849282,50.32719],
['OAGWE','Großweikersdorf',8100906,15.976339,48.468946],
['LGWU','Großwudicke',8011766,12.231128,52.590435],
['NGUF','Grub am Forst',8002434,11.025858,50.227523],
['MGRB','Grub(Oberbay)',8002435,11.782559,48.164523],
['NGRU','Grub(Oberpf)',8002436,12.681653,49.357856],
['TGC','Grunbach',8002448,9.420029,48.81036],
['BGRU','Grunow(Niederlausitz)',8010150,14.378843,52.165074],
['OPGR','Gryfow Sl.',5100109,15.428618,51.033946],
['MGFL','Gräfelfing',8002339,11.425571,48.119774],
['NGFG','Gräfenberg',8002340,11.250423,49.64156],
['NG','Gräfendorf',8002341,9.737162,50.118279],
['LG','Gräfenhainichen',8011683,12.460037,51.724731],
['UGD','Gräfenroda',8010137,10.833007,50.758894],
['LGRK','Gräfenstuhl-Klippmühle',8011685,11.404255,51.602127],
['UGTA','Gräfentonna',8011687,10.733617,51.089734],
['FGRK','Gräveneck',8002342,8.250757,50.451905],
['FGR','Grävenwiesbach',8000132,8.458553,50.382239],
['MGRZ','Gröbenzell',8002377,11.374107,48.194919],
['LGOH','Gröbers',8011711,12.116826,51.432502],
['XAGM','Gröbming',8100135,13.9007409940509,47.4268348520619],
['DGT','Gröditz(Riesa)',8011712,13.439542,51.411468],
['RGZ','Grötzingen',8000381,8.492941,49.005975],
['RGZK','Grötzingen Krappmühlenweg',8007861,8.512178,49.005782],
['RGZO','Grötzingen Oberausstraße',8079057,8.504049,49.00526],
['DGN','Grüna(Sachs)Hp',8011770,12.798514,50.811417],
['DGBA','Grünbach(Vogtl)',8011773,12.372815,50.439895],
['FGRG','Grünberg(Oberhess)',8002439,8.959931,50.596589],
['EGNO','Grünebach Ort',8002441,7.90235,50.777143],
['EGNH','Grünebacherhütte',8002442,7.891546,50.781656],
['WGRG','Grüneberg',8011776,13.213023,52.8678],
['DGRB','Grünhainichen-Borstendorf',8011777,13.163443,50.774622],
['TGRS','Grünsfeld',8002447,9.745447,49.604933],
['RGR','Grünstadt',8000137,8.167962,49.564384],
['RGRN','Grünstadt Nord',8002444,8.170781,49.573355],
['TGRW','Grüntal-Wittlensweiler',8002445,8.460747,48.475399],
['NSDT','Gstadt(Wanderbahn)',8070669,12.944043,49.064357],
['BGU','Guben',8010357,14.706775,51.957203],
['XDGA','Guldager st',8600809,8.440325,55.535961],
['KGU','Gummersbach',8002462,7.56631,51.023632],
['KDI','Gummersbach-Dieringhausen',8000363,7.542483,50.98542],
['NGPA','Gumpenried-Asbach',8070599,13.000993,49.071832],
['MGUF','Gundelfingen(Bay)',8002466,10.377186,48.548779],
['RGDN','Gundelfingen(Breisgau)',8002465,7.874185,48.044025],
['NGD','Gundelsdorf',8002467,11.301455,50.279917],
['NGU','Gundelshausen',8002468,12.003553,48.94488],
['RGUN','Gundelsheim(Neckar)',8002470,9.15787,49.282933],
['FGUH','Gundersheim(Rheinhess)',8002473,8.196596,49.690167],
['OAGKN','Gunskirchen',8100845,13.945622,48.1323],
['FGUB','Guntersblum',8002474,8.351257,49.79198],
['OAGTD','Guntersdorf',8100894,16.054159,48.642141],
['XAGK','Guntramsdorf Kaiserau',8100372,16.324911,48.044141],
['NGUN','Gunzenhausen',8000385,10.755463,49.120444],
['XAGUR','Gurten OÖ',8100263,13.335071,48.243243],
['TGSS','Gussenstadt',8007074,9.957623,48.639901],
['KGUS','Gustorf',8002477,6.570011,51.067173],
['RGTF','Gutach Freilichtmuseum',8002480,8.198572,48.271677],
['RGTA','Gutach(Breisgau)',8002478,7.988493,48.113325],
['DGF','Gutenfürst',8011790,11.960916,50.418797],
['UGU','Guthmannshausen',8011791,11.365703,51.132368],
['FGX','Guxhagen',8002484,9.482159,51.204322],
['XMG','Györ',5500080,17.634791,47.681982],
['XAGD','Gänserndorf',8100245,16.732404474771,48.3402477290626],
['TGT','Gärtringen',8002165,8.909113,48.641122],
['TGFD','Gäufelden',8002166,8.850308,48.559661],
['FGOE','Göbelnrod',8002301,8.921448,50.597631],
['AGH','Göhrde',8002304,10.851118,53.167749],
['WGO','Göhren(Rügen)',8011651,13.737704,54.345961],
['FGLD','Göllheim-Dreisen',8070257,8.016444,49.599376],
['RGOE','Gölshausen',8002307,8.724715,49.044904],
['RGOI','Gölshausen Industriegebiet',8002306,8.739879,49.051803],
['OAGP','Göpfritz an der Wild',8100200,15.394459,48.729759],
['TGO','Göppingen',8000127,9.651969,48.700027],
['LGOR','Görden',8011654,12.503951,52.427881],
['DG','Görlitz',8010131,14.97908,51.146767],
['DGRA','Görlitz-Rauschwalde',8012869,14.93601,51.149078],
['DGWH','Görlitz-Weinhübel',8011656,14.970271,51.128664],
['UGSB','Görsbach',8011657,10.941792,51.455733],
['NGOE','Görschnitz',8002312,11.700315,49.957306],
['XSGS','Göschenen',8505119,8.5887965914315,46.6658163571858],
['WGOE','Götschendorf',8011659,13.6659193,53.0868334],
['HG','Göttingen',8000128,9.926072,51.536815],
['LGOE','Götz',8011662,12.725983,52.411224],
['XAGT','Götzendorf/Leitha',8100254,16.586341,48.025705],
['XAGZ','Götzis',8100120,9.63661815230629,47.3366191471335],
['DGZ','Gößnitz',8010134,12.429301,50.8932],
['SGD','Güdingen',8002452,7.03072943,49.19781231],
['TGU','Gültstein',8070604,8.881558,48.577494],
['MGKF','Gündlkofen',8002457,12.033642,48.526159],
['LGBG','Güntersberge',8017011,10.985669,51.644231],
['MGNZ','Günzach',8002458,10.439565,47.819599],
['MGZB','Günzburg',8000139,10.278656,48.460335],
['LGSN','Güsen(b Genthin)',8010151,11.977862,52.33489],
['LGT','Güsten',8010152,11.601857,51.793384],
['WG','Güstrow',8010153,12.172836,53.800597],
['LGK','Güterglück',8010154,11.986389,51.993474],
['EGLO','Gütersloh Hbf',8002461,8.385071,51.906941],
['XSGU','Güttingen',8506124,9.29222710394305,47.608749428579],
['XBHA','Haaltert',8800366,4.023832,50.906847],
['KHAN','Haan',8002490,6.998018,51.18812],
['KGUA','Haan-Gruiten',8000138,7.0041472,51.21378326],
['MHR','Haar',8002491,11.73115,48.111413],
['UHSN','Haarhausen',8011792,10.905715,50.867437],
['XNHE','Haarlem',8400285,4.638605,52.387973],
['XNHLS','Haarlem Spaarnwoude',8402735,4.672863,52.383065],
['OFHHM','Habsheim(Mulh)',8701261,7.4182622,47.7377069],
['KHAC','Hachenburg',8002494,7.822895,50.664001],
['FHAD','Hadamar',8002495,8.043453,50.447188],
['AHNU','Hademarschen',8002496,9.414475,54.122809],
['LHD','Hadmersleben',8011794,11.324446,52.00736],
['AHAF','Haffkrug',8002504,10.742682,54.054189],
['WHK','Hagebök',8011797,11.614882,53.96126],
['NHA','Hagelstadt',8002506,12.214829,48.895859],
['EHG','Hagen Hbf',8000142,7.460249,51.362747],
['HHGH','Hagen(Han)',8002507,9.408946,52.57369],
['AHGN','Hagen(Kr. Stade)',8071337,9.460078,53.550361],
['EHGI','Hagen-Heubing',8002512,7.423087,51.352318],
['EHGO','Hagen-Oberhagen',8002514,7.478792,51.351114],
['EHGV','Hagen-Vorhalle',8000977,7.433726,51.388224],
['EHGW','Hagen-Wehringhausen',8006712,7.452767,51.353583],
['EHWB','Hagen-Westerbauer',8004440,7.397392,51.341781],
['XAHU','Hagenau im Innkreis',8100914,13.1141042738338,48.2650965080385],
['RHGB','Hagenbach',8002515,8.253223,49.01628],
['NHBH','Hagenbüchach',8002517,10.767799,49.536347],
['WHL','Hagenow Land',8010156,11.215695,53.413582],
['WH','Hagenow Stadt',8011798,11.18499,53.429437],
['DHW','Hagenwerder',8011799,14.960228,51.070117],
['XFHD','Hagondange',8700283,6.164071,49.253403],
['PQKAH','Hagsfeld Bahnhof, Karlsruhe',378402,8.453961,49.027605],
['PQKHG','Hagsfeld Geroldsäcker, Karlsruhe',720672,8.455396,49.033105],
['PQKHJ','Hagsfeld Jenaer Straße, Karlsruhe',720555,8.456256,49.035898],
['PQKHU','Hagsfeld Reitschulschlag (Schleife), Karlsruhe',721084,8.461034,49.044108],
['PQKHL','Hagsfeld Reitschulschlag, Karlsruhe',373013,8.460884,49.043022],
['PQKHD','Hagsfeld Süd, Karlsruhe',723860,8.449639,49.024484],
['XFHG','Haguenau',8700347,7.782165,48.813365],
['NHAG','Haidenaab-Göppmannsbühl',8002523,11.820045,49.885777],
['OAHA','Haiding',8100265,13.974693,48.209994],
['THKP','Haidkapelle',8070414,9.261728,48.361157],
['FHG','Haiger',8000386,8.220657,50.741352],
['FHGO','Haiger Obertor',8002524,8.201961,50.741208],
['THGL','Haigerloch',8070415,8.801301,48.3702],
['FHME','Hailer-Meerholz',8002526,9.150665,50.189671],
['XAHM','Haiming',8100956,10.8894843569627,47.2526471696369],
['FHDT','Hainburg Hainstadt',8002531,8.938135,50.078113],
['DHND','Hainewalde',8011801,14.704463,50.906608],
['DHA','Hainichen',8011802,13.119057,50.968095],
['RHAI','Hainstadt(Baden)',8002529,9.326884,49.543058],
['FHAI','Haitz-Höchst',8002532,9.226821,50.208634],
['BHB','Halbe',8011805,13.701855,52.108384],
['LHB','Halberstadt',8010157,11.073452,51.899309],
['LHBO','Halberstadt Oststr',8011808,11.065436,51.885011],
['LHBS','Halberstadt-Spiegelsberge',8011809,11.048307,51.882581],
['RHAM','Halbmeil',8002533,8.270454,48.290749],
['LHL','Haldensleben',8010158,11.406106,52.285034],
['EHAD','Haldern(Rheinl)',8002536,6.455832,51.772558],
['HHAL','Halen',8002537,7.945044,52.339122],
['MHLF','Halfing',8070801,12.279275,47.952944],
['PNHWZ','Halfweg-Zwanenburg',8400400,4.747165,52.385935],
['FKMBS','Halitplatz, Kassel',710636,9.500013,51.326928],
['XAHT','Hall in Tirol',8100105,11.5016637136447,47.2769599967205],
['MHMO','Hallbergmoos',8002534,11.714334,48.309167],
['LDBR','Halle Dessauer Brücke',8080560,11.982535,51.500123],
['LHME','Halle Messe',8010155,12.028041,51.45476],
['LRO','Halle Rosengarten',8080570,11.982787,51.446863],
['LSBR','Halle Steintorbrücke',8080580,11.986893,51.490366],
['LSUE','Halle Südstadt',8080590,11.950925,51.447959],
['LWN','Halle Wohnstadt Nord',8080600,11.96481,51.517146],
['LZO','Halle Zoo',8080610,11.970346,51.503651],
['LHNZ','Halle Zscherbener Straße',8080620,11.921056,51.473314],
['LHHB','Halle(S) Heidebf',8011811,11.887318,51.502354],
['LH','Halle(Saale)Hbf',8010159,11.987085,51.477509],
['EHAL','Halle(Westf)',8002539,8.357729,52.057295],
['EHWS','Halle(Westf) OWL-Arena',8080630,8.343797,52.061643],
['LHAD','Halle-Ammendorf',8010162,11.987832,51.424182],
['LHN','Halle-Neustadt',8010160,11.920632,51.480056],
['LHNI','Halle-Nietleben',8011813,11.908451,51.487825],
['LHSS','Halle-Silberhöhe',8013448,11.966801,51.445546],
['LHT','Halle-Trotha',8011814,11.96217,51.523898],
['XAHL','Hallein',8100040,13.099637254899,47.685157373188],
['PANEU','Hallein Burgfried',8102049,13.114192,47.67599],
['NHAH','Hallstadt(b Bamberg)',8002542,10.885454,49.929551],
['XAHE','Hallwang-Elixhausen',8100929,13.0918470075002,47.8579325671667],
['AHKS','Halstenbek',8002545,9.839092,53.630377],
['EHLT','Haltern am See',8000145,7.184366,51.737668],
['RHL','Haltingen',8002546,7.611683,47.612837],
['EOBG','Halver-Oberbrügge',8002535,7.574042,51.191867],
['AAI','Hamburg Airport',8002547,10.006646,53.63235],
['AAW','Hamburg Alte Wöhr',8000512,10.035415,53.59793],
['ABTS','Hamburg Berliner Tor',8000908,10.02463,53.55287],
['ABWM','Hamburg Billwerder-Moorfleet',8000971,10.096658,53.515589],
['ABWD','Hamburg Burgwedel',8007046,9.908496,53.647614],
['ADF','Hamburg Dammtor',8002548,9.989566,53.560751],
['ADT','Hamburg Diebsteich',8001438,9.93426,53.568569],
['AELB','Hamburg Elbbrücken',8002551,10.0245,53.5345],
['AEGS','Hamburg Elbgaustraße',8001739,9.893738,53.602575],
['AFBG','Hamburg Friedrichsberg',8002106,10.057433,53.576328],
['AHSB','Hamburg Hasselbrook',8002628,10.056129,53.564711],
['AH','Hamburg Hbf',8002549,10.006909,53.552736],
['AHS','Hamburg Hbf (S-Bahn)',8098549,10.007921,53.552809],
['AHPS','Hamburg Hochkamp',8002873,9.842076,53.56137],
['AHCH','Hamburg Hoheneichen',8002946,10.067648,53.635478],
['AHST','Hamburg Holstenstraße',8002550,9.949741,53.561762],
['AJUS','Hamburg Jungfernstieg',8003137,9.993883,53.552194],
['AFB','Hamburg Klein Flottbek',8003312,9.861122,53.558169],
['AKWS','Hamburg Kornweg(Klein Borstel)',8003410,10.053841,53.632381],
['AKS','Hamburg Königstraße',8006706,9.944088,53.547796],
['ALAS','Hamburg Landungsbrücken',8003518,9.971281,53.546132],
['ALAN','Hamburg Landwehr',8003519,10.038021,53.561199],
['AML','Hamburg Mittlerer Landweg',8004048,10.131122,53.498172],
['ANWS','Hamburg Neuwiedenthal',8006750,9.877434,53.473059],
['ARES','Hamburg Reeperbahn',8006705,9.957668,53.549668],
['ARP','Hamburg Rübenkamp',8005207,10.033083,53.605968],
['ASHS','Hamburg Stadthausbrücke',8005663,9.984804,53.549465],
['AWCH','Hamburg Wandsbeker Chaussee',8006198,10.059975,53.569734],
['AALH','Hamburg-Allermöhe',8000779,10.158735,53.490356],
['AA','Hamburg-Altona',8002553,9.935175,53.552695],
['AAS','Hamburg-Altona(S)',8098553,9.934554,53.551855],
['ABAF','Hamburg-Bahrenfeld',8000780,9.910778,53.56006],
['ABAP','Hamburg-Barmbek',8000805,10.044164,53.587458],
['ABG','Hamburg-Bergedorf',8002554,10.206171,53.489832],
['AB','Hamburg-Blankenese',8001007,9.814607,53.564364],
['AE','Hamburg-Eidelstedt',8002555,9.907097,53.595887],
['AENZ','Hamburg-Eidelstedt Zentrum',8007044,9.901522,53.610375],
['AFIB','Hamburg-Fischbek',8002556,9.819561,53.474731],
['AHAB','Hamburg-Hammerbrook',8004266,10.02361,53.54661],
['AHAR','Hamburg-Harburg',8000147,9.991701,53.455908],
['AHRF','Hamburg-Harburg Rathaus',8004267,9.980463,53.460694],
['AHRS','Hamburg-Harburg(S)',8098147,9.991454,53.45696],
['AHFS','Hamburg-Heimfeld',8006749,9.963187,53.465481],
['AHOW','Hamburg-Hörgensweg',8002909,9.903627,53.617283],
['AIS','Hamburg-Iserbrook',8003088,9.814049,53.576606],
['ALST','Hamburg-Langenfelde',8003541,9.93092,53.579692],
['ANTB','Hamburg-Nettelnburg',8004241,10.181408,53.487888],
['ANR','Hamburg-Neugraben',8002557,9.852048,53.474143],
['AOPS','Hamburg-Ohlsdorf',8004661,10.031968,53.620873],
['AOH','Hamburg-Othmarschen',8004719,9.885967,53.559233],
['APB','Hamburg-Poppenbüttel',8004862,10.094034,53.652183],
['ARAL','Hamburg-Rahlstedt',8002558,10.154396,53.604857],
['ARI','Hamburg-Rissen',8005106,9.757057,53.583216],
['AROP','Hamburg-Rothenburgsort',8005191,10.043953,53.538476],
['ASLS','Hamburg-Schnelsen',8007045,9.906616,53.634124],
['ASTL','Hamburg-Stellingen',8002559,9.918336,53.589843],
['ASST','Hamburg-Sternschanze',8070146,9.967204,53.563719],
['ASDF','Hamburg-Sülldorf',8005785,9.797519,53.581122],
['ATK','Hamburg-Tiefstack',8005870,10.065591,53.531225],
['AOW','Hamburg-Tonndorf',8006197,10.12305,53.586385],
['AVLS','Hamburg-Veddel',8006062,10.013313,53.521703],
['AWN','Hamburg-Wandsbek',8002560,10.077224,53.569971],
['AWBS','Hamburg-Wellingsbüttel',8006319,10.082825,53.641327],
['AWFS','Hamburg-Wilhelmsburg',8002561,10.007006,53.498936],
['HHM','Hameln',8000148,9.375906,52.10185],
['EHM','Hamm(Westf)Hbf',8000149,7.807821,51.678078],
['EBCK','Hamm-Bockum-Hövel',8001045,7.774547,51.704809],
['EHE P','Hamm-Heessen',8002680,7.831551,51.709195],
['AHAM','Hammah',8002565,9.368728,53.612143],
['NHG','Hammelburg',8002567,9.882966,50.120041],
['NHGO','Hammelburg Ost',8002568,9.902111,50.115889],
['WHAM','Hammelspring',8011815,13.435744,53.070228],
['MHAU','Hammerau',8002570,12.946134,47.795883],
['RHST','Hammerstein',8070419,7.644148,47.690295],
['DHUW','Hammerunterwiesenthal',8011817,13.008722,50.441091],
['EHK','Hamminkeln',8002571,6.601745,51.735104],
['EDGD','Hamminkeln-Dingden',8001465,6.607872,51.770232],
['FH','Hanau Hbf',8000150,8.929,50.120953],
['FKAH','Hanau Klein-Auheim',8003311,8.934288,50.100734],
['FHN','Hanau Nord',8002572,8.925848,50.141433],
['FHW','Hanau West',8002573,8.908818,50.131949],
['FHWB','Hanau-Wilhelmsbad',8002574,8.88325,50.143872],
['AHAN','Handeloh',8002575,9.844711,53.241693],
['THFT','Hanfertal',8007235,9.235652,48.099767],
['KHIBM','Hangelar Mitte',8070076,7.165958,50.760201],
['BHGB','Hangelsberg',8011818,13.920916,52.400271],
['FHMD','Hann Münden',8006707,9.658272,51.412582],
['HAMI','Hannover Anderten-Misburg',8000578,9.861109,52.369161],
['HHBI','Hannover Bismarckstr.',8002580,9.769728,52.356456],
['HLGF','Hannover Flughafen',8002589,9.699105,52.458725],
['HH','Hannover Hbf',8000152,9.741021,52.376761],
['HKWA','Hannover Karl-Wiechert-Allee',8070086,9.808116,52.374417],
['HHML','Hannover Messe/Laatzen',8003487,9.792863,52.316899],
['HHBO','Hannover-Bornum',8002581,9.679538,52.350246],
['HKL','Hannover-Kleefeld',8002584,9.79061,52.373607],
['HLEG','Hannover-Ledeburg',8079097,9.691117,52.408787],
['HLEI','Hannover-Leinhausen',8002585,9.6763,52.396853],
['HLI R','Hannover-Linden/Fischerhof',8002586,9.723114,52.352636],
['HHN','Hannover-Nordstadt',8079095,9.717763,52.393845],
['HVIN','Hannover-Vinnhorst',8006089,9.707729,52.424043],
['SHN','Hanweiler-Bad Rilchingen',8002588,7.05002006,49.11882132],
['NHAP','Happurg',8002578,11.468355,49.500052],
['AHA','Harblek',8002592,8.962646,54.361971],
['MHRG','Harburg(Schwab)',8002593,10.698455,48.778898],
['XAHA','Hard-Fussach',8100267,9.688131,47.479858],
['HHRD','Hardegsen',8002594,9.826032,51.65902],
['ONH','Hardenberg',8400293,5.7936110496521,52.572776794434],
['ONHAW','Harderwijk',8400294,5.7922220230103,52.337501525879],
['NHHF','Hardhof',8002596,10.784726,49.496925],
['PNABU','Hardinxveld Blauwe Zoom',8400104,5.7888889312744,51.82944],
['ONHAG','Hardinxveld-Giessendam',8400295,5.7866668701172,51.830554962158],
['HHAR','Haren(Ems)',8002598,7.301428,52.785123],
['ONHAR','Haren(NL)',8400297,5.7852778434753,53.176109313965],
['OMHR','Haris',5500613,16.287204,46.965617],
['HHLE','Harlesiel',8002600,7.809332,53.708954],
['ONHA','Harlingen(NL)',8400296,5.7366666793823,53.1704205],
['UH','Harra',8011820,11.686006,50.418476],
['UHNO','Harra Nord',8011821,11.674692,50.42917],
['UHRS','Harras(Thür)',8011822,10.858072,50.412981],
['NH','Harsdorf',8002605,11.566273,50.027762],
['AHFD','Harsefeld',8007843,9.498657,53.450062],
['HHRS','Harsum',8002607,9.965697,52.206496],
['PAHA','Hart b. Graz',8102050,15.507363,47.041693],
['DHST','Hartenstein',8011823,12.658653,50.651833],
['NHAR','Hartershofen',8002609,10.242238,49.416762],
['MHHS','Harthaus',8002610,11.387867,48.133502],
['DHMU','Hartmannmühle',8011825,13.792418,50.778384],
['NHS','Hartmannshof',8002612,11.554562,49.498858],
['LHZG','Harzgerode',8017012,11.142641,51.64346],
['HHSB','Hasbergen',8002615,7.953967,52.241697],
['RRZB','Haselbrunn',8077771,8.975309,47.74453],
['OAHSS','Haselstauden (Dornbirn)',8100981,9.749185,47.432609],
['RHS','Haslach',8002621,8.087975,48.28004],
['NHCH','Hasloch(Main)',8002622,9.482125,49.789335],
['AHLH','Hasloh',8007048,9.919906,53.694569],
['AHLF','Haslohfurth',8079025,9.98676,53.744568],
['MHMR','Haspelmoor',8002623,11.098784,48.223263],
['SHSS','Hassel(Saar)',8002625,7.171309,49.263323],
['FHL','Hasselborn',8002627,8.495336,50.406593],
['LHAF','Hasselfelde',8017013,10.850903,51.687699],
['XBHT','Hasselt',8800114,5.327061,50.930875],
['HHAS','Haste',8002634,9.389097,52.379656],
['OAHAT','Hatlerdorf(Dornbirn)',8100921,9.724847,47.397997],
['FHAT','Hattenheim',8002635,8.0568,50.013663],
['FHAS','Hattersheim(Main)',8002637,8.489638,50.067879],
['KHAT','Hattert',8002638,7.775886,50.67613],
['XAHI','Hatting in Tirol',8100986,11.170541,47.2813],
['EHTM','Hattingen(R) Mitte',8002640,7.180538,51.397198],
['EHAT','Hattingen(Ruhr)',8002639,7.169865,51.400911],
['HHTF','Hattorf',8002641,10.235999,51.646223],
['SHZ','Hatzenport',8002643,7.413508,50.227678],
['THAU','Haubersbronn',8007192,9.550072,48.82433],
['THAM','Haubersbronn Mitte',8070078,9.549001,48.830873],
['SHAM','Hauenstein Mitte',8002648,7.849564,49.199169],
['SHAU','Hauenstein(Pfalz)',8002649,7.830252,49.20139],
['FNK','Haunetal-Neukirchen',8004297,9.692546,50.770838],
['MHPH','Haupeltshofen',8002651,10.38243,48.180467],
['PQKHC','Hauptfriedhof, Karlsruhe',720576,8.431048,49.013115],
['FKHFH','Hauptfriedhof, Kassel',710635,9.498559,51.330472],
['SHPT','Hauptstuhl',8002655,7.490949,49.401974],
['XSHL','Hauptwil',8506212,9.25157587262321,47.476860853604],
['PQKBM','Haus Bethlehem, Karlsruhe',721372,8.376661,49.033528],
['XAHAS','Haus im Ennstal',8100136,13.802541,47.416982],
['RHA','Hausach',8000333,8.181665,48.284924],
['KHAD','Hausen (b Düren)',8007828,6.491212,50.652576],
['THAT','Hausen i Tal',8002656,9.027574,48.080408],
['UHAU','Hausen(Eichsfeld)',8011834,10.379167,51.382523],
['MHNS','Hausen(Schwab)',8002664,10.482517,48.101004],
['FHS','Hausen(Taunus)',8007847,8.507244,50.307749],
['RHSN','Hausen-Raitbach',8002666,7.846041,47.67931],
['THSS','Hausen-Starzeln',8007225,9.068047,48.301744],
['MHHM','Hausham',8002667,11.840257,47.750412],
['EHBK','Havixbeck',8002670,7.407711,51.966713],
['XFHA','Hayange',8700350,6.073188,49.330652],
['LHY','Haynsburg',8011836,12.06556189,51.02770603],
['XFHZ','Hazebrouck',8700076,2.542488,50.725121],
['XTHZ','Hazlov',5401021,12.279022,50.161849],
['NHT','Haßfurt',8002630,10.509998,50.033323],
['RHLO','Haßloch(Pfalz)',8002632,8.253396,49.371956],
['RHAS','Haßmersheim',8002633,9.154129,49.30403],
['MHEF','Hebertsfelden',8002671,12.818533,48.416496],
['MHSN','Hebertshausen',8006189,11.455487,48.291106],
['THCH','Hechingen',8002673,8.968775,48.359601],
['THIL','Hechingen Landesbahn',8082673,8.968155,48.359052],
['AHEN','Hechthausen',8002674,9.228071,53.638716],
['RGCH','Heddesheim/Hirschberg',8002430,8.633746,49.509408],
['FHED','Hedemünden',8002677,9.762144,51.392164],
['NHED','Hedersdorf',8002678,11.338705,49.569344],
['LHEW','Hedersleben-Wedderstedt',8011838,11.250771,51.844688],
['ONHK','Heemskerk',8400317,5.7281572,52.495277404785],
['ONHSA','Heemstede-Aerdenhout',8400302,5.7228408,52.35916519165],
['XSHR','Heerbrugg',8506317,9.62724352945682,47.410385307077],
['XNHR','Heerenveen',8400305,5.72089,52.961387634277],
['ONHGV','Heerhugowaard',8400306,5.7172222137451,52.669723510742],
['XNH','Heerlen',8400307,5.7131996,50.89083480835],
['PNABM','Heerlen Woonboulevard',8400087,5.710000038147,50.896667],
['ONHEZ','Heeze',8400308,5.7055554389954,51.384998321533],
['FKHBS','Hegelsbergstraße, Kassel',710634,9.490479,51.336918],
['EHEG','Heggen',8002682,7.963238,51.153517],
['RHGN','Hegne',8002683,9.099572,47.706037],
['XMHY','Hegyeshalom',5500017,17.14702,47.913506],
['XBHD','Heide (B)',8800062,4.460286,51.364587],
['AHI','Heide(Holst)',8000155,9.101029,54.193563],
['RH','Heidelberg Hbf',8000156,8.675442,49.403567],
['RHBO','Heidelberg Orthopädie',8002684,8.774913,49.409995],
['RHKA','Heidelberg-Altstadt',8002685,8.720887,49.415237],
['RHKM','Heidelberg-Kirchheim/Rohrbach',8002686,8.675383,49.379389],
['RHBP','Heidelberg-Pfaffengrund/Wieblingen',8002687,8.64157,49.411929],
['RSR','Heidelberg-Schlierbach/Ziegelhausen',8005366,8.760564,49.415309],
['RHBF','Heidelberg-Weststadt/Südstadt',8002681,8.688749,49.398324],
['RHI','Heidelsheim',8002688,8.649483,49.10161],
['RHIO','Heidelsheim Nord',8070010,8.645252,49.105113],
['DHD','Heidenau',8010163,13.857887,50.981859],
['DHDS','Heidenau Süd',8011843,13.874717,50.971696],
['DHDG','Heidenau-Großsedlitz',8011844,13.894877,50.960822],
['THD','Heidenheim',8002689,10.156642,48.68017],
['THDV','Heidenheim Voithwerk',8070005,10.156077,48.669482],
['THDM','Heidenheim-Mergelstetten',8002690,10.160976,48.653279],
['THDS','Heidenheim-Schnaitheim',8002691,10.15876,48.708281],
['FHEI','Heidesheim(Rheinhess)',8002692,8.111318,49.997023],
['HHEI','Heidkrug',8002694,8.680195,53.057093],
['NHEI','Heigenbrücken',8002696,9.363943,50.027232],
['UHT','Heilbad Heiligenstadt',8011849,10.123845,51.377067],
['TBCB','Heilbr.-Böckingen Berufsschulzentrum',8079631,9.182328,49.140427],
['TH  A','Heilbronn Finanzamt',8070791,9.23501,49.140527],
['TH  F','Heilbronn Friedensplatz',8070792,9.228776,49.141313],
['THSTR','Heilbronn Hans-Rießer-Straße',8072723,9.219565,49.162603],
['TH  H','Heilbronn Harmonie',8070172,9.223006,49.141586],
['TH  W','Heilbronn Harmonie/Hafenmarktpassage',8071172,9.222436,49.142702],
['TH  O','Heilbronn Harmonie/Kunsthalle',8072172,9.222599,49.142486],
['TH  B','Heilbronn Hauptbahnhof/Willy-Brandt-Pl.',8070171,9.208356,49.142594],
['TH','Heilbronn Hbf',8000157,9.207715,49.143306],
['THSTI','Heilbronn Industrieplatz',8002723,9.217886,49.155321],
['THKT','Heilbronn Karlstor',8002697,9.234284,49.146303],
['TNSK','Heilbronn Kaufland',8002726,9.224687,49.170076],
['TH  P','Heilbronn Neckar-Turm/K.-S.-Pl',8070174,9.213758,49.142656],
['TH  U','Heilbronn Pfühlpark',8070793,9.241382,49.139956],
['TH  R','Heilbronn Rathaus',8070173,9.21906,49.141944],
['THST','Heilbronn Sülmertor',8002699,9.220598,49.151601],
['THSTS','Heilbronn Technisches Schulzentrum',8072722,9.22149,49.148667],
['TH  T','Heilbronn Theater',8002722,9.22215,49.146273],
['TTPS','Heilbronn Trappensee',8002700,9.25257,49.140282],
['WHDM','Heiligendamm',8011846,11.842863,54.141677],
['WHEG','Heiligengrabe',8011848,12.340537,53.14968],
['MHEI','Heiligenstatt(Obb)',8002703,12.609585,48.213359],
['RHN','Heiligenstein(Pfalz)',8002704,8.393726,49.28566],
['ONHEL','Heiloo',8400309,5.7036108970642,52.599445343018],
['NHE','Heilsbronn',8002705,10.791053,49.34595],
['KHE','Heimbach (Eifel)',8007829,6.4735,50.636515],
['SHB','Heimbach(Nahe)',8002707,7.231047,49.617676],
['SHBO','Heimbach(Nahe)Ort',8007887,7.251982,49.613212],
['MHMK','Heimenkirch',8002710,9.9021,47.628909],
['THMD','Heimerdingen',8007328,8.985433,48.851473],
['KHEH','Heimersheim',8002711,7.174409,50.54745],
['MHEM','Heimstetten',8002715,11.759659,48.158755],
['FHEB','Heinebach',8002716,9.664423,51.045739],
['PAARF','Heinfels',8105982,12.444433,46.745894],
['ONHEN','Heino',8400310,5.70177,52.427223205566],
['FKNZH','Heinrich-Heine-Straße, Kassel',714882,9.484061,51.303867],
['KHEBK','Heinsberg Kreishaus',8002725,6.10894,51.061774],
['KHEB','Heinsberg(Rheinl)',8002721,6.098881,51.065037],
['KDRN','Heinsberg-Dremmen',8001557,6.152515,51.045683],
['KHEBH','Heinsberg-Horst',8002719,6.182303,51.028841],
['KOB','Heinsberg-Oberbruch',8004519,6.135084,51.053072],
['KHEBP','Heinsberg-Porselen',8002720,6.174482,51.040615],
['KHEBR','Heinsberg-Randerath',8002718,6.182449,51.016244],
['AHWA','Heinschenwalde',8007807,8.972913,53.498728],
['SHZH','Heinzenhausen',8002724,7.606902,49.625703],
['RHE','Heitersheim',8002727,7.646194,47.879859],
['XAHP','Heiterwang-Plansee',8100550,10.7484904082008,47.4422827670705],
['UHD','Heldrungen',8011852,11.183186,51.302171],
['BHEL','Helenesee',8011853,14.478219,52.278758],
['NHB','Helmbrechts',8002733,11.724351,50.2338],
['XNHM','Helmond',8400313,5.661928,51.475478],
['PNAAT','Helmond Brandevoort',8400035,5.608972,51.462498],
['ONHMB','Helmond Brouwhuis',8400299,5.702829,51.470382],
['ONHMH','Helmond t Hout',8400300,5.63131,51.468035],
['DHLF','Helmsdorf(Pirna)',8011855,14.046491,51.034205],
['RHSM','Helmsheim',8002734,8.651336,49.08575],
['RHM','Helmstadt(Baden)',8007444,8.97513,49.320089],
['HHLM','Helmstedt',8000159,11.010553,52.222086],
['EHEP','Helpup',8002737,8.714725,51.97738],
['OBHKM','Hemiksem',8800313,4.338473,51.136414],
['ONHDW','Hemmen-Dodewaard',8400315,5.6619443893433,51.9222129],
['EHMD','Hemmerde',8002745,7.803364,51.553942],
['SHEM','Hemmersdorf(Saar)',8002746,6.614569,49.353998],
['THMG','Hemmingen',8007327,9.031696,48.867783],
['AHEM','Hemmoor',8000815,9.165803,53.684081],
['RHCH','Hemsbach',8002748,8.648722,49.590869],
['XFHE','Hendaye',8700149,-1.781961,43.353146],
['XSHE','Hendschiken',8502211,8.20737399628782,47.3894242237166],
['NHD','Henfenfeld',8002751,11.38655,49.501412],
['XNHL','Hengelo',8400316,6.7938890457153,52.261665344238],
['PNHGP','Hengelo Gezondheidspark',8400433,6.773611,52.261667],
['ONHLO','Hengelo Oost',8400312,6.8194446563721,52.268890380859],
['XFHB','Henin-Beaumont',8700351,2.952237,50.417042],
['XDHEN','Henne st',8600960,8.305357,55.710688],
['KHES','Hennef im Siegbogen',8002775,7.313288,50.773156],
['KHEN','Hennef(Sieg)',8002753,7.284592,50.773332],
['EHNE','Hennen',8002754,7.646847,51.437155],
['DHRF','Hennersdorf(Sachs)',8011856,13.070919,50.791751],
['BHD','Hennigsdorf (S)',8089207,13.2058078,52.6379039],
['BHND','Hennigsdorf(b Berlin)',8013483,13.205454,52.638257],
['AUB','Henstedt-Ulzburg',8007053,9.982182,53.795121],
['FHP','Heppenheim(Bergstr)',8002757,8.633379,49.641553],
['THT','Herbertingen',8000160,9.414604,48.063945],
['THTO','Herbertingen Ort',8002760,9.433397,48.05357],
['MHEH','Herbertshofen',8002761,10.848027,48.529528],
['RHRB','Herblingen',8002762,8.664127,47.717003],
['RHZ','Herbolzheim(Breisg)',8002763,7.767638,48.223866],
['THZ','Herbolzheim(Jagst)',8002764,9.259824,49.281494],
['FHRB','Herborn(Dillkr)',8000161,8.30814,50.684405],
['THC','Herbrechtingen',8002766,10.170334,48.625634],
['KHEC','Herchen',8002768,7.521349,50.771269],
['EHCK','Herdecke',8002769,7.432619,51.404806],
['EHF','Herdorf',8002770,7.953074,50.778301],
['XBHR','Herentals',8800063,4.828573,51.181117],
['EHFD','Herford',8000162,8.663643,52.119609],
['MHGZ','Hergatz',8000387,9.827382,47.64681],
['XBHE','Hergenrath',8800116,6.041335,50.718209],
['FHER','Hergershausen',8002773,8.916575,49.936802],
['UHRH','Heringen(Helme)',8011860,10.875255,51.451498],
['WHFN','Heringsdorf Neuhof',8087026,14.148259,53.952765],
['OSHS','Herisau',8506290,9.276814,47.390169],
['DHN','Herlasgrün',8010166,12.235424,50.570936],
['UHER','Herleshausen Hp',8013548,10.171661,51.002642],
['THMA','Hermaringen',8002776,10.258331,48.594584],
['THMT','Hermentingen',8007231,9.217467,48.200845],
['DHS','Hermsdorf(Dresden)',8011861,13.815351,51.165545],
['UHK','Hermsdorf-Klosterlausnitz',8011862,11.858626,50.903779],
['EHER','Herne',8000164,7.21783,51.543652],
['EHBO','Herne-Börnig',8002779,7.26835,51.554789],
['XFHN','Herny',8701294,6.476802,49.00381],
['NHER','Heroldsberg',8002782,11.149914,49.528757],
['NHEN','Heroldsberg Nord',8002783,11.146804,49.544582],
['KHER','Herrath',8002784,6.367399,51.104316],
['THE','Herrenberg',8002785,8.862662,48.593991],
['TZWE','Herrenberg Zwerchweg',8002786,8.867661,48.584969],
['BHE','Herrensee',8011863,13.886577,52.529928],
['THL','Herrlingen',8002789,9.89773,48.417731],
['XFHH','Herrlisheim près Colmar',8701281,7.32066,48.016667],
['THH','Herrlishöfen',8079099,9.808465,48.13944],
['WHB','Herrnburg',8011864,10.760008,53.837707],
['MHI','Herrsching',8002792,11.170571,47.998849],
['NHL','Hersbruck(l Pegnitz)',8002793,11.435143,49.500462],
['NHR','Hersbruck(r Pegnitz)',8002794,11.423826,49.510073],
['XBHL','Herstal',8800236,5.622483,50.660606],
['RHRT','Herten(Baden)',8002797,7.739663,47.549507],
['EHDT','Hervest-Dorsten',8000165,6.974167,51.67191],
['RHXB','Herxheim am Berg',8002798,8.190044,49.509491],
['HHBS','Herzberg Schloß',8002800,10.332804,51.654495],
['LHZW','Herzberg(Elster)',8011867,13.202786,51.679446],
['HHB','Herzberg(Harz)',8000166,10.329923,51.643861],
['WHE','Herzberg(Mark)',8010167,12.978391,52.905361],
['EHEZ','Herzebrock',8002801,8.236268,51.880225],
['XBHZ','Herzele',8800369,3.879834,50.897121],
['AHZH','Herzhorn',8079605,9.483884,53.783537],
['XSHZ','Herzogenbuchsee',8508008,7.70094642681797,47.1880813307841],
['XAHB','Herzogenburg',8100272,15.696542,48.276669],
['KHEZ','Herzogenrath',8002806,6.094486,50.870916],
['KMKW','Herzogenrath-Alt-Merkstein',8002804,6.100999,50.885434],
['KMK','Herzogenrath-August-Schmidt-Platz',8002816,6.119504,50.886962],
['AHOF','Hesedorf',8007808,9.195048,53.472715],
['RHBA','Heselbach',8002808,8.398967,48.536689],
['HHES','Hesepe',8000167,7.967599,52.439221],
['EHLN','Hesseln',8002810,8.311956,52.068397],
['FKAI','Hesseneck Kailbach',8003144,9.077482,49.539338],
['FSCH','Hesseneck Schöllenbach',8005393,9.067457,49.565924],
['HHSO','Hessisch Oldendorf',8002812,9.243614,52.166873],
['UHET','Hetschburg',8011869,11.298205,50.912802],
['OFHET','Hettange Grande',8701141,6.15672,49.40765],
['FHH','Hettenhausen',8002814,9.814657,50.448397],
['THTN','Hettingen(Hohenz)',8007230,9.229298,48.217364],
['LHE','Hettstedt',8010168,11.513231,51.636945],
['DHZF','Hetzdorf(Flöhatal)',8011870,13.127695,50.840313],
['SHR','Hetzerath',8002817,6.798385,49.878134],
['OAHEW','Hetzmannsdorf-Wullersdorf',8100936,16.091653,48.617142],
['LHR','Heudeber-Danstedt',8010169,10.866495,51.90474],
['MHEU','Heufeld',8002820,11.96738,47.871195],
['MHFM','Heufeldmühle',8002821,11.934356,47.877551],
['FHEU','Heusenstamm',8002822,8.802202,50.060069],
['HHIS','Hiddenhausen-Schweicheln',8002824,8.668239,52.15844],
['EHIB','Hilchenbach',8002826,8.107146,50.99226],
['NHGN','Hildbrandsgrün',8002827,11.7282417,50.21039014],
['UHN','Hildburghausen',8011871,10.717828,50.425133],
['KHI','Hilden',8000388,6.922006,51.16702],
['KHIS','Hilden Süd',8002828,6.937366,51.163682],
['HHI','Hildesheim Hbf',8000169,9.953497,52.160626],
['HHIO','Hildesheim Ost',8002830,9.963169,52.146551],
['XNHO','Hillegom',8400005,5.6347411,52.302501678467],
['EHIL','Hillnhütten',8002835,8.071317,50.972778],
['RHLT','Hilpertsau',8002837,8.348683,48.739895],
['NHP','Hilpoltstein',8002838,11.184146,49.188773],
['HHIL','Hilter',8002839,8.152301,52.135256],
['XNHI','Hilversum',8400322,5.63085,52.225833892822],
['ONHSN','Hilversum Media Park',8400324,5.6303429603577,52.238056182861],
['XNHIS','Hilversum Sportpark',8400570,5.1872220039368,52.216110229492],
['AHPF','Himmelpforten',8002843,9.310465,53.623301],
['RHIM','Himmelreich',8002844,7.991356,47.958616],
['NHIS','Himmelstadt',8002845,9.808214,49.923438],
['ONHI','Hindeloopen',8400323,5.619722366333,52.9464903],
['MHRS','Hinrichssegen',8002850,11.950658,47.874416],
['SHWP','Hinterweidenthal',8002847,7.747676,49.201568],
['SHWO','Hinterweidenthal Ort',8079088,7.750568,49.197498],
['SHW','Hinterweidenthal Ost',8079147,7.773047,49.203132],
['RHIZ','Hinterzarten',8002848,8.106033,47.906278],
['THI','Hirsau',8002852,8.73679,48.734059],
['NHI','Hirschaid',8002853,10.991064,49.819595],
['OAHIR','Hirschbach b.Gmünd',8100953,15.126985,48.74932],
['DHE','Hirschfelde',8011878,14.891018,50.943388],
['MHFN','Hirschfelden',8002856,10.362265,48.289531],
['RHO','Hirschhorn(Neckar)',8002857,8.896055,49.442668],
['SHIH','Hirschhorn(Pfalz)',8002858,7.681008,49.515588],
['PQKHT','Hirtenweg/Technologiepark, Karlsruhe',721378,8.438639,49.017109],
['AHIF','Hittfeld',8002864,9.974525,53.403712],
['AHZ','Hitzacker',8002865,11.038199,53.139158],
['XTHN','Hnevice',5401059,14.361715,50.452686],
['OBHBP','Hoboken-Polder',8800311,4.348424,51.182996],
['KHO','Hochdahl',8002868,6.944419,51.218832],
['KHOM','Hochdahl-Millrath',8002869,6.966684,51.216501],
['THF','Hochdorf(b Horb)',8000389,8.724052,48.482485],
['XFHC','Hochfelden',8701260,7.57244,48.755233],
['XAHF','Hochfilzen',8100052,12.6265319634057,47.4674753910083],
['THO','Hochhausen(Tauber)',8002871,9.633235,49.663812],
['FHM','Hochheim(Main)',8002872,8.350398,50.004253],
['KHOK','Hochneukirch',8000390,6.466316,51.103293],
['SHY','Hochspeyer',8002875,7.904244,49.443993],
['NHM','Hochstadt-Marktzeuln',8002878,11.172594,50.153139],
['RHOS','Hochstetten',8007201,8.41577,49.133571],
['PQLHA','Hochstetten Altenheim, Linkenheim-Hochstetten',721187,8.418277,49.13254],
['RHOSG','Hochstetten Grenzstraße',8079042,8.415723,49.12955],
['SHS','Hochstetten(Nahe)',8002880,7.510962,49.798662],
['SHST','Hochstätten(Pfalz)',8002879,7.829096,49.763342],
['MHWG','Hochwang',8002881,10.298007,48.389121],
['XAHO','Hochzirl',8100111,11.2491664051378,47.2809464617626],
['RHK','Hockenheim',8002883,8.537385,49.317414],
['UHR','Hockeroda',8010170,11.434282,50.59772],
['HHOD','Hodenhagen',8002884,9.595056,52.766564],
['OTHO','Hodonin',5400056,17.12194,48.8564],
['XBHO','Hoeilaart',8800528,4.468124,50.759937],
['XDHT','Hoeje Taastrup st',8601031,12.268799,55.648621],
['ONHBK','Hoensbroek',8400326,5.6160801,50.905555725098],
['PNHLK','Hoevelaken',8400490,5.45718,52.16652],
['NHO','Hof Hbf',8002924,11.923067,50.307743],
['RHOF','Hof(Münstertal)',8007336,7.772654,47.857122],
['NHON','Hof-Neuhof',8002927,11.904711,50.321538],
['SHFD','Hofeld',8002929,7.159755,49.511922],
['THOF','Hofen(b Aalen)',8002930,10.114407,48.872692],
['RHFF','Hoffenheim',8002931,8.838411,49.272037],
['KHOF','Hoffnungsthal',8002932,7.196513,50.911363],
['FHFG','Hofgeismar',8002933,9.395461,51.499186],
['FHMM','Hofgeismar-Hümme',8003015,9.401965,51.542923],
['FHOR','Hofheim (Ried)',8002934,8.40897,49.659467],
['FHF','Hofheim(Taunus)',8002935,8.443842,50.084471],
['KHOG','Hohegrete',8002939,7.642479,50.76485],
['BHOW','Hohen Neuendorf West',8080710,13.271342,52.672398],
['BHN','Hohen Neuendorf(b Berlin)',8080720,13.287091,52.669072],
['XAHH','Hohenau',8100130,16.9007221022991,48.5983241877404],
['OAHHR','Hohenbrugg an der Raab',8100945,16.060353,46.944322],
['MHOB','Hohenbrunn',8002940,11.698872,48.046572],
['WHOD','Hohendorf',8011889,13.730268,54.02727],
['UHOO','Hohenebra Ort',8011891,10.809172,51.306146],
['HHEP','Hoheneggelsen',8002944,10.19782,52.200177],
['XAHS','Hohenems',8100121,9.68111760968383,47.3648142463924],
['DHOF','Hohenfichte',8011892,13.133981,50.822064],
['BHL','Hohenleipisch',8011894,13.564969,51.492756],
['UHOL','Hohenleuben',8011895,12.036399,50.703161],
['EHOG','Hohenlimburg',8002953,7.571686,51.348854],
['MHPG','Hohenpeißenberg',8002954,10.999251,47.788795],
['LHRA','Hohenroda',8011900,12.421434,51.499026],
['MHSL','Hohenschäftlarn',8002955,11.457513,47.991299],
['NHOH','Hohenstadt(Mittelfr)',8002956,11.491465,49.518339],
['DHO','Hohenstein-Ernstthal',8011904,12.706564,50.798548],
['FHSU','Hohensülzen',8002958,8.214173,49.621788],
['LHM','Hohenthurm',8011905,12.097881,51.512359],
['NHWN','Hohenwarth',8007342,12.943161,49.205389],
['NHWNC','Hohenwarth Campingplatz',8070160,12.924448,49.204834],
['AHWT','Hohenwestedt',8002959,9.654161,54.086589],
['LHWU','Hohenwulsch',8010172,11.595136,52.667319],
['DRDFH','Hohndorf Mitte',8017422,12.675725,50.743048],
['OTHJS','Hojsova Straz',5401075,13.174806,49.211752],
['OTHSB','Hojsova Straz-Brcalnik',5400264,13.222827,49.192066],
['WHOL','Holdorf(Meckl)',8011908,11.065701,53.7348],
['HHDF','Holdorf(Oldb)',8002962,8.138367,52.574971],
['OTHKO','Holkov',5401086,14.447778,48.851689],
['OAHL','Hollabrunn',8100274,16.072281,48.562794],
['ONHLR','Hollandsche Rading',8400327,5.6072220802307,52.17777633667],
['FKHST','Holländische Straße, Kassel',711180,9.48096,51.340266],
['FKHPL','Holländischer Platz/Universität, Kassel',711363,9.502083,51.320735],
['AHES','Holm-Seppensen',8002967,9.870008,53.284812],
['AKTKH','Holstentherme',8007203,9.946077,53.839935],
['ONHO','Holten',8400328,5.60246,52.283889770508],
['HHOL','Holtensen/Linderte',8002969,9.653221,52.271953],
['WHO','Holthusen',8010173,11.364809,53.555831],
['XTHS','Holysov',5400057,13.101373,49.597551],
['LHZ','Holzdorf(Elster)',8011909,13.114137,51.780291],
['UHF','Holzdorf(b Weimar)',8011910,11.27592,50.942186],
['THZG','Holzgerlingen Bf',8085010,9.006945,48.637525],
['THZGB','Holzgerlingen Buch',8085011,9.024768,48.626696],
['THZGN','Holzgerlingen Hülben',8085009,9.009634,48.647857],
['DHU','Holzhau',8011912,13.591671,50.734108],
['DHUS','Holzhau Skilift',8017218,13.57339,50.733908],
['EHOZ','Holzhausen(Kr Siegen)',8002976,8.135495,50.739322],
['KHOZ','Holzheim(b Neuss)',8002979,6.664626,51.165653],
['MHO','Holzkirchen',8002980,11.697234,47.884384],
['HHZM','Holzminden',8000391,9.453743,51.820268],
['EHZW','Holzwickede',8000392,7.619647,51.504767],
['XFHM','Hombourg-Haut',8700525,6.775001,49.126362],
['SHO','Homburg(Saar)Hbf',8000176,7.337035,49.328082],
['KHOR','Honrath',8002988,7.252882,50.910589],
['XNHD','Hoofddorp',8400332,5.5980553627014,52.293334960938],
['XNHG','Hoogeveen',8400330,5.590277671814,52.733890533447],
['XNHS','Hoogezand-Sappemeer',8400331,5.5833465,53.159818131676],
['XNHGK','Hoogkarspel',8400334,5.5783333778381,52.69055557251],
['XNHOR','Hoorn',8400337,5.5752778053284,52.644721984863],
['XNHOK','Hoorn Kersenboogerd',8400336,5.5738887786865,52.653610229492],
['XAHG','Hopfgarten im Brixental',8100059,12.14918,47.455351],
['XAHGB','Hopfgarten im Brixental Berglift',8100939,12.158595,47.446912],
['LHGT','Hopfgarten(Sachs)',8011914,12.662693,51.105574],
['UHP','Hopfgarten(Weimar)',8011915,11.220591,50.984262],
['EHOP','Hoppecke',8002992,8.640059,51.378059],
['BHPG','Hoppegarten(Mark)',8080750,13.672956,52.518122],
['MHOP','Hoppingen',8002994,10.653198,48.803817],
['SHPS','Hoppstädten(Nahe)',8002995,7.195011,49.615527],
['THB','Horb',8000177,8.688982,48.441471],
['THBH','Horb-Heiligenfeld',8002998,8.660151,48.467796],
['XSHG','Horgen',8503204,8.59690458831108,47.2614824887468],
['BHR','Horka',8010174,14.902088,51.303985],
['XSHB','Horn(Bodensee)',8506307,9.46337580998521,47.4931768240412],
['XSHBS','Horn(Bodensee), SF',8506111,9.46295013675514,47.496639074807],
['EHBM','Horn-Bad Meinberg',8003000,8.955092,51.881518],
['RHBG','Hornberg(Schwarzw)',8003001,8.23294,48.211895],
['AHOG','Horneburg',8003002,9.57655,53.508677],
['XTHB','Horni Blatna',5400231,12.766519,50.388097],
['XTHD','Horni Dvoriste',5400060,14.421975,48.601815],
['XTHK','Horni Kamenice',5401113,14.436597,50.799348],
['XTHP','Horni Podluzi',5401122,14.556988,50.88298],
['XTHOP','Horni Police',5402438,14.4,50.706083],
['XTHPT','Horni Poustevna',5401124,14.300467,50.996785],
['WHOR','Hornstorf',8010176,11.534673,53.906688],
['XTHV','Horovice',5400061,13.899184,49.843323],
['KHR','Horrem',8000178,6.713497,50.916249],
['XDHR','Horsens st',8601089,9.8356522,55.8626973],
['AHOT','Horst(Holst)',8003003,9.645156,53.804596],
['ONHSM','Horst-Sevenum',8400339,6.043115,51.426047],
['OMHOR','Horvatnadalja',5501621,16.543451,47.004846],
['BHC','Hosena',8010171,14.016105,51.454706],
['ONHT','Houten',8400340,5.5505557060242,52.03402],
['PNSHC','Houten Castellum',8400010,5.548611164093,52.01701],
['ONHSG','Houthem-St. Gerlach',8400341,5.5483094,50.873332977295],
['XLHW','Howald',8200250,6.1325,49.5811],
['BHW','Hoyerswerda',8010177,14.231407,51.432788],
['BHWN','Hoyerswerda-Neustadt',8011922,14.26823906,51.4290131],
['HHOY','Hoykenkamp',8003008,8.598683,53.069799],
['XTHR','Hradek nad Nisou',5400205,14.847601,50.855007],
['XTHM','Hranice na Morave',5400063,17.741595,49.565548],
['XTHY','Hrebeny',5401220,12.581061,50.221911],
['RHAR','Hubacker',8003010,8.135691,48.507398],
['BHUB','Hubertushöhe',8011923,13.965151,52.23387],
['KHUS','Huchem-Stammeln',8007817,6.45337,50.852519],
['WHU','Huckstorf',8011924,12.116026,53.98448],
['HHUD','Hude',8000522,8.460956,53.109429],
['MHUF','Hufschlag',8003023,12.664941,47.875599],
['MHUG','Huglfing',8003024,11.140552,47.776736],
['RHU','Hugstetten',8003025,7.783929,48.048247],
['THUB','Hulb',8003022,8.982644,48.679267],
['DHUN','Hundsgrün',8011928,12.211452,50.366256],
['FHUN','Hundstadt',8007848,8.469063,50.370908],
['FHUG','Hungen',8000400,8.89279,50.478055],
['HHUL','Huntlosen',8003030,8.26652,52.990817],
['ONHG','Hurdegaryp',8400292,5.5322222709656,53.2187783],
['AY','Husby',8003032,9.575505,54.764372],
['AHM','Husum',8000181,9.055026,54.472271],
['RHTT','Huttenheim',8003033,8.472636,49.197162],
['XBHU','Huy(B)',8800185,5.233456,50.527026],
['RHUB','Huzenbach',8003034,8.391276,48.582625],
['XDHVD','Hviding st',8601144,8.730155,55.274465],
['XDHYL','Hyllerslev st',8601157,8.388286,55.624674],
['XSHW','Häggenschwil-Winden',8506395,9.35870895961232,47.5038584594884],
['BHAH','Hähnichen',8011795,14.856726,51.364119],
['FHAE','Hähnlein-Alsbach',8002498,8.606664,49.73935],
['HHAE','Hämelerwald',8002499,10.110601,52.354704],
['LHMT','Hämerten',8011796,11.97177,52.599024],
['RKEH','Händelstraße, Karlsruhe',721381,8.369307,49.011247],
['XVHH','Hässleholm Central',7400006,13.76337,56.15799],
['FHHF','Häuserhof',8002501,8.939159,50.418594],
['FHET','Höchst Hetschbach',8002813,8.983195,49.807596],
['FMGR','Höchst Mümling-Grumbach',8004125,8.985638,49.771669],
['FHT','Höchst(Odenw)',8000172,8.988549,49.794499],
['MHDT','Höchstädt(Donau)',8002888,10.566218,48.618309],
['THOE','Höfen(Enz) Bf',8002891,8.58104,48.79856],
['THON','Höfen(Enz) Nord',8070279,8.581724,48.807709],
['THFG','Höfingen',8002892,9.025315,48.814986],
['MHSB','Höhenkirchen-Siegertsbrunn',8002894,11.719226,48.018465],
['SHMB','Höhmühlbach',8002895,7.526028,49.243893],
['NHTL','Höllenthal',8002898,11.683818,50.3638],
['MHRK','Höllriegelskreuth',8002899,11.509752,48.043452],
['MHPF','Höpfling',8002908,12.651162,47.811226],
['RHOR','Hörden',8002910,8.34519,48.781523],
['MHLK','Hörlkofen',8002912,11.942341,48.242591],
['MHPD','Hörpolding',8002914,12.568261,47.964138],
['UHL','Hörschel Hp',8013547,10.233271,51.007795],
['XAHOG','Hörsching',8100974,14.1865101731904,48.2457848203888],
['UHOS','Hörselgau',8087061,10.577866,50.923383],
['HHTL','Hörstel',8002915,7.591557,52.295686],
['EHOM','Hörstmar(Lippe)',8002916,8.844978,52.012502],
['NHOE','Hösbach',8002918,9.229008,49.999713],
['EHOS','Hösel',8002919,6.893231,51.341521],
['EHST','Höste',8070884,7.92109,52.158949],
['OAHZD','Hötzelsdorf-Geras',8100273,15.670257,48.74247],
['EHOV','Hövelhof',8002920,8.661685,51.823991],
['EHVR','Hövelriege',8002921,8.642067,51.865123],
['HHXR','Höxter Rathaus',8002923,9.381918,51.772604],
['HGOH','Höxter-Godelheim',8002299,9.356871,51.735123],
['HLN','Höxter-Lüchtringen',8003780,9.427208,51.790928],
['HOTT','Höxter-Ottbergen',8004720,9.304909,51.71099],
['PQKHB','Hübschstraße, Karlsruhe',721382,8.371921,49.005643],
['KBA','Hückelhoven-Baal',8000677,6.274149,51.033457],
['RHFH','Hüffenhardt',8007439,9.086804,49.291132],
['RHFM','Hüfingen Mitte',8003014,8.490511,47.929913],
['FHUE','Hünfeld',8003016,9.762453,50.673271],
['XSHU','Hüntwangen-Wil',8503403,8.51282074899121,47.5812668467021],
['KKAS','Hürth-Kalscheuren',8003160,6.910223,50.875671],
['XAHUT','Hüttau',8100993,13.32063,47.415676],
['THTT','Hütten',8070219,9.642462,48.370998],
['AHTB','Hüttenbusch',8007119,8.962154,53.273296],
['UHUE','Hüttengrund',8011925,11.197711,50.381153],
['SHT','Hüttingen',8003021,6.585008,49.967418],
['ONLJ','IJlst',8400722,5.6160801,53.0146614],
['RIB','Ibach',8003035,8.162739,48.455116],
['HI','Ibbenbüren',8003036,7.721486,52.276867],
['HESH','Ibbenbüren-Esch',8001867,7.655968,52.299746],
['HLGG','Ibbenbüren-Laggenbeck',8003491,7.780962,52.26486],
['MIHN','Ichenhausen',8003038,10.302138,48.370187],
['MIC','Icking',8003039,11.436647,47.953249],
['SIDO','Idar-Oberstein',8003040,7.32123,49.699368],
['FIST','Idstein(Taunus)',8003041,8.257264,50.21599],
['MSTA','Iffeldorf',8005672,11.329019,47.782064],
['SIG','Igel',8003042,6.550679,49.70737],
['NIDF','Igensdorf',8003044,11.23453,49.620122],
['TIH','Igersheim',8003045,9.812535,49.493425],
['RIR','Ihringen',8003052,7.648777,48.04041],
['XPIL','Ilawa Glowna',5100075,19.573848,53.582253],
['LIB','Ilberstedt',8011929,11.650922,51.806862],
['LIF','Ilfeld',8017014,10.789534,51.578415],
['LIFB','Ilfeld Bad',8080998,10.785333,51.5952],
['LIFN','Ilfeld Neanderklinik',8070776,10.78853,51.583414],
['LIFS','Ilfeld Schreiberwiese',8080990,10.787137,51.573549],
['MILT','Illertissen',8003057,10.099942,48.222828],
['NILL','Illesheim',8003058,10.382648,49.479731],
['SILG','Illingen(Saar)',8003059,7.048966,49.376422],
['TIL','Illingen(Württ)',8003060,8.921162,48.956588],
['UI','Ilmenau',8010178,10.923086,50.684481],
['UIB','Ilmenau Bad',8011931,10.908966,50.681348],
['UIP','Ilmenau Pörlitzer Höhe',8011935,10.922753,50.694699],
['UIR','Ilmenau-Roda',8011932,10.889111,50.697228],
['LIG','Ilsenburg',8011933,10.683103,51.869004],
['UIM','Immelborn',8011934,10.280415,50.793235],
['RIM','Immendingen',8000182,8.729536,47.936007],
['RIMM','Immendingen Mitte',8003061,8.735162,47.937109],
['RIMZ','Immendingen Zimmern',8003066,8.714051,47.932876],
['FIM','Immenhausen',8003062,9.464397,51.426902],
['NIM','Immenreuth',8003063,11.86966,49.911344],
['XSIM','Immensee',8505003,8.46266014649329,47.0916137780866],
['HIMS','Immensen-Arpke',8003064,10.084479,52.391356],
['MIMS','Immenstadt',8003065,10.213999,47.559203],
['XAIP','Imst-Pitztal',8100062,10.7619430949049,47.2190401577172],
['XAIB','Imsterberg',8101000,10.7061522037279,47.2112580421863],
['SIM','Imsweiler',8003070,7.807976,49.597656],
['OIIO','Induno-Olona',8301609,8.8377,45.846478],
['KING','Ingelbach',8003073,7.726214,50.688903],
['FIL','Ingelheim',8003075,8.053716,49.976277],
['XBIM','Ingelmunster',8800346,3.255353,50.913985],
['MIA','Ingolstadt Audi',8003074,11.4074564,48.7904959],
['MIH','Ingolstadt Hbf',8000183,11.437337,48.744541],
['MIN','Ingolstadt Nord',8003076,11.432933,48.773087],
['XFIW','Ingwiller',8700309,7.476667,48.872642],
['MINI','Inningen',8003079,10.868876,48.311336],
['XAI','Innsbruck Hbf',8100108,11.4010885424296,47.2634127853823],
['XAIH','Innsbruck Hötting',8100110,11.373714005966,47.2615611390909],
['PAIM','Innsbruck Messe',8105987,11.407662,47.273201],
['XAIW','Innsbruck Westbahnhof',8100109,11.3917477933704,47.2556089816207],
['XPIW','Inowroclaw',5100015,18.24406,52.804945],
['WIM','Inselstadt Malchow',8012296,12.423808,53.48201],
['RIN','Insheim',8003080,8.152132,49.157624],
['XSIO','Interlaken Ost',8507492,7.86900513743685,46.6905054600522],
['XSI','Interlaken West',8507493,7.8514404307212,46.6826271765726],
['XAIZ','Inzing/Inn',8101007,11.199143,47.277777],
['NI','Iphofen',8003081,10.255622,49.696603],
['NIP','Ipsheim',8003083,10.485764,49.5255],
['DIR','Irfersgrün',8011937,12.409602,50.608547],
['OAIF','Irnfritz',8100399,15.539769,48.748412],
['NIR','Irrenlohe',8003086,12.101376,49.362776],
['XFIS','Is-sur-Tille',8700469,5.130341,47.52072],
['XIIT','Iselle di Trasquera',8302814,8.206997,46.207241],
['EIL','Iserlohn',8000186,7.691608,51.373294],
['EILH','Iserlohnerheide',8003090,7.69221,51.399861],
['HIHG','Isernhagen',8003091,9.803842,52.486091],
['MIS','Ismaning',8003092,11.679489,48.226012],
['TIP','Ispringen',8003094,8.67222,48.914427],
['EIAV','Isselhorst-Avenwedde',8003096,8.438524,51.939976],
['RIT','Istein',8003098,7.542943,47.660889],
['RITB','Ittersbach Bahnhof',8007014,8.511045,48.869154],
['RITI','Ittersbach Industrie, Karlsbad',723599,8.508898,48.884793],
['RITBR','Ittersbach Rathaus',8090001,8.509824,48.865902],
['NIL','Ittling',8003100,12.637998,48.884909],
['RITL','Ittlingen',8003101,8.93458,49.187119],
['AIZ','Itzehoe',8003102,9.510287,53.923873],
['TIT','Itzelberg',8003103,10.1363,48.730681],
['XRIG','Ivanic Grad',7800032,16.3978365,45.7074608],
['WJAB','Jabel(Meckl)',8011939,12.547559,53.545263],
['XTJP','Jablonne v Podjestedi',5400066,14.758118,50.769452],
['BJF','Jacobsdorf(Mark)',8011940,14.355037,52.332626],
['HJAH','Jaderberg',8003105,8.18455,53.34492],
['WJS','Jagdschloß',8011947,13.619872,54.376479],
['TJZ','Jagstzell',8003111,10.098819,49.031239],
['DJD','Jahnsdorf(Erzgeb)',8011948,12.857511,50.754946],
['OMJB','Jak-Balogunyom',5501609,16.630655,47.161294],
['XDJP','Janderup st',8601177,8.374358,55.622836],
['XPJZ','Jankowa Zaganska',5101447,15.181,51.567123],
['XTJU','Janovice nad Uhlavou',5400212,13.203749,49.352525],
['OPJWE','Janowice Wielkie',5101483,15.91879,50.878181],
['XPJR','Jaroslaw',5100233,22.677897,50.010668],
['AJHH','Jarrenwisch',8003115,8.962896,54.212081],
['WJAS','Jasnitz',8011951,11.374058,53.386389],
['WJK','Jatznick',8010179,13.937671,53.603062],
['LJEB','Jeber-Bergfrieden',8011952,12.349699,51.984637],
['RJ','Jechtingen',8007288,7.610624,48.119844],
['OAJE','Jedenspeigen',8101012,16.878245,48.494934],
['XTJL','Jedlova',5400282,14.570331,50.842738],
['XPJDZ','Jedrzychowice',5101408,15.017829,51.173729],
['WJER','Jeeser',8011953,13.258802,54.164548],
['XDJE','Jegum st',8601182,8.302022,55.665381],
['XPJG','Jelenia Gora',5100259,15.755329,50.902568],
['OPJGA','Jelenia Gora Zabobrze',5100374,15.742934,50.910039],
['UJP','Jena Paradies',8011956,11.587461,50.924856],
['UJS','Jena Saalbf',8011058,11.593783,50.93692],
['UJW','Jena West',8011957,11.577848,50.923286],
['UGW','Jena-Göschwitz',8010133,11.593537,50.883942],
['UJZ','Jena-Zwätzen',8011958,11.620875,50.955487],
['XAJB','Jenbach',8100102,11.7784265200941,47.3884268967759],
['XAJBZ','Jenbach Zillertalbahn',8100545,11.778555,47.388364],
['PTJOV','Jenikov-Oldrichov',5454318,13.764004,50.639886],
['OAJD','Jennersdorf',8101010,16.13887,46.93506],
['LJW','Jerichow',8010181,12.029388,52.500297],
['HJRX','Jerxheim',8003118,10.882937,52.066238],
['OPJRM','Jerzmanki',5101455,15.05641,51.129852],
['XZJ','Jesenice(SL)',7900001,14.0549133,46.4363246],
['LJES','Jesewitz(Leipzig)',8011959,12.545014,51.419886],
['LJN','Jessen(Elster)',8011960,12.954722,51.792787],
['XSJE','Jestetten',8503421,8.57327389270922,47.6544006039198],
['XTJSR','Jestrebi',5401370,14.599075,50.614626],
['MJEB','Jettenbach',8003122,12.36682,48.171428],
['MJET','Jettingen',8003123,10.445473,48.399126],
['XFJM','Jeumont',8700118,4.086267,50.296239],
['HJ','Jever',8003124,7.89298,53.568715],
['LJZ','Jeßnitz(Anh)',8011961,12.277353,51.682552],
['OTJC','Jince',5400244,13.987404,49.782162],
['XTJD','Jiretin pod Jedlovou',5401397,14.580668,50.883069],
['XTJI','Jirkov zast.',5401395,13.447661,50.485694],
['WJT','Joachimsthal',8011962,13.749473,52.98038],
['WWLS','Joachimsthal Kaiserbahnhof',8013279,13.755016,52.963952],
['DJA','Jocketa',8011963,12.170103,50.555297],
['RJO','Jockgrim Bf',8003125,8.272272,49.092289],
['XFJF','Joeuf',8701317,6.017705,49.22501],
['DJ','Johanngeorgenstadt',8011967,12.728736,50.437596],
['XFJY','Joigny(Lar.Migennes)',8700561,3.393081,47.973729],
['NJS','Jossa',8003129,9.604178,50.232506],
['OFJP','Juan-Les-Pins',8700313,7.111879,43.571147],
['XAJ','Judenburg',8100073,14.6626510154222,47.1749452895542],
['MJUL','Julbach',8003136,12.958025,48.250895],
['TJUH','Jungingen(Hohenz)',8007223,9.038123,48.326187],
['TJNU','Jungnau',8007234,9.213664,48.139161],
['XBJV','Juslenville',8800589,5.810115,50.544484],
['XFJU','Juvisy',8700352,2.383238,48.689508],
['SJF','Jägersfreude',8003108,7.00497,49.265758],
['BJW','Jänschwalde',8011944,14.500761,51.866273],
['BJWO','Jänschwalde Ost',8011945,14.541248,51.877817],
['LJV','Jävenitz',8011946,11.493067,52.519664],
['RJL','Jöhlingen',8003127,8.575224,49.02818],
['RJLW','Jöhlingen West',8079058,8.569975,49.030939],
['DJZ','Jößnitz',8011966,12.139827,50.537618],
['AJ','Jübek',8000334,9.405438,54.558782],
['KJUC','Jüchen',8003130,6.500923,51.097113],
['KJ','Jülich',8000188,6.367977,50.919381],
['KJAA','Jülich An den Aspen',8003114,6.357111,50.936068],
['KJSU','Jülich Forschungszentrum',8007815,6.392244,50.898594],
['KJB','Jülich-Broich',8007801,6.342104,50.947237],
['KJND','Jülich-Nord',8007802,6.366587,50.928899],
['KJSE','Jülich-Selgersdorf',8007814,6.40829,50.890229],
['KJU','Jünkerath',8003135,6.580939,50.344769],
['BJUE','Jüterbog',8010182,13.054353,51.997509],
['LJR','Jütrichau',8011969,12.12617046,51.93431345],
['PQEKN','KIT-Campus Nord Bahnhof, Eggenstein-Leopoldshafen',720846,8.43033,49.097069],
['FKBH1','KVG-Betriebshof, Kassel',710446,9.521294,51.309604],
['KKAI','Kaarst IKEA',8000438,6.629881,51.217023],
['KKMI','Kaarst Mitte/Holzbüttgen',8000432,6.617246,51.219504],
['KKAA','Kaarster Bahnhof',8003141,6.607274,51.222551],
['KKSE','Kaarster See',8000430,6.593977,51.226689],
['BKAB','Kablow',8011981,13.721351,52.300067],
['XTKA','Kadan-Prunerov',5400071,13.258141,50.41134],
['FKLPK','Kahl Kopp/Heide',8070164,9.01577,50.079145],
['FKLM','Kahl(Main)',8003143,9.005468,50.07687],
['UKA','Kahla(Thür)',8011985,11.589104,50.808926],
['XSKI','Kaiseraugst',8500300,7.72412101575612,47.5384906333521],
['SKAI','Kaisersesch',8003148,7.129573,50.232102],
['SGSZ','Kaiserslautern Galgenschanze',8002175,7.744124,49.43549],
['SKL','Kaiserslautern Hbf',8000189,7.768716,49.436137],
['SKLP','Kaiserslautern Pfaffwerk',8003150,7.751248,49.434714],
['SKLW','Kaiserslautern West',8003151,7.749812,49.447535],
['SKLH','Kaiserslautern-Hohenecken',8002943,7.6997976,49.41617239],
['OSKAI','Kaiserstuhl AG',8503413,8.41884,47.56657],
['NKAL','Kalchreuth',8003154,11.139993,49.558442],
['KKAK','Kaldenkirchen',8000190,6.203225,51.327184],
['KKAB','Kalenborn(Westerw)',8070018,7.312721,50.615535],
['XFKH','Kalhausen',8700314,7.12519544,49.0351694],
['KKAL','Kall',8003158,6.557283,50.538493],
['XBKH','Kalmthout',8800183,4.466506,51.391375],
['XAKAL','Kalsdorf b.Graz',8101019,15.469937,46.964357],
['WKAR','Kalsow',8011995,11.57835,53.925699],
['MKBG','Kaltenberg',8070973,11.001326,48.124545],
['OAKAL','Kaltenbrunnen im Montafon',8100282,9.888115,47.085384],
['NKCK','Kalteneck',8070807,13.453011,48.689385],
['AKTKS','Kaltenkirchen Süd',8007204,9.973065,53.823588],
['AKTK','Kaltenkirchen(Holst)',8007054,9.966825,53.834417],
['EKAL','Kalthof(Kr Iserlohn)',8003166,7.672364,51.425059],
['XAK','Kalwang',8100126,14.7443470718751,47.4233995202874],
['EKAM','Kamen',8003168,7.661,51.585224],
['EKME','Kamen-Methler',8003169,7.613056,51.567379],
['OTKUB','Kamenny Ujezd u C.B.',5401433,14.448883,48.891179],
['DKA','Kamenz(Sachs)',8011988,14.092192,51.273781],
['FKMP','Kamp-Bornhofen',8003170,7.618251,50.227988],
['XNKM','Kampen Zuid',8400360,5.4938888549805,52.5331],
['ONK','Kampen(NL)',8400353,5.5055556297302,52.559722900391],
['RKD','Kandel',8003172,8.198025,49.07914],
['RKA','Kandern',8070450,7.656905,47.713491],
['XSKA','Kandersteg',8507475,7.67126537051752,46.4955238840939],
['SKAZ','Kanzem',8003173,6.573666,49.669359],
['ONKA','Kapelle-Biezelinge',8400354,5.4813890457153,51.480834960938],
['XBKP','Kapellen(B)',8800072,4.432653,51.313376],
['RKPD','Kapellen-Drusweiler',8003175,8.030754,49.105621],
['KKAW','Kapellen-Wevelinghoven',8003174,6.621061,51.129795],
['LKPB','Kapen Biosphärenreservat',8070260,12.33669,51.816483],
['XAKP','Kapfenberg',8100031,15.2920523197463,47.4451033791557],
['OTKP','Kaplice',5400299,14.467653,48.775146],
['RKPP','Kappelrodeck',8007004,8.116094,48.593404],
['RKPO','Kappelrodeck Ost',8077004,8.125834,48.586925],
['RKPW','Kapsweyer',8007859,8.022177,49.038878],
['OMKA','Karcag',5500054,20.929405,47.30336],
['PTANE','Karez',5473160,13.77925,49.822704],
['XTKAJ','Karlov pod Jestedem',5401443,14.983921,50.77378],
['XTKV','Karlovy Vary',5400006,12.86685,50.235668],
['XTKVD','Karlovy Vary dolni n.',5400242,12.864007,50.230413],
['WKAB','Karlsburg',8011991,13.609802,53.982447],
['RKF','Karlsdorf',8003181,8.547872,49.144484],
['WKH','Karlshagen',8011992,13.83143,54.116755],
['RKAB','Karlsruhe Albtalbahnhof',8079045,8.39611,48.993707],
['RKV','Karlsruhe Bahnhofsvorplatz',8079041,8.399587,48.994346],
['RKDT','Karlsruhe Durlacher Tor/KIT-Campus Süd',8079125,8.41788,49.008815],
['RKEF','Karlsruhe Entenfang',8079126,8.359504,49.010666],
['RK','Karlsruhe Hbf',8000191,8.402181,48.993515],
['RK  S','Karlsruhe Hbf Südausgang',8089390,8.400955,48.991717],
['RKMAK','Karlsruhe Marktplatz (Kaiserstraße)',8079035,8.404555,49.009554],
['RKMT','Karlsruhe Mühlburger Tor',8079144,8.386728,49.010457],
['RKW','Karlsruhe West',8003183,8.362951,49.002159],
['RKDU','Karlsruhe-Durlach',8003184,8.462822,49.002328],
['RKHA','Karlsruhe-Hagsfeld',8003185,8.453645,49.025938],
['RKSR','Karlsruhe-Kniel. Rheinbergstr.',8079128,8.336613,49.035015],
['RKIN','Karlsruhe-Knielingen',8003186,8.341171,49.026695],
['RKMG','Karlsruhe-Mühlburg',8003187,8.351126,49.014557],
['RKNEK','Karlsruhe-Neureut Kirchfeld',8079047,8.388835,49.052912],
['NKA','Karlstadt(Main)',8003189,9.768148,49.962899],
['WKA','Karow(Meckl)',8010188,12.272118,53.540373],
['MKH','Karpfham',8003191,13.187394,48.40799],
['UKF B','Karsdorf',8011993,11.655766,51.280688],
['WKT','Karstädt',8011994,11.738618,53.160684],
['SKU','Karthaus',8000402,6.596854,49.71034],
['KKBA','Kasbach',8070019,7.260031,50.585644],
['KKBB','Kasbach Brauerei Steffens',8070021,7.259105,50.591964],
['FK','Kassel Hbf',8000193,9.489501,51.31826],
['FKKVG','Kassel Hbf (tief)',8098193,9.489787,51.318196],
['FKH','Kassel-Harleshausen',8003196,9.45225,51.332178],
['FKJK','Kassel-Jungfernkopf',8003197,9.462869,51.338918],
['FKKD','Kassel-Kirchditmold',8003198,9.452204,51.324561],
['FKOZ','Kassel-Oberzwehren',8003199,9.454028,51.276348],
['FKW','Kassel-Wilhelmshöhe',8003200,9.446898,51.313114],
['MKAT','Kastl(Oberbay)',8003205,12.712856,48.192327],
['AKAD','Katharinenheerd',8003207,8.830489,54.334163],
['AKTO','Kating',8003208,8.872281,54.32603],
['HKAT','Katlenburg',8003209,10.09974,51.686158],
['XPKA','Katowice',5100020,19.017165,50.257515],
['SKTS','Kattenes',8003211,7.439211,50.254327],
['EKV','Kattenvenne',8003212,7.860281,52.113273],
['FKFT','Katzenfurt',8003213,8.343189,50.615947],
['UKH','Katzhütte',8011999,11.06111,50.561065],
['NKG','Katzwang',8003214,11.042543,49.355372],
['SKW','Katzweiler',8003215,7.700935,49.500082],
['FKAU','Kaub',8003216,7.768197,50.083635],
['MKFB','Kaufbeuren',8000194,10.629496,47.875432],
['MKFG','Kaufering',8000195,10.854595,48.080835],
['UKL','Kaulsdorf(Saale)',8012000,11.433642,50.611341],
['XLKT','Kautenbach',8270630,6.021703,49.949187],
['WKV','Kavelstorf(Kr Rostock)',8012002,12.197821,54.007081],
['OAKFM','Kefermarkt',8100536,14.538029,48.436972],
['RKL','Kehl',8003218,7.806556,48.576658],
['TKEH','Kehlen',8003220,9.548184,47.683031],
['XSKH','Kehlhof',8506193,9.16976823983709,47.5721849531574],
['AKI','Keitum',8003222,8.368969,54.888814],
['FKE','Kelkheim',8007161,8.447663,50.137284],
['FKHO','Kelkheim-Hornau',8007162,8.44454,50.14702],
['FKEM','Kelkheim-Münster',8007160,8.461687,50.124874],
['MKMZ','Kellmünz',8003227,10.124616,48.120286],
['FKCH','Kelsterbach',8003228,8.529479,50.06249],
['XAKM','Kematen in Tirol',8101038,11.2772685582648,47.2610236593306],
['NKNN','Kemnath-Neustadt',8003229,11.862262,49.843906],
['KKEM','Kempen(Niederrhein)',8000409,6.425549,51.367564],
['MKP','Kempten(Allgäu)Hbf',8000197,10.31761,47.711745],
['MKPO','Kempten(Allgäu)Ost',8003230,10.33205,47.731293],
['DKAU','Kemtau',8012004,12.953921,50.742944],
['SKEN','Kennelgarten',8003232,7.733013,49.440998],
['WKEN','Kenz',8012005,12.741013,54.329875],
['RKN','Kenzingen',8003233,7.764094,48.194451],
['FKB','Kerkerbach',8003235,8.135882,50.401962],
['ONKD','Kerkrade Centrum',8400355,5.4727778434753,50.861667633057],
['BKE','Kerkwitz',8012006,14.627567,51.909578],
['NKCH','Kersbach',8003238,11.059544,49.684987],
['XSKW','Kesswil',8506123,9.31740544782057,47.5954978155944],
['XNKE','Kesteren',8400359,5.45718,51.9313869],
['FKES','Kestert',8003241,7.648978,50.187065],
['EKG','Kettwig',8000198,6.953747,51.363375],
['EKGS','Kettwig Stausee',8003245,6.939145,51.356608],
['KKEV','Kevelaer',8003247,6.252227,51.581008],
['TKBI','Kiebingen',8003248,8.973745,48.479369],
['UKIE','Kiebitzhöhe',8012007,11.203555,51.181028],
['MKI','Kiefersfelden',8003249,12.190473,47.609907],
['AK','Kiel Hbf',8000199,10.131976,54.314985],
['AKSL','Kiel Schulen am Langsee',8003251,10.156965,54.307205],
['AKEL','Kiel-Ellerbek',8003259,10.1700729,54.3141169],
['AKE','Kiel-Elmschenhagen',8003477,10.180414,54.287142],
['AKH','Kiel-Hassee CITTI-PARK',8003474,10.098596,54.310569],
['AOPD','Kiel-Oppendorf',8003260,10.208319,54.325961],
['AKRU','Kiel-Russee',8003253,10.070212,54.31004],
['EKIE','Kierspe',8003297,7.61622906,51.1300136],
['PQSKH','Kieselhumes, Saarbrücken',837234,7.017393,49.228139],
['XBKU','Kijkuit',8800192,4.467126,51.379393],
['XSKB','Kilchberg(CH)',8503200,8.54799908563018,47.32442740643],
['TKLR','Killer',8007224,9.060828,48.315684],
['XSKS','Killwangen-Spreitenbach',8503506,8.3541943098573,47.4333282379529],
['OMKIM','Kimle-Karolyhaza',5500653,17.341621,47.804356],
['OAKIM','Kimpling',8101045,13.670939,48.266653],
['XAKB','Kindberg',8100030,15.4484055513883,47.5011332316571],
['MKIG','Kinding(Altmühltal)',8003256,11.377501,48.992694],
['SKIB','Kindsbach',8003257,7.612836,49.419371],
['FKGS','Kirch Göns',8003262,8.666869,50.473373],
['WKJ','Kirch-Jesar',8012009,11.263321,53.448596],
['MKAG','Kirchanschöring',8003263,12.831517,47.953415],
['XAKG','Kirchberg in Tirol',8100057,12.3091673722213,47.4488871524999],
['TKIM','Kirchberg(Murr)',8003266,9.329056,48.939161],
['XAKL','Kirchbichl',8100290,12.094194686665,47.5198304376909],
['HKDF','Kirchdorf(Deister)',8003267,9.491936,52.289852],
['XAKK','Kirchdorf/Krems',8100170,14.116244,47.906435],
['NKIR','Kirchehrenbach',8003268,11.141641,49.735444],
['EKIR','Kirchen',8000427,7.880509,50.806576],
['NKL','Kirchenlaibach',8000201,11.776325,49.869904],
['NKO','Kirchenlamitz Ost',8003270,11.985965,50.165496],
['TKI','Kirchentellinsfurt',8003272,9.13948,48.528749],
['FKBHG','Kirchgasse, Kassel',713491,9.527878,51.305657],
['FKIH','Kirchhain(Bz Kassel)',8000435,8.921399,50.823779],
['HKHW','Kirchhammelwarden',8003276,8.475233,53.305655],
['TKM','Kirchheim(Neckar)',8003278,9.150903,49.037646],
['TKT','Kirchheim(Teck)',8003280,9.443927,48.644258],
['TKTO','Kirchheim(Teck)-Ötlingen',8003282,9.416291,48.657764],
['TKTS','Kirchheim(Teck)Süd',8003283,9.451788,48.640261],
['TKU','Kirchheim(Unterfr)',8003284,9.857713,49.656749],
['RKH','Kirchheim(Weinstr)',8003285,8.181452,49.537163],
['FKIR','Kirchheimbolanden',8000652,8.016526,49.668545],
['HKHN','Kirchhorsten',8003286,9.119783,52.307875],
['EKHU','Kirchhundem',8003287,8.078103,51.086068],
['HKLG','Kirchlengern',8003288,8.643778,52.196755],
['LKIM','Kirchmöser',8012011,12.422206,52.375235],
['UKI','Kirchscheidungen',8012012,11.66257,51.2447],
['MKO','Kirchseeon',8003290,11.887255,48.0709],
['MKW','Kirchweidach',8084066,12.648475,48.092999],
['HKI','Kirchweyhe',8003292,8.847236,52.983765],
['RKZ','Kirchzarten',8003293,7.959132,47.967936],
['SKI','Kirkel',8003294,7.226601,49.286245],
['SKR','Kirn',8003295,7.464589,49.785769],
['RKBG','Kirnbach-Grün',8007104,8.105907,48.36193],
['SKRS','Kirnsulzbach',8003298,7.435477,49.762324],
['RKBV','Kirschbaumwasen',8003289,8.355684,48.623055],
['MKIS','Kissing',8003299,10.959553,48.300922],
['OMKZ','Kisujszallas',5500126,20.751643,47.223985],
['XAKIT','Kittsee',8100373,17.0717371492073,48.0816777663134],
['XAKI','Kitzbühel',8100055,12.3910460811951,47.4542605925096],
['XAKIH','Kitzbühel Hahnenkamm',8101044,12.3896431123102,47.4434636491778],
['OASSE','Kitzbühel Schwarzsee',8101593,12.370523,47.453435],
['NKN','Kitzingen',8000479,10.155214,49.732497],
['TKG','Kißlegg',8000203,9.881921,47.793533],
['DNK K','Klaffenbach Hp',8017421,12.903751,50.772286],
['XAKT','Klagenfurt Hbf',8100085,14.313569,46.615584],
['MKLA','Klais',8003302,11.238589,47.483032],
['BKLD','Klandorf',8012015,13.555957,52.877938],
['AKX','Klanxbüll',8003303,8.676454,54.861997],
['ONKL','Klarenbeek',8400361,5.4564285,52.17805480957],
['BKDF','Klasdorf Glashütte',8012016,13.543711,52.021383],
['XTKY','Klatovy',5400213,13.274112,49.401489],
['OAKV','Klaus in Vorarlberg',8101100,9.624272,47.308944],
['AKC','Klecken',8003309,9.928922,53.366207],
['XAKE','Kledering b.Wien',8101051,16.439313,48.133002],
['WKB','Klein Bünzow',8012021,13.62244,53.923657],
['FKGE','Klein Gerau',8003313,8.51674,49.919849],
['FKWO','Klein Winternheim-Ober Olm',8003316,8.207097,49.939619],
['MKHN','Kleinberghofen',8003317,11.275478,48.354045],
['XLKB','Kleinbettingen',8200520,5.91621,49.64381],
['SKB','Kleinblittersdorf',8003318,7.03365514,49.15849521],
['KKLE','Kleinenbroich',8003321,6.551972,51.195662],
['HKSI','Kleinensiel',8003323,8.476006,53.444736],
['UKFA','Kleinfurra',8012033,10.763196,51.417407],
['NKGM','Kleingemünden',8003329,9.687704,50.062991],
['NKLH','Kleinheubach',8003324,9.207476,49.721423],
['UKJ','Kleinjena',8012034,11.781279,51.180265],
['RKES','Kleinkems',8003325,7.524662,47.686129],
['MKKZ','Kleinkötz',8003326,10.288497,48.411659],
['FKO','Kleinostheim',8003314,9.072252,50.002645],
['DKRD','Kleinröhrsdorf',8012036,13.990052,51.134175],
['DKMA','Kleinschirma',8012037,13.281817,50.902581],
['RKBA','Kleinsteinbach',8003331,8.5549,48.966745],
['NKT','Kleinwallstadt',8003334,9.168168,49.87491],
['KKLV','Kleve',8000205,6.146224,51.789734],
['LKK','Klieken',8012040,12.371778,51.89453],
['ONKLR','Klimmen-Ransdaal',8400362,5.4558334350586,50.866390228271],
['BKG','Klinge',8012043,14.518271,51.743608],
['NKM','Klingenberg(Main)',8003337,9.176549,49.781419],
['DKC','Klingenberg-Colmnitz',8012044,13.501014,50.92597],
['NKNB','Klingenbrunn',8003338,13.33618,48.944698],
['DKN','Klingenthal',8012045,12.462677,50.357163],
['PSAXH','Klingnau',8516176,8.24873,47.58213],
['HBKM','Klinikum Bremen-Nord/Beckedorf',8007893,8.595206,53.185254],
['LKLM','Klitschmar',8012046,12.228895,51.508306],
['BKL','Klitten',8012047,14.59074098,51.34858175],
['TBR','Kloster Bronnbach',8001193,9.543516,49.715144],
['KKLM','Kloster Marienthal',8003340,7.668528,50.738647],
['HKOE','Kloster Oesede',8004627,8.111626,52.200591],
['DKLB','Klosterbuch',8012053,13.00406,51.157622],
['BKLF','Klosterfelde',8012054,13.488131,52.791376],
['MKLF','Klosterlechfeld',8003342,10.83263,48.155393],
['LKM','Klostermansfeld',8010191,11.491904,51.574682],
['LKMR','Klostermansfeld Randsiedlung',8010204,11.498588,51.590999],
['RKLB','Klosterreichenbach',8003343,8.399008,48.526627],
['XSKT','Kloten',8503308,8.58379121248714,47.4486070251005],
['SKT','Klotten',8003344,7.203262,50.165328],
['LKD H','Kläden(Stendal)',8012014,11.654836,52.637814],
['HKNE','Knesebeck',8003348,10.690267,52.677812],
['RKEG','Knielingen Eggensteiner Straße, Karlsruhe',723871,8.338104,49.033607],
['RKIH','Knielingen Herweghstraße, Karlsruhe',721509,8.341001,49.030687],
['PQKRC','Knielingen Rheinbergstraße (Schleife), Karlsruhe',723325,8.336614,49.03488],
['RKIS','Knielingen Siemens, Karlsruhe',721520,8.346364,49.025215],
['PQKKA','Knielinger Allee/Städt. Klinikum, Karlsruhe',721389,8.375443,49.018841],
['XAKF','Knittelfeld',8100072,14.8376651906696,47.2152169502983],
['TKNK','Knittlingen-Kleinvillars',8003332,8.744536,48.993444],
['RKG','Knöringen-Essingen',8003349,8.148265,49.23817],
['SKG','Kobern-Gondorf',8003350,7.46075,50.300718],
['OSKOD','Koblenz Dorf',8503411,8.24013,47.60939],
['KKO','Koblenz Hbf',8000206,7.588345,50.350929],
['KKSM','Koblenz Stadtmitte',8003341,7.589985,50.357714],
['XSKO','Koblenz(CH)',8500329,8.22702315842398,47.6003354815496],
['KKOE','Koblenz-Ehrenbreitstein',8003351,7.610202,50.361746],
['SGS','Koblenz-Güls',8002454,7.549171,50.340305],
['KKOL','Koblenz-Lützel',8003352,7.591607,50.367487],
['SKOW','Koblenz-Moselweiß',8003354,7.560646,50.349463],
['MKCH','Kochel',8003355,11.370987,47.66065],
['BKOD','Kodersdorf',8012061,14.916232,51.259554],
['XDKH','Koebenhavn H',8601309,12.564617,55.672722],
['XDKHL','Koebenhavns Lufthavn st',8601242,12.649382,55.629605],
['XFKO','Kogenheim',8701340,7.535225,48.338915],
['KKOS','Kohlscheid',8003395,6.074485,50.831728],
['TKOS','Kohlstetten',8070458,9.332438,48.400763],
['MKMR','Kolbermoor',8003397,12.064147,47.851926],
['XAKO','Kolbnitz',8100091,13.3222309777453,46.8781666025054],
['XDKO','Kolding st',8601318,9.481528,55.490841],
['XTKI','Kolin(CZ)',5400022,15.214279,50.025438],
['BKOW','Kolkwitz',8012083,14.250169,51.75773],
['BKOS','Kolkwitz Süd',8012084,14.242179,51.746913],
['RKLR','Kollmarsreute',8003398,7.887074,48.098271],
['RKNA','Kollnau',8003399,7.973842,48.101151],
['XMKO','Komarom',5500012,18.114153,47.749688],
['RKMK','Kongresszentrum (U), Karlsruhe',901013,8.40307,49.00249],
['PQKVS','Kongresszentrum, Karlsruhe',367072,8.404054,49.003793],
['XPKN','Konin',5100026,18.253336,52.231397],
['RKO','Konstanz',8003400,9.177312,47.658754],
['RKOH','Konstanz Hafen',8073400,9.179538,47.659864],
['RKOF','Konstanz-Fürstenberg',8003404,9.162847,47.677479],
['RKOP','Konstanz-Petershausen',8003401,9.173468,47.674092],
['RKOW','Konstanz-Wollmatingen',8003416,9.147331,47.682453],
['SKZ','Konz',8003402,6.573294,49.695388],
['SKZM','Konz Mitte',8003403,6.573757,49.70024],
['PQKKH','Konzerthaus, Karlsruhe',721392,8.39976,49.003611],
['XNKB','Koog aan de Zaan',8400363,5.4338889122009,52.458610534668],
['FKOB','Korbach Hbf',8000210,8.873229,51.278712],
['FKBS','Korbach Süd',8003406,8.878815,51.270264],
['SKDL','Kordel',8003407,6.634933,49.836367],
['RKOR','Kork',8003408,7.874797,48.570019],
['OAKOB','Korneuburg',8100293,16.328932,48.342935],
['TKO','Korntal',8003409,9.121168,48.826416],
['TKO G','Korntal Gymnasium',8007855,9.112353,48.831057],
['TKH','Kornwestheim Pbf',8003411,9.179964,48.862219],
['KKOI','Korschenbroich',8003412,6.511886,51.19565],
['XDKS','Korsoer st',8601343,11.135125,55.357201],
['XBKO','Kortenberg',8800249,4.54099,50.892734],
['XBKK','Kortrijk',8800077,3.264297,50.824461],
['WKO','Koserow',8012086,13.999275,54.045335],
['NKMG','Kothmaißling',8003413,12.729367,49.242912],
['KKOH','Kottenheim',8003415,7.248906,50.348974],
['ONKOM','Koudum-Molkwerum',8400366,5.4251932,52.9028197],
['ONKR','Krabbendijke',8400367,5.423063,51.433334350586],
['UKR','Kraftsdorf',8012088,11.930855,50.878075],
['BFIK','Kraftwerk Finkenheerd',8012089,14.575654,52.263228],
['EKRG','Kraghammer',8003420,7.873762,51.109134],
['XPKR','Krakow Glowny',5100028,19.947426,50.067194],
['OPKRP','Krakow Plaszow',5100240,19.974894,50.035092],
['XTKR','Kralupy nad Vltavou',5400126,14.313473,50.238729],
['XAKA','Kranebitten',8100551,11.3286149683013,47.2696230257977],
['UKD','Kranichfeld',8012092,11.203225,50.856335],
['XZKJ','Kranj',7900014,14.348167,46.239011],
['XTKC','Kraslice',5401594,12.50316,50.330351],
['XTKCP','Kraslice predmesti',5401595,12.518783,50.311694],
['XTKP','Kraslice-Pod vlekem',5403835,12.496783,50.340585],
['XTKLP','Krasna Lipa',5401597,14.512289,50.91902],
['XTKLM','Krasna Lipa mesto',5401598,14.512049,50.907432],
['WKG','Kratzeburg',8012093,12.941627,53.427803],
['KNKR','Krauthausen',8007816,6.42327,50.878662],
['EKRD','Kredenbach',8003424,8.042776,50.963257],
['KKR','Krefeld Hbf',8000211,6.569885,51.325717],
['KHB','Krefeld-Hohenbudberg Chempark',8002941,6.66446,51.373529],
['KKRL','Krefeld-Linn',8003426,6.629668,51.337305],
['KKRO','Krefeld-Oppum',8000212,6.61009,51.329749],
['KKRX','Krefeld-Uerdingen',8003427,6.645778,51.357278],
['HK','Kreiensen',8000213,9.967798,51.851423],
['SKRB','Kreimbach-Kaulbach',8003429,7.631296,49.55149],
['BKRM','Kremmen',8012096,13.040231,52.753347],
['AKM','Krempe',8003430,9.481757,53.834111],
['AKHD','Kremperheide',8003431,9.480377,53.881178],
['XAKD','Krems an der Donau',8100295,15.604964,48.408932],
['LKNZ','Krensitz',8012097,12.46197,51.490449],
['TKN','Kressbronn',8003432,9.598854,47.594239],
['RKRB','Kressbronn Hafen',8073432,9.599262,47.586184],
['DKRO','Kretscham-Rothensehma',8012098,12.988245,50.46721],
['SKK','Kreuz Konz',8003434,6.576866,49.703798],
['KKUZ','Kreuzau Bahnhof',8007820,6.488409,50.75075],
['KKUZE','Kreuzau-Eifelstraße',8007830,6.49194,50.742798],
['XSKR','Kreuzlingen',8506131,9.16906514322919,47.6525540443623],
['XSKRB','Kreuzlingen Bernrain',8506197,9.16318719460646,47.6421167081071],
['XSKL','Kreuzlingen Hafen',8506128,9.18196081638044,47.6491676497374],
['MKZ','Kreuzstraße',8003438,11.759014,47.916494],
['EKT','Kreuztal',8000214,7.991696,50.956029],
['ELTF','Kreuztal-Littfeld',8003716,7.987142,51.00719],
['FKRI','Kriftel',8003442,8.475448,50.08228],
['XFKM','Krimmeri-Meinau',8733852,7.752633,48.563622],
['DKRP','Krippen',8012105,14.160425,50.913082],
['XTKZY','Krizany',5401655,14.918633,50.751388],
['XNKA','Krommenie-Assendelft',8400368,5.4222221374512,52.49511],
['NK','Kronach',8003446,11.320115,50.239612],
['FKRS','Kronberg Süd',8087063,8.529183,50.173304],
['FKRO','Kronberg(Taunus)',8003447,8.516874,50.179919],
['RKBP','Kronenplatz (U), Karlsruhe',721394,8.408456,49.009426],
['RKBPS','Kronenplatz, Karlsruhe',721393,8.409938,49.007977],
['AKRH','Kronshagen',8003479,10.083155,54.331211],
['WKRP','Kronskamp',8012109,12.315387,53.933556],
['SKRO','Kronweiler',8003452,7.262416,49.655588],
['XNKR','Kropswolde',8400369,5.4112885,53.1617362],
['XZKR','Krsko',7900030,15.4934537,45.956241],
['KKRF','Kruft',8003455,7.338598,50.390541],
['ONKUY','Kruiningen-Yerseke',8400370,5.4106913,51.465000152588],
['MKRB','Krumbach(Schwab)',8003457,10.358619,48.24759],
['MKRS','Krumbach(Schwab)Schule',8001179,10.361165,48.23542],
['DKRU','Krumhermsdorf',8012113,14.207348,50.992963],
['LKRP','Krumpa',8012114,11.854636,51.289437],
['XAKR','Krumpendorf/Wörthersee',8100079,14.221512,46.626333],
['AKRS','Krupunder',8003460,9.867762,53.615823],
['XTKRU','Krystofovo Udoli',5401638,14.941276,50.771902],
['XPKZG','Krzewina Zgorzelecka',5100244,14.939365,51.015358],
['UKPR','Krölpa-Ranis',8012107,11.54332,50.677118],
['WKR','Kröpelin',8012108,11.791573,54.069137],
['DKU','Kubschütz',8012115,14.509634,51.165726],
['TKUC','Kuchen',8003461,9.8034,48.640523],
['XAKU','Kuchl',8100546,13.1421473013548,47.6249473930203],
['PASEQ','Kuchl Garnei',8102047,13.128377,47.651503],
['XAKN','Kufstein',8100001,12.1656680163989,47.5833802441703],
['RKUL','Kullenmühle, Bad Herrenalb',723532,8.443993,48.808925],
['NKU','Kulmbach',8003476,11.451889,50.109822],
['WKUM','Kummerow(Stralsund)',8012127,12.884616,54.298331],
['BKUM','Kummersdorf(Storkow)',8012129,13.874126,52.275064],
['OAKMU','Kumpfmühl',8101063,13.620204,48.269682],
['XAKUN','Kundl',8100100,11.982068,47.475983],
['BPA','Kunersdorf',8012605,14.188364,51.76864],
['XPKU','Kunowice',5100083,14.638813,52.341665],
['AKUP','Kupfermühle',8003478,10.326795,53.762446],
['RKU','Kuppenheim',8003480,8.256112,48.834128],
['DAG','Kurort Altenberg(Erzgebirge)',8011019,13.753634,50.766298],
['DKJ','Kurort Jonsdorf',8012131,14.70661,50.853855],
['DKJH','Kurort Jonsdorf Hst',8012132,14.725668,50.862151],
['DKP','Kurort Kipsdorf',8012133,13.6765462,50.8059076],
['DKOW','Kurort Oberwiesenthal',8012134,12.971981,50.421178],
['DKOY','Kurort Oybin',8012135,14.745577,50.843662],
['DKON','Kurort Oybin-Niederdorf',8012136,14.753624,50.862166],
['DRAT','Kurort Rathen',8012138,14.075341,50.956816],
['PQKKS','Kurt-Schumacher-Straße, Karlsruhe',721396,8.37635,49.030263],
['SKUS','Kusel',8003481,7.410329,49.538282],
['AKTH','Kutenholz',8007844,9.309961,53.470379],
['XRKU','Kutina',7800034,16.7738427,45.4752481],
['XPKT','Kutno',5100032,19.348615,52.226963],
['XYKU','Kuty',5600081,17.047695,48.661893],
['MKUN','Kutzenhausen',8003483,10.696338,48.334775],
['OPKWC','Kwieciszowice',5101849,15.502617,50.925033],
['LKYA','Kyhna',8012141,12.265928,51.511018],
['SKY','Kyllburg',8003484,6.597027,50.04193],
['WKY','Kyritz',8012142,12.390945,52.942491],
['WKYA','Kyritz Am Bürgerpark',8017159,12.38994,52.949017],
['XTKT','Kytlice',5401683,14.533679,50.814815],
['FKAE','Kälberau',8007276,9.091445,50.090911],
['LKF','Kämmereiforst',8011983,12.540793,51.4763],
['NKI','Köditz',8003356,11.848109,50.328888],
['NKOE','Köfering',8003357,12.20875,48.931716],
['UKOE','Kölleda',8012064,11.244906,51.180274],
['KBP','Köln Airport-Businesspark',8003370,7.044451,50.910282],
['KKFS','Köln Frankfurter Straße',8003358,7.051262,50.915219],
['KKP','Köln Geldernstr./Parkgürtel',8003360,6.941413,50.968551],
['KKHR','Köln Hansaring',8003392,6.952565,50.949131],
['KK','Köln Hbf',8000207,6.958729,50.94303],
['KKDZ','Köln Messe/Deutz',8003368,6.975001,50.940874],
['KKDT','Köln Messe/Deutz Gl.11-12',8073368,6.974067,50.941721],
['KSTP','Köln Steinstraße',8003379,7.057173,50.895558],
['KKS','Köln Süd',8003361,6.938059,50.9273],
['KKTR','Köln Trimbornstr',8003320,6.996734,50.935857],
['KKV','Köln Volkhovener Weg',8003362,6.893241,51.014251],
['KKW','Köln West',8003363,6.934389,50.943665],
['KKBL','Köln-Blumenberg',8079140,6.881921,51.037414],
['KKBH','Köln-Buchforst',8003364,7.004327,50.953487],
['KKC','Köln-Chorweiler',8003365,6.897824,51.021126],
['KKCN','Köln-Chorweiler Nord',8003366,6.892772,51.028126],
['KKDB','Köln-Dellbrück',8003367,7.070124,50.981437],
['KKER','Köln-Ehrenfeld',8000208,6.917276,50.951533],
['KKH','Köln-Holweide',8003369,7.041235,50.97627],
['KKL','Köln-Longerich',8003371,6.901557,50.997736],
['KKM','Köln-Mülheim',8000209,7.013295,50.957986],
['KKMT','Köln-Müngersdorf Technologiepark',8003375,6.888201,50.948394],
['KKN','Köln-Nippes',8003372,6.941605,50.958666],
['KKSH','Köln-Stammheim',8003310,7.002095,50.99007],
['KKWW','Köln-Weiden West',8003383,6.815137,50.9409],
['KKWO','Köln-Worringen',8003373,6.851719,51.052378],
['KFKB','Köln/Bonn Flughafen',8003330,7.119302,50.878901],
['WKP','Kölpinsee',8012065,14.022905,54.03529],
['RKOE','Köndringen',8003374,7.802925,48.137458],
['BKW','Königs Wusterhausen',8010193,13.631472,52.296635],
['TKB','Königsbach(Baden)',8003376,8.608931,48.962584],
['LKB','Königsborn',8012066,11.756268,52.134011],
['TKS','Königsbronn',8003378,10.116135,48.739518],
['DKB','Königsbrück',8012067,13.900231,51.260204],
['RKHS','Königschaffhausen',8007286,7.658069,48.13719],
['TKF','Königshofen(Baden)',8003381,9.724669,49.546022],
['FKHN','Königshofen(Kahl)',8007281,9.205986,50.058847],
['HKOL','Königslutter',8003382,10.812489,52.257166],
['FKKPL','Königsplatz, Kassel',714222,9.497927,51.315791],
['EKSO','Königsstollen',8003385,7.933989,50.776527],
['DKOH','Königstein(Sächs Schw)',8012072,14.078899,50.919445],
['FKOE','Königstein(Taunus)',8007164,8.468693,50.177917],
['KKOW','Königswinter',8003386,7.193592,50.678638],
['KKOWF','Königswinter Fähre',8070029,7.192572,50.672765],
['KKOWA','Königswinter, Clemens-August-Str.',8070074,7.189242,50.676888],
['UKZ','Könitz(Thür)',8012075,11.487168,50.660159],
['LKO','Könnern',8010194,11.779905,51.674069],
['FKP','Köppern',8007849,8.646921,50.269615],
['FKRL','Körle',8003388,9.513137,51.171588],
['XMKR','Körmend',5500127,16.597209,47.016127],
['XAWEG','Köstendorf Weng',8100594,13.175346,47.936749],
['LK','Köthen',8010195,11.989358,51.751929],
['DKTW','Köttewitz',8012079,13.859704,50.945143],
['LKTU','Kötzschau',8012080,12.123904,51.304463],
['SKV','Kövenig',8003394,7.119543,49.981186],
['PQKKG','Kühler Krug, Karlsruhe',723922,8.366821,49.006077],
['UKU','Kühnhausen',8010198,10.978069,51.036371],
['LKUH','Kühren',8012117,12.833196,51.349341],
['FKWB','Külte-Wetterburg',8003467,9.071138,51.396821],
['EKUE','Künsebeck',8003469,8.384227,52.036936],
['EKNT','Küntrop',8003470,7.814796,51.293399],
['NKUE','Küps',8003472,11.268337,50.195886],
['DKUR','Kürbitz',8010040,12.069771,50.462724],
['XSKN','Küssnacht am Rigi',8505002,8.43349405729859,47.0835940036376],
['BKI','Küstrin-Kietz',8010189,14.607909,52.568481],
['XFLAE','LAigle',8700315,0.620009,48.76645],
['XFLBS','La Bastide-St-Laurent les Bains',8700123,3.90398,44.592703],
['XFWBI','La Brigue(F)',8703545,7.605623,44.062568],
['XFLAT','La Charité sur Loire',8703555,3.024181,47.179947],
['PFBTF','La Frayère',8706480,6.972087,43.558103],
['XFGPL','La Plaine',8501001,5.99999627841878,46.1786594704865],
['XFLRY','La Roche sur Yon',8700069,-1.435815,46.672123],
['XFLST','La Souterraine',8701994,1.492611,46.239645],
['XALAA','Laa/Thaya',8101180,16.402639,48.723783],
['NLB','Laaber',8003485,11.884056,49.070022],
['WLA','Laage(Meckl)',8012143,12.339608,53.919599],
['MLBW','Laberweinting',8003488,12.315237,48.796839],
['XSLH','Lachen',8503220,8.8526923816567,47.1900685739673],
['RLD','Ladenburg',8003489,8.602803,49.474242],
['XNZLW','Lage Zwaluwe',8400382,5.4038887023926,51.69111251831],
['ELAG','Lage(Lippe)',8000215,8.801199,51.991742],
['MLLF','Lagerlechfeld',8003490,10.84437,48.183373],
['FLSR','Lahntal-Sarnau',8005291,8.756045,50.871196],
['RLSW','Lahr(Schwarzw)',8003494,7.834734,48.340436],
['NLCK','Laineck',8003495,11.615907,49.959351],
['OILAL','Laives/Leifers',8301615,11.323649,46.434049],
['WLD','Lalendorf',8010199,12.386421,53.755004],
['NLAM','Lam',8007345,13.051003,49.191555],
['XLLM','Lamadelaine',8200143,5.860639,49.553406],
['XALB','Lambach',8100015,13.888346,48.09409],
['OAMLB','Lambach Markt',8101223,13.87032,48.094429],
['RLBP','Lambrecht(Pfalz)',8003497,8.074391,49.373336],
['RLSH','Lambsheim',8003498,8.283476,49.511863],
['RKSL','Lameyplatz, Karlsruhe',721401,8.354494,49.013244],
['XSLMC','Lamone-Cadempino',8505219,8.93212223945651,46.0397205271346],
['FLP','Lampertheim',8003503,8.478489,49.598215],
['SLAO','Lampertsmühle-Otterbach',8003504,7.729408,49.483662],
['BLW','Lampertswalde',8012145,13.680379,51.308473],
['WLAK','Lancken',8012146,13.607885,54.518032],
['XPLAN','Lancut',5101932,22.22751,50.081431],
['MLDI','Landau(Isar)',8003506,12.695062,48.68289],
['RLA','Landau(Pfalz)Hbf',8000216,8.126204,49.197741],
['RLAD','Landau(Pfalz)Süd',8003507,8.113836,49.189514],
['RLW','Landau(Pfalz)West',8003508,8.107052,49.195748],
['XALE','Landeck-Zams',8100063,10.5809502975959,47.1492384616683],
['XBLD','Landen',8800079,5.080262,50.747801],
['XNLG','Landgraaf',8400548,6.019166469574,50.896389007568],
['XSLQ','Landquart',8509002,9.55402859224419,46.9674389763619],
['XFLA','Landry',8700444,6.733527,45.574193],
['MLLS','Landsberg(L)Schule',8005389,10.869641,48.054179],
['MLL','Landsberg(Lech)',8003512,10.871701,48.047274],
['LLBG','Landsberg(b. Halle/Saale)',8012147,12.166712,51.532899],
['LLAS','Landsberg(b. Halle/Saale) Süd',8012148,12.172315,51.504396],
['MLA','Landshut(Bay)Hbf',8000217,12.13593,48.547492],
['MLAS','Landshut(Bay)Süd',8003514,12.140728,48.523938],
['SLD','Landstuhl',8003515,7.565931,49.416287],
['SLWR','Landsweiler-Reden',8003516,7.119316,49.352246],
['FLGS','Lang Göns',8003520,8.667091,50.497939],
['NLG','Langdorf',8003521,13.161392,49.020662],
['XBLO','Langdorp',8800243,4.863541,51.002466],
['DLAB','Langebrück(Sachs)',8012150,13.841072,51.126751],
['ALAL','Langeln(Holst)',8007137,9.862105,53.791833],
['HLNG','Langelsheim',8003522,10.343173,51.93012],
['XALA','Langen am Arlberg',8100065,10.1209885152087,47.1315927917209],
['FLG','Langen(Hess)',8003523,8.656787,49.993612],
['FLGF','Langen-Flugsicherung',8003526,8.658671,50.00523],
['TLR','Langenargen',8003524,9.544837,47.599491],
['TLL','Langenau(Württ)',8003525,10.125988,48.493333],
['MLB','Langenbach(Oberbay)',8003528,11.852854,48.438097],
['RLBD','Langenbrand',8003532,8.355473,48.702272],
['ULF','Langendorf',8012155,11.959322,51.181451],
['LLGS','Langeneichstädt',8012156,11.755805,51.347286],
['KLA','Langenfeld(Rhld)',8003540,6.938278,51.102677],
['KLAB','Langenfeld(Rhld)-Berghausen',8003539,6.923684,51.11751],
['HLGM','Langenhagen Mitte',8003545,9.725427,52.440279],
['HLGH','Langenhagen Pferdemarkt',8003542,9.735882,52.450993],
['HKAW','Langenhagen-Kaltenweide',8003165,9.736342,52.480085],
['FLAH','Langenhahn',8003543,7.914633,50.587535],
['ALG','Langenhorn(Schlesw)',8003544,8.946413,54.685934],
['SLN','Langenlonsheim',8000585,7.899887,49.901372],
['ALGM','Langenmoor',8007065,9.663746,53.772441],
['ULAO','Langenorla Ost',8012159,11.592704,50.730409],
['ULAW','Langenorla West',8012160,11.579663,50.741877],
['NLP','Langenprozelten',8003548,9.661384,50.061572],
['FSLB','Langenselbold',8003550,9.057682,50.162068],
['LLAG','Langenstein',8012161,10.979275,51.860457],
['RLSB','Langensteinbach Bahnhof',8007013,8.50312,48.915256],
['PQKLS','Langensteinbach Schießhüttenäcker, Karlsbad',720323,8.499482,48.920042],
['RLBB','Langensteinbach St. Barbara, Karlsbad',721649,8.499572,48.909728],
['XSLT','Langenthal(CH)',8508100,7.78470885275884,47.217300377662],
['MLNW','Langenwang(Schwab)',8003551,10.276032,47.436588],
['LLWD','Langenweddingen',8012162,11.532404,52.045554],
['DLW','Langenwolmsdorf',8012163,14.153669,51.036251],
['DLWM','Langenwolmsdorf Mitte',8012164,14.127331,51.038605],
['NLZ','Langenzenn',8003552,10.801856,49.496943],
['KLAW','Langerwehe',8003553,6.353467,50.817909],
['WLG','Langhagen',8010201,12.425217,53.680936],
['XALK','Langkampfen',8100300,12.109642837809,47.5460393312049],
['NLGU','Langlau',8003554,10.859352,49.118743],
['FLF','Langsdorf(Oberhess)',8003558,8.85699,50.494954],
['HLGW','Langwedel',8000586,9.194981,52.977881],
['MLAW','Langweid(Lech)',8003560,10.847966,48.490447],
['PNACH','Lansingerland-Zoetermeer',8400135,5.3891668319702,52.042222],
['OJLAS','Lasko',7900031,15.232185,46.154044],
['XPLSW','Lasow',5101933,15.035115,51.225165],
['HLAT','Lathen',8003563,7.322574,52.860749],
['NLDF','Laubendorf',8003567,10.752696,49.494365],
['SLAU','Laubenheim(Nahe)',8003568,7.897215,49.918799],
['ULCH','Laucha(Unstrut)',8012167,11.678442,51.222058],
['BLH','Lauchhammer',8012169,13.743242,51.474569],
['TLH','Lauchheim',8003569,10.236563,48.868885],
['RLAU','Lauchringen',8004552,8.322193,47.629088],
['RLAC','Lauchringen West',8003562,8.308102,47.632775],
['TL','Lauda',8000221,9.709512,49.565385],
['NLK','Laudenbach am Main',8003573,9.179126,49.742528],
['RLCH','Laudenbach(Bergstr)',8003571,8.644539,49.612076],
['TLC','Laudenbach(Württ)',8003572,9.9231,49.455421],
['ALUB','Lauenbrück',8003576,9.56371,53.19703],
['ALAU','Lauenburg(Elbe)',8003577,10.567586,53.369555],
['HLFO','Lauenförde-Beverungen',8003578,9.392667,51.65847],
['DLST','Lauenstein(Sachs)',8012170,13.814398,50.786565],
['NLLW','Lauf West',8003587,11.277629,49.500659],
['NLL','Lauf(links Pegnitz)',8003580,11.285976,49.507097],
['NLR','Lauf(rechts Pegnitz)',8003581,11.277832,49.512552],
['NLA','Laufach',8003582,9.277692,50.01067],
['XSLF','Laufen(CH)',8500113,7.50263030739464,47.4193383262749],
['MLF','Laufen(Oberbay)',8003584,12.922363,47.933653],
['RLFG','Laufenburg(Baden)',8003585,8.058312,47.563408],
['RLBO','Laufenburg(Baden)Ost',8003586,8.073691,47.566163],
['XSLN','Laufenburg(CH)',8500322,8.06127319303691,47.5597640915552],
['TLN','Lauffen(Neckar)',8003588,9.146136,49.076514],
['MLIG','Lauingen',8003589,10.424966,48.574566],
['TLM','Laupheim Stadt',8003591,9.878394,48.233304],
['TLW','Laupheim West',8003592,9.847854,48.230008],
['FLBG','Laurenburg(Lahn)',8003593,7.905766,50.329552],
['XSLA','Lausanne',8501120,6.62909314109197,46.5167786487065],
['XSLAF','Lausanne-Flon',8501181,6.6303493230184,46.520790861913],
['ULA','Lauscha(Thür)',8012171,11.160302,50.473314],
['XSLS','Lausen(CH)',8500024,7.75982160092041,47.4701962129558],
['BLA','Lauta(Nl)',8012175,14.093147,51.447233],
['RLBA','Lautenbach(Baden)',8003594,8.116067,48.519483],
['DLR','Lauter(Sachs)',8012176,12.749028,50.568051],
['XALAH','Lauterach',8100302,9.724285,47.477413],
['WLAM','Lauterbach Mole',8012177,13.503118,54.342219],
['FLAU','Lauterbach(Hess)Nord',8000222,9.408055,50.643606],
['WLAU','Lauterbach(Rügen)',8017345,13.500754,54.345215],
['LLSB','Lauterbach-Steinbach',8012178,12.619387,51.175036],
['XFLTG','Lauterbourg',8700353,8.182904,48.967664],
['SLKG','Lauterecken-Grumbach',8000547,7.59071,49.653709],
['DLZ','Laußnitz',8012174,13.879653,51.24825],
['XILVM','Laveno Mombello',8300606,8.624525,45.903142],
['OALH','Laßnitzhöhe',8100194,15.588473,47.078899],
['OALNT','Laßnitzthal',8101161,15.656341,47.088167],
['XFBLM','Le Blanc-Mesnil',8703684,2.47632,48.9323],
['PFBTE','Le Bosquet',8706479,6.98167,43.551532],
['XFLB','Le Bourget',8700355,2.426198,48.930836],
['XFLC','Le Creusot Montceau Montchanin TGV',8700167,4.500068,46.765367],
['XFHV','Le Havre',8700112,0.125471,49.492734],
['XFLM','Le Mans',8700435,0.192168,47.995288],
['XFRVM','Le Raincy Villemomble Montferm',8703727,2.512914,48.888958],
['SLCH','Lebach',8000563,6.907231,49.408332],
['SLCJ','Lebach-Jabach',8007868,6.891561,49.407169],
['XBLK','Lebbeke',8800343,4.134273,51.005288],
['HLEE','Leer(Ostfriesl)',8000225,7.465283,53.23165],
['ONLE','Leerdam',8400386,5.3705554008484,51.894721984863],
['HLST','Leese-Stolzenau',8000335,9.110127,52.509469],
['XNLW','Leeuwarden',8400387,5.3699998855591,53.195835113525],
['ONLWC','Leeuwarden Camminghaburen',8400389,5.8422968,53.2021808],
['ELGD','Legden',8003608,7.088505,52.034933],
['ULE','Legefeld',8012180,11.288262,50.926908],
['RLT','Legelshurst',8003609,7.913549,48.55855],
['XPLE','Legnica',5100035,16.168923,51.213849],
['SLE','Lehmen',8003611,7.45523,50.284746],
['DLH','Lehndorf(Altenburg)',8010202,12.425806,50.937827],
['FLEH','Lehnheim',8003612,8.992094,50.606769],
['BLEN','Lehnitz',8081722,13.263224,52.741702],
['HLER','Lehrte',8000226,9.974599,52.376722],
['XALZ','Leibnitz',8100035,15.5469985829334,46.7807714647667],
['KLEL','Leichlingen',8003616,7.005251,51.107521],
['XNL','Leiden Centraal',8400390,4.481968,52.166263],
['XNLL','Leiden Lammenschans',8400384,5.31912,52.146945953369],
['HLFG','Leiferde(b Gifhorn)',8003617,10.427937,52.456453],
['ELEI','Leimstruth',8003621,8.312789,50.990658],
['UL','Leinefelde',8010203,10.329296,51.388752],
['TLF','Leinfelden',8003622,9.142866,48.696506],
['TLG','Leingarten',8003623,9.121967,49.145032],
['TLGM','Leingarten Mitte',8071003,9.112742,49.145609],
['TLGO','Leingarten Ost',8070157,9.13089,49.144213],
['TLGW','Leingarten West',8003624,9.105654,49.145993],
['MLEH','Leipheim',8003627,10.215369,48.450171],
['LSTG','Leipzig Allee-Center',8013070,12.291748,51.319158],
['LACF','Leipzig Anger-Crottendorf',8010008,12.419467,51.334534],
['LLB','Leipzig Bayerischer Bahnhof',8012184,12.381658,51.329267],
['LCZ','Leipzig Coppiplatz',8080840,12.366024,51.367074],
['LLES','Leipzig Essener Straße',8012200,12.3969877,51.376358],
['LGRA','Leipzig Grünauer Allee',8011771,12.303006,51.320905],
['LL','Leipzig Hbf',8010205,12.383336,51.346549],
['LL  T','Leipzig Hbf (tief)',8098205,12.380428,51.345696],
['LKRS','Leipzig Karlsruher Str',8010186,12.278868,51.317221],
['LMDR','Leipzig MDR',8012187,12.386318,51.320067],
['LLMK','Leipzig Markt',8012186,12.374612,51.34064],
['LNW','Leipzig Messe',8012478,12.389278,51.396145],
['LMIA','Leipzig Miltitzer Allee',8012344,12.267345,51.315353],
['LLMS','Leipzig Mockauer Straße',8012273,12.4121,51.3738],
['LLN','Leipzig Nord',8012196,12.40106,51.364162],
['LSEL','Leipzig Olbrichtstraße',8012181,12.3535,51.369887],
['LSVS','Leipzig Slevogtstraße',8012204,12.344416,51.372944],
['LLVD','Leipzig Völkerschlachtdenkmal',8012343,12.40644,51.318813],
['LEW','Leipzig Werkstättenstraße',8011495,12.45676,51.340273],
['LLWP','Leipzig Wilhelm-Leuschner-Platz',8012202,12.375394,51.335396],
['LLC','Leipzig-Connewitz',8010206,12.385791,51.300258],
['LE','Leipzig-Engelsdorf',8011491,12.477634,51.343946],
['LLG','Leipzig-Gohlis',8012188,12.374533,51.362861],
['LLH','Leipzig-Heiterblick',8012190,12.459979,51.369339],
['LHSN','Leipzig-Holzhausen',8011913,12.461448,51.306041],
['LLK','Leipzig-Knauthain',8012192,12.309095,51.278181],
['LLEL','Leipzig-Leutzsch',8010207,12.303337,51.353772],
['LLWZ','Leipzig-Liebertwolkwitz',8012228,12.469248,51.28397],
['LLIN','Leipzig-Lindenau',8012236,12.321483,51.333756],
['LLA','Leipzig-Lützschena',8012285,12.293091,51.390057],
['LMIZ','Leipzig-Miltitz',8012355,12.25503,51.325316],
['LLMH','Leipzig-Möckern',8012193,12.352271,51.364431],
['LMLK','Leipzig-Mölkau',8012375,12.45982,51.325238],
['LLPD','Leipzig-Paunsdorf',8010208,12.444338,51.3443],
['LLP','Leipzig-Plagwitz',8010209,12.32208,51.32804],
['LRMF','Leipzig-Rückmarsdorf',8012817,12.282668,51.341871],
['LSEH','Leipzig-Sellerhausen',8080930,12.424666,51.345178],
['LLST','Leipzig-Stötteritz',8012194,12.411428,51.324512],
['LLT','Leipzig-Thekla',8012195,12.430945,51.371545],
['LLW','Leipzig-Wahren',8012197,12.321669,51.38067],
['LFLU','Leipzig/Halle Flughafen',8012183,12.223426,51.423338],
['FKBHL','Leipziger Platz, Kassel',711002,9.531239,51.303429],
['FKBHW','Leipziger Straße, Kassel',710954,9.535099,51.300966],
['DLS','Leisnig',8012198,12.938389,51.160325],
['XALT','Leithen b.Seefeld',8100554,11.221932,47.290788],
['ALE','Leitstade',8003628,10.912783,53.169143],
['ULL','Leißling',8012199,11.909824,51.185484],
['XNLY','Lelystad Centrum',8400394,5.4727778434753,52.507778167725],
['ELBK','Lembeck',8003630,7.02548,51.751244],
['HLMF','Lemförde',8003632,8.36161,52.460163],
['ELGO','Lemgo',8003633,8.894696,52.0224],
['ELGL','Lemgo-Lüttfeld',8003634,8.9107,52.020965],
['HLEM','Lemmie',8003635,9.608572,52.285104],
['XALND','Lend',8100045,13.0556845656477,47.2974230556985],
['ELSN','Lendringsen',8003638,7.826617,51.410398],
['XALEG','Lengau',8102009,13.219716,48.008546],
['HBST','Lengede-Broistedt',8001188,10.320695,52.197022],
['DRAU','Lengefeld-Rauenstein',8012201,13.202676,50.730583],
['DLFD','Lengenfeld(Vogtl)',8012203,12.373259,50.573121],
['MLWG','Lengenwang',8003639,10.601214,47.697399],
['ELEN','Lengerich(Westf)',8003640,7.878459,52.175785],
['MLG','Lenggries',8003643,11.573539,47.680395],
['HLGL','Lenglern',8003644,9.871195,51.588428],
['XSLW','Lengwil',8506196,9.19026101004505,47.6255999764796],
['EA','Lennestadt-Altenhundem',8000532,8.071517,51.104132],
['EGVB','Lennestadt-Grevenbrück',8002370,8.017977,51.141781],
['EMEG','Lennestadt-Meggen',8003939,8.065778,51.122453],
['XFLN','Lens(F)',8700244,2.8281,50.426506],
['ALS','Lensahn',8003649,10.890451,54.21931],
['ALFD','Lentföhrden',8007056,9.889835,53.876909],
['XSLB','Lenzburg',8502119,8.17037888645302,47.3911934191161],
['XALEZ','Lenzing',8101141,13.6136667493604,47.9830469378579],
['XALO','Leoben Hbf',8100070,15.089603,47.386603],
['OALOD','Leobersdorf',8101163,16.230941,47.93878],
['XALG','Leogang',8100051,12.7404220329678,47.4433816684077],
['TLE','Leonberg',8003652,9.003853,48.799646],
['XBLB','Leopoldsburg',8800080,5.257835,51.1175],
['PQELF','Leopoldshafen Frankfurter Straße, Eggenstein-Leopo',721670,8.403753,49.100832],
['RLEO','Leopoldshafen Leopoldstr.',8007174,8.401099,49.097193],
['PQELV','Leopoldshafen Viermorgen, Eggenstein-Leopoldshafen',721674,8.400281,49.090469],
['ELEO','Leopoldstal',8003655,8.971182,51.844497],
['XALM','Lermoos',8100552,10.878814774173,47.4053731991073],
['XFLE','Lerouville',8700060,5.538444,48.797023],
['XFLAC','Les Arcs Draguignan',8700624,6.48248,43.455579],
['XFAO','Les Aubrais - Orléans',8700003,1.906285,47.926722],
['XZLB','Lesce-Bled',7900002,14.1579714,46.360417],
['HLED','Leschede',8003656,7.305961,52.397644],
['PQKL','Lessingstraße, Karlsruhe',721405,8.383842,49.004435],
['ELE','Letmathe',8000227,7.618397,51.362838],
['ELED','Letmathe Dechenhöhle',8003657,7.644154,51.365465],
['BLTS','Letschin',8012205,14.347447,52.632725],
['ELET','Lette(Kr Coesfeld)',8003658,7.186998,51.892495],
['HLT','Letter',8003659,9.63948,52.393898],
['ULBN','Leubingen',8012207,11.15332,51.205099],
['KLEU','Leubsdorf(Rhein)',8003660,7.28635,50.547039],
['DLEU','Leubsdorf(Sachs)',8012208,13.14131,50.80185],
['OFLUT','Leucate-la-Franqui',8701462,3.012861,42.932778],
['XLLD','Leudelange',8270650,6.057117,49.586743],
['XSLE','Leuk',8501601,7.64394777254294,46.3118851334778],
['FBFS','Leun/Braunfels',8001132,8.366902,50.539915],
['LLWN','Leuna Werke Nord',8012211,12.000539,51.321335],
['LLWS','Leuna Werke Süd',8012212,12.006637,51.306599],
['ULEU','Leutenberg',8012213,11.447858,50.564819],
['MLSH','Leuterschach',8003663,10.581221,47.745641],
['NLWI','Leutershausen-Wiedersbach',8003664,10.44015442,49.29497465],
['KLET','Leutesdorf(Rhein)',8003665,7.392067,50.447682],
['BLE','Leuthen(Cottbus)',8012215,14.256108,51.695079],
['TLK','Leutkirch',8000336,10.015836,47.826167],
['XBLE','Leuven',8800011,4.712388,50.879089],
['OMLEE','Level',5500771,17.192481,47.889861],
['KBAY','Leverkusen Chempark',8000832,6.996675,51.011409],
['KLMH','Leverkusen Mitte',8006713,6.991661,51.031514],
['KLK','Leverkusen-Küppersteg',8003668,6.988119,51.045822],
['KLS','Leverkusen-Manfort',8003669,7.015128,51.031616],
['KLRH','Leverkusen-Rheindorf',8003672,6.963464,51.064265],
['XFLZ','Lezignan',8702319,2.769966,43.199964],
['XTL','Liberec',5400198,15.04595,50.761432],
['XTLHR','Liberec-Horni Ruzodol',5401739,15.033038,50.75351],
['XBLBM','Libramont',8800021,5.37951,49.92072],
['FLI','Lich(Oberhess)',8003673,8.821959,50.514578],
['DLIG','Lichtenberg(Erzgeb)',8012220,13.403754,50.840179],
['NLF','Lichtenfels',8000228,11.059472,50.146452],
['ULIH','Lichtenhain(a d Bergbahn)',8012222,11.132371,50.592084],
['DLTSS','Lichtenstein Ernst-Schneller-Siedlung',8017404,12.625858,50.764466],
['DLGL','Lichtenstein Gewerbegebiet',8017405,12.632105,50.775285],
['DLTSH','Lichtenstein Hartensteiner Straße',8017406,12.63619,50.74607],
['DLTS','Lichtenstein(Sachs)',8012223,12.626412,50.757677],
['DLI','Lichtentanne(Sachs)',8012224,12.419664,50.69935],
['ULIT','Lichtentanne(Thür)',8012225,11.481606,50.524377],
['NLH','Lichtenthal',8003676,13.246466,49.008762],
['ONLI','Lichtenvoorde-Groenlo',8400395,6.59641,52.01188],
['FLIB','Liebenau(Bz Kassel)',8003677,9.273958,51.491841],
['WLBT','Liebenthal(Prignitz)',8012226,12.393594,53.151313],
['FLIE','Lieblos',8003681,9.14402,50.207104],
['FLDB','Liederbach',8007159,8.486465,50.118573],
['FLDS','Liederbach-Süd',8070041,8.501678,50.115419],
['XALI','Lienz in Osttirol',8100141,12.771371,46.828442],
['XBLI','Liers',8800238,5.568457,50.698226],
['XSLI','Liestal',8500023,7.7313546877493,47.484455130825],
['WLI','Lietzow(Rügen)',8010210,13.510002,54.480965],
['XALZN','Liezen',8100131,14.2419737456905,47.5626282046104],
['XFLIE','Lille Europe',8704949,3.076448,50.639294],
['XFLI','Lille Flandres',8700030,3.071128,50.637488],
['DLIM','Limbach(Vogtl)',8012231,12.25315,50.587071],
['SLB','Limbach(b Homburg,Saar)',8003684,7.279127,49.312148],
['OALIM','Limberg-Maissau',8101154,15.8633,48.592359],
['FLIS','Limburg Süd',8003680,8.096112,50.382498],
['FL','Limburg(Lahn)',8000229,8.062342,50.384119],
['RLI','Limburgerhof',8003687,8.390747,49.424273],
['DLM','Limmritz(Sachs)',8012232,13.049744,51.117885],
['XILMN','Limone',8300381,7.577914,44.203627],
['PIXL','Limone Confine',8310061,7.573601,44.153045],
['LLI','Linda(Elster)',8012233,13.085176,51.853056],
['RLID','Lindach',8003690,9.00646,49.416918],
['MLIA','Lindau-Aeschach',8003692,9.68466,47.55962],
['MLI','Lindau-Insel',8000230,9.680469,47.544341],
['MLIR','Lindau-Reutin',8003693,9.70284607,47.55242921],
['BLNG','Lindenberg(Mark)',8012237,14.111705,52.203625],
['FKBHI','Lindenberg, Kassel',714811,9.546479,51.295167],
['FLHN','Lindenholzhausen',8003696,8.133372,50.377565],
['KLD','Lindern',8003697,6.207467,50.996842],
['HLH','Lindhorst(Schaumb-Lippe)',8003699,9.288867,52.35432],
['WLDW','Lindow(Mark)',8012239,12.981417,52.961586],
['HLWL','Lindwedel',8003700,9.689022,52.610943],
['HLIG','Lingen(Ems)',8003701,7.321731,52.519867],
['RLF','Lingenfeld',8003702,8.349523,49.252584],
['PQLLF','Linkenheim Friedrichstraße, Linkenheim-Hochstetten',721697,8.409346,49.119686],
['RLING','Linkenheim Rathaus',8079018,8.408248,49.123188],
['PQLS','Linkenheim Schulzentrum, Linkenheim-Hochstetten',721699,8.413486,49.127524],
['PQLSD','Linkenheim Süd, Linkenheim-Hochstetten',721700,8.4116,49.116864],
['XVL','Linköping Central',7400008,15.6258809,58.4165503],
['KLIN','Linnich Bhf',8007803,6.276141,50.982679],
['KLIT','Linnich-Tetz',8007806,6.322882,50.964215],
['HLBU','Linsburg',8003705,9.325638,52.600966],
['TLSH','Linsenhofen',8007447,9.371531,48.579867],
['XAL','Linz Hbf',8100013,14.2919405869061,48.2901577309329],
['KLI','Linz(Rhein)',8003708,7.276032,50.569335],
['XALW','Linz/Donau Wegscheid',8101195,14.2756088399248,48.2496679884762],
['XPLIL','Lipinki Luzyckie',5102094,15.009288,51.649091],
['XTLL','Lipova u Sluknova',5401773,14.358139,50.994648],
['ELPP','Lippstadt',8000571,8.348785,51.670687],
['FLIH','Lispenhausen',8003711,9.766787,50.990247],
['KLIS','Lissendorf',8003713,6.615158,50.318489],
['OILMU','Lissone-Muggio',8300958,9.235338,45.606035],
['ELIS','Listerscheid',8003715,7.849495,51.108143],
['XZLJ','Litija',7900140,14.8251627,46.0580545],
['XTLM','Litomerice mesto',5401791,14.138833,50.532482],
['XILI','Livorno Centrale',8300157,10.336626,43.553983],
['XBLJ','Liège-Carré',8800235,5.561959,50.640506],
['XBLIG','Liège-Guillemins',8800012,5.566667,50.624297],
['XBLP','Liège-Saint-Lambert',8800586,5.570714,50.646484],
['XZL','Ljubljana',7900003,14.512937,46.058691],
['LLO','Lobstädt',8012241,12.448732,51.135997],
['XSLC','Locarno',8505400,8.80135894864531,46.1724273965166],
['XALH','Lochau-Hörbranz',8100124,9.74282908782299,47.5292041059986],
['ONLOC','Lochem',8400399,6.4263887405395,52.166667938232],
['MLCH','Lochham',8003720,11.43089,48.128247],
['OTLHO','Lochovice',5401805,13.974298,49.846426],
['XDLF','Loeftgaard st',8601472,8.353014,55.729461],
['NLOR','Lohgarten-Roth',8003734,11.09595,49.243567],
['MLH','Lohhof',8003735,11.580813,48.287937],
['DLO','Lohmen',8012249,13.987904,50.98906],
['HLON','Lohne(Oldb)',8003738,8.229292,52.665326],
['SLOH','Lohnweiler',8003739,7.59967,49.635799],
['NLO','Lohr Bahnhof',8003740,9.580715,50.004409],
['BLOH','Lohsa',8012250,14.40404894,51.37427295],
['ULHO','Loitsch-Hohenleuben',8012252,12.048648,50.734215],
['FLOL','Lollar',8000234,8.70174,50.647936],
['XFLNG','Longueau',8700188,2.352512,49.863617],
['XFLY','Longwy',8700162,5.769369,49.513226],
['XFLS','Lons-Le-Saunier',8700189,5.551304,46.66847],
['TLON','Lonsee',8003748,9.917377,48.544967],
['XALDF','Loosdorf b.Melk',8101169,15.404969,48.194867],
['MLOH','Loppenhausen',8003749,10.390907,48.162511],
['ONLO','Loppersum',8400403,6.7472625,53.3347145],
['FLOR','Lorch(Rhein)',8003751,7.812843,50.0403],
['TLO','Lorch(Württ)',8003752,9.695761,48.797906],
['FLON','Lorchhausen',8003753,7.781403,50.053835],
['XFLR','Lorraine',8700729,6.169689,48.94741],
['FLB','Lorsbach',8003754,8.422853,50.11489],
['FLO','Lorsch',8003755,8.566262,49.659093],
['OALRU','Lorüns',8101175,9.853631,47.130716],
['BLOS','Lottschesee',8012255,13.498501,52.815398],
['XSLO','Lottstetten',8503420,8.56680664760525,47.625735629614],
['XFLO','Lourches',8700356,3.343838,50.310564],
['XFL','Lourdes',8700105,-0.042157,43.100386],
['XTLO','Lovosice',5400176,14.059588,50.50971],
['HLOX','Loxstedt',8003760,8.654301,53.474653],
['RLOS','Loßburg-Rodt',8003758,8.453187,48.418057],
['XPLU','Luban Sl.',5100224,15.293196,51.111219],
['XPLUG','Lubin Gorniczy',5100308,16.195838,51.393955],
['BLU','Lubolz',8012257,13.821351,51.962416],
['BSNZ','Luckaitztal',8012897,14.001704,51.685047],
['BUK','Luckau-Uckro',8010353,13.60784,51.852121],
['LLUC','Luckenau',8012259,12.077902,51.093993],
['BLD','Luckenwalde',8012260,13.160409,52.09059],
['NLHM','Ludersheim',8003762,11.323856,49.392166],
['XALU','Ludesch',8100066,9.77118805392253,47.1802475900787],
['FFL','Ludwigsau-Friedlos',8002103,9.743325,50.896879],
['TLU','Ludwigsburg',8000235,9.18542,48.891862],
['NLS','Ludwigschorgast',8003763,11.557252,50.121624],
['BLF','Ludwigsfelde',8010215,13.267319,52.298098],
['BSTH','Ludwigsfelde-Struveshof',8012253,13.232152,52.317181],
['RLU','Ludwigshafen(Bodensee)',8003764,9.053193,47.815651],
['RL','Ludwigshafen(Rh)Hbf',8000236,8.433402,49.477987],
['RLBM','Ludwigshafen(Rhein) BASF Mitte',8000308,8.432073,49.510038],
['RLBN','Ludwigshafen(Rhein) BASF Nord',8087060,8.427768,49.5201],
['RLBS','Ludwigshafen(Rhein) BASF Süd',8002056,8.43896,49.493971],
['RLSM','Ludwigshafen(Rhein) Mitte',8003759,8.452152,49.479005],
['RLOP','Ludwigshafen(Rhein) Oppau',8070167,8.409691,49.519378],
['RLUM','Ludwigshafen-Mundenheim',8003765,8.421092,49.461572],
['RLO','Ludwigshafen-Oggersheim',8003766,8.381523,49.493188],
['RLUR','Ludwigshafen-Rheingönheim',8003767,8.409493,49.447471],
['NLUD','Ludwigshöhe',8003768,11.248783,49.499569],
['WL','Ludwigslust',8010216,11.494491,53.334671],
['NLUS','Ludwigsstadt',8003770,11.382989,50.486583],
['NLT','Ludwigsthal',8003771,13.237815,49.059599],
['XSL','Lugano',8505300,8.94687441523852,46.0055057274732],
['OSLUP','Lugano-Paradiso',8505301,8.946406,45.989254],
['XTLS','Luh nad Svatavou',5401861,12.588197,50.217709],
['NLU','Luhe',8003794,12.139463,49.57992],
['NLW','Luhe-Wildenau',8003795,12.126909,49.598731],
['XIL','Luino',8300061,8.735784,45.995479],
['SLU','Luisenthal(Saar)',8003796,6.904214,49.249595],
['XFLUQ','Lumes Halte',8701415,4.783105,49.733092],
['XVLD','Lund Central',7400115,13.18639,55.70661],
['XDLD','Lunde J st',8601509,8.36395,55.756144],
['ALU','Lunden',8003798,9.030746,54.331231],
['XDLU','Lunderskov st',8601512,9.303791,55.48012],
['XFLUN','Lunel',8702315,4.131005,43.679597],
['HLUN','Lunestedt',8003799,8.735085,53.439084],
['ONLU','Lunteren',8400405,5.6244444847107,52.085277557373],
['XFLU','Lunéville',8700264,6.497134,48.587848],
['XSLP','Lupfig',8502237,8.21496733294592,47.4451758366077],
['XALUU','Lustenau',8100123,9.66764782260439,47.4512274401706],
['XSLZ','Luterbach-Attisholz',8500208,7.58351524914714,47.2171432544021],
['FKLPL','Lutherplatz, Kassel',715535,9.496612,51.318861],
['LEL','Lutherstadt Eisleben',8012279,11.550799,51.518194],
['LWET','Lutherstadt Wittenberg Altstadt',8012280,12.641431,51.863767],
['LW','Lutherstadt Wittenberg Hbf',8010222,12.662285,51.867811],
['LWND','Lutherstadt Wittenberg-Labetz',8013275,12.694192,51.871456],
['LWP','Lutherstadt Wittenberg-Piesteritz',8012282,12.596775,51.871862],
['HLTT','Lutten',8003800,8.343977,52.768181],
['XFLUB','Lutterbach',8701439,7.276862,47.758106],
['ELUT','Lutum',8003804,7.227015,51.982668],
['XFLT','Lutzelbourg',8700505,7.251652,48.729988],
['XLL','Luxembourg',8200100,6.134396,49.599714],
['XSLU','Luzern',8505000,8.31017092011109,47.0501697679182],
['XTLVV','Lvova',5401883,14.786851,50.780684],
['XFLPD','Lyon Part Dieu',8700152,4.85999,45.760564],
['XALN','Lähn',8100553,10.8333158653198,47.4197018608821],
['XSLL','Läufelfingen',8500035,7.85621326784447,47.3921249769244],
['OMLEM','Lébény-Mosonszentmiklos',5500765,17.425562,47.756263],
['DL','Löbau(Sachs)',8010212,14.671941,51.099447],
['RLOE','Löcherberg',8003721,8.172248,48.434667],
['WLK','Löcknitz',8010213,14.215417,53.4561],
['OALOF','Lödersdorf',8101164,15.9461,46.954641],
['HLOD','Lödingsen',8003722,9.791027,51.589196],
['SLF','Löf',8003723,7.443512,50.230569],
['RLGN','Löffingen',8003724,8.3418,47.883434],
['FLOE','Löhnberg',8003726,8.274307,50.509347],
['HL','Löhne(Westf)',8000233,8.7135,52.196653],
['XMLO','Lököshaza',5500110,21.238043,46.432379],
['RLRD','Lörrach Dammstraße',8003736,7.655224,47.597713],
['RLR','Lörrach Hbf',8003729,7.66542,47.614053],
['RLRS','Lörrach Museum/Burghof',8003737,7.661196,47.607961],
['RLRW','Lörrach Schwarzwaldstraße',8003743,7.672569,47.624683],
['RBRM','Lörrach-Brombach/Hauingen',8001191,7.695207,47.637611],
['RHAG','Lörrach-Haagen/Messe',8002489,7.680893,47.633233],
['RLST','Lörrach-Stetten',8003730,7.659032,47.601418],
['RLFB','Lörzenbach-Fahrenbach',8003731,8.764441,49.638678],
['KLO','Lövenich',8003732,6.83444,50.942932],
['WLO','Löwenberg(Mark)',8010214,13.190055,52.896801],
['TLOE','Löwental',8003733,9.499241,47.661398],
['DLN','Lößnitz ob Bf',8012245,12.748769,50.624873],
['DLNU','Lößnitz unt Bf',8012246,12.72446,50.611108],
['DLOE','Lößnitzgrund',8012247,13.653765,51.121863],
['HLBB','Lübbecke(Westf)',8003772,8.605732,52.306341],
['BLB','Lübben(Spreewald)',8010217,13.877182,51.939737],
['BLN','Lübbenau(Spreewald)',8010220,13.9609,51.862169],
['HLBR','Lübberstedt',8003773,8.785104,53.343358],
['ALB','Lübeck Flughafen',8003781,10.697484,53.804129],
['AL','Lübeck Hbf',8000237,10.669821,53.867547],
['ALHS','Lübeck Hochschulstadtteil',8003785,10.688902,53.830983],
['ALSJ','Lübeck St Jürgen',8003774,10.702942,53.842321],
['ALD A','Lübeck-Dänischburg IKEA',8003786,10.735581,53.911202],
['ALKR','Lübeck-Kücknitz',8003776,10.81889,53.924952],
['ALTK','Lübeck-Travem. Skandinavienkai',8006704,10.854029,53.950787],
['ALTH','Lübeck-Travemünde Hafen',8003777,10.865587,53.958759],
['ALTS','Lübeck-Travemünde Strand',8003778,10.875604,53.964795],
['WLOW','Lüblow(Meckl)',8012262,11.464346,53.411042],
['LLBS','Lübs(Magdeburg)',8012263,11.93517,52.020211],
['WLST','Lübstorf',8012264,11.411316,53.728881],
['WLZ','Lübz',8012265,12.025535,53.466877],
['ELS','Lüdenscheid',8003782,7.628717,51.220352],
['EBRU','Lüdenscheid-Brügge',8001213,7.571086,51.20792],
['WLF','Lüdersdorf(Meckl)',8012268,10.815143,53.832924],
['ELDH','Lüdinghausen',8003783,7.431312,51.762386],
['HLUE','Lügde',8003784,9.25083,51.959294],
['ALBG','Lüneburg',8000238,10.41989,53.249656],
['ELUE','Lünen Hbf',8000239,7.529485,51.617129],
['EPRN','Lünen-Preußen',8004883,7.539692,51.58815],
['ELRN','Lünern',8003788,7.760771,51.54337],
['WLW','Lüssow(Meckl)',8012269,12.13786,53.843724],
['FLUE','Lütter',8003790,9.765536,50.4809],
['ELUZ','Lützel',8003791,8.174364,50.967045],
['WLTW','Lützow',8012274,11.18043,53.655968],
['PNABN','Maarheeze',8400088,5.2919445037842,51.30376236035],
['ONMN','Maarn',8400417,5.3699998855591,52.064167022705],
['XNMS','Maarssen',8400419,5.0336112976074,52.135276794434],
['AMSB','Maasbüll(b Niebüll)',8079021,8.812742,54.75445],
['XNMT','Maastricht',8400424,5.7055554389954,50.850276947021],
['PNMAN','Maastricht Noord',8400449,5.71774,50.87087],
['XNMTR','Maastricht Randwyck',8400426,5.7172222137451,50.838611602783],
['OIM C','Maccagno',8300864,8.737452,46.043216],
['LMAC','Machern(Sachs)',8012284,12.627757,51.357628],
['XTMC','Machnin',5401888,14.9848,50.78743],
['XTMR','Machnin hrad',5401889,14.969514,50.787898],
['OSMGV','Magadino-Vira',8505406,8.850186,46.145316],
['LMGH','Magdeburg Hasselbachplatz',8080660,11.625322,52.122395],
['LM','Magdeburg Hbf',8010224,11.626891,52.130349],
['LMHR','Magdeburg Herrenkrug',8013455,11.676379,52.14545],
['LMTW','Magdeburg SKET Industriepark',8013485,11.638277,52.097545],
['LMSO','Magdeburg Südost',8012287,11.669977,52.07019],
['LMB','Magdeburg-Buckau',8013456,11.63004,52.109204],
['LMGE','Magdeburg-Eichenweiler',8012289,11.657982,52.166448],
['LMN','Magdeburg-Neustadt',8010226,11.641703,52.148843],
['LMR','Magdeburg-Rothensee',8010086,11.647915,52.186756],
['LMSA','Magdeburg-Salbke',8012291,11.656447,52.080745],
['LMS','Magdeburg-Sudenburg',8012292,11.597136,52.120426],
['OIMMC','Magrè-Cortaccia',8301723,11.232633,46.288046],
['TMAG','Magstadt',8003807,8.965454,48.736106],
['BMAH','Mahlow',8080970,13.407932,52.36054],
['LMW','Mahlwinkel',8012295,11.788824,52.39373],
['TMAI','Maichingen',8003808,8.969921,48.722331],
['TMIN','Maichingen Nord',8003834,8.979257,48.72736],
['XSMF','Maienfeld',8509003,9.5291955214178,47.0038340591768],
['RMKI','Maikammer-Kirrweiler',8003809,8.147177,49.30558],
['FMAS','Mainaschaff',8003810,9.085739,49.982405],
['FZH','Mainhausen Zellhausen',8006646,8.969946,50.016157],
['NML','Mainleus',8003813,11.379525,50.099812],
['NMRH','Mainroth',8003814,11.319285,50.120661],
['FHD','Maintal Ost',8002877,8.836714,50.14234],
['FBMR','Maintal West',8000996,8.805296,50.140987],
['FMZ','Mainz Hbf',8000240,8.25872,50.001117],
['FMN','Mainz Nord',8003815,8.246852,50.020066],
['FMS','Mainz Römisches Theater',8003816,8.277565,49.993465],
['FWFK','Mainz Waggonfabrik',8006136,8.235108,50.014915],
['FMB','Mainz-Bischofsheim',8000241,8.358117,49.992818],
['FMGO','Mainz-Gonsenheim',8003817,8.214478,49.997756],
['FMG','Mainz-Gustavsburg',8003818,8.314197,49.994319],
['FMK','Mainz-Kastel',8000615,8.283174,50.00658],
['FML','Mainz-Laubenheim',8003819,8.314183,49.961233],
['FMMB','Mainz-Marienborn',8003820,8.222972,49.960283],
['FMM','Mainz-Mombach',8003821,8.22937,50.022775],
['MMA','Maisach',8003824,11.256393,48.214147],
['XAMS','Maishofen-Saalbach',8100050,12.810197,47.358585],
['OFMZM','Maizieres-les-Metz',8701650,6.15831,49.2152],
['XTMLB','Mala Bela',5401892,14.923091,50.486764],
['XTMV','Mala Velen',5401899,14.272547,50.742285],
['XPMA','Malbork',5100040,19.042822,54.035794],
['WMA','Malchin',8010227,12.761041,53.743417],
['MMAG','Malching(Oberbay)',8003828,11.219064,48.21545],
['XPMAL','Malczyce',5102278,16.485516,51.215557],
['WGRN','Malk Göhren',8011650,11.376504,53.206911],
['OTMKV','Malkov',5401910,13.330445,50.441944],
['MMD','Mallersdorf',8003830,12.256898,48.768098],
['WML','Malliß',8012297,11.326002,53.212942],
['XAMO','Mallnitz-Obervellach',8100093,13.176498,46.9812135],
['TMAL','Malmsheim',8003831,8.904505,48.771755],
['XVM','Malmö Central',7400004,13.001263,55.609232],
['XIFMA','Malpensa Aeroporto',8303905,8.711275,45.627132],
['RMS','Malsch',8003832,8.323585,48.889506],
['RMSU','Malsch Süd',8003833,8.316234,48.887591],
['FMFH','Malsfeld',8000243,9.534833,51.097605],
['FBEF','Malsfeld-Beiseförth',8000859,9.55313,51.083076],
['DMAL','Malter',8012298,13.654343,50.923595],
['XLMR','Mamer',8270680,6.019718,49.625867],
['XLMY','Mamer Lycée',8276932,6.028474,49.619398],
['MMAM','Mammendorf',8004204,11.174618,48.216826],
['XSMMS','Mammern URh',8506155,8.91673503093438,47.6482873603292],
['XSMM','Mammern(Bodensee)',8506137,8.91398444987168,47.6441576693808],
['XBMA','Manage',8800121,4.23515,50.505847],
['FMAN','Mandern',8003836,9.206155,51.125543],
['UMCH','Manebach',8012299,10.862501,50.680291],
['NMDF','Manndorf',8003839,10.834224,50.038395],
['XSMBS','Mannenbach URh',8506160,9.04756474024539,47.6751705431517],
['XSMB','Mannenbach-Salenstein',8506134,9.0527792207066,47.6736499576961],
['RMSM','Mannheim ARENA/Maimarkt',8003841,8.516358,49.459786],
['RMHH','Mannheim Handelshafen',8006508,8.453917,49.492623],
['RM','Mannheim Hbf',8000244,8.468921,49.479354],
['RMFS','Mannheim-Friedrichsfeld Süd',8003842,8.572382,49.438144],
['RMKL','Mannheim-Käfertal',8003843,8.503772,49.501558],
['RMLB','Mannheim-Luzenberg',8006509,8.477775,49.517201],
['RMN','Mannheim-Neckarau',8003844,8.494792,49.455545],
['RMNS','Mannheim-Neckarstadt',8006511,8.459566,49.503633],
['RMA','Mannheim-Rheinau',8003845,8.534944,49.424091],
['RMSE','Mannheim-Seckenheim',8003847,8.538107,49.450962],
['RMW','Mannheim-Waldhof',8003848,8.482603,49.525661],
['XLMN','Manternach',8270690,6.423769,49.706458],
['ONMG','Mantgum',8400427,5.7131996,53.1296368],
['RMBO','Marbach Ost (Villingen-Schwenningen)',8003857,8.475884,48.033683],
['RMBW','Marbach West(Villingen-Schwenningen)',8003854,8.469154,48.031286],
['TMB','Marbach(Neckar)',8003853,9.264452,48.943685],
['TMBM','Marbach(b Münsingen)',8070481,9.422304,48.383716],
['TGRA','Marbach-Grafeneck',8003851,9.431171,48.395856],
['EMHD','Marbeck-Heiden',8003855,6.906067,51.809404],
['XBMAR','Marbehan',8800156,5.53967,49.72739],
['FMBS','Marburg Süd',8003856,8.762431,50.794467],
['FMBG','Marburg(Lahn)',8000337,8.775014,50.819272],
['XBMD','Marche-les-Dames',8800473,4.965371,50.480624],
['XAMG','Marchegg',8100466,16.918740508158,48.2492198664618],
['XBMP','Marchienne au Pont',8800122,4.394223,50.412171],
['XAMR','Marchtrenk',8101204,14.0994595972377,48.2011514793544],
['OPMW','Marciszow',5100078,16.007469,50.851402],
['MMGH','Margertshausen Bf',8003858,10.710733,48.314633],
['MMRN','Maria Rain',8003859,10.480275,47.632552],
['XZM','Maribor',7900006,15.658011,46.562065],
['ONMB','Marienberg(NL)',8400428,6.5752778053284,52.50944519043],
['LMBN','Marienborn',8012302,11.123269,52.197904],
['HMAR','Marienhafe',8003866,7.270731,53.520893],
['KMAH','Marienheide',8070483,7.531982,51.081123],
['RMAD','Markdorf(Baden)',8003871,9.38864,47.716816],
['LMAR','Marke',8012305,12.257028,51.7411],
['RMAR','Markelfingen',8003872,9.002772,47.739364],
['TMA','Markelsheim',8003873,9.835418,49.478264],
['LMA','Markkleeberg',8012308,12.372615,51.279029],
['LMAM','Markkleeberg Mitte',8012309,12.369742,51.280182],
['LMAN','Markkleeberg Nord',8012304,12.372204,51.287998],
['LGW','Markkleeberg-Gaschwitz',8011598,12.37922,51.250076],
['LMAG','Markkleeberg-Großstädteln',8010228,12.376129,51.262219],
['LMKS','Markranstädt',8012311,12.22476,51.30718],
['UML','Marksuhl',8012312,10.224589,50.90835],
['NMB','Markt Bibart',8003876,10.425466,49.646089],
['NMER','Markt Erlbach',8003878,10.658449,49.492675],
['MIDR','Markt Indersdorf',8003072,11.378446,48.352391],
['MSB','Markt Schwaben',8003879,11.862093,48.193606],
['NMT','Marktbreit',8003881,10.146092,49.663804],
['MMK','Marktl',8003883,12.852478,48.256695],
['NMH','Marktleuthen',8003884,12.01317,50.130803],
['MMO','Marktoberdorf',8003885,10.61423,47.779215],
['MMOS','Marktoberdorf Schule',8003877,10.609997,47.774099],
['PQKMU','Marktplatz (Kaiserstraße U), Karlsruhe',401003,8.40206,49.00956],
['PQKPZ','Marktplatz (Pyramide U), Karlsruhe',151011,8.40376,49.00896],
['NMR','Marktredwitz',8000247,12.082583,50.004596],
['NMSG','Marktschorgast',8003887,11.65353,50.090794],
['XTMVE','Markvartice',5401928,14.346349,50.772316],
['EMAM','Marl Mitte',8003888,7.099575,51.653837],
['EMHM','Marl-Hamm',8003890,7.131422,51.682972],
['EMSI','Marl-Sinsen',8003891,7.173482,51.667748],
['XFMSS','Marle-sur-Serre',8701544,3.769577,49.747193],
['UMAH','Marlishausen',8012314,11.010056,50.819504],
['XBMR','Marloie',8800154,5.313892,50.202821],
['XFMVC','Marne la Vallée-Chessy',8704948,2.782876,48.870272],
['FMHM','Marnheim',8003893,8.039141,49.623021],
['OSMME','Maroggia-Melano',8505303,8.974084,45.932496],
['BMQU','Marquardt',8012315,12.971627,52.458881],
['EMAR','Marsberg',8003896,8.854904,51.462889],
['XFMBL','Marseille-Blancarde',8700464,5.406342,43.295654],
['XFM','Marseille-St-Charles',8700074,5.38195,43.303812],
['TMAR','Marstetten-Aitrach',8003897,10.080166,47.943939],
['WMTF','Martensdorf',8012316,12.930252,54.300918],
['XNMH','Martenshoek',8400430,6.7402989,53.1607232],
['XSMA','Martigny',8501500,7.07912247583242,46.1058273015178],
['XFMAG','Martigues',8701583,5.025654,43.393012],
['NMLZ','Martinlamitz',8003898,11.950515,50.215527],
['UMT','Martinroda',8012317,10.880943,50.733145],
['SMSO','Martinstein',8003899,7.536625,49.803978],
['MMSZ','Martinszell(Allgäu)',8003901,10.273777,47.629207],
['NMX','Marxgrün',8003903,11.686568,50.354978],
['RMX','Marxzell',8007009,8.447351,48.863328],
['MMZG','Marzling',8003905,11.800108,48.410401],
['AMA','Maschen',8003906,10.065662,53.403815],
['TMSM','Maselheim',8079119,9.877614,48.133249],
['EMAN','Massen',8003909,7.643711,51.541776],
['MMSG','Massing',8003910,12.608166,48.394006],
['PQKMY','Mathystraße, Karlsruhe',367062,8.393813,49.002532],
['XAM','Matrei am Brenner',8100106,11.452824,47.127124],
['XAMAH','Mattighofen',8100409,13.152315,48.108749],
['SEMA','Matzenbach',8001727,7.456212,49.494721],
['MMTZ','Matzing',8003912,12.59239,47.935527],
['TMAU','Maubach',8003913,9.41999,48.926132],
['XFMB','Maubeuge',8700249,3.966475,50.272586],
['RMAU','Mauer(b Heidelberg)',8003915,8.795545,49.335802],
['XAMK','Mauerkirchen',8100410,13.128871,48.191701],
['TMBS','Maulbronn Stadt/Kloster',8003918,8.802691,48.996546],
['TMW','Maulbronn West',8087080,8.781536,48.983745],
['RMLG','Maulburg',8003920,7.780662,47.644374],
['NMSM','Mausheim',8003921,11.766209,49.121587],
['XAMT','Mautern im Liesingtal',8100125,14.835245,47.396827],
['NMAU','Mauthaus',8070804,11.494502,50.323404],
['RMAX','Maxau',8084068,8.307736,49.035966],
['NMXH','Maxhütte-Haidhof',8003922,12.107818,49.198019],
['RMAL','Maximiliansau Eisenbahnstraße',8003923,8.298814,49.037143],
['RMAW','Maximiliansau West',8084067,8.291797,49.038934],
['RMAI','Maximiliansau-Im Rüsten',8003911,8.279421,49.03488],
['KMYO','Mayen Ost',8000248,7.238939,50.329594],
['KMYW','Mayen West',8003924,7.213894,50.328373],
['XAMY','Mayrhofen im Zillertal',8100541,11.862392,47.169527],
['KMAY','Mayschoß',8003926,7.020463,50.517233],
['XBMCH','Mechelen',8800010,4.483468,51.017504],
['KMCH','Mechernich',8003927,6.642296,50.591367],
['UME','Mechterstädt',8012320,10.521367,50.943778],
['AMDH','Meckelfeld',8003929,10.029711,53.42438],
['TMK','Meckenbeuren',8003930,9.558393,47.69976],
['KMCP','Meckenheim Industriepark',8003937,7.027224,50.643917],
['KKOF','Meckenheim Kottenforst',8003414,7.022683,50.662412],
['KMCK','Meckenheim(Bz Köln)',8003931,7.014757,50.627446],
['RMK','Meckesheim',8003932,8.812836,49.320658],
['BMZ','Medewitz(Mark)',8012322,12.391829,52.060706],
['XUM','Medias',5300063,24.349443,46.160167],
['NMEE','Meeder',8003938,10.906842,50.315656],
['DMA','Meerane',8012323,12.457247,50.850975],
['KMBO','Meerbusch-Osterath',8004694,6.625981,51.269017],
['XNMES','Meerssen',8400434,5.7509994506836,50.882879392551],
['AMSS','Meeschensee',8079026,9.97963,53.754222],
['DMEH','Mehltheuer',8010229,12.037091,50.544312],
['EMHO','Mehrhoog',8003943,6.51825,51.738965],
['HMEI','Meine',8003947,10.535812,52.381353],
['DMS','Meinersdorf(Erzgeb)',8012324,12.888175,50.723006],
['HMRS','Meinersen',8003949,10.321114,52.449188],
['EMZH','Meinerzhagen',8003950,7.634116,51.108144],
['UM','Meiningen',8010230,10.421205,50.57407],
['LMEI','Meinsdorf',8010231,12.256306,51.903194],
['XSM','Meiringen',8508308,8.18423402153295,46.7273296621819],
['MMEI','Meitingen',8003952,10.84805,48.545997],
['LME','Meitzendorf',8012328,11.558967,52.209394],
['DME','Meißen',8012326,13.482522,51.162957],
['DMEA','Meißen Altstadt',8012318,13.473401,51.159303],
['DMT','Meißen Triebischtal',8012327,13.462529,51.152472],
['FMLB','Melbach',8003953,8.811423,50.379148],
['WMCH','Melchow',8012329,13.694375,52.774871],
['AMF','Meldorf',8003954,9.080085,54.087771],
['OSMED','Melide',8505302,8.948393,45.955931],
['XAME','Melk',8100005,15.3314576939406,48.2245295380846],
['HMEL','Melle',8003956,8.343221,52.209257],
['UMEL','Mellenbach-Glasbach',8012330,11.110281,50.60325],
['HMDF','Mellendorf',8003957,9.744501,52.548199],
['OSMEX','Mellikon',8503414,8.35255,47.56846],
['UMEN','Mellingen(Thür)',8012332,11.394318,50.950094],
['NME','Mellrichstadt Bf',8003959,10.307039,50.424782],
['XSMS','Mels',8509412,9.41774577747592,47.053743903978],
['AME','Melsdorf',8003960,10.03083,54.312754],
['FMLS','Melsungen',8003961,9.546079,51.126002],
['FMBB','Melsungen Bartenwetzerbrücke',8003971,9.548839,51.132177],
['FRFH','Melsungen-Röhrenfurth',8005125,9.548372,51.154377],
['XFMEL','Melun',8700540,2.654776,48.527412],
['MM','Memmingen',8000249,10.186853,47.985581],
['KMD','Menden(Rheinl)',8003966,7.149549,50.779917],
['EMED','Menden(Sauerland)',8003967,7.792084,51.435271],
['EMEU','Menden(Sauerland)Süd',8003965,7.807804,51.428333],
['KNME','Mendig',8004393,7.291007,50.369658],
['XSME','Mendrisio',8505305,8.97860209024968,45.8691205007211],
['PSMPP','Mendrisio S. Martino',8518475,8.983091,45.877131],
['TMG','Mengen',8003969,9.336547,48.053701],
['FMGH','Mengeringhausen',8003970,8.989763,51.360204],
['UMGH','Mengersgereuth-Hämmern',8012333,11.118299,50.392892],
['UMHO','Mengersgereuth-Hämmern Ost',8012334,11.127745,50.389471],
['RMEN','Menningen-Leitishofen',8077779,9.1609604,48.0067397],
['XFME','Menton',8700150,7.493155,43.774719],
['OFMGV','Menton Garavan',8701518,7.517247,43.78527],
['RMZN','Menzingen(Baden)',8007145,8.775067,49.136233],
['XSMEN','Menznau',8508297,8.04092804491874,47.0834344952763],
['ONMP','Meppel',8400435,6.1975002288818,52.69083404541],
['HMEP','Meppen',8003978,7.298015,52.696021],
['XIMM','Merano/Meran',8300097,11.149065,46.673167],
['MMEG','Merching',8003979,10.979397,48.245769],
['XBMER','Merchtem',8800340,4.223222,50.954427],
['SMER','Merchweiler',8003980,7.065547,49.356029],
['XBME','Merelbeke',8800123,3.764727,51.020048],
['MMR','Mering',8003982,10.988291,48.262698],
['MSAF','Mering-St Afra',8004008,10.971202,48.274282],
['XLM','Mersch(LUX)',8200110,6.110484,49.75207],
['EMES','Mersch(Westf)',8003986,7.737412,51.762112],
['LMGB','Merseburg Bergmannsring',8012339,11.989651,51.337371],
['LMG','Merseburg Hbf',8010232,11.990551,51.356889],
['KMES','Merten(Sieg)',8003987,7.385657,50.77048],
['XLMT','Mertert',8270720,6.478645,49.703255],
['RME','Mertesheim',8003988,8.133923,49.569195],
['MMTG','Mertingen Bahnhof',8003989,10.82518,48.660485],
['XFMEH','Merxheim(Colmar)',8701637,7.302598,47.913365],
['KMEZ','Merzenich',8003990,6.518051,50.840032],
['SMZG','Merzig(Saar)',8003992,6.634192,49.436419],
['SMZO','Merzig(Saar) Ost',8000202,6.651132,49.445896],
['SMZM','Merzig(Saar) Stadtmitte',8003991,6.635226,49.443478],
['HNMU','Mesch Neue Mühle',8070734,8.520849,52.26384],
['EMSD','Meschede',8003993,8.279053,51.349603],
['FMES','Messel',8003996,8.745969,49.921718],
['EMSN','Messinghausen',8003998,8.679775,51.393192],
['EMTE','Metelen Land',8004001,7.254173,52.162494],
['FMET','Mettenheim',8004003,8.334166,49.739906],
['SMT','Mettlach',8004004,6.598315,49.495476],
['KME','Mettmann Stadtwald',8004005,6.986951,51.251019],
['KMEW','Mettmann Zentrum',8004007,6.979813,51.248656],
['OFMZN','Metz Nord',8701651,6.16716,49.13697],
['XFMZV','Metz Ville',8700019,6.177669,49.109381],
['TME','Metzingen(Württ)',8004009,9.290156,48.539725],
['TNHU','Metzingen-Neuhausen',8070678,9.307106,48.532647],
['XFMU','Meuse TGV',8714732,5.271734,48.978329],
['UMEU','Meuselbach-Schwarzmühle',8012346,11.079214,50.581412],
['WME','Meyenburg',8012348,12.247161,53.311096],
['XIMZ','Mezzocorona',8300102,11.128421,46.207269],
['OMMZP','Mezöpeterd',5500853,21.626347,47.17592],
['LMF','Meßdorf',8012342,11.546771,52.709899],
['RMSS','Meßkirch',8077778,9.1161128,47.9951988],
['XLMC','Michelau(LUX)',8270730,6.091991,49.896923],
['NMI','Michelau(Oberfr)',8004011,11.116245,50.15498],
['TMIC','Michelau(Württ)',8007194,9.535256,48.861913],
['NMIK','Michelaubrück',8004013,9.767679,50.116712],
['FMIC','Michelbach(Unterfr)',8007277,9.104496,50.099814],
['XAMI','Micheldorf',8100412,14.1263841897469,47.8831452165321],
['FMI','Michelstadt',8004017,9.001453,49.684858],
['BMIP','Michendorf',8010233,13.030688,52.316344],
['ONM','Middelburg',8400436,3.61708,51.494832],
['TMST','Miedelsbach-Steinenberg',8007193,9.53913,48.84362],
['XPMIE','Miekinia',5102265,16.737917,51.18837],
['MMIB','Miesbach',8004019,11.830657,47.790443],
['SRAM','Miesenbach',8007482,7.548373,49.456368],
['KMIE','Miesenheim',8004020,7.407598,50.404043],
['LMST','Mieste',8012351,11.204771,52.48375],
['LMT','Miesterhorst',8012352,11.120178,52.466251],
['XPMIK','Mikolow',5102244,18.899407,50.172959],
['XTMD','Mikulasovice dolni nadrazi',5401975,14.336654,50.984338],
['XTMHN','Mikulasovice horni nadrazi',5401976,14.390211,50.956468],
['XTMHS','Mikulasovice stred',5401977,14.357535,50.962356],
['OPMKU','Mikulowa',5102272,15.109087,51.095019],
['XIMB','Milano Centrale',8300046,9.204828,45.487143],
['XIMG','Milano Greco Pirelli',8300416,9.214492,45.512893],
['XIML','Milano Lambrate',8300062,9.2373317,45.4850183],
['XIMP','Milano Porta Garibaldi',8300047,9.18729699,45.484437],
['XIMR','Milano Rogoredo',8300418,9.239014,45.433667],
['EMIL','Millingen(b Rees)',8004024,6.400012,51.809457],
['KMIL','Millingen(b Rheinb)',8004023,6.556373,51.560154],
['WMF','Milmersdorf',8012353,13.63731,53.099216],
['XBMM','Milmort',8800237,5.599803,50.69303],
['NMLT','Miltach',8004026,12.7683,49.163962],
['NM','Miltenberg',8000640,9.248467,49.706481],
['LMI','Miltern',8012354,11.936624,52.563344],
['WMI','Miltzow',8012358,13.201008,54.199263],
['NMIM','Mimberg',8004028,11.274564,49.352814],
['XTMM','Mimon',5400140,14.714704,50.657952],
['MMAH','Mindelaltheim',8004030,10.407905,48.455978],
['MMH','Mindelheim',8000338,10.501626,48.044917],
['HM','Minden(Westf)',8000252,8.934728,52.290138],
['XAMN','Mining',8100478,13.1736455452214,48.271192584833],
['XFMI','Miramas',8700362,4.999501,43.580939],
['OTMV','Mirovice',5400283,14.034454,49.50987],
['WMIR','Mirow',8012361,12.820759,53.27043],
['WMIS','Mistorf',8012362,12.123044,53.880497],
['FMGD','Mittel Gründau',8004037,9.119818,50.230798],
['DMHD','Mittelherwigsdorf',8010234,14.74128,50.922794],
['DMST','Mitteloelsnitz',8012366,12.706665,50.718031],
['UMSK','Mittelschmalkalden',8012367,10.400055,50.717714],
['NMSN','Mittelsinn',8004040,9.623423,50.191195],
['MMW','Mittenwald',8004043,11.265705,47.44003],
['XAMH','Mitterberghütten',8101219,13.2224075581538,47.3953245188029],
['XAMV','Mitterdorf-Veitsch',8101221,15.5119248802729,47.53646975059],
['MMIG','Mittergars',8004046,12.33299,48.150161],
['OAMIW','Mittewald an der Drau',8100417,12.595038,46.76967],
['DMW','Mittweida',8012369,12.959863,50.987545],
['BMX','Mixdorf',8012370,14.394802,52.19778],
['XAMIX','Mixnitz Bärenschützklamm',8101210,15.360554,47.33136],
['XTMB','Mlada Boleslav hl.n.',5400141,14.886947,50.407399],
['XTMBM','Mlada Boleslav mesto',5402007,14.91617,50.41921],
['OPMLK','Mlynsko',5102284,15.45021,50.988443],
['XTMY','Mlyny(CZ)',5402025,14.498228,50.811413],
['TMO','Mochenwangen',8004049,9.637901,47.872571],
['LMRN','Mockrehna',8012371,12.819504,51.505606],
['XFMOD','Modane',8700127,6.658469,45.193095],
['KMO','Moers',8000644,6.641535,51.451147],
['OAMOG','Mogersdorf',8101231,16.228604,46.945481],
['WMOI','Moidentin',8012384,11.481918,53.806071],
['OTMJZ','Mojzir',5402040,14.125155,50.678738],
['XBML','Mol',8800124,5.115104,51.190772],
['PQKSK','Moltkestraße/Städt. Klinikum, Karlsruhe',723630,8.375209,49.015707],
['XFMH','Mommenheim',8700395,7.641459,48.755848],
['XFMC','Monaco-Monte-Carlo',8700174,7.419602,43.738212],
['TMON','Monbach-Neuhausen',8004077,8.728328,48.799166],
['XIMW','Monguelfo-Casies/Welsberg-Gsies',8300421,12.107298,46.752912],
['SML','Monreal',8004078,7.153055,50.296357],
['XBMS','Mons',8800025,3.94467115402222,50.4561242358052],
['FMSH','Monsheim',8000663,8.208162,49.633666],
['FMT','Montabaur',8000667,7.825333,50.444834],
['XFMD','Montbéliard Ville',8700177,6.801591,47.510592],
['XFMN','Montelimar',8700096,4.7447,44.559365],
['XSMY','Monthey',8501421,6.95522854720308,46.255645893295],
['XFMLV','Montluçon Ville',8700028,2.596389,46.337909],
['XFMOM','Montmelian',8700159,6.043143,45.503041],
['XFMO','Montpellier Saint-Roch',8700097,3.880803,43.604533],
['XSMO','Montreux',8501300,6.91043275260853,46.4358743527171],
['XIMOZ','Monza',8300063,9.273683,45.574824],
['SMON','Monzingen',8004080,7.588673,49.793466],
['PNABI','Mook-Molenhoek',8400077,5.21764,51.766262],
['AMBH','Moorbekhalle',8079023,9.991744,53.717155],
['SMBT','Moosbachtal',8079265,7.754959,49.165954],
['XAMB','Moosbierbaum-Heiligeneich',8100376,15.9011249781733,48.3058802860415],
['MMB','Moosburg',8004084,11.930382,48.47033],
['MMRI','Moosrain',8007630,11.72055,47.767574],
['XFMOR','Moret-Veneux-les-Sablons',8701643,2.799504,48.378323],
['XSMG','Morges',8501037,6.49396427184231,46.5110918027145],
['XFMOH','Morhange',8700284,6.658806,48.936973],
['DMO','Moritzburg',8012387,13.683435,51.155587],
['NMOU','Morlesau',8004090,9.799066,50.117146],
['AMM','Morsum',8004093,8.432464,54.872142],
['RMOW','Mosbach West',8004095,9.134042,49.34677],
['RMO','Mosbach(Baden)',8004094,9.143655,49.35256],
['RNZ','Mosbach-Neckarelz',8000264,9.113093,49.348484],
['DML','Mosel',8012388,12.481399,50.783598],
['SMK','Moselkern',8004096,7.371357,50.195483],
['XMMO','Mosonmagyarovar',5500016,17.266424,47.850357],
['XTMO','Most',5400203,13.657415,50.511218],
['PFABX','Mouans-Sartoux',8705360,6.974263,43.620461],
['XFMOU','Mouchard',8700049,5.799451,46.976814],
['XFMSA','Moulins-sur-Allier',8700041,3.339264,46.561253],
['XBMN','Mouscron',8800159,3.227702,50.740133],
['XBMT','Moustier',8800480,4.695101,50.452829],
['XSMU','Moutier',8500105,7.38103944266446,47.2806661618839],
['XFMT','Moutiers-Salins-Brides-les-Bains',8700129,6.531452,45.486692],
['XFMG','Moyeuvre-Grande',8700364,6.043387,49.24673],
['EMUD','Mudersbach',8004099,7.951651,50.827476],
['RMU','Muggensturm',8004178,8.274293,48.876805],
['RMU B','Muggensturm Badesee',8004192,8.286613,48.879996],
['NMS','Muhr a See',8000534,10.720493,49.15436],
['XBMU','Muizen',8800129,4.513627,51.008443],
['DMUL','Mulda(Sachs)',8012407,13.413153,50.808999],
['DMB','Muldenberg',8013486,12.3973155,50.42523139],
['DMBH','Muldenberg Floßplatz',8000273,12.399034,50.41569],
['DMH','Muldenhütten',8012408,13.388908,50.905594],
['LMD','Muldenstein',8012409,12.354047,51.667787],
['XFMV','Mulhouse Ville',8700031,7.343048,47.741953],
['XFMVD','Mulhouse-Dornach',8700564,7.308216,47.746825],
['AMS','Mulsum-Essel',8007809,9.307073,53.498745],
['XAMF','Munderfing',8100489,13.180218,48.073079],
['TMU','Munderkingen',8004182,9.645671,48.237872],
['XFMUM','Mundolsheim',8701497,7.721135,48.644738],
['XBMZ','Munkzwalm',8800372,3.733238,50.875673],
['XLMB','Munsbach',8270780,6.268579,49.630257],
['XFMST','Munster(Metzeral)',8700563,7.134028,48.038201],
['HMS','Munster(Örtze)',8004183,10.096487,52.993312],
['XSMUO','Muolen',8506396,9.3370815797839,47.5176199644252],
['RMRG','Murg(Baden)',8004184,8.018725,47.553452],
['XSMR','Murg(CH)',8509417,9.21502492933449,47.1131764997568],
['MMU','Murnau',8004185,11.192628,47.682266],
['MUO','Murnau Ort',8004186,11.19566,47.678834],
['TMT','Murrhardt',8004188,9.57777,48.982757],
['XAMU','Musau',8100555,10.6726436464983,47.5316447232258],
['XFMUS','Mussidan',8700183,0.3538,45.034351],
['XSMT','Muttenz',8500020,7.64787914262229,47.5335803903138],
['RMCH','Mußbach',8004189,8.168529,49.37196],
['XFMCV','Mâcon Ville',8700032,4.824803,46.302941],
['XFMAL','Mâcon-Loché TGV',8700253,4.778594,46.282792],
['LMAE','Mägdesprung',8017015,11.132653,51.670375],
['TMGK','Mägerkingen',8070480,9.221932,48.287525],
['XSMW','Märwil',8506184,9.06921723298781,47.5331267042624],
['TML','Möckmühl',8004050,9.357979,49.321107],
['OAMOD','Mödling',8101230,16.295744,48.08579],
['LMGI','Mögelin',8012373,12.329815,52.560089],
['TMOE','Mögglingen(Gmünd)',8004053,9.960316,48.825289],
['XSMI','Möhlin',8500302,7.83385418672799,47.5618497593626],
['TMHB','Möhringen Bahnhof',8004068,8.770796,47.958151],
['TMHR','Möhringen Rathaus',8004067,8.763373,47.957237],
['AMLN','Mölln(Lauenb)',8004057,10.683209,53.624414],
['WMOE','Mölln(Meckl)',8012376,13.084507,53.585939],
['FMOE','Mömbris-Mensengesäß',8007279,9.166218,50.070309],
['FMOES','Mömbris-Strötzbach',8070166,9.156228,50.079471],
['KM','Mönchengladbach Hbf',8000253,6.446111,51.196583],
['KMGE','Mönchengladbach-Genhausen',8004061,6.32904,51.148081],
['KML','Mönchengladbach-Lürrip',8001745,6.472428,51.199625],
['KMR','Mönchengladbach-Rheindahlen',8004063,6.357894,51.150712],
['WMN','Mönchhagen',8012377,12.225336,54.14357],
['NMOE','Mönchröden',8004064,11.057613,50.302227],
['FMF','Mörfelden',8004065,8.565384,49.979],
['LMGN','Möringen(Altm)',8012378,11.748849,52.581661],
['RMOE','Mörlenbach',8004066,8.730987,49.597299],
['PQRMA','Mörsch Am Hang, Rheinstetten',723652,8.285496,48.956471],
['PQRMB','Mörsch Bach-West, Rheinstetten',723109,8.284194,48.958631],
['PQRMK','Mörsch Merkurstraße, Rheinstetten',724172,8.291028,48.952933],
['PQRMI','Mörsch Narzissenstraße, Rheinstetten',367217,8.302972,48.966171],
['PQRMD','Mörsch Rheinaustraße, Rheinstetten',723654,8.294234,48.958565],
['PQRMO','Mörsch Römerstraße, Rheinstetten',721818,8.297293,48.961461],
['PQRMS','Mörsch Rösselsbrünnle, Rheinstetten',720606,8.305044,48.967657],
['LMOS','Möser',8012381,11.78462,52.218981],
['TMS','Mössingen',8004070,9.04653,48.404309],
['MMTN','Möttingen',8004071,10.597832,48.806806],
['XAMTZ','Mötz',8101237,10.9612689009239,47.2758502398949],
['LMCH','Mücheln(Geiseltal)',8012390,11.804437,51.307641],
['LMCZ','Mücheln(Geiseltal) Stadt',8012392,11.813771,51.303855],
['BMC','Mücka',8012391,14.70272111,51.32020914],
['FMCK','Mücke(Hess)',8004100,9.029035,50.6171],
['SMD','Müden(Mosel)',8004101,7.339393,50.18486],
['DMUE','Mügeln Bf',8070695,13.059797,51.236462],
['TM','Mühlacker',8000339,8.846101,48.953192],
['TMRO','Mühlacker Rößlesweg',8004103,8.860143,48.95634],
['LMUA','Mühlanger',8012393,12.748212,51.855712],
['DMHL','Mühlbach(Pirna)',8012394,13.818338,50.914116],
['RKMW','Mühlburg West, Karlsruhe',721416,8.350595,49.020491],
['PQKMD','Mühlburger Feld, Karlsruhe',370503,8.36322,49.008038],
['PQKMB','Mühlburger Tor, Karlsruhe',721836,8.381677,49.010687],
['MMF','Mühldorf(Oberbay)',8000258,12.519638,48.248208],
['XAMM','Mühldorf-Möllbrücke',8100087,13.3669395649723,46.8514639677516],
['XSMH','Mühlehorn',8509418,9.17300255739309,47.117840196198],
['HMLN','Mühlen(Oldb)',8004105,8.208512,52.619692],
['TMUE','Mühlen(b Horb)',8004104,8.726802,48.449941],
['BMM','Mühlenbeck-Mönchmühle',8080980,13.386844,52.654605],
['UMH','Mühlhausen(Thür)',8010235,10.474041,51.209193],
['RMH','Mühlhausen(b Engen)',8004107,8.804391,47.813658],
['XAMHM','Mühlheim am Inn',8101248,13.220859,48.269737],
['FMH','Mühlheim(Main)',8004112,8.837646,50.119277],
['FMHD','Mühlheim(Main)-Dietesheim',8070088,8.857998,50.120519],
['TMUL','Mühlheim(b Tuttlingen)',8004111,8.885552,48.029364],
['NMST','Mühlstetten',8004115,11.00796,49.151491],
['FNR','Mühltal',8004350,8.703318,49.832203],
['TMRN','Mühringen',8070494,8.760169,48.420328],
['EMLR','Mülheim(Ruhr)Hbf',8000259,6.88651,51.431342],
['EMRY','Mülheim(Ruhr)Styrum',8000687,6.852636,51.449203],
['EMRW','Mülheim(Ruhr)West',8004122,6.871404,51.439654],
['RML','Müllheim(Baden)',8004124,7.599332,47.809743],
['BMR','Müllrose',8012400,14.434246,52.242046],
['NMBG','Münchberg',8004126,11.790667,50.189043],
['BMB','Müncheberg(Mark)',8010236,14.100332,52.524727],
['HMHZ','Münchehof(Harz)',8004127,10.188654,51.848306],
['MMDN','München Donnersbergerbrücke',8004128,11.536537,48.142623],
['MFHB','München Flughafen Besucherpark',8004167,11.764185,48.352095],
['MFHM','München Flughafen Terminal',8004168,11.78597,48.353728],
['MHAB','München Hackerbrücke',8004129,11.548572,48.141969],
['MHAR','München Harras',8004130,11.536311,48.117747],
['MH','München Hbf',8000261,11.558335,48.140232],
['MHT','München Hbf (tief)',8098263,11.560493,48.141172],
['MH  N','München Hbf Gl.27-36',8098261,11.556708,48.141529],
['MH  S','München Hbf Gl.5-10',8098262,11.555371,48.140094],
['MHP','München Heimeranplatz',8005419,11.5315,48.132961],
['MMHG','München Hirschgarten',8004179,11.519245,48.14354],
['MIT','München Isartor',8004131,11.583234,48.134202],
['MKA','München Karlsplatz',8004132,11.565619,48.139452],
['MLEF','München Leienfelsstr.',8004133,11.428524,48.154538],
['MLEU','München Leuchtenbergring',8004134,11.615986,48.13425],
['MMP','München Marienplatz',8004135,11.575386,48.137048],
['MOP','München Ost',8000262,11.604971,48.12744],
['MRP','München Rosenheimer Platz',8004136,11.593049,48.129168],
['MSW','München Siemenswerke',8004137,11.532799,48.094503],
['MMAR','München St.Martin-Str.',8004138,11.595785,48.118543],
['UMU','München(Bad Berka)',8012401,11.254596,50.870051],
['MMAL','München-Allach',8004140,11.468036,48.189932],
['MMAU','München-Aubing',8004141,11.413309,48.155968],
['MBAL','München-Berg am Laim',8004142,11.633295,48.134001],
['MDFG','München-Daglfing',8004143,11.64933,48.149622],
['MEGS','München-Englschalking',8004144,11.648335,48.156915],
['MFAS','München-Fasanerie',8004145,11.525924,48.197811],
['MFG','München-Fasangarten',8004146,11.606009,48.092746],
['MFE','München-Feldmoching',8004147,11.541318,48.213813],
['MFHH','München-Freiham',8004181,11.410112,48.14],
['MGI','München-Giesing',8004148,11.596346,48.110803],
['MJK','München-Johanneskirchen',8004149,11.646058,48.167638],
['MKFS','München-Karlsfeld',8004150,11.459568,48.211179],
['ML','München-Laim',8004151,11.503669,48.144371],
['MLW','München-Langwied',8004152,11.432508,48.163112],
['MLO','München-Lochhausen',8004153,11.407895,48.176505],
['MMT','München-Mittersendling',8004154,11.536354,48.107824],
['MMCH','München-Moosach',8004155,11.506237,48.180258],
['MNA','München-Neuaubing',8004156,11.422197,48.141706],
['MNPS','München-Neuperlach Süd',8006696,11.645175,48.088685],
['MOZ','München-Obermenzing',8004157,11.478117,48.164223],
['MP','München-Pasing',8004158,11.461872,48.149852],
['MPER','München-Perlach',8004159,11.631208,48.093426],
['MRI P','München-Riem',8004160,11.678049,48.143983],
['MSN','München-Solln',8004161,11.526954,48.079921],
['MTR','München-Trudering',8004162,11.663375,48.126066],
['MAUG','München-Untermenzing',8004139,11.472792,48.177673],
['MWKR','München-Westkreuz',8004163,11.44394,48.149026],
['XSMBU','Münchenbuchsee',8504411,7.45194288391667,47.0213694411125],
['FMHN','Münchhausen',8004164,8.718671,50.964196],
['TMCG','Münchingen',8007325,9.096218,48.855236],
['TMCR','Münchingen Rührberg',8070220,9.095853,48.849796],
['MMST','Münchsmünster',8004165,11.687409,48.758342],
['SMUE','Münchweiler(Alsenz)',8087062,7.887939,49.550606],
['SMR','Münchweiler(Rodalb)',8004166,7.700417,49.221355],
['NMUE','Münnerstadt',8004169,10.188634,50.250078],
['TMN','Münsingen',8070495,9.490432,48.409637],
['XSMUS','Münsingen(CH)',8507006,7.55942999818897,46.8733456585943],
['FMTR','Münster(Hessen)',8004171,8.853885,49.923678],
['ENHF','Münster(W)Zentrum Nord',8004173,7.63847,51.98432],
['EMST','Münster(Westf)Hbf',8000263,7.635715,51.956566],
['EABT','Münster-Albachten',8000462,7.528197,51.914576],
['EAML','Münster-Amelsbüren',8000569,7.598897,51.883662],
['EHIT','Münster-Hiltrup',8002841,7.654281,51.904755],
['ENBE','Münster-Häger',8004426,7.562341,52.022062],
['EMEK','Münster-Mecklenbeck',8003934,7.579568,51.924006],
['EMSR','Münster-Roxel',8004190,7.526126,51.946411],
['SMSA','Münster-Sarmsheim',8004172,7.898033,49.947388],
['ESPR','Münster-Sprakel',8005635,7.619982,52.041513],
['XAMW','Münster-Wiesing',8100488,11.8197409585937,47.4033415615249],
['XSMN','Münsterlingen-Scherzingen',8506126,9.22699835959647,47.6334235782514],
['RUM','Münstertal(Schwarzwald)',8007337,7.781951,47.854915],
['RMZH','Münzesheim',8007142,8.716007,49.12608],
['RMZO','Münzesheim Ost',8007146,8.726215,49.121492],
['SMLB','Mürlenbach',8004174,6.601548,50.148782],
['XAMZ','Mürzzuschlag',8100029,15.677393,47.607947],
['AMUE','Müssen',8004177,10.561128,53.499464],
['ONN','Naarden-Bussum',8400452,5.1569442749023,52.280277252197],
['NNAB','Nabburg',8004191,12.180701,49.447167],
['LNHM','Nachterstedt-Hoym',8012410,11.333025,51.802908],
['FNAC','Nackenheim',8004193,8.341885,49.919106],
['TNA','Nagold',8004196,8.727774,48.555644],
['TNA M','Nagold Stadtmitte',8004201,8.728502,48.551275],
['TNAI','Nagold-Iselshausen',8004202,8.72589,48.53154],
['TNAS','Nagold-Steinberg',8004195,8.732643,48.542015],
['XMNV','Nagymaros-Visegrad',5500913,18.958799,47.790893],
['NNIL','Naila',8004198,11.7122,50.329636],
['SNAB','Namborn',8004199,7.146277,49.523922],
['KNAM','Namedy',8004200,7.361768,50.457146],
['HNMB','Nammen-Bad',8070497,8.977854,52.259681],
['XBNA','Namur',8800018,4.862499,50.468983],
['XFNT','Nancois Tronville',8701659,5.291387,48.71802],
['XFN','Nancy',8700018,6.174096,48.689798],
['XFNA','Nantes',8700020,-1.541474,47.217089],
['XFNB','Narbonne',8700073,3.006011,43.190402],
['LNA','Narsdorf',8010238,12.713023,51.009141],
['DNA','Nassau(Erzgeb)',8012412,13.485766,50.769601],
['FNAS','Nassau(Lahn)',8004206,7.800691,50.31148],
['MNBN','Nassenbeuren',8004207,10.503797,48.078066],
['WNAS','Nassenheide',8012413,13.239198,52.816919],
['HNAH','Natrup-Hagen',8004208,7.910752,52.209849],
['BNAU','Nauen',8010239,12.885559,52.612696],
['LNAU','Nauendorf(Saalkr)',8012414,11.884503,51.608515],
['FNU','Nauheim(b Gr.Gerau)',8004210,8.449929,49.942137],
['UNM','Naumburg(Saale)Hbf',8010240,11.796984,51.163071],
['UNMO','Naumburg(Saale)Ost',8012415,11.823895,51.155525],
['UNRO','Naumburg-Roßbach',8012429,11.77953,51.170649],
['LNH','Naunhof',8012416,12.594242,51.277086],
['KNEA','Neanderthal',8004213,6.95325,51.22782],
['XSN','Nebikon',8502005,7.97744173597831,47.1923736469678],
['DNEB','Nebitzschen',8070698,13.015741,51.239187],
['UNE','Nebra',8012417,11.570126,51.28344],
['WNL','Nechlin',8012418,13.90288,53.440927],
['RNBH','Neckarbischofsheim Helmhof',8007435,8.995621,49.278376],
['RNHF','Neckarbischofsheim Nord',8077434,8.942274,49.307098],
['RNHS','Neckarbischofsheim Stadt',8007434,8.963686,49.296035],
['RNB','Neckarburken',8004215,9.163721,49.378383],
['RNM','Neckargemünd',8000265,8.788425,49.393678],
['RNMA','Neckargemünd Altstadt',8004217,8.802954,49.392391],
['RNA','Neckargerach',8004216,9.074704,49.397906],
['RNH','Neckarhausen bei Neckarsteinach',8004218,8.879703,49.416954],
['RNT','Neckarsteinach',8004219,8.841429,49.404909],
['TN','Neckarsulm',8004220,9.220068,49.188973],
['TN  M','Neckarsulm Mitte',8004232,9.222943,49.19341],
['TNSN','Neckarsulm Nord',8004238,9.228679,49.202096],
['TN  S','Neckarsulm Süd',8004226,9.220743,49.180328],
['RNEZ','Neckarzimmern',8004222,9.137577,49.316563],
['LNE','Nedlitz',8012420,12.223233,52.071866],
['SNF','Neef',8004223,7.139418,50.091053],
['XBN','Neerpelt',8800130,5.43717,51.222369],
['ANEZ','Neetzendorf',8004227,10.760576,53.163784],
['WNA','Neetzka',8012421,13.500838,53.533518],
['ENHH','Neheim-Hüsten',8004228,7.970066,51.438003],
['TNEH','Nehren',8004229,9.06688,48.423954],
['RNFL','Neidenfels',8079146,8.045236,49.386201],
['RNST','Neidenstein',8007441,8.890152,49.320237],
['LNI','Neinstedt',8012423,11.084893,51.752368],
['XTNJ','Nejdek',5400225,12.727467,50.319083],
['XTNJZ','Nejdek zastavka',5400238,12.721907,50.329422],
['XTOL','Nejdek-Oldrichov',5400233,12.769029,50.347809],
['XTNHZ','Nejdek-Sejfy',5400234,12.751223,50.349415],
['XTS','Nejdek-Sucha',5400239,12.750256,50.310906],
['XTTI','Nejdek-Tisova',5400235,12.730079,50.341353],
['TNL','Nellmersbach',8004233,9.415401,48.903368],
['KNEM','Nemmenich',8004234,6.681466,50.688051],
['XFNP','Nemours St Pierre',8704092,2.685809,48.267638],
['LNDG','Nemsdorf-Göhrendorf',8012424,11.659227,51.358381],
['XAND','Nendeln',8101262,9.54163,47.200203],
['TNED','Nendingen(b Tuttlingen)',8004235,8.854048,48.009577],
['LNS','Nennhausen',8012425,12.50279,52.59991],
['SNE','Nennig',8004236,6.375851,49.538738],
['DNGM','Nennigmühle',8012426,13.253168,50.691091],
['XANE','Nenzing',8100068,9.708253,47.191562],
['RNN','Nenzingen',8077772,8.964728,47.841348],
['MNSG','Nersingen',8004239,10.118003,48.430141],
['MNEW','Nesselwang',8004240,10.504419,47.623944],
['XBNE','Nessonvaux',8800267,5.742084,50.571963],
['XTNT','Nestedice',5402126,14.140584,50.670044],
['XTNM','Nestemice',5402127,14.106396,50.672181],
['KNEH','Nettersheim',8004242,6.629376,50.490398],
['XANF','Nettingsdorf',8101265,14.2585415930949,48.1896542133018],
['WNED','Netzeband',8012428,12.628103,52.995556],
['LNKA','Netzkater',8017016,10.789613,51.602403],
['DNZU','Netzschkau',8012430,12.244275,50.611404],
['WNPG','Neu Pudagla',8017349,14.065198,54.000336],
['ANSJ','Neu St Jürgen',8007120,8.958919,53.255475],
['WNWO','Neu Wokern',8012436,12.500916,53.760033],
['ANWF','Neu Wulmstorf',8004247,9.788432,53.473046],
['FNAP','Neu-Anspach',8007850,8.51473,50.300962],
['RMF','Neu-Edingen/Friedrichsfeld',8000631,8.580125,49.44867],
['FNIS','Neu-Isenburg',8004246,8.665609,50.053052],
['MNM','Neu-Ulm',8006730,10.004823,48.393039],
['MNB','Neubiberg',8004252,11.660222,48.075847],
['WN','Neubrandenburg',8010241,13.261465,53.561831],
['SNBR','Neubrücke(Nahe)',8004253,7.172701,49.606066],
['WNB','Neubukow',8012438,11.677763,54.030779],
['MNBD','Neuburg(Donau)',8004254,11.17837,48.727218],
['MNBK','Neuburg(Kammel)',8004256,10.365536,48.302557],
['RNBU','Neuburg(Rhein)',8004257,8.238217,48.992129],
['NNAE','Neubäu',8004250,12.436474,49.239861],
['XSNC','Neuchâtel',8504221,6.93570514490734,46.9967222076024],
['TND','Neudenau',8004258,9.27082,49.288367],
['UND','Neudietendorf',8010242,10.909685,50.913898],
['OANEF','Neudorf b.Parndorf',8100388,16.938257,48.008824],
['DNDF','Neudorf(Erzgeb)',8012442,12.97404,50.47803],
['UNS','Neue Schenke',8012443,11.63763,50.875388],
['RNBG','Neuenburg(Baden)',8089119,7.562756,47.811483],
['TNE','Neuenbürg(Enz)',8004265,8.600857,48.849147],
['TNEB','Neuenbürg(Enz) Freibad',8070276,8.59033,48.836942],
['TNES','Neuenbürg(Enz) Süd',8004264,8.598864,48.844572],
['TNEE','Neuenbürg(Enz)-Rotenbach Eyachbrücke',8070278,8.577871,48.8172],
['NNDU','Neuendettelsau',8004268,10.782372,49.282675],
['BNG','Neuenhagen(b Berlin)',8081020,13.700494,52.520453],
['HNEH','Neuenhaus',8004262,6.96998,52.5019],
['HNES','Neuenhaus Süd',8004261,6.98405,52.4871],
['HNKO','Neuenkirchen(Oldb)',8004271,8.059574,52.508434],
['NNE','Neuenmarkt-Wirsberg',8000267,11.581061,50.093676],
['ENRA','Neuenrade',8004273,7.79439,51.284773],
['TNN','Neuenstein',8004276,9.585454,49.205945],
['MNFR','Neufahrn(Niederbay)',8000688,12.19046,48.729884],
['MNF','Neufahrn(b Freising)',8004279,11.661261,48.321636],
['XBNC','Neufchateau(B)',8800181,5.452559,49.854318],
['XFNE','Neufchateau(F)',8700285,5.690393,48.358334],
['TNEF','Neuffen',8007448,9.374079,48.558556],
['TNFH','Neufra(Hohenz)',8007228,9.186653,48.246026],
['DNF','Neugersdorf',8012454,14.611635,50.986636],
['MNGH','Neugilching',8004249,11.288666,48.098966],
['UNHR','Neuhaus am Rennweg',8087081,11.136691,50.506543],
['NNP','Neuhaus(Pegnitz)',8004284,11.551709,49.626653],
['UNHI','Neuhaus-Igelshieb',8012452,11.146107,50.501051],
['RNHN','Neuhausen Bad Bf',8004289,8.612186,47.682615],
['PSNPF','Neuhausen Rheinfall',8518924,8.617455,47.679648],
['XSNE','Neuhausen(CH)',8503423,8.62491498919065,47.6831341759971],
['BNH','Neuhausen(Cottbus)',8012456,14.41266,51.68703],
['FNF','Neuhof(Kr Fulda)',8004295,9.620224,50.454818],
['BNE','Neuhof(b Zossen)',8012458,13.479582,52.139674],
['LNK','Neukieritzsch',8010243,12.412836,51.150774],
['DNKO','Neukirch(Lausitz)Ost',8012460,14.322047,51.09075],
['DNKW','Neukirch(Lausitz)West',8010400,14.269977,51.084344],
['XSNK','Neukirch-Egnach',8506398,9.37583489866189,47.5387945817308],
['OANLB','Neukirchen b.Lambach',8101278,13.83216,48.095435],
['MNK','Neukirchen(Inn)',8004298,13.370103,48.517679],
['NNS','Neukirchen(b Sulzb)',8000269,11.61954,49.524326],
['OANEG','Neukirchen-Gampern',8101260,13.549315,48.020277],
['DNK','Neukirchen-Klaffenbach',8012462,12.893604,50.771031],
['LNWY','Neukirchen-Wyhra',8012463,12.533536,51.087846],
['ANL','Neukloster(Kr Stade)',8004302,9.639721,53.481257],
['RNL','Neulußheim',8004304,8.530075,49.292199],
['DNM','Neumark(Sachs)',8010244,12.352828,50.660171],
['NNT','Neumarkt(Oberpf)',8004305,11.456987,49.273221],
['XANK','Neumarkt-Kallham',8100023,13.725044,48.271547],
['MNR','Neumarkt-St Veit',8000720,12.503075,48.361318],
['XANKD','Neumarkt/Wallersee',8100134,13.224806,47.954675],
['UNME','Neumühle(Elster)',8012465,12.170331,50.702223],
['AN','Neumünster',8000271,9.979816,54.075752],
['ANSW','Neumünster Stadtwald',8007790,9.962863,54.08343],
['ANM','Neumünster Süd AKN',8007062,9.983042,54.059815],
['LN','Neundorf(Anh)',8012467,11.59376,51.824698],
['UNH','Neunhofen',8012468,11.71444,50.724345],
['RNK','Neunkirch',8004308,8.495384,47.689151],
['OANKO','Neunkirchen NÖ',8101277,16.084713,47.731498],
['NNKS','Neunkirchen a Sand',8004310,11.32205,49.520405],
['ENK','Neunkirchen(Kr Siegen)',8004313,8.006101,50.784701],
['SNKW','Neunkirchen(Saar)-Wellesweiler',8004312,7.226787,49.34956],
['SNK','Neunkirchen(Saar)Hbf',8000272,7.176655,49.353291],
['DNOE','Neuoelsnitz',8010245,12.723437,50.719514],
['BNP','Neupetershain',8012469,14.161703,51.606324],
['XANG','Neuratting',8101288,13.3736324507398,48.2272331074522],
['PQKNA','Neureut Adolf-Ehrmann-Bad, Karlsruhe',721887,8.385261,49.050827],
['RKNEB','Neureut Bärenweg, Karlsruhe',723873,8.378614,49.046994],
['PQKNW','Neureut Welschneureuter Straße, Karlsruhe',721916,8.374724,49.044803],
['WNRR','Neuruppin Rheinsberger Tor',8010175,12.810799,52.92957],
['WNRW','Neuruppin West',8010246,12.793888,52.926244],
['DNP','Neusalza-Spremberg',8012470,14.526247,51.034251],
['NNEU','Neuses(b Kronach)',8004319,11.306843,50.217153],
['NNSG','Neusorg',8004321,11.971987,49.933844],
['KNAL','Neuss Allerheiligen',8004335,6.756793,51.142466],
['KNAK','Neuss Am Kaiser',8004320,6.697529,51.220352],
['KN','Neuss Hbf',8000274,6.684527,51.204351],
['KNRC','Neuss Rheinparkcenter',8004316,6.717153,51.206175],
['KNSD','Neuss Süd',8004317,6.69029,51.185784],
['HNRU','Neustadt am Rübenberge',8004322,9.455277,52.503325],
['NNA','Neustadt(Aisch)Bahnhof',8004323,10.588032,49.576876],
['NNAM','Neustadt(Aisch)Mitte',8004336,10.609306,49.574202],
['MND','Neustadt(Donau)',8004326,11.763297,48.800185],
['WNS','Neustadt(Dosse)',8010248,12.450667,52.852677],
['ANT','Neustadt(Holst)',8004327,10.80849,54.104002],
['ANN','Neustadt(Holst)Gbf',8099507,10.795431,54.096228],
['FNSM','Neustadt(Kr Marburg)',8004328,9.120643,50.850447],
['UNU','Neustadt(Orla)',8012472,11.757621,50.73479],
['DNE','Neustadt(Sachs)',8010249,14.213219,51.021338],
['RNSS','Neustadt(Schwarzw)',8004331,8.210883,47.910198],
['NNW','Neustadt(Waldnaab)',8004332,12.168337,49.725918],
['RND','Neustadt(Weinstr) Süd',8004306,8.157061,49.341553],
['RN','Neustadt(Weinstr)Hbf',8000275,8.140757,49.349553],
['NNU','Neustadt(b Coburg)',8004325,11.121391,50.332813],
['RNBO','Neustadt-Böbig',8004489,8.158313,49.354245],
['WNG','Neustadt-Glewe',8012474,11.593779,53.37764],
['TNHO','Neustadt-Hohenacker',8004333,9.324715,48.859312],
['NNSP','Neustift(b Passau)',8084074,13.394415,48.566815],
['WNT','Neustrelitz Hbf',8010250,13.074603,53.359255],
['MNES','Neusäß',8004318,10.83352,48.394392],
['DNZ','Neusörnewitz',8012471,13.552767,51.147553],
['BNTB','Neutrebbin',8012475,14.237036,52.676327],
['KNE','Neuwied',8000276,7.473132,50.431466],
['RETN','Neuwiesenreben, Ettlingen',720781,8.400524,48.952987],
['TNW','Neuwirtshaus(Porscheplatz)',8004338,9.152505,48.833824],
['BNZ','Neuzelle',8012479,14.648866,52.098797],
['MNN','Neuötting',8004315,12.690432,48.261158],
['XFNC','Nice Ville',8700171,7.261766,43.704824],
['OFNIR','Nice-Riquier',8700481,7.290485,43.705832],
['OFNIA','Nice-St-Augustin',8701667,7.216351,43.670675],
['OANC','Nickelsdorf',8100499,17.086247,47.942817],
['FND','Nidda',8000277,8.998881,50.411449],
['FHWD','Nidderau',8000158,8.880233,50.230826],
['FECH','Nidderau-Eichen',8001701,8.917491,50.255947],
['FWIN','Nidderau-Windecken',8006465,8.876069,50.225056],
['KNID','Nideggen-Brück',8007825,6.46578,50.689754],
['ANB','Niebüll',8004343,8.834572,54.789605],
['ANB A','Niebüll Autoverladung',8085311,8.835786,54.78456],
['ANBN','Niebüll neg',8074343,8.832959,54.78955],
['SNID','Niedaltdorf',8004344,6.594053,49.343539],
['FNFD','Nieder Flörsheim-Dalsheim',8004345,8.204274,49.656901],
['FNOL','Nieder Olm',8004349,8.20496,49.905529],
['FNRW','Nieder Wöllstadt',8004353,8.767357,50.280291],
['FNO','Nieder-Ohmen',8004348,9.034132,50.645379],
['MNAR','Niederarnbach',8071875,11.33165423,48.6511999],
['DNDR','Niederau',8012482,13.560474,51.176333],
['KTUM','Niederau-Tuchmühle',8007834,6.488009,50.764071],
['TNB','Niederbiegen',8004363,9.620958,47.830626],
['XSNB','Niederbipp',8500211,7.69480825358107,47.2703963922795],
['DNBO','Niederbobritzsch',8012483,13.440637,50.901389],
['FNCH','Niederbrechen',8004364,8.159856,50.359598],
['KND','Niederdollendorf',8004366,7.180977,50.695078],
['DNIE','Niederdorf(Erzgeb)',8013459,12.782341,50.728308],
['FNIE','Niederdorfelden',8004367,8.809034,50.193166],
['ENDR','Niederdreisbach',8007079,7.922511,50.755516],
['ENID','Niederdresselndorf',8004369,8.136394,50.721212],
['FNIB','Niedererbach',8004373,7.97687,50.425075],
['WNW','Niederfinow',8012485,13.928948,52.830668],
['XSNI','Niederglatt',8503313,8.50329612568232,47.4874689476657],
['LNF','Niedergörsdorf',8012487,12.978931,51.96793],
['FNHD','Niederhadamar',8004376,8.037069,50.43276],
['FNDH','Niederheimbach',8004379,7.805505,50.036013],
['FNH','Niederhöchstadt',8004380,8.547237,50.154198],
['ENDV','Niederhövels',8004381,7.788525,50.786291],
['FNJ','Niederjosbach',8004382,8.351017,50.149807],
['XLNK','Niederkorn',8270790,5.893876,49.536286],
['KNL','Niederlahnstein',8000278,7.599503,50.31639],
['BNDL','Niederlehme',8012489,13.652526,52.301976],
['MNLH','Niederlindhart',8004391,12.237846,48.762512],
['SNDL','Niederlinxweiler',8004392,7.160695,49.432201],
['FNMI','Niedermittlau',8004395,9.109264,50.178609],
['SNDM','Niedermohr',8004396,7.471588,49.458429],
['LNR','Niederndodeleben',8012490,11.502663,52.129976],
['FNSD','Niedernhausen(Taunus)',8004400,8.312879,50.159697],
['DNOW','Niederoderwitz',8012491,14.724414,50.9523],
['UNP','Niederpöllnitz',8012493,11.95708,50.76636],
['MNRU','Niederraunau',8004401,10.374503,48.221344],
['MNRO','Niederroth',8004404,11.390041,48.320935],
['UNIW','Niedersachswerfen',8012494,10.76389,51.545067],
['LNDH','Niedersachswerfen Herkulesmarkt',8080992,10.768553,51.542165],
['LNDI','Niedersachswerfen Ilfelder Straße',8080991,10.769898,51.560674],
['LNDS','Niedersachswerfen Ost',8017017,10.768731,51.549439],
['FNDS','Niederscheld(Dillkr)Süd',8004405,8.3033,50.717731],
['ENDN','Niederschelden',8004406,7.965509,50.839248],
['ENDO','Niederschelden Nord',8004407,7.970657,50.844187],
['DNSL','Niederschlag',8012496,13.014418,50.463964],
['DNDS','Niederschlottwitz',8012497,13.810979,50.889578],
['UNSK','Niederschmalkalden',8012498,10.375907,50.716724],
['FNS','Niederselters',8004409,8.230084,50.332676],
['UNI','Niederspier',8012500,10.848231,51.290103],
['FNIH','Niedersteinbach',8007278,9.148562,50.086596],
['TNI','Niederstetten',8004412,9.915079,49.403573],
['TNS','Niederstotzingen',8004413,10.23646,48.532604],
['UNTA','Niedertrebra',8012502,11.579246,51.064343],
['FNL','Niederwalgern',8004417,8.708379,50.736598],
['FNWF','Niederwalluf',8004418,8.159158,50.03665],
['DNI','Niederwartha',8012503,13.605922,51.094632],
['FNDW','Niederweimar',8004420,8.733665,50.756771],
['DNR','Niederwiesa',8010253,13.022852,50.862616],
['UNWL','Niederwillingen',8012504,11.038709,50.775457],
['RNID','Niederwinden',8004423,8.02296,48.13978],
['DNWZ','Niederwürschnitz',8012505,12.754106,50.718224],
['FNIZ','Niederzeuzheim',8004424,8.039687,50.468225],
['KNZS','Niederzissen',8070501,7.223197,50.461225],
['DNZW','Niederzwönitz',8012499,12.82213,50.646191],
['TNF','Niefern',8004425,8.769755,48.920281],
['OBNL','Niel',8800314,4.338491,51.111748],
['LNM','Niemberg',8012506,12.099869,51.552062],
['LNB','Nienburg(Saale)',8012507,11.761533,51.837951],
['HNBG','Nienburg(Weser)',8000279,9.217753,52.645566],
['LNHG','Nienhagen(Halberst)',8010254,11.170056,51.951204],
['FNIR','Nierstein',8004432,8.34281,49.872002],
['BNY','Niesky',8013493,14.83186652,51.29876056],
['KNIK','Nieukerk',8004433,6.375586,51.458081],
['XNNA','Nieuw Amsterdam',8400454,6.8478111,52.7183348],
['ONNV','Nieuw Vennep',8400460,4.6455554962158,52.258888244629],
['ONNW','Nieuwerkerk a. d. Ijssel',8400455,4.6169443130493,51.965278625488],
['KNIV','Nievenheim',8004434,6.782117,51.123717],
['FNIV','Nievern',8004435,7.681876,50.337385],
['ONNK','Nijkerk',8400469,5.4938888549805,52.222221374512],
['XNNM','Nijmegen',8400470,5.8522224426269,51.843612670898],
['ONNMD','Nijmegen Dukenburg',8400475,5.7955555915833,51.824165344238],
['PNABY','Nijmegen Goffert',8400109,5.1819443702698,51.8273],
['ONNMH','Nijmegen Heyendaal',8400468,5.8674998283386,51.826946258545],
['PNNL','Nijmegen Lent',8400016,5.1791667938232,51.861811],
['ONNVD','Nijverdal',8400472,6.462,52.366111],
['TNK','Niklashausen',8004437,9.613916,49.701699],
['RNIM','Nimburg(Baden)',8007294,7.760079,48.105534],
['FERW','Nistertal-Bad Marienberg',8001819,7.90058,50.632114],
['SNI','Nittel',8004438,6.440942,49.654264],
['XDNN','Noerre Nebel st',8601692,8.290385,55.777294],
['XLNZ','Noertzange',8270800,6.050831,49.508101],
['XFNR','Nogent-le-Rotrou',8701673,0.810116,48.325837],
['SNON','Nohen',8004444,7.242085,49.639648],
['SNO','Nohfelden',8079083,7.139443,49.585688],
['UNOH','Nohra(Weimar)',8012511,11.267304,50.969222],
['UNA','Nohra(Wipper)',8012512,10.698478,51.443037],
['XFNO','Noisy-le-Sec',8700436,2.458793,48.89651],
['MNHN','Nonnenhorn',8004446,9.612676,47.575118],
['PBIKY','Noorderkempen',8821105,4.633103,51.357153],
['HND','Norddeich',8004449,7.160824,53.621579],
['HNDM','Norddeich Mole',8007768,7.158806,53.624315],
['HNN','Norden',8000800,7.218913,53.588196],
['MNOD','Nordendorf',8004451,10.837306,48.593434],
['HNO','Nordenham',8004452,8.487392,53.483811],
['ANDM','Norderstedt Mitte',8079027,9.992378,53.707687],
['NNOH','Nordhalben Bf',8004455,11.517838,50.368359],
['ANH','Nordhastedt',8004456,9.183515,54.168383],
['UN','Nordhausen',8010256,10.789249,51.49292],
['LNHNB','Nordhausen Bahnhofsplatz',8070777,10.789318,51.493954],
['LNHH','Nordhausen Hesseröder Straße',8070732,10.777204,51.501962],
['LNHN','Nordhausen Nord',8017020,10.788409,51.493932],
['LNHR','Nordhausen Ricarda-Huch-Straße',8070733,10.780708,51.514701],
['LNHKS','Nordhausen Schurzfell',8070902,10.776852,51.521667],
['LNHA','Nordhausen-Altentor',8017018,10.778952,51.508043],
['LNHK','Nordhausen-Krimderode',8017019,10.773986,51.529257],
['UNSA','Nordhausen-Salza',8012516,10.77314,51.515111],
['TNO','Nordheim(Württ)',8004458,9.148811,49.109384],
['ANZ','Nordholz',8004460,8.62137,53.778743],
['HNDH','Nordhorn',8004467,7.06479907,52.429883],
['HNDB','Nordhorn-Blanke',8004465,7.07477,52.417],
['ANDS','Nordsode',8007116,8.980288,53.332837],
['HNOS','Nordstemmen',8000282,9.788881,52.166394],
['ENOW','Nordwalde',8004461,7.461641,52.077392],
['KNO','Norf',8004462,6.731645,51.160412],
['SNOR','Norheim',8004463,7.812291,49.808807],
['XVNC','Norrköping Central',7400007,16.1831339,58.5966527],
['RNO','Norsingen',8004464,7.726196,47.93925],
['HN','Northeim(Han)',8000283,9.986618,51.703139],
['ANF','Nortorf',8004466,9.852585,54.16663],
['WNOS','Nossentin',8012517,12.452177,53.521594],
['XFNDB','Notre-Dame-de-Briancon',8702410,6.468597,45.539576],
['EAPH','Nottuln-Appelhülsen',8000595,7.426334,51.892139],
['XRNG','Nova Gradiska',7800008,17.3792982,45.2535085],
['XRNK','Nova Kapela',7800046,17.6503388,45.189925],
['XTNR','Nova Role',5400226,12.780008,50.273413],
['XTNRZ','Nova Role zastavka',5400240,12.755986,50.291112],
['XINV','Novara',8300007,8.625109,45.451262],
['XTNH','Nove Hamry',5400236,12.719386,50.356982],
['XYNZ','Nove Zamky',5600025,18.173956,47.995002],
['XFNV','Noveant',8701695,6.052339,49.028308],
['XTNOV','Novina',5402196,14.941708,50.760063],
['XRNV','Novska',7800009,16.9767523,45.3269873],
['XTNB','Novy Bor',5400260,14.547289,50.760599],
['XTNHL','Nová Hut v Luzických horách',5401350,14.58587,50.830745],
['XFNY','Noyon',8700247,3.007136,49.577231],
['TNUF','Nufringen',8004490,8.889796,48.620278],
['ONNU','Nunspeet',8400466,5.7852778434753,52.370834350586],
['ONNUT','Nuth',8400467,5.8927779197693,50.919445037842],
['NNBS','Nußberg-Schönau',8070668,12.965009,49.070682],
['XDNE','Ny Ellebjerg st',8613687,12.516317,55.652421],
['XDNY','Nyborg st',8601739,10.802921,55.314068],
['XMNH','Nyiregyhaza',5500061,21.705232,47.946346],
['XTN','Nymburk hl.n.',5400149,15.045429,50.193389],
['OTNK','Nyrsko',5400215,13.153376,49.297671],
['XVN','Nässjö Central',7400017,14.6940474,57.651969],
['XFNI','Nîmes',8700151,4.366172,43.832401],
['PFNPG','Nîmes Pont du Gard',8770397,4.507704,43.816822],
['DNB','Nöbdenitz',8012509,12.280657,50.878906],
['MNL','Nördlingen',8000280,10.497863,48.850841],
['HNTH','Nörten-Hardenberg',8004441,9.933096,51.628184],
['KBIF','Nörvenich-Binsfeld',8071257,6.533342,50.79497],
['KRO','Nörvenich-Rommelsheim',8004371,6.54732,50.782608],
['DNUN','Nünchritz',8012523,13.39197,51.302649],
['NSTD','Nürnberg Frankenstadion',8004493,11.130044,49.430795],
['NN','Nürnberg Hbf',8000284,11.082989,49.445616],
['NNRO','Nürnberg Nordost',8004469,11.106115,49.473975],
['NNO','Nürnberg Ost',8004471,11.120885,49.463811],
['NNOS','Nürnberg Ostring',8004470,11.119935,49.454129],
['NNRS','Nürnberg Rothenburger Str.',8004473,11.055338,49.4454],
['NDTH','Nürnberg-Dutzendteich',8004476,11.117378,49.43707],
['NDHF','Nürnberg-Dürrenhof',8004442,11.09753,49.448039],
['NNES','Nürnberg-Eibach',8004477,11.048058,49.4098],
['NNER','Nürnberg-Erlenstegen',8004478,11.137293,49.472061],
['NGLH','Nürnberg-Gleißhammer',8005304,11.111284,49.444437],
['NNLH','Nürnberg-Laufamholz',8004480,11.168477,49.462948],
['NNMO','Nürnberg-Mögeldorf',8004481,11.133866,49.459213],
['NNRH','Nürnberg-Rehhof',8004491,11.154754,49.462625],
['NNRE','Nürnberg-Reichelsdorf',8004483,11.038493,49.382151],
['NNSR','Nürnberg-Sandreuth',8004484,11.05465,49.429585],
['NNSW','Nürnberg-Schweinau',8004485,11.045403,49.434377],
['NNST','Nürnberg-Stein',8004486,11.018171,49.425552],
['NNSE','Nürnberg-Steinbühl',8004487,11.0682,49.442836],
['TNU','Nürtingen',8004488,9.342648,48.627997],
['TNU R','Nürtingen-Roßdorf',8090021,9.345713,48.608573],
['TNUV','Nürtingen-Vorstadt',8090020,9.340072,48.620334],
['ANTZ','Nützen',8007055,9.916749,53.863663],
['OANU','Nüziders',8101289,9.794401,47.170751],
['FORA','Ober Ramstadt',8004497,8.74337,49.832029],
['FOW','Ober Widdersheim',8004499,8.933836,50.429511],
['ROA','Oberachern',8007002,8.079185,48.61405],
['ROAB','Oberachern Bindfadenfabrik',8007003,8.093268,48.603464],
['TOAI','Oberaichen',8004496,9.127335,48.705193],
['XAOA','Oberalm',8102006,13.0931707946738,47.7005992040525],
['MOA','Oberammergau',8004503,11.057078,47.599545],
['NOA','Oberasbach',8004504,10.964247,49.416681],
['MOU','Oberau',8004506,11.139272,47.559273],
['MOD','Oberaudorf',8004507,12.175262,47.65279],
['SOH','Oberbettingen-Hillesheim',8004513,6.638337,50.282929],
['SOG','Oberbillig',8004514,6.511634,49.710162],
['FOBA','Oberbimbach',8004515,9.563726,50.579018],
['TOBB','Oberboihingen',8004517,9.364135,48.647928],
['FOB','Oberbrechen',8004518,8.187801,50.354498],
['XSOG','Oberburg',8508080,7.6296304606003,47.0396164934769],
['DOCA','Obercarsdorf',8012518,13.665174,50.860248],
['NON','Oberdachstetten',8004521,10.421948,49.418521],
['ROBE','Oberderdingen-Flehingen Industrie',8079078,8.775007,49.083968],
['TOLC','Oberelchingen',8004525,10.083024,48.447573],
['FOSN','Oberelsungen',8004526,9.250929,51.376323],
['KOE','Obererbach',8004527,7.659393,50.719911],
['TOES','Oberesslingen',8004528,9.327267,48.729876],
['NOB','Oberferrieden',8004529,11.333429,49.331477],
['ROGI','Obergimpern',8007437,9.044019,49.255404],
['XSOB','Oberglatt',8503312,8.51060488948705,47.470203451831],
['MOGS','Obergries',8004531,11.563533,47.707537],
['MOGB','Obergriesbach',8004532,11.07976,48.421926],
['UOGR','Obergrunstedt',8012524,11.270746,50.955595],
['NOH','Oberhaid',8004533,10.817637,49.929468],
['ROHD','Oberharmersbach Dorf',8007105,8.124407,48.373308],
['ROHR','Oberharmersbach-Riersbach',8007106,8.140512,48.380789],
['EOB','Oberhausen Hbf',8000286,6.851588,51.474878],
['EOHT','Oberhausen-Holten',8004540,6.810455,51.534574],
['EOS','Oberhausen-Osterfeld Süd',8004541,6.885134,51.499889],
['EOSD','Oberhausen-Sterkrade',8004542,6.843543,51.512086],
['XAOB','Oberhofen im Inntal',8102053,11.0950492279649,47.3020088544719],
['OAOZM','Oberhofen-Zell am Moos',8101332,13.301464,47.958853],
['LOH','Oberholz',8012526,12.506422,51.257796],
['ROB','Oberkirch',8004545,8.07689,48.529031],
['ROBK','Oberkirch-Köhlersiedlung',8004546,8.089437,48.524845],
['TON','Oberkochen',8004549,10.107654,48.782359],
['XLOK','Oberkorn',8270820,5.893763,49.508851],
['NOKP','Oberkotzau',8000287,11.932204,50.266389],
['ROK','Oberkrozingen',8007331,7.715884,47.910541],
['KOL','Oberlahnstein',8004550,7.603964,50.299926],
['UOLA','Oberlauscha',8012527,11.156265,50.484953],
['TOL','Oberlenningen',8004553,9.470774,48.554385],
['DOBL','Oberlichtenau',8012528,12.959276,50.907914],
['MOLH','Oberlindhart',8004554,12.217908,48.755409],
['SOW','Oberlinxweiler',8004555,7.151116,49.450707],
['KOM','Obermaubach',8007823,6.446967,50.713986],
['XFOM','Obermodern',8700400,7.54688,48.842342],
['SOBM','Obermohr',8004557,7.501412,49.456253],
['NOBN','Obernau',8004558,9.136088,49.934537],
['XAOM','Obernberg-Altheim',8100442,13.2592753714827,48.2702677728786],
['NOE','Obernburg-Elsenfeld',8004560,9.154222,49.840738],
['OAWOB','Oberndorf in Tirol',8101792,12.39065,47.497149],
['TOB','Oberndorf(Neckar)',8004563,8.575514,48.295669],
['EOBW','Oberndorf(Wittgenstein)',8004564,8.300167,50.952239],
['DOBN','Oberneuschönberg',8012529,13.39613447,50.64638282],
['FOBH','Obernhof(Lahn)',8004567,7.853001,50.315888],
['DOZ','Oberoderwitz',8010259,14.708569,50.966028],
['DOZO','Oberoderwitz Oberdorf',8012530,14.678718,50.973831],
['MOMN','Oberottmarshausen',8004571,10.851834,48.235868],
['XSOR','Oberrieden(CH)',8503203,8.57844974795217,47.2796754087945],
['XSOT','Oberriet',8509400,9.57136707107465,47.3234789515107],
['UORO','Oberrohn',8012533,10.214108,50.849861],
['DOH','Oberrothenbach',8012534,12.475776,50.763883],
['ROBL','Oberrotweil',8007290,7.620899,48.089842],
['UOR','Oberröblingen',8012532,11.297069,51.441136],
['ROSC','Oberschefflenz',8004577,9.27885,49.416925],
['MOSM','Oberschleißheim',8004580,11.55783,48.257226],
['DOSC','Oberschlottwitz',8012535,13.814493,50.87055],
['BOB','Obersdorf',8012537,14.167862,52.536966],
['NOBS','Obersinn',8004583,9.617798,50.209019],
['MOSF','Oberstaufen',8004584,10.025285,47.554206],
['MOF','Oberstdorf',8004585,10.278097,47.411032],
['OAOTM','Obertrattnach-Markt Hofkirchen',8101325,13.766863,48.245942],
['NOT','Obertraubling',8004592,12.169996,48.967537],
['FOTS','Obertshausen(Kr Of)',8004593,8.853417,50.072226],
['ROT','Obertsrot',8004594,8.34753,48.745806],
['FOU','Oberursel(Taunus)',8004596,8.589409,50.199423],
['FOUS','Oberursel-Stierstadt',8087064,8.584694,50.185688],
['FWN','Oberursel-Weißkirchen/Steinbach',8006304,8.586918,50.173246],
['DOG','Obervogelgesang',8012540,13.989919,50.949797],
['UOB','Oberweimar',8012541,11.354518,50.966306],
['UOW','Oberweißbach-Deesbach',8012542,11.135521,50.579239],
['NOBW','Oberwerrn',8004453,10.153804,50.070342],
['FOBW','Oberwesel',8004601,7.731542,50.10446],
['ROD','Oberwinden',8004603,8.044583,48.152529],
['KOWI','Oberwinter',8004604,7.207696,50.611356],
['TOBZ','Oberzell',8004605,9.574475,47.751727],
['KOZS','Oberzissen',8070507,7.200216,50.455067],
['ROOE','Oberöwisheim',8007141,8.686232,49.14006],
['XBOB','Obourg',8800427,4.008397,50.469873],
['UOFM','Obstfelderschmiede',8010260,11.133784,50.603622],
['NOK','Ochenbruck',8004609,11.253831,49.362839],
['NOF','Ochsenfurt',8000818,10.071776,49.663043],
['TOC','Ochsenhausen',8079093,9.947367,48.071069],
['LOL','Ochtmersleben',8012546,11.381105,52.144442],
['EOP','Ochtrup',8004613,7.184036,52.201616],
['FOCK','Ockenheim',8004614,7.965441,49.950552],
['RODH','Odenheim Bf',8007138,8.746388,49.17902],
['RODW','Odenheim West',8070099,8.736492,49.182272],
['XDOD','Odense st',8601770,10.386005,55.401776],
['BOD','Oderin',8012549,13.726923,52.074916],
['LOE','Oebisfelde',8010261,10.983852,52.439275],
['DOR','Oederan',8012550,13.175149,50.857284],
['BOEG','Oegeln',8012551,14.270723,52.172783],
['LOEH','Oehna',8012552,13.048201,51.93305],
['EOEL','Oelde',8004626,8.142599,51.829112],
['DOE B','Oelsnitz Bahnhofstraße',8017408,12.698135,50.727524],
['DOE','Oelsnitz(Erzgeb)',8012553,12.693933,50.734178],
['DOV','Oelsnitz(Vogtl)',8012554,12.159,50.41323],
['AOE','Oerel',8007810,9.03247,53.494156],
['NOER','Oerlenbach',8004629,10.130921,50.143278],
['EOER','Oerlinghausen',8004630,8.666016,51.978774],
['XFOE','Oermingen',8701714,7.131803,49.00031],
['WOE','Oertzenhof',8012555,13.573119,53.518083],
['HOES','Oesede',8004628,8.064317,52.208729],
['FOE','Oestrich-Winkel',8004635,8.0189,50.002659],
['XLOE','Oetrange',8270830,6.25814,49.602607],
['MOET','Oettingen(Bay)',8070508,10.600122,48.94505],
['EOVP','Oeventrop',8004642,8.132081,51.39202],
['ROU','Offenau',8004643,9.165293,49.246414],
['FOKL','Offenbach(Main) Kaiserlei',8070092,8.738377,50.105332],
['FOLM','Offenbach(Main) Ledermuseum',8070091,8.750485,50.105989],
['FOMP','Offenbach(Main) Marktplatz',8070090,8.763633,50.105855],
['FO','Offenbach(Main)Hbf',8000349,8.760743,50.099264],
['FOO','Offenbach(Main)Ost',8004645,8.784375,50.102765],
['FOBI','Offenbach-Bieber',8004647,8.808367,50.090547],
['FOWH','Offenbach-Waldhof',8004640,8.828938,50.081691],
['RO','Offenburg',8000290,7.946723,48.476475],
['ROKS','Offenburg Kreisschulzentrum',8004639,7.955192,48.459784],
['TOFS','Offenhausen',8070509,9.370292,48.399628],
['HOFN','Offensen(Kr North)',8004652,9.679817,51.588886],
['MOFF','Offingen',8004654,10.376003,48.481846],
['ROFH','Oftersheim',8004658,8.579013,49.373505],
['MOH','Ohlstadt',8004662,11.218066,47.634091],
['ONOI','Oisterwijk',8400482,5.1941666603088,51.582221984863],
['FOK','Okarben',8004664,8.75335,50.252664],
['HOK','Oker',8004665,10.478146,51.904879],
['XTOKN','Okna',5402223,14.67445,50.527269],
['XDOB','Oksboel st',8601780,8.283689,55.626006],
['DOL','Olbernhau',8012558,13.336774,50.656255],
['DOLW','Olbernhau West',8012571,13.321153,50.660251],
['DOGT','Olbernhau-Grünthal',8012559,13.364854,50.649844],
['DODN','Olbersdorf Niederdorf',8012560,14.781219,50.881175],
['DODO','Olbersdorf Oberdorf',8012561,14.767724,50.871548],
['UOL','Olbersleben-Ellersleben',8012562,11.33293,51.144198],
['MOL','Olching',8004667,11.335602,48.209995],
['AOL','Oldenburg(Holst)',8004669,10.882838,54.283824],
['HOLD','Oldenburg(Oldb)Hbf',8000291,8.222713,53.144323],
['HOLW','Oldenburg-Wechloy',8004670,8.178156,53.151804],
['HOLB','Oldenbüttel',8004668,8.810466,53.283432],
['EOLT','Oldentrup',8079069,8.590814,52.010279],
['XNOD','Oldenzaal',8400483,6.9347224235535,52.30638885498],
['XBOL','Olen(Belgien)',8800605,4.902968,51.17389],
['XIOM','Olivetta-S. Michele',8300467,7.535091,43.878398],
['XTOV','Olovi',5402243,12.559583,50.253898],
['EOLP','Olpe',8004674,7.841447,51.027738],
['EOLS','Olsberg',8004676,8.484206,51.360495],
['SOU','Olsbrücken',8004677,7.652759,49.538071],
['ONOL','Olst(NL)',8400486,6.1130557060242,52.334720611572],
['OPOLL','Olszyna Lubanska',5102567,15.379968,51.069588],
['XSOL','Olten',8500218,7.90768810499843,47.3519295324592],
['OTOML','Omlenice',5402247,14.447454,48.725202],
['XNOM','Ommen',8400487,6.4158334732056,52.50944519043],
['XFO','Onville',8700267,5.979984,49.013536],
['XBO','Oostende',8800030,2.926824,51.22849],
['ONOB','Oosterbeek',8400489,5.8400001525879,51.994998931885],
['XSZP','Opfikon',8503340,8.5617698744546,47.4299514491701],
['ONOP','Opheusden',8400494,5.6371145,51.9261615],
['KOPL','Opladen',8000853,7.008775,51.066175],
['XPO','Opole Glowne',5100046,17.925863,50.661515],
['ROP','Oppenau',8004679,8.159761,48.471999],
['FOPP','Oppenheim',8004680,8.358078,49.85756],
['TOP','Oppenweiler(Württ)',8004681,9.462785,48.981518],
['XSOP','Oppikon',8506185,9.06209186806461,47.5520637371114],
['UOG','Oppurg',8012563,11.650508,50.706068],
['XBOW','Opwijk',8800150,4.187166,50.974761],
['XIOA','Ora/Auer',8300123,11.296978,46.360913],
['XFOR','Orange(Avignon)',8700433,4.819398,44.137554],
['LOR','Oranienbaum(Anh)',8012564,12.390405,51.800919],
['BOR','Oranienburg',8013487,13.249613,52.753653],
['BORB','Oranienburg (S)',8089197,13.2490718,52.7537108],
['XFOC','Orchies',8700403,3.249315,50.477364],
['UO','Orlamünde',8010264,11.544899,50.775661],
['XFOL','Orléans',8700404,1.904651,47.907987],
['RORW','Orschweier',8004683,7.790281,48.274192],
['BORT','Ortrand',8012565,13.764948,51.373633],
['DOT','Oschatz',8013461,13.104093,51.31166],
['LO','Oschersleben(Bode)',8010266,11.22684,52.030726],
['HOHT','Osnabrück Altstadt',8004689,8.045902,52.280935],
['HO','Osnabrück Hbf',8000294,8.061781,52.272851],
['HSUN','Osnabrück-Sutthausen',8004690,8.021413,52.231807],
['XNO','Oss',8400495,5.5322222709656,51.765556335449],
['ONOSW','Oss West',8400496,5.5055556297302,51.758056640625],
['XTOST','Ostasov',5402280,15.014287,50.763182],
['EBRO','Ostbevern',8001183,7.809287,52.070117],
['PQKOE','Ostendstraße, Karlsruhe',721651,8.416476,49.005021],
['LOB','Osterburg',8012568,11.760386,52.787668],
['TO','Osterburken',8000295,9.422692,49.429657],
['NOS','Osterhofen(Nby)',8004700,13.018705,48.695474],
['MOSH','Osterhofen(Oberbay)',8004701,11.986881,47.687655],
['HOSS','Osterholz-Scharmbeck',8004702,8.797434,53.222776],
['XSOM','Ostermundigen',8507002,7.48148743551759,46.9567955453479],
['MOM','Ostermünchen',8004703,12.041588,47.942148],
['LOST','Osternienburg',8012570,12.03059,51.783518],
['HOTL','Osterode am Harz Leege',8004705,10.273027,51.717059],
['HOTM','Osterode am Harz Mitte',8004704,10.245443,51.726038],
['AOSD','Ostersode',8070214,8.975377,53.314658],
['KOSS','Osterspai',8004706,7.615074,50.245071],
['AODT','Osterstedt',8004707,9.575455,54.102219],
['LOT','Osterteich',8017021,11.160691,51.720614],
['HOTW','Osterwald',8004709,9.636544,52.097344],
['LON','Osterweddingen',8012572,11.575921,52.049135],
['FOS','Ostheim(Kr Hanau)',8004713,8.903381,50.2191],
['FOM','Ostheim(b Butzbach)',8004712,8.675319,50.406598],
['FOHF','Osthofen',8004714,8.325988,49.705423],
['TOR','Ostrach Bahnhof',8070628,9.378822,47.946319],
['DOU','Ostrau',8012576,13.166405,51.200294],
['XTOH','Ostrava hl.n.',5400026,18.267262,49.852085],
['XTOI','Ostrava-Svinov',5402286,18.210233,49.82139],
['WBI','Ostseebad Binz',8011191,13.600507,54.404819],
['WKBM','Ostseebad Kühlungsborn Mitte',8012585,11.75344,54.141615],
['WKBO','Ostseebad Kühlungsborn Ost',8012586,11.759827,54.147563],
['WKBW','Ostseebad Kühlungsborn West',8012587,11.727167,54.146496],
['XSOS','Othmarsingen',8502105,8.21478836445337,47.4074269011401],
['OTOT','Otrokovice',5400159,17.53158,49.20229],
['ROTU','Ottenau',8004722,8.338314,48.792877],
['DOF','Ottendorf(Mittweida)',8012593,12.952856,50.935117],
['DOK','Ottendorf-Okrilla Hp',8012594,13.836284,51.186795],
['DON','Ottendorf-Okrilla Nord',8012595,13.834945,51.196124],
['DOS','Ottendorf-Okrilla Süd',8012596,13.824953,51.17767],
['MONH','Ottenhofen(Oberbay)',8004723,11.879385,48.218134],
['NOBE','Ottenhofen-Bergel',8004724,10.355976,49.45579],
['ROTT','Ottenhöfen',8007006,8.151041,48.566867],
['ROTW','Ottenhöfen West',8007015,8.142636,48.567873],
['NOTS','Ottensoos',8004725,11.339683,49.50775],
['MOTF','Otterfing',8004726,11.682121,47.911387],
['AOF','Otterndorf',8004727,8.893989,53.805984],
['AOBG','Ottersberg(Han)',8004728,9.13315,53.096853],
['LOTW','Otterwisch',8012597,12.601793,51.200328],
['MOTG','Otting',8004730,12.703593,47.92871],
['MOTW','Otting-Weilheim',8004731,10.818935,48.880872],
['PQKO','Otto-Sachs-Straße, Karlsruhe',721423,8.389564,49.00341],
['MOTB','Ottobeuren',8004732,10.307136,47.944168],
['MOBR','Ottobrunn',8004733,11.677795,48.063692],
['SOTW','Ottweiler(Saar)',8000875,7.166133,49.402337],
['FLE','Otzberg Lengfeld',8003641,8.902737,49.839453],
['HOTZ','Otze',8004735,10.017114,52.487617],
['NOZ','Otzing',8004738,12.8066016,48.76373513],
['ONOU','Oudenbosch',8400498,4.5333333015442,51.587776184082],
['OIOC','Oulx-Cesana-Claviere-Sestriere',8300010,6.830669,45.037638],
['XDOU','Outrup st',8601898,8.344607,55.717281],
['LOV','Ovelgünne',8012599,11.26943,52.141807],
['KOV','Overath',8004739,7.288817,50.93273],
['XNOV','Overveen',8400501,4.6061110496521,52.391109466553],
['TOW','Owen(Teck)',8004740,9.44776,48.586996],
['AOS','Owschlag',8004741,9.590516,54.392595],
['MOYM','Oy-Mittelberg',8004742,10.458131,47.646152],
['UOM','Oßmannstedt',8012567,11.425931,51.019303],
['XDPA','Padborg st',8601899,9.358803,54.824251],
['EPD','Paderborn Hbf',8000297,8.740505,51.712979],
['EPDK','Paderborn Kasseler Tor',8004744,8.76126,51.716161],
['EPDN','Paderborn Nord',8004745,8.758954,51.72807],
['ESNS','Paderborn-Schloss Neuhaus',8005370,8.720845,51.749379],
['ESEL','Paderborn-Sennelager',8005534,8.713704,51.77024],
['XIPP','Padova',8300098,11.88062,45.417824],
['KPFF','Paffendorf',8004746,6.606998,50.961691],
['XFPS','Pagny-sur-Moselle',8700276,6.02543,48.985502],
['MPD','Paindorf',8004747,11.487263,48.44268],
['SPZ','Palzem',8004748,6.371926,49.565064],
['OAPAM','Pama',8100543,17.041417,48.042058],
['NPK','Pankofen',8004749,12.899425,48.799641],
['APF','Pansdorf',8004750,10.703056,53.981034],
['XTPAN','Pansky',5402315,14.463796,50.948252],
['XFPAN','Pantin',8704174,2.400453,48.897956],
['HPAP','Papenburg(Ems)',8004751,7.386708,53.089706],
['WPF','Papendorf',8012603,12.137318,54.036604],
['FPAPK','Papierfabrik, Kaufungen',714299,9.563238,51.290762],
['UPM','Papiermühle(Stadtr)',8012604,11.790459,50.885235],
['MPP','Pappenheim',8004753,10.964028,48.926405],
['WPM','Parchim',8010267,11.831265,53.43032],
['XTPAR','Pardubice hl.n.',5400161,15.756211,50.031737],
['XFPA','Paris Austerlitz',8700010,2.364891,48.842285],
['XFPO','Paris Est',8700011,2.358424,48.876742],
['XFPG','Paris Gare de Lyon',8700012,2.37352,48.844888],
['XFPMP','Paris Montparnasse',8700013,2.320514,48.841172],
['XFPN','Paris Nord',8700014,2.355151,48.880185],
['XFPSL','Paris St Lazare',8700015,2.325331,48.876242],
['WPA','Parkentin',8012609,11.978983,54.081256],
['XAPD','Parndorf',8101335,16.8716517108747,47.9869323700954],
['OAPO','Parndorf Ort',8100515,16.851161,47.99214],
['NPB','Parsberg',8004755,11.723355,49.164355],
['NPAR','Partenstein',8004756,9.52399,50.038379],
['WP','Pasewalk',8010268,13.988875,53.515353],
['WPO','Pasewalk Ost',8012610,14.009312,53.50957],
['NPA','Passau Hbf',8000298,13.450776,48.573632],
['WPAW','Passow(Meckl)',8012612,12.054112,53.50811],
['WPS','Passow(Uckermark)',8012611,14.10137,53.148702],
['XAPT','Paternion-Feistritz',8100086,13.670831,46.709777],
['NPAD','Patersdorf',8070665,12.993409,49.013394],
['XAPA','Patsch',8101337,11.4177019105294,47.1925902167328],
['XFPU','Pau',8700106,-0.369723,43.291555],
['WPAU','Paulinenaue',8012614,12.71327,52.675892],
['UPA','Paulinzella',8012615,11.10596,50.701106],
['XIPVI','Pavia',8300049,9.144811,45.18897],
['OAP','Payerbach-Reichenau',8100027,15.863066,47.696072],
['NPE','Pechbrunn',8004758,12.165956,49.969536],
['WPD','Peenemünde',8012617,13.773084,54.138762],
['LPG','Pegau',8010269,12.241046,51.165966],
['XAPG','Peggau-Deutschfeistritz',8100034,15.3430896797667,47.2072873134608],
['NPZ','Pegnitz',8004759,11.547547,49.758341],
['HP','Peine',8004760,10.232145,52.318942],
['MPTN','Peiting Nord',8004764,10.92667,47.801565],
['MPTO','Peiting Ost',8004765,10.936692,47.792955],
['BPO','Peitz Ost',8012621,14.449422,51.843979],
['MPEI','Peiß',8004761,11.776595,47.960102],
['LPE','Peißen',8012619,12.059642,51.500814],
['MPBG','Peißenberg',8004762,11.060279,47.797496],
['MPBN','Peißenberg Nord',8004763,11.077304,47.81568],
['XFPTE','Peltre',8701810,6.221895,49.073893],
['DPE','Penig',8013488,12.695617,50.934071],
['MPZ','Penzberg',8004767,11.371875,47.749249],
['XBP','Pepinster',8800178,5.80615,50.568179],
['XBPC','Pepinster-Cité',8800588,5.804353,50.563613],
['PIPP','Perca-Plan de Corones/Percha-Kronplatz',8372315,11.978522,46.790373],
['XFPGX','Perigueux',8700405,0.707477,45.187226],
['MPRM','Perkam',8004770,12.437388,48.857554],
['SPE','Perl',8004771,6.369321,49.473163],
['WPB','Perleberg',8012622,11.852322,53.071255],
['XTPEK','Pernink',5400232,12.773449,50.3653],
['XFPE','Perpignan',8700164,2.879399,42.695942],
['XTPPR','Pertoltice pod Ralskem',5402342,14.718308,50.677308],
['XIPDG','Peschiera del Garda',8300124,10.701178,45.437581],
['XLP','Petange',8200930,5.879173,49.554195],
['LPB','Petergrube',8012623,12.503348,51.098402],
['NPET','Petersaurach',8004774,10.745433,49.303656],
['NPEN','Petersaurach Nord',8004797,10.739097,49.318401],
['BPEN','Petershagen Nord',8081150,13.789481,52.528849],
['WPE','Petershagen(Uckerm)',8012627,14.252349,53.239977],
['HLAD','Petershagen-Lahde',8004777,9.009813,52.368032],
['BPE','Petershain',8012628,14.75012562,51.31651472],
['MPE','Petershausen(Obb)',8004775,11.469881,48.41345],
['XAPK','Peterskirchen',8101399,13.5489634249991,48.2338329643957],
['LPRO','Petersroda',8012629,12.285408,51.569691],
['XFPTC','Petit Croix',8701817,6.994836,47.610249],
['DPFH','Pfaffenhain',8012633,12.822485,50.750091],
['MPFH','Pfaffenhausen',8004780,10.451825,48.117794],
['MPF','Pfaffenhofen(Ilm)',8004781,11.511884,48.522433],
['OAPFS','Pfaffenschwendt',8101351,12.581132,47.468537],
['SPF','Pfalzel',8004784,6.68302,49.780319],
['MPKI','Pfarrkirchen',8004786,12.938169,48.429195],
['XAPFW','Pfarrwerfen',8101353,13.1997265750904,47.4615021468634],
['XAPL','Pflach',8100556,10.7180310319209,47.5140653903749],
['TPF','Pflaumloch',8004796,10.436925,48.84903],
['TPH','Pforzheim Hbf',8000299,8.703099,48.894152],
['TPHM','Pforzheim Maihälden',8004804,8.678158,48.893391],
['TPW','Pforzheim-Weißenstein',8004801,8.676449,48.865147],
['MPFR','Pfraundorf(Inn)',8004802,12.118643,47.804161],
['NPD','Pfreimd',8004803,12.167453,49.485791],
['MPFD','Pfronten-Ried',8004806,10.561026,47.583591],
['MPFS','Pfronten-Steinach',8004807,10.574572,47.566111],
['MPFW','Pfronten-Weißbach',8004809,10.557736,47.595701],
['TPU','Pfullendorf',8070630,9.255728,47.92288],
['FPU','Pfungstadt',8004816,8.607033,49.806223],
['XSPF','Pfäffikon SZ',8503209,8.77811068503499,47.2029974466971],
['TPG','Pfäffingen',8004778,8.964701,48.532167],
['PQKPC','Philipp-Reis-Straße, Karlsruhe',378621,8.411851,49.004594],
['RPB','Philippsburg(Baden)',8004813,8.454023,49.231621],
['WPH','Philippshagen',8012634,13.707042,54.347662],
['SPI','Philippsheim',8004814,6.625693,49.953435],
['RKEP','Philippstraße, Karlsruhe',721426,8.36477,49.011418],
['XAPC','Pichl b.Schladming',8101356,13.612423,47.3883],
['MPI','Piding',8004815,12.91153,47.759543],
['XPPN','Piensk',5102756,15.047399,51.245573],
['XAPV','Pill-Vomperbach',8100524,11.6777797747497,47.3244961094],
['BPIL','Pillgram',8012636,14.398532,52.336898],
['AP','Pinneberg',8004819,9.797608,53.655179],
['WPIN','Pinnow(Uckermark)',8012637,14.088742,53.065342],
['OIPTZ','Pino-Tronzano',8300914,8.736616,46.098689],
['NPI','Pinzberg',8004820,11.097096,49.698809],
['DPK','Pirk',8012639,12.076612,50.427422],
['SPS','Pirmasens Hbf',8004822,7.598432,49.205645],
['SPSN','Pirmasens Nord',8000876,7.604401,49.259218],
['DPI','Pirna',8010272,13.928881,50.962623],
['DPIC','Pirna-Copitz',8012640,13.933872,50.96811],
['DPIN','Pirna-Copitz Nord',8012641,13.935361,50.977611],
['XIPI','Pisa Centrale',8300169,10.398174,43.707973],
['OTPS','Pisek',5400163,14.142971,49.296502],
['WPZ','Plaaz',8010273,12.337716,53.840457],
['KPL','Plaidt',8004826,7.393638,50.395204],
['MPL','Planegg',8004827,11.413556,48.105303],
['WPLM','Plate(Meckl)',8012643,11.507024,53.553205],
['OAPLT','Platt',8101367,15.96611,48.67461],
['NPL','Plattling',8000301,12.86394,48.779619],
['FKPDE','Platz der Deutschen Einheit, Kassel',713056,9.513104,51.31079],
['WPU','Plau am See Bahnhof',8012644,12.25593,53.46041],
['UPL','Plaue(Thür)',8010274,10.908698,50.778393],
['DPM','Plauen(Vogtl) Mitte',8017442,12.14778,50.493584],
['DP','Plauen(Vogtl) ob Bf',8010275,12.129419,50.506163],
['DSRB','Plauen(Vogtl)-Straßberg',8010336,12.092312,50.480212],
['DPW','Plauen(Vogtl)West',8012646,12.113439,50.494412],
['NPLF','Pleinfeld',8004835,10.977369,49.10628],
['XTPLA','Plesna(CZ)',5402380,12.344977,50.210945],
['BP','Plessa',8012650,13.616847,51.470851],
['EPLT','Plettenberg',8004838,7.868913,51.23193],
['TP','Plochingen',8000302,9.41081,48.71308],
['XUPV','Ploiesti Vest',5300006,25.994682,44.924576],
['XTPZ','Plzen hl.n.',5400012,13.388244,49.743166],
['OTPZZ','Plzen zast.',5402390,13.374888,49.736794],
['APLN','Plön',8004841,10.422562,54.159479],
['TPL','Plüderhausen',8004842,9.595853,48.796684],
['WPSW','Plüschow',8012651,11.285845,53.837064],
['DPF','Pockau-Lengefeld',8010277,13.226585,50.707132],
['MPKG','Pocking',8004845,13.313164,48.406222],
['OTPB','Podebrady',5400029,15.12347,50.149713],
['APOF','Pogeez',8004850,10.72756789,53.7540526],
['HPOG','Poggenhagen',8004851,9.453972,52.467307],
['NPOI','Poikam',8004853,12.013836,48.931508],
['MPO','Poing',8004854,11.809438,48.171329],
['XFPT','Poitiers',8700066,0.33306,46.582238],
['XTPI','Pomezi nad Ohri',5465000,12.272207,50.086057],
['NPMH','Pommelsbrunn',8004858,11.513615,49.501463],
['SPOM','Pommern(Mosel)',8004859,7.269836,50.169298],
['DPOM','Pommritz',8012660,14.5747,51.159015],
['DPO','Ponitz',8012661,12.416664,50.857778],
['XFPV','Pont St Vincent',8700367,6.103291,48.602411],
['XFPXE','Pont-Ste-Maxence',8701786,2.60295,49.309883],
['XFPM','Pont-a-Mousson',8700366,6.050876,48.899721],
['OFPDB','Pont-de-Bois',8700515,3.128048,50.624236],
['XIPW','Ponte Gardena-Laion/Waidbruck-Lajen',8300125,11.532579,46.601242],
['XSPT','Pontresina',8509255,9.896077579131,46.4906477886758],
['NPOP','Poppenhausen',8004865,10.138786,50.100477],
['XIPD','Pordenone',8300110,12.653684,45.956356],
['DPSC','Porschdorf(Pirna)',8012662,14.138576,50.943184],
['UPF','Porstendorf',8012663,11.645489,50.976993],
['XEPB','Port Bou',7100079,3.157851,42.424723],
['XFPR','Port Vendres Ville',8700165,3.102604,42.513494],
['OFPOV','Port-la-Nouvelle',8700490,3.038821,43.019928],
['HPTH','Porta Westfalica',8004868,8.920253,52.243423],
['KPR','Porz(Rhein)',8004869,7.064724,50.882907],
['KPW','Porz-Wahn',8004873,7.079266,50.858133],
['WPOW','Posewald',8012665,13.528412,54.368107],
['MPH','Possenhofen',8004874,11.306475,47.96196],
['NPOH','Postbauer-Heng',8004875,11.358849,49.308921],
['RKAP','Poststraße, Karlsruhe',723869,8.40352982,48.9951692],
['BPDC','Potsdam Charlottenhof',8010280,13.036496,52.3928],
['BGBS','Potsdam Griebnitzsee',8011695,13.128713,52.394439],
['BGRI','Potsdam Griebnitzsee (S)',8080530,13.128713,52.394439],
['BPD','Potsdam Hbf',8012666,13.066782,52.391704],
['BPDH','Potsdam Hbf (S)',8089184,13.0667272,52.391748],
['BDW','Potsdam Medienstadt Babelsberg',8011430,13.122284,52.382659],
['BWP','Potsdam Park Sanssouci',8010377,13.014512,52.394108],
['BPDP','Potsdam Pirschheide',8010279,13.011243,52.372667],
['BBAB','Potsdam-Babelsberg',8080070,13.092871,52.391391],
['BRC','Potsdam-Rehbrücke',8012733,13.098232,52.358298],
['OAPSH','Pottschach',8101390,16.006381,47.697213],
['XTPO','Potucky',5400224,12.738825,50.430192],
['XTPOZ','Potucky zastavka',5400230,12.73493,50.418726],
['XFPSU','Pougues les Eaux',8704301,3.094027,47.076782],
['XBPS','Poulseur',8800177,5.578481,50.509048],
['OTPRY','Povrly',5402481,14.15677,50.670692],
['OTPYR','Povrly-Roztoky',5402482,14.18772,50.687691],
['XPPG','Poznan Gl.',5100081,16.91087,52.401993],
['EPRA','Praest',8004878,6.345534,51.821862],
['OJPR','Pragersko',7900007,15.66205,46.395378],
['XTP','Praha hl.n.',5400014,14.436039,50.083062],
['XTPH','Praha-Holesovice',5400201,14.440013,50.110213],
['XTPM','Praha-Smichov',5400204,14.408153,50.060946],
['XAPM','Pram-Haag',8100526,13.6172111194142,48.2317838015214],
['LPT','Pratau',8010281,12.635964,51.843256],
['XSPR','Pratteln',8500021,7.69080243836182,47.5226576079532],
['XUP','Predeal',5300069,25.575271,45.50483],
['APZ','Preetz',8004879,10.275752,54.233941],
['XAPR','Pregarten',8100528,14.522545973468,48.3559359378967],
['LPZH','Premnitz Nord',8012668,12.333494,52.535968],
['LPZS','Premnitz Zentrum',8012669,12.343138,52.529136],
['WPL','Prenzlau',8010282,13.866532,53.321608],
['XTPR','Prerov',5400016,17.446173,49.446351],
['NPS','Pressath',8004880,11.939142,49.76407],
['NPR','Pressig-Rothenkirchen',8004881,11.310824,50.348838],
['OTPT','Prestice',5400216,13.322625,49.575132],
['NPRE','Pretzfeld',8004882,11.170051,49.757306],
['LPRZ','Pretzier(Altm)',8012673,11.26454,52.836436],
['LPH','Pretzsch',8010283,12.787814,51.71801],
['OTPM','Pribram',5400278,14.003207,49.688845],
['WPI','Priemerburg',8010284,12.223022,53.795979],
['MPR','Prien am Chiemsee',8004885,12.346615,47.855513],
['DPR','Priestewitz',8010285,13.50912,51.250602],
['XAPRD','Prinzersdorf',8101387,15.5255463575927,48.2029310235294],
['BPOT','Priort',8013489,12.971374,52.516367],
['APD','Prisdorf',8004888,9.760216,53.675291],
['UPZ','Prittitz',8012675,11.937331,51.15841],
['LPI','Pritzerbe',8012676,12.458652,52.499581],
['WPRZ','Pritzier',8012677,11.08356,53.364971],
['WPR','Pritzwalk',8010287,12.184518,53.145759],
['WPRH','Pritzwalk Hainholz',8074703,12.20592,53.170082],
['WPRW','Pritzwalk West',8017347,12.164263,53.14461],
['OTPBT','Probostov',5402542,13.838399,50.661325],
['UPR','Probstzella',8010288,11.383568,50.528231],
['LPR','Profen',8012682,12.210933,51.130458],
['XBPO','Profondsart',8800532,4.549341,50.693848],
['WPRA','Prora',8012683,13.564057,54.444986],
['WPRO','Prora Ost',8012684,13.574515,54.43006],
['NPM','Prosselsheim',8070858,10.123567,49.864518],
['OTPR','Protivin',5400172,14.210543,49.21284],
['OTPTT','Protivin zast.',5402553,14.222499,49.196353],
['XPPRZ','Przemysl Gl.',5100234,22.776364,49.783664],
['OPPMZ','Przemysl Zasanie',5102825,22.774117,49.793633],
['XPPZ','Przeworsk',5100195,22.503353,50.067219],
['XPPRY','Przylep',5102886,15.438656,51.977575],
['LPRL','Prödel',8012678,11.913342,52.03764],
['DPRO','Prösen',8012679,13.488394,51.435058],
['BPW','Prösen Ost',8012681,13.500532,51.425299],
['DPRW','Prösen West',8012680,13.470221,51.424961],
['PAWIV','Puch b.Hallein Urstein',8102054,13.088186,47.72392],
['XAPO','Puch bei Hallein',8101406,13.0907711466606,47.7128430833758],
['MPM','Puchheim',8004893,11.353061,48.172179],
['KPUL','Pulheim',8004898,6.797051,50.998043],
['MPUL','Pullach',8004899,11.521848,48.05898],
['MPU','Pulling(b Freising)',8004900,11.707084,48.36339],
['DPUL','Pulsnitz',8012685,14.013795,51.188162],
['DPUS','Pulsnitz Süd',8012686,14.007514,51.180731],
['ONPU','Purmerend',8400508,4.9536108970642,52.50305557251],
['ONPUO','Purmerend Overwhere',8400506,4.9683332443237,52.511390686035],
['PNABD','Purmerend Weidevenne',8400046,5.0511112213135,52.496590632542],
['XAPZ','Pusarnitz',8101373,13.404561,46.835208],
['NPU','Puschendorf',8004901,10.828177,49.520762],
['WPUB','Putbus',8010401,13.48097,54.356764],
['ONPT','Putten',8400509,5.5752778053284,52.264999389648],
['APU','Puttgarden',8004903,11.226721,54.50037],
['DPT','Putzkau',8012688,14.23577,51.103124],
['XBPU','Puurs',8800316,4.282964,51.077157],
['XAPN','Pöchlarn',8100006,15.2163712121249,48.2079924671037],
['WPOE','Pölchow',8012654,12.121127,54.011031],
['NPG','Pölling',8004847,11.413685,49.288282],
['UPW','Pöllwitz',8012655,12.0242501,50.62804376],
['OAPON','Pöndorf',8101377,13.355732,47.986738],
['APN','Pönitz(Holst)',8004848,10.671157,54.045654],
['LPOE','Pönitz(Leipzig)',8012656,12.514432,51.408536],
['XAPW','Pörtschach am Wörther See',8100080,14.146231,46.636199],
['NPOE','Pösing',8004849,12.5429,49.229146],
['UPS','Pößneck ob Bf',8012657,11.588338,50.690293],
['UPSU','Pößneck unt Bf',8012658,11.606872,50.700536],
['OAPBS','Pürbach-Schrems',8100531,15.08398,48.763712],
['OMPK','Püspökladany',5500055,21.128435,47.328089],
['KQ','Quadrath-Ichendorf',8004907,6.686165,50.937859],
['HQ','Quakenbrück',8000304,7.947819,52.673943],
['OSQ','Quartino',8505405,8.887329,46.151302],
['LQB','Quedlinburg',8010290,11.153001,51.785268],
['LQQ','Quedlinburg-Quarmbeck',8012690,11.126402,51.753029],
['EQL','Quelle',8004908,8.460768,52.000487],
['EQLK','Quelle-Kupferheide',8004905,8.476397,51.994101],
['HQDF','Quendorf',8004912,7.17205524,52.3384726],
['LQ','Querfurt',8010291,11.603697,51.386919],
['XBQ','Quevy',8800026,3.909372,50.34068],
['AQB','Quickborn',8007049,9.904759,53.73113],
['AQBD','Quickborn Süd',8007064,9.90747,53.723084],
['AQBS','Quickborner Straße',8079028,9.989818,53.734426],
['SQS','Quierschied',8004909,7.059386,49.324855],
['XFQ','Quimper',8700208,-4.092173,47.994764],
['SQI','Quint',8004910,6.704697,49.825988],
['XAMD','Raaba',8100193,15.4957762799444,47.0301332178118],
['ONRA','Raalte',8400513,6.2775001525879,52.391666412354],
['DRAB','Rabenau',8012694,13.634875,50.963227],
['OARAB','Rabensburg',8101416,16.894579,48.652012],
['LRAK','Rackith(Elbe)',8012696,12.680739,51.802679],
['LRK','Rackwitz(Leipzig)',8012697,12.37513,51.440318],
['ARH','Radbruch',8004913,10.289618,53.317873],
['BRAD','Raddusch',8012698,14.032354,51.815858],
['DRAG','Radeberg',8012699,13.912539,51.111752],
['DRB','Radebeul Ost',8010292,13.680163,51.098294],
['DRBK','Radebeul-Kötzschenbroda',8010293,13.628693,51.107615],
['DRBN','Radebeul-Naundorf',8013490,13.599101,51.110336],
['DRBT','Radebeul-Weintraube',8012700,13.656017,51.103002],
['DRBZ','Radebeul-Zitzschewig',8012701,13.606809,51.114305],
['DRDB','Radeburg',8012702,13.727718,51.20988],
['MRDD','Radersdorf',8004914,11.162269,48.514419],
['LRA','Radis',8012704,12.504183,51.754704],
['NRA','Radldorf(Niederbay)',8004917,12.44307,48.874666],
['RRZ','Radolfzell',8000880,8.968984,47.735873],
['XARA','Radstadt',8100138,13.4680981613571,47.3843087971262],
['XSRF','Rafz',8503404,8.54342564763274,47.6037893297931],
['LRH','Raguhn',8012707,12.270894,51.708391],
['HRAH','Rahden',8004919,8.623836,52.432902],
['MRN','Rain',8004922,10.927514,48.696179],
['NRAF','Raindorf',8004923,10.846188,49.504239],
['ARS','Raisdorf',8004924,10.243694,54.280937],
['MRAG','Raisting',8004925,11.114165,47.912076],
['NRAH','Raitersaich',8004926,10.843549,49.374898],
['WRAK','Rakow',8012710,13.045942,54.048156],
['WRMB','Rambin(Rügen)',8012711,13.207813,54.353429],
['MRMB','Ramerberg',8004928,12.146704,48.01964],
['SRCH','Rammelsbach',8004929,7.444075,49.542131],
['MRAM','Rammingen(Bay)',8004927,10.588065,48.053022],
['TRM','Rammingen(Württ)',8004930,10.191084,48.512467],
['RRBI','Ramsbach Birkhof',8004931,8.14567,48.488339],
['RRBH','Ramsbach Höfle',8004932,8.139361,48.494864],
['NRAB','Ramsberg',8004933,10.925378,49.111841],
['RRN','Ramsen',8004935,8.02113,49.534971],
['NRSL','Ramsenthal',8004936,11.593334,50.007928],
['SRAS','Ramstein',8004938,7.556715,49.448755],
['TRGD','Rangendingen',8070520,8.892999,48.381475],
['BRSF','Rangsdorf',8012713,13.43089,52.293948],
['OFRSB','Ranguin',8704345,6.96931,43.569169],
['XARW','Rankweil',8100119,9.6375536699449,47.2719271752978],
['FRAN','Ranstadt',8004942,8.983134,50.35673],
['XSRZ','Ranzo-S. Abbondio',8505408,8.77653228958131,46.1169976034332],
['RRA','Rastatt',8000306,8.215623,48.860483],
['RRAB','Rastatt Beinle',8004944,8.225065,48.852148],
['HRST','Rastede',8004945,8.191011,53.2446],
['WRW','Rastow',8012716,11.430859,53.458156],
['FKRAT','Rathaus, Kassel',712896,9.49221,51.312336],
['FKRFF','Rathaus/Fünffensterstraße, Kassel',716122,9.49129,51.312134],
['LRW','Rathenow',8010296,12.35484,52.59964],
['DRD','Rathmannsdorf(Kr Pirna)',8012719,14.130838,50.927042],
['KRAO','Ratingen Ost',8004948,6.863562,51.295185],
['OMRTO','Ratot',5501125,16.433459,46.967487],
['XARK','Rattenberg-Kramsach',8100465,11.8960603651606,47.4392302811903],
['ARF','Ratzeburg',8004952,10.740633,53.698215],
['MRA','Raubling',8004955,12.110149,47.788506],
['URAU','Rauenstein(Thür)',8012723,11.047486,50.412253],
['ERMA','Raumland-Markhausen',8004960,8.368242,51.033954],
['RRMZ','Raumünzach',8004961,8.351408,48.644846],
['DRU','Raun',8012724,12.293006,50.259722],
['FRA','Raunheim',8004962,8.454498,50.009688],
['TRB','Ravensburg',8004965,9.6061,47.784481],
['ONRAV','Ravenstein',8400515,5.6358332633972,51.794166564941],
['XIREC','Re(I)',8302806,8.539104,46.127306],
['MRH','Rebdorf-Hofmühle',8004966,11.169457,48.892215],
['OPRBI','Rebiszow',5103044,15.455666,50.948423],
['XSRM','Rebstein-Marbach',8506318,9.58675061708481,47.3926373927342],
['DRBG','Rechenberg',8012727,13.559902,50.733931],
['DRBS','Rechenberg Schule',8017220,13.543867,50.7371],
['TRC','Rechtenstein',8004968,9.550904,48.239993],
['HRFD','Rechterfeld',8004970,8.391291,52.838685],
['NRDF','Reckendorf',8004971,10.834038,50.019394],
['ERFE','Reckenfeld',8004972,7.564753,52.133696],
['ERE','Recklinghausen Hbf',8000307,7.20349,51.616359],
['ERES','Recklinghausen Süd',8000887,7.195754,51.562965],
['SRWH','Reckweilerhof',8004975,7.609151,49.607333],
['WRDL','Reddelich',8012729,11.849531,54.085241],
['OARED','Redl-Zipf',8101428,13.515066,48.026228],
['NRCH','Rednitzhembach',8004978,11.063363,49.303877],
['NRZ','Redwitz(Rodach)',8004979,11.207288,50.168831],
['NREG','Regen',8004981,13.136465,48.968625],
['NRH','Regensburg Hbf',8000309,12.099617,49.011672],
['NBWH','Regensburg-Burgweinting',8001298,12.146713,48.990425],
['NRPF','Regensburg-Prüfening',8004983,12.049297,49.012057],
['NRGF','Regenstauf',8004987,12.125142,49.122157],
['LRB','Regis-Breitingen',8012731,12.426039,51.083548],
['NRU','Rehau',8004988,12.032457,50.250556],
['LRF','Rehfeld(Falkenberg)',8012734,13.153331,51.579726],
['BRE','Rehfelde',8012735,13.922803,52.528418],
['WRA','Rehna',8012737,11.049747,53.774263],
['SRW','Rehweiler',8004993,7.440581,49.48516],
['NREK','Reichelsdorfer Keller',8004994,11.040166,49.367922],
['FRHM','Reichelsheim(Wett)',8004995,8.874578,50.360145],
['RRU','Reichenau(Baden)',8004997,9.125961,47.689346],
['RRBK','Reichenbach Kurpark, Waldbronn',722237,8.473062,48.91877],
['XSRC','Reichenbach im Kandertal',8507480,7.690062258479,46.6252278395944],
['TRF','Reichenbach(Fils)',8004999,9.463733,48.707971],
['DRCH','Reichenbach(Oberlausitz)',8012738,14.796362,51.135472],
['DRC','Reichenbach(Vogtl) ob Bf',8012739,12.29312,50.627777],
['RRBA','Reichenbach(b. Ettlingen)',8007012,8.479553,48.920482],
['TRCB','Reichenberg(Unterfr)',8005002,9.91289,49.731129],
['XSRE','Reichenburg',8503223,8.98230203353756,47.1726951082912],
['NREI','Reichenschwand',8005005,11.373441,49.51497],
['MRCH','Reichersbeuern',8005007,11.635984,47.774638],
['MRS','Reichertshausen(Ilm)',8005008,11.510203,48.471197],
['MRFS','Reichertshofen(Schwab) Bf',8005010,10.598236,48.198513],
['TRL','Reicholzheim',8005011,9.527543,49.728514],
['DRF','Reifland-Wünschendorf',8012740,13.194486,50.740437],
['RRIN','Reihen',8005013,8.920591,49.216431],
['SREI','Reil',8005014,7.112949,50.025169],
['RRHM','Reilsheim',8005015,8.778836,49.353966],
['XFRS','Reims',8700081,4.024156,49.259244],
['ARBK','Reinbek',8005016,10.253335,53.508395],
['ARD','Reinfeld(Holst)',8005019,10.494537,53.83043],
['URN','Reinhardsbrunn-Friedrichroda',8012742,10.562728,50.863498],
['FREI','Reinheim(Odenw)',8005020,8.835689,49.829806],
['ARE','Reinsbüttel',8005023,8.906647,54.181206],
['URD','Reinsdorf(Artern)',8010124,11.286051,51.34227],
['URDN','Reinsdorf(bei Nebra)',8012743,11.601464,51.297997],
['TRTT','Reinstetten',8079094,9.93981,48.109047],
['RRSH','Reisen(Hess)',8005026,8.720015,49.57797],
['FRSK','Reiskirchen(Kr Gi)',8005027,8.83093,50.597832],
['XARE','Reith b.Seefeld',8100112,11.200652,47.300848],
['XDRE','Rejsby st',8601964,8.732178,55.229999],
['XARWL','Rekawinkel',8101432,16.0317297985089,48.1797800927769],
['EREK','Reken',8005030,7.049956,51.801846],
['EREKK','Reken-Klein Reken',8003305,7.03519821,51.7870373],
['EMV','Reken-Maria Veen',8003860,7.098167,51.839266],
['XSRN','Rekingen AG',8503408,8.32711190205277,47.5699674290436],
['KRE','Remagen',8000310,7.229779,50.577215],
['XFRT','Remiremont',8701879,6.599071,48.016433],
['KR','Remscheid Hbf',8005033,7.199983,51.177235],
['KRG','Remscheid-Güldenwerth',8005034,7.16303,51.169198],
['KRL','Remscheid-Lennep',8000311,7.252833,51.190724],
['KRLU','Remscheid-Lüttringhausen',8005035,7.242728,51.215323],
['RR','Renchen',8005037,8.007138,48.59266],
['AR','Rendsburg',8000312,9.671134,54.302262],
['XFR','Rennes',8700025,-1.672339,48.103178],
['TRX','Renningen',8000313,8.93235,48.775121],
['TRXS','Renningen Süd',8005001,8.932027,48.762674],
['UREN','Rennsteig',8012749,10.835138,50.615249],
['SRE','Rentrisch',8005044,7.079065,49.25977],
['NREN','Rentweinsdorf',8005045,10.813855,50.060448],
['URH','Rentwertshausen',8012750,10.432284,50.455159],
['URM','Rentzschmühle',8012751,12.157813,50.575007],
['OMRPC','Repcelak',5501132,17.009101,47.419267],
['XTRE','Retenice',5402744,13.800925,50.642648],
['HRTN','Rethen(Leine)',8005047,9.819496,52.285807],
['XAREZ','Retz',8100469,15.9574469686991,48.7539401441072],
['NREZ','Retzbach-Zellingen',8005049,9.814214,49.905152],
['URR','Reurieth',8012756,10.653519,50.459791],
['WRST','Reuterstadt Stavenhagen',8012758,12.9142,53.706919],
['NRT','Reuth(b Erbendorf)',8005050,12.118438,49.840039],
['DRTH','Reuth(b Plauen,Vogtl)',8012759,11.954337,50.475859],
['TRE','Reutlingen Hbf',8000314,9.209116,48.496079],
['TREW','Reutlingen West',8005052,9.20185,48.492613],
['TREB','Reutlingen-Betzingen',8005053,9.175442,48.49621],
['TRES','Reutlingen-Sondelfingen',8005054,9.236915,48.515132],
['XART','Reutte in Tirol',8100115,10.7217460323692,47.4930389583872],
['XARTS','Reutte in Tirol Schulzentrum',8101912,10.7249260522324,47.4897639687645],
['ONRE','Reuver',8400518,6.0789585113525,51.28321916653],
['LRE','Reußen',8012757,12.134346,51.503201],
['ERHA','Rhade',8005055,6.948091,51.75127],
['ERDW','Rheda-Wiedenbrück',8000315,8.28665,51.857023],
['ONRH','Rheden(NL)',8400519,6.0314,52.0101],
['KRBA','Rheinbach',8005058,6.947513,50.629213],
['KRBL','Rheinbach Römerkanal',8005057,6.967911,50.628284],
['KRBE','Rheinberg(Rheinl)',8005059,6.591944,51.542382],
['KRBR','Rheinbrohl',8005062,7.333427,50.489493],
['HR','Rheine',8000316,7.434255,52.276299],
['HMSU','Rheine-Mesum',8004000,7.485613,52.223134],
['XSRH','Rheineck',8506313,9.59090422658998,47.4668881390747],
['RRH','Rheinfelden(Baden)',8005064,7.784209,47.556923],
['XSRD','Rheinfelden(CH)',8500301,7.79215393064317,47.5512096146335],
['RK  H','Rheinhafen, Karlsruhe',362391,8.347322,49.015578],
['PQKRH','Rheinhafenstraße, Karlsruhe',723924,8.34525,49.001666],
['KRH','Rheinhausen',8000317,6.706484,51.393507],
['KRHO','Rheinhausen Ost',8005065,6.724108,51.401873],
['WRH','Rheinsberg(Mark)',8012760,12.899993,53.092858],
['RRHH','Rheinsheim',8005067,8.415966,49.229156],
['RRW','Rheinweiler',8005068,7.531643,47.709532],
['RRZU','Rheinzabern Alte Römerstraße',8005072,8.273057,49.109366],
['RRZA','Rheinzabern Bf',8005069,8.274166,49.119537],
['RRZM','Rheinzabern Rappengasse',8005071,8.273291,49.114836],
['ONRHN','Rhenen',8400517,5.5783333778381,51.958610534668],
['KRHE','Rhens',8005070,7.620484,50.281519],
['KRY','Rheydt Hbf',8000318,6.439564,51.163027],
['KRYO','Rheydt-Odenkirchen',8005073,6.446169,51.137847],
['KRHD','Rhöndorf',8005074,7.210214,50.657876],
['PSDRK','Riazzino',8505412,8.886493,46.175232],
['XDRBN','Ribe Noerremark st',8601972,8.775832,55.339906],
['XDRB','Ribe st',8601971,8.770304,55.327634],
['WRIO','Ribnitz-Damgarten Ost',8012762,12.487015,54.251016],
['WRI','Ribnitz-Damgarten West',8012763,12.436965,54.239176],
['RRIH','Richen(b Eppingen)',8005077,8.936554,49.167846],
['XSRW','Richterswil',8503207,8.70746042266797,47.2083677130556],
['ARL','Rickling',8005080,10.168318,53.999058],
['FRID','Ried',8005083,9.769765,50.459238],
['XARI','Ried im Innkreis',8100405,13.4877004262402,48.2004513359074],
['OARI','Riedau',8100407,13.626721,48.304471],
['MRDU','Riederau',8005086,11.097153,47.982581],
['TRI','Riedlingen',8005087,9.484927,48.149595],
['FRIE','Riedrode',8005089,8.49595,49.647488],
['FGE','Riedstadt-Goddelau',8000126,8.489187,49.83323],
['FLW','Riedstadt-Wolfskehlen',8003605,8.493098,49.853937],
['RROP','Riegel am Kaiserstuhl Ort',8007284,7.749943,48.154055],
['RRL','Riegel-Malterdingen',8005090,7.77085,48.151969],
['RRP','Riegel-Malterdingen (SWEG)',8007299,7.770728,48.152021],
['RRIE','Riehen',8005091,7.652014,47.583157],
['RRID','Riehen Niederholz',8005093,7.63347,47.569463],
['NRCK','Rieneck',8005092,9.664138,50.091664],
['DR','Riesa',8010297,13.287734,51.309654],
['SRI','Rieschweiler',8005094,7.507438,49.244747],
['ARY','Rieseby',8005095,9.820489,54.541358],
['ASBRS','Rieseby Schleibrücke Süd',8085385,9.821102,54.582384],
['HRIE','Rieste',8005096,8.010613,52.48472],
['URIE','Riestedt',8012766,11.379856,51.484021],
['OSRIT','Rietheim(CH)',8503410,8.27728,47.6008],
['TRH','Rietheim(Württ)',8005097,8.782636,48.039008],
['BRI','Rietschen',8012767,14.783887,51.398624],
['XARZ','Rietz in Tirol',8101457,11.023813,47.291922],
['ONRIS','Rijssen',8400538,6.5202779769897,52.3122215271],
['ONRIW','Rijswijk',8400505,4.3191666603088,52.039722442627],
['ONRIB','Rilland-Bath',8400521,4.1611108779907,51.422779083252],
['RRIM','Rimbach',8005098,8.757296,49.627348],
['XIRI','Rimini',8300221,12.574016,44.064237],
['WRIW','Ringenwalde(Templin)',8012768,13.7075,53.057004],
['URGS','Ringleben-Gebesee',8012769,10.957993,51.104096],
['RRI','Ringsheim/Europa-Park',8005101,7.773037,48.248726],
['XDRI','Ringsted st',8601979,11.786155,55.438036],
['ERIK','Rinkerode',8005102,7.689387,51.844383],
['RBTR','Rinklingen',8079059,8.673874,49.03671],
['RRIT','Rinnthal',8005103,7.927918,49.217075],
['HRIN','Rinteln',8005104,9.077815,52.198936],
['PQKRN','Rintheim Sinsheimer Straße, Karlsruhe',370404,8.445062,49.020968],
['XIRP','Rio di Pusteria/Mühlbach',8300428,11.669748,46.797261],
['RRB','Rippberg',8005105,9.291189,49.624722],
['URI','Ritschenhausen',8012770,10.429506,50.512863],
['HRTH','Ritterhude',8005107,8.753889,53.183633],
['XBRV','Rivage',8800014,5.585969,50.485038],
['XSRB','Rivera-Bironico',8505216,8.92528147890578,46.1239793633486],
['XFRV','Rivesaltes',8700489,2.867761,42.766377],
['OFRXM','Rixheim(Mulhouse)',8701910,7.4062493,47.7487462],
['XFROA','Roanne',8700094,4.06304,46.039339],
['XIRL','Robilante',8302022,7.511007,44.296488],
['XIROV','Roccavione',8301989,7.485489,44.314426],
['XBJ','Rochefort-Jemelle',8800020,5.266761,50.160356],
['DROC','Rochlitz(Sachs)',8010298,12.793422,51.055704],
['SRC','Rockenhausen',8005111,7.81727,49.628385],
['SROA','Rodalben',8005113,7.631712,49.239238],
['XLRD','Rodange',8200940,5.843466,49.551086],
['FRB','Rodenbach(Dillkr)',8005116,8.205263,50.773991],
['FROD','Rodenbach(b Hanau)',8004402,9.01256,50.147267],
['HRDK','Rodenkirchen(Oldb)',8005119,8.454794,53.399841],
['DROW','Rodewisch',8012775,12.395337,50.528653],
['FDU','Rodgau-Dudenhofen',8001567,8.884482,50.010661],
['FHHN','Rodgau-Hainhausen',8002528,8.875611,50.04022],
['FJUE','Rodgau-Jügesheim',8003131,8.878957,50.025984],
['FNRO','Rodgau-Nieder Roden',8004351,8.871215,49.997442],
['FROL','Rodgau-Rollwald',8005156,8.846545,49.987985],
['FWEK','Rodgau-Weiskirchen',8006293,8.877828,50.052573],
['FRO','Rodheim v d Höhe',8005120,8.695803,50.267604],
['NROD','Roding',8005121,12.51574,49.21448],
['LROD','Rodleben',8012777,12.214799,51.898357],
['XDRD','Roedekro st',8601996,9.332754,55.069686],
['XNRM','Roermond',8400523,5.9941668510437,51.193054199219],
['XFRSW','Roeschwoog',8700412,8.029835,48.833624],
['WRGT','Roggentin',8012785,12.213086,54.073494],
['XSRO','Roggwil-Berg',8506394,9.392012710833,47.4855867172536],
['XSRY','Roggwil-Wynau',8508101,7.8149047588659,47.2516286412186],
['UROH','Rohr(Thür)',8012787,10.515839,50.571588],
['XARH','Rohr-Bad Hall',8100167,14.1911327556412,48.0696994139544],
['OARRH','Rohr/Raab',8101454,15.812412,46.976314],
['MRBI','Rohrbach(Ilm)',8000256,11.573177,48.605855],
['MROH','Rohrbach(Oberbay)',8005145,12.551407,48.298159],
['RRST','Rohrbach(Pfalz)',8005146,8.14152,49.138017],
['SRO','Rohrbach(Saar)',8000319,7.157395,49.276737],
['MRDO','Rohrdorf(Oberbay)',8005148,12.173701,47.798095],
['MRFD','Rohrenfeld',8005149,11.259809,48.721194],
['TRO','Roigheim',8005151,9.341831,49.360833],
['KROI','Roisdorf',8005152,7.01614,50.753181],
['LROI','Roitzsch(Bitterf)',8012788,12.26454,51.571167],
['XTRO','Rokycany',5400182,13.591744,49.740378],
['KROL','Rolandseck',8005153,7.206835,50.63138],
['NRON','Rollhofen',8005154,11.335524,49.543716],
['XIRM','Roma Termini',8300263,12.502788,41.900493],
['XSR','Romanshorn',8506121,9.37936259731519,47.5655269843802],
['XSRHF','Romanshorn (See)',8506112,9.37997531046235,47.5655617030878],
['XFRO','Rombas-Clouange',8700369,6.099975,49.255991],
['TROM','Rommelshausen',8005157,9.319344,48.81554],
['KROM','Rommerskirchen',8005159,6.69959,51.039933],
['XBRO','Ronet',8800155,4.82842,50.457737],
['DRON','Ronneburg(Thür)',8010301,12.18172,50.859555],
['HRBG','Ronnenberg',8005160,9.651786,52.323073],
['FRON','Ronshausen',8005161,9.854425,50.946016],
['ONRS','Roodeschool',8400525,6.7587,53.421262],
['XLRT','Roodt/Syre',8270890,6.303071,49.666803],
['XNRD','Roosendaal',8400526,4.4583334922791,51.540279388428],
['XARP','Roppen',8101448,10.8173889556115,47.2157974115755],
['XSRS','Rorschach',8506311,9.5051316803467,47.4779984015879],
['XSRSH','Rorschach Hafen',8506306,9.49290567677393,47.4785940342802],
['XSRSS','Rorschach Hafen (See)',8506113,9.49250636652451,47.4789070232403],
['FROS','Rosbach v d Höhe',8005163,8.7008,50.298669],
['KROS','Rosbach(Sieg)',8005164,7.608767,50.796768],
['NRNU','Rosenau(b Grafenau)',8005166,13.408466,48.874132],
['XARB','Rosenbach bei Villach',8100083,14.035515,46.531292],
['TRBG','Rosenberg(Baden)',8005168,9.471425,49.457583],
['EHW','Rosendahl-Holtwick',8002972,7.122568,51.998391],
['MRO','Rosenheim',8000320,12.119202,47.850018],
['MRAI','Rosenheim Aicherpark',8005169,12.089467,47.851651],
['MROS','Rosenheim Hochschule',8005173,12.104178,47.866304],
['WROW','Rosenwinkel',8012792,12.343197,53.038194],
['XDRK','Roskilde st',8602026,12.088854,55.639014],
['ONROS','Rosmalen',8400524,5.3680553436279,51.714721679688],
['WR','Rostock Hbf',8010304,12.131079,54.078246],
['WRHO','Rostock Holbeinplatz',8012805,12.099466,54.0933],
['WRHP','Rostock Parkstraße',8012801,12.10789,54.085243],
['WRSN','Rostock Seehafen Nord',8012802,12.11197118,54.14208075],
['WRTF','Rostock Thierfelder Str.',8079629,12.09991,54.077877],
['WRB','Rostock-Bramow',8012803,12.090548,54.101746],
['WEV','Rostock-Evershagen',8011523,12.068507,54.123552],
['WRK','Rostock-Kassebohm',8012806,12.163316,54.079425],
['WLH','Rostock-Lichtenhagen',8012221,12.070866,54.152403],
['WLKL','Rostock-Lütten Klein',8012271,12.064985,54.138222],
['WRMA','Rostock-Marienehe',8012807,12.080072,54.111774],
['WGMS','Rostock-Torfbrücke',8012582,12.227735,54.241758],
['TRS','Rot am See',8005179,10.030336,49.249393],
['RRM','Rot-Malsch',8005181,8.65221,49.243385],
['XTRV','Rotava',5402682,12.53556,50.286822],
['TRY','Rotenbach(Enz)',8070277,8.578903,48.830163],
['FROF','Rotenburg a.d. Fulda',8005182,9.733344,50.997855],
['AROG','Rotenburg(Wümme)',8000321,9.390098,53.112349],
['FRTN','Rotenhain',8005184,7.893375,50.601621],
['NRO','Roth',8005185,11.082508,49.241287],
['NROT','Rothenburg ob der Tauber',8005190,10.1907,49.37669],
['XSRTB','Rothenburg(CH)',8502020,8.2491774137357,47.0881904457208],
['NRBG','Rothenbürg',8005189,11.773125,50.310565],
['UROT','Rothenstein(Saale)',8012811,11.609223,50.851148],
['XSRTT','Rothenthurm(CH)',8503282,8.67466069214818,47.1057933987156],
['XSRR','Rothrist',8508103,7.87938648835843,47.3064476644103],
['XSRK','Rotkreuz',8502202,8.43047453437533,47.1417586665254],
['MRT','Rott(Inn)',8005194,12.136133,47.988171],
['TRR','Rottenacker',8005195,9.694364,48.234844],
['URTB','Rottenbach',8010305,11.169816,50.689343],
['TRT','Rottenburg(Neckar)',8005197,8.935548,48.47243],
['NRTD','Rottendorf',8005198,10.029094,49.791971],
['ONROA','Rotterdam Alexander',8400507,4.5536112785339,51.951946258545],
['ONRBL','Rotterdam Blaak',8400529,4.4888887405395,51.920276641846],
['XNRC','Rotterdam Centraal',8400530,4.468888759613,51.92499923706],
['XNRL','Rotterdam Lombardijen',8400542,4.531388759613,51.880001068115],
['PNRN','Rotterdam Noord',8400531,4.4816665649414,51.942222595215],
['ONROZ','Rotterdam Zuid',8400533,4.5102777481079,51.904445648193],
['NRHN','Rottershausen',8005199,10.166333,50.166441],
['TR','Rottweil',8000322,8.639295,48.165304],
['TRG','Rottweil Göllsdorf',8005200,8.651078,48.16001],
['TRNF','Rottweil Neufra',8004280,8.67042,48.126824],
['TRSA','Rottweil Saline',8005202,8.645609,48.14871],
['OFRX','Roubaix',8700236,3.163061,50.695745],
['XTRN','Roudnice nad Labem',5400183,14.263827,50.426597],
['XFROU','Rouffach',8701862,7.312616,47.960319],
['XIRR','Rovereto',8300113,11.033601,45.89096],
['SROB','Roßbach(Pfalz)',8005172,7.623254,49.572112],
['UROS','Roßla',8012796,11.065487,51.462881],
['LR','Roßlau(Elbe)',8010302,12.237262,51.884612],
['NRL','Roßtal',8005177,10.898632,49.400694],
['NRW','Roßtal Wegbrücke',8005178,10.885414,49.394778],
['TRU','Rudersberg',8007196,9.530716,48.881864],
['TRUN','Rudersberg Nord',8070079,9.534161,48.887613],
['TRUO','Rudersberg-Oberndorf',8007625,9.543699,48.891722],
['UR','Rudolstadt(Thür)',8010306,11.339156,50.717997],
['URS','Rudolstadt-Schwarza',8010307,11.328199,50.691119],
['BRU','Ruhland',8010308,13.870004,51.455319],
['BRUZ','Ruhlsdorf-Zerpenschleuse',8012821,13.541511,52.843215],
['NRUF','Ruhmannsfelden',8070664,12.99151,48.989413],
['MRPD','Ruhpolding',8005222,12.649033,47.762251],
['MRUS','Ruhstorf',8005223,13.334949,48.433647],
['PBRUS','Ruisbroek-Sauvegarde',8800099,4.326301,51.08114],
['XARU','Rum b.Innsbruck',8100477,11.45617,47.27803],
['XTRU','Rumburk',5400227,14.550814,50.956839],
['KRUM','Rumeln',8005225,6.675979,51.398113],
['EROL','Rummenohl',8005227,7.528306,51.277809],
['NRUD','Runding',8005228,12.72776282,49.21758469],
['FRUK','Runkel',8005229,8.15937,50.405284],
['XSRP','Rupperswil',8502114,8.12694494762455,47.4032880043253],
['DRUG','Ruppertsgrün',8012823,12.176392,50.575023],
['NRST','Rupprechtstegen',8005231,11.480483,49.597437],
['SRUB','Ruschberg',8007886,7.286185,49.622909],
['ARWD','Ruschwedel',8007845,9.560046,53.446216],
['TRUT','Rutesheim',8005236,8.95955,48.790017],
['WRU','Ruthenbeck',8012824,11.711168,53.545245],
['ONRU','Ruurlo',8400537,6.4492656,52.0810888],
['OPRYI','Rybnica',5103213,15.645599,50.910318],
['OTRYB','Rybnik(CZ)',5402728,14.431705,48.649513],
['OPRY','Rybnik(PL)',5100262,18.547641,50.089135],
['XTRY','Rybniste',5400255,14.509805,50.883077],
['XTRTB','Rynoltice',5402736,14.826152,50.786923],
['XPR','Rzepin',5100082,14.815073,52.350222],
['XPRZ','Rzeszow Gl.',5100229,22.006798,50.04311],
['LRI','Rätzlingen',8012705,11.123409,52.409035],
['XFRD','Réding(F)',8700452,7.095652,48.742745],
['XFRM','Rémilly',8700169,6.39514,49.014351],
['LRN','Röblingen am See',8010299,11.668535,51.462603],
['NRTL','Rödental',8004633,11.031308,50.288366],
['NRTM','Rödental Mitte',8005122,11.050672,50.295736],
['FORD','Rödermark-Ober Roden',8000285,8.828961,49.973622],
['FUCH','Rödermark-Urberach',8006031,8.798159,49.975137],
['DRDF','Rödlitz-Hohndorf',8012781,12.654033,50.742252],
['MRMS','Röhrmoos',8005127,11.44477,48.333318],
['NRBH','Röhrnbach',8070810,13.526134,48.737053],
['FROH','Rönshausen',8005131,9.74373,50.478451],
['BRGT','Röntgental',8081210,13.513799,52.648798],
['NROE','Röslau',8005133,11.994091,50.075097],
['KROE','Rösrath',8005134,7.182662,50.901549],
['KRST','Rösrath-Stümpen',8005143,7.15927,50.898665],
['RRT','Röt',8005135,8.397356,48.555465],
['RROE','Rötenbach(Baden)',8005136,8.290057,47.89283],
['HROT','Rötgesbüttel',8005137,10.52432,52.416173],
['MRTA','Röthenbach(Allgäu)',8005138,9.953543,47.620618],
['NRTH','Röthenbach(Oberpf)',8005139,11.995583,49.623543],
['NRP','Röthenbach(Pegnitz)',8005140,11.231104,49.4794],
['NRPE','Röthenbach-Seespitze',8005142,11.26149,49.491524],
['NRPG','Röthenbach-Steinberg',8005141,11.246357,49.483383],
['WRV','Rövershagen',8010300,12.247446,54.175568],
['FRS','Rückersbacher Schlucht',8005208,9.057186,50.019628],
['BRO','Rückersdorf',8012816,13.574281,51.567358],
['NRUE','Rückersdorf(Mfr)',8005209,11.231788,49.491202],
['FRDH','Rüdesheim(Rhein)',8005213,7.915418,49.97689],
['WRZ','Rüdnitz',8012819,13.63634,52.717704],
['RRZH','Rülzheim Bf',8005217,8.290446,49.160871],
['RRZD','Rülzheim Freizeitzentrum',8005214,8.279365,49.15159],
['OSRRU','Rümikon AG',8503415,8.37403,47.56531],
['XSRU','Rümlang',8503311,8.53274503651097,47.4540663115926],
['RRMM','Rümmingen',8070524,7.640709,47.642926],
['KRUN','Ründeroth',8005218,7.465132,50.995077],
['RRUB','Rüppurr Battstraße, Karlsruhe',722324,8.404808,48.965249],
['RRUO','Rüppurr Ostendorfplatz, Karlsruhe',722325,8.406614,48.975764],
['RRUT','Rüppurr Tulpenstraße, Karlsruhe',722326,8.404045,48.97107],
['RKRT','Rüppurrer Tor, Karlsruhe',721759,8.41042,49.005034],
['XSRL','Rüschlikon',8503201,8.55515146936332,47.307132384681],
['NRLB','Rüsselbach',8005219,11.231771,49.608738],
['FRUE','Rüsselsheim',8005220,8.413583,49.991639],
['FRUO','Rüsselsheim Opelwerk',8005221,8.400373,49.988],
['XSRT','Rüthi SG',8509401,9.53604616418714,47.2867324557409],
['OSSAT','S. Antonino',8505415,8.974282,46.160678],
['OSSNR','S. Nazzaro',8505407,8.807056,46.135158],
['NSL','Saal(Donau)',8005238,11.933195,48.90242],
['FSB','Saalburg(Taunus)',8007851,8.586492,50.283609],
['US','Saalfeld(Saale)',8010309,11.374987,50.650316],
['XASA','Saalfelden',8100049,12.8297349965758,47.4267390784968],
['SSH','Saarbrücken Hbf',8000323,6.991021,49.241065],
['SSO','Saarbrücken Ost',8005241,7.018788,49.230425],
['SSB','Saarbrücken-Burbach',8005243,6.957086,49.242167],
['SSAB','Saarburg(Bz Trier)',8005245,6.557034,49.606455],
['SSLB','Saarhölzbach',8005246,6.6075,49.516441],
['SSLS','Saarlouis Hbf',8005247,6.750169,49.32783],
['BSAM','Saarmund',8081220,13.139005,52.323553],
['FSAA','Saasen',8005249,8.881774,50.59408],
['WSAA','Saatel',8012827,12.77268,54.300371],
['NSA','Sachsen(b Ansbach)',8005250,10.661498,49.29299],
['LSAD','Sachsendorf(Calbe)',8012830,11.865517,51.870054],
['BSAH','Sachsenhausen(Nordb)',8012831,13.251867,52.772269],
['TSA','Sachsenheim',8005253,9.063158,48.961292],
['XSSA','Safenwil',8502100,7.98350900935745,47.3217529599857],
['WSAG','Sagard',8012832,13.564956,54.524379],
['ASAG','Sagehorn',8005256,9.022394,53.08405],
['XFSZE','Saincaize',8700035,3.072103,46.931273],
['XBSG','Saint Ghislain',8800133,3.820253,50.44286],
['XFSAS','Saintes',8700418,-0.617409,45.748922],
['TSAL','Salach',8005258,9.737183,48.689398],
['RSLM','Salem',8004029,9.2972,47.757673],
['XSSZ','Salez-Sennwald',8509402,9.50232064244831,47.2414442444337],
['MSAL','Sallach',8005259,12.360541,48.81127],
['SSMT','Salmtal',8005260,6.839254,49.921684],
['OISSA','Salorno/Salurn',8302197,11.202825,46.245752],
['OFSLP','Salses(Perpignan)',8701991,2.917494,42.835568],
['HSAL','Salzbergen',8005262,7.350526,52.32325],
['XASBA','Salzburg Aigen',8101470,13.0787928506003,47.7885792154792],
['XAAI','Salzburg Aiglhof',8102048,13.0268283771151,47.8078673204272],
['XASG','Salzburg Gnigl',8100559,13.0663828956381,47.8120237445838],
['XASB','Salzburg Hbf',8100002,13.046756378102,47.8136297940914],
['XASBK','Salzburg Kasern',8101558,13.065336,47.838874],
['XASLF','Salzburg Liefering',8102063,13.0007765382897,47.8240389720688],
['XAML','Salzburg Mülln-Altstadt',8102052,13.0337828783657,47.8083899458954],
['XASBP','Salzburg Parsch',8101481,13.0731653216014,47.7990790119191],
['XASSA','Salzburg Sam',8102055,13.063199297621,47.8195034189248],
['XASBS','Salzburg Süd',8101917,13.0785299473885,47.7701078768375],
['XATX','Salzburg Taxham Europark',8102045,13.0108233471485,47.8159723773145],
['HSB','Salzgitter-Bad',8005265,10.372335,52.049824],
['HSI','Salzgitter-Immendorf',8005269,10.441891,52.150101],
['HSL','Salzgitter-Lebenstedt',8005270,10.33249,52.151155],
['HSRI','Salzgitter-Ringelheim',8000325,10.31483,52.038158],
['HST','Salzgitter-Thiede',8005274,10.493609,52.180553],
['HSW','Salzgitter-Watenstedt',8005275,10.407398,52.150168],
['ESZK','Salzkotten',8005276,8.600489,51.672875],
['LSW','Salzwedel',8010310,11.162035,52.858113],
['XSSD','Samedan',8509251,9.87363541630226,46.5337641741307],
['XSSMT','Samstagern',8503286,8.68597267489496,47.1915464206901],
['WSAM','Samtens',8012835,13.290177,54.354116],
['XISCI','San Candido/Innichen',8300114,12.272041,46.732732],
['PIHRH','San Lorenzo/St.Lorenzen',8396239,11.903372,46.781518],
['NSND','Sand(Niederbay)',8005279,12.672642,48.897143],
['HSAN','Sande',8005282,8.031519,53.489796],
['ESDB','Sandebeck',8005283,8.986954,51.818371],
['LSA','Sandersdorf(Bitterf)',8012838,12.2604,51.628239],
['FKBHH','Sandershäuser Straße, Kassel',712612,9.518088,51.309073],
['LSL','Sandersleben(Anh)',8010311,11.56002,51.679063],
['WSAF','Sandförde',8012839,13.971273,53.563981],
['WSAN','Sandhagen(b Bad Dob)',8012840,11.740909,54.052785],
['HSAK','Sandkrug',8005287,8.254993,53.054427],
['ASDW','Sandwehle',8005288,8.758482,54.325749],
['XLSC','Sandweiler-Contern',8270930,6.205689,49.600738],
['USG','Sangerhausen',8010312,11.294515,51.479891],
['WSTZ','Sanitz(b Rostock)',8012841,12.376588,54.07506],
['KB  M','Sankt Augustin Zentrum',8070025,7.187892,50.776658],
['XFSN','Sanry-sur-Nied',8702039,6.340066,49.044777],
['ESCI','Sanssouci',8005289,7.878844,51.353665],
['ONSN','Santpoort Noord',8400543,4.6325001716614,52.43388748169],
['ONSZ','Santpoort Zuid',8400544,4.6313886642456,52.419723510742],
['OMSAP','Sap',5501151,21.360366,47.259493],
['XSSR','Sargans',8509411,9.4453956275359,47.0453635269429],
['WSAW','Sarnow',8012842,12.229871,53.11728],
['XFSB','Sarrebourg',8700265,7.052033,48.738594],
['XFSM','Sarreguemines',8700439,7.067878,49.107257],
['HSRD','Sarstedt',8005292,9.842592,52.2326],
['RSAS','Sasbach am Kaiserstuhl',8007287,7.620345,48.138749],
['PNABS','Sassenheim',8400102,4.8936109542847,52.215278],
['ESAS','Sassenroth',8005293,7.915248,50.771569],
['WSZ','Sassnitz',8012843,13.637909,54.516284],
['XFSRI','Sathonay Rillieux',8704456,4.875424,45.820135],
['OTSAT','Satov',5400228,16.025987,48.780539],
['TSAT','Satteldorf',8005297,10.078155,49.178443],
['KSA','Satzvey',8005298,6.713237,50.622859],
['MSR','Sauerlach',8005299,11.654774,47.974061],
['RSDO','Sauldorf',8077776,9.0946518,47.944482],
['MSGB','Saulgrub',8005302,11.025397,47.66609],
['FSLH','Saulheim',8004352,8.154249,49.873807],
['XFSUD','Saumur Rive Droit',8704969,-0.071562,47.26886],
['ONSAU','Sauwerd',8400547,6.5404,53.29113],
['XFSV','Saverne',8700266,7.362095,48.744862],
['XASVZ','Schaan-Vaduz',8100482,9.5078,47.168293],
['XBS','Schaerbeek',8800001,4.378656,50.878404],
['SSU','Schafbrücke',8005306,7.049237,49.22794],
['XSS','Schaffhausen',8503424,8.63272848589521,47.6982814692071],
['XASFU','Schaftenau',8100483,12.1254177725974,47.5588271226355],
['MSFL','Schaftlach',8005311,11.684123,47.795471],
['ONSG','Schagen',8400549,4.8052778244019,52.784442901611],
['RSAI','Schaidt(Pfalz)',8007857,8.079776,49.061238],
['MSCA','Schalchen',8005312,12.570982,48.059071],
['XASMH','Schalchen-Mattighofen',8102068,13.161673,48.097242],
['USCK','Schalkau',8012852,11.001731,50.400554],
['USKM','Schalkau Mitte',8012854,11.008687,50.396618],
['ESMU','Schalksmühle',8005316,7.532751,51.240588],
['TSKS','Schalkstetten',8007072,9.91133,48.611798],
['RSAL','Schallstadt',8005317,7.753888,47.955947],
['ESCA','Schameder',8005319,8.293102,50.997584],
['HSDL','Schandelah',8005320,10.685403,52.267226],
['ASAZ','Scharbeutz',8005321,10.745762,54.018743],
['DSS','Scharfenstein',8012853,13.056007,50.702827],
['ESMD','Scharmede',8005322,8.64524,51.71179],
['XAA','Scharnitz',8100088,11.2668091811901,47.3917019317776],
['WST','Scharstorf',8012856,12.245847,53.970079],
['MSC','Schechen',8005327,12.126724,47.927051],
['XNSE','Scheemda',8400551,6.9777775,53.1655362],
['ASL','Scheeßel',8005330,9.496963,53.165825],
['DSG','Scheibenberg',8012859,12.91104906,50.54759429],
['FKSMP','Scheidemannplatz, Kassel',713679,9.492867,51.316259],
['SSD','Scheidt(Saar)',8005332,7.057083,49.244018],
['TSK','Schelklingen',8005333,9.735267,48.371699],
['PBLLB','Schelle',8824232,4.340271,51.125465],
['TSX','Schemmerberg',8005334,9.829031,48.189232],
['RSZL','Schenkenzell',8005335,8.371887,48.308425],
['TSEP','Scheppach',8005329,9.434278,49.1618],
['HSCD','Scherfede',8005336,9.04794,51.524738],
['ESCF','Scheuerfeld(Sieg)',8005338,7.836636,50.791863],
['KSEV','Scheven',8005339,6.59227,50.559662],
['XNSC','Schiedam Centrum',8400553,4.409802,51.921946],
['HSCI','Schieder',8005340,9.152475,51.9224],
['HSCB','Schierbrok',8005343,8.579004,53.084709],
['LSCR','Schierke',8017022,10.678004,51.765073],
['LSIS','Schierstedt',8012862,11.521195,51.751526],
['RSD','Schifferstadt',8000326,8.364945,49.39291],
['RSDS','Schifferstadt Süd',8005345,8.377314,49.374089],
['XLSL','Schifflange',8200630,6.010218,49.5065],
['SSWL','Schiffweiler',8005346,7.12934,49.363371],
['RKMS','Schillerstraße, Karlsruhe',721433,8.37969,49.010099],
['RSCL','Schiltach',8005350,8.335093,48.291218],
['RSCM','Schiltach Mitte',8005347,8.344766,48.291284],
['FSBN','Schimborn',8007280,9.186811,50.057764],
['ONSIG','Schin op Geul',8400555,5.8722224235535,50.856388092041],
['XSSF','Schindellegi-Feusisberg',8503285,8.70936729896086,47.1764022814468],
['ONSI','Schinnen',8400554,5.8744444847107,50.939167022705],
['XNSP','Schiphol (Airport)',8400561,4.7619442939758,52.30944442749],
['DSWK','Schirgiswalde-Kirschau',8012864,14.426345,51.08051],
['NSG','Schirnding',8005352,12.228749,50.0773],
['LSD','Schkeuditz',8012865,12.222169,51.40239],
['LSDW','Schkeuditz West',8012863,12.195667,51.40291],
['LSP','Schkopau',8012867,11.991874,51.38896],
['HSCL','Schladen(Harz)',8005355,10.550134,52.022364],
['KSLA','Schladern(Sieg)',8005356,7.592264,50.807006],
['XASL','Schladming',8100137,13.6779277290979,47.3937162134042],
['TSLT','Schlatt(Hohenz)',8007222,9.025203,48.343544],
['TSLB','Schlechtbach',8007195,9.526361,48.872549],
['BSFE','Schleife',8012870,14.531034,51.5357],
['ASW','Schleswig',8005362,9.53814,54.499457],
['RSG','Schliengen',8005364,7.568937,47.761598],
['FSBA','Schlierbach(Schwalm-Eder-Kr.)',8005365,9.201445,50.968783],
['MSCS','Schliersee',8005367,11.859586,47.735581],
['OASLN','Schlins-Beschling',8101543,9.690518,47.194893],
['PQKGT','Schloss Gottesaue, Karlsruhe',721642,8.427361,49.003638],
['RSRP','Schloss Rüppurr, Karlsruhe',721435,8.403784,48.981218],
['ESHO','Schloß Holte',8005369,8.610576,51.908542],
['RSLU','Schluchsee',8005371,8.177126,47.816868],
['OASGM','Schlöglmühl',8100587,15.913774,47.682597],
['FSUE','Schlüchtern',8000891,9.510039,50.341177],
['OASBG','Schlüßlberg',8100584,13.869178,48.223667],
['BSHN','Schmachtenhagen',8010319,13.336799,52.775309],
['USM','Schmalkalden',8010315,10.440504,50.720181],
['USMS','Schmalkalden-Fachhochschule',8012881,10.463487,50.716422],
['FSMU','Schmalnau',8005374,9.787847,50.456013],
['KSMI','Schmidtheim',8005378,6.552086,50.413239],
['TSHM','Schmiechen',8005379,9.72038,48.362356],
['TSHA','Schmiechen Albbahn',8070974,9.715289,48.364897],
['MSCN','Schmiechen(Schwab)',8005381,10.978087,48.213046],
['DSBG','Schmiedeberg (Dresden)',8012884,13.6775064,50.8338467],
['DNAS','Schmiedeberg-Naundorf',8012885,13.669616,50.84411],
['DSMI','Schmilka-Hirschmühle',8012888,14.228419,50.889918],
['WSCM','Schmollensee',8012892,14.077246,53.982272],
['DSML','Schmölln(Ol)',8012890,14.227957,51.119755],
['DSM','Schmölln(Thür)',8012889,12.354899,50.898319],
['NSAW','Schnabelwaid',8000328,11.59566,49.810453],
['NSMA','Schnaittach Markt',8005383,11.34444,49.556978],
['NSCB','Schneeberg im Odenwald',8005386,9.250801,49.641099],
['BSB','Schneeberg(Mark)',8012895,14.329917,52.164558],
['HSCG','Schnega',8000440,10.890386,52.869058],
['FSNH','Schneidhain',8007163,8.45214,50.172739],
['NSNE','Schnelldorf',8005388,10.178483,49.194325],
['ASDN','Schneverdingen',8005390,9.798868,53.11057],
['NSY','Schney',8005391,11.073623,50.166202],
['NSNI','Schnitzmühle',8070670,12.915158,49.070409],
['SSOF','Schoden-Ockfen',8005392,6.58097,49.636377],
['MSDF','Schondorf(Bay)',8005417,11.089847,48.052848],
['MSGU','Schongau',8005418,10.902459,47.812327],
['NSGN','Schonungen',8005400,10.304913,50.049204],
['RSCH','Schopfheim',8005420,7.822674,47.64797],
['RSCW','Schopfheim West',8005425,7.801715,47.645541],
['RSCS','Schopfheim-Schlattholz',8005426,7.83251434,47.6533979],
['TSPF','Schopfloch(b Freudenstadt)',8005421,8.547754,48.453711],
['SSCP','Schopp',8005423,7.687317,49.358867],
['TSF','Schorndorf',8005424,9.52631,48.80715],
['TSFH','Schorndorf-Hammerschlag',8007191,9.534566,48.807605],
['HHDM','Schortens-Heidmühle',8002695,7.946367,53.542158],
['XLSW','Schouweiler',8270960,5.959944,49.573523],
['TSCH','Schrezheim',8005431,10.11788,48.951125],
['MSHN','Schrobenhausen',8005432,11.259237,48.565267],
['TSZG','Schrozberg',8005433,9.974904,49.346916],
['XASN','Schruns',8100117,9.917602,47.079505],
['XBSU','Schulen',8800245,5.185625,50.964046],
['ESCT','Schutzbach',8007080,7.903878,50.758491],
['WSN','Schwaan',8010322,12.117894,53.939188],
['NSC','Schwabach',8005439,11.035351,49.326195],
['NSCL','Schwabach-Limbach',8005440,11.044422,49.338233],
['MSHH','Schwabhausen(b Dachau)',8005442,11.364758,48.300517],
['MSMN','Schwabmünchen',8005444,10.768291,48.178688],
['TSWA','Schwabsberg',8005445,10.138893,48.92519],
['NSAI','Schwaig',8005451,11.200442,49.471494],
['TSWO','Schwaigern Ost',8070156,9.069164,49.140544],
['TSWG','Schwaigern(Württ)',8005453,9.05644,49.138366],
['TSWW','Schwaigern(Württ) West',8071002,9.042472,49.138813],
['TSWK','Schwaikheim',8005454,9.354943,48.86834],
['FSTS','Schwalbach(Taunus)Limes',8005455,8.52797,50.154354],
['FSLN','Schwalbach(Taunus)Nord',8005456,8.534777,50.15986],
['USWL','Schwallungen',8012929,10.346514,50.689385],
['FWRA','Schwalmstadt-Wiera',8006401,9.136421,50.881937],
['NSCH','Schwandorf',8000027,12.104219,49.326139],
['OASST','Schwanenstadt',8100016,13.767879,48.054004],
['WSAH','Schwanheide',8012933,10.689993,53.428156],
['BSHE','Schwante',8012934,13.091733,52.734683],
['HSWS','Schwarmstedt',8005457,9.624754,52.67888],
['OASWV','Schwarzach i Vorarl.',8101634,9.754395,47.446134],
['XASW','Schwarzach-St.Veit',8100044,13.154368320768,47.3185248064705],
['USCG','Schwarzburg',8012937,11.181031,50.642817],
['OASZ','Schwarzenau im Waldviertel',8100199,15.267369,48.746632],
['NSBS','Schwarzenbach(Saale)',8005466,11.935887,50.220374],
['NSW','Schwarzenbach(b Pressath)',8005465,11.992901,49.724702],
['ASWA','Schwarzenbek',8005468,10.484736,53.503733],
['RSW','Schwarzenberg',8006715,8.383851,48.598672],
['DSCH','Schwarzenberg Hp',8012938,12.786451,50.532368],
['DSC','Schwarzenberg(Erzg)',8010323,12.786824,50.545119],
['DSCN','Schwarzenberg-Neuwelt',8012939,12.765726,50.554379],
['NSDO','Schwarzenfeld(Opf)',8005469,12.130637,49.392751],
['BSRO','Schwarzheide Ost',8012941,13.890799,51.473649],
['BSKL','Schwarzkollm',8012942,14.133566,51.443187],
['XASC','Schwaz',8100103,11.7016246645856,47.3497447768277],
['XAGS','Schwechat',8100259,16.481428,48.143698],
['WSC','Schwedt(Oder)',8012943,14.290507,53.063069],
['WSCT','Schwedt(Oder)Mitte',8012944,14.271588,53.068323],
['SSWE','Schweich(DB)',8005476,6.740335,49.831062],
['RSHF','Schweighofen',8007860,7.999224,49.032686],
['DSKH','Schweikershain',8012946,12.955222,51.037376],
['NS','Schweinfurt Hbf',8000032,10.212919,50.035313],
['NSMT','Schweinfurt Mitte',8005479,10.228786,50.040173],
['NSST','Schweinfurt Stadt',8005481,10.244297,50.046808],
['DSU','Schweinsburg-Culten',8012947,12.369588,50.78714],
['NSWF','Schweinsdorf',8005485,10.22702,49.40069],
['KSWE','Schwelm',8000033,7.289681,51.290526],
['KSWW','Schwelm West',8005488,7.269619,51.285646],
['MSWN','Schwenningen(Bay)',8005489,10.642895,48.65646],
['RSCV','Schwenningen(Neckar)',8005490,8.535862,48.05977],
['WSWN','Schwenzin',8012949,12.612018,53.536187],
['KSH','Schweppenburg-Heilbrunnen',8071495,7.309218,50.466037],
['WS','Schwerin Hbf',8010324,11.407455,53.634739],
['WSMI','Schwerin Mitte',8012940,11.405334,53.626911],
['WSS','Schwerin Süd',8012951,11.376636,53.574273],
['WSGN','Schwerin-Görries',8010325,11.384935,53.609373],
['WSL','Schwerin-Lankow',8012953,11.369536,53.656656],
['WSMH','Schwerin-Margaretenhof',8012960,11.360973,53.658552],
['WSWZ','Schwerin-Warnitz',8012954,11.345565,53.6617],
['WWST','Schwerin-Wüstmark',8013354,11.399627,53.584045],
['ESRT','Schwerte(Ruhr)',8000037,7.55896,51.442281],
['DSWOP','Schweta Bf',8070693,13.078225,51.24077],
['RSZ','Schwetzingen',8005494,8.578679,49.383434],
['TSBD','Schwieberdingen',8007326,9.071396,48.870579],
['HSWB','Schwindebeck',8070650,10.117192,53.122716],
['MSDG','Schwindegg',8005495,12.249699,48.273193],
['XFSWM','Schwindratzheim',8701943,7.600944,48.753614],
['XSSY','Schwyz',8505006,8.63213946703058,47.0263942921993],
['TSG','Schwäbisch Gmünd',8000329,9.787795,48.801011],
['TSHL','Schwäbisch Hall',8005449,9.733359,49.10821],
['TSHT','Schwäbisch Hall-Hessental',8000330,9.767373,49.096732],
['RSST','Schwörstadt',8005497,7.870328,47.591019],
['XASH','Schärding',8100024,13.442511,48.46372],
['FSK','Schöllkrippen',8007283,9.244214,50.085839],
['TSCS','Schömberg Stausee',8072211,8.771335,48.21129],
['TSCB','Schömberg(b Balingen)',8029359,8.758503,48.205743],
['DSN','Schöna',8012898,14.234719,50.875903],
['USU','Schönau(Hörsel)',8012899,10.429779,50.94522],
['ASCB','Schönberg(Holstein)',8070532,10.375835,54.387422],
['WSBG','Schönberg(Meckl)',8012902,10.92787,53.85338],
['DSB','Schönberg(Vogtl)',8010317,11.961259,50.528427],
['ASCS','Schönberger Strand',8070533,10.412798,54.410736],
['XASBL','Schönbichl in Tirol',8100557,10.596053,47.558761],
['BSBD','Schönborn(Doberl)',8012903,13.468048,51.602008],
['LSBS','Schönebeck Süd',8081260,11.737305,52.006752],
['LSB','Schönebeck(Elbe)',8010318,11.733157,52.018794],
['LSBE','Schönebeck-Bad Salzelmen',8012907,11.723627,51.998364],
['LSBF','Schönebeck-Felgeleben',8013465,11.757148,52.000747],
['LSBO','Schönebeck-Frohse',8081270,11.707384,52.033917],
['DSCK','Schöneck(Vogtl)',8012908,12.343357,50.395988],
['DSCF','Schöneck(Vogtl) Ferienpark',8000343,12.347044,50.38957],
['FBHM','Schöneck-Büdesheim',8001248,8.8436,50.214951],
['FKIL','Schöneck-Kilianstädten',8003255,8.84042,50.201787],
['FOBD','Schöneck-Oberdorfelden',8004523,8.823385,50.196149],
['BSL','Schönerlinde',8012910,13.428633,52.652182],
['HSWO','Schönewörde',8005405,10.634899,52.628178],
['OASLS','Schönfeld-Lassee',8101545,16.80723,48.251102],
['BSOE','Schönfließ(Mark) Dorf',8012914,14.472814,52.437028],
['BSNF','Schönfließ(b Oranienburg)',8081290,13.339419,52.665075],
['MSNG','Schöngeising',8005406,11.192051,48.14737],
['LSH','Schönhausen(Elbe)',8010321,12.04008,52.591254],
['RSOM','Schönmünzach',8005409,8.369354,48.605345],
['WSCN','Schönow(Angerm)',8012918,14.153814,53.184946],
['USCS','Schönstedt',8012919,10.585823,51.120752],
['NSOE','Schönwald(Oberfr)',8005412,12.096647,50.199055],
['BSWH','Schönwalde(Barnim)',8081300,13.432376,52.680106],
['BSCH','Schönwalde(Spreewald)',8012923,13.777723,51.990797],
['XASCH','Schönwies',8101629,10.6608076936357,47.1972591676855],
['HSPP','Schöppenstedt',8005413,10.772047,52.140692],
['ESHM','Schötmar',8005415,8.754951,52.069935],
['XSSBU','Schübelbach-Buttikon',8503222,8.9387628821428,47.1763838552673],
['ASC','Schülldorf',8005435,9.747804,54.298863],
['USP','Schüptitz',8012927,12.029665,50.723169],
['HSTT','Schüttorf',8005436,7.22061,52.31684],
['XSST','Scuol-Tarasp',8509268,10.2862148814735,46.7937752596951],
['DSEB','Sebnitz(Sachs)',8012959,14.272563,50.975952],
['XTSBZ','Sebuzin',5402772,14.053958,50.593048],
['FSN','Sechshelden',8005498,8.252661,50.748892],
['KSEC','Sechtem',8005499,6.957454,50.795711],
['RSE','Seckach',8000042,9.338469,49.441157],
['BSE','Seddin',8013492,12.985452,52.29184],
['BSEO','Sedlitz Ost',8010183,14.055252,51.553101],
['OPSEZ','Sedzislaw',5103361,16.069827,50.81336],
['USE','Seebach(Mühlhausen)',8012961,10.521193,51.170012],
['WAB','Seebad Ahlbeck',8012962,14.187859,53.935478],
['WHF','Seebad Heringsdorf',8012963,14.169586,53.949836],
['WLM','Seebad Lubmin',8012964,13.614807,54.133315],
['USB','Seebergen',8012965,10.792702,50.92927],
['RSEE','Seebrugg',8005502,8.191115,47.803516],
['XAS','Seefeld in Tirol',8100113,11.1894763949385,47.328708772584],
['BSEE','Seefeld(Mark)',8012966,13.675987,52.618294],
['MSH','Seefeld-Hechendorf',8005504,11.19873,48.04137],
['MSEG','Seeg',8005505,10.613981,47.655267],
['BSFD','Seegefeld',8081586,13.11681,52.55248],
['LSNA','Seehausen(Altm)',8012967,11.743515,52.885775],
['WSEE','Seehausen(Uckermark)',8012968,13.884201,53.221367],
['XASK','Seekirchen am Wallersee',8100426,13.1300961023492,47.8993943718728],
['MSEB','Seeleiten-Berggeist',8005506,11.16583,47.670984],
['BSLO','Seelow(Mark)',8012973,14.394413,52.538198],
['BGSW','Seelow-Gusow',8011788,14.351462,52.559303],
['WSEV','Seelvitz',8012974,13.561281,54.367611],
['HS','Seelze',8005507,9.594314,52.391675],
['DSRH','Seerhausen',8012975,13.240079,51.270271],
['HSSN','Seesen',8000043,10.173898,51.887263],
['MSE','Seeshaupt',8005508,11.28703,47.822783],
['SSE','Sehlem(Kr Wittlich)',8005510,6.823421,49.906959],
['DSEH','Sehma',8012976,12.993805,50.535453],
['HSEN','Sehnde',8005511,9.962528,52.318075],
['MSBD','Seiboldsdorf',8005512,12.636988,47.852967],
['DSFS','Seifersdorf',8012977,13.647601,50.939967],
['DSFH','Seifhennersdorf',8012979,14.613706,50.935798],
['DSEN','Seitschen',8012981,14.325332,51.153767],
['XDSE','Sejstrup st',8602117,8.733332,55.43532],
['NSN','Selb Nord',8005516,12.134605,50.178915],
['NSS','Selb Stadt',8005517,12.126305,50.174216],
['NSP','Selb-Plößberg',8005518,12.119884,50.188948],
['NSLZ','Selbitz',8005520,11.748405,50.316476],
['KSHS','Selhausen',8007835,6.439356,50.865695],
['NSLIM','Seligenstadt Mainschleifenbahn',8070859,10.10203,49.857008],
['FSEL','Seligenstadt(Hess)',8005522,8.967472,50.04146],
['NSLI','Seligenstadt(b Würzburg)',8005523,10.102454,49.85426],
['WSIN','Sellin(Rügen) Ost',8012983,13.697662,54.371344],
['WSIW','Sellin(Rügen) West',8070258,13.680913,54.375892],
['ASLL','Sellstedt',8007811,8.723057,53.515529],
['ESEM','Selm',8005525,7.453406,51.706644],
['ESEB','Selm-Beifang',8005526,7.454609,51.693672],
['USEL','Seltendorf',8012984,11.064095,50.386897],
['XASZ','Selzthal',8100150,14.312841,47.550243],
['XASEM','Semmering',8100028,15.8308831,47.6395943],
['MSED','Senden',8005532,10.050502,48.324016],
['EBSL','Senden-Bösensell',8001065,7.487687,51.90703],
['BSN','Senftenberg',8010327,14.003905,51.526941],
['TSE','Sennfeld',8005536,9.380518,49.378762],
['WSES','Serams',8012986,13.582128,54.377976],
['XISER','Seregno',8300066,9.202122,45.644522],
['SSER','Serrig',8005539,6.569981,49.577132],
['TSER','Sersheim',8005540,9.018508,48.958916],
['XISGI','Sesto S. Giovanni',8300866,9.239354,45.541034],
['XFSE','Sete',8700099,3.696536,43.412808],
['NSF','Seubersdorf',8005543,11.628123,49.167648],
['FSG','Seulberg',8005544,8.646005,50.241906],
['NSE','Seulbitz',8005545,11.868771,50.20982],
['XSSV','Sevelen',8509406,9.49382469898941,47.1253714781719],
['XZSN','Sevnica',7900018,15.3012314,46.0096767],
['NSYB','Seybothenreuth',8005547,11.705542,49.894417],
['RSIB','Siebeldingen-Birkweiler',8005551,8.042565,49.20927],
['OASBL','Siebenbrunn-Leopoldsdorf',8101477,16.704475,48.245609],
['XSSW','Siebnen-Wangen',8503221,8.90069892838304,47.1826674890805],
['LSI','Siedenlangenbeck',8012989,11.080807,52.75428],
['ESIH','Siedlinghausen',8005555,8.473835,51.257761],
['PQSI','Siegburg Bahnhof',8075556,7.2031,50.793475],
['KSIB','Siegburg/Bonn',8005556,7.203026,50.793915],
['RSGB','Siegelsbach',8007438,9.087386,49.271227],
['NSDF','Siegelsdorf',8005557,10.875519,49.50635],
['ESIE','Siegen Hbf',8000046,8.016508,50.875939],
['EHTG','Siegen-Geisweid',8003018,8.014352,50.915581],
['ESW','Siegen-Weidenau',8003020,8.029842,50.895966],
['XSSH','Siegershausen',8506195,9.16823879330259,47.6109165826381],
['MSGD','Siegsdorf',8005559,12.646006,47.821827],
['XPSIZ','Sieniawa Zarska',5103420,15.060747,51.636461],
['XFSIK','Sierck-les-Bains',8700526,6.352122,49.442774],
['OFSTZ','Sierentz',8702060,7.4594691,47.6560872],
['ASID','Sierksdorf',8005561,10.769108,54.068523],
['OASIM','Sierndorf an der March',8101524,16.891136,48.511339],
['XSSI','Sierre/Siders',8501509,7.53283036255468,46.2921149791685],
['SSBG','Siersburg',8005562,6.665362,49.361696],
['KSIH','Siershahn',8000060,7.77138,50.485857],
['OSSGW','Siggenthal-Würenlingen',8503502,8.2406,47.52049],
['XUSG','Sighisoara',5300083,24.795735,46.226401],
['TSY','Siglingen',8005566,9.305336,49.297435],
['TSIG','Sigmaringen',8000069,9.221851,48.086984],
['TSID','Sigmaringendorf',8005568,9.260935,48.068901],
['OASHB','Sigmundsherberg',8100493,15.745047,48.685748],
['ESIL','Silbach',8005569,8.481124,51.22367],
['USI','Silberhausen',8012993,10.34241,51.319425],
['LSIB','Silberhütte NE',8017023,11.091686,51.629092],
['DSBS','Silberstraße',8012996,12.549615,50.662054],
['XASIL','Sillian',8100142,12.4250716261526,46.7455944467566],
['XASLZ','Silz im Oberinntal',8100586,10.936724,47.270184],
['MSBI','Simbach(Inn)',8000072,13.023012,48.262726],
['XUSI','Simeria',5300003,23.013784,45.846272],
['NSHU','Simmelsdorf-Hüttenbach',8005572,11.341671,49.598459],
['FSMH','Simtshausen',8005573,8.704856,50.936918],
['XUSN','Sinaia',5300084,25.561277,45.35224],
['TSI','Sindelfingen',8005574,8.999075,48.703891],
['KSID','Sindorf',8005575,6.681106,50.903707],
['RSII','Singen Industriegebiet',8079616,8.872131,47.75945],
['RSIS','Singen Landesgartenschau',8005560,8.827046,47.760737],
['RSI','Singen(Hohentwiel)',8000073,8.840383,47.758438],
['USGN','Singen(Thür)',8012998,11.067263,50.727804],
['FSL','Singlis',8005576,9.323773,51.058605],
['FSI','Sinn',8005577,8.324932,50.649827],
['RSMM','Sinsheim Museum/Arena',8070097,8.899932,49.241239],
['RSM','Sinsheim(Elsenz) Hbf',8005578,8.8751,49.250353],
['XBSD','Sint-Denijs-Boekel',8800373,3.698395,50.874297],
['XBSM','Sint-Mariaburg',8800190,4.43499,51.291379],
['RSZM','Sinzheim',8005587,8.158429,48.75988],
['RSZN','Sinzheim Nord',8005588,8.169792,48.770819],
['KSIZ','Sinzig(Rhein)',8005580,7.258279,50.546982],
['NSIH','Sinzing',8005581,12.037653,48.990796],
['XSSN','Sion',8501506,7.35919185190604,46.227545361518],
['RSIN','Sipplingen',8005582,9.095524,47.795587],
['XSSC','Sissach',8500026,7.81201832436554,47.4627456535356],
['XNSI','Sittard',8400564,5.8586111068726,51.001667022705],
['USDF','Sitzendorf-Unterweißbach',8013000,11.155399,50.627313],
['XDSB','Skaerbaek st',8602156,8.771498,55.158767],
['XTSKA','Skalice u Ceske Lipy',5402813,14.522289,50.741788],
['XDSG','Skanderborg st',8602175,9.9246973,56.0435631],
['XDSGE','Slagelse st',8602254,11.348057,55.407553],
['XRSL','Slavonski Brod',7800015,18.0114088,45.1634037],
['ONSL','Sliedrecht',8400565,4.7783331871033,51.829723358154],
['PNABR','Sliedrecht Baanhoek',8400101,4.8111109733581,51.829722],
['XPSLB','Slubice',5193610,14.594658,52.335815],
['XTSLN','Sluknov',5403047,14.461721,51.006413],
['XTSLZ','Sluknov zast.',5403049,14.435561,51.006773],
['XNSK','Sneek',8400566,5.6523969,53.0328688],
['ONSKN','Sneek Noord',8400574,5.6631808,53.0409319],
['ESOT','Soest',8000076,8.104589,51.578419],
['ONSOZ','Soest Zuid',8400571,5.3030557632446,52.165279388428],
['ONSO','Soest(NL)',8400567,5.3099999427795,52.173332214355],
['ONSOK','Soestdijk',8400569,5.3000001907349,52.183612823486],
['DSOL','Sohl',8013002,12.282808,50.275131],
['DSOH','Sohland',8013003,14.431926,51.053738],
['XTSO','Sokolov',5400199,12.644152,50.186161],
['KSGR','Solingen Grünewald',8005597,7.079004,51.163899],
['KSO','Solingen Hbf',8000087,7.004187,51.160766],
['KSM','Solingen Mitte',8005598,7.088716,51.16574],
['KSV','Solingen Vogelpark',8006714,6.992398,51.166711],
['KSS','Solingen-Schaberg',8005590,7.128182,51.163206],
['USOL','Sollstedt',8013004,10.529848,51.413673],
['FSOL','Solms',8005592,8.406693,50.545585],
['MSO','Solnhofen',8005593,10.993983,48.891987],
['XSSO','Solothurn',8500207,7.5426842030434,47.204180775131],
['LSK','Solpke',8013005,11.294178,52.500416],
['ASON','Soltau Nord',8005594,9.861013,53.001364],
['HSO','Soltau(Han)',8000088,9.831109,52.983017],
['HSDK','Soltendieck',8000445,10.761416,52.874209],
['XFSO','Somain',8700125,3.276963,50.35541],
['ESON','Sondern',8005600,7.842578,51.073085],
['TSOD','Sondernach',8005601,9.618849,48.36696],
['RSOH','Sondernheim',8005602,8.360272,49.194981],
['USH','Sondershausen',8010329,10.849193,51.370054],
['USO','Sonneberg(Thür)Hbf',8013008,11.168848,50.355078],
['USON','Sonneberg(Thür)Nord',8013009,11.20755,50.365478],
['USOO','Sonneberg(Thür)Ost',8013010,11.201293,50.352252],
['USOW','Sonneberg(Thür)West',8013011,11.159071,50.368031],
['MSHM','Sontheim(Schwab)',8005607,10.345372,48.012172],
['TSON','Sontheim-Brenz',8005608,10.284863,48.559324],
['MSF','Sonthofen',8005609,10.272344,47.513241],
['FSON','Sontra',8005610,9.930934,51.072153],
['LSPH','Sophienhof',8017040,10.790197,51.641234],
['XPSO','Sopot',5100056,18.562323,54.440165],
['XMS','Sopron',5501494,16.58673,47.677904],
['LSOR','Sorge',8017024,10.697094,51.693291],
['XDSOR','Soroe st',8602350,11.568794,55.419019],
['XPSI','Sosnowiec Glowny',5100133,19.126411,50.278902],
['AS','Sottrum',8005613,9.25003,53.101242],
['MSY','Soyen',8005614,12.209744,48.108085],
['XBSP','Spa',8800168,5.855501,50.49008],
['XBGN','Spa-Géronstère',8800592,5.866621,50.489317],
['TSP','Spaichingen',8005616,8.740147,48.068987],
['TSPM','Spaichingen Mitte',8005617,8.730425,48.078502],
['XDSP','Spangsbjerg st',8600509,8.460747,55.492348],
['ASPS','Sparrieshoop',8007066,9.685207,53.781294],
['ONSP','Spaubeek',8400572,5.850529,50.94327],
['KSPA','Spay',8005622,7.645473,50.255544],
['DSPR','Spechtritz',8013015,13.638817,50.952635],
['FSPE','Speele',8005623,9.563559,51.377458],
['SSPE','Speicher',8005624,6.615911,49.929184],
['NSKN','Speikern',8005625,11.336992,49.528639],
['RSP','Speyer Hbf',8005628,8.427949,49.324119],
['RSPN','Speyer Nord-West',8005626,8.419263,49.333592],
['XTSP','Spicak',5400218,13.22244,49.16192],
['KSPI','Spich',8005629,7.114916,50.826727],
['NSPU','Spiegelau',8005630,13.35926,48.917723],
['RSPG','Spielberg',8079048,8.474626,48.897652],
['XASS','Spielfeld-Straß',8100082,15.629004491839,46.7095434570178],
['XSSP','Spiez',8507483,7.68009797421132,46.6863921576928],
['RETS','Spinnerei, Ettlingen',720788,8.441656,48.934745],
['XASPP','Spital am Pyhrn',8100306,14.347602999977,47.6731191471016],
['XASP','Spittal-Millstättersee',8100092,13.4875342178876,46.7957548587706],
['WSP','Sponholz',8013017,13.366401,53.563854],
['WSPO','Spornitz',8013018,11.710976,53.412351],
['BSP','Spremberg',8010330,14.397498,51.574757],
['FSPR','Sprendlingen(Rheinhess)',8005637,7.981795,49.858947],
['HSPR','Springe',8005638,9.556238,52.21515],
['ASP','Sprötze',8005640,9.812245,53.309429],
['PQSSH','Spöck Hochhaus, Stutensee',721296,8.50091,49.111495],
['PQSSR','Spöck Richard-Hecht-Schule, Stutensee',721295,8.504845,49.112662],
['XTSCL','Srni u Ceske Lipy',5402906,14.584486,50.636992],
['MSAB','St Alban',8005639,11.105359,47.964133],
['XFSA','St Avold',8700269,6.721033,49.086052],
['XFSDD','St Dalmas de Tende',8704545,7.584314,44.055976],
['DEG','St Egidien',8010331,12.622556,50.789568],
['RSGO','St Georgen(Schwarzw)',8005644,8.341955,48.123813],
['FSGO','St Goar',8005645,7.714587,50.150155],
['FSGH','St Goarshausen',8005646,7.714246,50.156035],
['RSIG','St Ilgen-Sandhausen',8005648,8.668715,49.341268],
['SSI','St Ingbert',8005649,7.110814,49.274763],
['MKL','St Koloman',8005652,11.882965,48.243747],
['XFSMA','St Malo',8700228,-2.004055,48.646705],
['MMG','St Mang',8005653,10.325539,47.708899],
['ASD','St Michaelisdonn',8005655,9.118006,53.98962],
['MOTN','St Ottilien',8005656,11.04839,48.094544],
['SSTO','St Thomas',8005658,6.601076,50.069788],
['SSWD','St Wendel',8005659,7.165293,49.466952],
['XFSAR','St-Amour',8702469,5.334203,46.433786],
['XFSAC','St-Avre-la-Chambre',8702380,6.303064,45.352844],
['XFSGF','St-Germain-des-Fosses',8700033,3.430524,46.209244],
['XFSG','St-Gervais-les-Bains',8704576,6.70186,45.906665],
['XFJL','St-Jean-de-Luz-Ciboure',8700109,-1.661105,43.385822],
['XFJMA','St-Jean-de-Maurienne Arvan',8702383,6.354571,45.277792],
['XFJ','St-Jory(Toulouse)',8702033,1.371535,43.738699],
['OFSLU','St-Laurent-du-Var',8701995,7.194597,43.662387],
['XFSTL','St-Louis (Haut-Rhin)',8700133,7.555748,47.590592],
['OFSLE','St-Louis-la-Chaussee',8701987,7.5310413,47.609553],
['XSMC','St-Maurice(CH)',8501403,7.00204915834724,46.2163635359859],
['XFSMV','St-Michel-Valloire',8702381,6.471956,45.216859],
['XFPY','St-Pierre-dAlbigny',8700371,6.156667,45.557233],
['XFPDC','St-Pierre-des-Corps',8700006,0.723888,47.385542],
['XFSP','St-Priest',8702568,4.934757,45.686664],
['XFSQ','St-Quentin(Aisne)',8700176,3.297547,49.8398],
['XFSR','St-Raphael-Valescure',8700143,6.770123,43.422771],
['XFSSL','St-Sulpice-Lauriere',8701433,1.476189,46.046712],
['XAAB','St. Anton am Arlberg',8100064,10.26699,47.127564],
['XAAM','St. Anton im Montafon',8100497,9.866123,47.109944],
['XSSG','St. Gallen(CH)',8506302,9.36987712043016,47.4231790667776],
['XSSGH','St. Gallen(CH) Haggen',8506392,9.3381367947724,47.4078348304681],
['XSSGW','St. Gallen(CH) Winkeln',8506300,9.30083970710748,47.4039256735496],
['XASJ','St. Johann im Pongau',8100043,13.194961,47.348379],
['XAJT','St. Johann in Tirol',8100054,12.430775,47.519618],
['XSSM','St. Margrethen SG',8506314,9.63825154067703,47.4532118156642],
['XSMZ','St. Moritz',8509253,9.84639099718665,46.4979672615096],
['XASV','St. Valentin',8100009,14.521846,48.179145],
['OASED','St.Egyden am Steinfeld',8101489,16.146757,47.761046],
['XASGM','St.Georgen/Mattig',8101506,13.098901,48.216313],
['XAJO','St.Jodok am Brenner',8101529,11.499331,47.063305],
['XASE','St.Michael in Obersteiermark',8100071,15.009187,47.346621],
['XASPS','St.Peter-Seitenstetten',8101597,14.646178,48.05474],
['XAP','St.Pölten Hbf',8100008,15.624672,48.208303],
['XAVG','St.Veit/Glan',8100078,14.367186,46.770586],
['XSSTA','Staad',8506312,9.53652077144969,47.4807713471107],
['AST','Stade',8000089,9.477008,53.596143],
['XASRM','Stadt Rottenmann',8100309,14.367174,47.527231],
['DWH','Stadt Wehlen(Sachs)',8013022,14.032242,50.953718],
['FSTA','Stadtallendorf',8005661,9.015278,50.825432],
['HSHG','Stadthagen',8005662,9.189426,52.332837],
['USTM','Stadtilm',8013023,11.070817,50.766956],
['HSDF','Stadtoldendorf',8005665,9.620519,51.881002],
['NSPO','Stadtprozelten',8005666,9.410979,49.783595],
['USR','Stadtroda',8013025,11.722792,50.868216],
['FST','Staffel',8005668,8.04595,50.39953],
['XFSTA','Staffelfelden',8701956,7.265102,47.827976],
['RST','Stahringen',8077773,8.976275,47.787663],
['XASI','Stainach-Irdning',8100132,14.1073407406561,47.5292536686409],
['SSTB','Stambach',8005673,7.456623,49.239171],
['NSM','Stammbach',8005674,11.704894,50.154633],
['XASTM','Stams',8100589,10.980052760507,47.2819430829849],
['XASTS','Stans bei Schwaz',8100310,11.722982,47.366056],
['LSBU','Stapelburg',8013432,10.671721,51.900281],
['OPSH','Stara Kamienica',5103390,15.56653,50.913913],
['XTSR','Stara Role',5400241,12.835762,50.245795],
['RKSS','Starckstraße, Karlsruhe',721445,8.352862,49.016654],
['XTSKR','Stare Krecany',5402921,14.491942,50.947794],
['XTSSY','Stare Splavy',5402925,14.629315,50.587398],
['MST','Starnberg',8005676,11.34367,47.995963],
['MSNO','Starnberg Nord',8005675,11.347386,48.005975],
['XTSTS','Stary Sachov',5402929,14.374579,50.720708],
['XBSA','Statte',8800169,5.22,50.528132],
['DSTU','Stauchitz',8013029,13.21192,51.242914],
['SSTH','Staudernheim',8005678,7.693103,49.780582],
['RSTF','Staufen',8007332,7.728343,47.885027],
['RSTS','Staufen Süd',8007333,7.729681,47.877635],
['ONSVR','Stavoren',8400575,5.3600212,52.8865535],
['LSF','Staßfurt',8010332,11.587898,51.851258],
['XSSB','Steckborn',8506136,8.9810085806098,47.6645058687009],
['XSSBS','Steckborn URh',8506157,8.98143540966547,47.6686469246848],
['HSTF','Stederdorf(Kr Uelzen)',8005682,10.592702,52.907428],
['ONSTD','Stedum',8400576,6.6875551,53.3262092],
['XNSW','Steenwijk',8400578,6.1145557632446,52.791510992432],
['NSWH','Stegenwaldhaus',8005686,11.796809,50.31626],
['WHDS','Steilküste/Wittenbeck',8011847,11.793771,54.144768],
['MSTN','Stein(Traun)',8005687,12.546124,47.985354],
['XSSK','Stein-Säckingen',8500320,7.9488227239598,47.5415967349363],
['DSTI','Steina',8013033,13.022657,51.103359],
['XAST','Steinach in Tirol',8100107,11.4698480335679,47.0892785187682],
['RSNA','Steinach(Baden)',8005688,8.056469,48.298992],
['PSCTE','Steinach(Bodensee)',8516271,9.442027,47.500907],
['USTN','Steinach(Thür)',8013034,11.158644,50.432724],
['USTA','Steinach(Thür)Süd',8013036,11.166781,50.423051],
['NSTN','Steinach(b Rothenburg ob der Tauber)',8000091,10.273535,49.453218],
['SSTA','Steinalben',8005689,7.651484,49.316247],
['FSA','Steinau(Straße)',8005690,9.443162,50.314349],
['NSD','Steinbach am Wald',8005692,11.382922,50.441648],
['USTH','Steinbach-Hallenberg',8013037,10.558086,50.693163],
['XFSNG','Steinbourg',8702047,7.416245,48.763649],
['XASF','Steindorf bei Straßwalchen',8100020,13.239024,47.966725],
['MSA','Steinebach',8005699,11.206812,48.061184],
['XSSU','Steinebrunn(CH)',8506397,9.34983964908795,47.5315345098341],
['FSFZ','Steinefrenz',8005700,7.938888,50.44842],
['RSTN','Steinen',8005701,7.741561,47.641604],
['LSR','Steinerne Renne',8017025,10.727011,51.8167],
['HSFD','Steinfeld(Oldb)',8005703,8.198151,52.592797],
['RSFL','Steinfeld(Pfalz)',8007858,8.039369,49.044675],
['LSFD','Steinfeld(Stendal)',8013039,11.728617,52.614734],
['EBGO','Steinfurt-Borghorst',8001096,7.397539,52.118737],
['EBFT','Steinfurt-Burgsteinfurt',8000062,7.32934,52.147384],
['EGRK','Steinfurt-Grottenkamp',8005712,7.375921,52.123249],
['ESTG','Steinhagen(Westf)',8005704,8.420787,52.017419],
['ESBS','Steinhagen(Westf) Bielef. Str.',8005702,8.436453,52.011416],
['WSNB','Steinhausen-Neuburg',8013040,11.596334,53.942319],
['FSHM','Steinheim(Main)',8005706,8.906852,50.121369],
['HSTM','Steinheim(Westf)',8005708,9.088447,51.868177],
['MSHG','Steinhöring',8005709,12.031284,48.083487],
['DSPH','Steinpleis',8010333,12.394074,50.708976],
['RSS','Steinsfurt',8005714,8.907978,49.235822],
['RSTE','Steinweiler',8005713,8.130696,49.120844],
['SSTW','Steinwenden',8005715,7.524785,49.454175],
['ASTE','Stelle',8005717,10.109023,53.387699],
['HSTE','Stelle DHE',8070547,8.680962,53.008107],
['LS','Stendal Hbf',8010334,11.854412,52.594723],
['LSFH','Stendal Hochschule',8013045,11.848367,52.616237],
['LSV','Stendal Vorbf',8013046,11.87129,52.595836],
['LSS','Stendal-Stadtsee',8010335,11.836728,52.606837],
['DSTN','Stenn',8013047,12.441635,50.678758],
['XFSF','Stephansfeld',8702021,7.704482,48.717776],
['FSTZ','Sterbfritz',8005720,9.625417,50.312868],
['WSE','Sternfeld',8013051,13.15042,53.824775],
['LSTH','Sternhaus-Haferfeld',8017026,11.132586,51.698595],
['LSTE','Sternhaus-Ramberg',8017027,11.127498,51.690311],
['FSZH','Sterzhausen',8005722,8.708698,50.861554],
['XSSE','Stettbach',8503147,8.59613281647753,47.3972121247927],
['TSTT','Stetten (b. Haigerloch)',8070548,8.812741,48.353415],
['TSHG','Stetten am Heuchelberg',8005724,9.014726,49.136913],
['TSTD','Stetten(Donau)',8005723,8.872354,48.022814],
['MSTS','Stetten(Schwab)',8005725,10.43604,48.027663],
['TSTE','Stetten-Beinstein',8005726,9.35245,48.811924],
['RSF','Stettfeld(Baden)',8007134,8.64374,49.178906],
['RSFW','Stettfeld-Weiher',8005933,8.6369276,49.1836249],
['XASY','Steyr',8100010,14.423419,48.038466],
['LSTI','Stiege',8017028,10.881191,51.660798],
['ESKA','Stift Keppel-Allenbach',8005731,8.09223,50.977961],
['OASLD','Stillfried',8101536,16.84654,48.411577],
['RSTK','Stockach',8077774,9.005731,47.85009],
['NSOK','Stockau',8005734,11.666718,49.919576],
['MSD','Stockdorf',8005735,11.400845,48.093258],
['XASRA','Stockerau',8100534,16.213405,48.382252],
['FSTH','Stockhausen(Lahn)',8005736,8.325365,50.540536],
['NSTH','Stockheim(Oberfr)',8005737,11.282133,50.306822],
['NSTU','Stockheim(Unterfr)',8005738,10.271229,50.459952],
['XVS','Stockholm Central',7400002,18.05566,59.33221],
['FSTK','Stockstadt(Main)',8005739,9.063369,49.976627],
['FSTR','Stockstadt(Rhein)',8005740,8.47244,49.809433],
['USTO','Stolberg(Harz)',8013056,10.956538,51.567398],
['KST','Stolberg(Rheinl)Hbf',8000348,6.217478,50.79448],
['KST B','Stolberg(Rheinl)Hbf Gl.27',8098348,6.219009,50.794526],
['KST E','Stolberg(Rheinl)Hbf Gl.44',8098349,6.218439,50.7948],
['KSTT','Stolberg-Altstadt',8005741,6.230538,50.764259],
['KSTM','Stolberg-Mühlener Bahnhof',8005745,6.223898,50.773589],
['KSTR','Stolberg-Rathaus',8005743,6.229845,50.768554],
['KSTS','Stolberg-Schneidmühle',8005744,6.219012,50.784904],
['DSTOS','Stollberg Schlachthofstraße',8017415,12.778782,50.714229],
['DSTO','Stollberg(Sachs)',8010337,12.773549,50.70931],
['DSTL','Stolpen',8013057,14.08725,51.037051],
['KSOM','Stommeln',8005746,6.752466,51.018092],
['BSTW','Storkow(Mark)',8013058,13.9209,52.251632],
['TSGZ','Storzingen',8005747,9.127085,48.134881],
['USHM','Stotternheim',8013061,11.048324,51.052351],
['WSR','Stralsund Hbf',8010338,13.077321,54.308626],
['WSRR','Stralsund Rügendamm',8013062,13.107522,54.305322],
['WSRB','Stralsund-Grünhufe',8011778,13.04393,54.304298],
['XFSTG','Strasbourg',8700023,7.734584,48.584967],
['WSB','Strasburg(Uckerm)',8010339,13.745272,53.515101],
['XASTH','Strasshof',8101595,16.633955,48.318497],
['NST','Straubing',8000095,12.574094,48.876978],
['NSTT','Straubing-Ost',8006745,12.592248,48.876407],
['BST','Strausberg',8010341,13.833611,52.532204],
['BSTV','Strausberg (S)',8089187,13.8336233,52.532164],
['BSTN','Strausberg Nord',8013064,13.908476,52.590146],
['BSTR','Strausberg Stadt',8081420,13.888133,52.57698],
['BHGM','Strausberg-Hegermühle',8080680,13.866607,52.548375],
['USF','Straußfurt',8010342,10.987507,51.163144],
['MSMS','Straß-Moos',8005749,11.050315,48.711321],
['LSTR','Straßberg(Harz)',8017029,11.043781,51.620209],
['LSGL','Straßberg-Glasebach',8084109,11.049358,51.618215],
['TSTR','Straßberg-Winterlingen',8005750,9.087718,48.178747],
['DSTR','Straßgräbchen-Bernsdorf',8010340,14.052047,51.361469],
['NSK','Straßkirchen',8005752,12.720746,48.833615],
['XASR','Straßwalchen',8100019,13.2637351289072,47.9723921876988],
['XASRW','Straßwalchen West',8102062,13.245381,47.97667],
['XISTA','Stresa',8300068,8.531633,45.884528],
['XRSV','Strizivojna-Vrpolje',7800047,18.413851,45.227208],
['WSTK','Strohkirchen',8013069,11.318463,53.398386],
['NSU','Strullendorf',8005760,10.96167,49.84555],
['ESTU','Struthütten',8005761,7.973309,50.78144],
['XTSTR','Struznice',5402962,14.449854,50.698271],
['HSUB','Stubben',8005763,8.780519,53.405793],
['WSBB','Stubbenfelde',8087027,14.033515,54.028074],
['TSBH','Stubersheim',8007071,9.920377,48.593792],
['OASU','Studenzen-Fladnitz',8100196,15.774747,46.99903],
['LSTF','Stumsdorf',8010343,12.066859,51.616234],
['XYST','Sturovo',5603745,18.67992,47.800124],
['TSEB','Stuttgart Ebitzweg',8005766,9.231701,48.803938],
['TSFS','Stuttgart Feuersee',8006699,9.166273,48.772768],
['TFL','Stuttgart Flughafen/Messe',8005768,9.19263,48.690648],
['TS','Stuttgart Hbf',8000096,9.181635,48.784084],
['TS  T','Stuttgart Hbf (tief)',8098096,9.179808,48.782999],
['TSNS','Stuttgart Neckarpark',8006743,9.241595,48.792173],
['TSN','Stuttgart Nord',8005767,9.188026,48.803769],
['TSNU','Stuttgart Nürnberger Str.',8004357,9.234858,48.806423],
['TSS','Stuttgart Schwabstr.',8006698,9.156959,48.770255],
['TSMI','Stuttgart Stadtmitte',8006700,9.172925,48.776229],
['TSUN','Stuttgart Universität',8006513,9.105398,48.745837],
['TSC','Stuttgart-Bad Cannstatt',8005769,9.217531,48.801377],
['TSFE','Stuttgart-Feuerbach',8005770,9.169382,48.813673],
['TSM','Stuttgart-Münster',8005771,9.21586,48.820724],
['TSOM','Stuttgart-Obertürkheim',8005772,9.267889,48.762013],
['TSRO','Stuttgart-Rohr',8005773,9.108328,48.717902],
['TSSM','Stuttgart-Sommerrain',8005774,9.248327,48.81527],
['TSU','Stuttgart-Untertürkheim',8005775,9.250569,48.779751],
['TSV','Stuttgart-Vaihingen',8005776,9.113226,48.726279],
['TSZAH','Stuttgart-Zazenhausen',8005777,9.199539,48.836034],
['TSZ','Stuttgart-Zuffenhausen',8005778,9.166739,48.829415],
['TSOS','Stuttgart-Österfeld',8005779,9.116774,48.737651],
['RSTU','Stühlingen',8005764,8.451368,47.74703],
['UST','Stützerbach',8013071,10.857915,50.639479],
['WSBN','Subzin-Liessow',8013072,12.347623,53.891919],
['ASU','Suchsdorf',8005781,10.091264,54.349605],
['HSUD','Suderburg',8005780,10.43279,52.904892],
['ASUP','Suerhop',8005788,9.855154,53.315903],
['USL','Suhl',8010345,10.682826,50.605145],
['USLH','Suhl-Heinrichs',8013077,10.638454,50.602098],
['WSU','Sukow(b Schwerin)',8013079,11.559558,53.554785],
['TSUM','Sulmingen',8079100,9.863192,48.151937],
['TSUL','Sulz(Neckar)',8005791,8.636748,48.366485],
['OASR','Sulz-Röthis',8101585,9.634743,47.293869],
['MSBH','Sulzbach(Inn)',8005793,13.382017,48.454689],
['NSUZ','Sulzbach(Main)',8005794,9.146531,49.917973],
['TSBM','Sulzbach(Murr)',8005795,9.500409,48.999461],
['SSZ','Sulzbach(Saar)',8005796,7.055062,49.299561],
['SSZA','Sulzbach(Saar)Altenwald',8005797,7.078876,49.312078],
['FSZ','Sulzbach(Taunus)',8005798,8.527989,50.129833],
['FSZN','Sulzbach(Taunus)Nord',8005799,8.518195,50.139399],
['NSR','Sulzbach-Rosenberg',8005800,11.739277,49.499478],
['NSRH','Sulzbach-Rosenberg Hütte',8005801,11.775299,49.489036],
['SUSZ','Sulzbachtal',8006019,7.663654,49.522537],
['MSUG','Sulzberg',8005802,10.363935,47.675214],
['RSFD','Sulzfeld(Baden)',8005805,8.852544,49.108173],
['XASUM','Summerau',8100316,14.4488964537534,48.5572016498612],
['XSSUS','Sursee',8502007,8.09787795205423,47.1707889132201],
['XFSVF','Survilliers Fosses',8704683,2.525615,49.099146],
['XNSU','Susteren',8400582,5.8630557060242,51.061389923096],
['XTSV','Svatava',5400131,12.624193,50.1906],
['XTSVZ','Svatava zastavka',5402998,12.607995,50.197296],
['OTSHL','Svihov u Klatov',5403084,13.29074,49.47394],
['XTSVO','Svor',5400285,14.592498,50.790515],
['ONSW','Swalmen',8400583,6.03228,51.23582],
['XPSWB','Swiebodzin',5103284,15.53954,52.245144],
['XPSM','Swinoujscie Centrum',5189954,14.235997,53.912997],
['KODE','Swisttal-Odendorf',8004616,6.879764,50.651162],
['HSYK','Syke',8005809,8.809786,52.91616],
['DSY','Syrau',8013080,12.085313,50.544769],
['ESYH','Sythen',8005811,7.226526,51.77176],
['XPSG','Szczecin Glowny',5100057,14.550318,53.418785],
['XPSU','Szczecin Gumience',5100145,14.494864,53.397748],
['XMSG','Szentgotthárd',5500029,16.26424,46.95741],
['XMSB','Szob',5500006,18.862057,47.820998],
['XMSN','Szolnok',5500053,20.175698,47.179558],
['OMSO','Szombathely',5500028,16.63275,47.237532],
['OMSBS','Szombathely-Szölös',5501280,16.641757,47.206519],
['USAE','Sättelstädt',8012826,10.480338,50.945914],
['XFSL','Sélestat',8700179,7.443039,48.260295],
['XVSD','Södertälje Syd station',7400700,17.6457665,59.1625554],
['RSLA','Söllingen Kapellenstraße',8070865,8.549618,48.983956],
['RSLR','Söllingen Reetzstr.',8007866,8.540793,48.991053],
['RSL','Söllingen(b Karlsr)',8005585,8.543543,48.987754],
['USD','Sömmerda',8010328,11.127532,51.165186],
['ASOE','Sörup',8005586,9.669912,54.716662],
['ASUE','Süderbrarup',8005782,9.770907,54.637409],
['ASDD','Süderdeich',8005783,8.911247,54.198185],
['ANBS','Süderlügum',8005789,8.889327,54.870997],
['WSLT','Sülstorf',8013073,11.388039,53.513998],
['TSUE','Sülzbach',8005786,9.340458,49.14855],
['TSUS','Sülzbach Schule',8005792,9.351457,49.145063],
['USUE','Sülzenbrücken',8013074,10.895873,50.887391],
['NSUE','Sünching',8005787,12.356769,48.884159],
['TSD','Süßen',8005790,9.76028,48.683641],
['XFHP','TGV Haute Picardie',8704957,2.802566,49.623045],
['STB','Taben',8005812,6.600316,49.552747],
['XTT','Tabor',5400031,14.677554,49.414083],
['MTCH','Tacherting',8005813,12.567336,48.078747],
['OATSM','Takern-St.Margarethen',8100318,15.757767,47.045657],
['OATAL','Tallesbrunn',8101644,16.786987,48.364024],
['XBTA','Tamines',8800135,4.609938,50.432594],
['TTM','Tamm(Württ)',8005820,9.125828,48.921605],
['LTH','Tangerhütte',8013083,11.809943,52.433869],
['LTM','Tangermünde',8013084,11.969957,52.545741],
['LTMW','Tangermünde West',8013085,11.960454,52.547736],
['DTA','Tanndorf',8013087,12.848393,51.161466],
['ATAK','Tanneneck',8007051,9.943297,53.755327],
['TTA','Tannheim(Württ)',8005823,10.09692,47.994955],
['UTA','Tannroda',8013089,11.247149,50.862446],
['WTA','Tantow',8013090,14.347926,53.269275],
['MTPF','Tapfheim',8005824,10.694078,48.679208],
['XFTA','Tarascon sur Rhone',8700058,4.656929,43.801168],
['XPTA','Tarnow',5100230,20.97418,50.005401],
['ATP','Tarp',8005825,9.398599,54.664815],
['XITB','Tarvisio Boscoverde',8303915,13.607212,46.506356],
['OATAS','Tassenbach',8101646,12.466088,46.74691],
['XMTA','Tata',5500010,18.328202,47.663625],
['XMTB','Tatabanya',5500009,18.393612,47.584932],
['ATAT','Tating',8005826,8.709512,54.322847],
['DTB','Taubenheim(Spree)',8013092,14.480637,51.0422],
['TTB','Tauberbischofsheim',8005827,9.658294,49.623632],
['MTA','Tauberfeld',8005828,11.275691,48.819238],
['LTC','Taucha(Leipzig)',8013093,12.485724,51.379459],
['MTU','Taufkirchen',8005831,11.609252,48.051552],
['XATF','Taufkirchen an der Pram',8100320,13.522575,48.406857],
['LTNH','Tautenhain',8013095,12.67953,51.089839],
['XST','Taverne-Torricella',8505218,8.93032466625042,46.0566859523733],
['XATR','Taxenbach-Rauris',8100046,12.9478990030565,47.2928125215196],
['XPTC','Tczew',5100061,18.790155,54.097321],
['XSTE','Tecknau',8500028,7.88760523023861,47.4457572593675],
['ONTE','Tegelen',8400591,6.14253,51.33894],
['MTE','Tegernsee',8007632,11.757394,47.713689],
['LTE','Teicha',8013097,11.95918,51.554455],
['BT','Teichland',8012445,14.423813,51.818613],
['DTW','Teichwolframsdorf',8013098,12.266353,50.731606],
['MTO','Teisendorf',8005833,12.834452,47.849397],
['NTEN','Teisnach',8070666,12.994268,49.039375],
['NTRS','Teisnach Rohde+Schwarz',8005839,12.99215,49.03193],
['XATP','Telfs-Pfaffenhofen',8100060,11.0786677764694,47.3006527406517],
['ETEL','Telgte',8005834,7.780876,51.981193],
['BTL','Teltow',8013100,13.300441,52.388282],
['BTLS','Teltow Stadt',8080450,13.276623,52.396906],
['STS','Temmels',8005835,6.462523,49.688479],
['XFTE','Templeuve',8702110,3.176492,50.528252],
['WT','Templin',8010347,13.491481,53.112345],
['WTV','Templin Stadt',8010117,13.509241,53.117131],
['WTAD','Templin-Ahrensdorf',8013102,13.575789,53.112287],
['XFTND','Tende(F)',8704703,7.594029,44.090002],
['OSTE','Tenero',8505401,8.850995,46.177434],
['RTMU','Teningen-Mundingen',8005836,7.824408,48.128777],
['XATN','Tenneck',8101660,13.178956,47.494355],
['XTTV','Teplice v Cechach',5400101,13.829173,50.646472],
['ONTBG','Terborg',8400592,6.3642466,51.9224549],
['XATW','Terfens-Weer',8100323,11.6343135704153,47.3158846829949],
['XFTG','Tergnier',8700077,3.296927,49.659296],
['OATER','Ternitz',8101661,16.033421,47.71378],
['WTHN','Teschenhagen',8013104,13.374233,54.389367],
['WTOW','Teschow',8013105,11.637959,53.994354],
['WTI','Tessin',8013106,12.462614,54.032017],
['WTIW','Tessin West',8079604,12.44257,54.034436],
['XBTE','Testelt',8800244,4.946862,51.009783],
['WTE','Teterow',8010348,12.577966,53.768437],
['XFTT','Teting (Moselle)',8700556,6.663732,49.051712],
['UTEU','Teuchern',8010349,12.016542,51.133858],
['DTF','Teufelsmühle',8013537,14.751792,50.853298],
['LTT','Teutschenthal',8013110,11.782738,51.464358],
['LTTO','Teutschenthal Ost',8013111,11.819821,51.465749],
['OATHL','Thal',8100324,12.670772,46.784224],
['LTL','Thale Hbf',8013112,11.031048,51.746047],
['LTLM','Thale Musestieg',8013125,11.04688,51.751434],
['STWF','Thaleischweiler-Fröschen',8005843,7.578141,49.261374],
['TTL','Thalfingen(b Ulm)',8005845,10.047853,48.432982],
['DTAL','Thalheim(Erzgeb)',8013113,12.849345,50.696598],
['DTAM','Thalheim(Erzgeb) Mitte',8013117,12.854233,50.701291],
['DTL','Thalheim(b Oschatz)',8070690,13.089738,51.281057],
['XSTW','Thalwil',8503202,8.56475556229341,47.2959747212651],
['MTMA','Thann-Matzbach',8005852,12.04746,48.26651],
['NTAS','Thansüß',8005855,11.937845,49.622265],
['DTH','Tharandt',8013114,13.592111,50.982872],
['RTG','Thayngen',8005856,8.7043,47.745502],
['STN','Theisbergstegen',8005857,7.448373,49.518978],
['LT','Theißen',8013115,12.106626,51.090429],
['UTH','Themar',8010350,10.617521,50.506715],
['DWIE','Thermalbad Wiesenbad',8013116,13.044958,50.619145],
['ATHS','Thesdorf',8005858,9.813837,53.644372],
['XBTX','Theux',8800590,5.815194,50.536187],
['TTI','Thiergarten(Hohenz)',8007867,9.095629,48.085413],
['XFTHV','Thionville',8700059,6.15176,49.333258],
['DTFL','Thoßfell',8013120,12.2556397,50.54097583],
['XSTH','Thun',8507100,7.62959464394696,46.7548532939413],
['XSTU','Thusis',8509189,9.44050194243702,46.6981990893868],
['BTHR','Thyrow',8013123,13.259634,52.247228],
['NTHM','Thüngersheim',8005864,9.840298,49.877985],
['KTH','Thür',8005865,7.27708,50.358808],
['ATB','Tiebensee',8005867,9.019229,54.219487],
['DTFN','Tiefenau',8013124,13.413904,51.390689],
['LTF','Tiefenbachmühle',8017030,10.813515,51.636087],
['UTI','Tiefenort',8013127,10.162617,50.829487],
['XFTB','Tieffenbach-Struth',8700529,7.255394,48.90636],
['ONTL','Tiel',8400596,5.4222221374512,51.889446258545],
['PNAAU','Tiel Passewaaij',8400036,4.7208333015442,51.873889923096],
['XBTI','Tienen',8800085,4.925612,50.807759],
['RTI','Tiengen(Hochrhein)',8005871,8.272003,47.635471],
['XNT','Tilburg',8400597,5.0836110115051,51.560554504395],
['PNAAF','Tilburg Reeshof',8400021,4.7044444084167,51.573612213135],
['ONTW','Tilburg Universiteit',8400594,5.0511112213135,51.564998626709],
['OATIM','Timelkam',8101670,13.595978,48.007943],
['ATIM','Timmendorfer Strand',8005874,10.76227,53.994212],
['XDTI','Tinglev st',8602553,9.258234,54.936171],
['XATI','Tisis',8101685,9.57564573367006,47.2273702391884],
['RTIT','Titisee',8005876,8.155069,47.903402],
['MWSL','Tittmoning-Wiesmühl',8006422,12.744898,48.023909],
['RKTI','Tivoli, Karlsruhe',721450,8.410369,48.99665],
['XDTB','Tjaereborg st',8602563,8.579143,55.466661],
['XSTOA','Tobel-Affeltrangen',8506183,9.03368895274131,47.5212973846941],
['XDTON','Toender Nord st',8602955,8.86116,54.938984],
['XDTO','Toender st',8602589,8.8604,54.933399],
['XBTG','Tongeren',8800086,5.473756,50.784001],
['LTG','Torgau',8010351,12.991134,51.563036],
['WTO','Torgelow',8013131,14.008758,53.63462],
['XITUP','Torino Porta Susa',8300522,7.665169,45.071833],
['ATM','Tornesch',8005887,9.71497,53.697313],
['XITOR','Tortona',8300029,8.862079,44.900202],
['ATST','Tostedt',8005888,9.732013,53.272046],
['XFTU','Toul',8700263,5.880933,48.678998],
['XFTO','Toulon',8700108,5.9296,43.128411],
['XFTM','Toulouse-Matabiau',8700065,1.453939,43.611406],
['XFTC','Tourcoing',8700121,3.168172,50.716575],
['XBTO','Tournai',8800170,3.396825,50.612981],
['XFTOU','Tournan',8704734,2.758793,48.739523],
['STT','Traben-Trarbach',8005889,7.120722,49.951565],
['NTB','Trabitz',8005890,11.894621,49.801467],
['FTH','Trais-Horloff',8005891,8.910969,50.45059],
['RT','Trasadingen',8005892,8.436804,47.665238],
['WTH','Trassenheide',8013132,13.868517,54.081378],
['WTM','Trassenmoor',8013133,13.86781,54.091046],
['UTN','Traun',8013135,11.81941999,50.73412045],
['XATRN','Traun OÖ',8101690,14.253715,48.225481],
['MTRD','Traundorf',8005893,12.639879,47.838373],
['MTRT','Traunreut',8005894,12.589768,47.965068],
['MTS','Traunstein',8000116,12.638801,47.869727],
['MTSK','Traunstein Klinikum',8005873,12.633442,47.874557],
['XZT','Trbovlje',7900037,15.0372149,46.1264786],
['BTN','Trebbin',8013137,13.230382,52.217618],
['LTRL','Treben-Lehma',8013138,12.440947,51.046935],
['NTG','Trebgast',8005895,11.552112,50.065979],
['LTB','Trebitz(Elbe)',8013139,12.758954,51.753803],
['BTZ','Trebnitz(Mark)',8013141,14.216504,52.538262],
['XTTRB','Trebusice',5403197,13.577912,50.522719],
['FTRE','Trechtingshausen',8005896,7.852359,50.009042],
['XATA','Treibach-Althofen',8100096,14.4655944484276,46.8685828104467],
['STK','Treis-Karden',8003179,7.299635,50.179836],
['XITR','Trento',8300101,11.1189,46.072287],
['MTL','Treuchtlingen',8000122,10.908159,48.961267],
['DTRE','Treuen',8013144,12.301859,50.547935],
['BTZN','Treuenbrietzen',8013145,12.857911,52.091919],
['BTZS','Treuenbrietzen Süd',8013146,12.880916,52.080609],
['XITS','Treviso Centrale',8300130,12.245137,45.6597],
['FTS','Treysa',8000129,9.185673,50.910661],
['HTRI','Triangel',8005901,10.57824,52.509506],
['RTR','Triberg',8005902,8.236806,48.140004],
['XAT','Trieben',8100128,14.4899566339361,47.4889508226702],
['UTB','Triebes',8013150,12.023306,50.688044],
['NTRI','Triefenried',8005903,13.052686,48.969669],
['STR','Trier Hbf',8000134,6.652453,49.756846],
['STRS','Trier Süd',8005905,6.636883,49.744663],
['NTF','Triesdorf',8005907,10.679144,49.200919],
['UTR','Triptis',8010352,11.872173,50.740882],
['TTRA','Trochtelfingen ALB-GOLD',8007147,9.245916,48.328851],
['TTRF','Trochtelfingen(Hohenz)',8070557,9.246268,48.307542],
['TTO','Trochtelfingen(b Bopfingen)',8005908,10.401823,48.838365],
['XBTP','Trois-Ponts',8800088,5.87303,50.36905],
['KT','Troisdorf',8000135,7.150892,50.813922],
['XLTV','Troisvierges',8200136,5.990446,50.11936],
['KTR','Trompet',8005910,6.669107,51.413489],
['XBT','Trooz',8800265,5.688715,50.573195],
['TTR','Trossingen Bahnhof',8005911,8.585154,48.087664],
['TTRS','Trossingen Stadt',8007646,8.631547,48.074037],
['MTSB','Trostberg',8005912,12.555646,48.024737],
['OPTRZ','Trzcinsko',5103839,15.867894,50.884716],
['XATS','Tschagguns',8100118,9.904905,47.079154],
['RKTU','Tullastraße/Alter Schlachthof, Karlsruhe',723632,8.431264,49.006769],
['MTUL','Tulling',8005924,12.060049,48.082865],
['XATU','Tulln a.d.Donau',8100203,16.064725,48.327509],
['XATD','Tullnerfeld',8102059,15.996536,48.295235],
['XPTU','Tuplice',5100242,14.837239,51.671407],
['XPTUD','Tuplice Debinka',5103854,14.911764,51.665774],
['XSTG','Turgi',8503503,8.25344123675291,47.4917545162075],
['TTU','Tuttlingen',8000163,8.798542,47.980579],
['TTUG','Tuttlingen Gänsäcker',8005946,8.781233,47.964663],
['TTUN','Tuttlingen Nord',8000456,8.823737,47.992605],
['TTUS','Tuttlingen Schulen',8005925,8.801166,47.987335],
['TTUZ','Tuttlingen Zentrum',8079056,8.809435,47.985615],
['MTZ','Tutzing',8005927,11.27289,47.907142],
['PNAAV','Twello',8400037,4.7005553245544,52.237777709961],
['FTW','Twiste',8005928,8.964011,51.33626],
['HT','Twistringen',8005929,8.644832,52.79188],
['OSTGM','Tägerwilen Dorf',8506198,9.139504,47.653589],
['MTG','Töging(Inn)',8005883,12.59487,48.259015],
['ATG','Tönning',8005885,8.937601,54.314139],
['UTP','Töppeln',8013129,12.006161,50.890855],
['OMTKZ','Törökszentmiklos',5501381,20.412965,47.169933],
['TT','Tübingen Hbf',8000141,9.055407,48.515811],
['TTW','Tübingen West',8005916,9.038249,48.520045],
['TTD','Tübingen-Derendingen',8005917,9.05059,48.503486],
['TTLU','Tübingen-Lustnau',8005918,9.094876,48.524048],
['MTFD','Türkenfeld',8005920,11.077277,48.104725],
['MTHB','Türkheim(Bay)Bf',8000144,10.617439,48.04569],
['STM','Türkismühle',8000154,7.114615,49.580358],
['MTLG','Tüßling',8005923,12.588701,48.212319],
['EUBD','Ubbedissen',8005930,8.637579,51.988447],
['OPUB','Ubocze',5103894,15.42015,51.055592],
['RUO','Ubstadt Ort',8007133,8.625553,49.156748],
['RUOS','Ubstadt Salzbrunnenstr',8085003,8.633025,49.15519],
['RUOU','Ubstadt Uhlandstr.',8070098,8.628827,49.162713],
['RUW','Ubstadt-Weiher',8005931,8.623335,49.167021],
['LUS','Uchtspringe',8013158,11.592243,52.543674],
['XFUC','Uckange',8700377,6.156323,49.303435],
['UUD','Uder',8013159,10.062149,51.367042],
['XIU','Udine',8300115,13.24216,46.055785],
['LUEB','Uebigau',8013160,13.296519,51.585421],
['WUM','Ueckermünde',8013162,14.05408,53.733923],
['WUMH','Ueckermünde Stadthafen',8013156,14.052233,53.736202],
['HU','Uelzen',8000168,10.553053,52.969781],
['NU','Uffenheim',8005947,10.242887,49.551264],
['MUF','Uffing a Staffelsee',8005948,11.158954,47.72015],
['TUH','Uhingen',8005949,9.585528,48.708605],
['RUDM','Uhldingen-Mühlhofen',8004595,9.248419,47.736997],
['FUR','Uhlerborn',8005950,8.142584,50.010673],
['UUS','Uhlstädt',8013164,11.462662,50.741642],
['BUD','Uhsmannsdorf',8013165,14.894309,51.328137],
['BUS','Uhyst',8013166,14.50905162,51.3629311],
['XNUI','Uitgeest',8400615,4.7016668319702,52.521667480469],
['ONUHZ','Uithuizen',8400617,6.6748869,53.4099568],
['ONUHM','Uithuizermeeden',8400618,6.7202975,53.4145845],
['DUL','Ulberndorf',8013167,13.672117,50.874021],
['DUD','Ulbersdorf',8013168,14.219801,50.955621],
['TU  P','Ulm Hbf',8000170,9.982227,48.399437],
['TUO','Ulm Ost',8005952,9.994631,48.407159],
['TUDT','Ulm-Donautal',8005954,9.940355,48.36634],
['TU  F','Ulm-Söflingen',8005955,9.958849,48.402726],
['XAUH','Ulmerfeld-Hausmening',8101695,14.8156888052925,48.074913105826],
['XAU','Ulrichsbrücke-Füssen',8100558,10.6643628932915,47.5431131730802],
['AUBS','Ulzburg Süd',8007052,9.972892,53.77346],
['MURO','Umrathshausen Ort',8005962,12.326966,47.805741],
['RUN','Unadingen',8005963,8.397886,47.881166],
['NUDF','Undorf',8005966,11.939138,49.02714],
['NUND','Unfriedsdorf',8005967,11.752578,50.199537],
['FUNG','Ungedanken',8005968,9.218971,51.124656],
['KUN','Unkel',8005970,7.219678,50.602992],
['EUN','Unna',8000171,7.692858,51.538982],
['EUNW','Unna West',8003925,7.676431,51.53898],
['EUK','Unna-Königsborn',8005971,7.687808,51.55328],
['FUKO','Unnau-Korb',8005972,7.888829,50.654168],
['MUAG','Unterammergau',8005975,11.030051,47.617464],
['NUA','Unterasbach',8005976,10.98539,49.416691],
['MUA','Unteraschau',8005977,12.697808,47.922956],
['XAUS','Unterberg-Stefansbrücke',8101712,11.3920021438023,47.2140470523309],
['TUE','Unterelchingen',8005983,10.100191,48.452989],
['MUFG','Unterföhring',8005986,11.646772,48.19031],
['RUG','Untergimpern',8007436,9.011964,49.269021],
['MUGR','Untergrainau',8017042,11.042821,47.481117],
['TUG','Untergriesheim',8005989,9.222779,49.265104],
['RURB','Untergrombach',8005990,8.54829,49.087651],
['MUH','Unterhaching',8005991,11.612359,48.064962],
['RUH','Unterharmersbach',8007103,8.089966,48.354139],
['MUHN','Unterhausen(Bay)',8005993,11.100288,48.716773],
['NUT','Unterheckenhofen',8005995,11.056154,49.213517],
['TUJM','Unterjesingen Mitte',8006002,8.981736,48.524681],
['TUJS','Unterjesingen Sandäcker',8006003,8.988261,48.523306],
['TUK','Unterkochen',8005997,10.126493,48.815008],
['UUTL','Unterlemnitz',8010354,11.623841,50.469342],
['TUL','Unterlenningen',8005998,9.460555,48.565255],
['UUZ','Unterloquitz',8013171,11.391975,50.580446],
['HUNL','Unterlüß',8006001,10.299906,52.834315],
['KUM','Untermaubach-Schlagstein',8007822,6.460448,50.726853],
['UUM','Untermaßfeld',8013172,10.415475,50.536633],
['DUN','Unterneudorf',8013173,12.97461,50.493693],
['FKUNK','Unterneustädter Kirchplatz, Kassel',716135,9.509261,51.313468],
['TURB','Unterreichenbach',8006008,8.711284,48.826858],
['PASWS','Unterretzbach',8102056,16.008035,48.765069],
['MUSM','Unterschleißheim',8006688,11.568628,48.2737],
['NUST','Untersteinach(Bayr)',8006016,11.689862,49.968884],
['NUS','Untersteinach(b Stadtsteinach)',8006017,11.528122,50.129846],
['XSUT','Unterterzen',8509416,9.25500777054931,47.1138559733854],
['UUW','Unterwellenborn',8013174,11.435073,50.659253],
['DUW','Unterwiesenthal',8013175,12.989118,50.42776],
['RUOE','Unteröwisheim Bf',8007140,8.668986,49.146342],
['RUOEL','Unteröwisheim M.-Luther-Str.',8079149,8.66202,49.146484],
['XAUM','Unzmarkt',8100074,14.4423186300606,47.2009840330424],
['AUP','Uphusum',8006026,8.862821,54.838594],
['TUA','Urbach(b Schorndorf)',8006030,9.573734,48.804956],
['KURF','Urft',8006032,6.580173,50.512369],
['SURM','Urmersbach',8007357,7.13185,50.255912],
['KUR','Urmitz',8006035,7.509072,50.402613],
['KURR','Urmitz Rheinbrücke',8006036,7.527923,50.418391],
['MURS','Urschalling',8006037,12.33869,47.835815],
['TURS','Urspring',8006039,9.894569,48.550144],
['SUZD','Usch-Zendscheid',8005342,6.602947,50.102659],
['FUSI','Usingen',8007852,8.527254,50.330923],
['HUS','Uslar',8006041,9.65524,51.654481],
['ONUQT','Usquert',8400619,6.6093776,53.4014742],
['FUS','Usseln',8006043,8.67014,51.280542],
['OTULS','Usti nad Labem Sever',5403253,14.080568,50.664247],
['XTU','Usti nad Labem hl.n.',5400019,14.044728,50.659562],
['XTUZ','Usti nad Labem zapad',5403254,14.031016,50.658398],
['XTUS','Usti nad Labem-Strekov',5403255,14.048374,50.649793],
['XNU','Utrecht Centraal',8400621,5.1102776527405,52.088890075684],
['PNULR','Utrecht Leidsche Rijn',8400607,5.06523,52.09896],
['ONUL','Utrecht Lunetten',8400623,5.144166469574,52.06555557251],
['PNAAL','Utrecht Maliebaan',8400027,4.6577777862549,52.087776184082],
['ONUO','Utrecht Overvecht',8400620,5.1247220039368,52.110000610352],
['PNAAG','Utrecht Terwijde',8400022,4.6497220993042,52.1000753],
['PNUVR','Utrecht Vaartsche Rijn',8400606,5.1216674,52.078889],
['PNAAX','Utrecht Zuilen',8400039,4.6483335494995,52.103055],
['XAUDH','Uttendorf-Helpfau',8100333,13.13351,48.160634],
['MUTG','Utting',8006048,11.093969,48.022741],
['XSUW','Uttwil',8506122,9.33968840224464,47.5860214293216],
['WUTZ','Utzedel',8013177,13.116222,53.860724],
['XMV','Vac',5501413,19.133061,47.782728],
['NVA','Vach',8006052,10.986146,49.517572],
['UV','Vacha',8013178,10.026649,50.826416],
['UVA','Vachdorf',8013179,10.538533,50.529337],
['MVAD','Vachendorf',8006717,12.32188,47.826814],
['LVA','Vahldorf',8013180,11.499764,52.252389],
['TV','Vaihingen(Enz)',8006053,8.957632,48.948118],
['TVN','Vaihingen(Enz)Nord',8007660,8.985445,48.954861],
['XFVAR','Vaires Torcy',8700378,2.639345,48.875256],
['XFVDR','Val-de-Reuil',8700321,1.224984,49.275466],
['XIVO','Valdaora-Anterselva/Olang-Antholz',8300443,12.030313,46.76742],
['XTVA','Valdek',5403273,14.506925,50.981253],
['XFVCV','Valence TGV',8704943,4.978927,44.991319],
['XFVC','Valence Ville',8700056,4.893476,44.927653],
['XFVA','Valenciennes',8700078,3.51688,50.36356],
['XNVB','Valkenburg(NL)',8400632,5.8322219848633,50.869720458984],
['KVA','Vallendar',8006054,7.609821,50.399645],
['XDVA','Vamdrup st',8602722,9.286454,55.428092],
['XAVA','Vandans',8100380,9.868838,47.098719],
['OIVAN','Vandoies/Vintl',8300520,11.722949,46.814949],
['XFVN','Varangeville-St-Nicolas',8702174,6.313233,48.635313],
['XDVRK','Varde Kaserne st',8600130,8.472116,55.612111],
['XDVRW','Varde Vest st',8602927,8.476231,55.624608],
['XDVR','Varde st',8602729,8.484406,55.615983],
['HVA','Varel(Oldb)',8006056,8.150187,53.399098],
['XIVRS','Varese',8300050,8.833295,45.816212],
['XTVD','Varnsdorf',5400220,14.638871,50.903377],
['XTVK','Varnsdorf Pivovar Kocour',5454532,14.60425,50.918617],
['XTSVD','Varnsdorf stare nadr',5456709,14.612304,50.909995],
['ONVS','Varsseveld',8400635,6.458839,51.937257],
['AVF','Vastorf',8006058,10.555558,53.199049],
['MVS','Vaterstetten',8006059,11.76438,48.104109],
['LVT','Vatterode',8013182,11.428993,51.597687],
['LVTT','Vatteröder Teich',8079152,11.412183,51.598127],
['HVEC','Vechelde',8006060,10.35976,52.257212],
['HVCH','Vechta',8006061,8.280367,52.728904],
['HVCS','Vechta-Stoppelmarkt',8087020,8.293578,52.749146],
['PNABO','Veendam',8400095,4.6455554962158,53.10324],
['ONVEC','Veenendaal Centrum',8400627,5.548611164093,52.020000457764],
['ONVEW','Veenendaal West',8400628,5.531388759613,52.028057098389],
['XNVK','Veenendaal-De Klomp',8400637,5.5738887786865,52.045833587646],
['BVLZ','Vehlefanz',8013183,13.114827,52.722332],
['UVF','Veilsdorf',8013184,10.813763,50.41533],
['NVE','Veitshöchheim',8006065,9.876196,49.831432],
['XDVJ','Vejle st',8602756,9.5365649,55.7066917],
['EVLR','Velbert Rosenhügel',8006064,7.101725,51.300124],
['ELBG','Velbert-Langenberg',8003529,7.122377,51.354764],
['ENV','Velbert-Neviges',8004340,7.090484,51.313159],
['ENIR','Velbert-Nierenhof',8004430,7.134154,51.372376],
['XAVE','Velden am Wörther See',8100081,14.044838,46.62005],
['NVN','Velden(b Hersbruck)',8006067,11.518333,49.610808],
['OTVES','Velesin',5403297,14.43682,48.820002],
['OTVNM','Velesyn mesto',5403298,14.45318,48.836308],
['WV','Velgast',8010355,12.803137,54.277316],
['XTVZ','Velke Zernoseky',5403344,14.080554,50.526096],
['XTVV','Velky Senov',5403355,14.380956,50.993376],
['XTVVZ','Velky Senov zast.',5403356,14.394126,51.004702],
['XTVVN','Velky Valtinov',5403357,14.733275,50.742552],
['FNV','Vellmar-Niedervellmar',8004415,9.478438,51.351851],
['FOV','Vellmar-Obervellmar',8004597,9.452475,51.359679],
['FVOE','Vellmar-Osterberg/EKZ',8006068,9.460796,51.35426],
['ONVL','Velp',8400640,5.9802780151367,51.994720458984],
['BVLT','Velten(Mark)',8013185,13.172034,52.684889],
['XFVH','Vendenheim',8702148,7.718215,48.666101],
['XIVNM','Venezia Mestre',8300093,12.231898,45.481905],
['XIVNS','Venezia Santa Lucia',8300094,12.320459,45.441393],
['XFVE','Venissieux',8700380,4.88806,45.705617],
['XNVL','Venlo',8400644,6.174241,51.361774],
['ONV','Venray',8400646,6.0141777992248,51.526568099007],
['XIVT','Ventimiglia',8300146,7.609957,43.792591],
['WVE','Ventschow',8013186,11.580016,53.787208],
['XIVE','Vercelli',8300008,8.416503,45.330135],
['HV','Verden(Aller)',8006076,9.237855,52.920818],
['OFVGC','Vergeze-Codognan',8702590,4.218961,43.739793],
['TVRD','Veringendorf',8007233,9.199108,48.160279],
['TVRS','Veringenstadt',8007232,9.210822,48.181412],
['XIVNN','Vernante',8300390,7.53608,44.244723],
['HVWH','Vernawahlshausen',8006078,9.614442,51.629529],
['XFVEE','Verneuil lEtang',8702187,2.82475,48.644592],
['XFVEA','Verneuil sur Avre',8704808,0.928644,48.742915],
['XFVNO','Vernon(Eure)',8700230,1.477965,49.09165],
['XIVP','Verona Porta Nuova',8300120,10.982739,45.428656],
['OIVE','Versciaco-Elmo/Vierschach-Helm',8300499,12.328867,46.732383],
['XBVC','Verviers Central',8800016,5.854917,50.588135],
['XBVP','Verviers-Palais',8800268,5.865335,50.590921],
['XTVER','Vesele pod Rabstejnem',5403371,14.361327,50.794219],
['BV','Vetschau',8013188,14.081023,51.789759],
['KVET','Vettweiß',8006079,6.602616,50.743072],
['KJW','Vettweiß-Jakobwüllesheim',8071022,6.565209,50.766705],
['XIVC','Vicenza',8300126,11.540777,45.541098],
['NVIC','Viechtach',8070561,12.889255,49.078863],
['XBVS','Vielsalm',8800274,5.909131,50.278825],
['HVBG','Vienenburg',8000364,10.562174,51.955034],
['XFVI','Vienne',8700095,4.874401,45.521026],
['DVR','Vierenstraße',8013190,12.967797,50.466902],
['MESH','Vierkirchen-Esterhofen',8001922,11.445108,48.361118],
['ONVI','Vierlingsbeek',8400647,5.99714,51.59193],
['UVU','Viernau',8013191,10.558908,50.667106],
['KV','Viersen',8000174,6.403896,51.254947],
['UVI','Vieselbach',8013192,11.137866,50.992971],
['XFVVA','Vievola',8704841,7.564381,44.112872],
['XTVL','Vilemov u Sluknova',5403384,14.321317,50.99216],
['XIVB','Villabassa-Braies/Niederdorf-Prags',8300449,12.167073,46.736672],
['XAVH','Villach Hbf',8100147,13.848536,46.618624],
['XAWV','Villach Warmbad',8100382,13.8285847862442,46.5882653199344],
['XAVW','Villach Westbf',8100148,13.840684,46.609521],
['XFVD','Villars les Dombes',8704846,5.028728,46.004606],
['XFVDS','Villedieu les Poeles',8704852,-1.225427,48.834207],
['OFVFM','Villefranche-sur-Mer',8702169,7.314172,43.706929],
['OFVLN','Villeneuve Loubet',8702188,7.134361,43.629792],
['XFVR','Villers Cotterets',8702156,3.093635,49.250224],
['XFVG','Villiers-le-Bel-Gonesse',8704878,2.415976,48.99354],
['RVL','Villingen(Schwarzw)',8000366,8.465261,48.058022],
['RVLE','Villingen-Schwenningen Eisstadion',8000356,8.528553,48.052772],
['RVLH','Villingen-Schwenningen Hammerstatt',8000393,8.546922,48.060175],
['FVR','Villmar',8006083,8.186885,50.39562],
['XAVIS','Vils Stadt',8102260,10.63196,47.54968],
['XAV','Vils in Tirol',8100116,10.63854,47.548802],
['MVSB','Vilsbiburg',8006084,12.3475,48.447384],
['NVK','Vilseck',8006085,11.801058,49.615629],
['NVI','Vilshofen(Niederbay)',8006086,13.190867,48.629551],
['OTVIS','Vilsnice',5403386,14.18087,50.747002],
['XBVV','Vilvoorde',8800090,4.433039,50.924565],
['XRVI','Vinkovci',7800018,18.802735,45.300226],
['LVG','Vinzelberg',8013194,11.67196,52.569185],
['XIVS','Vipiteno-Val di Vizze/Sterzing-Pfitsch',8300121,11.440148,46.895828],
['XDVY','Visby st',8602867,8.802019,55.009494],
['XBV','Vise',8800172,5.692657,50.737859],
['XSVI','Visp',8501605,7.88145816487087,46.2940248591228],
['HVIS','Visselhövede',8006090,9.566642,52.980059],
['OAVT','Vitis',8100335,15.173621,48.753158],
['XFVF','Vitry le François Gare',8700082,4.587414,48.71764],
['XFVT','Vittel',8700520,5.941865,48.202506],
['XNVT','Vleuten',8400651,5.0108332633972,52.103054046631],
['XNVI','Vlissingen',8400652,3.595541,51.444412],
['ONVIS','Vlissingen Souburg',8400653,3.59493,51.46444],
['HVLO','Vlotho',8006091,8.86419,52.1718],
['EVD','Voerde(Niederrhein)',8006098,6.688813,51.597541],
['ONVOD','Voerendaal',8400656,5.9302778244019,50.887222290039],
['WVOG','Vogelsang(Gransee)',8013198,13.385687,53.037712],
['SVO','Vogelweh',8006100,7.706011,49.438535],
['MVG','Vohburg',8006101,11.60735,48.739125],
['EVOH','Vohren',8006103,8.05649663,51.94351529],
['DVO','Voigtsgrün',8013201,12.426541,50.634018],
['UVO','Voigtstedt',8013202,11.306824,51.391632],
['XDV','Vojens st',8602887,9.304915,55.248477],
['XTV','Vojtanov',5400188,12.327484,50.167753],
['XTVO','Vojtanov obec',5403687,12.313001,50.162676],
['HVOL','Voldagsen',8006104,9.582677,52.101681],
['XAVO','Volders-Baumkirchen',8100337,11.5641883894346,47.2960941020982],
['NVOLA','Volkach-Astheim',8070860,10.217033,49.864345],
['FVA','Volkmarsen',8006107,9.117226,51.407567],
['EVOK','Volkringhausen',8006109,7.872214,51.359889],
['HVOP','Volpriehausen',8006112,9.737822,51.660967],
['ONVOB','Voorburg',8400658,4.3594446182251,52.066665649414],
['ONVOO','Voorhout',8400655,4.4844446182251,52.224445343018],
['ONVOS','Voorschoten',8400659,4.4324998855591,52.1252784729],
['PNAAW','Voorst-Empe',8400038,4.5533332824707,52.157501220703],
['ONVOR','Vorden',8400661,6.3170457,52.1071949],
['HVHP','Vorhop',8006116,10.656384,52.64804],
['EVRD','Vormwald',8006117,8.143094,50.980421],
['EVRO','Vormwald Dorf',8006118,8.127215,50.989929],
['NV','Vorra(Pegnitz)',8006120,11.494502,49.563921],
['AVSL','Voßloch',8007068,9.735868,53.790602],
['ONVZV','Vriezenveen',8400664,6.60041,52.40203],
['XDVM','Vroegum st',8602914,8.292159,55.65386],
['ONVRH','Vroomshoop',8400666,6.5696679,52.4571921],
['ONVU','Vught',8400667,5.2919445037842,51.655555725098],
['OTVYE','Vyhen',5403486,14.473082,48.788549],
['XTVP','Vysoka Pec',5400237,12.712069,50.341951],
['XAVB','Vöcklabruck',8100507,13.6639379285357,48.0100063617427],
['XAVM','Vöcklamarkt',8100508,13.4893003519409,47.9979096640771],
['FEDN','Vöhl-Ederbringhausen',8001664,8.871803,51.129568],
['FHZN','Vöhl-Herzhausen',8002802,8.884998,51.181224],
['FSLM','Vöhl-Schmittlotheim',8005382,8.900261,51.156838],
['FTHA','Vöhl-Thalitter',8006093,8.895033,51.217442],
['MVRN','Vöhringen',8006094,10.083628,48.279088],
['HVOE','Vöhrum',8006095,10.167325,52.335731],
['SVL','Völklingen',8000175,6.848156,49.249091],
['HELV','Völksen/Eldagsen',8001741,9.626528,52.211875],
['XAVL','Völs',8101728,11.3216663976922,47.2556339927289],
['FWAB','Wabern(Bz Kassel)',8000368,9.35804,51.103134],
['RWCH','Wachenheim(Pfalz)',8006125,8.191152,49.4393],
['TWHF','Wackershofen',8006135,9.697115,49.137249],
['ONWA','Waddinxveen',8400675,4.6497220993042,52.044166564941],
['ONWAN','Waddinxveen Noord',8400674,4.6483335494995,52.055000305176],
['PNXTL','Waddinxveen Triangel',8400677,4.6491,52.02725],
['NWAF','Waffenbrunn',8006134,12.675032,49.261541],
['AWGR','Wagersrott',8007596,9.793359,54.662747],
['RWG','Waghäusel',8006137,8.508313,49.248186],
['MWGN','Waging',8006138,12.727085,47.931617],
['EWAL','Wahlbach(Kr Siegen)',8006139,8.053783,50.758416],
['FWHM','Wahlheim',8000327,8.09992,49.719105],
['LWH','Wahlitz',8013205,11.788868,52.109177],
['AWAH','Wahlstedt',8007273,10.229575,53.961223],
['RWW','Wahlwies',8077775,8.965227,47.814176],
['HWAZ','Wahrenholz',8006144,10.606954,52.608002],
['TWN','Waiblingen',8000180,9.299882,48.826124],
['RWB','Waibstadt',8007442,8.919354,49.300941],
['NWA','Waigolshausen',8006147,10.116027,49.967293],
['AWK','Wakendorf',8006148,10.365956,53.866266],
['XPWL','Walbrzych Glowny',5100064,16.278602,50.743909],
['XAWA','Wald am Schoberpass',8100127,14.670546,47.450601],
['BWA','Walddrehna',8013210,13.617249,51.772723],
['DWAL','Waldenburg(Sachs)',8013211,12.617455,50.868208],
['TWG','Waldenburg(Württ)',8006154,9.658699,49.202537],
['NWDH','Waldershof',8006155,12.057267,49.98272],
['SWAB','Waldfischbach',8006156,7.652035,49.288555],
['TWHS','Waldhausen(b Geislingen)',8007073,9.907723,48.635308],
['TWY','Waldhausen(b Schorndorf)',8006157,9.637927,48.789185],
['DWA','Waldheim',8010359,13.014033,51.075344],
['RWA','Waldkirch',8006159,7.957245,48.095691],
['DWK','Waldkirchen(Erzgeb)',8013212,13.090571,50.762714],
['NWKN','Waldkirchen(Niederbay.)',8006160,13.60658,48.737164],
['MWKG','Waldkraiburg-Kraiburg',8006164,12.408022,48.202953],
['NWLM','Waldmünchen',8006163,12.696007,49.377886],
['RWU','Waldshut',8006167,8.219526,47.621368],
['XSWA','Walenstadt',8509414,9.31297181278078,47.1198710092825],
['XLWF','Walferdange',8271060,6.136425,49.66221],
['SWL','Walhausen(Saar)',8006170,7.129374,49.5588],
['TWH','Walheim(Württ)',8006171,9.152118,49.010941],
['HWKD','Walkenried',8006172,10.608814,51.584876],
['FWA','Wallau(Lahn)',8000187,8.47001,50.922898],
['FWF','Walldorf(Hess)',8006175,8.580811,50.001339],
['UWD','Walldorf(Werra)',8013215,10.390843,50.617603],
['RWDN','Walldürn',8006176,9.367542,49.578023],
['FWAD','Wallenrod',8006180,9.33183722,50.66402784],
['NWLD','Wallersdorf',8006181,12.743464,48.740644],
['XAWAL','Wallersee',8101803,13.159327,47.919418],
['FWAH','Wallertheim',8006183,8.049458,49.832648],
['MWHN','Walleshausen',8006184,10.980995,48.150218],
['UWAL','Wallhausen(Helme)',8013217,11.204237,51.461883],
['TWAL','Wallhausen(Württ)',8006145,10.063117,49.209151],
['XSWS','Wallisellen',8503129,8.59191127026975,47.4127169826813],
['LWWZ','Wallwitz(Saalkr)',8013220,11.921079,51.581758],
['MWKN','Walpertskirchen',8006190,11.970421,48.260872],
['KWAP','Walporzheim',8006191,7.07992,50.533924],
['UWL','Walschleben',8013221,10.955958,51.067881],
['WWL','Walsleben',8013222,12.679027,52.947039],
['HWSR','Walsrode',8006193,9.600906,52.864855],
['UWN','Waltershausen',8013223,10.563743,50.90073],
['USNT','Waltershausen Schnepfenthal',8013224,10.576211,50.883974],
['OFWL','Walygator Parc',8702265,6.15963,49.22391],
['UWA','Wandersleben',8013226,10.852498,50.906666],
['BWAZ','Wandlitz',8013227,13.46615,52.744823],
['BWAS','Wandlitzsee',8013228,13.474025,52.755967],
['TWW','Wangen(Allgäu)',8006200,9.830573,47.689227],
['UWG','Wangen(Unstrut)',8013240,11.545293,51.271505],
['HWG','Wangerooge',8007766,7.89897875,53.78777097],
['EWAN','Wanne-Eickel Hbf',8000192,7.165783,51.531256],
['TWAN','Wannweil',8006203,9.150449,48.512315],
['LWAN','Wansleben am See',8013230,11.746764,51.462417],
['HWAR','Warburg(Westf)',8000196,9.163845,51.492953],
['WWR','Waren(Müritz)',8010361,12.680678,53.521512],
['EWAF','Warendorf',8006206,7.984464,51.950091],
['EWEM','Warendorf-Einen-Müssingen',8006207,7.894774,51.9614],
['WWAH','Warenshof',8013232,12.645419,53.530788],
['ONWAR','Warffum',8400679,6.5671364,53.3908431],
['DWAB','Warmbad',8013235,13.064031,50.668495],
['WWM','Warnemünde',8013236,12.091271,54.176852],
['WWMW','Warnemünde Werft',8013237,12.085638,54.16932],
['MWGU','Warngau',8006210,11.709472,47.83357],
['WWAN','Warnitz(Uckermark)',8013238,13.876684,53.182031],
['XPWC','Warszawa Centralna',5100065,21.003234,52.22886],
['XPWW','Warszawa Wschodnia',5100066,21.052335,52.251548],
['XPWZ','Warszawa Zachodnia',5100067,20.965247,52.219972],
['XAWB','Wartberg im Mürztal',8100383,15.4841759728053,47.5273319684292],
['XAWBK','Wartberg/Krems',8101742,14.121613,47.988984],
['TWV','Warthausen',8006212,9.801661,48.129915],
['AWA','Wasbek',8006213,9.898016,54.075581],
['RETW','Wasen, Ettlingen',723576,8.398691,48.9453],
['RWR','Wasenweiler',8006215,7.687126,48.046834],
['TWA','Wasseralfingen',8006217,10.103645,48.858615],
['XLW','Wasserbillig',8200340,6.499351,49.712828],
['MWBG','Wasserburg(Bodensee)',8006218,9.639064,47.571903],
['MWSG','Wasserburg(Günz)',8006219,10.269707,48.438377],
['MWSB','Wasserburg(Inn)Bf',8006220,12.18523,48.061563],
['SWAS','Wasserliesch',8006222,6.537216,49.708467],
['UWTL','Wasserthaleben',8013244,10.88998,51.258684],
['MWTD','Wassertrüdingen',8070567,10.607434,49.043792],
['MWAS','Wasserzell(b Eichstätt)',8006224,11.16797,48.875347],
['UWS','Wasungen',8013245,10.359287,50.662895],
['HWNS','Watenstedt',8006225,10.832212,52.082814],
['XBWA','Waterloo',8800136,4.383535,50.714847],
['XBWM','Watermael/Watermaal',8800525,4.399851,50.809296],
['EWAT','Wattenscheid',8006226,7.139521,51.473214],
['EWHP','Wattenscheid-Höntrop',8006227,7.153535,51.459894],
['NWAS','Watzelsteg',8007341,12.899847,49.206939],
['FWST','Watzenborn-Steinberg',8006229,8.723435,50.5455],
['BWAF','Waßmannsdorf',8013241,13.4635305,52.36842],
['LWBU','Webau',8013246,12.06655737,51.1793496],
['XLWK','Wecker',8271080,6.387365,49.700087],
['FWCK','Weckesheim',8006232,8.843673,50.359559],
['HWED','Weddel(Braunschw)',8006233,10.623494,52.269118],
['AWL','Wedel(Holst)',8006236,9.705161,53.581995],
['HWEE','Weener',8006237,7.343095,53.163271],
['XNWT','Weert',8400684,5.7036108970642,51.248611450195],
['DWSN','Weesenstein',8013247,13.862885,50.936358],
['XNWS','Weesp',8400685,5.0430555343628,52.3127784729],
['HWEZ','Weetzen',8000342,9.635376,52.298351],
['KWEE','Weeze',8006240,6.197976,51.624294],
['LWF','Wefensleben',8013248,11.155205,52.17694],
['FWGA','Wega',8006241,9.175551,51.128192],
['KWEG','Wegberg',8006243,6.281289,51.145179],
['LWEG','Wegeleben',8010364,11.168551,51.871583],
['LWST','Wegenstedt',8013250,11.208882,52.387075],
['XPWE','Wegliniec',5100068,15.223085,51.290107],
['AWHD','Wehdel',8007812,8.806549,53.512364],
['ONWEL','Wehl',8400686,6.213844,51.9578065],
['SWE','Wehr(Mosel)',8006252,6.376822,49.586464],
['RBN','Wehr-Brennet',8001174,7.910525,47.58092],
['FRSA','Wehretal-Reichensachsen',8005003,9.985977,51.154096],
['FWEH','Wehrheim',8007853,8.56703,50.296348],
['MWBH','Weibhausen',8006255,12.692476,47.898573],
['MWEI','Weichering',8006256,11.330409,48.720645],
['DWEI','Weickersdorf(Sachs)',8013253,14.151122,51.110906],
['NWGR','Weickersgrüben',8006257,9.782546,50.107067],
['UWE','Weida',8010365,12.061846,50.785642],
['UWEA','Weida Altstadt',8013254,12.058457,50.76787],
['UWEM','Weida Mitte',8013251,12.055613,50.776506],
['NWDO','Weiden(Oberpf)',8000204,12.153846,49.67049],
['MWDB','Weidenbach',8006258,12.347286,48.254215],
['NWBE','Weidenberg',8006259,11.723267,49.943612],
['RWD','Weidenthal',8006261,7.994912,49.417494],
['NWDG','Weiding',8006264,12.776995,49.255722],
['NWHR','Weiherhammer',8006266,12.061829,49.631253],
['NWHF','Weiherhof',8006267,10.928488,49.459926],
['OAWDL','Weikendorf-Dörfles',8101748,16.75912,48.349623],
['TWM','Weikersheim',8006269,9.905718,49.478463],
['RW','Weil am Rhein',8006272,7.608419,47.593973],
['RWEI','Weil am Rhein Ost',8006273,7.63478,47.590629],
['RWGA','Weil am Rhein-Gartenstadt',8000143,7.616284,47.588707],
['RWPF','Weil am Rhein-Pfädlistraße',8000146,7.626493,47.589015],
['TW','Weil der Stadt',8006271,8.872806,48.755483],
['TWEI','Weil im Schönbuch Röte',8085013,9.049898,48.62095],
['TWEIT','Weil im Schönbuch Troppel',8085012,9.042722,48.620216],
['TWEIU','Weil im Schönbuch Untere Halde',8085014,9.062796,48.62044],
['MWLB','Weilbach(Unterallg)',8006279,10.429623,48.125996],
['NWE','Weilbach(Unterfr)',8006274,9.213165,49.668683],
['FWG','Weilburg',8000218,8.267949,50.486368],
['KWLB','Weiler (Brohltal)',8071906,7.258502,50.459034],
['TWEL','Weiler(Rems)',8006277,9.501991,48.800301],
['KWES','Weilerswist',8006280,6.845078,50.750293],
['KDEK','Weilerswist-Derkum',8001416,6.81683,50.704964],
['MWH','Weilheim(Oberbay)',8000220,11.14286,47.845363],
['TWLH','Weilheim(Württ)',8006281,8.775956,48.025106],
['TSWF','Weilimdorf',8006268,9.094328,48.82208],
['UWM','Weimar',8010366,11.326458,50.991487],
['UWMB','Weimar Berkaer Bf',8013256,11.313686,50.980626],
['UWMT','Weimar West',8013266,11.311561,50.988083],
['PQKWI','Weinbrennerplatz, Karlsruhe',721834,8.378263,49.006297],
['DWEW','Weinböhla Hp',8013267,13.561549,51.159098],
['XSW','Weinfelden',8506105,9.10634628137412,47.5662241626392],
['TWEB','Weingarten Berg',8087067,9.616876,47.816852],
['RWGT','Weingarten(Baden)',8006287,8.521224,49.059101],
['RWE','Weinheim(Bergstr)Hbf',8000377,8.665351,49.553302],
['RLUE','Weinheim-Lützelsachsen',8003792,8.649501,49.527385],
['RWEZ','Weinheim-Sulzbach',8006283,8.65636,49.575797],
['TWR','Weinsberg',8006289,9.287024,49.147997],
['TWRW','Weinsberg West',8006290,9.273139,49.151162],
['TELI','Weinsberg/Ellhofen Gewerbegebiet',8006294,9.305552,49.148758],
['RKDW','Weinweg, Karlsruhe',721461,8.441568,49.004429],
['DWS','Weischlitz',8010367,12.060517,50.448105],
['WWSN','Weisen',8013258,11.787505,53.025546],
['RWSB','Weisenbach',8006291,8.355263,48.727532],
['RWSS','Weisenheim(Sand)',8006292,8.249874,49.513931],
['FWI','Weiterstadt',8006306,8.579385,49.909706],
['OAWLB','Weitlanbrunn',8101784,12.389554,46.742963],
['DWX','Weixdorf',8013268,13.80664,51.150471],
['DWXB','Weixdorf Bad',8013269,13.802003,51.140116],
['RWZ','Weizen',8070569,8.476514,47.768832],
['MWZH','Weizern-Hopferau',8006309,10.62046,47.614593],
['LWG','Weißandt-Gölzau',8013259,12.028765,51.66967],
['TWSN','Weißenau',8006296,9.594383,47.765975],
['NWG','Weißenburg(Bay)',8006298,10.96539,49.029673],
['UW','Weißenfels',8010368,11.970926,51.204615],
['UWWE','Weißenfels West',8013261,11.943964,51.194482],
['MWSH','Weißenhorn',8006299,10.153157,48.305795],
['MAES','Weißenhorn-Eschach',8006305,10.135093,48.300999],
['NWEO','Weißenohe',8006300,11.249641,49.629283],
['KWEH','Weißenthurm',8006303,7.450988,50.421177],
['WWES','Weißer See',8070946,12.948926,53.283034],
['DWRO','Weißes Roß',8013263,13.661618,51.106628],
['BWW','Weißwasser(Oberlausitz)',8010370,14.638027,51.505442],
['FWZ','Welgesheim-Zotzenheim',8006312,7.956653,49.878575],
['XBW','Welkenraedt',8800017,5.975021,50.659509],
['FWES','Welkers',8006313,9.722538,50.480996],
['LWL','Wellen(Magdeburg)',8013271,11.432138,52.136163],
['SWN','Wellen(Mosel)',8006315,6.441322,49.67266],
['HWLL','Wellendorf',8006316,8.140157,52.181173],
['BWZ','Wellmitz',8013272,14.714896,52.064644],
['XAWE','Wels Hbf',8100014,14.0272859949486,48.166187266768],
['EWSE','Welschen Ennest',8006320,8.00361,51.04197],
['RWEL','Welschingen-Neuhausen',8006321,8.769216,47.83403],
['EWVE','Welver',8006323,7.956653,51.616253],
['SWRR','Wemmetsweiler Rathaus',8000378,7.085936,49.369521],
['AWE','Wendisch Evern',8006330,10.462781,53.217641],
['BSH','Wendisch-Rietz',8012855,14.009652,52.206826],
['XAWEN','Wendling b.Haag',8101785,13.650305,48.246702],
['TWD','Wendlingen(Neckar)',8006331,9.373011,48.672961],
['TWEN','Wennedach',8079101,9.902746,48.119398],
['HWSN','Wennigsen(Deister)',8006336,9.572167,52.279628],
['BWSD','Wensickendorf',8013278,13.386685,52.754973],
['BWR','Werbig',8010371,14.407278,52.564622],
['DWR','Werdau',8010372,12.367086,50.726165],
['DWND','Werdau Nord',8013280,12.371521,50.743676],
['BWE','Werder(Havel)',8010373,12.926189,52.392939],
['RKWE','Werderstraße, Karlsruhe',721465,8.410569,49.00045],
['EWHL','Werdohl',8006339,7.757544,51.259485],
['FWDF','Werdorf',8006340,8.417191,50.59289],
['XAWRF','Werfen',8100539,13.1952958621023,47.4728020153912],
['EWER','Werl',8006342,7.914136,51.558073],
['TWER','Wernau(Neckar)',8006346,9.413898,48.694247],
['NWRB','Wernberg',8006347,12.146226,49.538931],
['EWRN','Werne a d Lippe',8006348,7.622934,51.66925],
['BWER','Werneuchen',8013285,13.73831,52.637456],
['NWFH','Wernfeld',8006349,9.725529,50.026065],
['LWDE','Wernigerode Elmowerk',8013286,10.769264,51.838791],
['LWD','Wernigerode Hbf',8010374,10.788805,51.840254],
['LWDK','Wernigerode Hochschule Harz',8017033,10.765687,51.826217],
['LWDT','Wernigerode Westerntor',8017034,10.780256,51.83396],
['LWDH','Wernigerode-Hasserode',8017032,10.743219,51.820098],
['UWH','Wernshausen',8010375,10.353606,50.72124],
['XAWR','Wernstein',8100544,13.4553322943825,48.5040341042802],
['MWHA','Wertach-Haslach',8006353,10.460369,47.628972],
['TWT','Wertheim',8000231,9.513095,49.762025],
['TWTB','Wertheim-Bestenheid',8006354,9.499932,49.786182],
['UWTH','Werther',8013291,10.74191,51.469932],
['EWES','Wesel',8000242,6.627134,51.65584],
['EWFK','Wesel Feldmark',8006356,6.616308,51.676658],
['EBKP','Wesel-Blumenkamp',8001030,6.613118,51.695217],
['WWE','Wesenberg',8013293,12.962746,53.286702],
['XBWT','Wespelaar-Tildonk',8800324,4.638829,50.957924],
['AWBU','Wesselburen',8006357,8.932718,54.207179],
['HWES','Wesseln',8006358,10.034206,52.081543],
['EWBH','Westbarthausen',8006360,8.232642,52.096975],
['EWBV','Westbevern',8006361,7.743702,52.030984],
['MWDF','Westendorf',8006363,10.84337,48.571845],
['XAWD','Westendorf in Tirol',8100058,12.2229,47.44111],
['FWBG','Westerburg',8000245,7.966978,50.557642],
['MWM','Westerham',8006366,11.828482,47.903892],
['HWTH','Westerhausen',8006367,8.278625,52.236324],
['AWLAU','Westerland (Sylt) Autoverladung',8030918,8.313635,54.904738],
['AWLA','Westerland(Sylt)',8006369,8.310925,54.906839],
['HOCH','Westerstede-Ocholt',8004610,7.886468,53.202166],
['TWSH','Westerstetten',8006373,9.949281,48.520195],
['PNABT','Westervoort',8400103,4.4844446182251,51.96286],
['DWES','Westewitz-Hochweitzschen',8013295,13.027851,51.137616],
['TWX','Westhausen',8006376,10.183653,48.881409],
['MWHS','Westheim(Schwab)',8006378,10.818233,48.385991],
['EWSM','Westheim(Westf)',8006379,8.910255,51.494589],
['NWL','Westheim-Langendorf',8006380,9.932748,50.125775],
['EWN','Westönnen',8006383,7.960952,51.557529],
['FWT','Wetter(Hessen)',8006385,8.729147,50.903715],
['EWET','Wetter(Ruhr)',8006386,7.385915,51.386413],
['LWZE','Wetterzeube',8013297,12.012642,51.008351],
['XSWE','Wettingen',8503505,8.31598635279994,47.4596367944127],
['FWR','Wetzlar',8000383,8.503819,50.565631],
['ONWEZ','Wezep',8400690,6.0025000572205,52.454166412354],
['MWS','Weßling(Oberbay)',8006359,11.251768,48.077374],
['EWIC','Wickede(Ruhr)',8006389,7.869713,51.493201],
['NWK','Wicklesgreuth',8006390,10.71145,49.310689],
['KWIC','Wickrath',8006391,6.411505,51.13277],
['SWK','Wiebelskirchen',8006392,7.175665,49.371135],
['AWMD','Wiemersdorf',8007059,9.916483,53.954628],
['PAWAN','Wien Aspern Nord',8102888,16.504501,48.234804],
['XAWFL','Wien Floridsdorf',8100236,16.400023,48.256388],
['XAWF','Wien Franz-Josefs-Bahnhof',8100446,16.3612304841096,48.2267175516244],
['OASMN','Wien Grillgasse',8101556,16.406707,48.167403],
['OAHAN','Wien Handelskai (Bahnsteige 1-2)',8101934,16.38525,48.241978],
['XAWIE','Wien Hbf',8103000,16.3791270081246,48.1844853212324],
['XAWIO','Wien Hbf (Autoreisezuganlage)',8100004,16.392876,48.17663],
['OASRP','Wien Hbf (Bahnsteige 1-2)',8101590,16.374553,48.185705],
['OAHE','Wien Heiligenstadt',8100269,16.365698,48.249052],
['XAHN','Wien Hernals',8100271,16.314844,48.223253],
['XAWH','Wien Hütteldorf',8100447,16.2611412696273,48.1974457340754],
['XAJD','Wien Jedlersdorf',8101013,16.395968,48.273999],
['XAKS','Wien Kaiserebersdorf',8100374,16.465505,48.146168],
['OALOP','Wien Leopoldau',8101170,16.44777,48.277098],
['OALIE','Wien Liesing',8101150,16.284274,48.134916],
['OAMLP','Wien Matzleinsdorfer Platz',8101227,16.359271,48.180815],
['XAWG','Wien Meidling',8100514,16.3360885346304,48.1747780574444],
['XAWMI','Wien Mitte',8100449,16.3842059716904,48.2057093363958],
['XAWP','Wien Penzing',8100450,16.3043238319604,48.1927799609768],
['XAWNP','Wien Praterstern',8100349,16.3913543750703,48.2209068644096],
['OASBF','Wien Quartier Belvedere',8101473,16.381978,48.188042],
['OAREN','Wien Rennweg',8101433,16.386104,48.195279],
['OAFLO','Wien Siemensstraße',8100796,16.420703,48.270914],
['XAWSG','Wien Simmering',8101553,16.419515,48.170144],
['OASPL','Wien Spittelau',8101937,16.358102,48.235586],
['XASU','Wien Stadlau',8104229,16.44813,48.218529],
['XASBN','Wien Süßenbrunn',8101619,16.4850262303651,48.2857960574421],
['OATAG','Wien Traisengasse',8101641,16.383299,48.234894],
['XAWW','Wien Westbahnhof',8100003,16.3373318584069,48.1963662085328],
['XAWNS','Wiener Neustadt Hbf',8100516,16.2338650316963,47.8116141455171],
['FKWST','Wiener Straße, Kassel',711550,9.49454,51.334214],
['ONWID','Wierden',8400691,6.5916666984558,52.361389160156],
['HWRN','Wieren',8006402,10.655847,52.892588],
['DWIS','Wiesa(Erzgeb)',8013310,13.023699,50.61064],
['NWU','Wiesau(Oberpf)',8006403,12.191288,49.911013],
['FW','Wiesbaden Hbf',8000250,8.243731,50.070791],
['FWO','Wiesbaden Ost',8006404,8.256293,50.041412],
['FWB','Wiesbaden-Biebrich',8000288,8.236423,50.048829],
['FWE','Wiesbaden-Erbenheim',8006407,8.295044,50.054411],
['FWIG','Wiesbaden-Igstadt',8006408,8.325635,50.08258],
['FWS','Wiesbaden-Schierstein',8006409,8.194603,50.04759],
['BWSU','Wiesenau',8013305,14.583905,52.231321],
['BWG','Wiesenburg(Mark)',8010376,12.431213,52.098825],
['DWSB','Wiesenburg(Sachs)',8013307,12.566743,50.652705],
['FWIF','Wiesenfeld',8006413,8.749376,51.007519],
['NWDC','Wiesenfeld(b Coburg)',8006414,10.911754,50.301555],
['RWI','Wiesental',8006417,8.50239,49.225458],
['NWIE','Wiesenthau',8006418,11.126521,49.713203],
['TWID','Wieslensdorf',8006416,9.422118,49.149785],
['RWS','Wiesloch-Walldorf',8006421,8.664146,49.291353],
['MWSM','Wiesmühl(Alz)',8006423,12.564312,48.105999],
['NWI','Wiesthal',8006426,9.441051,50.016833],
['ONWCH','Wijchen',8400710,5.730833530426,51.811668395996],
['ONWIH','Wijhe',8400711,6.1405553817749,52.390277862549],
['XSWI','Wil SG',8506206,9.040983279214,47.4624092373023],
['RWIN','Wilchingen-Hallau',8006430,8.46386,47.679448],
['BWI','Wildau',8081540,13.633779,52.319935],
['TWIB','Wildberg(Württ)',8006432,8.742947,48.62528],
['FBOS','Wildeck-Bosserode',8001106,9.993002,50.945697],
['FHNB','Wildeck-Hönebach',8002903,9.944241,50.935432],
['FOBS','Wildeck-Obersuhl',8004589,10.026229,50.950619],
['OBWI','Wildert',8800193,4.46354,51.427188],
['HWIH','Wildeshausen',8006436,8.431422,52.89782],
['XAWI','Wildon',8101774,15.5211890076551,46.8841599055912],
['TWL','Wilferdingen-Singen',8006440,8.572415,48.953862],
['RWSW','Wilgartswiesen',8006441,7.883823,49.209434],
['FWL','Wilhelmsdorf',8007854,8.480809,50.350146],
['HW','Wilhelmshaven',8006445,8.114901,53.518795],
['BWHO','Wilhelmshorst',8010378,13.067447,52.331486],
['FWUE','Wilhelmshütte(Lahn)',8006446,8.550882,50.868143],
['FKWSM','Wilhelmsstraße/Stadtmuseum, Kassel',710021,9.489604,51.314474],
['NWHD','Wilhermsdorf',8006448,10.723595,49.482484],
['NWDM','Wilhermsdorf Mitte',8007856,10.716547,49.47999],
['DWL','Wilischthal',8013312,13.056579,50.724724],
['DWI','Wilkau-Haßlau',8010379,12.513578,50.675412],
['HWBD','Willebadessen',8006449,9.011652,51.621757],
['FWLN','Willingen',8006453,8.603635,51.293342],
['FWLM','Willmenrod',8006454,7.985758,50.539329],
['NWIG','Willmering',8006455,12.670073,49.246573],
['TWLB','Willsbach',8006456,9.358868,49.142422],
['WWLD','Wilmersdorf(Angerm)',8013313,13.892457,53.111628],
['ERUD','Wilnsdorf-Rudersdorf',8005205,8.144083,50.839125],
['FWTH','Wilsenroth',8006459,8.032791,50.531112],
['AWIR','Wilster',8006460,9.383456,53.926228],
['DWT','Wilthen',8010380,14.391502,51.09328],
['SWIG','Wiltingen(Saar)',8006461,6.590462,49.662641],
['XLWW','Wilwerwiltz',8271120,6.00081,49.988201],
['XFWI','Wilwisheim',8702269,7.507795,48.745918],
['SWIN','Wincheringen',8006463,6.406578,49.608467],
['OAWIN','Windau im Brixental',8101776,12.185507,47.438917],
['RWND','Winden(Pfalz)',8006468,8.122479,49.095452],
['NWB','Windischeschenbach',8006472,12.16517,49.794747],
['XAWIG','Windischgarsten',8100517,14.3268902546829,47.7153615058722],
['NWIN','Windsbach',8006473,10.825716,49.249694],
['XFWM','Wingen-sur-Moder',8700327,7.381868,48.92036],
['UWIR','Wingerode',8013315,10.240509,51.389707],
['AWG','Wingst',8006475,9.098158,53.745047],
['NWKH','Winkelhaid',8006476,11.301035,49.392946],
['TWI','Winnenden',8006479,9.39229,48.879583],
['SWI','Winningen(Mosel)',8006481,7.523208,50.315424],
['HWIN','Winninghausen',8006482,9.436305,52.323325],
['SWNW','Winnweiler',8006483,7.855955,49.570548],
['XNWI','Winschoten',8400696,7.035101,53.1392377],
['AWI','Winsen(Luhe)',8006484,10.207691,53.353839],
['ONWS','Winsum',8400697,6.5202905,53.3300994],
['TWIN','Winterbach(b Schorndorf)',8006485,9.480994,48.798432],
['EWTB','Winterberg(Westf)',8006486,8.532408,51.198585],
['NWN','Winterhausen',8006488,10.012072,49.708442],
['AWIM','Wintermoor',8006489,9.828536,53.186138],
['XNWW','Winterswijk',8400698,6.7155181,51.9677307],
['PNW','Winterswijk West',8400013,4.4324998855591,51.97453],
['XSWT','Winterthur',8506000,8.72379907331845,47.5003335301466],
['UWIP','Wipperdorf',8013318,10.661064,51.452958],
['LWIP','Wippra',8013319,11.2807,51.57574],
['KWIR','Wirges',8006498,7.78521,50.468396],
['FWIR','Wirtheim',8006499,9.258929,50.225784],
['WWI','Wismar',8010381,11.469433,53.896837],
['XFWBG','Wissembourg',8700382,7.950014,49.031645],
['EWIN','Wissen(Sieg)',8006501,7.739814,50.782871],
['HWIS','Wissingen',8006503,8.205047,52.258211],
['OPWTO','Witkow Sl.',5104173,16.127331,50.79415],
['EWIK','Wittbräucke',8006505,7.44591,51.420173],
['EWIT','Witten Hbf',8000251,7.329442,51.435544],
['EWIA','Witten-Annen Nord',8006510,7.375337,51.44784],
['XSWB','Wittenbach',8506393,9.38853751224722,47.4628476165033],
['WW','Wittenberge',8010382,11.762871,53.003115],
['WWT','Wittenhagen',8013322,13.05605,54.184004],
['DWIM','Wittgensdorf Mitte',8013324,12.869759,50.874386],
['DWIO','Wittgensdorf ob Bf',8010383,12.841365,50.882771],
['TWIT','Wittighausen',8006517,9.846243,49.618406],
['HWTT','Wittingen',8000344,10.723174,52.727291],
['SWIH','Wittlich Hbf',8000379,6.943557,49.973121],
['RWL','Wittlingen',8070578,7.646976,47.656631],
['HWTM','Wittmund',8006520,7.788826,53.579868],
['WWK','Wittstock(Dosse)',8010384,12.478911,53.160621],
['FWZN','Witzenhausen Nord',8006524,9.863079,51.351556],
['MWIT','Witzighausen',8006493,10.097804,48.317443],
['DWIT','Witzschdorf',8013328,13.088523,50.775236],
['AWRT','Witzwort',8006527,8.998558,54.386097],
['XPWOD','Wodzislaw Sl.',5104095,18.476374,50.007989],
['XNWO','Woerden',8400702,4.8936109542847,52.084999084473],
['UWOF','Woffleben',8013333,10.722213,51.55552],
['XSWO','Wohlen AG',8502213,8.26978121871856,47.3484618373915],
['AWLF','Wohltorf',8006541,10.278184,53.520589],
['XFWY','Woippy',8700383,6.155867,49.148806],
['OPWOJ','Wojanow',5104100,15.821887,50.884608],
['RWO','Wolfach',8006544,8.221849,48.293665],
['PQKWS','Wolfartsweierer Straße, Karlsruhe',721646,8.423098,49.003569],
['TWO','Wolfegg',8006545,9.808665,47.824264],
['LWO','Wolfen(Bitterfeld)',8013335,12.279563,51.661159],
['HWOH','Wolfenbüttel',8000255,10.532306,52.159126],
['LWOR','Wolferode',8013336,11.508752,51.512244],
['FWFG','Wolfgang(Kr Hanau)',8006548,8.957469,50.123107],
['FWFH','Wolfhagen',8006549,9.17862,51.331695],
['ONWOH','Wolfheze',8400704,5.7936110496521,52.005554199219],
['MWO','Wolfratshausen',8006550,11.427201,47.914424],
['HWOB','Wolfsburg Hbf',8006552,10.787784,52.429498],
['UWOL','Wolfsgefärth',8013334,12.07314,50.816277],
['NWM','Wolfsmünster',8006554,9.734893,50.094508],
['XBWO','Wolfstee',8821709,4.786144,51.168361],
['SWFS','Wolfstein',8006555,7.610287,49.58428],
['XAWT','Wolfurt',8100389,9.740966,47.457189],
['WWO','Wolgast',8013339,13.769087,54.043949],
['WWOH','Wolgast Hafen',8013340,13.779963,54.051845],
['WWOF','Wolgaster Fähre',8013341,13.790624,54.056376],
['DWO','Wolkenstein',8013343,13.064965,50.652743],
['XAWO','Wolkersdorf im Weinviertel',8101793,16.512756,48.378181],
['UWK','Wolkramshausen',8010385,10.745663,51.440021],
['RWBB','Wollbach(Baden)',8070579,7.648632,47.668211],
['LWLS','Wolmirstedt',8013344,11.635619,52.250359],
['AWOL','Wolterdingen(Han)',8006559,9.8458,53.026122],
['BWOL','Woltersdorf/Nuthe-Urstromtal',8013345,13.195281,52.117362],
['HWWI','Woltwiesche',8006561,10.278999,52.200754],
['ONWOV','Wolvega',8400705,6.0036110877991,52.880832672119],
['ONWOK','Workum',8400706,5.4564285,52.9724864],
['XNWM','Wormerveer',8400707,4.7922220230103,52.489166259766],
['FWOR','Worms Hbf',8000257,8.356448,49.63494],
['FPD','Worms-Pfeddersheim',8004788,8.279654,49.634634],
['AWPW','Worpswede',8007122,8.91551,53.226487],
['AWRE','Wremen',8006570,8.521275,53.646987],
['BWRZ','Wriezen',8010386,14.140239,52.715433],
['AWST','Wrist',8006572,9.748128,53.932382],
['XPWR','Wroclaw Glowny',5100069,17.037088,51.098078],
['XPWRL','Wroclaw Lesnica',5104133,16.866581,51.142509],
['XPWRD','Wroclaw Nowy Dwor',5104127,16.954394,51.119923],
['LWU','Wulfen(Anh)',8013357,11.922141,51.818681],
['EWUF','Wulfen(Westf)',8006590,7.011578,51.719189],
['HWUL','Wulften',8006592,10.176026,51.659403],
['MWUH','Wullenstetten',8006595,10.071331,48.31398],
['NHOB','Wunsiedel-Holenbrunn',8000173,12.033928,50.051113],
['HWUN','Wunstorf',8000268,9.450976,52.422225],
['KW','Wuppertal Hbf',8000266,7.149543,51.254363],
['KWBA','Wuppertal-Barmen',8006596,7.195159,51.266972],
['KWHD','Wuppertal-Hahnenfurth/Düssel',8006601,7.05543146,51.2539996],
['KWLP','Wuppertal-Langerfeld',8006607,7.242298,51.277866],
['KWO','Wuppertal-Oberbarmen',8006719,7.221483,51.273839],
['KWRO','Wuppertal-Ronsdorf',8006616,7.2156,51.226476],
['KWSO','Wuppertal-Sonnborn',8006618,7.096575,51.240584],
['KWS','Wuppertal-Steinbeck',8006619,7.14063,51.250679],
['KWU','Wuppertal-Unterbarmen',8006620,7.171212,51.258929],
['KWV','Wuppertal-Vohwinkel',8006718,7.071597,51.234259],
['KWZ','Wuppertal-Zoologischer Garten',8006623,7.10702,51.243469],
['NWLZ','Wurlitz',8006624,11.99001,50.253194],
['TWUM','Wurmlingen Mitte',8006625,8.777842,48.001755],
['TWUN','Wurmlingen Nord',8006626,8.775387,48.008528],
['UWCH','Wurzbach(Thür)',8013360,11.543131,50.466172],
['LWZ','Wurzen',8013361,12.738972,51.364418],
['WWH','Wusterhausen(Dosse)',8013363,12.456704,52.888351],
['BWUS','Wustermark',8010389,12.939728,52.551851],
['LWUZ','Wusterwitz',8013365,12.37425,52.385112],
['WRDN','Wustrau-Radensleben',8012703,12.897265,52.857264],
['SWU','Wustweiler',8006627,7.034824,49.398897],
['UWU','Wutha',8013366,10.396598,50.957099],
['WWU','Wutike',8013367,12.352854,53.004316],
['RWUT','Wutöschingen',8006628,8.363654,47.662088],
['RWY','Wyhlen',8006629,7.690918,47.546328],
['MWAE','Wächterhof',8006131,11.712731,48.033567],
['FWAE','Wächtersbach',8006132,9.295828,50.253958],
['XSWW','Wädenswil',8503206,8.67519275896566,47.2293011037616],
['UWLH','Wölfershausen',8013329,10.436588,50.491507],
['FWOE','Wölfersheim-Södel',8006529,8.81622,50.397335],
['XAWL','Wörgl Hbf',8100099,12.060581,47.491797],
['OASOL','Wörgl Süd-Bruckhäusl',8101571,12.109135,47.486821],
['LWOZ','Wörlitz',8013332,12.421732,51.837865],
['MWNS','Wörnitzstein',8006533,10.714478,48.731977],
['FWRR','Wörrstadt',8006534,8.114712,49.846251],
['FWOD','Wörsdorf',8006535,8.249323,50.244752],
['MWTI','Wörth(Isar)',8006537,12.332925,48.624182],
['NWOE','Wörth(Main)',8006538,9.15696,49.793465],
['RWRT','Wörth(Rhein)',8000254,8.273146,49.045678],
['RWRTL','Wörth(Rhein) Alte Bahnmeisterei',8079143,8.266465,49.04862],
['RWRTA','Wörth(Rhein) Badallee',8079212,8.249891,49.055995],
['RWRTK','Wörth(Rhein) Badepark',8079213,8.24413,49.058565],
['RWRTB','Wörth(Rhein) Bienwaldhalle',8079142,8.260879,49.04978],
['RWRTP','Wörth(Rhein) Bürgerpark',8079141,8.254267,49.050843],
['RWRD','Wörth(Rhein) Mozartstraße',8006536,8.251944,49.055109],
['RWRTR','Wörth(Rhein) Rathaus',8079211,8.249809,49.052423],
['RWRZ','Wörth(Rhein) Zügelstraße',8006531,8.262363,49.052992],
['RWSN','Wössingen',8006539,8.605129,49.015508],
['RWSO','Wössingen Ost',8070179,8.609981,49.015786],
['EWAP','Wülfrath-Aprath',8006575,7.072023,51.267886],
['DWU','Wülknitz',8013348,13.389256,51.369021],
['UWF','Wünschendorf',8010387,12.097672,50.797633],
['UWFN','Wünschendorf Nord',8013349,12.077948,50.817438],
['BWUE','Wünsdorf-Waldstadt',8013350,13.468145,52.165559],
['EWGD','Würgendorf',8006577,8.141766,50.760013],
['EWGT','Würgendorf (Ort)',8006578,8.126875,50.756916],
['SWB','Würzbach(Saar)',8006581,7.193441,49.244182],
['NWH','Würzburg Hbf',8000260,9.93578,49.801796],
['NWS','Würzburg Süd',8006582,9.943503,49.788193],
['NWZ','Würzburg-Zell',8006586,9.884593,49.804938],
['DWD','Wüstenbrand',8010388,12.756417,50.805483],
['WWSF','Wüstenfelde',8013352,13.13961,54.230272],
['NWBZ','Wüstenselbitz',8006588,11.709552,50.218424],
['HWUE','Wüsting',8006270,8.337248,53.118123],
['KX','Xanten',8006630,6.445287,51.65967],
['XAY','Ybbs a.d. Donau',8100007,15.099578,48.158894],
['RKMY','Yorckstraße, Karlsruhe',721470,8.375432,49.010952],
['XSY','Yverdon-les-Bains',8504200,6.64114576153437,46.781876670999],
['XBYG','Yves-Gomezee',8800497,4.495307,50.236944],
['HDUD','ZOB, Duderstadt',860883,10.254035,51.51282],
['XNZAA','Zaandam',8400731,4.8136110305786,52.438888549805],
['ONZAK','Zaandam Kogerveld',8400728,4.8202776908875,52.456665039062],
['XNKZ','Zaandijk Zaanse Schans',8400364,4.3249998092651,52.469165802002],
['DZT','Zabeltitz',8013368,13.5154,51.349834],
['WZN','Zachun',8013370,11.324498,53.502653],
['XPZ','Zagan',5100211,15.315622,51.60425],
['XZZG','Zagorje',7900252,14.9910943,46.1206526],
['XRZ','Zagreb Glavni kolodvor',7800020,15.9787052,45.8044381],
['LZA','Zahna',8013371,12.781211,51.919969],
['NZH','Zainhammer',8006632,11.766251,49.967374],
['RZA','Zaisenhausen',8006633,8.816664,49.104757],
['XTZBO','Zakupy-Bozikov',5400565,14.650035,50.678639],
['ONZAB','Zaltbommel',8400732,5.2633333206177,51.80888748169],
['XTZAN','Zandov',5403779,14.389716,50.712105],
['XNZA','Zandvoort aan Zee',8400733,4.5327777862549,52.3752784729],
['NZA','Zapfendorf',8006634,10.929894,50.018291],
['OPZRE','Zareba',5104380,15.21827,51.098138],
['WZAR','Zarrendorf',8013373,13.08003,54.240747],
['XPZY','Zary',5100243,15.136962,51.634748],
['XPZS','Zasieki',5100159,14.668586,51.735509],
['XPZAW','Zawiercie',5100212,19.422992,50.481017],
['XPZA','Zbaszynek',5100071,15.818092,52.242507],
['XTZI','Zdice',5400190,13.979305,49.907733],
['XTZDI','Zdislava',5403563,14.87668,50.770131],
['XBZD','Zedelgem',8800345,3.16414,51.127047],
['XBZ','Zeebrugge-Dorp',8800184,3.19517,51.326383],
['BZS','Zeesen',8013376,13.635143,52.264863],
['WZE','Zehdenick(Mark)',8013377,13.317482,52.979387],
['WZEN','Zehdenick-Neuhof',8013378,13.345779,53.0057],
['NZ','Zeil',8006635,10.598519,50.005142],
['DZNH','Zeithain',8013381,13.344552,51.330206],
['LZ','Zeitz',8010390,12.131488,51.056452],
['OTZLH','Zelena Lhota',5403566,13.178995,49.249237],
['OTZNB','Zelenice nad Bilinou',5403625,13.723948,50.525238],
['OTZEY','Zelenky',5403627,13.771735,50.601385],
['XTZRC','Zelezna Ruda centrum',5477035,13.236809,49.136129],
['XTZR','Zelezna Ruda mesto',5403629,13.229329,49.143095],
['XAZ','Zell am See',8100048,12.7960147243479,47.3203884862581],
['XAZZ','Zell am Ziller',8100547,11.881362,47.231386],
['RZLH','Zell(Harmersbach)',8007101,8.064706,48.3451],
['RZ','Zell(Wiesental)',8006641,7.849149,47.705626],
['FZR','Zell-Romrod',8006644,9.199797,50.727164],
['OAZEL','Zell/Pram',8101819,13.623934,48.317424],
['UZL','Zella-Mehlis',8010391,10.674124,50.646721],
['UZLW','Zella-Mehlis West',8013383,10.649535,50.658552],
['LZD','Zellendorf',8013384,13.066853,51.89431],
['OAZLD','Zellerndorf',8100363,15.968069,48.695546],
['NZLT','Zellerthal',8007338,12.865143,49.174934],
['XAZW','Zeltweg',8100518,14.7479535495922,47.1896387342001],
['WZP','Zempin',8013385,13.959447,54.06598],
['FZE','Zennern',8006647,9.317729,51.111983],
['BZEP','Zepernick(Bernau)',8081560,13.533642,52.659449],
['FZEP','Zeppelinheim',8006648,8.605153,50.036516],
['LZE','Zerbst/Anhalt',8013389,12.088931,51.953821],
['KZE','Zerkall',8007824,6.453932,50.692439],
['XSZE','Zermatt',8501689,7.74829647858381,46.0244720211086],
['BZF','Zernsdorf',8013392,13.693338,52.299404],
['WZIN','Zerrenthin',8013393,14.097895,53.49939],
['ONZEA','Zetten-Andelst',8400734,5.7228408,51.920056],
['UZU','Zeulenroda unt Bf',8013396,12.011351,50.659376],
['RZE','Zeutern Bf',8007135,8.677521,49.178251],
['RZEO','Zeutern Ost',8007136,8.703363,49.179087],
['RZES','Zeutern Sportplatz',8079617,8.67065,49.177989],
['BZTH','Zeuthen',8081580,13.627173,52.348936],
['UZE','Zeutsch',8013398,11.508263,50.754927],
['XNZV','Zevenaar',8400735,6.0719442367554,51.923053741455],
['ONZEB','Zevenbergen',8400737,4.60904,51.64042],
['XPZG','Zgorzelec',5100085,15.003544,51.140024],
['XPZGM','Zgorzelec Miasto',5100232,15.020131,51.153027],
['XBZI','Zichem',8800097,4.988276,51.006394],
['XZZM','Zidani Most',7900004,15.1703235,46.0855858],
['XSZB','Ziegelbrücke',8503225,9.06003718983755,47.1361516591535],
['LZI','Zielitz',8013402,11.680214,52.296293],
['LZIO','Zielitz Ort',8073410,11.676309,52.288285],
['XPZIG','Zielona Gora Gl.',5100222,15.513709,51.947436],
['FZB','Zierenberg',8006658,9.304813,51.365117],
['FZBR','Zierenberg-Rosental',8006654,9.291483,51.367668],
['OAZIE','Ziersdorf',8101822,15.920993,48.528518],
['LZR','Ziesar',8013404,12.295846,52.2631],
['KZI','Zieverich',8006659,6.62574,50.949276],
['NZF','Zillendorf',8006660,12.67324,49.345477],
['BZIL','Ziltendorf',8013406,14.616335,52.199513],
['TZI','Zimmern(Main-Tauber)',8006662,9.79051,49.595355],
['RZIM','Zimmern(b Seckach)',8006661,9.371975,49.430411],
['FZM','Zimmersrode',8006663,9.225195,51.008144],
['WZ','Zinnowitz',8010392,13.903359,54.075564],
['XAZL','Zirl',8100451,11.229397067302,47.2660277315278],
['NZI','Zirndorf',8006664,10.958468,49.443891],
['NZIK','Zirndorf Kneippallee',8006666,10.945303,49.450029],
['XTFS','Zirovice-Seniky',5400962,12.335567,50.148295],
['WZIR','Zirtow-Leussow',8013409,12.88692,53.281036],
['DZ','Zittau',8010393,14.805774,50.904461],
['DZH','Zittau Hp',8013410,14.816982,50.898671],
['DZS','Zittau Süd',8013411,14.814749,50.890238],
['DZV','Zittau Vorstadt',8013412,14.79187,50.890364],
['PSZI','Zizers',8509054,9.55958937259641,46.9348427166025],
['OTZ','Zliv',5403589,14.362164,49.065219],
['DZL','Zoblitz',8013413,14.750741,51.123578],
['ONZO','Zoetermeer',8400741,4.4772224426269,52.047500610352],
['ONZOO','Zoetermeer Oost',8400740,4.4927778244019,52.046390533447],
['XSZG','Zofingen',8502001,7.94309735295328,47.2880447598482],
['XBZO','Zolder',8800145,5.3299,51.033548],
['RVLZ','Zollhaus(Villingen-Schwenningen)',8006667,8.505997,48.040888],
['MZHP','Zollhaus-Petersthal',8006670,10.418038,47.665825],
['UZN','Zopten',8013422,11.35179,50.528294],
['MZO','Zorneding',8006671,11.832456,48.089601],
['BZO','Zossen',8010395,13.438571,52.218923],
['RZT','Zotzenbach',8006672,8.75322,49.609367],
['DZSC','Zschaitz',8013424,13.156825,51.168852],
['LZBN','Zscherben',8013425,11.865125,51.467695],
['DZP','Zschopau',8013427,13.065988,50.743242],
['DZPO','Zschopau Ost',8013311,13.081878,50.744587],
['LZS','Zschortau',8013428,12.361585,51.483266],
['XSZU','Zug(CH)',8502204,8.51529569481037,47.173623052732],
['XNZB','Zuidbroek',8400742,6.8679141998291,53.159612280006],
['ONZH','Zuidhorn',8400743,6.4062361,53.2486292],
['OAZU','Zurndorf',8101829,17.024041,47.968058],
['RZHN','Zusenhofen',8006678,8.018466,48.544728],
['ONZTP','Zutphen',8400744,6.1941666603088,52.145278930664],
['RZUN','Zuzenhausen',8006679,8.821439,49.297394],
['SZW','Zweibrücken Hbf',8006680,7.356643,49.246805],
['SZWR','Zweibrücken-Rosengarten',8006682,7.380099,49.253021],
['OSZWI','Zweidlen',8503405,8.46803,47.57052],
['LGDG','Zwenkau-Großdalzig',8013447,12.271154,51.208264],
['DZWG','Zwickau Stadthalle',8000292,12.498056,50.70392],
['DZWM','Zwickau Zentrum',8000289,12.496893,50.715544],
['DZW','Zwickau(Sachs)Hbf',8010397,12.474716,50.714668],
['DZWP','Zwickau-Pölbitz',8013433,12.479662,50.737212],
['DZWS','Zwickau-Schedewitz',8013434,12.495009,50.701851],
['NZWL','Zwiesel(Bay)',8006684,13.22638,49.020941],
['NZWU','Zwieselau',8006685,13.276937,49.00676],
['XNZW','Zwijndrecht(NL)',8400752,4.6416668891907,51.814998626709],
['RZW','Zwingenberg(Baden)',8006686,9.04283,49.416029],
['FZW','Zwingenberg(Bergstr)',8006687,8.609119,49.725902],
['XNZL','Zwolle',8400747,6.0919442176819,52.504722595215],
['PNZSH','Zwolle Stadshagen',8400746,6.05146,52.52764],
['DZWO','Zwota',8013437,12.427735,50.352621],
['DZWZ','Zwota-Zechenbach',8013436,12.399987,50.351134],
['DZA','Zwotental',8010398,12.363835,50.36207],
['DZI','Zwönitz',8013435,12.797899,50.632232],
['LZBR','Zöberitz',8013414,12.033458,51.50461],
['LZGL','Zörnigall',8013418,12.731558,51.882935],
['BZUH','Zühlsdorf',8013429,13.403535,52.732698],
['KZ','Zülpich',8006674,6.662476,50.698174],
['XSZA','Zürich Altstetten',8503001,8.48894026539714,47.3914808360747],
['XSZN','Zürich Enge',8503010,8.53080595476229,47.364098359728],
['XSZF','Zürich Flughafen',8503016,8.56238666028306,47.4503820775337],
['XSZH','Zürich HB',8503000,8.54019221036255,47.3781765755721],
['XSZR','Zürich Hardbrücke',8503020,8.51710646093582,47.3851946907917],
['XSZO','Zürich Oerlikon',8503006,8.54411523120592,47.4115288802068],
['XSZS','Zürich Stadelhofen',8503003,8.54846647021741,47.3666105568869],
['XSZW','Zürich Wiedikon',8503011,8.52346258297155,47.3714716203929],
['XSZWO','Zürich Wollishofen',8503009,8.53358828018203,47.347439921851],
['WZS','Züssow',8010396,13.548191,53.973879],
['TZU','Züttlingen',8006676,9.329117,49.291657],
['XNSH','s-Hertogenbosch',8400319,5.29362,51.69048],
['ONSHO','s-Hertogenbosch Oost',8400320,5.3183331489563,51.700553894043],
['XNTH','t Harde',8400388,5.893611,52.4091682],
['TAPF','Äpfingen',8079092,9.853409,48.152625],
['TOE','Öhringen Hbf',8004623,9.502705,49.203214],
['TOEW','Öhringen West',8004624,9.485804,49.20014],
['TCP','Öhringen-Cappel',8004620,9.526919,49.201961],
['TOED','Ölbronn-Dürrn',8004632,8.753677,48.98581],
['ROH','Ötigheim',8004636,8.240582,48.888526],
['TOET','Ötisheim',8004637,8.813508,48.966571],
['OMOTT','Ötteveny',5501019,17.488783,47.719677],
['XAOE','Ötztal',8100061,10.8592487704863,47.2385762796078],
['KUBP','Übach-Palenberg',8005935,6.097265,50.924336],
['RUEM','Überlingen',8005942,9.162853,47.769101],
['RUEB','Überlingen Therme',8005937,9.145642,47.769269],
['RUEN','Überlingen-Nußdorf',8005943,9.188144,47.754859],
['MUS','Übersee',8005940,12.487338,47.822047],
['WUEK','Ückeritz',8013161,14.049809,54.013918],
['KUD','Üdingen',8007821,6.481437,50.728109],
['SUG','Ürzig(DB)',8005945,7.004806,49.995933],
);

# Automatically generated, see share/meta.json
my $meta = {
8004343 => [8074343],
5500003 => [5500008,5500728],
8070859 => [8005523],
8098044 => [8000044],
8013434 => [8000292],
8010184 => [8071738,8089295],
8089046 => [8010406],
8005523 => [8070859],
716122 => [712896],
8503340 => [8503310],
8010256 => [8017020,8070777],
8506307 => [8506111],
721836 => [8079144],
8089205 => [8013470],
8000105 => [8098105],
8098147 => [8000147],
8002116 => [721301],
8017017 => [8012494],
8013483 => [8089207],
8001903 => [8001904],
8070073 => [8000713],
8013487 => [8089197],
8071169 => [8002059],
370051 => [8079126],
8010406 => [8089046],
373013 => [721084],
8089187 => [8010341],
8011201 => [8089201],
8506121 => [8506112],
8002699 => [8072722],
8506134 => [8506160],
8070004 => [8070003],
8002549 => [8098549],
401003 => [151011],
8503310 => [8503340],
8700074 => [8700464],
8800004 => [8898004],
8070777 => [8010256,8017020],
8089028 => [8011162],
8071738 => [8010184,8089295],
8098262 => [8000261,8098261,8098263],
8070172 => [8071172,8072172],
8089051 => [8089050],
8000292 => [8013434],
8071172 => [8070172,8072172],
8075556 => [8005556],
8000261 => [8098261,8098262,8098263],
8012494 => [8017017],
8072722 => [8002699],
8089001 => [8011155],
8506155 => [8506137],
8073368 => [8003368],
8002228 => [8071001],
8089066 => [8011306],
8089015 => [8011102],
8089032 => [8011118],
8079212 => [8006536],
8003434 => [8003402,8003403],
8079088 => [8002847],
8072172 => [8070172,8071172],
8506111 => [8506307],
8011343 => [8089072],
8089165 => [8010403],
8089182 => [8010036],
8089190 => [8010405],
8011155 => [8089001],
8000193 => [8098193],
8073400 => [8003400],
8070003 => [8070004],
8000577 => [8079075],
8506133 => [8506162],
8089184 => [8012666],
8010041 => [8089168],
8098263 => [8000261,8098261,8098262],
8506137 => [8506155],
8010205 => [8098205],
8089201 => [8011201],
8010255 => [8089185],
8006536 => [8079212],
8098160 => [8011160,8089021],
151011 => [401003],
8017020 => [8010256,8070777],
8001904 => [8001903],
8700464 => [8700074],
8089083 => [8010404],
8089168 => [8010041],
8503428 => [8506152],
8003187 => [721401],
8089021 => [8011160,8098160],
8003432 => [8073432],
8010405 => [8089190],
8089197 => [8013487],
8002553 => [8098553],
8012666 => [8089184],
8098096 => [8000096],
8011118 => [8089032],
8079144 => [721836],
8011041 => [8089113],
721401 => [8003187],
8000044 => [8098044],
8089113 => [8011041],
8506308 => [8506110],
8089117 => [8011901],
8079075 => [8000577],
8506157 => [8506136],
8098105 => [8000105],
8000147 => [8098147],
8000348 => [8098349],
371210 => [720841],
5500008 => [5500003],
8010053 => [8089186],
8017475 => [8010185],
8100545 => [8100102],
8011901 => [8089117],
8000191 => [8079041,8089390],
721358 => [501004],
8003368 => [8073368],
8089188 => [8011003],
8002847 => [8079088],
8003402 => [8003403,8003434],
8011167 => [8089100],
8002442 => [8007078],
8506113 => [8506306],
8011003 => [8089188],
8005556 => [8075556],
378402 => [8003185],
8098553 => [8002553],
8089073 => [8011113],
720841 => [371210],
8010341 => [8089187],
501004 => [721358],
8898004 => [8800004],
8011102 => [8089015],
721084 => [373013],
8079041 => [8000191,8089390],
8074343 => [8004343],
8098205 => [8010205],
8079126 => [370051],
8089185 => [8010255],
8071001 => [8002228],
8011306 => [8089066],
8506136 => [8506157],
8070171 => [8000157],
8089100 => [8011167],
8001009 => [721245],
8010036 => [8089182],
8506110 => [8506308],
8506162 => [8506133],
8098261 => [8000261,8098262,8098263],
501001 => [377903,8079125],
8000157 => [8070171],
721245 => [8001009],
8089207 => [8013483],
8011160 => [8089021,8098160],
8007078 => [8002442],
8010404 => [8089083],
377903 => [501001,8079125],
8002059 => [8071169],
8098549 => [8002549],
8010403 => [8089165],
901013 => [367072],
8506152 => [8503428],
8010185 => [8017475],
8089181 => [8013477],
8001138 => [8001152],
8013470 => [8089205],
8079125 => [377903,501001],
8089186 => [8010053],
8089050 => [8089051],
8506160 => [8506134],
8506135 => [8506159],
8506112 => [8506121],
721301 => [8002116],
712896 => [716122],
8089072 => [8011343],
8011162 => [8089028],
8003403 => [8003402,8003434],
8003185 => [378402],
8506306 => [8506113],
8089390 => [8000191,8079041],
8098193 => [8000193],
367072 => [901013],
8080530 => [8011695],
8073432 => [8003432],
8001152 => [8001138],
8001091 => [8070026],
8013477 => [8089181],
8098349 => [8000348],
8082673 => [8002673],
8100102 => [8100545],
8089295 => [8010184,8071738],
8506159 => [8506135],
8000713 => [8070073],
8002673 => [8082673],
8003400 => [8073400],
8011113 => [8089073],
8000096 => [8098096],
8011695 => [8080530],
8070026 => [8001091],
5500728 => [5500003],
};

sub get_stations {
	return @stations;
}

sub get_meta {
	return $meta;
}

sub normalize {
	my ($val) = @_;

	$val =~ s{Ä}{Ae}g;
	$val =~ s{Ö}{Oe}g;
	$val =~ s{Ü}{Ue}g;
	$val =~ s{ä}{ae}g;
	$val =~ s{ö}{oe}g;
	$val =~ s{ß}{sz}g;
	$val =~ s{ü}{ue}g;

	return $val;
}

sub get_station {
	my ($name) = @_;

	if (not $name) {
		return;
	}

	my $ds100_match = firstval { $name eq $_->[0] } @stations;

	if ($ds100_match) {
		return ($ds100_match);
	}

	my $eva_match = firstval { defined $_->[2] and $name eq $_->[2] } @stations;

	if ($eva_match) {
		return ($eva_match);
	}

	return get_station_by_name($name);
}

sub get_station_by_location {
	my ( $lon, $lat, $num_matches ) = @_;

	$num_matches //= 10;

	my $dist = Geo::Distance->new();

	# we only use geolocations inside germany.
	# For these, this fast preprocessing step will let through all
	# coordinates inside a 60km radius (and a bunch which are farther out)
	my @candidates = grep {
		      $#{$_} >= 4
		  and abs( $_->[3] - $lon ) < 1
		  and abs( $_->[4] - $lat )
		  < 1
	} @stations;
	my @distances
= map { $dist->distance( 'kilometer', $lon, $lat, $_->[3], $_->[4] ) }	  @candidates;
	my @station_map = pairwise { [ $a, $b ] } @candidates, @distances;

	@station_map = sort { $a->[1] <=> $b->[1] } @station_map;
	splice( @station_map, $num_matches );

	return @station_map;
}

sub get_station_by_name {
	my ($name) = @_;

	if (not $name) {
		return;
	}

	my $nname        = lc($name);
	my $actual_match = firstval { $nname eq lc( $_->[1] ) } @stations;

	if ($actual_match) {
		return ($actual_match);
	}

	$nname        = normalize($nname);
	$actual_match = firstval { $nname eq normalize( lc( $_->[1] ) ) } @stations;
	if ($actual_match) {
		return ($actual_match);
	}

	my @distances   = map { distance( $nname, $_->[1] ) } @stations;
	my $min_dist    = min(@distances);
	my @station_map = pairwise { [ $a, $b ] } @stations, @distances;

	my @substring_matches;

	# $name may be an invalid regular expression
	eval { push(@substring_matches, grep { $_->[1] =~ m{\Q$name\E}i } @stations) };
	eval { push(@substring_matches, grep { $_->[1] =~ m{$name}i } @stations) };

	my @levenshtein_matches
	  = map { $_->[0] } grep { $_->[1] == $min_dist } @station_map;

	return uniq_by { $_->[0] } ( @substring_matches, @levenshtein_matches );
}

1;

__END__

=head1 NAME

Travel::Status::DE::IRIS::Stations - Station name to station code mapping

=head1 SYNOPSIS

    use Travel::Status::DE::IRIS::Stations;

    my $name = 'Essen Hbf';
    my @stations = Travel::Status::DE::IRIS::Stations::get_station_by_name(
      $name);

    if (@stations < 1) {
      # no matching stations
    }
    elsif (@stations > 1) {
      # too many matches
    }
    else {
      printf("Input '%s' matched station code %s (as '%s')\n",
        $name, @{$stations[0]});
    }

=head1 VERSION

version 1.73

=head1 DESCRIPTION

This module contains a list of Deutsche Bahn stations, and also some stations
outside of Germany which are served by Deutsche Bahn trains. It offers
several accessors to look up stations based on names or geolocation data and
can also simply dump all known stations.

Each of the following methods returns a list of array references. Each
array reference describes a single station and contains either two or
five elements:

=over

=item * Station code (also known as DS100 / "Druckschrift 100" /
"Richtlinie 100"). A short string used exclusively by Deutsche Bahn APIs. Note
that it may contain space characters.

=item * Station name

=item * EVA station number (often, but not always, same as UIC station number)

=item * Station longitude, if available

=item * Station latitude, if available

=back

=head1 METHODS

=over

=item Travel::Status::DE::IRIS::Stations::get_stations

Returns a list of all known stations, lexically sorted by station name.

=item Travel::Status::DE::IRIS::Stations::get_station(I<$in>)

Returns a list of stations matching I<$in>.

If a I<$in> is a valid station (either DS100 code or EVA number),
a single array reference describing the station is returned. Otherwise,
I<$in> is passed to get_station_by_name(I<$in>) (see below).

Note that DS100 code matching is case sensitive.

=item Travel::Status::DE::IRIS::Stations::get_station_by_location(I<$lon>, I<$lat>, I<$num_matches>)

Looks for stations which are close to longitude/latitude I<$lon>/I<$lat> and
returns the closest I<$num_matches> (defaults to 10) matches. Note that
stations which are located more than 70 kilometers away from I<$lon>/I<$lat>
may be ignored when computing the closest matches.

Note that location-based lookup is only supported for stations inside Germany,
since the station list data source does not provide geolocation data for
non-german stations.

=item Travel::Status::DE::IRIS::Stations::get_station_by_name(I<$name>)

Returns a list of stations where the station name matches I<$name>.

Matching happens in two steps: If a case-insensitive exact match exists, only
this one is returned. Otherwise, all stations whose name contains I<$name> as
a substring (also case-insensitive) and all stations whose name has a low
Levenshtein distance to I<$name> are returned.

This two-step behaviour makes sure that not-prefix-free stations can still be
matched directly. For instance, both "Essen-Steele" and "Essen-Steele Ost"
are valid station names, but "essen-steele" will only return "Essen-Steele".

=back

=head1 DIAGNOSTICS

None.

=head1 DEPENDENCIES

=over

=item * GIS::Distance(3pm)

=item * List::MoreUtils(3pm)

=item * List::Util(3pm)

=item * Text::LevenshteinXS(3pm)

=back

=head1 BUGS AND LIMITATIONS

There is no support for intelligent whitespaces (to also match "-" and similar)
yet.

=head1 SEE ALSO

Travel::Status::DE::IRIS(3pm).

=head1 AUTHOR

Station data: Copyright (C) 2016 by DB Station&Service AG, Europaplatz 1, 10557 Berlin, Germany

Lookup code: Copyright (C) 2014-2020 by Daniel Friesel E<lt>derf@finalrewind.orgE<gt>

=head1 LICENSE

This module is licensed under the same terms as Perl itself. Note that the
station data used by this module is also available under a CC-BY 4.0 license on
L<http://data.deutschebahn.com/dataset/data-haltestellen>.
