package VM::HetznerCloud::API::PlacementGroups;

# ABSTRACT: PlacementGroups

# ---
# This class is auto-generated by bin/get_hetzner_info.pl
# ---

use v5.24;

use Moo;
use Types::Standard qw(:all);

use Mojo::Base -strict, -signatures;

extends 'VM::HetznerCloud::APIBase';

with 'MooX::Singleton';

use VM::HetznerCloud::Schema;

our $VERSION = '0.0.1'; # VERSION

has endpoint  => ( is => 'ro', isa => Str, default => sub { 'placement_groups' } );

sub list ($self, %params) {
    my $request_params = {
        'label_selector' => {
            'in'       => 'query',
            'required' => 0,
            'validate' => 'string',
        },
        'name' => {
            'in'       => 'query',
            'required' => 0,
            'validate' => 'string',
        },
        'sort' => {
            'in'       => 'query',
            'required' => 0,
            'validate' => 'string',
        },
        'type' => {
            'in'       => 'query',
            'required' => 0,
            'validate' => 'string',
        },
    };
;
    return $self->_request( '', \%params, $request_params, { type => 'get' } );
}

sub create ($self, %params) {
    my $request_params = {};
    return $self->_request( '', \%params, $request_params, { type => 'post' } );
}

sub delete ($self, %params) {
    my $request_params = {
        'id' => {
            'in'       => 'path',
            'required' => 1,
            'validate' => 'int64',
        },
    };
;
    return $self->_request( '/:id', \%params, $request_params, { type => 'delete' } );
}

sub get ($self, %params) {
    my $request_params = {
        'id' => {
            'in'       => 'path',
            'required' => 1,
            'validate' => 'int64',
        },
    };
;
    return $self->_request( '/:id', \%params, $request_params, { type => 'get' } );
}

sub put ($self, %params) {
    my $request_params = {
        'id' => {
            'in'       => 'path',
            'required' => 1,
            'validate' => 'int64',
        },
    };
;
    return $self->_request( '/:id', \%params, $request_params, { type => 'put' } );
}


1;

__END__

=pod

=encoding UTF-8

=head1 NAME

VM::HetznerCloud::API::PlacementGroups - PlacementGroups

=head1 VERSION

version 0.0.1

=head1 SYNOPSIS

    use VM::HetznerCloud;

    my $api_key = '1234abc';
    my $cloud   = VM::HetznerCloud->new(
        token => $api_key,
    );

    $cloud->records->create(
    );

=head1 ATTRIBUTES

=over 4

=item * endpoint

=back

=head1 METHODS

=head2 list

Returns all PlacementGroup objects.

    $cloud->placement_groups->list(
        label_selector => 'test',
        name => 'test',
        sort => 'test',
        type => 'test',
    );

=head2 create

Creates a new PlacementGroup.

    $cloud->placement_groups->create();

=head2 delete

Deletes a PlacementGroup.

    $cloud->placement_groups->delete(
        id => 'test',
    );

=head2 get

Gets a specific PlacementGroup object.

    $cloud->placement_groups->get(
        id => 'test',
    );

=head2 put

Updates the PlacementGroup properties.

Note that when updating labels, the PlacementGroup’s current set of labels will be replaced with the labels provided in the request body. So, for example, if you want to add a new label, you have to provide all existing labels plus the new label in the request body.

Note: if the PlacementGroup object changes during the request, the response will be a “conflict” error.

    $cloud->placement_groups->put(
        id => 'test',
    );

=head1 AUTHOR

Renee Baecker <reneeb@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2018 by Renee Baecker.

This is free software, licensed under:

  The Artistic License 2.0 (GPL Compatible)

=cut
