#!/usr/bin/perl

package eBay::API::XML::DataType::NotificationStatisticsType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. NotificationStatisticsType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::NotificationStatisticsType

=head1 DESCRIPTION

Summary information about notifications delivered, failed, errors, queued for
a given application ID and time period.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::DataType::NotificationStatisticsType inherits from the L<eBay::API::XML::BaseDataType> class

=cut

use eBay::API::XML::BaseDataType;
our @ISA = ("eBay::API::XML::BaseDataType");



my @gaProperties = ( [ 'DeliveredCount', 'xs:int', '', '', '' ]
	, [ 'ErrorCount', 'xs:int', '', '', '' ]
	, [ 'ExpiredCount', 'xs:int', '', '', '' ]
	, [ 'QueuedNewCount', 'xs:int', '', '', '' ]
	, [ 'QueuedPendingCount', 'xs:int', '', '', '' ]
                    );
push @gaProperties, @{eBay::API::XML::BaseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::BaseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setDeliveredCount()

Returns the number of notifications delivered successfully during the given
time period.

#    Argument: 'xs:int'

=cut

sub setDeliveredCount {
  my $self = shift;
  $self->{'DeliveredCount'} = shift
}

=head2 getDeliveredCount()

  Calls: GetNotificationsUsage
  Returned: Always

#    Returns: 'xs:int'

=cut

sub getDeliveredCount {
  my $self = shift;
  return $self->{'DeliveredCount'};
}


=head2 setErrorCount()

Returns the number of notifications for which there were delivery errors
during the given time period.

#    Argument: 'xs:int'

=cut

sub setErrorCount {
  my $self = shift;
  $self->{'ErrorCount'} = shift
}

=head2 getErrorCount()

  Calls: GetNotificationsUsage
  Returned: Always

#    Returns: 'xs:int'

=cut

sub getErrorCount {
  my $self = shift;
  return $self->{'ErrorCount'};
}


=head2 setExpiredCount()

Returns the number of notifications that permanently failed during
the given time period.

#    Argument: 'xs:int'

=cut

sub setExpiredCount {
  my $self = shift;
  $self->{'ExpiredCount'} = shift
}

=head2 getExpiredCount()

  Calls: GetNotificationsUsage
  Returned: Always

#    Returns: 'xs:int'

=cut

sub getExpiredCount {
  my $self = shift;
  return $self->{'ExpiredCount'};
}


=head2 setQueuedNewCount()

Returns the number of new notifications that were queued during
the given time period.

#    Argument: 'xs:int'

=cut

sub setQueuedNewCount {
  my $self = shift;
  $self->{'QueuedNewCount'} = shift
}

=head2 getQueuedNewCount()

  Calls: GetNotificationsUsage
  Returned: Always

#    Returns: 'xs:int'

=cut

sub getQueuedNewCount {
  my $self = shift;
  return $self->{'QueuedNewCount'};
}


=head2 setQueuedPendingCount()

Returns the number of pending notifications in the queue during
the given time period.

#    Argument: 'xs:int'

=cut

sub setQueuedPendingCount {
  my $self = shift;
  $self->{'QueuedPendingCount'} = shift
}

=head2 getQueuedPendingCount()

  Calls: GetNotificationsUsage
  Returned: Always

#    Returns: 'xs:int'

=cut

sub getQueuedPendingCount {
  my $self = shift;
  return $self->{'QueuedPendingCount'};
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
