/*********************                                                        */
/*! \file module_template.cpp
 ** \verbatim
 ** Top contributors (to current version):
 **   Morgan Deters, Mathias Preiner
 ** This file is part of the CVC4 project.
 ** Copyright (c) 2009-2018 by the authors listed in the file AUTHORS
 ** in the top-level source directory) and their institutional affiliations.
 ** All rights reserved.  See the file COPYING in the top-level source
 ** directory for licensing information.\endverbatim
 **
 ** \brief Option template for option modules.
 **
 ** For each <module>_options.toml configuration file, mkoptions.py
 ** expands this template and generates a <module>_options.cpp file.
 **/

#include "options/options_holder.h"

namespace CVC4 {

template <> void Options::set(
    options::binary_name__option_t,
    const options::binary_name__option_t::type& x)
{
  d_holder->binary_name = x;
}
template <> const options::binary_name__option_t::type& Options::operator[](
    options::binary_name__option_t) const
{
  return d_holder->binary_name;
}
template <> bool Options::wasSetByUser(options::binary_name__option_t) const
{
  return d_holder->binary_name__setByUser__;
}
template <> void Options::set(
    options::err__option_t,
    const options::err__option_t::type& x)
{
  d_holder->err = x;
}
template <> const options::err__option_t::type& Options::operator[](
    options::err__option_t) const
{
  return d_holder->err;
}
template <> bool Options::wasSetByUser(options::err__option_t) const
{
  return d_holder->err__setByUser__;
}
template <> void Options::set(
    options::in__option_t,
    const options::in__option_t::type& x)
{
  d_holder->in = x;
}
template <> const options::in__option_t::type& Options::operator[](
    options::in__option_t) const
{
  return d_holder->in;
}
template <> bool Options::wasSetByUser(options::in__option_t) const
{
  return d_holder->in__setByUser__;
}
template <> void Options::set(
    options::inputLanguage__option_t,
    const options::inputLanguage__option_t::type& x)
{
  d_holder->inputLanguage = x;
}
template <> const options::inputLanguage__option_t::type& Options::operator[](
    options::inputLanguage__option_t) const
{
  return d_holder->inputLanguage;
}
template <> bool Options::wasSetByUser(options::inputLanguage__option_t) const
{
  return d_holder->inputLanguage__setByUser__;
}
template <> void Options::set(
    options::languageHelp__option_t,
    const options::languageHelp__option_t::type& x)
{
  d_holder->languageHelp = x;
}
template <> const options::languageHelp__option_t::type& Options::operator[](
    options::languageHelp__option_t) const
{
  return d_holder->languageHelp;
}
template <> bool Options::wasSetByUser(options::languageHelp__option_t) const
{
  return d_holder->languageHelp__setByUser__;
}
template <> void Options::set(
    options::out__option_t,
    const options::out__option_t::type& x)
{
  d_holder->out = x;
}
template <> const options::out__option_t::type& Options::operator[](
    options::out__option_t) const
{
  return d_holder->out;
}
template <> bool Options::wasSetByUser(options::out__option_t) const
{
  return d_holder->out__setByUser__;
}
template <> void Options::set(
    options::outputLanguage__option_t,
    const options::outputLanguage__option_t::type& x)
{
  d_holder->outputLanguage = x;
}
template <> const options::outputLanguage__option_t::type& Options::operator[](
    options::outputLanguage__option_t) const
{
  return d_holder->outputLanguage;
}
template <> bool Options::wasSetByUser(options::outputLanguage__option_t) const
{
  return d_holder->outputLanguage__setByUser__;
}
template <> void Options::set(
    options::parseOnly__option_t,
    const options::parseOnly__option_t::type& x)
{
  d_holder->parseOnly = x;
}
template <> const options::parseOnly__option_t::type& Options::operator[](
    options::parseOnly__option_t) const
{
  return d_holder->parseOnly;
}
template <> bool Options::wasSetByUser(options::parseOnly__option_t) const
{
  return d_holder->parseOnly__setByUser__;
}
template <> const options::preprocessOnly__option_t::type& Options::operator[](
    options::preprocessOnly__option_t) const
{
  return d_holder->preprocessOnly;
}
template <> bool Options::wasSetByUser(options::preprocessOnly__option_t) const
{
  return d_holder->preprocessOnly__setByUser__;
}
template <> const options::printSuccess__option_t::type& Options::operator[](
    options::printSuccess__option_t) const
{
  return d_holder->printSuccess;
}
template <> bool Options::wasSetByUser(options::printSuccess__option_t) const
{
  return d_holder->printSuccess__setByUser__;
}
template <> const options::statistics__option_t::type& Options::operator[](
    options::statistics__option_t) const
{
  return d_holder->statistics;
}
template <> bool Options::wasSetByUser(options::statistics__option_t) const
{
  return d_holder->statistics__setByUser__;
}
template <> const options::statsEveryQuery__option_t::type& Options::operator[](
    options::statsEveryQuery__option_t) const
{
  return d_holder->statsEveryQuery;
}
template <> bool Options::wasSetByUser(options::statsEveryQuery__option_t) const
{
  return d_holder->statsEveryQuery__setByUser__;
}
template <> const options::statsHideZeros__option_t::type& Options::operator[](
    options::statsHideZeros__option_t) const
{
  return d_holder->statsHideZeros;
}
template <> bool Options::wasSetByUser(options::statsHideZeros__option_t) const
{
  return d_holder->statsHideZeros__setByUser__;
}
template <> void Options::set(
    options::verbosity__option_t,
    const options::verbosity__option_t::type& x)
{
  d_holder->verbosity = x;
}
template <> const options::verbosity__option_t::type& Options::operator[](
    options::verbosity__option_t) const
{
  return d_holder->verbosity;
}
template <> bool Options::wasSetByUser(options::verbosity__option_t) const
{
  return d_holder->verbosity__setByUser__;
}


namespace options {

struct binary_name__option_t binary_name;
struct err__option_t err;
struct in__option_t in;
struct inputLanguage__option_t inputLanguage;
struct languageHelp__option_t languageHelp;
struct out__option_t out;
struct outputLanguage__option_t outputLanguage;
struct parseOnly__option_t parseOnly;
struct preprocessOnly__option_t preprocessOnly;
struct printSuccess__option_t printSuccess;
struct statistics__option_t statistics;
struct statsEveryQuery__option_t statsEveryQuery;
struct statsHideZeros__option_t statsHideZeros;
struct verbosity__option_t verbosity;


}  // namespace options
}  // namespace CVC4
