from typing import Iterable, Callable, IO, AnyStr, Generic, Any, Union, Iterator


def input(
    files: Union[str, Iterable[str]]=None,
    inplace: bool=...,
    backup: str=...,
    bufsize: int=...,
    mode: str=...,
    openhook: Callable[[str, str], IO[AnyStr]]=...) -> Iterable[AnyStr]: ...


def close() -> None: ...
def nextfile() -> None: ...
def filename() -> str: ...
def lineno() -> int: ...
def isfirstline() -> bool: ...
def isstdin() -> bool: ...

class FileInput(Iterable[AnyStr], Generic[AnyStr]):
    def __init__(
        self,
        files: Union[str, Iterable[str]]=None,
        inplace: bool=...,
        backup: str=...,
        bufsize: int=...,
        mode: str=...,
        openhook: Callable[[str, str], IO[AnyStr]]=...
        ) -> None: ...

    def __del__(self) -> None: ...
    def close(self) -> None: ...
    def __enter__(self) -> 'FileInput[AnyStr]': ...
    def __exit__(self, type: Any, value: Any, traceback: Any) -> None: ...
    def __iter__(self) -> Iterator[AnyStr]: ...
    def __next__(self) -> AnyStr: ...
    def __getitem__(self, i) -> AnyStr: ...
    def nextfile(self) -> None: ...
    def readline(self) -> AnyStr: ...
    def filename(self) -> str: ...
    def lineno(self) -> int: ...
    def filelineno(self) -> int: ...
    def fileno(self) -> int: ...
    def isfirstline(self) -> bool: ...
    def isstdin(self) -> bool: ...

def hook_compressed(filename: str, mode: str) -> IO[AnyStr]: ...
def hook_encoded(encoding: str) -> IO[AnyStr]: ...
