\name{edgeR-package}
\docType{package}
\alias{edgeR}
\alias{edgeR-package}
\title{Empirical analysis of digital gene expression data in R}
\description{
edgeR is a library for the analysis of digital gene expression data arising from RNA sequencing technologies such as SAGE, CAGE, Tag-seq or RNA-seq, with emphasis on testing for differential expression.

Particular strengths of the package include the ability to estimate biological variation between replicate libraries, and to conduct exact tests of significance which are suitable for small counts.
The package is able to make use of even minimal numbers of replicates.

A User's Guide is available as well as the usual help page documentation for each of the individual functions.

The library implements statistical methodology developed by Robinson and Smyth (2007, 2008).
}

\author{
Mark Robinson <mrobinson@wehi.edu.au>, Davis McCarthy <dmccarthy@wehi.edu.au>, Gordon Smyth
}

\references{
  Robinson MD and Smyth GK (2007). Moderated statistical tests for
  assessing differences in tag abundance. \emph{Bioinformatics} 23, 2881-2887

  Robinson MD and Smyth GK (2008). Small-sample estimation of negative
  binomial dispersion, with applications to SAGE data. \emph{Biostatistics},
  9, 321-332

  Robinson MD, McCarthy DJ and Smyth GK (2010). edgeR: a Bioconductor
  package for differential expression analysis of digital gene
  expression data. \emph{Bioinformatics} 26, 139-140
}
\keyword{package}
