## Note on Patches/Pull Requests

Thanks for taking the time to contribute back! To make it easier for us to
review your changes, try to follow these guidelines:

* Keep changesets small and on topic. Itching to refactor or clean something
  up? Do it in a separate branch.
* Stay consistent with existing code conventions.
* Break changes into smaller logical commits.

To propose a change:

* [Fork the project.](https://help.github.com/articles/fork-a-repo)
* Make your feature addition or bug fix.
* Add tests for it. This is important so I don't break it in a future version unintentionally.
* Commit, do not mess with rakefile, version, or history. (if you want to have your own version, that is fine but bump version in a commit by itself I can ignore when I pull)
* [Send me a pull request](https://help.github.com/articles/using-pull-requests). Bonus points for topic branches.
* [Check that your pull request passes the build](https://travis-ci.org/intridea/hashie/pull_requests).

## Bug triage

Have a problem? File an [issue here](https://github.com/intridea/hashie/issues).

To make bug squashing easier, include the following in your issue:

* What version of hashie are you using?
* Is it still a problem in master?