template <typename Type>
concept bool EqualComparable()
{
    return requires(Type lhs, Type rhs)
        {
            { lhs == rhs} -> bool;
            { lhs != rhs} -> bool;
        };
};

template <typename Iter>
concept bool Iterator()
{
    return requires(Iter it)
        {
            { ++it } -> Iter &;
            { *it }  -> typename Iter::ValueType;
        };
};
