//*****************************************************************************
//                              CmdNgSpicePR.hpp                              *
//                             ------------------                             *
// Description : This class contains values associated with the NG-Spice      *
//               PRINT command. It inherits from the class CmdBase.           *
// Started     : 16/10/2007                                                   *
// Last Update : 16/04/2010                                                   *
// Copyright   : (C) 2007 by M.S.Waters                                       *
// Email       : M.Waters@bom.gov.au                                          *
//*****************************************************************************

//*****************************************************************************
//                                                                            *
//    This program is free software; you can redistribute it and/or modify    *
//    it under the terms of the GNU General Public License as published by    *
//    the Free Software Foundation; either version 2 of the License, or       *
//    (at your option) any later version.                                     *
//                                                                            *
//*****************************************************************************

#ifndef CMDNGSPR_HPP
#define CMDNGSPR_HPP

// System Includes

using  namespace  std;

#include <iostream>
#include <climits>

// wxWidgets Includes

#include <wx/wx.h>
#include <wx/tokenzr.h>

// Application Includes

#include "base/CmdBase.hpp"
#include "gnucap/commands/CmdGnuCapPR.hpp"

struct CmdGnuCapPR;

// Local Macro and Constant Declarations


//*****************************************************************************

struct CmdNgSpicePR : public CmdBase
{
  private :

    virtual  bool  bValidate( void );

  public :

    eCmdType       m_eAnaType;
    wxArrayString  m_osaNodes;
    wxArrayString  m_osaCpnts;
    bool           m_bParmtrs[ ePAR_LST+1 ];
    bool           m_bCpxPrts[ eCPX_LST+1 ];

             CmdNgSpicePR( void );
    virtual ~CmdNgSpicePR( );

    virtual  bool  bClear( void );

             bool  bSetAnaType( eCmdType eAnaType );

    virtual  bool  bParse ( void );
    virtual  bool  bFormat( void );

             int   iGetParaCnt( void );

    CmdNgSpicePR & operator = ( const CmdNgSpicePR & roCmdPR );
    CmdNgSpicePR & operator = ( const CmdGnuCapPR  & roCmdPR );

    void  Print( const wxString & rosPrefix=wxT("  ") );
};

//*****************************************************************************

#endif // CMDNGSPR_HPP
