/* device.c generated by valac 0.11.6, the Vala compiler
 * generated from device.vala, do not modify */

/*
 * indicator-network - user interface for connman
 * Copyright 2010-2011 Canonical Ltd.
 *
 * Authors:
 * Andrew Higginson
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 3, as published
 * by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranties of
 * MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <connman-manager.h>
#include <connman-service.h>


#define TYPE_DEVICE (device_get_type ())
#define DEVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DEVICE, Device))
#define DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DEVICE, DeviceClass))
#define IS_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DEVICE))
#define IS_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DEVICE))
#define DEVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DEVICE, DeviceClass))

typedef struct _Device Device;
typedef struct _DeviceClass DeviceClass;
typedef struct _DevicePrivate DevicePrivate;

#define TYPE_DEVICE_TYPE (device_type_get_type ())

#define TYPE_DEVICE_STATE (device_state_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_WIFI_DEVICE (wifi_device_get_type ())
#define WIFI_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_WIFI_DEVICE, WifiDevice))
#define WIFI_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_WIFI_DEVICE, WifiDeviceClass))
#define IS_WIFI_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_WIFI_DEVICE))
#define IS_WIFI_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_WIFI_DEVICE))
#define WIFI_DEVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_WIFI_DEVICE, WifiDeviceClass))

typedef struct _WifiDevice WifiDevice;
typedef struct _WifiDeviceClass WifiDeviceClass;
typedef struct _WifiDevicePrivate WifiDevicePrivate;

#define TYPE_ETHERNET_DEVICE (ethernet_device_get_type ())
#define ETHERNET_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ETHERNET_DEVICE, EthernetDevice))
#define ETHERNET_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ETHERNET_DEVICE, EthernetDeviceClass))
#define IS_ETHERNET_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ETHERNET_DEVICE))
#define IS_ETHERNET_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ETHERNET_DEVICE))
#define ETHERNET_DEVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ETHERNET_DEVICE, EthernetDeviceClass))

typedef struct _EthernetDevice EthernetDevice;
typedef struct _EthernetDeviceClass EthernetDeviceClass;
typedef struct _EthernetDevicePrivate EthernetDevicePrivate;

#define TYPE_CELLULAR_DEVICE (cellular_device_get_type ())
#define CELLULAR_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CELLULAR_DEVICE, CellularDevice))
#define CELLULAR_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CELLULAR_DEVICE, CellularDeviceClass))
#define IS_CELLULAR_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CELLULAR_DEVICE))
#define IS_CELLULAR_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CELLULAR_DEVICE))
#define CELLULAR_DEVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CELLULAR_DEVICE, CellularDeviceClass))

typedef struct _CellularDevice CellularDevice;
typedef struct _CellularDeviceClass CellularDeviceClass;
typedef struct _CellularDevicePrivate CellularDevicePrivate;

#define TYPE_BLUETOOTH_DEVICE (bluetooth_device_get_type ())
#define BLUETOOTH_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BLUETOOTH_DEVICE, BluetoothDevice))
#define BLUETOOTH_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BLUETOOTH_DEVICE, BluetoothDeviceClass))
#define IS_BLUETOOTH_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BLUETOOTH_DEVICE))
#define IS_BLUETOOTH_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BLUETOOTH_DEVICE))
#define BLUETOOTH_DEVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BLUETOOTH_DEVICE, BluetoothDeviceClass))

typedef struct _BluetoothDevice BluetoothDevice;
typedef struct _BluetoothDeviceClass BluetoothDeviceClass;
typedef struct _BluetoothDevicePrivate BluetoothDevicePrivate;

#define TYPE_FLIGHT_MODE_DEVICE (flight_mode_device_get_type ())
#define FLIGHT_MODE_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FLIGHT_MODE_DEVICE, FlightModeDevice))
#define FLIGHT_MODE_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FLIGHT_MODE_DEVICE, FlightModeDeviceClass))
#define IS_FLIGHT_MODE_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FLIGHT_MODE_DEVICE))
#define IS_FLIGHT_MODE_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FLIGHT_MODE_DEVICE))
#define FLIGHT_MODE_DEVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FLIGHT_MODE_DEVICE, FlightModeDeviceClass))

typedef struct _FlightModeDevice FlightModeDevice;
typedef struct _FlightModeDeviceClass FlightModeDeviceClass;
typedef struct _FlightModeDevicePrivate FlightModeDevicePrivate;

struct _Device {
	GObject parent_instance;
	DevicePrivate * priv;
	ConnmanManager* connman;
};

struct _DeviceClass {
	GObjectClass parent_class;
};

typedef enum  {
	DEVICE_TYPE_WIRED,
	DEVICE_TYPE_WIRELESS,
	DEVICE_TYPE_BLUETOOTH,
	DEVICE_TYPE_MOBILE,
	DEVICE_TYPE_FLIGHTMODE,
	DEVICE_TYPE_GENERIC
} DeviceType;

typedef enum  {
	DEVICE_STATE_OFF,
	DEVICE_STATE_OFFLINE,
	DEVICE_STATE_CONNECTED,
	DEVICE_STATE_ONLINE
} DeviceState;

struct _DevicePrivate {
	DeviceType _type_;
	DeviceState _state;
};

struct _WifiDevice {
	Device parent_instance;
	WifiDevicePrivate * priv;
};

struct _WifiDeviceClass {
	DeviceClass parent_class;
};

struct _EthernetDevice {
	Device parent_instance;
	EthernetDevicePrivate * priv;
};

struct _EthernetDeviceClass {
	DeviceClass parent_class;
};

struct _CellularDevice {
	Device parent_instance;
	CellularDevicePrivate * priv;
};

struct _CellularDeviceClass {
	DeviceClass parent_class;
};

struct _BluetoothDevice {
	Device parent_instance;
	BluetoothDevicePrivate * priv;
};

struct _BluetoothDeviceClass {
	DeviceClass parent_class;
};

struct _FlightModeDevice {
	Device parent_instance;
	FlightModeDevicePrivate * priv;
};

struct _FlightModeDeviceClass {
	DeviceClass parent_class;
};


static gpointer device_parent_class = NULL;
static gpointer wifi_device_parent_class = NULL;
static gpointer ethernet_device_parent_class = NULL;
static gpointer cellular_device_parent_class = NULL;
static gpointer bluetooth_device_parent_class = NULL;
static gpointer flight_mode_device_parent_class = NULL;

GType device_get_type (void) G_GNUC_CONST;
GType device_type_get_type (void) G_GNUC_CONST;
GType device_state_get_type (void) G_GNUC_CONST;
#define DEVICE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_DEVICE, DevicePrivate))
enum  {
	DEVICE_DUMMY_PROPERTY,
	DEVICE_TYPE_,
	DEVICE_STATE
};
DeviceState device_convert_state (Device* self, ConnmanTechnologyState state);
void device_update_state (Device* self, ConnmanTechnologyState state);
void device_set_state (Device* self, DeviceState value);
Device* device_construct (GType object_type);
DeviceType device_get_type_ (Device* self);
void device_set_type_ (Device* self, DeviceType value);
DeviceState device_get_state (Device* self);
static void device_finalize (GObject* obj);
static void _vala_device_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_device_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType wifi_device_get_type (void) G_GNUC_CONST;
enum  {
	WIFI_DEVICE_DUMMY_PROPERTY
};
WifiDevice* wifi_device_new (ConnmanManager* connman);
WifiDevice* wifi_device_construct (GType object_type, ConnmanManager* connman);
static void _lambda2_ (GObject* s, GParamSpec* p, WifiDevice* self);
static void __lambda2__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
GType ethernet_device_get_type (void) G_GNUC_CONST;
enum  {
	ETHERNET_DEVICE_DUMMY_PROPERTY
};
EthernetDevice* ethernet_device_new (ConnmanManager* connman);
EthernetDevice* ethernet_device_construct (GType object_type, ConnmanManager* connman);
static void _lambda4_ (GObject* s, GParamSpec* p, EthernetDevice* self);
static void __lambda4__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
GType cellular_device_get_type (void) G_GNUC_CONST;
enum  {
	CELLULAR_DEVICE_DUMMY_PROPERTY
};
CellularDevice* cellular_device_new (ConnmanManager* connman);
CellularDevice* cellular_device_construct (GType object_type, ConnmanManager* connman);
static void _lambda5_ (GObject* s, GParamSpec* p, CellularDevice* self);
static void __lambda5__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
GType bluetooth_device_get_type (void) G_GNUC_CONST;
enum  {
	BLUETOOTH_DEVICE_DUMMY_PROPERTY
};
BluetoothDevice* bluetooth_device_new (ConnmanManager* connman);
BluetoothDevice* bluetooth_device_construct (GType object_type, ConnmanManager* connman);
static void _lambda6_ (GObject* s, GParamSpec* p, BluetoothDevice* self);
static void __lambda6__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
GType flight_mode_device_get_type (void) G_GNUC_CONST;
enum  {
	FLIGHT_MODE_DEVICE_DUMMY_PROPERTY
};
FlightModeDevice* flight_mode_device_new (ConnmanManager* connman);
FlightModeDevice* flight_mode_device_construct (GType object_type, ConnmanManager* connman);
static void _lambda7_ (GObject* s, GParamSpec* p, FlightModeDevice* self);
static void flight_mode_device_update_mode (FlightModeDevice* self, gboolean mode);
static void __lambda7__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);


DeviceState device_convert_state (Device* self, ConnmanTechnologyState state) {
	DeviceState result = 0;
	g_return_val_if_fail (self != NULL, 0);
	switch (state) {
		case CONNMAN_TECHNOLOGY_STATE_CONNECTED:
		{
			result = DEVICE_STATE_CONNECTED;
			return result;
		}
		case CONNMAN_TECHNOLOGY_STATE_ENABLED:
		{
			result = DEVICE_STATE_ONLINE;
			return result;
		}
		case CONNMAN_TECHNOLOGY_STATE_OFFLINE:
		{
			result = DEVICE_STATE_OFFLINE;
			return result;
		}
		default:
		case CONNMAN_TECHNOLOGY_STATE_AVAILABLE:
		{
			result = DEVICE_STATE_OFF;
			return result;
		}
	}
}


void device_update_state (Device* self, ConnmanTechnologyState state) {
	DeviceState _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = device_convert_state (self, state);
	device_set_state (self, _tmp0_);
}


Device* device_construct (GType object_type) {
	Device * self = NULL;
	self = (Device*) g_object_new (object_type, NULL);
	return self;
}


DeviceType device_get_type_ (Device* self) {
	DeviceType result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_type_;
	return result;
}


void device_set_type_ (Device* self, DeviceType value) {
	g_return_if_fail (self != NULL);
	self->priv->_type_ = value;
	g_object_notify ((GObject *) self, "type-");
}


DeviceState device_get_state (Device* self) {
	DeviceState result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_state;
	return result;
}


void device_set_state (Device* self, DeviceState value) {
	g_return_if_fail (self != NULL);
	self->priv->_state = value;
	g_object_notify ((GObject *) self, "state");
}


static void device_class_init (DeviceClass * klass) {
	device_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DevicePrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_device_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_device_set_property;
	G_OBJECT_CLASS (klass)->finalize = device_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DEVICE_TYPE_, g_param_spec_enum ("type-", "type-", "type-", TYPE_DEVICE_TYPE, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DEVICE_STATE, g_param_spec_enum ("state", "state", "state", TYPE_DEVICE_STATE, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void device_instance_init (Device * self) {
	self->priv = DEVICE_GET_PRIVATE (self);
}


static void device_finalize (GObject* obj) {
	Device * self;
	self = DEVICE (obj);
	_g_object_unref0 (self->connman);
	G_OBJECT_CLASS (device_parent_class)->finalize (obj);
}


GType device_get_type (void) {
	static volatile gsize device_type_id__volatile = 0;
	if (g_once_init_enter (&device_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DeviceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) device_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Device), 0, (GInstanceInitFunc) device_instance_init, NULL };
		GType device_type_id;
		device_type_id = g_type_register_static (G_TYPE_OBJECT, "Device", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&device_type_id__volatile, device_type_id);
	}
	return device_type_id__volatile;
}


static void _vala_device_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	Device * self;
	self = DEVICE (object);
	switch (property_id) {
		case DEVICE_TYPE_:
		g_value_set_enum (value, device_get_type_ (self));
		break;
		case DEVICE_STATE:
		g_value_set_enum (value, device_get_state (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_device_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	Device * self;
	self = DEVICE (object);
	switch (property_id) {
		case DEVICE_TYPE_:
		device_set_type_ (self, g_value_get_enum (value));
		break;
		case DEVICE_STATE:
		device_set_state (self, g_value_get_enum (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _lambda2_ (GObject* s, GParamSpec* p, WifiDevice* self) {
	ConnmanTechnologyState _tmp0_;
	g_return_if_fail (s != NULL);
	g_return_if_fail (p != NULL);
	_tmp0_ = connman_manager_get_wifi_state (((Device*) self)->connman);
	device_update_state ((Device*) self, _tmp0_);
}


static void __lambda2__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_lambda2_ (_sender, pspec, self);
}


WifiDevice* wifi_device_construct (GType object_type, ConnmanManager* connman) {
	WifiDevice * self = NULL;
	ConnmanManager* _tmp0_;
	ConnmanManager* _tmp1_;
	ConnmanTechnologyState _tmp2_;
	g_return_val_if_fail (connman != NULL, NULL);
	self = (WifiDevice*) device_construct (object_type);
	device_set_type_ ((Device*) self, DEVICE_TYPE_WIRELESS);
	_tmp0_ = _g_object_ref0 (connman);
	_tmp1_ = _tmp0_;
	_g_object_unref0 (((Device*) self)->connman);
	((Device*) self)->connman = _tmp1_;
	g_signal_connect_object ((GObject*) ((Device*) self)->connman, "notify::wifi-state", (GCallback) __lambda2__g_object_notify, self, 0);
	_tmp2_ = connman_manager_get_wifi_state (((Device*) self)->connman);
	device_update_state ((Device*) self, _tmp2_);
	return self;
}


WifiDevice* wifi_device_new (ConnmanManager* connman) {
	return wifi_device_construct (TYPE_WIFI_DEVICE, connman);
}


static void wifi_device_class_init (WifiDeviceClass * klass) {
	wifi_device_parent_class = g_type_class_peek_parent (klass);
}


static void wifi_device_instance_init (WifiDevice * self) {
}


GType wifi_device_get_type (void) {
	static volatile gsize wifi_device_type_id__volatile = 0;
	if (g_once_init_enter (&wifi_device_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (WifiDeviceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) wifi_device_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (WifiDevice), 0, (GInstanceInitFunc) wifi_device_instance_init, NULL };
		GType wifi_device_type_id;
		wifi_device_type_id = g_type_register_static (TYPE_DEVICE, "WifiDevice", &g_define_type_info, 0);
		g_once_init_leave (&wifi_device_type_id__volatile, wifi_device_type_id);
	}
	return wifi_device_type_id__volatile;
}


static void _lambda4_ (GObject* s, GParamSpec* p, EthernetDevice* self) {
	ConnmanTechnologyState _tmp0_;
	g_return_if_fail (s != NULL);
	g_return_if_fail (p != NULL);
	_tmp0_ = connman_manager_get_ethernet_state (((Device*) self)->connman);
	device_update_state ((Device*) self, _tmp0_);
}


static void __lambda4__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_lambda4_ (_sender, pspec, self);
}


EthernetDevice* ethernet_device_construct (GType object_type, ConnmanManager* connman) {
	EthernetDevice * self = NULL;
	ConnmanManager* _tmp0_;
	ConnmanManager* _tmp1_;
	ConnmanTechnologyState _tmp2_;
	g_return_val_if_fail (connman != NULL, NULL);
	self = (EthernetDevice*) device_construct (object_type);
	device_set_type_ ((Device*) self, DEVICE_TYPE_WIRED);
	_tmp0_ = _g_object_ref0 (connman);
	_tmp1_ = _tmp0_;
	_g_object_unref0 (((Device*) self)->connman);
	((Device*) self)->connman = _tmp1_;
	g_signal_connect_object ((GObject*) ((Device*) self)->connman, "notify::ethernet-state", (GCallback) __lambda4__g_object_notify, self, 0);
	_tmp2_ = connman_manager_get_ethernet_state (((Device*) self)->connman);
	device_update_state ((Device*) self, _tmp2_);
	return self;
}


EthernetDevice* ethernet_device_new (ConnmanManager* connman) {
	return ethernet_device_construct (TYPE_ETHERNET_DEVICE, connman);
}


static void ethernet_device_class_init (EthernetDeviceClass * klass) {
	ethernet_device_parent_class = g_type_class_peek_parent (klass);
}


static void ethernet_device_instance_init (EthernetDevice * self) {
}


GType ethernet_device_get_type (void) {
	static volatile gsize ethernet_device_type_id__volatile = 0;
	if (g_once_init_enter (&ethernet_device_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (EthernetDeviceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) ethernet_device_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (EthernetDevice), 0, (GInstanceInitFunc) ethernet_device_instance_init, NULL };
		GType ethernet_device_type_id;
		ethernet_device_type_id = g_type_register_static (TYPE_DEVICE, "EthernetDevice", &g_define_type_info, 0);
		g_once_init_leave (&ethernet_device_type_id__volatile, ethernet_device_type_id);
	}
	return ethernet_device_type_id__volatile;
}


static void _lambda5_ (GObject* s, GParamSpec* p, CellularDevice* self) {
	ConnmanTechnologyState _tmp0_;
	g_return_if_fail (s != NULL);
	g_return_if_fail (p != NULL);
	_tmp0_ = connman_manager_get_cellular_state (((Device*) self)->connman);
	device_update_state ((Device*) self, _tmp0_);
}


static void __lambda5__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_lambda5_ (_sender, pspec, self);
}


CellularDevice* cellular_device_construct (GType object_type, ConnmanManager* connman) {
	CellularDevice * self = NULL;
	ConnmanManager* _tmp0_;
	ConnmanManager* _tmp1_;
	ConnmanTechnologyState _tmp2_;
	g_return_val_if_fail (connman != NULL, NULL);
	self = (CellularDevice*) device_construct (object_type);
	device_set_type_ ((Device*) self, DEVICE_TYPE_MOBILE);
	_tmp0_ = _g_object_ref0 (connman);
	_tmp1_ = _tmp0_;
	_g_object_unref0 (((Device*) self)->connman);
	((Device*) self)->connman = _tmp1_;
	g_signal_connect_object ((GObject*) ((Device*) self)->connman, "notify::cellular-state", (GCallback) __lambda5__g_object_notify, self, 0);
	_tmp2_ = connman_manager_get_cellular_state (((Device*) self)->connman);
	device_update_state ((Device*) self, _tmp2_);
	return self;
}


CellularDevice* cellular_device_new (ConnmanManager* connman) {
	return cellular_device_construct (TYPE_CELLULAR_DEVICE, connman);
}


static void cellular_device_class_init (CellularDeviceClass * klass) {
	cellular_device_parent_class = g_type_class_peek_parent (klass);
}


static void cellular_device_instance_init (CellularDevice * self) {
}


GType cellular_device_get_type (void) {
	static volatile gsize cellular_device_type_id__volatile = 0;
	if (g_once_init_enter (&cellular_device_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (CellularDeviceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) cellular_device_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CellularDevice), 0, (GInstanceInitFunc) cellular_device_instance_init, NULL };
		GType cellular_device_type_id;
		cellular_device_type_id = g_type_register_static (TYPE_DEVICE, "CellularDevice", &g_define_type_info, 0);
		g_once_init_leave (&cellular_device_type_id__volatile, cellular_device_type_id);
	}
	return cellular_device_type_id__volatile;
}


static void _lambda6_ (GObject* s, GParamSpec* p, BluetoothDevice* self) {
	ConnmanTechnologyState _tmp0_;
	g_return_if_fail (s != NULL);
	g_return_if_fail (p != NULL);
	_tmp0_ = connman_manager_get_bluetooth_state (((Device*) self)->connman);
	device_update_state ((Device*) self, _tmp0_);
}


static void __lambda6__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_lambda6_ (_sender, pspec, self);
}


BluetoothDevice* bluetooth_device_construct (GType object_type, ConnmanManager* connman) {
	BluetoothDevice * self = NULL;
	ConnmanManager* _tmp0_;
	ConnmanManager* _tmp1_;
	ConnmanTechnologyState _tmp2_;
	g_return_val_if_fail (connman != NULL, NULL);
	self = (BluetoothDevice*) device_construct (object_type);
	device_set_type_ ((Device*) self, DEVICE_TYPE_BLUETOOTH);
	_tmp0_ = _g_object_ref0 (connman);
	_tmp1_ = _tmp0_;
	_g_object_unref0 (((Device*) self)->connman);
	((Device*) self)->connman = _tmp1_;
	g_signal_connect_object ((GObject*) ((Device*) self)->connman, "notify::bluetooth-state", (GCallback) __lambda6__g_object_notify, self, 0);
	_tmp2_ = connman_manager_get_bluetooth_state (((Device*) self)->connman);
	device_update_state ((Device*) self, _tmp2_);
	return self;
}


BluetoothDevice* bluetooth_device_new (ConnmanManager* connman) {
	return bluetooth_device_construct (TYPE_BLUETOOTH_DEVICE, connman);
}


static void bluetooth_device_class_init (BluetoothDeviceClass * klass) {
	bluetooth_device_parent_class = g_type_class_peek_parent (klass);
}


static void bluetooth_device_instance_init (BluetoothDevice * self) {
}


GType bluetooth_device_get_type (void) {
	static volatile gsize bluetooth_device_type_id__volatile = 0;
	if (g_once_init_enter (&bluetooth_device_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (BluetoothDeviceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) bluetooth_device_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BluetoothDevice), 0, (GInstanceInitFunc) bluetooth_device_instance_init, NULL };
		GType bluetooth_device_type_id;
		bluetooth_device_type_id = g_type_register_static (TYPE_DEVICE, "BluetoothDevice", &g_define_type_info, 0);
		g_once_init_leave (&bluetooth_device_type_id__volatile, bluetooth_device_type_id);
	}
	return bluetooth_device_type_id__volatile;
}


static void _lambda7_ (GObject* s, GParamSpec* p, FlightModeDevice* self) {
	gboolean _tmp0_;
	g_return_if_fail (s != NULL);
	g_return_if_fail (p != NULL);
	_tmp0_ = connman_manager_get_offline_mode (((Device*) self)->connman);
	flight_mode_device_update_mode (self, _tmp0_);
}


static void __lambda7__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_lambda7_ (_sender, pspec, self);
}


FlightModeDevice* flight_mode_device_construct (GType object_type, ConnmanManager* connman) {
	FlightModeDevice * self = NULL;
	ConnmanManager* _tmp0_;
	ConnmanManager* _tmp1_;
	gboolean _tmp2_;
	g_return_val_if_fail (connman != NULL, NULL);
	self = (FlightModeDevice*) device_construct (object_type);
	device_set_type_ ((Device*) self, DEVICE_TYPE_FLIGHTMODE);
	_tmp0_ = _g_object_ref0 (connman);
	_tmp1_ = _tmp0_;
	_g_object_unref0 (((Device*) self)->connman);
	((Device*) self)->connman = _tmp1_;
	g_signal_connect_object ((GObject*) ((Device*) self)->connman, "notify::offline-mode", (GCallback) __lambda7__g_object_notify, self, 0);
	_tmp2_ = connman_manager_get_offline_mode (((Device*) self)->connman);
	flight_mode_device_update_mode (self, _tmp2_);
	return self;
}


FlightModeDevice* flight_mode_device_new (ConnmanManager* connman) {
	return flight_mode_device_construct (TYPE_FLIGHT_MODE_DEVICE, connman);
}


static void flight_mode_device_update_mode (FlightModeDevice* self, gboolean mode) {
	g_return_if_fail (self != NULL);
	if (mode) {
		device_set_state ((Device*) self, DEVICE_STATE_OFFLINE);
	} else {
		device_set_state ((Device*) self, DEVICE_STATE_ONLINE);
	}
}


static void flight_mode_device_class_init (FlightModeDeviceClass * klass) {
	flight_mode_device_parent_class = g_type_class_peek_parent (klass);
}


static void flight_mode_device_instance_init (FlightModeDevice * self) {
}


GType flight_mode_device_get_type (void) {
	static volatile gsize flight_mode_device_type_id__volatile = 0;
	if (g_once_init_enter (&flight_mode_device_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FlightModeDeviceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) flight_mode_device_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FlightModeDevice), 0, (GInstanceInitFunc) flight_mode_device_instance_init, NULL };
		GType flight_mode_device_type_id;
		flight_mode_device_type_id = g_type_register_static (TYPE_DEVICE, "FlightModeDevice", &g_define_type_info, 0);
		g_once_init_leave (&flight_mode_device_type_id__volatile, flight_mode_device_type_id);
	}
	return flight_mode_device_type_id__volatile;
}



