/*
 * indicator-network - user interface for connman
 * Copyright 2010-2011 Canonical Ltd.
 *
 * Authors:
 * Andrew Higginson
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 3, as published
 * by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranties of
 * MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

public enum DeviceType {
    WIRED,
    WIRELESS,
    BLUETOOTH,
    MOBILE,
    FLIGHTMODE,
    GENERIC; // Shouldn't be used manually
    
    public string get_name() {
        switch (this) {
            case WIRED:
                return ("Wired");
            case WIRELESS:
                return ("Wireless");
            case BLUETOOTH:
                return ("Bluetooth");
            case MOBILE:
                return ("Mobile Broadband");
            case FLIGHTMODE:
                return ("Flight Mode");
            case GENERIC:
                return ("Wired");
            default:
                assert_not_reached();
        }
    }
    
    public string get_lname() {
        switch (this) {
            case WIRED:
                return "wired";
            case WIRELESS:
                return "wireless";
            case BLUETOOTH:
                return "bluetooth";
            case MOBILE:
                return "mobile";
            case FLIGHTMODE:
                return "flightmode";
            default:
                assert_not_reached();
        }
    }
    
    public string get_icon_name() {
        switch (this) {
            case WIRED:
                return "network-wired";
            case WIRELESS:
                return "network-wireless";
            case BLUETOOTH:
                return "bluetooth-active";
            case MOBILE:
                return "gsm-3g-high";
            case FLIGHTMODE:
                return "flightmode";
            case GENERIC:
                return "network-wired";
            default:
                assert_not_reached();
        }
    }
}

public enum DeviceState {
    OFF,
    OFFLINE,
    CONNECTED,
    ONLINE;

    public string get_name() {
        switch (this) {
            case OFF:
                return ("Off");
            case OFFLINE:
                return ("Offline");
            case CONNECTED:
                return ("Connected");
            case ONLINE:
                return ("Online");
            default:
             assert_not_reached();
            }
    }
}

public enum WirelessMode {
    INFRASTRUCTURE,
    ADHOC;
    
    public string get_name() {
        switch (this) {
            case INFRASTRUCTURE:
                return ("Infrastructure");
            case ADHOC:
                return ("Ad-hoc");
            default:
             assert_not_reached();
            }
    }
    
}
