/* stores.c generated by valac 0.11.6, the Vala compiler
 * generated from stores.vala, do not modify */

/*
 * indicator-network - user interface for connman
 * Copyright 2010-2011 Canonical Ltd.
 *
 * Authors:
 * Andrew Higginson
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 3, as published
 * by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranties of
 * MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <gdk-pixbuf/gdk-pixdata.h>
#include <connman-service.h>
#include <float.h>
#include <math.h>


#define TYPE_DEVICE_STORE_COL (device_store_col_get_type ())

#define TYPE_DEVICE_STORE (device_store_get_type ())
#define DEVICE_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DEVICE_STORE, DeviceStore))
#define DEVICE_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DEVICE_STORE, DeviceStoreClass))
#define IS_DEVICE_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DEVICE_STORE))
#define IS_DEVICE_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DEVICE_STORE))
#define DEVICE_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DEVICE_STORE, DeviceStoreClass))

typedef struct _DeviceStore DeviceStore;
typedef struct _DeviceStoreClass DeviceStoreClass;
typedef struct _DeviceStorePrivate DeviceStorePrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) ((var == NULL) ? NULL : (var = (g_free (var), NULL)))

#define TYPE_DEVICE (device_get_type ())
#define DEVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DEVICE, Device))
#define DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DEVICE, DeviceClass))
#define IS_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DEVICE))
#define IS_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DEVICE))
#define DEVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DEVICE, DeviceClass))

typedef struct _Device Device;
typedef struct _DeviceClass DeviceClass;

#define TYPE_DEVICE_STATE (device_state_get_type ())

#define TYPE_DEVICE_TYPE (device_type_get_type ())

#define TYPE_LOGGER (logger_get_type ())
#define LOGGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LOGGER, Logger))
#define LOGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LOGGER, LoggerClass))
#define IS_LOGGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LOGGER))
#define IS_LOGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LOGGER))
#define LOGGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LOGGER, LoggerClass))

typedef struct _Logger Logger;
typedef struct _LoggerClass LoggerClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block2Data Block2Data;

#define TYPE_WIRELESS_CONNECTION_STORE_COL (wireless_connection_store_col_get_type ())

#define TYPE_WIRELESS_CONNECTION_STORE (wireless_connection_store_get_type ())
#define WIRELESS_CONNECTION_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_WIRELESS_CONNECTION_STORE, WirelessConnectionStore))
#define WIRELESS_CONNECTION_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_WIRELESS_CONNECTION_STORE, WirelessConnectionStoreClass))
#define IS_WIRELESS_CONNECTION_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_WIRELESS_CONNECTION_STORE))
#define IS_WIRELESS_CONNECTION_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_WIRELESS_CONNECTION_STORE))
#define WIRELESS_CONNECTION_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_WIRELESS_CONNECTION_STORE, WirelessConnectionStoreClass))

typedef struct _WirelessConnectionStore WirelessConnectionStore;
typedef struct _WirelessConnectionStoreClass WirelessConnectionStoreClass;
typedef struct _WirelessConnectionStorePrivate WirelessConnectionStorePrivate;

typedef enum  {
	DEVICE_STORE_COL_DEVICE_OBJ,
	DEVICE_STORE_COL_SETTINGS_BOX,
	DEVICE_STORE_COL_PIN,
	DEVICE_STORE_COL_ICON,
	DEVICE_STORE_COL_LABEL
} DeviceStoreCol;

struct _DeviceStore {
	GtkListStore parent_instance;
	DeviceStorePrivate * priv;
};

struct _DeviceStoreClass {
	GtkListStoreClass parent_class;
};

struct _DeviceStorePrivate {
	GtkIconTheme* icons;
	GtkTreeIter* device_iter;
};

typedef enum  {
	DEVICE_STATE_OFF,
	DEVICE_STATE_OFFLINE,
	DEVICE_STATE_CONNECTED,
	DEVICE_STATE_ONLINE
} DeviceState;

typedef enum  {
	DEVICE_TYPE_WIRED,
	DEVICE_TYPE_WIRELESS,
	DEVICE_TYPE_BLUETOOTH,
	DEVICE_TYPE_MOBILE,
	DEVICE_TYPE_FLIGHTMODE,
	DEVICE_TYPE_GENERIC
} DeviceType;

struct _Block2Data {
	int _ref_count_;
	DeviceStore * self;
	Device* device;
};

typedef enum  {
	WIRELESS_CONNECTION_STORE_COL_CONNECTION_OBJ,
	WIRELESS_CONNECTION_STORE_COL_NETWORK,
	WIRELESS_CONNECTION_STORE_COL_SIGNAL,
	WIRELESS_CONNECTION_STORE_COL_LAST_USED
} WirelessConnectionStoreCol;

struct _WirelessConnectionStore {
	GtkListStore parent_instance;
	WirelessConnectionStorePrivate * priv;
};

struct _WirelessConnectionStoreClass {
	GtkListStoreClass parent_class;
};


static gpointer device_store_parent_class = NULL;
extern Logger* logger;
static gpointer wireless_connection_store_parent_class = NULL;

GType device_store_col_get_type (void) G_GNUC_CONST;
GType device_store_get_type (void) G_GNUC_CONST;
#define DEVICE_STORE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_DEVICE_STORE, DeviceStorePrivate))
enum  {
	DEVICE_STORE_DUMMY_PROPERTY
};
DeviceStore* device_store_new (GtkIconTheme* icons);
DeviceStore* device_store_construct (GType object_type, GtkIconTheme* icons);
GType device_get_type (void) G_GNUC_CONST;
void device_store_add_device (DeviceStore* self, Device* device, GtkVBox* settings_box);
static void device_store_on_device_state_changed (DeviceStore* self, GObject* object, GParamSpec* p);
static void _device_store_on_device_state_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
GType device_state_get_type (void) G_GNUC_CONST;
static gchar* device_store_get_pin_color (DeviceStore* self, DeviceState state);
DeviceState device_get_state (Device* self);
gchar* device_state_get_name (DeviceState self);
GType device_type_get_type (void) G_GNUC_CONST;
DeviceType device_get_type_ (Device* self);
gchar* device_type_get_name (DeviceType self);
gchar* device_type_get_icon_name (DeviceType self);
static gchar* device_store_get_markup (DeviceStore* self, const gchar* label, const gchar* caption);
GType logger_get_type (void) G_GNUC_CONST;
void logger_debug (Logger* self, const gchar* text);
void logger_info (Logger* self, const gchar* text);
static void device_store_get_iter_for_device (DeviceStore* self, Device* device, GtkTreeIter* result);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (Block2Data* _data2_);
static gboolean _lambda0_ (GtkTreeModel* model, GtkTreePath* path, GtkTreeIter* iter, Block2Data* _data2_);
static GtkTreeIter* _gtk_tree_iter_dup (GtkTreeIter* self);
static gboolean __lambda0__gtk_tree_model_foreach_func (GtkTreeModel* model, GtkTreePath* path, GtkTreeIter* iter, gpointer self);
static void device_store_finalize (GObject* obj);
GType wireless_connection_store_col_get_type (void) G_GNUC_CONST;
GType wireless_connection_store_get_type (void) G_GNUC_CONST;
enum  {
	WIRELESS_CONNECTION_STORE_DUMMY_PROPERTY
};
WirelessConnectionStore* wireless_connection_store_new (void);
WirelessConnectionStore* wireless_connection_store_construct (GType object_type);
void wireless_connection_store_add_service (WirelessConnectionStore* self, ConnmanService* service, const gchar* network, gdouble signal, const gchar* last_used);


GType device_store_col_get_type (void) {
	static volatile gsize device_store_col_type_id__volatile = 0;
	if (g_once_init_enter (&device_store_col_type_id__volatile)) {
		static const GEnumValue values[] = {{DEVICE_STORE_COL_DEVICE_OBJ, "DEVICE_STORE_COL_DEVICE_OBJ", "device-obj"}, {DEVICE_STORE_COL_SETTINGS_BOX, "DEVICE_STORE_COL_SETTINGS_BOX", "settings-box"}, {DEVICE_STORE_COL_PIN, "DEVICE_STORE_COL_PIN", "pin"}, {DEVICE_STORE_COL_ICON, "DEVICE_STORE_COL_ICON", "icon"}, {DEVICE_STORE_COL_LABEL, "DEVICE_STORE_COL_LABEL", "label"}, {0, NULL, NULL}};
		GType device_store_col_type_id;
		device_store_col_type_id = g_enum_register_static ("DeviceStoreCol", values);
		g_once_init_leave (&device_store_col_type_id__volatile, device_store_col_type_id);
	}
	return device_store_col_type_id__volatile;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


DeviceStore* device_store_construct (GType object_type, GtkIconTheme* icons) {
	DeviceStore * self = NULL;
	GType* column_types = NULL;
	gint column_types_length1 = 0;
	gint _column_types_size_ = 0;
	GType* _tmp0_ = NULL;
	GType* _tmp1_;
	GtkIconTheme* _tmp2_;
	GtkIconTheme* _tmp3_;
	g_return_val_if_fail (icons != NULL, NULL);
	self = (DeviceStore*) g_object_new (object_type, NULL);
	_tmp0_ = g_new0 (GType, 5);
	_tmp0_[0] = TYPE_DEVICE;
	_tmp0_[1] = GTK_TYPE_VBOX;
	_tmp0_[2] = G_TYPE_STRING;
	_tmp0_[3] = GDK_TYPE_PIXBUF;
	_tmp0_[4] = G_TYPE_STRING;
	_tmp1_ = _tmp0_;
	column_types = (g_free (column_types), NULL);
	column_types_length1 = 5;
	_column_types_size_ = column_types_length1;
	column_types = _tmp1_;
	gtk_list_store_set_column_types ((GtkListStore*) self, column_types_length1, column_types);
	_tmp2_ = _g_object_ref0 (icons);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (self->priv->icons);
	self->priv->icons = _tmp3_;
	column_types = (g_free (column_types), NULL);
	return self;
}


DeviceStore* device_store_new (GtkIconTheme* icons) {
	return device_store_construct (TYPE_DEVICE_STORE, icons);
}


static void _device_store_on_device_state_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	device_store_on_device_state_changed (self, _sender, pspec);
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


void device_store_add_device (DeviceStore* self, Device* device, GtkVBox* settings_box) {
	DeviceState _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* pin_color;
	DeviceState _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* caption;
	DeviceType _tmp4_;
	gchar* _tmp5_ = NULL;
	gchar* label;
	DeviceType _tmp6_;
	gchar* _tmp7_ = NULL;
	gchar* icon;
	gchar* _tmp8_ = NULL;
	gchar* markup;
	GdkPixbuf* icon_pixbuf;
	GdkPixbuf* _tmp9_ = NULL;
	GdkPixbuf* _tmp10_;
	GdkPixbuf* _tmp11_;
	GtkTreeIter iter = {0};
	GtkTreeIter _tmp20_ = {0};
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (device != NULL);
	g_return_if_fail (settings_box != NULL);
	g_signal_connect_object ((GObject*) device, "notify::state", (GCallback) _device_store_on_device_state_changed_g_object_notify, self, 0);
	_tmp0_ = device_get_state (device);
	_tmp1_ = device_store_get_pin_color (self, _tmp0_);
	pin_color = _tmp1_;
	_tmp2_ = device_get_state (device);
	_tmp3_ = device_state_get_name (_tmp2_);
	caption = _tmp3_;
	_tmp4_ = device_get_type_ (device);
	_tmp5_ = device_type_get_name (_tmp4_);
	label = _tmp5_;
	_tmp6_ = device_get_type_ (device);
	_tmp7_ = device_type_get_icon_name (_tmp6_);
	icon = _tmp7_;
	_tmp8_ = device_store_get_markup (self, label, caption);
	markup = _tmp8_;
	icon_pixbuf = NULL;
	_tmp9_ = gtk_icon_theme_load_icon (self->priv->icons, icon, 22, GTK_ICON_LOOKUP_USE_BUILTIN, &_inner_error_);
	_tmp10_ = _tmp9_;
	if (_inner_error_ != NULL) {
		goto __catch2_g_error;
	}
	_tmp11_ = _tmp10_;
	_g_object_unref0 (icon_pixbuf);
	icon_pixbuf = _tmp11_;
	goto __finally2;
	__catch2_g_error:
	{
		GError * e;
		gchar* _tmp12_ = NULL;
		gchar* fallback_icon;
		const gchar* _tmp13_ = NULL;
		const gchar* _tmp14_ = NULL;
		gchar* _tmp15_ = NULL;
		gchar* _tmp16_;
		GdkPixbuf* _tmp17_ = NULL;
		GdkPixbuf* _tmp18_;
		GdkPixbuf* _tmp19_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp12_ = device_type_get_icon_name (DEVICE_TYPE_GENERIC);
		fallback_icon = _tmp12_;
		_tmp13_ = string_to_string (icon);
		_tmp14_ = string_to_string (fallback_icon);
		_tmp15_ = g_strconcat ("Can't find '", _tmp13_, "' icon in your Gtk IconTheme, using '", _tmp14_, "' instead.", NULL);
		_tmp16_ = _tmp15_;
		logger_debug (logger, _tmp16_);
		_g_free0 (_tmp16_);
		_tmp17_ = gtk_icon_theme_load_icon (self->priv->icons, fallback_icon, 22, GTK_ICON_LOOKUP_USE_BUILTIN, &_inner_error_);
		_tmp18_ = _tmp17_;
		if (_inner_error_ != NULL) {
			goto __catch3_g_error;
		}
		_tmp19_ = _tmp18_;
		_g_object_unref0 (icon_pixbuf);
		icon_pixbuf = _tmp19_;
		goto __finally3;
		__catch3_g_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			logger_info (logger, "Failed to load fallback icon.");
			_g_error_free0 (e);
		}
		__finally3:
		if (_inner_error_ != NULL) {
			_g_free0 (fallback_icon);
			_g_error_free0 (e);
			_g_free0 (fallback_icon);
			_g_error_free0 (e);
			_g_object_unref0 (icon_pixbuf);
			_g_free0 (markup);
			_g_free0 (icon);
			_g_free0 (label);
			_g_free0 (caption);
			_g_free0 (pin_color);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_g_free0 (fallback_icon);
		_g_error_free0 (e);
	}
	__finally2:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (icon_pixbuf);
		_g_free0 (markup);
		_g_free0 (icon);
		_g_free0 (label);
		_g_free0 (caption);
		_g_free0 (pin_color);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	gtk_list_store_append ((GtkListStore*) self, &_tmp20_);
	iter = _tmp20_;
	gtk_list_store_set ((GtkListStore*) self, &iter, 0, device, 1, settings_box, 2, pin_color, 3, icon_pixbuf, 4, markup, -1);
	_g_object_unref0 (icon_pixbuf);
	_g_free0 (markup);
	_g_free0 (icon);
	_g_free0 (label);
	_g_free0 (caption);
	_g_free0 (pin_color);
}


static void device_store_on_device_state_changed (DeviceStore* self, GObject* object, GParamSpec* p) {
	GObject* _tmp0_;
	Device* _tmp1_;
	Device* device;
	GtkTreeIter _tmp2_ = {0};
	GtkTreeIter _tmp3_ = {0};
	GtkTreeIter iter;
	DeviceState _tmp4_;
	gchar* _tmp5_ = NULL;
	gchar* pin_color;
	DeviceState _tmp6_;
	gchar* _tmp7_ = NULL;
	gchar* caption;
	DeviceType _tmp8_;
	gchar* _tmp9_ = NULL;
	gchar* label;
	gchar* _tmp10_ = NULL;
	gchar* markup;
	GValue _tmp11_ = {0};
	GValue _tmp12_ = {0};
	g_return_if_fail (self != NULL);
	g_return_if_fail (object != NULL);
	g_return_if_fail (p != NULL);
	_tmp1_ = _g_object_ref0 ((_tmp0_ = object, IS_DEVICE (_tmp0_) ? ((Device*) _tmp0_) : NULL));
	device = _tmp1_;
	_tmp3_ = (device_store_get_iter_for_device (self, device, &_tmp2_), _tmp2_);
	iter = _tmp3_;
	_tmp4_ = device_get_state (device);
	_tmp5_ = device_store_get_pin_color (self, _tmp4_);
	pin_color = _tmp5_;
	_tmp6_ = device_get_state (device);
	_tmp7_ = device_state_get_name (_tmp6_);
	caption = _tmp7_;
	_tmp8_ = device_get_type_ (device);
	_tmp9_ = device_type_get_name (_tmp8_);
	label = _tmp9_;
	_tmp10_ = device_store_get_markup (self, label, caption);
	markup = _tmp10_;
	g_value_init (&_tmp11_, G_TYPE_STRING);
	g_value_set_string (&_tmp11_, pin_color);
	gtk_list_store_set_value ((GtkListStore*) self, &iter, (gint) DEVICE_STORE_COL_PIN, &_tmp11_);
	G_IS_VALUE (&_tmp11_) ? (g_value_unset (&_tmp11_), NULL) : NULL;
	g_value_init (&_tmp12_, G_TYPE_STRING);
	g_value_set_string (&_tmp12_, markup);
	gtk_list_store_set_value ((GtkListStore*) self, &iter, (gint) DEVICE_STORE_COL_LABEL, &_tmp12_);
	G_IS_VALUE (&_tmp12_) ? (g_value_unset (&_tmp12_), NULL) : NULL;
	_g_free0 (markup);
	_g_free0 (label);
	_g_free0 (caption);
	_g_free0 (pin_color);
	_g_object_unref0 (device);
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}


static void block2_data_unref (Block2Data* _data2_) {
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		_g_object_unref0 (_data2_->self);
		_g_object_unref0 (_data2_->device);
		g_slice_free (Block2Data, _data2_);
	}
}


static GtkTreeIter* _gtk_tree_iter_dup (GtkTreeIter* self) {
	GtkTreeIter* dup;
	dup = g_new0 (GtkTreeIter, 1);
	memcpy (dup, self, sizeof (GtkTreeIter));
	return dup;
}


static gpointer __gtk_tree_iter_dup0 (gpointer self) {
	return self ? _gtk_tree_iter_dup (self) : NULL;
}


static gboolean _lambda0_ (GtkTreeModel* model, GtkTreePath* path, GtkTreeIter* iter, Block2Data* _data2_) {
	DeviceStore * self;
	gboolean result = FALSE;
	GValue value = {0};
	GValue _tmp0_ = {0};
	GObject* _tmp1_ = NULL;
	GObject* _tmp2_;
	self = _data2_->self;
	g_return_val_if_fail (model != NULL, FALSE);
	g_return_val_if_fail (path != NULL, FALSE);
	gtk_tree_model_get_value (model, iter, (gint) DEVICE_STORE_COL_DEVICE_OBJ, &_tmp0_);
	G_IS_VALUE (&value) ? (g_value_unset (&value), NULL) : NULL;
	value = _tmp0_;
	_tmp1_ = g_value_get_object (&value);
	if ((_tmp2_ = _tmp1_, IS_DEVICE (_tmp2_) ? ((Device*) _tmp2_) : NULL) == _data2_->device) {
		GtkTreeIter* _tmp3_;
		GtkTreeIter* _tmp4_;
		_tmp3_ = __gtk_tree_iter_dup0 (iter);
		_tmp4_ = _tmp3_;
		_g_free0 (self->priv->device_iter);
		self->priv->device_iter = _tmp4_;
		result = TRUE;
		G_IS_VALUE (&value) ? (g_value_unset (&value), NULL) : NULL;
		return result;
	}
	result = FALSE;
	G_IS_VALUE (&value) ? (g_value_unset (&value), NULL) : NULL;
	return result;
}


static gboolean __lambda0__gtk_tree_model_foreach_func (GtkTreeModel* model, GtkTreePath* path, GtkTreeIter* iter, gpointer self) {
	gboolean result;
	result = _lambda0_ (model, path, iter, self);
	return result;
}


static void device_store_get_iter_for_device (DeviceStore* self, Device* device, GtkTreeIter* result) {
	Block2Data* _data2_;
	GtkTreeIter* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (device != NULL);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->self = g_object_ref (self);
	_data2_->device = _g_object_ref0 (device);
	_tmp0_ = NULL;
	_g_free0 (self->priv->device_iter);
	self->priv->device_iter = _tmp0_;
	gtk_tree_model_foreach ((GtkTreeModel*) self, __lambda0__gtk_tree_model_foreach_func, _data2_);
	*result = *self->priv->device_iter;
	block2_data_unref (_data2_);
	_data2_ = NULL;
	return;
}


static gchar* device_store_get_pin_color (DeviceStore* self, DeviceState state) {
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	switch (state) {
		case DEVICE_STATE_OFF:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup ("grey");
			result = _tmp0_;
			return result;
		}
		case DEVICE_STATE_OFFLINE:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup ("red");
			result = _tmp1_;
			return result;
		}
		case DEVICE_STATE_CONNECTED:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup ("yellow");
			result = _tmp2_;
			return result;
		}
		case DEVICE_STATE_ONLINE:
		{
			gchar* _tmp3_;
			_tmp3_ = g_strdup ("green");
			result = _tmp3_;
			return result;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}


static gchar* device_store_get_markup (DeviceStore* self, const gchar* label, const gchar* caption) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (label != NULL, NULL);
	g_return_val_if_fail (caption != NULL, NULL);
	_tmp0_ = string_to_string (label);
	_tmp1_ = string_to_string (caption);
	_tmp2_ = g_strconcat (_tmp0_, "\n<span font_size='small'>", _tmp1_, "</span>", NULL);
	result = _tmp2_;
	return result;
}


static void device_store_class_init (DeviceStoreClass * klass) {
	device_store_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DeviceStorePrivate));
	G_OBJECT_CLASS (klass)->finalize = device_store_finalize;
}


static void device_store_instance_init (DeviceStore * self) {
	self->priv = DEVICE_STORE_GET_PRIVATE (self);
}


static void device_store_finalize (GObject* obj) {
	DeviceStore * self;
	self = DEVICE_STORE (obj);
	_g_object_unref0 (self->priv->icons);
	_g_free0 (self->priv->device_iter);
	G_OBJECT_CLASS (device_store_parent_class)->finalize (obj);
}


GType device_store_get_type (void) {
	static volatile gsize device_store_type_id__volatile = 0;
	if (g_once_init_enter (&device_store_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DeviceStoreClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) device_store_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DeviceStore), 0, (GInstanceInitFunc) device_store_instance_init, NULL };
		GType device_store_type_id;
		device_store_type_id = g_type_register_static (GTK_TYPE_LIST_STORE, "DeviceStore", &g_define_type_info, 0);
		g_once_init_leave (&device_store_type_id__volatile, device_store_type_id);
	}
	return device_store_type_id__volatile;
}


GType wireless_connection_store_col_get_type (void) {
	static volatile gsize wireless_connection_store_col_type_id__volatile = 0;
	if (g_once_init_enter (&wireless_connection_store_col_type_id__volatile)) {
		static const GEnumValue values[] = {{WIRELESS_CONNECTION_STORE_COL_CONNECTION_OBJ, "WIRELESS_CONNECTION_STORE_COL_CONNECTION_OBJ", "connection-obj"}, {WIRELESS_CONNECTION_STORE_COL_NETWORK, "WIRELESS_CONNECTION_STORE_COL_NETWORK", "network"}, {WIRELESS_CONNECTION_STORE_COL_SIGNAL, "WIRELESS_CONNECTION_STORE_COL_SIGNAL", "signal"}, {WIRELESS_CONNECTION_STORE_COL_LAST_USED, "WIRELESS_CONNECTION_STORE_COL_LAST_USED", "last-used"}, {0, NULL, NULL}};
		GType wireless_connection_store_col_type_id;
		wireless_connection_store_col_type_id = g_enum_register_static ("WirelessConnectionStoreCol", values);
		g_once_init_leave (&wireless_connection_store_col_type_id__volatile, wireless_connection_store_col_type_id);
	}
	return wireless_connection_store_col_type_id__volatile;
}


WirelessConnectionStore* wireless_connection_store_construct (GType object_type) {
	WirelessConnectionStore * self = NULL;
	GType* column_types = NULL;
	gint column_types_length1 = 0;
	gint _column_types_size_ = 0;
	GType* _tmp0_ = NULL;
	GType* _tmp1_;
	self = (WirelessConnectionStore*) g_object_new (object_type, NULL);
	_tmp0_ = g_new0 (GType, 4);
	_tmp0_[0] = CONNMAN_TYPE_SERVICE;
	_tmp0_[1] = G_TYPE_STRING;
	_tmp0_[2] = G_TYPE_DOUBLE;
	_tmp0_[3] = G_TYPE_STRING;
	_tmp1_ = _tmp0_;
	column_types = (g_free (column_types), NULL);
	column_types_length1 = 4;
	_column_types_size_ = column_types_length1;
	column_types = _tmp1_;
	gtk_list_store_set_column_types ((GtkListStore*) self, column_types_length1, column_types);
	column_types = (g_free (column_types), NULL);
	return self;
}


WirelessConnectionStore* wireless_connection_store_new (void) {
	return wireless_connection_store_construct (TYPE_WIRELESS_CONNECTION_STORE);
}


void wireless_connection_store_add_service (WirelessConnectionStore* self, ConnmanService* service, const gchar* network, gdouble signal, const gchar* last_used) {
	GtkTreeIter iter = {0};
	GtkTreeIter _tmp0_ = {0};
	g_return_if_fail (self != NULL);
	g_return_if_fail (service != NULL);
	g_return_if_fail (network != NULL);
	g_return_if_fail (last_used != NULL);
	gtk_list_store_append ((GtkListStore*) self, &_tmp0_);
	iter = _tmp0_;
	gtk_list_store_set ((GtkListStore*) self, &iter, 0, service, 1, network, 2, signal, 3, last_used, -1);
}


static void wireless_connection_store_class_init (WirelessConnectionStoreClass * klass) {
	wireless_connection_store_parent_class = g_type_class_peek_parent (klass);
}


static void wireless_connection_store_instance_init (WirelessConnectionStore * self) {
}


GType wireless_connection_store_get_type (void) {
	static volatile gsize wireless_connection_store_type_id__volatile = 0;
	if (g_once_init_enter (&wireless_connection_store_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (WirelessConnectionStoreClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) wireless_connection_store_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (WirelessConnectionStore), 0, (GInstanceInitFunc) wireless_connection_store_instance_init, NULL };
		GType wireless_connection_store_type_id;
		wireless_connection_store_type_id = g_type_register_static (GTK_TYPE_LIST_STORE, "WirelessConnectionStore", &g_define_type_info, 0);
		g_once_init_leave (&wireless_connection_store_type_id__volatile, wireless_connection_store_type_id);
	}
	return wireless_connection_store_type_id__volatile;
}



