/*
 * indicator-network - user interface for connman
 *
 * Copyright 2010 Canonical Ltd.
 *
 * Authors:
 * Kalle Valo <kalle.valo@canonical.com>
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 3, as published
 * by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranties of
 * MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>

#include "service-manager.h"

#define DOMAIN "/Network/Backend/NetworkMenu"

/* stubs */

Service *service_new(ConnmanService *service, Manager *ns)
{
  return NULL;
}

const gchar *service_get_path(Service *self)
{
  return "";
}

ConnmanServiceType service_get_service_type(Service *self)
{
  return CONNMAN_SERVICE_TYPE_ETHERNET;
}

ConnmanServiceState service_get_state(Service *self)
{
  return 0;
}

gint service_get_strength(Service *self)
{
  return 0;
}

/* tests */

static NetworkMenu *menu;

static void test_new(void)
{
  Manager *manager = manager_new();

  g_assert(IS_MANAGER(manager));

  menu = network_menu_new(manager);

  g_assert(menu != NULL);
}

gint main (gint argc, gchar *argv[])
{
  g_type_init();

  g_test_init(&argc, &argv, NULL);

  g_test_add_func(DOMAIN "/New", test_new);

  return g_test_run();
}

