L.Transition = L.Class.extend({
	includes: L.Mixin.Events,
	
	statics: {
		CUSTOM_PROPS_SETTERS: {
			position: L.DomUtil.setPosition
			//TODO transform custom attr
		},
		
		implemented: function() {
			return L.Transition.NATIVE || L.Transition.TIMER;
		}
	},
	
	options: {
		easing: 'ease',
		duration: 0.5
	},
	
	_setProperty: function(prop, value) {
		var setters = L.Transition.CUSTOM_PROPS_SETTERS;
		if (prop in setters) {
			setters[prop](this._el, value);
		} else {
			this._el.style[prop] = value;
		}
	}
});