/* kkc.c generated by valac 0.24.0.131-42e78, the Vala compiler
 * generated from kkc.vala, do not modify */

/*
 * Copyright (C) 2012-2014 Daiki Ueno <ueno@gnu.org>
 * Copyright (C) 2012-2014 Red Hat, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <glib/gi18n-lib.h>
#include <locale.h>
#include <config.h>
#include <libkkc/libkkc.h>

#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_option_group_free0(var) ((var == NULL) ? NULL : (var = (g_option_group_free (var), NULL)))

#define TYPE_REPL (repl_get_type ())
#define REPL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_REPL, Repl))
#define IS_REPL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_REPL))
#define REPL_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_REPL, ReplIface))

typedef struct _Repl Repl;
typedef struct _ReplIface ReplIface;

#define TYPE_DECODER_REPL (decoder_repl_get_type ())
#define DECODER_REPL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DECODER_REPL, DecoderRepl))
#define DECODER_REPL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DECODER_REPL, DecoderReplClass))
#define IS_DECODER_REPL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DECODER_REPL))
#define IS_DECODER_REPL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DECODER_REPL))
#define DECODER_REPL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DECODER_REPL, DecoderReplClass))

typedef struct _DecoderRepl DecoderRepl;
typedef struct _DecoderReplClass DecoderReplClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_CONTEXT_REPL (context_repl_get_type ())
#define CONTEXT_REPL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONTEXT_REPL, ContextRepl))
#define CONTEXT_REPL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CONTEXT_REPL, ContextReplClass))
#define IS_CONTEXT_REPL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONTEXT_REPL))
#define IS_CONTEXT_REPL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CONTEXT_REPL))
#define CONTEXT_REPL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CONTEXT_REPL, ContextReplClass))

typedef struct _ContextRepl ContextRepl;
typedef struct _ContextReplClass ContextReplClass;
typedef struct _DecoderReplPrivate DecoderReplPrivate;
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
typedef struct _ContextReplPrivate ContextReplPrivate;

struct _ReplIface {
	GTypeInterface parent_iface;
	gboolean (*parse_arguments) (Repl* self, gchar** args, int args_length1, GError** error);
	gboolean (*run) (Repl* self, GError** error);
};

struct _DecoderRepl {
	GObject parent_instance;
	DecoderReplPrivate * priv;
};

struct _DecoderReplClass {
	GObjectClass parent_class;
};

struct _ContextRepl {
	GObject parent_instance;
	ContextReplPrivate * priv;
};

struct _ContextReplClass {
	GObjectClass parent_class;
};


extern gchar* opt_model;
gchar* opt_model = NULL;
extern gchar* opt_system_dictionary;
gchar* opt_system_dictionary = NULL;
extern gchar* opt_user_dictionary;
gchar* opt_user_dictionary = NULL;
extern gchar* opt_typing_rule;
gchar* opt_typing_rule = NULL;
extern GOptionGroup* model_group;
GOptionGroup* model_group = NULL;
static gpointer decoder_repl_parent_class = NULL;
static ReplIface* decoder_repl_repl_parent_iface = NULL;
static gpointer context_repl_parent_class = NULL;
static ReplIface* context_repl_repl_parent_iface = NULL;

void usage (gchar** args, int args_length1, FILE* output);
gint _vala_main (gchar** args, int args_length1);
static gchar** _vala_array_dup1 (gchar** self, int length);
static void _vala_array_add1 (gchar*** array, int* length, int* size, gchar* value);
GType repl_get_type (void) G_GNUC_CONST;
DecoderRepl* decoder_repl_new (void);
DecoderRepl* decoder_repl_construct (GType object_type);
GType decoder_repl_get_type (void) G_GNUC_CONST;
ContextRepl* context_repl_new (void);
ContextRepl* context_repl_construct (GType object_type);
GType context_repl_get_type (void) G_GNUC_CONST;
gboolean repl_parse_arguments (Repl* self, gchar** args, int args_length1, GError** error);
gboolean repl_run (Repl* self, GError** error);
enum  {
	DECODER_REPL_DUMMY_PROPERTY
};
static gboolean decoder_repl_real_parse_arguments (Repl* base, gchar** args, int args_length1, GError** error);
static gboolean decoder_repl_real_run (Repl* base, GError** error);
enum  {
	CONTEXT_REPL_DUMMY_PROPERTY
};
static gboolean context_repl_real_parse_arguments (Repl* base, gchar** args, int args_length1, GError** error);
static gboolean context_repl_real_run (Repl* base, GError** error);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

const GOptionEntry model_entries[2] = {{"model", 'm', 0, G_OPTION_ARG_STRING, &opt_model, "Language model", NULL}, {NULL}};
const GOptionEntry decoder_entries[1] = {{NULL}};
const GOptionEntry context_entries[4] = {{"system-dictionary", 's', 0, G_OPTION_ARG_STRING, &opt_system_dictionary, "Path to a system dictionary", NULL}, {"user-dictionary", 'u', 0, G_OPTION_ARG_STRING, &opt_user_dictionary, "Path to a user dictionary", NULL}, {"rule", 'r', 0, G_OPTION_ARG_STRING, &opt_typing_rule, "Typing rule (use \"?\" to list available rules)", NULL}, {NULL}};

void usage (gchar** args, int args_length1, FILE* output) {
	GOptionContext* o = NULL;
	const gchar* _tmp0_ = NULL;
	GOptionContext* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar** _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* s = NULL;
	gchar* _tmp9_ = NULL;
	FILE* _tmp10_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (output != NULL);
	_tmp0_ = _ ("COMMAND");
	_tmp1_ = g_option_context_new (_tmp0_);
	o = _tmp1_;
	g_option_context_set_help_enabled (o, FALSE);
	{
		g_option_context_parse (o, &args_length1, &args, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_option_context_free0 (o);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp2_ = _ ("Commands:\n" \
"  help         Shows this information\n" \
"  decoder      Run decoder\n" \
"  context      Run context\n" \
"\n" \
"  Use \"%s COMMAND --help\" to get help on each command.\n");
	_tmp3_ = args;
	_tmp3__length1 = args_length1;
	_tmp4_ = _tmp3_[0];
	_tmp5_ = g_path_get_basename (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_strdup_printf (_tmp2_, _tmp6_);
	_tmp8_ = _tmp7_;
	g_option_context_set_description (o, _tmp8_);
	_g_free0 (_tmp8_);
	_g_free0 (_tmp6_);
	_tmp9_ = g_option_context_get_help (o, FALSE, NULL);
	s = _tmp9_;
	_tmp10_ = output;
	fprintf (_tmp10_, "%s", s);
	_g_free0 (s);
	_g_option_context_free0 (o);
}


static gchar** _vala_array_dup1 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static void _vala_array_add1 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


gint _vala_main (gchar** args, int args_length1) {
	gint result = 0;
	GOptionGroup* _tmp0_ = NULL;
	GOptionGroup* _tmp1_ = NULL;
	gchar** new_args = NULL;
	gchar** _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	gchar** _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	gchar** _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	gint new_args_length1 = 0;
	gint _new_args_size_ = 0;
	gchar** _tmp5_ = NULL;
	gint _tmp5__length1 = 0;
	gchar** _tmp8_ = NULL;
	gint _tmp8__length1 = 0;
	const gchar* _tmp9_ = NULL;
	gchar** _tmp10_ = NULL;
	gint _tmp10__length1 = 0;
	const gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	Repl* repl = NULL;
	gchar** _tmp14_ = NULL;
	gint _tmp14__length1 = 0;
	const gchar* _tmp15_ = NULL;
	GError * _inner_error_ = NULL;
	setlocale (LC_ALL, "");
	bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	textdomain (GETTEXT_PACKAGE);
	_tmp0_ = g_option_group_new ("model", "Model options:", "Options specifying the language model", NULL, NULL);
	_g_option_group_free0 (model_group);
	model_group = _tmp0_;
	_tmp1_ = model_group;
	g_option_group_add_entries (_tmp1_, model_entries);
	kkc_init ();
	_tmp2_ = args;
	_tmp2__length1 = args_length1;
	_tmp3_ = args;
	_tmp3__length1 = args_length1;
	_tmp4_ = ((_tmp2_ + 1) != NULL) ? _vala_array_dup1 (_tmp2_ + 1, _tmp3__length1 - 1) : ((gpointer) (_tmp2_ + 1));
	_tmp4__length1 = _tmp3__length1 - 1;
	new_args = _tmp4_;
	new_args_length1 = _tmp4__length1;
	_new_args_size_ = new_args_length1;
	_tmp5_ = new_args;
	_tmp5__length1 = new_args_length1;
	if (_tmp5__length1 < 1) {
		gchar** _tmp6_ = NULL;
		gint _tmp6__length1 = 0;
		gchar* _tmp7_ = NULL;
		_tmp6_ = new_args;
		_tmp6__length1 = new_args_length1;
		_tmp7_ = g_strdup ("decoder");
		_vala_array_add1 (&new_args, &new_args_length1, &_new_args_size_, _tmp7_);
	}
	_tmp8_ = args;
	_tmp8__length1 = args_length1;
	_tmp9_ = _tmp8_[0];
	_tmp10_ = new_args;
	_tmp10__length1 = new_args_length1;
	_tmp11_ = _tmp10_[0];
	_tmp12_ = g_strdup_printf ("%s %s", _tmp9_, _tmp11_);
	_tmp13_ = _tmp12_;
	g_set_prgname (_tmp13_);
	_g_free0 (_tmp13_);
	_tmp14_ = new_args;
	_tmp14__length1 = new_args_length1;
	_tmp15_ = _tmp14_[0];
	if (g_strcmp0 (_tmp15_, "decoder") == 0) {
		DecoderRepl* _tmp16_ = NULL;
		_tmp16_ = decoder_repl_new ();
		_g_object_unref0 (repl);
		repl = (Repl*) _tmp16_;
	} else {
		gchar** _tmp17_ = NULL;
		gint _tmp17__length1 = 0;
		const gchar* _tmp18_ = NULL;
		_tmp17_ = new_args;
		_tmp17__length1 = new_args_length1;
		_tmp18_ = _tmp17_[0];
		if (g_strcmp0 (_tmp18_, "context") == 0) {
			ContextRepl* _tmp19_ = NULL;
			_tmp19_ = context_repl_new ();
			_g_object_unref0 (repl);
			repl = (Repl*) _tmp19_;
		} else {
			gchar** _tmp20_ = NULL;
			gint _tmp20__length1 = 0;
			const gchar* _tmp21_ = NULL;
			_tmp20_ = new_args;
			_tmp20__length1 = new_args_length1;
			_tmp21_ = _tmp20_[0];
			if (g_strcmp0 (_tmp21_, "help") == 0) {
				gchar** _tmp22_ = NULL;
				gint _tmp22__length1 = 0;
				FILE* _tmp23_ = NULL;
				_tmp22_ = args;
				_tmp22__length1 = args_length1;
				_tmp23_ = stdout;
				usage (_tmp22_, _tmp22__length1, _tmp23_);
				result = 0;
				_g_object_unref0 (repl);
				new_args = (_vala_array_free (new_args, new_args_length1, (GDestroyNotify) g_free), NULL);
				return result;
			} else {
				FILE* _tmp24_ = NULL;
				gchar** _tmp25_ = NULL;
				gint _tmp25__length1 = 0;
				const gchar* _tmp26_ = NULL;
				gchar** _tmp27_ = NULL;
				gint _tmp27__length1 = 0;
				FILE* _tmp28_ = NULL;
				_tmp24_ = stderr;
				_tmp25_ = new_args;
				_tmp25__length1 = new_args_length1;
				_tmp26_ = _tmp25_[0];
				fprintf (_tmp24_, "Unknown command: %s\n", _tmp26_);
				_tmp27_ = args;
				_tmp27__length1 = args_length1;
				_tmp28_ = stderr;
				usage (_tmp27_, _tmp27__length1, _tmp28_);
				result = 1;
				_g_object_unref0 (repl);
				new_args = (_vala_array_free (new_args, new_args_length1, (GDestroyNotify) g_free), NULL);
				return result;
			}
		}
	}
	{
		Repl* _tmp29_ = NULL;
		gchar** _tmp30_ = NULL;
		gint _tmp30__length1 = 0;
		_tmp29_ = repl;
		_tmp30_ = new_args;
		_tmp30__length1 = new_args_length1;
		repl_parse_arguments (_tmp29_, _tmp30_, _tmp30__length1, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch1_g_error;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		gchar** _tmp31_ = NULL;
		gint _tmp31__length1 = 0;
		FILE* _tmp32_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp31_ = args;
		_tmp31__length1 = args_length1;
		_tmp32_ = stderr;
		usage (_tmp31_, _tmp31__length1, _tmp32_);
		result = 1;
		_g_error_free0 (e);
		_g_object_unref0 (repl);
		new_args = (_vala_array_free (new_args, new_args_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	__finally1:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (repl);
		new_args = (_vala_array_free (new_args, new_args_length1, (GDestroyNotify) g_free), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	{
		Repl* _tmp33_ = NULL;
		_tmp33_ = repl;
		repl_run (_tmp33_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch2_g_error;
		}
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		result = 1;
		_g_error_free0 (e);
		_g_object_unref0 (repl);
		new_args = (_vala_array_free (new_args, new_args_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	__finally2:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (repl);
		new_args = (_vala_array_free (new_args, new_args_length1, (GDestroyNotify) g_free), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	result = 0;
	_g_object_unref0 (repl);
	new_args = (_vala_array_free (new_args, new_args_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


int main (int argc, char ** argv) {
#if !GLIB_CHECK_VERSION (2,35,0)
	g_type_init ();
#endif
	return _vala_main (argv, argc);
}


gboolean repl_parse_arguments (Repl* self, gchar** args, int args_length1, GError** error) {
	g_return_val_if_fail (self != NULL, FALSE);
	return REPL_GET_INTERFACE (self)->parse_arguments (self, args, args_length1, error);
}


gboolean repl_run (Repl* self, GError** error) {
	g_return_val_if_fail (self != NULL, FALSE);
	return REPL_GET_INTERFACE (self)->run (self, error);
}


static void repl_base_init (ReplIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
	}
}


GType repl_get_type (void) {
	static volatile gsize repl_type_id__volatile = 0;
	if (g_once_init_enter (&repl_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ReplIface), (GBaseInitFunc) repl_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType repl_type_id;
		repl_type_id = g_type_register_static (G_TYPE_INTERFACE, "Repl", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (repl_type_id, G_TYPE_OBJECT);
		g_once_init_leave (&repl_type_id__volatile, repl_type_id);
	}
	return repl_type_id__volatile;
}


static gboolean decoder_repl_real_parse_arguments (Repl* base, gchar** args, int args_length1, GError** error) {
	DecoderRepl * self;
	gboolean result = FALSE;
	GOptionContext* o = NULL;
	const gchar* _tmp0_ = NULL;
	GOptionContext* _tmp1_ = NULL;
	GOptionGroup* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	GError * _inner_error_ = NULL;
	self = (DecoderRepl*) base;
	_tmp0_ = _ ("- run decoder on the command line");
	_tmp1_ = g_option_context_new (_tmp0_);
	o = _tmp1_;
	g_option_context_add_main_entries (o, decoder_entries, "libkkc");
	_tmp2_ = model_group;
	model_group = NULL;
	g_option_context_add_group (o, _tmp2_);
	_tmp4_ = g_option_context_parse (o, &args_length1, &args, &_inner_error_);
	_tmp3_ = _tmp4_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_option_context_free0 (o);
		return FALSE;
	}
	result = _tmp3_;
	_g_option_context_free0 (o);
	return result;
}


static gchar* g_file_stream_read_line (FILE* self) {
	gchar* result = NULL;
	gint c = 0;
	GString* ret = NULL;
	GString* _tmp7_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	ret = NULL;
	while (TRUE) {
		gint _tmp0_ = 0;
		gint _tmp1_ = 0;
		GString* _tmp2_ = NULL;
		gint _tmp4_ = 0;
		GString* _tmp5_ = NULL;
		gint _tmp6_ = 0;
		_tmp0_ = fgetc (self);
		c = _tmp0_;
		_tmp1_ = c;
		if (!(_tmp1_ != EOF)) {
			break;
		}
		_tmp2_ = ret;
		if (_tmp2_ == NULL) {
			GString* _tmp3_ = NULL;
			_tmp3_ = g_string_new ("");
			_g_string_free0 (ret);
			ret = _tmp3_;
		}
		_tmp4_ = c;
		if (_tmp4_ == ((gint) '\n')) {
			break;
		}
		_tmp5_ = ret;
		_tmp6_ = c;
		g_string_append_c ((GString*) _tmp5_, (gchar) _tmp6_);
	}
	_tmp7_ = ret;
	if (_tmp7_ == NULL) {
		result = NULL;
		_g_string_free0 (ret);
		return result;
	} else {
		GString* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		_tmp8_ = ret;
		_tmp9_ = ((GString*) _tmp8_)->str;
		_tmp10_ = g_strdup (_tmp9_);
		result = _tmp10_;
		_g_string_free0 (ret);
		return result;
	}
	_g_string_free0 (ret);
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	g_strstrip (_tmp1_);
	result = _result_;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gboolean decoder_repl_real_run (Repl* base, GError** error) {
	DecoderRepl * self;
	gboolean result = FALSE;
	KkcLanguageModel* model = NULL;
	KkcDecoder* decoder = NULL;
	KkcLanguageModel* _tmp11_ = NULL;
	KkcDecoder* _tmp12_ = NULL;
	FILE* _tmp13_ = NULL;
	GError * _inner_error_ = NULL;
	self = (DecoderRepl*) base;
	{
		const gchar* _tmp0_ = NULL;
		const gchar* _tmp1_ = NULL;
		gchar* name = NULL;
		gchar* _tmp3_ = NULL;
		KkcLanguageModel* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		KkcLanguageModel* _tmp6_ = NULL;
		KkcLanguageModel* _tmp7_ = NULL;
		_tmp1_ = opt_model;
		if (_tmp1_ == NULL) {
			_tmp0_ = "sorted3";
		} else {
			const gchar* _tmp2_ = NULL;
			_tmp2_ = opt_model;
			_tmp0_ = _tmp2_;
		}
		_tmp3_ = g_strdup (_tmp0_);
		name = _tmp3_;
		_tmp5_ = name;
		_tmp6_ = kkc_language_model_load (_tmp5_, &_inner_error_);
		_tmp4_ = _tmp6_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_free0 (name);
			if (_inner_error_->domain == KKC_LANGUAGE_MODEL_ERROR) {
				goto __catch3_kkc_language_model_error;
			}
			goto __finally3;
		}
		_tmp7_ = _tmp4_;
		_tmp4_ = NULL;
		_g_object_unref0 (model);
		model = _tmp7_;
		_g_object_unref0 (_tmp4_);
		_g_free0 (name);
	}
	goto __finally3;
	__catch3_kkc_language_model_error:
	{
		GError* e = NULL;
		FILE* _tmp8_ = NULL;
		GError* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp8_ = stderr;
		_tmp9_ = e;
		_tmp10_ = _tmp9_->message;
		fprintf (_tmp8_, "%s\n", _tmp10_);
		result = FALSE;
		_g_error_free0 (e);
		_g_object_unref0 (model);
		return result;
	}
	__finally3:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (model);
		return FALSE;
	}
	_tmp11_ = model;
	_tmp12_ = kkc_decoder_create (_tmp11_);
	decoder = _tmp12_;
	_tmp13_ = stdout;
	fprintf (_tmp13_, "%s", "Type kana sentence in the following form:\n" "SENTENCE [N-BEST [SEGMENT-BOUNDARY...]]\n");
	while (TRUE) {
		FILE* _tmp14_ = NULL;
		FILE* _tmp15_ = NULL;
		gchar* line = NULL;
		FILE* _tmp16_ = NULL;
		gchar* _tmp17_ = NULL;
		const gchar* _tmp18_ = NULL;
		gint nbest = 0;
		gchar** strv = NULL;
		const gchar* _tmp19_ = NULL;
		gchar* _tmp20_ = NULL;
		gchar* _tmp21_ = NULL;
		gchar** _tmp22_ = NULL;
		gchar** _tmp23_ = NULL;
		gchar** _tmp24_ = NULL;
		gint _tmp24__length1 = 0;
		gint strv_length1 = 0;
		gint _strv_size_ = 0;
		gchar** _tmp25_ = NULL;
		gint _tmp25__length1 = 0;
		gchar** _tmp26_ = NULL;
		gint _tmp26__length1 = 0;
		gint _tmp30_ = 0;
		gchar** _tmp31_ = NULL;
		gint _tmp31__length1 = 0;
		gint* constraints = NULL;
		gint* _tmp33_ = NULL;
		gint constraints_length1 = 0;
		gint _constraints_size_ = 0;
		KkcSegment** segments = NULL;
		KkcDecoder* _tmp45_ = NULL;
		gchar** _tmp46_ = NULL;
		gint _tmp46__length1 = 0;
		const gchar* _tmp47_ = NULL;
		gint _tmp48_ = 0;
		gint* _tmp49_ = NULL;
		gint _tmp49__length1 = 0;
		gint _tmp50_ = 0;
		KkcSegment** _tmp51_ = NULL;
		gint segments_length1 = 0;
		gint _segments_size_ = 0;
		_tmp14_ = stdout;
		fprintf (_tmp14_, ">> ");
		_tmp15_ = stdout;
		fflush (_tmp15_);
		_tmp16_ = stdin;
		_tmp17_ = g_file_stream_read_line (_tmp16_);
		line = _tmp17_;
		_tmp18_ = line;
		if (_tmp18_ == NULL) {
			_g_free0 (line);
			break;
		}
		nbest = 1;
		_tmp19_ = line;
		_tmp20_ = string_strip (_tmp19_);
		_tmp21_ = _tmp20_;
		_tmp23_ = _tmp22_ = g_strsplit (_tmp21_, " ", 0);
		_tmp24_ = _tmp23_;
		_tmp24__length1 = _vala_array_length (_tmp22_);
		_g_free0 (_tmp21_);
		strv = _tmp24_;
		strv_length1 = _tmp24__length1;
		_strv_size_ = strv_length1;
		_tmp25_ = strv;
		_tmp25__length1 = strv_length1;
		if (_tmp25__length1 == 0) {
			strv = (_vala_array_free (strv, strv_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (line);
			continue;
		}
		_tmp26_ = strv;
		_tmp26__length1 = strv_length1;
		if (_tmp26__length1 >= 2) {
			gchar** _tmp27_ = NULL;
			gint _tmp27__length1 = 0;
			const gchar* _tmp28_ = NULL;
			gint _tmp29_ = 0;
			_tmp27_ = strv;
			_tmp27__length1 = strv_length1;
			_tmp28_ = _tmp27_[1];
			_tmp29_ = atoi (_tmp28_);
			nbest = _tmp29_;
		}
		_tmp31_ = strv;
		_tmp31__length1 = strv_length1;
		if (_tmp31__length1 > 2) {
			gchar** _tmp32_ = NULL;
			gint _tmp32__length1 = 0;
			_tmp32_ = strv;
			_tmp32__length1 = strv_length1;
			_tmp30_ = _tmp32__length1 - 2;
		} else {
			_tmp30_ = 0;
		}
		_tmp33_ = g_new0 (gint, _tmp30_);
		constraints = _tmp33_;
		constraints_length1 = _tmp30_;
		_constraints_size_ = constraints_length1;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp34_ = FALSE;
				_tmp34_ = TRUE;
				while (TRUE) {
					gint _tmp36_ = 0;
					gint* _tmp37_ = NULL;
					gint _tmp37__length1 = 0;
					gint* _tmp38_ = NULL;
					gint _tmp38__length1 = 0;
					gint _tmp39_ = 0;
					gchar** _tmp40_ = NULL;
					gint _tmp40__length1 = 0;
					gint _tmp41_ = 0;
					const gchar* _tmp42_ = NULL;
					gint _tmp43_ = 0;
					gint _tmp44_ = 0;
					if (!_tmp34_) {
						gint _tmp35_ = 0;
						_tmp35_ = i;
						i = _tmp35_ + 1;
					}
					_tmp34_ = FALSE;
					_tmp36_ = i;
					_tmp37_ = constraints;
					_tmp37__length1 = constraints_length1;
					if (!(_tmp36_ < _tmp37__length1)) {
						break;
					}
					_tmp38_ = constraints;
					_tmp38__length1 = constraints_length1;
					_tmp39_ = i;
					_tmp40_ = strv;
					_tmp40__length1 = strv_length1;
					_tmp41_ = i;
					_tmp42_ = _tmp40_[2 + _tmp41_];
					_tmp43_ = atoi (_tmp42_);
					_tmp38_[_tmp39_] = _tmp43_;
					_tmp44_ = _tmp38_[_tmp39_];
				}
			}
		}
		_tmp45_ = decoder;
		_tmp46_ = strv;
		_tmp46__length1 = strv_length1;
		_tmp47_ = _tmp46_[0];
		_tmp48_ = nbest;
		_tmp49_ = constraints;
		_tmp49__length1 = constraints_length1;
		_tmp51_ = kkc_decoder_decode (_tmp45_, _tmp47_, _tmp48_, _tmp49_, _tmp49__length1, &_tmp50_);
		segments = _tmp51_;
		segments_length1 = _tmp50_;
		_segments_size_ = segments_length1;
		{
			gint index = 0;
			index = 0;
			{
				gboolean _tmp52_ = FALSE;
				_tmp52_ = TRUE;
				while (TRUE) {
					gint _tmp54_ = 0;
					KkcSegment** _tmp55_ = NULL;
					gint _tmp55__length1 = 0;
					FILE* _tmp56_ = NULL;
					gint _tmp57_ = 0;
					KkcSegment* segment = NULL;
					KkcSegment** _tmp58_ = NULL;
					gint _tmp58__length1 = 0;
					gint _tmp59_ = 0;
					KkcSegment* _tmp60_ = NULL;
					KkcSegment* _tmp61_ = NULL;
					FILE* _tmp73_ = NULL;
					if (!_tmp52_) {
						gint _tmp53_ = 0;
						_tmp53_ = index;
						index = _tmp53_ + 1;
					}
					_tmp52_ = FALSE;
					_tmp54_ = index;
					_tmp55_ = segments;
					_tmp55__length1 = segments_length1;
					if (!(_tmp54_ < _tmp55__length1)) {
						break;
					}
					_tmp56_ = stdout;
					_tmp57_ = index;
					fprintf (_tmp56_, "%d: ", _tmp57_);
					_tmp58_ = segments;
					_tmp58__length1 = segments_length1;
					_tmp59_ = index;
					_tmp60_ = _tmp58_[_tmp59_];
					_tmp61_ = _g_object_ref0 (_tmp60_);
					segment = _tmp61_;
					while (TRUE) {
						KkcSegment* _tmp62_ = NULL;
						FILE* _tmp63_ = NULL;
						KkcSegment* _tmp64_ = NULL;
						const gchar* _tmp65_ = NULL;
						const gchar* _tmp66_ = NULL;
						KkcSegment* _tmp67_ = NULL;
						const gchar* _tmp68_ = NULL;
						const gchar* _tmp69_ = NULL;
						KkcSegment* _tmp70_ = NULL;
						KkcSegment* _tmp71_ = NULL;
						KkcSegment* _tmp72_ = NULL;
						_tmp62_ = segment;
						if (!(_tmp62_ != NULL)) {
							break;
						}
						_tmp63_ = stdout;
						_tmp64_ = segment;
						_tmp65_ = kkc_segment_get_output (_tmp64_);
						_tmp66_ = _tmp65_;
						_tmp67_ = segment;
						_tmp68_ = kkc_segment_get_input (_tmp67_);
						_tmp69_ = _tmp68_;
						fprintf (_tmp63_, "<%s/%s>", _tmp66_, _tmp69_);
						_tmp70_ = segment;
						_tmp71_ = _tmp70_->next;
						_tmp72_ = _g_object_ref0 (_tmp71_);
						_g_object_unref0 (segment);
						segment = _tmp72_;
					}
					_tmp73_ = stdout;
					fprintf (_tmp73_, "\n");
					_g_object_unref0 (segment);
				}
			}
		}
		segments = (_vala_array_free (segments, segments_length1, (GDestroyNotify) g_object_unref), NULL);
		constraints = (g_free (constraints), NULL);
		strv = (_vala_array_free (strv, strv_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (line);
	}
	result = TRUE;
	_g_object_unref0 (decoder);
	_g_object_unref0 (model);
	return result;
}


DecoderRepl* decoder_repl_construct (GType object_type) {
	DecoderRepl * self = NULL;
	self = (DecoderRepl*) g_object_new (object_type, NULL);
	return self;
}


DecoderRepl* decoder_repl_new (void) {
	return decoder_repl_construct (TYPE_DECODER_REPL);
}


static void decoder_repl_class_init (DecoderReplClass * klass) {
	decoder_repl_parent_class = g_type_class_peek_parent (klass);
}


static void decoder_repl_repl_interface_init (ReplIface * iface) {
	decoder_repl_repl_parent_iface = g_type_interface_peek_parent (iface);
	iface->parse_arguments = (gboolean (*)(Repl*, gchar**, int, GError**)) decoder_repl_real_parse_arguments;
	iface->run = (gboolean (*)(Repl*, GError**)) decoder_repl_real_run;
}


static void decoder_repl_instance_init (DecoderRepl * self) {
}


GType decoder_repl_get_type (void) {
	static volatile gsize decoder_repl_type_id__volatile = 0;
	if (g_once_init_enter (&decoder_repl_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DecoderReplClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) decoder_repl_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DecoderRepl), 0, (GInstanceInitFunc) decoder_repl_instance_init, NULL };
		static const GInterfaceInfo repl_info = { (GInterfaceInitFunc) decoder_repl_repl_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType decoder_repl_type_id;
		decoder_repl_type_id = g_type_register_static (G_TYPE_OBJECT, "DecoderRepl", &g_define_type_info, 0);
		g_type_add_interface_static (decoder_repl_type_id, TYPE_REPL, &repl_info);
		g_once_init_leave (&decoder_repl_type_id__volatile, decoder_repl_type_id);
	}
	return decoder_repl_type_id__volatile;
}


static gboolean context_repl_real_parse_arguments (Repl* base, gchar** args, int args_length1, GError** error) {
	ContextRepl * self;
	gboolean result = FALSE;
	GOptionContext* o = NULL;
	const gchar* _tmp0_ = NULL;
	GOptionContext* _tmp1_ = NULL;
	GOptionGroup* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	GError * _inner_error_ = NULL;
	self = (ContextRepl*) base;
	_tmp0_ = _ ("- run context on the command line");
	_tmp1_ = g_option_context_new (_tmp0_);
	o = _tmp1_;
	g_option_context_add_main_entries (o, context_entries, "libkkc");
	_tmp2_ = model_group;
	model_group = NULL;
	g_option_context_add_group (o, _tmp2_);
	_tmp4_ = g_option_context_parse (o, &args_length1, &args, &_inner_error_);
	_tmp3_ = _tmp4_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_option_context_free0 (o);
		return FALSE;
	}
	result = _tmp3_;
	_g_option_context_free0 (o);
	return result;
}


static gboolean context_repl_real_run (Repl* base, GError** error) {
	ContextRepl * self;
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	KkcLanguageModel* model = NULL;
	KkcContext* context = NULL;
	KkcLanguageModel* _tmp26_ = NULL;
	KkcContext* _tmp27_ = NULL;
	const gchar* _tmp28_ = NULL;
	const gchar* _tmp39_ = NULL;
	const gchar* _tmp51_ = NULL;
	FILE* _tmp62_ = NULL;
	GError * _inner_error_ = NULL;
	self = (ContextRepl*) base;
	_tmp0_ = opt_typing_rule;
	if (g_strcmp0 (_tmp0_, "?") == 0) {
		KkcRuleMetadata** rules = NULL;
		gint _tmp1_ = 0;
		KkcRuleMetadata** _tmp2_ = NULL;
		gint rules_length1 = 0;
		gint _rules_size_ = 0;
		KkcRuleMetadata** _tmp3_ = NULL;
		gint _tmp3__length1 = 0;
		_tmp2_ = kkc_rule_list (&_tmp1_);
		rules = _tmp2_;
		rules_length1 = _tmp1_;
		_rules_size_ = rules_length1;
		_tmp3_ = rules;
		_tmp3__length1 = rules_length1;
		{
			KkcRuleMetadata** rule_collection = NULL;
			gint rule_collection_length1 = 0;
			gint _rule_collection_size_ = 0;
			gint rule_it = 0;
			rule_collection = _tmp3_;
			rule_collection_length1 = _tmp3__length1;
			for (rule_it = 0; rule_it < _tmp3__length1; rule_it = rule_it + 1) {
				KkcRuleMetadata* _tmp4_ = NULL;
				KkcRuleMetadata* rule = NULL;
				_tmp4_ = _g_object_ref0 (rule_collection[rule_it]);
				rule = _tmp4_;
				{
					FILE* _tmp5_ = NULL;
					KkcRuleMetadata* _tmp6_ = NULL;
					const gchar* _tmp7_ = NULL;
					const gchar* _tmp8_ = NULL;
					KkcRuleMetadata* _tmp9_ = NULL;
					const gchar* _tmp10_ = NULL;
					const gchar* _tmp11_ = NULL;
					KkcRuleMetadata* _tmp12_ = NULL;
					const gchar* _tmp13_ = NULL;
					const gchar* _tmp14_ = NULL;
					_tmp5_ = stdout;
					_tmp6_ = rule;
					_tmp7_ = kkc_metadata_file_get_name ((KkcMetadataFile*) _tmp6_);
					_tmp8_ = _tmp7_;
					_tmp9_ = rule;
					_tmp10_ = kkc_metadata_file_get_label ((KkcMetadataFile*) _tmp9_);
					_tmp11_ = _tmp10_;
					_tmp12_ = rule;
					_tmp13_ = kkc_metadata_file_get_description ((KkcMetadataFile*) _tmp12_);
					_tmp14_ = _tmp13_;
					fprintf (_tmp5_, "%s - %s: %s\n", _tmp8_, _tmp11_, _tmp14_);
					_g_object_unref0 (rule);
				}
			}
		}
		result = TRUE;
		rules = (_vala_array_free (rules, rules_length1, (GDestroyNotify) g_object_unref), NULL);
		return result;
	}
	{
		const gchar* _tmp15_ = NULL;
		const gchar* _tmp16_ = NULL;
		gchar* name = NULL;
		gchar* _tmp18_ = NULL;
		KkcLanguageModel* _tmp19_ = NULL;
		const gchar* _tmp20_ = NULL;
		KkcLanguageModel* _tmp21_ = NULL;
		KkcLanguageModel* _tmp22_ = NULL;
		_tmp16_ = opt_model;
		if (_tmp16_ == NULL) {
			_tmp15_ = "sorted3";
		} else {
			const gchar* _tmp17_ = NULL;
			_tmp17_ = opt_model;
			_tmp15_ = _tmp17_;
		}
		_tmp18_ = g_strdup (_tmp15_);
		name = _tmp18_;
		_tmp20_ = name;
		_tmp21_ = kkc_language_model_load (_tmp20_, &_inner_error_);
		_tmp19_ = _tmp21_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_free0 (name);
			if (_inner_error_->domain == KKC_LANGUAGE_MODEL_ERROR) {
				goto __catch4_kkc_language_model_error;
			}
			goto __finally4;
		}
		_tmp22_ = _tmp19_;
		_tmp19_ = NULL;
		_g_object_unref0 (model);
		model = _tmp22_;
		_g_object_unref0 (_tmp19_);
		_g_free0 (name);
	}
	goto __finally4;
	__catch4_kkc_language_model_error:
	{
		GError* e = NULL;
		FILE* _tmp23_ = NULL;
		GError* _tmp24_ = NULL;
		const gchar* _tmp25_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp23_ = stderr;
		_tmp24_ = e;
		_tmp25_ = _tmp24_->message;
		fprintf (_tmp23_, "%s\n", _tmp25_);
		result = FALSE;
		_g_error_free0 (e);
		_g_object_unref0 (model);
		return result;
	}
	__finally4:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (model);
		return FALSE;
	}
	_tmp26_ = model;
	_tmp27_ = kkc_context_new (_tmp26_);
	context = _tmp27_;
	_tmp28_ = opt_user_dictionary;
	if (_tmp28_ != NULL) {
		{
			KkcUserDictionary* _tmp29_ = NULL;
			const gchar* _tmp30_ = NULL;
			KkcUserDictionary* _tmp31_ = NULL;
			KkcContext* _tmp32_ = NULL;
			KkcDictionaryList* _tmp33_ = NULL;
			KkcDictionaryList* _tmp34_ = NULL;
			_tmp30_ = opt_user_dictionary;
			_tmp31_ = kkc_user_dictionary_new (_tmp30_, &_inner_error_);
			_tmp29_ = _tmp31_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				goto __catch5_g_error;
			}
			_tmp32_ = context;
			_tmp33_ = kkc_context_get_dictionaries (_tmp32_);
			_tmp34_ = _tmp33_;
			kkc_dictionary_list_add (_tmp34_, (KkcDictionary*) _tmp29_);
			_g_object_unref0 (_tmp29_);
		}
		goto __finally5;
		__catch5_g_error:
		{
			GError* e = NULL;
			FILE* _tmp35_ = NULL;
			const gchar* _tmp36_ = NULL;
			GError* _tmp37_ = NULL;
			const gchar* _tmp38_ = NULL;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp35_ = stderr;
			_tmp36_ = opt_user_dictionary;
			_tmp37_ = e;
			_tmp38_ = _tmp37_->message;
			fprintf (_tmp35_, "can't open user dictionary %s: %s", _tmp36_, _tmp38_);
			result = FALSE;
			_g_error_free0 (e);
			_g_object_unref0 (context);
			_g_object_unref0 (model);
			return result;
		}
		__finally5:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (context);
			_g_object_unref0 (model);
			return FALSE;
		}
	}
	_tmp39_ = opt_system_dictionary;
	if (_tmp39_ == NULL) {
		gchar* _tmp40_ = NULL;
		_tmp40_ = g_build_filename (DATADIR, "skk", "SKK-JISYO.L", NULL);
		_g_free0 (opt_system_dictionary);
		opt_system_dictionary = _tmp40_;
	}
	{
		KkcSystemSegmentDictionary* _tmp41_ = NULL;
		const gchar* _tmp42_ = NULL;
		KkcSystemSegmentDictionary* _tmp43_ = NULL;
		KkcContext* _tmp44_ = NULL;
		KkcDictionaryList* _tmp45_ = NULL;
		KkcDictionaryList* _tmp46_ = NULL;
		_tmp42_ = opt_system_dictionary;
		_tmp43_ = kkc_system_segment_dictionary_new (_tmp42_, "EUC-JP", &_inner_error_);
		_tmp41_ = _tmp43_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch6_g_error;
		}
		_tmp44_ = context;
		_tmp45_ = kkc_context_get_dictionaries (_tmp44_);
		_tmp46_ = _tmp45_;
		kkc_dictionary_list_add (_tmp46_, (KkcDictionary*) _tmp41_);
		_g_object_unref0 (_tmp41_);
	}
	goto __finally6;
	__catch6_g_error:
	{
		GError* e = NULL;
		FILE* _tmp47_ = NULL;
		const gchar* _tmp48_ = NULL;
		GError* _tmp49_ = NULL;
		const gchar* _tmp50_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp47_ = stderr;
		_tmp48_ = opt_system_dictionary;
		_tmp49_ = e;
		_tmp50_ = _tmp49_->message;
		fprintf (_tmp47_, "can't open system dictionary %s: %s", _tmp48_, _tmp50_);
		result = FALSE;
		_g_error_free0 (e);
		_g_object_unref0 (context);
		_g_object_unref0 (model);
		return result;
	}
	__finally6:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (context);
		_g_object_unref0 (model);
		return FALSE;
	}
	_tmp51_ = opt_typing_rule;
	if (_tmp51_ != NULL) {
		{
			KkcRuleMetadata* metadata = NULL;
			const gchar* _tmp52_ = NULL;
			KkcRuleMetadata* _tmp53_ = NULL;
			KkcRule* _tmp54_ = NULL;
			KkcRuleMetadata* _tmp55_ = NULL;
			KkcRule* _tmp56_ = NULL;
			KkcContext* _tmp57_ = NULL;
			_tmp52_ = opt_typing_rule;
			_tmp53_ = kkc_rule_metadata_find (_tmp52_);
			metadata = _tmp53_;
			_tmp55_ = metadata;
			_tmp56_ = kkc_rule_new (_tmp55_, &_inner_error_);
			_tmp54_ = _tmp56_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				_g_object_unref0 (metadata);
				if (_inner_error_->domain == KKC_RULE_PARSE_ERROR) {
					goto __catch7_kkc_rule_parse_error;
				}
				goto __finally7;
			}
			_tmp57_ = context;
			kkc_context_set_typing_rule (_tmp57_, _tmp54_);
			_g_object_unref0 (_tmp54_);
			_g_object_unref0 (metadata);
		}
		goto __finally7;
		__catch7_kkc_rule_parse_error:
		{
			GError* e = NULL;
			FILE* _tmp58_ = NULL;
			const gchar* _tmp59_ = NULL;
			GError* _tmp60_ = NULL;
			const gchar* _tmp61_ = NULL;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp58_ = stderr;
			_tmp59_ = opt_typing_rule;
			_tmp60_ = e;
			_tmp61_ = _tmp60_->message;
			fprintf (_tmp58_, "can't load rule \"%s\": %s\n", _tmp59_, _tmp61_);
			result = FALSE;
			_g_error_free0 (e);
			_g_object_unref0 (context);
			_g_object_unref0 (model);
			return result;
		}
		__finally7:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (context);
			_g_object_unref0 (model);
			return FALSE;
		}
	}
	_tmp62_ = stdout;
	fprintf (_tmp62_, "Type key event sequence separated by space\n");
	while (TRUE) {
		FILE* _tmp63_ = NULL;
		FILE* _tmp64_ = NULL;
		gchar* line = NULL;
		FILE* _tmp65_ = NULL;
		gchar* _tmp66_ = NULL;
		const gchar* _tmp67_ = NULL;
		KkcContext* _tmp73_ = NULL;
		gchar* _tmp74_ = NULL;
		gchar* _tmp75_ = NULL;
		gchar* _tmp76_ = NULL;
		KkcContext* _tmp103_ = NULL;
		gchar* _tmp104_ = NULL;
		gchar* _tmp105_ = NULL;
		_tmp63_ = stdout;
		fprintf (_tmp63_, ">> ");
		_tmp64_ = stdout;
		fflush (_tmp64_);
		_tmp65_ = stdin;
		_tmp66_ = g_file_stream_read_line (_tmp65_);
		line = _tmp66_;
		_tmp67_ = line;
		if (_tmp67_ == NULL) {
			_g_free0 (line);
			break;
		}
		{
			KkcContext* _tmp68_ = NULL;
			const gchar* _tmp69_ = NULL;
			_tmp68_ = context;
			_tmp69_ = line;
			kkc_context_process_key_events (_tmp68_, _tmp69_, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == KKC_KEY_EVENT_FORMAT_ERROR) {
					goto __catch8_kkc_key_event_format_error;
				}
				_g_free0 (line);
				_g_object_unref0 (context);
				_g_object_unref0 (model);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		goto __finally8;
		__catch8_kkc_key_event_format_error:
		{
			GError* e = NULL;
			FILE* _tmp70_ = NULL;
			GError* _tmp71_ = NULL;
			const gchar* _tmp72_ = NULL;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp70_ = stderr;
			_tmp71_ = e;
			_tmp72_ = _tmp71_->message;
			fprintf (_tmp70_, "%s\n", _tmp72_);
			_g_error_free0 (e);
			_g_free0 (line);
			continue;
		}
		__finally8:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (line);
			_g_object_unref0 (context);
			_g_object_unref0 (model);
			return FALSE;
		}
		_tmp73_ = context;
		_tmp74_ = kkc_context_get_input (_tmp73_);
		_tmp75_ = _tmp74_;
		_tmp76_ = _tmp75_;
		g_print ("input: %s\n", _tmp76_);
		_g_free0 (_tmp76_);
		g_print ("segments:\n");
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp77_ = FALSE;
				_tmp77_ = TRUE;
				while (TRUE) {
					gint _tmp79_ = 0;
					KkcContext* _tmp80_ = NULL;
					KkcSegmentList* _tmp81_ = NULL;
					KkcSegmentList* _tmp82_ = NULL;
					gint _tmp83_ = 0;
					gint _tmp84_ = 0;
					gint _tmp85_ = 0;
					KkcContext* _tmp86_ = NULL;
					KkcSegmentList* _tmp87_ = NULL;
					KkcSegmentList* _tmp88_ = NULL;
					gint _tmp89_ = 0;
					KkcSegment* _tmp90_ = NULL;
					KkcSegment* _tmp91_ = NULL;
					const gchar* _tmp92_ = NULL;
					const gchar* _tmp93_ = NULL;
					gint _tmp94_ = 0;
					KkcContext* _tmp95_ = NULL;
					KkcSegmentList* _tmp96_ = NULL;
					KkcSegmentList* _tmp97_ = NULL;
					gint _tmp98_ = 0;
					KkcSegment* _tmp99_ = NULL;
					KkcSegment* _tmp100_ = NULL;
					const gchar* _tmp101_ = NULL;
					const gchar* _tmp102_ = NULL;
					if (!_tmp77_) {
						gint _tmp78_ = 0;
						_tmp78_ = i;
						i = _tmp78_ + 1;
					}
					_tmp77_ = FALSE;
					_tmp79_ = i;
					_tmp80_ = context;
					_tmp81_ = kkc_context_get_segments (_tmp80_);
					_tmp82_ = _tmp81_;
					_tmp83_ = kkc_segment_list_get_size (_tmp82_);
					_tmp84_ = _tmp83_;
					if (!(_tmp79_ < _tmp84_)) {
						break;
					}
					_tmp85_ = i;
					_tmp86_ = context;
					_tmp87_ = kkc_context_get_segments (_tmp86_);
					_tmp88_ = _tmp87_;
					_tmp89_ = i;
					_tmp90_ = kkc_segment_list_get (_tmp88_, _tmp89_);
					_tmp91_ = _tmp90_;
					_tmp92_ = kkc_segment_get_input (_tmp91_);
					_tmp93_ = _tmp92_;
					g_print ("  input[%d]: %s\n", _tmp85_, _tmp93_);
					_g_object_unref0 (_tmp91_);
					_tmp94_ = i;
					_tmp95_ = context;
					_tmp96_ = kkc_context_get_segments (_tmp95_);
					_tmp97_ = _tmp96_;
					_tmp98_ = i;
					_tmp99_ = kkc_segment_list_get (_tmp97_, _tmp98_);
					_tmp100_ = _tmp99_;
					_tmp101_ = kkc_segment_get_output (_tmp100_);
					_tmp102_ = _tmp101_;
					g_print ("  output[%d]: %s\n", _tmp94_, _tmp102_);
					_g_object_unref0 (_tmp100_);
				}
			}
		}
		_tmp103_ = context;
		_tmp104_ = kkc_context_poll_output (_tmp103_);
		_tmp105_ = _tmp104_;
		g_print ("output: %s\n", _tmp105_);
		_g_free0 (_tmp105_);
		_g_free0 (line);
	}
	result = TRUE;
	_g_object_unref0 (context);
	_g_object_unref0 (model);
	return result;
}


ContextRepl* context_repl_construct (GType object_type) {
	ContextRepl * self = NULL;
	self = (ContextRepl*) g_object_new (object_type, NULL);
	return self;
}


ContextRepl* context_repl_new (void) {
	return context_repl_construct (TYPE_CONTEXT_REPL);
}


static void context_repl_class_init (ContextReplClass * klass) {
	context_repl_parent_class = g_type_class_peek_parent (klass);
}


static void context_repl_repl_interface_init (ReplIface * iface) {
	context_repl_repl_parent_iface = g_type_interface_peek_parent (iface);
	iface->parse_arguments = (gboolean (*)(Repl*, gchar**, int, GError**)) context_repl_real_parse_arguments;
	iface->run = (gboolean (*)(Repl*, GError**)) context_repl_real_run;
}


static void context_repl_instance_init (ContextRepl * self) {
}


GType context_repl_get_type (void) {
	static volatile gsize context_repl_type_id__volatile = 0;
	if (g_once_init_enter (&context_repl_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ContextReplClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) context_repl_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ContextRepl), 0, (GInstanceInitFunc) context_repl_instance_init, NULL };
		static const GInterfaceInfo repl_info = { (GInterfaceInitFunc) context_repl_repl_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType context_repl_type_id;
		context_repl_type_id = g_type_register_static (G_TYPE_OBJECT, "ContextRepl", &g_define_type_info, 0);
		g_type_add_interface_static (context_repl_type_id, TYPE_REPL, &repl_info);
		g_once_init_leave (&context_repl_type_id__volatile, context_repl_type_id);
	}
	return context_repl_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



