// Copyright 2011 Google Inc. All Rights Reserved.
// This file is available under the Apache license.

package vm

import (
	"regexp/syntax"

	"github.com/google/mtail/metrics"
)

type node interface {
}

type stmtlistNode struct {
	s        *scope
	children []node
}

type exprlistNode struct {
	children []node
}

type condNode struct {
	cond      node
	truthNode node
	elseNode  node
}

type regexNode struct {
	pattern string
	addr    int
	re_ast  *syntax.Regexp
}

type idNode struct {
	name string
	sym  *symbol
}

type caprefNode struct {
	name string
	sym  *symbol
}

type builtinNode struct {
	name string
	args node
}

type binaryExprNode struct {
	lhs, rhs node
	op       int
}

type unaryExprNode struct {
	lhs node
	op  int
}

type indexedExprNode struct {
	lhs, index node
}

type declNode struct {
	name         string
	keys         []string
	kind         metrics.Kind
	exportedName string
	m            *metrics.Metric
	sym          *symbol
}

type stringConstNode struct {
	text string
}

type intConstNode struct {
	i int64
}

type floatConstNode struct {
	f float64
}

type defNode struct {
	name     string
	children []node
	sym      *symbol
}

type decoNode struct {
	name     string
	children []node
	def      *defNode
}

type nextNode struct {
}

type otherwiseNode struct {
}
