# {%= name %} {%= badge("fury") %} {%= badge("travis") %}

> {%= description %}

## Install
{%= include("install-npm", {save: true}) %}

## Usage

```js
var isDescriptor = require('{%= name %}');

isDescriptor({value: 'foo'})
//=> true
isDescriptor({get: function(){}, set: function(){}})
//=> true
isDescriptor({get: 'foo', set: function(){}})
//=> false
```

You may also check for a descriptor by passing an object as the first argument and property name (`string`) as the second argument.

```js
var obj = {};
obj.foo = 'abc';

Object.defineProperty(obj, 'bar', {
  value: 'xyz'
});

isDescriptor(obj, 'foo');
//=> true
isDescriptor(obj, 'bar');
//=> true
```

## Examples

### value type

`false` when not an object

```js
isDescriptor('a'))
//=> false
isDescriptor(null))
//=> false
isDescriptor([]))
//=> false
```

### data descriptor

`true` when the object has valid properties with valid values.

```js
isDescriptor({value: 'foo'}))
//=> true
isDescriptor({value: noop}))
//=> true
```

`false` when the object has invalid properties

```js
isDescriptor({value: 'foo', bar: 'baz'}))
//=> false
isDescriptor({value: 'foo', bar: 'baz'}))
//=> false
isDescriptor({value: 'foo', get: noop}))
//=> false
isDescriptor({get: noop, value: noop}))
//=> false
```

`false` when a value is not the correct type

```js
isDescriptor({value: 'foo', enumerable: 'foo'}))
//=> false
isDescriptor({value: 'foo', configurable: 'foo'}))
//=> false
isDescriptor({value: 'foo', writable: 'foo'}))
//=> false
```

### accessor descriptor

`true` when the object has valid properties with valid values.

```js
isDescriptor({get: noop, set: noop}))
//=> true
isDescriptor({get: noop}))
//=> true
isDescriptor({set: noop}))
//=> true
```

`false` when the object has invalid properties

```js
isDescriptor({get: noop, set: noop, bar: 'baz'}))
//=> false
isDescriptor({get: noop, writable: true}))
//=> false
isDescriptor({get: noop, value: true}))
//=> false
```

`false` when an accessor is not a function

```js
isDescriptor({get: noop, set: 'baz'}))
//=> false
isDescriptor({get: 'foo', set: noop}))
//=> false
isDescriptor({get: 'foo', bar: 'baz'}))
//=> false
isDescriptor({get: 'foo', set: 'baz'}))
//=> false
```

`false` when a value is not the correct type

```js
isDescriptor({get: noop, set: noop, enumerable: 'foo'}))
//=> false
isDescriptor({set: noop, configurable: 'foo'}))
//=> false
isDescriptor({get: noop, configurable: 'foo'}))
//=> false
```

## Related projects
{%= related(verb.related.list, {remove: name}) %}  

## Running tests
{%= include("tests") %}

## Contributing
{%= include("contributing") %}

## Author
{%= include("author") %}

## License
{%= copyright() %}
{%= license %}

***

{%= include("footer") %}
