class mysql_slave( $clustername = $uniqueid, $listen_port = "3306", $admin_password = "admin" )
{
  debconf::set_selection{ "mysql_admin_password":
    selection => "mysql-server/root_password", 
    value_type => "password", 
    value => $admin_password,
  }

  debconf::set_selection{ "mysql_admin_password_again":
    selection => "mysql-server/root_password_again", 
    value_type => "password", 
    value => $admin_password,
  }

  package{"mysql-server": 
    ensure => installed,
    require => Debconf::Set_Selection["mysql_admin_password", "mysql_admin_password_again"],
  }

  package{"libmyodbc":
    ensure => installed,
    require => Package["mysql-server"],
  }

  package{"libmysql-java":
    ensure => installed,
    require => Package["mysql-server"],
  }

  exec{"create_${clustername}_dir":
    command => "mkdir -p /etc/mysql/${clustername}",
    require => Package["mysql-server"],
    unless => "tesd -d /etc/mysql/${clustername}",
  } -> File <<| tag == "mysql_${clustername}" |>> 

  file{"mysql_${uniqueid}_main_config":
    name => "/etc/mysql/my.cnf",
    require => Package["mysql-server"],
  }

  file{"mysql_${uniqueid}_config":
    name => "/etc/mysql/conf.d/mysql_config.cnf",
    ensure => present,
    owner => "root",
    group => "root",
    mode => "644",
    content => template("/etc/puppet/modules/orchestra-mysql/templates/mysql_config.erb"),
    require => Package["mysql-server"],
  }

  service {"mysql":
    ensure => running,
    enable => true,
    subscribe => File["mysql_${uniqueid}_config", "mysql_${uniqueid}_main_config"],
    hasstatus => true,
    require => File["mysql_${uniqueid}_config", "mysql_${uniqueid}_main_config"],
  }

} 
