//
// tardy - a tar post-processor
// Copyright (C) 1998, 1999, 2008, 2009 Peter Miller
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 3 of the License, or (at
// your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.
//

#include <libtardy/ac/unistd.h>

#include <libtardy/file/input/stdin.h>


file_input_stdin::~file_input_stdin()
{
    // nothing to do
}


file_input_stdin::file_input_stdin()
{
    // nothing to do
}


file_input_stdin::file_input_stdin(const file_input_stdin &rhs) :
    file_input(rhs)
{
    // nothing to do
}


file_input_stdin &
file_input_stdin::operator = (const file_input_stdin &rhs)
{
    file_input::operator=(rhs);
    // nothing to do
    return *this;
}


int
file_input_stdin::read(void *buffer, int maximum_length)
    const
{
    int nbytes = ::read(0, buffer, maximum_length);
    if (nbytes < 0)
        nfatal("read");
    return nbytes;
}


const char *
file_input_stdin::filename()
    const
{
    return "standard input";
}
