/*
 * Decompiled with CFR 0.152.
 */
package net.tinyos.tools;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.tinyos.comm.SerialPort;
import net.tinyos.comm.TOSSerial;
import net.tinyos.comm.UnsupportedCommOperationException;
import net.tinyos.util.Dump;

public class ListenRaw {
    private static final int PORT_SPEED_TELOS = 115200;
    private static final int PORT_SPEED_MICAZ = 57600;
    private static final int PORT_SPEED_MICA2 = 57600;
    private static final int PORT_SPEED_MICA2DOT = 19200;
    private static final int PORT_SPEED_MICA = 19200;
    private static final int PORT_SPEED_RENE = 19200;
    private static final int PORT_SPEED_IRIS = 57600;
    private static final int PORT_SPEED_SHIMMER = 115200;
    private int portSpeed;
    private SerialPort port;
    private String portName;
    private InputStream in;
    private OutputStream out;

    public ListenRaw(String string, int n) {
        this.portName = string;
        this.portSpeed = n;
    }

    public void open() throws IOException, UnsupportedCommOperationException {
        System.out.println("Opening port " + this.portName);
        this.port = new TOSSerial(this.portName);
        this.in = this.port.getInputStream();
        this.out = this.port.getOutputStream();
        this.port.setSerialPortParams(this.portSpeed, 8, 1, false);
        this.printPortStatus();
        System.out.println();
    }

    private void printPortStatus() {
        System.out.println(" baud rate: " + this.port.getBaudRate());
        System.out.println(" data bits: " + this.port.getDataBits());
        System.out.println(" stop bits: " + this.port.getStopBits());
        System.out.println(" parity:    " + this.port.getParity());
    }

    public void read() throws IOException {
        int n;
        while ((n = this.in.read()) != -1) {
            if (n == 126) {
                System.out.println();
            }
            Dump.printByte(System.out, n);
        }
    }

    private static void printUsage() {
        System.err.println("usage: java net.tinyos.tools.ListenRaw [options] <port>");
        System.err.println("options are:");
        System.err.println("  -h, --help:    usage help");
        System.err.println("  -p:            print available ports");
        System.err.println("  -telos:        Telos (115200 bps)");
        System.err.println("  -micaz:        Mica2 (57600 bps) [default]");
        System.err.println("  -mica2:        Mica2 (57600 bps) [default]");
        System.err.println("  -mica2dot:     Mica2Dot (19200 bps)");
        System.err.println("  -mica:         Mica (19200 bps)");
        System.err.println("  -rene:         Rene (19200 bps)");
        System.err.println("  -iris:         Iris (57600 bps) [default]");
        System.err.println("  -shimmer:      Shimmer (115200 bps)");
        System.exit(-1);
    }

    public static void main(String[] stringArray) {
        int n = 57600;
        if (stringArray.length < 1 || stringArray.length > 3) {
            ListenRaw.printUsage();
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-h") || stringArray[i].equals("--help")) {
                ListenRaw.printUsage();
            }
            if (stringArray[i].equals("-telos")) {
                n = 115200;
            }
            if (stringArray[i].equals("-micaz")) {
                n = 57600;
            }
            if (stringArray[i].equals("-mica2")) {
                n = 57600;
            }
            if (stringArray[i].equals("-mica2dot")) {
                n = 19200;
            }
            if (stringArray[i].equals("-mica")) {
                n = 19200;
            }
            if (stringArray[i].equals("-rene")) {
                n = 19200;
            }
            if (stringArray[i].equals("-iris")) {
                n = 57600;
            }
            if (!stringArray[i].equals("-shimmer")) continue;
            n = 115200;
        }
        if (stringArray[stringArray.length - 1].charAt(0) == '-') {
            return;
        }
        ListenRaw listenRaw = new ListenRaw(stringArray[stringArray.length - 1], n);
        try {
            listenRaw.open();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            listenRaw.read();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

