char tcl_tk707[] = "\
#	File tk707.tcl\n\
#	Remainder of gui, including key & mouse bindings. Then RUN!\n\
\n\
#	Pattern memory is now in C-land but track memory still in tcl/tk.\n\
#\n\
mem_init\n\
\n\
# ======================================================\n\
# lamps into the score\n\
# ======================================================\n\
set score_width  [expr $score_width_in_inch  * $cm_per_inch]\n\
set score_height [expr $score_height_in_inch * $cm_per_inch]\n\
set lamp_width  0.40;\n\
set lamp_height 0.15;\n\
set scale_lamps $score\n\
\n\
set scale_lamp3 $score.l3\n\
set scale_lamp2 $score.l2\n\
set scale_lamp1 $score.l1\n\
set scale_lamp0 $score.l0\n\
label $scale_lamp3 -bitmap nix -width ${lamp_width}c -height ${lamp_height}c	\\\n\
	-relief groove -borderwidth 2 -bg $tkxox(lamp_off)\n\
label $scale_lamp2 -bitmap nix -width ${lamp_width}c -height ${lamp_height}c	\\\n\
	-relief groove -borderwidth 2 -bg $tkxox(lamp_off)\n\
label $scale_lamp1 -bitmap nix -width ${lamp_width}c -height ${lamp_height}c	\\\n\
	-relief groove -borderwidth 2 -bg $tkxox(lamp_off)\n\
label $scale_lamp0 -bitmap nix -width ${lamp_width}c -height ${lamp_height}c	\\\n\
	-relief groove -borderwidth 2 -bg $tkxox(lamp_on)\n\
pack  $scale_lamp3 -side bottom\n\
pack  $scale_lamp2 -side bottom\n\
pack  $scale_lamp1 -side bottom\n\
pack  $scale_lamp0 -side bottom\n\
set x  0.75\n\
set dy [expr $score_height / 4.0 - 0.04]\n\
set y3 [expr $dy/2 - 0.01];\n\
set y2 [expr $y3 + $dy]\n\
set y1 [expr $y2 + $dy]\n\
set y0 [expr $y1 + $dy]\n\
\n\
$scale_lamps create window ${x}c ${y3}c -window $scale_lamp3;\n\
$scale_lamps create window ${x}c ${y2}c -window $scale_lamp2;\n\
$scale_lamps create window ${x}c ${y1}c -window $scale_lamp1;\n\
$scale_lamps create window ${x}c ${y0}c -window $scale_lamp0;\n\
\n\
focus ${scale_lamp0}\n\
# ======================================================\n\
# Grid Display Area\n\
# ======================================================\n\
# Vertical lines\n\
set xcoord 0.0\n\
for {set i 0} {$i < 16} {incr i} {\n\
	set xcoord [expr $xcoord + 0.5]\n\
	$grid create line ${xcoord}c 0.5c ${xcoord}c 9.0c -fill #aaaaaa\n\
	set pvalX [tk7_cm2pix $grid ${xcoord}c]\n\
	lappend gridXs $pvalX\n\
	set gridSvals($pvalX) $i\n\
}\n\
# Horizontal lines\n\
set ycoord 0.5\n\
for {set i 0} {$i < 16} {incr i} {\n\
	set ycoord [expr $ycoord + 0.5]\n\
	$grid create line 0.0c ${ycoord}c 8.5c ${ycoord}c -fill #aaaaaa\n\
	set pvalY [tk7_cm2pix $grid ${ycoord}c]\n\
	lappend gridYs $pvalY\n\
	set gridIvals($pvalY) [expr 15 - $i]\n\
}\n\
# -----------------------\n\
# Step markers\n\
# -----------------------\n\
set xcoord 0.0\n\
for {set i 0} {$i < 16} {incr i} {\n\
	set xcoord [expr $xcoord + 0.5]\n\
	$grid create text ${xcoord}c 0.28125c -text [expr $i + 1] -font *-${font12}-*\n\
}\n\
# -----------------------\n\
# Instrument labels\n\
# -----------------------\n\
$gridlabel create text 2.85c 0.28125c -text Step -font *-${font12}-* -anchor e\n\
set xcoord 0.5\n\
set ycoord 0.5625\n\
for {set i 0} {$i < 16} {incr i} {\n\
	set ycoord [expr $ycoord + 0.5]\n\
	$gridlabel create text 2.85c ${ycoord}c -tags ilabel$i	\\\n\
		-text $sound([expr 16 - $i],name) -font *-${font12}-* -anchor e\n\
}\n\
$tempoinfo create text 1c 0.5c -text TEMPO -font *-${font12}-* -tags tmtitle\n\
$tempoinfo create text 3.6c 1.5c -text \"$mode(tempo)\" -tags tempo	\\\n\
	-font -${courrier_boldfont_i_50}-* -anchor e\n\
#trace variable mode(tempo) w tempoinfo_update\n\
$tminfo.t create text 0.2c 0.45c -text TRACK -anchor w -font *-${normal_r_14}-*\n\
$tminfo.t create text 3c 0.45c -text \"\" -tags trackid -font *-${normal_r_14}-*\n\
trace variable mode(current_track) w trackinfo_update\n\
$tminfo.m create text 0.2c 0.4c -text STATUS -anchor w -font *-${font12}-*\n\
# ===================================================================================\n\
# Volume controls\n\
# ===================================================================================\n\
set vol_tics_width 0.25\n\
\n\
set title_width  [expr ${title_width_in_inch}  * ${cm_per_inch}];\n\
set title_height [expr ${title_height_in_inch} * ${cm_per_inch}];\n\
set space_height [expr ${title_height}/4.];\n\
set volspacer $vcunit.spacer\n\
canvas $volspacer -width ${title_width}c -height ${space_height}c\n\
pack $volspacer\n\
\n\
set cunit $vcunit.u\n\
frame $cunit;\n\
pack $cunit\n\
for {set i 0} {$i<11} {incr i} {\n\
	frame $cunit.$i ;# -relief groove -borderwidth 2\n\
	frame $cunit.$i.sf\n\
	if {$i == 0} {\n\
		canvas $cunit.$i.sf.cl -width 1.2c -height 4c\n\
		$cunit.$i.sf.cl create text 1.2c 0.4c -text MAX -font *-${font12}-* -anchor e\n\
		$cunit.$i.sf.cl create text 1.2c 3.6c -text MIN -font *-${font12}-* -anchor e\n\
		pack $cunit.$i.sf.cl -side left\n\
		set vol_space_width [expr 4*${vol_tics_width}];\n\
	} else {\n\
		set vol_space_width ${vol_tics_width};\n\
	}\n\
	canvas $cunit.$i.sf.c -width 0.25c -height 4c\n\
	for {set j 1} {$j < 10} {incr j} {\n\
		set y [expr 0.4 * $j]\n\
		$cunit.$i.sf.c create line 0c ${y}c ${vol_tics_width}c ${y}c\n\
	}\n\
	$cunit.$i.sf.c create line 0c 0.4c 0.25c 0.4c -width 2\n\
	$cunit.$i.sf.c create line 0c 2.0c 0.25c 2.0c -width 2\n\
	$cunit.$i.sf.c create line 0c 3.6c 0.25c 3.6c -width 2\n\
	scale $cunit.$i.sf.s -orient vertical -from 100 -to 0 -length 4c	\\\n\
		-width 0.4c -sliderlength 0.8c \\\n\
		-activebackground 	$tkxox(vol_slider_active) \\\n\
		-troughcolor 		$tkxox(vol_trough_color) \\\n\
		-background 		$tkxox(vol_slider_passive) \\\n\
		-highlightbackground 	$tkxox(vol_highlightbackground) \\\n\
		-showvalue false -borderwidth 1p \\\n\
		-command volset -relief groove\n\
\n\
	eval canvas $cunit.$i.sf.spacer -width ${vol_space_width}c -height 4c ${debug_relief};\n\
	pack $cunit.$i.sf.spacer -side right\n\
\n\
	pack $cunit.$i -side left\n\
	pack $cunit.$i.sf\n\
	pack $cunit.$i.sf.c -side left\n\
	pack $cunit.$i.sf.s -side left\n\
	frame $cunit.$i.lab\n\
\n\
	eval label $cunit.$i.l -height 1 -font *-${font8}-*	\\\n\
		-text $volume_label($i) -justify left ${debug_relief}\n\
	pack $cunit.$i.l -expand true -fill x\n\
\n\
	# Initialise fader setting\n\
	if {$i == 0} {\n\
	    $cunit.$i.sf.s set 100\n\
	} else {\n\
	    $cunit.$i.sf.s set 66\n\
	}\n\
}\n\
set masterv $cunit.11\n\
frame $masterv\n\
frame  $masterv.sf\n\
pack $masterv -side left\n\
pack  $masterv.sf\n\
\n\
set master_width        0.5;\n\
set master_height       5.0;\n\
set master_n_tics       10;\n\
set master_tics_width   0.7;\n\
set master_sliderlength [expr 2.*${master_height}/${master_n_tics}]\n\
set master_incr_height  [expr ${master_height}/(${master_n_tics}+2)];\n\
set vol_space_width     [expr 3*${vol_tics_width}];\n\
eval canvas $masterv.sf.spacer -width ${vol_space_width}c -height ${master_height}c \\\n\
	${debug_relief}\n\
pack $masterv.sf.spacer -side left\n\
\n\
set master_hi_color #ffff00000000; # red\n\
set master_hibg_color #f332ffff0000; # yellow\n\
set master_acbg_color #000044cffb22; # blue\n\
set master_fg_color #000044440000; # green\n\
	#-background 		$tkxox(but_grey)          \\\n\
\n\
canvas $masterv.sf.cl -width ${master_tics_width}c -height ${master_height}c\n\
scale $masterv.sf.s -orient vertical -from 100 -to 0 \\\n\
	-length ${master_height}c -width ${master_width}c \\\n\
	-sliderlength ${master_sliderlength}c	\\\n\
	-activebackground 	$tkxox(vol_slider_active) \\\n\
	-troughcolor 		$tkxox(vol_trough_color) \\\n\
	-background 		$tkxox(vol_slider_passive) \\\n\
	-highlightbackground 	$tkxox(vol_highlightbackground) \\\n\
	-showvalue false \\\n\
	-command volset \\\n\
	-borderwidth 1p \\\n\
	-relief groove\n\
\n\
\n\
canvas $masterv.sf.cr -width 2.0c -height ${master_height}c\n\
$masterv.sf.s set 100\n\
for {set i 0} {$i <= ${master_n_tics}} {incr i} {\n\
	if {$i == 0 || 2*$i == ${master_n_tics} || $i == ${master_n_tics} } {\n\
	    set width_in_point 2;\n\
	} else {\n\
	    set width_in_point 1;\n\
	}\n\
	set y [expr ${master_incr_height} * ($i + 1)]\n\
	$masterv.sf.cl create line 0c ${y}c 1.5c ${y}c \\\n\
		-width ${width_in_point}p\n\
	$masterv.sf.cr create line 0c ${y}c ${master_tics_width}c ${y}c \\\n\
		-width ${width_in_point}p\n\
}\n\
set x [expr ${master_tics_width} * 1.2 ]\n\
set y [expr ${master_incr_height} * (0 + 1)]\n\
$masterv.sf.cr create text ${x}c ${y}c -text MAX -font *-${font12}-* -anchor w\n\
set y [expr ${master_incr_height} * (${master_n_tics} + 1)]\n\
$masterv.sf.cr create text ${x}c ${y}c -text MIN -font *-${font12}-* -anchor w\n\
eval label $masterv.l -text \"VOLUME\" -justify right -font *-${boldfont12}-* ${debug_relief}\n\
\n\
pack  $masterv.sf.cl $masterv.sf.s $masterv.sf.cr -side left\n\
pack $masterv.l -expand true -fill x\n\
$masterv.sf.cl configure\n\
\n\
set bypassval 0\n\
set bypass $vcunit.bypass\n\
frame $bypass\n\
pack $bypass\n\
label $bypass.l -text \"BYPASS Faders\" -font *-${font12}-*\n\
button $bypass.b -bitmap nix -width 3.5c -height 0.75c 	\\\n\
	-background $tkxox(but_grey) -activebackground $tkxox(but_grey_active)	\\\n\
	-command {vol_bypass [incr bypassval -1]}\n\
pack $bypass.b\n\
pack $bypass.l\n\
set volspacerB $vcunit.spacerB\n\
canvas $volspacerB -width ${title_width}c -height ${space_height}c\n\
pack $volspacerB\n\
\n\
proc volset {val} {\n\
	global cunit\n\
\n\
	for {set i 0} {$i < 12} {incr i} {\n\
		lappend vals [$cunit.$i.sf.s get]\n\
	}\n\
	eval tk7_set_vols $vals\n\
\n\
}\n\
proc vol_bypass {n} {\n\
	global bypassval cunit vcunit masterv\n\
	global font12\n\
\n\
	set bypassval [expr abs($n)]	;# Should now be 0 or 1\n\
	if {$bypassval} {\n\
		for {set i 0} {$i < 11} {incr i} {\n\
			$cunit.$i.sf.s configure -state disabled\n\
			$masterv.sf.s configure -state disabled\n\
			$vcunit.bypass.l configure -text \"ACTIVATE Faders\" -font *-${font12}-*\n\
			tk7_set_vols 100 100 100 100 100 100 100 100 100 100 100 100\n\
		}\n\
	} else {\n\
		for {set i 0} {$i < 11} {incr i} {\n\
			$cunit.$i.sf.s configure -state normal\n\
			$masterv.sf.s configure -state normal\n\
			$vcunit.bypass.l configure -text \"BYPASS Faders\" -font *-${font12}-*\n\
			volset 0\n\
		}\n\
	}\n\
\n\
}\n\
# ======================================================\n\
# small buttons area\n\
# ======================================================\n\
\n\
# ------------------------------------------------------\n\
# Clear/Scale/Last Step/Instrument Guide\n\
# ------------------------------------------------------\n\
eval frame $misc.lt1 $debug_relief\n\
pack $misc.lt1\n\
label $misc.lt1.clear -text CLEAR -font *-${boldfont12}-* -anchor c\n\
pack $misc.lt1.clear\n\
button $misc.b1 -bitmap nix -width 0.75c -height 0.75c	\\\n\
	-bg $tkxox(but_grey) -activebackground $tkxox(but_grey_active)\n\
eval frame $misc.lb1 $debug_relief\n\
pack $misc.lb1\n\
label $misc.lb1.clear -text CLEAR -font *-${boldfont12}-* -anchor c\n\
pack $misc.lb1.clear\n\
$misc create window 0.8c 1.4c  -window $misc.lt1 -anchor s\n\
$misc create window 0.8c 2c    -window $misc.b1  -anchor c\n\
$misc create window 0.8c 2.65c -window $misc.lb1 -anchor n\n\
bind $misc.b1 <ButtonRelease-1>               {ac_clear 0}\n\
bind $misc.b1 <Shift-ButtonRelease-1>         {ac_clear 1}\n\
bind $misc.b1 <Control-ButtonRelease-1>       {ac_clear 2}\n\
bind $misc.b1 <Shift-Control-ButtonRelease-1> {ac_clear 3}\n\
\n\
eval frame $misc.lt2 $debug_relief;\n\
pack $misc.lt2\n\
label $misc.lt2.scale -text SCALE -font *-${boldfont12}-* -anchor c\n\
pack $misc.lt2.scale\n\
button $misc.b2 -bitmap nix -width 0.75c -height 0.75c  \\\n\
	-bg $tkxox(but_grey) -activebackground $tkxox(but_grey_active)\n\
eval frame $misc.lb2 $debug_relief;\n\
pack $misc.lb2\n\
label $misc.lb2.back -text BACK -font *-${boldfont12}-* -anchor c\n\
pack $misc.lb2.back\n\
$misc create window 2.0c 1.4c  -window $misc.lt2 -anchor s\n\
$misc create window 2.0c 2c    -window $misc.b2 -anchor c\n\
$misc create window 2.0c 2.65c -window $misc.lb2 -anchor n\n\
bind $misc.b2 <1> ac_scaleback\n\
\n\
eval frame $misc.lt3 $debug_relief;\n\
pack $misc.lt3\n\
label $misc.lt3.last -text LAST -font *-${boldfont12}-* -anchor c\n\
label $misc.lt3.step -text STEP -font *-${boldfont12}-* -anchor c\n\
pack $misc.lt3.last $misc.lt3.step\n\
button $misc.b3 -bitmap nix -width 0.75c -height 0.75c  \\\n\
	-bg $tkxox(but_grey) -activebackground $tkxox(but_grey_active)\n\
eval frame $misc.lb3 $debug_relief;\n\
pack $misc.lb3\n\
label $misc.lb3.fwd -text FWD -font *-${boldfont12}-* -anchor c\n\
pack $misc.lb3.fwd\n\
$misc create window 3.2c 1.4c  -window $misc.lt3 -anchor s\n\
$misc create window 3.2c 2c    -window $misc.b3 -anchor c\n\
$misc create window 3.2c 2.65c -window $misc.lb3 -anchor n\n\
bind $misc.b3 <1> ac_lastfwd\n\
\n\
eval frame $misc.lt4 $debug_relief;\n\
pack $misc.lt4\n\
label $misc.lt4.inst -text INSTR -font *-${boldfont12}-* -anchor c\n\
label $misc.lt4.guide -text /GUIDE -font *-${boldfont12}-* -anchor c\n\
pack $misc.lt4.inst $misc.lt4.guide\n\
button $misc.b4 -bitmap nix -width 0.75c -height 0.75c  \\\n\
	-bg $tkxox(but_grey) -activebackground $tkxox(but_grey_active)\n\
eval frame $misc.lb4 $debug_relief;\n\
pack $misc.lb4\n\
label $misc.lb4.last -text LAST -font *-${boldfont12}-* -anchor c\n\
label $misc.lb4.meas -text MEAS -font *-${boldfont12}-* -anchor c\n\
pack $misc.lb4.last $misc.lb4.meas\n\
$misc create window 4.4c 1.4c  -window $misc.lt4 -anchor s\n\
$misc create window 4.4c 2c    -window $misc.b4 -anchor c\n\
$misc create window 4.4c 2.65c -window $misc.lb4 -anchor n\n\
\n\
bind $misc.b4 <1>                     {ac_lastmeas 0}\n\
bind $misc.b4 <ButtonRelease-1>       {ac_lastmeas 1}\n\
bind $misc.b4 <Shift-1>               {ac_lastmeas 2}\n\
bind $misc.b4 <Shift-ButtonRelease-1> {ac_lastmeas 3}\n\
\n\
# ------------------------------------------------------\n\
# Shuffle/Flam & Tempo/Measure controls\n\
# ------------------------------------------------------\n\
#\n\
# shuffle/flam\n\
#\n\
eval frame $st.lt1 $debug_relief;\n\
pack $st.lt1\n\
label $st.lt1.shuff -text SHUFFLE -font *-${boldfont12}-*\n\
label $st.lt1.flam -text /FLAM -font *-${boldfont12}-*\n\
pack $st.lt1.shuff $st.lt1.flam\n\
button $st.b1 -bitmap nix -width 0.75c -height 0.75c  \\\n\
	-bg $tkxox(but_grey) -activebackground $tkxox(but_grey_active)\n\
eval frame $st.lb1 $debug_relief;\n\
pack $st.lb1\n\
label $st.lb1.midi -text \"MIDI CH\" -font *-${boldfont12}-* \\\n\
	-fg $tkxox(color_fg_shift) -bg $tkxox(color_bg_shift)\n\
pack $st.lb1.midi\n\
$st create window 1c 1.4c  -window $st.lt1 -anchor s\n\
$st create window 1c 2c    -window $st.b1  -anchor c\n\
$st create window 1c 2.65c -window $st.lb1 -anchor n\n\
bind $st.b1 <Button-1> { ac_flam }\n\
bind $st.b1 <Shift-1>  { ac_midi }\n\
#\n\
# tempo/meas area\n\
#\n\
eval frame $st.lt2 $debug_relief;\n\
pack $st.lt2\n\
label $st.lt2.tempo -text TEMPO -font *-${boldfont12}-*\n\
label $st.lt2.meas -text /MEAS  -font *-${boldfont12}-*\n\
pack $st.lt2.tempo $st.lt2.meas\n\
button $st.b2 -bitmap nix -width 0.75c -height 0.75c  \\\n\
	-bg $tkxox(but_grey) -activebackground $tkxox(but_grey_active)\n\
eval frame $st.lb2 $debug_relief;\n\
pack $st.lb2\n\
label $st.lb2.sync -text \"SYNC MODE\" -font *-${boldfont12}-* \\\n\
	-fg $tkxox(color_fg_shift) -bg $tkxox(color_bg_shift)\n\
pack $st.lb2.sync\n\
$st create window 3c 1.4c  -window $st.lt2 -anchor s\n\
$st create window 3c 2c    -window $st.b2\n\
$st create window 3c 2.65c -window $st.lb2 -anchor n\n\
bind $st.b2 <1> ac_tempomeasure\n\
# ------------------------------------------------------\n\
# Track/Pattern Read/Write control\n\
# ------------------------------------------------------\n\
label $trpa.lt -text PLAY -font *-${boldfont12}-*\n\
label $trpa.lttrack -text TRACK -font *-${boldfont12}-*\n\
label $trpa.ltpattern -text PATTERN -font *-${boldfont12}-*\n\
label $trpa.lbtrack -text TRACK -font *-${boldfont12}-* \\\n\
	-fg $tkxox(color_fg_shift) -bg $tkxox(color_bg_shift)\n\
label $trpa.lbstep -text \"STEP/TAP\" -font *-${boldfont12}-* \\\n\
	-fg $tkxox(color_fg_shift) -bg $tkxox(color_bg_shift)\n\
button $trpa.btrk -bitmap nix -width 0.75c -height 0.75c  \\\n\
    -bg $tkxox(but_grey) -activebackground $tkxox(but_grey_active)\n\
button $trpa.bpat -bitmap nix -width 0.75c -height 0.75c  \\\n\
    -bg $tkxox(but_grey) -activebackground $tkxox(but_grey_active)\n\
label $trpa.lb -text WRITE -font *-${boldfont12}-*\n\
$trpa create window 1.6c 0.8c  -window $trpa.lt -anchor s\n\
$trpa create window 0.8c 1.4c  -window $trpa.lttrack -anchor s\n\
$trpa create window 0.8c 2c    -window $trpa.btrk -anchor c\n\
$trpa create window 0.8c 2.65c -window $trpa.lbtrack -anchor n\n\
$trpa create window 2.3c 1.4c  -window $trpa.ltpattern -anchor s\n\
$trpa create window 2.3c 2c    -window $trpa.bpat -anchor c\n\
$trpa create window 2.3c 2.65c -window $trpa.lbstep -anchor n\n\
$trpa create window 1.6c 3.30c -window $trpa.lb -anchor n\n\
\n\
bind $trpa.btrk <1>        {ac_trackmode $tkxox(READ)}\n\
bind $trpa.btrk <Double-1> {ac_trackmode $tkxox(WRITE)}\n\
bind $trpa.btrk <Shift-1>  {ac_trackmode $tkxox(WRITE)}\n\
bind $trpa.bpat <1>        { ac_patternmode $tkxox(READ); }\n\
bind $trpa.bpat <Double-1> { ac_patternmode $tkxox(WRITE); }\n\
bind $trpa.bpat <Shift-1>  { ac_patternmode $tkxox(WRITE); }\n\
#---------------------------------------\n\
# Pattern Group & Track Number selection\n\
#---------------------------------------\n\
label $grps.lt -text \"PATTERN GROUP\" -font *-${boldfont12}-*\n\
label $grps.lb -text \"TRACK NUMBER\"  -font *-${boldfont12}-*\n\
$grps create window 2.5c 0.8c  -window $grps.lt -anchor s\n\
$grps create window 2.5c 3.30c -window $grps.lb -anchor n\n\
eval frame $grps.lt0 $debug_relief;\n\
pack $grps.lt0\n\
label $grps.lt0.lamp -bitmap nix -width 0.4c -height 0.15c	\\\n\
	-relief groove -borderwidth 2 -bg $tkxox(lamp_off)\n\
label $grps.lt0.labl -text A -font *-${boldfont12}-*\n\
pack $grps.lt0.lamp $grps.lt0.labl -side left\n\
button $grps.b0 -bitmap nix -width 0.75c -height 0.75c  \\\n\
    -bg $tkxox(but_grey) -activebackground $tkxox(but_grey_active)\n\
label $grps.lb0 -text I -font *-${boldfont13}-* \\\n\
	-fg $tkxox(color_fg_shift) -bg $tkxox(color_bg_shift)\n\
$grps create window 0.8c 1.4c -window $grps.lt0 -anchor s\n\
$grps create window 0.8c 2c -window $grps.b0 -anchor c\n\
$grps create window 0.8c 2.65c -window $grps.lb0 -anchor n\n\
\n\
eval frame $grps.lt1 $debug_relief;\n\
pack $grps.lt1\n\
label $grps.lt1.lamp -bitmap nix -width 0.4c -height 0.15c	\\\n\
	-relief groove -borderwidth 2 -bg $tkxox(lamp_off)\n\
label $grps.lt1.labl -text B -font *-${boldfont12}-*\n\
pack $grps.lt1.lamp $grps.lt1.labl -side left\n\
button $grps.b1 -bitmap nix -width 0.75c -height 0.75c  \\\n\
    -bg $tkxox(but_grey) -activebackground $tkxox(but_grey_active)\n\
label $grps.lb1 -text II -font *-${boldfont13}-* \\\n\
	-fg $tkxox(color_fg_shift) -bg $tkxox(color_bg_shift)\n\
\n\
\n\
\n\
$grps create window 2c 1.4c -window $grps.lt1 -anchor s\n\
$grps create window 2c 2c -window $grps.b1 -anchor c\n\
$grps create window 2c 2.65c -window $grps.lb1 -anchor n\n\
\n\
eval frame $grps.lt2 $debug_relief;\n\
pack $grps.lt2\n\
label $grps.lt2.lamp -bitmap nix -width 0.4c -height 0.15c	\\\n\
	-relief groove -borderwidth 2 -bg $tkxox(lamp_off)\n\
label $grps.lt2.labl -text C -font *-${boldfont12}-*\n\
pack $grps.lt2.lamp $grps.lt2.labl -side left\n\
button $grps.b2 -bitmap nix -width 0.75c -height 0.75c  \\\n\
    -bg $tkxox(but_grey) -activebackground $tkxox(but_grey_active)\n\
label $grps.lb2 -text III -font *-${boldfont13}-* \\\n\
	-fg $tkxox(color_fg_shift) -bg $tkxox(color_bg_shift)\n\
$grps create window 3.2c 1.4c -window $grps.lt2 -anchor s\n\
$grps create window 3.2c 2c -window $grps.b2 -anchor c\n\
$grps create window 3.2c 2.65c -window $grps.lb2 -anchor n\n\
\n\
eval frame $grps.lt3 $debug_relief;\n\
pack $grps.lt3\n\
label $grps.lt3.lamp -bitmap nix -width 0.4c -height 0.15c	\\\n\
	-relief groove -borderwidth 2 -bg $tkxox(lamp_off)\n\
label $grps.lt3.labl -text D -font *-${boldfont12}-*\n\
pack $grps.lt3.lamp $grps.lt3.labl -side left\n\
button $grps.b3 -bitmap nix -width 0.75c -height 0.75c  \\\n\
    -bg $tkxox(but_grey) -activebackground $tkxox(but_grey_active)\n\
label $grps.lb3 -text IV -font *-${boldfont13}-* \\\n\
	-fg $tkxox(color_fg_shift) -bg $tkxox(color_bg_shift)\n\
$grps create window 4.4c 1.4c -window $grps.lt3 -anchor s\n\
$grps create window 4.4c 2c -window $grps.b3 -anchor c\n\
$grps create window 4.4c 2.65c -window $grps.lb3 -anchor n\n\
\n\
bind $grps.b0 <1> {ac_group 0}\n\
bind $grps.b1 <1> {ac_group 1}\n\
bind $grps.b2 <1> {ac_group 2}\n\
bind $grps.b3 <1> {ac_group 3}\n\
bind $grps.b0 <Shift-1> {ac_track 0}\n\
bind $grps.b1 <Shift-1> {ac_track 1}\n\
bind $grps.b2 <Shift-1> {ac_track 2}\n\
bind $grps.b3 <Shift-1> {ac_track 3}\n\
# -------------------------------\n\
# Create the note buttons & lamps\n\
# -------------------------------\n\
# add half a button width at left and right of the score alignement\n\
set border_width_in_point 2;\n\
set correction            0.20\n\
set button_width [expr $score_width/17.0 - 2*$border_width_in_point/$point_per_cm - $correction];\n\
\n\
set shift_buttons $notes.shift\n\
canvas $shift_buttons -width [expr 0.95*${button_width}]c -height 2.6c;\n\
pack   $shift_buttons -side left;\n\
\n\
for {set i 0} {$i<16} {incr i} {\n\
	frame $notes.note$i\n\
	pack $notes.note$i -side left\n\
	label $notes.note$i.l -height 1 -text [expr $i + 1]	\\\n\
		-relief groove -borderwidth ${border_width_in_point}p -font *-${font12}-*\n\
	button $notes.note$i.b -bitmap nix -width ${button_width}c -height 2.6c	\\\n\
		-bg $tkxox(but_grey) -activebackground $tkxox(but_grey_active)\n\
	label $notes.note$i.instr -width 1 \\\n\
		-font *-${font12}-* -text $sound([expr $i + 1],shortname);\n\
	pack $notes.note$i.l $notes.note$i.b $notes.note$i.instr \\\n\
		-expand true -fill x\n\
	bind $notes.note$i.b <ButtonPress-1>           {ac_note     %W 0}\n\
	bind $notes.note$i.b <ButtonRelease-1>         {ac_note_off %W}\n\
	bind $notes.note$i.b <Control-ButtonPress-1>   {ac_note     %W $tkxox(flam)}\n\
	bind $notes.note$i.b <Control-ButtonRelease-1> {ac_note_off %W}\n\
	bind $notes.note$i.b <Button-3>                {ac_note     %W $tkxox(zero_velocity)}\n\
	bind $notes.note$i.b <Shift-1>                 {ac_newinstr %W}\n\
}\n\
#\n\
# Empty Space : adjust vectical alignment with score\n\
# 	- at the right of the score\n\
# 	- at the right of the instrument buttons\n\
#\n\
set empty_right $note_score.right\n\
set empty_case $notes.right\n\
canvas $empty_right -width ${right_space_width}c -height ${score_height_in_inch}i;\n\
canvas $empty_case  -width ${right_space_width}c -height 2.6c;\n\
pack   $empty_right -side left;\n\
pack   $empty_case -side right;\n\
\n\
pattern_setid 0	;	# Initialise pattern number\n\
ac_group $mode(patgroup)\n\
ac_newinstr $notes.note0.b	;	# Initialise current instrument\n\
\n\
# Bindings to activate note buttons from keyboard\n\
# 1->10 = buttons 1->10, \"q\"->\"y\" = 11->16\n\
#\n\
set k 0\n\
bind . <KeyPress-1> {ac_note $notes.note0.b 0}\n\
bind . <KeyPress-2> {ac_note $notes.note1.b 0}\n\
bind . <KeyPress-3> {ac_note $notes.note2.b 0}\n\
bind . <KeyPress-4> {ac_note $notes.note3.b 0}\n\
bind . <KeyPress-5> {ac_note $notes.note4.b 0}\n\
bind . <KeyPress-6> {ac_note $notes.note5.b 0}\n\
bind . <KeyPress-7> {ac_note $notes.note6.b 0}\n\
bind . <KeyPress-8> {ac_note $notes.note7.b 0}\n\
bind . <KeyPress-9> {ac_note $notes.note8.b 0}\n\
bind . <KeyPress-0> {ac_note $notes.note9.b 0}\n\
bind . <KeyPress-q> {ac_note $notes.note10.b 0}\n\
bind . <KeyPress-w> {ac_note $notes.note11.b 0}\n\
bind . <KeyPress-e> {ac_note $notes.note12.b 0} ;# puts \"[incr k]\"}\n\
bind . <KeyPress-r> {ac_note $notes.note13.b 0}\n\
bind . <KeyPress-t> {ac_note $notes.note14.b 0}\n\
bind . <KeyPress-y> {ac_note $notes.note15.b 0}\n\
\n\
# Bindings for pattern Copy/Paste\n\
#\n\
bind . <Control-c> {\n\
	tk7_set_patbuf $mode(patgroup) $mode(current_pattern)\n\
}\n\
bind . <Control-b> {\n\
	if {($mode(rdrw) == $tkxox(WRITE)) && ($mode(patr) == $tkxox(PATTERN))} {\n\
		tk7_copy_patbuf $mode(patgroup) $mode(current_pattern) 1\n\
		pattern_setid $mode(current_pattern)\n\
	}\n\
}\n\
bind . <Control-v> {\n\
	if {($mode(rdrw) == $tkxox(WRITE)) && ($mode(patr) == $tkxox(PATTERN))} {\n\
		tk7_copy_patbuf $mode(patgroup) $mode(current_pattern) 0\n\
		pattern_setid $mode(current_pattern)\n\
	}\n\
}\n\
#\n\
# Bindings for pattern editing from display grid\n\
#\n\
proc grid_note {x y prop} {\n\
	global notes\n\
	upvar #0 tkxox xox\n\
	upvar #0 mode mo\n\
	if {$mo(patr) == $xox(TRACK) || $mo(rdrw) == $xox(READ)} {\n\
	    return\n\
	}\n\
	if {![have_zero_velocity $prop]} {\n\
	  switch $mo(current_accent) {\n\
	    2       {set prop [add_strong_accent    $prop] }\n\
	    1 	    {set prop [add_weak_accent      $prop] }\n\
	    default {set prop [add_default_velocity $prop] }\n\
	  }\n\
	}\n\
	# Convert x,y position to a grid intersection point\n\
	# and imply step,instrument combination from it.\n\
	if {[locate_gridpos $x $y SIvals] < 0 } {\n\
	    return\n\
	}\n\
	#puts \" -> Instrument $SIvals(inst) at step $SIvals(step) with prop $prop\"\n\
	ac_newinstr $notes.note$SIvals(inst).b\n\
	step_insert $SIvals(step) $prop\n\
}\n\
bind $grid <Button-1> {\n\
	#puts \"Button-1: %x,%y\"\n\
}\n\
bind $grid <Double-Button-1> {\n\
	#puts \"Double-Button-1: %x,%y\"\n\
	grid_note %x %y 0\n\
}\n\
bind $grid <Control-Double-Button-1> {\n\
	#puts \"Control-Double-Button-1: %x,%y\"\n\
        upvar #0 tkxox xox\n\
	grid_note %x %y $xox(flam)\n\
}\n\
bind $grid <Double-Button-3> {\n\
	#puts \"Shift-Double-Button-1: %x,%y\"\n\
        upvar #0 tkxox xox\n\
	grid_note %x %y $xox(zero_velocity)\n\
}\n\
# ------------------------------------------------------\n\
# Create Accent/Enter button set\n\
# ------------------------------------------------------\n\
label $accenter.lt -height 1 -text ENTER -font *-${boldfont12}-*\n\
frame $accenter.cart\n\
label $accenter.cart.lamp -bitmap nix -width 0.4c -height 0.15c	\\\n\
	-relief groove -borderwidth 2 -bg $tkxox(lamp_off)\n\
label $accenter.cart.labl -text CARTRIDGE -font *-${boldfont12}-* \\\n\
	-fg $tkxox(color_fg_shift) -bg $tkxox(color_bg_shift)\n\
pack $accenter.cart.lamp $accenter.cart.labl -side left\n\
button $accenter.b -bitmap nix -width 1.45c -height 2.1c	\\\n\
	-bg $tkxox(but_grey) -activebackground $tkxox(but_grey_active)\n\
set accent_label $accenter.lb\n\
label $accent_label -height 1 -text ACCENT -font *-${boldfont12}-*\n\
$accenter create window 1.43c 0.35c -window $accenter.lt\n\
$accenter create window 1.43c 0.8c -window $accenter.cart\n\
$accenter create window 1.43c 2.3c -window $accenter.b\n\
$accenter create window 1.43c 3.8c -window $accent_label -tags accent\n\
bind $accenter.b <1> {ac_accenter 0}		;# Add pattern into track\n\
bind $accenter.b <Shift-1> {ac_accenter 1}	;# Insert pattern into track\n\
bind $accenter.b <Control-1> {ac_cartridge}\n\
# ------------------------------------------------------\n\
# Create the Tempo Dial\n\
# ------------------------------------------------------\n\
set dial_canvas $dial.c\n\
set dial_value  $dial.v\n\
\n\
label $dial_value -text \"TEMPO $mode(tempo)\" -anchor n -font *-${boldr14}-* ;\n\
pack $dial_value -expand true -fill x\n\
canvas $dial_canvas -width 4c -height 3.2c ;#-relief groove -borderwidth 2\n\
pack $dial_canvas -side left\n\
set dial_radius 1.; # in centimeter\n\
$dial_canvas create oval 1c 0.2c 3c 2.2c -width 2p -tags dial	\\\n\
	-fill $tkxox(but_grey)\n\
$dial_canvas create line 0c 0c 0c 0c -tags indicator\n\
$dial_canvas create text 0.4c 2.9c -text SLOW -anchor w	\\\n\
	-font *-${helvetica_bold_r_12}-*\n\
$dial_canvas create text 3.7c 2.9c -text FAST -anchor e	\\\n\
	-font *-${helvetica_bold_r_12}-*\n\
$dial_canvas bind dial <Button-1> {\n\
	upvar #0 mode mo\n\
\n\
	# Angular-oriented dial:\n\
	# Note: It would be better to get the center of the\n\
	# dial as origin, instead of the picked point into the dial\n\
	set orig_x %x\n\
	set orig_y %x\n\
	set orig_tempo $mo(tempo)\n\
}\n\
$dial_canvas bind dial <B1-Motion> {\n\
	dial_adjust [expr %x - $orig_x] [expr %y - $orig_y] $orig_tempo\n\
}\n\
# the tempo range is 30-330 on my tk727 (saramito@imag.fr)\n\
# I don't known for the tk707\n\
set tempo_min  30; # points to SLOW\n\
set tempo_max 265; # points to FAST\n\
set tempo_ini 120; # at initialization\n\
\n\
proc dial_adjust {x y orig_tempo} {\n\
	global dial_value\n\
	global dial_canvas\n\
	global dial_radius\n\
	global tempo_min; # the arrow points to SLOW\n\
	global tempo_max; # the arrow points to FAST\n\
	upvar #0 mode mo\n\
\n\
	set pi          3.14159265358979323846;\n\
	set pi_o4       [expr 0.25*$pi];\n\
	set pi_3o4      [expr 3*$pi_o4];\n\
\n\
	# vertical indicator -> medium tempo\n\
	set delta_tempo  [expr 0.5*($tempo_max - $tempo_min)];\n\
	set tempo_med    [expr 0.5*($tempo_max + $tempo_min)];\n\
\n\
	if {($x == 0) && ($y == 0)} {\n\
\n\
	    # special case: when x = y = 0\n\
	    # i.e. when mouse comes back to origin where we pick the dial\n\
	    #  or also at the initialization call procedure\n\
	    # => angle is not computable with (x,y)	\n\
	    # but by using $orig_tempo :\n\
	    set tempo_val $orig_tempo\n\
	    if {$tempo_val > $tempo_med} {\n\
		# alpha is in the range ( pi/4, pi (\n\
		# ksi                   (  0 ,  1  (\n\
	        set ksi    [expr  ($tempo_max-$tempo_val)/$delta_tempo]\n\
	        set alpha  [expr  $pi/4 + $ksi*(3*$pi/4)]\n\
	    } else {\n\
		# alpha is in the range ) -pi, -pi/4 )\n\
		# ksi                   )  0 ,  1    )\n\
	        set ksi    [expr  ($tempo_val-$tempo_min)/$delta_tempo]\n\
	        set alpha  [expr  - $pi/4 - $ksi*(3*$pi/4)]\n\
	    }\n\
	} else {\n\
	    #  the general case\n\
	    set alpha [expr atan2($x,$y)];\n\
            if {$alpha > 0} {\n\
\n\
	        # the mouse is on the right side of the origin -> fast\n\
	        if {$alpha < $pi_o4} {\n\
		    # set to the minimal value\n\
		    set tempo_val $tempo_max\n\
		    set alpha $pi_o4\n\
	        } else {\n\
	  	    # alpha is in the range ( pi/4, pi (\n\
		    # zeta                  ( 0     1  (\n\
	            set zeta  [expr ($alpha-$pi_o4)/$pi_3o4]\n\
		    set tempo_val [expr $tempo_max - $zeta*$delta_tempo]\n\
	        }\n\
	    } else {\n\
	        # alpha < 0\n\
\n\
	        # mouse is on the right side of the origin -> fast\n\
	        if {$alpha > [expr -$pi_o4]} {\n\
		    # set tempo the minimal value\n\
		    set tempo_val $tempo_min\n\
		    set alpha -$pi_o4\n\
	        } else {\n\
	  	    # alpha is in the range ) -pi, -pi/4 )\n\
		    # zeta                  ) 0     1    )\n\
		    set zeta  [expr ($alpha+$pi)/$pi_3o4]\n\
		    set tempo_val [expr $tempo_med - $zeta*$delta_tempo ]\n\
	        }\n\
	    }\n\
	}\n\
        # make an integer\n\
	set tempo_val [expr int($tempo_val)]\n\
\n\
	# then we apply this :\n\
	set mo(tempo) $tempo_val\n\
	tk7_set_tempo $tempo_val\n\
	${dial_value} configure -text \"TEMPO $tempo_val\"\n\
\n\
	# update the dial indicator\n\
	set sin_alpha [expr sin($alpha)]\n\
	set cos_alpha [expr cos($alpha)]\n\
	set x_indic [expr 2.0 + $dial_radius * $sin_alpha]\n\
	set y_indic [expr 1.2 + $dial_radius * $cos_alpha]\n\
	${dial_canvas} coords indicator ${x_indic}c ${y_indic}c 2c 1.2c\n\
}\n\
# Angular-oriented dial: set initial tempo and vertical direction\n\
dial_adjust 0 0 $tempo_ini\n\
\n\
midichan_set [expr $midi_channel + 1]\n\
ac_patternmode $tkxox(READ)\n\
ac_trackmode $tkxox(READ)\n\
ac_track 0\n\
# ======================================================\n\
# Action!\n\
# ======================================================\n\
wm deiconify .;\n\
# after 10 play_loop;\n\
play_loop;\n\
\n\
\n\
";
